/* math-function.c generated by valac 0.40.6, the Vala compiler
 * generated from math-function.vala, do not modify */

/*
 * Copyright (C) 2013 Garima Joshi
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_MATH_FUNCTION (math_function_get_type ())
#define MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_FUNCTION, MathFunction))
#define MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_FUNCTION, MathFunctionClass))
#define IS_MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_FUNCTION))
#define IS_MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_FUNCTION))
#define MATH_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_FUNCTION, MathFunctionClass))

typedef struct _MathFunction MathFunction;
typedef struct _MathFunctionClass MathFunctionClass;
typedef struct _MathFunctionPrivate MathFunctionPrivate;

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;

#define TYPE_PARSER (parser_get_type ())
#define PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PARSER, Parser))
#define PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PARSER, ParserClass))
#define IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PARSER))
#define IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PARSER))
#define PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PARSER, ParserClass))

typedef struct _Parser Parser;
typedef struct _ParserClass ParserClass;
enum  {
	MATH_FUNCTION_0_PROPERTY,
	MATH_FUNCTION_NAME_PROPERTY,
	MATH_FUNCTION_ARGUMENTS_PROPERTY,
	MATH_FUNCTION_EXPRESSION_PROPERTY,
	MATH_FUNCTION_DESCRIPTION_PROPERTY,
	MATH_FUNCTION_NUM_PROPERTIES
};
static GParamSpec* math_function_properties[MATH_FUNCTION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_EXPRESSION_PARSER (expression_parser_get_type ())
#define EXPRESSION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPRESSION_PARSER, ExpressionParser))
#define EXPRESSION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPRESSION_PARSER, ExpressionParserClass))
#define IS_EXPRESSION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPRESSION_PARSER))
#define IS_EXPRESSION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPRESSION_PARSER))
#define EXPRESSION_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPRESSION_PARSER, ExpressionParserClass))

typedef struct _ExpressionParser ExpressionParser;
typedef struct _ExpressionParserClass ExpressionParserClass;

#define TYPE_FUNCTION_PARSER (function_parser_get_type ())
#define FUNCTION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_PARSER, FunctionParser))
#define FUNCTION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_PARSER, FunctionParserClass))
#define IS_FUNCTION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_PARSER))
#define IS_FUNCTION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_PARSER))
#define FUNCTION_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_PARSER, FunctionParserClass))

typedef struct _FunctionParser FunctionParser;
typedef struct _FunctionParserClass FunctionParserClass;

#define TYPE_ERROR_CODE (error_code_get_type ())
#define _parser_unref0(var) ((var == NULL) ? NULL : (var = (parser_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParserPrivate ParserPrivate;

#define TYPE_ANGLE_UNIT (angle_unit_get_type ())
typedef struct _ExpressionParserPrivate ExpressionParserPrivate;
typedef struct _FunctionParserPrivate FunctionParserPrivate;

#define TYPE_BUILT_IN_MATH_FUNCTION (built_in_math_function_get_type ())
#define BUILT_IN_MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILT_IN_MATH_FUNCTION, BuiltInMathFunction))
#define BUILT_IN_MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILT_IN_MATH_FUNCTION, BuiltInMathFunctionClass))
#define IS_BUILT_IN_MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILT_IN_MATH_FUNCTION))
#define IS_BUILT_IN_MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILT_IN_MATH_FUNCTION))
#define BUILT_IN_MATH_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILT_IN_MATH_FUNCTION, BuiltInMathFunctionClass))

typedef struct _BuiltInMathFunction BuiltInMathFunction;
typedef struct _BuiltInMathFunctionClass BuiltInMathFunctionClass;
typedef struct _BuiltInMathFunctionPrivate BuiltInMathFunctionPrivate;
enum  {
	BUILT_IN_MATH_FUNCTION_0_PROPERTY,
	BUILT_IN_MATH_FUNCTION_NUM_PROPERTIES
};
static GParamSpec* built_in_math_function_properties[BUILT_IN_MATH_FUNCTION_NUM_PROPERTIES];

struct _MathFunction {
	GObject parent_instance;
	MathFunctionPrivate * priv;
};

struct _MathFunctionClass {
	GObjectClass parent_class;
	Number* (*evaluate) (MathFunction* self, Number** args, int args_length1, Parser* root_parser);
	gboolean (*is_custom_function) (MathFunction* self);
};

struct _MathFunctionPrivate {
	gchar* _name;
	gchar** _arguments;
	gint _arguments_length1;
	gint __arguments_size_;
	gchar* _expression;
	gchar* _description;
};

typedef enum  {
	ERROR_CODE_NONE,
	ERROR_CODE_INVALID,
	ERROR_CODE_OVERFLOW,
	ERROR_CODE_UNKNOWN_VARIABLE,
	ERROR_CODE_UNKNOWN_FUNCTION,
	ERROR_CODE_UNKNOWN_CONVERSION,
	ERROR_CODE_MP
} ErrorCode;

typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

struct _Parser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ParserPrivate * priv;
	gint number_base;
	gint wordlen;
	AngleUnit angle_units;
};

struct _ParserClass {
	GTypeClass parent_class;
	void (*finalize) (Parser *self);
	gboolean (*variable_is_defined) (Parser* self, const gchar* name);
	Number* (*get_variable) (Parser* self, const gchar* name);
	void (*set_variable) (Parser* self, const gchar* name, Number* x);
	gboolean (*function_is_defined) (Parser* self, const gchar* name);
	gboolean (*unit_is_defined) (Parser* self, const gchar* name);
	Number* (*convert) (Parser* self, Number* x, const gchar* x_units, const gchar* z_units);
};

struct _ExpressionParser {
	Parser parent_instance;
	ExpressionParserPrivate * priv;
};

struct _ExpressionParserClass {
	ParserClass parent_class;
};

struct _ExpressionParserPrivate {
	Parser* _root_parser;
};

struct _FunctionParser {
	ExpressionParser parent_instance;
	FunctionParserPrivate * priv;
};

struct _FunctionParserClass {
	ExpressionParserClass parent_class;
};

struct _FunctionParserPrivate {
	Number** _parameters;
	gint _parameters_length1;
	gint __parameters_size_;
	MathFunction* _function;
};

struct _BuiltInMathFunction {
	MathFunction parent_instance;
	BuiltInMathFunctionPrivate * priv;
};

struct _BuiltInMathFunctionClass {
	MathFunctionClass parent_class;
};


static gpointer math_function_parent_class = NULL;
static gpointer expression_parser_parent_class = NULL;
static gpointer function_parser_parent_class = NULL;
static gpointer built_in_math_function_parent_class = NULL;

GType math_function_get_type (void) G_GNUC_CONST;
GType number_get_type (void) G_GNUC_CONST;
gpointer parser_ref (gpointer instance);
void parser_unref (gpointer instance);
GParamSpec* param_spec_parser (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_parser (GValue* value,
                       gpointer v_object);
void value_take_parser (GValue* value,
                        gpointer v_object);
gpointer value_get_parser (const GValue* value);
GType parser_get_type (void) G_GNUC_CONST;
#define MATH_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_FUNCTION, MathFunctionPrivate))
MathFunction* math_function_new (const gchar* function_name,
                                 gchar** arguments,
                                 int arguments_length1,
                                 const gchar* expression,
                                 const gchar* description);
MathFunction* math_function_construct (GType object_type,
                                       const gchar* function_name,
                                       gchar** arguments,
                                       int arguments_length1,
                                       const gchar* expression,
                                       const gchar* description);
static gchar** _vala_array_dup5 (gchar** self,
                          int length);
Number* math_function_evaluate (MathFunction* self,
                                Number** args,
                                int args_length1,
                                Parser* root_parser);
static Number* math_function_real_evaluate (MathFunction* self,
                                     Number** args,
                                     int args_length1,
                                     Parser* root_parser);
GType expression_parser_get_type (void) G_GNUC_CONST;
GType function_parser_get_type (void) G_GNUC_CONST;
FunctionParser* function_parser_new (MathFunction* function,
                                     Parser* root_parser,
                                     Number** parameters,
                                     int parameters_length1);
FunctionParser* function_parser_construct (GType object_type,
                                           MathFunction* function,
                                           Parser* root_parser,
                                           Number** parameters,
                                           int parameters_length1);
GType error_code_get_type (void) G_GNUC_CONST;
Number* parser_parse (Parser* self,
                      guint* representation_base,
                      ErrorCode* error_code,
                      gchar* * error_token,
                      guint* error_start,
                      guint* error_end);
void parser_set_error (Parser* self,
                       ErrorCode errorno,
                       const gchar* token,
                       guint token_start,
                       guint token_end);
gboolean math_function_validate (MathFunction* self,
                                 Parser* root_parser);
static gboolean math_function_is_name_valid (MathFunction* self,
                                      const gchar* x);
const gchar* math_function_get_name (MathFunction* self);
gchar** math_function_get_arguments (MathFunction* self,
                                     int* result_length1);
gboolean parser_create_parse_tree (Parser* self,
                                   guint* representation_base,
                                   ErrorCode* error_code,
                                   gchar* * error_token,
                                   guint* error_start,
                                   guint* error_end);
gboolean math_function_is_custom_function (MathFunction* self);
static gboolean math_function_real_is_custom_function (MathFunction* self);
const gchar* math_function_get_expression (MathFunction* self);
const gchar* math_function_get_description (MathFunction* self);
static void math_function_finalize (GObject * obj);
static void _vala_math_function_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
GType angle_unit_get_type (void) G_GNUC_CONST;
#define EXPRESSION_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EXPRESSION_PARSER, ExpressionParserPrivate))
ExpressionParser* expression_parser_new (const gchar* expression,
                                         Parser* root_parser);
ExpressionParser* expression_parser_construct (GType object_type,
                                               const gchar* expression,
                                               Parser* root_parser);
Parser* parser_new (const gchar* input,
                    gint number_base,
                    gint wordlen,
                    AngleUnit angle_units);
Parser* parser_construct (GType object_type,
                          const gchar* input,
                          gint number_base,
                          gint wordlen,
                          AngleUnit angle_units);
static gboolean expression_parser_real_variable_is_defined (Parser* base,
                                                     const gchar* name);
gboolean parser_variable_is_defined (Parser* self,
                                     const gchar* name);
static Number* expression_parser_real_get_variable (Parser* base,
                                             const gchar* name);
Number* parser_get_variable (Parser* self,
                             const gchar* name);
static gboolean expression_parser_real_function_is_defined (Parser* base,
                                                     const gchar* name);
gboolean parser_function_is_defined (Parser* self,
                                     const gchar* name);
static void expression_parser_finalize (Parser * obj);
#define FUNCTION_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_FUNCTION_PARSER, FunctionParserPrivate))
static Number** _vala_array_dup6 (Number** self,
                           int length);
static gboolean function_parser_real_variable_is_defined (Parser* base,
                                                   const gchar* name);
static gchar** _vala_array_dup7 (gchar** self,
                          int length);
static Number* function_parser_real_get_variable (Parser* base,
                                           const gchar* name);
static gchar** _vala_array_dup8 (gchar** self,
                          int length);
static void function_parser_finalize (Parser * obj);
GType built_in_math_function_get_type (void) G_GNUC_CONST;
BuiltInMathFunction* built_in_math_function_new (const gchar* function_name,
                                                 const gchar* description);
BuiltInMathFunction* built_in_math_function_construct (GType object_type,
                                                       const gchar* function_name,
                                                       const gchar* description);
static Number* built_in_math_function_real_evaluate (MathFunction* base,
                                              Number** args,
                                              int args_length1,
                                              Parser* root_parser);
Number* evaluate_built_in_function (const gchar* name,
                                    Number** args,
                                    int args_length1,
                                    Parser* root_parser);
static gboolean built_in_math_function_real_is_custom_function (MathFunction* base);
Number* number_logarithm (Number* self,
                          gint64 n);
gint64 number_to_integer (Number* self);
Number* number_ln (Number* self);
Number* number_sqrt (Number* self);
Number* number_abs (Number* self);
Number* number_sgn (Number* self);
Number* number_arg (Number* self,
                    AngleUnit unit);
Number* number_conjugate (Number* self);
Number* number_integer_component (Number* self);
Number* number_fractional_component (Number* self);
Number* number_floor (Number* self);
Number* number_ceiling (Number* self);
Number* number_round (Number* self);
Number* number_real_component (Number* self);
Number* number_imaginary_component (Number* self);
Number* number_sin (Number* self,
                    AngleUnit unit);
Number* number_cos (Number* self,
                    AngleUnit unit);
Number* number_tan (Number* self,
                    AngleUnit unit);
Number* number_asin (Number* self,
                     AngleUnit unit);
Number* number_acos (Number* self,
                     AngleUnit unit);
Number* number_atan (Number* self,
                     AngleUnit unit);
Number* number_sinh (Number* self);
Number* number_cosh (Number* self);
Number* number_tanh (Number* self);
Number* number_asinh (Number* self);
Number* number_acosh (Number* self);
Number* number_atanh (Number* self);
Number* number_ones_complement (Number* self,
                                gint wordlen);
Number* number_twos_complement (Number* self,
                                gint wordlen);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static gchar**
_vala_array_dup5 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


MathFunction*
math_function_construct (GType object_type,
                         const gchar* function_name,
                         gchar** arguments,
                         int arguments_length1,
                         const gchar* expression,
                         const gchar* description)
{
	MathFunction * self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (function_name != NULL, NULL);
	self = (MathFunction*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (function_name);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
	_tmp1_ = (arguments != NULL) ? _vala_array_dup5 (arguments, arguments_length1) : ((gpointer) arguments);
	_tmp1__length1 = arguments_length1;
	self->priv->_arguments = (_vala_array_free (self->priv->_arguments, self->priv->_arguments_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_arguments = _tmp1_;
	self->priv->_arguments_length1 = _tmp1__length1;
	self->priv->__arguments_size_ = self->priv->_arguments_length1;
	if (expression != NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (expression);
		_g_free0 (self->priv->_expression);
		self->priv->_expression = _tmp2_;
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		_g_free0 (self->priv->_expression);
		self->priv->_expression = _tmp3_;
	}
	if (description != NULL) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (description);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp5_;
	}
	return self;
}


MathFunction*
math_function_new (const gchar* function_name,
                   gchar** arguments,
                   int arguments_length1,
                   const gchar* expression,
                   const gchar* description)
{
	return math_function_construct (TYPE_MATH_FUNCTION, function_name, arguments, arguments_length1, expression, description);
}


static Number*
math_function_real_evaluate (MathFunction* self,
                             Number** args,
                             int args_length1,
                             Parser* root_parser)
{
	Number* result = NULL;
	FunctionParser* parser = NULL;
	FunctionParser* _tmp0_;
	guint representation_base = 0U;
	ErrorCode error_code = 0;
	gchar* error_token = NULL;
	guint error_start = 0U;
	guint error_end = 0U;
	Number* ans = NULL;
	FunctionParser* _tmp1_;
	guint _tmp2_ = 0U;
	ErrorCode _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	Number* _tmp7_;
	ErrorCode _tmp8_;
	ErrorCode _tmp9_;
	const gchar* _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	_tmp0_ = function_parser_new (self, root_parser, args, args_length1);
	parser = _tmp0_;
	_tmp1_ = parser;
	_tmp7_ = parser_parse ((Parser*) _tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	representation_base = _tmp2_;
	error_code = _tmp3_;
	_g_free0 (error_token);
	error_token = _tmp4_;
	error_start = _tmp5_;
	error_end = _tmp6_;
	ans = _tmp7_;
	_tmp8_ = error_code;
	if (_tmp8_ == ERROR_CODE_NONE) {
		result = ans;
		_g_free0 (error_token);
		_parser_unref0 (parser);
		return result;
	}
	_tmp9_ = error_code;
	_tmp10_ = error_token;
	_tmp11_ = error_start;
	_tmp12_ = error_end;
	parser_set_error (root_parser, _tmp9_, _tmp10_, _tmp11_, _tmp12_);
	result = NULL;
	_g_object_unref0 (ans);
	_g_free0 (error_token);
	_parser_unref0 (parser);
	return result;
}


Number*
math_function_evaluate (MathFunction* self,
                        Number** args,
                        int args_length1,
                        Parser* root_parser)
{
	g_return_val_if_fail (self != NULL, NULL);
	return MATH_FUNCTION_GET_CLASS (self)->evaluate (self, args, args_length1, root_parser);
}


gboolean
math_function_validate (MathFunction* self,
                        Parser* root_parser)
{
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	Number** args = NULL;
	Number** _tmp6_;
	gint args_length1;
	gint _args_size_;
	FunctionParser* parser = NULL;
	Number** _tmp7_;
	gint _tmp7__length1;
	FunctionParser* _tmp8_;
	guint representation_base = 0U;
	ErrorCode error_code = 0;
	gchar* error_token = NULL;
	guint error_start = 0U;
	guint error_end = 0U;
	FunctionParser* _tmp9_;
	guint _tmp10_ = 0U;
	ErrorCode _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	guint _tmp14_ = 0U;
	ErrorCode _tmp15_;
	ErrorCode _tmp16_;
	const gchar* _tmp17_;
	guint _tmp18_;
	guint _tmp19_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = math_function_get_name (self);
	_tmp1_ = _tmp0_;
	if (!math_function_is_name_valid (self, _tmp1_)) {
		parser_set_error (root_parser, ERROR_CODE_INVALID, NULL, (guint) 0, (guint) 0);
		result = FALSE;
		return result;
	}
	_tmp2_ = math_function_get_arguments (self, &_tmp2__length1);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	{
		gchar** argument_collection = NULL;
		gint argument_collection_length1 = 0;
		gint _argument_collection_size_ = 0;
		gint argument_it = 0;
		argument_collection = _tmp3_;
		argument_collection_length1 = _tmp3__length1;
		for (argument_it = 0; argument_it < _tmp3__length1; argument_it = argument_it + 1) {
			gchar* _tmp4_;
			gchar* argument = NULL;
			_tmp4_ = g_strdup (argument_collection[argument_it]);
			argument = _tmp4_;
			{
				const gchar* _tmp5_;
				_tmp5_ = argument;
				if (!math_function_is_name_valid (self, _tmp5_)) {
					parser_set_error (root_parser, ERROR_CODE_INVALID, NULL, (guint) 0, (guint) 0);
					result = FALSE;
					_g_free0 (argument);
					return result;
				}
				_g_free0 (argument);
			}
		}
	}
	_tmp6_ = g_new0 (Number*, 0 + 1);
	args = _tmp6_;
	args_length1 = 0;
	_args_size_ = args_length1;
	_tmp7_ = args;
	_tmp7__length1 = args_length1;
	_tmp8_ = function_parser_new (self, root_parser, _tmp7_, _tmp7__length1);
	parser = _tmp8_;
	_tmp9_ = parser;
	parser_create_parse_tree ((Parser*) _tmp9_, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_);
	representation_base = _tmp10_;
	error_code = _tmp11_;
	_g_free0 (error_token);
	error_token = _tmp12_;
	error_start = _tmp13_;
	error_end = _tmp14_;
	_tmp15_ = error_code;
	if (_tmp15_ == ERROR_CODE_NONE) {
		result = TRUE;
		_g_free0 (error_token);
		_parser_unref0 (parser);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
		return result;
	}
	_tmp16_ = error_code;
	_tmp17_ = error_token;
	_tmp18_ = error_start;
	_tmp19_ = error_end;
	parser_set_error (root_parser, _tmp16_, _tmp17_, _tmp18_, _tmp19_);
	result = FALSE;
	_g_free0 (error_token);
	_parser_unref0 (parser);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
	return result;
}


static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}


static gboolean
math_function_is_name_valid (MathFunction* self,
                             const gchar* x)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (x != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				gunichar current_char = 0U;
				gint _tmp5_;
				gunichar _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = strlen (x);
				_tmp4_ = _tmp3_;
				if (!(_tmp2_ < _tmp4_)) {
					break;
				}
				_tmp5_ = i;
				current_char = string_get_char (x, (glong) _tmp5_);
				_tmp6_ = current_char;
				if (!g_unichar_isalpha (_tmp6_)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean
math_function_real_is_custom_function (MathFunction* self)
{
	gboolean result = FALSE;
	result = TRUE;
	return result;
}


gboolean
math_function_is_custom_function (MathFunction* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return MATH_FUNCTION_GET_CLASS (self)->is_custom_function (self);
}


const gchar*
math_function_get_name (MathFunction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


gchar**
math_function_get_arguments (MathFunction* self,
                             int* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_arguments;
	_tmp0__length1 = self->priv->_arguments_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


const gchar*
math_function_get_expression (MathFunction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_expression;
	result = _tmp0_;
	return result;
}


const gchar*
math_function_get_description (MathFunction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


static void
math_function_class_init (MathFunctionClass * klass)
{
	math_function_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathFunctionPrivate));
	((MathFunctionClass *) klass)->evaluate = (Number* (*) (MathFunction *, Number**, int, Parser*)) math_function_real_evaluate;
	((MathFunctionClass *) klass)->is_custom_function = (gboolean (*) (MathFunction *)) math_function_real_is_custom_function;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_function_get_property;
	G_OBJECT_CLASS (klass)->finalize = math_function_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_NAME_PROPERTY, math_function_properties[MATH_FUNCTION_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_ARGUMENTS_PROPERTY, math_function_properties[MATH_FUNCTION_ARGUMENTS_PROPERTY] = g_param_spec_boxed ("arguments", "arguments", "arguments", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_EXPRESSION_PROPERTY, math_function_properties[MATH_FUNCTION_EXPRESSION_PROPERTY] = g_param_spec_string ("expression", "expression", "expression", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_DESCRIPTION_PROPERTY, math_function_properties[MATH_FUNCTION_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}


static void
math_function_instance_init (MathFunction * self)
{
	self->priv = MATH_FUNCTION_GET_PRIVATE (self);
}


static void
math_function_finalize (GObject * obj)
{
	MathFunction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_FUNCTION, MathFunction);
	_g_free0 (self->priv->_name);
	self->priv->_arguments = (_vala_array_free (self->priv->_arguments, self->priv->_arguments_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_expression);
	_g_free0 (self->priv->_description);
	G_OBJECT_CLASS (math_function_parent_class)->finalize (obj);
}


GType
math_function_get_type (void)
{
	static volatile gsize math_function_type_id__volatile = 0;
	if (g_once_init_enter (&math_function_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathFunction), 0, (GInstanceInitFunc) math_function_instance_init, NULL };
		GType math_function_type_id;
		math_function_type_id = g_type_register_static (G_TYPE_OBJECT, "MathFunction", &g_define_type_info, 0);
		g_once_init_leave (&math_function_type_id__volatile, math_function_type_id);
	}
	return math_function_type_id__volatile;
}


static void
_vala_math_function_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	MathFunction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_FUNCTION, MathFunction);
	switch (property_id) {
		case MATH_FUNCTION_NAME_PROPERTY:
		g_value_set_string (value, math_function_get_name (self));
		break;
		case MATH_FUNCTION_ARGUMENTS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, math_function_get_arguments (self, &length));
		}
		break;
		case MATH_FUNCTION_EXPRESSION_PROPERTY:
		g_value_set_string (value, math_function_get_expression (self));
		break;
		case MATH_FUNCTION_DESCRIPTION_PROPERTY:
		g_value_set_string (value, math_function_get_description (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gpointer
_parser_ref0 (gpointer self)
{
	return self ? parser_ref (self) : NULL;
}


ExpressionParser*
expression_parser_construct (GType object_type,
                             const gchar* expression,
                             Parser* root_parser)
{
	ExpressionParser* self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	AngleUnit _tmp2_;
	Parser* _tmp3_;
	g_return_val_if_fail (expression != NULL, NULL);
	_tmp0_ = root_parser->number_base;
	_tmp1_ = root_parser->wordlen;
	_tmp2_ = root_parser->angle_units;
	self = (ExpressionParser*) parser_construct (object_type, expression, _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = _parser_ref0 (root_parser);
	_parser_unref0 (self->priv->_root_parser);
	self->priv->_root_parser = _tmp3_;
	return self;
}


ExpressionParser*
expression_parser_new (const gchar* expression,
                       Parser* root_parser)
{
	return expression_parser_construct (TYPE_EXPRESSION_PARSER, expression, root_parser);
}


static gboolean
expression_parser_real_variable_is_defined (Parser* base,
                                            const gchar* name)
{
	ExpressionParser * self;
	gboolean result = FALSE;
	Parser* _tmp0_;
	self = (ExpressionParser*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	if (PARSER_CLASS (expression_parser_parent_class)->variable_is_defined (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PARSER, Parser), name)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = self->priv->_root_parser;
	result = parser_variable_is_defined (_tmp0_, name);
	return result;
}


static Number*
expression_parser_real_get_variable (Parser* base,
                                     const gchar* name)
{
	ExpressionParser * self;
	Number* result = NULL;
	Number* value = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Parser* _tmp2_;
	Number* _tmp3_;
	self = (ExpressionParser*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = PARSER_CLASS (expression_parser_parent_class)->get_variable (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PARSER, Parser), name);
	value = _tmp0_;
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		result = value;
		return result;
	}
	_tmp2_ = self->priv->_root_parser;
	_tmp3_ = parser_get_variable (_tmp2_, name);
	result = _tmp3_;
	_g_object_unref0 (value);
	return result;
}


static gboolean
expression_parser_real_function_is_defined (Parser* base,
                                            const gchar* name)
{
	ExpressionParser * self;
	gboolean result = FALSE;
	Parser* _tmp0_;
	self = (ExpressionParser*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	if (PARSER_CLASS (expression_parser_parent_class)->function_is_defined (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PARSER, Parser), name)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = self->priv->_root_parser;
	result = parser_function_is_defined (_tmp0_, name);
	return result;
}


static void
expression_parser_class_init (ExpressionParserClass * klass)
{
	expression_parser_parent_class = g_type_class_peek_parent (klass);
	((ParserClass *) klass)->finalize = expression_parser_finalize;
	g_type_class_add_private (klass, sizeof (ExpressionParserPrivate));
	((ParserClass *) klass)->variable_is_defined = (gboolean (*) (Parser *, const gchar*)) expression_parser_real_variable_is_defined;
	((ParserClass *) klass)->get_variable = (Number* (*) (Parser *, const gchar*)) expression_parser_real_get_variable;
	((ParserClass *) klass)->function_is_defined = (gboolean (*) (Parser *, const gchar*)) expression_parser_real_function_is_defined;
}


static void
expression_parser_instance_init (ExpressionParser * self)
{
	self->priv = EXPRESSION_PARSER_GET_PRIVATE (self);
}


static void
expression_parser_finalize (Parser * obj)
{
	ExpressionParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPRESSION_PARSER, ExpressionParser);
	_parser_unref0 (self->priv->_root_parser);
	PARSER_CLASS (expression_parser_parent_class)->finalize (obj);
}


GType
expression_parser_get_type (void)
{
	static volatile gsize expression_parser_type_id__volatile = 0;
	if (g_once_init_enter (&expression_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ExpressionParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) expression_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExpressionParser), 0, (GInstanceInitFunc) expression_parser_instance_init, NULL };
		GType expression_parser_type_id;
		expression_parser_type_id = g_type_register_static (TYPE_PARSER, "ExpressionParser", &g_define_type_info, 0);
		g_once_init_leave (&expression_parser_type_id__volatile, expression_parser_type_id);
	}
	return expression_parser_type_id__volatile;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static Number**
_vala_array_dup6 (Number** self,
                  int length)
{
	Number** result;
	int i;
	result = g_new0 (Number*, length + 1);
	for (i = 0; i < length; i++) {
		Number* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


FunctionParser*
function_parser_construct (GType object_type,
                           MathFunction* function,
                           Parser* root_parser,
                           Number** parameters,
                           int parameters_length1)
{
	FunctionParser* self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	MathFunction* _tmp2_;
	Number** _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (function != NULL, NULL);
	_tmp0_ = math_function_get_expression (function);
	_tmp1_ = _tmp0_;
	self = (FunctionParser*) expression_parser_construct (object_type, _tmp1_, root_parser);
	_tmp2_ = _g_object_ref0 (function);
	_g_object_unref0 (self->priv->_function);
	self->priv->_function = _tmp2_;
	_tmp3_ = (parameters != NULL) ? _vala_array_dup6 (parameters, parameters_length1) : ((gpointer) parameters);
	_tmp3__length1 = parameters_length1;
	self->priv->_parameters = (_vala_array_free (self->priv->_parameters, self->priv->_parameters_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_parameters = _tmp3_;
	self->priv->_parameters_length1 = _tmp3__length1;
	self->priv->__parameters_size_ = self->priv->_parameters_length1;
	return self;
}


FunctionParser*
function_parser_new (MathFunction* function,
                     Parser* root_parser,
                     Number** parameters,
                     int parameters_length1)
{
	return function_parser_construct (TYPE_FUNCTION_PARSER, function, root_parser, parameters, parameters_length1);
}


static gchar**
_vala_array_dup7 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gboolean
function_parser_real_variable_is_defined (Parser* base,
                                          const gchar* name)
{
	FunctionParser * self;
	gboolean result = FALSE;
	gchar** argument_names = NULL;
	MathFunction* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint argument_names_length1;
	gint _argument_names_size_;
	self = (FunctionParser*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->_function;
	_tmp1_ = math_function_get_arguments (_tmp0_, &_tmp1__length1);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup7 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	argument_names = _tmp3_;
	argument_names_length1 = _tmp3__length1;
	_argument_names_size_ = argument_names_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				gchar** _tmp7_;
				gint _tmp7__length1;
				gchar** _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				const gchar* _tmp10_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = argument_names;
				_tmp7__length1 = argument_names_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = argument_names;
				_tmp8__length1 = argument_names_length1;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				if (g_strcmp0 (_tmp10_, name) == 0) {
					result = TRUE;
					argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	result = PARSER_CLASS (function_parser_parent_class)->variable_is_defined ((Parser*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EXPRESSION_PARSER, ExpressionParser), name);
	argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar**
_vala_array_dup8 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static Number*
function_parser_real_get_variable (Parser* base,
                                   const gchar* name)
{
	FunctionParser * self;
	Number* result = NULL;
	gchar** argument_names = NULL;
	MathFunction* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint argument_names_length1;
	gint _argument_names_size_;
	Number* _tmp17_;
	self = (FunctionParser*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->_function;
	_tmp1_ = math_function_get_arguments (_tmp0_, &_tmp1__length1);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup8 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	argument_names = _tmp3_;
	argument_names_length1 = _tmp3__length1;
	_argument_names_size_ = argument_names_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				gchar** _tmp7_;
				gint _tmp7__length1;
				gchar** _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				const gchar* _tmp10_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = argument_names;
				_tmp7__length1 = argument_names_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = argument_names;
				_tmp8__length1 = argument_names_length1;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				if (g_strcmp0 (_tmp10_, name) == 0) {
					Number** _tmp11_;
					gint _tmp11__length1;
					gint _tmp12_;
					_tmp11_ = self->priv->_parameters;
					_tmp11__length1 = self->priv->_parameters_length1;
					_tmp12_ = i;
					if (_tmp11__length1 > _tmp12_) {
						Number** _tmp13_;
						gint _tmp13__length1;
						gint _tmp14_;
						Number* _tmp15_;
						Number* _tmp16_;
						_tmp13_ = self->priv->_parameters;
						_tmp13__length1 = self->priv->_parameters_length1;
						_tmp14_ = i;
						_tmp15_ = _tmp13_[_tmp14_];
						_tmp16_ = _g_object_ref0 (_tmp15_);
						result = _tmp16_;
						argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					result = NULL;
					argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	_tmp17_ = PARSER_CLASS (function_parser_parent_class)->get_variable ((Parser*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EXPRESSION_PARSER, ExpressionParser), name);
	result = _tmp17_;
	argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void
function_parser_class_init (FunctionParserClass * klass)
{
	function_parser_parent_class = g_type_class_peek_parent (klass);
	((ParserClass *) klass)->finalize = function_parser_finalize;
	g_type_class_add_private (klass, sizeof (FunctionParserPrivate));
	((ParserClass *) klass)->variable_is_defined = (gboolean (*) (Parser *, const gchar*)) function_parser_real_variable_is_defined;
	((ParserClass *) klass)->get_variable = (Number* (*) (Parser *, const gchar*)) function_parser_real_get_variable;
}


static void
function_parser_instance_init (FunctionParser * self)
{
	self->priv = FUNCTION_PARSER_GET_PRIVATE (self);
}


static void
function_parser_finalize (Parser * obj)
{
	FunctionParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FUNCTION_PARSER, FunctionParser);
	self->priv->_parameters = (_vala_array_free (self->priv->_parameters, self->priv->_parameters_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->_function);
	PARSER_CLASS (function_parser_parent_class)->finalize (obj);
}


GType
function_parser_get_type (void)
{
	static volatile gsize function_parser_type_id__volatile = 0;
	if (g_once_init_enter (&function_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FunctionParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionParser), 0, (GInstanceInitFunc) function_parser_instance_init, NULL };
		GType function_parser_type_id;
		function_parser_type_id = g_type_register_static (TYPE_EXPRESSION_PARSER, "FunctionParser", &g_define_type_info, 0);
		g_once_init_leave (&function_parser_type_id__volatile, function_parser_type_id);
	}
	return function_parser_type_id__volatile;
}


BuiltInMathFunction*
built_in_math_function_construct (GType object_type,
                                  const gchar* function_name,
                                  const gchar* description)
{
	BuiltInMathFunction * self = NULL;
	gchar** arguments = NULL;
	gchar** _tmp0_;
	gint arguments_length1;
	gint _arguments_size_;
	gchar* expression = NULL;
	gchar* _tmp1_;
	g_return_val_if_fail (function_name != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	arguments = _tmp0_;
	arguments_length1 = 0;
	_arguments_size_ = arguments_length1;
	_tmp1_ = g_strdup ("");
	expression = _tmp1_;
	self = (BuiltInMathFunction*) math_function_construct (object_type, function_name, arguments, arguments_length1, expression, description);
	_g_free0 (expression);
	arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


BuiltInMathFunction*
built_in_math_function_new (const gchar* function_name,
                            const gchar* description)
{
	return built_in_math_function_construct (TYPE_BUILT_IN_MATH_FUNCTION, function_name, description);
}


static Number*
built_in_math_function_real_evaluate (MathFunction* base,
                                      Number** args,
                                      int args_length1,
                                      Parser* root_parser)
{
	BuiltInMathFunction * self;
	Number* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	Number* _tmp2_;
	self = (BuiltInMathFunction*) base;
	_tmp0_ = math_function_get_name ((MathFunction*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = evaluate_built_in_function (_tmp1_, args, args_length1, root_parser);
	result = _tmp2_;
	return result;
}


static gboolean
built_in_math_function_real_is_custom_function (MathFunction* base)
{
	BuiltInMathFunction * self;
	gboolean result = FALSE;
	self = (BuiltInMathFunction*) base;
	result = FALSE;
	return result;
}


static void
built_in_math_function_class_init (BuiltInMathFunctionClass * klass)
{
	built_in_math_function_parent_class = g_type_class_peek_parent (klass);
	((MathFunctionClass *) klass)->evaluate = (Number* (*) (MathFunction *, Number**, int, Parser*)) built_in_math_function_real_evaluate;
	((MathFunctionClass *) klass)->is_custom_function = (gboolean (*) (MathFunction *)) built_in_math_function_real_is_custom_function;
}


static void
built_in_math_function_instance_init (BuiltInMathFunction * self)
{
}


GType
built_in_math_function_get_type (void)
{
	static volatile gsize built_in_math_function_type_id__volatile = 0;
	if (g_once_init_enter (&built_in_math_function_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuiltInMathFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) built_in_math_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuiltInMathFunction), 0, (GInstanceInitFunc) built_in_math_function_instance_init, NULL };
		GType built_in_math_function_type_id;
		built_in_math_function_type_id = g_type_register_static (TYPE_MATH_FUNCTION, "BuiltInMathFunction", &g_define_type_info, 0);
		g_once_init_leave (&built_in_math_function_type_id__volatile, built_in_math_function_type_id);
	}
	return built_in_math_function_type_id__volatile;
}


Number*
evaluate_built_in_function (const gchar* name,
                            Number** args,
                            int args_length1,
                            Parser* root_parser)
{
	Number* result = NULL;
	gchar* lower_name = NULL;
	gchar* _tmp0_;
	Number* x = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_utf8_strdown (name, (gssize) -1);
	lower_name = _tmp0_;
	_tmp1_ = args[0];
	_tmp2_ = _g_object_ref0 (_tmp1_);
	x = _tmp2_;
	_tmp3_ = lower_name;
	if (g_strcmp0 (_tmp3_, "log") == 0) {
		if (args_length1 <= 1) {
			Number* _tmp4_;
			Number* _tmp5_;
			_tmp4_ = x;
			_tmp5_ = number_logarithm (_tmp4_, (gint64) 10);
			result = _tmp5_;
			_g_object_unref0 (x);
			_g_free0 (lower_name);
			return result;
		} else {
			gint64 log_base = 0LL;
			Number* _tmp6_;
			gint64 _tmp7_;
			_tmp6_ = args[1];
			log_base = number_to_integer (_tmp6_);
			_tmp7_ = log_base;
			if (_tmp7_ < ((gint64) 0)) {
				result = NULL;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			} else {
				Number* _tmp8_;
				gint64 _tmp9_;
				Number* _tmp10_;
				_tmp8_ = x;
				_tmp9_ = log_base;
				_tmp10_ = number_logarithm (_tmp8_, _tmp9_);
				result = _tmp10_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else {
		const gchar* _tmp11_;
		_tmp11_ = lower_name;
		if (g_strcmp0 (_tmp11_, "ln") == 0) {
			Number* _tmp12_;
			Number* _tmp13_;
			_tmp12_ = x;
			_tmp13_ = number_ln (_tmp12_);
			result = _tmp13_;
			_g_object_unref0 (x);
			_g_free0 (lower_name);
			return result;
		} else {
			const gchar* _tmp14_;
			_tmp14_ = lower_name;
			if (g_strcmp0 (_tmp14_, "sqrt") == 0) {
				Number* _tmp15_;
				Number* _tmp16_;
				_tmp15_ = x;
				_tmp16_ = number_sqrt (_tmp15_);
				result = _tmp16_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			} else {
				const gchar* _tmp17_;
				_tmp17_ = lower_name;
				if (g_strcmp0 (_tmp17_, "abs") == 0) {
					Number* _tmp18_;
					Number* _tmp19_;
					_tmp18_ = x;
					_tmp19_ = number_abs (_tmp18_);
					result = _tmp19_;
					_g_object_unref0 (x);
					_g_free0 (lower_name);
					return result;
				} else {
					const gchar* _tmp20_;
					_tmp20_ = lower_name;
					if (g_strcmp0 (_tmp20_, "sgn") == 0) {
						Number* _tmp21_;
						Number* _tmp22_;
						_tmp21_ = x;
						_tmp22_ = number_sgn (_tmp21_);
						result = _tmp22_;
						_g_object_unref0 (x);
						_g_free0 (lower_name);
						return result;
					} else {
						const gchar* _tmp23_;
						_tmp23_ = lower_name;
						if (g_strcmp0 (_tmp23_, "arg") == 0) {
							Number* _tmp24_;
							AngleUnit _tmp25_;
							Number* _tmp26_;
							_tmp24_ = x;
							_tmp25_ = root_parser->angle_units;
							_tmp26_ = number_arg (_tmp24_, _tmp25_);
							result = _tmp26_;
							_g_object_unref0 (x);
							_g_free0 (lower_name);
							return result;
						} else {
							const gchar* _tmp27_;
							_tmp27_ = lower_name;
							if (g_strcmp0 (_tmp27_, "conj") == 0) {
								Number* _tmp28_;
								Number* _tmp29_;
								_tmp28_ = x;
								_tmp29_ = number_conjugate (_tmp28_);
								result = _tmp29_;
								_g_object_unref0 (x);
								_g_free0 (lower_name);
								return result;
							} else {
								const gchar* _tmp30_;
								_tmp30_ = lower_name;
								if (g_strcmp0 (_tmp30_, "int") == 0) {
									Number* _tmp31_;
									Number* _tmp32_;
									_tmp31_ = x;
									_tmp32_ = number_integer_component (_tmp31_);
									result = _tmp32_;
									_g_object_unref0 (x);
									_g_free0 (lower_name);
									return result;
								} else {
									const gchar* _tmp33_;
									_tmp33_ = lower_name;
									if (g_strcmp0 (_tmp33_, "frac") == 0) {
										Number* _tmp34_;
										Number* _tmp35_;
										_tmp34_ = x;
										_tmp35_ = number_fractional_component (_tmp34_);
										result = _tmp35_;
										_g_object_unref0 (x);
										_g_free0 (lower_name);
										return result;
									} else {
										const gchar* _tmp36_;
										_tmp36_ = lower_name;
										if (g_strcmp0 (_tmp36_, "floor") == 0) {
											Number* _tmp37_;
											Number* _tmp38_;
											_tmp37_ = x;
											_tmp38_ = number_floor (_tmp37_);
											result = _tmp38_;
											_g_object_unref0 (x);
											_g_free0 (lower_name);
											return result;
										} else {
											const gchar* _tmp39_;
											_tmp39_ = lower_name;
											if (g_strcmp0 (_tmp39_, "ceil") == 0) {
												Number* _tmp40_;
												Number* _tmp41_;
												_tmp40_ = x;
												_tmp41_ = number_ceiling (_tmp40_);
												result = _tmp41_;
												_g_object_unref0 (x);
												_g_free0 (lower_name);
												return result;
											} else {
												const gchar* _tmp42_;
												_tmp42_ = lower_name;
												if (g_strcmp0 (_tmp42_, "round") == 0) {
													Number* _tmp43_;
													Number* _tmp44_;
													_tmp43_ = x;
													_tmp44_ = number_round (_tmp43_);
													result = _tmp44_;
													_g_object_unref0 (x);
													_g_free0 (lower_name);
													return result;
												} else {
													const gchar* _tmp45_;
													_tmp45_ = lower_name;
													if (g_strcmp0 (_tmp45_, "re") == 0) {
														Number* _tmp46_;
														Number* _tmp47_;
														_tmp46_ = x;
														_tmp47_ = number_real_component (_tmp46_);
														result = _tmp47_;
														_g_object_unref0 (x);
														_g_free0 (lower_name);
														return result;
													} else {
														const gchar* _tmp48_;
														_tmp48_ = lower_name;
														if (g_strcmp0 (_tmp48_, "im") == 0) {
															Number* _tmp49_;
															Number* _tmp50_;
															_tmp49_ = x;
															_tmp50_ = number_imaginary_component (_tmp49_);
															result = _tmp50_;
															_g_object_unref0 (x);
															_g_free0 (lower_name);
															return result;
														} else {
															const gchar* _tmp51_;
															_tmp51_ = lower_name;
															if (g_strcmp0 (_tmp51_, "sin") == 0) {
																Number* _tmp52_;
																AngleUnit _tmp53_;
																Number* _tmp54_;
																_tmp52_ = x;
																_tmp53_ = root_parser->angle_units;
																_tmp54_ = number_sin (_tmp52_, _tmp53_);
																result = _tmp54_;
																_g_object_unref0 (x);
																_g_free0 (lower_name);
																return result;
															} else {
																const gchar* _tmp55_;
																_tmp55_ = lower_name;
																if (g_strcmp0 (_tmp55_, "cos") == 0) {
																	Number* _tmp56_;
																	AngleUnit _tmp57_;
																	Number* _tmp58_;
																	_tmp56_ = x;
																	_tmp57_ = root_parser->angle_units;
																	_tmp58_ = number_cos (_tmp56_, _tmp57_);
																	result = _tmp58_;
																	_g_object_unref0 (x);
																	_g_free0 (lower_name);
																	return result;
																} else {
																	const gchar* _tmp59_;
																	_tmp59_ = lower_name;
																	if (g_strcmp0 (_tmp59_, "tan") == 0) {
																		Number* _tmp60_;
																		AngleUnit _tmp61_;
																		Number* _tmp62_;
																		_tmp60_ = x;
																		_tmp61_ = root_parser->angle_units;
																		_tmp62_ = number_tan (_tmp60_, _tmp61_);
																		result = _tmp62_;
																		_g_object_unref0 (x);
																		_g_free0 (lower_name);
																		return result;
																	} else {
																		gboolean _tmp63_ = FALSE;
																		const gchar* _tmp64_;
																		_tmp64_ = lower_name;
																		if (g_strcmp0 (_tmp64_, "sin⁻¹") == 0) {
																			_tmp63_ = TRUE;
																		} else {
																			const gchar* _tmp65_;
																			_tmp65_ = lower_name;
																			_tmp63_ = g_strcmp0 (_tmp65_, "asin") == 0;
																		}
																		if (_tmp63_) {
																			Number* _tmp66_;
																			AngleUnit _tmp67_;
																			Number* _tmp68_;
																			_tmp66_ = x;
																			_tmp67_ = root_parser->angle_units;
																			_tmp68_ = number_asin (_tmp66_, _tmp67_);
																			result = _tmp68_;
																			_g_object_unref0 (x);
																			_g_free0 (lower_name);
																			return result;
																		} else {
																			gboolean _tmp69_ = FALSE;
																			const gchar* _tmp70_;
																			_tmp70_ = lower_name;
																			if (g_strcmp0 (_tmp70_, "cos⁻¹") == 0) {
																				_tmp69_ = TRUE;
																			} else {
																				const gchar* _tmp71_;
																				_tmp71_ = lower_name;
																				_tmp69_ = g_strcmp0 (_tmp71_, "acos") == 0;
																			}
																			if (_tmp69_) {
																				Number* _tmp72_;
																				AngleUnit _tmp73_;
																				Number* _tmp74_;
																				_tmp72_ = x;
																				_tmp73_ = root_parser->angle_units;
																				_tmp74_ = number_acos (_tmp72_, _tmp73_);
																				result = _tmp74_;
																				_g_object_unref0 (x);
																				_g_free0 (lower_name);
																				return result;
																			} else {
																				gboolean _tmp75_ = FALSE;
																				const gchar* _tmp76_;
																				_tmp76_ = lower_name;
																				if (g_strcmp0 (_tmp76_, "tan⁻¹") == 0) {
																					_tmp75_ = TRUE;
																				} else {
																					const gchar* _tmp77_;
																					_tmp77_ = lower_name;
																					_tmp75_ = g_strcmp0 (_tmp77_, "atan") == 0;
																				}
																				if (_tmp75_) {
																					Number* _tmp78_;
																					AngleUnit _tmp79_;
																					Number* _tmp80_;
																					_tmp78_ = x;
																					_tmp79_ = root_parser->angle_units;
																					_tmp80_ = number_atan (_tmp78_, _tmp79_);
																					result = _tmp80_;
																					_g_object_unref0 (x);
																					_g_free0 (lower_name);
																					return result;
																				} else {
																					const gchar* _tmp81_;
																					_tmp81_ = lower_name;
																					if (g_strcmp0 (_tmp81_, "sinh") == 0) {
																						Number* _tmp82_;
																						Number* _tmp83_;
																						_tmp82_ = x;
																						_tmp83_ = number_sinh (_tmp82_);
																						result = _tmp83_;
																						_g_object_unref0 (x);
																						_g_free0 (lower_name);
																						return result;
																					} else {
																						const gchar* _tmp84_;
																						_tmp84_ = lower_name;
																						if (g_strcmp0 (_tmp84_, "cosh") == 0) {
																							Number* _tmp85_;
																							Number* _tmp86_;
																							_tmp85_ = x;
																							_tmp86_ = number_cosh (_tmp85_);
																							result = _tmp86_;
																							_g_object_unref0 (x);
																							_g_free0 (lower_name);
																							return result;
																						} else {
																							const gchar* _tmp87_;
																							_tmp87_ = lower_name;
																							if (g_strcmp0 (_tmp87_, "tanh") == 0) {
																								Number* _tmp88_;
																								Number* _tmp89_;
																								_tmp88_ = x;
																								_tmp89_ = number_tanh (_tmp88_);
																								result = _tmp89_;
																								_g_object_unref0 (x);
																								_g_free0 (lower_name);
																								return result;
																							} else {
																								gboolean _tmp90_ = FALSE;
																								const gchar* _tmp91_;
																								_tmp91_ = lower_name;
																								if (g_strcmp0 (_tmp91_, "sinh⁻¹") == 0) {
																									_tmp90_ = TRUE;
																								} else {
																									const gchar* _tmp92_;
																									_tmp92_ = lower_name;
																									_tmp90_ = g_strcmp0 (_tmp92_, "asinh") == 0;
																								}
																								if (_tmp90_) {
																									Number* _tmp93_;
																									Number* _tmp94_;
																									_tmp93_ = x;
																									_tmp94_ = number_asinh (_tmp93_);
																									result = _tmp94_;
																									_g_object_unref0 (x);
																									_g_free0 (lower_name);
																									return result;
																								} else {
																									gboolean _tmp95_ = FALSE;
																									const gchar* _tmp96_;
																									_tmp96_ = lower_name;
																									if (g_strcmp0 (_tmp96_, "cosh⁻¹") == 0) {
																										_tmp95_ = TRUE;
																									} else {
																										const gchar* _tmp97_;
																										_tmp97_ = lower_name;
																										_tmp95_ = g_strcmp0 (_tmp97_, "acosh") == 0;
																									}
																									if (_tmp95_) {
																										Number* _tmp98_;
																										Number* _tmp99_;
																										_tmp98_ = x;
																										_tmp99_ = number_acosh (_tmp98_);
																										result = _tmp99_;
																										_g_object_unref0 (x);
																										_g_free0 (lower_name);
																										return result;
																									} else {
																										gboolean _tmp100_ = FALSE;
																										const gchar* _tmp101_;
																										_tmp101_ = lower_name;
																										if (g_strcmp0 (_tmp101_, "tanh⁻¹") == 0) {
																											_tmp100_ = TRUE;
																										} else {
																											const gchar* _tmp102_;
																											_tmp102_ = lower_name;
																											_tmp100_ = g_strcmp0 (_tmp102_, "atanh") == 0;
																										}
																										if (_tmp100_) {
																											Number* _tmp103_;
																											Number* _tmp104_;
																											_tmp103_ = x;
																											_tmp104_ = number_atanh (_tmp103_);
																											result = _tmp104_;
																											_g_object_unref0 (x);
																											_g_free0 (lower_name);
																											return result;
																										} else {
																											const gchar* _tmp105_;
																											_tmp105_ = lower_name;
																											if (g_strcmp0 (_tmp105_, "ones") == 0) {
																												Number* _tmp106_;
																												gint _tmp107_;
																												Number* _tmp108_;
																												_tmp106_ = x;
																												_tmp107_ = root_parser->wordlen;
																												_tmp108_ = number_ones_complement (_tmp106_, _tmp107_);
																												result = _tmp108_;
																												_g_object_unref0 (x);
																												_g_free0 (lower_name);
																												return result;
																											} else {
																												const gchar* _tmp109_;
																												_tmp109_ = lower_name;
																												if (g_strcmp0 (_tmp109_, "twos") == 0) {
																													Number* _tmp110_;
																													gint _tmp111_;
																													Number* _tmp112_;
																													_tmp110_ = x;
																													_tmp111_ = root_parser->wordlen;
																													_tmp112_ = number_twos_complement (_tmp110_, _tmp111_);
																													result = _tmp112_;
																													_g_object_unref0 (x);
																													_g_free0 (lower_name);
																													return result;
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	_g_object_unref0 (x);
	_g_free0 (lower_name);
	return result;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



