//! Syscalls for the `mips64` architecture.

// This file is automatically generated. Do not edit!

syscall_enum! {
    pub enum Sysno {
        /// See [read(2)](https://man7.org/linux/man-pages/man2/read.2.html) for more info on this syscall.
        read = 5000,
        /// See [write(2)](https://man7.org/linux/man-pages/man2/write.2.html) for more info on this syscall.
        write = 5001,
        /// See [open(2)](https://man7.org/linux/man-pages/man2/open.2.html) for more info on this syscall.
        open = 5002,
        /// See [close(2)](https://man7.org/linux/man-pages/man2/close.2.html) for more info on this syscall.
        close = 5003,
        /// See [stat(2)](https://man7.org/linux/man-pages/man2/stat.2.html) for more info on this syscall.
        stat = 5004,
        /// See [fstat(2)](https://man7.org/linux/man-pages/man2/fstat.2.html) for more info on this syscall.
        fstat = 5005,
        /// See [lstat(2)](https://man7.org/linux/man-pages/man2/lstat.2.html) for more info on this syscall.
        lstat = 5006,
        /// See [poll(2)](https://man7.org/linux/man-pages/man2/poll.2.html) for more info on this syscall.
        poll = 5007,
        /// See [lseek(2)](https://man7.org/linux/man-pages/man2/lseek.2.html) for more info on this syscall.
        lseek = 5008,
        /// See [mmap(2)](https://man7.org/linux/man-pages/man2/mmap.2.html) for more info on this syscall.
        mmap = 5009,
        /// See [mprotect(2)](https://man7.org/linux/man-pages/man2/mprotect.2.html) for more info on this syscall.
        mprotect = 5010,
        /// See [munmap(2)](https://man7.org/linux/man-pages/man2/munmap.2.html) for more info on this syscall.
        munmap = 5011,
        /// See [brk(2)](https://man7.org/linux/man-pages/man2/brk.2.html) for more info on this syscall.
        brk = 5012,
        /// See [rt_sigaction(2)](https://man7.org/linux/man-pages/man2/rt_sigaction.2.html) for more info on this syscall.
        rt_sigaction = 5013,
        /// See [rt_sigprocmask(2)](https://man7.org/linux/man-pages/man2/rt_sigprocmask.2.html) for more info on this syscall.
        rt_sigprocmask = 5014,
        /// See [ioctl(2)](https://man7.org/linux/man-pages/man2/ioctl.2.html) for more info on this syscall.
        ioctl = 5015,
        /// See [pread64(2)](https://man7.org/linux/man-pages/man2/pread64.2.html) for more info on this syscall.
        pread64 = 5016,
        /// See [pwrite64(2)](https://man7.org/linux/man-pages/man2/pwrite64.2.html) for more info on this syscall.
        pwrite64 = 5017,
        /// See [readv(2)](https://man7.org/linux/man-pages/man2/readv.2.html) for more info on this syscall.
        readv = 5018,
        /// See [writev(2)](https://man7.org/linux/man-pages/man2/writev.2.html) for more info on this syscall.
        writev = 5019,
        /// See [access(2)](https://man7.org/linux/man-pages/man2/access.2.html) for more info on this syscall.
        access = 5020,
        /// See [pipe(2)](https://man7.org/linux/man-pages/man2/pipe.2.html) for more info on this syscall.
        pipe = 5021,
        /// See [_newselect(2)](https://man7.org/linux/man-pages/man2/_newselect.2.html) for more info on this syscall.
        _newselect = 5022,
        /// See [sched_yield(2)](https://man7.org/linux/man-pages/man2/sched_yield.2.html) for more info on this syscall.
        sched_yield = 5023,
        /// See [mremap(2)](https://man7.org/linux/man-pages/man2/mremap.2.html) for more info on this syscall.
        mremap = 5024,
        /// See [msync(2)](https://man7.org/linux/man-pages/man2/msync.2.html) for more info on this syscall.
        msync = 5025,
        /// See [mincore(2)](https://man7.org/linux/man-pages/man2/mincore.2.html) for more info on this syscall.
        mincore = 5026,
        /// See [madvise(2)](https://man7.org/linux/man-pages/man2/madvise.2.html) for more info on this syscall.
        madvise = 5027,
        /// See [shmget(2)](https://man7.org/linux/man-pages/man2/shmget.2.html) for more info on this syscall.
        shmget = 5028,
        /// See [shmat(2)](https://man7.org/linux/man-pages/man2/shmat.2.html) for more info on this syscall.
        shmat = 5029,
        /// See [shmctl(2)](https://man7.org/linux/man-pages/man2/shmctl.2.html) for more info on this syscall.
        shmctl = 5030,
        /// See [dup(2)](https://man7.org/linux/man-pages/man2/dup.2.html) for more info on this syscall.
        dup = 5031,
        /// See [dup2(2)](https://man7.org/linux/man-pages/man2/dup2.2.html) for more info on this syscall.
        dup2 = 5032,
        /// See [pause(2)](https://man7.org/linux/man-pages/man2/pause.2.html) for more info on this syscall.
        pause = 5033,
        /// See [nanosleep(2)](https://man7.org/linux/man-pages/man2/nanosleep.2.html) for more info on this syscall.
        nanosleep = 5034,
        /// See [getitimer(2)](https://man7.org/linux/man-pages/man2/getitimer.2.html) for more info on this syscall.
        getitimer = 5035,
        /// See [setitimer(2)](https://man7.org/linux/man-pages/man2/setitimer.2.html) for more info on this syscall.
        setitimer = 5036,
        /// See [alarm(2)](https://man7.org/linux/man-pages/man2/alarm.2.html) for more info on this syscall.
        alarm = 5037,
        /// See [getpid(2)](https://man7.org/linux/man-pages/man2/getpid.2.html) for more info on this syscall.
        getpid = 5038,
        /// See [sendfile(2)](https://man7.org/linux/man-pages/man2/sendfile.2.html) for more info on this syscall.
        sendfile = 5039,
        /// See [socket(2)](https://man7.org/linux/man-pages/man2/socket.2.html) for more info on this syscall.
        socket = 5040,
        /// See [connect(2)](https://man7.org/linux/man-pages/man2/connect.2.html) for more info on this syscall.
        connect = 5041,
        /// See [accept(2)](https://man7.org/linux/man-pages/man2/accept.2.html) for more info on this syscall.
        accept = 5042,
        /// See [sendto(2)](https://man7.org/linux/man-pages/man2/sendto.2.html) for more info on this syscall.
        sendto = 5043,
        /// See [recvfrom(2)](https://man7.org/linux/man-pages/man2/recvfrom.2.html) for more info on this syscall.
        recvfrom = 5044,
        /// See [sendmsg(2)](https://man7.org/linux/man-pages/man2/sendmsg.2.html) for more info on this syscall.
        sendmsg = 5045,
        /// See [recvmsg(2)](https://man7.org/linux/man-pages/man2/recvmsg.2.html) for more info on this syscall.
        recvmsg = 5046,
        /// See [shutdown(2)](https://man7.org/linux/man-pages/man2/shutdown.2.html) for more info on this syscall.
        shutdown = 5047,
        /// See [bind(2)](https://man7.org/linux/man-pages/man2/bind.2.html) for more info on this syscall.
        bind = 5048,
        /// See [listen(2)](https://man7.org/linux/man-pages/man2/listen.2.html) for more info on this syscall.
        listen = 5049,
        /// See [getsockname(2)](https://man7.org/linux/man-pages/man2/getsockname.2.html) for more info on this syscall.
        getsockname = 5050,
        /// See [getpeername(2)](https://man7.org/linux/man-pages/man2/getpeername.2.html) for more info on this syscall.
        getpeername = 5051,
        /// See [socketpair(2)](https://man7.org/linux/man-pages/man2/socketpair.2.html) for more info on this syscall.
        socketpair = 5052,
        /// See [setsockopt(2)](https://man7.org/linux/man-pages/man2/setsockopt.2.html) for more info on this syscall.
        setsockopt = 5053,
        /// See [getsockopt(2)](https://man7.org/linux/man-pages/man2/getsockopt.2.html) for more info on this syscall.
        getsockopt = 5054,
        /// See [clone(2)](https://man7.org/linux/man-pages/man2/clone.2.html) for more info on this syscall.
        clone = 5055,
        /// See [fork(2)](https://man7.org/linux/man-pages/man2/fork.2.html) for more info on this syscall.
        fork = 5056,
        /// See [execve(2)](https://man7.org/linux/man-pages/man2/execve.2.html) for more info on this syscall.
        execve = 5057,
        /// See [exit(2)](https://man7.org/linux/man-pages/man2/exit.2.html) for more info on this syscall.
        exit = 5058,
        /// See [wait4(2)](https://man7.org/linux/man-pages/man2/wait4.2.html) for more info on this syscall.
        wait4 = 5059,
        /// See [kill(2)](https://man7.org/linux/man-pages/man2/kill.2.html) for more info on this syscall.
        kill = 5060,
        /// See [uname(2)](https://man7.org/linux/man-pages/man2/uname.2.html) for more info on this syscall.
        uname = 5061,
        /// See [semget(2)](https://man7.org/linux/man-pages/man2/semget.2.html) for more info on this syscall.
        semget = 5062,
        /// See [semop(2)](https://man7.org/linux/man-pages/man2/semop.2.html) for more info on this syscall.
        semop = 5063,
        /// See [semctl(2)](https://man7.org/linux/man-pages/man2/semctl.2.html) for more info on this syscall.
        semctl = 5064,
        /// See [shmdt(2)](https://man7.org/linux/man-pages/man2/shmdt.2.html) for more info on this syscall.
        shmdt = 5065,
        /// See [msgget(2)](https://man7.org/linux/man-pages/man2/msgget.2.html) for more info on this syscall.
        msgget = 5066,
        /// See [msgsnd(2)](https://man7.org/linux/man-pages/man2/msgsnd.2.html) for more info on this syscall.
        msgsnd = 5067,
        /// See [msgrcv(2)](https://man7.org/linux/man-pages/man2/msgrcv.2.html) for more info on this syscall.
        msgrcv = 5068,
        /// See [msgctl(2)](https://man7.org/linux/man-pages/man2/msgctl.2.html) for more info on this syscall.
        msgctl = 5069,
        /// See [fcntl(2)](https://man7.org/linux/man-pages/man2/fcntl.2.html) for more info on this syscall.
        fcntl = 5070,
        /// See [flock(2)](https://man7.org/linux/man-pages/man2/flock.2.html) for more info on this syscall.
        flock = 5071,
        /// See [fsync(2)](https://man7.org/linux/man-pages/man2/fsync.2.html) for more info on this syscall.
        fsync = 5072,
        /// See [fdatasync(2)](https://man7.org/linux/man-pages/man2/fdatasync.2.html) for more info on this syscall.
        fdatasync = 5073,
        /// See [truncate(2)](https://man7.org/linux/man-pages/man2/truncate.2.html) for more info on this syscall.
        truncate = 5074,
        /// See [ftruncate(2)](https://man7.org/linux/man-pages/man2/ftruncate.2.html) for more info on this syscall.
        ftruncate = 5075,
        /// See [getdents(2)](https://man7.org/linux/man-pages/man2/getdents.2.html) for more info on this syscall.
        getdents = 5076,
        /// See [getcwd(2)](https://man7.org/linux/man-pages/man2/getcwd.2.html) for more info on this syscall.
        getcwd = 5077,
        /// See [chdir(2)](https://man7.org/linux/man-pages/man2/chdir.2.html) for more info on this syscall.
        chdir = 5078,
        /// See [fchdir(2)](https://man7.org/linux/man-pages/man2/fchdir.2.html) for more info on this syscall.
        fchdir = 5079,
        /// See [rename(2)](https://man7.org/linux/man-pages/man2/rename.2.html) for more info on this syscall.
        rename = 5080,
        /// See [mkdir(2)](https://man7.org/linux/man-pages/man2/mkdir.2.html) for more info on this syscall.
        mkdir = 5081,
        /// See [rmdir(2)](https://man7.org/linux/man-pages/man2/rmdir.2.html) for more info on this syscall.
        rmdir = 5082,
        /// See [creat(2)](https://man7.org/linux/man-pages/man2/creat.2.html) for more info on this syscall.
        creat = 5083,
        /// See [link(2)](https://man7.org/linux/man-pages/man2/link.2.html) for more info on this syscall.
        link = 5084,
        /// See [unlink(2)](https://man7.org/linux/man-pages/man2/unlink.2.html) for more info on this syscall.
        unlink = 5085,
        /// See [symlink(2)](https://man7.org/linux/man-pages/man2/symlink.2.html) for more info on this syscall.
        symlink = 5086,
        /// See [readlink(2)](https://man7.org/linux/man-pages/man2/readlink.2.html) for more info on this syscall.
        readlink = 5087,
        /// See [chmod(2)](https://man7.org/linux/man-pages/man2/chmod.2.html) for more info on this syscall.
        chmod = 5088,
        /// See [fchmod(2)](https://man7.org/linux/man-pages/man2/fchmod.2.html) for more info on this syscall.
        fchmod = 5089,
        /// See [chown(2)](https://man7.org/linux/man-pages/man2/chown.2.html) for more info on this syscall.
        chown = 5090,
        /// See [fchown(2)](https://man7.org/linux/man-pages/man2/fchown.2.html) for more info on this syscall.
        fchown = 5091,
        /// See [lchown(2)](https://man7.org/linux/man-pages/man2/lchown.2.html) for more info on this syscall.
        lchown = 5092,
        /// See [umask(2)](https://man7.org/linux/man-pages/man2/umask.2.html) for more info on this syscall.
        umask = 5093,
        /// See [gettimeofday(2)](https://man7.org/linux/man-pages/man2/gettimeofday.2.html) for more info on this syscall.
        gettimeofday = 5094,
        /// See [getrlimit(2)](https://man7.org/linux/man-pages/man2/getrlimit.2.html) for more info on this syscall.
        getrlimit = 5095,
        /// See [getrusage(2)](https://man7.org/linux/man-pages/man2/getrusage.2.html) for more info on this syscall.
        getrusage = 5096,
        /// See [sysinfo(2)](https://man7.org/linux/man-pages/man2/sysinfo.2.html) for more info on this syscall.
        sysinfo = 5097,
        /// See [times(2)](https://man7.org/linux/man-pages/man2/times.2.html) for more info on this syscall.
        times = 5098,
        /// See [ptrace(2)](https://man7.org/linux/man-pages/man2/ptrace.2.html) for more info on this syscall.
        ptrace = 5099,
        /// See [getuid(2)](https://man7.org/linux/man-pages/man2/getuid.2.html) for more info on this syscall.
        getuid = 5100,
        /// See [syslog(2)](https://man7.org/linux/man-pages/man2/syslog.2.html) for more info on this syscall.
        syslog = 5101,
        /// See [getgid(2)](https://man7.org/linux/man-pages/man2/getgid.2.html) for more info on this syscall.
        getgid = 5102,
        /// See [setuid(2)](https://man7.org/linux/man-pages/man2/setuid.2.html) for more info on this syscall.
        setuid = 5103,
        /// See [setgid(2)](https://man7.org/linux/man-pages/man2/setgid.2.html) for more info on this syscall.
        setgid = 5104,
        /// See [geteuid(2)](https://man7.org/linux/man-pages/man2/geteuid.2.html) for more info on this syscall.
        geteuid = 5105,
        /// See [getegid(2)](https://man7.org/linux/man-pages/man2/getegid.2.html) for more info on this syscall.
        getegid = 5106,
        /// See [setpgid(2)](https://man7.org/linux/man-pages/man2/setpgid.2.html) for more info on this syscall.
        setpgid = 5107,
        /// See [getppid(2)](https://man7.org/linux/man-pages/man2/getppid.2.html) for more info on this syscall.
        getppid = 5108,
        /// See [getpgrp(2)](https://man7.org/linux/man-pages/man2/getpgrp.2.html) for more info on this syscall.
        getpgrp = 5109,
        /// See [setsid(2)](https://man7.org/linux/man-pages/man2/setsid.2.html) for more info on this syscall.
        setsid = 5110,
        /// See [setreuid(2)](https://man7.org/linux/man-pages/man2/setreuid.2.html) for more info on this syscall.
        setreuid = 5111,
        /// See [setregid(2)](https://man7.org/linux/man-pages/man2/setregid.2.html) for more info on this syscall.
        setregid = 5112,
        /// See [getgroups(2)](https://man7.org/linux/man-pages/man2/getgroups.2.html) for more info on this syscall.
        getgroups = 5113,
        /// See [setgroups(2)](https://man7.org/linux/man-pages/man2/setgroups.2.html) for more info on this syscall.
        setgroups = 5114,
        /// See [setresuid(2)](https://man7.org/linux/man-pages/man2/setresuid.2.html) for more info on this syscall.
        setresuid = 5115,
        /// See [getresuid(2)](https://man7.org/linux/man-pages/man2/getresuid.2.html) for more info on this syscall.
        getresuid = 5116,
        /// See [setresgid(2)](https://man7.org/linux/man-pages/man2/setresgid.2.html) for more info on this syscall.
        setresgid = 5117,
        /// See [getresgid(2)](https://man7.org/linux/man-pages/man2/getresgid.2.html) for more info on this syscall.
        getresgid = 5118,
        /// See [getpgid(2)](https://man7.org/linux/man-pages/man2/getpgid.2.html) for more info on this syscall.
        getpgid = 5119,
        /// See [setfsuid(2)](https://man7.org/linux/man-pages/man2/setfsuid.2.html) for more info on this syscall.
        setfsuid = 5120,
        /// See [setfsgid(2)](https://man7.org/linux/man-pages/man2/setfsgid.2.html) for more info on this syscall.
        setfsgid = 5121,
        /// See [getsid(2)](https://man7.org/linux/man-pages/man2/getsid.2.html) for more info on this syscall.
        getsid = 5122,
        /// See [capget(2)](https://man7.org/linux/man-pages/man2/capget.2.html) for more info on this syscall.
        capget = 5123,
        /// See [capset(2)](https://man7.org/linux/man-pages/man2/capset.2.html) for more info on this syscall.
        capset = 5124,
        /// See [rt_sigpending(2)](https://man7.org/linux/man-pages/man2/rt_sigpending.2.html) for more info on this syscall.
        rt_sigpending = 5125,
        /// See [rt_sigtimedwait(2)](https://man7.org/linux/man-pages/man2/rt_sigtimedwait.2.html) for more info on this syscall.
        rt_sigtimedwait = 5126,
        /// See [rt_sigqueueinfo(2)](https://man7.org/linux/man-pages/man2/rt_sigqueueinfo.2.html) for more info on this syscall.
        rt_sigqueueinfo = 5127,
        /// See [rt_sigsuspend(2)](https://man7.org/linux/man-pages/man2/rt_sigsuspend.2.html) for more info on this syscall.
        rt_sigsuspend = 5128,
        /// See [sigaltstack(2)](https://man7.org/linux/man-pages/man2/sigaltstack.2.html) for more info on this syscall.
        sigaltstack = 5129,
        /// See [utime(2)](https://man7.org/linux/man-pages/man2/utime.2.html) for more info on this syscall.
        utime = 5130,
        /// See [mknod(2)](https://man7.org/linux/man-pages/man2/mknod.2.html) for more info on this syscall.
        mknod = 5131,
        /// See [personality(2)](https://man7.org/linux/man-pages/man2/personality.2.html) for more info on this syscall.
        personality = 5132,
        /// See [ustat(2)](https://man7.org/linux/man-pages/man2/ustat.2.html) for more info on this syscall.
        ustat = 5133,
        /// See [statfs(2)](https://man7.org/linux/man-pages/man2/statfs.2.html) for more info on this syscall.
        statfs = 5134,
        /// See [fstatfs(2)](https://man7.org/linux/man-pages/man2/fstatfs.2.html) for more info on this syscall.
        fstatfs = 5135,
        /// See [sysfs(2)](https://man7.org/linux/man-pages/man2/sysfs.2.html) for more info on this syscall.
        sysfs = 5136,
        /// See [getpriority(2)](https://man7.org/linux/man-pages/man2/getpriority.2.html) for more info on this syscall.
        getpriority = 5137,
        /// See [setpriority(2)](https://man7.org/linux/man-pages/man2/setpriority.2.html) for more info on this syscall.
        setpriority = 5138,
        /// See [sched_setparam(2)](https://man7.org/linux/man-pages/man2/sched_setparam.2.html) for more info on this syscall.
        sched_setparam = 5139,
        /// See [sched_getparam(2)](https://man7.org/linux/man-pages/man2/sched_getparam.2.html) for more info on this syscall.
        sched_getparam = 5140,
        /// See [sched_setscheduler(2)](https://man7.org/linux/man-pages/man2/sched_setscheduler.2.html) for more info on this syscall.
        sched_setscheduler = 5141,
        /// See [sched_getscheduler(2)](https://man7.org/linux/man-pages/man2/sched_getscheduler.2.html) for more info on this syscall.
        sched_getscheduler = 5142,
        /// See [sched_get_priority_max(2)](https://man7.org/linux/man-pages/man2/sched_get_priority_max.2.html) for more info on this syscall.
        sched_get_priority_max = 5143,
        /// See [sched_get_priority_min(2)](https://man7.org/linux/man-pages/man2/sched_get_priority_min.2.html) for more info on this syscall.
        sched_get_priority_min = 5144,
        /// See [sched_rr_get_interval(2)](https://man7.org/linux/man-pages/man2/sched_rr_get_interval.2.html) for more info on this syscall.
        sched_rr_get_interval = 5145,
        /// See [mlock(2)](https://man7.org/linux/man-pages/man2/mlock.2.html) for more info on this syscall.
        mlock = 5146,
        /// See [munlock(2)](https://man7.org/linux/man-pages/man2/munlock.2.html) for more info on this syscall.
        munlock = 5147,
        /// See [mlockall(2)](https://man7.org/linux/man-pages/man2/mlockall.2.html) for more info on this syscall.
        mlockall = 5148,
        /// See [munlockall(2)](https://man7.org/linux/man-pages/man2/munlockall.2.html) for more info on this syscall.
        munlockall = 5149,
        /// See [vhangup(2)](https://man7.org/linux/man-pages/man2/vhangup.2.html) for more info on this syscall.
        vhangup = 5150,
        /// See [pivot_root(2)](https://man7.org/linux/man-pages/man2/pivot_root.2.html) for more info on this syscall.
        pivot_root = 5151,
        /// See [_sysctl(2)](https://man7.org/linux/man-pages/man2/_sysctl.2.html) for more info on this syscall.
        _sysctl = 5152,
        /// See [prctl(2)](https://man7.org/linux/man-pages/man2/prctl.2.html) for more info on this syscall.
        prctl = 5153,
        /// See [adjtimex(2)](https://man7.org/linux/man-pages/man2/adjtimex.2.html) for more info on this syscall.
        adjtimex = 5154,
        /// See [setrlimit(2)](https://man7.org/linux/man-pages/man2/setrlimit.2.html) for more info on this syscall.
        setrlimit = 5155,
        /// See [chroot(2)](https://man7.org/linux/man-pages/man2/chroot.2.html) for more info on this syscall.
        chroot = 5156,
        /// See [sync(2)](https://man7.org/linux/man-pages/man2/sync.2.html) for more info on this syscall.
        sync = 5157,
        /// See [acct(2)](https://man7.org/linux/man-pages/man2/acct.2.html) for more info on this syscall.
        acct = 5158,
        /// See [settimeofday(2)](https://man7.org/linux/man-pages/man2/settimeofday.2.html) for more info on this syscall.
        settimeofday = 5159,
        /// See [mount(2)](https://man7.org/linux/man-pages/man2/mount.2.html) for more info on this syscall.
        mount = 5160,
        /// See [umount2(2)](https://man7.org/linux/man-pages/man2/umount2.2.html) for more info on this syscall.
        umount2 = 5161,
        /// See [swapon(2)](https://man7.org/linux/man-pages/man2/swapon.2.html) for more info on this syscall.
        swapon = 5162,
        /// See [swapoff(2)](https://man7.org/linux/man-pages/man2/swapoff.2.html) for more info on this syscall.
        swapoff = 5163,
        /// See [reboot(2)](https://man7.org/linux/man-pages/man2/reboot.2.html) for more info on this syscall.
        reboot = 5164,
        /// See [sethostname(2)](https://man7.org/linux/man-pages/man2/sethostname.2.html) for more info on this syscall.
        sethostname = 5165,
        /// See [setdomainname(2)](https://man7.org/linux/man-pages/man2/setdomainname.2.html) for more info on this syscall.
        setdomainname = 5166,
        /// See [create_module(2)](https://man7.org/linux/man-pages/man2/create_module.2.html) for more info on this syscall.
        create_module = 5167,
        /// See [init_module(2)](https://man7.org/linux/man-pages/man2/init_module.2.html) for more info on this syscall.
        init_module = 5168,
        /// See [delete_module(2)](https://man7.org/linux/man-pages/man2/delete_module.2.html) for more info on this syscall.
        delete_module = 5169,
        /// See [get_kernel_syms(2)](https://man7.org/linux/man-pages/man2/get_kernel_syms.2.html) for more info on this syscall.
        get_kernel_syms = 5170,
        /// See [query_module(2)](https://man7.org/linux/man-pages/man2/query_module.2.html) for more info on this syscall.
        query_module = 5171,
        /// See [quotactl(2)](https://man7.org/linux/man-pages/man2/quotactl.2.html) for more info on this syscall.
        quotactl = 5172,
        /// See [nfsservctl(2)](https://man7.org/linux/man-pages/man2/nfsservctl.2.html) for more info on this syscall.
        nfsservctl = 5173,
        /// See [getpmsg(2)](https://man7.org/linux/man-pages/man2/getpmsg.2.html) for more info on this syscall.
        getpmsg = 5174,
        /// See [putpmsg(2)](https://man7.org/linux/man-pages/man2/putpmsg.2.html) for more info on this syscall.
        putpmsg = 5175,
        /// See [afs_syscall(2)](https://man7.org/linux/man-pages/man2/afs_syscall.2.html) for more info on this syscall.
        afs_syscall = 5176,
        /// See [reserved177(2)](https://man7.org/linux/man-pages/man2/reserved177.2.html) for more info on this syscall.
        reserved177 = 5177,
        /// See [gettid(2)](https://man7.org/linux/man-pages/man2/gettid.2.html) for more info on this syscall.
        gettid = 5178,
        /// See [readahead(2)](https://man7.org/linux/man-pages/man2/readahead.2.html) for more info on this syscall.
        readahead = 5179,
        /// See [setxattr(2)](https://man7.org/linux/man-pages/man2/setxattr.2.html) for more info on this syscall.
        setxattr = 5180,
        /// See [lsetxattr(2)](https://man7.org/linux/man-pages/man2/lsetxattr.2.html) for more info on this syscall.
        lsetxattr = 5181,
        /// See [fsetxattr(2)](https://man7.org/linux/man-pages/man2/fsetxattr.2.html) for more info on this syscall.
        fsetxattr = 5182,
        /// See [getxattr(2)](https://man7.org/linux/man-pages/man2/getxattr.2.html) for more info on this syscall.
        getxattr = 5183,
        /// See [lgetxattr(2)](https://man7.org/linux/man-pages/man2/lgetxattr.2.html) for more info on this syscall.
        lgetxattr = 5184,
        /// See [fgetxattr(2)](https://man7.org/linux/man-pages/man2/fgetxattr.2.html) for more info on this syscall.
        fgetxattr = 5185,
        /// See [listxattr(2)](https://man7.org/linux/man-pages/man2/listxattr.2.html) for more info on this syscall.
        listxattr = 5186,
        /// See [llistxattr(2)](https://man7.org/linux/man-pages/man2/llistxattr.2.html) for more info on this syscall.
        llistxattr = 5187,
        /// See [flistxattr(2)](https://man7.org/linux/man-pages/man2/flistxattr.2.html) for more info on this syscall.
        flistxattr = 5188,
        /// See [removexattr(2)](https://man7.org/linux/man-pages/man2/removexattr.2.html) for more info on this syscall.
        removexattr = 5189,
        /// See [lremovexattr(2)](https://man7.org/linux/man-pages/man2/lremovexattr.2.html) for more info on this syscall.
        lremovexattr = 5190,
        /// See [fremovexattr(2)](https://man7.org/linux/man-pages/man2/fremovexattr.2.html) for more info on this syscall.
        fremovexattr = 5191,
        /// See [tkill(2)](https://man7.org/linux/man-pages/man2/tkill.2.html) for more info on this syscall.
        tkill = 5192,
        /// See [reserved193(2)](https://man7.org/linux/man-pages/man2/reserved193.2.html) for more info on this syscall.
        reserved193 = 5193,
        /// See [futex(2)](https://man7.org/linux/man-pages/man2/futex.2.html) for more info on this syscall.
        futex = 5194,
        /// See [sched_setaffinity(2)](https://man7.org/linux/man-pages/man2/sched_setaffinity.2.html) for more info on this syscall.
        sched_setaffinity = 5195,
        /// See [sched_getaffinity(2)](https://man7.org/linux/man-pages/man2/sched_getaffinity.2.html) for more info on this syscall.
        sched_getaffinity = 5196,
        /// See [cacheflush(2)](https://man7.org/linux/man-pages/man2/cacheflush.2.html) for more info on this syscall.
        cacheflush = 5197,
        /// See [cachectl(2)](https://man7.org/linux/man-pages/man2/cachectl.2.html) for more info on this syscall.
        cachectl = 5198,
        /// See [sysmips(2)](https://man7.org/linux/man-pages/man2/sysmips.2.html) for more info on this syscall.
        sysmips = 5199,
        /// See [io_setup(2)](https://man7.org/linux/man-pages/man2/io_setup.2.html) for more info on this syscall.
        io_setup = 5200,
        /// See [io_destroy(2)](https://man7.org/linux/man-pages/man2/io_destroy.2.html) for more info on this syscall.
        io_destroy = 5201,
        /// See [io_getevents(2)](https://man7.org/linux/man-pages/man2/io_getevents.2.html) for more info on this syscall.
        io_getevents = 5202,
        /// See [io_submit(2)](https://man7.org/linux/man-pages/man2/io_submit.2.html) for more info on this syscall.
        io_submit = 5203,
        /// See [io_cancel(2)](https://man7.org/linux/man-pages/man2/io_cancel.2.html) for more info on this syscall.
        io_cancel = 5204,
        /// See [exit_group(2)](https://man7.org/linux/man-pages/man2/exit_group.2.html) for more info on this syscall.
        exit_group = 5205,
        /// See [lookup_dcookie(2)](https://man7.org/linux/man-pages/man2/lookup_dcookie.2.html) for more info on this syscall.
        lookup_dcookie = 5206,
        /// See [epoll_create(2)](https://man7.org/linux/man-pages/man2/epoll_create.2.html) for more info on this syscall.
        epoll_create = 5207,
        /// See [epoll_ctl(2)](https://man7.org/linux/man-pages/man2/epoll_ctl.2.html) for more info on this syscall.
        epoll_ctl = 5208,
        /// See [epoll_wait(2)](https://man7.org/linux/man-pages/man2/epoll_wait.2.html) for more info on this syscall.
        epoll_wait = 5209,
        /// See [remap_file_pages(2)](https://man7.org/linux/man-pages/man2/remap_file_pages.2.html) for more info on this syscall.
        remap_file_pages = 5210,
        /// See [rt_sigreturn(2)](https://man7.org/linux/man-pages/man2/rt_sigreturn.2.html) for more info on this syscall.
        rt_sigreturn = 5211,
        /// See [set_tid_address(2)](https://man7.org/linux/man-pages/man2/set_tid_address.2.html) for more info on this syscall.
        set_tid_address = 5212,
        /// See [restart_syscall(2)](https://man7.org/linux/man-pages/man2/restart_syscall.2.html) for more info on this syscall.
        restart_syscall = 5213,
        /// See [semtimedop(2)](https://man7.org/linux/man-pages/man2/semtimedop.2.html) for more info on this syscall.
        semtimedop = 5214,
        /// See [fadvise64(2)](https://man7.org/linux/man-pages/man2/fadvise64.2.html) for more info on this syscall.
        fadvise64 = 5215,
        /// See [timer_create(2)](https://man7.org/linux/man-pages/man2/timer_create.2.html) for more info on this syscall.
        timer_create = 5216,
        /// See [timer_settime(2)](https://man7.org/linux/man-pages/man2/timer_settime.2.html) for more info on this syscall.
        timer_settime = 5217,
        /// See [timer_gettime(2)](https://man7.org/linux/man-pages/man2/timer_gettime.2.html) for more info on this syscall.
        timer_gettime = 5218,
        /// See [timer_getoverrun(2)](https://man7.org/linux/man-pages/man2/timer_getoverrun.2.html) for more info on this syscall.
        timer_getoverrun = 5219,
        /// See [timer_delete(2)](https://man7.org/linux/man-pages/man2/timer_delete.2.html) for more info on this syscall.
        timer_delete = 5220,
        /// See [clock_settime(2)](https://man7.org/linux/man-pages/man2/clock_settime.2.html) for more info on this syscall.
        clock_settime = 5221,
        /// See [clock_gettime(2)](https://man7.org/linux/man-pages/man2/clock_gettime.2.html) for more info on this syscall.
        clock_gettime = 5222,
        /// See [clock_getres(2)](https://man7.org/linux/man-pages/man2/clock_getres.2.html) for more info on this syscall.
        clock_getres = 5223,
        /// See [clock_nanosleep(2)](https://man7.org/linux/man-pages/man2/clock_nanosleep.2.html) for more info on this syscall.
        clock_nanosleep = 5224,
        /// See [tgkill(2)](https://man7.org/linux/man-pages/man2/tgkill.2.html) for more info on this syscall.
        tgkill = 5225,
        /// See [utimes(2)](https://man7.org/linux/man-pages/man2/utimes.2.html) for more info on this syscall.
        utimes = 5226,
        /// See [mbind(2)](https://man7.org/linux/man-pages/man2/mbind.2.html) for more info on this syscall.
        mbind = 5227,
        /// See [get_mempolicy(2)](https://man7.org/linux/man-pages/man2/get_mempolicy.2.html) for more info on this syscall.
        get_mempolicy = 5228,
        /// See [set_mempolicy(2)](https://man7.org/linux/man-pages/man2/set_mempolicy.2.html) for more info on this syscall.
        set_mempolicy = 5229,
        /// See [mq_open(2)](https://man7.org/linux/man-pages/man2/mq_open.2.html) for more info on this syscall.
        mq_open = 5230,
        /// See [mq_unlink(2)](https://man7.org/linux/man-pages/man2/mq_unlink.2.html) for more info on this syscall.
        mq_unlink = 5231,
        /// See [mq_timedsend(2)](https://man7.org/linux/man-pages/man2/mq_timedsend.2.html) for more info on this syscall.
        mq_timedsend = 5232,
        /// See [mq_timedreceive(2)](https://man7.org/linux/man-pages/man2/mq_timedreceive.2.html) for more info on this syscall.
        mq_timedreceive = 5233,
        /// See [mq_notify(2)](https://man7.org/linux/man-pages/man2/mq_notify.2.html) for more info on this syscall.
        mq_notify = 5234,
        /// See [mq_getsetattr(2)](https://man7.org/linux/man-pages/man2/mq_getsetattr.2.html) for more info on this syscall.
        mq_getsetattr = 5235,
        /// See [vserver(2)](https://man7.org/linux/man-pages/man2/vserver.2.html) for more info on this syscall.
        vserver = 5236,
        /// See [waitid(2)](https://man7.org/linux/man-pages/man2/waitid.2.html) for more info on this syscall.
        waitid = 5237,
        /// See [add_key(2)](https://man7.org/linux/man-pages/man2/add_key.2.html) for more info on this syscall.
        add_key = 5239,
        /// See [request_key(2)](https://man7.org/linux/man-pages/man2/request_key.2.html) for more info on this syscall.
        request_key = 5240,
        /// See [keyctl(2)](https://man7.org/linux/man-pages/man2/keyctl.2.html) for more info on this syscall.
        keyctl = 5241,
        /// See [set_thread_area(2)](https://man7.org/linux/man-pages/man2/set_thread_area.2.html) for more info on this syscall.
        set_thread_area = 5242,
        /// See [inotify_init(2)](https://man7.org/linux/man-pages/man2/inotify_init.2.html) for more info on this syscall.
        inotify_init = 5243,
        /// See [inotify_add_watch(2)](https://man7.org/linux/man-pages/man2/inotify_add_watch.2.html) for more info on this syscall.
        inotify_add_watch = 5244,
        /// See [inotify_rm_watch(2)](https://man7.org/linux/man-pages/man2/inotify_rm_watch.2.html) for more info on this syscall.
        inotify_rm_watch = 5245,
        /// See [migrate_pages(2)](https://man7.org/linux/man-pages/man2/migrate_pages.2.html) for more info on this syscall.
        migrate_pages = 5246,
        /// See [openat(2)](https://man7.org/linux/man-pages/man2/openat.2.html) for more info on this syscall.
        openat = 5247,
        /// See [mkdirat(2)](https://man7.org/linux/man-pages/man2/mkdirat.2.html) for more info on this syscall.
        mkdirat = 5248,
        /// See [mknodat(2)](https://man7.org/linux/man-pages/man2/mknodat.2.html) for more info on this syscall.
        mknodat = 5249,
        /// See [fchownat(2)](https://man7.org/linux/man-pages/man2/fchownat.2.html) for more info on this syscall.
        fchownat = 5250,
        /// See [futimesat(2)](https://man7.org/linux/man-pages/man2/futimesat.2.html) for more info on this syscall.
        futimesat = 5251,
        /// See [newfstatat(2)](https://man7.org/linux/man-pages/man2/newfstatat.2.html) for more info on this syscall.
        newfstatat = 5252,
        /// See [unlinkat(2)](https://man7.org/linux/man-pages/man2/unlinkat.2.html) for more info on this syscall.
        unlinkat = 5253,
        /// See [renameat(2)](https://man7.org/linux/man-pages/man2/renameat.2.html) for more info on this syscall.
        renameat = 5254,
        /// See [linkat(2)](https://man7.org/linux/man-pages/man2/linkat.2.html) for more info on this syscall.
        linkat = 5255,
        /// See [symlinkat(2)](https://man7.org/linux/man-pages/man2/symlinkat.2.html) for more info on this syscall.
        symlinkat = 5256,
        /// See [readlinkat(2)](https://man7.org/linux/man-pages/man2/readlinkat.2.html) for more info on this syscall.
        readlinkat = 5257,
        /// See [fchmodat(2)](https://man7.org/linux/man-pages/man2/fchmodat.2.html) for more info on this syscall.
        fchmodat = 5258,
        /// See [faccessat(2)](https://man7.org/linux/man-pages/man2/faccessat.2.html) for more info on this syscall.
        faccessat = 5259,
        /// See [pselect6(2)](https://man7.org/linux/man-pages/man2/pselect6.2.html) for more info on this syscall.
        pselect6 = 5260,
        /// See [ppoll(2)](https://man7.org/linux/man-pages/man2/ppoll.2.html) for more info on this syscall.
        ppoll = 5261,
        /// See [unshare(2)](https://man7.org/linux/man-pages/man2/unshare.2.html) for more info on this syscall.
        unshare = 5262,
        /// See [splice(2)](https://man7.org/linux/man-pages/man2/splice.2.html) for more info on this syscall.
        splice = 5263,
        /// See [sync_file_range(2)](https://man7.org/linux/man-pages/man2/sync_file_range.2.html) for more info on this syscall.
        sync_file_range = 5264,
        /// See [tee(2)](https://man7.org/linux/man-pages/man2/tee.2.html) for more info on this syscall.
        tee = 5265,
        /// See [vmsplice(2)](https://man7.org/linux/man-pages/man2/vmsplice.2.html) for more info on this syscall.
        vmsplice = 5266,
        /// See [move_pages(2)](https://man7.org/linux/man-pages/man2/move_pages.2.html) for more info on this syscall.
        move_pages = 5267,
        /// See [set_robust_list(2)](https://man7.org/linux/man-pages/man2/set_robust_list.2.html) for more info on this syscall.
        set_robust_list = 5268,
        /// See [get_robust_list(2)](https://man7.org/linux/man-pages/man2/get_robust_list.2.html) for more info on this syscall.
        get_robust_list = 5269,
        /// See [kexec_load(2)](https://man7.org/linux/man-pages/man2/kexec_load.2.html) for more info on this syscall.
        kexec_load = 5270,
        /// See [getcpu(2)](https://man7.org/linux/man-pages/man2/getcpu.2.html) for more info on this syscall.
        getcpu = 5271,
        /// See [epoll_pwait(2)](https://man7.org/linux/man-pages/man2/epoll_pwait.2.html) for more info on this syscall.
        epoll_pwait = 5272,
        /// See [ioprio_set(2)](https://man7.org/linux/man-pages/man2/ioprio_set.2.html) for more info on this syscall.
        ioprio_set = 5273,
        /// See [ioprio_get(2)](https://man7.org/linux/man-pages/man2/ioprio_get.2.html) for more info on this syscall.
        ioprio_get = 5274,
        /// See [utimensat(2)](https://man7.org/linux/man-pages/man2/utimensat.2.html) for more info on this syscall.
        utimensat = 5275,
        /// See [signalfd(2)](https://man7.org/linux/man-pages/man2/signalfd.2.html) for more info on this syscall.
        signalfd = 5276,
        /// See [timerfd(2)](https://man7.org/linux/man-pages/man2/timerfd.2.html) for more info on this syscall.
        timerfd = 5277,
        /// See [eventfd(2)](https://man7.org/linux/man-pages/man2/eventfd.2.html) for more info on this syscall.
        eventfd = 5278,
        /// See [fallocate(2)](https://man7.org/linux/man-pages/man2/fallocate.2.html) for more info on this syscall.
        fallocate = 5279,
        /// See [timerfd_create(2)](https://man7.org/linux/man-pages/man2/timerfd_create.2.html) for more info on this syscall.
        timerfd_create = 5280,
        /// See [timerfd_gettime(2)](https://man7.org/linux/man-pages/man2/timerfd_gettime.2.html) for more info on this syscall.
        timerfd_gettime = 5281,
        /// See [timerfd_settime(2)](https://man7.org/linux/man-pages/man2/timerfd_settime.2.html) for more info on this syscall.
        timerfd_settime = 5282,
        /// See [signalfd4(2)](https://man7.org/linux/man-pages/man2/signalfd4.2.html) for more info on this syscall.
        signalfd4 = 5283,
        /// See [eventfd2(2)](https://man7.org/linux/man-pages/man2/eventfd2.2.html) for more info on this syscall.
        eventfd2 = 5284,
        /// See [epoll_create1(2)](https://man7.org/linux/man-pages/man2/epoll_create1.2.html) for more info on this syscall.
        epoll_create1 = 5285,
        /// See [dup3(2)](https://man7.org/linux/man-pages/man2/dup3.2.html) for more info on this syscall.
        dup3 = 5286,
        /// See [pipe2(2)](https://man7.org/linux/man-pages/man2/pipe2.2.html) for more info on this syscall.
        pipe2 = 5287,
        /// See [inotify_init1(2)](https://man7.org/linux/man-pages/man2/inotify_init1.2.html) for more info on this syscall.
        inotify_init1 = 5288,
        /// See [preadv(2)](https://man7.org/linux/man-pages/man2/preadv.2.html) for more info on this syscall.
        preadv = 5289,
        /// See [pwritev(2)](https://man7.org/linux/man-pages/man2/pwritev.2.html) for more info on this syscall.
        pwritev = 5290,
        /// See [rt_tgsigqueueinfo(2)](https://man7.org/linux/man-pages/man2/rt_tgsigqueueinfo.2.html) for more info on this syscall.
        rt_tgsigqueueinfo = 5291,
        /// See [perf_event_open(2)](https://man7.org/linux/man-pages/man2/perf_event_open.2.html) for more info on this syscall.
        perf_event_open = 5292,
        /// See [accept4(2)](https://man7.org/linux/man-pages/man2/accept4.2.html) for more info on this syscall.
        accept4 = 5293,
        /// See [recvmmsg(2)](https://man7.org/linux/man-pages/man2/recvmmsg.2.html) for more info on this syscall.
        recvmmsg = 5294,
        /// See [fanotify_init(2)](https://man7.org/linux/man-pages/man2/fanotify_init.2.html) for more info on this syscall.
        fanotify_init = 5295,
        /// See [fanotify_mark(2)](https://man7.org/linux/man-pages/man2/fanotify_mark.2.html) for more info on this syscall.
        fanotify_mark = 5296,
        /// See [prlimit64(2)](https://man7.org/linux/man-pages/man2/prlimit64.2.html) for more info on this syscall.
        prlimit64 = 5297,
        /// See [name_to_handle_at(2)](https://man7.org/linux/man-pages/man2/name_to_handle_at.2.html) for more info on this syscall.
        name_to_handle_at = 5298,
        /// See [open_by_handle_at(2)](https://man7.org/linux/man-pages/man2/open_by_handle_at.2.html) for more info on this syscall.
        open_by_handle_at = 5299,
        /// See [clock_adjtime(2)](https://man7.org/linux/man-pages/man2/clock_adjtime.2.html) for more info on this syscall.
        clock_adjtime = 5300,
        /// See [syncfs(2)](https://man7.org/linux/man-pages/man2/syncfs.2.html) for more info on this syscall.
        syncfs = 5301,
        /// See [sendmmsg(2)](https://man7.org/linux/man-pages/man2/sendmmsg.2.html) for more info on this syscall.
        sendmmsg = 5302,
        /// See [setns(2)](https://man7.org/linux/man-pages/man2/setns.2.html) for more info on this syscall.
        setns = 5303,
        /// See [process_vm_readv(2)](https://man7.org/linux/man-pages/man2/process_vm_readv.2.html) for more info on this syscall.
        process_vm_readv = 5304,
        /// See [process_vm_writev(2)](https://man7.org/linux/man-pages/man2/process_vm_writev.2.html) for more info on this syscall.
        process_vm_writev = 5305,
        /// See [kcmp(2)](https://man7.org/linux/man-pages/man2/kcmp.2.html) for more info on this syscall.
        kcmp = 5306,
        /// See [finit_module(2)](https://man7.org/linux/man-pages/man2/finit_module.2.html) for more info on this syscall.
        finit_module = 5307,
        /// See [getdents64(2)](https://man7.org/linux/man-pages/man2/getdents64.2.html) for more info on this syscall.
        getdents64 = 5308,
        /// See [sched_setattr(2)](https://man7.org/linux/man-pages/man2/sched_setattr.2.html) for more info on this syscall.
        sched_setattr = 5309,
        /// See [sched_getattr(2)](https://man7.org/linux/man-pages/man2/sched_getattr.2.html) for more info on this syscall.
        sched_getattr = 5310,
        /// See [renameat2(2)](https://man7.org/linux/man-pages/man2/renameat2.2.html) for more info on this syscall.
        renameat2 = 5311,
        /// See [seccomp(2)](https://man7.org/linux/man-pages/man2/seccomp.2.html) for more info on this syscall.
        seccomp = 5312,
        /// See [getrandom(2)](https://man7.org/linux/man-pages/man2/getrandom.2.html) for more info on this syscall.
        getrandom = 5313,
        /// See [memfd_create(2)](https://man7.org/linux/man-pages/man2/memfd_create.2.html) for more info on this syscall.
        memfd_create = 5314,
        /// See [bpf(2)](https://man7.org/linux/man-pages/man2/bpf.2.html) for more info on this syscall.
        bpf = 5315,
        /// See [execveat(2)](https://man7.org/linux/man-pages/man2/execveat.2.html) for more info on this syscall.
        execveat = 5316,
        /// See [userfaultfd(2)](https://man7.org/linux/man-pages/man2/userfaultfd.2.html) for more info on this syscall.
        userfaultfd = 5317,
        /// See [membarrier(2)](https://man7.org/linux/man-pages/man2/membarrier.2.html) for more info on this syscall.
        membarrier = 5318,
        /// See [mlock2(2)](https://man7.org/linux/man-pages/man2/mlock2.2.html) for more info on this syscall.
        mlock2 = 5319,
        /// See [copy_file_range(2)](https://man7.org/linux/man-pages/man2/copy_file_range.2.html) for more info on this syscall.
        copy_file_range = 5320,
        /// See [preadv2(2)](https://man7.org/linux/man-pages/man2/preadv2.2.html) for more info on this syscall.
        preadv2 = 5321,
        /// See [pwritev2(2)](https://man7.org/linux/man-pages/man2/pwritev2.2.html) for more info on this syscall.
        pwritev2 = 5322,
        /// See [pkey_mprotect(2)](https://man7.org/linux/man-pages/man2/pkey_mprotect.2.html) for more info on this syscall.
        pkey_mprotect = 5323,
        /// See [pkey_alloc(2)](https://man7.org/linux/man-pages/man2/pkey_alloc.2.html) for more info on this syscall.
        pkey_alloc = 5324,
        /// See [pkey_free(2)](https://man7.org/linux/man-pages/man2/pkey_free.2.html) for more info on this syscall.
        pkey_free = 5325,
        /// See [statx(2)](https://man7.org/linux/man-pages/man2/statx.2.html) for more info on this syscall.
        statx = 5326,
        /// See [rseq(2)](https://man7.org/linux/man-pages/man2/rseq.2.html) for more info on this syscall.
        rseq = 5327,
        /// See [io_pgetevents(2)](https://man7.org/linux/man-pages/man2/io_pgetevents.2.html) for more info on this syscall.
        io_pgetevents = 5328,
        /// See [pidfd_send_signal(2)](https://man7.org/linux/man-pages/man2/pidfd_send_signal.2.html) for more info on this syscall.
        pidfd_send_signal = 5424,
        /// See [io_uring_setup(2)](https://man7.org/linux/man-pages/man2/io_uring_setup.2.html) for more info on this syscall.
        io_uring_setup = 5425,
        /// See [io_uring_enter(2)](https://man7.org/linux/man-pages/man2/io_uring_enter.2.html) for more info on this syscall.
        io_uring_enter = 5426,
        /// See [io_uring_register(2)](https://man7.org/linux/man-pages/man2/io_uring_register.2.html) for more info on this syscall.
        io_uring_register = 5427,
        /// See [open_tree(2)](https://man7.org/linux/man-pages/man2/open_tree.2.html) for more info on this syscall.
        open_tree = 5428,
        /// See [move_mount(2)](https://man7.org/linux/man-pages/man2/move_mount.2.html) for more info on this syscall.
        move_mount = 5429,
        /// See [fsopen(2)](https://man7.org/linux/man-pages/man2/fsopen.2.html) for more info on this syscall.
        fsopen = 5430,
        /// See [fsconfig(2)](https://man7.org/linux/man-pages/man2/fsconfig.2.html) for more info on this syscall.
        fsconfig = 5431,
        /// See [fsmount(2)](https://man7.org/linux/man-pages/man2/fsmount.2.html) for more info on this syscall.
        fsmount = 5432,
        /// See [fspick(2)](https://man7.org/linux/man-pages/man2/fspick.2.html) for more info on this syscall.
        fspick = 5433,
        /// See [pidfd_open(2)](https://man7.org/linux/man-pages/man2/pidfd_open.2.html) for more info on this syscall.
        pidfd_open = 5434,
        /// See [clone3(2)](https://man7.org/linux/man-pages/man2/clone3.2.html) for more info on this syscall.
        clone3 = 5435,
        /// See [close_range(2)](https://man7.org/linux/man-pages/man2/close_range.2.html) for more info on this syscall.
        close_range = 5436,
        /// See [openat2(2)](https://man7.org/linux/man-pages/man2/openat2.2.html) for more info on this syscall.
        openat2 = 5437,
        /// See [pidfd_getfd(2)](https://man7.org/linux/man-pages/man2/pidfd_getfd.2.html) for more info on this syscall.
        pidfd_getfd = 5438,
        /// See [faccessat2(2)](https://man7.org/linux/man-pages/man2/faccessat2.2.html) for more info on this syscall.
        faccessat2 = 5439,
        /// See [process_madvise(2)](https://man7.org/linux/man-pages/man2/process_madvise.2.html) for more info on this syscall.
        process_madvise = 5440,
        /// See [epoll_pwait2(2)](https://man7.org/linux/man-pages/man2/epoll_pwait2.2.html) for more info on this syscall.
        epoll_pwait2 = 5441,
        /// See [mount_setattr(2)](https://man7.org/linux/man-pages/man2/mount_setattr.2.html) for more info on this syscall.
        mount_setattr = 5442,
        /// See [quotactl_fd(2)](https://man7.org/linux/man-pages/man2/quotactl_fd.2.html) for more info on this syscall.
        quotactl_fd = 5443,
        /// See [landlock_create_ruleset(2)](https://man7.org/linux/man-pages/man2/landlock_create_ruleset.2.html) for more info on this syscall.
        landlock_create_ruleset = 5444,
        /// See [landlock_add_rule(2)](https://man7.org/linux/man-pages/man2/landlock_add_rule.2.html) for more info on this syscall.
        landlock_add_rule = 5445,
        /// See [landlock_restrict_self(2)](https://man7.org/linux/man-pages/man2/landlock_restrict_self.2.html) for more info on this syscall.
        landlock_restrict_self = 5446,
        /// See [process_mrelease(2)](https://man7.org/linux/man-pages/man2/process_mrelease.2.html) for more info on this syscall.
        process_mrelease = 5448,
        /// See [futex_waitv(2)](https://man7.org/linux/man-pages/man2/futex_waitv.2.html) for more info on this syscall.
        futex_waitv = 5449,
        /// See [cachestat(2)](https://man7.org/linux/man-pages/man2/cachestat.2.html) for more info on this syscall.
        cachestat = 5451,
        /// See [fchmodat2(2)](https://man7.org/linux/man-pages/man2/fchmodat2.2.html) for more info on this syscall.
        fchmodat2 = 5452,
        /// See [map_shadow_stack(2)](https://man7.org/linux/man-pages/man2/map_shadow_stack.2.html) for more info on this syscall.
        map_shadow_stack = 5453,
        /// See [futex_wake(2)](https://man7.org/linux/man-pages/man2/futex_wake.2.html) for more info on this syscall.
        futex_wake = 5454,
        /// See [futex_wait(2)](https://man7.org/linux/man-pages/man2/futex_wait.2.html) for more info on this syscall.
        futex_wait = 5455,
        /// See [futex_requeue(2)](https://man7.org/linux/man-pages/man2/futex_requeue.2.html) for more info on this syscall.
        futex_requeue = 5456,
        /// See [statmount(2)](https://man7.org/linux/man-pages/man2/statmount.2.html) for more info on this syscall.
        statmount = 5457,
        /// See [listmount(2)](https://man7.org/linux/man-pages/man2/listmount.2.html) for more info on this syscall.
        listmount = 5458,
        /// See [lsm_get_self_attr(2)](https://man7.org/linux/man-pages/man2/lsm_get_self_attr.2.html) for more info on this syscall.
        lsm_get_self_attr = 5459,
        /// See [lsm_set_self_attr(2)](https://man7.org/linux/man-pages/man2/lsm_set_self_attr.2.html) for more info on this syscall.
        lsm_set_self_attr = 5460,
        /// See [lsm_list_modules(2)](https://man7.org/linux/man-pages/man2/lsm_list_modules.2.html) for more info on this syscall.
        lsm_list_modules = 5461,
        /// See [mseal(2)](https://man7.org/linux/man-pages/man2/mseal.2.html) for more info on this syscall.
        mseal = 5462,
        /// See [setxattrat(2)](https://man7.org/linux/man-pages/man2/setxattrat.2.html) for more info on this syscall.
        setxattrat = 5463,
        /// See [getxattrat(2)](https://man7.org/linux/man-pages/man2/getxattrat.2.html) for more info on this syscall.
        getxattrat = 5464,
        /// See [listxattrat(2)](https://man7.org/linux/man-pages/man2/listxattrat.2.html) for more info on this syscall.
        listxattrat = 5465,
        /// See [removexattrat(2)](https://man7.org/linux/man-pages/man2/removexattrat.2.html) for more info on this syscall.
        removexattrat = 5466,
        /// See [open_tree_attr(2)](https://man7.org/linux/man-pages/man2/open_tree_attr.2.html) for more info on this syscall.
        open_tree_attr = 5467,
    }
    LAST: open_tree_attr;
}
