!{\src2tex{textfont=tt}}
!!****f* ABINIT/int_ang
!! NAME
!! int_ang
!!
!! FUNCTION
!! routine for evaluation of angular part for <phi_i|nabla|phi_j> and <tphi_i|nabla|tphi_j>
!! Modification 02/06 VR
!! COPYRIGHT
!! Copyright (C) 2005-2007 ABINIT group (VR)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!
!!
!! OUTPUT
!!  ang_phipphj :: angular part for <phi_i|nabla|phi_j> and <tphi_i|nabla|tphi_j>
!!  ang_phipphj(i,j,1)=\int sin\theta cos\phi Si Sj d\omega
!!  ang_phipphj(i,j,2)=\int cos\theta cos\phi Si \frac{d}{d\theta}Sj d\Omega
!!  ang_phipphj(i,j,3)=\int -sin\phi  Si \frac{d}{d\phi}Sj d\Omega
!!  ang_phipphj(i,j,4)=\int sin\theta sin\phi Si Sj d\Omega
!!  ang_phipphj(i,j,5)=\int cos\theta sin\phi Si \frac{d}{d\theta}Sj d\Omega
!!  ang_phipphj(i,j,6)=\int cos\phi Si \frac{d}{d\phi}Sj d\Omega
!!  ang_phipphj(i,j,7)=\int cos\theta  Si Sj d\Omega
!!  ang_phipphj(i,j,8)=\int -sin\theta Si \frac{d}{d\theta}Sj d\Omega
!!
!! SIDE EFFECTS
!!  (only writing, printing)
!!
!! NOTES
!!
!! PARENTS
!!      optics_paw
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

 subroutine int_ang(ang_phipphj)

 use defs_basis
 use defs_datatypes

 implicit none

!Arguments ------------------------------------
!arrays
 real(dp) :: ang_phipphj(16,16,8)

!Local variables-------------------------------

! ************************************************************************
!
!DEBUG
! write(*,*)' int_ang : enter'
!ENDDEBUG

 ang_phipphj=zero
!
 ang_phipphj(1,2,4)=one/sqrt(three)
 ang_phipphj(1,3,7)=one/sqrt(three)
 ang_phipphj(1,4,1)=one/sqrt(three)
 ang_phipphj(2,1,4)=one/sqrt(three)
 ang_phipphj(2,5,1)=one/sqrt(five)
 ang_phipphj(2,6,7)=one/sqrt(five)
 ang_phipphj(2,7,4)=-one/sqrt(15._dp)
 ang_phipphj(2,9,4)=-one/sqrt(five)
 ang_phipphj(3,1,7)=one/sqrt(three)
 ang_phipphj(3,6,4)=one/sqrt(five)
 ang_phipphj(3,7,7)=two/sqrt(15._dp)
 ang_phipphj(3,8,1)=one/sqrt(five)
 ang_phipphj(4,1,1)=one/sqrt(three)
 ang_phipphj(4,5,4)=one/sqrt(five)
 ang_phipphj(4,7,1)=-one/sqrt(15._dp)
 ang_phipphj(4,8,7)=one/sqrt(five)
 ang_phipphj(4,9,1)=one/sqrt(five)
 ang_phipphj(5,2,1)=one/sqrt(five)
 ang_phipphj(5,4,4)=one/sqrt(five)
 ang_phipphj(6,2,7)=one/sqrt(five)
 ang_phipphj(6,3,4)=one/sqrt(five)
 ang_phipphj(7,2,4)=-one/sqrt(15._dp)
 ang_phipphj(7,3,7)=two/sqrt(15._dp)
 ang_phipphj(7,4,1)=-one/sqrt(15._dp)
 ang_phipphj(8,3,1)=one/sqrt(five)
 ang_phipphj(8,4,7)=one/sqrt(five)
 ang_phipphj(9,2,4)=-one/sqrt(five)
 ang_phipphj(9,4,1)=one/sqrt(five)
!
 ang_phipphj(1,2,5)=one/two/sqrt(three)
 ang_phipphj(1,3,8)=two/sqrt(three)
 ang_phipphj(1,4,2)=one/two/sqrt(three)
 ang_phipphj(2,5,2)=one/two/sqrt(five)
 ang_phipphj(2,6,8)=three/sqrt(five)
 ang_phipphj(2,7,5)=-sqrt(three/five)
 ang_phipphj(2,9,5)=-one/two/sqrt(five)
 ang_phipphj(3,6,5)=one/two/sqrt(five)
 ang_phipphj(3,7,8)=two/sqrt(three)
 ang_phipphj(3,8,2)=one/two/sqrt(five)
 ang_phipphj(4,5,5)=one/two/sqrt(five)
 ang_phipphj(4,7,2)=-sqrt(three/five)
 ang_phipphj(4,8,8)=three/sqrt(five)
 ang_phipphj(4,9,2)=one/two/sqrt(five)
 ang_phipphj(5,2,2)=one/four/sqrt(five)
 ang_phipphj(5,4,5)=one/four/sqrt(five)
 ang_phipphj(6,2,8)=-one/sqrt(five)
 ang_phipphj(6,3,5)=-one/sqrt(five)
 ang_phipphj(7,2,5)=one/sqrt(15.0_dp)
 ang_phipphj(7,3,8)=-two/sqrt(15.0_dp)
 ang_phipphj(7,4,2)=one/sqrt(15.0_dp)
 ang_phipphj(8,3,2)=-one/sqrt(five)
 ang_phipphj(8,4,8)=one/sqrt(five)
 ang_phipphj(9,2,5)=-one/four/sqrt(five)
 ang_phipphj(9,4,2)=one/four/sqrt(five)
!
 ang_phipphj(1,2,6)=sqrt(three)/two
 ang_phipphj(1,4,3)=sqrt(three)/two
 ang_phipphj(2,5,3)=sqrt(five)/two
 ang_phipphj(2,9,6)=-sqrt(five)/two
 ang_phipphj(3,6,6)=sqrt(five)/two
 ang_phipphj(3,8,3)=sqrt(five)/two
 ang_phipphj(4,5,6)=sqrt(five)/two
 ang_phipphj(4,9,3)=sqrt(five)/two
 ang_phipphj(5,2,3)=-sqrt(five)/four
 ang_phipphj(5,4,6)=-sqrt(five)/four
 ang_phipphj(9,2,6)=sqrt(five)/four
 ang_phipphj(9,4,3)=-sqrt(five)/four

!DEBUG
!write(6,*)' int_ang : exit '
!stop
!ENDDEBUG

 end subroutine int_ang
!!***
