#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Abinit Post Process Application
author: Martin Alexandre
last edited: May 2013
"""

import sys,os,commands,time
import string, math
from numpy import array,sqrt,zeros,conjugate,arange,linspace,exp,log,sin,dot,degrees,arccos
from numpy.fft import rfft,fft, ifft
from numpy.linalg import inv

#Fortran Code
import fortran.positions as posit



#----------------------------------------------------------------#
#-------------------PERIODIC BOUNDARY POSITIONS------------------#
#----------------------------------------------------------------#

class PBC:

    def __init__(self,pfile, No_Windows=False):

        # This class aim is to calculate the positions of each atom using periodic boundary condistions
        # the parameters are :
        #    - pfile  is the output file (ascii/netcdf)

        file = pfile
        
        pos = file.getPos()            # position of atom

        acell = file.getAcell()        #acell
        a = acell[0,0]
        b = acell[0,1]
        c = acell[0,2]

        typat = file.getTypat()              # Type of particule
        ntypat = max(typat)
            
        nbtime =  len(pos)                    # final step

        if ntypat == 1:

            indexAtom1 = array([i for i in enumerate(typat)],dtype=int) + 1    
            
            self.a = posit.atom_sym(nbtime,pos,a,b,c,indexAtom1)

        elif ntypat == 2:

            indexAtom1 = array([i for i,x in enumerate(typat) if x == 1],dtype=int) + 1   

            indexAtom2 = array([i for i,x in enumerate(typat) if x == 2],dtype=int) + 1   
            
            self.a = posit.atom_sym(nbtime,pos,a,b,c,indexAtom1)

            self.b = posit.atom_sym(nbtime,pos,a,b,c,indexAtom2)

    def getx1(self):
        return self.a[0]

    def gety1(self):
        return self.a[1]
            
    def getz1(self):
        return self.a[2]

    def getx2(self):
        return self.b[0]

    def gety2(self):
        return self.b[1]
    
    def getz2(self):
        return self.b[2]





#------------------------------------------------------#
#-------------------Average_Positions------------------#
#------------------------------------------------------#

class Average:

    def __init__(self,pfile, No_Windows=False):

        # This class aim is to calculate the Average position of each atom
        # the parameters are :
        #    - pfile  is the output file (ascii/netcdf)

        file = pfile
        
        pos = file.getPos()            # position of atom

        typat = file.getTypat()              # Type of particule
        ntypat = max(typat)           

        nbtime =  len(pos)                    # final step

        if ntypat == 1:

            indexAtom1 = array([i for i in enumerate(typat)],dtype=int) + 1    
            
            self.a = posit.atom_ave(nbtime,pos,indexAtom1)

        elif ntypat == 2:

            indexAtom1 = array([i for i,x in enumerate(typat) if x == 1],dtype=int) + 1   

            indexAtom2 = array([i for i,x in enumerate(typat) if x == 2],dtype=int) + 1   
            
            self.a = posit.atom_ave(nbtime,pos,indexAtom1)

            self.b = posit.atom_ave(nbtime,pos,indexAtom2)

    def getx1(self):
        return self.a[0]
        
    def gety1(self):
        return self.a[1]
            
    def getz1(self):
        return self.a[2]

    def getx2(self):
        return self.b[0]

    def gety2(self):
        return self.b[1]
    
    def getz2(self):
        return self.b[2]
