/*  File: rpcgnbk_sp.c
 *  Author: Jean Thierry-Mieg (mieg@kaa.cnrs_mop.fr)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1994
 * -------------------------------------------------------------------
 * Acedb is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * or see the on-line version at http://www.gnu.org/copyleft/gpl.txt
 * -------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@kaa.cnrs-mop.fr
 *
 * Description:
 * Exported functions:
 * HISTORY:
     from a first version by Peter Kocab
     edited by Bigwood & Co
 * Last edited: Jan 10 16:13 1996 (mieg)
 * Created: Fri Nov 18 16:42:20 1994 (mieg)
 *-------------------------------------------------------------------
 */

/* $Id: rpcgnbk_sp.c,v 1.8 2004/08/12 20:25:08 mieg Exp $ */

/* 
 * RPC_SVC_FG prevent forking on solaris
 * affects rpcgnbk_svc.c which is generated by rpcgen during make
 */

#define RPC_SVC_FG

unsigned long  rpc_port;
int rpc_socket;

#if defined (ALPHA ) || defined(HP)
#include <stdlib.h>
#include <string.h> /* needed to compile with cc on the alpha - srk */
#endif

#define main     my_run_rpc
#include "rpcgnbk_svc.c"
#undef  main

#include "regular.h"   /* must come after rpcgnbk_svc.c */
#include "array.h"

void  wait_for_client (u_long port, BOOL isDaemon)
{ rpc_port = port ;
  if (isDaemon)
    rpc_socket = 0;
  else
    rpc_socket = -1;
  my_run_rpc(0,0) ;
}

void closePortMap(void) {
 svc_unregister(RPC_GNBK,RPC_GNBK_VERS);
}

/*
** Remote version for "gnbk_server"
*/


extern Stack processQuery (char *cp) ;

#if defined(LINUX) || defined(OPTERON) || defined (DARWIN)
gnbk_reponse *gnbk_server_1_svc (gnbk_data *question, struct svc_req *rqstp)
#else
gnbk_reponse *gnbk_server_1 (gnbk_data *question, CLIENT *rqstp)
#endif
{ int nn ;
  Stack s ;
  static gnbk_reponse rr ; 
  char *cp ;

  /* free previous result */
  xdr_free((xdrproc_t )xdr_gnbk_reponse, (char*)&rr) ;
  s = processQuery (question->question) ;

  nn = s && stackMark(s) ? stackMark(s) : 60 ;
   /* stackMrk == 0 happens if we write to a file and are in the encore case */

  cp = malloc (nn + 1) ;
  if (cp)
    { *(cp + nn) = 0 ;
      if (nn &&  stackMark(s))
	memcpy (cp, stackText(s,0), nn) ;
      else if(nn)
	strcpy(cp,"// Sorry, broken connection, possibly due to client time out") ;
      else 
	strcpy(cp,"// ") ;
    }
  else
     { cp = malloc(300) ;
       sprintf(cp, "%s%d%s\n%s\n",
	       "//! Sorry, the answer is too long (",stackMark (s)," kilobytes),",
	       "//! I can t mallocate a sufficcient buffer." ) ;
       nn = strlen (cp) ;
    }
  rr.gnbk_reponse_u.res_data.reponse.reponse_val = cp ;
  rr.gnbk_reponse_u.res_data.reponse.reponse_len = nn ;
  rr.gnbk_reponse_u.res_data.question = malloc(5) ; *rr.gnbk_reponse_u.res_data.question = 0 ;
  return &rr ;
}

/********* end of file ********/

