/*
   Copyright (C) 2017 Montel Laurent <montel@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef ABSTRACTDISPLAYINFO_H
#define ABSTRACTDISPLAYINFO_H

#include "libimportwizard_export.h"
#include <QString>
class QWidget;

namespace MailImporter {
class Filter;
}

namespace LibImportWizard {
class LIBIMPORTWIZARD_EXPORT AbstractDisplayInfo
{
public:
    AbstractDisplayInfo();
    virtual ~AbstractDisplayInfo() = default;

    virtual void calendarImportError(const QString &log);
    virtual void settingsImportError(const QString &log);
    virtual void addressbookImportError(const QString &log);
    virtual void filterImportError(const QString &log);

    virtual void calendarImportInfo(const QString &log);
    virtual void settingsImportInfo(const QString &log);
    virtual void addressbookImportInfo(const QString &log);
    virtual void filterImportInfo(const QString &log);

    virtual QWidget *parentWidget() const;
    virtual void initializeFilter(MailImporter::Filter &filter);
};
}

#endif // ABSTRACTDISPLAYINFO_H
