/****************************************************************************************
 * Copyright (c) 2004 Michael Pyne <michael.pyne@kdemail.net>                           *
 * Copyright (c) 2006 Ian Monroe <ian@monroe.nu>                                        *
 *                                                                                      *
 * This program is free software; you can redistribute it and/or modify it under        *
 * the terms of the GNU General Public License as published by the Free Software        *
 * Foundation; either version 2 of the License, or (at your option) any later           *
 * version.                                                                             *
 *                                                                                      *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY      *
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A      *
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.             *
 *                                                                                      *
 * You should have received a copy of the GNU General Public License along with         *
 * this program.  If not, see <http://www.gnu.org/licenses/>.                           *
 ****************************************************************************************/

#ifndef DELETEDIALOG_H
#define DELETEDIALOG_H

#include "ui_deletedialogbase.h"

#include <QDialog>
#include <QUrl>

#include <QCheckBox>
#include <QLabel>

class KGuiItem;
class QLabel;

class DeleteDialogBase : public QWidget, public Ui::DeleteDialogBase
{
public:
    explicit DeleteDialogBase( QWidget *parent ) : QWidget( parent ) {
    setupUi( this );
  }
};


class DeleteWidget : public DeleteDialogBase
{
    Q_OBJECT

public:
    explicit DeleteWidget(QWidget *parent = nullptr);

    void setFiles(const QList<QUrl> &files);

protected Q_SLOTS:
    virtual void slotShouldDelete(bool shouldDelete);
};

class DeleteDialog : public QDialog
{
    Q_OBJECT

public:
    explicit DeleteDialog(QWidget *parent, const char *name = "delete_dialog");
    static bool showTrashDialog(QWidget* parent, const QList<QUrl> &files);

    bool confirmDeleteList(const QList<QUrl> &condemnedFiles);
    void setFiles(const QList<QUrl> &files);
    bool shouldDelete() const { return m_widget->ddShouldDelete->isChecked(); }

protected Q_SLOTS:
    virtual void accept();
    void slotShouldDelete(bool shouldDelete);

private:
    DeleteWidget *m_widget;
    KGuiItem m_trashGuiItem;
};

#endif

// vim: set et ts=4 sw=4:
