# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

from __future__ import absolute_import, division, print_function


__metaclass__ = type

from ansible_collections.junipernetworks.junos.plugins.modules import junos_bgp_global
from ansible_collections.junipernetworks.junos.tests.unit.compat.mock import patch
from ansible_collections.junipernetworks.junos.tests.unit.modules.utils import set_module_args

from .junos_module import TestJunosModule, load_fixture


class TestJunosBgp_globalModule(TestJunosModule):
    module = junos_bgp_global

    def setUp(self):
        super(TestJunosBgp_globalModule, self).setUp()

        self.mock_lock_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.junos.lock_configuration",
        )
        self.lock_configuration = self.mock_lock_configuration.start()

        self.mock_unlock_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.junos.unlock_configuration",
        )
        self.unlock_configuration = self.mock_unlock_configuration.start()

        self.mock_load_config = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.bgp_global.bgp_global.load_config",
        )
        self.load_config = self.mock_load_config.start()

        self.mock_commit_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.bgp_global.bgp_global.commit_configuration",
        )
        self.mock_commit_configuration = self.mock_commit_configuration.start()

        self.mock_execute_show_command = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.facts.bgp_global.bgp_global."
            "Bgp_globalFacts.get_device_data",
        )
        self.execute_show_command = self.mock_execute_show_command.start()

    def tearDown(self):
        super(TestJunosBgp_globalModule, self).tearDown()
        self.mock_load_config.stop()
        self.mock_lock_configuration.stop()
        self.mock_unlock_configuration.stop()
        self.mock_commit_configuration.stop()
        self.mock_execute_show_command.stop()

    def load_fixtures(
        self,
        commands=None,
        format="text",
        changed=False,
        filename=None,
    ):
        def load_from_file(*args, **kwargs):
            if filename:
                output = load_fixture(filename)
            else:
                output = load_fixture("junos_bgp_global_config.cfg")
            return output

        self.execute_show_command.side_effect = load_from_file

    def test_junos_bgp_global_merged(self):
        set_module_args(
            dict(
                config=dict(
                    damping=True,
                    description="This is configured with Junos_bgp resource module",
                    preference="2",
                    bfd_liveness_detection=dict(
                        minimum_receive_interval=4,
                        multiplier=10,
                        no_adaptation=True,
                        version="automatic",
                    ),
                ),
                state="merged",
            ),
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:bgp><nc:damping/><nc:description>This is configured with Junos_bgp resource module</nc:description>"
            "<nc:preference>2</nc:preference><nc:bfd-liveness-detection>"
            "<nc:minimum-receive-interval>4</nc:minimum-receive-interval>"
            "<nc:multiplier>10</nc:multiplier>"
            "<nc:no-adaptation/><nc:version>automatic</nc:version></nc:bfd-liveness-detection></nc:bgp></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>',
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_bgp_global_merged_idempotent(self):
        set_module_args(
            dict(
                config=dict(
                    accept_remote_nexthop=True,
                    advertise_from_main_vpn_tables=True,
                    advertise_inactive=True,
                    as_number="65432",
                    authentication_algorithm="md5",
                    bgp_error_tolerance=dict(malformed_route_limit=30000000),
                    damping=True,
                    description="This is configured with Junos_bgp resource module",
                    hold_time=5,
                    holddown_all_stale_labels=True,
                    log_updown=True,
                    no_advertise_peer_as=True,
                    no_aggregator_id=True,
                    out_delay=10,
                    preference="2",
                ),
                state="merged",
            ),
        )
        result = self.execute_module(changed=True)
        self.assertEqual(result["before"], result["after"])

    def test_junos_bgp_global_replaced(self):
        """
        :return:
        """
        set_module_args(
            dict(
                config=dict(
                    accept_remote_nexthop=True,
                    advertise_from_main_vpn_tables=True,
                    advertise_inactive=True,
                    as_number="65432",
                    authentication_algorithm="md5",
                    bgp_error_tolerance=dict(malformed_route_limit=20000000),
                    damping=True,
                    description="This is configured with Junos_bgp resource module",
                    groups=[
                        dict(name="internal", out_delay=22),
                        dict(name="external", out_delay=20),
                    ],
                    hold_time=4,
                    holddown_all_stale_labels=True,
                    log_updown=True,
                    keep="all",
                    mtu_discovery=True,
                    no_precision_timers=True,
                    no_advertise_peer_as=True,
                    no_aggregator_id=True,
                    out_delay=10,
                    preference="2",
                ),
                state="replaced",
            ),
        )

        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            '<nc:bgp><nc:accept-remote-nexthop delete="delete"/>'
            '<nc:add-path-display-ipv4-address delete="delete"/>'
            '<nc:advertise-bgp-static delete="delete"/>'
            '<nc:advertise-external delete="delete"/>'
            '<nc:advertise-from-main-vpn-tables delete="delete"/>'
            '<nc:advertise-inactive delete="delete"/>'
            '<nc:advertise-peer-as delete="delete"/>'
            '<nc:authentication-algorithm delete="delete"/>'
            '<nc:authentication-key delete="delete"/>'
            '<nc:authentication-key-chain delete="delete"/>'
            '<nc:bfd-liveness-detection delete="delete"/>'
            '<nc:bgp-error-tolerance delete="delete"/><nc:bmp delete="delete"/>'
            '<nc:group delete="delete"/><nc:cluster delete="delete"/>'
            '<nc:damping delete="delete"/><nc:description delete="delete"/>'
            '<nc:disable delete="delete"/><nc:egress-te-sid-stats delete="delete"/>'
            '<nc:enforce-first-as delete="delete"/><nc:export delete="delete"/>'
            '<nc:forwarding-context delete="delete"/><nc:hold-time delete="delete"/>'
            '<nc:holddown-all-stale-labels delete="delete"/><nc:import delete="delete"/>'
            '<nc:include-mp-next-hop delete="delete"/><nc:ipsec-sa delete="delete"/>'
            '<nc:keep delete="delete"/><nc:local-address delete="delete"/>'
            '<nc:local-interface delete="delete"/><nc:local-preference delete="delete"/>'
            '<nc:log-updown delete="delete"/><nc:mtu-discovery delete="delete"/>'
            '<nc:no-advertise-peer-as delete="delete"/><nc:no-aggregator-id delete="delete"/>'
            '<nc:no-client-reflect delete="delete"/><nc:no-precision-timers delete="delete"/>'
            '<nc:passive delete="delete"/><nc:peer-as delete="delete"/>'
            '<nc:precision-timers delete="delete"/><nc:preference delete="delete"/>'
            '<nc:out-delay delete="delete"/><nc:rfc6514-compliant-safi129 delete="delete"/>'
            '<nc:route-server-client delete="delete"/><nc:send-addpath-optimization delete="delete"/>'
            '<nc:sr-preference-override delete="delete"/>'
            '<nc:stale-labels-holddown-period delete="delete"/><nc:tcp-aggressive-transmission delete="delete"/>'
            '<nc:tcp-mss delete="delete"/><nc:ttl delete="delete"/>'
            '<nc:unconfigured-peer-graceful-restart delete="delete"/>'
            '<nc:vpn-apply-export delete="delete"/></nc:bgp><nc:bgp>'
            "<nc:accept-remote-nexthop/><nc:advertise-from-main-vpn-tables/>"
            "<nc:advertise-inactive/><nc:damping/><nc:holddown-all-stale-labels/>"
            "<nc:log-updown/><nc:mtu-discovery/><nc:no-advertise-peer-as/>"
            "<nc:no-aggregator-id/><nc:no-precision-timers/>"
            "<nc:authentication-algorithm>md5</nc:authentication-algorithm>"
            "<nc:description>This is configured with Junos_bgp resource module</nc:description>"
            "<nc:hold-time>4</nc:hold-time><nc:keep>all</nc:keep><nc:preference>2</nc:preference>"
            "<nc:out-delay>10</nc:out-delay><nc:bgp-error-tolerance>"
            "<nc:malformed-route-limit>20000000</nc:malformed-route-limit>"
            "</nc:bgp-error-tolerance><nc:group><nc:name>internal</nc:name>"
            "<nc:out-delay>22</nc:out-delay></nc:group><nc:group><nc:name>external</nc:name>"
            "<nc:out-delay>20</nc:out-delay></nc:group></nc:bgp></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            '<nc:autonomous-system delete="delete"/>'
            "<nc:autonomous-system>65432</nc:autonomous-system></nc:routing-options>",
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_bgp_global_replaced_idempotent(self):
        set_module_args(
            dict(
                config=dict(
                    accept_remote_nexthop=True,
                    advertise_from_main_vpn_tables=True,
                    advertise_inactive=True,
                    as_number="65432",
                    authentication_algorithm="md5",
                    bgp_error_tolerance=dict(malformed_route_limit=30000000),
                    damping=True,
                    description="This is configured with Junos_bgp resource module",
                    hold_time=5,
                    holddown_all_stale_labels=True,
                    log_updown=True,
                    no_advertise_peer_as=True,
                    no_aggregator_id=True,
                    out_delay=10,
                    preference="2",
                ),
                state="replaced",
            ),
        )
        result = self.execute_module(changed=True)
        self.assertEqual(result["before"], result["after"])

    def test_junos_bgp_global_rendered(self):
        """
        :return:
        """
        set_module_args(
            dict(
                config=dict(
                    description="This is configured with Junos_bgp resource module",
                    groups=[dict(name="internal", out_delay=22)],
                    hold_time=4,
                    holddown_all_stale_labels=True,
                    include_mp_next_hop=True,
                    log_updown=True,
                    loops=5,
                    keep="all",
                    mtu_discovery=True,
                    out_delay=10,
                    preference="2",
                ),
                state="rendered",
            ),
        )

        rendered = (
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:bgp>'
            "<nc:holddown-all-stale-labels/><nc:include-mp-next-hop/><nc:log-updown/>"
            "<nc:mtu-discovery/>"
            "<nc:description>This is configured with Junos_bgp resource module</nc:description>"
            "<nc:hold-time>4</nc:hold-time><nc:keep>all</nc:keep><nc:preference>2</nc:preference>"
            "<nc:out-delay>10</nc:out-delay><nc:group>"
            "<nc:name>internal</nc:name><nc:out-delay>22</nc:out-delay>"
            "</nc:group></nc:bgp></nc:protocols>"
        )
        result = self.execute_module(changed=False)
        self.assertEqual(sorted(result["rendered"]), sorted(rendered))

    def test_junos_bgp_global_rendered_empty(self):
        """
        :return:
        """
        set_module_args(dict(config=dict(description=""), state="rendered"))
        rendered = ""
        result = self.execute_module(changed=False)
        self.assertEqual(sorted(result["rendered"]), sorted(rendered))

    def test_junos_bgp_global_gathered(self):
        """
        :return:
        """
        set_module_args(dict(state="gathered"))
        result = self.execute_module(changed=False)
        gather_dict = {
            "accept_remote_nexthop": True,
            "advertise_from_main_vpn_tables": True,
            "advertise_inactive": True,
            "as_number": "65432",
            "authentication_algorithm": "md5",
            "bgp_error_tolerance": {"malformed_route_limit": "30000000"},
            "damping": True,
            "description": "This is configured with Junos_bgp resource module",
            "hold_time": "5",
            "holddown_all_stale_labels": True,
            "log_updown": True,
            "no_advertise_peer_as": True,
            "no_aggregator_id": True,
            "out_delay": "10",
            "preference": "2",
        }
        self.assertEqual(sorted(gather_dict), sorted(result["gathered"]))

    def test_junos_bgp_global_parsed(self):
        parsed_str = """
            <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
                <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
                    <version>18.4R1-S2.4</version>
                    <protocols>
                        <bgp>
                            <advertise-from-main-vpn-tables />
                            <holddown-all-stale-labels />
                            <description>This is configured with Junos_bgp resource module</description>
                            <accept-remote-nexthop />
                            <preference>2</preference>
                            <hold-time>5</hold-time>
                            <advertise-inactive />
                            <no-advertise-peer-as />
                            <no-aggregator-id />
                            <out-delay>10</out-delay>
                            <log-updown />
                            <damping />
                            <bgp-error-tolerance>
                            <malformed-route-limit>30000000</malformed-route-limit>
                            </bgp-error-tolerance>
                            <authentication-algorithm>md5</authentication-algorithm>
                        </bgp>
                    </protocols>
                    <routing-options>
                        <static>
                            <route>
                            <name>172.16.17.0/24</name>
                            <discard />
                            </route>
                        </static>
                        <router-id>10.200.16.75</router-id>
                        <autonomous-system>
                            <as-number>65432</as-number>
                        </autonomous-system>
                    </routing-options>
                </configuration>
            </rpc-reply>
        """
        set_module_args(dict(running_config=parsed_str, state="parsed"))
        result = self.execute_module(changed=False)
        parsed_dict = {
            "accept_remote_nexthop": "True",
            "advertise_from_main_vpn_tables": "True",
            "advertise_inactive": "True",
            "as_number": "65534",
            "authentication_algorithm": "md5",
            "bgp_error_tolerance": {"malformed_route_limit": "30000000"},
            "damping": "True",
            "description": "This is configured with Junos_bgp resource module",
            "hold_time": "5",
            "holddown_all_stale_labels": "True",
            "log_updown": "true",
            "no_advertise_peer_as": "true",
            "no_aggregator_id": "true",
            "out_delay": "10",
            "preference": "2",
        }
        self.assertEqual(sorted(parsed_dict), sorted(result["parsed"]))

    def test_junos_bgp_global_parsed_empty_running_config(self):
        set_module_args(dict(running_config="", state="parsed"))
        try:
            self.execute_module(changed=False)
        except Exception:
            pass

    def test_junos_bgp_global_delete(self):
        set_module_args(dict(config=dict(), state="deleted"))

        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            '<nc:bgp><nc:accept-remote-nexthop delete="delete"/><nc:add-path-display-ipv4-address delete="delete"/>'
            '<nc:advertise-bgp-static delete="delete"/><nc:advertise-external delete="delete"/>'
            '<nc:advertise-from-main-vpn-tables delete="delete"/><nc:advertise-inactive delete="delete"/>'
            '<nc:advertise-peer-as delete="delete"/><nc:authentication-algorithm delete="delete"/>'
            '<nc:authentication-key delete="delete"/><nc:authentication-key-chain delete="delete"/>'
            '<nc:bfd-liveness-detection delete="delete"/><nc:bgp-error-tolerance delete="delete"/>'
            '<nc:bmp delete="delete"/><nc:group delete="delete"/><nc:cluster delete="delete"/>'
            '<nc:damping delete="delete"/><nc:description delete="delete"/><nc:disable delete="delete"/>'
            '<nc:egress-te-sid-stats delete="delete"/><nc:enforce-first-as delete="delete"/>'
            '<nc:export delete="delete"/><nc:forwarding-context delete="delete"/>'
            '<nc:hold-time delete="delete"/><nc:holddown-all-stale-labels delete="delete"/>'
            '<nc:import delete="delete"/><nc:include-mp-next-hop delete="delete"/>'
            '<nc:ipsec-sa delete="delete"/><nc:keep delete="delete"/><nc:local-address delete="delete"/>'
            '<nc:local-interface delete="delete"/>'
            '<nc:local-preference delete="delete"/><nc:log-updown delete="delete"/>'
            '<nc:mtu-discovery delete="delete"/><nc:no-advertise-peer-as delete="delete"/>'
            '<nc:no-aggregator-id delete="delete"/><nc:no-client-reflect delete="delete"/>'
            '<nc:no-precision-timers delete="delete"/><nc:passive delete="delete"/>'
            '<nc:peer-as delete="delete"/><nc:precision-timers delete="delete"/>'
            '<nc:preference delete="delete"/><nc:out-delay delete="delete"/>'
            '<nc:rfc6514-compliant-safi129 delete="delete"/><nc:route-server-client delete="delete"/>'
            '<nc:send-addpath-optimization delete="delete"/><nc:sr-preference-override delete="delete"/>'
            '<nc:stale-labels-holddown-period delete="delete"/><nc:tcp-aggressive-transmission delete="delete"/>'
            '<nc:tcp-mss delete="delete"/><nc:ttl delete="delete"/>'
            '<nc:unconfigured-peer-graceful-restart delete="delete"/>'
            '<nc:vpn-apply-export delete="delete"/>'
            "</nc:bgp></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            '<nc:autonomous-system delete="delete"/></nc:routing-options>',
        ]

        result = self.execute_module(changed=True)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_bgp_global_delete_purged(self):
        set_module_args(dict(config=dict(), state="purged"))

        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:bgp delete="delete"/></nc:protocols>',
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:autonomous-system delete="delete"/></nc:routing-options>',
        ]
        result = self.execute_module(changed=True)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_bgp_global_merged_routing_options(self):
        """
        configure routing-options attributes:
         - loops
         - as_number
         - asdot_notation
        """
        set_module_args(
            dict(
                config=dict(as_number="65432", loops=5, asdot_notation=True),
                state="merged",
            ),
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:bgp/></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:autonomous-system>65432<nc:loops>5</nc:loops><nc:asdot-notation/></nc:autonomous-system>"
            "</nc:routing-options>",
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_bgp_global_merge_groups(self):
        """
        description: configure groups attributes:
        """
        set_module_args(
            dict(
                config=dict(
                    groups=[
                        dict(
                            name="internal",
                            neighbors=[
                                dict(
                                    neighbor_address="11.11.11.11",
                                    peer_as="65534",
                                    out_delay=11,
                                    accept_remote_nexthop=True,
                                ),
                                dict(
                                    neighbor_address="11.11.11.12",
                                    peer_as="65534",
                                    out_delay=12,
                                    accept_remote_nexthop=True,
                                ),
                            ],
                        ),
                    ],
                ),
                state="merged",
            ),
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:bgp><nc:group><nc:name>internal</nc:name>"
            "<nc:neighbor><nc:name>11.11.11.11</nc:name>"
            "<nc:accept-remote-nexthop/><nc:peer-as>65534</nc:peer-as>"
            "<nc:out-delay>11</nc:out-delay></nc:neighbor>"
            "<nc:neighbor><nc:name>11.11.11.12</nc:name><nc:accept-remote-nexthop/>"
            "<nc:peer-as>65534</nc:peer-as><nc:out-delay>12</nc:out-delay></nc:neighbor></nc:group>"
            "</nc:bgp></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>',
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_bgp_global_merged_advertise_bgp_static(self):
        """
        configure advertise_bgp_static attributes:
        """
        set_module_args(
            dict(
                config=dict(advertise_bgp_static=dict(policy="static-to-bgp")),
                state="merged",
            ),
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:bgp><nc:advertise-bgp-static><nc:policy>static-to-bgp</nc:policy>"
            "</nc:advertise-bgp-static>"
            "</nc:bgp></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>',
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_bgp_global_merged_advertise_external(self):
        """
        configure advertise_external attributes:
        """
        set_module_args(
            dict(
                config=dict(
                    advertise_external=dict(set=True, conditional=True),
                ),
                state="merged",
            ),
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:bgp><nc:advertise-external><nc:conditional/></nc:advertise-external>"
            "</nc:bgp></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>',
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_bgp_global_merged_bfd_liveness_detection(self):
        """
        configure bfd_liveness_detection attributes:
        """
        set_module_args(
            dict(
                config=dict(
                    bfd_liveness_detection=dict(
                        minimum_receive_interval=8,
                        no_adaptation=True,
                        authentication=dict(
                            algorithm="keyed-md5",
                            key_chain="junos",
                            loose_check=True,
                        ),
                        detection_time=dict(threshold=1000000),
                        transmit_interval=dict(
                            minimum_interval=20,
                            threshold=100000,
                        ),
                        holddown_interval=20,
                        multiplier=20,
                        session_mode="multihop",
                        version="1",
                    ),
                ),
                state="merged",
            ),
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:bgp><nc:bfd-liveness-detection><nc:authentication>"
            "<nc:algorithm>keyed-md5</nc:algorithm><nc:key-chain>junos</nc:key-chain>"
            "<nc:loose-check/></nc:authentication><nc:detection-time>"
            "<nc:threshold>1000000</nc:threshold></nc:detection-time><nc:transmit-interval>"
            "<nc:minimum-interval>20</nc:minimum-interval></nc:transmit-interval>"
            "<nc:holddown-interval>20</nc:holddown-interval><nc:minimum-receive-interval>8</nc:minimum-receive-interval>"
            "<nc:multiplier>20</nc:multiplier><nc:no-adaptation/>"
            "<nc:session-mode>multihop</nc:session-mode>"
            "<nc:version>1</nc:version></nc:bfd-liveness-detection>"
            "</nc:bgp></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>',
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_bgp_global_merged_bgp_error_tolerance(self):
        """
        configure bgp_error_tolerance attributes:
        """
        set_module_args(
            dict(
                config=dict(
                    bgp_error_tolerance=dict(
                        set=True,
                        malformed_route_limit=10,
                        malformed_update_log_interval=15,
                        no_malformed_route_limit=True,
                    ),
                ),
                state="merged",
            ),
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:bgp><nc:bgp-error-tolerance><nc:malformed-route-limit>10</nc:malformed-route-limit>"
            "<nc:malformed-update-log-interval>15</nc:malformed-update-log-interval>"
            "<nc:no-malformed-route-limit/></nc:bgp-error-tolerance>"
            "</nc:bgp></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>',
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_bgp_global_merged_bmp(self):
        """
        configure bmp attributes:
        """
        set_module_args(
            dict(
                config=dict(
                    bmp=dict(
                        monitor=True,
                        route_monitoring=dict(
                            none=True,
                            post_policy=True,
                            post_policy_exclude_non_eligible=True,
                            pre_policy=True,
                            post_policy_exclude_non_feasible=True,
                        ),
                    ),
                ),
                state="merged",
            ),
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:bgp><nc:bmp><nc:monitor>enable</nc:monitor><nc:route-monitoring><nc:none/>"
            "<nc:post-policy><nc:exclude-non-eligible/></nc:post-policy></nc:route-monitoring></nc:bmp>"
            "</nc:bgp></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>',
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_bgp_global_merged_bmp_2(self):
        """
        configure bmp attributes:
        """
        set_module_args(
            dict(
                config=dict(
                    bmp=dict(
                        monitor=False,
                        route_monitoring=dict(
                            none=False,
                            post_policy=False,
                            post_policy_exclude_non_eligible=False,
                            pre_policy=False,
                            post_policy_exclude_non_feasible=False,
                        ),
                    ),
                ),
                state="merged",
            ),
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:bgp><nc:bmp><nc:monitor>disable</nc:monitor><nc:route-monitoring/></nc:bmp>"
            "</nc:bgp></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>',
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_bgp_global_merged_egress_te(self):
        """
        configure egress_te attributes:
        """
        set_module_args(
            dict(
                config=dict(egress_te=dict(set=True, backup_path="sample")),
                state="merged",
            ),
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:bgp><nc:egress-te><nc:backup-path>sample</nc:backup-path></nc:egress-te>"
            "</nc:bgp></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>',
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_bgp_global_merged_egress_te_backup_paths(self):
        """
        configure egress_te_backup_paths attributes:
        """
        set_module_args(
            dict(
                config=dict(
                    egress_te_backup_paths=dict(
                        templates=[
                            dict(
                                path_name="temp",
                                ip_forward=dict(set=True, rti_name="sample"),
                                peers=["10.10.10.10", "11.11.11.11"],
                                remote_nexthop="11.1.1.1",
                            ),
                        ],
                    ),
                ),
                state="merged",
            ),
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:bgp><nc:egress-te-backup-paths><nc:template><nc:name>temp</nc:name><nc:peer>"
            "<nc:name>10.10.10.10</nc:name></nc:peer><nc:peer><nc:name>11.11.11.11</nc:name>"
            "</nc:peer><nc:remote-nexthop>11.1.1.1</nc:remote-nexthop><nc:ip-forward/>"
            "</nc:template></nc:egress-te-backup-paths>"
            "</nc:bgp></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>',
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_bgp_global_merged_groups_allow(self):
        """
        configure allow attributes:
        """
        set_module_args(
            dict(
                config=dict(
                    groups=[dict(name="internal", allow=["all", "1.1.1.0/24"])],
                ),
                state="merged",
            ),
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:bgp><nc:group><nc:name>internal</nc:name><nc:allow>all</nc:allow>"
            "<nc:allow>1.1.1.0/24</nc:allow></nc:group>"
            "</nc:bgp></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>',
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_bgp_global_merged_optimal_route_reflection(self):
        """
        configure optimal_route_reflection attributes:
        """
        set_module_args(
            dict(
                config=dict(
                    groups=[
                        dict(
                            name="internal",
                            optimal_route_reflection=dict(
                                igp_backup="test_igp",
                                igp_primary="test_primary",
                            ),
                        ),
                    ],
                ),
                state="merged",
            ),
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:bgp><nc:group><nc:name>internal</nc:name><nc:optimal-route-reflection>"
            "<nc:igp-backup>test_igp</nc:igp-backup><nc:igp-primary>test_primary</nc:igp-primary>"
            "</nc:optimal-route-reflection></nc:group>"
            "</nc:bgp></nc:protocols>",
            '<nc:routing-options xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>',
        ]
        result = self.execute_module(changed=True, commands=commands)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_bgp_global_parsed_bgp_global(self):
        parsed_str = """
            <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
                <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
                    <version>18.4R1-S2.4</version>
                    <protocols>
                        <bgp>
                            <bgp-error-tolerance>
                                <malformed-update-log-interval>10000</malformed-update-log-interval>
                                <no-malformed-route-limit/>
                            </bgp-error-tolerance>
                            <advertise-peer-as/>
                            <advertise-external>
                                <conditional/>
                            </advertise-external>
                            <precision-timers/>
                            <advertise-from-main-vpn-tables/>
                            <holddown-all-stale-labels/>
                            <description>Config is updated with merged operation</description>
                            <accept-remote-nexthop/>
                            <preference>3</preference>
                            <hold-time>15</hold-time>
                            <advertise-inactive/>
                            <no-advertise-peer-as/>
                            <keep>all</keep>
                            <no-aggregator-id/>
                            <mtu-discovery/>
                            <out-delay>20</out-delay>
                            <log-updown/>
                            <damping/>
                            <authentication-algorithm>md5</authentication-algorithm>
                            <no-client-reflect/>
                            <include-mp-next-hop/>
                            <bmp>
                                <monitor>enable</monitor>
                                <route-monitoring>
                                    <pre-policy>
                                        <exclude-non-feasible/>
                                    </pre-policy>
                                    <post-policy>
                                        <exclude-non-eligible/>
                                    </post-policy>
                                </route-monitoring>
                            </bmp>>
                            <add-path-display-ipv4-address/>
                            <egress-te-sid-stats/>
                            <egress-te-set-segment>
                                <name>est1</name>
                                <label>
                                    <label-value>1048400</label-value>
                                </label>
                                <egress-te-backup-segment>
                                    <label>
                                        <label-value>1048300</label-value>
                                    </label>
                                </egress-te-backup-segment>
                            </egress-te-set-segment>
                            <egress-te-set-segment>
                                <name>est2</name>
                                <label>
                                    <label-value>1048400</label-value>
                                </label>
                            </egress-te-set-segment>
                            <egress-te-backup-paths>
                                <template>
                                    <name>mpls</name>
                                    <peer>
                                        <name>1.1.1.1</name>
                                    </peer>
                                    <ip-forward>
                                    </ip-forward>
                                </template>
                                <template>
                                    <name>mpls2</name>
                                    <peer>
                                        <name>1.1.1.1</name>
                                    </peer>
                                    <peer>
                                        <name>1.1.1.2</name>
                                    </peer>
                                    <remote-nexthop>
                                        <remote-nh-addr>10.10.10.11</remote-nh-addr>
                                    </remote-nexthop>
                                </template>
                            </egress-te-backup-paths>
                            <group>
                                <name>internal</name>
                                <out-delay>22</out-delay>
                                <neighbor>
                                    <name>11.11.11.1</name>
                                    <peer-as>65432</peer-as>
                                </neighbor>
                            </group>
                            <graceful-restart>
                                <disable/>
                            </graceful-restart>
                            <metric-out>
                                <metric-value>4294967291</metric-value>
                            </metric-out>
                            <multipath>
                                <disable/>
                                <multiple-as/>
                            </multipath>
                        </bgp>
                    </protocols>
                    <routing-options>
                        <autonomous-system>
                            <as-number>65534</as-number>
                            <loops>5</loops>
                            <asdot-notation/>
                        </autonomous-system>
                    </routing-options>
                </configuration>
            </rpc-reply>
        """
        set_module_args(dict(running_config=parsed_str, state="parsed"))
        self.execute_module(changed=False)

    def test_junos_bgp_global_parsed_bgp_group_neighbors_list(self):
        parsed_str = """
            <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
                <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
                    <version>18.4R1-S2.4</version>
                    <protocols>
                        <bgp>
                            <disable/>
                             <egress-te-set-segment>
                                <name>est2</name>
                                <label>
                                    <label-value>1048400</label-value>
                                </label>
                            </egress-te-set-segment>
                            <bfd-liveness-detection>
                                <minimum-interval>1000</minimum-interval>
                                <holddown-interval>1000</holddown-interval>
                                <minimum-receive-interval>100</minimum-receive-interval>
                                <multiplier>400</multiplier>
                                <no-adaptation/>
                                <session-mode>multihop</session-mode>
                                <version>1</version>
                            </bfd-liveness-detection>
                            <bgp-error-tolerance>
                                <malformed-update-log-interval>10000</malformed-update-log-interval>
                                <malformed-route-limit>4294967285</malformed-route-limit>
                            </bgp-error-tolerance>
                            <bmp>
                                <monitor>enable</monitor>
                                <route-monitoring>
                                    <none/>
                                </route-monitoring>
                            </bmp>
                            <authentication-key>$9$6HxBAtOrlMXNbp0MX</authentication-key>
                            <advertise-external/>
                            <cluster>0.0.4.198</cluster>
                            <egress-te-backup-segment>
                                    <label>
                                        <label-value>1048300</label-value>
                                    </label>
                            </egress-te-backup-segment>
                            <egress-te-backup-paths>
                                <template>
                                    <name>mpls</name>
                                    <peer>
                                        <name>1.1.1.1</name>
                                    </peer>
                                    <ip-forward>
                                    </ip-forward>
                                </template>
                            </egress-te-backup-paths>
                            <group>
                                <name>internal</name>
                                <out-delay>22</out-delay>
                                <neighbor>
                                    <name>11.11.11.1</name>
                                    <peer-as>65432</peer-as>
                                </neighbor>
                                <neighbor>
                                    <name>11.11.11.2</name>
                                    <peer-as>65432</peer-as>
                                </neighbor>
                            </group>
                            <idle-after-switch-over>
                                <timeout>4294967291</timeout>
                            </idle-after-switch-over>
                            <graceful-restart>
                            </graceful-restart>
                           <import>art1</import>
                           <metric-out>
                                <igp>
                                    <delay-med-update/>
                                </igp>
                            </metric-out>
                            <multihop>
                            </multihop>
                            <multipath>
                            </multipath>
                            <no-precision-timers/>
                        </bgp>
                    </protocols>
                    <routing-options xmlns="http://yang.juniper.net/junos-es/conf/routing-options">
                        <autonomous-system>
                            <as-number>65534</as-number>
                            <loops>5</loops>
                            <asdot-notation/>
                        </autonomous-system>
                    </routing-options>
                </configuration>
            </rpc-reply>
        """
        set_module_args(dict(running_config=parsed_str, state="parsed"))
        self.execute_module(changed=False)

    def test_junos_bgp_global_parsed_bgp_group_neighbors_list_2(self):
        parsed_str = """
            <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
                <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
                    <version>18.4R1-S2.4</version>
                    <protocols>
                        <bgp>
                        <graceful-restart>
                                <forwarding-state-bit>from-fib</forwarding-state-bit>
                                <restart-time>1700</restart-time>
                                <stale-routes-time>1500</stale-routes-time>
                                <long-lived>
                                    <receiver>
                                        <disable/>
                                    </receiver>
                                    <advertise-to-non-llgr-neighbor>
                                    </advertise-to-non-llgr-neighbor>
                                </long-lived>
                        </graceful-restart>
                        <idle-after-switch-over>
                            <forever/>
                        </idle-after-switch-over>
                        <import>art1</import>
                        <import>art12</import>
                        <local-as>
                            <as-number>65432</as-number>
                            <private/>
                            <alias/>
                            <no-prepend-global-as/>
                        </local-as>
                        <local-interface>ge-0/0/1.0</local-interface>
                        <local-preference>12</local-preference>
                        <metric-out>
                            <minimum-igp>
                                <metric-offset>100</metric-offset>
                            </minimum-igp>
                        </metric-out>
                        <traceoptions>
                                <file>
                                    <filename>temp_trace</filename>
                                    <size>4294967100</size>
                                    <files>3</files>
                                    <no-world-readable/>
                                </file>
                                <flag>
                                    <name>4byte-as</name>
                                    <receive/>
                                    <detail/>
                                </flag>
                                <flag>
                                    <name>all</name>
                                    <send/>
                                </flag>
                                <flag>
                                    <name>state</name>
                                    <receive/>
                                </flag>
                                <flag>
                                    <name>task</name>
                                    <disable/>
                                </flag>
                                <flag>
                                    <name>update</name>
                                    <filter>
                                        <match-on>prefix</match-on>
                                        <policy>pol1</policy>
                                    </filter>
                                </flag>
                            </traceoptions>
                            <multihop>
                                <ttl>200</ttl>
                                <no-nexthop-change/>
                            </multihop>
                            <traffic-statistics-labeled-path>
                                <file>
                                    <filename>traffic_temp</filename>
                                    <size>20000</size>
                                    <files>10</files>
                                    <world-readable/>
                                </file>
                            </traffic-statistics-labeled-path>
                            <path-selection>
                                <cisco-non-deterministic/>
                                <always-compare-med/>
                                <med-plus-igp>
                                    <igp-multiplier>500</igp-multiplier>
                                </med-plus-igp>
                                <external-router-id/>
                                <as-path-ignore/>
                                <l2vpn-use-bgp-rules/>
                            </path-selection>
                            <outbound-route-filter>
                                <bgp-orf-cisco-mode/>
                                <prefix-based>
                                    <accept>
                                        <inet/>
                                    </accept>
                                </prefix-based>
                            </outbound-route-filter>
                            <output-queue-priority>
                                <expedited>
                                    <update-tokens>10</update-tokens>
                                </expedited>
                                <priority>
                                    <name>13</name>
                                    <update-tokens>20</update-tokens>
                                </priority>
                                <defaults>
                                    <low>
                                        <priority>14</priority>
                                    </low>
                                    <high>
                                        <priority>15</priority>
                                    </high>
                                </defaults>
                            </output-queue-priority>
                            <remove-private>
                                <all>
                                    <replace>
                                        <nearest/>
                                    </replace>
                                </all>
                            </remove-private>
                            <rfc6514-compliant-safi129/>
                            <route-server-client/>
                            <send-addpath-optimization/>
                            <tcp-aggressive-transmission/>
                            <group>
                                <name>internal</name>
                                <out-delay>22</out-delay>
                                <neighbor>
                                    <name>11.11.11.1</name>
                                    <peer-as>65432</peer-as>
                                </neighbor>
                            </group>
                            <bfd-liveness-detection>
                            <minimum-interval>1000</minimum-interval>
                                <transmit-interval>
                                    <minimum-interval>220000</minimum-interval>
                                    <threshold>2000</threshold>
                                </transmit-interval>
                                <detection-time>
                                    <threshold>10000</threshold>
                                </detection-time>
                                <authentication>
                                    <key-chain>cisco</key-chain>
                                    <loose-check/>
                                    <algorithm>keyed-md5</algorithm>
                                </authentication>
                            </bfd-liveness-detection>
                        </bgp>
                    </protocols>
                    <routing-options xmlns="http://yang.juniper.net/junos-es/conf/routing-options">
                        <autonomous-system>
                            <as-number>65534</as-number>
                            <loops>5</loops>
                            <asdot-notation/>
                        </autonomous-system>
                    </routing-options>
                </configuration>
            </rpc-reply>
        """
        set_module_args(dict(running_config=parsed_str, state="parsed"))
        self.execute_module(changed=False)

    def test_junos_bgp_global_parsed_only_routing_options(self):
        parsed_str = """
            <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
                <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
                    <version>18.4R1-S2.4</version>
                    <routing-options>
                        <autonomous-system>
                            <as-number>65534</as-number>
                            <loops>5</loops>
                            <asdot-notation/>
                        </autonomous-system>
                    </routing-options>
                </configuration>
            </rpc-reply>
        """
        set_module_args(dict(running_config=parsed_str, state="parsed"))
        self.execute_module(changed=False)
