#!/usr/bin/env python

# Copyright (c) Django Software Foundation and individual contributors.
# Copyright (C) 2009, 2010 Canonical Ltd
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os

from distutils.core import setup
from distutils.command.install import INSTALL_SCHEMES

""" The logic comes from Django's setup.py """


def fullsplit(path, result=None):
    """
    Split a pathname into components (the opposite of os.path.join) in a
    platform-neutral way.
    """
    if result is None:
        result = []
    head, tail = os.path.split(path)
    if head == '':
        return [tail] + result
    if head == path:
        return result
    return fullsplit(head, [tail] + result)

# Tell distutils to put the data_files in platform-specific installation
# locations. See here for an explanation:
# http://groups.google.com/group/comp.lang.python/browse_thread/thread/35ec7b2fed36eaec/2105ee4d9e8042cb
for scheme in INSTALL_SCHEMES.values():
    scheme['data'] = scheme['purelib']

data_files = []
packages = []
for dirpath, dirnames, filenames in os.walk('apache_openid'):
    # Ignore dirnames that start with '.'
    for i, dirname in enumerate(dirnames):
        if dirname.startswith('.'):
            del dirnames[i]
    if '__init__.py' in filenames:
        packages.append('.'.join(fullsplit(dirpath)))
    elif filenames:
        data_files.append([
            dirpath,
            [os.path.join(dirpath, f) for f in filenames]])

setup(
    name="apache_openid",
    version="2.0.1",
    author="Canonical ISD hackers",
    author_email="canonical-isd@lists.launchpad.net",
    url="http://launchpad.net/apache-openid",
    description="OpenID consumer module for Apache",
    long_description="This is a library that you can use with Apache web server and mod_python to enable OpenID access control to web resources.",
    license="GPLv3",
    packages=packages,
    data_files=data_files,
    install_requires=[
        "python-openid",
    ],
)
