/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:51:16 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import java.io.StringReader;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.plot.AGWindowAlgorithm;
import uk.ac.sanger.artemis.plot.CSCSAlgorithm;
import uk.ac.sanger.artemis.plot.EntropyAlgorithm;
import uk.ac.sanger.artemis.plot.GCSDWindowAlgorithm;
import uk.ac.sanger.artemis.plot.HydrophilicityAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class Algorithm_ESTest extends Algorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("g", "g");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      aGWindowAlgorithm0.getMinimumInternal();
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      HydrophilicityAlgorithm hydrophilicityAlgorithm0 = new HydrophilicityAlgorithm((Feature) null);
      hydrophilicityAlgorithm0.getMinimumInternal();
      assertFalse(hydrophilicityAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, hydrophilicityAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, hydrophilicityAlgorithm0.getUserMin(), 0.01F);
      assertFalse(hydrophilicityAlgorithm0.scalingFlag());
      assertEquals("hydrophilicity", hydrophilicityAlgorithm0.getAlgorithmShortName());
      assertEquals("Hopp-Woods Hydrophilicity", hydrophilicityAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      StringReader stringReader0 = new StringReader("7` nrwtm$FM^iy}ql");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(linePushBackReader0);
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      gCSDWindowAlgorithm0.setScalingFlag(true);
      assertTrue(gCSDWindowAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("g", "g");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      boolean boolean0 = aGWindowAlgorithm0.isUserMaxMin();
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      StringReader stringReader0 = new StringReader("7` nrwtm$FM^iy}ql");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(linePushBackReader0);
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      gCSDWindowAlgorithm0.setUserMax(5);
      assertEquals(5.0F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("g", "g");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      aGWindowAlgorithm0.setUserMaxMin(false);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("g", "g");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      entropyAlgorithm0.getDefaultMinWindowSize();
      assertFalse(entropyAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, entropyAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, entropyAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Reverse Informational Entropy", entropyAlgorithm0.getAlgorithmName());
      assertEquals("entropy", entropyAlgorithm0.getAlgorithmShortName());
      assertTrue(entropyAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("g", "g");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      EntropyAlgorithm entropyAlgorithm0 = new EntropyAlgorithm(strand0);
      float float0 = entropyAlgorithm0.getUserMax();
      assertEquals(1.4E-45F, entropyAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Reverse Informational Entropy", entropyAlgorithm0.getAlgorithmName());
      assertTrue(entropyAlgorithm0.scalingFlag());
      assertFalse(entropyAlgorithm0.isUserMaxMin());
      assertEquals("entropy", entropyAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test8()  throws Throwable  {
      StringReader stringReader0 = new StringReader("7` nrwtm$FM^iy}ql");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(linePushBackReader0);
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      GCSDWindowAlgorithm gCSDWindowAlgorithm0 = new GCSDWindowAlgorithm(strand0);
      gCSDWindowAlgorithm0.getDefaultWindowSize();
      assertFalse(gCSDWindowAlgorithm0.isUserMaxMin());
      assertEquals("GC Content (%) With A 2.5 SD Cutoff", gCSDWindowAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCSDWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCSDWindowAlgorithm0.scalingFlag());
      assertEquals("sd_gc_content", gCSDWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCSDWindowAlgorithm0.getUserMin(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test9()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("g", "g");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      CSCSAlgorithm cSCSAlgorithm0 = new CSCSAlgorithm(strand0);
      cSCSAlgorithm0.getAlgorithmShortName();
  }
}
