/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.aspectj.internal.tools.ant.taskdefs.AntBuilder;
import org.aspectj.internal.tools.ant.taskdefs.TestBuildModule;
import org.aspectj.internal.tools.build.BuildSpec;
import org.aspectj.internal.tools.build.Builder;

public class BuildModule
extends Task {
    BuildSpec buildSpec = new BuildSpec();

    public static void main(String[] args) {
        TestBuildModule.main(args);
    }

    private static File pathToFile(Path path) {
        if (null != path) {
            String[] list = path.list();
            if (null == list || 1 != list.length) {
                throw new IllegalArgumentException("expected exactly 1 element");
            }
            return new File(list[0]);
        }
        return null;
    }

    public BuildModule() {
        this.setTaskName("ajbuild");
    }

    public void setModuledir(Path moduleDir) {
        this.buildSpec.moduleDir = BuildModule.pathToFile(moduleDir);
    }

    public void setModule(String module) {
        this.buildSpec.module = module;
    }

    public void setVersion(String version) {
        this.buildSpec.version = version;
    }

    public void setBasedir(Path baseDir) {
        this.buildSpec.baseDir = BuildModule.pathToFile(baseDir);
    }

    public void setJardir(Path jarDir) {
        this.buildSpec.jarDir = BuildModule.pathToFile(jarDir);
    }

    public void setTrimtesting(boolean trimTesting) {
        this.buildSpec.trimTesting = trimTesting;
    }

    public void setAssembleall(boolean assembleAll) {
        this.buildSpec.assembleAll = assembleAll;
    }

    public void setRebuild(boolean rebuild) {
        this.buildSpec.rebuild = rebuild;
    }

    public void setFailonerror(boolean failonerror) {
        this.buildSpec.failonerror = failonerror;
    }

    public void setCreateinstaller(boolean create) {
        this.buildSpec.createInstaller = create;
    }

    public void setVerbose(boolean verbose) {
        this.buildSpec.verbose = verbose;
    }

    public void setBuildConfig(String buildConfig) {
        this.buildSpec.buildConfig = buildConfig;
    }

    public void setProductdir(Path productDir) {
        this.buildSpec.productDir = BuildModule.pathToFile(productDir);
    }

    public void setTempdir(Path tempDir) {
        this.buildSpec.tempDir = BuildModule.pathToFile(tempDir);
    }

    public void setDistdir(Path distdir) {
        this.buildSpec.distDir = BuildModule.pathToFile(distdir);
    }

    public void execute() throws BuildException {
        BuildSpec buildSpec = this.buildSpec;
        this.buildSpec = new BuildSpec();
        this.build(buildSpec);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void build(BuildSpec buildSpec) throws BuildException {
        boolean failonerror = buildSpec.failonerror;
        Builder builder = null;
        try {
            try {
                File buildScript;
                boolean built = false;
                if (null == buildSpec.productDir && null != buildSpec.moduleDir && (buildScript = new File(buildSpec.moduleDir, "build.xml")).canRead() && !(built = this.buildByScript(buildSpec, buildScript))) {
                    this.log("unable to build " + buildSpec + " using script: " + buildScript.getAbsolutePath());
                }
                if (!built && !(builder = AntBuilder.getBuilder(buildSpec.buildConfig, this.getProject(), buildSpec.tempDir)).build(buildSpec) && failonerror) {
                    Location loc = this.getLocation();
                    throw new BuildException("error building " + buildSpec, loc);
                }
                Object var7_9 = null;
                if (null == builder) return;
                builder.cleanup();
                return;
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Throwable t) {
                Location loc = this.getLocation();
                throw new BuildException("error building " + buildSpec, t, loc);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (null == builder) throw throwable;
            builder.cleanup();
            throw throwable;
        }
    }

    boolean buildByScript(BuildSpec buildSpec, File buildScript) throws BuildException {
        return false;
    }
}

