# 22w52a

## What's New
- Fix capital file extensions confusing auto-editor

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/22w48a...22w52a


# 22w48a

### Bug Fixes
 - Fixed all of the subcommands not working when auto-editor is installed with pip
 - Make having the `readline` module optional for `repl`. This allows Windows to use it without immediately causing a traceback.

### Features
Auto-Editor can now read use its own v2 json timelines. v2 timelines are still undocumented and unstable[1] but is a step in the right direction and opens up the way for more powerful Premiere, ShotCut and FinalCutPro exports.

[1] In the sense that how it works can change from version to version.

### Breaking Changes
Exporting v1 json timelines has been removed due to in part to format being entirely undocumented. Auto-Editor still uses a v1-format like structure for "Editor" exports and

### What to Expect in the Future
Besides making 'Premiere and friends' exports better, Auto-Editor will not work on new features till at least mid-Jan, 2023. Instead improving documentation will be the primary focus.

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/22w46a...22w48a


# 22w48a

### Bug Fixes
 - Fixed all of the subcommands not working when auto-editor is installed with pip
 - Make having the `readline` module optional for `repl`. This allows Windows to use it without immediately causing a traceback.

### Features
Auto-Editor can now read use its own v2 json timelines. v2 timelines are still undocumented and unstable[1] but is a step in the right direction and opens up the way for more powerful Premiere, ShotCut and FinalCutPro exports.

[1] In the sense that how it works can change from version to version.

### Breaking Changes
Exporting v1 json timelines has been removed due to in part to format being entirely undocumented. Auto-Editor still uses a v1-format like structure for "Editor" exports and

### What to Expect in the Future
Besides making 'Premiere and friends' exports better, Auto-Editor will not work on new features till at least mid-Jan, 2023. Instead improving documentation will be the primary focus.

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/22w46a...22w48a


# 22w46a

## What's Changed
- ffmpeg colorspace won't be set if applied value is `reserved`
- Fixed premiere xml export setting `channelcount` to `10` instead of `2`
- Bug Fix: Handle PyAV reporting `stream.duration` as `None` instead of crashing #313

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/22w43a...22w46a


# 22w43a

## Changes
Add Python 3.11 support, drop Python 3.8 support
Improve Premiere Pro and ShotCut XML reading

## New Features
--edit now has direct access to the `margin` `mincut` `minclip` `cook` functions. Along with `or` `and` `xor` `not`

```
--edit '(or (margin 5 motion:4%) (cook 6 3 audio:threshold=4%))
```

## Bug Fixes
Fix `or` `and` `xor` length resizing. Old behavior added random data instead of just filling zeros.

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/22w39a...22w43a


# 22w39a

## Changes
 * Auto-Editor can now read Premiere xml files, provided that it follows a very strict subset of features
 * Timeline files now have `_ALTERED` part added
 * Premiere XML and ShotCut MLT timeline files have been improved

## Bug Fixes
 * Fixed bug on Windows that caused sound to not render right when speed was changed

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/22w37a...22w39a


# 22w37a

## New Features

You can now add audio to the timeline and change its volume.
```
auto-editor movie.mp4 \
--source my-background:/Users/wyattblue/Downloads/music.mp3 \
--add audio:0,500,my-background,volume=0.7
```

Auto-Editor renders volume using FFmpeg's [volume audio filter](https://www.ffmpeg.org/ffmpeg-filters.html#volume) and accepts both raw floats and decibels.

### dB units for audio threshold

dB is now a supported unit.

```
auto-editor --edit audio:threshold=-24dB  # equivalent to 0.063
```

## Minor Improvements
 * ZipSafe is now set to True, which makes auto-editor slightly faster
 * You can now add background music/audio


## Breaking Changes
 * Removed `--timeline` and `--api` options. Instead, use the export option as so: `--export timeline:api=$VAL`

## Bug Fixes
* Final Cut Pro: Use numerator and denominator of timebase fraction by @marcelohenrique in https://github.com/WyattBlue/auto-editor/pull/302

## New Contributors
* @marcelohenrique made their first contribution in https://github.com/WyattBlue/auto-editor/pull/302

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/22w35c...22w37a


