/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifndef _BC_TYPES_H_
#define _BC_TYPES_H_ 

#if 0
---------------------------------------------------------------------
          CONVERSIONS FROM PHYSICAL TO MATHEMATICAL BCs


PHYS BC     |   Velocity      |    Temperature   |    Scalars     |
---------------------------------------------------------------------
INTERIOR    |                 |                  |                |
   or       |    INT_DIR      |     INT_DIR      |    INT_DIR     |
PERIODIC    |                 |                  |                |
---------------------------------------------------------------------
            |                 |                  |                |
INFLOW      |    EXT_DIR      |     EXT_DIR      |    EXT_DIR     |
            |                 |                  |                |
---------------------------------------------------------------------
            |                 |                  |                |
OUTFLOW     |    FOEXTRAP       |     FOEXTRAP       |    FOEXTRAP      |
            |                 |                  |                |
---------------------------------------------------------------------
NO SLIP WALL   |                 |                  |                |
  with         |    EXT_DIR      |  REFLECT_EVEN    |    HOEXTRAP    |
ADIABATIC TEMP |    U = V = 0    |    dT/dn = 0     |                |
---------------------------------------------------------------------
NO SLIP WALL |                 |                  |                |
  with       |    EXT_DIR      |     EXT_DIR      |    HOEXTRAP    |
FIXED TEMP   |    U = V = 0    |                  |                |
---------------------------------------------------------------------
SLIP WALL   |                 |                  |                |
  with      |  Un=0 EXT_DIR   |  REFLECT_EVEN    |    HOEXTRAP    |
ADIABATIC TEMP |  Ut   HOEXTRAP  |    dT/dn = 0     |                |
---------------------------------------------------------------------
SLIP WALL   |                 |                  |                |
  with      |  Un=0 EXT_DIR   |     EXT_DIR      |    HOEXTRAP    |
FIXED TEMP  |  Ut   HOEXTRAP  |                  |                |
---------------------------------------------------------------------
            |                 |                  |                |
SYMMETRY    |  Un REFLECT_ODD |  REFLECT_EVEN    | REFLECT_EVEN   |
            |  Ut REFLECT_EVEN|                  |                |
---------------------------------------------------------------------


INT_DIR      : data taken from other grids or interpolated
EXT_DIR      : data specified on EDGE (FACE) of bndry
HOEXTRAP     : higher order extrapolation to EDGE of bndry
FOEXTRAP       : first order extrapolation from last cell in interior
REFLECT_EVEN : F(-n) = F(n)   true reflection from interior cells
REFLECT_ODD  : F(-n) = -F(n)  true reflection from interior cells

#endif

#ifndef BL_LANG_FORT
enum physicalBndryTypes {Interior,Inflow,Outflow,Symmetry,
                         SlipWall,NoSlipWall};
#endif

#define BOGUS_BC -666

#define REFLECT_ODD -1
#define INT_DIR 0
#define REFLECT_EVEN 1
#define FOEXTRAP  2
#define EXT_DIR 3
#define HOEXTRAP 4

#define Interior 0
#define Inflow 1
#define Outflow 2
#define Symmetry 3
#define SlipWall 4
#define NoSlipWall 5

#endif

