from __future__ import absolute_import, division, print_function
from iotbx.data_manager import DataManager
from mmtbx.ncs.symmetrize_solvent import SymmetrizeSolvent
from libtbx.test_utils import approx_equal
from cctbx.array_family import flex

import time


data_7kjr_frag_asym = """
ATOM      1  N   GLN A  70     110.433  95.183 114.087  1.00 47.08           N
ATOM      2  CA  GLN A  70     109.667  96.116 113.269  1.00 47.08           C
ATOM      3  C   GLN A  70     110.416  97.429 113.073  1.00 47.08           C
ATOM      4  O   GLN A  70     110.343  98.032 111.999  1.00 47.08           O
ATOM      5  CB  GLN A  70     108.298  96.365 113.893  1.00 47.08           C
ATOM      6  CG  GLN A  70     107.489  95.110 114.123  1.00 47.08           C
ATOM      7  CD  GLN A  70     106.238  95.365 114.929  1.00 47.08           C
ATOM      8  OE1 GLN A  70     106.244  96.152 115.869  1.00 47.08           O
ATOM      9  NE2 GLN A  70     105.157  94.698 114.566  1.00 47.08           N
ATOM     10  N   LEU A  71     111.145  97.885 114.095  1.00 41.52           N
ATOM     11  CA  LEU A  71     111.954  99.091 113.946  1.00 41.52           C
ATOM     12  C   LEU A  71     113.074  98.883 112.935  1.00 41.52           C
ATOM     13  O   LEU A  71     113.333  99.754 112.095  1.00 41.52           O
ATOM     14  CB  LEU A  71     112.528  99.513 115.298  1.00 41.52           C
ATOM     15  CG  LEU A  71     111.529  99.856 116.402  1.00 41.52           C
ATOM     16  CD1 LEU A  71     112.184  99.736 117.763  1.00 41.52           C
ATOM     17  CD2 LEU A  71     110.975 101.246 116.200  1.00 41.52           C
ATOM     18  N   ALA A  72     113.744  97.730 113.000  1.00 39.97           N
ATOM     19  CA  ALA A  72     114.790  97.427 112.029  1.00 39.97           C
ATOM     20  C   ALA A  72     114.217  97.306 110.622  1.00 39.97           C
ATOM     21  O   ALA A  72     114.822  97.785 109.655  1.00 39.97           O
ATOM     22  CB  ALA A  72     115.526  96.150 112.427  1.00 39.97           C
ATOM     23  N   LEU A  73     113.046  96.677 110.492  1.00 38.66           N
ATOM     24  CA  LEU A  73     112.396  96.559 109.193  1.00 38.66           C
ATOM     25  C   LEU A  73     112.033  97.924 108.627  1.00 38.66           C
ATOM     26  O   LEU A  73     112.250  98.187 107.441  1.00 38.66           O
ATOM     27  CB  LEU A  73     111.150  95.684 109.312  1.00 38.66           C
ATOM     28  CG  LEU A  73     110.277  95.585 108.064  1.00 38.66           C
ATOM     29  CD1 LEU A  73     110.984  94.785 106.983  1.00 38.66           C
ATOM     30  CD2 LEU A  73     108.936  94.971 108.399  1.00 38.66           C
ATOM     31  N   SER A  74     111.493  98.807 109.468  1.00 39.30           N
ATOM     32  CA  SER A  74     111.125 100.145 109.024  1.00 39.30           C
ATOM     33  C   SER A  74     112.347 100.947 108.598  1.00 39.30           C
ATOM     34  O   SER A  74     112.306 101.658 107.588  1.00 39.30           O
ATOM     35  CB  SER A  74     110.369 100.861 110.138  1.00 39.30           C
ATOM     36  OG  SER A  74     109.968 102.157 109.748  1.00 39.30           O
ATOM     37  N   LYS A  75     113.446 100.839 109.349  1.00 38.70           N
ATOM     38  CA  LYS A  75     114.672 101.531 108.964  1.00 38.70           C
ATOM     39  C   LYS A  75     115.238 101.001 107.652  1.00 38.70           C
ATOM     40  O   LYS A  75     115.685 101.790 106.812  1.00 38.70           O
ATOM     41  CB  LYS A  75     115.715 101.414 110.076  1.00 38.70           C
ATOM     42  CG  LYS A  75     115.508 102.361 111.245  1.00 38.70           C
ATOM     43  CD  LYS A  75     114.921 103.690 110.808  1.00 38.70           C
ATOM     44  CE  LYS A  75     114.154 104.361 111.928  1.00 38.70           C
ATOM     45  NZ  LYS A  75     114.997 105.313 112.697  1.00 38.70           N
ATOM     46  N   GLY A  76     115.221  99.682 107.454  1.00 38.10           N
ATOM     47  CA  GLY A  76     115.690  99.130 106.194  1.00 38.10           C
ATOM     48  C   GLY A  76     114.827  99.536 105.015  1.00 38.10           C
ATOM     49  O   GLY A  76     115.339  99.834 103.931  1.00 38.10           O
ATOM     50  N   VAL A  77     113.509  99.567 105.213  1.00 38.63           N
ATOM     51  CA  VAL A  77     112.605  99.982 104.149  1.00 38.63           C
ATOM     52  C   VAL A  77     112.806 101.457 103.824  1.00 38.63           C
ATOM     53  O   VAL A  77     112.778 101.851 102.657  1.00 38.63           O
ATOM     54  CB  VAL A  77     111.148  99.660 104.533  1.00 38.63           C
ATOM     55  CG1 VAL A  77     110.172 100.326 103.587  1.00 38.63           C
ATOM     56  CG2 VAL A  77     110.923  98.163 104.517  1.00 38.63           C
ATOM     57  N   HIS A  78     113.053 102.286 104.842  1.00 40.48           N
ATOM     58  CA  HIS A  78     113.342 103.697 104.601  1.00 40.48           C
ATOM     59  C   HIS A  78     114.657 103.881 103.852  1.00 40.48           C
ATOM     60  O   HIS A  78     114.770 104.765 102.993  1.00 40.48           O
ATOM     61  CB  HIS A  78     113.367 104.456 105.923  1.00 40.48           C
ATOM     62  CG  HIS A  78     112.007 104.766 106.461  1.00 40.48           C
ATOM     63  ND1 HIS A  78     111.645 104.504 107.763  1.00 40.48           N
ATOM     64  CD2 HIS A  78     110.921 105.320 105.873  1.00 40.48           C
ATOM     65  CE1 HIS A  78     110.393 104.877 107.952  1.00 40.48           C
ATOM     66  NE2 HIS A  78     109.932 105.378 106.822  1.00 40.48           N
ATOM     67  N   PHE A  79     115.661 103.062 104.167  1.00 39.77           N
ATOM     68  CA  PHE A  79     116.921 103.115 103.432  1.00 39.77           C
ATOM     69  C   PHE A  79     116.726 102.746 101.964  1.00 39.77           C
ATOM     70  O   PHE A  79     117.266 103.410 101.067  1.00 39.77           O
ATOM     71  CB  PHE A  79     117.939 102.186 104.092  1.00 39.77           C
ATOM     72  CG  PHE A  79     119.306 102.265 103.493  1.00 39.77           C
ATOM     73  CD1 PHE A  79     120.066 103.414 103.620  1.00 39.77           C
ATOM     74  CD2 PHE A  79     119.832 101.193 102.799  1.00 39.77           C
ATOM     75  CE1 PHE A  79     121.325 103.489 103.067  1.00 39.77           C
ATOM     76  CE2 PHE A  79     121.091 101.263 102.247  1.00 39.77           C
ATOM     77  CZ  PHE A  79     121.838 102.413 102.380  1.00 39.77           C
ATOM     78  N   VAL A  80     115.943 101.697 101.702  1.00 39.47           N
ATOM     79  CA  VAL A  80     115.647 101.308 100.324  1.00 39.47           C
ATOM     80  C   VAL A  80     114.849 102.403  99.617  1.00 39.47           C
ATOM     81  O   VAL A  80     115.065 102.680  98.430  1.00 39.47           O
ATOM     82  CB  VAL A  80     114.914  99.953 100.303  1.00 39.47           C
ATOM     83  CG1 VAL A  80     114.404  99.622  98.908  1.00 39.47           C
ATOM     84  CG2 VAL A  80     115.834  98.858 100.795  1.00 39.47           C
TER      85      VAL A  80
ATOM     86  N   LEU A 115     119.909 118.752  99.596  1.00 37.68           N
ATOM     87  CA  LEU A 115     119.178 118.172 100.718  1.00 37.68           C
ATOM     88  C   LEU A 115     119.610 116.731 100.973  1.00 37.68           C
ATOM     89  O   LEU A 115     119.665 116.285 102.124  1.00 37.68           O
ATOM     90  CB  LEU A 115     117.673 118.253 100.469  1.00 37.68           C
ATOM     91  CG  LEU A 115     117.051 119.639 100.264  1.00 37.68           C
ATOM     92  CD1 LEU A 115     115.593 119.529  99.867  1.00 37.68           C
ATOM     93  CD2 LEU A 115     117.212 120.526 101.482  1.00 37.68           C
ATOM     94  N   GLN A 116     119.945 115.993  99.913  1.00 38.20           N
ATOM     95  CA  GLN A 116     120.407 114.620 100.083  1.00 38.20           C
ATOM     96  C   GLN A 116     121.806 114.575 100.685  1.00 38.20           C
ATOM     97  O   GLN A 116     122.131 113.655 101.438  1.00 38.20           O
ATOM     98  CB  GLN A 116     120.368 113.884  98.746  1.00 38.20           C
ATOM     99  CG  GLN A 116     118.983 113.430  98.346  1.00 38.20           C
ATOM    100  CD  GLN A 116     118.418 112.391  99.284  1.00 38.20           C
ATOM    101  OE1 GLN A 116     119.087 111.419  99.626  1.00 38.20           O
ATOM    102  NE2 GLN A 116     117.179 112.588  99.706  1.00 38.20           N
ATOM    103  N   SER A 117     122.647 115.561 100.366  1.00 37.82           N
ATOM    104  CA  SER A 117     123.937 115.682 101.038  1.00 37.82           C
ATOM    105  C   SER A 117     123.752 115.939 102.529  1.00 37.82           C
ATOM    106  O   SER A 117     124.466 115.370 103.367  1.00 37.82           O
ATOM    107  CB  SER A 117     124.757 116.800 100.399  1.00 37.82           C
ATOM    108  OG  SER A 117     125.487 116.320  99.291  1.00 37.82           O
ATOM    109  N   ILE A 118     122.791 116.800 102.874  1.00 38.08           N
ATOM    110  CA  ILE A 118     122.484 117.043 104.283  1.00 38.08           C
ATOM    111  C   ILE A 118     122.008 115.761 104.957  1.00 38.08           C
ATOM    112  O   ILE A 118     122.387 115.460 106.094  1.00 38.08           O
ATOM    113  CB  ILE A 118     121.452 118.179 104.418  1.00 38.08           C
ATOM    114  CG1 ILE A 118     122.060 119.501 103.961  1.00 38.08           C
ATOM    115  CG2 ILE A 118     120.969 118.308 105.849  1.00 38.08           C
ATOM    116  CD1 ILE A 118     121.098 120.646 104.008  1.00 38.08           C
ATOM    117  N   ASN A 119     121.178 114.982 104.263  1.00 38.82           N
ATOM    118  CA  ASN A 119     120.692 113.725 104.825  1.00 38.82           C
ATOM    119  C   ASN A 119     121.821 112.714 105.006  1.00 38.82           C
ATOM    120  O   ASN A 119     121.825 111.943 105.973  1.00 38.82           O
ATOM    121  CB  ASN A 119     119.593 113.154 103.938  1.00 38.82           C
ATOM    122  CG  ASN A 119     119.019 111.871 104.480  1.00 38.82           C
ATOM    123  OD1 ASN A 119     118.497 111.833 105.587  1.00 38.82           O
ATOM    124  ND2 ASN A 119     119.106 110.810 103.696  1.00 38.82           N
ATOM    125  N   PHE A 120     122.781 112.698 104.081  1.00 37.82           N
ATOM    126  CA  PHE A 120     123.957 111.849 104.232  1.00 37.82           C
ATOM    127  C   PHE A 120     124.759 112.233 105.471  1.00 37.82           C
ATOM    128  O   PHE A 120     125.194 111.365 106.240  1.00 37.82           O
ATOM    129  CB  PHE A 120     124.824 111.941 102.979  1.00 37.82           C
ATOM    130  CG  PHE A 120     126.095 111.150 103.065  1.00 37.82           C
ATOM    131  CD1 PHE A 120     126.068 109.767 103.041  1.00 37.82           C
ATOM    132  CD2 PHE A 120     127.315 111.791 103.180  1.00 37.82           C
ATOM    133  CE1 PHE A 120     127.237 109.037 103.122  1.00 37.82           C
ATOM    134  CE2 PHE A 120     128.486 111.067 103.262  1.00 37.82           C
ATOM    135  CZ  PHE A 120     128.447 109.688 103.233  1.00 37.82           C
ATOM    136  N   VAL A 121     124.961 113.538 105.679  1.00 37.70           N
ATOM    137  CA  VAL A 121     125.651 114.006 106.880  1.00 37.70           C
ATOM    138  C   VAL A 121     124.874 113.611 108.134  1.00 37.70           C
ATOM    139  O   VAL A 121     125.460 113.223 109.151  1.00 37.70           O
ATOM    140  CB  VAL A 121     125.882 115.527 106.804  1.00 37.70           C
ATOM    141  CG1 VAL A 121     126.443 116.060 108.108  1.00 37.70           C
ATOM    142  CG2 VAL A 121     126.820 115.854 105.666  1.00 37.70           C
ATOM    143  N   ARG A 122     123.544 113.685 108.071  1.00 40.99           N
ATOM    144  CA  ARG A 122     122.715 113.295 109.207  1.00 40.99           C
ATOM    145  C   ARG A 122     122.852 111.808 109.517  1.00 40.99           C
ATOM    146  O   ARG A 122     122.873 111.410 110.685  1.00 40.99           O
ATOM    147  CB  ARG A 122     121.257 113.652 108.931  1.00 40.99           C
ATOM    148  CG  ARG A 122     120.301 113.257 110.032  1.00 40.99           C
ATOM    149  CD  ARG A 122     118.872 113.271 109.548  1.00 40.99           C
ATOM    150  NE  ARG A 122     118.628 112.257 108.529  1.00 40.99           N
ATOM    151  CZ  ARG A 122     118.330 110.990 108.792  1.00 40.99           C
ATOM    152  NH1 ARG A 122     118.244 110.575 110.046  1.00 40.99           N
ATOM    153  NH2 ARG A 122     118.120 110.138 107.802  1.00 40.99           N
ATOM    154  N   ILE A 123     122.937 110.972 108.482  1.00 38.92           N
ATOM    155  CA  ILE A 123     123.117 109.537 108.691  1.00 38.92           C
ATOM    156  C   ILE A 123     124.487 109.253 109.302  1.00 38.92           C
ATOM    157  O   ILE A 123     124.630 108.384 110.173  1.00 38.92           O
ATOM    158  CB  ILE A 123     122.899 108.781 107.366  1.00 38.92           C
ATOM    159  CG1 ILE A 123     121.404 108.623 107.094  1.00 38.92           C
ATOM    160  CG2 ILE A 123     123.562 107.416 107.381  1.00 38.92           C
ATOM    161  CD1 ILE A 123     121.079 108.310 105.659  1.00 38.92           C
ATOM    162  N   ILE A 124     125.509 110.000 108.875  1.00 38.73           N
ATOM    163  CA  ILE A 124     126.835 109.862 109.478  1.00 38.73           C
ATOM    164  C   ILE A 124     126.792 110.239 110.957  1.00 38.73           C
ATOM    165  O   ILE A 124     127.379 109.560 111.808  1.00 38.73           O
ATOM    166  CB  ILE A 124     127.872 110.706 108.712  1.00 38.73           C
ATOM    167  CG1 ILE A 124     128.016 110.218 107.270  1.00 38.73           C
ATOM    168  CG2 ILE A 124     129.220 110.676 109.410  1.00 38.73           C
ATOM    169  CD1 ILE A 124     128.306 108.748 107.146  1.00 38.73           C
ATOM    170  N   MET A 125     126.093 111.329 111.284  1.00 41.37           N
ATOM    171  CA  MET A 125     125.972 111.733 112.683  1.00 41.37           C
ATOM    172  C   MET A 125     125.183 110.712 113.495  1.00 41.37           C
ATOM    173  O   MET A 125     125.472 110.495 114.674  1.00 41.37           O
ATOM    174  CB  MET A 125     125.331 113.116 112.796  1.00 41.37           C
ATOM    175  CG  MET A 125     126.120 114.235 112.141  1.00 41.37           C
ATOM    176  SD  MET A 125     127.577 114.834 113.033  1.00 41.37           S
ATOM    177  CE  MET A 125     127.222 114.406 114.744  1.00 41.37           C
ATOM    178  N   ARG A 126     124.188 110.073 112.880  1.00 36.50           N
ATOM    179  CA  ARG A 126     123.455 109.009 113.557  1.00 36.50           C
ATOM    180  C   ARG A 126     124.354 107.812 113.852  1.00 36.50           C
ATOM    181  O   ARG A 126     124.275 107.215 114.932  1.00 36.50           O
ATOM    182  CB  ARG A 126     122.256 108.587 112.713  1.00 36.50           C
ATOM    183  CG  ARG A 126     121.069 108.114 113.516  1.00 36.50           C
ATOM    184  CD  ARG A 126     120.428 109.256 114.274  1.00 36.50           C
ATOM    185  NE  ARG A 126     119.364 108.798 115.158  1.00 36.50           N
ATOM    186  CZ  ARG A 126     118.662 109.589 115.959  1.00 36.50           C
ATOM    187  NH1 ARG A 126     118.905 110.887 115.993  1.00 36.50           N
ATOM    188  NH2 ARG A 126     117.712 109.078 116.721  1.00 36.50           N
ATOM    189  N   LEU A 127     125.218 107.450 112.901  1.00 36.90           N
ATOM    190  CA  LEU A 127     126.167 106.365 113.137  1.00 36.90           C
ATOM    191  C   LEU A 127     127.160 106.729 114.232  1.00 36.90           C
ATOM    192  O   LEU A 127     127.553 105.879 115.040  1.00 36.90           O
ATOM    193  CB  LEU A 127     126.907 106.019 111.847  1.00 36.90           C
ATOM    194  CG  LEU A 127     126.072 105.336 110.768  1.00 36.90           C
ATOM    195  CD1 LEU A 127     126.867 105.210 109.486  1.00 36.90           C
ATOM    196  CD2 LEU A 127     125.595 103.981 111.246  1.00 36.90           C
ATOM    197  N   TRP A 128     127.575 107.992 114.275  1.00 40.80           N
ATOM    198  CA  TRP A 128     128.495 108.418 115.320  1.00 40.80           C
ATOM    199  C   TRP A 128     127.807 108.444 116.682  1.00 40.80           C
ATOM    200  O   TRP A 128     128.443 108.206 117.714  1.00 40.80           O
ATOM    201  CB  TRP A 128     129.078 109.785 114.972  1.00 40.80           C
ATOM    202  CG  TRP A 128     130.065 110.243 115.965  1.00 40.80           C
ATOM    203  CD1 TRP A 128     131.399 109.971 115.967  1.00 40.80           C
ATOM    204  CD2 TRP A 128     129.819 111.054 117.111  1.00 40.80           C
ATOM    205  NE1 TRP A 128     131.999 110.557 117.047  1.00 40.80           N
ATOM    206  CE2 TRP A 128     131.050 111.229 117.766  1.00 40.80           C
ATOM    207  CE3 TRP A 128     128.676 111.644 117.652  1.00 40.80           C
ATOM    208  CZ2 TRP A 128     131.173 111.971 118.926  1.00 40.80           C
ATOM    209  CZ3 TRP A 128     128.801 112.376 118.803  1.00 40.80           C
ATOM    210  CH2 TRP A 128     130.042 112.535 119.428  1.00 40.80           C
ATOM    211  N   LEU A 129     126.509 108.753 116.704  1.00 36.45           N
ATOM    212  CA  LEU A 129     125.733 108.658 117.935  1.00 36.45           C
ATOM    213  C   LEU A 129     125.610 107.212 118.390  1.00 36.45           C
ATOM    214  O   LEU A 129     125.633 106.928 119.591  1.00 36.45           O
ATOM    215  CB  LEU A 129     124.353 109.280 117.730  1.00 36.45           C
ATOM    216  CG  LEU A 129     123.513 109.660 118.950  1.00 36.45           C
ATOM    217  CD1 LEU A 129     124.314 110.491 119.931  1.00 36.45           C
ATOM    218  CD2 LEU A 129     122.262 110.402 118.509  1.00 36.45           C
ATOM    219  N   CYS A 130     125.467 106.287 117.441  1.00 35.02           N
ATOM    220  CA  CYS A 130     125.505 104.868 117.776  1.00 35.02           C
ATOM    221  C   CYS A 130     126.842 104.470 118.379  1.00 35.02           C
ATOM    222  O   CYS A 130     126.883 103.703 119.345  1.00 35.02           O
ATOM    223  CB  CYS A 130     125.219 104.018 116.540  1.00 35.02           C
ATOM    224  SG  CYS A 130     123.510 104.011 116.046  1.00 35.02           S
ATOM    225  N   TRP A 131     127.940 104.966 117.814  1.00 35.21           N
ATOM    226  CA  TRP A 131     129.258 104.695 118.376  1.00 35.21           C
ATOM    227  C   TRP A 131     129.406 105.276 119.781  1.00 35.21           C
ATOM    228  O   TRP A 131     129.952 104.618 120.672  1.00 35.21           O
ATOM    229  CB  TRP A 131     130.348 105.249 117.457  1.00 35.21           C
ATOM    230  CG  TRP A 131     131.702 105.256 118.085  1.00 35.21           C
ATOM    231  CD1 TRP A 131     132.606 104.242 118.079  1.00 35.21           C
ATOM    232  CD2 TRP A 131     132.309 106.329 118.810  1.00 35.21           C
ATOM    233  NE1 TRP A 131     133.736 104.610 118.758  1.00 35.21           N
ATOM    234  CE2 TRP A 131     133.577 105.887 119.222  1.00 35.21           C
ATOM    235  CE3 TRP A 131     131.899 107.619 119.158  1.00 35.21           C
ATOM    236  CZ2 TRP A 131     134.443 106.689 119.955  1.00 35.21           C
ATOM    237  CZ3 TRP A 131     132.754 108.409 119.891  1.00 35.21           C
ATOM    238  CH2 TRP A 131     134.014 107.945 120.280  1.00 35.21           C
ATOM    239  N   LYS A 132     128.939 106.506 119.990  1.00 36.62           N
ATOM    240  CA  LYS A 132     129.077 107.140 121.296  1.00 36.62           C
ATOM    241  C   LYS A 132     128.198 106.466 122.343  1.00 36.62           C
ATOM    242  O   LYS A 132     128.629 106.257 123.482  1.00 36.62           O
ATOM    243  CB  LYS A 132     128.739 108.626 121.200  1.00 36.62           C
ATOM    244  CG  LYS A 132     128.939 109.342 122.501  1.00 36.62           C
ATOM    245  CD  LYS A 132     127.920 110.432 122.691  1.00 36.62           C
ATOM    246  CE  LYS A 132     128.424 111.809 122.329  1.00 36.62           C
ATOM    247  NZ  LYS A 132     127.310 112.778 122.136  1.00 36.62           N
ATOM    248  N   CYS A 133     126.969 106.115 121.978  1.00 35.80           N
ATOM    249  CA  CYS A 133     126.069 105.434 122.895  1.00 35.80           C
ATOM    250  C   CYS A 133     126.404 103.961 123.072  1.00 35.80           C
ATOM    251  O   CYS A 133     125.808 103.319 123.942  1.00 35.80           O
ATOM    252  CB  CYS A 133     124.621 105.579 122.421  1.00 35.80           C
ATOM    253  SG  CYS A 133     124.020 107.281 122.345  1.00 35.80           S
TER     254      CYS A 133
ATOM    255  N   GLN B  70     107.670 122.916 114.087  1.00 47.04           N
ATOM    256  CA  GLN B  70     108.439 121.985 113.270  1.00 47.04           C
ATOM    257  C   GLN B  70     107.691 120.673 113.071  1.00 47.04           C
ATOM    258  O   GLN B  70     107.762 120.075 111.994  1.00 47.04           O
ATOM    259  CB  GLN B  70     109.806 121.738 113.900  1.00 47.04           C
ATOM    260  CG  GLN B  70     110.611 122.994 114.137  1.00 47.04           C
ATOM    261  CD  GLN B  70     111.871 122.735 114.925  1.00 47.04           C
ATOM    262  OE1 GLN B  70     111.861 121.997 115.904  1.00 47.04           O
ATOM    263  NE2 GLN B  70     112.965 123.344 114.505  1.00 47.04           N
ATOM    264  N   LEU B  71     106.968 120.210 114.093  1.00 41.38           N
ATOM    265  CA  LEU B  71     106.160 119.004 113.940  1.00 41.38           C
ATOM    266  C   LEU B  71     105.038 119.216 112.933  1.00 41.38           C
ATOM    267  O   LEU B  71     104.782 118.351 112.084  1.00 41.38           O
ATOM    268  CB  LEU B  71     105.589 118.575 115.291  1.00 41.38           C
ATOM    269  CG  LEU B  71     106.589 118.227 116.392  1.00 41.38           C
ATOM    270  CD1 LEU B  71     105.940 118.360 117.755  1.00 41.38           C
ATOM    271  CD2 LEU B  71     107.130 116.831 116.195  1.00 41.38           C
ATOM    272  N   ALA B  72     104.361 120.365 113.010  1.00 40.04           N
ATOM    273  CA  ALA B  72     103.314 120.671 112.041  1.00 40.04           C
ATOM    274  C   ALA B  72     103.883 120.792 110.632  1.00 40.04           C
ATOM    275  O   ALA B  72     103.280 120.301 109.670  1.00 40.04           O
ATOM    276  CB  ALA B  72     102.582 121.950 112.441  1.00 40.04           C
ATOM    277  N   LEU B  73     105.050 121.427 110.497  1.00 39.04           N
ATOM    278  CA  LEU B  73     105.696 121.549 109.195  1.00 39.04           C
ATOM    279  C   LEU B  73     106.063 120.187 108.627  1.00 39.04           C
ATOM    280  O   LEU B  73     105.847 119.926 107.440  1.00 39.04           O
ATOM    281  CB  LEU B  73     106.939 122.429 109.312  1.00 39.04           C
ATOM    282  CG  LEU B  73     107.812 122.526 108.063  1.00 39.04           C
ATOM    283  CD1 LEU B  73     107.106 123.325 106.981  1.00 39.04           C
ATOM    284  CD2 LEU B  73     109.155 123.138 108.398  1.00 39.04           C
ATOM    285  N   SER B  74     106.608 119.304 109.465  1.00 39.40           N
ATOM    286  CA  SER B  74     106.995 117.976 109.009  1.00 39.40           C
ATOM    287  C   SER B  74     105.783 117.158 108.583  1.00 39.40           C
ATOM    288  O   SER B  74     105.833 116.450 107.571  1.00 39.40           O
ATOM    289  CB  SER B  74     107.775 117.263 110.108  1.00 39.40           C
ATOM    290  OG  SER B  74     107.809 115.868 109.896  1.00 39.40           O
ATOM    291  N   LYS B  75     104.680 117.250 109.331  1.00 39.23           N
ATOM    292  CA  LYS B  75     103.475 116.525 108.937  1.00 39.23           C
ATOM    293  C   LYS B  75     102.881 117.075 107.646  1.00 39.23           C
ATOM    294  O   LYS B  75     102.408 116.307 106.801  1.00 39.23           O
ATOM    295  CB  LYS B  75     102.440 116.552 110.060  1.00 39.23           C
ATOM    296  CG  LYS B  75     102.882 115.823 111.304  1.00 39.23           C
ATOM    297  CD  LYS B  75     102.841 114.328 111.090  1.00 39.23           C
ATOM    298  CE  LYS B  75     103.961 113.638 111.832  1.00 39.23           C
ATOM    299  NZ  LYS B  75     103.474 112.457 112.591  1.00 39.23           N
ATOM    300  N   GLY B  76     102.898 118.397 107.469  1.00 38.81           N
ATOM    301  CA  GLY B  76     102.424 118.967 106.218  1.00 38.81           C
ATOM    302  C   GLY B  76     103.277 118.564 105.029  1.00 38.81           C
ATOM    303  O   GLY B  76     102.756 118.266 103.949  1.00 38.81           O
ATOM    304  N   VAL B  77     104.596 118.535 105.217  1.00 38.82           N
ATOM    305  CA  VAL B  77     105.495 118.121 104.147  1.00 38.82           C
ATOM    306  C   VAL B  77     105.292 116.647 103.822  1.00 38.82           C
ATOM    307  O   VAL B  77     105.318 116.254 102.654  1.00 38.82           O
ATOM    308  CB  VAL B  77     106.954 118.442 104.527  1.00 38.82           C
ATOM    309  CG1 VAL B  77     107.927 117.774 103.579  1.00 38.82           C
ATOM    310  CG2 VAL B  77     107.179 119.940 104.512  1.00 38.82           C
ATOM    311  N   HIS B  78     105.046 115.817 104.839  1.00 40.70           N
ATOM    312  CA  HIS B  78     104.758 114.405 104.598  1.00 40.70           C
ATOM    313  C   HIS B  78     103.442 114.220 103.849  1.00 40.70           C
ATOM    314  O   HIS B  78     103.329 113.336 102.991  1.00 40.70           O
ATOM    315  CB  HIS B  78     104.733 113.646 105.920  1.00 40.70           C
ATOM    316  CG  HIS B  78     106.093 113.335 106.457  1.00 40.70           C
ATOM    317  ND1 HIS B  78     106.460 113.608 107.755  1.00 40.70           N
ATOM    318  CD2 HIS B  78     107.174 112.771 105.871  1.00 40.70           C
ATOM    319  CE1 HIS B  78     107.711 113.231 107.945  1.00 40.70           C
ATOM    320  NE2 HIS B  78     108.166 112.718 106.818  1.00 40.70           N
ATOM    321  N   PHE B  79     102.436 115.036 104.166  1.00 39.97           N
ATOM    322  CA  PHE B  79     101.177 114.987 103.430  1.00 39.97           C
ATOM    323  C   PHE B  79     101.374 115.357 101.963  1.00 39.97           C
ATOM    324  O   PHE B  79     100.836 114.693 101.065  1.00 39.97           O
ATOM    325  CB  PHE B  79     100.160 115.917 104.090  1.00 39.97           C
ATOM    326  CG  PHE B  79      98.798 115.855 103.477  1.00 39.97           C
ATOM    327  CD1 PHE B  79      98.018 114.720 103.604  1.00 39.97           C
ATOM    328  CD2 PHE B  79      98.298 116.930 102.767  1.00 39.97           C
ATOM    329  CE1 PHE B  79      96.763 114.661 103.038  1.00 39.97           C
ATOM    330  CE2 PHE B  79      97.044 116.876 102.201  1.00 39.97           C
ATOM    331  CZ  PHE B  79      96.277 115.740 102.336  1.00 39.97           C
ATOM    332  N   VAL B  80     102.152 116.410 101.703  1.00 39.40           N
ATOM    333  CA  VAL B  80     102.454 116.798 100.326  1.00 39.40           C
ATOM    334  C   VAL B  80     103.246 115.700  99.619  1.00 39.40           C
ATOM    335  O   VAL B  80     103.027 115.421  98.433  1.00 39.40           O
ATOM    336  CB  VAL B  80     103.194 118.149 100.307  1.00 39.40           C
ATOM    337  CG1 VAL B  80     103.704 118.478  98.912  1.00 39.40           C
ATOM    338  CG2 VAL B  80     102.282 119.248 100.803  1.00 39.40           C
TER     339      VAL B  80
ATOM    340  N   LEU B 115      98.199  99.301  99.516  1.00 37.41           N
ATOM    341  CA  LEU B 115      98.915  99.885 100.638  1.00 37.41           C
ATOM    342  C   LEU B 115      98.433 101.300 100.905  1.00 37.41           C
ATOM    343  O   LEU B 115      98.204 101.662 102.066  1.00 37.41           O
ATOM    344  CB  LEU B 115     100.420  99.855 100.384  1.00 37.41           C
ATOM    345  CG  LEU B 115     101.056  98.483 100.143  1.00 37.41           C
ATOM    346  CD1 LEU B 115     102.505  98.617  99.722  1.00 37.41           C
ATOM    347  CD2 LEU B 115     100.934  97.593 101.363  1.00 37.41           C
ATOM    348  N   GLN B 116      98.178 102.071  99.843  1.00 37.55           N
ATOM    349  CA  GLN B 116      97.715 103.434 100.048  1.00 37.55           C
ATOM    350  C   GLN B 116      96.349 103.442 100.704  1.00 37.55           C
ATOM    351  O   GLN B 116      96.099 104.274 101.585  1.00 37.55           O
ATOM    352  CB  GLN B 116      97.699 104.199  98.729  1.00 37.55           C
ATOM    353  CG  GLN B 116      99.070 104.664  98.297  1.00 37.55           C
ATOM    354  CD  GLN B 116      99.659 105.685  99.243  1.00 37.55           C
ATOM    355  OE1 GLN B 116      99.009 106.666  99.599  1.00 37.55           O
ATOM    356  NE2 GLN B 116     100.896 105.462  99.656  1.00 37.55           N
ATOM    357  N   SER B 117      95.498 102.471 100.351  1.00 37.13           N
ATOM    358  CA  SER B 117      94.206 102.357 101.012  1.00 37.13           C
ATOM    359  C   SER B 117      94.388 102.181 102.508  1.00 37.13           C
ATOM    360  O   SER B 117      93.760 102.894 103.301  1.00 37.13           O
ATOM    361  CB  SER B 117      93.409 101.195 100.425  1.00 37.13           C
ATOM    362  OG  SER B 117      92.681 101.610  99.289  1.00 37.13           O
ATOM    363  N   ILE B 118      95.322 101.308 102.903  1.00 37.58           N
ATOM    364  CA  ILE B 118      95.581 101.093 104.321  1.00 37.58           C
ATOM    365  C   ILE B 118      96.026 102.392 104.965  1.00 37.58           C
ATOM    366  O   ILE B 118      95.524 102.778 106.029  1.00 37.58           O
ATOM    367  CB  ILE B 118      96.617  99.970 104.514  1.00 37.58           C
ATOM    368  CG1 ILE B 118      96.018  98.627 104.108  1.00 37.58           C
ATOM    369  CG2 ILE B 118      97.087  99.911 105.951  1.00 37.58           C
ATOM    370  CD1 ILE B 118      97.033  97.538 103.984  1.00 37.58           C
ATOM    371  N   ASN B 119      96.900 103.132 104.276  1.00 38.18           N
ATOM    372  CA  ASN B 119      97.385 104.390 104.820  1.00 38.18           C
ATOM    373  C   ASN B 119      96.237 105.367 105.009  1.00 38.18           C
ATOM    374  O   ASN B 119      96.150 106.031 106.050  1.00 38.18           O
ATOM    375  CB  ASN B 119      98.458 104.972 103.909  1.00 38.18           C
ATOM    376  CG  ASN B 119      99.039 106.255 104.443  1.00 38.18           C
ATOM    377  OD1 ASN B 119      99.600 106.286 105.532  1.00 38.18           O
ATOM    378  ND2 ASN B 119      98.916 107.323 103.673  1.00 38.18           N
ATOM    379  N   PHE B 120      95.302 105.393 104.052  1.00 37.53           N
ATOM    380  CA  PHE B 120      94.132 106.243 104.193  1.00 37.53           C
ATOM    381  C   PHE B 120      93.362 105.883 105.453  1.00 37.53           C
ATOM    382  O   PHE B 120      93.069 106.760 106.278  1.00 37.53           O
ATOM    383  CB  PHE B 120      93.245 106.122 102.957  1.00 37.53           C
ATOM    384  CG  PHE B 120      91.953 106.875 103.062  1.00 37.53           C
ATOM    385  CD1 PHE B 120      91.940 108.258 103.016  1.00 37.53           C
ATOM    386  CD2 PHE B 120      90.754 106.202 103.209  1.00 37.53           C
ATOM    387  CE1 PHE B 120      90.754 108.957 103.111  1.00 37.53           C
ATOM    388  CE2 PHE B 120      89.565 106.894 103.304  1.00 37.53           C
ATOM    389  CZ  PHE B 120      89.565 108.274 103.254  1.00 37.53           C
ATOM    390  N   VAL B 121      93.131 104.582 105.667  1.00 37.26           N
ATOM    391  CA  VAL B 121      92.433 104.137 106.866  1.00 37.26           C
ATOM    392  C   VAL B 121      93.205 104.565 108.101  1.00 37.26           C
ATOM    393  O   VAL B 121      92.626 105.102 109.055  1.00 37.26           O
ATOM    394  CB  VAL B 121      92.214 102.613 106.829  1.00 37.26           C
ATOM    395  CG1 VAL B 121      91.664 102.120 108.152  1.00 37.26           C
ATOM    396  CG2 VAL B 121      91.275 102.248 105.703  1.00 37.26           C
ATOM    397  N   ARG B 122      94.535 104.431 108.054  1.00 40.45           N
ATOM    398  CA  ARG B 122      95.352 104.806 109.198  1.00 40.45           C
ATOM    399  C   ARG B 122      95.181 106.281 109.515  1.00 40.45           C
ATOM    400  O   ARG B 122      94.978 106.650 110.679  1.00 40.45           O
ATOM    401  CB  ARG B 122      96.816 104.471 108.929  1.00 40.45           C
ATOM    402  CG  ARG B 122      97.769 104.972 109.986  1.00 40.45           C
ATOM    403  CD  ARG B 122      99.200 104.911 109.506  1.00 40.45           C
ATOM    404  NE  ARG B 122      99.488 105.928 108.501  1.00 40.45           N
ATOM    405  CZ  ARG B 122      99.798 107.188 108.780  1.00 40.45           C
ATOM    406  NH1 ARG B 122      99.858 107.596 110.038  1.00 40.45           N
ATOM    407  NH2 ARG B 122     100.048 108.042 107.800  1.00 40.45           N
ATOM    408  N   ILE B 123      95.150 107.123 108.476  1.00 38.82           N
ATOM    409  CA  ILE B 123      94.987 108.555 108.693  1.00 38.82           C
ATOM    410  C   ILE B 123      93.647 108.825 109.355  1.00 38.82           C
ATOM    411  O   ILE B 123      93.563 109.591 110.324  1.00 38.82           O
ATOM    412  CB  ILE B 123      95.147 109.319 107.366  1.00 38.82           C
ATOM    413  CG1 ILE B 123      96.627 109.455 107.018  1.00 38.82           C
ATOM    414  CG2 ILE B 123      94.510 110.692 107.447  1.00 38.82           C
ATOM    415  CD1 ILE B 123      96.882 109.889 105.601  1.00 38.82           C
ATOM    416  N   ILE B 124      92.602 108.116 108.910  1.00 38.33           N
ATOM    417  CA  ILE B 124      91.286 108.267 109.517  1.00 38.33           C
ATOM    418  C   ILE B 124      91.355 107.918 110.993  1.00 38.33           C
ATOM    419  O   ILE B 124      90.897 108.690 111.846  1.00 38.33           O
ATOM    420  CB  ILE B 124      90.245 107.402 108.779  1.00 38.33           C
ATOM    421  CG1 ILE B 124      90.067 107.866 107.332  1.00 38.33           C
ATOM    422  CG2 ILE B 124      88.913 107.431 109.507  1.00 38.33           C
ATOM    423  CD1 ILE B 124      89.957 109.361 107.164  1.00 38.33           C
ATOM    424  N   MET B 125      92.017 106.801 111.321  1.00 40.71           N
ATOM    425  CA  MET B 125      92.138 106.412 112.720  1.00 40.71           C
ATOM    426  C   MET B 125      92.895 107.466 113.504  1.00 40.71           C
ATOM    427  O   MET B 125      92.491 107.823 114.618  1.00 40.71           O
ATOM    428  CB  MET B 125      92.814 105.047 112.848  1.00 40.71           C
ATOM    429  CG  MET B 125      92.127 103.933 112.084  1.00 40.71           C
ATOM    430  SD  MET B 125      90.649 103.234 112.861  1.00 40.71           S
ATOM    431  CE  MET B 125      90.865 103.638 114.601  1.00 40.71           C
ATOM    432  N   ARG B 126      93.936 108.040 112.895  1.00 36.44           N
ATOM    433  CA  ARG B 126      94.679 109.097 113.561  1.00 36.44           C
ATOM    434  C   ARG B 126      93.770 110.275 113.869  1.00 36.44           C
ATOM    435  O   ARG B 126      93.751 110.766 115.005  1.00 36.44           O
ATOM    436  CB  ARG B 126      95.864 109.528 112.702  1.00 36.44           C
ATOM    437  CG  ARG B 126      97.050 110.006 113.500  1.00 36.44           C
ATOM    438  CD  ARG B 126      97.683 108.865 114.268  1.00 36.44           C
ATOM    439  NE  ARG B 126      98.747 109.320 115.152  1.00 36.44           N
ATOM    440  CZ  ARG B 126      99.446 108.526 115.953  1.00 36.44           C
ATOM    441  NH1 ARG B 126      99.199 107.228 115.985  1.00 36.44           N
ATOM    442  NH2 ARG B 126     100.396 109.032 116.717  1.00 36.44           N
ATOM    443  N   LEU B 127      92.933 110.663 112.900  1.00 36.93           N
ATOM    444  CA  LEU B 127      91.999 111.754 113.133  1.00 36.93           C
ATOM    445  C   LEU B 127      91.030 111.394 114.240  1.00 36.93           C
ATOM    446  O   LEU B 127      90.736 112.221 115.111  1.00 36.93           O
ATOM    447  CB  LEU B 127      91.242 112.094 111.852  1.00 36.93           C
ATOM    448  CG  LEU B 127      92.065 112.789 110.772  1.00 36.93           C
ATOM    449  CD1 LEU B 127      91.289 112.851 109.474  1.00 36.93           C
ATOM    450  CD2 LEU B 127      92.472 114.173 111.231  1.00 36.93           C
ATOM    451  N   TRP B 128      90.583 110.140 114.261  1.00 40.68           N
ATOM    452  CA  TRP B 128      89.648 109.733 115.293  1.00 40.68           C
ATOM    453  C   TRP B 128      90.332 109.728 116.652  1.00 40.68           C
ATOM    454  O   TRP B 128      89.713 110.075 117.666  1.00 40.68           O
ATOM    455  CB  TRP B 128      89.058 108.370 114.945  1.00 40.68           C
ATOM    456  CG  TRP B 128      88.085 107.896 115.937  1.00 40.68           C
ATOM    457  CD1 TRP B 128      86.754 108.179 115.968  1.00 40.68           C
ATOM    458  CD2 TRP B 128      88.337 107.032 117.040  1.00 40.68           C
ATOM    459  NE1 TRP B 128      86.164 107.562 117.035  1.00 40.68           N
ATOM    460  CE2 TRP B 128      87.115 106.848 117.710  1.00 40.68           C
ATOM    461  CE3 TRP B 128      89.480 106.404 117.536  1.00 40.68           C
ATOM    462  CZ2 TRP B 128      87.000 106.061 118.839  1.00 40.68           C
ATOM    463  CZ3 TRP B 128      89.363 105.626 118.657  1.00 40.68           C
ATOM    464  CH2 TRP B 128      88.130 105.457 119.294  1.00 40.68           C
ATOM    465  N   LEU B 129      91.627 109.395 116.678  1.00 36.38           N
ATOM    466  CA  LEU B 129      92.382 109.494 117.918  1.00 36.38           C
ATOM    467  C   LEU B 129      92.434 110.939 118.385  1.00 36.38           C
ATOM    468  O   LEU B 129      92.269 111.220 119.578  1.00 36.38           O
ATOM    469  CB  LEU B 129      93.785 108.920 117.724  1.00 36.38           C
ATOM    470  CG  LEU B 129      94.611 108.530 118.950  1.00 36.38           C
ATOM    471  CD1 LEU B 129      93.829 107.614 119.869  1.00 36.38           C
ATOM    472  CD2 LEU B 129      95.896 107.859 118.501  1.00 36.38           C
ATOM    473  N   CYS B 130      92.584 111.871 117.439  1.00 35.24           N
ATOM    474  CA  CYS B 130      92.524 113.286 117.774  1.00 35.24           C
ATOM    475  C   CYS B 130      91.170 113.652 118.352  1.00 35.24           C
ATOM    476  O   CYS B 130      91.078 114.491 119.254  1.00 35.24           O
ATOM    477  CB  CYS B 130      92.827 114.134 116.542  1.00 35.24           C
ATOM    478  SG  CYS B 130      94.547 114.138 116.092  1.00 35.24           S
ATOM    479  N   TRP B 131      90.107 113.030 117.850  1.00 35.21           N
ATOM    480  CA  TRP B 131      88.797 113.280 118.425  1.00 35.21           C
ATOM    481  C   TRP B 131      88.692 112.670 119.816  1.00 35.21           C
ATOM    482  O   TRP B 131      88.055 113.245 120.704  1.00 35.21           O
ATOM    483  CB  TRP B 131      87.707 112.736 117.503  1.00 35.21           C
ATOM    484  CG  TRP B 131      86.358 112.743 118.122  1.00 35.21           C
ATOM    485  CD1 TRP B 131      85.459 113.759 118.103  1.00 35.21           C
ATOM    486  CD2 TRP B 131      85.750 111.681 118.857  1.00 35.21           C
ATOM    487  NE1 TRP B 131      84.326 113.402 118.782  1.00 35.21           N
ATOM    488  CE2 TRP B 131      84.480 112.128 119.258  1.00 35.21           C
ATOM    489  CE3 TRP B 131      86.158 110.396 119.220  1.00 35.21           C
ATOM    490  CZ2 TRP B 131      83.612 111.336 119.998  1.00 35.21           C
ATOM    491  CZ3 TRP B 131      85.301 109.613 119.956  1.00 35.21           C
ATOM    492  CH2 TRP B 131      84.040 110.083 120.337  1.00 35.21           C
ATOM    493  N   LYS B 132      89.312 111.509 120.028  1.00 36.87           N
ATOM    494  CA  LYS B 132      89.165 110.842 121.315  1.00 36.87           C
ATOM    495  C   LYS B 132      90.010 111.524 122.381  1.00 36.87           C
ATOM    496  O   LYS B 132      89.598 111.641 123.539  1.00 36.87           O
ATOM    497  CB  LYS B 132      89.537 109.367 121.193  1.00 36.87           C
ATOM    498  CG  LYS B 132      89.176 108.577 122.415  1.00 36.87           C
ATOM    499  CD  LYS B 132      90.195 107.497 122.664  1.00 36.87           C
ATOM    500  CE  LYS B 132      89.787 106.142 122.156  1.00 36.87           C
ATOM    501  NZ  LYS B 132      90.882 105.142 122.265  1.00 36.87           N
ATOM    502  N   CYS B 133      91.194 111.986 122.003  1.00 36.01           N
ATOM    503  CA  CYS B 133      92.086 112.677 122.919  1.00 36.01           C
ATOM    504  C   CYS B 133      91.731 114.145 123.098  1.00 36.01           C
ATOM    505  O   CYS B 133      92.320 114.795 123.966  1.00 36.01           O
ATOM    506  CB  CYS B 133      93.531 112.546 122.434  1.00 36.01           C
ATOM    507  SG  CYS B 133      94.118 110.843 122.306  1.00 36.01           S
TER     508      CYS B 133
ATOM    509  N   PHE C  25      81.165 103.086 113.295  1.00 61.74           N
ATOM    510  CA  PHE C  25      82.615 103.229 113.300  1.00 61.74           C
ATOM    511  C   PHE C  25      83.223 102.314 114.359  1.00 61.74           C
ATOM    512  O   PHE C  25      84.340 101.824 114.195  1.00 61.74           O
ATOM    513  CB  PHE C  25      83.012 104.694 113.545  1.00 61.74           C
ATOM    514  CG  PHE C  25      84.501 104.939 113.552  1.00 61.74           C
ATOM    515  CD1 PHE C  25      85.152 105.325 112.392  1.00 61.74           C
ATOM    516  CD2 PHE C  25      85.243 104.820 114.720  1.00 61.74           C
ATOM    517  CE1 PHE C  25      86.512 105.555 112.389  1.00 61.74           C
ATOM    518  CE2 PHE C  25      86.600 105.043 114.717  1.00 61.74           C
ATOM    519  CZ  PHE C  25      87.235 105.415 113.552  1.00 61.74           C
ATOM    520  N   SER C  26      82.483 102.096 115.448  1.00 69.14           N
ATOM    521  CA  SER C  26      82.995 101.284 116.549  1.00 69.14           C
ATOM    522  C   SER C  26      83.196  99.836 116.121  1.00 69.14           C
ATOM    523  O   SER C  26      84.188  99.196 116.494  1.00 69.14           O
ATOM    524  CB  SER C  26      82.047 101.365 117.744  1.00 69.14           C
ATOM    525  OG  SER C  26      82.568 100.653 118.853  1.00 69.14           O
ATOM    526  N   LYS C  27      82.256  99.301 115.339  1.00 71.21           N
ATOM    527  CA  LYS C  27      82.361  97.929 114.856  1.00 71.21           C
ATOM    528  C   LYS C  27      83.585  97.757 113.964  1.00 71.21           C
ATOM    529  O   LYS C  27      84.315  96.767 114.070  1.00 71.21           O
ATOM    530  CB  LYS C  27      81.084  97.548 114.105  1.00 71.21           C
ATOM    531  CG  LYS C  27      79.807  97.822 114.881  1.00 71.21           C
ATOM    532  CD  LYS C  27      78.575  97.471 114.064  1.00 71.21           C
ATOM    533  CE  LYS C  27      77.300  97.745 114.844  1.00 71.21           C
ATOM    534  NZ  LYS C  27      76.083  97.418 114.051  1.00 71.21           N
ATOM    535  N   LEU C  28      83.830  98.732 113.087  1.00 68.12           N
ATOM    536  CA  LEU C  28      84.998  98.668 112.217  1.00 68.12           C
ATOM    537  C   LEU C  28      86.296  98.725 113.012  1.00 68.12           C
ATOM    538  O   LEU C  28      87.250  98.023 112.677  1.00 68.12           O
ATOM    539  CB  LEU C  28      84.951  99.801 111.193  1.00 68.12           C
ATOM    540  CG  LEU C  28      84.213  99.501 109.888  1.00 68.12           C
ATOM    541  CD1 LEU C  28      83.602 100.771 109.318  1.00 68.12           C
ATOM    542  CD2 LEU C  28      85.146  98.849 108.881  1.00 68.12           C
ATOM    543  N   ARG C  29      86.345  99.538 114.067  1.00 60.94           N
ATOM    544  CA  ARG C  29      87.528  99.603 114.922  1.00 60.94           C
ATOM    545  C   ARG C  29      87.759  98.279 115.647  1.00 60.94           C
ATOM    546  O   ARG C  29      88.897  97.791 115.743  1.00 60.94           O
ATOM    547  CB  ARG C  29      87.354 100.765 115.902  1.00 60.94           C
ATOM    548  CG  ARG C  29      88.264 100.817 117.117  1.00 60.94           C
ATOM    549  CD  ARG C  29      88.119 102.199 117.744  1.00 60.94           C
ATOM    550  NE  ARG C  29      87.617 102.156 119.115  1.00 60.94           N
ATOM    551  CZ  ARG C  29      88.374 102.278 120.199  1.00 60.94           C
ATOM    552  NH1 ARG C  29      89.674 102.493 120.082  1.00 60.94           N
ATOM    553  NH2 ARG C  29      87.820 102.228 121.402  1.00 60.94           N
ATOM    554  N   GLU C  30      86.676  97.675 116.148  1.00 70.38           N
ATOM    555  CA  GLU C  30      86.776  96.377 116.808  1.00 70.38           C
ATOM    556  C   GLU C  30      87.221  95.288 115.839  1.00 70.38           C
ATOM    557  O   GLU C  30      87.901  94.337 116.237  1.00 70.38           O
ATOM    558  CB  GLU C  30      85.437  96.009 117.445  1.00 70.38           C
ATOM    559  CG  GLU C  30      85.057  96.872 118.632  1.00 70.38           C
ATOM    560  CD  GLU C  30      83.614  96.680 119.053  1.00 70.38           C
ATOM    561  OE1 GLU C  30      82.878  95.961 118.346  1.00 70.38           O
ATOM    562  OE2 GLU C  30      83.215  97.250 120.090  1.00 70.38           O
ATOM    563  N   GLN C  31      86.821  95.390 114.572  1.00 68.91           N
ATOM    564  CA  GLN C  31      87.322  94.466 113.558  1.00 68.91           C
ATOM    565  C   GLN C  31      88.791  94.728 113.235  1.00 68.91           C
ATOM    566  O   GLN C  31      89.565  93.795 112.999  1.00 68.91           O
ATOM    567  CB  GLN C  31      86.463  94.550 112.291  1.00 68.91           C
ATOM    568  CG  GLN C  31      85.262  93.587 112.208  1.00 68.91           C
ATOM    569  CD  GLN C  31      84.342  93.590 113.420  1.00 68.91           C
ATOM    570  OE1 GLN C  31      83.322  94.277 113.431  1.00 68.91           O
ATOM    571  NE2 GLN C  31      84.672  92.783 114.424  1.00 68.91           N
ATOM    572  N   LEU C  32      89.190  96.001 113.215  1.00 64.22           N
ATOM    573  CA  LEU C  32      90.523  96.358 112.738  1.00 64.22           C
ATOM    574  C   LEU C  32      91.607  95.995 113.742  1.00 64.22           C
ATOM    575  O   LEU C  32      92.727  95.650 113.347  1.00 64.22           O
ATOM    576  CB  LEU C  32      90.587  97.850 112.416  1.00 64.22           C
ATOM    577  CG  LEU C  32      90.019  98.307 111.075  1.00 64.22           C
ATOM    578  CD1 LEU C  32      90.331  99.775 110.848  1.00 64.22           C
ATOM    579  CD2 LEU C  32      90.564  97.452 109.944  1.00 64.22           C
ATOM    580  N   GLY C  33      91.311  96.102 115.037  1.00 63.47           N
ATOM    581  CA  GLY C  33      92.310  95.877 116.064  1.00 63.47           C
ATOM    582  C   GLY C  33      93.016  94.527 116.031  1.00 63.47           C
ATOM    583  O   GLY C  33      94.226  94.427 115.757  1.00 63.47           O
ATOM    584  N   PRO C  34      92.267  93.457 116.328  1.00 67.34           N
ATOM    585  CA  PRO C  34      92.882  92.120 116.333  1.00 67.34           C
ATOM    586  C   PRO C  34      93.406  91.682 114.980  1.00 67.34           C
ATOM    587  O   PRO C  34      94.340  90.877 114.930  1.00 67.34           O
ATOM    588  CB  PRO C  34      91.742  91.216 116.823  1.00 67.34           C
ATOM    589  CG  PRO C  34      90.834  92.127 117.565  1.00 67.34           C
ATOM    590  CD  PRO C  34      90.881  93.416 116.817  1.00 67.34           C
ATOM    591  N   VAL C  35      92.838  92.186 113.883  1.00 66.77           N
ATOM    592  CA  VAL C  35      93.341  91.838 112.555  1.00 66.77           C
ATOM    593  C   VAL C  35      94.770  92.344 112.380  1.00 66.77           C
ATOM    594  O   VAL C  35      95.665  91.601 111.958  1.00 66.77           O
ATOM    595  CB  VAL C  35      92.399  92.392 111.469  1.00 66.77           C
ATOM    596  CG1 VAL C  35      93.134  92.594 110.154  1.00 66.77           C
ATOM    597  CG2 VAL C  35      91.215  91.465 111.282  1.00 66.77           C
ATOM    598  N   THR C  36      95.007  93.608 112.744  1.00 64.73           N
ATOM    599  CA  THR C  36      96.348  94.182 112.682  1.00 64.73           C
ATOM    600  C   THR C  36      97.303  93.449 113.618  1.00 64.73           C
ATOM    601  O   THR C  36      98.440  93.116 113.238  1.00 64.73           O
ATOM    602  CB  THR C  36      96.280  95.670 113.039  1.00 64.73           C
ATOM    603  OG1 THR C  36      95.406  96.345 112.127  1.00 64.73           O
ATOM    604  CG2 THR C  36      97.654  96.309 112.980  1.00 64.73           C
TER     605      THR C  36
ATOM    606  N   PHE D  25     136.962 114.886 112.940  1.00 61.44           N
ATOM    607  CA  PHE D  25     135.515 114.787 113.080  1.00 61.44           C
ATOM    608  C   PHE D  25     135.058 115.675 114.230  1.00 61.44           C
ATOM    609  O   PHE D  25     133.936 116.181 114.227  1.00 61.44           O
ATOM    610  CB  PHE D  25     135.091 113.326 113.308  1.00 61.44           C
ATOM    611  CG  PHE D  25     133.601 113.128 113.443  1.00 61.44           C
ATOM    612  CD1 PHE D  25     132.839 112.787 112.337  1.00 61.44           C
ATOM    613  CD2 PHE D  25     132.966 113.245 114.673  1.00 61.44           C
ATOM    614  CE1 PHE D  25     131.477 112.601 112.448  1.00 61.44           C
ATOM    615  CE2 PHE D  25     131.607 113.069 114.783  1.00 61.44           C
ATOM    616  CZ  PHE D  25     130.863 112.739 113.672  1.00 61.44           C
ATOM    617  N   SER D  26     135.940 115.855 115.216  1.00 68.37           N
ATOM    618  CA  SER D  26     135.581 116.617 116.408  1.00 68.37           C
ATOM    619  C   SER D  26     135.313 118.079 116.078  1.00 68.37           C
ATOM    620  O   SER D  26     134.396 118.690 116.638  1.00 68.37           O
ATOM    621  CB  SER D  26     136.687 116.499 117.456  1.00 68.37           C
ATOM    622  OG  SER D  26     136.156 116.573 118.767  1.00 68.37           O
ATOM    623  N   LYS D  27     136.111 118.660 115.180  1.00 70.38           N
ATOM    624  CA  LYS D  27     135.936 120.061 114.812  1.00 70.38           C
ATOM    625  C   LYS D  27     134.627 120.276 114.060  1.00 70.38           C
ATOM    626  O   LYS D  27     133.868 121.206 114.352  1.00 70.38           O
ATOM    627  CB  LYS D  27     137.125 120.526 113.969  1.00 70.38           C
ATOM    628  CG  LYS D  27     138.477 120.320 114.631  1.00 70.38           C
ATOM    629  CD  LYS D  27     139.608 120.745 113.709  1.00 70.38           C
ATOM    630  CE  LYS D  27     140.964 120.528 114.359  1.00 70.38           C
ATOM    631  NZ  LYS D  27     142.080 120.920 113.455  1.00 70.38           N
ATOM    632  N   LEU D  28     134.346 119.408 113.085  1.00 67.25           N
ATOM    633  CA  LEU D  28     133.147 119.567 112.271  1.00 67.25           C
ATOM    634  C   LEU D  28     131.878 119.331 113.080  1.00 67.25           C
ATOM    635  O   LEU D  28     130.848 119.955 112.805  1.00 67.25           O
ATOM    636  CB  LEU D  28     133.204 118.622 111.072  1.00 67.25           C
ATOM    637  CG  LEU D  28     132.276 118.944 109.901  1.00 67.25           C
ATOM    638  CD1 LEU D  28     133.052 118.941 108.595  1.00 67.25           C
ATOM    639  CD2 LEU D  28     131.128 117.952 109.844  1.00 67.25           C
ATOM    640  N   ARG D  29     131.933 118.449 114.079  1.00 61.13           N
ATOM    641  CA  ARG D  29     130.787 118.254 114.962  1.00 61.13           C
ATOM    642  C   ARG D  29     130.469 119.521 115.746  1.00 61.13           C
ATOM    643  O   ARG D  29     129.301 119.906 115.871  1.00 61.13           O
ATOM    644  CB  ARG D  29     131.056 117.085 115.907  1.00 61.13           C
ATOM    645  CG  ARG D  29     130.059 116.934 117.044  1.00 61.13           C
ATOM    646  CD  ARG D  29     130.269 115.607 117.743  1.00 61.13           C
ATOM    647  NE  ARG D  29     130.644 115.769 119.145  1.00 61.13           N
ATOM    648  CZ  ARG D  29     129.789 115.756 120.161  1.00 61.13           C
ATOM    649  NH1 ARG D  29     128.497 115.573 119.941  1.00 61.13           N
ATOM    650  NH2 ARG D  29     130.231 115.905 121.401  1.00 61.13           N
ATOM    651  N   GLU D  30     131.496 120.192 116.269  1.00 68.65           N
ATOM    652  CA  GLU D  30     131.273 121.450 116.972  1.00 68.65           C
ATOM    653  C   GLU D  30     130.861 122.563 116.014  1.00 68.65           C
ATOM    654  O   GLU D  30     130.189 123.516 116.420  1.00 68.65           O
ATOM    655  CB  GLU D  30     132.528 121.846 117.750  1.00 68.65           C
ATOM    656  CG  GLU D  30     132.696 121.181 119.123  1.00 68.65           C
ATOM    657  CD  GLU D  30     131.384 120.934 119.862  1.00 68.65           C
ATOM    658  OE1 GLU D  30     130.994 121.796 120.678  1.00 68.65           O
ATOM    659  OE2 GLU D  30     130.767 119.862 119.671  1.00 68.65           O
ATOM    660  N   GLN D  31     131.272 122.468 114.749  1.00 68.36           N
ATOM    661  CA  GLN D  31     130.832 123.437 113.749  1.00 68.36           C
ATOM    662  C   GLN D  31     129.352 123.264 113.414  1.00 68.36           C
ATOM    663  O   GLN D  31     128.635 124.246 113.195  1.00 68.36           O
ATOM    664  CB  GLN D  31     131.683 123.312 112.483  1.00 68.36           C
ATOM    665  CG  GLN D  31     132.761 124.381 112.312  1.00 68.36           C
ATOM    666  CD  GLN D  31     133.778 124.413 113.436  1.00 68.36           C
ATOM    667  OE1 GLN D  31     134.775 123.693 113.404  1.00 68.36           O
ATOM    668  NE2 GLN D  31     133.541 125.263 114.428  1.00 68.36           N
ATOM    669  N   LEU D  32     128.880 122.015 113.363  1.00 64.33           N
ATOM    670  CA  LEU D  32     127.547 121.742 112.831  1.00 64.33           C
ATOM    671  C   LEU D  32     126.441 122.172 113.788  1.00 64.33           C
ATOM    672  O   LEU D  32     125.353 122.561 113.346  1.00 64.33           O
ATOM    673  CB  LEU D  32     127.407 120.257 112.506  1.00 64.33           C
ATOM    674  CG  LEU D  32     128.002 119.761 111.192  1.00 64.33           C
ATOM    675  CD1 LEU D  32     127.610 118.313 110.963  1.00 64.33           C
ATOM    676  CD2 LEU D  32     127.552 120.638 110.037  1.00 64.33           C
ATOM    677  N   GLY D  33     126.687 122.089 115.093  1.00 63.98           N
ATOM    678  CA  GLY D  33     125.670 122.324 116.096  1.00 63.98           C
ATOM    679  C   GLY D  33     125.023 123.698 116.070  1.00 63.98           C
ATOM    680  O   GLY D  33     123.810 123.835 115.846  1.00 63.98           O
ATOM    681  N   PRO D  34     125.817 124.745 116.329  1.00 67.66           N
ATOM    682  CA  PRO D  34     125.253 126.105 116.296  1.00 67.66           C
ATOM    683  C   PRO D  34     124.700 126.498 114.941  1.00 67.66           C
ATOM    684  O   PRO D  34     123.749 127.282 114.885  1.00 67.66           O
ATOM    685  CB  PRO D  34     126.442 126.985 116.706  1.00 67.66           C
ATOM    686  CG  PRO D  34     127.336 126.077 117.465  1.00 67.66           C
ATOM    687  CD  PRO D  34     127.217 124.754 116.785  1.00 67.66           C
ATOM    688  N   VAL D  35     125.261 125.972 113.850  1.00 67.05           N
ATOM    689  CA  VAL D  35     124.743 126.280 112.518  1.00 67.05           C
ATOM    690  C   VAL D  35     123.313 125.773 112.368  1.00 67.05           C
ATOM    691  O   VAL D  35     122.415 126.516 111.948  1.00 67.05           O
ATOM    692  CB  VAL D  35     125.676 125.691 111.443  1.00 67.05           C
ATOM    693  CG1 VAL D  35     124.960 125.573 110.110  1.00 67.05           C
ATOM    694  CG2 VAL D  35     126.924 126.540 111.308  1.00 67.05           C
ATOM    695  N   THR D  36     123.077 124.511 112.739  1.00 65.03           N
ATOM    696  CA  THR D  36     121.736 123.936 112.684  1.00 65.03           C
ATOM    697  C   THR D  36     120.778 124.676 113.612  1.00 65.03           C
ATOM    698  O   THR D  36     119.644 125.008 113.227  1.00 65.03           O
ATOM    699  CB  THR D  36     121.805 122.452 113.054  1.00 65.03           C
ATOM    700  OG1 THR D  36     122.665 121.767 112.136  1.00 65.03           O
ATOM    701  CG2 THR D  36     120.430 121.814 113.019  1.00 65.03           C
TER     702      THR D  36
HETATM  703  O   HOH A 401     111.121 107.036 103.276  1.00 44.72           O
HETATM  704  O   HOH A 402     103.961 102.484 115.168  1.00 45.97           O
HETATM  705  O   HOH A 403     108.059 102.078 143.839  1.00 33.07           O
HETATM  706  O   HOH A 404     110.938 103.892 111.338  1.00 42.67           O
HETATM  707  O   HOH A 405     100.805 103.322 102.487  1.00 40.85           O
HETATM  708  O   HOH A 406     106.839 104.687 135.192  1.00 24.49           O
HETATM  709  O   HOH A 407     124.566  92.207 136.128  1.00 36.29           O
HETATM  710  O   HOH A 408     112.062 117.857 135.428  1.00 29.17           O
HETATM  711  O   HOH A 409     124.899 118.501 132.786  1.00 37.97           O
HETATM  712  O   HOH A 410     110.358 106.260 133.771  1.00 22.31           O
HETATM  713  O   HOH A 411     107.430 102.761 109.359  1.00 44.22           O
HETATM  714  O   HOH A 412     111.579 108.243 126.847  1.00 24.94           O
HETATM  715  O   HOH A 413     107.596 108.364 125.044  1.00 27.88           O
HETATM  716  O   HOH A 414     122.136 116.320 125.770  1.00 31.48           O
HETATM  717  O   HOH A 415     125.139 103.419 126.599  1.00 29.45           O
HETATM  718  O   HOH A 416     108.800 102.343 119.296  1.00 36.24           O
HETATM  719  O   HOH A 417     127.224 103.349 127.780  1.00 33.37           O
HETATM  720  O   HOH A 418     121.142 104.028 135.792  1.00 29.65           O
HETATM  721  O   HOH A 419     112.196 112.472 120.682  1.00 33.87           O
HETATM  722  O   HOH A 420     110.335  98.778 144.877  1.00 36.37           O
HETATM  723  O   HOH A 421     117.133 107.049 113.412  1.00 36.60           O
HETATM  724  O   HOH A 422     111.837 111.540 133.042  1.00 23.71           O
HETATM  725  O   HOH A 423     117.143 123.300  78.615  1.00 57.90           O
HETATM  726  O   HOH A 424     113.432 101.232 123.925  1.00 32.63           O
HETATM  727  O   HOH A 425     120.140 113.814 118.034  1.00 42.03           O
HETATM  728  O   HOH A 426     110.204  99.858 124.317  1.00 33.24           O
HETATM  729  O   HOH A 427     112.764 120.336 132.732  1.00 32.07           O
HETATM  730  O   HOH A 428     108.720 107.734 132.287  1.00 26.04           O
HETATM  731  O   HOH A 429     100.960  97.724 142.414  1.00 39.88           O
HETATM  732  O   HOH A 430     115.795 119.955 124.887  1.00 33.46           O
HETATM  733  O   HOH A 431     113.295 118.394 122.123  1.00 34.62           O
HETATM  734  O   HOH A 432     121.236  99.599 124.203  1.00 35.66           O
HETATM  735  O   HOH A 433     109.838  99.017 134.014  1.00 31.19           O
HETATM  736  O   HOH A 434     128.298  97.892 123.710  1.00 42.56           O
HETATM  737  O   HOH A 435     112.029 119.903 128.488  1.00 34.34           O
HETATM  738  O   HOH A 436     104.673 109.044 101.052  1.00 42.05           O
HETATM  739  O   HOH A 437     113.380 107.431 103.234  1.00 43.31           O
HETATM  740  O   HOH A 438     127.952 105.402 132.728  1.00 32.39           O
HETATM  741  O   HOH A 439     107.560  98.311 131.024  1.00 34.21           O
HETATM  742  O   HOH A 440     107.596  99.789 133.040  1.00 30.58           O
HETATM  743  O   HOH A 441     124.080 119.955 140.076  1.00 41.04           O
HETATM  744  O   HOH A 442     129.189  96.857 128.131  1.00 36.10           O
HETATM  745  O   HOH A 443     111.264 106.034 116.320  1.00 42.40           O
HETATM  746  O   HOH A 444     125.738  96.299 125.388  1.00 39.31           O
HETATM  747  O   HOH A 445     116.727 107.254 148.308  1.00 41.57           O
HETATM  748  O   HOH A 446     111.958 107.387 119.270  1.00 32.37           O
HETATM  749  O   HOH A 447     127.376  94.568 134.634  1.00 38.70           O
HETATM  750  O   HOH A 448     109.636 100.673 120.713  1.00 37.92           O
HETATM  751  O   HOH A 449     103.119  94.530 117.017  1.00 52.42           O
HETATM  752  O   HOH A 450     117.583 114.004 116.543  1.00 41.13           O
HETATM  753  O   HOH A 451     115.593 101.478 124.517  1.00 35.69           O
HETATM  754  O   HOH A 452     114.696 117.988  90.897  1.00 44.25           O
HETATM  755  O   HOH A 453      99.731 110.565 103.965  1.00 46.25           O
HETATM  756  O   HOH A 454     122.827 117.047 140.311  1.00 36.44           O
HETATM  757  O   HOH A 455     111.493 108.024  99.175  1.00 42.74           O
HETATM  758  O   HOH A 456     117.000 111.949  96.057  1.00 40.89           O
HETATM  759  O   HOH A 457     109.370 104.539 118.335  1.00 38.44           O
HETATM  760  O   HOH A 458     118.501 120.682 137.506  1.00 32.24           O
HETATM  761  O   HOH A 459     106.592 108.203 122.473  1.00 28.32           O
HETATM  762  O   HOH A 460     127.226 105.786 128.941  1.00 31.13           O
HETATM  763  O   HOH A 461     109.050 109.050  97.769  1.00 46.65           O
HETATM  764  O   HOH B 401     102.440 116.670 124.779  1.00 34.13           O
HETATM  765  O   HOH B 402     106.998 111.038 103.285  1.00 45.92           O
HETATM  766  O   HOH B 403     107.177 114.200 111.377  1.00 42.85           O
HETATM  767  O   HOH B 404     114.139 115.622 115.166  1.00 46.76           O
HETATM  768  O   HOH B 405     110.042 116.023 143.838  1.00 33.26           O
HETATM  769  O   HOH B 406      96.864 118.501 124.203  1.00 35.28           O
HETATM  770  O   HOH B 407      93.557 125.909 136.093  1.00 36.45           O
HETATM  771  O   HOH B 408     117.300 114.817 102.470  1.00 41.22           O
HETATM  772  O   HOH B 409     111.260 113.412 135.191  1.00 24.77           O
HETATM  773  O   HOH B 410      93.193  99.599 132.789  1.00 39.46           O
HETATM  774  O   HOH B 411     106.516 109.861 126.844  1.00 24.86           O
HETATM  775  O   HOH B 412     110.504 109.736 125.044  1.00 28.66           O
HETATM  776  O   HOH B 413     107.741 111.839 133.771  1.00 22.11           O
HETATM  777  O   HOH B 414     109.302 115.762 119.299  1.00 37.74           O
HETATM  778  O   HOH B 415      92.973 114.686 126.585  1.00 29.13           O
HETATM  779  O   HOH B 416     106.038 100.243 135.428  1.00 29.10           O
HETATM  780  O   HOH B 417      95.964 101.784 125.771  1.00 31.63           O
HETATM  781  O   HOH B 418     110.668 115.337 109.359  1.00 45.06           O
HETATM  782  O   HOH B 419      96.961 114.075 135.795  1.00 29.06           O
HETATM  783  O   HOH B 420      90.876 114.752 127.779  1.00 32.11           O
HETATM  784  O   HOH B 421     105.905 105.628 120.682  1.00 33.35           O
HETATM  785  O   HOH B 422     107.758 119.317 144.874  1.00 36.67           O
HETATM  786  O   HOH B 423     106.261 106.560 133.041  1.00 23.99           O
HETATM  787  O   HOH B 424     107.893 118.242 124.317  1.00 33.33           O
HETATM  788  O   HOH B 425      97.967 104.293 118.028  1.00 40.66           O
HETATM  789  O   HOH B 426     105.333  97.759 132.733  1.00 31.81           O
HETATM  790  O   HOH B 427     117.138 120.380 142.413  1.00 39.74           O
HETATM  791  O   HOH B 428     109.379 110.365 132.287  1.00 25.60           O
HETATM  792  O   HOH B 429     102.313  98.145 124.889  1.00 34.63           O
HETATM  793  O   HOH B 430     104.804  99.712 122.120  1.00 35.17           O
HETATM  794  O   HOH B 431     100.973 111.058 113.412  1.00 36.20           O
HETATM  795  O   HOH B 432     108.261 119.089 134.015  1.00 30.91           O
HETATM  796  O   HOH B 433     104.558 116.841 123.969  1.00 32.33           O
HETATM  797  O   HOH B 434      89.806 120.206 123.716  1.00 42.06           O
HETATM  798  O   HOH B 435     113.428 109.056 101.053  1.00 42.89           O
HETATM  799  O   HOH B 436     104.734 110.673 103.233  1.00 43.12           O
HETATM  800  O   HOH B 437      90.148 112.700 132.734  1.00 34.31           O
HETATM  801  O   HOH B 438     110.504 118.300 133.041  1.00 31.25           O
HETATM  802  O   HOH B 439     110.537 119.800 131.011  1.00 34.74           O
HETATM  803  O   HOH B 440     106.076  98.190 128.498  1.00 34.70           O
HETATM  804  O   HOH B 441     100.955  94.838  78.936  1.00 56.45           O
HETATM  805  O   HOH B 442      88.911 121.245 128.130  1.00 35.13           O
HETATM  806  O   HOH B 443      92.377 121.778 125.372  1.00 38.16           O
HETATM  807  O   HOH B 444     106.835 112.067 116.320  1.00 42.46           O
HETATM  808  O   HOH B 445     106.142 110.721 119.273  1.00 32.64           O
HETATM  809  O   HOH B 446     101.378 110.854 148.308  1.00 42.17           O
HETATM  810  O   HOH B 447     108.462 117.428 120.718  1.00 38.21           O
HETATM  811  O   HOH B 448      90.724 123.531 134.634  1.00 37.57           O
HETATM  812  O   HOH B 449      93.899  98.152 140.190  1.00 42.10           O
HETATM  813  O   HOH B 450     114.945 123.575 117.030  1.00 53.06           O
HETATM  814  O   HOH B 451     100.514 104.093 116.544  1.00 40.92           O
HETATM  815  O   HOH B 452     118.323 107.479 103.988  1.00 45.50           O
HETATM  816  O   HOH B 453     103.425 100.125  90.904  1.00 44.44           O
HETATM  817  O   HOH B 454      95.281 101.053 140.311  1.00 36.69           O
HETATM  818  O   HOH B 455     106.607 110.073  99.180  1.00 43.06           O
HETATM  819  O   HOH B 456     101.104 106.151  96.059  1.00 40.69           O
HETATM  820  O   HOH B 457     108.725 113.552 118.333  1.00 38.73           O
HETATM  821  O   HOH B 458      99.599  97.419 137.505  1.00 33.17           O
HETATM  822  O   HOH B 459     109.050 109.050 104.433  1.00 45.09           O
HETATM  823  O   HOH B 460     111.508 109.898 122.473  1.00 28.72           O
HETATM  824  O   HOH B 461      90.875 112.317 128.938  1.00 31.62           O
"""
data_7kjr_frag_sym = """
ATOM      1  N   GLN A  70     110.433  95.183 114.087  1.00 47.08           N
ATOM      2  CA  GLN A  70     109.667  96.116 113.269  1.00 47.08           C
ATOM      3  C   GLN A  70     110.416  97.429 113.073  1.00 47.08           C
ATOM      4  O   GLN A  70     110.343  98.032 111.999  1.00 47.08           O
ATOM      5  CB  GLN A  70     108.298  96.365 113.893  1.00 47.08           C
ATOM      6  CG  GLN A  70     107.489  95.110 114.123  1.00 47.08           C
ATOM      7  CD  GLN A  70     106.238  95.365 114.929  1.00 47.08           C
ATOM      8  OE1 GLN A  70     106.244  96.152 115.869  1.00 47.08           O
ATOM      9  NE2 GLN A  70     105.157  94.698 114.566  1.00 47.08           N
ATOM     10  N   LEU A  71     111.145  97.885 114.095  1.00 41.52           N
ATOM     11  CA  LEU A  71     111.954  99.091 113.946  1.00 41.52           C
ATOM     12  C   LEU A  71     113.074  98.883 112.935  1.00 41.52           C
ATOM     13  O   LEU A  71     113.333  99.754 112.095  1.00 41.52           O
ATOM     14  CB  LEU A  71     112.528  99.513 115.298  1.00 41.52           C
ATOM     15  CG  LEU A  71     111.529  99.856 116.402  1.00 41.52           C
ATOM     16  CD1 LEU A  71     112.184  99.736 117.763  1.00 41.52           C
ATOM     17  CD2 LEU A  71     110.975 101.246 116.200  1.00 41.52           C
ATOM     18  N   ALA A  72     113.744  97.730 113.000  1.00 39.97           N
ATOM     19  CA  ALA A  72     114.790  97.427 112.029  1.00 39.97           C
ATOM     20  C   ALA A  72     114.217  97.306 110.622  1.00 39.97           C
ATOM     21  O   ALA A  72     114.822  97.785 109.655  1.00 39.97           O
ATOM     22  CB  ALA A  72     115.526  96.150 112.427  1.00 39.97           C
ATOM     23  N   LEU A  73     113.046  96.677 110.492  1.00 38.66           N
ATOM     24  CA  LEU A  73     112.396  96.559 109.193  1.00 38.66           C
ATOM     25  C   LEU A  73     112.033  97.924 108.627  1.00 38.66           C
ATOM     26  O   LEU A  73     112.250  98.187 107.441  1.00 38.66           O
ATOM     27  CB  LEU A  73     111.150  95.684 109.312  1.00 38.66           C
ATOM     28  CG  LEU A  73     110.277  95.585 108.064  1.00 38.66           C
ATOM     29  CD1 LEU A  73     110.984  94.785 106.983  1.00 38.66           C
ATOM     30  CD2 LEU A  73     108.936  94.971 108.399  1.00 38.66           C
ATOM     31  N   SER A  74     111.493  98.807 109.468  1.00 39.30           N
ATOM     32  CA  SER A  74     111.125 100.145 109.024  1.00 39.30           C
ATOM     33  C   SER A  74     112.347 100.947 108.598  1.00 39.30           C
ATOM     34  O   SER A  74     112.306 101.658 107.588  1.00 39.30           O
ATOM     35  CB  SER A  74     110.369 100.861 110.138  1.00 39.30           C
ATOM     36  OG  SER A  74     109.968 102.157 109.748  1.00 39.30           O
ATOM     37  N   LYS A  75     113.446 100.839 109.349  1.00 38.70           N
ATOM     38  CA  LYS A  75     114.672 101.531 108.964  1.00 38.70           C
ATOM     39  C   LYS A  75     115.238 101.001 107.652  1.00 38.70           C
ATOM     40  O   LYS A  75     115.685 101.790 106.812  1.00 38.70           O
ATOM     41  CB  LYS A  75     115.715 101.414 110.076  1.00 38.70           C
ATOM     42  CG  LYS A  75     115.508 102.361 111.245  1.00 38.70           C
ATOM     43  CD  LYS A  75     114.921 103.690 110.808  1.00 38.70           C
ATOM     44  CE  LYS A  75     114.154 104.361 111.928  1.00 38.70           C
ATOM     45  NZ  LYS A  75     114.997 105.313 112.697  1.00 38.70           N
ATOM     46  N   GLY A  76     115.221  99.682 107.454  1.00 38.10           N
ATOM     47  CA  GLY A  76     115.690  99.130 106.194  1.00 38.10           C
ATOM     48  C   GLY A  76     114.827  99.536 105.015  1.00 38.10           C
ATOM     49  O   GLY A  76     115.339  99.834 103.931  1.00 38.10           O
ATOM     50  N   VAL A  77     113.509  99.567 105.213  1.00 38.63           N
ATOM     51  CA  VAL A  77     112.605  99.982 104.149  1.00 38.63           C
ATOM     52  C   VAL A  77     112.806 101.457 103.824  1.00 38.63           C
ATOM     53  O   VAL A  77     112.778 101.851 102.657  1.00 38.63           O
ATOM     54  CB  VAL A  77     111.148  99.660 104.533  1.00 38.63           C
ATOM     55  CG1 VAL A  77     110.172 100.326 103.587  1.00 38.63           C
ATOM     56  CG2 VAL A  77     110.923  98.163 104.517  1.00 38.63           C
ATOM     57  N   HIS A  78     113.053 102.286 104.842  1.00 40.48           N
ATOM     58  CA  HIS A  78     113.342 103.697 104.601  1.00 40.48           C
ATOM     59  C   HIS A  78     114.657 103.881 103.852  1.00 40.48           C
ATOM     60  O   HIS A  78     114.770 104.765 102.993  1.00 40.48           O
ATOM     61  CB  HIS A  78     113.367 104.456 105.923  1.00 40.48           C
ATOM     62  CG  HIS A  78     112.007 104.766 106.461  1.00 40.48           C
ATOM     63  ND1 HIS A  78     111.645 104.504 107.763  1.00 40.48           N
ATOM     64  CD2 HIS A  78     110.921 105.320 105.873  1.00 40.48           C
ATOM     65  CE1 HIS A  78     110.393 104.877 107.952  1.00 40.48           C
ATOM     66  NE2 HIS A  78     109.932 105.378 106.822  1.00 40.48           N
ATOM     67  N   PHE A  79     115.661 103.062 104.167  1.00 39.77           N
ATOM     68  CA  PHE A  79     116.921 103.115 103.432  1.00 39.77           C
ATOM     69  C   PHE A  79     116.726 102.746 101.964  1.00 39.77           C
ATOM     70  O   PHE A  79     117.266 103.410 101.067  1.00 39.77           O
ATOM     71  CB  PHE A  79     117.939 102.186 104.092  1.00 39.77           C
ATOM     72  CG  PHE A  79     119.306 102.265 103.493  1.00 39.77           C
ATOM     73  CD1 PHE A  79     120.066 103.414 103.620  1.00 39.77           C
ATOM     74  CD2 PHE A  79     119.832 101.193 102.799  1.00 39.77           C
ATOM     75  CE1 PHE A  79     121.325 103.489 103.067  1.00 39.77           C
ATOM     76  CE2 PHE A  79     121.091 101.263 102.247  1.00 39.77           C
ATOM     77  CZ  PHE A  79     121.838 102.413 102.380  1.00 39.77           C
ATOM     78  N   VAL A  80     115.943 101.697 101.702  1.00 39.47           N
ATOM     79  CA  VAL A  80     115.647 101.308 100.324  1.00 39.47           C
ATOM     80  C   VAL A  80     114.849 102.403  99.617  1.00 39.47           C
ATOM     81  O   VAL A  80     115.065 102.680  98.430  1.00 39.47           O
ATOM     82  CB  VAL A  80     114.914  99.953 100.303  1.00 39.47           C
ATOM     83  CG1 VAL A  80     114.404  99.622  98.908  1.00 39.47           C
ATOM     84  CG2 VAL A  80     115.834  98.858 100.795  1.00 39.47           C
TER
ATOM     85  N   LEU A 115     119.909 118.752  99.596  1.00 37.68           N
ATOM     86  CA  LEU A 115     119.178 118.172 100.718  1.00 37.68           C
ATOM     87  C   LEU A 115     119.610 116.731 100.973  1.00 37.68           C
ATOM     88  O   LEU A 115     119.665 116.285 102.124  1.00 37.68           O
ATOM     89  CB  LEU A 115     117.673 118.253 100.469  1.00 37.68           C
ATOM     90  CG  LEU A 115     117.051 119.639 100.264  1.00 37.68           C
ATOM     91  CD1 LEU A 115     115.593 119.529  99.867  1.00 37.68           C
ATOM     92  CD2 LEU A 115     117.212 120.526 101.482  1.00 37.68           C
ATOM     93  N   GLN A 116     119.945 115.993  99.913  1.00 38.20           N
ATOM     94  CA  GLN A 116     120.407 114.620 100.083  1.00 38.20           C
ATOM     95  C   GLN A 116     121.806 114.575 100.685  1.00 38.20           C
ATOM     96  O   GLN A 116     122.131 113.655 101.438  1.00 38.20           O
ATOM     97  CB  GLN A 116     120.368 113.884  98.746  1.00 38.20           C
ATOM     98  CG  GLN A 116     118.983 113.430  98.346  1.00 38.20           C
ATOM     99  CD  GLN A 116     118.418 112.391  99.284  1.00 38.20           C
ATOM    100  OE1 GLN A 116     119.087 111.419  99.626  1.00 38.20           O
ATOM    101  NE2 GLN A 116     117.179 112.588  99.706  1.00 38.20           N
ATOM    102  N   SER A 117     122.647 115.561 100.366  1.00 37.82           N
ATOM    103  CA  SER A 117     123.937 115.682 101.038  1.00 37.82           C
ATOM    104  C   SER A 117     123.752 115.939 102.529  1.00 37.82           C
ATOM    105  O   SER A 117     124.466 115.370 103.367  1.00 37.82           O
ATOM    106  CB  SER A 117     124.757 116.800 100.399  1.00 37.82           C
ATOM    107  OG  SER A 117     125.487 116.320  99.291  1.00 37.82           O
ATOM    108  N   ILE A 118     122.791 116.800 102.874  1.00 38.08           N
ATOM    109  CA  ILE A 118     122.484 117.043 104.283  1.00 38.08           C
ATOM    110  C   ILE A 118     122.008 115.761 104.957  1.00 38.08           C
ATOM    111  O   ILE A 118     122.387 115.460 106.094  1.00 38.08           O
ATOM    112  CB  ILE A 118     121.452 118.179 104.418  1.00 38.08           C
ATOM    113  CG1 ILE A 118     122.060 119.501 103.961  1.00 38.08           C
ATOM    114  CG2 ILE A 118     120.969 118.308 105.849  1.00 38.08           C
ATOM    115  CD1 ILE A 118     121.098 120.646 104.008  1.00 38.08           C
ATOM    116  N   ASN A 119     121.178 114.982 104.263  1.00 38.82           N
ATOM    117  CA  ASN A 119     120.692 113.725 104.825  1.00 38.82           C
ATOM    118  C   ASN A 119     121.821 112.714 105.006  1.00 38.82           C
ATOM    119  O   ASN A 119     121.825 111.943 105.973  1.00 38.82           O
ATOM    120  CB  ASN A 119     119.593 113.154 103.938  1.00 38.82           C
ATOM    121  CG  ASN A 119     119.019 111.871 104.480  1.00 38.82           C
ATOM    122  OD1 ASN A 119     118.497 111.833 105.587  1.00 38.82           O
ATOM    123  ND2 ASN A 119     119.106 110.810 103.696  1.00 38.82           N
ATOM    124  N   PHE A 120     122.781 112.698 104.081  1.00 37.82           N
ATOM    125  CA  PHE A 120     123.957 111.849 104.232  1.00 37.82           C
ATOM    126  C   PHE A 120     124.759 112.233 105.471  1.00 37.82           C
ATOM    127  O   PHE A 120     125.194 111.365 106.240  1.00 37.82           O
ATOM    128  CB  PHE A 120     124.824 111.941 102.979  1.00 37.82           C
ATOM    129  CG  PHE A 120     126.095 111.150 103.065  1.00 37.82           C
ATOM    130  CD1 PHE A 120     126.068 109.767 103.041  1.00 37.82           C
ATOM    131  CD2 PHE A 120     127.315 111.791 103.180  1.00 37.82           C
ATOM    132  CE1 PHE A 120     127.237 109.037 103.122  1.00 37.82           C
ATOM    133  CE2 PHE A 120     128.486 111.067 103.262  1.00 37.82           C
ATOM    134  CZ  PHE A 120     128.447 109.688 103.233  1.00 37.82           C
ATOM    135  N   VAL A 121     124.961 113.538 105.679  1.00 37.70           N
ATOM    136  CA  VAL A 121     125.651 114.006 106.880  1.00 37.70           C
ATOM    137  C   VAL A 121     124.874 113.611 108.134  1.00 37.70           C
ATOM    138  O   VAL A 121     125.460 113.223 109.151  1.00 37.70           O
ATOM    139  CB  VAL A 121     125.882 115.527 106.804  1.00 37.70           C
ATOM    140  CG1 VAL A 121     126.443 116.060 108.108  1.00 37.70           C
ATOM    141  CG2 VAL A 121     126.820 115.854 105.666  1.00 37.70           C
ATOM    142  N   ARG A 122     123.544 113.685 108.071  1.00 40.99           N
ATOM    143  CA  ARG A 122     122.715 113.295 109.207  1.00 40.99           C
ATOM    144  C   ARG A 122     122.852 111.808 109.517  1.00 40.99           C
ATOM    145  O   ARG A 122     122.873 111.410 110.685  1.00 40.99           O
ATOM    146  CB  ARG A 122     121.257 113.652 108.931  1.00 40.99           C
ATOM    147  CG  ARG A 122     120.301 113.257 110.032  1.00 40.99           C
ATOM    148  CD  ARG A 122     118.872 113.271 109.548  1.00 40.99           C
ATOM    149  NE  ARG A 122     118.628 112.257 108.529  1.00 40.99           N
ATOM    150  CZ  ARG A 122     118.330 110.990 108.792  1.00 40.99           C
ATOM    151  NH1 ARG A 122     118.244 110.575 110.046  1.00 40.99           N
ATOM    152  NH2 ARG A 122     118.120 110.138 107.802  1.00 40.99           N
ATOM    153  N   ILE A 123     122.937 110.972 108.482  1.00 38.92           N
ATOM    154  CA  ILE A 123     123.117 109.537 108.691  1.00 38.92           C
ATOM    155  C   ILE A 123     124.487 109.253 109.302  1.00 38.92           C
ATOM    156  O   ILE A 123     124.630 108.384 110.173  1.00 38.92           O
ATOM    157  CB  ILE A 123     122.899 108.781 107.366  1.00 38.92           C
ATOM    158  CG1 ILE A 123     121.404 108.623 107.094  1.00 38.92           C
ATOM    159  CG2 ILE A 123     123.562 107.416 107.381  1.00 38.92           C
ATOM    160  CD1 ILE A 123     121.079 108.310 105.659  1.00 38.92           C
ATOM    161  N   ILE A 124     125.509 110.000 108.875  1.00 38.73           N
ATOM    162  CA  ILE A 124     126.835 109.862 109.478  1.00 38.73           C
ATOM    163  C   ILE A 124     126.792 110.239 110.957  1.00 38.73           C
ATOM    164  O   ILE A 124     127.379 109.560 111.808  1.00 38.73           O
ATOM    165  CB  ILE A 124     127.872 110.706 108.712  1.00 38.73           C
ATOM    166  CG1 ILE A 124     128.016 110.218 107.270  1.00 38.73           C
ATOM    167  CG2 ILE A 124     129.220 110.676 109.410  1.00 38.73           C
ATOM    168  CD1 ILE A 124     128.306 108.748 107.146  1.00 38.73           C
ATOM    169  N   MET A 125     126.093 111.329 111.284  1.00 41.37           N
ATOM    170  CA  MET A 125     125.972 111.733 112.683  1.00 41.37           C
ATOM    171  C   MET A 125     125.183 110.712 113.495  1.00 41.37           C
ATOM    172  O   MET A 125     125.472 110.495 114.674  1.00 41.37           O
ATOM    173  CB  MET A 125     125.331 113.116 112.796  1.00 41.37           C
ATOM    174  CG  MET A 125     126.120 114.235 112.141  1.00 41.37           C
ATOM    175  SD  MET A 125     127.577 114.834 113.033  1.00 41.37           S
ATOM    176  CE  MET A 125     127.222 114.406 114.744  1.00 41.37           C
ATOM    177  N   ARG A 126     124.188 110.073 112.880  1.00 36.50           N
ATOM    178  CA  ARG A 126     123.455 109.009 113.557  1.00 36.50           C
ATOM    179  C   ARG A 126     124.354 107.812 113.852  1.00 36.50           C
ATOM    180  O   ARG A 126     124.275 107.215 114.932  1.00 36.50           O
ATOM    181  CB  ARG A 126     122.256 108.587 112.713  1.00 36.50           C
ATOM    182  CG  ARG A 126     121.069 108.114 113.516  1.00 36.50           C
ATOM    183  CD  ARG A 126     120.428 109.256 114.274  1.00 36.50           C
ATOM    184  NE  ARG A 126     119.364 108.798 115.158  1.00 36.50           N
ATOM    185  CZ  ARG A 126     118.662 109.589 115.959  1.00 36.50           C
ATOM    186  NH1 ARG A 126     118.905 110.887 115.993  1.00 36.50           N
ATOM    187  NH2 ARG A 126     117.712 109.078 116.721  1.00 36.50           N
ATOM    188  N   LEU A 127     125.218 107.450 112.901  1.00 36.90           N
ATOM    189  CA  LEU A 127     126.167 106.365 113.137  1.00 36.90           C
ATOM    190  C   LEU A 127     127.160 106.729 114.232  1.00 36.90           C
ATOM    191  O   LEU A 127     127.553 105.879 115.040  1.00 36.90           O
ATOM    192  CB  LEU A 127     126.907 106.019 111.847  1.00 36.90           C
ATOM    193  CG  LEU A 127     126.072 105.336 110.768  1.00 36.90           C
ATOM    194  CD1 LEU A 127     126.867 105.210 109.486  1.00 36.90           C
ATOM    195  CD2 LEU A 127     125.595 103.981 111.246  1.00 36.90           C
ATOM    196  N   TRP A 128     127.575 107.992 114.275  1.00 40.80           N
ATOM    197  CA  TRP A 128     128.495 108.418 115.320  1.00 40.80           C
ATOM    198  C   TRP A 128     127.807 108.444 116.682  1.00 40.80           C
ATOM    199  O   TRP A 128     128.443 108.206 117.714  1.00 40.80           O
ATOM    200  CB  TRP A 128     129.078 109.785 114.972  1.00 40.80           C
ATOM    201  CG  TRP A 128     130.065 110.243 115.965  1.00 40.80           C
ATOM    202  CD1 TRP A 128     131.399 109.971 115.967  1.00 40.80           C
ATOM    203  CD2 TRP A 128     129.819 111.054 117.111  1.00 40.80           C
ATOM    204  NE1 TRP A 128     131.999 110.557 117.047  1.00 40.80           N
ATOM    205  CE2 TRP A 128     131.050 111.229 117.766  1.00 40.80           C
ATOM    206  CE3 TRP A 128     128.676 111.644 117.652  1.00 40.80           C
ATOM    207  CZ2 TRP A 128     131.173 111.971 118.926  1.00 40.80           C
ATOM    208  CZ3 TRP A 128     128.801 112.376 118.803  1.00 40.80           C
ATOM    209  CH2 TRP A 128     130.042 112.535 119.428  1.00 40.80           C
ATOM    210  N   LEU A 129     126.509 108.753 116.704  1.00 36.45           N
ATOM    211  CA  LEU A 129     125.733 108.658 117.935  1.00 36.45           C
ATOM    212  C   LEU A 129     125.610 107.212 118.390  1.00 36.45           C
ATOM    213  O   LEU A 129     125.633 106.928 119.591  1.00 36.45           O
ATOM    214  CB  LEU A 129     124.353 109.280 117.730  1.00 36.45           C
ATOM    215  CG  LEU A 129     123.513 109.660 118.950  1.00 36.45           C
ATOM    216  CD1 LEU A 129     124.314 110.491 119.931  1.00 36.45           C
ATOM    217  CD2 LEU A 129     122.262 110.402 118.509  1.00 36.45           C
ATOM    218  N   CYS A 130     125.467 106.287 117.441  1.00 35.02           N
ATOM    219  CA  CYS A 130     125.505 104.868 117.776  1.00 35.02           C
ATOM    220  C   CYS A 130     126.842 104.470 118.379  1.00 35.02           C
ATOM    221  O   CYS A 130     126.883 103.703 119.345  1.00 35.02           O
ATOM    222  CB  CYS A 130     125.219 104.018 116.540  1.00 35.02           C
ATOM    223  SG  CYS A 130     123.510 104.011 116.046  1.00 35.02           S
ATOM    224  N   TRP A 131     127.940 104.966 117.814  1.00 35.21           N
ATOM    225  CA  TRP A 131     129.258 104.695 118.376  1.00 35.21           C
ATOM    226  C   TRP A 131     129.406 105.276 119.781  1.00 35.21           C
ATOM    227  O   TRP A 131     129.952 104.618 120.672  1.00 35.21           O
ATOM    228  CB  TRP A 131     130.348 105.249 117.457  1.00 35.21           C
ATOM    229  CG  TRP A 131     131.702 105.256 118.085  1.00 35.21           C
ATOM    230  CD1 TRP A 131     132.606 104.242 118.079  1.00 35.21           C
ATOM    231  CD2 TRP A 131     132.309 106.329 118.810  1.00 35.21           C
ATOM    232  NE1 TRP A 131     133.736 104.610 118.758  1.00 35.21           N
ATOM    233  CE2 TRP A 131     133.577 105.887 119.222  1.00 35.21           C
ATOM    234  CE3 TRP A 131     131.899 107.619 119.158  1.00 35.21           C
ATOM    235  CZ2 TRP A 131     134.443 106.689 119.955  1.00 35.21           C
ATOM    236  CZ3 TRP A 131     132.754 108.409 119.891  1.00 35.21           C
ATOM    237  CH2 TRP A 131     134.014 107.945 120.280  1.00 35.21           C
ATOM    238  N   LYS A 132     128.939 106.506 119.990  1.00 36.62           N
ATOM    239  CA  LYS A 132     129.077 107.140 121.296  1.00 36.62           C
ATOM    240  C   LYS A 132     128.198 106.466 122.343  1.00 36.62           C
ATOM    241  O   LYS A 132     128.629 106.257 123.482  1.00 36.62           O
ATOM    242  CB  LYS A 132     128.739 108.626 121.200  1.00 36.62           C
ATOM    243  CG  LYS A 132     128.939 109.342 122.501  1.00 36.62           C
ATOM    244  CD  LYS A 132     127.920 110.432 122.691  1.00 36.62           C
ATOM    245  CE  LYS A 132     128.424 111.809 122.329  1.00 36.62           C
ATOM    246  NZ  LYS A 132     127.310 112.778 122.136  1.00 36.62           N
ATOM    247  N   CYS A 133     126.969 106.115 121.978  1.00 35.80           N
ATOM    248  CA  CYS A 133     126.069 105.434 122.895  1.00 35.80           C
ATOM    249  C   CYS A 133     126.404 103.961 123.072  1.00 35.80           C
ATOM    250  O   CYS A 133     125.808 103.319 123.942  1.00 35.80           O
ATOM    251  CB  CYS A 133     124.621 105.579 122.421  1.00 35.80           C
ATOM    252  SG  CYS A 133     124.020 107.281 122.345  1.00 35.80           S
TER
ATOM    253  N   PHE C  25      81.165 103.086 113.295  1.00 61.74           N
ATOM    254  CA  PHE C  25      82.615 103.229 113.300  1.00 61.74           C
ATOM    255  C   PHE C  25      83.223 102.314 114.359  1.00 61.74           C
ATOM    256  O   PHE C  25      84.340 101.824 114.195  1.00 61.74           O
ATOM    257  CB  PHE C  25      83.012 104.694 113.545  1.00 61.74           C
ATOM    258  CG  PHE C  25      84.501 104.939 113.552  1.00 61.74           C
ATOM    259  CD1 PHE C  25      85.243 104.820 114.720  1.00 61.74           C
ATOM    260  CD2 PHE C  25      85.152 105.325 112.392  1.00 61.74           C
ATOM    261  CE1 PHE C  25      86.600 105.043 114.717  1.00 61.74           C
ATOM    262  CE2 PHE C  25      86.512 105.555 112.389  1.00 61.74           C
ATOM    263  CZ  PHE C  25      87.235 105.415 113.552  1.00 61.74           C
ATOM    264  N   SER C  26      82.483 102.096 115.448  1.00 69.14           N
ATOM    265  CA  SER C  26      82.995 101.284 116.549  1.00 69.14           C
ATOM    266  C   SER C  26      83.196  99.836 116.121  1.00 69.14           C
ATOM    267  O   SER C  26      84.188  99.196 116.494  1.00 69.14           O
ATOM    268  CB  SER C  26      82.047 101.365 117.744  1.00 69.14           C
ATOM    269  OG  SER C  26      82.568 100.653 118.853  1.00 69.14           O
ATOM    270  N   LYS C  27      82.256  99.301 115.339  1.00 71.21           N
ATOM    271  CA  LYS C  27      82.361  97.929 114.856  1.00 71.21           C
ATOM    272  C   LYS C  27      83.585  97.757 113.964  1.00 71.21           C
ATOM    273  O   LYS C  27      84.315  96.767 114.070  1.00 71.21           O
ATOM    274  CB  LYS C  27      81.084  97.548 114.105  1.00 71.21           C
ATOM    275  CG  LYS C  27      79.807  97.822 114.881  1.00 71.21           C
ATOM    276  CD  LYS C  27      78.575  97.471 114.064  1.00 71.21           C
ATOM    277  CE  LYS C  27      77.300  97.745 114.844  1.00 71.21           C
ATOM    278  NZ  LYS C  27      76.083  97.418 114.051  1.00 71.21           N
ATOM    279  N   LEU C  28      83.830  98.732 113.087  1.00 68.12           N
ATOM    280  CA  LEU C  28      84.998  98.668 112.217  1.00 68.12           C
ATOM    281  C   LEU C  28      86.296  98.725 113.012  1.00 68.12           C
ATOM    282  O   LEU C  28      87.250  98.023 112.677  1.00 68.12           O
ATOM    283  CB  LEU C  28      84.951  99.801 111.193  1.00 68.12           C
ATOM    284  CG  LEU C  28      84.213  99.501 109.888  1.00 68.12           C
ATOM    285  CD1 LEU C  28      83.602 100.771 109.318  1.00 68.12           C
ATOM    286  CD2 LEU C  28      85.146  98.849 108.881  1.00 68.12           C
ATOM    287  N   ARG C  29      86.345  99.538 114.067  1.00 60.94           N
ATOM    288  CA  ARG C  29      87.528  99.603 114.922  1.00 60.94           C
ATOM    289  C   ARG C  29      87.759  98.279 115.647  1.00 60.94           C
ATOM    290  O   ARG C  29      88.897  97.791 115.743  1.00 60.94           O
ATOM    291  CB  ARG C  29      87.354 100.765 115.902  1.00 60.94           C
ATOM    292  CG  ARG C  29      88.264 100.817 117.117  1.00 60.94           C
ATOM    293  CD  ARG C  29      88.119 102.199 117.744  1.00 60.94           C
ATOM    294  NE  ARG C  29      87.617 102.156 119.115  1.00 60.94           N
ATOM    295  CZ  ARG C  29      88.374 102.278 120.199  1.00 60.94           C
ATOM    296  NH1 ARG C  29      89.674 102.493 120.082  1.00 60.94           N
ATOM    297  NH2 ARG C  29      87.820 102.228 121.402  1.00 60.94           N
ATOM    298  N   GLU C  30      86.676  97.675 116.148  1.00 70.38           N
ATOM    299  CA  GLU C  30      86.776  96.377 116.808  1.00 70.38           C
ATOM    300  C   GLU C  30      87.221  95.288 115.839  1.00 70.38           C
ATOM    301  O   GLU C  30      87.901  94.337 116.237  1.00 70.38           O
ATOM    302  CB  GLU C  30      85.437  96.009 117.445  1.00 70.38           C
ATOM    303  CG  GLU C  30      85.057  96.872 118.632  1.00 70.38           C
ATOM    304  CD  GLU C  30      83.614  96.680 119.053  1.00 70.38           C
ATOM    305  OE1 GLU C  30      82.878  95.961 118.346  1.00 70.38           O
ATOM    306  OE2 GLU C  30      83.215  97.250 120.090  1.00 70.38           O
ATOM    307  N   GLN C  31      86.821  95.390 114.572  1.00 68.91           N
ATOM    308  CA  GLN C  31      87.322  94.466 113.558  1.00 68.91           C
ATOM    309  C   GLN C  31      88.791  94.728 113.235  1.00 68.91           C
ATOM    310  O   GLN C  31      89.565  93.795 112.999  1.00 68.91           O
ATOM    311  CB  GLN C  31      86.463  94.550 112.291  1.00 68.91           C
ATOM    312  CG  GLN C  31      85.262  93.587 112.208  1.00 68.91           C
ATOM    313  CD  GLN C  31      84.342  93.590 113.420  1.00 68.91           C
ATOM    314  OE1 GLN C  31      83.322  94.277 113.431  1.00 68.91           O
ATOM    315  NE2 GLN C  31      84.672  92.783 114.424  1.00 68.91           N
ATOM    316  N   LEU C  32      89.190  96.001 113.215  1.00 64.22           N
ATOM    317  CA  LEU C  32      90.523  96.358 112.738  1.00 64.22           C
ATOM    318  C   LEU C  32      91.607  95.995 113.742  1.00 64.22           C
ATOM    319  O   LEU C  32      92.727  95.650 113.347  1.00 64.22           O
ATOM    320  CB  LEU C  32      90.587  97.850 112.416  1.00 64.22           C
ATOM    321  CG  LEU C  32      90.019  98.307 111.075  1.00 64.22           C
ATOM    322  CD1 LEU C  32      90.331  99.775 110.848  1.00 64.22           C
ATOM    323  CD2 LEU C  32      90.564  97.452 109.944  1.00 64.22           C
ATOM    324  N   GLY C  33      91.311  96.102 115.037  1.00 63.47           N
ATOM    325  CA  GLY C  33      92.310  95.877 116.064  1.00 63.47           C
ATOM    326  C   GLY C  33      93.016  94.527 116.031  1.00 63.47           C
ATOM    327  O   GLY C  33      94.226  94.427 115.757  1.00 63.47           O
ATOM    328  N   PRO C  34      92.267  93.457 116.328  1.00 67.34           N
ATOM    329  CA  PRO C  34      92.882  92.120 116.333  1.00 67.34           C
ATOM    330  C   PRO C  34      93.406  91.682 114.980  1.00 67.34           C
ATOM    331  O   PRO C  34      94.340  90.877 114.930  1.00 67.34           O
ATOM    332  CB  PRO C  34      91.742  91.216 116.823  1.00 67.34           C
ATOM    333  CG  PRO C  34      90.834  92.127 117.565  1.00 67.34           C
ATOM    334  CD  PRO C  34      90.881  93.416 116.817  1.00 67.34           C
ATOM    335  N   VAL C  35      92.838  92.186 113.883  1.00 66.77           N
ATOM    336  CA  VAL C  35      93.341  91.838 112.555  1.00 66.77           C
ATOM    337  C   VAL C  35      94.770  92.344 112.380  1.00 66.77           C
ATOM    338  O   VAL C  35      95.665  91.601 111.958  1.00 66.77           O
ATOM    339  CB  VAL C  35      92.399  92.392 111.469  1.00 66.77           C
ATOM    340  CG1 VAL C  35      93.134  92.594 110.154  1.00 66.77           C
ATOM    341  CG2 VAL C  35      91.215  91.465 111.282  1.00 66.77           C
ATOM    342  N   THR C  36      95.007  93.608 112.744  1.00 64.73           N
ATOM    343  CA  THR C  36      96.348  94.182 112.682  1.00 64.73           C
ATOM    344  C   THR C  36      97.303  93.449 113.618  1.00 64.73           C
ATOM    345  O   THR C  36      98.440  93.116 113.238  1.00 64.73           O
ATOM    346  CB  THR C  36      96.280  95.670 113.039  1.00 64.73           C
ATOM    347  OG1 THR C  36      95.406  96.345 112.127  1.00 64.73           O
ATOM    348  CG2 THR C  36      97.654  96.309 112.980  1.00 64.73           C
TER
HETATM  349  O   HOH A 401     111.121 107.036 103.276  1.00 44.72           O
HETATM  350  O   HOH A 402     103.961 102.484 115.168  1.00 45.97           O
HETATM  351  O   HOH A 403     108.059 102.078 143.839  1.00 33.07           O
HETATM  352  O   HOH A 404     110.938 103.892 111.338  1.00 42.67           O
HETATM  353  O   HOH A 405     100.805 103.322 102.487  1.00 40.85           O
HETATM  354  O   HOH A 406     106.839 104.687 135.192  1.00 24.49           O
HETATM  355  O   HOH A 407     124.566  92.207 136.128  1.00 36.29           O
HETATM  356  O   HOH A 408     112.062 117.857 135.428  1.00 29.17           O
HETATM  357  O   HOH A 409     124.899 118.501 132.786  1.00 37.97           O
HETATM  358  O   HOH A 410     110.358 106.260 133.771  1.00 22.31           O
HETATM  359  O   HOH A 411     107.430 102.761 109.359  1.00 44.22           O
HETATM  360  O   HOH A 412     111.579 108.243 126.847  1.00 24.94           O
HETATM  361  O   HOH A 413     107.596 108.364 125.044  1.00 27.88           O
HETATM  362  O   HOH A 414     122.136 116.320 125.770  1.00 31.48           O
HETATM  363  O   HOH A 415     125.139 103.419 126.599  1.00 29.45           O
HETATM  364  O   HOH A 416     108.800 102.343 119.296  1.00 36.24           O
HETATM  365  O   HOH A 417     127.224 103.349 127.780  1.00 33.37           O
HETATM  366  O   HOH A 418     121.142 104.028 135.792  1.00 29.65           O
HETATM  367  O   HOH A 419     112.196 112.472 120.682  1.00 33.87           O
HETATM  368  O   HOH A 420     110.335  98.778 144.877  1.00 36.37           O
HETATM  369  O   HOH A 421     117.133 107.049 113.412  1.00 36.60           O
HETATM  370  O   HOH A 422     111.837 111.540 133.042  1.00 23.71           O
HETATM  371  O   HOH A 423     117.143 123.300  78.615  1.00 57.90           O
HETATM  372  O   HOH A 424     113.432 101.232 123.925  1.00 32.63           O
HETATM  373  O   HOH A 425     120.140 113.814 118.034  1.00 42.03           O
HETATM  374  O   HOH A 426     110.204  99.858 124.317  1.00 33.24           O
HETATM  375  O   HOH A 427     112.764 120.336 132.732  1.00 32.07           O
HETATM  376  O   HOH A 428     108.720 107.734 132.287  1.00 26.04           O
HETATM  377  O   HOH A 429     100.960  97.724 142.414  1.00 39.88           O
HETATM  378  O   HOH A 430     115.795 119.955 124.887  1.00 33.46           O
HETATM  379  O   HOH A 431     113.295 118.394 122.123  1.00 34.62           O
HETATM  380  O   HOH A 432     121.236  99.599 124.203  1.00 35.66           O
HETATM  381  O   HOH A 433     109.838  99.017 134.014  1.00 31.19           O
HETATM  382  O   HOH A 434     128.298  97.892 123.710  1.00 42.56           O
HETATM  383  O   HOH A 435     112.029 119.903 128.488  1.00 34.34           O
HETATM  384  O   HOH A 436     104.673 109.044 101.052  1.00 42.05           O
HETATM  385  O   HOH A 437     113.380 107.431 103.234  1.00 43.31           O
HETATM  386  O   HOH A 438     127.952 105.402 132.728  1.00 32.39           O
HETATM  387  O   HOH A 439     107.560  98.311 131.024  1.00 34.21           O
HETATM  388  O   HOH A 440     107.596  99.789 133.040  1.00 30.58           O
HETATM  389  O   HOH A 441     124.080 119.955 140.076  1.00 41.04           O
HETATM  390  O   HOH A 442     129.189  96.857 128.131  1.00 36.10           O
HETATM  391  O   HOH A 443     111.264 106.034 116.320  1.00 42.40           O
HETATM  392  O   HOH A 444     125.738  96.299 125.388  1.00 39.31           O
HETATM  393  O   HOH A 445     116.727 107.254 148.308  1.00 41.57           O
HETATM  394  O   HOH A 446     111.958 107.387 119.270  1.00 32.37           O
HETATM  395  O   HOH A 447     127.376  94.568 134.634  1.00 38.70           O
HETATM  396  O   HOH A 448     109.636 100.673 120.713  1.00 37.92           O
HETATM  397  O   HOH A 449     103.119  94.530 117.017  1.00 52.42           O
HETATM  398  O   HOH A 450     117.583 114.004 116.543  1.00 41.13           O
HETATM  399  O   HOH A 451     115.593 101.478 124.517  1.00 35.69           O
HETATM  400  O   HOH A 452     114.696 117.988  90.897  1.00 44.25           O
HETATM  401  O   HOH A 453      99.731 110.565 103.965  1.00 46.25           O
HETATM  402  O   HOH A 454     122.827 117.047 140.311  1.00 36.44           O
HETATM  403  O   HOH A 455     111.493 108.024  99.175  1.00 42.74           O
HETATM  404  O   HOH A 456     117.000 111.949  96.057  1.00 40.89           O
HETATM  405  O   HOH A 457     109.370 104.539 118.335  1.00 38.44           O
HETATM  406  O   HOH A 458     118.501 120.682 137.506  1.00 32.24           O
HETATM  407  O   HOH A 459     106.592 108.203 122.473  1.00 28.32           O
HETATM  408  O   HOH A 460     127.226 105.786 128.941  1.00 31.13           O
HETATM  409  O   HOH A 461     109.050 109.050  97.769  1.00 46.65           O
HETATM  410  O   HOH A 462     109.022 109.050 104.424  1.00 45.09           O
ATOM    411  N   GLN B  70     107.692 122.827 114.124  1.00 47.08           N
ATOM    412  CA  GLN B  70     108.458 121.897 113.303  1.00 47.08           C
ATOM    413  C   GLN B  70     107.710 120.584 113.102  1.00 47.08           C
ATOM    414  O   GLN B  70     107.783 119.985 112.026  1.00 47.08           O
ATOM    415  CB  GLN B  70     109.827 121.646 113.926  1.00 47.08           C
ATOM    416  CG  GLN B  70     110.636 122.901 114.160  1.00 47.08           C
ATOM    417  CD  GLN B  70     111.887 122.643 114.965  1.00 47.08           C
ATOM    418  OE1 GLN B  70     111.881 121.853 115.903  1.00 47.08           O
ATOM    419  NE2 GLN B  70     112.968 123.312 114.605  1.00 47.08           N
ATOM    420  N   LEU B  71     106.981 120.125 114.123  1.00 41.52           N
ATOM    421  CA  LEU B  71     106.172 118.919 113.970  1.00 41.52           C
ATOM    422  C   LEU B  71     105.052 119.130 112.959  1.00 41.52           C
ATOM    423  O   LEU B  71     104.793 118.262 112.116  1.00 41.52           O
ATOM    424  CB  LEU B  71     105.598 118.492 115.320  1.00 41.52           C
ATOM    425  CG  LEU B  71     106.597 118.146 116.423  1.00 41.52           C
ATOM    426  CD1 LEU B  71     105.942 118.261 117.784  1.00 41.52           C
ATOM    427  CD2 LEU B  71     107.151 116.757 116.216  1.00 41.52           C
ATOM    428  N   ALA B  72     104.382 120.283 113.028  1.00 39.97           N
ATOM    429  CA  ALA B  72     103.336 120.589 112.058  1.00 39.97           C
ATOM    430  C   ALA B  72     103.909 120.714 110.651  1.00 39.97           C
ATOM    431  O   ALA B  72     103.304 120.238 109.683  1.00 39.97           O
ATOM    432  CB  ALA B  72     102.599 121.864 112.460  1.00 39.97           C
ATOM    433  N   LEU B  73     105.080 121.344 110.523  1.00 38.66           N
ATOM    434  CA  LEU B  73     105.730 121.467 109.225  1.00 38.66           C
ATOM    435  C   LEU B  73     106.093 120.104 108.654  1.00 38.66           C
ATOM    436  O   LEU B  73     105.876 119.845 107.468  1.00 38.66           O
ATOM    437  CB  LEU B  73     106.975 122.342 109.347  1.00 38.66           C
ATOM    438  CG  LEU B  73     107.848 122.445 108.099  1.00 38.66           C
ATOM    439  CD1 LEU B  73     107.141 123.248 107.021  1.00 38.66           C
ATOM    440  CD2 LEU B  73     109.189 123.058 108.436  1.00 38.66           C
ATOM    441  N   SER B  74     106.633 119.218 109.493  1.00 39.30           N
ATOM    442  CA  SER B  74     107.002 117.882 109.044  1.00 39.30           C
ATOM    443  C   SER B  74     105.780 117.081 108.615  1.00 39.30           C
ATOM    444  O   SER B  74     105.821 116.373 107.603  1.00 39.30           O
ATOM    445  CB  SER B  74     107.758 117.162 110.156  1.00 39.30           C
ATOM    446  OG  SER B  74     108.159 115.867 109.762  1.00 39.30           O
ATOM    447  N   LYS B  75     104.681 117.186 109.367  1.00 38.70           N
ATOM    448  CA  LYS B  75     103.455 116.495 108.979  1.00 38.70           C
ATOM    449  C   LYS B  75     102.889 117.029 107.669  1.00 38.70           C
ATOM    450  O   LYS B  75     102.442 116.243 106.826  1.00 38.70           O
ATOM    451  CB  LYS B  75     102.412 116.608 110.092  1.00 38.70           C
ATOM    452  CG  LYS B  75     102.619 115.657 111.257  1.00 38.70           C
ATOM    453  CD  LYS B  75     103.206 114.330 110.816  1.00 38.70           C
ATOM    454  CE  LYS B  75     103.973 113.655 111.934  1.00 38.70           C
ATOM    455  NZ  LYS B  75     103.131 112.700 112.700  1.00 38.70           N
ATOM    456  N   GLY B  76     102.906 118.349 107.475  1.00 38.10           N
ATOM    457  CA  GLY B  76     102.436 118.905 106.217  1.00 38.10           C
ATOM    458  C   GLY B  76     103.300 118.503 105.037  1.00 38.10           C
ATOM    459  O   GLY B  76     102.788 118.208 103.952  1.00 38.10           O
ATOM    460  N   VAL B  77     104.618 118.472 105.235  1.00 38.63           N
ATOM    461  CA  VAL B  77     105.522 118.060 104.170  1.00 38.63           C
ATOM    462  C   VAL B  77     105.321 116.586 103.840  1.00 38.63           C
ATOM    463  O   VAL B  77     105.349 116.196 102.671  1.00 38.63           O
ATOM    464  CB  VAL B  77     106.979 118.381 104.555  1.00 38.63           C
ATOM    465  CG1 VAL B  77     107.955 117.719 103.607  1.00 38.63           C
ATOM    466  CG2 VAL B  77     107.203 119.879 104.544  1.00 38.63           C
ATOM    467  N   HIS B  78     105.074 115.754 104.855  1.00 40.48           N
ATOM    468  CA  HIS B  78     104.786 114.344 104.609  1.00 40.48           C
ATOM    469  C   HIS B  78     103.471 114.162 103.859  1.00 40.48           C
ATOM    470  O   HIS B  78     103.358 113.281 102.998  1.00 40.48           O
ATOM    471  CB  HIS B  78     104.761 113.580 105.929  1.00 40.48           C
ATOM    472  CG  HIS B  78     106.121 113.269 106.466  1.00 40.48           C
ATOM    473  ND1 HIS B  78     106.483 113.527 107.769  1.00 40.48           N
ATOM    474  CD2 HIS B  78     107.207 112.717 105.876  1.00 40.48           C
ATOM    475  CE1 HIS B  78     107.735 113.153 107.956  1.00 40.48           C
ATOM    476  NE2 HIS B  78     108.196 112.656 106.825  1.00 40.48           N
ATOM    477  N   PHE B  79     102.467 114.980 104.177  1.00 39.77           N
ATOM    478  CA  PHE B  79     101.207 114.929 103.442  1.00 39.77           C
ATOM    479  C   PHE B  79     101.402 115.303 101.975  1.00 39.77           C
ATOM    480  O   PHE B  79     100.862 114.641 101.076  1.00 39.77           O
ATOM    481  CB  PHE B  79     100.188 115.855 104.105  1.00 39.77           C
ATOM    482  CG  PHE B  79      98.822 115.778 103.505  1.00 39.77           C
ATOM    483  CD1 PHE B  79      98.062 114.628 103.629  1.00 39.77           C
ATOM    484  CD2 PHE B  79      98.295 116.852 102.815  1.00 39.77           C
ATOM    485  CE1 PHE B  79      96.803 114.555 103.075  1.00 39.77           C
ATOM    486  CE2 PHE B  79      97.036 116.783 102.263  1.00 39.77           C
ATOM    487  CZ  PHE B  79      96.290 115.633 102.392  1.00 39.77           C
ATOM    488  N   VAL B  80     102.185 116.353 101.717  1.00 39.47           N
ATOM    489  CA  VAL B  80     102.481 116.746 100.340  1.00 39.47           C
ATOM    490  C   VAL B  80     103.279 115.654  99.629  1.00 39.47           C
ATOM    491  O   VAL B  80     103.063 115.381  98.441  1.00 39.47           O
ATOM    492  CB  VAL B  80     103.213 118.102 100.324  1.00 39.47           C
ATOM    493  CG1 VAL B  80     103.723 118.437  98.930  1.00 39.47           C
ATOM    494  CG2 VAL B  80     102.293 119.195 100.819  1.00 39.47           C
TER
ATOM    495  N   LEU B 115      98.223  99.304  99.554  1.00 37.68           N
ATOM    496  CA  LEU B 115      98.954  99.880 100.678  1.00 37.68           C
ATOM    497  C   LEU B 115      98.521 101.320 100.937  1.00 37.68           C
ATOM    498  O   LEU B 115      98.466 101.762 102.090  1.00 37.68           O
ATOM    499  CB  LEU B 115     100.459  99.800 100.428  1.00 37.68           C
ATOM    500  CG  LEU B 115     101.081  98.415 100.219  1.00 37.68           C
ATOM    501  CD1 LEU B 115     102.539  98.527  99.822  1.00 37.68           C
ATOM    502  CD2 LEU B 115     100.920  97.524 101.434  1.00 37.68           C
ATOM    503  N   GLN B 116      98.186 102.062  99.880  1.00 38.20           N
ATOM    504  CA  GLN B 116      97.724 103.434 100.054  1.00 38.20           C
ATOM    505  C   GLN B 116      96.325 103.477 100.656  1.00 38.20           C
ATOM    506  O   GLN B 116      96.000 104.394 101.412  1.00 38.20           O
ATOM    507  CB  GLN B 116      97.763 104.174  98.720  1.00 38.20           C
ATOM    508  CG  GLN B 116      99.148 104.630  98.321  1.00 38.20           C
ATOM    509  CD  GLN B 116      99.712 105.666  99.263  1.00 38.20           C
ATOM    510  OE1 GLN B 116      99.043 106.637  99.608  1.00 38.20           O
ATOM    511  NE2 GLN B 116     100.952 105.468  99.684  1.00 38.20           N
ATOM    512  N   SER B 117      95.484 102.491 100.334  1.00 37.82           N
ATOM    513  CA  SER B 117      94.194 102.368 101.006  1.00 37.82           C
ATOM    514  C   SER B 117      94.379 102.106 102.496  1.00 37.82           C
ATOM    515  O   SER B 117      93.665 102.672 103.336  1.00 37.82           O
ATOM    516  CB  SER B 117      93.375 101.252 100.363  1.00 37.82           C
ATOM    517  OG  SER B 117      92.645 101.735  99.256  1.00 37.82           O
ATOM    518  N   ILE B 118      95.340 101.244 102.838  1.00 38.08           N
ATOM    519  CA  ILE B 118      95.647 100.996 104.246  1.00 38.08           C
ATOM    520  C   ILE B 118      96.123 102.276 104.924  1.00 38.08           C
ATOM    521  O   ILE B 118      95.744 102.573 106.062  1.00 38.08           O
ATOM    522  CB  ILE B 118      96.680  99.860 104.377  1.00 38.08           C
ATOM    523  CG1 ILE B 118      96.072  98.540 103.916  1.00 38.08           C
ATOM    524  CG2 ILE B 118      97.163  99.727 105.808  1.00 38.08           C
ATOM    525  CD1 ILE B 118      97.034  97.395 103.959  1.00 38.08           C
ATOM    526  N   ASN B 119      96.953 103.058 104.233  1.00 38.82           N
ATOM    527  CA  ASN B 119      97.438 104.313 104.799  1.00 38.82           C
ATOM    528  C   ASN B 119      96.309 105.323 104.984  1.00 38.82           C
ATOM    529  O   ASN B 119      96.305 106.091 105.953  1.00 38.82           O
ATOM    530  CB  ASN B 119      98.537 104.887 103.914  1.00 38.82           C
ATOM    531  CG  ASN B 119      99.111 106.169 104.461  1.00 38.82           C
ATOM    532  OD1 ASN B 119      99.633 106.203 105.568  1.00 38.82           O
ATOM    533  ND2 ASN B 119      99.024 107.232 103.680  1.00 38.82           N
ATOM    534  N   PHE B 120      95.349 105.342 104.059  1.00 37.82           N
ATOM    535  CA  PHE B 120      94.173 106.190 104.212  1.00 37.82           C
ATOM    536  C   PHE B 120      93.371 105.802 105.450  1.00 37.82           C
ATOM    537  O   PHE B 120      92.936 106.667 106.222  1.00 37.82           O
ATOM    538  CB  PHE B 120      93.306 106.102 102.959  1.00 37.82           C
ATOM    539  CG  PHE B 120      92.035 106.893 103.047  1.00 37.82           C
ATOM    540  CD1 PHE B 120      92.062 108.276 103.028  1.00 37.82           C
ATOM    541  CD2 PHE B 120      90.815 106.251 103.160  1.00 37.82           C
ATOM    542  CE1 PHE B 120      90.892 109.005 103.111  1.00 37.82           C
ATOM    543  CE2 PHE B 120      89.644 106.974 103.245  1.00 37.82           C
ATOM    544  CZ  PHE B 120      89.682 108.353 103.220  1.00 37.82           C
ATOM    545  N   VAL B 121      93.169 104.496 105.654  1.00 37.70           N
ATOM    546  CA  VAL B 121      92.479 104.024 106.853  1.00 37.70           C
ATOM    547  C   VAL B 121      93.256 104.415 108.108  1.00 37.70           C
ATOM    548  O   VAL B 121      92.670 104.799 109.127  1.00 37.70           O
ATOM    549  CB  VAL B 121      92.249 102.503 106.772  1.00 37.70           C
ATOM    550  CG1 VAL B 121      91.688 101.966 108.074  1.00 37.70           C
ATOM    551  CG2 VAL B 121      91.311 102.180 105.633  1.00 37.70           C
ATOM    552  N   ARG B 122      94.586 104.342 108.045  1.00 40.99           N
ATOM    553  CA  ARG B 122      95.415 104.728 109.183  1.00 40.99           C
ATOM    554  C   ARG B 122      95.278 106.214 109.497  1.00 40.99           C
ATOM    555  O   ARG B 122      95.256 106.608 110.667  1.00 40.99           O
ATOM    556  CB  ARG B 122      96.873 104.372 108.905  1.00 40.99           C
ATOM    557  CG  ARG B 122      97.829 104.764 110.008  1.00 40.99           C
ATOM    558  CD  ARG B 122      99.258 104.752 109.524  1.00 40.99           C
ATOM    559  NE  ARG B 122      99.502 105.769 108.508  1.00 40.99           N
ATOM    560  CZ  ARG B 122      99.799 107.035 108.776  1.00 40.99           C
ATOM    561  NH1 ARG B 122      99.885 107.446 110.031  1.00 40.99           N
ATOM    562  NH2 ARG B 122     100.009 107.891 107.788  1.00 40.99           N
ATOM    563  N   ILE B 123      95.192 107.053 108.465  1.00 38.92           N
ATOM    564  CA  ILE B 123      95.012 108.488 108.679  1.00 38.92           C
ATOM    565  C   ILE B 123      93.642 108.769 109.291  1.00 38.92           C
ATOM    566  O   ILE B 123      93.499 109.635 110.165  1.00 38.92           O
ATOM    567  CB  ILE B 123      95.230 109.248 107.357  1.00 38.92           C
ATOM    568  CG1 ILE B 123      96.725 109.407 107.085  1.00 38.92           C
ATOM    569  CG2 ILE B 123      94.567 110.613 107.376  1.00 38.92           C
ATOM    570  CD1 ILE B 123      97.050 109.725 105.651  1.00 38.92           C
ATOM    571  N   ILE B 124      92.620 108.023 108.861  1.00 38.73           N
ATOM    572  CA  ILE B 124      91.294 108.159 109.465  1.00 38.73           C
ATOM    573  C   ILE B 124      91.337 107.777 110.942  1.00 38.73           C
ATOM    574  O   ILE B 124      90.750 108.453 111.796  1.00 38.73           O
ATOM    575  CB  ILE B 124      90.257 107.317 108.696  1.00 38.73           C
ATOM    576  CG1 ILE B 124      90.113 107.810 107.255  1.00 38.73           C
ATOM    577  CG2 ILE B 124      88.909 107.345 109.394  1.00 38.73           C
ATOM    578  CD1 ILE B 124      89.823 109.280 107.136  1.00 38.73           C
ATOM    579  N   MET B 125      92.036 106.686 111.266  1.00 41.37           N
ATOM    580  CA  MET B 125      92.157 106.278 112.663  1.00 41.37           C
ATOM    581  C   MET B 125      92.946 107.296 113.479  1.00 41.37           C
ATOM    582  O   MET B 125      92.657 107.509 114.659  1.00 41.37           O
ATOM    583  CB  MET B 125      92.799 104.894 112.772  1.00 41.37           C
ATOM    584  CG  MET B 125      92.010 103.777 112.113  1.00 41.37           C
ATOM    585  SD  MET B 125      90.553 103.175 113.003  1.00 41.37           S
ATOM    586  CE  MET B 125      90.908 103.597 114.715  1.00 41.37           C
ATOM    587  N   ARG B 126      93.941 107.937 112.866  1.00 36.50           N
ATOM    588  CA  ARG B 126      94.674 108.999 113.547  1.00 36.50           C
ATOM    589  C   ARG B 126      93.774 110.195 113.846  1.00 36.50           C
ATOM    590  O   ARG B 126      93.853 110.789 114.928  1.00 36.50           O
ATOM    591  CB  ARG B 126      95.872 109.424 112.704  1.00 36.50           C
ATOM    592  CG  ARG B 126      97.059 109.895 113.509  1.00 36.50           C
ATOM    593  CD  ARG B 126      97.701 108.751 114.263  1.00 36.50           C
ATOM    594  NE  ARG B 126      98.764 109.206 115.149  1.00 36.50           N
ATOM    595  CZ  ARG B 126      99.467 108.413 115.947  1.00 36.50           C
ATOM    596  NH1 ARG B 126      99.224 107.114 115.977  1.00 36.50           N
ATOM    597  NH2 ARG B 126     100.416 108.921 116.711  1.00 36.50           N
ATOM    598  N   LEU B 127      92.910 110.560 112.896  1.00 36.90           N
ATOM    599  CA  LEU B 127      91.961 111.644 113.135  1.00 36.90           C
ATOM    600  C   LEU B 127      90.968 111.276 114.229  1.00 36.90           C
ATOM    601  O   LEU B 127      90.575 112.123 115.040  1.00 36.90           O
ATOM    602  CB  LEU B 127      91.221 111.994 111.846  1.00 36.90           C
ATOM    603  CG  LEU B 127      92.056 112.681 110.770  1.00 36.90           C
ATOM    604  CD1 LEU B 127      91.261 112.811 109.488  1.00 36.90           C
ATOM    605  CD2 LEU B 127      92.532 114.034 111.252  1.00 36.90           C
ATOM    606  N   TRP B 128      90.553 110.013 114.268  1.00 40.80           N
ATOM    607  CA  TRP B 128      89.633 109.583 115.311  1.00 40.80           C
ATOM    608  C   TRP B 128      90.321 109.553 116.673  1.00 40.80           C
ATOM    609  O   TRP B 128      89.685 109.787 117.706  1.00 40.80           O
ATOM    610  CB  TRP B 128      89.051 108.217 114.959  1.00 40.80           C
ATOM    611  CG  TRP B 128      88.064 107.756 115.950  1.00 40.80           C
ATOM    612  CD1 TRP B 128      86.730 108.027 115.953  1.00 40.80           C
ATOM    613  CD2 TRP B 128      88.310 106.941 117.093  1.00 40.80           C
ATOM    614  NE1 TRP B 128      86.130 107.437 117.031  1.00 40.80           N
ATOM    615  CE2 TRP B 128      87.079 106.763 117.748  1.00 40.80           C
ATOM    616  CE3 TRP B 128      89.453 106.349 117.633  1.00 40.80           C
ATOM    617  CZ2 TRP B 128      86.956 106.017 118.905  1.00 40.80           C
ATOM    618  CZ3 TRP B 128      89.328 105.613 118.781  1.00 40.80           C
ATOM    619  CH2 TRP B 128      88.087 105.452 119.405  1.00 40.80           C
ATOM    620  N   LEU B 129      91.619 109.244 116.694  1.00 36.45           N
ATOM    621  CA  LEU B 129      92.395 109.335 117.926  1.00 36.45           C
ATOM    622  C   LEU B 129      92.518 110.780 118.385  1.00 36.45           C
ATOM    623  O   LEU B 129      92.495 111.060 119.587  1.00 36.45           O
ATOM    624  CB  LEU B 129      93.775 108.714 117.719  1.00 36.45           C
ATOM    625  CG  LEU B 129      94.615 108.330 118.937  1.00 36.45           C
ATOM    626  CD1 LEU B 129      93.814 107.496 119.916  1.00 36.45           C
ATOM    627  CD2 LEU B 129      95.867 107.590 118.494  1.00 36.45           C
ATOM    628  N   CYS B 130      92.661 111.708 117.440  1.00 35.02           N
ATOM    629  CA  CYS B 130      92.622 113.126 117.779  1.00 35.02           C
ATOM    630  C   CYS B 130      91.285 113.521 118.384  1.00 35.02           C
ATOM    631  O   CYS B 130      91.244 114.285 119.352  1.00 35.02           O
ATOM    632  CB  CYS B 130      92.908 113.980 116.546  1.00 35.02           C
ATOM    633  SG  CYS B 130      94.617 113.989 116.052  1.00 35.02           S
ATOM    634  N   TRP B 131      90.187 113.027 117.817  1.00 35.21           N
ATOM    635  CA  TRP B 131      88.869 113.296 118.380  1.00 35.21           C
ATOM    636  C   TRP B 131      88.721 112.710 119.783  1.00 35.21           C
ATOM    637  O   TRP B 131      88.175 113.365 120.676  1.00 35.21           O
ATOM    638  CB  TRP B 131      87.779 112.745 117.459  1.00 35.21           C
ATOM    639  CG  TRP B 131      86.425 112.735 118.087  1.00 35.21           C
ATOM    640  CD1 TRP B 131      85.521 113.749 118.084  1.00 35.21           C
ATOM    641  CD2 TRP B 131      85.818 111.660 118.808  1.00 35.21           C
ATOM    642  NE1 TRP B 131      84.391 113.378 118.762  1.00 35.21           N
ATOM    643  CE2 TRP B 131      84.550 112.100 119.221  1.00 35.21           C
ATOM    644  CE3 TRP B 131      86.229 110.368 119.152  1.00 35.21           C
ATOM    645  CZ2 TRP B 131      83.684 111.295 119.952  1.00 35.21           C
ATOM    646  CZ3 TRP B 131      85.374 109.576 119.882  1.00 35.21           C
ATOM    647  CH2 TRP B 131      84.114 110.038 120.272  1.00 35.21           C
ATOM    648  N   LYS B 132      89.188 111.479 119.988  1.00 36.62           N
ATOM    649  CA  LYS B 132      89.050 110.841 121.291  1.00 36.62           C
ATOM    650  C   LYS B 132      89.929 111.512 122.341  1.00 36.62           C
ATOM    651  O   LYS B 132      89.498 111.717 123.480  1.00 36.62           O
ATOM    652  CB  LYS B 132      89.389 109.356 121.191  1.00 36.62           C
ATOM    653  CG  LYS B 132      89.189 108.635 122.489  1.00 36.62           C
ATOM    654  CD  LYS B 132      90.208 107.545 122.676  1.00 36.62           C
ATOM    655  CE  LYS B 132      89.705 106.169 122.309  1.00 36.62           C
ATOM    656  NZ  LYS B 132      90.819 105.201 122.113  1.00 36.62           N
ATOM    657  N   CYS B 133      91.158 111.864 121.977  1.00 35.80           N
ATOM    658  CA  CYS B 133      92.058 112.543 122.896  1.00 35.80           C
ATOM    659  C   CYS B 133      91.723 114.015 123.078  1.00 35.80           C
ATOM    660  O   CYS B 133      92.318 114.654 123.950  1.00 35.80           O
ATOM    661  CB  CYS B 133      93.506 112.400 122.422  1.00 35.80           C
ATOM    662  SG  CYS B 133      94.107 110.698 122.340  1.00 35.80           S
TER
ATOM    663  N   PHE D  25     136.962 114.934 113.308  1.00 61.74           N
ATOM    664  CA  PHE D  25     135.512 114.791 113.312  1.00 61.74           C
ATOM    665  C   PHE D  25     134.904 115.702 114.374  1.00 61.74           C
ATOM    666  O   PHE D  25     133.787 116.192 114.212  1.00 61.74           O
ATOM    667  CB  PHE D  25     135.115 113.325 113.552  1.00 61.74           C
ATOM    668  CG  PHE D  25     133.626 113.079 113.558  1.00 61.74           C
ATOM    669  CD1 PHE D  25     132.884 113.194 114.726  1.00 61.74           C
ATOM    670  CD2 PHE D  25     132.976 112.697 112.397  1.00 61.74           C
ATOM    671  CE1 PHE D  25     131.527 112.971 114.723  1.00 61.74           C
ATOM    672  CE2 PHE D  25     131.616 112.467 112.393  1.00 61.74           C
ATOM    673  CZ  PHE D  25     130.893 112.603 113.556  1.00 61.74           C
ATOM    674  N   SER D  26     135.644 115.917 115.464  1.00 69.14           N
ATOM    675  CA  SER D  26     135.131 116.725 116.567  1.00 69.14           C
ATOM    676  C   SER D  26     134.930 118.174 116.144  1.00 69.14           C
ATOM    677  O   SER D  26     133.938 118.813 116.519  1.00 69.14           O
ATOM    678  CB  SER D  26     136.079 116.640 117.762  1.00 69.14           C
ATOM    679  OG  SER D  26     135.558 117.348 118.874  1.00 69.14           O
ATOM    680  N   LYS D  27     135.870 118.712 115.364  1.00 71.21           N
ATOM    681  CA  LYS D  27     135.765 120.086 114.886  1.00 71.21           C
ATOM    682  C   LYS D  27     134.541 120.260 113.994  1.00 71.21           C
ATOM    683  O   LYS D  27     133.810 121.250 114.103  1.00 71.21           O
ATOM    684  CB  LYS D  27     137.041 120.470 114.136  1.00 71.21           C
ATOM    685  CG  LYS D  27     138.319 120.193 114.911  1.00 71.21           C
ATOM    686  CD  LYS D  27     139.550 120.547 114.095  1.00 71.21           C
ATOM    687  CE  LYS D  27     140.825 120.271 114.875  1.00 71.21           C
ATOM    688  NZ  LYS D  27     142.042 120.601 114.083  1.00 71.21           N
ATOM    689  N   LEU D  28     134.296 119.288 113.114  1.00 68.12           N
ATOM    690  CA  LEU D  28     133.128 119.355 112.244  1.00 68.12           C
ATOM    691  C   LEU D  28     131.830 119.295 113.039  1.00 68.12           C
ATOM    692  O   LEU D  28     130.876 119.998 112.706  1.00 68.12           O
ATOM    693  CB  LEU D  28     133.175 118.225 111.216  1.00 68.12           C
ATOM    694  CG  LEU D  28     133.913 118.530 109.912  1.00 68.12           C
ATOM    695  CD1 LEU D  28     134.525 117.262 109.338  1.00 68.12           C
ATOM    696  CD2 LEU D  28     132.980 119.185 108.907  1.00 68.12           C
ATOM    697  N   ARG D  29     131.781 118.478 114.091  1.00 60.94           N
ATOM    698  CA  ARG D  29     130.598 118.410 114.946  1.00 60.94           C
ATOM    699  C   ARG D  29     130.367 119.732 115.675  1.00 60.94           C
ATOM    700  O   ARG D  29     129.228 120.219 115.773  1.00 60.94           O
ATOM    701  CB  ARG D  29     130.772 117.245 115.922  1.00 60.94           C
ATOM    702  CG  ARG D  29     129.862 117.189 117.137  1.00 60.94           C
ATOM    703  CD  ARG D  29     130.007 115.805 117.759  1.00 60.94           C
ATOM    704  NE  ARG D  29     130.509 115.843 119.130  1.00 60.94           N
ATOM    705  CZ  ARG D  29     129.752 115.717 120.214  1.00 60.94           C
ATOM    706  NH1 ARG D  29     128.452 115.502 120.096  1.00 60.94           N
ATOM    707  NH2 ARG D  29     130.306 115.764 121.417  1.00 60.94           N
ATOM    708  N   GLU D  30     131.449 120.334 116.178  1.00 70.38           N
ATOM    709  CA  GLU D  30     131.349 121.630 116.842  1.00 70.38           C
ATOM    710  C   GLU D  30     130.904 122.722 115.877  1.00 70.38           C
ATOM    711  O   GLU D  30     130.223 123.672 116.278  1.00 70.38           O
ATOM    712  CB  GLU D  30     132.688 121.996 117.481  1.00 70.38           C
ATOM    713  CG  GLU D  30     133.068 121.129 118.665  1.00 70.38           C
ATOM    714  CD  GLU D  30     134.511 121.320 119.087  1.00 70.38           C
ATOM    715  OE1 GLU D  30     135.247 122.042 118.382  1.00 70.38           O
ATOM    716  OE2 GLU D  30     134.910 120.747 120.122  1.00 70.38           O
ATOM    717  N   GLN D  31     131.304 122.624 114.610  1.00 68.91           N
ATOM    718  CA  GLN D  31     130.803 123.552 113.599  1.00 68.91           C
ATOM    719  C   GLN D  31     129.334 123.290 113.275  1.00 68.91           C
ATOM    720  O   GLN D  31     128.560 124.224 113.042  1.00 68.91           O
ATOM    721  CB  GLN D  31     131.662 123.472 112.332  1.00 68.91           C
ATOM    722  CG  GLN D  31     132.863 124.436 112.252  1.00 68.91           C
ATOM    723  CD  GLN D  31     133.783 124.429 113.464  1.00 68.91           C
ATOM    724  OE1 GLN D  31     134.803 123.742 113.473  1.00 68.91           O
ATOM    725  NE2 GLN D  31     133.452 125.232 114.471  1.00 68.91           N
ATOM    726  N   LEU D  32     128.935 122.017 113.251  1.00 64.22           N
ATOM    727  CA  LEU D  32     127.602 121.662 112.772  1.00 64.22           C
ATOM    728  C   LEU D  32     126.518 122.021 113.777  1.00 64.22           C
ATOM    729  O   LEU D  32     125.398 122.367 113.383  1.00 64.22           O
ATOM    730  CB  LEU D  32     127.539 120.171 112.445  1.00 64.22           C
ATOM    731  CG  LEU D  32     128.107 119.718 111.103  1.00 64.22           C
ATOM    732  CD1 LEU D  32     127.795 118.251 110.871  1.00 64.22           C
ATOM    733  CD2 LEU D  32     127.562 120.577 109.975  1.00 64.22           C
ATOM    734  N   GLY D  33     126.814 121.910 115.072  1.00 63.47           N
ATOM    735  CA  GLY D  33     125.815 122.131 116.100  1.00 63.47           C
ATOM    736  C   GLY D  33     125.109 123.481 116.071  1.00 63.47           C
ATOM    737  O   GLY D  33     123.899 123.582 115.797  1.00 63.47           O
ATOM    738  N   PRO D  34     125.857 124.550 116.372  1.00 67.34           N
ATOM    739  CA  PRO D  34     125.242 125.887 116.381  1.00 67.34           C
ATOM    740  C   PRO D  34     124.718 126.329 115.030  1.00 67.34           C
ATOM    741  O   PRO D  34     123.784 127.134 114.982  1.00 67.34           O
ATOM    742  CB  PRO D  34     126.382 126.790 116.874  1.00 67.34           C
ATOM    743  CG  PRO D  34     127.290 125.876 117.613  1.00 67.34           C
ATOM    744  CD  PRO D  34     127.243 124.590 116.861  1.00 67.34           C
ATOM    745  N   VAL D  35     125.286 125.829 113.931  1.00 66.77           N
ATOM    746  CA  VAL D  35     124.783 126.181 112.604  1.00 66.77           C
ATOM    747  C   VAL D  35     123.354 125.676 112.427  1.00 66.77           C
ATOM    748  O   VAL D  35     122.459 126.420 112.008  1.00 66.77           O
ATOM    749  CB  VAL D  35     125.725 125.631 111.516  1.00 66.77           C
ATOM    750  CG1 VAL D  35     124.990 125.433 110.201  1.00 66.77           C
ATOM    751  CG2 VAL D  35     126.909 126.559 111.332  1.00 66.77           C
ATOM    752  N   THR D  36     123.118 124.410 112.787  1.00 64.73           N
ATOM    753  CA  THR D  36     121.777 123.836 112.723  1.00 64.73           C
ATOM    754  C   THR D  36     120.821 124.566 113.661  1.00 64.73           C
ATOM    755  O   THR D  36     119.684 124.900 113.282  1.00 64.73           O
ATOM    756  CB  THR D  36     121.845 122.347 113.075  1.00 64.73           C
ATOM    757  OG1 THR D  36     122.719 121.675 112.161  1.00 64.73           O
ATOM    758  CG2 THR D  36     120.471 121.708 113.014  1.00 64.73           C
TER
HETATM  759  O   HOH B 401     107.008 111.010 103.273  1.00 44.72           O
HETATM  760  O   HOH B 402     114.166 115.524 115.181  1.00 45.97           O
HETATM  761  O   HOH B 403     110.065 115.834 143.853  1.00 33.07           O
HETATM  762  O   HOH B 404     107.189 114.127 111.346  1.00 42.67           O
HETATM  763  O   HOH B 405     117.323 114.729 102.497  1.00 40.85           O
HETATM  764  O   HOH B 406     111.287 113.254 135.197  1.00 24.49           O
HETATM  765  O   HOH B 407      93.556 125.726 136.173  1.00 36.29           O
HETATM  766  O   HOH B 408     106.067 100.082 135.389  1.00 29.17           O
HETATM  767  O   HOH B 409      93.231  99.443 132.744  1.00 37.97           O
HETATM  768  O   HOH B 410     107.768 111.685 133.771  1.00 22.31           O
HETATM  769  O   HOH B 411     110.697 115.265 109.371  1.00 44.22           O
HETATM  770  O   HOH B 412     106.548 109.724 126.840  1.00 24.94           O
HETATM  771  O   HOH B 413     110.532 109.610 125.037  1.00 27.88           O
HETATM  772  O   HOH B 414      95.994 101.648 125.735  1.00 31.48           O
HETATM  773  O   HOH B 415      92.987 114.545 126.607  1.00 29.45           O
HETATM  774  O   HOH B 416     109.326 115.650 119.309  1.00 36.24           O
HETATM  775  O   HOH B 417      90.902 114.611 127.788  1.00 33.37           O
HETATM  776  O   HOH B 418      96.984 113.907 135.798  1.00 29.65           O
HETATM  777  O   HOH B 419     105.933 105.516 120.661  1.00 33.87           O
HETATM  778  O   HOH B 420     107.789 119.130 144.902  1.00 36.37           O
HETATM  779  O   HOH B 421     100.995 110.961 113.409  1.00 36.60           O
HETATM  780  O   HOH B 422     106.291 106.407 133.024  1.00 23.71           O
HETATM  781  O   HOH B 423     100.992  94.826  78.558  1.00 57.90           O
HETATM  782  O   HOH B 424     104.694 116.744 123.941  1.00 32.63           O
HETATM  783  O   HOH B 425      97.989 104.180 118.008  1.00 42.03           O
HETATM  784  O   HOH B 426     107.921 118.118 124.338  1.00 33.24           O
HETATM  785  O   HOH B 427     105.366  97.611 132.685  1.00 32.07           O
HETATM  786  O   HOH B 428     109.407 110.216 132.282  1.00 26.04           O
HETATM  787  O   HOH B 429     117.163 120.194 142.443  1.00 39.88           O
HETATM  788  O   HOH B 430     102.336  98.018 124.841  1.00 33.46           O
HETATM  789  O   HOH B 431     104.835  99.589 122.082  1.00 34.62           O
HETATM  790  O   HOH B 432      96.889 118.374 124.224  1.00 35.66           O
HETATM  791  O   HOH B 433     108.286 118.927 134.038  1.00 31.19           O
HETATM  792  O   HOH B 434      89.827 120.081 123.736  1.00 42.56           O
HETATM  793  O   HOH B 435     106.101  98.059 128.442  1.00 34.34           O
HETATM  794  O   HOH B 436     113.456 109.011 101.043  1.00 42.05           O
HETATM  795  O   HOH B 437     104.749 110.614 103.230  1.00 43.31           O
HETATM  796  O   HOH B 438      90.174 112.541 132.729  1.00 32.39           O
HETATM  797  O   HOH B 439     110.564 119.643 131.050  1.00 34.21           O
HETATM  798  O   HOH B 440     110.529 118.159 133.061  1.00 30.58           O
HETATM  799  O   HOH B 441      94.049  97.965 140.029  1.00 41.04           O
HETATM  800  O   HOH B 442      88.935 121.101 128.161  1.00 36.10           O
HETATM  801  O   HOH B 443     106.864 111.968 116.320  1.00 42.40           O
HETATM  802  O   HOH B 444      92.386 121.669 125.420  1.00 39.31           O
HETATM  803  O   HOH B 445     101.399 110.641 148.304  1.00 41.57           O
HETATM  804  O   HOH B 446     106.170 110.605 119.266  1.00 32.37           O
HETATM  805  O   HOH B 447      90.747 123.369 134.671  1.00 38.70           O
HETATM  806  O   HOH B 448     108.490 117.315 120.731  1.00 37.92           O
HETATM  807  O   HOH B 449     115.005 123.472 117.056  1.00 52.42           O
HETATM  808  O   HOH B 450     100.547 103.996 116.517  1.00 41.13           O
HETATM  809  O   HOH B 451     102.533 116.496 124.532  1.00 35.69           O
HETATM  810  O   HOH B 452     103.437 100.098  90.858  1.00 44.25           O
HETATM  811  O   HOH B 453     118.399 107.481 103.951  1.00 46.25           O
HETATM  812  O   HOH B 454      95.302 100.873 140.274  1.00 36.44           O
HETATM  813  O   HOH B 455     106.636 110.035  99.169  1.00 42.74           O
HETATM  814  O   HOH B 456     101.131 106.119  96.038  1.00 40.89           O
HETATM  815  O   HOH B 457     108.757 113.457 118.341  1.00 38.44           O
HETATM  816  O   HOH B 458      99.629  97.248 137.457  1.00 32.24           O
HETATM  817  O   HOH B 459     111.536 109.780 122.467  1.00 28.32           O
HETATM  818  O   HOH B 460      90.901 112.170 128.941  1.00 31.13           O
HETATM  819  O   HOH B 461     109.080 109.015  97.760  1.00 46.65           O
HETATM  820  O   HOH B 462     109.107 108.993 104.414  1.00 45.09           O
"""

data_6cvm_frag_asym = """
ATOM      1  N   ILE A 351      85.984 118.452 121.905  1.00 48.51           N
ATOM      2  CA  ILE A 351      85.786 119.893 121.987  1.00 48.51           C
ATOM      3  C   ILE A 351      84.295 120.190 121.929  1.00 48.51           C
ATOM      4  O   ILE A 351      83.638 119.942 120.920  1.00 48.51           O
ATOM      5  CB  ILE A 351      86.539 120.620 120.871  1.00 48.51           C
ATOM      6  CG1 ILE A 351      88.039 120.403 121.018  1.00 48.51           C
ATOM      7  CG2 ILE A 351      86.195 122.081 120.857  1.00 48.51           C
ATOM      8  CD1 ILE A 351      88.595 120.916 122.294  1.00 48.51           C
ATOM      9  N   ARG A 352      83.760 120.702 123.026  1.00 47.54           N
ATOM     10  CA  ARG A 352      82.395 121.198 123.098  1.00 47.54           C
ATOM     11  C   ARG A 352      82.484 122.713 123.003  1.00 47.54           C
ATOM     12  O   ARG A 352      82.398 123.429 123.986  1.00 47.54           O
ATOM     13  CB  ARG A 352      81.759 120.747 124.394  1.00 47.54           C
ATOM     14  CG  ARG A 352      81.611 119.275 124.486  1.00 47.54           C
ATOM     15  CD  ARG A 352      81.308 118.858 125.867  1.00 47.54           C
ATOM     16  NE  ARG A 352      80.852 117.481 125.952  1.00 47.54           N
ATOM     17  CZ  ARG A 352      81.641 116.423 126.028  1.00 47.54           C
ATOM     18  NH1 ARG A 352      82.951 116.558 126.003  1.00 47.54           N
ATOM     19  NH2 ARG A 352      81.108 115.224 126.115  1.00 47.54           N
ATOM     20  N   GLY A 353      82.701 123.206 121.792  1.00 44.84           N
ATOM     21  CA  GLY A 353      83.123 124.569 121.596  1.00 44.84           C
ATOM     22  C   GLY A 353      82.049 125.482 121.041  1.00 44.84           C
ATOM     23  O   GLY A 353      81.036 125.056 120.504  1.00 44.84           O
ATOM     24  N   VAL A 354      82.313 126.773 121.171  1.00 46.30           N
ATOM     25  CA  VAL A 354      81.463 127.798 120.588  1.00 46.30           C
ATOM     26  C   VAL A 354      82.348 128.958 120.154  1.00 46.30           C
ATOM     27  O   VAL A 354      83.349 129.273 120.795  1.00 46.30           O
ATOM     28  CB  VAL A 354      80.343 128.216 121.570  1.00 46.30           C
ATOM     29  CG1 VAL A 354      80.884 128.866 122.814  1.00 46.30           C
ATOM     30  CG2 VAL A 354      79.324 129.098 120.896  1.00 46.30           C
ATOM     31  N   ASN A 355      82.019 129.534 119.012  1.00 51.63           N
ATOM     32  CA  ASN A 355      82.616 130.779 118.573  1.00 51.63           C
ATOM     33  C   ASN A 355      81.994 131.940 119.321  1.00 51.63           C
ATOM     34  O   ASN A 355      80.789 131.964 119.553  1.00 51.63           O
ATOM     35  CB  ASN A 355      82.384 130.951 117.087  1.00 51.63           C
ATOM     36  CG  ASN A 355      83.250 130.064 116.262  1.00 51.63           C
ATOM     37  OD1 ASN A 355      84.457 130.158 116.307  1.00 51.63           O
ATOM     38  ND2 ASN A 355      82.640 129.131 115.567  1.00 51.63           N
ATOM     39  N   ARG A 356      82.811 132.913 119.690  1.00 56.60           N
ATOM     40  CA  ARG A 356      82.323 134.057 120.443  1.00 56.60           C
ATOM     41  C   ARG A 356      82.961 135.330 119.922  1.00 56.60           C
ATOM     42  O   ARG A 356      84.179 135.485 119.988  1.00 56.60           O
ATOM     43  CB  ARG A 356      82.619 133.899 121.925  1.00 56.60           C
ATOM     44  CG  ARG A 356      82.184 135.071 122.741  1.00 56.60           C
ATOM     45  CD  ARG A 356      82.595 134.868 124.148  1.00 56.60           C
ATOM     46  NE  ARG A 356      82.247 135.977 125.010  1.00 56.60           N
ATOM     47  CZ  ARG A 356      83.054 136.996 125.251  1.00 56.60           C
ATOM     48  NH1 ARG A 356      82.667 137.957 126.058  1.00 56.60           N
ATOM     49  NH2 ARG A 356      84.248 137.045 124.690  1.00 56.60           N
ATOM     50  N   HIS A 357      82.138 136.235 119.415  1.00 61.60           N
ATOM     51  CA  HIS A 357      82.561 137.605 119.189  1.00 61.60           C
ATOM     52  C   HIS A 357      82.449 138.423 120.461  1.00 61.60           C
ATOM     53  O   HIS A 357      81.612 138.160 121.323  1.00 61.60           O
ATOM     54  CB  HIS A 357      81.722 138.271 118.106  1.00 61.60           C
ATOM     55  CG  HIS A 357      82.171 137.970 116.717  1.00 61.60           C
ATOM     56  ND1 HIS A 357      83.276 138.568 116.155  1.00 61.60           N
ATOM     57  CD2 HIS A 357      81.642 137.181 115.756  1.00 61.60           C
ATOM     58  CE1 HIS A 357      83.425 138.138 114.917  1.00 61.60           C
ATOM     59  NE2 HIS A 357      82.447 137.293 114.651  1.00 61.60           N
ATOM     60  N   GLU A 358      83.300 139.430 120.565  1.00 65.08           N
ATOM     61  CA  GLU A 358      83.164 140.447 121.599  1.00 65.08           C
ATOM     62  C   GLU A 358      82.086 141.425 121.170  1.00 65.08           C
ATOM     63  O   GLU A 358      82.308 142.272 120.309  1.00 65.08           O
ATOM     64  CB  GLU A 358      84.486 141.157 121.833  1.00 65.08           C
ATOM     65  CG  GLU A 358      85.464 140.356 122.628  1.00 65.08           C
ATOM     66  CD  GLU A 358      86.752 141.099 122.870  1.00 65.08           C
ATOM     67  OE1 GLU A 358      86.994 142.121 122.201  1.00 65.08           O
ATOM     68  OE2 GLU A 358      87.505 140.691 123.768  1.00 65.08           O
ATOM     69  N   HIS A 359      80.909 141.311 121.768  1.00 64.23           N
ATOM     70  CA  HIS A 359      79.791 142.144 121.368  1.00 64.23           C
ATOM     71  C   HIS A 359      78.944 142.481 122.577  1.00 64.23           C
ATOM     72  O   HIS A 359      78.643 141.608 123.390  1.00 64.23           O
ATOM     73  CB  HIS A 359      78.930 141.451 120.320  1.00 64.23           C
ATOM     74  CG  HIS A 359      77.752 142.257 119.890  1.00 64.23           C
ATOM     75  ND1 HIS A 359      77.846 143.285 118.981  1.00 64.23           N
ATOM     76  CD2 HIS A 359      76.459 142.217 120.280  1.00 64.23           C
ATOM     77  CE1 HIS A 359      76.655 143.823 118.807  1.00 64.23           C
ATOM     78  NE2 HIS A 359      75.797 143.197 119.588  1.00 64.23           N
ATOM     79  N   HIS A 360      78.565 143.744 122.684  1.00 67.87           N
ATOM     80  CA  HIS A 360      77.598 144.191 123.658  1.00 67.87           C
ATOM     81  C   HIS A 360      76.583 145.029 122.892  1.00 67.87           C
ATOM     82  O   HIS A 360      76.977 145.849 122.055  1.00 67.87           O
ATOM     83  CB  HIS A 360      78.260 145.006 124.764  1.00 67.87           C
ATOM     84  CG  HIS A 360      77.369 145.262 125.932  1.00 67.87           C
ATOM     85  ND1 HIS A 360      76.455 146.290 125.958  1.00 67.87           N
ATOM     86  CD2 HIS A 360      77.249 144.622 127.117  1.00 67.87           C
ATOM     87  CE1 HIS A 360      75.805 146.269 127.106  1.00 67.87           C
ATOM     88  NE2 HIS A 360      76.271 145.268 127.829  1.00 67.87           N
ATOM     89  N   PRO A 361      75.282 144.845 123.124  1.00 67.53           N
ATOM     90  CA  PRO A 361      74.286 145.540 122.296  1.00 67.53           C
ATOM     91  C   PRO A 361      74.216 147.033 122.536  1.00 67.53           C
ATOM     92  O   PRO A 361      73.778 147.762 121.643  1.00 67.53           O
ATOM     93  CB  PRO A 361      72.975 144.863 122.691  1.00 67.53           C
ATOM     94  CG  PRO A 361      73.214 144.391 124.058  1.00 67.53           C
ATOM     95  CD  PRO A 361      74.644 143.990 124.134  1.00 67.53           C
ATOM     96  N   LEU A 362      74.637 147.512 123.699  1.00 71.50           N
ATOM     97  CA  LEU A 362      74.648 148.935 123.994  1.00 71.50           C
ATOM     98  C   LEU A 362      75.990 149.586 123.729  1.00 71.50           C
ATOM     99  O   LEU A 362      76.036 150.721 123.254  1.00 71.50           O
ATOM    100  CB  LEU A 362      74.261 149.172 125.452  1.00 71.50           C
ATOM    101  CG  LEU A 362      72.815 148.830 125.777  1.00 71.50           C
ATOM    102  CD1 LEU A 362      72.573 148.925 127.266  1.00 71.50           C
ATOM    103  CD2 LEU A 362      71.899 149.765 125.024  1.00 71.50           C
ATOM    104  N   HIS A 363      77.084 148.892 124.015  1.00 70.40           N
ATOM    105  CA  HIS A 363      78.407 149.485 123.950  1.00 70.40           C
ATOM    106  C   HIS A 363      79.206 149.004 122.755  1.00 70.40           C
ATOM    107  O   HIS A 363      80.385 149.337 122.643  1.00 70.40           O
ATOM    108  CB  HIS A 363      79.164 149.196 125.238  1.00 70.40           C
ATOM    109  CG  HIS A 363      78.451 149.670 126.458  1.00 70.40           C
ATOM    110  ND1 HIS A 363      78.270 151.005 126.739  1.00 70.40           N
ATOM    111  CD2 HIS A 363      77.876 148.989 127.474  1.00 70.40           C
ATOM    112  CE1 HIS A 363      77.606 151.125 127.872  1.00 70.40           C
ATOM    113  NE2 HIS A 363      77.358 149.917 128.341  1.00 70.40           N
ATOM    114  N   GLY A 364      78.597 148.240 121.861  1.00 67.37           N
ATOM    115  CA  GLY A 364      79.293 147.763 120.689  1.00 67.37           C
ATOM    116  C   GLY A 364      80.331 146.716 121.011  1.00 67.37           C
ATOM    117  O   GLY A 364      80.013 145.658 121.550  1.00 67.37           O
ATOM    118  N   GLN A 365      81.588 147.014 120.710  1.00 65.98           N
ATOM    119  CA  GLN A 365      82.667 146.056 120.866  1.00 65.98           C
ATOM    120  C   GLN A 365      83.509 146.327 122.100  1.00 65.98           C
ATOM    121  O   GLN A 365      84.663 145.903 122.164  1.00 65.98           O
ATOM    122  CB  GLN A 365      83.508 146.047 119.597  1.00 65.98           C
ATOM    123  CG  GLN A 365      82.682 145.560 118.436  1.00 65.98           C
ATOM    124  CD  GLN A 365      83.372 145.664 117.115  1.00 65.98           C
ATOM    125  OE1 GLN A 365      84.470 146.197 117.015  1.00 65.98           O
ATOM    126  NE2 GLN A 365      82.728 145.154 116.080  1.00 65.98           N
ATOM    127  N   VAL A 366      82.942 146.997 123.091  1.00 66.98           N
ATOM    128  CA  VAL A 366      83.613 147.279 124.349  1.00 66.98           C
ATOM    129  C   VAL A 366      83.147 146.257 125.369  1.00 66.98           C
ATOM    130  O   VAL A 366      81.953 146.165 125.663  1.00 66.98           O
ATOM    131  CB  VAL A 366      83.320 148.705 124.825  1.00 66.98           C
ATOM    132  CG1 VAL A 366      83.933 148.947 126.175  1.00 66.98           C
ATOM    133  CG2 VAL A 366      83.851 149.668 123.827  1.00 66.98           C
ATOM    134  N   MET A 367      84.083 145.495 125.914  1.00 72.90           N
ATOM    135  CA  MET A 367      83.771 144.420 126.839  1.00 72.90           C
ATOM    136  C   MET A 367      84.249 144.762 128.236  1.00 72.90           C
ATOM    137  O   MET A 367      85.387 145.196 128.418  1.00 72.90           O
ATOM    138  CB  MET A 367      84.409 143.109 126.393  1.00 72.90           C
ATOM    139  CG  MET A 367      83.818 142.547 125.142  1.00 72.90           C
ATOM    140  SD  MET A 367      82.044 142.330 125.297  1.00 72.90           S
ATOM    141  CE  MET A 367      82.005 141.162 126.633  1.00 72.90           C
ATOM    142  N   ASP A 368      83.382 144.556 129.214  1.00 74.72           N
ATOM    143  CA  ASP A 368      83.738 144.657 130.616  1.00 74.72           C
ATOM    144  C   ASP A 368      83.749 143.273 131.247  1.00 74.72           C
ATOM    145  O   ASP A 368      83.377 142.282 130.622  1.00 74.72           O
ATOM    146  CB  ASP A 368      82.778 145.586 131.357  1.00 74.72           C
ATOM    147  CG  ASP A 368      81.333 145.202 131.172  1.00 74.72           C
ATOM    148  OD1 ASP A 368      81.034 144.342 130.324  1.00 74.72           O
ATOM    149  OD2 ASP A 368      80.484 145.754 131.896  1.00 74.72           O
ATOM    150  N   GLU A 369      84.174 143.224 132.510  1.00 72.94           N
ATOM    151  CA  GLU A 369      84.347 141.946 133.188  1.00 72.94           C
ATOM    152  C   GLU A 369      83.020 141.259 133.463  1.00 72.94           C
ATOM    153  O   GLU A 369      82.935 140.033 133.361  1.00 72.94           O
ATOM    154  CB  GLU A 369      85.117 142.144 134.488  1.00 72.94           C
ATOM    155  CG  GLU A 369      85.427 140.860 135.219  1.00 72.94           C
ATOM    156  CD  GLU A 369      86.363 141.058 136.381  1.00 72.94           C
ATOM    157  OE1 GLU A 369      86.786 142.208 136.612  1.00 72.94           O
ATOM    158  OE2 GLU A 369      86.683 140.061 137.061  1.00 72.94           O
ATOM    159  N   GLN A 370      81.976 142.026 133.766  1.00 73.01           N
ATOM    160  CA  GLN A 370      80.704 141.436 134.163  1.00 73.01           C
ATOM    161  C   GLN A 370      80.027 140.716 133.010  1.00 73.01           C
ATOM    162  O   GLN A 370      79.379 139.690 133.222  1.00 73.01           O
ATOM    163  CB  GLN A 370      79.772 142.506 134.724  1.00 73.01           C
ATOM    164  CG  GLN A 370      80.065 142.929 136.157  1.00 73.01           C
ATOM    165  CD  GLN A 370      81.349 143.723 136.301  1.00 73.01           C
ATOM    166  OE1 GLN A 370      82.243 143.347 137.058  1.00 73.01           O
ATOM    167  NE2 GLN A 370      81.460 144.810 135.545  1.00 73.01           N
ATOM    168  N   THR A 371      80.182 141.217 131.791  1.00 69.35           N
ATOM    169  CA  THR A 371      79.631 140.517 130.645  1.00 69.35           C
ATOM    170  C   THR A 371      80.462 139.287 130.303  1.00 69.35           C
ATOM    171  O   THR A 371      79.912 138.275 129.864  1.00 69.35           O
ATOM    172  CB  THR A 371      79.538 141.471 129.459  1.00 69.35           C
ATOM    173  OG1 THR A 371      78.859 142.657 129.874  1.00 69.35           O
ATOM    174  CG2 THR A 371      78.732 140.862 128.337  1.00 69.35           C
ATOM    175  N   MET A 372      81.777 139.346 130.526  1.00 66.00           N
ATOM    176  CA  MET A 372      82.624 138.182 130.291  1.00 66.00           C
ATOM    177  C   MET A 372      82.319 137.064 131.269  1.00 66.00           C
ATOM    178  O   MET A 372      82.292 135.894 130.882  1.00 66.00           O
ATOM    179  CB  MET A 372      84.092 138.546 130.410  1.00 66.00           C
ATOM    180  CG  MET A 372      84.606 139.464 129.378  1.00 66.00           C
ATOM    181  SD  MET A 372      86.337 139.738 129.710  1.00 66.00           S
ATOM    182  CE  MET A 372      86.609 141.084 128.607  1.00 66.00           C
ATOM    183  N   VAL A 373      82.124 137.401 132.542  1.00 63.75           N
ATOM    184  CA  VAL A 373      81.793 136.390 133.534  1.00 63.75           C
ATOM    185  C   VAL A 373      80.414 135.818 133.257  1.00 63.75           C
ATOM    186  O   VAL A 373      80.199 134.611 133.379  1.00 63.75           O
ATOM    187  CB  VAL A 373      81.910 136.980 134.950  1.00 63.75           C
ATOM    188  CG1 VAL A 373      81.433 136.006 135.995  1.00 63.75           C
ATOM    189  CG2 VAL A 373      83.336 137.338 135.232  1.00 63.75           C
ATOM    190  N   GLN A 374      79.487 136.661 132.802  1.00 64.23           N
ATOM    191  CA  GLN A 374      78.154 136.197 132.438  1.00 64.23           C
ATOM    192  C   GLN A 374      78.198 135.227 131.265  1.00 64.23           C
ATOM    193  O   GLN A 374      77.448 134.247 131.240  1.00 64.23           O
ATOM    194  CB  GLN A 374      77.268 137.390 132.098  1.00 64.23           C
ATOM    195  CG  GLN A 374      75.826 137.042 131.863  1.00 64.23           C
ATOM    196  CD  GLN A 374      74.996 138.237 131.473  1.00 64.23           C
ATOM    197  OE1 GLN A 374      75.518 139.324 131.253  1.00 64.23           O
ATOM    198  NE2 GLN A 374      73.691 138.046 131.401  1.00 64.23           N
ATOM    199  N   ASP A 375      79.086 135.467 130.300  1.00 60.83           N
ATOM    200  CA  ASP A 375      79.214 134.549 129.177  1.00 60.83           C
ATOM    201  C   ASP A 375      79.809 133.218 129.605  1.00 60.83           C
ATOM    202  O   ASP A 375      79.321 132.167 129.190  1.00 60.83           O
ATOM    203  CB  ASP A 375      80.058 135.159 128.064  1.00 60.83           C
ATOM    204  CG  ASP A 375      79.302 136.176 127.251  1.00 60.83           C
ATOM    205  OD1 ASP A 375      78.065 136.111 127.225  1.00 60.83           O
ATOM    206  OD2 ASP A 375      79.943 137.017 126.599  1.00 60.83           O
ATOM    207  N   ILE A 376      80.842 133.241 130.447  1.00 57.84           N
ATOM    208  CA  ILE A 376      81.538 132.016 130.825  1.00 57.84           C
ATOM    209  C   ILE A 376      80.658 131.129 131.687  1.00 57.84           C
ATOM    210  O   ILE A 376      80.664 129.904 131.532  1.00 57.84           O
ATOM    211  CB  ILE A 376      82.866 132.358 131.517  1.00 57.84           C
ATOM    212  CG1 ILE A 376      83.809 132.942 130.497  1.00 57.84           C
ATOM    213  CG2 ILE A 376      83.529 131.152 132.122  1.00 57.84           C
ATOM    214  CD1 ILE A 376      85.025 133.472 131.070  1.00 57.84           C
ATOM    215  N   LEU A 377      79.854 131.726 132.569  1.00 57.63           N
ATOM    216  CA  LEU A 377      78.948 130.917 133.371  1.00 57.63           C
ATOM    217  C   LEU A 377      77.881 130.269 132.505  1.00 57.63           C
ATOM    218  O   LEU A 377      77.628 129.077 132.643  1.00 57.63           O
ATOM    219  CB  LEU A 377      78.294 131.736 134.476  1.00 57.63           C
ATOM    220  CG  LEU A 377      79.179 132.424 135.509  1.00 57.63           C
ATOM    221  CD1 LEU A 377      78.356 132.988 136.648  1.00 57.63           C
ATOM    222  CD2 LEU A 377      80.309 131.583 135.985  1.00 57.63           C
ATOM    223  N   LEU A 378      77.299 131.018 131.568  1.00 56.00           N
ATOM    224  CA  LEU A 378      76.302 130.444 130.670  1.00 56.00           C
ATOM    225  C   LEU A 378      76.878 129.375 129.759  1.00 56.00           C
ATOM    226  O   LEU A 378      76.174 128.428 129.409  1.00 56.00           O
ATOM    227  CB  LEU A 378      75.663 131.528 129.819  1.00 56.00           C
ATOM    228  CG  LEU A 378      74.659 132.439 130.485  1.00 56.00           C
ATOM    229  CD1 LEU A 378      74.295 133.533 129.524  1.00 56.00           C
ATOM    230  CD2 LEU A 378      73.451 131.623 130.838  1.00 56.00           C
ATOM    231  N   MET A 379      78.141 129.507 129.364  1.00 54.55           N
ATOM    232  CA  MET A 379      78.772 128.482 128.546  1.00 54.55           C
ATOM    233  C   MET A 379      78.969 127.194 129.322  1.00 54.55           C
ATOM    234  O   MET A 379      78.656 126.111 128.825  1.00 54.55           O
ATOM    235  CB  MET A 379      80.101 128.984 128.014  1.00 54.55           C
ATOM    236  CG  MET A 379      79.952 129.968 126.917  1.00 54.55           C
ATOM    237  SD  MET A 379      81.508 130.714 126.503  1.00 54.55           S
ATOM    238  CE  MET A 379      80.953 131.823 125.249  1.00 54.55           C
ATOM    239  N   LYS A 380      79.483 127.288 130.542  1.00 54.17           N
ATOM    240  CA  LYS A 380      79.755 126.077 131.296  1.00 54.17           C
ATOM    241  C   LYS A 380      78.483 125.441 131.825  1.00 54.17           C
ATOM    242  O   LYS A 380      78.420 124.219 131.953  1.00 54.17           O
ATOM    243  CB  LYS A 380      80.728 126.370 132.425  1.00 54.17           C
ATOM    244  CG  LYS A 380      82.102 126.688 131.922  1.00 54.17           C
ATOM    245  CD  LYS A 380      83.064 126.853 133.046  1.00 54.17           C
ATOM    246  CE  LYS A 380      83.369 125.521 133.674  1.00 54.17           C
ATOM    247  NZ  LYS A 380      84.117 124.635 132.770  1.00 54.17           N
ATOM    248  N   GLN A 381      77.450 126.234 132.092  1.00 55.58           N
ATOM    249  CA  GLN A 381      76.163 125.679 132.484  1.00 55.58           C
ATOM    250  C   GLN A 381      75.442 125.000 131.335  1.00 55.58           C
ATOM    251  O   GLN A 381      74.471 124.287 131.573  1.00 55.58           O
ATOM    252  CB  GLN A 381      75.284 126.773 133.071  1.00 55.58           C
ATOM    253  CG  GLN A 381      75.752 127.247 134.418  1.00 55.58           C
ATOM    254  CD  GLN A 381      75.105 128.535 134.826  1.00 55.58           C
ATOM    255  OE1 GLN A 381      74.232 129.043 134.139  1.00 55.58           O
ATOM    256  NE2 GLN A 381      75.584 129.115 135.909  1.00 55.58           N
ATOM    257  N   ASN A 382      75.895 125.194 130.108  1.00 50.40           N
ATOM    258  CA  ASN A 382      75.321 124.560 128.937  1.00 50.40           C
ATOM    259  C   ASN A 382      76.302 123.600 128.288  1.00 50.40           C
ATOM    260  O   ASN A 382      76.234 123.356 127.087  1.00 50.40           O
ATOM    261  CB  ASN A 382      74.858 125.638 127.972  1.00 50.40           C
ATOM    262  CG  ASN A 382      73.650 126.346 128.480  1.00 50.40           C
ATOM    263  OD1 ASN A 382      72.630 125.732 128.725  1.00 50.40           O
ATOM    264  ND2 ASN A 382      73.794 127.617 128.772  1.00 50.40           N
ATOM    265  N   ASN A 383      77.239 123.095 129.091  1.00 48.74           N
ATOM    266  CA  ASN A 383      78.156 122.008 128.753  1.00 48.74           C
ATOM    267  C   ASN A 383      79.108 122.366 127.621  1.00 48.74           C
ATOM    268  O   ASN A 383      79.518 121.503 126.857  1.00 48.74           O
ATOM    269  CB  ASN A 383      77.403 120.716 128.429  1.00 48.74           C
ATOM    270  CG  ASN A 383      76.672 120.170 129.611  1.00 48.74           C
ATOM    271  OD1 ASN A 383      77.164 120.216 130.723  1.00 48.74           O
ATOM    272  ND2 ASN A 383      75.493 119.643 129.381  1.00 48.74           N
ATOM    273  N   PHE A 384      79.477 123.629 127.500  1.00 46.24           N
ATOM    274  CA  PHE A 384      80.572 124.014 126.627  1.00 46.24           C
ATOM    275  C   PHE A 384      81.874 123.974 127.411  1.00 46.24           C
ATOM    276  O   PHE A 384      81.912 124.350 128.578  1.00 46.24           O
ATOM    277  CB  PHE A 384      80.351 125.411 126.053  1.00 46.24           C
ATOM    278  CG  PHE A 384      79.267 125.486 125.030  1.00 46.24           C
ATOM    279  CD1 PHE A 384      79.528 125.198 123.709  1.00 46.24           C
ATOM    280  CD2 PHE A 384      77.989 125.841 125.387  1.00 46.24           C
ATOM    281  CE1 PHE A 384      78.536 125.268 122.772  1.00 46.24           C
ATOM    282  CE2 PHE A 384      76.996 125.908 124.450  1.00 46.24           C
ATOM    283  CZ  PHE A 384      77.272 125.622 123.144  1.00 46.24           C
ATOM    284  N   ASN A 385      82.938 123.500 126.776  1.00 47.51           N
ATOM    285  CA  ASN A 385      84.245 123.539 127.408  1.00 47.51           C
ATOM    286  C   ASN A 385      85.289 124.298 126.606  1.00 47.51           C
ATOM    287  O   ASN A 385      86.449 124.328 127.013  1.00 47.51           O
ATOM    288  CB  ASN A 385      84.750 122.121 127.735  1.00 47.51           C
ATOM    289  CG  ASN A 385      84.941 121.226 126.515  1.00 47.51           C
ATOM    290  OD1 ASN A 385      84.801 121.629 125.376  1.00 47.51           O
ATOM    291  ND2 ASN A 385      85.276 119.984 126.775  1.00 47.51           N
ATOM    292  N   ALA A 386      84.925 124.900 125.484  1.00 45.28           N
ATOM    293  CA  ALA A 386      85.917 125.535 124.640  1.00 45.28           C
ATOM    294  C   ALA A 386      85.319 126.750 123.959  1.00 45.28           C
ATOM    295  O   ALA A 386      84.123 126.802 123.694  1.00 45.28           O
ATOM    296  CB  ALA A 386      86.473 124.569 123.603  1.00 45.28           C
ATOM    297  N   VAL A 387      86.158 127.750 123.719  1.00 47.41           N
ATOM    298  CA  VAL A 387      85.757 128.990 123.068  1.00 47.41           C
ATOM    299  C   VAL A 387      86.781 129.299 121.992  1.00 47.41           C
ATOM    300  O   VAL A 387      87.984 129.216 122.239  1.00 47.41           O
ATOM    301  CB  VAL A 387      85.661 130.172 124.053  1.00 47.41           C
ATOM    302  CG1 VAL A 387      85.175 131.408 123.357  1.00 47.41           C
ATOM    303  CG2 VAL A 387      84.744 129.881 125.164  1.00 47.41           C
ATOM    304  N   ARG A 388      86.315 129.649 120.808  1.00 52.67           N
ATOM    305  CA  ARG A 388      87.184 130.147 119.759  1.00 52.67           C
ATOM    306  C   ARG A 388      87.037 131.656 119.673  1.00 52.67           C
ATOM    307  O   ARG A 388      85.924 132.173 119.572  1.00 52.67           O
ATOM    308  CB  ARG A 388      86.862 129.470 118.433  1.00 52.67           C
ATOM    309  CG  ARG A 388      87.695 129.914 117.274  1.00 52.67           C
ATOM    310  CD  ARG A 388      87.528 128.957 116.129  1.00 52.67           C
ATOM    311  NE  ARG A 388      88.202 129.417 114.929  1.00 52.67           N
ATOM    312  CZ  ARG A 388      87.592 130.038 113.930  1.00 52.67           C
ATOM    313  NH1 ARG A 388      86.289 130.240 113.977  1.00 52.67           N
ATOM    314  NH2 ARG A 388      88.276 130.430 112.870  1.00 52.67           N
ATOM    315  N   CYS A 389      88.159 132.357 119.754  1.00 59.66           N
ATOM    316  CA  CYS A 389      88.197 133.817 119.741  1.00 59.66           C
ATOM    317  C   CYS A 389      88.022 134.280 118.308  1.00 59.66           C
ATOM    318  O   CYS A 389      88.989 134.537 117.602  1.00 59.66           O
ATOM    319  CB  CYS A 389      89.516 134.322 120.304  1.00 59.66           C
ATOM    320  SG  CYS A 389      89.871 133.807 121.964  1.00 59.66           S
ATOM    321  N   SER A 390      86.782 134.406 117.871  1.00 58.60           N
ATOM    322  CA  SER A 390      86.486 134.655 116.469  1.00 58.60           C
ATOM    323  C   SER A 390      86.308 136.150 116.220  1.00 58.60           C
ATOM    324  O   SER A 390      85.467 136.781 116.862  1.00 58.60           O
ATOM    325  CB  SER A 390      85.229 133.896 116.068  1.00 58.60           C
ATOM    326  OG  SER A 390      84.103 134.402 116.745  1.00 58.60           O
ATOM    327  N   HIS A 391      87.112 136.729 115.321  1.00 59.22           N
ATOM    328  CA  HIS A 391      88.323 136.124 114.781  1.00 59.22           C
ATOM    329  C   HIS A 391      89.452 137.107 114.969  1.00 59.22           C
ATOM    330  O   HIS A 391      89.916 137.699 114.004  1.00 59.22           O
ATOM    331  CB  HIS A 391      88.179 135.837 113.293  1.00 59.22           C
ATOM    332  CG  HIS A 391      86.990 135.012 112.941  1.00 59.22           C
ATOM    333  ND1 HIS A 391      86.951 133.649 113.113  1.00 59.22           N
ATOM    334  CD2 HIS A 391      85.787 135.364 112.435  1.00 59.22           C
ATOM    335  CE1 HIS A 391      85.778 133.195 112.721  1.00 59.22           C
ATOM    336  NE2 HIS A 391      85.052 134.215 112.307  1.00 59.22           N
ATOM    337  N   TYR A 392      89.944 137.202 116.185  1.00 58.66           N
ATOM    338  CA  TYR A 392      90.877 138.223 116.640  1.00 58.66           C
ATOM    339  C   TYR A 392      91.251 137.927 118.082  1.00 58.66           C
ATOM    340  O   TYR A 392      90.505 137.219 118.760  1.00 58.66           O
ATOM    341  CB  TYR A 392      90.295 139.639 116.493  1.00 58.66           C
ATOM    342  CG  TYR A 392      88.875 139.835 116.944  1.00 58.66           C
ATOM    343  CD1 TYR A 392      87.856 139.917 116.015  1.00 58.66           C
ATOM    344  CD2 TYR A 392      88.547 139.922 118.282  1.00 58.66           C
ATOM    345  CE1 TYR A 392      86.564 140.089 116.400  1.00 58.66           C
ATOM    346  CE2 TYR A 392      87.251 140.084 118.678  1.00 58.66           C
ATOM    347  CZ  TYR A 392      86.264 140.170 117.729  1.00 58.66           C
ATOM    348  OH  TYR A 392      84.960 140.339 118.110  1.00 58.66           O
ATOM    349  N   PRO A 393      92.387 138.416 118.579  1.00 57.99           N
ATOM    350  CA  PRO A 393      92.693 138.235 119.998  1.00 57.99           C
ATOM    351  C   PRO A 393      91.726 139.015 120.862  1.00 57.99           C
ATOM    352  O   PRO A 393      91.353 140.141 120.539  1.00 57.99           O
ATOM    353  CB  PRO A 393      94.113 138.786 120.122  1.00 57.99           C
ATOM    354  CG  PRO A 393      94.652 138.725 118.777  1.00 57.99           C
ATOM    355  CD  PRO A 393      93.530 139.005 117.869  1.00 57.99           C
ATOM    356  N   ASN A 394      91.297 138.403 121.954  1.00 61.43           N
ATOM    357  CA  ASN A 394      90.343 139.095 122.792  1.00 61.43           C
ATOM    358  C   ASN A 394      91.027 140.058 123.745  1.00 61.43           C
ATOM    359  O   ASN A 394      92.245 140.235 123.748  1.00 61.43           O
ATOM    360  CB  ASN A 394      89.479 138.134 123.597  1.00 61.43           C
ATOM    361  CG  ASN A 394      88.440 137.462 122.766  1.00 61.43           C
ATOM    362  OD1 ASN A 394      88.185 136.287 122.915  1.00 61.43           O
ATOM    363  ND2 ASN A 394      87.889 138.189 121.819  1.00 61.43           N
ATOM    364  N   HIS A 395      90.183 140.712 124.520  1.00 65.16           N
ATOM    365  CA  HIS A 395      90.579 141.481 125.682  1.00 65.16           C
ATOM    366  C   HIS A 395      91.393 140.601 126.625  1.00 65.16           C
ATOM    367  O   HIS A 395      91.083 139.417 126.775  1.00 65.16           O
ATOM    368  CB  HIS A 395      89.307 141.979 126.364  1.00 65.16           C
ATOM    369  CG  HIS A 395      89.531 142.940 127.479  1.00 65.16           C
ATOM    370  ND1 HIS A 395      89.886 142.537 128.745  1.00 65.16           N
ATOM    371  CD2 HIS A 395      89.382 144.281 127.538  1.00 65.16           C
ATOM    372  CE1 HIS A 395      89.990 143.594 129.527  1.00 65.16           C
ATOM    373  NE2 HIS A 395      89.687 144.666 128.820  1.00 65.16           N
ATOM    374  N   PRO A 396      92.445 141.131 127.254  1.00 63.79           N
ATOM    375  CA  PRO A 396      93.357 140.271 128.025  1.00 63.79           C
ATOM    376  C   PRO A 396      92.740 139.636 129.250  1.00 63.79           C
ATOM    377  O   PRO A 396      93.232 138.596 129.693  1.00 63.79           O
ATOM    378  CB  PRO A 396      94.481 141.232 128.422  1.00 63.79           C
ATOM    379  CG  PRO A 396      94.418 142.303 127.435  1.00 63.79           C
ATOM    380  CD  PRO A 396      92.982 142.490 127.111  1.00 63.79           C
ATOM    381  N   LEU A 397      91.673 140.207 129.798  1.00 62.71           N
ATOM    382  CA  LEU A 397      91.013 139.617 130.951  1.00 62.71           C
ATOM    383  C   LEU A 397      90.268 138.340 130.597  1.00 62.71           C
ATOM    384  O   LEU A 397      90.049 137.502 131.475  1.00 62.71           O
ATOM    385  CB  LEU A 397      90.068 140.643 131.560  1.00 62.71           C
ATOM    386  CG  LEU A 397      89.336 140.323 132.850  1.00 62.71           C
ATOM    387  CD1 LEU A 397      90.334 140.035 133.936  1.00 62.71           C
ATOM    388  CD2 LEU A 397      88.494 141.497 133.207  1.00 62.71           C
ATOM    389  N   TRP A 398      89.903 138.169 129.327  1.00 57.16           N
ATOM    390  CA  TRP A 398      89.182 136.983 128.888  1.00 57.16           C
ATOM    391  C   TRP A 398      89.996 135.717 129.087  1.00 57.16           C
ATOM    392  O   TRP A 398      89.459 134.689 129.502  1.00 57.16           O
ATOM    393  CB  TRP A 398      88.797 137.139 127.427  1.00 57.16           C
ATOM    394  CG  TRP A 398      88.151 135.961 126.861  1.00 57.16           C
ATOM    395  CD1 TRP A 398      88.692 135.081 125.991  1.00 57.16           C
ATOM    396  CD2 TRP A 398      86.834 135.505 127.130  1.00 57.16           C
ATOM    397  NE1 TRP A 398      87.790 134.107 125.685  1.00 57.16           N
ATOM    398  CE2 TRP A 398      86.637 134.345 126.378  1.00 57.16           C
ATOM    399  CE3 TRP A 398      85.797 135.972 127.932  1.00 57.16           C
ATOM    400  CZ2 TRP A 398      85.450 133.642 126.403  1.00 57.16           C
ATOM    401  CZ3 TRP A 398      84.625 135.281 127.950  1.00 57.16           C
ATOM    402  CH2 TRP A 398      84.456 134.126 127.195  1.00 57.16           C
ATOM    403  N   TYR A 399      91.296 135.781 128.819  1.00 57.98           N
ATOM    404  CA  TYR A 399      92.142 134.609 128.967  1.00 57.98           C
ATOM    405  C   TYR A 399      92.357 134.268 130.426  1.00 57.98           C
ATOM    406  O   TYR A 399      92.461 133.093 130.770  1.00 57.98           O
ATOM    407  CB  TYR A 399      93.478 134.844 128.279  1.00 57.98           C
ATOM    408  CG  TYR A 399      93.317 135.179 126.835  1.00 57.98           C
ATOM    409  CD1 TYR A 399      93.084 134.195 125.901  1.00 57.98           C
ATOM    410  CD2 TYR A 399      93.371 136.491 126.406  1.00 57.98           C
ATOM    411  CE1 TYR A 399      92.921 134.504 124.582  1.00 57.98           C
ATOM    412  CE2 TYR A 399      93.206 136.806 125.094  1.00 57.98           C
ATOM    413  CZ  TYR A 399      92.985 135.812 124.186  1.00 57.98           C
ATOM    414  OH  TYR A 399      92.825 136.128 122.869  1.00 57.98           O
ATOM    415  N   THR A 400      92.412 135.283 131.286  1.00 60.01           N
ATOM    416  CA  THR A 400      92.531 135.063 132.720  1.00 60.01           C
ATOM    417  C   THR A 400      91.301 134.361 133.270  1.00 60.01           C
ATOM    418  O   THR A 400      91.412 133.430 134.070  1.00 60.01           O
ATOM    419  CB  THR A 400      92.743 136.401 133.420  1.00 60.01           C
ATOM    420  OG1 THR A 400      93.946 137.000 132.937  1.00 60.01           O
ATOM    421  CG2 THR A 400      92.844 136.227 134.909  1.00 60.01           C
ATOM    422  N   LEU A 401      90.122 134.774 132.825  1.00 58.69           N
ATOM    423  CA  LEU A 401      88.897 134.149 133.294  1.00 58.69           C
ATOM    424  C   LEU A 401      88.730 132.743 132.739  1.00 58.69           C
ATOM    425  O   LEU A 401      88.156 131.884 133.407  1.00 58.69           O
ATOM    426  CB  LEU A 401      87.710 135.015 132.919  1.00 58.69           C
ATOM    427  CG  LEU A 401      87.610 136.393 133.549  1.00 58.69           C
ATOM    428  CD1 LEU A 401      86.465 137.131 132.931  1.00 58.69           C
ATOM    429  CD2 LEU A 401      87.420 136.265 135.025  1.00 58.69           C
ATOM    430  N   CYS A 402      89.230 132.482 131.535  1.00 56.47           N
ATOM    431  CA  CYS A 402      89.190 131.123 131.016  1.00 56.47           C
ATOM    432  C   CYS A 402      90.208 130.227 131.706  1.00 56.47           C
ATOM    433  O   CYS A 402      89.992 129.019 131.792  1.00 56.47           O
ATOM    434  CB  CYS A 402      89.410 131.125 129.507  1.00 56.47           C
ATOM    435  SG  CYS A 402      88.082 131.868 128.550  1.00 56.47           S
ATOM    436  N   ASP A 403      91.320 130.792 132.187  1.00 58.77           N
ATOM    437  CA  ASP A 403      92.224 130.053 133.066  1.00 58.77           C
ATOM    438  C   ASP A 403      91.521 129.653 134.349  1.00 58.77           C
ATOM    439  O   ASP A 403      91.686 128.536 134.841  1.00 58.77           O
ATOM    440  CB  ASP A 403      93.443 130.897 133.438  1.00 58.77           C
ATOM    441  CG  ASP A 403      94.336 131.208 132.273  1.00 58.77           C
ATOM    442  OD1 ASP A 403      94.342 130.438 131.313  1.00 58.77           O
ATOM    443  OD2 ASP A 403      95.046 132.232 132.315  1.00 58.77           O
ATOM    444  N   ARG A 404      90.728 130.562 134.895  1.00 62.32           N
ATOM    445  CA  ARG A 404      90.194 130.434 136.238  1.00 62.32           C
ATOM    446  C   ARG A 404      89.003 129.491 136.283  1.00 62.32           C
ATOM    447  O   ARG A 404      88.933 128.614 137.143  1.00 62.32           O
ATOM    448  CB  ARG A 404      89.808 131.818 136.735  1.00 62.32           C
ATOM    449  CG  ARG A 404      89.342 131.913 138.145  1.00 62.32           C
ATOM    450  CD  ARG A 404      89.081 133.370 138.431  1.00 62.32           C
ATOM    451  NE  ARG A 404      90.314 134.139 138.312  1.00 62.32           N
ATOM    452  CZ  ARG A 404      90.364 135.462 138.221  1.00 62.32           C
ATOM    453  NH1 ARG A 404      89.246 136.169 138.222  1.00 62.32           N
ATOM    454  NH2 ARG A 404      91.533 136.074 138.120  1.00 62.32           N
ATOM    455  N   TYR A 405      88.057 129.660 135.371  1.00 60.24           N
ATOM    456  CA  TYR A 405      86.862 128.833 135.357  1.00 60.24           C
ATOM    457  C   TYR A 405      87.049 127.543 134.590  1.00 60.24           C
ATOM    458  O   TYR A 405      86.406 126.544 134.906  1.00 60.24           O
ATOM    459  CB  TYR A 405      85.698 129.609 134.756  1.00 60.24           C
ATOM    460  CG  TYR A 405      85.229 130.727 135.629  1.00 60.24           C
ATOM    461  CD1 TYR A 405      84.390 130.483 136.697  1.00 60.24           C
ATOM    462  CD2 TYR A 405      85.631 132.025 135.394  1.00 60.24           C
ATOM    463  CE1 TYR A 405      83.960 131.500 137.500  1.00 60.24           C
ATOM    464  CE2 TYR A 405      85.209 133.048 136.191  1.00 60.24           C
ATOM    465  CZ  TYR A 405      84.372 132.780 137.241  1.00 60.24           C
ATOM    466  OH  TYR A 405      83.946 133.804 138.042  1.00 60.24           O
ATOM    467  N   GLY A 406      87.899 127.553 133.584  1.00 55.48           N
ATOM    468  CA  GLY A 406      88.229 126.367 132.836  1.00 55.48           C
ATOM    469  C   GLY A 406      87.482 126.316 131.529  1.00 55.48           C
ATOM    470  O   GLY A 406      86.371 125.801 131.451  1.00 55.48           O
ATOM    471  N   LEU A 407      88.124 126.810 130.484  1.00 50.07           N
ATOM    472  CA  LEU A 407      87.642 126.712 129.122  1.00 50.07           C
ATOM    473  C   LEU A 407      88.867 126.645 128.242  1.00 50.07           C
ATOM    474  O   LEU A 407      89.832 127.365 128.477  1.00 50.07           O
ATOM    475  CB  LEU A 407      86.776 127.904 128.710  1.00 50.07           C
ATOM    476  CG  LEU A 407      85.382 128.091 129.286  1.00 50.07           C
ATOM    477  CD1 LEU A 407      84.814 129.402 128.844  1.00 50.07           C
ATOM    478  CD2 LEU A 407      84.488 126.976 128.843  1.00 50.07           C
ATOM    479  N   TYR A 408      88.840 125.778 127.250  1.00 49.12           N
ATOM    480  CA  TYR A 408      89.910 125.768 126.277  1.00 49.12           C
ATOM    481  C   TYR A 408      89.712 126.936 125.331  1.00 49.12           C
ATOM    482  O   TYR A 408      88.589 127.288 124.990  1.00 49.12           O
ATOM    483  CB  TYR A 408      89.931 124.461 125.509  1.00 49.12           C
ATOM    484  CG  TYR A 408      89.959 123.278 126.414  1.00 49.12           C
ATOM    485  CD1 TYR A 408      91.022 123.063 127.265  1.00 49.12           C
ATOM    486  CD2 TYR A 408      88.940 122.350 126.387  1.00 49.12           C
ATOM    487  CE1 TYR A 408      91.043 121.987 128.095  1.00 49.12           C
ATOM    488  CE2 TYR A 408      88.958 121.265 127.201  1.00 49.12           C
ATOM    489  CZ  TYR A 408      90.013 121.084 128.052  1.00 49.12           C
ATOM    490  OH  TYR A 408      90.021 119.995 128.871  1.00 49.12           O
ATOM    491  N   VAL A 409      90.800 127.572 124.941  1.00 48.32           N
ATOM    492  CA  VAL A 409      90.732 128.763 124.114  1.00 48.32           C
ATOM    493  C   VAL A 409      91.527 128.509 122.848  1.00 48.32           C
ATOM    494  O   VAL A 409      92.660 128.029 122.909  1.00 48.32           O
ATOM    495  CB  VAL A 409      91.248 129.999 124.869  1.00 48.32           C
ATOM    496  CG1 VAL A 409      91.335 131.177 123.967  1.00 48.32           C
ATOM    497  CG2 VAL A 409      90.334 130.324 126.002  1.00 48.32           C
ATOM    498  N   VAL A 410      90.917 128.784 121.707  1.00 50.57           N
ATOM    499  CA  VAL A 410      91.628 128.896 120.445  1.00 50.57           C
ATOM    500  C   VAL A 410      91.872 130.374 120.210  1.00 50.57           C
ATOM    501  O   VAL A 410      90.932 131.141 120.004  1.00 50.57           O
ATOM    502  CB  VAL A 410      90.845 128.268 119.292  1.00 50.57           C
ATOM    503  CG1 VAL A 410      91.556 128.514 117.989  1.00 50.57           C
ATOM    504  CG2 VAL A 410      90.692 126.809 119.529  1.00 50.57           C
ATOM    505  N   ASP A 411      93.128 130.781 120.255  1.00 55.37           N
ATOM    506  CA  ASP A 411      93.486 132.176 120.089  1.00 55.37           C
ATOM    507  C   ASP A 411      93.807 132.423 118.624  1.00 55.37           C
ATOM    508  O   ASP A 411      94.605 131.700 118.030  1.00 55.37           O
ATOM    509  CB  ASP A 411      94.677 132.520 120.971  1.00 55.37           C
ATOM    510  CG  ASP A 411      94.812 133.988 121.213  1.00 55.37           C
ATOM    511  OD1 ASP A 411      93.979 134.767 120.731  1.00 55.37           O
ATOM    512  OD2 ASP A 411      95.765 134.369 121.895  1.00 55.37           O
ATOM    513  N   GLU A 412      93.188 133.437 118.044  1.00 58.94           N
ATOM    514  CA  GLU A 412      93.156 133.589 116.600  1.00 58.94           C
ATOM    515  C   GLU A 412      93.722 134.937 116.199  1.00 58.94           C
ATOM    516  O   GLU A 412      93.377 135.952 116.794  1.00 58.94           O
ATOM    517  CB  GLU A 412      91.731 133.423 116.097  1.00 58.94           C
ATOM    518  CG  GLU A 412      91.581 133.451 114.613  1.00 58.94           C
ATOM    519  CD  GLU A 412      90.230 132.937 114.193  1.00 58.94           C
ATOM    520  OE1 GLU A 412      89.438 132.566 115.081  1.00 58.94           O
ATOM    521  OE2 GLU A 412      89.959 132.888 112.983  1.00 58.94           O
ATOM    522  N   ALA A 413      94.605 134.936 115.210  1.00 56.38           N
ATOM    523  CA  ALA A 413      95.209 136.170 114.741  1.00 56.38           C
ATOM    524  C   ALA A 413      94.191 137.020 113.996  1.00 56.38           C
ATOM    525  O   ALA A 413      93.251 136.514 113.386  1.00 56.38           O
ATOM    526  CB  ALA A 413      96.398 135.870 113.838  1.00 56.38           C
ATOM    527  N   ASN A 414      94.397 138.332 114.043  1.00 58.63           N
ATOM    528  CA  ASN A 414      93.475 139.305 113.462  1.00 58.63           C
ATOM    529  C   ASN A 414      93.752 139.453 111.965  1.00 58.63           C
ATOM    530  O   ASN A 414      94.186 140.493 111.476  1.00 58.63           O
ATOM    531  CB  ASN A 414      93.626 140.636 114.179  1.00 58.63           C
ATOM    532  CG  ASN A 414      92.537 141.616 113.839  1.00 58.63           C
ATOM    533  OD1 ASN A 414      91.541 141.267 113.226  1.00 58.63           O
ATOM    534  ND2 ASN A 414      92.764 142.870 114.168  1.00 58.63           N
ATOM    535  N   ILE A 415      93.512 138.377 111.225  1.00 56.49           N
ATOM    536  CA  ILE A 415      93.741 138.356 109.786  1.00 56.49           C
ATOM    537  C   ILE A 415      92.513 137.754 109.129  1.00 56.49           C
ATOM    538  O   ILE A 415      92.233 136.567 109.309  1.00 56.49           O
ATOM    539  CB  ILE A 415      94.990 137.560 109.390  1.00 56.49           C
ATOM    540  CG1 ILE A 415      96.253 138.136 110.012  1.00 56.49           C
ATOM    541  CG2 ILE A 415      95.142 137.572 107.896  1.00 56.49           C
ATOM    542  CD1 ILE A 415      97.428 137.244 109.889  1.00 56.49           C
ATOM    543  N   GLU A 416      91.786 138.558 108.367  1.00 62.75           N
ATOM    544  CA  GLU A 416      90.731 138.032 107.512  1.00 62.75           C
ATOM    545  C   GLU A 416      90.601 138.899 106.276  1.00 62.75           C
ATOM    546  O   GLU A 416      90.346 140.096 106.383  1.00 62.75           O
ATOM    547  CB  GLU A 416      89.398 137.933 108.240  1.00 62.75           C
ATOM    548  CG  GLU A 416      88.299 137.504 107.301  1.00 62.75           C
ATOM    549  CD  GLU A 416      87.066 137.007 107.994  1.00 62.75           C
ATOM    550  OE1 GLU A 416      87.081 136.842 109.223  1.00 62.75           O
ATOM    551  OE2 GLU A 416      86.059 136.808 107.305  1.00 62.75           O
ATOM    552  N   THR A 417      90.704 138.287 105.113  1.00 63.74           N
ATOM    553  CA  THR A 417      90.590 139.026 103.883  1.00 63.74           C
ATOM    554  C   THR A 417      89.587 138.301 103.033  1.00 63.74           C
ATOM    555  O   THR A 417      89.854 137.963 101.901  1.00 63.74           O
ATOM    556  CB  THR A 417      91.926 139.031 103.140  1.00 63.74           C
ATOM    557  OG1 THR A 417      92.192 137.721 102.647  1.00 63.74           O
ATOM    558  CG2 THR A 417      93.039 139.432 104.059  1.00 63.74           C
ATOM    559  N   HIS A 418      88.399 138.131 103.582  1.00 66.36           N
ATOM    560  CA  HIS A 418      87.317 137.419 102.933  1.00 66.36           C
ATOM    561  C   HIS A 418      86.856 138.073 101.646  1.00 66.36           C
ATOM    562  O   HIS A 418      86.546 137.401 100.680  1.00 66.36           O
ATOM    563  CB  HIS A 418      86.140 137.311 103.891  1.00 66.36           C
ATOM    564  CG  HIS A 418      85.203 136.196 103.571  1.00 66.36           C
ATOM    565  ND1 HIS A 418      84.419 135.590 104.524  1.00 66.36           N
ATOM    566  CD2 HIS A 418      84.932 135.568 102.406  1.00 66.36           C
ATOM    567  CE1 HIS A 418      83.697 134.643 103.958  1.00 66.36           C
ATOM    568  NE2 HIS A 418      83.992 134.607 102.674  1.00 66.36           N
ATOM    569  N   GLY A 419      86.817 139.392 101.645  1.00 67.96           N
ATOM    570  CA  GLY A 419      86.365 140.157 100.507  1.00 67.96           C
ATOM    571  C   GLY A 419      87.241 140.207  99.275  1.00 67.96           C
ATOM    572  O   GLY A 419      86.796 140.681  98.245  1.00 67.96           O
ATOM    573  N   MET A 420      88.484 139.761  99.374  1.00 69.11           N
ATOM    574  CA  MET A 420      89.399 139.850  98.253  1.00 69.11           C
ATOM    575  C   MET A 420      89.015 138.841  97.183  1.00 69.11           C
ATOM    576  O   MET A 420      88.459 137.783  97.473  1.00 69.11           O
ATOM    577  CB  MET A 420      90.832 139.595  98.711  1.00 69.11           C
ATOM    578  CG  MET A 420      91.343 140.579  99.729  1.00 69.11           C
ATOM    579  SD  MET A 420      91.274 142.278  99.157  1.00 69.11           S
ATOM    580  CE  MET A 420      92.477 142.219  97.858  1.00 69.11           C
ATOM    581  N   VAL A 421      89.299 139.183  95.933  1.00 69.64           N
ATOM    582  CA  VAL A 421      89.087 138.254  94.827  1.00 69.64           C
ATOM    583  C   VAL A 421      90.420 138.026  94.125  1.00 69.64           C
ATOM    584  O   VAL A 421      90.963 138.960  93.524  1.00 69.64           O
ATOM    585  CB  VAL A 421      88.025 138.758  93.844  1.00 69.64           C
ATOM    586  CG1 VAL A 421      87.913 137.798  92.691  1.00 69.64           C
ATOM    587  CG2 VAL A 421      86.693 138.894  94.534  1.00 69.64           C
ATOM    588  N   PRO A 422      91.015 136.829  94.206  1.00 69.53           N
ATOM    589  CA  PRO A 422      90.617 135.673  95.005  1.00 69.53           C
ATOM    590  C   PRO A 422      90.948 135.902  96.462  1.00 69.53           C
ATOM    591  O   PRO A 422      91.562 136.914  96.765  1.00 69.53           O
ATOM    592  CB  PRO A 422      91.456 134.547  94.425  1.00 69.53           C
ATOM    593  CG  PRO A 422      92.650 135.214  93.935  1.00 69.53           C
ATOM    594  CD  PRO A 422      92.224 136.540  93.423  1.00 69.53           C
ATOM    595  N   MET A 423      90.547 134.986  97.337  1.00 69.70           N
ATOM    596  CA  MET A 423      90.600 135.249  98.766  1.00 69.70           C
ATOM    597  C   MET A 423      92.031 135.350  99.282  1.00 69.70           C
ATOM    598  O   MET A 423      92.256 135.980 100.315  1.00 69.70           O
ATOM    599  CB  MET A 423      89.819 134.162  99.504  1.00 69.70           C
ATOM    600  CG  MET A 423      89.427 134.465 100.918  1.00 69.70           C
ATOM    601  SD  MET A 423      88.671 133.027 101.695  1.00 69.70           S
ATOM    602  CE  MET A 423      87.155 132.882 100.789  1.00 69.70           C
ATOM    603  N   ASN A 424      93.010 134.805  98.561  1.00 67.55           N
ATOM    604  CA  ASN A 424      94.401 134.885  98.979  1.00 67.55           C
ATOM    605  C   ASN A 424      95.199 135.938  98.220  1.00 67.55           C
ATOM    606  O   ASN A 424      96.411 135.780  98.079  1.00 67.55           O
ATOM    607  CB  ASN A 424      95.094 133.527  98.858  1.00 67.55           C
ATOM    608  CG  ASN A 424      95.180 133.008  97.430  1.00 67.55           C
ATOM    609  OD1 ASN A 424      94.655 133.589  96.491  1.00 67.55           O
ATOM    610  ND2 ASN A 424      95.906 131.920  97.265  1.00 67.55           N
ATOM    611  N   ARG A 425      94.550 136.984  97.706  1.00 67.75           N
ATOM    612  CA  ARG A 425      95.269 137.985  96.925  1.00 67.75           C
ATOM    613  C   ARG A 425      96.299 138.724  97.770  1.00 67.75           C
ATOM    614  O   ARG A 425      97.416 138.981  97.314  1.00 67.75           O
ATOM    615  CB  ARG A 425      94.293 138.968  96.288  1.00 67.75           C
ATOM    616  CG  ARG A 425      94.983 140.024  95.462  1.00 67.75           C
ATOM    617  CD  ARG A 425      94.032 140.920  94.732  1.00 67.75           C
ATOM    618  NE  ARG A 425      93.364 140.232  93.641  1.00 67.75           N
ATOM    619  CZ  ARG A 425      93.881 140.089  92.429  1.00 67.75           C
ATOM    620  NH1 ARG A 425      95.074 140.583  92.151  1.00 67.75           N
ATOM    621  NH2 ARG A 425      93.204 139.451  91.493  1.00 67.75           N
ATOM    622  N   LEU A 426      95.970 139.014  99.019  1.00 63.68           N
ATOM    623  CA  LEU A 426      96.938 139.646  99.897  1.00 63.68           C
ATOM    624  C   LEU A 426      97.829 138.640 100.597  1.00 63.68           C
ATOM    625  O   LEU A 426      99.006 138.921 100.821  1.00 63.68           O
ATOM    626  CB  LEU A 426      96.229 140.498 100.945  1.00 63.68           C
ATOM    627  CG  LEU A 426      95.343 141.598 100.382  1.00 63.68           C
ATOM    628  CD1 LEU A 426      94.709 142.367 101.503  1.00 63.68           C
ATOM    629  CD2 LEU A 426      96.106 142.506  99.458  1.00 63.68           C
ATOM    630  N   THR A 427      97.309 137.475 100.946  1.00 62.81           N
ATOM    631  CA  THR A 427      98.087 136.533 101.730  1.00 62.81           C
ATOM    632  C   THR A 427      99.023 135.684 100.891  1.00 62.81           C
ATOM    633  O   THR A 427      99.783 134.902 101.454  1.00 62.81           O
ATOM    634  CB  THR A 427      97.171 135.622 102.531  1.00 62.81           C
ATOM    635  OG1 THR A 427      96.407 134.810 101.640  1.00 62.81           O
ATOM    636  CG2 THR A 427      96.233 136.437 103.379  1.00 62.81           C
ATOM    637  N   ASP A 428      98.988 135.799  99.573  1.00 68.07           N
ATOM    638  CA  ASP A 428      99.994 135.167  98.741  1.00 68.07           C
ATOM    639  C   ASP A 428     100.975 136.196  98.198  1.00 68.07           C
ATOM    640  O   ASP A 428     101.824 135.865  97.372  1.00 68.07           O
ATOM    641  CB  ASP A 428      99.328 134.394  97.607  1.00 68.07           C
ATOM    642  CG  ASP A 428     100.165 133.238  97.119  1.00 68.07           C
ATOM    643  OD1 ASP A 428     101.246 132.995  97.692  1.00 68.07           O
ATOM    644  OD2 ASP A 428      99.742 132.562  96.162  1.00 68.07           O
ATOM    645  N   ASP A 429     100.870 137.438  98.655  1.00 66.53           N
ATOM    646  CA  ASP A 429     101.729 138.528  98.237  1.00 66.53           C
ATOM    647  C   ASP A 429     102.768 138.765  99.317  1.00 66.53           C
ATOM    648  O   ASP A 429     102.391 139.022 100.467  1.00 66.53           O
ATOM    649  CB  ASP A 429     100.886 139.779  98.021  1.00 66.53           C
ATOM    650  CG  ASP A 429     101.634 140.913  97.343  1.00 66.53           C
ATOM    651  OD1 ASP A 429     102.832 140.799  97.035  1.00 66.53           O
ATOM    652  OD2 ASP A 429     100.996 141.953  97.107  1.00 66.53           O
ATOM    653  N   PRO A 430     104.066 138.695  99.016  1.00 63.91           N
ATOM    654  CA  PRO A 430     105.067 138.926 100.065  1.00 63.91           C
ATOM    655  C   PRO A 430     105.195 140.369 100.493  1.00 63.91           C
ATOM    656  O   PRO A 430     105.827 140.628 101.517  1.00 63.91           O
ATOM    657  CB  PRO A 430     106.361 138.421  99.427  1.00 63.91           C
ATOM    658  CG  PRO A 430     106.131 138.539  98.015  1.00 63.91           C
ATOM    659  CD  PRO A 430     104.697 138.253  97.767  1.00 63.91           C
ATOM    660  N   ARG A 431     104.611 141.314  99.761  1.00 67.22           N
ATOM    661  CA  ARG A 431     104.558 142.690 100.227  1.00 67.22           C
ATOM    662  C   ARG A 431     103.639 142.857 101.427  1.00 67.22           C
ATOM    663  O   ARG A 431     103.757 143.847 102.149  1.00 67.22           O
ATOM    664  CB  ARG A 431     104.116 143.601  99.089  1.00 67.22           C
ATOM    665  CG  ARG A 431     105.154 143.718  97.990  1.00 67.22           C
ATOM    666  CD  ARG A 431     104.646 144.483  96.788  1.00 67.22           C
ATOM    667  NE  ARG A 431     104.335 145.877  97.085  1.00 67.22           N
ATOM    668  CZ  ARG A 431     105.219 146.867  97.051  1.00 67.22           C
ATOM    669  NH1 ARG A 431     106.484 146.626  96.745  1.00 67.22           N
ATOM    670  NH2 ARG A 431     104.838 148.101  97.333  1.00 67.22           N
ATOM    671  N   TRP A 432     102.737 141.914 101.659  1.00 61.70           N
ATOM    672  CA  TRP A 432     101.862 141.920 102.815  1.00 61.70           C
ATOM    673  C   TRP A 432     102.330 140.987 103.911  1.00 61.70           C
ATOM    674  O   TRP A 432     101.694 140.926 104.960  1.00 61.70           O
ATOM    675  CB  TRP A 432     100.451 141.551 102.384  1.00 61.70           C
ATOM    676  CG  TRP A 432      99.799 142.640 101.653  1.00 61.70           C
ATOM    677  CD1 TRP A 432      99.877 142.890 100.328  1.00 61.70           C
ATOM    678  CD2 TRP A 432      98.927 143.622 102.199  1.00 61.70           C
ATOM    679  NE1 TRP A 432      99.130 143.986 100.012  1.00 61.70           N
ATOM    680  CE2 TRP A 432      98.530 144.452 101.148  1.00 61.70           C
ATOM    681  CE3 TRP A 432      98.447 143.882 103.480  1.00 61.70           C
ATOM    682  CZ2 TRP A 432      97.671 145.520 101.333  1.00 61.70           C
ATOM    683  CZ3 TRP A 432      97.603 144.940 103.663  1.00 61.70           C
ATOM    684  CH2 TRP A 432      97.223 145.749 102.598  1.00 61.70           C
ATOM    685  N   LEU A 433     103.410 140.250 103.680  1.00 59.21           N
ATOM    686  CA  LEU A 433     103.984 139.418 104.732  1.00 59.21           C
ATOM    687  C   LEU A 433     104.461 140.186 105.967  1.00 59.21           C
ATOM    688  O   LEU A 433     104.265 139.658 107.072  1.00 59.21           O
ATOM    689  CB  LEU A 433     105.105 138.551 104.143  1.00 59.21           C
ATOM    690  CG  LEU A 433     105.850 137.602 105.078  1.00 59.21           C
ATOM    691  CD1 LEU A 433     104.904 136.617 105.706  1.00 59.21           C
ATOM    692  CD2 LEU A 433     106.930 136.879 104.322  1.00 59.21           C
ATOM    693  N   PRO A 434     105.068 141.387 105.887  1.00 60.38           N
ATOM    694  CA  PRO A 434     105.325 142.123 107.138  1.00 60.38           C
ATOM    695  C   PRO A 434     104.083 142.521 107.910  1.00 60.38           C
ATOM    696  O   PRO A 434     104.106 142.492 109.143  1.00 60.38           O
ATOM    697  CB  PRO A 434     106.094 143.353 106.657  1.00 60.38           C
ATOM    698  CG  PRO A 434     106.761 142.916 105.478  1.00 60.38           C
ATOM    699  CD  PRO A 434     105.835 142.006 104.787  1.00 60.38           C
ATOM    700  N   ALA A 435     103.002 142.894 107.230  1.00 60.35           N
ATOM    701  CA  ALA A 435     101.792 143.269 107.948  1.00 60.35           C
ATOM    702  C   ALA A 435     101.120 142.054 108.565  1.00 60.35           C
ATOM    703  O   ALA A 435     100.592 142.131 109.676  1.00 60.35           O
ATOM    704  CB  ALA A 435     100.830 143.996 107.017  1.00 60.35           C
ATOM    705  N   MET A 436     101.136 140.925 107.864  1.00 60.10           N
ATOM    706  CA  MET A 436     100.543 139.715 108.410  1.00 60.10           C
ATOM    707  C   MET A 436     101.367 139.145 109.546  1.00 60.10           C
ATOM    708  O   MET A 436     100.803 138.572 110.479  1.00 60.10           O
ATOM    709  CB  MET A 436     100.380 138.667 107.322  1.00 60.10           C
ATOM    710  CG  MET A 436      99.296 138.958 106.338  1.00 60.10           C
ATOM    711  SD  MET A 436      99.293 137.718 105.056  1.00 60.10           S
ATOM    712  CE  MET A 436      98.875 136.273 106.014  1.00 60.10           C
ATOM    713  N   SER A 437     102.690 139.287 109.490  1.00 59.53           N
ATOM    714  CA  SER A 437     103.524 138.686 110.518  1.00 59.53           C
ATOM    715  C   SER A 437     103.377 139.397 111.849  1.00 59.53           C
ATOM    716  O   SER A 437     103.372 138.741 112.887  1.00 59.53           O
ATOM    717  CB  SER A 437     104.986 138.664 110.089  1.00 59.53           C
ATOM    718  OG  SER A 437     105.518 139.964 110.011  1.00 59.53           O
ATOM    719  N   GLU A 438     103.193 140.703 111.811  1.00 63.70           N
ATOM    720  CA  GLU A 438     103.022 141.471 113.022  1.00 63.70           C
ATOM    721  C   GLU A 438     101.772 141.018 113.746  1.00 63.70           C
ATOM    722  O   GLU A 438     101.756 140.929 114.955  1.00 63.70           O
ATOM    723  CB  GLU A 438     102.901 142.948 112.689  1.00 63.70           C
ATOM    724  CG  GLU A 438     104.137 143.529 112.043  1.00 63.70           C
ATOM    725  CD  GLU A 438     105.108 144.089 113.056  1.00 63.70           C
ATOM    726  OE1 GLU A 438     106.334 144.002 112.826  1.00 63.70           O
ATOM    727  OE2 GLU A 438     104.644 144.621 114.085  1.00 63.70           O
ATOM    728  N   ARG A 439     100.721 140.735 112.996  1.00 59.20           N
ATOM    729  CA  ARG A 439      99.465 140.319 113.593  1.00 59.20           C
ATOM    730  C   ARG A 439      99.552 138.944 114.222  1.00 59.20           C
ATOM    731  O   ARG A 439      98.813 138.662 115.163  1.00 59.20           O
ATOM    732  CB  ARG A 439      98.368 140.359 112.542  1.00 59.20           C
ATOM    733  CG  ARG A 439      98.037 141.764 112.173  1.00 59.20           C
ATOM    734  CD  ARG A 439      97.164 141.842 110.985  1.00 59.20           C
ATOM    735  NE  ARG A 439      96.923 143.231 110.648  1.00 59.20           N
ATOM    736  CZ  ARG A 439      95.854 143.908 111.026  1.00 59.20           C
ATOM    737  NH1 ARG A 439      95.727 145.174 110.693  1.00 59.20           N
ATOM    738  NH2 ARG A 439      94.905 143.309 111.711  1.00 59.20           N
ATOM    739  N   VAL A 440     100.449 138.099 113.742  1.00 55.50           N
ATOM    740  CA  VAL A 440     100.631 136.776 114.310  1.00 55.50           C
ATOM    741  C   VAL A 440     101.645 136.793 115.440  1.00 55.50           C
ATOM    742  O   VAL A 440     101.383 136.264 116.520  1.00 55.50           O
ATOM    743  CB  VAL A 440     101.034 135.791 113.200  1.00 55.50           C
ATOM    744  CG1 VAL A 440     101.447 134.492 113.785  1.00 55.50           C
ATOM    745  CG2 VAL A 440      99.877 135.576 112.266  1.00 55.50           C
ATOM    746  N   THR A 441     102.805 137.413 115.217  1.00 57.15           N
ATOM    747  CA  THR A 441     103.886 137.350 116.194  1.00 57.15           C
ATOM    748  C   THR A 441     103.557 138.118 117.462  1.00 57.15           C
ATOM    749  O   THR A 441     103.959 137.703 118.548  1.00 57.15           O
ATOM    750  CB  THR A 441     105.192 137.870 115.596  1.00 57.15           C
ATOM    751  OG1 THR A 441     105.030 139.226 115.188  1.00 57.15           O
ATOM    752  CG2 THR A 441     105.622 137.036 114.415  1.00 57.15           C
ATOM    753  N   ARG A 442     102.807 139.205 117.360  1.00 59.65           N
ATOM    754  CA  ARG A 442     102.459 139.953 118.554  1.00 59.65           C
ATOM    755  C   ARG A 442     101.324 139.312 119.331  1.00 59.65           C
ATOM    756  O   ARG A 442     101.200 139.566 120.528  1.00 59.65           O
ATOM    757  CB  ARG A 442     102.115 141.389 118.187  1.00 59.65           C
ATOM    758  CG  ARG A 442     103.300 142.113 117.609  1.00 59.65           C
ATOM    759  CD  ARG A 442     102.972 143.494 117.129  1.00 59.65           C
ATOM    760  NE  ARG A 442     102.668 144.397 118.225  1.00 59.65           N
ATOM    761  CZ  ARG A 442     101.489 144.968 118.419  1.00 59.65           C
ATOM    762  NH1 ARG A 442     100.492 144.752 117.580  1.00 59.65           N
ATOM    763  NH2 ARG A 442     101.318 145.774 119.448  1.00 59.65           N
ATOM    764  N   MET A 443     100.502 138.490 118.684  1.00 57.54           N
ATOM    765  CA  MET A 443      99.524 137.696 119.414  1.00 57.54           C
ATOM    766  C   MET A 443     100.206 136.631 120.255  1.00 57.54           C
ATOM    767  O   MET A 443      99.875 136.451 121.430  1.00 57.54           O
ATOM    768  CB  MET A 443      98.547 137.039 118.451  1.00 57.54           C
ATOM    769  CG  MET A 443      97.621 136.074 119.143  1.00 57.54           C
ATOM    770  SD  MET A 443      96.583 135.142 118.038  1.00 57.54           S
ATOM    771  CE  MET A 443      97.777 134.093 117.236  1.00 57.54           C
ATOM    772  N   VAL A 444     101.153 135.910 119.658  1.00 55.44           N
ATOM    773  CA  VAL A 444     101.851 134.839 120.356  1.00 55.44           C
ATOM    774  C   VAL A 444     102.682 135.399 121.498  1.00 55.44           C
ATOM    775  O   VAL A 444     102.694 134.846 122.595  1.00 55.44           O
ATOM    776  CB  VAL A 444     102.698 134.033 119.358  1.00 55.44           C
ATOM    777  CG1 VAL A 444     103.553 133.022 120.064  1.00 55.44           C
ATOM    778  CG2 VAL A 444     101.802 133.334 118.379  1.00 55.44           C
ATOM    779  N   GLN A 445     103.323 136.542 121.285  1.00 60.13           N
ATOM    780  CA  GLN A 445     104.104 137.155 122.349  1.00 60.13           C
ATOM    781  C   GLN A 445     103.240 137.676 123.485  1.00 60.13           C
ATOM    782  O   GLN A 445     103.694 137.710 124.628  1.00 60.13           O
ATOM    783  CB  GLN A 445     104.964 138.266 121.778  1.00 60.13           C
ATOM    784  CG  GLN A 445     106.200 137.742 121.139  1.00 60.13           C
ATOM    785  CD  GLN A 445     107.039 138.817 120.528  1.00 60.13           C
ATOM    786  OE1 GLN A 445     106.556 139.894 120.209  1.00 60.13           O
ATOM    787  NE2 GLN A 445     108.330 138.575 120.473  1.00 60.13           N
ATOM    788  N   ARG A 446     101.998 138.050 123.212  1.00 58.60           N
ATOM    789  CA  ARG A 446     101.146 138.509 124.295  1.00 58.60           C
ATOM    790  C   ARG A 446     100.581 137.346 125.100  1.00 58.60           C
ATOM    791  O   ARG A 446     100.500 137.424 126.326  1.00 58.60           O
ATOM    792  CB  ARG A 446     100.002 139.361 123.757  1.00 58.60           C
ATOM    793  CG  ARG A 446      99.252 140.057 124.859  1.00 58.60           C
ATOM    794  CD  ARG A 446      97.981 140.719 124.423  1.00 58.60           C
ATOM    795  NE  ARG A 446      96.970 139.738 124.075  1.00 58.60           N
ATOM    796  CZ  ARG A 446      95.734 140.034 123.707  1.00 58.60           C
ATOM    797  NH1 ARG A 446      94.891 139.067 123.406  1.00 58.60           N
ATOM    798  NH2 ARG A 446      95.329 141.288 123.677  1.00 58.60           N
ATOM    799  N   ASP A 447     100.204 136.254 124.440  1.00 58.33           N
ATOM    800  CA  ASP A 447      99.292 135.288 125.033  1.00 58.33           C
ATOM    801  C   ASP A 447      99.883 133.904 125.252  1.00 58.33           C
ATOM    802  O   ASP A 447      99.141 132.988 125.599  1.00 58.33           O
ATOM    803  CB  ASP A 447      98.043 135.172 124.163  1.00 58.33           C
ATOM    804  CG  ASP A 447      97.219 136.427 124.181  1.00 58.33           C
ATOM    805  OD1 ASP A 447      97.217 137.116 125.213  1.00 58.33           O
ATOM    806  OD2 ASP A 447      96.590 136.751 123.166  1.00 58.33           O
ATOM    807  N   ARG A 448     101.189 133.724 125.088  1.00 59.42           N
ATOM    808  CA  ARG A 448     101.758 132.384 125.151  1.00 59.42           C
ATOM    809  C   ARG A 448     101.826 131.804 126.555  1.00 59.42           C
ATOM    810  O   ARG A 448     102.063 130.605 126.684  1.00 59.42           O
ATOM    811  CB  ARG A 448     103.154 132.373 124.554  1.00 59.42           C
ATOM    812  CG  ARG A 448     104.130 133.241 125.288  1.00 59.42           C
ATOM    813  CD  ARG A 448     105.441 133.254 124.574  1.00 59.42           C
ATOM    814  NE  ARG A 448     106.004 131.919 124.523  1.00 59.42           N
ATOM    815  CZ  ARG A 448     106.997 131.562 123.725  1.00 59.42           C
ATOM    816  NH1 ARG A 448     107.546 132.451 122.918  1.00 59.42           N
ATOM    817  NH2 ARG A 448     107.440 130.318 123.740  1.00 59.42           N
ATOM    818  N   ASN A 449     101.632 132.595 127.599  1.00 61.44           N
ATOM    819  CA  ASN A 449     101.723 132.048 128.942  1.00 61.44           C
ATOM    820  C   ASN A 449     100.389 131.582 129.499  1.00 61.44           C
ATOM    821  O   ASN A 449     100.370 130.996 130.581  1.00 61.44           O
ATOM    822  CB  ASN A 449     102.330 133.065 129.903  1.00 61.44           C
ATOM    823  CG  ASN A 449     103.786 133.314 129.634  1.00 61.44           C
ATOM    824  OD1 ASN A 449     104.515 132.416 129.242  1.00 61.44           O
ATOM    825  ND2 ASN A 449     104.227 134.528 129.878  1.00 61.44           N
TER     826      ASN A 449
ATOM    827  N   ILE B 351     129.309  96.854 121.905  1.00 48.46           N
ATOM    828  CA  ILE B 351     129.507  95.413 121.987  1.00 48.46           C
ATOM    829  C   ILE B 351     130.998  95.116 121.929  1.00 48.46           C
ATOM    830  O   ILE B 351     131.655  95.364 120.920  1.00 48.46           O
ATOM    831  CB  ILE B 351     128.754  94.685 120.871  1.00 48.46           C
ATOM    832  CG1 ILE B 351     127.254  94.902 121.018  1.00 48.46           C
ATOM    833  CG2 ILE B 351     129.098  93.225 120.857  1.00 48.46           C
ATOM    834  CD1 ILE B 351     126.697  94.389 122.294  1.00 48.46           C
ATOM    835  N   ARG B 352     131.532  94.604 123.026  1.00 47.56           N
ATOM    836  CA  ARG B 352     132.897  94.108 123.098  1.00 47.56           C
ATOM    837  C   ARG B 352     132.809  92.593 123.003  1.00 47.56           C
ATOM    838  O   ARG B 352     132.895  91.877 123.986  1.00 47.56           O
ATOM    839  CB  ARG B 352     133.533  94.558 124.394  1.00 47.56           C
ATOM    840  CG  ARG B 352     133.682  96.030 124.486  1.00 47.56           C
ATOM    841  CD  ARG B 352     133.985  96.447 125.867  1.00 47.56           C
ATOM    842  NE  ARG B 352     134.441  97.824 125.952  1.00 47.56           N
ATOM    843  CZ  ARG B 352     133.652  98.882 126.028  1.00 47.56           C
ATOM    844  NH1 ARG B 352     132.342  98.748 126.003  1.00 47.56           N
ATOM    845  NH2 ARG B 352     134.185 100.081 126.115  1.00 47.56           N
ATOM    846  N   GLY B 353     132.592  92.100 121.792  1.00 44.56           N
ATOM    847  CA  GLY B 353     132.170  90.737 121.596  1.00 44.56           C
ATOM    848  C   GLY B 353     133.244  89.823 121.042  1.00 44.56           C
ATOM    849  O   GLY B 353     134.257  90.249 120.505  1.00 44.56           O
ATOM    850  N   VAL B 354     132.980  88.532 121.172  1.00 46.19           N
ATOM    851  CA  VAL B 354     133.829  87.507 120.589  1.00 46.19           C
ATOM    852  C   VAL B 354     132.945  86.347 120.155  1.00 46.19           C
ATOM    853  O   VAL B 354     131.944  86.033 120.796  1.00 46.19           O
ATOM    854  CB  VAL B 354     134.950  87.089 121.571  1.00 46.19           C
ATOM    855  CG1 VAL B 354     134.409  86.439 122.815  1.00 46.19           C
ATOM    856  CG2 VAL B 354     135.969  86.208 120.897  1.00 46.19           C
ATOM    857  N   ASN B 355     133.274  85.771 119.013  1.00 51.55           N
ATOM    858  CA  ASN B 355     132.677  84.527 118.574  1.00 51.55           C
ATOM    859  C   ASN B 355     133.299  83.365 119.322  1.00 51.55           C
ATOM    860  O   ASN B 355     134.504  83.341 119.554  1.00 51.55           O
ATOM    861  CB  ASN B 355     132.909  84.354 117.088  1.00 51.55           C
ATOM    862  CG  ASN B 355     132.043  85.242 116.263  1.00 51.55           C
ATOM    863  OD1 ASN B 355     130.836  85.148 116.308  1.00 51.55           O
ATOM    864  ND2 ASN B 355     132.653  86.175 115.568  1.00 51.55           N
ATOM    865  N   ARG B 356     132.482  82.393 119.691  1.00 56.59           N
ATOM    866  CA  ARG B 356     132.969  81.248 120.444  1.00 56.59           C
ATOM    867  C   ARG B 356     132.332  79.976 119.923  1.00 56.59           C
ATOM    868  O   ARG B 356     131.114  79.821 119.989  1.00 56.59           O
ATOM    869  CB  ARG B 356     132.674  81.407 121.926  1.00 56.59           C
ATOM    870  CG  ARG B 356     133.109  80.234 122.742  1.00 56.59           C
ATOM    871  CD  ARG B 356     132.698  80.438 124.149  1.00 56.59           C
ATOM    872  NE  ARG B 356     133.046  79.328 125.011  1.00 56.59           N
ATOM    873  CZ  ARG B 356     132.239  78.310 125.252  1.00 56.59           C
ATOM    874  NH1 ARG B 356     132.626  77.349 126.059  1.00 56.59           N
ATOM    875  NH2 ARG B 356     131.045  78.261 124.691  1.00 56.59           N
ATOM    876  N   HIS B 357     133.155  79.070 119.416  1.00 61.68           N
ATOM    877  CA  HIS B 357     132.732  77.701 119.190  1.00 61.68           C
ATOM    878  C   HIS B 357     132.844  76.883 120.462  1.00 61.68           C
ATOM    879  O   HIS B 357     133.681  77.145 121.324  1.00 61.68           O
ATOM    880  CB  HIS B 357     133.571  77.034 118.107  1.00 61.68           C
ATOM    881  CG  HIS B 357     133.122  77.335 116.718  1.00 61.68           C
ATOM    882  ND1 HIS B 357     132.017  76.738 116.156  1.00 61.68           N
ATOM    883  CD2 HIS B 357     133.651  78.124 115.757  1.00 61.68           C
ATOM    884  CE1 HIS B 357     131.868  77.168 114.918  1.00 61.68           C
ATOM    885  NE2 HIS B 357     132.846  78.012 114.652  1.00 61.68           N
ATOM    886  N   GLU B 358     131.993  75.876 120.566  1.00 65.17           N
ATOM    887  CA  GLU B 358     132.129  74.859 121.600  1.00 65.17           C
ATOM    888  C   GLU B 358     133.207  73.880 121.171  1.00 65.17           C
ATOM    889  O   GLU B 358     132.985  73.033 120.310  1.00 65.17           O
ATOM    890  CB  GLU B 358     130.806  74.149 121.834  1.00 65.17           C
ATOM    891  CG  GLU B 358     129.829  74.950 122.629  1.00 65.17           C
ATOM    892  CD  GLU B 358     128.540  74.206 122.871  1.00 65.17           C
ATOM    893  OE1 GLU B 358     128.299  73.184 122.202  1.00 65.17           O
ATOM    894  OE2 GLU B 358     127.787  74.614 123.769  1.00 65.17           O
ATOM    895  N   HIS B 359     134.384  73.994 121.769  1.00 64.28           N
ATOM    896  CA  HIS B 359     135.502  73.161 121.369  1.00 64.28           C
ATOM    897  C   HIS B 359     136.349  72.825 122.578  1.00 64.28           C
ATOM    898  O   HIS B 359     136.650  73.698 123.391  1.00 64.28           O
ATOM    899  CB  HIS B 359     136.363  73.855 120.321  1.00 64.28           C
ATOM    900  CG  HIS B 359     137.541  73.049 119.891  1.00 64.28           C
ATOM    901  ND1 HIS B 359     137.447  72.021 118.982  1.00 64.28           N
ATOM    902  CD2 HIS B 359     138.834  73.089 120.281  1.00 64.28           C
ATOM    903  CE1 HIS B 359     138.638  71.483 118.808  1.00 64.28           C
ATOM    904  NE2 HIS B 359     139.496  72.108 119.589  1.00 64.28           N
ATOM    905  N   HIS B 360     136.728  71.562 122.685  1.00 67.87           N
ATOM    906  CA  HIS B 360     137.695  71.115 123.659  1.00 67.87           C
ATOM    907  C   HIS B 360     138.710  70.277 122.893  1.00 67.87           C
ATOM    908  O   HIS B 360     138.316  69.457 122.056  1.00 67.87           O
ATOM    909  CB  HIS B 360     137.033  70.300 124.765  1.00 67.87           C
ATOM    910  CG  HIS B 360     137.924  70.044 125.933  1.00 67.87           C
ATOM    911  ND1 HIS B 360     138.838  69.016 125.959  1.00 67.87           N
ATOM    912  CD2 HIS B 360     138.044  70.684 127.118  1.00 67.87           C
ATOM    913  CE1 HIS B 360     139.488  69.037 127.107  1.00 67.87           C
ATOM    914  NE2 HIS B 360     139.022  70.038 127.830  1.00 67.87           N
ATOM    915  N   PRO B 361     140.011  70.460 123.125  1.00 67.53           N
ATOM    916  CA  PRO B 361     141.007  69.765 122.297  1.00 67.53           C
ATOM    917  C   PRO B 361     141.077  68.272 122.537  1.00 67.53           C
ATOM    918  O   PRO B 361     141.514  67.543 121.644  1.00 67.53           O
ATOM    919  CB  PRO B 361     142.318  70.443 122.692  1.00 67.53           C
ATOM    920  CG  PRO B 361     142.079  70.914 124.059  1.00 67.53           C
ATOM    921  CD  PRO B 361     140.649  71.315 124.135  1.00 67.53           C
ATOM    922  N   LEU B 362     140.655  67.793 123.700  1.00 71.34           N
ATOM    923  CA  LEU B 362     140.645  66.370 123.995  1.00 71.34           C
ATOM    924  C   LEU B 362     139.303  65.720 123.730  1.00 71.34           C
ATOM    925  O   LEU B 362     139.257  64.585 123.255  1.00 71.34           O
ATOM    926  CB  LEU B 362     141.032  66.133 125.453  1.00 71.34           C
ATOM    927  CG  LEU B 362     142.478  66.476 125.778  1.00 71.34           C
ATOM    928  CD1 LEU B 362     142.720  66.381 127.267  1.00 71.34           C
ATOM    929  CD2 LEU B 362     143.394  65.541 125.025  1.00 71.34           C
ATOM    930  N   HIS B 363     138.209  66.414 124.016  1.00 70.30           N
ATOM    931  CA  HIS B 363     136.886  65.821 123.951  1.00 70.30           C
ATOM    932  C   HIS B 363     136.087  66.302 122.756  1.00 70.30           C
ATOM    933  O   HIS B 363     134.908  65.968 122.644  1.00 70.30           O
ATOM    934  CB  HIS B 363     136.129  66.110 125.239  1.00 70.30           C
ATOM    935  CG  HIS B 363     136.842  65.636 126.459  1.00 70.30           C
ATOM    936  ND1 HIS B 363     137.023  64.301 126.740  1.00 70.30           N
ATOM    937  CD2 HIS B 363     137.417  66.317 127.475  1.00 70.30           C
ATOM    938  CE1 HIS B 363     137.687  64.181 127.873  1.00 70.30           C
ATOM    939  NE2 HIS B 363     137.935  65.389 128.342  1.00 70.30           N
ATOM    940  N   GLY B 364     136.696  67.066 121.862  1.00 67.40           N
ATOM    941  CA  GLY B 364     135.999  67.543 120.690  1.00 67.40           C
ATOM    942  C   GLY B 364     134.962  68.589 121.012  1.00 67.40           C
ATOM    943  O   GLY B 364     135.280  69.647 121.551  1.00 67.40           O
ATOM    944  N   GLN B 365     133.705  68.291 120.711  1.00 66.01           N
ATOM    945  CA  GLN B 365     132.626  69.250 120.867  1.00 66.01           C
ATOM    946  C   GLN B 365     131.784  68.979 122.101  1.00 66.01           C
ATOM    947  O   GLN B 365     130.630  69.403 122.165  1.00 66.01           O
ATOM    948  CB  GLN B 365     131.785  69.259 119.598  1.00 66.01           C
ATOM    949  CG  GLN B 365     132.611  69.746 118.437  1.00 66.01           C
ATOM    950  CD  GLN B 365     131.921  69.642 117.116  1.00 66.01           C
ATOM    951  OE1 GLN B 365     130.823  69.109 117.016  1.00 66.01           O
ATOM    952  NE2 GLN B 365     132.565  70.152 116.081  1.00 66.01           N
ATOM    953  N   VAL B 366     132.351  68.309 123.092  1.00 67.04           N
ATOM    954  CA  VAL B 366     131.679  68.027 124.350  1.00 67.04           C
ATOM    955  C   VAL B 366     132.146  69.049 125.370  1.00 67.04           C
ATOM    956  O   VAL B 366     133.340  69.140 125.664  1.00 67.04           O
ATOM    957  CB  VAL B 366     131.973  66.601 124.826  1.00 67.04           C
ATOM    958  CG1 VAL B 366     131.360  66.359 126.176  1.00 67.04           C
ATOM    959  CG2 VAL B 366     131.442  65.638 123.828  1.00 67.04           C
ATOM    960  N   MET B 367     131.210  69.811 125.915  1.00 73.05           N
ATOM    961  CA  MET B 367     131.522  70.886 126.840  1.00 73.05           C
ATOM    962  C   MET B 367     131.044  70.544 128.237  1.00 73.05           C
ATOM    963  O   MET B 367     129.906  70.110 128.419  1.00 73.05           O
ATOM    964  CB  MET B 367     130.884  72.197 126.394  1.00 73.05           C
ATOM    965  CG  MET B 367     131.475  72.759 125.143  1.00 73.05           C
ATOM    966  SD  MET B 367     133.249  72.975 125.298  1.00 73.05           S
ATOM    967  CE  MET B 367     133.287  74.143 126.634  1.00 73.05           C
ATOM    968  N   ASP B 368     131.911  70.750 129.215  1.00 74.79           N
ATOM    969  CA  ASP B 368     131.555  70.649 130.617  1.00 74.79           C
ATOM    970  C   ASP B 368     131.544  72.033 131.248  1.00 74.79           C
ATOM    971  O   ASP B 368     131.916  73.024 130.623  1.00 74.79           O
ATOM    972  CB  ASP B 368     132.515  69.720 131.358  1.00 74.79           C
ATOM    973  CG  ASP B 368     133.960  70.103 131.173  1.00 74.79           C
ATOM    974  OD1 ASP B 368     134.259  70.963 130.325  1.00 74.79           O
ATOM    975  OD2 ASP B 368     134.809  69.551 131.897  1.00 74.79           O
ATOM    976  N   GLU B 369     131.119  72.082 132.511  1.00 72.94           N
ATOM    977  CA  GLU B 369     130.946  73.360 133.189  1.00 72.94           C
ATOM    978  C   GLU B 369     132.272  74.047 133.464  1.00 72.94           C
ATOM    979  O   GLU B 369     132.358  75.273 133.362  1.00 72.94           O
ATOM    980  CB  GLU B 369     130.176  73.162 134.489  1.00 72.94           C
ATOM    981  CG  GLU B 369     129.865  74.446 135.220  1.00 72.94           C
ATOM    982  CD  GLU B 369     128.929  74.248 136.382  1.00 72.94           C
ATOM    983  OE1 GLU B 369     128.507  73.098 136.613  1.00 72.94           O
ATOM    984  OE2 GLU B 369     128.610  75.245 137.062  1.00 72.94           O
ATOM    985  N   GLN B 370     133.317  73.279 133.767  1.00 72.96           N
ATOM    986  CA  GLN B 370     134.589  73.869 134.164  1.00 72.96           C
ATOM    987  C   GLN B 370     135.265  74.590 133.011  1.00 72.96           C
ATOM    988  O   GLN B 370     135.914  75.616 133.223  1.00 72.96           O
ATOM    989  CB  GLN B 370     135.521  72.800 134.725  1.00 72.96           C
ATOM    990  CG  GLN B 370     135.228  72.377 136.158  1.00 72.96           C
ATOM    991  CD  GLN B 370     133.944  71.582 136.302  1.00 72.96           C
ATOM    992  OE1 GLN B 370     133.050  71.959 137.059  1.00 72.96           O
ATOM    993  NE2 GLN B 370     133.833  70.495 135.546  1.00 72.96           N
ATOM    994  N   THR B 371     135.110  74.088 131.792  1.00 69.40           N
ATOM    995  CA  THR B 371     135.661  74.789 130.646  1.00 69.40           C
ATOM    996  C   THR B 371     134.831  76.018 130.304  1.00 69.40           C
ATOM    997  O   THR B 371     135.381  77.031 129.865  1.00 69.40           O
ATOM    998  CB  THR B 371     135.755  73.835 129.460  1.00 69.40           C
ATOM    999  OG1 THR B 371     136.434  72.649 129.875  1.00 69.40           O
ATOM   1000  CG2 THR B 371     136.560  74.444 128.338  1.00 69.40           C
ATOM   1001  N   MET B 372     133.516  75.959 130.527  1.00 66.04           N
ATOM   1002  CA  MET B 372     132.669  77.124 130.292  1.00 66.04           C
ATOM   1003  C   MET B 372     132.974  78.242 131.270  1.00 66.04           C
ATOM   1004  O   MET B 372     133.001  79.412 130.883  1.00 66.04           O
ATOM   1005  CB  MET B 372     131.201  76.760 130.411  1.00 66.04           C
ATOM   1006  CG  MET B 372     130.687  75.842 129.379  1.00 66.04           C
ATOM   1007  SD  MET B 372     128.956  75.568 129.711  1.00 66.04           S
ATOM   1008  CE  MET B 372     128.683  74.221 128.608  1.00 66.04           C
ATOM   1009  N   VAL B 373     133.169  77.905 132.543  1.00 63.90           N
ATOM   1010  CA  VAL B 373     133.500  78.915 133.535  1.00 63.90           C
ATOM   1011  C   VAL B 373     134.879  79.487 133.258  1.00 63.90           C
ATOM   1012  O   VAL B 373     135.093  80.694 133.380  1.00 63.90           O
ATOM   1013  CB  VAL B 373     133.383  78.325 134.951  1.00 63.90           C
ATOM   1014  CG1 VAL B 373     133.860  79.299 135.996  1.00 63.90           C
ATOM   1015  CG2 VAL B 373     131.957  77.968 135.233  1.00 63.90           C
ATOM   1016  N   GLN B 374     135.806  78.645 132.803  1.00 64.33           N
ATOM   1017  CA  GLN B 374     137.139  79.109 132.439  1.00 64.33           C
ATOM   1018  C   GLN B 374     137.095  80.079 131.266  1.00 64.33           C
ATOM   1019  O   GLN B 374     137.844  81.059 131.241  1.00 64.33           O
ATOM   1020  CB  GLN B 374     138.025  77.916 132.099  1.00 64.33           C
ATOM   1021  CG  GLN B 374     139.467  78.264 131.864  1.00 64.33           C
ATOM   1022  CD  GLN B 374     140.297  77.068 131.474  1.00 64.33           C
ATOM   1023  OE1 GLN B 374     139.775  75.982 131.254  1.00 64.33           O
ATOM   1024  NE2 GLN B 374     141.602  77.259 131.402  1.00 64.33           N
ATOM   1025  N   ASP B 375     136.207  79.839 130.301  1.00 60.95           N
ATOM   1026  CA  ASP B 375     136.078  80.757 129.178  1.00 60.95           C
ATOM   1027  C   ASP B 375     135.484  82.088 129.606  1.00 60.95           C
ATOM   1028  O   ASP B 375     135.972  83.139 129.191  1.00 60.95           O
ATOM   1029  CB  ASP B 375     135.235  80.146 128.065  1.00 60.95           C
ATOM   1030  CG  ASP B 375     135.991  79.130 127.252  1.00 60.95           C
ATOM   1031  OD1 ASP B 375     137.228  79.195 127.226  1.00 60.95           O
ATOM   1032  OD2 ASP B 375     135.350  78.288 126.600  1.00 60.95           O
ATOM   1033  N   ILE B 376     134.451  82.064 130.448  1.00 57.89           N
ATOM   1034  CA  ILE B 376     133.755  83.289 130.826  1.00 57.89           C
ATOM   1035  C   ILE B 376     134.635  84.176 131.688  1.00 57.89           C
ATOM   1036  O   ILE B 376     134.629  85.401 131.533  1.00 57.89           O
ATOM   1037  CB  ILE B 376     132.427  82.948 131.518  1.00 57.89           C
ATOM   1038  CG1 ILE B 376     131.484  82.364 130.498  1.00 57.89           C
ATOM   1039  CG2 ILE B 376     131.764  84.154 132.123  1.00 57.89           C
ATOM   1040  CD1 ILE B 376     130.268  81.834 131.071  1.00 57.89           C
ATOM   1041  N   LEU B 377     135.439  83.580 132.570  1.00 57.63           N
ATOM   1042  CA  LEU B 377     136.345  84.389 133.372  1.00 57.63           C
ATOM   1043  C   LEU B 377     137.412  85.037 132.506  1.00 57.63           C
ATOM   1044  O   LEU B 377     137.665  86.229 132.644  1.00 57.63           O
ATOM   1045  CB  LEU B 377     136.999  83.570 134.477  1.00 57.63           C
ATOM   1046  CG  LEU B 377     136.114  82.882 135.510  1.00 57.63           C
ATOM   1047  CD1 LEU B 377     136.937  82.318 136.649  1.00 57.63           C
ATOM   1048  CD2 LEU B 377     134.984  83.722 135.986  1.00 57.63           C
ATOM   1049  N   LEU B 378     137.994  84.288 131.569  1.00 56.07           N
ATOM   1050  CA  LEU B 378     138.991  84.862 130.671  1.00 56.07           C
ATOM   1051  C   LEU B 378     138.415  85.931 129.760  1.00 56.07           C
ATOM   1052  O   LEU B 378     139.119  86.878 129.410  1.00 56.07           O
ATOM   1053  CB  LEU B 378     139.630  83.778 129.820  1.00 56.07           C
ATOM   1054  CG  LEU B 378     140.634  82.866 130.486  1.00 56.07           C
ATOM   1055  CD1 LEU B 378     140.998  81.772 129.525  1.00 56.07           C
ATOM   1056  CD2 LEU B 378     141.842  83.682 130.839  1.00 56.07           C
ATOM   1057  N   MET B 379     137.152  85.799 129.365  1.00 54.55           N
ATOM   1058  CA  MET B 379     136.521  86.824 128.547  1.00 54.55           C
ATOM   1059  C   MET B 379     136.324  88.112 129.323  1.00 54.55           C
ATOM   1060  O   MET B 379     136.637  89.195 128.826  1.00 54.55           O
ATOM   1061  CB  MET B 379     135.192  86.321 128.015  1.00 54.55           C
ATOM   1062  CG  MET B 379     135.341  85.337 126.918  1.00 54.55           C
ATOM   1063  SD  MET B 379     133.785  84.591 126.504  1.00 54.55           S
ATOM   1064  CE  MET B 379     134.340  83.482 125.250  1.00 54.55           C
ATOM   1065  N   LYS B 380     135.809  88.018 130.543  1.00 54.16           N
ATOM   1066  CA  LYS B 380     135.538  89.229 131.297  1.00 54.16           C
ATOM   1067  C   LYS B 380     136.810  89.865 131.826  1.00 54.16           C
ATOM   1068  O   LYS B 380     136.873  91.087 131.954  1.00 54.16           O
ATOM   1069  CB  LYS B 380     134.565  88.935 132.426  1.00 54.16           C
ATOM   1070  CG  LYS B 380     133.191  88.618 131.923  1.00 54.16           C
ATOM   1071  CD  LYS B 380     132.229  88.453 133.047  1.00 54.16           C
ATOM   1072  CE  LYS B 380     131.924  89.785 133.675  1.00 54.16           C
ATOM   1073  NZ  LYS B 380     131.176  90.671 132.770  1.00 54.16           N
ATOM   1074  N   GLN B 381     137.843  89.072 132.093  1.00 55.59           N
ATOM   1075  CA  GLN B 381     139.130  89.627 132.485  1.00 55.59           C
ATOM   1076  C   GLN B 381     139.851  90.306 131.336  1.00 55.59           C
ATOM   1077  O   GLN B 381     140.822  91.018 131.574  1.00 55.59           O
ATOM   1078  CB  GLN B 381     140.009  88.532 133.072  1.00 55.59           C
ATOM   1079  CG  GLN B 381     139.540  88.059 134.419  1.00 55.59           C
ATOM   1080  CD  GLN B 381     140.188  86.770 134.827  1.00 55.59           C
ATOM   1081  OE1 GLN B 381     141.061  86.262 134.140  1.00 55.59           O
ATOM   1082  NE2 GLN B 381     139.709  86.191 135.910  1.00 55.59           N
ATOM   1083  N   ASN B 382     139.398  90.112 130.109  1.00 50.44           N
ATOM   1084  CA  ASN B 382     139.972  90.745 128.938  1.00 50.44           C
ATOM   1085  C   ASN B 382     138.991  91.706 128.289  1.00 50.44           C
ATOM   1086  O   ASN B 382     139.059  91.950 127.088  1.00 50.44           O
ATOM   1087  CB  ASN B 382     140.435  89.667 127.973  1.00 50.44           C
ATOM   1088  CG  ASN B 382     141.643  88.959 128.481  1.00 50.44           C
ATOM   1089  OD1 ASN B 382     142.663  89.574 128.726  1.00 50.44           O
ATOM   1090  ND2 ASN B 382     141.498  87.688 128.773  1.00 50.44           N
ATOM   1091  N   ASN B 383     138.054  92.211 129.091  1.00 48.78           N
ATOM   1092  CA  ASN B 383     137.137  93.298 128.753  1.00 48.78           C
ATOM   1093  C   ASN B 383     136.185  92.940 127.621  1.00 48.78           C
ATOM   1094  O   ASN B 383     135.775  93.803 126.857  1.00 48.78           O
ATOM   1095  CB  ASN B 383     137.889  94.590 128.429  1.00 48.78           C
ATOM   1096  CG  ASN B 383     138.621  95.136 129.611  1.00 48.78           C
ATOM   1097  OD1 ASN B 383     138.129  95.090 130.723  1.00 48.78           O
ATOM   1098  ND2 ASN B 383     139.800  95.663 129.381  1.00 48.78           N
ATOM   1099  N   PHE B 384     135.816  91.677 127.500  1.00 46.22           N
ATOM   1100  CA  PHE B 384     134.721  91.291 126.628  1.00 46.22           C
ATOM   1101  C   PHE B 384     133.419  91.331 127.411  1.00 46.22           C
ATOM   1102  O   PHE B 384     133.381  90.955 128.579  1.00 46.22           O
ATOM   1103  CB  PHE B 384     134.942  89.894 126.054  1.00 46.22           C
ATOM   1104  CG  PHE B 384     136.026  89.820 125.031  1.00 46.22           C
ATOM   1105  CD1 PHE B 384     135.765  90.108 123.710  1.00 46.22           C
ATOM   1106  CD2 PHE B 384     137.304  89.465 125.388  1.00 46.22           C
ATOM   1107  CE1 PHE B 384     136.757  90.038 122.773  1.00 46.22           C
ATOM   1108  CE2 PHE B 384     138.297  89.398 124.451  1.00 46.22           C
ATOM   1109  CZ  PHE B 384     138.021  89.684 123.145  1.00 46.22           C
ATOM   1110  N   ASN B 385     132.355  91.806 126.776  1.00 47.42           N
ATOM   1111  CA  ASN B 385     131.048  91.767 127.408  1.00 47.42           C
ATOM   1112  C   ASN B 385     130.004  91.008 126.606  1.00 47.42           C
ATOM   1113  O   ASN B 385     128.844  90.978 127.013  1.00 47.42           O
ATOM   1114  CB  ASN B 385     130.543  93.185 127.735  1.00 47.42           C
ATOM   1115  CG  ASN B 385     130.351  94.080 126.515  1.00 47.42           C
ATOM   1116  OD1 ASN B 385     130.492  93.677 125.376  1.00 47.42           O
ATOM   1117  ND2 ASN B 385     130.017  95.322 126.775  1.00 47.42           N
ATOM   1118  N   ALA B 386     130.368  90.406 125.484  1.00 45.11           N
ATOM   1119  CA  ALA B 386     129.376  89.771 124.641  1.00 45.11           C
ATOM   1120  C   ALA B 386     129.974  88.556 123.960  1.00 45.11           C
ATOM   1121  O   ALA B 386     131.170  88.504 123.695  1.00 45.11           O
ATOM   1122  CB  ALA B 386     128.820  90.736 123.603  1.00 45.11           C
ATOM   1123  N   VAL B 387     129.134  87.556 123.720  1.00 47.29           N
ATOM   1124  CA  VAL B 387     129.536  86.316 123.069  1.00 47.29           C
ATOM   1125  C   VAL B 387     128.512  86.006 121.993  1.00 47.29           C
ATOM   1126  O   VAL B 387     127.309  86.089 122.240  1.00 47.29           O
ATOM   1127  CB  VAL B 387     129.632  85.134 124.054  1.00 47.29           C
ATOM   1128  CG1 VAL B 387     130.118  83.898 123.358  1.00 47.29           C
ATOM   1129  CG2 VAL B 387     130.549  85.425 125.165  1.00 47.29           C
ATOM   1130  N   ARG B 388     128.978  85.657 120.809  1.00 52.62           N
ATOM   1131  CA  ARG B 388     128.109  85.158 119.760  1.00 52.62           C
ATOM   1132  C   ARG B 388     128.256  83.649 119.674  1.00 52.62           C
ATOM   1133  O   ARG B 388     129.369  83.133 119.573  1.00 52.62           O
ATOM   1134  CB  ARG B 388     128.431  85.835 118.434  1.00 52.62           C
ATOM   1135  CG  ARG B 388     127.598  85.391 117.275  1.00 52.62           C
ATOM   1136  CD  ARG B 388     127.765  86.348 116.130  1.00 52.62           C
ATOM   1137  NE  ARG B 388     127.091  85.888 114.930  1.00 52.62           N
ATOM   1138  CZ  ARG B 388     127.701  85.267 113.931  1.00 52.62           C
ATOM   1139  NH1 ARG B 388     129.004  85.065 113.978  1.00 52.62           N
ATOM   1140  NH2 ARG B 388     127.017  84.875 112.871  1.00 52.62           N
ATOM   1141  N   CYS B 389     127.134  82.948 119.755  1.00 59.58           N
ATOM   1142  CA  CYS B 389     127.096  81.488 119.742  1.00 59.58           C
ATOM   1143  C   CYS B 389     127.270  81.025 118.309  1.00 59.58           C
ATOM   1144  O   CYS B 389     126.304  80.768 117.603  1.00 59.58           O
ATOM   1145  CB  CYS B 389     125.776  80.984 120.305  1.00 59.58           C
ATOM   1146  SG  CYS B 389     125.422  81.499 121.965  1.00 59.58           S
ATOM   1147  N   SER B 390     128.510  80.899 117.872  1.00 58.63           N
ATOM   1148  CA  SER B 390     128.807  80.650 116.470  1.00 58.63           C
ATOM   1149  C   SER B 390     128.985  79.155 116.221  1.00 58.63           C
ATOM   1150  O   SER B 390     129.826  78.525 116.863  1.00 58.63           O
ATOM   1151  CB  SER B 390     130.064  81.410 116.069  1.00 58.63           C
ATOM   1152  OG  SER B 390     131.189  80.904 116.746  1.00 58.63           O
ATOM   1153  N   HIS B 391     128.181  78.576 115.322  1.00 59.25           N
ATOM   1154  CA  HIS B 391     126.970  79.181 114.782  1.00 59.25           C
ATOM   1155  C   HIS B 391     125.841  78.199 114.970  1.00 59.25           C
ATOM   1156  O   HIS B 391     125.377  77.607 114.005  1.00 59.25           O
ATOM   1157  CB  HIS B 391     127.114  79.468 113.294  1.00 59.25           C
ATOM   1158  CG  HIS B 391     128.303  80.293 112.942  1.00 59.25           C
ATOM   1159  ND1 HIS B 391     128.342  81.656 113.114  1.00 59.25           N
ATOM   1160  CD2 HIS B 391     129.506  79.942 112.436  1.00 59.25           C
ATOM   1161  CE1 HIS B 391     129.515  82.111 112.722  1.00 59.25           C
ATOM   1162  NE2 HIS B 391     130.240  81.091 112.308  1.00 59.25           N
ATOM   1163  N   TYR B 392     125.349  78.104 116.186  1.00 58.70           N
ATOM   1164  CA  TYR B 392     124.416  77.083 116.641  1.00 58.70           C
ATOM   1165  C   TYR B 392     124.042  77.379 118.083  1.00 58.70           C
ATOM   1166  O   TYR B 392     124.788  78.087 118.761  1.00 58.70           O
ATOM   1167  CB  TYR B 392     124.998  75.667 116.494  1.00 58.70           C
ATOM   1168  CG  TYR B 392     126.418  75.470 116.945  1.00 58.70           C
ATOM   1169  CD1 TYR B 392     127.437  75.388 116.016  1.00 58.70           C
ATOM   1170  CD2 TYR B 392     126.746  75.383 118.283  1.00 58.70           C
ATOM   1171  CE1 TYR B 392     128.729  75.216 116.401  1.00 58.70           C
ATOM   1172  CE2 TYR B 392     128.042  75.221 118.679  1.00 58.70           C
ATOM   1173  CZ  TYR B 392     129.029  75.135 117.730  1.00 58.70           C
ATOM   1174  OH  TYR B 392     130.333  74.967 118.111  1.00 58.70           O
ATOM   1175  N   PRO B 393     122.906  76.890 118.580  1.00 58.08           N
ATOM   1176  CA  PRO B 393     122.600  77.071 119.999  1.00 58.08           C
ATOM   1177  C   PRO B 393     123.567  76.291 120.863  1.00 58.08           C
ATOM   1178  O   PRO B 393     123.940  75.165 120.540  1.00 58.08           O
ATOM   1179  CB  PRO B 393     121.180  76.519 120.123  1.00 58.08           C
ATOM   1180  CG  PRO B 393     120.641  76.580 118.778  1.00 58.08           C
ATOM   1181  CD  PRO B 393     121.763  76.300 117.870  1.00 58.08           C
ATOM   1182  N   ASN B 394     123.996  76.903 121.955  1.00 61.51           N
ATOM   1183  CA  ASN B 394     124.950  76.211 122.793  1.00 61.51           C
ATOM   1184  C   ASN B 394     124.266  75.248 123.746  1.00 61.51           C
ATOM   1185  O   ASN B 394     123.048  75.071 123.749  1.00 61.51           O
ATOM   1186  CB  ASN B 394     125.814  77.172 123.598  1.00 61.51           C
ATOM   1187  CG  ASN B 394     126.853  77.843 122.767  1.00 61.51           C
ATOM   1188  OD1 ASN B 394     127.108  79.018 122.916  1.00 61.51           O
ATOM   1189  ND2 ASN B 394     127.404  77.116 121.820  1.00 61.51           N
ATOM   1190  N   HIS B 395     125.109  74.594 124.521  1.00 65.23           N
ATOM   1191  CA  HIS B 395     124.714  73.825 125.683  1.00 65.23           C
ATOM   1192  C   HIS B 395     123.899  74.705 126.626  1.00 65.23           C
ATOM   1193  O   HIS B 395     124.210  75.889 126.776  1.00 65.23           O
ATOM   1194  CB  HIS B 395     125.986  73.327 126.365  1.00 65.23           C
ATOM   1195  CG  HIS B 395     125.762  72.366 127.480  1.00 65.23           C
ATOM   1196  ND1 HIS B 395     125.407  72.769 128.746  1.00 65.23           N
ATOM   1197  CD2 HIS B 395     125.911  71.025 127.539  1.00 65.23           C
ATOM   1198  CE1 HIS B 395     125.303  71.712 129.528  1.00 65.23           C
ATOM   1199  NE2 HIS B 395     125.606  70.640 128.821  1.00 65.23           N
ATOM   1200  N   PRO B 396     122.847  74.175 127.255  1.00 63.80           N
ATOM   1201  CA  PRO B 396     121.936  75.034 128.026  1.00 63.80           C
ATOM   1202  C   PRO B 396     122.553  75.670 129.251  1.00 63.80           C
ATOM   1203  O   PRO B 396     122.061  76.710 129.694  1.00 63.80           O
ATOM   1204  CB  PRO B 396     120.811  74.073 128.423  1.00 63.80           C
ATOM   1205  CG  PRO B 396     120.875  73.002 127.436  1.00 63.80           C
ATOM   1206  CD  PRO B 396     122.311  72.816 127.112  1.00 63.80           C
ATOM   1207  N   LEU B 397     123.620  75.099 129.799  1.00 62.56           N
ATOM   1208  CA  LEU B 397     124.280  75.689 130.952  1.00 62.56           C
ATOM   1209  C   LEU B 397     125.025  76.966 130.598  1.00 62.56           C
ATOM   1210  O   LEU B 397     125.244  77.804 131.476  1.00 62.56           O
ATOM   1211  CB  LEU B 397     125.224  74.663 131.561  1.00 62.56           C
ATOM   1212  CG  LEU B 397     125.957  74.983 132.851  1.00 62.56           C
ATOM   1213  CD1 LEU B 397     124.959  75.271 133.937  1.00 62.56           C
ATOM   1214  CD2 LEU B 397     126.799  73.808 133.208  1.00 62.56           C
ATOM   1215  N   TRP B 398     125.390  77.137 129.328  1.00 57.08           N
ATOM   1216  CA  TRP B 398     126.111  78.323 128.889  1.00 57.08           C
ATOM   1217  C   TRP B 398     125.297  79.589 129.088  1.00 57.08           C
ATOM   1218  O   TRP B 398     125.834  80.617 129.503  1.00 57.08           O
ATOM   1219  CB  TRP B 398     126.496  78.166 127.428  1.00 57.08           C
ATOM   1220  CG  TRP B 398     127.142  79.344 126.862  1.00 57.08           C
ATOM   1221  CD1 TRP B 398     126.601  80.224 125.992  1.00 57.08           C
ATOM   1222  CD2 TRP B 398     128.459  79.800 127.131  1.00 57.08           C
ATOM   1223  NE1 TRP B 398     127.502  81.198 125.686  1.00 57.08           N
ATOM   1224  CE2 TRP B 398     128.655  80.960 126.379  1.00 57.08           C
ATOM   1225  CE3 TRP B 398     129.496  79.334 127.933  1.00 57.08           C
ATOM   1226  CZ2 TRP B 398     129.843  81.664 126.404  1.00 57.08           C
ATOM   1227  CZ3 TRP B 398     130.668  80.025 127.951  1.00 57.08           C
ATOM   1228  CH2 TRP B 398     130.836  81.180 127.196  1.00 57.08           C
ATOM   1229  N   TYR B 399     123.997  79.525 128.820  1.00 57.90           N
ATOM   1230  CA  TYR B 399     123.150  80.697 128.968  1.00 57.90           C
ATOM   1231  C   TYR B 399     122.935  81.038 130.427  1.00 57.90           C
ATOM   1232  O   TYR B 399     122.832  82.213 130.771  1.00 57.90           O
ATOM   1233  CB  TYR B 399     121.815  80.461 128.280  1.00 57.90           C
ATOM   1234  CG  TYR B 399     121.976  80.126 126.836  1.00 57.90           C
ATOM   1235  CD1 TYR B 399     122.208  81.111 125.902  1.00 57.90           C
ATOM   1236  CD2 TYR B 399     121.922  78.814 126.407  1.00 57.90           C
ATOM   1237  CE1 TYR B 399     122.371  80.802 124.583  1.00 57.90           C
ATOM   1238  CE2 TYR B 399     122.087  78.499 125.095  1.00 57.90           C
ATOM   1239  CZ  TYR B 399     122.308  79.494 124.187  1.00 57.90           C
ATOM   1240  OH  TYR B 399     122.468  79.178 122.870  1.00 57.90           O
ATOM   1241  N   THR B 400     122.881  80.023 131.287  1.00 59.95           N
ATOM   1242  CA  THR B 400     122.762  80.243 132.721  1.00 59.95           C
ATOM   1243  C   THR B 400     123.991  80.945 133.271  1.00 59.95           C
ATOM   1244  O   THR B 400     123.881  81.876 134.071  1.00 59.95           O
ATOM   1245  CB  THR B 400     122.550  78.905 133.421  1.00 59.95           C
ATOM   1246  OG1 THR B 400     121.347  78.305 132.938  1.00 59.95           O
ATOM   1247  CG2 THR B 400     122.449  79.079 134.910  1.00 59.95           C
ATOM   1248  N   LEU B 401     125.171  80.532 132.826  1.00 58.59           N
ATOM   1249  CA  LEU B 401     126.395  81.157 133.295  1.00 58.59           C
ATOM   1250  C   LEU B 401     126.563  82.563 132.740  1.00 58.59           C
ATOM   1251  O   LEU B 401     127.137  83.421 133.408  1.00 58.59           O
ATOM   1252  CB  LEU B 401     127.583  80.290 132.920  1.00 58.59           C
ATOM   1253  CG  LEU B 401     127.683  78.912 133.550  1.00 58.59           C
ATOM   1254  CD1 LEU B 401     128.828  78.175 132.932  1.00 58.59           C
ATOM   1255  CD2 LEU B 401     127.873  79.040 135.026  1.00 58.59           C
ATOM   1256  N   CYS B 402     126.063  82.824 131.536  1.00 56.33           N
ATOM   1257  CA  CYS B 402     126.103  84.183 131.017  1.00 56.33           C
ATOM   1258  C   CYS B 402     125.085  85.079 131.707  1.00 56.33           C
ATOM   1259  O   CYS B 402     125.301  86.287 131.793  1.00 56.33           O
ATOM   1260  CB  CYS B 402     125.883  84.181 129.508  1.00 56.33           C
ATOM   1261  SG  CYS B 402     127.211  83.437 128.551  1.00 56.33           S
ATOM   1262  N   ASP B 403     123.973  84.514 132.188  1.00 58.63           N
ATOM   1263  CA  ASP B 403     123.069  85.253 133.067  1.00 58.63           C
ATOM   1264  C   ASP B 403     123.772  85.653 134.350  1.00 58.63           C
ATOM   1265  O   ASP B 403     123.607  86.770 134.842  1.00 58.63           O
ATOM   1266  CB  ASP B 403     121.850  84.408 133.439  1.00 58.63           C
ATOM   1267  CG  ASP B 403     120.957  84.097 132.274  1.00 58.63           C
ATOM   1268  OD1 ASP B 403     120.951  84.867 131.314  1.00 58.63           O
ATOM   1269  OD2 ASP B 403     120.247  83.073 132.316  1.00 58.63           O
ATOM   1270  N   ARG B 404     124.565  84.744 134.896  1.00 62.30           N
ATOM   1271  CA  ARG B 404     125.099  84.872 136.239  1.00 62.30           C
ATOM   1272  C   ARG B 404     126.290  85.815 136.284  1.00 62.30           C
ATOM   1273  O   ARG B 404     126.360  86.692 137.144  1.00 62.30           O
ATOM   1274  CB  ARG B 404     125.485  83.488 136.736  1.00 62.30           C
ATOM   1275  CG  ARG B 404     125.951  83.393 138.146  1.00 62.30           C
ATOM   1276  CD  ARG B 404     126.212  81.936 138.432  1.00 62.30           C
ATOM   1277  NE  ARG B 404     124.978  81.167 138.313  1.00 62.30           N
ATOM   1278  CZ  ARG B 404     124.929  79.844 138.222  1.00 62.30           C
ATOM   1279  NH1 ARG B 404     126.047  79.137 138.223  1.00 62.30           N
ATOM   1280  NH2 ARG B 404     123.760  79.232 138.121  1.00 62.30           N
ATOM   1281  N   TYR B 405     127.236  85.645 135.372  1.00 60.12           N
ATOM   1282  CA  TYR B 405     128.431  86.472 135.358  1.00 60.12           C
ATOM   1283  C   TYR B 405     128.243  87.762 134.591  1.00 60.12           C
ATOM   1284  O   TYR B 405     128.887  88.762 134.907  1.00 60.12           O
ATOM   1285  CB  TYR B 405     129.595  85.697 134.757  1.00 60.12           C
ATOM   1286  CG  TYR B 405     130.064  84.579 135.630  1.00 60.12           C
ATOM   1287  CD1 TYR B 405     130.903  84.823 136.698  1.00 60.12           C
ATOM   1288  CD2 TYR B 405     129.662  83.281 135.395  1.00 60.12           C
ATOM   1289  CE1 TYR B 405     131.333  83.806 137.501  1.00 60.12           C
ATOM   1290  CE2 TYR B 405     130.084  82.258 136.192  1.00 60.12           C
ATOM   1291  CZ  TYR B 405     130.921  82.526 137.242  1.00 60.12           C
ATOM   1292  OH  TYR B 405     131.347  81.502 138.043  1.00 60.12           O
ATOM   1293  N   GLY B 406     127.393  87.752 133.585  1.00 55.30           N
ATOM   1294  CA  GLY B 406     127.064  88.938 132.837  1.00 55.30           C
ATOM   1295  C   GLY B 406     127.811  88.989 131.530  1.00 55.30           C
ATOM   1296  O   GLY B 406     128.922  89.505 131.452  1.00 55.30           O
ATOM   1297  N   LEU B 407     127.169  88.495 130.485  1.00 49.80           N
ATOM   1298  CA  LEU B 407     127.651  88.593 129.123  1.00 49.80           C
ATOM   1299  C   LEU B 407     126.426  88.661 128.243  1.00 49.80           C
ATOM   1300  O   LEU B 407     125.460  87.941 128.478  1.00 49.80           O
ATOM   1301  CB  LEU B 407     128.516  87.401 128.711  1.00 49.80           C
ATOM   1302  CG  LEU B 407     129.911  87.215 129.287  1.00 49.80           C
ATOM   1303  CD1 LEU B 407     130.479  85.904 128.845  1.00 49.80           C
ATOM   1304  CD2 LEU B 407     130.805  88.330 128.844  1.00 49.80           C
ATOM   1305  N   TYR B 408     126.453  89.527 127.250  1.00 48.97           N
ATOM   1306  CA  TYR B 408     125.383  89.538 126.277  1.00 48.97           C
ATOM   1307  C   TYR B 408     125.581  88.370 125.332  1.00 48.97           C
ATOM   1308  O   TYR B 408     126.703  88.017 124.991  1.00 48.97           O
ATOM   1309  CB  TYR B 408     125.362  90.845 125.509  1.00 48.97           C
ATOM   1310  CG  TYR B 408     125.334  92.028 126.414  1.00 48.97           C
ATOM   1311  CD1 TYR B 408     124.271  92.243 127.265  1.00 48.97           C
ATOM   1312  CD2 TYR B 408     126.353  92.956 126.387  1.00 48.97           C
ATOM   1313  CE1 TYR B 408     124.250  93.319 128.095  1.00 48.97           C
ATOM   1314  CE2 TYR B 408     126.334  94.041 127.201  1.00 48.97           C
ATOM   1315  CZ  TYR B 408     125.279  94.222 128.052  1.00 48.97           C
ATOM   1316  OH  TYR B 408     125.272  95.311 128.871  1.00 48.97           O
ATOM   1317  N   VAL B 409     124.492  87.734 124.942  1.00 48.18           N
ATOM   1318  CA  VAL B 409     124.561  86.543 124.115  1.00 48.18           C
ATOM   1319  C   VAL B 409     123.766  86.797 122.849  1.00 48.18           C
ATOM   1320  O   VAL B 409     122.633  87.277 122.910  1.00 48.18           O
ATOM   1321  CB  VAL B 409     124.045  85.307 124.870  1.00 48.18           C
ATOM   1322  CG1 VAL B 409     123.958  84.129 123.968  1.00 48.18           C
ATOM   1323  CG2 VAL B 409     124.959  84.982 126.003  1.00 48.18           C
ATOM   1324  N   VAL B 410     124.376  86.522 121.708  1.00 50.40           N
ATOM   1325  CA  VAL B 410     123.665  86.410 120.446  1.00 50.40           C
ATOM   1326  C   VAL B 410     123.421  84.932 120.211  1.00 50.40           C
ATOM   1327  O   VAL B 410     124.361  84.165 120.005  1.00 50.40           O
ATOM   1328  CB  VAL B 410     124.448  87.038 119.293  1.00 50.40           C
ATOM   1329  CG1 VAL B 410     123.737  86.792 117.990  1.00 50.40           C
ATOM   1330  CG2 VAL B 410     124.601  88.497 119.530  1.00 50.40           C
ATOM   1331  N   ASP B 411     122.165  84.524 120.256  1.00 55.30           N
ATOM   1332  CA  ASP B 411     121.807  83.129 120.090  1.00 55.30           C
ATOM   1333  C   ASP B 411     121.486  82.882 118.625  1.00 55.30           C
ATOM   1334  O   ASP B 411     120.688  83.605 118.031  1.00 55.30           O
ATOM   1335  CB  ASP B 411     120.616  82.785 120.972  1.00 55.30           C
ATOM   1336  CG  ASP B 411     120.480  81.317 121.214  1.00 55.30           C
ATOM   1337  OD1 ASP B 411     121.314  80.538 120.732  1.00 55.30           O
ATOM   1338  OD2 ASP B 411     119.527  80.937 121.896  1.00 55.30           O
ATOM   1339  N   GLU B 412     122.105  81.868 118.045  1.00 58.87           N
ATOM   1340  CA  GLU B 412     122.137  81.716 116.601  1.00 58.87           C
ATOM   1341  C   GLU B 412     121.571  80.368 116.200  1.00 58.87           C
ATOM   1342  O   GLU B 412     121.916  79.353 116.795  1.00 58.87           O
ATOM   1343  CB  GLU B 412     123.562  81.883 116.098  1.00 58.87           C
ATOM   1344  CG  GLU B 412     123.712  81.855 114.614  1.00 58.87           C
ATOM   1345  CD  GLU B 412     125.063  82.369 114.194  1.00 58.87           C
ATOM   1346  OE1 GLU B 412     125.855  82.740 115.082  1.00 58.87           O
ATOM   1347  OE2 GLU B 412     125.334  82.418 112.984  1.00 58.87           O
ATOM   1348  N   ALA B 413     120.688  80.369 115.211  1.00 56.57           N
ATOM   1349  CA  ALA B 413     120.084  79.135 114.742  1.00 56.57           C
ATOM   1350  C   ALA B 413     121.102  78.285 113.997  1.00 56.57           C
ATOM   1351  O   ALA B 413     122.042  78.791 113.387  1.00 56.57           O
ATOM   1352  CB  ALA B 413     118.895  79.436 113.839  1.00 56.57           C
ATOM   1353  N   ASN B 414     120.896  76.973 114.044  1.00 58.67           N
ATOM   1354  CA  ASN B 414     121.818  76.000 113.463  1.00 58.67           C
ATOM   1355  C   ASN B 414     121.541  75.852 111.966  1.00 58.67           C
ATOM   1356  O   ASN B 414     121.107  74.812 111.477  1.00 58.67           O
ATOM   1357  CB  ASN B 414     121.667  74.669 114.180  1.00 58.67           C
ATOM   1358  CG  ASN B 414     122.756  73.690 113.840  1.00 58.67           C
ATOM   1359  OD1 ASN B 414     123.752  74.039 113.227  1.00 58.67           O
ATOM   1360  ND2 ASN B 414     122.529  72.435 114.169  1.00 58.67           N
ATOM   1361  N   ILE B 415     121.781  76.928 111.226  1.00 56.53           N
ATOM   1362  CA  ILE B 415     121.552  76.949 109.787  1.00 56.53           C
ATOM   1363  C   ILE B 415     122.780  77.552 109.130  1.00 56.53           C
ATOM   1364  O   ILE B 415     123.060  78.739 109.310  1.00 56.53           O
ATOM   1365  CB  ILE B 415     120.303  77.745 109.391  1.00 56.53           C
ATOM   1366  CG1 ILE B 415     119.040  77.170 110.013  1.00 56.53           C
ATOM   1367  CG2 ILE B 415     120.151  77.733 107.897  1.00 56.53           C
ATOM   1368  CD1 ILE B 415     117.865  78.062 109.890  1.00 56.53           C
ATOM   1369  N   GLU B 416     123.507  76.748 108.368  1.00 62.74           N
ATOM   1370  CA  GLU B 416     124.562  77.274 107.513  1.00 62.74           C
ATOM   1371  C   GLU B 416     124.692  76.407 106.277  1.00 62.74           C
ATOM   1372  O   GLU B 416     124.947  75.210 106.384  1.00 62.74           O
ATOM   1373  CB  GLU B 416     125.895  77.372 108.241  1.00 62.74           C
ATOM   1374  CG  GLU B 416     126.994  77.801 107.302  1.00 62.74           C
ATOM   1375  CD  GLU B 416     128.227  78.298 107.995  1.00 62.74           C
ATOM   1376  OE1 GLU B 416     128.212  78.463 109.224  1.00 62.74           O
ATOM   1377  OE2 GLU B 416     129.234  78.497 107.306  1.00 62.74           O
ATOM   1378  N   THR B 417     124.589  77.019 105.114  1.00 63.74           N
ATOM   1379  CA  THR B 417     124.703  76.280 103.884  1.00 63.74           C
ATOM   1380  C   THR B 417     125.706  77.004 103.034  1.00 63.74           C
ATOM   1381  O   THR B 417     125.439  77.343 101.902  1.00 63.74           O
ATOM   1382  CB  THR B 417     123.367  76.275 103.141  1.00 63.74           C
ATOM   1383  OG1 THR B 417     123.101  77.585 102.648  1.00 63.74           O
ATOM   1384  CG2 THR B 417     122.254  75.873 104.060  1.00 63.74           C
ATOM   1385  N   HIS B 418     126.894  77.174 103.583  1.00 66.35           N
ATOM   1386  CA  HIS B 418     127.976  77.886 102.934  1.00 66.35           C
ATOM   1387  C   HIS B 418     128.437  77.232 101.647  1.00 66.35           C
ATOM   1388  O   HIS B 418     128.747  77.904 100.681  1.00 66.35           O
ATOM   1389  CB  HIS B 418     129.153  77.994 103.892  1.00 66.35           C
ATOM   1390  CG  HIS B 418     130.090  79.110 103.572  1.00 66.35           C
ATOM   1391  ND1 HIS B 418     130.874  79.716 104.525  1.00 66.35           N
ATOM   1392  CD2 HIS B 418     130.361  79.738 102.407  1.00 66.35           C
ATOM   1393  CE1 HIS B 418     131.596  80.663 103.959  1.00 66.35           C
ATOM   1394  NE2 HIS B 418     131.301  80.699 102.675  1.00 66.35           N
ATOM   1395  N   GLY B 419     128.476  75.913 101.646  1.00 68.06           N
ATOM   1396  CA  GLY B 419     128.928  75.148 100.508  1.00 68.06           C
ATOM   1397  C   GLY B 419     128.052  75.098  99.276  1.00 68.06           C
ATOM   1398  O   GLY B 419     128.497  74.624  98.246  1.00 68.06           O
ATOM   1399  N   MET B 420     126.809  75.544  99.375  1.00 69.13           N
ATOM   1400  CA  MET B 420     125.894  75.455  98.254  1.00 69.13           C
ATOM   1401  C   MET B 420     126.278  76.464  97.184  1.00 69.13           C
ATOM   1402  O   MET B 420     126.834  77.522  97.474  1.00 69.13           O
ATOM   1403  CB  MET B 420     124.461  75.711  98.712  1.00 69.13           C
ATOM   1404  CG  MET B 420     123.950  74.727  99.730  1.00 69.13           C
ATOM   1405  SD  MET B 420     124.019  73.028  99.158  1.00 69.13           S
ATOM   1406  CE  MET B 420     122.816  73.086  97.859  1.00 69.13           C
ATOM   1407  N   VAL B 421     125.994  76.122  95.934  1.00 69.69           N
ATOM   1408  CA  VAL B 421     126.206  77.051  94.828  1.00 69.69           C
ATOM   1409  C   VAL B 421     124.873  77.280  94.126  1.00 69.69           C
ATOM   1410  O   VAL B 421     124.330  76.346  93.525  1.00 69.69           O
ATOM   1411  CB  VAL B 421     127.268  76.547  93.845  1.00 69.69           C
ATOM   1412  CG1 VAL B 421     127.380  77.507  92.692  1.00 69.69           C
ATOM   1413  CG2 VAL B 421     128.600  76.411  94.535  1.00 69.69           C
ATOM   1414  N   PRO B 422     124.278  78.477  94.207  1.00 69.41           N
ATOM   1415  CA  PRO B 422     124.676  79.633  95.006  1.00 69.41           C
ATOM   1416  C   PRO B 422     124.345  79.404  96.463  1.00 69.41           C
ATOM   1417  O   PRO B 422     123.731  78.392  96.766  1.00 69.41           O
ATOM   1418  CB  PRO B 422     123.837  80.759  94.426  1.00 69.41           C
ATOM   1419  CG  PRO B 422     122.643  80.091  93.936  1.00 69.41           C
ATOM   1420  CD  PRO B 422     123.069  78.765  93.424  1.00 69.41           C
ATOM   1421  N   MET B 423     124.746  80.320  97.338  1.00 69.58           N
ATOM   1422  CA  MET B 423     124.693  80.057  98.767  1.00 69.58           C
ATOM   1423  C   MET B 423     123.262  79.956  99.283  1.00 69.58           C
ATOM   1424  O   MET B 423     123.037  79.326 100.316  1.00 69.58           O
ATOM   1425  CB  MET B 423     125.473  81.144  99.505  1.00 69.58           C
ATOM   1426  CG  MET B 423     125.866  80.840 100.919  1.00 69.58           C
ATOM   1427  SD  MET B 423     126.622  82.278 101.696  1.00 69.58           S
ATOM   1428  CE  MET B 423     128.138  82.423 100.790  1.00 69.58           C
ATOM   1429  N   ASN B 424     122.283  80.500  98.562  1.00 67.50           N
ATOM   1430  CA  ASN B 424     120.892  80.420  98.980  1.00 67.50           C
ATOM   1431  C   ASN B 424     120.094  79.367  98.221  1.00 67.50           C
ATOM   1432  O   ASN B 424     118.882  79.525  98.080  1.00 67.50           O
ATOM   1433  CB  ASN B 424     120.199  81.778  98.859  1.00 67.50           C
ATOM   1434  CG  ASN B 424     120.113  82.297  97.431  1.00 67.50           C
ATOM   1435  OD1 ASN B 424     120.638  81.716  96.492  1.00 67.50           O
ATOM   1436  ND2 ASN B 424     119.387  83.385  97.266  1.00 67.50           N
ATOM   1437  N   ARG B 425     120.743  78.321  97.707  1.00 67.71           N
ATOM   1438  CA  ARG B 425     120.024  77.320  96.926  1.00 67.71           C
ATOM   1439  C   ARG B 425     118.994  76.581  97.771  1.00 67.71           C
ATOM   1440  O   ARG B 425     117.877  76.325  97.315  1.00 67.71           O
ATOM   1441  CB  ARG B 425     121.000  76.337  96.289  1.00 67.71           C
ATOM   1442  CG  ARG B 425     120.310  75.281  95.463  1.00 67.71           C
ATOM   1443  CD  ARG B 425     121.260  74.385  94.733  1.00 67.71           C
ATOM   1444  NE  ARG B 425     121.929  75.073  93.642  1.00 67.71           N
ATOM   1445  CZ  ARG B 425     121.412  75.216  92.430  1.00 67.71           C
ATOM   1446  NH1 ARG B 425     120.219  74.722  92.152  1.00 67.71           N
ATOM   1447  NH2 ARG B 425     122.089  75.854  91.494  1.00 67.71           N
ATOM   1448  N   LEU B 426     119.323  76.291  99.020  1.00 63.61           N
ATOM   1449  CA  LEU B 426     118.355  75.660  99.898  1.00 63.61           C
ATOM   1450  C   LEU B 426     117.464  76.666 100.598  1.00 63.61           C
ATOM   1451  O   LEU B 426     116.287  76.384 100.822  1.00 63.61           O
ATOM   1452  CB  LEU B 426     119.064  74.807 100.946  1.00 63.61           C
ATOM   1453  CG  LEU B 426     119.950  73.707 100.383  1.00 63.61           C
ATOM   1454  CD1 LEU B 426     120.584  72.938 101.504  1.00 63.61           C
ATOM   1455  CD2 LEU B 426     119.187  72.799  99.459  1.00 63.61           C
ATOM   1456  N   THR B 427     117.984  77.831 100.947  1.00 62.72           N
ATOM   1457  CA  THR B 427     117.206  78.773 101.731  1.00 62.72           C
ATOM   1458  C   THR B 427     116.270  79.621 100.892  1.00 62.72           C
ATOM   1459  O   THR B 427     115.510  80.403 101.455  1.00 62.72           O
ATOM   1460  CB  THR B 427     118.122  79.684 102.532  1.00 62.72           C
ATOM   1461  OG1 THR B 427     118.886  80.496 101.641  1.00 62.72           O
ATOM   1462  CG2 THR B 427     119.060  78.868 103.380  1.00 62.72           C
ATOM   1463  N   ASP B 428     116.305  79.506  99.574  1.00 67.94           N
ATOM   1464  CA  ASP B 428     115.299  80.138  98.742  1.00 67.94           C
ATOM   1465  C   ASP B 428     114.318  79.109  98.199  1.00 67.94           C
ATOM   1466  O   ASP B 428     113.469  79.440  97.373  1.00 67.94           O
ATOM   1467  CB  ASP B 428     115.965  80.911  97.608  1.00 67.94           C
ATOM   1468  CG  ASP B 428     115.128  82.067  97.120  1.00 67.94           C
ATOM   1469  OD1 ASP B 428     114.047  82.310  97.693  1.00 67.94           O
ATOM   1470  OD2 ASP B 428     115.551  82.743  96.163  1.00 67.94           O
ATOM   1471  N   ASP B 429     114.423  77.867  98.656  1.00 66.36           N
ATOM   1472  CA  ASP B 429     113.564  76.777  98.238  1.00 66.36           C
ATOM   1473  C   ASP B 429     112.525  76.540  99.318  1.00 66.36           C
ATOM   1474  O   ASP B 429     112.902  76.283 100.468  1.00 66.36           O
ATOM   1475  CB  ASP B 429     114.407  75.526  98.022  1.00 66.36           C
ATOM   1476  CG  ASP B 429     113.658  74.392  97.344  1.00 66.36           C
ATOM   1477  OD1 ASP B 429     112.460  74.506  97.036  1.00 66.36           O
ATOM   1478  OD2 ASP B 429     114.297  73.352  97.108  1.00 66.36           O
ATOM   1479  N   PRO B 430     111.227  76.611  99.017  1.00 63.72           N
ATOM   1480  CA  PRO B 430     110.226  76.380 100.066  1.00 63.72           C
ATOM   1481  C   PRO B 430     110.098  74.937 100.494  1.00 63.72           C
ATOM   1482  O   PRO B 430     109.466  74.677 101.518  1.00 63.72           O
ATOM   1483  CB  PRO B 430     108.932  76.884  99.428  1.00 63.72           C
ATOM   1484  CG  PRO B 430     109.162  76.766  98.016  1.00 63.72           C
ATOM   1485  CD  PRO B 430     110.596  77.053  97.768  1.00 63.72           C
ATOM   1486  N   ARG B 431     110.682  73.992  99.762  1.00 67.16           N
ATOM   1487  CA  ARG B 431     110.735  72.616 100.228  1.00 67.16           C
ATOM   1488  C   ARG B 431     111.654  72.449 101.428  1.00 67.16           C
ATOM   1489  O   ARG B 431     111.536  71.459 102.150  1.00 67.16           O
ATOM   1490  CB  ARG B 431     111.177  71.705  99.090  1.00 67.16           C
ATOM   1491  CG  ARG B 431     110.139  71.588  97.991  1.00 67.16           C
ATOM   1492  CD  ARG B 431     110.647  70.823  96.789  1.00 67.16           C
ATOM   1493  NE  ARG B 431     110.958  69.429  97.086  1.00 67.16           N
ATOM   1494  CZ  ARG B 431     110.074  68.439  97.052  1.00 67.16           C
ATOM   1495  NH1 ARG B 431     108.809  68.679  96.746  1.00 67.16           N
ATOM   1496  NH2 ARG B 431     110.455  67.205  97.334  1.00 67.16           N
ATOM   1497  N   TRP B 432     112.556  73.391 101.660  1.00 61.71           N
ATOM   1498  CA  TRP B 432     113.431  73.385 102.816  1.00 61.71           C
ATOM   1499  C   TRP B 432     112.962  74.318 103.912  1.00 61.71           C
ATOM   1500  O   TRP B 432     113.598  74.379 104.961  1.00 61.71           O
ATOM   1501  CB  TRP B 432     114.842  73.754 102.385  1.00 61.71           C
ATOM   1502  CG  TRP B 432     115.494  72.665 101.654  1.00 61.71           C
ATOM   1503  CD1 TRP B 432     115.416  72.415 100.329  1.00 61.71           C
ATOM   1504  CD2 TRP B 432     116.366  71.684 102.200  1.00 61.71           C
ATOM   1505  NE1 TRP B 432     116.163  71.319 100.013  1.00 61.71           N
ATOM   1506  CE2 TRP B 432     116.763  70.854 101.149  1.00 61.71           C
ATOM   1507  CE3 TRP B 432     116.846  71.424 103.481  1.00 61.71           C
ATOM   1508  CZ2 TRP B 432     117.622  69.786 101.334  1.00 61.71           C
ATOM   1509  CZ3 TRP B 432     117.690  70.366 103.664  1.00 61.71           C
ATOM   1510  CH2 TRP B 432     118.070  69.557 102.599  1.00 61.71           C
ATOM   1511  N   LEU B 433     111.883  75.056 103.681  1.00 59.19           N
ATOM   1512  CA  LEU B 433     111.309  75.888 104.733  1.00 59.19           C
ATOM   1513  C   LEU B 433     110.832  75.120 105.968  1.00 59.19           C
ATOM   1514  O   LEU B 433     111.028  75.648 107.073  1.00 59.19           O
ATOM   1515  CB  LEU B 433     110.188  76.755 104.144  1.00 59.19           C
ATOM   1516  CG  LEU B 433     109.443  77.703 105.079  1.00 59.19           C
ATOM   1517  CD1 LEU B 433     110.389  78.689 105.707  1.00 59.19           C
ATOM   1518  CD2 LEU B 433     108.363  78.426 104.323  1.00 59.19           C
ATOM   1519  N   PRO B 434     110.225  73.919 105.888  1.00 60.29           N
ATOM   1520  CA  PRO B 434     109.968  73.183 107.139  1.00 60.29           C
ATOM   1521  C   PRO B 434     111.210  72.785 107.911  1.00 60.29           C
ATOM   1522  O   PRO B 434     111.187  72.814 109.144  1.00 60.29           O
ATOM   1523  CB  PRO B 434     109.199  71.952 106.658  1.00 60.29           C
ATOM   1524  CG  PRO B 434     108.532  72.389 105.479  1.00 60.29           C
ATOM   1525  CD  PRO B 434     109.458  73.299 104.788  1.00 60.29           C
ATOM   1526  N   ALA B 435     112.291  72.412 107.231  1.00 60.30           N
ATOM   1527  CA  ALA B 435     113.501  72.036 107.949  1.00 60.30           C
ATOM   1528  C   ALA B 435     114.173  73.251 108.566  1.00 60.30           C
ATOM   1529  O   ALA B 435     114.701  73.174 109.677  1.00 60.30           O
ATOM   1530  CB  ALA B 435     114.463  71.309 107.018  1.00 60.30           C
ATOM   1531  N   MET B 436     114.156  74.380 107.865  1.00 60.06           N
ATOM   1532  CA  MET B 436     114.750  75.590 108.411  1.00 60.06           C
ATOM   1533  C   MET B 436     113.926  76.160 109.547  1.00 60.06           C
ATOM   1534  O   MET B 436     114.490  76.733 110.480  1.00 60.06           O
ATOM   1535  CB  MET B 436     114.913  76.638 107.323  1.00 60.06           C
ATOM   1536  CG  MET B 436     115.997  76.347 106.339  1.00 60.06           C
ATOM   1537  SD  MET B 436     116.000  77.587 105.057  1.00 60.06           S
ATOM   1538  CE  MET B 436     116.418  79.033 106.015  1.00 60.06           C
ATOM   1539  N   SER B 437     112.603  76.018 109.491  1.00 59.55           N
ATOM   1540  CA  SER B 437     111.769  76.620 110.519  1.00 59.55           C
ATOM   1541  C   SER B 437     111.916  75.909 111.850  1.00 59.55           C
ATOM   1542  O   SER B 437     111.921  76.565 112.888  1.00 59.55           O
ATOM   1543  CB  SER B 437     110.307  76.642 110.090  1.00 59.55           C
ATOM   1544  OG  SER B 437     109.775  75.342 110.012  1.00 59.55           O
ATOM   1545  N   GLU B 438     112.099  74.603 111.812  1.00 63.79           N
ATOM   1546  CA  GLU B 438     112.271  73.835 113.023  1.00 63.79           C
ATOM   1547  C   GLU B 438     113.520  74.287 113.747  1.00 63.79           C
ATOM   1548  O   GLU B 438     113.536  74.376 114.956  1.00 63.79           O
ATOM   1549  CB  GLU B 438     112.392  72.358 112.690  1.00 63.79           C
ATOM   1550  CG  GLU B 438     111.156  71.777 112.044  1.00 63.79           C
ATOM   1551  CD  GLU B 438     110.185  71.217 113.057  1.00 63.79           C
ATOM   1552  OE1 GLU B 438     108.959  71.303 112.827  1.00 63.79           O
ATOM   1553  OE2 GLU B 438     110.649  70.685 114.086  1.00 63.79           O
ATOM   1554  N   ARG B 439     114.571  74.570 112.997  1.00 59.22           N
ATOM   1555  CA  ARG B 439     115.828  74.986 113.594  1.00 59.22           C
ATOM   1556  C   ARG B 439     115.741  76.361 114.223  1.00 59.22           C
ATOM   1557  O   ARG B 439     116.480  76.644 115.164  1.00 59.22           O
ATOM   1558  CB  ARG B 439     116.925  74.947 112.543  1.00 59.22           C
ATOM   1559  CG  ARG B 439     117.256  73.542 112.174  1.00 59.22           C
ATOM   1560  CD  ARG B 439     118.129  73.464 110.986  1.00 59.22           C
ATOM   1561  NE  ARG B 439     118.370  72.075 110.649  1.00 59.22           N
ATOM   1562  CZ  ARG B 439     119.439  71.397 111.027  1.00 59.22           C
ATOM   1563  NH1 ARG B 439     119.566  70.131 110.694  1.00 59.22           N
ATOM   1564  NH2 ARG B 439     120.388  71.996 111.712  1.00 59.22           N
ATOM   1565  N   VAL B 440     114.844  77.206 113.743  1.00 55.57           N
ATOM   1566  CA  VAL B 440     114.662  78.529 114.311  1.00 55.57           C
ATOM   1567  C   VAL B 440     113.648  78.512 115.441  1.00 55.57           C
ATOM   1568  O   VAL B 440     113.910  79.041 116.521  1.00 55.57           O
ATOM   1569  CB  VAL B 440     114.259  79.514 113.201  1.00 55.57           C
ATOM   1570  CG1 VAL B 440     113.845  80.813 113.786  1.00 55.57           C
ATOM   1571  CG2 VAL B 440     115.416  79.729 112.267  1.00 55.57           C
ATOM   1572  N   THR B 441     112.488  77.893 115.218  1.00 57.10           N
ATOM   1573  CA  THR B 441     111.407  77.956 116.195  1.00 57.10           C
ATOM   1574  C   THR B 441     111.736  77.188 117.463  1.00 57.10           C
ATOM   1575  O   THR B 441     111.334  77.603 118.549  1.00 57.10           O
ATOM   1576  CB  THR B 441     110.101  77.436 115.597  1.00 57.10           C
ATOM   1577  OG1 THR B 441     110.263  76.080 115.189  1.00 57.10           O
ATOM   1578  CG2 THR B 441     109.671  78.270 114.416  1.00 57.10           C
ATOM   1579  N   ARG B 442     112.486  76.101 117.361  1.00 59.65           N
ATOM   1580  CA  ARG B 442     112.834  75.352 118.555  1.00 59.65           C
ATOM   1581  C   ARG B 442     113.969  75.993 119.332  1.00 59.65           C
ATOM   1582  O   ARG B 442     114.093  75.739 120.529  1.00 59.65           O
ATOM   1583  CB  ARG B 442     113.178  73.916 118.188  1.00 59.65           C
ATOM   1584  CG  ARG B 442     111.993  73.193 117.610  1.00 59.65           C
ATOM   1585  CD  ARG B 442     112.321  71.812 117.130  1.00 59.65           C
ATOM   1586  NE  ARG B 442     112.625  70.909 118.226  1.00 59.65           N
ATOM   1587  CZ  ARG B 442     113.804  70.337 118.420  1.00 59.65           C
ATOM   1588  NH1 ARG B 442     114.801  70.553 117.581  1.00 59.65           N
ATOM   1589  NH2 ARG B 442     113.975  69.531 119.449  1.00 59.65           N
ATOM   1590  N   MET B 443     114.791  76.815 118.685  1.00 57.59           N
ATOM   1591  CA  MET B 443     115.769  77.610 119.415  1.00 57.59           C
ATOM   1592  C   MET B 443     115.087  78.674 120.256  1.00 57.59           C
ATOM   1593  O   MET B 443     115.418  78.854 121.431  1.00 57.59           O
ATOM   1594  CB  MET B 443     116.746  78.267 118.452  1.00 57.59           C
ATOM   1595  CG  MET B 443     117.672  79.232 119.144  1.00 57.59           C
ATOM   1596  SD  MET B 443     118.710  80.164 118.039  1.00 57.59           S
ATOM   1597  CE  MET B 443     117.515  81.213 117.237  1.00 57.59           C
ATOM   1598  N   VAL B 444     114.140  79.395 119.659  1.00 55.36           N
ATOM   1599  CA  VAL B 444     113.442  80.466 120.357  1.00 55.36           C
ATOM   1600  C   VAL B 444     112.611  79.907 121.499  1.00 55.36           C
ATOM   1601  O   VAL B 444     112.599  80.460 122.596  1.00 55.36           O
ATOM   1602  CB  VAL B 444     112.594  81.273 119.359  1.00 55.36           C
ATOM   1603  CG1 VAL B 444     111.740  82.284 120.065  1.00 55.36           C
ATOM   1604  CG2 VAL B 444     113.491  81.971 118.380  1.00 55.36           C
ATOM   1605  N   GLN B 445     111.970  78.764 121.286  1.00 60.01           N
ATOM   1606  CA  GLN B 445     111.189  78.151 122.350  1.00 60.01           C
ATOM   1607  C   GLN B 445     112.053  77.630 123.486  1.00 60.01           C
ATOM   1608  O   GLN B 445     111.599  77.596 124.629  1.00 60.01           O
ATOM   1609  CB  GLN B 445     110.329  77.040 121.779  1.00 60.01           C
ATOM   1610  CG  GLN B 445     109.093  77.564 121.140  1.00 60.01           C
ATOM   1611  CD  GLN B 445     108.254  76.488 120.529  1.00 60.01           C
ATOM   1612  OE1 GLN B 445     108.737  75.411 120.210  1.00 60.01           O
ATOM   1613  NE2 GLN B 445     106.963  76.730 120.474  1.00 60.01           N
ATOM   1614  N   ARG B 446     113.295  77.255 123.213  1.00 58.68           N
ATOM   1615  CA  ARG B 446     114.147  76.796 124.296  1.00 58.68           C
ATOM   1616  C   ARG B 446     114.712  77.959 125.101  1.00 58.68           C
ATOM   1617  O   ARG B 446     114.793  77.881 126.327  1.00 58.68           O
ATOM   1618  CB  ARG B 446     115.291  75.944 123.758  1.00 58.68           C
ATOM   1619  CG  ARG B 446     116.041  75.249 124.860  1.00 58.68           C
ATOM   1620  CD  ARG B 446     117.311  74.587 124.424  1.00 58.68           C
ATOM   1621  NE  ARG B 446     118.323  75.568 124.076  1.00 58.68           N
ATOM   1622  CZ  ARG B 446     119.559  75.272 123.708  1.00 58.68           C
ATOM   1623  NH1 ARG B 446     120.402  76.238 123.407  1.00 58.68           N
ATOM   1624  NH2 ARG B 446     119.964  74.017 123.678  1.00 58.68           N
ATOM   1625  N   ASP B 447     115.089  79.051 124.441  1.00 58.29           N
ATOM   1626  CA  ASP B 447     116.001  80.018 125.034  1.00 58.29           C
ATOM   1627  C   ASP B 447     115.410  81.401 125.253  1.00 58.29           C
ATOM   1628  O   ASP B 447     116.152  82.318 125.600  1.00 58.29           O
ATOM   1629  CB  ASP B 447     117.250  80.134 124.164  1.00 58.29           C
ATOM   1630  CG  ASP B 447     118.074  78.879 124.182  1.00 58.29           C
ATOM   1631  OD1 ASP B 447     118.076  78.190 125.214  1.00 58.29           O
ATOM   1632  OD2 ASP B 447     118.703  78.555 123.167  1.00 58.29           O
ATOM   1633  N   ARG B 448     114.104  81.581 125.089  1.00 59.47           N
ATOM   1634  CA  ARG B 448     113.535  82.921 125.152  1.00 59.47           C
ATOM   1635  C   ARG B 448     113.467  83.501 126.556  1.00 59.47           C
ATOM   1636  O   ARG B 448     113.230  84.700 126.685  1.00 59.47           O
ATOM   1637  CB  ARG B 448     112.139  82.933 124.555  1.00 59.47           C
ATOM   1638  CG  ARG B 448     111.163  82.065 125.289  1.00 59.47           C
ATOM   1639  CD  ARG B 448     109.852  82.052 124.575  1.00 59.47           C
ATOM   1640  NE  ARG B 448     109.289  83.387 124.524  1.00 59.47           N
ATOM   1641  CZ  ARG B 448     108.296  83.743 123.726  1.00 59.47           C
ATOM   1642  NH1 ARG B 448     107.747  82.854 122.919  1.00 59.47           N
ATOM   1643  NH2 ARG B 448     107.853  84.987 123.740  1.00 59.47           N
ATOM   1644  N   ASN B 449     113.661  82.710 127.600  1.00 61.56           N
ATOM   1645  CA  ASN B 449     113.570  83.257 128.943  1.00 61.56           C
ATOM   1646  C   ASN B 449     114.904  83.723 129.500  1.00 61.56           C
ATOM   1647  O   ASN B 449     114.923  84.309 130.582  1.00 61.56           O
ATOM   1648  CB  ASN B 449     112.963  82.241 129.904  1.00 61.56           C
ATOM   1649  CG  ASN B 449     111.507  81.992 129.635  1.00 61.56           C
ATOM   1650  OD1 ASN B 449     110.778  82.890 129.243  1.00 61.56           O
ATOM   1651  ND2 ASN B 449     111.065  80.778 129.879  1.00 61.56           N
TER    1652      ASN B 449
ATOM   1653  N   ILE C 351      85.983  96.857  93.402  1.00 48.47           N
ATOM   1654  CA  ILE C 351      85.785  95.416  93.320  1.00 48.47           C
ATOM   1655  C   ILE C 351      84.294  95.120  93.378  1.00 48.47           C
ATOM   1656  O   ILE C 351      83.637  95.368  94.387  1.00 48.47           O
ATOM   1657  CB  ILE C 351      86.538  94.688  94.436  1.00 48.47           C
ATOM   1658  CG1 ILE C 351      88.038  94.906  94.289  1.00 48.47           C
ATOM   1659  CG2 ILE C 351      86.192  93.228  94.450  1.00 48.47           C
ATOM   1660  CD1 ILE C 351      88.593  94.393  93.013  1.00 48.47           C
ATOM   1661  N   ARG C 352      83.759  94.608  92.281  1.00 47.55           N
ATOM   1662  CA  ARG C 352      82.393  94.112  92.209  1.00 47.55           C
ATOM   1663  C   ARG C 352      82.482  92.597  92.304  1.00 47.55           C
ATOM   1664  O   ARG C 352      82.396  91.881  91.321  1.00 47.55           O
ATOM   1665  CB  ARG C 352      81.758  94.562  90.913  1.00 47.55           C
ATOM   1666  CG  ARG C 352      81.610  96.034  90.821  1.00 47.55           C
ATOM   1667  CD  ARG C 352      81.307  96.451  89.440  1.00 47.55           C
ATOM   1668  NE  ARG C 352      80.851  97.828  89.355  1.00 47.55           N
ATOM   1669  CZ  ARG C 352      81.639  98.886  89.279  1.00 47.55           C
ATOM   1670  NH1 ARG C 352      82.950  98.752  89.304  1.00 47.55           N
ATOM   1671  NH2 ARG C 352      81.106 100.085  89.192  1.00 47.55           N
ATOM   1672  N   GLY C 353      82.699  92.104  93.515  1.00 44.87           N
ATOM   1673  CA  GLY C 353      83.121  90.741  93.711  1.00 44.87           C
ATOM   1674  C   GLY C 353      82.047  89.828  94.265  1.00 44.87           C
ATOM   1675  O   GLY C 353      81.034  90.253  94.802  1.00 44.87           O
ATOM   1676  N   VAL C 354      82.311  88.537  94.135  1.00 46.37           N
ATOM   1677  CA  VAL C 354      81.460  87.511  94.718  1.00 46.37           C
ATOM   1678  C   VAL C 354      82.345  86.352  95.152  1.00 46.37           C
ATOM   1679  O   VAL C 354      83.346  86.037  94.511  1.00 46.37           O
ATOM   1680  CB  VAL C 354      80.339  87.093  93.736  1.00 46.37           C
ATOM   1681  CG1 VAL C 354      80.881  86.443  92.492  1.00 46.37           C
ATOM   1682  CG2 VAL C 354      79.321  86.212  94.410  1.00 46.37           C
ATOM   1683  N   ASN C 355      82.016  85.776  96.294  1.00 51.54           N
ATOM   1684  CA  ASN C 355      82.613  84.531  96.733  1.00 51.54           C
ATOM   1685  C   ASN C 355      81.991  83.370  95.985  1.00 51.54           C
ATOM   1686  O   ASN C 355      80.786  83.345  95.753  1.00 51.54           O
ATOM   1687  CB  ASN C 355      82.381  84.359  98.219  1.00 51.54           C
ATOM   1688  CG  ASN C 355      83.247  85.246  99.044  1.00 51.54           C
ATOM   1689  OD1 ASN C 355      84.454  85.152  98.999  1.00 51.54           O
ATOM   1690  ND2 ASN C 355      82.637  86.179  99.739  1.00 51.54           N
ATOM   1691  N   ARG C 356      82.808  82.397  95.616  1.00 56.59           N
ATOM   1692  CA  ARG C 356      82.320  81.253  94.863  1.00 56.59           C
ATOM   1693  C   ARG C 356      82.957  79.980  95.384  1.00 56.59           C
ATOM   1694  O   ARG C 356      84.175  79.825  95.318  1.00 56.59           O
ATOM   1695  CB  ARG C 356      82.616  81.411  93.381  1.00 56.59           C
ATOM   1696  CG  ARG C 356      82.180  80.239  92.565  1.00 56.59           C
ATOM   1697  CD  ARG C 356      82.591  80.442  91.158  1.00 56.59           C
ATOM   1698  NE  ARG C 356      82.243  79.333  90.296  1.00 56.59           N
ATOM   1699  CZ  ARG C 356      83.050  78.314  90.055  1.00 56.59           C
ATOM   1700  NH1 ARG C 356      82.663  77.353  89.248  1.00 56.59           N
ATOM   1701  NH2 ARG C 356      84.244  78.265  90.616  1.00 56.59           N
ATOM   1702  N   HIS C 357      82.134  79.075  95.891  1.00 61.62           N
ATOM   1703  CA  HIS C 357      82.557  77.705  96.117  1.00 61.62           C
ATOM   1704  C   HIS C 357      82.445  76.887  94.845  1.00 61.62           C
ATOM   1705  O   HIS C 357      81.608  77.149  93.983  1.00 61.62           O
ATOM   1706  CB  HIS C 357      81.718  77.038  97.200  1.00 61.62           C
ATOM   1707  CG  HIS C 357      82.167  77.340  98.589  1.00 61.62           C
ATOM   1708  ND1 HIS C 357      83.272  76.742  99.151  1.00 61.62           N
ATOM   1709  CD2 HIS C 357      81.638  78.128  99.550  1.00 61.62           C
ATOM   1710  CE1 HIS C 357      83.421  77.172 100.389  1.00 61.62           C
ATOM   1711  NE2 HIS C 357      82.443  78.017 100.655  1.00 61.62           N
ATOM   1712  N   GLU C 358      83.296  75.880  94.741  1.00 65.04           N
ATOM   1713  CA  GLU C 358      83.160  74.863  93.707  1.00 65.04           C
ATOM   1714  C   GLU C 358      82.081  73.885  94.136  1.00 65.04           C
ATOM   1715  O   GLU C 358      82.303  73.038  94.997  1.00 65.04           O
ATOM   1716  CB  GLU C 358      84.482  74.153  93.473  1.00 65.04           C
ATOM   1717  CG  GLU C 358      85.460  74.953  92.678  1.00 65.04           C
ATOM   1718  CD  GLU C 358      86.748  74.209  92.436  1.00 65.04           C
ATOM   1719  OE1 GLU C 358      86.989  73.187  93.105  1.00 65.04           O
ATOM   1720  OE2 GLU C 358      87.501  74.617  91.538  1.00 65.04           O
ATOM   1721  N   HIS C 359      80.904  73.998  93.538  1.00 64.14           N
ATOM   1722  CA  HIS C 359      79.786  73.165  93.938  1.00 64.14           C
ATOM   1723  C   HIS C 359      78.939  72.829  92.729  1.00 64.14           C
ATOM   1724  O   HIS C 359      78.638  73.703  91.916  1.00 64.14           O
ATOM   1725  CB  HIS C 359      78.925  73.859  94.986  1.00 64.14           C
ATOM   1726  CG  HIS C 359      77.747  73.054  95.416  1.00 64.14           C
ATOM   1727  ND1 HIS C 359      77.841  72.026  96.325  1.00 64.14           N
ATOM   1728  CD2 HIS C 359      76.454  73.094  95.026  1.00 64.14           C
ATOM   1729  CE1 HIS C 359      76.650  71.488  96.499  1.00 64.14           C
ATOM   1730  NE2 HIS C 359      75.792  72.114  95.718  1.00 64.14           N
ATOM   1731  N   HIS C 360      78.560  71.567  92.622  1.00 67.67           N
ATOM   1732  CA  HIS C 360      77.593  71.120  91.648  1.00 67.67           C
ATOM   1733  C   HIS C 360      76.578  70.282  92.414  1.00 67.67           C
ATOM   1734  O   HIS C 360      76.972  69.462  93.251  1.00 67.67           O
ATOM   1735  CB  HIS C 360      78.255  70.305  90.542  1.00 67.67           C
ATOM   1736  CG  HIS C 360      77.364  70.049  89.374  1.00 67.67           C
ATOM   1737  ND1 HIS C 360      76.450  69.021  89.348  1.00 67.67           N
ATOM   1738  CD2 HIS C 360      77.244  70.689  88.189  1.00 67.67           C
ATOM   1739  CE1 HIS C 360      75.800  69.041  88.200  1.00 67.67           C
ATOM   1740  NE2 HIS C 360      76.266  70.043  87.477  1.00 67.67           N
ATOM   1741  N   PRO C 361      75.277  70.465  92.182  1.00 67.28           N
ATOM   1742  CA  PRO C 361      74.281  69.770  93.010  1.00 67.28           C
ATOM   1743  C   PRO C 361      74.212  68.277  92.770  1.00 67.28           C
ATOM   1744  O   PRO C 361      73.773  67.548  93.663  1.00 67.28           O
ATOM   1745  CB  PRO C 361      72.970  70.448  92.615  1.00 67.28           C
ATOM   1746  CG  PRO C 361      73.209  70.919  91.248  1.00 67.28           C
ATOM   1747  CD  PRO C 361      74.639  71.320  91.172  1.00 67.28           C
ATOM   1748  N   LEU C 362      74.632  67.798  91.607  1.00 71.14           N
ATOM   1749  CA  LEU C 362      74.642  66.375  91.312  1.00 71.14           C
ATOM   1750  C   LEU C 362      75.984  65.725  91.577  1.00 71.14           C
ATOM   1751  O   LEU C 362      76.030  64.590  92.052  1.00 71.14           O
ATOM   1752  CB  LEU C 362      74.255  66.138  89.854  1.00 71.14           C
ATOM   1753  CG  LEU C 362      72.809  66.481  89.529  1.00 71.14           C
ATOM   1754  CD1 LEU C 362      72.567  66.386  88.040  1.00 71.14           C
ATOM   1755  CD2 LEU C 362      71.893  65.547  90.282  1.00 71.14           C
ATOM   1756  N   HIS C 363      77.078  66.419  91.291  1.00 70.11           N
ATOM   1757  CA  HIS C 363      78.401  65.826  91.356  1.00 70.11           C
ATOM   1758  C   HIS C 363      79.200  66.306  92.551  1.00 70.11           C
ATOM   1759  O   HIS C 363      80.379  65.972  92.663  1.00 70.11           O
ATOM   1760  CB  HIS C 363      79.158  66.114  90.068  1.00 70.11           C
ATOM   1761  CG  HIS C 363      78.445  65.641  88.848  1.00 70.11           C
ATOM   1762  ND1 HIS C 363      78.264  64.306  88.567  1.00 70.11           N
ATOM   1763  CD2 HIS C 363      77.870  66.322  87.832  1.00 70.11           C
ATOM   1764  CE1 HIS C 363      77.600  64.186  87.434  1.00 70.11           C
ATOM   1765  NE2 HIS C 363      77.352  65.394  86.965  1.00 70.11           N
ATOM   1766  N   GLY C 364      78.591  67.071  93.445  1.00 67.21           N
ATOM   1767  CA  GLY C 364      79.288  67.547  94.617  1.00 67.21           C
ATOM   1768  C   GLY C 364      80.327  68.593  94.295  1.00 67.21           C
ATOM   1769  O   GLY C 364      80.008  69.651  93.756  1.00 67.21           O
ATOM   1770  N   GLN C 365      81.584  68.295  94.596  1.00 65.73           N
ATOM   1771  CA  GLN C 365      82.662  69.254  94.440  1.00 65.73           C
ATOM   1772  C   GLN C 365      83.504  68.983  93.206  1.00 65.73           C
ATOM   1773  O   GLN C 365      84.658  69.407  93.142  1.00 65.73           O
ATOM   1774  CB  GLN C 365      83.503  69.263  95.709  1.00 65.73           C
ATOM   1775  CG  GLN C 365      82.677  69.750  96.870  1.00 65.73           C
ATOM   1776  CD  GLN C 365      83.367  69.646  98.191  1.00 65.73           C
ATOM   1777  OE1 GLN C 365      84.465  69.113  98.291  1.00 65.73           O
ATOM   1778  NE2 GLN C 365      82.723  70.156  99.226  1.00 65.73           N
ATOM   1779  N   VAL C 366      82.938  68.313  92.215  1.00 66.80           N
ATOM   1780  CA  VAL C 366      83.609  68.031  90.957  1.00 66.80           C
ATOM   1781  C   VAL C 366      83.142  69.053  89.937  1.00 66.80           C
ATOM   1782  O   VAL C 366      81.948  69.144  89.643  1.00 66.80           O
ATOM   1783  CB  VAL C 366      83.314  66.605  90.481  1.00 66.80           C
ATOM   1784  CG1 VAL C 366      83.927  66.363  89.131  1.00 66.80           C
ATOM   1785  CG2 VAL C 366      83.845  65.642  91.479  1.00 66.80           C
ATOM   1786  N   MET C 367      84.078  69.815  89.392  1.00 72.74           N
ATOM   1787  CA  MET C 367      83.766  70.890  88.467  1.00 72.74           C
ATOM   1788  C   MET C 367      84.244  70.548  87.070  1.00 72.74           C
ATOM   1789  O   MET C 367      85.382  70.113  86.888  1.00 72.74           O
ATOM   1790  CB  MET C 367      84.404  72.201  88.913  1.00 72.74           C
ATOM   1791  CG  MET C 367      83.813  72.763  90.164  1.00 72.74           C
ATOM   1792  SD  MET C 367      82.039  72.979  90.009  1.00 72.74           S
ATOM   1793  CE  MET C 367      82.001  74.147  88.673  1.00 72.74           C
ATOM   1794  N   ASP C 368      83.377  70.754  86.092  1.00 74.74           N
ATOM   1795  CA  ASP C 368      83.733  70.653  84.690  1.00 74.74           C
ATOM   1796  C   ASP C 368      83.744  72.037  84.059  1.00 74.74           C
ATOM   1797  O   ASP C 368      83.372  73.028  84.684  1.00 74.74           O
ATOM   1798  CB  ASP C 368      82.773  69.724  83.949  1.00 74.74           C
ATOM   1799  CG  ASP C 368      81.328  70.107  84.134  1.00 74.74           C
ATOM   1800  OD1 ASP C 368      81.029  70.967  84.982  1.00 74.74           O
ATOM   1801  OD2 ASP C 368      80.479  69.555  83.410  1.00 74.74           O
ATOM   1802  N   GLU C 369      84.169  72.086  82.796  1.00 72.97           N
ATOM   1803  CA  GLU C 369      84.342  73.364  82.118  1.00 72.97           C
ATOM   1804  C   GLU C 369      83.015  74.051  81.843  1.00 72.97           C
ATOM   1805  O   GLU C 369      82.931  75.277  81.945  1.00 72.97           O
ATOM   1806  CB  GLU C 369      85.112  73.165  80.818  1.00 72.97           C
ATOM   1807  CG  GLU C 369      85.423  74.449  80.087  1.00 72.97           C
ATOM   1808  CD  GLU C 369      86.358  74.251  78.925  1.00 72.97           C
ATOM   1809  OE1 GLU C 369      86.781  73.101  78.694  1.00 72.97           O
ATOM   1810  OE2 GLU C 369      86.679  75.248  78.245  1.00 72.97           O
ATOM   1811  N   GLN C 370      81.971  73.283  81.540  1.00 73.05           N
ATOM   1812  CA  GLN C 370      80.699  73.873  81.143  1.00 73.05           C
ATOM   1813  C   GLN C 370      80.023  74.594  82.296  1.00 73.05           C
ATOM   1814  O   GLN C 370      79.375  75.620  82.084  1.00 73.05           O
ATOM   1815  CB  GLN C 370      79.767  72.804  80.582  1.00 73.05           C
ATOM   1816  CG  GLN C 370      80.060  72.381  79.149  1.00 73.05           C
ATOM   1817  CD  GLN C 370      81.344  71.586  79.005  1.00 73.05           C
ATOM   1818  OE1 GLN C 370      82.238  71.962  78.248  1.00 73.05           O
ATOM   1819  NE2 GLN C 370      81.455  70.499  79.761  1.00 73.05           N
ATOM   1820  N   THR C 371      80.178  74.092  83.515  1.00 69.43           N
ATOM   1821  CA  THR C 371      79.627  74.793  84.661  1.00 69.43           C
ATOM   1822  C   THR C 371      80.458  76.022  85.003  1.00 69.43           C
ATOM   1823  O   THR C 371      79.908  77.035  85.442  1.00 69.43           O
ATOM   1824  CB  THR C 371      79.533  73.839  85.847  1.00 69.43           C
ATOM   1825  OG1 THR C 371      78.854  72.653  85.432  1.00 69.43           O
ATOM   1826  CG2 THR C 371      78.728  74.448  86.969  1.00 69.43           C
ATOM   1827  N   MET C 372      81.773  75.963  84.780  1.00 66.07           N
ATOM   1828  CA  MET C 372      82.620  77.128  85.015  1.00 66.07           C
ATOM   1829  C   MET C 372      82.315  78.246  84.037  1.00 66.07           C
ATOM   1830  O   MET C 372      82.288  79.415  84.424  1.00 66.07           O
ATOM   1831  CB  MET C 372      84.088  76.764  84.896  1.00 66.07           C
ATOM   1832  CG  MET C 372      84.602  75.846  85.928  1.00 66.07           C
ATOM   1833  SD  MET C 372      86.333  75.571  85.596  1.00 66.07           S
ATOM   1834  CE  MET C 372      86.605  74.224  86.699  1.00 66.07           C
ATOM   1835  N   VAL C 373      82.120  77.908  82.764  1.00 63.80           N
ATOM   1836  CA  VAL C 373      81.789  78.919  81.772  1.00 63.80           C
ATOM   1837  C   VAL C 373      80.410  79.491  82.049  1.00 63.80           C
ATOM   1838  O   VAL C 373      80.195  80.698  81.927  1.00 63.80           O
ATOM   1839  CB  VAL C 373      81.906  78.329  80.356  1.00 63.80           C
ATOM   1840  CG1 VAL C 373      81.429  79.303  79.311  1.00 63.80           C
ATOM   1841  CG2 VAL C 373      83.332  77.972  80.074  1.00 63.80           C
ATOM   1842  N   GLN C 374      79.483  78.649  82.504  1.00 64.29           N
ATOM   1843  CA  GLN C 374      78.150  79.114  82.868  1.00 64.29           C
ATOM   1844  C   GLN C 374      78.194  80.084  84.041  1.00 64.29           C
ATOM   1845  O   GLN C 374      77.445  81.064  84.066  1.00 64.29           O
ATOM   1846  CB  GLN C 374      77.264  77.921  83.208  1.00 64.29           C
ATOM   1847  CG  GLN C 374      75.822  78.268  83.443  1.00 64.29           C
ATOM   1848  CD  GLN C 374      74.992  77.073  83.833  1.00 64.29           C
ATOM   1849  OE1 GLN C 374      75.514  75.986  84.053  1.00 64.29           O
ATOM   1850  NE2 GLN C 374      73.687  77.264  83.905  1.00 64.29           N
ATOM   1851  N   ASP C 375      79.082  79.843  85.006  1.00 60.92           N
ATOM   1852  CA  ASP C 375      79.210  80.761  86.129  1.00 60.92           C
ATOM   1853  C   ASP C 375      79.806  82.092  85.701  1.00 60.92           C
ATOM   1854  O   ASP C 375      79.318  83.143  86.116  1.00 60.92           O
ATOM   1855  CB  ASP C 375      80.054  80.150  87.242  1.00 60.92           C
ATOM   1856  CG  ASP C 375      79.298  79.134  88.055  1.00 60.92           C
ATOM   1857  OD1 ASP C 375      78.061  79.200  88.081  1.00 60.92           O
ATOM   1858  OD2 ASP C 375      79.939  78.292  88.707  1.00 60.92           O
ATOM   1859  N   ILE C 376      80.839  82.068  84.859  1.00 57.81           N
ATOM   1860  CA  ILE C 376      81.535  83.293  84.481  1.00 57.81           C
ATOM   1861  C   ILE C 376      80.655  84.180  83.619  1.00 57.81           C
ATOM   1862  O   ILE C 376      80.661  85.405  83.774  1.00 57.81           O
ATOM   1863  CB  ILE C 376      82.863  82.952  83.789  1.00 57.81           C
ATOM   1864  CG1 ILE C 376      83.806  82.368  84.809  1.00 57.81           C
ATOM   1865  CG2 ILE C 376      83.526  84.158  83.184  1.00 57.81           C
ATOM   1866  CD1 ILE C 376      85.022  81.838  84.236  1.00 57.81           C
ATOM   1867  N   LEU C 377      79.851  83.584  82.737  1.00 57.59           N
ATOM   1868  CA  LEU C 377      78.945  84.393  81.935  1.00 57.59           C
ATOM   1869  C   LEU C 377      77.878  85.042  82.801  1.00 57.59           C
ATOM   1870  O   LEU C 377      77.625  86.234  82.663  1.00 57.59           O
ATOM   1871  CB  LEU C 377      78.291  83.574  80.830  1.00 57.59           C
ATOM   1872  CG  LEU C 377      79.176  82.886  79.797  1.00 57.59           C
ATOM   1873  CD1 LEU C 377      78.353  82.322  78.658  1.00 57.59           C
ATOM   1874  CD2 LEU C 377      80.306  83.726  79.321  1.00 57.59           C
ATOM   1875  N   LEU C 378      77.296  84.293  83.738  1.00 55.94           N
ATOM   1876  CA  LEU C 378      76.299  84.867  84.636  1.00 55.94           C
ATOM   1877  C   LEU C 378      76.875  85.936  85.547  1.00 55.94           C
ATOM   1878  O   LEU C 378      76.170  86.883  85.897  1.00 55.94           O
ATOM   1879  CB  LEU C 378      75.660  83.782  85.487  1.00 55.94           C
ATOM   1880  CG  LEU C 378      74.656  82.871  84.821  1.00 55.94           C
ATOM   1881  CD1 LEU C 378      74.292  81.777  85.782  1.00 55.94           C
ATOM   1882  CD2 LEU C 378      73.448  83.687  84.468  1.00 55.94           C
ATOM   1883  N   MET C 379      78.138  85.804  85.942  1.00 54.51           N
ATOM   1884  CA  MET C 379      78.768  86.828  86.760  1.00 54.51           C
ATOM   1885  C   MET C 379      78.967  88.116  85.984  1.00 54.51           C
ATOM   1886  O   MET C 379      78.654  89.199  86.481  1.00 54.51           O
ATOM   1887  CB  MET C 379      80.098  86.325  87.292  1.00 54.51           C
ATOM   1888  CG  MET C 379      79.949  85.341  88.389  1.00 54.51           C
ATOM   1889  SD  MET C 379      81.505  84.595  88.803  1.00 54.51           S
ATOM   1890  CE  MET C 379      80.950  83.486  90.057  1.00 54.51           C
ATOM   1891  N   LYS C 380      79.481  88.022  84.764  1.00 54.11           N
ATOM   1892  CA  LYS C 380      79.753  89.233  84.010  1.00 54.11           C
ATOM   1893  C   LYS C 380      78.481  89.869  83.481  1.00 54.11           C
ATOM   1894  O   LYS C 380      78.418  91.091  83.353  1.00 54.11           O
ATOM   1895  CB  LYS C 380      80.726  88.939  82.881  1.00 54.11           C
ATOM   1896  CG  LYS C 380      82.100  88.621  83.384  1.00 54.11           C
ATOM   1897  CD  LYS C 380      83.062  88.457  82.260  1.00 54.11           C
ATOM   1898  CE  LYS C 380      83.367  89.789  81.632  1.00 54.11           C
ATOM   1899  NZ  LYS C 380      84.115  90.675  82.537  1.00 54.11           N
ATOM   1900  N   GLN C 381      77.448  89.077  83.214  1.00 55.52           N
ATOM   1901  CA  GLN C 381      76.161  89.631  82.822  1.00 55.52           C
ATOM   1902  C   GLN C 381      75.440  90.310  83.971  1.00 55.52           C
ATOM   1903  O   GLN C 381      74.469  91.023  83.733  1.00 55.52           O
ATOM   1904  CB  GLN C 381      75.282  88.537  82.235  1.00 55.52           C
ATOM   1905  CG  GLN C 381      75.750  88.063  80.888  1.00 55.52           C
ATOM   1906  CD  GLN C 381      75.101  86.775  80.480  1.00 55.52           C
ATOM   1907  OE1 GLN C 381      74.228  86.267  81.167  1.00 55.52           O
ATOM   1908  NE2 GLN C 381      75.580  86.195  79.397  1.00 55.52           N
ATOM   1909  N   ASN C 382      75.893  90.116  85.198  1.00 50.50           N
ATOM   1910  CA  ASN C 382      75.319  90.750  86.369  1.00 50.50           C
ATOM   1911  C   ASN C 382      76.300  91.711  87.018  1.00 50.50           C
ATOM   1912  O   ASN C 382      76.232  91.955  88.219  1.00 50.50           O
ATOM   1913  CB  ASN C 382      74.856  89.672  87.334  1.00 50.50           C
ATOM   1914  CG  ASN C 382      73.648  88.964  86.826  1.00 50.50           C
ATOM   1915  OD1 ASN C 382      72.628  89.579  86.581  1.00 50.50           O
ATOM   1916  ND2 ASN C 382      73.791  87.693  86.534  1.00 50.50           N
ATOM   1917  N   ASN C 383      77.237  92.216  86.216  1.00 48.87           N
ATOM   1918  CA  ASN C 383      78.153  93.303  86.554  1.00 48.87           C
ATOM   1919  C   ASN C 383      79.105  92.944  87.686  1.00 48.87           C
ATOM   1920  O   ASN C 383      79.515  93.807  88.450  1.00 48.87           O
ATOM   1921  CB  ASN C 383      77.402  94.595  86.878  1.00 48.87           C
ATOM   1922  CG  ASN C 383      76.671  95.141  85.696  1.00 48.87           C
ATOM   1923  OD1 ASN C 383      77.163  95.095  84.584  1.00 48.87           O
ATOM   1924  ND2 ASN C 383      75.492  95.667  85.926  1.00 48.87           N
ATOM   1925  N   PHE C 384      79.475  91.681  87.807  1.00 46.32           N
ATOM   1926  CA  PHE C 384      80.570  91.295  88.679  1.00 46.32           C
ATOM   1927  C   PHE C 384      81.872  91.335  87.896  1.00 46.32           C
ATOM   1928  O   PHE C 384      81.910  90.959  86.728  1.00 46.32           O
ATOM   1929  CB  PHE C 384      80.349  89.898  89.253  1.00 46.32           C
ATOM   1930  CG  PHE C 384      79.265  89.824  90.276  1.00 46.32           C
ATOM   1931  CD1 PHE C 384      79.526  90.112  91.597  1.00 46.32           C
ATOM   1932  CD2 PHE C 384      77.987  89.470  89.919  1.00 46.32           C
ATOM   1933  CE1 PHE C 384      78.534  90.043  92.534  1.00 46.32           C
ATOM   1934  CE2 PHE C 384      76.994  89.403  90.856  1.00 46.32           C
ATOM   1935  CZ  PHE C 384      77.270  89.689  92.162  1.00 46.32           C
ATOM   1936  N   ASN C 385      82.936  91.810  88.531  1.00 47.51           N
ATOM   1937  CA  ASN C 385      84.243  91.771  87.899  1.00 47.51           C
ATOM   1938  C   ASN C 385      85.287  91.011  88.701  1.00 47.51           C
ATOM   1939  O   ASN C 385      86.447  90.981  88.294  1.00 47.51           O
ATOM   1940  CB  ASN C 385      84.747  93.189  87.572  1.00 47.51           C
ATOM   1941  CG  ASN C 385      84.939  94.084  88.792  1.00 47.51           C
ATOM   1942  OD1 ASN C 385      84.798  93.681  89.931  1.00 47.51           O
ATOM   1943  ND2 ASN C 385      85.275  95.325  88.532  1.00 47.51           N
ATOM   1944  N   ALA C 386      84.923  90.410  89.823  1.00 45.11           N
ATOM   1945  CA  ALA C 386      85.915  89.774  90.666  1.00 45.11           C
ATOM   1946  C   ALA C 386      85.317  88.559  91.347  1.00 45.11           C
ATOM   1947  O   ALA C 386      84.121  88.508  91.612  1.00 45.11           O
ATOM   1948  CB  ALA C 386      86.471  90.739  91.704  1.00 45.11           C
ATOM   1949  N   VAL C 387      86.155  87.559  91.587  1.00 47.32           N
ATOM   1950  CA  VAL C 387      85.754  86.319  92.238  1.00 47.32           C
ATOM   1951  C   VAL C 387      86.778  86.009  93.314  1.00 47.32           C
ATOM   1952  O   VAL C 387      87.981  86.092  93.067  1.00 47.32           O
ATOM   1953  CB  VAL C 387      85.658  85.137  91.253  1.00 47.32           C
ATOM   1954  CG1 VAL C 387      85.172  83.902  91.949  1.00 47.32           C
ATOM   1955  CG2 VAL C 387      84.741  85.429  90.142  1.00 47.32           C
ATOM   1956  N   ARG C 388      86.312  85.660  94.498  1.00 52.55           N
ATOM   1957  CA  ARG C 388      87.181  85.161  95.547  1.00 52.55           C
ATOM   1958  C   ARG C 388      87.034  83.652  95.633  1.00 52.55           C
ATOM   1959  O   ARG C 388      85.921  83.136  95.734  1.00 52.55           O
ATOM   1960  CB  ARG C 388      86.859  85.838  96.873  1.00 52.55           C
ATOM   1961  CG  ARG C 388      87.692  85.394  98.032  1.00 52.55           C
ATOM   1962  CD  ARG C 388      87.525  86.351  99.177  1.00 52.55           C
ATOM   1963  NE  ARG C 388      88.199  85.892 100.377  1.00 52.55           N
ATOM   1964  CZ  ARG C 388      87.589  85.270 101.376  1.00 52.55           C
ATOM   1965  NH1 ARG C 388      86.286  85.068 101.329  1.00 52.55           N
ATOM   1966  NH2 ARG C 388      88.273  84.879 102.436  1.00 52.55           N
ATOM   1967  N   CYS C 389      88.156  82.952  95.552  1.00 59.32           N
ATOM   1968  CA  CYS C 389      88.194  81.492  95.565  1.00 59.32           C
ATOM   1969  C   CYS C 389      88.018  81.029  96.998  1.00 59.32           C
ATOM   1970  O   CYS C 389      88.985  80.772  97.704  1.00 59.32           O
ATOM   1971  CB  CYS C 389      89.512  80.987  95.002  1.00 59.32           C
ATOM   1972  SG  CYS C 389      89.868  81.502  93.342  1.00 59.32           S
ATOM   1973  N   SER C 390      86.779  80.902  97.435  1.00 58.46           N
ATOM   1974  CA  SER C 390      86.482  80.653  98.837  1.00 58.46           C
ATOM   1975  C   SER C 390      86.304  79.158  99.086  1.00 58.46           C
ATOM   1976  O   SER C 390      85.463  78.529  98.444  1.00 58.46           O
ATOM   1977  CB  SER C 390      85.226  81.414  99.238  1.00 58.46           C
ATOM   1978  OG  SER C 390      84.100  80.908  98.561  1.00 58.46           O
ATOM   1979  N   HIS C 391      87.108  78.579  99.985  1.00 59.01           N
ATOM   1980  CA  HIS C 391      88.319  79.185 100.525  1.00 59.01           C
ATOM   1981  C   HIS C 391      89.448  78.202 100.337  1.00 59.01           C
ATOM   1982  O   HIS C 391      89.912  77.610 101.302  1.00 59.01           O
ATOM   1983  CB  HIS C 391      88.175  79.472 102.013  1.00 59.01           C
ATOM   1984  CG  HIS C 391      86.986  80.296 102.365  1.00 59.01           C
ATOM   1985  ND1 HIS C 391      86.948  81.659 102.193  1.00 59.01           N
ATOM   1986  CD2 HIS C 391      85.783  79.945 102.871  1.00 59.01           C
ATOM   1987  CE1 HIS C 391      85.775  82.114 102.585  1.00 59.01           C
ATOM   1988  NE2 HIS C 391      85.049  81.095 102.999  1.00 59.01           N
ATOM   1989  N   TYR C 392      89.940  78.107  99.121  1.00 58.64           N
ATOM   1990  CA  TYR C 392      90.873  77.086  98.666  1.00 58.64           C
ATOM   1991  C   TYR C 392      91.247  77.382  97.224  1.00 58.64           C
ATOM   1992  O   TYR C 392      90.501  78.090  96.546  1.00 58.64           O
ATOM   1993  CB  TYR C 392      90.291  75.670  98.813  1.00 58.64           C
ATOM   1994  CG  TYR C 392      88.871  75.474  98.362  1.00 58.64           C
ATOM   1995  CD1 TYR C 392      87.852  75.392  99.291  1.00 58.64           C
ATOM   1996  CD2 TYR C 392      88.543  75.387  97.024  1.00 58.64           C
ATOM   1997  CE1 TYR C 392      86.560  75.219  98.906  1.00 58.64           C
ATOM   1998  CE2 TYR C 392      87.247  75.224  96.628  1.00 58.64           C
ATOM   1999  CZ  TYR C 392      86.260  75.138  97.577  1.00 58.64           C
ATOM   2000  OH  TYR C 392      84.956  74.971  97.196  1.00 58.64           O
ATOM   2001  N   PRO C 393      92.383  76.892  96.727  1.00 57.99           N
ATOM   2002  CA  PRO C 393      92.689  77.073  95.308  1.00 57.99           C
ATOM   2003  C   PRO C 393      91.722  76.294  94.444  1.00 57.99           C
ATOM   2004  O   PRO C 393      91.349  75.168  94.767  1.00 57.99           O
ATOM   2005  CB  PRO C 393      94.109  76.522  95.184  1.00 57.99           C
ATOM   2006  CG  PRO C 393      94.648  76.583  96.529  1.00 57.99           C
ATOM   2007  CD  PRO C 393      93.526  76.302  97.437  1.00 57.99           C
ATOM   2008  N   ASN C 394      91.293  76.906  93.352  1.00 61.40           N
ATOM   2009  CA  ASN C 394      90.339  76.214  92.514  1.00 61.40           C
ATOM   2010  C   ASN C 394      91.023  75.251  91.561  1.00 61.40           C
ATOM   2011  O   ASN C 394      92.241  75.073  91.558  1.00 61.40           O
ATOM   2012  CB  ASN C 394      89.475  77.175  91.709  1.00 61.40           C
ATOM   2013  CG  ASN C 394      88.436  77.847  92.540  1.00 61.40           C
ATOM   2014  OD1 ASN C 394      88.181  79.022  92.391  1.00 61.40           O
ATOM   2015  ND2 ASN C 394      87.885  77.119  93.487  1.00 61.40           N
ATOM   2016  N   HIS C 395      90.179  74.597  90.786  1.00 65.19           N
ATOM   2017  CA  HIS C 395      90.574  73.828  89.624  1.00 65.19           C
ATOM   2018  C   HIS C 395      91.389  74.708  88.681  1.00 65.19           C
ATOM   2019  O   HIS C 395      91.079  75.892  88.531  1.00 65.19           O
ATOM   2020  CB  HIS C 395      89.302  73.330  88.942  1.00 65.19           C
ATOM   2021  CG  HIS C 395      89.526  72.369  87.827  1.00 65.19           C
ATOM   2022  ND1 HIS C 395      89.881  72.772  86.561  1.00 65.19           N
ATOM   2023  CD2 HIS C 395      89.377  71.028  87.768  1.00 65.19           C
ATOM   2024  CE1 HIS C 395      89.985  71.715  85.779  1.00 65.19           C
ATOM   2025  NE2 HIS C 395      89.682  70.643  86.486  1.00 65.19           N
ATOM   2026  N   PRO C 396      92.441  74.177  88.052  1.00 63.77           N
ATOM   2027  CA  PRO C 396      93.353  75.036  87.281  1.00 63.77           C
ATOM   2028  C   PRO C 396      92.736  75.672  86.056  1.00 63.77           C
ATOM   2029  O   PRO C 396      93.228  76.712  85.613  1.00 63.77           O
ATOM   2030  CB  PRO C 396      94.477  74.076  86.884  1.00 63.77           C
ATOM   2031  CG  PRO C 396      94.413  73.005  87.871  1.00 63.77           C
ATOM   2032  CD  PRO C 396      92.977  72.818  88.195  1.00 63.77           C
ATOM   2033  N   LEU C 397      91.669  75.102  85.508  1.00 62.54           N
ATOM   2034  CA  LEU C 397      91.009  75.692  84.355  1.00 62.54           C
ATOM   2035  C   LEU C 397      90.264  76.969  84.709  1.00 62.54           C
ATOM   2036  O   LEU C 397      90.045  77.807  83.831  1.00 62.54           O
ATOM   2037  CB  LEU C 397      90.064  74.666  83.746  1.00 62.54           C
ATOM   2038  CG  LEU C 397      89.332  74.986  82.456  1.00 62.54           C
ATOM   2039  CD1 LEU C 397      90.330  75.274  81.370  1.00 62.54           C
ATOM   2040  CD2 LEU C 397      88.489  73.812  82.099  1.00 62.54           C
ATOM   2041  N   TRP C 398      89.899  77.140  85.979  1.00 57.03           N
ATOM   2042  CA  TRP C 398      89.178  78.326  86.418  1.00 57.03           C
ATOM   2043  C   TRP C 398      89.992  79.592  86.219  1.00 57.03           C
ATOM   2044  O   TRP C 398      89.454  80.620  85.804  1.00 57.03           O
ATOM   2045  CB  TRP C 398      88.793  78.170  87.879  1.00 57.03           C
ATOM   2046  CG  TRP C 398      88.147  79.347  88.445  1.00 57.03           C
ATOM   2047  CD1 TRP C 398      88.688  80.228  89.315  1.00 57.03           C
ATOM   2048  CD2 TRP C 398      86.830  79.803  88.176  1.00 57.03           C
ATOM   2049  NE1 TRP C 398      87.787  81.201  89.621  1.00 57.03           N
ATOM   2050  CE2 TRP C 398      86.633  80.963  88.928  1.00 57.03           C
ATOM   2051  CE3 TRP C 398      85.793  79.337  87.374  1.00 57.03           C
ATOM   2052  CZ2 TRP C 398      85.447  81.667  88.903  1.00 57.03           C
ATOM   2053  CZ3 TRP C 398      84.621  80.029  87.356  1.00 57.03           C
ATOM   2054  CH2 TRP C 398      84.453  81.184  88.111  1.00 57.03           C
ATOM   2055  N   TYR C 399      91.292  79.528  86.487  1.00 57.84           N
ATOM   2056  CA  TYR C 399      92.138  80.699  86.339  1.00 57.84           C
ATOM   2057  C   TYR C 399      92.353  81.040  84.880  1.00 57.84           C
ATOM   2058  O   TYR C 399      92.458  82.215  84.536  1.00 57.84           O
ATOM   2059  CB  TYR C 399      93.473  80.463  87.027  1.00 57.84           C
ATOM   2060  CG  TYR C 399      93.313  80.128  88.471  1.00 57.84           C
ATOM   2061  CD1 TYR C 399      93.081  81.113  89.405  1.00 57.84           C
ATOM   2062  CD2 TYR C 399      93.367  78.816  88.900  1.00 57.84           C
ATOM   2063  CE1 TYR C 399      92.917  80.804  90.724  1.00 57.84           C
ATOM   2064  CE2 TYR C 399      93.202  78.501  90.212  1.00 57.84           C
ATOM   2065  CZ  TYR C 399      92.981  79.496  91.120  1.00 57.84           C
ATOM   2066  OH  TYR C 399      92.821  79.180  92.437  1.00 57.84           O
ATOM   2067  N   THR C 400      92.408  80.025  84.020  1.00 59.88           N
ATOM   2068  CA  THR C 400      92.526  80.245  82.586  1.00 59.88           C
ATOM   2069  C   THR C 400      91.297  80.948  82.036  1.00 59.88           C
ATOM   2070  O   THR C 400      91.409  81.879  81.236  1.00 59.88           O
ATOM   2071  CB  THR C 400      92.739  78.907  81.886  1.00 59.88           C
ATOM   2072  OG1 THR C 400      93.942  78.307  82.369  1.00 59.88           O
ATOM   2073  CG2 THR C 400      92.840  79.081  80.397  1.00 59.88           C
ATOM   2074  N   LEU C 401      90.117  80.535  82.481  1.00 58.51           N
ATOM   2075  CA  LEU C 401      88.894  81.160  82.012  1.00 58.51           C
ATOM   2076  C   LEU C 401      88.727  82.566  82.567  1.00 58.51           C
ATOM   2077  O   LEU C 401      88.153  83.424  81.899  1.00 58.51           O
ATOM   2078  CB  LEU C 401      87.705  80.293  82.387  1.00 58.51           C
ATOM   2079  CG  LEU C 401      87.606  78.915  81.757  1.00 58.51           C
ATOM   2080  CD1 LEU C 401      86.461  78.178  82.375  1.00 58.51           C
ATOM   2081  CD2 LEU C 401      87.416  79.043  80.281  1.00 58.51           C
ATOM   2082  N   CYS C 402      89.227  82.827  83.771  1.00 56.30           N
ATOM   2083  CA  CYS C 402      89.187  84.186  84.290  1.00 56.30           C
ATOM   2084  C   CYS C 402      90.205  85.082  83.600  1.00 56.30           C
ATOM   2085  O   CYS C 402      89.989  86.290  83.514  1.00 56.30           O
ATOM   2086  CB  CYS C 402      89.407  84.184  85.799  1.00 56.30           C
ATOM   2087  SG  CYS C 402      88.079  83.440  86.756  1.00 56.30           S
ATOM   2088  N   ASP C 403      91.317  84.517  83.119  1.00 58.63           N
ATOM   2089  CA  ASP C 403      92.221  85.255  82.240  1.00 58.63           C
ATOM   2090  C   ASP C 403      91.518  85.656  80.957  1.00 58.63           C
ATOM   2091  O   ASP C 403      91.682  86.772  80.465  1.00 58.63           O
ATOM   2092  CB  ASP C 403      93.440  84.410  81.868  1.00 58.63           C
ATOM   2093  CG  ASP C 403      94.333  84.099  83.033  1.00 58.63           C
ATOM   2094  OD1 ASP C 403      94.339  84.869  83.993  1.00 58.63           O
ATOM   2095  OD2 ASP C 403      95.043  83.076  82.991  1.00 58.63           O
ATOM   2096  N   ARG C 404      90.725  84.747  80.411  1.00 62.25           N
ATOM   2097  CA  ARG C 404      90.191  84.875  79.068  1.00 62.25           C
ATOM   2098  C   ARG C 404      89.000  85.818  79.023  1.00 62.25           C
ATOM   2099  O   ARG C 404      88.929  86.695  78.163  1.00 62.25           O
ATOM   2100  CB  ARG C 404      89.805  83.491  78.571  1.00 62.25           C
ATOM   2101  CG  ARG C 404      89.339  83.396  77.161  1.00 62.25           C
ATOM   2102  CD  ARG C 404      89.078  81.939  76.875  1.00 62.25           C
ATOM   2103  NE  ARG C 404      90.311  81.170  76.994  1.00 62.25           N
ATOM   2104  CZ  ARG C 404      90.360  79.847  77.085  1.00 62.25           C
ATOM   2105  NH1 ARG C 404      89.242  79.140  77.084  1.00 62.25           N
ATOM   2106  NH2 ARG C 404      91.529  79.234  77.186  1.00 62.25           N
ATOM   2107  N   TYR C 405      88.054  85.648  79.935  1.00 60.08           N
ATOM   2108  CA  TYR C 405      86.858  86.475  79.949  1.00 60.08           C
ATOM   2109  C   TYR C 405      87.047  87.765  80.716  1.00 60.08           C
ATOM   2110  O   TYR C 405      86.404  88.765  80.400  1.00 60.08           O
ATOM   2111  CB  TYR C 405      85.695  85.700  80.550  1.00 60.08           C
ATOM   2112  CG  TYR C 405      85.226  84.582  79.677  1.00 60.08           C
ATOM   2113  CD1 TYR C 405      84.387  84.827  78.609  1.00 60.08           C
ATOM   2114  CD2 TYR C 405      85.628  83.284  79.912  1.00 60.08           C
ATOM   2115  CE1 TYR C 405      83.957  83.810  77.806  1.00 60.08           C
ATOM   2116  CE2 TYR C 405      85.206  82.261  79.115  1.00 60.08           C
ATOM   2117  CZ  TYR C 405      84.369  82.530  78.065  1.00 60.08           C
ATOM   2118  OH  TYR C 405      83.943  81.506  77.264  1.00 60.08           O
ATOM   2119  N   GLY C 406      87.897  87.755  81.722  1.00 55.28           N
ATOM   2120  CA  GLY C 406      88.227  88.941  82.470  1.00 55.28           C
ATOM   2121  C   GLY C 406      87.480  88.992  83.777  1.00 55.28           C
ATOM   2122  O   GLY C 406      86.369  89.508  83.855  1.00 55.28           O
ATOM   2123  N   LEU C 407      88.122  88.498  84.822  1.00 49.94           N
ATOM   2124  CA  LEU C 407      87.640  88.596  86.184  1.00 49.94           C
ATOM   2125  C   LEU C 407      88.865  88.664  87.064  1.00 49.94           C
ATOM   2126  O   LEU C 407      89.830  87.944  86.829  1.00 49.94           O
ATOM   2127  CB  LEU C 407      86.773  87.404  86.596  1.00 49.94           C
ATOM   2128  CG  LEU C 407      85.378  87.218  86.020  1.00 49.94           C
ATOM   2129  CD1 LEU C 407      84.811  85.908  86.462  1.00 49.94           C
ATOM   2130  CD2 LEU C 407      84.486  88.334  86.463  1.00 49.94           C
ATOM   2131  N   TYR C 408      88.838  89.531  88.057  1.00 49.07           N
ATOM   2132  CA  TYR C 408      89.908  89.541  89.030  1.00 49.07           C
ATOM   2133  C   TYR C 408      89.710  88.373  89.975  1.00 49.07           C
ATOM   2134  O   TYR C 408      88.587  88.021  90.316  1.00 49.07           O
ATOM   2135  CB  TYR C 408      89.929  90.848  89.798  1.00 49.07           C
ATOM   2136  CG  TYR C 408      89.957  92.031  88.893  1.00 49.07           C
ATOM   2137  CD1 TYR C 408      91.020  92.246  88.042  1.00 49.07           C
ATOM   2138  CD2 TYR C 408      88.937  92.959  88.920  1.00 49.07           C
ATOM   2139  CE1 TYR C 408      91.040  93.322  87.212  1.00 49.07           C
ATOM   2140  CE2 TYR C 408      88.956  94.044  88.106  1.00 49.07           C
ATOM   2141  CZ  TYR C 408      90.011  94.225  87.255  1.00 49.07           C
ATOM   2142  OH  TYR C 408      90.020  95.314  86.436  1.00 49.07           O
ATOM   2143  N   VAL C 409      90.797  87.737  90.365  1.00 48.18           N
ATOM   2144  CA  VAL C 409      90.729  86.546  91.192  1.00 48.18           C
ATOM   2145  C   VAL C 409      91.523  86.800  92.458  1.00 48.18           C
ATOM   2146  O   VAL C 409      92.656  87.279  92.397  1.00 48.18           O
ATOM   2147  CB  VAL C 409      91.245  85.310  90.437  1.00 48.18           C
ATOM   2148  CG1 VAL C 409      91.332  84.132  91.339  1.00 48.18           C
ATOM   2149  CG2 VAL C 409      90.331  84.985  89.304  1.00 48.18           C
ATOM   2150  N   VAL C 410      90.914  86.525  93.599  1.00 50.42           N
ATOM   2151  CA  VAL C 410      91.625  86.413  94.861  1.00 50.42           C
ATOM   2152  C   VAL C 410      91.869  84.935  95.096  1.00 50.42           C
ATOM   2153  O   VAL C 410      90.929  84.168  95.302  1.00 50.42           O
ATOM   2154  CB  VAL C 410      90.841  87.041  96.014  1.00 50.42           C
ATOM   2155  CG1 VAL C 410      91.553  86.795  97.317  1.00 50.42           C
ATOM   2156  CG2 VAL C 410      90.690  88.500  95.777  1.00 50.42           C
ATOM   2157  N   ASP C 411      93.125  84.526  95.051  1.00 55.08           N
ATOM   2158  CA  ASP C 411      93.483  83.131  95.217  1.00 55.08           C
ATOM   2159  C   ASP C 411      93.804  82.884  96.682  1.00 55.08           C
ATOM   2160  O   ASP C 411      94.602  83.608  97.276  1.00 55.08           O
ATOM   2161  CB  ASP C 411      94.674  82.788  94.335  1.00 55.08           C
ATOM   2162  CG  ASP C 411      94.809  81.320  94.093  1.00 55.08           C
ATOM   2163  OD1 ASP C 411      93.975  80.540  94.575  1.00 55.08           O
ATOM   2164  OD2 ASP C 411      95.761  80.939  93.411  1.00 55.08           O
ATOM   2165  N   GLU C 412      93.185  81.870  97.262  1.00 58.65           N
ATOM   2166  CA  GLU C 412      93.153  81.718  98.706  1.00 58.65           C
ATOM   2167  C   GLU C 412      93.718  80.370  99.107  1.00 58.65           C
ATOM   2168  O   GLU C 412      93.373  79.355  98.512  1.00 58.65           O
ATOM   2169  CB  GLU C 412      91.728  81.886  99.209  1.00 58.65           C
ATOM   2170  CG  GLU C 412      91.578  81.858 100.693  1.00 58.65           C
ATOM   2171  CD  GLU C 412      90.227  82.372 101.113  1.00 58.65           C
ATOM   2172  OE1 GLU C 412      89.435  82.743 100.225  1.00 58.65           O
ATOM   2173  OE2 GLU C 412      89.956  82.421 102.323  1.00 58.65           O
ATOM   2174  N   ALA C 413      94.601  80.372 100.096  1.00 56.24           N
ATOM   2175  CA  ALA C 413      95.205  79.138 100.565  1.00 56.24           C
ATOM   2176  C   ALA C 413      94.187  78.288 101.310  1.00 56.24           C
ATOM   2177  O   ALA C 413      93.247  78.793 101.920  1.00 56.24           O
ATOM   2178  CB  ALA C 413      96.394  79.438 101.468  1.00 56.24           C
ATOM   2179  N   ASN C 414      94.393  76.976 101.263  1.00 58.54           N
ATOM   2180  CA  ASN C 414      93.471  76.002 101.844  1.00 58.54           C
ATOM   2181  C   ASN C 414      93.748  75.854 103.341  1.00 58.54           C
ATOM   2182  O   ASN C 414      94.183  74.815 103.830  1.00 58.54           O
ATOM   2183  CB  ASN C 414      93.623  74.671 101.127  1.00 58.54           C
ATOM   2184  CG  ASN C 414      92.532  73.692 101.467  1.00 58.54           C
ATOM   2185  OD1 ASN C 414      91.536  74.042 102.080  1.00 58.54           O
ATOM   2186  ND2 ASN C 414      92.759  72.437 101.138  1.00 58.54           N
ATOM   2187  N   ILE C 415      93.508  76.930 104.081  1.00 56.29           N
ATOM   2188  CA  ILE C 415      93.737  76.952 105.520  1.00 56.29           C
ATOM   2189  C   ILE C 415      92.509  77.554 106.177  1.00 56.29           C
ATOM   2190  O   ILE C 415      92.229  78.742 105.997  1.00 56.29           O
ATOM   2191  CB  ILE C 415      94.986  77.748 105.916  1.00 56.29           C
ATOM   2192  CG1 ILE C 415      96.249  77.172 105.294  1.00 56.29           C
ATOM   2193  CG2 ILE C 415      95.138  77.736 107.410  1.00 56.29           C
ATOM   2194  CD1 ILE C 415      97.424  78.064 105.417  1.00 56.29           C
ATOM   2195  N   GLU C 416      91.782  76.751 106.939  1.00 62.47           N
ATOM   2196  CA  GLU C 416      90.727  77.277 107.794  1.00 62.47           C
ATOM   2197  C   GLU C 416      90.597  76.410 109.030  1.00 62.47           C
ATOM   2198  O   GLU C 416      90.343  75.213 108.923  1.00 62.47           O
ATOM   2199  CB  GLU C 416      89.394  77.376 107.066  1.00 62.47           C
ATOM   2200  CG  GLU C 416      88.295  77.805 108.005  1.00 62.47           C
ATOM   2201  CD  GLU C 416      87.062  78.301 107.312  1.00 62.47           C
ATOM   2202  OE1 GLU C 416      87.077  78.466 106.083  1.00 62.47           O
ATOM   2203  OE2 GLU C 416      86.055  78.500 108.001  1.00 62.47           O
ATOM   2204  N   THR C 417      90.700  77.022 110.193  1.00 63.58           N
ATOM   2205  CA  THR C 417      90.586  76.283 111.423  1.00 63.58           C
ATOM   2206  C   THR C 417      89.583  77.008 112.273  1.00 63.58           C
ATOM   2207  O   THR C 417      89.850  77.346 113.405  1.00 63.58           O
ATOM   2208  CB  THR C 417      91.922  76.278 112.166  1.00 63.58           C
ATOM   2209  OG1 THR C 417      92.188  77.588 112.659  1.00 63.58           O
ATOM   2210  CG2 THR C 417      93.035  75.875 111.247  1.00 63.58           C
ATOM   2211  N   HIS C 418      88.395  77.178 111.724  1.00 66.23           N
ATOM   2212  CA  HIS C 418      87.313  77.889 112.373  1.00 66.23           C
ATOM   2213  C   HIS C 418      86.852  77.235 113.660  1.00 66.23           C
ATOM   2214  O   HIS C 418      86.542  77.907 114.626  1.00 66.23           O
ATOM   2215  CB  HIS C 418      86.136  77.997 111.415  1.00 66.23           C
ATOM   2216  CG  HIS C 418      85.199  79.114 111.735  1.00 66.23           C
ATOM   2217  ND1 HIS C 418      84.415  79.720 110.782  1.00 66.23           N
ATOM   2218  CD2 HIS C 418      84.928  79.742 112.900  1.00 66.23           C
ATOM   2219  CE1 HIS C 418      83.693  80.667 111.348  1.00 66.23           C
ATOM   2220  NE2 HIS C 418      83.988  80.703 112.632  1.00 66.23           N
ATOM   2221  N   GLY C 419      86.813  75.916 113.661  1.00 67.87           N
ATOM   2222  CA  GLY C 419      86.362  75.151 114.799  1.00 67.87           C
ATOM   2223  C   GLY C 419      87.238  75.102 116.031  1.00 67.87           C
ATOM   2224  O   GLY C 419      86.792  74.627 117.061  1.00 67.87           O
ATOM   2225  N   MET C 420      88.481  75.548 115.932  1.00 68.91           N
ATOM   2226  CA  MET C 420      89.396  75.459 117.053  1.00 68.91           C
ATOM   2227  C   MET C 420      89.011  76.468 118.123  1.00 68.91           C
ATOM   2228  O   MET C 420      88.455  77.526 117.833  1.00 68.91           O
ATOM   2229  CB  MET C 420      90.829  75.714 116.595  1.00 68.91           C
ATOM   2230  CG  MET C 420      91.340  74.730 115.577  1.00 68.91           C
ATOM   2231  SD  MET C 420      91.269  73.031 116.149  1.00 68.91           S
ATOM   2232  CE  MET C 420      92.472  73.089 117.448  1.00 68.91           C
ATOM   2233  N   VAL C 421      89.295  76.126 119.373  1.00 69.47           N
ATOM   2234  CA  VAL C 421      89.083  77.055 120.479  1.00 69.47           C
ATOM   2235  C   VAL C 421      90.416  77.283 121.181  1.00 69.47           C
ATOM   2236  O   VAL C 421      90.959  76.349 121.782  1.00 69.47           O
ATOM   2237  CB  VAL C 421      88.021  76.551 121.462  1.00 69.47           C
ATOM   2238  CG1 VAL C 421      87.909  77.511 122.615  1.00 69.47           C
ATOM   2239  CG2 VAL C 421      86.689  76.414 120.772  1.00 69.47           C
ATOM   2240  N   PRO C 422      91.011  78.480 121.100  1.00 69.35           N
ATOM   2241  CA  PRO C 422      90.613  79.636 120.301  1.00 69.35           C
ATOM   2242  C   PRO C 422      90.944  79.407 118.844  1.00 69.35           C
ATOM   2243  O   PRO C 422      91.558  78.395 118.541  1.00 69.35           O
ATOM   2244  CB  PRO C 422      91.452  80.762 120.881  1.00 69.35           C
ATOM   2245  CG  PRO C 422      92.646  80.094 121.371  1.00 69.35           C
ATOM   2246  CD  PRO C 422      92.220  78.768 121.883  1.00 69.35           C
ATOM   2247  N   MET C 423      90.543  80.323 117.969  1.00 69.58           N
ATOM   2248  CA  MET C 423      90.596  80.060 116.540  1.00 69.58           C
ATOM   2249  C   MET C 423      92.027  79.959 116.024  1.00 69.58           C
ATOM   2250  O   MET C 423      92.252  79.329 114.991  1.00 69.58           O
ATOM   2251  CB  MET C 423      89.816  81.147 115.802  1.00 69.58           C
ATOM   2252  CG  MET C 423      89.423  80.844 114.388  1.00 69.58           C
ATOM   2253  SD  MET C 423      88.668  82.282 113.611  1.00 69.58           S
ATOM   2254  CE  MET C 423      87.152  82.426 114.517  1.00 69.58           C
ATOM   2255  N   ASN C 424      93.006  80.502 116.745  1.00 67.44           N
ATOM   2256  CA  ASN C 424      94.397  80.423 116.327  1.00 67.44           C
ATOM   2257  C   ASN C 424      95.195  79.370 117.086  1.00 67.44           C
ATOM   2258  O   ASN C 424      96.407  79.528 117.227  1.00 67.44           O
ATOM   2259  CB  ASN C 424      95.092  81.781 116.448  1.00 67.44           C
ATOM   2260  CG  ASN C 424      95.177  82.300 117.876  1.00 67.44           C
ATOM   2261  OD1 ASN C 424      94.653  81.719 118.815  1.00 67.44           O
ATOM   2262  ND2 ASN C 424      95.903  83.388 118.041  1.00 67.44           N
ATOM   2263  N   ARG C 425      94.546  78.324 117.600  1.00 67.67           N
ATOM   2264  CA  ARG C 425      95.265  77.323 118.381  1.00 67.67           C
ATOM   2265  C   ARG C 425      96.295  76.584 117.536  1.00 67.67           C
ATOM   2266  O   ARG C 425      97.412  76.327 117.992  1.00 67.67           O
ATOM   2267  CB  ARG C 425      94.289  76.340 119.018  1.00 67.67           C
ATOM   2268  CG  ARG C 425      94.980  75.284 119.844  1.00 67.67           C
ATOM   2269  CD  ARG C 425      94.028  74.388 120.574  1.00 67.67           C
ATOM   2270  NE  ARG C 425      93.361  75.076 121.665  1.00 67.67           N
ATOM   2271  CZ  ARG C 425      93.878  75.219 122.877  1.00 67.67           C
ATOM   2272  NH1 ARG C 425      95.070  74.725 123.155  1.00 67.67           N
ATOM   2273  NH2 ARG C 425      93.201  75.857 123.813  1.00 67.67           N
ATOM   2274  N   LEU C 426      95.966  76.294 116.287  1.00 63.49           N
ATOM   2275  CA  LEU C 426      96.935  75.662 115.409  1.00 63.49           C
ATOM   2276  C   LEU C 426      97.825  76.668 114.709  1.00 63.49           C
ATOM   2277  O   LEU C 426      99.002  76.386 114.485  1.00 63.49           O
ATOM   2278  CB  LEU C 426      96.226  74.810 114.361  1.00 63.49           C
ATOM   2279  CG  LEU C 426      95.338  73.710 114.924  1.00 63.49           C
ATOM   2280  CD1 LEU C 426      94.704  72.941 113.803  1.00 63.49           C
ATOM   2281  CD2 LEU C 426      96.101  72.802 115.848  1.00 63.49           C
ATOM   2282  N   THR C 427      97.305  77.833 114.360  1.00 62.66           N
ATOM   2283  CA  THR C 427      98.083  78.775 113.576  1.00 62.66           C
ATOM   2284  C   THR C 427      99.019  79.623 114.415  1.00 62.66           C
ATOM   2285  O   THR C 427      99.779  80.405 113.852  1.00 62.66           O
ATOM   2286  CB  THR C 427      97.167  79.686 112.775  1.00 62.66           C
ATOM   2287  OG1 THR C 427      96.403  80.498 113.666  1.00 62.66           O
ATOM   2288  CG2 THR C 427      96.229  78.871 111.927  1.00 62.66           C
ATOM   2289  N   ASP C 428      98.984  79.508 115.733  1.00 67.99           N
ATOM   2290  CA  ASP C 428      99.990  80.140 116.565  1.00 67.99           C
ATOM   2291  C   ASP C 428     100.971  79.111 117.108  1.00 67.99           C
ATOM   2292  O   ASP C 428     101.820  79.442 117.934  1.00 67.99           O
ATOM   2293  CB  ASP C 428      99.324  80.914 117.699  1.00 67.99           C
ATOM   2294  CG  ASP C 428     100.163  82.069 118.187  1.00 67.99           C
ATOM   2295  OD1 ASP C 428     101.243  82.312 117.614  1.00 67.99           O
ATOM   2296  OD2 ASP C 428      99.739  82.745 119.144  1.00 67.99           O
ATOM   2297  N   ASP C 429     100.866  77.869 116.651  1.00 66.43           N
ATOM   2298  CA  ASP C 429     101.725  76.779 117.069  1.00 66.43           C
ATOM   2299  C   ASP C 429     102.764  76.542 115.989  1.00 66.43           C
ATOM   2300  O   ASP C 429     102.387  76.285 114.839  1.00 66.43           O
ATOM   2301  CB  ASP C 429     100.883  75.528 117.285  1.00 66.43           C
ATOM   2302  CG  ASP C 429     101.630  74.394 117.963  1.00 66.43           C
ATOM   2303  OD1 ASP C 429     102.828  74.508 118.271  1.00 66.43           O
ATOM   2304  OD2 ASP C 429     100.991  73.354 118.199  1.00 66.43           O
ATOM   2305  N   PRO C 430     104.062  76.612 116.290  1.00 63.82           N
ATOM   2306  CA  PRO C 430     105.063  76.381 115.241  1.00 63.82           C
ATOM   2307  C   PRO C 430     105.192  74.938 114.813  1.00 63.82           C
ATOM   2308  O   PRO C 430     105.824  74.679 113.789  1.00 63.82           O
ATOM   2309  CB  PRO C 430     106.357  76.885 115.879  1.00 63.82           C
ATOM   2310  CG  PRO C 430     106.127  76.768 117.291  1.00 63.82           C
ATOM   2311  CD  PRO C 430     104.693  77.054 117.539  1.00 63.82           C
ATOM   2312  N   ARG C 431     104.606  73.993 115.545  1.00 67.23           N
ATOM   2313  CA  ARG C 431     104.553  72.617 115.079  1.00 67.23           C
ATOM   2314  C   ARG C 431     103.634  72.450 113.879  1.00 67.23           C
ATOM   2315  O   ARG C 431     103.752  71.460 113.157  1.00 67.23           O
ATOM   2316  CB  ARG C 431     104.111  71.706 116.217  1.00 67.23           C
ATOM   2317  CG  ARG C 431     105.149  71.589 117.316  1.00 67.23           C
ATOM   2318  CD  ARG C 431     104.641  70.824 118.518  1.00 67.23           C
ATOM   2319  NE  ARG C 431     104.331  69.430 118.221  1.00 67.23           N
ATOM   2320  CZ  ARG C 431     105.215  68.440 118.255  1.00 67.23           C
ATOM   2321  NH1 ARG C 431     106.480  68.680 118.561  1.00 67.23           N
ATOM   2322  NH2 ARG C 431     104.832  67.206 117.973  1.00 67.23           N
ATOM   2323  N   TRP C 432     102.732  73.393 113.647  1.00 61.60           N
ATOM   2324  CA  TRP C 432     101.857  73.387 112.491  1.00 61.60           C
ATOM   2325  C   TRP C 432     102.326  74.320 111.395  1.00 61.60           C
ATOM   2326  O   TRP C 432     101.690  74.381 110.346  1.00 61.60           O
ATOM   2327  CB  TRP C 432     100.446  73.756 112.922  1.00 61.60           C
ATOM   2328  CG  TRP C 432      99.794  72.667 113.653  1.00 61.60           C
ATOM   2329  CD1 TRP C 432      99.872  72.417 114.978  1.00 61.60           C
ATOM   2330  CD2 TRP C 432      98.922  71.686 113.107  1.00 61.60           C
ATOM   2331  NE1 TRP C 432      99.125  71.321 115.294  1.00 61.60           N
ATOM   2332  CE2 TRP C 432      98.525  70.856 114.158  1.00 61.60           C
ATOM   2333  CE3 TRP C 432      98.442  71.426 111.826  1.00 61.60           C
ATOM   2334  CZ2 TRP C 432      97.666  69.788 113.973  1.00 61.60           C
ATOM   2335  CZ3 TRP C 432      97.598  70.368 111.643  1.00 61.60           C
ATOM   2336  CH2 TRP C 432      97.219  69.559 112.708  1.00 61.60           C
ATOM   2337  N   LEU C 433     103.407  75.057 111.626  1.00 59.14           N
ATOM   2338  CA  LEU C 433     103.980  75.889 110.574  1.00 59.14           C
ATOM   2339  C   LEU C 433     104.458  75.121 109.339  1.00 59.14           C
ATOM   2340  O   LEU C 433     104.261  75.649 108.234  1.00 59.14           O
ATOM   2341  CB  LEU C 433     105.101  76.756 111.163  1.00 59.14           C
ATOM   2342  CG  LEU C 433     105.846  77.705 110.228  1.00 59.14           C
ATOM   2343  CD1 LEU C 433     104.900  78.690 109.600  1.00 59.14           C
ATOM   2344  CD2 LEU C 433     106.926  78.427 110.984  1.00 59.14           C
ATOM   2345  N   PRO C 434     105.063  73.920 109.419  1.00 60.24           N
ATOM   2346  CA  PRO C 434     105.320  73.184 108.168  1.00 60.24           C
ATOM   2347  C   PRO C 434     104.078  72.786 107.396  1.00 60.24           C
ATOM   2348  O   PRO C 434     104.101  72.815 106.163  1.00 60.24           O
ATOM   2349  CB  PRO C 434     106.089  71.953 108.649  1.00 60.24           C
ATOM   2350  CG  PRO C 434     106.756  72.390 109.828  1.00 60.24           C
ATOM   2351  CD  PRO C 434     105.830  73.301 110.519  1.00 60.24           C
ATOM   2352  N   ALA C 435     102.997  72.413 108.076  1.00 60.21           N
ATOM   2353  CA  ALA C 435     101.787  72.038 107.358  1.00 60.21           C
ATOM   2354  C   ALA C 435     101.115  73.253 106.741  1.00 60.21           C
ATOM   2355  O   ALA C 435     100.587  73.176 105.630  1.00 60.21           O
ATOM   2356  CB  ALA C 435     100.825  71.311 108.289  1.00 60.21           C
ATOM   2357  N   MET C 436     101.132  74.382 107.442  1.00 60.00           N
ATOM   2358  CA  MET C 436     100.539  75.592 106.896  1.00 60.00           C
ATOM   2359  C   MET C 436     101.363  76.162 105.760  1.00 60.00           C
ATOM   2360  O   MET C 436     100.799  76.735 104.827  1.00 60.00           O
ATOM   2361  CB  MET C 436     100.376  76.640 107.984  1.00 60.00           C
ATOM   2362  CG  MET C 436      99.292  76.348 108.968  1.00 60.00           C
ATOM   2363  SD  MET C 436      99.289  77.588 110.250  1.00 60.00           S
ATOM   2364  CE  MET C 436      98.871  79.035 109.292  1.00 60.00           C
ATOM   2365  N   SER C 437     102.686  76.020 105.816  1.00 59.43           N
ATOM   2366  CA  SER C 437     103.520  76.621 104.788  1.00 59.43           C
ATOM   2367  C   SER C 437     103.373  75.910 103.457  1.00 59.43           C
ATOM   2368  O   SER C 437     103.368  76.566 102.419  1.00 59.43           O
ATOM   2369  CB  SER C 437     104.982  76.643 105.217  1.00 59.43           C
ATOM   2370  OG  SER C 437     105.514  75.343 105.295  1.00 59.43           O
ATOM   2371  N   GLU C 438     103.190  74.604 103.495  1.00 63.71           N
ATOM   2372  CA  GLU C 438     103.017  73.836 102.284  1.00 63.71           C
ATOM   2373  C   GLU C 438     101.768  74.289 101.560  1.00 63.71           C
ATOM   2374  O   GLU C 438     101.752  74.378 100.351  1.00 63.71           O
ATOM   2375  CB  GLU C 438     102.896  72.359 102.617  1.00 63.71           C
ATOM   2376  CG  GLU C 438     104.132  71.778 103.263  1.00 63.71           C
ATOM   2377  CD  GLU C 438     105.103  71.218 102.250  1.00 63.71           C
ATOM   2378  OE1 GLU C 438     106.329  71.304 102.480  1.00 63.71           O
ATOM   2379  OE2 GLU C 438     104.639  70.686 101.221  1.00 63.71           O
ATOM   2380  N   ARG C 439     100.718  74.572 102.310  1.00 59.07           N
ATOM   2381  CA  ARG C 439      99.462  74.987 101.713  1.00 59.07           C
ATOM   2382  C   ARG C 439      99.548  76.362 101.084  1.00 59.07           C
ATOM   2383  O   ARG C 439      98.809  76.646 100.143  1.00 59.07           O
ATOM   2384  CB  ARG C 439      98.365  74.949 102.764  1.00 59.07           C
ATOM   2385  CG  ARG C 439      98.032  73.544 103.133  1.00 59.07           C
ATOM   2386  CD  ARG C 439      97.159  73.466 104.321  1.00 59.07           C
ATOM   2387  NE  ARG C 439      96.918  72.077 104.658  1.00 59.07           N
ATOM   2388  CZ  ARG C 439      95.849  71.400 104.280  1.00 59.07           C
ATOM   2389  NH1 ARG C 439      95.722  70.134 104.613  1.00 59.07           N
ATOM   2390  NH2 ARG C 439      94.900  71.999 103.595  1.00 59.07           N
ATOM   2391  N   VAL C 440     100.445  77.208 101.564  1.00 55.43           N
ATOM   2392  CA  VAL C 440     100.627  78.531 100.996  1.00 55.43           C
ATOM   2393  C   VAL C 440     101.641  78.514  99.866  1.00 55.43           C
ATOM   2394  O   VAL C 440     101.379  79.043  98.786  1.00 55.43           O
ATOM   2395  CB  VAL C 440     101.030  79.516 102.106  1.00 55.43           C
ATOM   2396  CG1 VAL C 440     101.444  80.815 101.521  1.00 55.43           C
ATOM   2397  CG2 VAL C 440      99.873  79.731 103.040  1.00 55.43           C
ATOM   2398  N   THR C 441     102.801  77.894 100.089  1.00 56.96           N
ATOM   2399  CA  THR C 441     103.882  77.957  99.112  1.00 56.96           C
ATOM   2400  C   THR C 441     103.553  77.189  97.844  1.00 56.96           C
ATOM   2401  O   THR C 441     103.955  77.604  96.758  1.00 56.96           O
ATOM   2402  CB  THR C 441     105.188  77.437  99.710  1.00 56.96           C
ATOM   2403  OG1 THR C 441     105.026  76.081 100.118  1.00 56.96           O
ATOM   2404  CG2 THR C 441     105.618  78.270 100.891  1.00 56.96           C
ATOM   2405  N   ARG C 442     102.803  76.102  97.946  1.00 59.47           N
ATOM   2406  CA  ARG C 442     102.455  75.354  96.752  1.00 59.47           C
ATOM   2407  C   ARG C 442     101.320  75.995  95.975  1.00 59.47           C
ATOM   2408  O   ARG C 442     101.196  75.741  94.778  1.00 59.47           O
ATOM   2409  CB  ARG C 442     102.110  73.918  97.119  1.00 59.47           C
ATOM   2410  CG  ARG C 442     103.295  73.194  97.697  1.00 59.47           C
ATOM   2411  CD  ARG C 442     102.967  71.813  98.177  1.00 59.47           C
ATOM   2412  NE  ARG C 442     102.663  70.910  97.081  1.00 59.47           N
ATOM   2413  CZ  ARG C 442     101.484  70.339  96.887  1.00 59.47           C
ATOM   2414  NH1 ARG C 442     100.487  70.555  97.726  1.00 59.47           N
ATOM   2415  NH2 ARG C 442     101.313  69.533  95.858  1.00 59.47           N
ATOM   2416  N   MET C 443     100.498  76.817  96.622  1.00 57.40           N
ATOM   2417  CA  MET C 443      99.520  77.611  95.892  1.00 57.40           C
ATOM   2418  C   MET C 443     100.202  78.676  95.051  1.00 57.40           C
ATOM   2419  O   MET C 443      99.871  78.855  93.876  1.00 57.40           O
ATOM   2420  CB  MET C 443      98.543  78.269  96.855  1.00 57.40           C
ATOM   2421  CG  MET C 443      97.617  79.234  96.163  1.00 57.40           C
ATOM   2422  SD  MET C 443      96.579  80.166  97.268  1.00 57.40           S
ATOM   2423  CE  MET C 443      97.774  81.215  98.070  1.00 57.40           C
ATOM   2424  N   VAL C 444     101.149  79.397  95.648  1.00 55.20           N
ATOM   2425  CA  VAL C 444     101.847  80.468  94.950  1.00 55.20           C
ATOM   2426  C   VAL C 444     102.678  79.908  93.808  1.00 55.20           C
ATOM   2427  O   VAL C 444     102.690  80.461  92.711  1.00 55.20           O
ATOM   2428  CB  VAL C 444     102.695  81.274  95.948  1.00 55.20           C
ATOM   2429  CG1 VAL C 444     103.550  82.285  95.242  1.00 55.20           C
ATOM   2430  CG2 VAL C 444     101.799  81.973  96.927  1.00 55.20           C
ATOM   2431  N   GLN C 445     103.319  78.765  94.021  1.00 59.98           N
ATOM   2432  CA  GLN C 445     104.100  78.152  92.957  1.00 59.98           C
ATOM   2433  C   GLN C 445     103.236  77.631  91.821  1.00 59.98           C
ATOM   2434  O   GLN C 445     103.690  77.597  90.678  1.00 59.98           O
ATOM   2435  CB  GLN C 445     104.960  77.041  93.528  1.00 59.98           C
ATOM   2436  CG  GLN C 445     106.196  77.564  94.167  1.00 59.98           C
ATOM   2437  CD  GLN C 445     107.035  76.489  94.778  1.00 59.98           C
ATOM   2438  OE1 GLN C 445     106.552  75.412  95.097  1.00 59.98           O
ATOM   2439  NE2 GLN C 445     108.326  76.731  94.833  1.00 59.98           N
ATOM   2440  N   ARG C 446     101.994  77.257  92.094  1.00 58.67           N
ATOM   2441  CA  ARG C 446     101.142  76.798  91.011  1.00 58.67           C
ATOM   2442  C   ARG C 446     100.577  77.961  90.206  1.00 58.67           C
ATOM   2443  O   ARG C 446     100.496  77.883  88.980  1.00 58.67           O
ATOM   2444  CB  ARG C 446      99.998  75.945  91.549  1.00 58.67           C
ATOM   2445  CG  ARG C 446      99.248  75.250  90.447  1.00 58.67           C
ATOM   2446  CD  ARG C 446      97.977  74.589  90.883  1.00 58.67           C
ATOM   2447  NE  ARG C 446      96.966  75.570  91.231  1.00 58.67           N
ATOM   2448  CZ  ARG C 446      95.730  75.274  91.599  1.00 58.67           C
ATOM   2449  NH1 ARG C 446      94.887  76.241  91.900  1.00 58.67           N
ATOM   2450  NH2 ARG C 446      95.324  74.020  91.629  1.00 58.67           N
ATOM   2451  N   ASP C 447     100.200  79.052  90.866  1.00 58.20           N
ATOM   2452  CA  ASP C 447      99.288  80.019  90.273  1.00 58.20           C
ATOM   2453  C   ASP C 447      99.880  81.402  90.054  1.00 58.20           C
ATOM   2454  O   ASP C 447      99.138  82.319  89.707  1.00 58.20           O
ATOM   2455  CB  ASP C 447      98.039  80.136  91.143  1.00 58.20           C
ATOM   2456  CG  ASP C 447      97.215  78.881  91.125  1.00 58.20           C
ATOM   2457  OD1 ASP C 447      97.213  78.192  90.093  1.00 58.20           O
ATOM   2458  OD2 ASP C 447      96.586  78.557  92.140  1.00 58.20           O
ATOM   2459  N   ARG C 448     101.186  81.583  90.218  1.00 59.36           N
ATOM   2460  CA  ARG C 448     101.755  82.923  90.155  1.00 59.36           C
ATOM   2461  C   ARG C 448     101.823  83.503  88.751  1.00 59.36           C
ATOM   2462  O   ARG C 448     102.060  84.702  88.622  1.00 59.36           O
ATOM   2463  CB  ARG C 448     103.151  82.934  90.752  1.00 59.36           C
ATOM   2464  CG  ARG C 448     104.127  82.066  90.018  1.00 59.36           C
ATOM   2465  CD  ARG C 448     105.438  82.052  90.732  1.00 59.36           C
ATOM   2466  NE  ARG C 448     106.001  83.387  90.783  1.00 59.36           N
ATOM   2467  CZ  ARG C 448     106.994  83.744  91.581  1.00 59.36           C
ATOM   2468  NH1 ARG C 448     107.543  82.855  92.388  1.00 59.36           N
ATOM   2469  NH2 ARG C 448     107.437  84.988  91.567  1.00 59.36           N
ATOM   2470  N   ASN C 449     101.629  82.712  87.707  1.00 61.40           N
ATOM   2471  CA  ASN C 449     101.720  83.259  86.364  1.00 61.40           C
ATOM   2472  C   ASN C 449     100.386  83.724  85.807  1.00 61.40           C
ATOM   2473  O   ASN C 449     100.367  84.310  84.725  1.00 61.40           O
ATOM   2474  CB  ASN C 449     102.327  82.242  85.403  1.00 61.40           C
ATOM   2475  CG  ASN C 449     103.783  81.993  85.672  1.00 61.40           C
ATOM   2476  OD1 ASN C 449     104.512  82.891  86.064  1.00 61.40           O
ATOM   2477  ND2 ASN C 449     104.223  80.779  85.428  1.00 61.40           N
TER    2478      ASN C 449
ATOM   2479  N   ILE D 351     129.309 118.449  93.402  1.00 48.50           N
ATOM   2480  CA  ILE D 351     129.507 119.890  93.320  1.00 48.50           C
ATOM   2481  C   ILE D 351     130.998 120.187  93.378  1.00 48.50           C
ATOM   2482  O   ILE D 351     131.655 119.939  94.387  1.00 48.50           O
ATOM   2483  CB  ILE D 351     128.754 120.618  94.436  1.00 48.50           C
ATOM   2484  CG1 ILE D 351     127.254 120.400  94.289  1.00 48.50           C
ATOM   2485  CG2 ILE D 351     129.100 122.078  94.450  1.00 48.50           C
ATOM   2486  CD1 ILE D 351     126.698 120.913  93.013  1.00 48.50           C
ATOM   2487  N   ARG D 352     131.533 120.699  92.281  1.00 47.57           N
ATOM   2488  CA  ARG D 352     132.899 121.194  92.209  1.00 47.57           C
ATOM   2489  C   ARG D 352     132.811 122.709  92.304  1.00 47.57           C
ATOM   2490  O   ARG D 352     132.897 123.425  91.321  1.00 47.57           O
ATOM   2491  CB  ARG D 352     133.534 120.743  90.913  1.00 47.57           C
ATOM   2492  CG  ARG D 352     133.682 119.271  90.821  1.00 47.57           C
ATOM   2493  CD  ARG D 352     133.985 118.854  89.440  1.00 47.57           C
ATOM   2494  NE  ARG D 352     134.442 117.477  89.355  1.00 47.57           N
ATOM   2495  CZ  ARG D 352     133.653 116.419  89.279  1.00 47.57           C
ATOM   2496  NH1 ARG D 352     132.343 116.554  89.304  1.00 47.57           N
ATOM   2497  NH2 ARG D 352     134.186 115.220  89.192  1.00 47.57           N
ATOM   2498  N   GLY D 353     132.594 123.202  93.515  1.00 44.80           N
ATOM   2499  CA  GLY D 353     132.171 124.565  93.711  1.00 44.80           C
ATOM   2500  C   GLY D 353     133.245 125.478  94.265  1.00 44.80           C
ATOM   2501  O   GLY D 353     134.258 125.052  94.802  1.00 44.80           O
ATOM   2502  N   VAL D 354     132.981 126.769  94.135  1.00 46.26           N
ATOM   2503  CA  VAL D 354     133.832 127.794  94.718  1.00 46.26           C
ATOM   2504  C   VAL D 354     132.948 128.954  95.152  1.00 46.26           C
ATOM   2505  O   VAL D 354     131.947 129.270  94.511  1.00 46.26           O
ATOM   2506  CB  VAL D 354     134.953 128.212  93.736  1.00 46.26           C
ATOM   2507  CG1 VAL D 354     134.412 128.862  92.492  1.00 46.26           C
ATOM   2508  CG2 VAL D 354     135.972 129.094  94.410  1.00 46.26           C
ATOM   2509  N   ASN D 355     133.277 129.530  96.294  1.00 51.48           N
ATOM   2510  CA  ASN D 355     132.679 130.775  96.733  1.00 51.48           C
ATOM   2511  C   ASN D 355     133.301 131.936  95.985  1.00 51.48           C
ATOM   2512  O   ASN D 355     134.506 131.960  95.753  1.00 51.48           O
ATOM   2513  CB  ASN D 355     132.911 130.947  98.219  1.00 51.48           C
ATOM   2514  CG  ASN D 355     132.046 130.061  99.044  1.00 51.48           C
ATOM   2515  OD1 ASN D 355     130.838 130.155  98.999  1.00 51.48           O
ATOM   2516  ND2 ASN D 355     132.656 129.127  99.739  1.00 51.48           N
ATOM   2517  N   ARG D 356     132.484 132.909  95.616  1.00 56.58           N
ATOM   2518  CA  ARG D 356     132.972 134.053  94.863  1.00 56.58           C
ATOM   2519  C   ARG D 356     132.336 135.326  95.384  1.00 56.58           C
ATOM   2520  O   ARG D 356     131.118 135.482  95.318  1.00 56.58           O
ATOM   2521  CB  ARG D 356     132.676 133.895  93.381  1.00 56.58           C
ATOM   2522  CG  ARG D 356     133.113 135.067  92.565  1.00 56.58           C
ATOM   2523  CD  ARG D 356     132.702 134.864  91.158  1.00 56.58           C
ATOM   2524  NE  ARG D 356     133.050 135.973  90.296  1.00 56.58           N
ATOM   2525  CZ  ARG D 356     132.242 136.992  90.054  1.00 56.58           C
ATOM   2526  NH1 ARG D 356     132.629 137.953  89.247  1.00 56.58           N
ATOM   2527  NH2 ARG D 356     131.048 137.042  90.615  1.00 56.58           N
ATOM   2528  N   HIS D 357     133.159 136.231  95.891  1.00 61.63           N
ATOM   2529  CA  HIS D 357     132.735 137.601  96.116  1.00 61.63           C
ATOM   2530  C   HIS D 357     132.847 138.419  94.844  1.00 61.63           C
ATOM   2531  O   HIS D 357     133.684 138.156  93.982  1.00 61.63           O
ATOM   2532  CB  HIS D 357     133.574 138.267  97.199  1.00 61.63           C
ATOM   2533  CG  HIS D 357     133.125 137.966  98.588  1.00 61.63           C
ATOM   2534  ND1 HIS D 357     132.020 138.565  99.150  1.00 61.63           N
ATOM   2535  CD2 HIS D 357     133.654 137.177  99.549  1.00 61.63           C
ATOM   2536  CE1 HIS D 357     131.871 138.135 100.388  1.00 61.63           C
ATOM   2537  NE2 HIS D 357     132.849 137.289 100.654  1.00 61.63           N
ATOM   2538  N   GLU D 358     131.996 139.426  94.740  1.00 65.13           N
ATOM   2539  CA  GLU D 358     132.132 140.443  93.706  1.00 65.13           C
ATOM   2540  C   GLU D 358     133.212 141.421  94.135  1.00 65.13           C
ATOM   2541  O   GLU D 358     132.990 142.268  94.996  1.00 65.13           O
ATOM   2542  CB  GLU D 358     130.811 141.154  93.472  1.00 65.13           C
ATOM   2543  CG  GLU D 358     129.832 140.353  92.677  1.00 65.13           C
ATOM   2544  CD  GLU D 358     128.545 141.096  92.435  1.00 65.13           C
ATOM   2545  OE1 GLU D 358     128.304 142.118  93.104  1.00 65.13           O
ATOM   2546  OE2 GLU D 358     127.791 140.688  91.537  1.00 65.13           O
ATOM   2547  N   HIS D 359     134.389 141.307  93.537  1.00 64.17           N
ATOM   2548  CA  HIS D 359     135.507 142.141  93.937  1.00 64.17           C
ATOM   2549  C   HIS D 359     136.354 142.477  92.728  1.00 64.17           C
ATOM   2550  O   HIS D 359     136.655 141.604  91.915  1.00 64.17           O
ATOM   2551  CB  HIS D 359     136.368 141.447  94.985  1.00 64.17           C
ATOM   2552  CG  HIS D 359     137.546 142.253  95.415  1.00 64.17           C
ATOM   2553  ND1 HIS D 359     137.451 143.281  96.324  1.00 64.17           N
ATOM   2554  CD2 HIS D 359     138.839 142.212  95.025  1.00 64.17           C
ATOM   2555  CE1 HIS D 359     138.642 143.819  96.498  1.00 64.17           C
ATOM   2556  NE2 HIS D 359     139.500 143.192  95.717  1.00 64.17           N
ATOM   2557  N   HIS D 360     136.732 143.740  92.621  1.00 67.73           N
ATOM   2558  CA  HIS D 360     137.699 144.187  91.647  1.00 67.73           C
ATOM   2559  C   HIS D 360     138.714 145.024  92.413  1.00 67.73           C
ATOM   2560  O   HIS D 360     138.320 145.845  93.250  1.00 67.73           O
ATOM   2561  CB  HIS D 360     137.037 145.002  90.541  1.00 67.73           C
ATOM   2562  CG  HIS D 360     137.928 145.258  89.373  1.00 67.73           C
ATOM   2563  ND1 HIS D 360     138.842 146.285  89.347  1.00 67.73           N
ATOM   2564  CD2 HIS D 360     138.048 144.618  88.188  1.00 67.73           C
ATOM   2565  CE1 HIS D 360     139.492 146.264  88.199  1.00 67.73           C
ATOM   2566  NE2 HIS D 360     139.026 145.263  87.476  1.00 67.73           N
ATOM   2567  N   PRO D 361     140.015 144.840  92.181  1.00 67.32           N
ATOM   2568  CA  PRO D 361     141.011 145.535  93.009  1.00 67.32           C
ATOM   2569  C   PRO D 361     141.081 147.028  92.769  1.00 67.32           C
ATOM   2570  O   PRO D 361     141.520 147.758  93.662  1.00 67.32           O
ATOM   2571  CB  PRO D 361     142.322 144.858  92.614  1.00 67.32           C
ATOM   2572  CG  PRO D 361     142.083 144.387  91.247  1.00 67.32           C
ATOM   2573  CD  PRO D 361     140.653 143.985  91.171  1.00 67.32           C
ATOM   2574  N   LEU D 362     140.660 147.507  91.606  1.00 71.25           N
ATOM   2575  CA  LEU D 362     140.651 148.930  91.311  1.00 71.25           C
ATOM   2576  C   LEU D 362     139.308 149.581  91.576  1.00 71.25           C
ATOM   2577  O   LEU D 362     139.262 150.716  92.051  1.00 71.25           O
ATOM   2578  CB  LEU D 362     141.038 149.167  89.853  1.00 71.25           C
ATOM   2579  CG  LEU D 362     142.484 148.825  89.528  1.00 71.25           C
ATOM   2580  CD1 LEU D 362     142.726 148.920  88.039  1.00 71.25           C
ATOM   2581  CD2 LEU D 362     143.399 149.760  90.281  1.00 71.25           C
ATOM   2582  N   HIS D 363     138.215 148.888  91.290  1.00 70.21           N
ATOM   2583  CA  HIS D 363     136.892 149.481  91.355  1.00 70.21           C
ATOM   2584  C   HIS D 363     136.093 149.000  92.550  1.00 70.21           C
ATOM   2585  O   HIS D 363     134.914 149.333  92.662  1.00 70.21           O
ATOM   2586  CB  HIS D 363     136.135 149.192  90.067  1.00 70.21           C
ATOM   2587  CG  HIS D 363     136.847 149.666  88.847  1.00 70.21           C
ATOM   2588  ND1 HIS D 363     137.028 151.001  88.566  1.00 70.21           N
ATOM   2589  CD2 HIS D 363     137.423 148.985  87.831  1.00 70.21           C
ATOM   2590  CE1 HIS D 363     137.692 151.121  87.433  1.00 70.21           C
ATOM   2591  NE2 HIS D 363     137.940 149.913  86.964  1.00 70.21           N
ATOM   2592  N   GLY D 364     136.702 148.236  93.444  1.00 67.29           N
ATOM   2593  CA  GLY D 364     136.005 147.759  94.616  1.00 67.29           C
ATOM   2594  C   GLY D 364     134.966 146.712  94.294  1.00 67.29           C
ATOM   2595  O   GLY D 364     135.284 145.655  93.755  1.00 67.29           O
ATOM   2596  N   GLN D 365     133.709 147.010  94.595  1.00 65.86           N
ATOM   2597  CA  GLN D 365     132.630 146.052  94.439  1.00 65.86           C
ATOM   2598  C   GLN D 365     131.788 146.324  93.205  1.00 65.86           C
ATOM   2599  O   GLN D 365     130.634 145.900  93.141  1.00 65.86           O
ATOM   2600  CB  GLN D 365     131.789 146.044  95.708  1.00 65.86           C
ATOM   2601  CG  GLN D 365     132.615 145.556  96.869  1.00 65.86           C
ATOM   2602  CD  GLN D 365     131.925 145.661  98.190  1.00 65.86           C
ATOM   2603  OE1 GLN D 365     130.827 146.194  98.290  1.00 65.86           O
ATOM   2604  NE2 GLN D 365     132.569 145.150  99.225  1.00 65.86           N
ATOM   2605  N   VAL D 366     132.355 146.993  92.214  1.00 66.89           N
ATOM   2606  CA  VAL D 366     131.684 147.276  90.956  1.00 66.89           C
ATOM   2607  C   VAL D 366     132.150 146.253  89.936  1.00 66.89           C
ATOM   2608  O   VAL D 366     133.344 146.161  89.642  1.00 66.89           O
ATOM   2609  CB  VAL D 366     131.979 148.701  90.480  1.00 66.89           C
ATOM   2610  CG1 VAL D 366     131.366 148.944  89.130  1.00 66.89           C
ATOM   2611  CG2 VAL D 366     131.447 149.665  91.478  1.00 66.89           C
ATOM   2612  N   MET D 367     131.214 145.492  89.391  1.00 72.85           N
ATOM   2613  CA  MET D 367     131.526 144.417  88.466  1.00 72.85           C
ATOM   2614  C   MET D 367     131.048 144.759  87.069  1.00 72.85           C
ATOM   2615  O   MET D 367     129.910 145.193  86.887  1.00 72.85           O
ATOM   2616  CB  MET D 367     130.889 143.106  88.912  1.00 72.85           C
ATOM   2617  CG  MET D 367     131.480 142.544  90.163  1.00 72.85           C
ATOM   2618  SD  MET D 367     133.254 142.326  90.008  1.00 72.85           S
ATOM   2619  CE  MET D 367     133.292 141.158  88.672  1.00 72.85           C
ATOM   2620  N   ASP D 368     131.915 144.552  86.091  1.00 74.82           N
ATOM   2621  CA  ASP D 368     131.559 144.654  84.689  1.00 74.82           C
ATOM   2622  C   ASP D 368     131.549 143.270  84.058  1.00 74.82           C
ATOM   2623  O   ASP D 368     131.921 142.278  84.683  1.00 74.82           O
ATOM   2624  CB  ASP D 368     132.519 145.582  83.948  1.00 74.82           C
ATOM   2625  CG  ASP D 368     133.964 145.198  84.133  1.00 74.82           C
ATOM   2626  OD1 ASP D 368     134.263 144.338  84.981  1.00 74.82           O
ATOM   2627  OD2 ASP D 368     134.813 145.750  83.409  1.00 74.82           O
ATOM   2628  N   GLU D 369     131.124 143.221  82.795  1.00 73.01           N
ATOM   2629  CA  GLU D 369     130.951 141.943  82.117  1.00 73.01           C
ATOM   2630  C   GLU D 369     132.277 141.255  81.842  1.00 73.01           C
ATOM   2631  O   GLU D 369     132.361 140.029  81.944  1.00 73.01           O
ATOM   2632  CB  GLU D 369     130.181 142.141  80.817  1.00 73.01           C
ATOM   2633  CG  GLU D 369     129.869 140.857  80.086  1.00 73.01           C
ATOM   2634  CD  GLU D 369     128.934 141.055  78.924  1.00 73.01           C
ATOM   2635  OE1 GLU D 369     128.512 142.205  78.693  1.00 73.01           O
ATOM   2636  OE2 GLU D 369     128.613 140.058  78.244  1.00 73.01           O
ATOM   2637  N   GLN D 370     133.322 142.022  81.539  1.00 73.18           N
ATOM   2638  CA  GLN D 370     134.594 141.432  81.142  1.00 73.18           C
ATOM   2639  C   GLN D 370     135.269 140.712  82.295  1.00 73.18           C
ATOM   2640  O   GLN D 370     135.917 139.686  82.083  1.00 73.18           O
ATOM   2641  CB  GLN D 370     135.526 142.502  80.581  1.00 73.18           C
ATOM   2642  CG  GLN D 370     135.233 142.925  79.148  1.00 73.18           C
ATOM   2643  CD  GLN D 370     133.948 143.719  79.004  1.00 73.18           C
ATOM   2644  OE1 GLN D 370     133.055 143.343  78.247  1.00 73.18           O
ATOM   2645  NE2 GLN D 370     133.837 144.806  79.760  1.00 73.18           N
ATOM   2646  N   THR D 371     135.115 141.214  83.514  1.00 69.49           N
ATOM   2647  CA  THR D 371     135.665 140.513  84.660  1.00 69.49           C
ATOM   2648  C   THR D 371     134.834 139.283  85.002  1.00 69.49           C
ATOM   2649  O   THR D 371     135.384 138.271  85.441  1.00 69.49           O
ATOM   2650  CB  THR D 371     135.760 141.467  85.846  1.00 69.49           C
ATOM   2651  OG1 THR D 371     136.439 142.653  85.431  1.00 69.49           O
ATOM   2652  CG2 THR D 371     136.564 140.858  86.968  1.00 69.49           C
ATOM   2653  N   MET D 372     133.519 139.342  84.779  1.00 66.04           N
ATOM   2654  CA  MET D 372     132.672 138.178  85.014  1.00 66.04           C
ATOM   2655  C   MET D 372     132.977 137.060  84.036  1.00 66.04           C
ATOM   2656  O   MET D 372     133.005 135.890  84.424  1.00 66.04           O
ATOM   2657  CB  MET D 372     131.204 138.543  84.895  1.00 66.04           C
ATOM   2658  CG  MET D 372     130.690 139.461  85.927  1.00 66.04           C
ATOM   2659  SD  MET D 372     128.959 139.735  85.595  1.00 66.04           S
ATOM   2660  CE  MET D 372     128.688 141.082  86.698  1.00 66.04           C
ATOM   2661  N   VAL D 373     133.172 137.397  82.763  1.00 63.88           N
ATOM   2662  CA  VAL D 373     133.504 136.386  81.772  1.00 63.88           C
ATOM   2663  C   VAL D 373     134.883 135.814  82.049  1.00 63.88           C
ATOM   2664  O   VAL D 373     135.097 134.608  81.927  1.00 63.88           O
ATOM   2665  CB  VAL D 373     133.386 136.976  80.355  1.00 63.88           C
ATOM   2666  CG1 VAL D 373     133.864 136.002  79.311  1.00 63.88           C
ATOM   2667  CG2 VAL D 373     131.960 137.334  80.073  1.00 63.88           C
ATOM   2668  N   GLN D 374     135.810 136.657  82.504  1.00 64.23           N
ATOM   2669  CA  GLN D 374     137.143 136.193  82.868  1.00 64.23           C
ATOM   2670  C   GLN D 374     137.099 135.223  84.041  1.00 64.23           C
ATOM   2671  O   GLN D 374     137.847 134.243  84.066  1.00 64.23           O
ATOM   2672  CB  GLN D 374     138.028 137.386  83.208  1.00 64.23           C
ATOM   2673  CG  GLN D 374     139.470 137.037  83.443  1.00 64.23           C
ATOM   2674  CD  GLN D 374     140.300 138.232  83.833  1.00 64.23           C
ATOM   2675  OE1 GLN D 374     139.778 139.319  84.052  1.00 64.23           O
ATOM   2676  NE2 GLN D 374     141.605 138.042  83.905  1.00 64.23           N
ATOM   2677  N   ASP D 375     136.211 135.463  85.006  1.00 60.92           N
ATOM   2678  CA  ASP D 375     136.082 134.545  86.129  1.00 60.92           C
ATOM   2679  C   ASP D 375     135.486 133.214  85.701  1.00 60.92           C
ATOM   2680  O   ASP D 375     135.974 132.163  86.116  1.00 60.92           O
ATOM   2681  CB  ASP D 375     135.239 135.156  87.242  1.00 60.92           C
ATOM   2682  CG  ASP D 375     135.995 136.172  88.055  1.00 60.92           C
ATOM   2683  OD1 ASP D 375     137.232 136.107  88.081  1.00 60.92           O
ATOM   2684  OD2 ASP D 375     135.353 137.014  88.707  1.00 60.92           O
ATOM   2685  N   ILE D 376     134.453 133.237  84.859  1.00 57.77           N
ATOM   2686  CA  ILE D 376     133.757 132.012  84.481  1.00 57.77           C
ATOM   2687  C   ILE D 376     134.637 131.125  83.619  1.00 57.77           C
ATOM   2688  O   ILE D 376     134.632 129.900  83.774  1.00 57.77           O
ATOM   2689  CB  ILE D 376     132.429 132.354  83.789  1.00 57.77           C
ATOM   2690  CG1 ILE D 376     131.486 132.939  84.809  1.00 57.77           C
ATOM   2691  CG2 ILE D 376     131.766 131.148  83.184  1.00 57.77           C
ATOM   2692  CD1 ILE D 376     130.270 133.469  84.236  1.00 57.77           C
ATOM   2693  N   LEU D 377     135.441 131.722  82.737  1.00 57.52           N
ATOM   2694  CA  LEU D 377     136.347 130.913  81.935  1.00 57.52           C
ATOM   2695  C   LEU D 377     137.415 130.265  82.801  1.00 57.52           C
ATOM   2696  O   LEU D 377     137.668 129.073  82.663  1.00 57.52           O
ATOM   2697  CB  LEU D 377     137.001 131.732  80.830  1.00 57.52           C
ATOM   2698  CG  LEU D 377     136.116 132.420  79.797  1.00 57.52           C
ATOM   2699  CD1 LEU D 377     136.939 132.984  78.658  1.00 57.52           C
ATOM   2700  CD2 LEU D 377     134.986 131.580  79.321  1.00 57.52           C
ATOM   2701  N   LEU D 378     137.996 131.014  83.738  1.00 55.95           N
ATOM   2702  CA  LEU D 378     138.994 130.439  84.636  1.00 55.95           C
ATOM   2703  C   LEU D 378     138.418 129.370  85.547  1.00 55.95           C
ATOM   2704  O   LEU D 378     139.122 128.423  85.897  1.00 55.95           O
ATOM   2705  CB  LEU D 378     139.632 131.523  85.487  1.00 55.95           C
ATOM   2706  CG  LEU D 378     140.636 132.434  84.821  1.00 55.95           C
ATOM   2707  CD1 LEU D 378     141.000 133.528  85.782  1.00 55.95           C
ATOM   2708  CD2 LEU D 378     141.844 131.619  84.468  1.00 55.95           C
ATOM   2709  N   MET D 379     137.155 129.503  85.942  1.00 54.53           N
ATOM   2710  CA  MET D 379     136.524 128.478  86.760  1.00 54.53           C
ATOM   2711  C   MET D 379     136.325 127.190  85.984  1.00 54.53           C
ATOM   2712  O   MET D 379     136.638 126.107  86.481  1.00 54.53           O
ATOM   2713  CB  MET D 379     135.195 128.981  87.292  1.00 54.53           C
ATOM   2714  CG  MET D 379     135.344 129.965  88.389  1.00 54.53           C
ATOM   2715  SD  MET D 379     133.787 130.710  88.803  1.00 54.53           S
ATOM   2716  CE  MET D 379     134.342 131.819  90.057  1.00 54.53           C
ATOM   2717  N   LYS D 380     135.811 127.284  84.764  1.00 54.08           N
ATOM   2718  CA  LYS D 380     135.539 126.073  84.010  1.00 54.08           C
ATOM   2719  C   LYS D 380     136.811 125.437  83.481  1.00 54.08           C
ATOM   2720  O   LYS D 380     136.874 124.215  83.353  1.00 54.08           O
ATOM   2721  CB  LYS D 380     134.566 126.366  82.881  1.00 54.08           C
ATOM   2722  CG  LYS D 380     133.192 126.684  83.384  1.00 54.08           C
ATOM   2723  CD  LYS D 380     132.230 126.849  82.260  1.00 54.08           C
ATOM   2724  CE  LYS D 380     131.925 125.517  81.632  1.00 54.08           C
ATOM   2725  NZ  LYS D 380     131.177 124.632  82.537  1.00 54.08           N
ATOM   2726  N   GLN D 381     137.844 126.230  83.214  1.00 55.41           N
ATOM   2727  CA  GLN D 381     139.131 125.674  82.822  1.00 55.41           C
ATOM   2728  C   GLN D 381     139.852 124.995  83.971  1.00 55.41           C
ATOM   2729  O   GLN D 381     140.823 124.282  83.733  1.00 55.41           O
ATOM   2730  CB  GLN D 381     140.010 126.768  82.235  1.00 55.41           C
ATOM   2731  CG  GLN D 381     139.542 127.242  80.888  1.00 55.41           C
ATOM   2732  CD  GLN D 381     140.191 128.530  80.480  1.00 55.41           C
ATOM   2733  OE1 GLN D 381     141.064 129.038  81.167  1.00 55.41           O
ATOM   2734  NE2 GLN D 381     139.712 129.110  79.397  1.00 55.41           N
ATOM   2735  N   ASN D 382     139.399 125.189  85.198  1.00 50.40           N
ATOM   2736  CA  ASN D 382     139.973 124.555  86.369  1.00 50.40           C
ATOM   2737  C   ASN D 382     138.993 123.595  87.018  1.00 50.40           C
ATOM   2738  O   ASN D 382     139.061 123.351  88.219  1.00 50.40           O
ATOM   2739  CB  ASN D 382     140.436 125.633  87.334  1.00 50.40           C
ATOM   2740  CG  ASN D 382     141.644 126.342  86.826  1.00 50.40           C
ATOM   2741  OD1 ASN D 382     142.664 125.727  86.581  1.00 50.40           O
ATOM   2742  ND2 ASN D 382     141.500 127.613  86.534  1.00 50.40           N
ATOM   2743  N   ASN D 383     138.056 123.091  86.216  1.00 48.72           N
ATOM   2744  CA  ASN D 383     137.139 122.004  86.554  1.00 48.72           C
ATOM   2745  C   ASN D 383     136.187 122.362  87.686  1.00 48.72           C
ATOM   2746  O   ASN D 383     135.777 121.499  88.450  1.00 48.72           O
ATOM   2747  CB  ASN D 383     137.890 120.712  86.878  1.00 48.72           C
ATOM   2748  CG  ASN D 383     138.621 120.165  85.696  1.00 48.72           C
ATOM   2749  OD1 ASN D 383     138.129 120.212  84.584  1.00 48.72           O
ATOM   2750  ND2 ASN D 383     139.800 119.638  85.926  1.00 48.72           N
ATOM   2751  N   PHE D 384     135.818 123.625  87.807  1.00 46.26           N
ATOM   2752  CA  PHE D 384     134.722 124.010  88.679  1.00 46.26           C
ATOM   2753  C   PHE D 384     133.420 123.970  87.896  1.00 46.26           C
ATOM   2754  O   PHE D 384     133.382 124.346  86.728  1.00 46.26           O
ATOM   2755  CB  PHE D 384     134.943 125.407  89.253  1.00 46.26           C
ATOM   2756  CG  PHE D 384     136.027 125.482  90.276  1.00 46.26           C
ATOM   2757  CD1 PHE D 384     135.766 125.194  91.597  1.00 46.26           C
ATOM   2758  CD2 PHE D 384     137.305 125.837  89.919  1.00 46.26           C
ATOM   2759  CE1 PHE D 384     136.758 125.264  92.534  1.00 46.26           C
ATOM   2760  CE2 PHE D 384     138.298 125.904  90.856  1.00 46.26           C
ATOM   2761  CZ  PHE D 384     138.022 125.618  92.162  1.00 46.26           C
ATOM   2762  N   ASN D 385     132.357 123.496  88.531  1.00 47.52           N
ATOM   2763  CA  ASN D 385     131.050 123.536  87.899  1.00 47.52           C
ATOM   2764  C   ASN D 385     130.005 124.295  88.701  1.00 47.52           C
ATOM   2765  O   ASN D 385     128.845 124.325  88.294  1.00 47.52           O
ATOM   2766  CB  ASN D 385     130.545 122.118  87.572  1.00 47.52           C
ATOM   2767  CG  ASN D 385     130.353 121.223  88.792  1.00 47.52           C
ATOM   2768  OD1 ASN D 385     130.494 121.626  89.931  1.00 47.52           O
ATOM   2769  ND2 ASN D 385     130.017 119.981  88.532  1.00 47.52           N
ATOM   2770  N   ALA D 386     130.369 124.897  89.823  1.00 45.26           N
ATOM   2771  CA  ALA D 386     129.377 125.532  90.666  1.00 45.26           C
ATOM   2772  C   ALA D 386     129.975 126.747  91.347  1.00 45.26           C
ATOM   2773  O   ALA D 386     131.171 126.799  91.612  1.00 45.26           O
ATOM   2774  CB  ALA D 386     128.821 124.567  91.704  1.00 45.26           C
ATOM   2775  N   VAL D 387     129.137 127.747  91.587  1.00 47.26           N
ATOM   2776  CA  VAL D 387     129.539 128.987  92.238  1.00 47.26           C
ATOM   2777  C   VAL D 387     128.515 129.296  93.314  1.00 47.26           C
ATOM   2778  O   VAL D 387     127.312 129.213  93.067  1.00 47.26           O
ATOM   2779  CB  VAL D 387     129.635 130.169  91.253  1.00 47.26           C
ATOM   2780  CG1 VAL D 387     130.120 131.405  91.949  1.00 47.26           C
ATOM   2781  CG2 VAL D 387     130.552 129.878  90.142  1.00 47.26           C
ATOM   2782  N   ARG D 388     128.981 129.646  94.498  1.00 52.52           N
ATOM   2783  CA  ARG D 388     128.112 130.144  95.547  1.00 52.52           C
ATOM   2784  C   ARG D 388     128.258 131.653  95.633  1.00 52.52           C
ATOM   2785  O   ARG D 388     129.371 132.170  95.734  1.00 52.52           O
ATOM   2786  CB  ARG D 388     128.434 129.467  96.873  1.00 52.52           C
ATOM   2787  CG  ARG D 388     127.601 129.911  98.032  1.00 52.52           C
ATOM   2788  CD  ARG D 388     127.768 128.954  99.177  1.00 52.52           C
ATOM   2789  NE  ARG D 388     127.094 129.414 100.377  1.00 52.52           N
ATOM   2790  CZ  ARG D 388     127.704 130.035 101.376  1.00 52.52           C
ATOM   2791  NH1 ARG D 388     129.006 130.238 101.329  1.00 52.52           N
ATOM   2792  NH2 ARG D 388     127.019 130.427 102.436  1.00 52.52           N
ATOM   2793  N   CYS D 389     127.136 132.354  95.552  1.00 59.50           N
ATOM   2794  CA  CYS D 389     127.098 133.814  95.565  1.00 59.50           C
ATOM   2795  C   CYS D 389     127.273 134.277  96.998  1.00 59.50           C
ATOM   2796  O   CYS D 389     126.308 134.534  97.704  1.00 59.50           O
ATOM   2797  CB  CYS D 389     125.779 134.319  95.002  1.00 59.50           C
ATOM   2798  SG  CYS D 389     125.424 133.804  93.342  1.00 59.50           S
ATOM   2799  N   SER D 390     128.514 134.403  97.435  1.00 58.55           N
ATOM   2800  CA  SER D 390     128.811 134.653  98.837  1.00 58.55           C
ATOM   2801  C   SER D 390     128.989 136.148  99.085  1.00 58.55           C
ATOM   2802  O   SER D 390     129.829 136.778  98.443  1.00 58.55           O
ATOM   2803  CB  SER D 390     130.066 133.893  99.238  1.00 58.55           C
ATOM   2804  OG  SER D 390     131.193 134.399  98.561  1.00 58.55           O
ATOM   2805  N   HIS D 391     128.184 136.726  99.984  1.00 59.13           N
ATOM   2806  CA  HIS D 391     126.974 136.121 100.524  1.00 59.13           C
ATOM   2807  C   HIS D 391     125.844 137.104 100.336  1.00 59.13           C
ATOM   2808  O   HIS D 391     125.380 137.697 101.301  1.00 59.13           O
ATOM   2809  CB  HIS D 391     127.118 135.834 102.012  1.00 59.13           C
ATOM   2810  CG  HIS D 391     128.307 135.009 102.365  1.00 59.13           C
ATOM   2811  ND1 HIS D 391     128.344 133.646 102.193  1.00 59.13           N
ATOM   2812  CD2 HIS D 391     129.510 135.361 102.871  1.00 59.13           C
ATOM   2813  CE1 HIS D 391     129.517 133.192 102.585  1.00 59.13           C
ATOM   2814  NE2 HIS D 391     130.243 134.212 102.999  1.00 59.13           N
ATOM   2815  N   TYR D 392     125.352 137.200  99.120  1.00 58.58           N
ATOM   2816  CA  TYR D 392     124.419 138.221  98.665  1.00 58.58           C
ATOM   2817  C   TYR D 392     124.045 137.925  97.223  1.00 58.58           C
ATOM   2818  O   TYR D 392     124.791 137.217  96.545  1.00 58.58           O
ATOM   2819  CB  TYR D 392     125.001 139.637  98.812  1.00 58.58           C
ATOM   2820  CG  TYR D 392     126.421 139.832  98.361  1.00 58.58           C
ATOM   2821  CD1 TYR D 392     127.440 139.914  99.290  1.00 58.58           C
ATOM   2822  CD2 TYR D 392     126.749 139.919  97.023  1.00 58.58           C
ATOM   2823  CE1 TYR D 392     128.732 140.087  98.905  1.00 58.58           C
ATOM   2824  CE2 TYR D 392     128.045 140.081  96.627  1.00 58.58           C
ATOM   2825  CZ  TYR D 392     129.032 140.168  97.576  1.00 58.58           C
ATOM   2826  OH  TYR D 392     130.336 140.336  97.195  1.00 58.58           O
ATOM   2827  N   PRO D 393     122.909 138.414  96.726  1.00 58.02           N
ATOM   2828  CA  PRO D 393     122.603 138.233  95.307  1.00 58.02           C
ATOM   2829  C   PRO D 393     123.570 139.013  94.443  1.00 58.02           C
ATOM   2830  O   PRO D 393     123.943 140.139  94.766  1.00 58.02           O
ATOM   2831  CB  PRO D 393     121.183 138.784  95.183  1.00 58.02           C
ATOM   2832  CG  PRO D 393     120.644 138.723  96.528  1.00 58.02           C
ATOM   2833  CD  PRO D 393     121.766 139.003  97.436  1.00 58.02           C
ATOM   2834  N   ASN D 394     123.999 138.401  93.351  1.00 61.49           N
ATOM   2835  CA  ASN D 394     124.953 139.093  92.513  1.00 61.49           C
ATOM   2836  C   ASN D 394     124.269 140.056  91.560  1.00 61.49           C
ATOM   2837  O   ASN D 394     123.051 140.233  91.557  1.00 61.49           O
ATOM   2838  CB  ASN D 394     125.817 138.131  91.708  1.00 61.49           C
ATOM   2839  CG  ASN D 394     126.856 137.459  92.539  1.00 61.49           C
ATOM   2840  OD1 ASN D 394     127.112 136.284  92.390  1.00 61.49           O
ATOM   2841  ND2 ASN D 394     127.407 138.186  93.486  1.00 61.49           N
ATOM   2842  N   HIS D 395     125.113 140.710  90.785  1.00 65.27           N
ATOM   2843  CA  HIS D 395     124.719 141.479  89.623  1.00 65.27           C
ATOM   2844  C   HIS D 395     123.903 140.599  88.680  1.00 65.27           C
ATOM   2845  O   HIS D 395     124.213 139.415  88.530  1.00 65.27           O
ATOM   2846  CB  HIS D 395     125.991 141.976  88.941  1.00 65.27           C
ATOM   2847  CG  HIS D 395     125.767 142.937  87.826  1.00 65.27           C
ATOM   2848  ND1 HIS D 395     125.412 142.534  86.560  1.00 65.27           N
ATOM   2849  CD2 HIS D 395     125.915 144.278  87.767  1.00 65.27           C
ATOM   2850  CE1 HIS D 395     125.307 143.591  85.778  1.00 65.27           C
ATOM   2851  NE2 HIS D 395     125.610 144.663  86.485  1.00 65.27           N
ATOM   2852  N   PRO D 396     122.852 141.129  88.051  1.00 63.81           N
ATOM   2853  CA  PRO D 396     121.939 140.269  87.280  1.00 63.81           C
ATOM   2854  C   PRO D 396     122.556 139.634  86.055  1.00 63.81           C
ATOM   2855  O   PRO D 396     122.064 138.593  85.612  1.00 63.81           O
ATOM   2856  CB  PRO D 396     120.816 141.230  86.883  1.00 63.81           C
ATOM   2857  CG  PRO D 396     120.880 142.301  87.870  1.00 63.81           C
ATOM   2858  CD  PRO D 396     122.316 142.488  88.194  1.00 63.81           C
ATOM   2859  N   LEU D 397     123.623 140.205  85.507  1.00 62.64           N
ATOM   2860  CA  LEU D 397     124.283 139.615  84.354  1.00 62.64           C
ATOM   2861  C   LEU D 397     125.028 138.337  84.708  1.00 62.64           C
ATOM   2862  O   LEU D 397     125.247 137.499  83.830  1.00 62.64           O
ATOM   2863  CB  LEU D 397     125.228 140.640  83.745  1.00 62.64           C
ATOM   2864  CG  LEU D 397     125.960 140.320  82.455  1.00 62.64           C
ATOM   2865  CD1 LEU D 397     124.962 140.032  81.369  1.00 62.64           C
ATOM   2866  CD2 LEU D 397     126.804 141.494  82.098  1.00 62.64           C
ATOM   2867  N   TRP D 398     125.393 138.166  85.978  1.00 57.11           N
ATOM   2868  CA  TRP D 398     126.114 136.980  86.417  1.00 57.11           C
ATOM   2869  C   TRP D 398     125.301 135.714  86.218  1.00 57.11           C
ATOM   2870  O   TRP D 398     125.838 134.686  85.804  1.00 57.11           O
ATOM   2871  CB  TRP D 398     126.499 137.136  87.878  1.00 57.11           C
ATOM   2872  CG  TRP D 398     127.146 135.958  88.444  1.00 57.11           C
ATOM   2873  CD1 TRP D 398     126.605 135.078  89.315  1.00 57.11           C
ATOM   2874  CD2 TRP D 398     128.463 135.502  88.176  1.00 57.11           C
ATOM   2875  NE1 TRP D 398     127.505 134.104  89.621  1.00 57.11           N
ATOM   2876  CE2 TRP D 398     128.659 134.343  88.928  1.00 57.11           C
ATOM   2877  CE3 TRP D 398     129.500 135.969  87.373  1.00 57.11           C
ATOM   2878  CZ2 TRP D 398     129.845 133.639  88.903  1.00 57.11           C
ATOM   2879  CZ3 TRP D 398     130.672 135.278  87.356  1.00 57.11           C
ATOM   2880  CH2 TRP D 398     130.839 134.123  88.111  1.00 57.11           C
ATOM   2881  N   TYR D 399     124.001 135.779  86.486  1.00 57.93           N
ATOM   2882  CA  TYR D 399     123.154 134.607  86.338  1.00 57.93           C
ATOM   2883  C   TYR D 399     122.939 134.266  84.879  1.00 57.93           C
ATOM   2884  O   TYR D 399     122.834 133.091  84.536  1.00 57.93           O
ATOM   2885  CB  TYR D 399     121.819 134.842  87.026  1.00 57.93           C
ATOM   2886  CG  TYR D 399     121.980 135.177  88.470  1.00 57.93           C
ATOM   2887  CD1 TYR D 399     122.211 134.193  89.404  1.00 57.93           C
ATOM   2888  CD2 TYR D 399     121.926 136.489  88.899  1.00 57.93           C
ATOM   2889  CE1 TYR D 399     122.375 134.502  90.723  1.00 57.93           C
ATOM   2890  CE2 TYR D 399     122.090 136.804  90.211  1.00 57.93           C
ATOM   2891  CZ  TYR D 399     122.312 135.810  91.119  1.00 57.93           C
ATOM   2892  OH  TYR D 399     122.472 136.126  92.436  1.00 57.93           O
ATOM   2893  N   THR D 400     122.885 135.281  84.019  1.00 59.93           N
ATOM   2894  CA  THR D 400     122.766 135.061  82.585  1.00 59.93           C
ATOM   2895  C   THR D 400     123.995 134.359  82.036  1.00 59.93           C
ATOM   2896  O   THR D 400     123.883 133.428  81.236  1.00 59.93           O
ATOM   2897  CB  THR D 400     122.554 136.399  81.885  1.00 59.93           C
ATOM   2898  OG1 THR D 400     121.350 136.998  82.368  1.00 59.93           O
ATOM   2899  CG2 THR D 400     122.453 136.225  80.396  1.00 59.93           C
ATOM   2900  N   LEU D 401     125.175 134.771  82.481  1.00 58.62           N
ATOM   2901  CA  LEU D 401     126.398 134.146  82.012  1.00 58.62           C
ATOM   2902  C   LEU D 401     126.565 132.740  82.567  1.00 58.62           C
ATOM   2903  O   LEU D 401     127.139 131.881  81.899  1.00 58.62           O
ATOM   2904  CB  LEU D 401     127.587 135.012  82.387  1.00 58.62           C
ATOM   2905  CG  LEU D 401     127.687 136.390  81.756  1.00 58.62           C
ATOM   2906  CD1 LEU D 401     128.831 137.128  82.374  1.00 58.62           C
ATOM   2907  CD2 LEU D 401     127.877 136.262  80.280  1.00 58.62           C
ATOM   2908  N   CYS D 402     126.065 132.479  83.771  1.00 56.31           N
ATOM   2909  CA  CYS D 402     126.105 131.120  84.290  1.00 56.31           C
ATOM   2910  C   CYS D 402     125.088 130.224  83.600  1.00 56.31           C
ATOM   2911  O   CYS D 402     125.304 129.016  83.514  1.00 56.31           O
ATOM   2912  CB  CYS D 402     125.885 131.122  85.799  1.00 56.31           C
ATOM   2913  SG  CYS D 402     127.213 131.865  86.756  1.00 56.31           S
ATOM   2914  N   ASP D 403     123.975 130.790  83.119  1.00 58.64           N
ATOM   2915  CA  ASP D 403     123.072 130.051  82.240  1.00 58.64           C
ATOM   2916  C   ASP D 403     123.775 129.651  80.957  1.00 58.64           C
ATOM   2917  O   ASP D 403     123.610 128.534  80.465  1.00 58.64           O
ATOM   2918  CB  ASP D 403     121.852 130.895  81.868  1.00 58.64           C
ATOM   2919  CG  ASP D 403     120.959 131.206  83.033  1.00 58.64           C
ATOM   2920  OD1 ASP D 403     120.954 130.436  83.993  1.00 58.64           O
ATOM   2921  OD2 ASP D 403     120.249 132.230  82.991  1.00 58.64           O
ATOM   2922  N   ARG D 404     124.567 130.560  80.411  1.00 62.23           N
ATOM   2923  CA  ARG D 404     125.102 130.431  79.068  1.00 62.23           C
ATOM   2924  C   ARG D 404     126.293 129.488  79.023  1.00 62.23           C
ATOM   2925  O   ARG D 404     126.363 128.611  78.163  1.00 62.23           O
ATOM   2926  CB  ARG D 404     125.487 131.815  78.571  1.00 62.23           C
ATOM   2927  CG  ARG D 404     125.953 131.910  77.161  1.00 62.23           C
ATOM   2928  CD  ARG D 404     126.214 133.367  76.875  1.00 62.23           C
ATOM   2929  NE  ARG D 404     124.981 134.136  76.994  1.00 62.23           N
ATOM   2930  CZ  ARG D 404     124.933 135.459  77.084  1.00 62.23           C
ATOM   2931  NH1 ARG D 404     126.051 136.166  77.083  1.00 62.23           N
ATOM   2932  NH2 ARG D 404     123.764 136.072  77.185  1.00 62.23           N
ATOM   2933  N   TYR D 405     127.239 129.657  79.935  1.00 60.07           N
ATOM   2934  CA  TYR D 405     128.434 128.830  79.949  1.00 60.07           C
ATOM   2935  C   TYR D 405     128.245 127.540  80.716  1.00 60.07           C
ATOM   2936  O   TYR D 405     128.888 126.541  80.400  1.00 60.07           O
ATOM   2937  CB  TYR D 405     129.598 129.606  80.550  1.00 60.07           C
ATOM   2938  CG  TYR D 405     130.066 130.724  79.677  1.00 60.07           C
ATOM   2939  CD1 TYR D 405     130.906 130.480  78.609  1.00 60.07           C
ATOM   2940  CD2 TYR D 405     129.664 132.022  79.912  1.00 60.07           C
ATOM   2941  CE1 TYR D 405     131.335 131.497  77.806  1.00 60.07           C
ATOM   2942  CE2 TYR D 405     130.086 133.045  79.115  1.00 60.07           C
ATOM   2943  CZ  TYR D 405     130.923 132.777  78.065  1.00 60.07           C
ATOM   2944  OH  TYR D 405     131.349 133.801  77.264  1.00 60.07           O
ATOM   2945  N   GLY D 406     127.395 127.550  81.722  1.00 55.36           N
ATOM   2946  CA  GLY D 406     127.065 126.364  82.470  1.00 55.36           C
ATOM   2947  C   GLY D 406     127.812 126.313  83.777  1.00 55.36           C
ATOM   2948  O   GLY D 406     128.923 125.798  83.855  1.00 55.36           O
ATOM   2949  N   LEU D 407     127.170 126.807  84.822  1.00 49.98           N
ATOM   2950  CA  LEU D 407     127.652 126.709  86.184  1.00 49.98           C
ATOM   2951  C   LEU D 407     126.427 126.642  87.064  1.00 49.98           C
ATOM   2952  O   LEU D 407     125.462 127.362  86.829  1.00 49.98           O
ATOM   2953  CB  LEU D 407     128.519 127.901  86.596  1.00 49.98           C
ATOM   2954  CG  LEU D 407     129.914 128.088  86.020  1.00 49.98           C
ATOM   2955  CD1 LEU D 407     130.482 129.399  86.462  1.00 49.98           C
ATOM   2956  CD2 LEU D 407     130.806 126.973  86.463  1.00 49.98           C
ATOM   2957  N   TYR D 408     126.454 125.775  88.057  1.00 49.03           N
ATOM   2958  CA  TYR D 408     125.384 125.765  89.030  1.00 49.03           C
ATOM   2959  C   TYR D 408     125.582 126.933  89.975  1.00 49.03           C
ATOM   2960  O   TYR D 408     126.705 127.285  90.316  1.00 49.03           O
ATOM   2961  CB  TYR D 408     125.363 124.458  89.798  1.00 49.03           C
ATOM   2962  CG  TYR D 408     125.336 123.275  88.893  1.00 49.03           C
ATOM   2963  CD1 TYR D 408     124.273 123.061  88.042  1.00 49.03           C
ATOM   2964  CD2 TYR D 408     126.355 122.347  88.920  1.00 49.03           C
ATOM   2965  CE1 TYR D 408     124.252 121.985  87.212  1.00 49.03           C
ATOM   2966  CE2 TYR D 408     126.336 121.262  88.106  1.00 49.03           C
ATOM   2967  CZ  TYR D 408     125.281 121.081  87.255  1.00 49.03           C
ATOM   2968  OH  TYR D 408     125.272 119.992  86.436  1.00 49.03           O
ATOM   2969  N   VAL D 409     124.494 127.570  90.365  1.00 48.19           N
ATOM   2970  CA  VAL D 409     124.564 128.761  91.192  1.00 48.19           C
ATOM   2971  C   VAL D 409     123.769 128.507  92.458  1.00 48.19           C
ATOM   2972  O   VAL D 409     122.636 128.027  92.397  1.00 48.19           O
ATOM   2973  CB  VAL D 409     124.048 129.997  90.437  1.00 48.19           C
ATOM   2974  CG1 VAL D 409     123.960 131.175  91.339  1.00 48.19           C
ATOM   2975  CG2 VAL D 409     124.962 130.322  89.304  1.00 48.19           C
ATOM   2976  N   VAL D 410     124.379 128.782  93.599  1.00 50.42           N
ATOM   2977  CA  VAL D 410     123.668 128.894  94.861  1.00 50.42           C
ATOM   2978  C   VAL D 410     123.423 130.372  95.096  1.00 50.42           C
ATOM   2979  O   VAL D 410     124.363 131.139  95.302  1.00 50.42           O
ATOM   2980  CB  VAL D 410     124.451 128.266  96.014  1.00 50.42           C
ATOM   2981  CG1 VAL D 410     123.740 128.512  97.317  1.00 50.42           C
ATOM   2982  CG2 VAL D 410     124.602 126.807  95.777  1.00 50.42           C
ATOM   2983  N   ASP D 411     122.167 130.779  95.051  1.00 55.25           N
ATOM   2984  CA  ASP D 411     121.809 132.174  95.217  1.00 55.25           C
ATOM   2985  C   ASP D 411     121.488 132.421  96.682  1.00 55.25           C
ATOM   2986  O   ASP D 411     120.690 131.698  97.276  1.00 55.25           O
ATOM   2987  CB  ASP D 411     120.618 132.518  94.335  1.00 55.25           C
ATOM   2988  CG  ASP D 411     120.483 133.986  94.092  1.00 55.25           C
ATOM   2989  OD1 ASP D 411     121.318 134.765  94.574  1.00 55.25           O
ATOM   2990  OD2 ASP D 411     119.531 134.367  93.410  1.00 55.25           O
ATOM   2991  N   GLU D 412     122.107 133.435  97.262  1.00 58.78           N
ATOM   2992  CA  GLU D 412     122.139 133.587  98.706  1.00 58.78           C
ATOM   2993  C   GLU D 412     121.575 134.935  99.106  1.00 58.78           C
ATOM   2994  O   GLU D 412     121.920 135.950  98.511  1.00 58.78           O
ATOM   2995  CB  GLU D 412     123.564 133.421  99.209  1.00 58.78           C
ATOM   2996  CG  GLU D 412     123.714 133.449 100.693  1.00 58.78           C
ATOM   2997  CD  GLU D 412     125.065 132.935 101.113  1.00 58.78           C
ATOM   2998  OE1 GLU D 412     125.857 132.563 100.225  1.00 58.78           O
ATOM   2999  OE2 GLU D 412     125.336 132.886 102.323  1.00 58.78           O
ATOM   3000  N   ALA D 413     120.692 134.934 100.095  1.00 56.33           N
ATOM   3001  CA  ALA D 413     120.088 136.168 100.564  1.00 56.33           C
ATOM   3002  C   ALA D 413     121.105 137.018 101.309  1.00 56.33           C
ATOM   3003  O   ALA D 413     122.045 136.512 101.919  1.00 56.33           O
ATOM   3004  CB  ALA D 413     118.899 135.868 101.467  1.00 56.33           C
ATOM   3005  N   ASN D 414     120.899 138.330 101.262  1.00 58.62           N
ATOM   3006  CA  ASN D 414     121.821 139.303 101.843  1.00 58.62           C
ATOM   3007  C   ASN D 414     121.544 139.451 103.340  1.00 58.62           C
ATOM   3008  O   ASN D 414     121.110 140.491 103.829  1.00 58.62           O
ATOM   3009  CB  ASN D 414     121.670 140.634 101.126  1.00 58.62           C
ATOM   3010  CG  ASN D 414     122.761 141.614 101.466  1.00 58.62           C
ATOM   3011  OD1 ASN D 414     123.757 141.265 102.079  1.00 58.62           O
ATOM   3012  ND2 ASN D 414     122.534 142.869 101.137  1.00 58.62           N
ATOM   3013  N   ILE D 415     121.784 138.375 104.080  1.00 56.52           N
ATOM   3014  CA  ILE D 415     121.555 138.354 105.519  1.00 56.52           C
ATOM   3015  C   ILE D 415     122.783 137.752 106.176  1.00 56.52           C
ATOM   3016  O   ILE D 415     123.063 136.565 105.996  1.00 56.52           O
ATOM   3017  CB  ILE D 415     120.306 137.558 105.915  1.00 56.52           C
ATOM   3018  CG1 ILE D 415     119.043 138.134 105.293  1.00 56.52           C
ATOM   3019  CG2 ILE D 415     120.154 137.570 107.409  1.00 56.52           C
ATOM   3020  CD1 ILE D 415     117.868 137.243 105.416  1.00 56.52           C
ATOM   3021  N   GLU D 416     123.510 138.556 106.938  1.00 62.67           N
ATOM   3022  CA  GLU D 416     124.565 138.030 107.793  1.00 62.67           C
ATOM   3023  C   GLU D 416     124.695 138.897 109.029  1.00 62.67           C
ATOM   3024  O   GLU D 416     124.950 140.094 108.922  1.00 62.67           O
ATOM   3025  CB  GLU D 416     125.898 137.930 107.065  1.00 62.67           C
ATOM   3026  CG  GLU D 416     126.997 137.501 108.004  1.00 62.67           C
ATOM   3027  CD  GLU D 416     128.230 137.004 107.311  1.00 62.67           C
ATOM   3028  OE1 GLU D 416     128.215 136.839 106.082  1.00 62.67           O
ATOM   3029  OE2 GLU D 416     129.237 136.806 108.000  1.00 62.67           O
ATOM   3030  N   THR D 417     124.592 138.285 110.192  1.00 63.67           N
ATOM   3031  CA  THR D 417     124.706 139.024 111.422  1.00 63.67           C
ATOM   3032  C   THR D 417     125.709 138.299 112.272  1.00 63.67           C
ATOM   3033  O   THR D 417     125.442 137.961 113.404  1.00 63.67           O
ATOM   3034  CB  THR D 417     123.370 139.029 112.165  1.00 63.67           C
ATOM   3035  OG1 THR D 417     123.104 137.719 112.658  1.00 63.67           O
ATOM   3036  CG2 THR D 417     122.257 139.430 111.246  1.00 63.67           C
ATOM   3037  N   HIS D 418     126.897 138.128 111.723  1.00 66.25           N
ATOM   3038  CA  HIS D 418     127.979 137.416 112.372  1.00 66.25           C
ATOM   3039  C   HIS D 418     128.440 138.070 113.659  1.00 66.25           C
ATOM   3040  O   HIS D 418     128.750 137.398 114.625  1.00 66.25           O
ATOM   3041  CB  HIS D 418     129.156 137.309 111.414  1.00 66.25           C
ATOM   3042  CG  HIS D 418     130.094 136.193 111.734  1.00 66.25           C
ATOM   3043  ND1 HIS D 418     130.878 135.587 110.782  1.00 66.25           N
ATOM   3044  CD2 HIS D 418     130.365 135.565 112.900  1.00 66.25           C
ATOM   3045  CE1 HIS D 418     131.600 134.640 111.348  1.00 66.25           C
ATOM   3046  NE2 HIS D 418     131.305 134.604 112.632  1.00 66.25           N
ATOM   3047  N   GLY D 419     128.479 139.389 113.660  1.00 67.79           N
ATOM   3048  CA  GLY D 419     128.931 140.155 114.798  1.00 67.79           C
ATOM   3049  C   GLY D 419     128.055 140.204 116.030  1.00 67.79           C
ATOM   3050  O   GLY D 419     128.500 140.678 117.060  1.00 67.79           O
ATOM   3051  N   MET D 420     126.812 139.758 115.931  1.00 68.86           N
ATOM   3052  CA  MET D 420     125.897 139.848 117.052  1.00 68.86           C
ATOM   3053  C   MET D 420     126.281 138.838 118.122  1.00 68.86           C
ATOM   3054  O   MET D 420     126.837 137.780 117.832  1.00 68.86           O
ATOM   3055  CB  MET D 420     124.464 139.593 116.594  1.00 68.86           C
ATOM   3056  CG  MET D 420     123.953 140.577 115.576  1.00 68.86           C
ATOM   3057  SD  MET D 420     124.024 142.276 116.148  1.00 68.86           S
ATOM   3058  CE  MET D 420     122.821 142.218 117.447  1.00 68.86           C
ATOM   3059  N   VAL D 421     125.997 139.181 119.372  1.00 69.42           N
ATOM   3060  CA  VAL D 421     126.209 138.251 120.478  1.00 69.42           C
ATOM   3061  C   VAL D 421     124.876 138.024 121.180  1.00 69.42           C
ATOM   3062  O   VAL D 421     124.333 138.958 121.781  1.00 69.42           O
ATOM   3063  CB  VAL D 421     127.271 138.755 121.461  1.00 69.42           C
ATOM   3064  CG1 VAL D 421     127.383 137.795 122.614  1.00 69.42           C
ATOM   3065  CG2 VAL D 421     128.603 138.891 120.771  1.00 69.42           C
ATOM   3066  N   PRO D 422     124.281 136.827 121.099  1.00 69.26           N
ATOM   3067  CA  PRO D 422     124.680 135.671 120.300  1.00 69.26           C
ATOM   3068  C   PRO D 422     124.349 135.900 118.843  1.00 69.26           C
ATOM   3069  O   PRO D 422     123.734 136.912 118.540  1.00 69.26           O
ATOM   3070  CB  PRO D 422     123.840 134.545 120.880  1.00 69.26           C
ATOM   3071  CG  PRO D 422     122.647 135.213 121.370  1.00 69.26           C
ATOM   3072  CD  PRO D 422     123.072 136.539 121.882  1.00 69.26           C
ATOM   3073  N   MET D 423     124.750 134.984 117.968  1.00 69.55           N
ATOM   3074  CA  MET D 423     124.697 135.247 116.539  1.00 69.55           C
ATOM   3075  C   MET D 423     123.266 135.348 116.023  1.00 69.55           C
ATOM   3076  O   MET D 423     123.041 135.978 114.990  1.00 69.55           O
ATOM   3077  CB  MET D 423     125.476 134.160 115.802  1.00 69.55           C
ATOM   3078  CG  MET D 423     125.869 134.463 114.388  1.00 69.55           C
ATOM   3079  SD  MET D 423     126.624 133.024 113.611  1.00 69.55           S
ATOM   3080  CE  MET D 423     128.140 132.879 114.517  1.00 69.55           C
ATOM   3081  N   ASN D 424     122.287 134.803 116.744  1.00 67.45           N
ATOM   3082  CA  ASN D 424     120.896 134.883 116.326  1.00 67.45           C
ATOM   3083  C   ASN D 424     120.098 135.936 117.085  1.00 67.45           C
ATOM   3084  O   ASN D 424     118.886 135.779 117.226  1.00 67.45           O
ATOM   3085  CB  ASN D 424     120.201 133.525 116.448  1.00 67.45           C
ATOM   3086  CG  ASN D 424     120.115 133.006 117.876  1.00 67.45           C
ATOM   3087  OD1 ASN D 424     120.640 133.587 118.815  1.00 67.45           O
ATOM   3088  ND2 ASN D 424     119.389 131.919 118.041  1.00 67.45           N
ATOM   3089  N   ARG D 425     120.746 136.982 117.599  1.00 67.54           N
ATOM   3090  CA  ARG D 425     120.027 137.983 118.380  1.00 67.54           C
ATOM   3091  C   ARG D 425     118.997 138.723 117.535  1.00 67.54           C
ATOM   3092  O   ARG D 425     117.880 138.980 117.991  1.00 67.54           O
ATOM   3093  CB  ARG D 425     121.003 138.966 119.017  1.00 67.54           C
ATOM   3094  CG  ARG D 425     120.313 140.022 119.843  1.00 67.54           C
ATOM   3095  CD  ARG D 425     121.264 140.918 120.573  1.00 67.54           C
ATOM   3096  NE  ARG D 425     121.932 140.230 121.664  1.00 67.54           N
ATOM   3097  CZ  ARG D 425     121.415 140.087 122.876  1.00 67.54           C
ATOM   3098  NH1 ARG D 425     120.222 140.581 123.154  1.00 67.54           N
ATOM   3099  NH2 ARG D 425     122.092 139.449 123.812  1.00 67.54           N
ATOM   3100  N   LEU D 426     119.326 139.013 116.286  1.00 63.62           N
ATOM   3101  CA  LEU D 426     118.358 139.645 115.408  1.00 63.62           C
ATOM   3102  C   LEU D 426     117.467 138.639 114.708  1.00 63.62           C
ATOM   3103  O   LEU D 426     116.290 138.921 114.484  1.00 63.62           O
ATOM   3104  CB  LEU D 426     119.067 140.497 114.360  1.00 63.62           C
ATOM   3105  CG  LEU D 426     119.955 141.596 114.923  1.00 63.62           C
ATOM   3106  CD1 LEU D 426     120.589 142.365 113.802  1.00 63.62           C
ATOM   3107  CD2 LEU D 426     119.192 142.505 115.847  1.00 63.62           C
ATOM   3108  N   THR D 427     117.987 137.474 114.359  1.00 62.71           N
ATOM   3109  CA  THR D 427     117.209 136.532 113.575  1.00 62.71           C
ATOM   3110  C   THR D 427     116.274 135.684 114.414  1.00 62.71           C
ATOM   3111  O   THR D 427     115.514 134.901 113.851  1.00 62.71           O
ATOM   3112  CB  THR D 427     118.126 135.621 112.774  1.00 62.71           C
ATOM   3113  OG1 THR D 427     118.890 134.809 113.665  1.00 62.71           O
ATOM   3114  CG2 THR D 427     119.063 136.436 111.926  1.00 62.71           C
ATOM   3115  N   ASP D 428     116.309 135.799 115.732  1.00 68.11           N
ATOM   3116  CA  ASP D 428     115.303 135.166 116.564  1.00 68.11           C
ATOM   3117  C   ASP D 428     114.321 136.195 117.107  1.00 68.11           C
ATOM   3118  O   ASP D 428     113.473 135.864 117.933  1.00 68.11           O
ATOM   3119  CB  ASP D 428     115.968 134.393 117.698  1.00 68.11           C
ATOM   3120  CG  ASP D 428     115.130 133.237 118.186  1.00 68.11           C
ATOM   3121  OD1 ASP D 428     114.049 132.994 117.613  1.00 68.11           O
ATOM   3122  OD2 ASP D 428     115.553 132.561 119.143  1.00 68.11           O
ATOM   3123  N   ASP D 429     114.426 137.437 116.650  1.00 66.46           N
ATOM   3124  CA  ASP D 429     113.567 138.527 117.068  1.00 66.46           C
ATOM   3125  C   ASP D 429     112.528 138.765 115.988  1.00 66.46           C
ATOM   3126  O   ASP D 429     112.905 139.021 114.838  1.00 66.46           O
ATOM   3127  CB  ASP D 429     114.410 139.778 117.284  1.00 66.46           C
ATOM   3128  CG  ASP D 429     113.662 140.912 117.962  1.00 66.46           C
ATOM   3129  OD1 ASP D 429     112.464 140.799 118.270  1.00 66.46           O
ATOM   3130  OD2 ASP D 429     114.302 141.952 118.198  1.00 66.46           O
ATOM   3131  N   PRO D 430     111.230 138.695 116.289  1.00 63.80           N
ATOM   3132  CA  PRO D 430     110.229 138.926 115.240  1.00 63.80           C
ATOM   3133  C   PRO D 430     110.101 140.369 114.812  1.00 63.80           C
ATOM   3134  O   PRO D 430     109.469 140.628 113.788  1.00 63.80           O
ATOM   3135  CB  PRO D 430     108.935 138.421 115.878  1.00 63.80           C
ATOM   3136  CG  PRO D 430     109.165 138.539 117.290  1.00 63.80           C
ATOM   3137  CD  PRO D 430     110.599 138.253 117.538  1.00 63.80           C
ATOM   3138  N   ARG D 431     110.687 141.314 115.544  1.00 67.14           N
ATOM   3139  CA  ARG D 431     110.739 142.690 115.078  1.00 67.14           C
ATOM   3140  C   ARG D 431     111.658 142.857 113.878  1.00 67.14           C
ATOM   3141  O   ARG D 431     111.540 143.847 113.156  1.00 67.14           O
ATOM   3142  CB  ARG D 431     111.181 143.601 116.216  1.00 67.14           C
ATOM   3143  CG  ARG D 431     110.143 143.718 117.315  1.00 67.14           C
ATOM   3144  CD  ARG D 431     110.651 144.483 118.517  1.00 67.14           C
ATOM   3145  NE  ARG D 431     110.962 145.877 118.220  1.00 67.14           N
ATOM   3146  CZ  ARG D 431     110.078 146.867 118.254  1.00 67.14           C
ATOM   3147  NH1 ARG D 431     108.813 146.626 118.560  1.00 67.14           N
ATOM   3148  NH2 ARG D 431     110.461 148.101 117.972  1.00 67.14           N
ATOM   3149  N   TRP D 432     112.561 141.914 113.646  1.00 61.67           N
ATOM   3150  CA  TRP D 432     113.436 141.919 112.490  1.00 61.67           C
ATOM   3151  C   TRP D 432     112.966 140.986 111.394  1.00 61.67           C
ATOM   3152  O   TRP D 432     113.602 140.925 110.345  1.00 61.67           O
ATOM   3153  CB  TRP D 432     114.847 141.550 112.921  1.00 61.67           C
ATOM   3154  CG  TRP D 432     115.498 142.639 113.652  1.00 61.67           C
ATOM   3155  CD1 TRP D 432     115.420 142.889 114.977  1.00 61.67           C
ATOM   3156  CD2 TRP D 432     116.370 143.621 113.106  1.00 61.67           C
ATOM   3157  NE1 TRP D 432     116.167 143.986 115.293  1.00 61.67           N
ATOM   3158  CE2 TRP D 432     116.767 144.451 114.157  1.00 61.67           C
ATOM   3159  CE3 TRP D 432     116.850 143.881 111.825  1.00 61.67           C
ATOM   3160  CZ2 TRP D 432     117.626 145.519 113.972  1.00 61.67           C
ATOM   3161  CZ3 TRP D 432     117.694 144.939 111.642  1.00 61.67           C
ATOM   3162  CH2 TRP D 432     118.074 145.748 112.707  1.00 61.67           C
ATOM   3163  N   LEU D 433     111.886 140.250 111.625  1.00 59.17           N
ATOM   3164  CA  LEU D 433     111.312 139.418 110.573  1.00 59.17           C
ATOM   3165  C   LEU D 433     110.835 140.186 109.338  1.00 59.17           C
ATOM   3166  O   LEU D 433     111.031 139.658 108.233  1.00 59.17           O
ATOM   3167  CB  LEU D 433     110.191 138.551 111.162  1.00 59.17           C
ATOM   3168  CG  LEU D 433     109.446 137.602 110.227  1.00 59.17           C
ATOM   3169  CD1 LEU D 433     110.392 136.617 109.599  1.00 59.17           C
ATOM   3170  CD2 LEU D 433     108.366 136.879 110.983  1.00 59.17           C
ATOM   3171  N   PRO D 434     110.230 141.387 109.418  1.00 60.25           N
ATOM   3172  CA  PRO D 434     109.973 142.123 108.167  1.00 60.25           C
ATOM   3173  C   PRO D 434     111.215 142.521 107.395  1.00 60.25           C
ATOM   3174  O   PRO D 434     111.192 142.492 106.162  1.00 60.25           O
ATOM   3175  CB  PRO D 434     109.203 143.353 108.648  1.00 60.25           C
ATOM   3176  CG  PRO D 434     108.536 142.916 109.827  1.00 60.25           C
ATOM   3177  CD  PRO D 434     109.463 142.006 110.518  1.00 60.25           C
ATOM   3178  N   ALA D 435     112.295 142.894 108.075  1.00 60.36           N
ATOM   3179  CA  ALA D 435     113.505 143.268 107.357  1.00 60.36           C
ATOM   3180  C   ALA D 435     114.178 142.053 106.740  1.00 60.36           C
ATOM   3181  O   ALA D 435     114.706 142.130 105.629  1.00 60.36           O
ATOM   3182  CB  ALA D 435     114.467 143.995 108.288  1.00 60.36           C
ATOM   3183  N   MET D 436     114.160 140.924 107.441  1.00 59.99           N
ATOM   3184  CA  MET D 436     114.753 139.714 106.895  1.00 59.99           C
ATOM   3185  C   MET D 436     113.929 139.144 105.759  1.00 59.99           C
ATOM   3186  O   MET D 436     114.493 138.571 104.826  1.00 59.99           O
ATOM   3187  CB  MET D 436     114.916 138.666 107.983  1.00 59.99           C
ATOM   3188  CG  MET D 436     116.000 138.958 108.967  1.00 59.99           C
ATOM   3189  SD  MET D 436     116.003 137.718 110.249  1.00 59.99           S
ATOM   3190  CE  MET D 436     116.421 136.272 109.291  1.00 59.99           C
ATOM   3191  N   SER D 437     112.606 139.286 105.815  1.00 59.68           N
ATOM   3192  CA  SER D 437     111.772 138.686 104.787  1.00 59.68           C
ATOM   3193  C   SER D 437     111.919 139.397 103.456  1.00 59.68           C
ATOM   3194  O   SER D 437     111.924 138.741 102.418  1.00 59.68           O
ATOM   3195  CB  SER D 437     110.310 138.664 105.216  1.00 59.68           C
ATOM   3196  OG  SER D 437     109.778 139.964 105.294  1.00 59.68           O
ATOM   3197  N   GLU D 438     112.103 140.703 103.494  1.00 63.87           N
ATOM   3198  CA  GLU D 438     112.276 141.471 102.283  1.00 63.87           C
ATOM   3199  C   GLU D 438     113.524 141.017 101.559  1.00 63.87           C
ATOM   3200  O   GLU D 438     113.540 140.928 100.350  1.00 63.87           O
ATOM   3201  CB  GLU D 438     112.396 142.947 102.616  1.00 63.87           C
ATOM   3202  CG  GLU D 438     111.160 143.529 103.262  1.00 63.87           C
ATOM   3203  CD  GLU D 438     110.189 144.089 102.249  1.00 63.87           C
ATOM   3204  OE1 GLU D 438     108.963 144.002 102.479  1.00 63.87           O
ATOM   3205  OE2 GLU D 438     110.653 144.621 101.220  1.00 63.87           O
ATOM   3206  N   ARG D 439     114.575 140.734 102.309  1.00 59.25           N
ATOM   3207  CA  ARG D 439     115.831 140.318 101.712  1.00 59.25           C
ATOM   3208  C   ARG D 439     115.744 138.943 101.083  1.00 59.25           C
ATOM   3209  O   ARG D 439     116.483 138.661 100.142  1.00 59.25           O
ATOM   3210  CB  ARG D 439     116.928 140.358 102.763  1.00 59.25           C
ATOM   3211  CG  ARG D 439     117.261 141.763 103.132  1.00 59.25           C
ATOM   3212  CD  ARG D 439     118.134 141.841 104.320  1.00 59.25           C
ATOM   3213  NE  ARG D 439     118.374 143.230 104.657  1.00 59.25           N
ATOM   3214  CZ  ARG D 439     119.443 143.906 104.279  1.00 59.25           C
ATOM   3215  NH1 ARG D 439     119.570 145.172 104.612  1.00 59.25           N
ATOM   3216  NH2 ARG D 439     120.392 143.307 103.594  1.00 59.25           N
ATOM   3217  N   VAL D 440     114.847 138.098 101.563  1.00 55.50           N
ATOM   3218  CA  VAL D 440     114.665 136.775 100.995  1.00 55.50           C
ATOM   3219  C   VAL D 440     113.651 136.792  99.865  1.00 55.50           C
ATOM   3220  O   VAL D 440     113.914 136.263  98.785  1.00 55.50           O
ATOM   3221  CB  VAL D 440     114.263 135.790 102.105  1.00 55.50           C
ATOM   3222  CG1 VAL D 440     113.849 134.491 101.520  1.00 55.50           C
ATOM   3223  CG2 VAL D 440     115.420 135.575 103.039  1.00 55.50           C
ATOM   3224  N   THR D 441     112.491 137.412 100.088  1.00 57.10           N
ATOM   3225  CA  THR D 441     111.410 137.350  99.111  1.00 57.10           C
ATOM   3226  C   THR D 441     111.739 138.118  97.843  1.00 57.10           C
ATOM   3227  O   THR D 441     111.337 137.703  96.757  1.00 57.10           O
ATOM   3228  CB  THR D 441     110.104 137.870  99.709  1.00 57.10           C
ATOM   3229  OG1 THR D 441     110.266 139.226 100.117  1.00 57.10           O
ATOM   3230  CG2 THR D 441     109.674 137.036 100.890  1.00 57.10           C
ATOM   3231  N   ARG D 442     112.489 139.204  97.945  1.00 59.68           N
ATOM   3232  CA  ARG D 442     112.837 139.952  96.751  1.00 59.68           C
ATOM   3233  C   ARG D 442     113.972 139.311  95.974  1.00 59.68           C
ATOM   3234  O   ARG D 442     114.096 139.565  94.777  1.00 59.68           O
ATOM   3235  CB  ARG D 442     113.183 141.388  97.118  1.00 59.68           C
ATOM   3236  CG  ARG D 442     111.998 142.113  97.696  1.00 59.68           C
ATOM   3237  CD  ARG D 442     112.325 143.493  98.176  1.00 59.68           C
ATOM   3238  NE  ARG D 442     112.629 144.396  97.080  1.00 59.68           N
ATOM   3239  CZ  ARG D 442     113.808 144.967  96.886  1.00 59.68           C
ATOM   3240  NH1 ARG D 442     114.805 144.751  97.725  1.00 59.68           N
ATOM   3241  NH2 ARG D 442     113.979 145.773  95.857  1.00 59.68           N
ATOM   3242  N   MET D 443     114.794 138.489  96.621  1.00 57.55           N
ATOM   3243  CA  MET D 443     115.772 137.694  95.891  1.00 57.55           C
ATOM   3244  C   MET D 443     115.090 136.630  95.050  1.00 57.55           C
ATOM   3245  O   MET D 443     115.422 136.450  93.875  1.00 57.55           O
ATOM   3246  CB  MET D 443     116.749 137.038  96.854  1.00 57.55           C
ATOM   3247  CG  MET D 443     117.676 136.073  96.162  1.00 57.55           C
ATOM   3248  SD  MET D 443     118.714 135.141  97.267  1.00 57.55           S
ATOM   3249  CE  MET D 443     117.518 134.092  98.069  1.00 57.55           C
ATOM   3250  N   VAL D 444     114.144 135.909  95.647  1.00 55.36           N
ATOM   3251  CA  VAL D 444     113.446 134.838  94.949  1.00 55.36           C
ATOM   3252  C   VAL D 444     112.615 135.398  93.807  1.00 55.36           C
ATOM   3253  O   VAL D 444     112.603 134.845  92.710  1.00 55.36           O
ATOM   3254  CB  VAL D 444     112.597 134.032  95.947  1.00 55.36           C
ATOM   3255  CG1 VAL D 444     111.742 133.022  95.241  1.00 55.36           C
ATOM   3256  CG2 VAL D 444     113.493 133.333  96.926  1.00 55.36           C
ATOM   3257  N   GLN D 445     111.974 136.542  94.020  1.00 60.01           N
ATOM   3258  CA  GLN D 445     111.192 137.155  92.956  1.00 60.01           C
ATOM   3259  C   GLN D 445     112.056 137.675  91.820  1.00 60.01           C
ATOM   3260  O   GLN D 445     111.602 137.710  90.677  1.00 60.01           O
ATOM   3261  CB  GLN D 445     110.332 138.266  93.527  1.00 60.01           C
ATOM   3262  CG  GLN D 445     109.096 137.741  94.166  1.00 60.01           C
ATOM   3263  CD  GLN D 445     108.257 138.817  94.777  1.00 60.01           C
ATOM   3264  OE1 GLN D 445     108.740 139.894  95.096  1.00 60.01           O
ATOM   3265  NE2 GLN D 445     106.966 138.575  94.832  1.00 60.01           N
ATOM   3266  N   ARG D 446     113.298 138.049  92.093  1.00 58.64           N
ATOM   3267  CA  ARG D 446     114.150 138.508  91.010  1.00 58.64           C
ATOM   3268  C   ARG D 446     114.715 137.345  90.205  1.00 58.64           C
ATOM   3269  O   ARG D 446     114.796 137.423  88.979  1.00 58.64           O
ATOM   3270  CB  ARG D 446     115.294 139.360  91.548  1.00 58.64           C
ATOM   3271  CG  ARG D 446     116.044 140.056  90.446  1.00 58.64           C
ATOM   3272  CD  ARG D 446     117.315 140.718  90.882  1.00 58.64           C
ATOM   3273  NE  ARG D 446     118.326 139.737  91.230  1.00 58.64           N
ATOM   3274  CZ  ARG D 446     119.562 140.032  91.598  1.00 58.64           C
ATOM   3275  NH1 ARG D 446     120.405 139.065  91.899  1.00 58.64           N
ATOM   3276  NH2 ARG D 446     119.969 141.286  91.628  1.00 58.64           N
ATOM   3277  N   ASP D 447     115.093 136.253  90.865  1.00 58.31           N
ATOM   3278  CA  ASP D 447     116.005 135.287  90.272  1.00 58.31           C
ATOM   3279  C   ASP D 447     115.412 133.903  90.053  1.00 58.31           C
ATOM   3280  O   ASP D 447     116.154 132.987  89.706  1.00 58.31           O
ATOM   3281  CB  ASP D 447     117.254 135.171  91.142  1.00 58.31           C
ATOM   3282  CG  ASP D 447     118.078 136.426  91.124  1.00 58.31           C
ATOM   3283  OD1 ASP D 447     118.079 137.115  90.092  1.00 58.31           O
ATOM   3284  OD2 ASP D 447     118.706 136.749  92.139  1.00 58.31           O
ATOM   3285  N   ARG D 448     114.106 133.723  90.217  1.00 59.36           N
ATOM   3286  CA  ARG D 448     113.537 132.383  90.154  1.00 59.36           C
ATOM   3287  C   ARG D 448     113.469 131.803  88.751  1.00 59.36           C
ATOM   3288  O   ARG D 448     113.232 130.604  88.622  1.00 59.36           O
ATOM   3289  CB  ARG D 448     112.141 132.372  90.751  1.00 59.36           C
ATOM   3290  CG  ARG D 448     111.165 133.241  90.017  1.00 59.36           C
ATOM   3291  CD  ARG D 448     109.854 133.254  90.731  1.00 59.36           C
ATOM   3292  NE  ARG D 448     109.291 131.918  90.782  1.00 59.36           N
ATOM   3293  CZ  ARG D 448     108.298 131.562  91.580  1.00 59.36           C
ATOM   3294  NH1 ARG D 448     107.749 132.451  92.387  1.00 59.36           N
ATOM   3295  NH2 ARG D 448     107.855 130.318  91.567  1.00 59.36           N
ATOM   3296  N   ASN D 449     113.663 132.594  87.706  1.00 61.45           N
ATOM   3297  CA  ASN D 449     113.572 132.047  86.363  1.00 61.45           C
ATOM   3298  C   ASN D 449     114.906 131.581  85.807  1.00 61.45           C
ATOM   3299  O   ASN D 449     114.925 130.995  84.725  1.00 61.45           O
ATOM   3300  CB  ASN D 449     112.965 133.064  85.402  1.00 61.45           C
ATOM   3301  CG  ASN D 449     111.509 133.314  85.671  1.00 61.45           C
ATOM   3302  OD1 ASN D 449     110.780 132.416  86.063  1.00 61.45           O
ATOM   3303  ND2 ASN D 449     111.069 134.528  85.427  1.00 61.45           N
TER    3304      ASN D 449
HETATM 3305  C1  PTQ A2001      80.063 133.001 106.500  1.00 70.60           C
HETATM 3306  O1  PTQ A2001      81.095 132.522 107.343  1.00 70.60           O
HETATM 3307  S1  PTQ A2001      79.873 132.061 105.009  1.00 70.60           S
HETATM 3308  C2  PTQ A2001      78.762 132.957 107.279  1.00 70.60           C
HETATM 3309  O2  PTQ A2001      77.739 133.572 106.547  1.00 70.60           O
HETATM 3310  C3  PTQ A2001      78.941 133.684 108.590  1.00 70.60           C
HETATM 3311  O3  PTQ A2001      77.728 133.628 109.300  1.00 70.60           O
HETATM 3312  C4  PTQ A2001      80.122 133.156 109.385  1.00 70.60           C
HETATM 3313  O4  PTQ A2001      80.020 131.774 109.598  1.00 70.60           O
HETATM 3314  C5  PTQ A2001      81.306 133.332 108.481  1.00 70.60           C
HETATM 3315  O5  PTQ A2001      82.706 133.940 110.264  1.00 70.60           O
HETATM 3316  C6  PTQ A2001      82.604 133.052 109.180  1.00 70.60           C
HETATM 3317  C7  PTQ A2001      79.460 133.109 103.637  1.00 70.60           C
HETATM 3318  C8  PTQ A2001      77.999 132.969 103.262  1.00 70.60           C
HETATM 3319  C9  PTQ A2001      77.368 134.341 103.175  1.00 70.60           C
HETATM 3320  C10 PTQ A2001      76.157 134.644 104.014  1.00 70.60           C
HETATM 3321  C11 PTQ A2001      75.585 135.861 103.962  1.00 70.60           C
HETATM 3322  C12 PTQ A2001      76.145 136.936 103.063  1.00 70.60           C
HETATM 3323  C13 PTQ A2001      77.232 136.664 102.307  1.00 70.60           C
HETATM 3324  C14 PTQ A2001      77.874 135.294 102.371  1.00 70.60           C
HETATM 3325  C1  PTQ B2001     135.230  82.304 106.501  1.00 70.54           C
HETATM 3326  O1  PTQ B2001     134.198  82.783 107.344  1.00 70.54           O
HETATM 3327  S1  PTQ B2001     135.420  83.244 105.010  1.00 70.54           S
HETATM 3328  C2  PTQ B2001     136.531  82.349 107.280  1.00 70.54           C
HETATM 3329  O2  PTQ B2001     137.554  81.734 106.548  1.00 70.54           O
HETATM 3330  C3  PTQ B2001     136.352  81.622 108.591  1.00 70.54           C
HETATM 3331  O3  PTQ B2001     137.565  81.678 109.301  1.00 70.54           O
HETATM 3332  C4  PTQ B2001     135.171  82.149 109.386  1.00 70.54           C
HETATM 3333  O4  PTQ B2001     135.273  83.531 109.599  1.00 70.54           O
HETATM 3334  C5  PTQ B2001     133.987  81.973 108.482  1.00 70.54           C
HETATM 3335  O5  PTQ B2001     132.587  81.365 110.265  1.00 70.54           O
HETATM 3336  C6  PTQ B2001     132.689  82.253 109.181  1.00 70.54           C
HETATM 3337  C7  PTQ B2001     135.833  82.196 103.638  1.00 70.54           C
HETATM 3338  C8  PTQ B2001     137.294  82.337 103.263  1.00 70.54           C
HETATM 3339  C9  PTQ B2001     137.924  80.965 103.176  1.00 70.54           C
HETATM 3340  C10 PTQ B2001     139.136  80.661 104.015  1.00 70.54           C
HETATM 3341  C11 PTQ B2001     139.708  79.444 103.963  1.00 70.54           C
HETATM 3342  C12 PTQ B2001     139.148  78.369 103.064  1.00 70.54           C
HETATM 3343  C13 PTQ B2001     138.061  78.642 102.308  1.00 70.54           C
HETATM 3344  C14 PTQ B2001     137.419  80.012 102.372  1.00 70.54           C
HETATM 3345 MG   MG  B2002     131.148  79.161 106.826  1.00 67.14          Mg
HETATM 3346 MG   MG  B2003     114.880  64.091 107.183  1.00 68.34          Mg
HETATM 3347 NA   NA  B2004     137.877  79.066 110.703  1.00 67.59          Na
HETATM 3348 NA   NA  B2005     129.650 103.686 118.947  1.00 61.13          Na
HETATM 3349  C1  PTQ C2001      80.060  82.308 108.806  1.00 70.56           C
HETATM 3350  O1  PTQ C2001      81.092  82.787 107.963  1.00 70.56           O
HETATM 3351  S1  PTQ C2001      79.870  83.248 110.297  1.00 70.56           S
HETATM 3352  C2  PTQ C2001      78.759  82.354 108.027  1.00 70.56           C
HETATM 3353  O2  PTQ C2001      77.736  81.739 108.759  1.00 70.56           O
HETATM 3354  C3  PTQ C2001      78.938  81.627 106.716  1.00 70.56           C
HETATM 3355  O3  PTQ C2001      77.725  81.683 106.006  1.00 70.56           O
HETATM 3356  C4  PTQ C2001      80.119  82.153 105.921  1.00 70.56           C
HETATM 3357  O4  PTQ C2001      80.017  83.535 105.708  1.00 70.56           O
HETATM 3358  C5  PTQ C2001      81.303  81.977 106.825  1.00 70.56           C
HETATM 3359  O5  PTQ C2001      82.703  81.370 105.042  1.00 70.56           O
HETATM 3360  C6  PTQ C2001      82.601  82.258 106.126  1.00 70.56           C
HETATM 3361  C7  PTQ C2001      79.457  82.200 111.669  1.00 70.56           C
HETATM 3362  C8  PTQ C2001      77.996  82.342 112.044  1.00 70.56           C
HETATM 3363  C9  PTQ C2001      77.365  80.970 112.131  1.00 70.56           C
HETATM 3364  C10 PTQ C2001      76.153  80.667 111.292  1.00 70.56           C
HETATM 3365  C11 PTQ C2001      75.581  79.450 111.344  1.00 70.56           C
HETATM 3366  C12 PTQ C2001      76.141  78.375 112.243  1.00 70.56           C
HETATM 3367  C13 PTQ C2001      77.228  78.647 112.999  1.00 70.56           C
HETATM 3368  C14 PTQ C2001      77.870  80.017 112.935  1.00 70.56           C
HETATM 3369  C1  PTQ D2001     135.232 132.998 108.806  1.00 70.49           C
HETATM 3370  O1  PTQ D2001     134.200 132.518 107.963  1.00 70.49           O
HETATM 3371  S1  PTQ D2001     135.422 132.058 110.297  1.00 70.49           S
HETATM 3372  C2  PTQ D2001     136.533 132.953 108.027  1.00 70.49           C
HETATM 3373  O2  PTQ D2001     137.556 133.568 108.759  1.00 70.49           O
HETATM 3374  C3  PTQ D2001     136.354 133.680 106.716  1.00 70.49           C
HETATM 3375  O3  PTQ D2001     137.567 133.624 106.006  1.00 70.49           O
HETATM 3376  C4  PTQ D2001     135.173 133.153 105.921  1.00 70.49           C
HETATM 3377  O4  PTQ D2001     135.275 131.771 105.708  1.00 70.49           O
HETATM 3378  C5  PTQ D2001     133.989 133.328 106.825  1.00 70.49           C
HETATM 3379  O5  PTQ D2001     132.589 133.936 105.042  1.00 70.49           O
HETATM 3380  C6  PTQ D2001     132.691 133.048 106.126  1.00 70.49           C
HETATM 3381  C7  PTQ D2001     135.835 133.106 111.669  1.00 70.49           C
HETATM 3382  C8  PTQ D2001     137.296 132.965 112.044  1.00 70.49           C
HETATM 3383  C9  PTQ D2001     137.927 134.337 112.131  1.00 70.49           C
HETATM 3384  C10 PTQ D2001     139.140 134.640 111.292  1.00 70.49           C
HETATM 3385  C11 PTQ D2001     139.712 135.856 111.344  1.00 70.49           C
HETATM 3386  C12 PTQ D2001     139.151 136.932 112.243  1.00 70.49           C
HETATM 3387  C13 PTQ D2001     138.064 136.660 112.999  1.00 70.49           C
HETATM 3388  C14 PTQ D2001     137.423 135.290 112.935  1.00 70.49           C
HETATM 3389 MG   MG  D2002     131.152 136.142 108.481  1.00 67.03          Mg
HETATM 3390 MG   MG  D2003     114.886 151.213 108.123  1.00 68.40          Mg
HETATM 3391 NA   NA  D2005     129.649 111.617  96.360  1.00 61.13          Na
HETATM 3392  O   HOH A2101      78.364 117.680 133.816  1.00 61.38           O
HETATM 3393  O   HOH A2102      70.372 130.560  99.857  1.00 75.31           O
HETATM 3394  O   HOH A2103     113.472 140.928 125.771  1.00 72.52           O
HETATM 3395  O   HOH A2104      88.851 130.512 107.641  1.00 65.31           O
HETATM 3396  O   HOH A2105     100.008 143.352 115.629  1.00 63.37           O
HETATM 3397  O   HOH A2106      85.109 165.148 132.903  1.00 80.04           O
HETATM 3398  O   HOH A2107      90.744 156.233 135.047  1.00 68.90           O
HETATM 3399  O   HOH A2108      41.767 132.188 130.614  1.00 77.21           O
HETATM 3400  O   HOH A2109      57.795 134.732 127.959  1.00 69.05           O
HETATM 3401  O   HOH A2110      69.224 135.049  90.933  1.00 85.72           O
HETATM 3402  O   HOH A2111      71.791 111.380 126.638  1.00 59.48           O
HETATM 3403  O   HOH A2112      92.498 146.566 131.328  1.00 70.90           O
HETATM 3404  O   HOH A2113      75.987 156.213 115.182  1.00 73.37           O
HETATM 3405  O   HOH A2114      88.134 129.961 104.083  1.00 67.35           O
HETATM 3406  O   HOH A2115      74.919 110.354 110.042  1.00 68.49           O
HETATM 3407  O   HOH A2116     102.848 140.598 135.558  1.00 73.74           O
HETATM 3408  O   HOH A2117      46.749 107.339 130.974  1.00 79.77           O
HETATM 3409  O   HOH A2118     103.498 134.368  96.710  1.00 67.81           O
HETATM 3410  O   HOH A2119      79.230 163.122 113.225  1.00 70.83           O
HETATM 3411  O   HOH A2120      93.068 122.193 101.057  1.00 65.27           O
HETATM 3412  O   HOH A2121      85.733 116.094 129.183  1.00 63.08           O
HETATM 3413  O   HOH A2122     107.196 112.146 141.975  1.00 77.32           O
HETATM 3414  O   HOH A2123      76.561 163.372 116.654  1.00 75.45           O
HETATM 3415  O   HOH A2124      35.690 111.291 119.705  1.00 75.55           O
HETATM 3416  O   HOH A2125     101.619 159.409 138.034  1.00 80.90           O
HETATM 3417  O   HOH A2126     104.325 119.335 144.359  1.00 77.59           O
HETATM 3418  O   HOH A2127     121.384 147.861 136.941  1.00 85.08           O
HETATM 3419  O   HOH A2128      68.926 150.945 126.549  1.00 79.46           O
HETATM 3420  O   HOH A2129      63.623 129.080 125.274  1.00 61.38           O
HETATM 3421  O   HOH A2130      79.854 105.559 110.550  1.00 63.82           O
HETATM 3422  O   HOH A2131      71.942 125.941 136.573  1.00 65.03           O
HETATM 3423  O   HOH A2132      68.344 112.574 123.686  1.00 51.91           O
HETATM 3424  O   HOH A2133      33.044 119.375 122.372  1.00 77.41           O
HETATM 3425  O   HOH A2134      51.677 109.059 126.271  1.00 70.47           O
HETATM 3426  O   HOH A2135     100.534 172.118 114.541  1.00 76.22           O
HETATM 3427  O   HOH A2136      82.146 135.610 106.626  1.00 66.13           O
HETATM 3428  O   HOH A2137      94.413 144.242 123.763  1.00 64.80           O
HETATM 3429  O   HOH A2138      99.248 132.177 145.422  1.00 76.98           O
HETATM 3430  O   HOH A2139      67.154 138.640  90.993  1.00 91.87           O
HETATM 3431  O   HOH A2140      85.925 147.948 117.684  1.00 63.57           O
HETATM 3432  O   HOH A2141      98.150 132.500  94.403  1.00 75.61           O
HETATM 3433  O   HOH A2142      72.170 118.466 106.001  1.00 69.17           O
HETATM 3434  O   HOH A2143      88.803 107.249 101.581  1.00 60.71           O
HETATM 3435  O   HOH A2144      84.599 156.928 121.267  1.00 67.35           O
HETATM 3436  O   HOH A2145     122.510 132.152 134.889  1.00 76.84           O
HETATM 3437  O   HOH A2146      91.120 156.179  98.055  1.00 75.60           O
HETATM 3438  O   HOH A2147     101.840 114.799 115.709  1.00 66.42           O
HETATM 3439  O   HOH A2148      95.517 138.622 130.359  1.00 67.59           O
HETATM 3440  O   HOH A2149     109.123 167.673 119.091  1.00 73.85           O
HETATM 3441  O   HOH A2150     126.011 134.311 134.862  1.00 76.71           O
HETATM 3442  O   HOH A2151      47.813 130.737  92.543  1.00 74.04           O
HETATM 3443  O   HOH A2152     110.806 130.763 125.522  1.00 67.22           O
HETATM 3444  O   HOH A2153      98.621 168.952 123.317  1.00 73.53           O
HETATM 3445  O   HOH A2154      36.892 113.723 101.890  1.00 70.15           O
HETATM 3446  O   HOH A2155      37.194 138.477 119.546  1.00 71.99           O
HETATM 3447  O   HOH A2156      97.268 171.142 108.612  1.00 80.96           O
HETATM 3448  O   HOH A2157     100.268 117.851 144.169  1.00 76.57           O
HETATM 3449  O   HOH A2158      85.209 138.474 138.111  1.00 69.37           O
HETATM 3450  O   HOH A2159      49.279 124.416 110.604  1.00 59.32           O
HETATM 3451  O   HOH A2160      83.673 147.139  98.891  1.00 72.86           O
HETATM 3452  O   HOH A2161      33.191 107.233 111.060  1.00 72.29           O
HETATM 3453  O   HOH A2162      84.173 142.567 118.583  1.00 66.48           O
HETATM 3454  O   HOH A2163      37.552 123.051 108.444  1.00 66.38           O
HETATM 3455  O   HOH A2164     104.764 120.217 127.780  1.00 71.07           O
HETATM 3456  O   HOH A2165     102.349 121.241 107.565  1.00 64.71           O
HETATM 3457  O   HOH A2166     115.156 120.216 132.997  1.00 78.70           O
HETATM 3458  O   HOH A2167      70.140 126.221 105.231  1.00 72.45           O
HETATM 3459  O   HOH A2168     106.917 163.286 102.823  1.00 74.44           O
HETATM 3460  O   HOH A2169      69.857 111.905 147.586  1.00 73.56           O
HETATM 3461  O   HOH A2170      62.635 114.689  97.714  1.00 65.91           O
HETATM 3462  O   HOH A2171      46.009 119.574 106.287  1.00 61.16           O
HETATM 3463  O   HOH A2172      70.879 134.372 130.678  1.00 64.19           O
HETATM 3464  O   HOH A2173      81.685 134.378 116.963  1.00 59.54           O
HETATM 3465  O   HOH A2174     100.561 145.107 127.237  1.00 69.49           O
HETATM 3466  O   HOH A2175      65.670 138.108 101.873  1.00 79.10           O
HETATM 3467  O   HOH A2176      45.064 120.959  87.845  1.00 74.52           O
HETATM 3468  O   HOH A2177      54.035 131.135  90.540  1.00 73.53           O
HETATM 3469  O   HOH A2178      47.116 109.181 119.644  1.00 66.54           O
HETATM 3470  O   HOH A2179      63.189 113.179 101.632  1.00 65.96           O
HETATM 3471  O   HOH A2180      71.449 136.228  96.873  1.00 87.23           O
HETATM 3472  O   HOH A2181      67.646 120.890 140.470  1.00 71.90           O
HETATM 3473  O   HOH A2182      43.823 117.431 130.704  1.00 63.59           O
HETATM 3474  O   HOH A2183      62.420  98.604 131.619  1.00 81.11           O
HETATM 3475  O   HOH A2184      64.237 123.799 128.880  1.00 59.51           O
HETATM 3476  O   HOH A2185      72.473 122.539 100.168  1.00 70.18           O
HETATM 3477  O   HOH A2186      87.821 158.804  98.654  1.00 72.78           O
HETATM 3478  O   HOH A2187      85.319 135.799 138.401  1.00 68.41           O
HETATM 3479  O   HOH A2188      54.876 128.656 134.151  1.00 68.33           O
HETATM 3480  O   HOH A2189     117.031 138.914 125.253  1.00 74.25           O
HETATM 3481  O   HOH A2190     104.892 151.515 144.762  1.00 82.71           O
HETATM 3482  O   HOH A2191      52.512 132.606 122.184  1.00 66.14           O
HETATM 3483  O   HOH A2192      84.195 167.978 114.920  1.00 72.25           O
HETATM 3484  O   HOH A2193     108.068 154.353 121.965  1.00 64.14           O
HETATM 3485  O   HOH A2194      88.449 164.529 129.842  1.00 75.81           O
HETATM 3486  O   HOH A2195     107.587 134.890 122.595  1.00 65.30           O
HETATM 3487  O   HOH A2196      76.422 123.120 140.880  1.00 68.52           O
HETATM 3488  O   HOH A2197      92.780 115.603 103.376  1.00 66.56           O
HETATM 3489  O   HOH A2198      41.109 108.345 106.182  1.00 61.21           O
HETATM 3490  O   HOH A2199     100.168 146.388 131.658  1.00 72.95           O
HETATM 3491  O   HOH A2200     108.369 156.883 122.423  1.00 66.73           O
HETATM 3492  O   HOH A2201      86.153 124.638 105.128  1.00 64.68           O
HETATM 3493  O   HOH A2202      77.805 117.377 136.484  1.00 64.44           O
HETATM 3494  O   HOH A2203      62.933 114.048 122.499  1.00 57.70           O
HETATM 3495  O   HOH A2204      51.933 112.370  95.009  1.00 71.76           O
HETATM 3496  O   HOH A2205      71.866 138.273 100.735  1.00 83.63           O
HETATM 3497  O   HOH A2206      75.173 144.792 130.017  1.00 72.77           O
HETATM 3498  O   HOH A2207      46.680 125.481 132.390  1.00 66.69           O
HETATM 3499  O   HOH A2208      90.926 129.508 110.466  1.00 62.46           O
HETATM 3500  O   HOH A2209      80.041 122.345 120.261  1.00 47.66           O
HETATM 3501  O   HOH A2210      85.818 143.401 110.364  1.00 66.19           O
HETATM 3502  O   HOH A2211      96.624 125.851  99.110  1.00 62.21           O
HETATM 3503  O   HOH A2212      87.461 144.341 135.499  1.00 72.76           O
HETATM 3504  O   HOH A2213     110.140 163.984 130.496  1.00 73.13           O
HETATM 3505  O   HOH A2214      75.653 110.875 112.796  1.00 59.83           O
HETATM 3506  O   HOH A2215      44.204 127.893 129.187  1.00 70.15           O
HETATM 3507  O   HOH A2216      53.713 127.904 120.474  1.00 57.35           O
HETATM 3508  O   HOH A2217      69.948 144.015 120.572  1.00 66.44           O
HETATM 3509  O   HOH A2218      96.261 106.325 118.825  1.00 70.14           O
HETATM 3510  O   HOH A2219      73.897 127.903 144.802  1.00 71.81           O
HETATM 3511  O   HOH A2220     108.296 151.046 112.290  1.00 64.67           O
HETATM 3512  O   HOH A2221      59.167 110.638 133.196  1.00 60.28           O
HETATM 3513  O   HOH A2222      85.069 126.990  94.473  1.00 80.03           O
HETATM 3514  O   HOH A2223      58.720 129.469 122.308  1.00 59.49           O
HETATM 3515  O   HOH A2224     108.162 164.528 117.992  1.00 69.88           O
HETATM 3516  O   HOH A2225      70.838 128.108  97.772  1.00 78.56           O
HETATM 3517  O   HOH A2226      83.931 138.168 106.462  1.00 64.59           O
HETATM 3518  O   HOH A2227     100.588 112.934 140.385  1.00 78.14           O
HETATM 3519  O   HOH A2228     104.391 113.174 128.862  1.00 77.15           O
HETATM 3520  O   HOH A2229      89.253 142.220 137.177  1.00 71.02           O
HETATM 3521  O   HOH A2230      72.158 128.254 132.919  1.00 64.13           O
HETATM 3522  O   HOH A2231      39.584 137.783 121.065  1.00 71.85           O
HETATM 3523  O   HOH A2232     112.306 153.233 125.172  1.00 72.15           O
HETATM 3524  O   HOH A2233      94.552 145.341 129.939  1.00 71.71           O
HETATM 3525  O   HOH A2234      34.700 132.238 110.694  1.00 69.84           O
HETATM 3526  O   HOH A2235     101.518 148.604 144.158  1.00 79.49           O
HETATM 3527  O   HOH A2236      89.041 123.935 114.798  1.00 54.45           O
HETATM 3528  O   HOH A2237     100.230 115.063 138.496  1.00 71.29           O
HETATM 3529  O   HOH A2238      65.181 125.405 106.299  1.00 66.68           O
HETATM 3530  O   HOH A2239      78.234 146.288 130.834  1.00 70.07           O
HETATM 3531  O   HOH A2240      49.499 110.886 111.583  1.00 60.44           O
HETATM 3532  O   HOH A2241      61.861 113.833 114.887  1.00 63.65           O
HETATM 3533  O   HOH A2242     105.673 123.416 107.367  1.00 59.06           O
HETATM 3534  O   HOH A2243     107.082 140.934 149.872  1.00 78.71           O
HETATM 3535  O   HOH A2244      97.947 123.410 137.032  1.00 59.88           O
HETATM 3536  O   HOH A2245      63.898 114.622  99.907  1.00 68.11           O
HETATM 3537  O   HOH A2246      90.983 127.881 138.792  1.00 60.89           O
HETATM 3538  O   HOH A2247      34.873 129.472 105.344  1.00 77.96           O
HETATM 3539  O   HOH A2248      70.075 125.692 128.771  1.00 57.64           O
HETATM 3540  O   HOH A2249      68.097 145.800 106.885  1.00 76.14           O
HETATM 3541  O   HOH A2250      60.944 132.413  93.725  1.00 72.73           O
HETATM 3542  O   HOH A2251      73.596 156.340 108.426  1.00 74.66           O
HETATM 3543  O   HOH A2252     123.371 138.782 136.931  1.00 80.50           O
HETATM 3544  O   HOH A2253      59.691 134.770 108.155  1.00 63.42           O
HETATM 3545  O   HOH A2254      61.549 119.357  97.028  1.00 67.08           O
HETATM 3546  O   HOH A2255      76.188 104.466 128.815  1.00 66.70           O
HETATM 3547  O   HOH A2256      87.137 144.323 123.527  1.00 65.68           O
HETATM 3548  O   HOH A2257      84.106 156.497 103.953  1.00 72.66           O
HETATM 3549  O   HOH A2258      59.766 137.336 116.408  1.00 59.62           O
HETATM 3550  O   HOH A2259      94.459 167.844 109.329  1.00 74.12           O
HETATM 3551  O   HOH A2260      58.477 149.784 118.917  1.00 81.02           O
HETATM 3552  O   HOH A2261      55.384 115.041  99.863  1.00 62.00           O
HETATM 3553  O   HOH A2262      67.390 127.245 125.625  1.00 55.55           O
HETATM 3554  O   HOH A2263      65.484 123.516  98.538  1.00 66.36           O
HETATM 3555  O   HOH A2264     104.867 145.476 119.038  1.00 65.83           O
HETATM 3556  O   HOH A2265      56.683 112.146 131.399  1.00 62.21           O
HETATM 3557  O   HOH A2266      77.036 123.155 105.175  1.00 65.63           O
HETATM 3558  O   HOH A2267      82.842 136.857 112.134  1.00 67.37           O
HETATM 3559  O   HOH A2268      54.029 105.865 122.984  1.00 71.51           O
HETATM 3560  O   HOH A2269      65.183 120.493 121.585  1.00 54.49           O
HETATM 3561  O   HOH A2270      83.589 111.045 135.815  1.00 68.71           O
HETATM 3562  O   HOH A2271      89.305 161.261 132.462  1.00 74.90           O
HETATM 3563  O   HOH A2272     125.042 138.356 132.031  1.00 79.26           O
HETATM 3564  O   HOH A2273      75.849 136.288 116.166  1.00 63.33           O
HETATM 3565  O   HOH A2274      93.557 172.074 131.022  1.00 77.81           O
HETATM 3566  O   HOH A2275      82.714 123.083 130.693  1.00 57.47           O
HETATM 3567  O   HOH A2276      89.420 152.328  98.753  1.00 74.50           O
HETATM 3568  O   HOH A2277     109.687 158.093 133.572  1.00 75.07           O
HETATM 3569  O   HOH A2278      95.104 108.535 125.415  1.00 64.15           O
HETATM 3570  O   HOH A2279      75.087 153.119 122.954  1.00 75.59           O
HETATM 3571  O   HOH A2280      78.546 112.156 143.525  1.00 74.81           O
HETATM 3572  O   HOH A2281      75.396 149.457 129.981  1.00 72.69           O
HETATM 3573  O   HOH A2282      88.061 118.299 129.052  1.00 60.35           O
HETATM 3574  O   HOH A2283      84.153 136.126 108.934  1.00 63.93           O
HETATM 3575  O   HOH A2284     111.539 154.160 118.346  1.00 65.06           O
HETATM 3576  O   HOH A2285      96.994 138.504 127.401  1.00 61.32           O
HETATM 3577  O   HOH A2286      98.211 146.610 117.739  1.00 62.23           O
HETATM 3578  O   HOH A2287      84.586 113.927 126.604  1.00 61.16           O
HETATM 3579  O   HOH A2288      39.002 119.043 102.671  1.00 67.27           O
HETATM 3580  O   HOH A2289     105.504 146.095 116.062  1.00 67.45           O
HETATM 3581  O   HOH A2290      73.535 112.614 119.190  1.00 57.95           O
HETATM 3582  O   HOH A2291      95.510 163.210 136.470  1.00 73.33           O
HETATM 3583  O   HOH A2292      67.899 118.829 109.316  1.00 61.72           O
HETATM 3584  O   HOH A2293      95.382 150.213 115.942  1.00 60.93           O
HETATM 3585  O   HOH A2294      51.087 113.298 113.044  1.00 61.04           O
HETATM 3586  O   HOH A2295      98.513 141.565  96.367  1.00 67.28           O
HETATM 3587  O   HOH A2296      80.481 147.737 101.001  1.00 77.10           O
HETATM 3588  O   HOH A2297      60.005 138.134 108.699  1.00 64.46           O
HETATM 3589  O   HOH A2298      94.184 137.689 100.806  1.00 65.92           O
HETATM 3590  O   HOH A2299      88.447 126.760 103.002  1.00 68.77           O
HETATM 3591  O   HOH A2300     100.761 135.489 128.081  1.00 59.32           O
HETATM 3592  O   HOH A2301      99.536 173.003 116.995  1.00 77.42           O
HETATM 3593  O   HOH A2302      62.929 105.084 145.094  1.00 75.30           O
HETATM 3594  O   HOH A2303      71.687 119.487  99.760  1.00 69.83           O
HETATM 3595  O   HOH A2304      90.103 141.287  92.652  1.00 73.97           O
HETATM 3596  O   HOH A2305     107.482 151.484 130.813  1.00 69.76           O
HETATM 3597  O   HOH A2306      99.423 112.526 114.410  1.00 67.68           O
HETATM 3598  O   HOH A2307      71.351 120.913 146.014  1.00 71.70           O
HETATM 3599  O   HOH A2308      79.140 148.049 102.925  1.00 79.69           O
HETATM 3600  O   HOH A2309      73.337 117.680 110.680  1.00 61.19           O
HETATM 3601  O   HOH A2310      90.649 118.305 100.478  1.00 66.96           O
HETATM 3602  O   HOH A2311      67.386 120.687 102.189  1.00 66.24           O
HETATM 3603  O   HOH A2312      86.595 120.849 138.893  1.00 66.79           O
HETATM 3604  O   HOH A2313      47.351 113.823 115.125  1.00 62.85           O
HETATM 3605  O   HOH A2314     101.780 121.592 125.415  1.00 59.85           O
HETATM 3606  O   HOH A2315      88.972 110.980 120.317  1.00 63.15           O
HETATM 3607  O   HOH A2316     100.260 120.175 108.449  1.00 63.72           O
HETATM 3608  O   HOH A2317     133.398 135.025 117.988  1.00 77.75           O
HETATM 3609  O   HOH A2318     101.382 144.388  96.141  1.00 68.35           O
HETATM 3610  O   HOH A2319      71.219 153.473 118.957  1.00 74.77           O
HETATM 3611  O   HOH A2320      83.810 152.107 128.820  1.00 68.97           O
HETATM 3612  O   HOH A2321      69.341 130.097 117.676  1.00 61.40           O
HETATM 3613  O   HOH A2322      80.063 118.609 103.540  1.00 64.17           O
HETATM 3614  O   HOH A2323      92.063 145.786 128.193  1.00 69.06           O
HETATM 3615  O   HOH A2324     119.125 128.446 136.107  1.00 74.69           O
HETATM 3616  O   HOH A2325      76.019 129.900 144.062  1.00 72.89           O
HETATM 3617  O   HOH A2326      77.484 122.778 110.048  1.00 58.72           O
HETATM 3618  O   HOH A2327      56.502 117.101  97.173  1.00 64.93           O
HETATM 3619  O   HOH A2328      37.366 126.684  99.803  1.00 75.83           O
HETATM 3620  O   HOH A2329     101.450 145.049 130.204  1.00 70.92           O
HETATM 3621  O   HOH A2330      37.849 130.474 121.136  1.00 69.55           O
HETATM 3622  O   HOH A2331     101.668 124.594 130.727  1.00 63.91           O
HETATM 3623  O   HOH A2332      33.643 135.297 120.918  1.00 75.98           O
HETATM 3624  O   HOH A2333      89.350 148.303 110.118  1.00 64.95           O
HETATM 3625  O   HOH A2334      80.161 124.766 146.997  1.00 71.56           O
HETATM 3626  O   HOH A2335      57.475 112.279 105.586  1.00 61.34           O
HETATM 3627  O   HOH A2336      98.946 117.337 112.912  1.00 60.87           O
HETATM 3628  O   HOH A2337     102.867 122.268 127.828  1.00 63.88           O
HETATM 3629  O   HOH A2338      80.400 108.211 125.725  1.00 65.02           O
HETATM 3630  O   HOH A2339      98.264 146.330 109.490  1.00 64.04           O
HETATM 3631  O   HOH A2340      55.339 107.437 100.757  1.00 67.16           O
HETATM 3632  O   HOH A2341      78.637 138.831 135.646  1.00 68.30           O
HETATM 3633  O   HOH A2342      45.559 128.412 106.256  1.00 65.82           O
HETATM 3634  O   HOH A2343      70.572 150.846 104.995  1.00 76.41           O
HETATM 3635  O   HOH A2344      95.013 133.614 134.699  1.00 66.36           O
HETATM 3636  O   HOH A2345     101.468 152.417  99.914  1.00 69.32           O
HETATM 3637  O   HOH A2346      87.436 111.872 124.377  1.00 61.55           O
HETATM 3638  O   HOH A2347     103.906 147.228 144.341  1.00 76.57           O
HETATM 3639  O   HOH A2348      73.414 113.550 124.718  1.00 52.57           O
HETATM 3640  O   HOH A2349      96.456 139.829 115.714  1.00 60.44           O
HETATM 3641  O   HOH A2350      78.791 140.377 101.997  1.00 72.57           O
HETATM 3642  O   HOH A2351      65.465 114.781 126.238  1.00 52.47           O
HETATM 3643  O   HOH A2352      87.524 145.890 106.461  1.00 68.00           O
HETATM 3644  O   HOH A2353      93.887 125.100 105.742  1.00 60.56           O
HETATM 3645  O   HOH A2354     114.714 148.613 144.366  1.00 77.87           O
HETATM 3646  O   HOH A2355      87.261 170.985 110.121  1.00 71.64           O
HETATM 3647  O   HOH A2356      52.027 126.314  88.897  1.00 76.06           O
HETATM 3648  O   HOH A2357      87.652 150.838 111.928  1.00 64.72           O
HETATM 3649  O   HOH A2358     107.227 119.507 144.200  1.00 76.05           O
HETATM 3650  O   HOH A2359      52.958 109.626 105.256  1.00 62.76           O
HETATM 3651  O   HOH A2360      98.527 137.501  95.354  1.00 70.55           O
HETATM 3652  O   HOH A2361     118.526 143.742 126.644  1.00 79.65           O
HETATM 3653  O   HOH A2362      95.961 148.855 119.658  1.00 63.57           O
HETATM 3654  O   HOH A2363      87.039 128.091 138.995  1.00 64.77           O
HETATM 3655  O   HOH A2364      77.253 143.714 102.480  1.00 76.38           O
HETATM 3656  O   HOH A2365      59.835 116.105 109.494  1.00 61.10           O
HETATM 3657  O   HOH A2366     100.754 142.804 126.705  1.00 68.75           O
HETATM 3658  O   HOH A2367      58.082 135.672 124.464  1.00 66.53           O
HETATM 3659  O   HOH A2368     101.499 125.685 126.184  1.00 59.70           O
HETATM 3660  O   HOH A2369     103.364 144.235 104.799  1.00 63.99           O
HETATM 3661  O   HOH A2370     103.867 173.037 121.801  1.00 78.85           O
HETATM 3662  O   HOH A2371     105.731 154.438 140.405  1.00 75.92           O
HETATM 3663  O   HOH A2372      70.149 134.011 116.432  1.00 63.82           O
HETATM 3664  O   HOH A2373      76.713 162.421 119.044  1.00 73.99           O
HETATM 3665  O   HOH A2374      59.788 117.742  94.832  1.00 68.08           O
HETATM 3666  O   HOH A2375      77.003 124.902 101.564  1.00 72.38           O
HETATM 3667  O   HOH A2376     110.413 128.559 128.977  1.00 72.24           O
HETATM 3668  O   HOH A2377     106.148 123.298 149.927  1.00 79.66           O
HETATM 3669  O   HOH A2378      97.054 128.855 143.031  1.00 72.57           O
HETATM 3670  O   HOH A2379      76.903 117.009 131.604  1.00 53.74           O
HETATM 3671  O   HOH A2380      54.635 110.616 131.052  1.00 68.97           O
HETATM 3672  O   HOH A2381      82.612 108.247 122.462  1.00 65.19           O
HETATM 3673  O   HOH A2382      96.739 131.408 140.636  1.00 69.16           O
HETATM 3674  O   HOH A2383      98.800 128.837  97.599  1.00 66.75           O
HETATM 3675  O   HOH A2384      66.734 129.664 110.745  1.00 65.13           O
HETATM 3676  O   HOH A2385     106.354 140.897 116.888  1.00 63.66           O
HETATM 3677  O   HOH A2386      76.043 105.012 144.352  1.00 75.39           O
HETATM 3678  O   HOH A2387      64.982 132.467 126.904  1.00 66.38           O
HETATM 3679  O   HOH A2388     127.952 134.655 125.779  1.00 75.83           O
HETATM 3680  O   HOH A2389      77.465 113.557  99.166  1.00 72.69           O
HETATM 3681  O   HOH A2390      42.533 129.556 109.109  1.00 66.50           O
HETATM 3682  O   HOH A2391      68.701 136.143 112.431  1.00 70.09           O
HETATM 3683  O   HOH A2392      64.951 134.587 112.785  1.00 66.07           O
HETATM 3684  O   HOH A2393     115.220 125.559 141.479  1.00 78.54           O
HETATM 3685  O   HOH A2394     130.097 125.408 114.486  1.00 72.41           O
HETATM 3686  O   HOH A2395      85.671 135.218 122.696  1.00 58.60           O
HETATM 3687  O   HOH A2396      80.500 122.455 131.677  1.00 56.30           O
HETATM 3688  O   HOH A2397      54.960 111.962 121.848  1.00 63.72           O
HETATM 3689  O   HOH A2398      89.001 121.128 100.811  1.00 66.12           O
HETATM 3690  O   HOH A2399      49.276 117.919  90.093  1.00 73.92           O
HETATM 3691  O   HOH A2400      77.710 137.008 114.896  1.00 64.60           O
HETATM 3692  O   HOH A2401      92.885 118.633 135.448  1.00 58.97           O
HETATM 3693  O   HOH A2402      85.543 145.437 133.392  1.00 74.53           O
HETATM 3694  O   HOH A2403     100.539 134.259  94.153  1.00 71.32           O
HETATM 3695  O   HOH A2404      37.029 120.894 105.549  1.00 67.96           O
HETATM 3696  O   HOH A2405     112.878 155.523 128.487  1.00 71.84           O
HETATM 3697  O   HOH A2406     115.280 130.606 145.026  1.00 74.85           O
HETATM 3698  O   HOH A2407      66.358 152.062 110.801  1.00 75.18           O
HETATM 3699  O   HOH A2408      95.987 149.215 128.883  1.00 64.22           O
HETATM 3700  O   HOH A2409      65.516 144.633 122.106  1.00 67.45           O
HETATM 3701  O   HOH A2410     101.226 136.480  94.751  1.00 70.33           O
HETATM 3702  O   HOH A2411      80.896 128.280 144.717  1.00 72.65           O
HETATM 3703  O   HOH A2412     101.971 120.855 120.810  1.00 57.93           O
HETATM 3704  O   HOH A2413      48.898 126.904 102.917  1.00 65.03           O
HETATM 3705  O   HOH A2414      76.042 122.898  99.907  1.00 73.78           O
HETATM 3706  O   HOH A2415     101.535 120.706 144.076  1.00 71.50           O
HETATM 3707  O   HOH A2416     131.639 136.031 121.122  1.00 74.90           O
HETATM 3708  O   HOH A2417      89.431 169.288 128.924  1.00 74.83           O
HETATM 3709  O   HOH A2418     104.696 128.796 125.072  1.00 63.31           O
HETATM 3710  O   HOH A2419     105.347 127.840 151.685  1.00 78.40           O
HETATM 3711  O   HOH A2420      71.967  99.771 141.506  1.00 82.89           O
HETATM 3712  O   HOH A2421      90.760 128.109 112.822  1.00 59.82           O
HETATM 3713  O   HOH A2422      26.035 118.029  99.738  1.00 78.91           O
HETATM 3714  O   HOH A2423      94.078 170.109 105.242  1.00 79.49           O
HETATM 3715  O   HOH A2424      80.861 152.032 123.091  1.00 68.34           O
HETATM 3716  O   HOH A2425      82.911 167.377 112.061  1.00 66.71           O
HETATM 3717  O   HOH A2426      68.608 141.090 123.258  1.00 66.00           O
HETATM 3718  O   HOH A2427      85.036 116.792 114.577  1.00 52.02           O
HETATM 3719  O   HOH A2428      53.816 114.230 116.423  1.00 61.91           O
HETATM 3720  O   HOH A2429      82.195 166.318 119.069  1.00 74.33           O
HETATM 3721  O   HOH A2430     111.921 125.393 118.247  1.00 66.88           O
HETATM 3722  O   HOH A2431      86.043 111.846  96.199  1.00 66.25           O
HETATM 3723  O   HOH A2432      87.363 112.723 121.250  1.00 59.12           O
HETATM 3724  O   HOH A2433      81.461 119.937 133.281  1.00 62.63           O
HETATM 3725  O   HOH A2434      91.834 161.091 103.725  1.00 72.26           O
HETATM 3726  O   HOH A2435      56.558 143.030 119.624  1.00 71.20           O
HETATM 3727  O   HOH A2436      99.770 139.064 135.499  1.00 76.64           O
HETATM 3728  O   HOH A2437      47.662 119.293  88.312  1.00 73.07           O
HETATM 3729  O   HOH A2438      64.263 132.068 111.941  1.00 66.19           O
HETATM 3730  O   HOH A2439      69.866 128.204 103.820  1.00 70.85           O
HETATM 3731  O   HOH A2440      92.184 111.083 134.257  1.00 70.29           O
HETATM 3732  O   HOH A2441      92.191 167.485 126.882  1.00 71.24           O
HETATM 3733  O   HOH A2442      85.736 119.207 129.421  1.00 59.51           O
HETATM 3734  O   HOH A2443     110.089 134.813 143.012  1.00 73.69           O
HETATM 3735  O   HOH A2444      77.585 107.877 118.659  1.00 59.60           O
HETATM 3736  O   HOH A2445      96.588 141.608 137.399  1.00 78.53           O
HETATM 3737  O   HOH A2446      97.264 110.277 130.827  1.00 64.65           O
HETATM 3738  O   HOH A2447     118.323 131.756 128.445  1.00 74.95           O
HETATM 3739  O   HOH A2448      39.996 111.867 105.460  1.00 61.18           O
HETATM 3740  O   HOH A2449      75.403 111.549 120.829  1.00 58.01           O
HETATM 3741  O   HOH A2450      76.306 121.795 132.878  1.00 56.49           O
HETATM 3742  O   HOH A2451      73.703 111.012 122.894  1.00 61.66           O
HETATM 3743  O   HOH A2452      85.100 123.166 135.378  1.00 63.60           O
HETATM 3744  O   HOH A2453      36.584 111.665 111.567  1.00 65.48           O
HETATM 3745  O   HOH A2454     104.220 114.986 145.692  1.00 79.63           O
HETATM 3746  O   HOH A2455      86.607 136.860 119.651  1.00 61.71           O
HETATM 3747  O   HOH A2456      82.721 151.443  97.622  1.00 75.53           O
HETATM 3748  O   HOH A2457      54.855 130.445 114.661  1.00 61.39           O
HETATM 3749  O   HOH A2458     101.727 157.156 141.413  1.00 82.59           O
HETATM 3750  O   HOH A2459     121.602 132.041 126.075  1.00 79.06           O
HETATM 3751  O   HOH A2460      96.304 112.600 132.741  1.00 63.50           O
HETATM 3752  O   HOH A2461      83.584 103.977 137.615  1.00 71.20           O
HETATM 3753  O   HOH A2462      70.167 106.602 125.378  1.00 65.20           O
HETATM 3754  O   HOH A2463      59.694 125.884  92.708  1.00 71.03           O
HETATM 3755  O   HOH A2464      86.215 139.023 125.637  1.00 62.85           O
HETATM 3756  O   HOH A2465      42.410 125.043 130.114  1.00 65.83           O
HETATM 3757  O   HOH A2466      50.926 131.567 113.797  1.00 64.61           O
HETATM 3758  O   HOH A2467      66.327 124.674  93.204  1.00 76.36           O
HETATM 3759  O   HOH A2468      94.139 108.099 105.315  1.00 64.65           O
HETATM 3760  O   HOH A2469      52.282 130.804 106.135  1.00 66.71           O
HETATM 3761  O   HOH A2470     103.449 147.516 121.776  1.00 63.72           O
HETATM 3762  O   HOH A2471      36.266 112.979  99.770  1.00 70.32           O
HETATM 3763  O   HOH A2472      90.020 165.854 121.297  1.00 68.28           O
HETATM 3764  O   HOH A2473     105.480 150.838  97.643  1.00 65.94           O
HETATM 3765  O   HOH A2474      59.397 119.530 103.334  1.00 58.70           O
HETATM 3766  O   HOH A2475      76.349 108.145 123.420  1.00 65.06           O
HETATM 3767  O   HOH A2476     114.940 152.679 137.893  1.00 79.45           O
HETATM 3768  O   HOH A2477      75.614 141.450 100.259  1.00 80.79           O
HETATM 3769  O   HOH A2478     106.725 126.404 124.031  1.00 62.99           O
HETATM 3770  O   HOH A2479      84.283 128.231 103.957  1.00 71.39           O
HETATM 3771  O   HOH A2480      53.851 144.240 109.946  1.00 71.53           O
HETATM 3772  O   HOH A2481     100.503 110.191 137.885  1.00 78.13           O
HETATM 3773  O   HOH A2482      66.817 127.245 102.007  1.00 68.57           O
HETATM 3774  O   HOH A2483      72.926 109.357 126.415  1.00 61.54           O
HETATM 3775  O   HOH A2484      93.044 117.840 140.301  1.00 64.87           O
HETATM 3776  O   HOH A2485      98.237 119.151 103.395  1.00 64.62           O
HETATM 3777  O   HOH A2486      52.724 143.984 111.972  1.00 68.32           O
HETATM 3778  O   HOH A2487     108.510 140.548 102.441  1.00 62.53           O
HETATM 3779  O   HOH A2488      94.232 147.885 111.875  1.00 62.99           O
HETATM 3780  O   HOH A2489      63.478 144.365 119.330  1.00 67.82           O
HETATM 3781  O   HOH A2490      99.150 133.393 132.662  1.00 65.76           O
HETATM 3782  O   HOH A2491     108.827 160.722 118.204  1.00 69.27           O
HETATM 3783  O   HOH A2492      73.061 138.993 102.746  1.00 78.10           O
HETATM 3784  O   HOH A2493      45.665 126.888 102.406  1.00 68.85           O
HETATM 3785  O   HOH A2494     109.644 152.417 114.787  1.00 65.10           O
HETATM 3786  O   HOH A2495      29.238 112.720 104.875  1.00 72.76           O
HETATM 3787  O   HOH A2496      74.928 102.348 141.642  1.00 77.72           O
HETATM 3788  O   HOH A2497     110.111 146.132 128.504  1.00 71.90           O
HETATM 3789  O   HOH A2498      83.328 118.604 141.535  1.00 72.41           O
HETATM 3790  O   HOH A2499      30.784 133.429 112.202  1.00 71.17           O
HETATM 3791  O   HOH A2500      56.606 112.665  96.899  1.00 66.44           O
HETATM 3792  O   HOH A2501      92.986 151.142 123.739  1.00 63.11           O
HETATM 3793  O   HOH A2502     108.817 164.770 115.195  1.00 72.84           O
HETATM 3794  O   HOH A2503      91.607 146.594  93.377  1.00 78.17           O
HETATM 3795  O   HOH A2504      74.191 142.322 127.091  1.00 68.74           O
HETATM 3796  O   HOH A2505      94.118 117.172 133.747  1.00 56.75           O
HETATM 3797  O   HOH A2506      80.101 145.953 127.832  1.00 72.31           O
HETATM 3798  O   HOH A2507      70.880 120.684 109.236  1.00 63.31           O
HETATM 3799  O   HOH A2508      55.296 125.018 101.745  1.00 60.77           O
HETATM 3800  O   HOH A2509      66.527 140.329 124.089  1.00 68.08           O
HETATM 3801  O   HOH A2510     127.643 138.768 141.840  1.00 85.22           O
HETATM 3802  O   HOH A2511      68.363 126.526  91.213  1.00 81.61           O
HETATM 3803  O   HOH A2512      43.658 113.146  99.830  1.00 63.90           O
HETATM 3804  O   HOH A2513     124.731 138.445 125.066  1.00 74.05           O
HETATM 3805  O   HOH A2514      81.668 122.257 144.080  1.00 69.03           O
HETATM 3806  O   HOH A2515      86.624 146.375 108.545  1.00 68.25           O
HETATM 3807  O   HOH A2516      43.167 140.098 114.371  1.00 68.72           O
HETATM 3808  O   HOH A2517      94.432 134.269 107.898  1.00 60.47           O
HETATM 3809  O   HOH A2518      59.351 136.159 102.237  1.00 69.76           O
HETATM 3810  O   HOH A2519      75.391 111.260 101.527  1.00 70.16           O
HETATM 3811  O   HOH A2520      66.671 128.720 118.630  1.00 59.05           O
HETATM 3812  O   HOH A2521      94.374 153.427 138.064  1.00 70.70           O
HETATM 3813  O   HOH A2522     102.850 170.945 118.229  1.00 77.72           O
HETATM 3814  O   HOH A2523      96.858 135.271 143.185  1.00 74.11           O
HETATM 3815  O   HOH A2524      41.646 139.761 121.223  1.00 71.54           O
HETATM 3816  O   HOH A2525     112.930 144.652 148.563  1.00 77.89           O
HETATM 3817  O   HOH A2526     111.326 127.478 120.977  1.00 65.22           O
HETATM 3818  O   HOH A2527      40.872 122.624 128.294  1.00 66.17           O
HETATM 3819  O   HOH A2528     106.364 136.697 125.286  1.00 68.63           O
HETATM 3820  O   HOH A2529      46.278 111.159 122.034  1.00 64.69           O
HETATM 3821  O   HOH A2530      93.457 130.353  98.306  1.00 69.51           O
HETATM 3822  O   HOH A2531      83.693 160.791 106.225  1.00 70.69           O
HETATM 3823  O   HOH A2532     105.370 130.353 126.854  1.00 66.12           O
HETATM 3824  O   HOH A2533      83.943 120.617 136.120  1.00 67.59           O
HETATM 3825  O   HOH A2534      55.930 107.919 121.760  1.00 70.94           O
HETATM 3826  O   HOH A2535      58.436 101.222 124.731  1.00 72.62           O
HETATM 3827  O   HOH A2536      79.233 135.828 118.994  1.00 57.07           O
HETATM 3828  O   HOH A2537      73.448 127.276 137.827  1.00 66.25           O
HETATM 3829  O   HOH A2538      95.832 116.702 138.445  1.00 63.81           O
HETATM 3830  O   HOH A2539     109.063 161.862 103.229  1.00 67.70           O
HETATM 3831  O   HOH A2540      84.077 101.573 134.168  1.00 74.39           O
HETATM 3832  O   HOH A2541      92.187 171.543 108.298  1.00 79.34           O
HETATM 3833  O   HOH A2542      60.013 136.579 105.886  1.00 68.05           O
HETATM 3834  O   HOH A2543      33.601 111.662 117.283  1.00 72.11           O
HETATM 3835  O   HOH A2544     107.200 142.530 119.211  1.00 68.20           O
HETATM 3836  O   HOH A2545      99.808 144.614 110.935  1.00 64.34           O
HETATM 3837  O   HOH A2546      54.581 104.086 119.685  1.00 71.66           O
HETATM 3838  O   HOH A2547      78.656 125.171 103.236  1.00 73.39           O
HETATM 3839  O   HOH A2548      95.710 109.076 111.901  1.00 63.06           O
HETATM 3840  O   HOH A2549      60.315 149.641 120.405  1.00 82.91           O
HETATM 3841  O   HOH A2550      98.630 138.715 137.507  1.00 75.63           O
HETATM 3842  O   HOH A2551      75.338 130.262  98.910  1.00 77.66           O
HETATM 3843  O   HOH A2552      58.262 140.565 119.950  1.00 68.14           O
HETATM 3844  O   HOH A2553      94.111 175.308 113.647  1.00 73.13           O
HETATM 3845  O   HOH A2554     104.034 155.824 104.700  1.00 68.47           O
HETATM 3846  O   HOH A2555     105.507 146.163 102.158  1.00 69.55           O
HETATM 3847  O   HOH A2556     109.030 142.183 148.279  1.00 78.78           O
HETATM 3848  O   HOH A2557      45.462 112.447 126.777  1.00 65.19           O
HETATM 3849  O   HOH A2558      63.837 132.257 124.195  1.00 66.82           O
HETATM 3850  O   HOH A2559      63.199 128.868  92.743  1.00 80.12           O
HETATM 3851  O   HOH A2560     112.779 149.594 141.613  1.00 77.81           O
HETATM 3852  O   HOH A2561     108.215 146.080 125.588  1.00 67.25           O
HETATM 3853  O   HOH A2562      87.002 146.687 125.969  1.00 66.57           O
HETATM 3854  O   HOH A2563     101.457 155.866 101.829  1.00 69.98           O
HETATM 3855  O   HOH A2564      47.567 109.295 123.680  1.00 63.88           O
HETATM 3856  O   HOH A2565      69.127 116.286 110.178  1.00 64.39           O
HETATM 3857  O   HOH A2566      76.621 105.832 112.289  1.00 67.16           O
HETATM 3858  O   HOH A2567      52.367 119.181  86.748  1.00 76.17           O
HETATM 3859  O   HOH A2568     111.395 135.329 115.692  1.00 62.42           O
HETATM 3860  O   HOH A2569      73.797 150.463 120.528  1.00 71.71           O
HETATM 3861  O   HOH A2570     104.311 120.527 109.620  1.00 63.21           O
HETATM 3862  O   HOH A2571      58.753 113.874  95.312  1.00 70.15           O
HETATM 3863  O   HOH A2572      75.573 133.985 133.468  1.00 62.63           O
HETATM 3864  O   HOH A2573     126.236 132.292 131.147  1.00 80.66           O
HETATM 3865  O   HOH A2574      67.749 140.801 121.137  1.00 66.57           O
HETATM 3866  O   HOH A2575      75.235 117.441 108.664  1.00 61.14           O
HETATM 3867  O   HOH A2576      48.898 137.772 124.779  1.00 71.59           O
HETATM 3868  O   HOH A2577      71.629 125.503 132.077  1.00 57.27           O
HETATM 3869  O   HOH A2578      59.950 132.159 124.651  1.00 64.49           O
HETATM 3870  O   HOH A2579      54.343 132.922 116.534  1.00 64.13           O
HETATM 3871  O   HOH A2580     102.072 143.038 124.173  1.00 66.22           O
HETATM 3872  O   HOH A2581      76.244 124.483 147.721  1.00 68.05           O
HETATM 3873  O   HOH A2582      94.395 174.355 110.943  1.00 78.35           O
HETATM 3874  O   HOH A2583     105.655 117.237 128.341  1.00 70.68           O
HETATM 3875  O   HOH A2584      94.454 171.983 109.483  1.00 77.74           O
HETATM 3876  O   HOH A2585      69.597 139.639 119.939  1.00 64.67           O
HETATM 3877  O   HOH A2586      89.273 143.099 113.584  1.00 64.02           O
HETATM 3878  O   HOH A2587      91.547 120.606 142.742  1.00 67.44           O
HETATM 3879  O   HOH A2588      69.266 117.940 116.807  1.00 55.86           O
HETATM 3880  O   HOH A2589      95.798 137.129 137.032  1.00 72.65           O
HETATM 3881  O   HOH A2590      88.180 114.121 140.613  1.00 71.92           O
HETATM 3882  O   HOH A2591      92.276 158.413 104.041  1.00 69.58           O
HETATM 3883  O   HOH A2592      93.556 126.336 141.418  1.00 63.30           O
HETATM 3884  O   HOH A2593      84.863 150.477 111.034  1.00 68.40           O
HETATM 3885  O   HOH A2594     106.603 142.886 115.536  1.00 65.97           O
HETATM 3886  O   HOH A2595      84.948 146.909 113.956  1.00 64.81           O
HETATM 3887  O   HOH A2596      74.796 115.324 106.571  1.00 65.07           O
HETATM 3888  O   HOH A2597      60.737 120.799  93.198  1.00 68.30           O
HETATM 3889  O   HOH A2598     104.258 124.181 128.189  1.00 68.20           O
HETATM 3890  O   HOH A2599     101.662 138.122 133.101  1.00 72.91           O
HETATM 3891  O   HOH A2600      85.592 147.571  95.119  1.00 74.63           O
HETATM 3892  O   HOH A2601      28.874 131.606 102.136  1.00 82.45           O
HETATM 3893  O   HOH A2602      66.425 106.433 145.970  1.00 77.65           O
HETATM 3894  O   HOH A2603      67.594 124.846 104.555  1.00 69.80           O
HETATM 3895  O   HOH A2604     108.522 158.121 120.424  1.00 64.66           O
HETATM 3896  O   HOH A2605     105.378 162.190 100.496  1.00 73.07           O
HETATM 3897  O   HOH A2606      50.430 130.448 115.988  1.00 63.09           O
HETATM 3898  O   HOH A2607      90.239 141.859  95.094  1.00 73.04           O
HETATM 3899  O   HOH A2608      93.068 150.466 132.171  1.00 71.64           O
HETATM 3900  O   HOH A2609     110.052 124.560 113.228  1.00 59.99           O
HETATM 3901  O   HOH A2610     113.563 156.001 130.807  1.00 74.17           O
HETATM 3902  O   HOH A2611     107.488 122.281 116.568  1.00 63.99           O
HETATM 3903  O   HOH A2612     100.934 119.933 116.697  1.00 63.94           O
HETATM 3904  O   HOH A2613      77.796 129.561 142.156  1.00 69.56           O
HETATM 3905  O   HOH A2614      99.983 163.141 101.051  1.00 72.22           O
HETATM 3906  O   HOH A2615      90.663 165.799 129.374  1.00 71.42           O
HETATM 3907  O   HOH A2616      67.995 102.430 142.662  1.00 84.18           O
HETATM 3908  O   HOH A2617      53.301 125.361  90.629  1.00 72.24           O
HETATM 3909  O   HOH A2618     102.322 110.516 116.126  1.00 71.65           O
HETATM 3910  O   HOH A2619      65.775 112.385 126.146  1.00 56.77           O
HETATM 3911  O   HOH A2620      79.005 152.411 100.741  1.00 78.85           O
HETATM 3912  O   HOH A2621      98.879 115.382 125.986  1.00 60.29           O
HETATM 3913  O   HOH A2622      96.933 108.980 120.265  1.00 65.14           O
HETATM 3914  O   HOH A2623     111.319 135.345 127.645  1.00 72.51           O
HETATM 3915  O   HOH A2624      83.048 107.922 127.527  1.00 70.48           O
HETATM 3916  O   HOH A2625      82.441 166.477 116.705  1.00 72.35           O
HETATM 3917  O   HOH A2626     110.261 123.668 117.312  1.00 64.88           O
HETATM 3918  O   HOH A2627      70.629 143.922 102.761  1.00 78.31           O
HETATM 3919  O   HOH A2628      20.463 114.717 112.839  1.00 79.75           O
HETATM 3920  O   HOH A2629      61.953 112.094 124.982  1.00 63.21           O
HETATM 3921  O   HOH A2630     103.283 113.732 119.285  1.00 69.95           O
HETATM 3922  O   HOH A2631      48.166 130.092 100.219  1.00 70.95           O
HETATM 3923  O   HOH A2632      82.079 141.450  97.239  1.00 75.27           O
HETATM 3924  O   HOH A2633      78.419 137.475 112.632  1.00 65.69           O
HETATM 3925  O   HOH A2634      79.294 162.196 122.901  1.00 74.40           O
HETATM 3926  O   HOH A2635      99.278 166.467 122.771  1.00 67.51           O
HETATM 3927  O   HOH A2636      63.305 144.501 116.794  1.00 66.23           O
HETATM 3928  O   HOH A2637      54.654 123.108  91.646  1.00 69.79           O
HETATM 3929  O   HOH A2638      89.840 168.304 122.091  1.00 76.14           O
HETATM 3930  O   HOH A2639      85.549 153.922 131.340  1.00 68.93           O
HETATM 3931  O   HOH A2640      62.540 105.588 124.107  1.00 65.25           O
HETATM 3932  O   HOH A2641     106.251 169.395 124.646  1.00 75.14           O
HETATM 3933  O   HOH A2642     101.218 169.019 103.890  1.00 79.99           O
HETATM 3934  O   HOH A2643      85.128 109.129 119.838  1.00 59.42           O
HETATM 3935  O   HOH A2644      54.506 130.760 118.397  1.00 61.35           O
HETATM 3936  O   HOH A2645      89.493 139.399 137.890  1.00 71.80           O
HETATM 3937  O   HOH A2646      96.284 148.910 138.666  1.00 77.37           O
HETATM 3938  O   HOH A2647      81.019 151.129 127.945  1.00 72.04           O
HETATM 3939  O   HOH A2648     118.032 128.304 143.436  1.00 76.53           O
HETATM 3940  O   HOH A2649      79.485 126.897 101.852  1.00 75.50           O
HETATM 3941  O   HOH A2650      99.442 156.866 100.034  1.00 70.89           O
HETATM 3942  O   HOH A2651      56.230 127.304 103.244  1.00 63.19           O
HETATM 3943  O   HOH A2652      71.672 133.849  93.107  1.00 85.83           O
HETATM 3944  O   HOH A2653      84.423 153.410  99.555  1.00 74.94           O
HETATM 3945  O   HOH A2654      68.312 134.765 105.901  1.00 73.62           O
HETATM 3946  O   HOH A2655      55.379 123.439 133.248  1.00 62.29           O
HETATM 3947  O   HOH A2656      48.356 133.545 108.216  1.00 68.16           O
HETATM 3948  O   HOH A2657     130.692 135.256 124.190  1.00 75.87           O
HETATM 3949  O   HOH A2658      55.529 105.799 118.452  1.00 70.93           O
HETATM 3950  O   HOH A2659      70.053 118.958 102.391  1.00 69.83           O
HETATM 3951  O   HOH A2660      61.711 123.488  92.766  1.00 73.46           O
HETATM 3952  O   HOH A2661     105.233 141.366  95.294  1.00 68.27           O
HETATM 3953  O   HOH A2662      86.746 116.659 126.411  1.00 57.80           O
HETATM 3954  O   HOH A2663      60.282 147.677 121.682  1.00 81.03           O
HETATM 3955  O   HOH A2664      98.257 135.295 134.211  1.00 71.98           O
HETATM 3956  O   HOH A2665      64.786 138.470 123.856  1.00 65.88           O
HETATM 3957  O   HOH A2666      42.047 113.451 127.585  1.00 65.98           O
HETATM 3958  O   HOH A2667      51.061 135.398 128.526  1.00 68.72           O
HETATM 3959  O   HOH A2668      73.110 121.717 112.730  1.00 59.90           O
HETATM 3960  O   HOH A2669      67.513  98.821 143.207  1.00 86.44           O
HETATM 3961  O   HOH A2670      59.836 102.797 122.289  1.00 70.57           O
HETATM 3962  O   HOH A2671      56.712 115.790 111.313  1.00 61.63           O
HETATM 3963  O   HOH A2672      78.993 119.948 133.523  1.00 63.25           O
HETATM 3964  O   HOH A2673      67.892 123.344 138.065  1.00 68.54           O
HETATM 3965  O   HOH A2674      52.311 105.206 142.165  1.00 76.57           O
HETATM 3966  O   HOH A2675      58.343 145.165 108.151  1.00 69.91           O
HETATM 3967  O   HOH A2676      69.339 103.259 125.626  1.00 70.82           O
HETATM 3968  O   HOH A2677      58.911 106.067 144.419  1.00 71.31           O
HETATM 3969  O   HOH A2678      63.201 102.415 125.373  1.00 68.27           O
HETATM 3970  O   HOH A2679      60.940 128.010 124.015  1.00 59.33           O
HETATM 3971  O   HOH A2680      81.328 152.500 126.032  1.00 70.36           O
HETATM 3972  O   HOH A2681     111.045 139.481 147.852  1.00 76.24           O
HETATM 3973  O   HOH A2682      82.132 153.592 103.643  1.00 74.13           O
HETATM 3974  O   HOH A2683      91.839 173.859 119.560  1.00 76.70           O
HETATM 3975  O   HOH A2684      83.104 155.493 106.152  1.00 68.85           O
HETATM 3976  O   HOH A2685      47.552 135.795 127.159  1.00 70.20           O
HETATM 3977  O   HOH A2686      33.824 135.703 116.529  1.00 71.96           O
HETATM 3978  O   HOH A2687      33.874 129.786  98.008  1.00 82.23           O
HETATM 3979  O   HOH A2688      73.814 142.981 100.166  1.00 82.88           O
HETATM 3980  O   HOH A2689      79.090 155.041 108.175  1.00 73.36           O
HETATM 3981  O   HOH A2690      85.599 126.563 137.857  1.00 64.47           O
HETATM 3982  O   HOH A2691      68.342 122.191 131.704  1.00 58.36           O
HETATM 3983  O   HOH A2692      65.775 115.846 116.682  1.00 59.26           O
HETATM 3984  O   HOH A2693     110.699 147.612 123.131  1.00 67.09           O
HETATM 3985  O   HOH A2694      75.493 130.761 138.703  1.00 68.18           O
HETATM 3986  O   HOH A2695      65.196 123.037 121.218  1.00 58.15           O
HETATM 3987  O   HOH A2696      53.914 136.084 131.190  1.00 71.05           O
HETATM 3988  O   HOH A2697      81.578 133.249 139.916  1.00 69.89           O
HETATM 3989  O   HOH A2698      46.423 137.903 109.684  1.00 69.10           O
HETATM 3990  O   HOH A2699      77.222 157.830 108.747  1.00 73.21           O
HETATM 3991  O   HOH A2700     107.438 128.814 126.708  1.00 69.37           O
HETATM 3992  O   HOH A2701      59.068 111.239 103.777  1.00 63.80           O
HETATM 3993  O   HOH A2702      48.595 131.441 111.055  1.00 63.18           O
HETATM 3994  O   HOH A2703      34.293 120.060 119.402  1.00 71.11           O
HETATM 3995  O   HOH A2704     110.373 158.422 125.437  1.00 64.90           O
HETATM 3996  O   HOH A2705      83.217 105.237 119.845  1.00 62.72           O
HETATM 3997  O   HOH A2706      79.274 160.184 124.408  1.00 73.40           O
HETATM 3998  O   HOH A2707     101.793 118.367 118.712  1.00 63.68           O
HETATM 3999  O   HOH A2708      46.717 135.234 108.154  1.00 70.39           O
HETATM 4000  O   HOH A2709      50.838 109.454 107.106  1.00 59.03           O
HETATM 4001  O   HOH A2710      59.943 113.836 107.408  1.00 65.27           O
HETATM 4002  O   HOH A2711     121.376 146.905 146.607  1.00 83.14           O
HETATM 4003  O   HOH A2712      60.423 103.242 118.350  1.00 70.51           O
HETATM 4004  O   HOH A2713      57.534 147.011 120.412  1.00 75.77           O
HETATM 4005  O   HOH A2714     109.977 151.212 143.694  1.00 80.30           O
HETATM 4006  O   HOH A2715      78.088 113.806 145.383  1.00 78.17           O
HETATM 4007  O   HOH A2716      30.369 135.844 120.557  1.00 77.83           O
HETATM 4008  O   HOH A2717      32.117 125.917  96.037  1.00 82.92           O
HETATM 4009  O   HOH A2718     111.386 153.177 139.354  1.00 76.41           O
HETATM 4010  O   HOH A2719      58.113 139.042 103.103  1.00 71.12           O
HETATM 4011  O   HOH A2720      54.176 147.956 112.906  1.00 68.96           O
HETATM 4012  O   HOH A2721     111.899 147.141 147.046  1.00 81.25           O
HETATM 4013  O   HOH A2722      79.735 150.625 103.099  1.00 77.39           O
HETATM 4014  O   HOH A2723      49.974 130.744 102.615  1.00 66.53           O
HETATM 4015  O   HOH A2724      56.121 113.833 135.547  1.00 69.69           O
HETATM 4016  O   HOH A2725      50.730 143.976 120.857  1.00 69.39           O
HETATM 4017  O   HOH A2726      29.157 129.794 107.079  1.00 73.11           O
HETATM 4018  O   HOH A2727     110.840 130.634 122.165  1.00 66.72           O
HETATM 4019  O   HOH A2728      89.816 151.181 135.227  1.00 78.17           O
HETATM 4020  O   HOH A2729      70.173 114.276 103.507  1.00 71.58           O
HETATM 4021  O   HOH A2730      82.894 132.922 100.292  1.00 73.35           O
HETATM 4022  O   HOH A2731      65.471 107.498 123.977  1.00 71.63           O
HETATM 4023  O   HOH A2732      97.800 114.531 107.091  1.00 65.20           O
HETATM 4024  O   HOH A2733      77.765 152.358 104.382  1.00 78.53           O
HETATM 4025  O   HOH A2734      80.984 102.572 139.244  1.00 74.72           O
HETATM 4026  O   HOH A2735      82.235 141.411 117.025  1.00 63.87           O
HETATM 4027  O   HOH A2736      54.895 113.649 112.340  1.00 62.00           O
HETATM 4028  O   HOH A2737     107.073 168.003 126.448  1.00 73.13           O
HETATM 4029  O   HOH A2738     102.760 127.911 128.107  1.00 64.77           O
HETATM 4030  O   HOH A2739     106.974 146.666 111.321  1.00 69.69           O
HETATM 4031  O   HOH A2740      84.173 104.982 127.891  1.00 73.94           O
HETATM 4032  O   HOH A2741      45.119 125.740 129.676  1.00 66.30           O
HETATM 4033  O   HOH A2742      67.344 136.419 117.258  1.00 63.79           O
HETATM 4034  O   HOH A2743      94.381 124.126 142.538  1.00 65.52           O
HETATM 4035  O   HOH A2744     120.093 129.910 131.278  1.00 76.86           O
HETATM 4036  O   HOH A2745      39.393 136.740 125.031  1.00 75.63           O
HETATM 4037  O   HOH A2746      95.063 167.519 135.083  1.00 76.73           O
HETATM 4038  O   HOH A2747      52.042 135.143 121.494  1.00 65.68           O
HETATM 4039  O   HOH A2748      80.025 166.975 126.601  1.00 75.79           O
HETATM 4040  O   HOH A2749      85.918 119.044  94.377  1.00 77.41           O
HETATM 4041  O   HOH A2750      74.696 122.532 148.613  1.00 71.47           O
HETATM 4042  O   HOH A2751     112.263 124.063 144.351  1.00 77.28           O
HETATM 4043  O   HOH A2752      47.676 111.413 113.744  1.00 62.51           O
HETATM 4044  O   HOH A2753     117.641 126.217 137.127  1.00 79.39           O
HETATM 4045  O   HOH A2754      64.854 154.570 114.902  1.00 81.14           O
HETATM 4046  O   HOH A2755     118.393 147.453 126.866  1.00 80.74           O
HETATM 4047  O   HOH A2756      72.427 145.892 100.841  1.00 78.54           O
HETATM 4048  O   HOH A2757      53.776 131.662  96.416  1.00 69.77           O
HETATM 4049  O   HOH A2758      62.309 100.069 127.474  1.00 77.05           O
HETATM 4050  O   HOH A2759      98.919 108.703 112.654  1.00 68.04           O
HETATM 4051  O   HOH A2760      80.031 143.278 116.692  1.00 66.75           O
HETATM 4052  O   HOH A2761      53.284 132.963 105.621  1.00 66.27           O
HETATM 4053  O   HOH A2762      65.772 141.298 105.975  1.00 73.74           O
HETATM 4054  O   HOH A2763      98.547 115.824 142.188  1.00 75.77           O
HETATM 4055  O   HOH A2764      72.536 155.964 111.992  1.00 72.63           O
HETATM 4056  O   HOH A2765      40.557 109.691 101.737  1.00 63.97           O
HETATM 4057  O   HOH A2766      65.267 108.226 146.851  1.00 78.42           O
HETATM 4058  O   HOH A2767     110.702 122.218 144.724  1.00 79.95           O
HETATM 4059  O   HOH A2768      69.796 125.374 139.991  1.00 68.80           O
HETATM 4060  O   HOH A2769      84.781 143.147  98.602  1.00 70.10           O
HETATM 4061  O   HOH A2770      71.293 116.995 108.951  1.00 65.24           O
HETATM 4062  O   HOH A2771      74.511 106.182 124.961  1.00 65.72           O
HETATM 4063  O   HOH A2772     109.705 115.815 133.961  1.00 75.99           O
HETATM 4064  O   HOH A2773     106.511 149.131 110.399  1.00 63.05           O
HETATM 4065  O   HOH A2774      98.507 143.741 133.948  1.00 73.76           O
HETATM 4066  O   HOH A2775      80.974 119.307 136.785  1.00 68.90           O
HETATM 4067  O   HOH A2776      98.844 145.713  97.331  1.00 70.82           O
HETATM 4068  O   HOH A2777     103.024 171.403 115.920  1.00 80.07           O
HETATM 4069  O   HOH A2778     100.721 128.080 131.958  1.00 62.39           O
HETATM 4070  O   HOH A2779      37.990 119.803 128.226  1.00 67.24           O
HETATM 4071  O   HOH A2780      67.578 117.200  99.533  1.00 68.47           O
HETATM 4072  O   HOH A2781     110.079 142.273 124.948  1.00 73.74           O
HETATM 4073  O   HOH A2782      50.085 133.349 133.831  1.00 76.58           O
HETATM 4074  O   HOH A2783      59.625 134.870 115.558  1.00 59.90           O
HETATM 4075  O   HOH A2784      74.370 121.226  99.752  1.00 71.18           O
HETATM 4076  O   HOH A2785      55.403 126.572  89.117  1.00 73.62           O
HETATM 4077  O   HOH A2786      32.122 104.223 115.171  1.00 75.50           O
HETATM 4078  O   HOH A2787     102.083 149.247  98.521  1.00 71.08           O
HETATM 4079  O   HOH A2788     100.906 142.503 121.808  1.00 66.24           O
HETATM 4080  O   HOH A2789     112.881 123.121 142.259  1.00 76.74           O
HETATM 4081  O   HOH A2790      79.095  99.285 137.505  1.00 78.33           O
HETATM 4082  O   HOH A2791      55.204 114.782  97.049  1.00 66.78           O
HETATM 4083  O   HOH A2792      63.651 158.162 121.528  1.00 92.15           O
HETATM 4084  O   HOH A2793      90.999 159.427 132.912  1.00 70.49           O
HETATM 4085  O   HOH A2794     103.940 119.317 114.225  1.00 61.10           O
HETATM 4086  O   HOH A2795      90.528 126.235 140.880  1.00 64.52           O
HETATM 4087  O   HOH A2796     124.848 139.705 134.533  1.00 79.92           O
HETATM 4088  O   HOH A2797      95.211 149.891 136.677  1.00 79.06           O
HETATM 4089  O   HOH A2798     103.863 124.933 106.244  1.00 60.13           O
HETATM 4090  O   HOH A2799      69.625 123.689 135.732  1.00 61.56           O
HETATM 4091  O   HOH A2800      79.921 158.834 126.993  1.00 69.49           O
HETATM 4092  O   HOH A2801      61.842 131.051 123.717  1.00 65.46           O
HETATM 4093  O   HOH A2802     127.052 136.687 139.316  1.00 83.07           O
HETATM 4094  O   HOH A2803      58.351 151.696 116.305  1.00 84.62           O
HETATM 4095  O   HOH A2804      50.318 115.506 135.194  1.00 70.90           O
HETATM 4096  O   HOH A2805      46.388 109.453 103.195  1.00 60.93           O
HETATM 4097  O   HOH A2806      68.662 155.222 118.194  1.00 76.92           O
HETATM 4098  O   HOH A2807      89.649 130.408 102.339  1.00 66.41           O
HETATM 4099  O   HOH A2808      68.905 154.923 110.371  1.00 76.85           O
HETATM 4100  O   HOH A2809     129.038 144.959 136.889  1.00 86.74           O
HETATM 4101  O   HOH A2810      99.952 141.412 135.251  1.00 73.00           O
HETATM 4102  O   HOH A2811      64.357 118.569  97.996  1.00 69.14           O
HETATM 4103  O   HOH A2812     112.223 135.102 122.624  1.00 73.58           O
HETATM 4104  O   HOH A2813      35.804 127.014  96.832  1.00 75.63           O
HETATM 4105  O   HOH A2814      59.599 128.450 126.558  1.00 64.08           O
HETATM 4106  O   HOH A2815      83.441 153.719 101.660  1.00 76.11           O
HETATM 4107  O   HOH A2816      89.645 112.152 139.790  1.00 71.36           O
HETATM 4108  O   HOH A2817      81.535 119.268 145.692  1.00 71.52           O
HETATM 4109  O   HOH A2818      43.068 109.986 124.028  1.00 72.30           O
HETATM 4110  O   HOH A2819      71.235 128.538 130.589  1.00 63.35           O
HETATM 4111  O   HOH A2820      53.992 110.057 122.776  1.00 68.77           O
HETATM 4112  O   HOH A2821      46.300 110.662 101.156  1.00 62.93           O
HETATM 4113  O   HOH A2822     101.971 125.319  99.601  1.00 63.52           O
HETATM 4114  O   HOH A2823     114.275 139.413 146.949  1.00 76.20           O
HETATM 4115  O   HOH A2824      24.942 116.663 101.719  1.00 74.71           O
HETATM 4116  O   HOH A2825     104.084 150.393  95.118  1.00 66.14           O
HETATM 4117  O   HOH A2826      41.265 106.792 116.459  1.00 68.28           O
HETATM 4118  O   HOH A2827      81.154 119.715 140.060  1.00 72.49           O
HETATM 4119  O   HOH A2828      74.340  97.690 140.090  1.00 82.26           O
HETATM 4120  O   HOH A2829      68.794 147.475 103.953  1.00 75.01           O
HETATM 4121  O   HOH A2830      71.475 141.030 101.429  1.00 79.19           O
HETATM 4122  O   HOH A2831      83.289 122.070 138.906  1.00 68.57           O
HETATM 4123  O   HOH A2832     102.709 145.469 123.746  1.00 65.87           O
HETATM 4124  O   HOH A2833      84.793 130.810 103.111  1.00 72.23           O
HETATM 4125  O   HOH A2834      81.701 151.254  99.791  1.00 74.53           O
HETATM 4126  O   HOH A2835      60.382 139.976 106.166  1.00 70.81           O
HETATM 4127  O   HOH A2836      47.154 104.311 124.832  1.00 77.78           O
HETATM 4128  O   HOH A2837      44.209 129.629 131.296  1.00 72.22           O
HETATM 4129  O   HOH A2838      48.040 145.393 118.597  1.00 71.91           O
HETATM 4130  O   HOH A2839     109.764 144.932 148.524  1.00 76.17           O
HETATM 4131  O   HOH A2840      98.540 122.694 100.933  1.00 64.19           O
HETATM 4132  O   HOH A2841     106.181 123.445 126.873  1.00 70.33           O
HETATM 4133  O   HOH A2842      95.179 143.797 140.006  1.00 82.17           O
HETATM 4134  O   HOH A2843     111.378 155.365 113.977  1.00 70.63           O
HETATM 4135  O   HOH A2844      70.222 112.061 120.612  1.00 62.00           O
HETATM 4136  O   HOH A2845      77.219 143.607 100.099  1.00 77.96           O
HETATM 4137  O   HOH A2846     100.762 127.656 129.352  1.00 64.09           O
HETATM 4138  O   HOH A2847     125.664 134.184 128.187  1.00 76.41           O
HETATM 4139  O   HOH A2848      85.366 124.224 137.709  1.00 65.23           O
HETATM 4140  O   HOH A2849     110.624 116.885 137.927  1.00 74.96           O
HETATM 4141  O   HOH A2850      62.966  98.559 129.329  1.00 79.81           O
HETATM 4142  O   HOH A2851      33.910 136.084 114.233  1.00 73.85           O
HETATM 4143  O   HOH A2852     110.708 148.014 114.586  1.00 70.37           O
HETATM 4144  O   HOH A2853      93.695 140.311 133.322  1.00 70.38           O
HETATM 4145  O   HOH A2854      67.031 104.605 143.885  1.00 78.06           O
HETATM 4146  O   HOH A2855      98.023 147.170 130.933  1.00 72.53           O
HETATM 4147  O   HOH A2856      53.139 108.773 124.489  1.00 67.13           O
HETATM 4148  O   HOH A2857      45.465 111.727 124.514  1.00 69.63           O
HETATM 4149  O   HOH A2858      37.770 130.178 104.019  1.00 72.76           O
HETATM 4150  O   HOH A2859      66.748 136.299 114.353  1.00 65.84           O
HETATM 4151  O   HOH A2860      93.421 112.358  98.841  1.00 62.31           O
HETATM 4152  O   HOH A2861     110.794 173.309 114.674  1.00 81.61           O
HETATM 4153  O   HOH A2862     103.731 119.335 123.562  1.00 66.35           O
HETATM 4154  O   HOH A2863      34.203 120.373  91.747  1.00 79.31           O
HETATM 4155  O   HOH A2864      73.242 134.962 132.697  1.00 66.82           O
HETATM 4156  O   HOH A2865     115.584 133.151 146.276  1.00 80.32           O
HETATM 4157  O   HOH A2866      78.099 131.060 140.065  1.00 68.76           O
HETATM 4158  O   HOH A2867      68.406 123.823 129.463  1.00 55.57           O
HETATM 4159  O   HOH A2868      42.301 136.108 108.824  1.00 68.26           O
HETATM 4160  O   HOH A2869      91.508 107.552 126.452  1.00 66.16           O
HETATM 4161  O   HOH A2870      57.427 111.325 142.254  1.00 70.91           O
HETATM 4162  O   HOH A2871     105.268 120.562 117.687  1.00 71.46           O
HETATM 4163  O   HOH A2872     122.541 142.563 125.974  1.00 78.19           O
HETATM 4164  O   HOH A2873     110.675 159.021 114.719  1.00 71.46           O
HETATM 4165  O   HOH A2874     100.974 128.224  99.385  1.00 63.63           O
HETATM 4166  O   HOH A2875      81.028 110.353 144.742  1.00 74.76           O
HETATM 4167  O   HOH A2876      78.454 121.431  95.990  1.00 75.38           O
HETATM 4168  O   HOH A2877     106.982 130.078 151.979  1.00 76.58           O
HETATM 4169  O   HOH A2878      90.382 123.920 140.454  1.00 63.56           O
HETATM 4170  O   HOH A2879      99.344 170.194 129.023  1.00 77.25           O
HETATM 4171  O   HOH A2880      68.666 115.544 114.632  1.00 61.18           O
HETATM 4172  O   HOH A2881      65.051 138.234 104.647  1.00 70.72           O
HETATM 4173  O   HOH A2882      98.332 146.412 106.848  1.00 64.86           O
HETATM 4174  O   HOH A2883     100.405 145.179 113.545  1.00 66.09           O
HETATM 4175  O   HOH A2884      59.647  98.567 127.633  1.00 75.83           O
HETATM 4176  O   HOH A2885     128.180 147.364 140.218  1.00 88.18           O
HETATM 4177  O   HOH A2886      42.906 111.588 117.769  1.00 67.14           O
HETATM 4178  O   HOH A2887     112.839 129.658 118.362  1.00 65.71           O
HETATM 4179  O   HOH A2888      68.491 127.567 128.092  1.00 59.15           O
HETATM 4180  O   HOH A2889      61.552 102.110 123.700  1.00 73.61           O
HETATM 4181  O   HOH A2890      93.773 171.726 126.688  1.00 75.97           O
HETATM 4182  O   HOH A2891     109.794 157.055 113.326  1.00 72.01           O
HETATM 4183  O   HOH A2892      97.379 145.184 138.606  1.00 81.91           O
HETATM 4184  O   HOH A2893     101.797 136.249 131.658  1.00 71.10           O
HETATM 4185  O   HOH A2894      85.196 109.690 126.795  1.00 68.97           O
HETATM 4186  O   HOH A2895      48.352 110.309 125.907  1.00 68.49           O
HETATM 4187  O   HOH A2896      44.698 110.404 116.678  1.00 68.23           O
HETATM 4188  O   HOH A2897     132.339 139.031 121.249  1.00 75.85           O
HETATM 4189  O   HOH A2898      95.871 135.198 140.997  1.00 73.56           O
HETATM 4190  O   HOH A2899      70.882 109.625 123.315  1.00 65.93           O
HETATM 4191  O   HOH A2900      78.523 100.453 139.418  1.00 76.87           O
HETATM 4192  O   HOH A2901      74.022 118.910 149.298  1.00 74.63           O
HETATM 4193  O   HOH A2902     109.422 135.269 120.201  1.00 65.88           O
HETATM 4194  O   HOH A2903      82.951 158.920 120.957  1.00 70.28           O
HETATM 4195  O   HOH A2904      97.436 153.608 140.354  1.00 76.80           O
HETATM 4196  O   HOH A2905      40.622 110.755 115.521  1.00 65.00           O
HETATM 4197  O   HOH A2906      72.837 109.959 113.903  1.00 63.93           O
HETATM 4198  O   HOH A2907      60.245 141.036 121.747  1.00 69.00           O
HETATM 4199  O   HOH A2908      22.459 109.498 105.497  1.00 79.45           O
HETATM 4200  O   HOH A2909      99.937 118.615 106.025  1.00 62.47           O
HETATM 4201  O   HOH A2910      69.408 115.225 101.483  1.00 70.45           O
HETATM 4202  O   HOH A2911     101.221 147.081  98.168  1.00 71.28           O
HETATM 4203  O   HOH A2912      69.751 143.445  99.224  1.00 86.30           O
HETATM 4204  O   HOH A2913      86.285 166.116 130.175  1.00 75.85           O
HETATM 4205  O   HOH A2914      86.766 151.462 132.425  1.00 70.34           O
HETATM 4206  O   HOH A2915      69.282 128.473 101.426  1.00 70.02           O
HETATM 4207  O   HOH A2916      59.963  99.569 125.498  1.00 73.64           O
HETATM 4208  O   HOH A2917      78.913 105.861 126.062  1.00 72.72           O
HETATM 4209  O   HOH A2918      18.596 114.269 115.688  1.00 84.13           O
HETATM 4210  O   HOH A2919      63.285 111.485 144.674  1.00 73.88           O
HETATM 4211  O   HOH A2920      99.767 135.230 131.098  1.00 67.09           O
HETATM 4212  O   HOH A2921      91.214 149.257 133.917  1.00 74.37           O
HETATM 4213  O   HOH A2922     102.542 138.378  94.462  1.00 68.85           O
HETATM 4214  O   HOH A2923      86.741 123.563 102.668  1.00 68.92           O
HETATM 4215  O   HOH A2924      95.840 139.951 132.311  1.00 71.81           O
HETATM 4216  O   HOH A2925      63.911 146.041 106.777  1.00 72.98           O
HETATM 4217  O   HOH A2926     100.453 117.996 110.942  1.00 60.60           O
HETATM 4218  O   HOH A2927     110.400 126.378 147.357  1.00 73.84           O
HETATM 4219  O   HOH A2928      60.371 115.070 132.481  1.00 64.20           O
HETATM 4220  O   HOH A2929      77.686 136.661 135.895  1.00 68.48           O
HETATM 4221  O   HOH A2930      58.039 108.821 121.184  1.00 69.44           O
HETATM 4222  O   HOH A2931      61.280 148.488 109.129  1.00 73.57           O
HETATM 4223  O   HOH A2932      61.672 144.495 120.871  1.00 70.62           O
HETATM 4224  O   HOH A2933      35.784 133.697 122.928  1.00 72.68           O
HETATM 4225  O   HOH A2934      79.301 106.167 120.115  1.00 65.48           O
HETATM 4226  O   HOH A2935      30.567 120.852  96.751  1.00 73.31           O
HETATM 4227  O   HOH A2936      58.063 133.367  92.307  1.00 71.99           O
HETATM 4228  O   HOH A2937      88.104 108.631 123.974  1.00 68.74           O
HETATM 4229  O   HOH A2938      77.744 144.307  97.566  1.00 75.97           O
HETATM 4230  O   HOH A2939      93.331 132.609 139.737  1.00 68.53           O
HETATM 4231  O   HOH A2940      67.513 120.248  99.711  1.00 71.83           O
HETATM 4232  O   HOH A2941      83.313 121.252 133.851  1.00 65.26           O
HETATM 4233  O   HOH A2942      45.071 110.104 120.260  1.00 66.92           O
HETATM 4234  O   HOH A2943     106.798 121.738 123.719  1.00 65.15           O
HETATM 4235  O   HOH A2944     116.158 150.003 138.817  1.00 77.53           O
HETATM 4236  O   HOH A2945      55.665 109.759 142.578  1.00 75.59           O
HETATM 4237  O   HOH A2946     122.128 132.978 142.317  1.00 76.92           O
HETATM 4238  O   HOH A2947      72.120 115.137 104.644  1.00 76.45           O
HETATM 4239  O   HOH A2948      34.240 105.625 113.928  1.00 72.79           O
HETATM 4240  O   HOH A2949      99.850 170.254 125.871  1.00 71.38           O
HETATM 4241  O   HOH A2950      90.192 154.093  97.344  1.00 75.62           O
HETATM 4242  O   HOH A2951      84.515 120.875 131.206  1.00 59.58           O
HETATM 4243  O   HOH A2952     109.702 122.811 127.065  1.00 71.64           O
HETATM 4244  O   HOH A2953      49.194 132.852 105.981  1.00 70.66           O
HETATM 4245  O   HOH A2954      78.509 160.875 109.337  1.00 70.96           O
HETATM 4246  O   HOH A2955      71.442 111.331 115.194  1.00 63.38           O
HETATM 4247  O   HOH A2956      46.742 109.576 117.398  1.00 68.61           O
HETATM 4248  O   HOH A2957      85.453 106.312 120.063  1.00 63.57           O
HETATM 4249  O   HOH A2958     112.887 132.967 123.657  1.00 77.83           O
HETATM 4250  O   HOH A2959      99.859 116.035 107.680  1.00 67.40           O
HETATM 4251  O   HOH A2960     135.563 138.393 116.448  1.00 73.39           O
HETATM 4252  O   HOH A2961      70.826 101.964 142.893  1.00 82.89           O
HETATM 4253  O   HOH A2962     127.696 137.392 126.051  1.00 75.45           O
HETATM 4254  O   HOH A2963      82.375 158.619 105.660  1.00 74.29           O
HETATM 4255  O   HOH A2964     123.900 144.612 145.261  1.00 83.74           O
HETATM 4256  O   HOH A2965      67.067 101.993 124.830  1.00 72.89           O
HETATM 4257  O   HOH A2966      86.754 174.997 124.682  1.00 82.94           O
HETATM 4258  O   HOH A2967      47.367 132.712 135.316  1.00 76.43           O
HETATM 4259  O   HOH A2968      75.716 116.816 148.820  1.00 80.18           O
HETATM 4260  O   HOH A2969      60.309 117.479 138.098  1.00 72.37           O
HETATM 4261  O   HOH A2970      61.380 114.755  94.787  1.00 72.55           O
HETATM 4262  O   HOH A2971      58.121 112.906 134.615  1.00 68.94           O
HETATM 4263  O   HOH A2972      58.003 114.765 115.418  1.00 65.31           O
HETATM 4264  O   HOH A2973      73.923 155.761 114.133  1.00 73.53           O
HETATM 4265  O   HOH A2974      86.826 117.713 140.785  1.00 71.36           O
HETATM 4266  O   HOH A2975      71.117 123.413  96.296  1.00 75.49           O
HETATM 4267  O   HOH A2976      55.829 134.874  94.415  1.00 69.21           O
HETATM 4268  O   HOH A2977      61.246 140.313 123.813  1.00 68.95           O
HETATM 4269  O   HOH A2978      80.494 158.815 107.734  1.00 73.86           O
HETATM 4270  O   HOH A2979      92.928 142.530 132.525  1.00 69.75           O
HETATM 4271  O   HOH A2980      88.661 167.138 104.496  1.00 72.76           O
HETATM 4272  O   HOH A2981      81.143 114.608  95.848  1.00 71.88           O
HETATM 4273  O   HOH A2982      97.722 167.107 105.813  1.00 75.68           O
HETATM 4274  O   HOH A2983      35.524 109.451 103.362  1.00 74.12           O
HETATM 4275  O   HOH A2984      60.028 127.034 128.383  1.00 60.17           O
HETATM 4276  O   HOH A2985      58.345  98.902 132.346  1.00 79.43           O
HETATM 4277  O   HOH A2986     115.516 120.172 135.321  1.00 79.40           O
HETATM 4278  O   HOH A2987      48.856 107.647 110.717  1.00 63.99           O
HETATM 4279  O   HOH A2988      80.874 129.814 101.944  1.00 76.94           O
HETATM 4280  O   HOH A2989      42.763 110.887 119.984  1.00 67.29           O
HETATM 4281  O   HOH A2990      93.238 116.917 137.688  1.00 63.71           O
HETATM 4282  O   HOH A2991      83.369 149.134  95.706  1.00 74.65           O
HETATM 4283  O   HOH A2992      86.565 105.257 126.833  1.00 79.27           O
HETATM 4284  O   HOH A2993      87.272 145.416 131.796  1.00 72.37           O
HETATM 4285  O   HOH A2994      96.887 171.452 127.630  1.00 74.67           O
HETATM 4286  O   HOH A2995      38.659 128.861 100.475  1.00 72.09           O
HETATM 4287  O   HOH A2996      35.554 108.972 116.037  1.00 72.67           O
HETATM 4288  O   HOH A2997      95.056 149.686 134.327  1.00 76.76           O
HETATM 4289  O   HOH A2998      79.685 106.872 122.324  1.00 65.96           O
HETATM 4290  O   HOH A2999      96.686 157.885 140.153  1.00 82.06           O
HETATM 4291  O   HOH A3000      53.064 137.191 122.793  1.00 70.63           O
HETATM 4292  O   HOH A3001      91.609 176.807 121.173  1.00 77.02           O
HETATM 4293  O   HOH A3002      74.733 106.940 110.968  1.00 68.89           O
HETATM 4294  O   HOH A3003      80.410 148.210  98.680  1.00 80.61           O
HETATM 4295  O   HOH A3004     119.855 135.565 145.770  1.00 72.73           O
HETATM 4296  O   HOH A3005     104.059 174.366 117.050  1.00 80.39           O
HETATM 4297  O   HOH A3006      57.858 113.317 118.069  1.00 62.20           O
HETATM 4298  O   HOH A3007      83.971 123.696 141.827  1.00 70.86           O
HETATM 4299  O   HOH A3008      54.939 138.482 123.451  1.00 68.29           O
HETATM 4300  O   HOH A3009      69.614 143.531 123.167  1.00 69.79           O
HETATM 4301  O   HOH A3010      62.813 131.464  91.830  1.00 79.53           O
HETATM 4302  O   HOH A3011      98.518 114.334 112.810  1.00 60.77           O
HETATM 4303  O   HOH A3012     100.444 110.621 112.914  1.00 70.51           O
HETATM 4304  O   HOH A3013      99.523 137.083 133.224  1.00 73.22           O
HETATM 4305  O   HOH A3014      77.713 139.400  99.663  1.00 79.29           O
HETATM 4306  O   HOH A3015      98.012 113.568 137.373  1.00 70.48           O
HETATM 4307  O   HOH A3016     109.787 128.849 126.520  1.00 73.61           O
HETATM 4308  O   HOH A3017      86.422 145.858 112.075  1.00 67.59           O
HETATM 4309  O   HOH A3018      66.053 141.295 101.951  1.00 82.58           O
HETATM 4310  O   HOH A3019     101.069 117.832 114.730  1.00 63.86           O
HETATM 4311  O   HOH A3020      72.810 126.837  97.376  1.00 80.01           O
HETATM 4312  O   HOH A3021      97.601 138.450 133.206  1.00 74.88           O
HETATM 4313  O   HOH A3022      72.421 144.416 127.943  1.00 76.63           O
HETATM 4314  O   HOH A3023      81.892 129.049 104.277  1.00 73.60           O
HETATM 4315  O   HOH A3024      47.558 129.260 105.214  1.00 66.75           O
HETATM 4316  O   HOH A3025     125.719 142.480 146.025  1.00 88.66           O
HETATM 4317  O   HOH A3026      62.523 149.560 111.876  1.00 68.21           O
HETATM 4318  O   HOH A3027      76.263 105.268 126.310  1.00 68.00           O
HETATM 4319  O   HOH A3028      94.052 139.961 136.201  1.00 75.85           O
HETATM 4320  O   HOH A3029      64.148 110.322 146.704  1.00 75.41           O
HETATM 4321  O   HOH A3030      61.356 118.693 134.247  1.00 70.28           O
HETATM 4322  O   HOH A3031      81.354 148.528 128.825  1.00 71.94           O
HETATM 4323  O   HOH A3032      80.042  98.918 134.907  1.00 74.61           O
HETATM 4324  O   HOH A3033      85.074 111.882 125.416  1.00 65.62           O
HETATM 4325  O   HOH A3034      83.769 110.311 122.796  1.00 62.68           O
HETATM 4326  O   HOH A3035      91.953 139.964 137.279  1.00 74.72           O
HETATM 4327  O   HOH A3036      51.020 136.755 124.386  1.00 69.02           O
HETATM 4328  O   HOH A3037      34.161 136.575 118.980  1.00 76.21           O
HETATM 4329  O   HOH A3038      89.886 163.515 133.661  1.00 74.67           O
HETATM 4330  O   HOH A3039     104.951 149.199 146.143  1.00 80.86           O
HETATM 4331  O   HOH A3040      59.895  98.012 130.716  1.00 79.94           O
HETATM 4332  O   HOH A3041      96.381 168.770 107.698  1.00 78.31           O
HETATM 4333  O   HOH A3042     110.876 149.352 145.338  1.00 78.63           O
HETATM 4334  O   HOH A3043      66.736 105.667 123.191  1.00 74.76           O
HETATM 4335  O   HOH A3044      71.837 110.625 118.321  1.00 63.64           O
HETATM 4336  O   HOH A3045      76.902 126.823  99.480  1.00 75.88           O
HETATM 4337  O   HOH A3046      87.251 155.871  97.613  1.00 73.86           O
HETATM 4338  O   HOH A3047      92.003 143.980  94.495  1.00 74.46           O
HETATM 4339  O   HOH A3048      74.954 137.081  99.776  1.00 80.05           O
HETATM 4340  O   HOH A3049      95.151 144.082  94.347  1.00 76.47           O
HETATM 4341  O   HOH A3050      79.078 131.070 100.134  1.00 77.83           O
HETATM 4342  O   HOH A3051      98.408 176.258 116.842  1.00 79.68           O
HETATM 4343  O   HOH A3052     110.798 153.922 121.810  1.00 68.34           O
HETATM 4344  O   HOH A3053      75.081 159.378 111.446  1.00 72.71           O
HETATM 4345  O   HOH A3054      38.253 110.690 102.770  1.00 71.99           O
HETATM 4346  O   HOH A3055      84.228 148.958 129.806  1.00 71.23           O
HETATM 4347  O   HOH A3056      78.362 107.263 124.214  1.00 68.92           O
HETATM 4348  O   HOH A3057     132.869 127.255 115.259  1.00 77.91           O
HETATM 4349  O   HOH A3058      60.091 103.107 143.471  1.00 77.15           O
HETATM 4350  O   HOH A3059      38.566 109.168  99.227  1.00 72.70           O
HETATM 4351  O   HOH A3060      89.195 108.789 121.173  1.00 66.97           O
HETATM 4352  O   HOH A3061      50.396  93.726 130.042  1.00 74.33           O
HETATM 4353  O   HOH A3062      59.108 148.187 107.860  1.00 73.72           O
HETATM 4354  O   HOH A3063      73.152 112.566 103.036  1.00 73.99           O
HETATM 4355  O   HOH A3064     107.581 124.377 124.997  1.00 72.52           O
HETATM 4356  O   HOH A3065      61.567 108.563 122.388  1.00 69.03           O
HETATM 4357  O   HOH A3066      87.902 123.102 140.352  1.00 68.40           O
HETATM 4358  O   HOH A3067      86.499 147.792 110.475  1.00 68.63           O
HETATM 4359  O   HOH A3068     108.255 151.575 145.353  1.00 83.22           O
HETATM 4360  O   HOH A3069      98.096 142.359 127.326  1.00 68.62           O
HETATM 4361  O   HOH A3070      65.078 153.719 112.582  1.00 80.00           O
HETATM 4362  O   HOH A3071      63.240 134.758 125.252  1.00 69.10           O
HETATM 4363  O   HOH A3072      96.238 146.618 132.386  1.00 74.82           O
HETATM 4364  O   HOH A3073      99.509 157.167 139.695  1.00 81.11           O
HETATM 4365  O   HOH A3074      57.899 124.300  91.022  1.00 70.04           O
HETATM 4366  O   HOH A3075      66.483 143.949 105.601  1.00 77.50           O
HETATM 4367  O   HOH A3076      91.169 150.538 137.419  1.00 78.96           O
HETATM 4368  O   HOH A3077      61.588 126.866  91.631  1.00 74.16           O
HETATM 4369  O   HOH A3078      65.296 113.001 117.038  1.00 64.17           O
HETATM 4370  O   HOH A3079      57.505 111.886 121.732  1.00 64.48           O
HETATM 4371  O   HOH A3080      61.449 112.316 121.055  1.00 67.94           O
HETATM 4372  O   HOH A3081     104.939 116.959 124.349  1.00 67.13           O
HETATM 4373  O   HOH A3082      72.458 134.296  95.485  1.00 90.00           O
HETATM 4374  O   HOH A3083      89.474 130.990 141.375  1.00 68.70           O
HETATM 4375  O   HOH A3084      77.612 154.124 106.573  1.00 78.87           O
HETATM 4376  O   HOH A3085      75.949 108.787 120.505  1.00 61.36           O
HETATM 4377  O   HOH A3086      64.060 116.134 131.712  1.00 55.98           O
HETATM 4378  O   HOH A3087      75.718 135.601 135.165  1.00 66.91           O
HETATM 4379  O   HOH A3088      75.619 125.080  97.711  1.00 79.35           O
HETATM 4380  O   HOH A3089      45.825 106.359 117.027  1.00 64.91           O
HETATM 4381  O   HOH A3090      78.781 107.011 145.970  1.00 78.63           O
HETATM 4382  O   HOH A3091      68.981 108.352 121.597  1.00 70.87           O
HETATM 4383  O   HOH A3092      54.905 138.529 102.365  1.00 73.29           O
HETATM 4384  O   HOH A3093      91.948 129.866 140.286  1.00 66.78           O
HETATM 4385  O   HOH A3094      86.765 130.701 140.540  1.00 68.66           O
HETATM 4386  O   HOH A3095      55.426 109.932 106.631  1.00 61.82           O
HETATM 4387  O   HOH A3096      66.097 103.411 123.196  1.00 78.89           O
HETATM 4388  O   HOH A3097      57.999 138.040 124.268  1.00 69.56           O
HETATM 4389  O   HOH A3098      82.369 162.617 104.390  1.00 78.37           O
HETATM 4390  O   HOH A3099      77.000 122.249  97.689  1.00 75.67           O
HETATM 4391  O   HOH A3100      93.845 145.796 139.243  1.00 79.71           O
HETATM 4392  O   HOH A3101      54.372 134.419  97.165  1.00 68.23           O
HETATM 4393  O   HOH A3102      88.397 139.913  89.816  1.00 77.91           O
HETATM 4394  O   HOH A3103     127.253 140.597 144.616  1.00 87.94           O
HETATM 4395  O   HOH A3104      58.262 139.974 122.720  1.00 69.76           O
HETATM 4396  O   HOH A3105      80.176 165.843 115.265  1.00 72.15           O
HETATM 4397  O   HOH A3106     130.434 138.345 124.565  1.00 74.48           O
HETATM 4398  O   HOH A3107      95.330 108.369 122.382  1.00 66.03           O
HETATM 4399  O   HOH A3108      74.569 132.965  96.021  1.00 85.24           O
HETATM 4400  O   HOH A3109      64.784 111.799 119.909  1.00 62.07           O
HETATM 4401  O   HOH A3110      52.755 109.026 109.691  1.00 64.90           O
HETATM 4402  O   HOH A3111      69.949 131.836 131.315  1.00 67.06           O
HETATM 4403  O   HOH A3112      53.367 135.712 100.500  1.00 75.71           O
HETATM 4404  O   HOH A3113      36.614 109.135 113.301  1.00 70.64           O
HETATM 4405  O   HOH A3114      59.796 113.568 111.612  1.00 65.56           O
HETATM 4406  O   HOH A3115      84.903 169.129 108.652  1.00 73.71           O
HETATM 4407  O   HOH A3116      70.475 145.052 126.243  1.00 74.91           O
HETATM 4408  O   HOH A3117      79.509 146.569  96.968  1.00 77.82           O
HETATM 4409  O   HOH A3118      70.971 116.756 147.252  1.00 76.41           O
HETATM 4410  O   HOH A3119      57.549 113.491 108.483  1.00 65.97           O
HETATM 4411  O   HOH A3120      93.471 143.724 146.917  1.00 77.50           O
HETATM 4412  O   HOH A3121      76.704 132.516  99.441  1.00 80.42           O
HETATM 4413  O   HOH A3122      58.459 124.652 132.659  1.00 69.00           O
HETATM 4414  O   HOH A3123      69.398 111.390 118.276  1.00 67.62           O
HETATM 4415  O   HOH A3124     115.036 150.779 140.699  1.00 74.89           O
HETATM 4416  O   HOH A3125      68.085 147.849 126.327  1.00 76.67           O
HETATM 4417  O   HOH A3126      85.473 107.412 123.777  1.00 67.16           O
HETATM 4418  O   HOH A3127      96.107 143.304 131.237  1.00 73.09           O
HETATM 4419  O   HOH A3128     127.593 144.187 144.462  1.00 85.03           O
HETATM 4420  O   HOH A3129      73.043 108.411 119.636  1.00 66.75           O
HETATM 4421  O   HOH A3130      89.924 117.762 142.247  1.00 66.44           O
HETATM 4422  O   HOH A3131      78.880 135.814 138.715  1.00 64.93           O
HETATM 4423  O   HOH A3132      66.114 122.921 133.895  1.00 70.03           O
HETATM 4424  O   HOH A3133      92.602 107.086 122.473  1.00 69.49           O
HETATM 4425  O   HOH A3134      68.239 112.537 116.434  1.00 67.88           O
HETATM 4426  O   HOH A3135      93.529 177.498 124.352  1.00 81.49           O
HETATM 4427  O   HOH A3136      38.421 109.200 117.912  1.00 71.15           O
HETATM 4428  O   HOH A3137      59.830 111.368 122.428  1.00 68.32           O
HETATM 4429  O   HOH A3138      91.229 109.167  95.771  1.00 69.28           O
HETATM 4430  O   HOH A3139      89.964 111.903  96.904  1.00 67.35           O
HETATM 4431  O   HOH A3140      76.246 135.019  98.836  1.00 81.84           O
HETATM 4432  O   HOH A3141      73.074 115.377 148.040  1.00 77.01           O
HETATM 4433  O   HOH A3142      95.140 144.606 135.946  1.00 81.68           O
HETATM 4434  O   HOH A3143      94.827 146.629 134.801  1.00 78.99           O
HETATM 4435  O   HOH A3144      56.774 111.658 109.732  1.00 70.29           O
HETATM 4436  O   HOH A3145     100.506 152.471  94.406  1.00 75.78           O
HETATM 4437  O   HOH A3146      76.580 123.958  94.849  1.00 82.45           O
HETATM 4438  O   HOH A3147      77.840 126.488  94.779  1.00 87.82           O
HETATM 4439  O   HOH B2101     136.929  97.626 133.816  1.00 61.45           O
HETATM 4440  O   HOH B2102     144.920  84.746  99.858  1.00 75.22           O
HETATM 4441  O   HOH B2103     101.820  74.377 125.772  1.00 72.51           O
HETATM 4442  O   HOH B2104     126.441  84.793 107.642  1.00 65.38           O
HETATM 4443  O   HOH B2105     115.285  71.953 115.630  1.00 63.36           O
HETATM 4444  O   HOH B2106     130.184  50.158 132.904  1.00 80.52           O
HETATM 4445  O   HOH B2107     124.549  59.073 135.048  1.00 69.11           O
HETATM 4446  O   HOH B2108     173.526  83.117 130.615  1.00 77.12           O
HETATM 4447  O   HOH B2109     157.498  80.574 127.960  1.00 68.86           O
HETATM 4448  O   HOH B2110     146.068  80.256  90.934  1.00 85.39           O
HETATM 4449  O   HOH B2111     143.502 103.926 126.638  1.00 59.47           O
HETATM 4450  O   HOH B2112     122.795  68.740 131.329  1.00 71.12           O
HETATM 4451  O   HOH B2113     139.306  59.093 115.183  1.00 73.46           O
HETATM 4452  O   HOH B2114     127.158  85.344 104.084  1.00 67.38           O
HETATM 4453  O   HOH B2115     140.374 104.951 110.042  1.00 68.46           O
HETATM 4454  O   HOH B2116     112.444  74.708 135.559  1.00 73.86           O
HETATM 4455  O   HOH B2117     168.543 107.967 130.974  1.00 79.64           O
HETATM 4456  O   HOH B2118     111.794  80.938  96.711  1.00 67.77           O
HETATM 4457  O   HOH B2119     136.062  52.184 113.226  1.00 70.66           O
HETATM 4458  O   HOH B2120     122.224  93.112 101.057  1.00 65.37           O
HETATM 4459  O   HOH B2121     129.560  99.212 129.183  1.00 63.15           O
HETATM 4460  O   HOH B2122     108.097 103.159 141.975  1.00 77.11           O
HETATM 4461  O   HOH B2123     138.732  51.934 116.655  1.00 74.95           O
HETATM 4462  O   HOH B2124     179.603 104.014 119.705  1.00 75.71           O
HETATM 4463  O   HOH B2125     113.674  55.896 138.035  1.00 80.94           O
HETATM 4464  O   HOH B2126      93.908  67.444 136.942  1.00 84.85           O
HETATM 4465  O   HOH B2127     110.968  95.971 144.359  1.00 77.83           O
HETATM 4466  O   HOH B2128     146.367  64.360 126.550  1.00 79.39           O
HETATM 4467  O   HOH B2129     151.670  86.226 125.275  1.00 61.22           O
HETATM 4468  O   HOH B2130     135.439 109.747 110.550  1.00 63.75           O
HETATM 4469  O   HOH B2131     143.351  89.365 136.574  1.00 65.00           O
HETATM 4470  O   HOH B2132     146.949 102.731 123.686  1.00 51.56           O
HETATM 4471  O   HOH B2133     163.616 106.247 126.271  1.00 70.31           O
HETATM 4472  O   HOH B2134     182.249  95.931 122.373  1.00 77.69           O
HETATM 4473  O   HOH B2135     148.138  76.665  90.994  1.00 91.35           O
HETATM 4474  O   HOH B2136     114.758  43.187 114.542  1.00 76.21           O
HETATM 4475  O   HOH B2137     120.880  71.063 123.764  1.00 64.83           O
HETATM 4476  O   HOH B2138     116.045  83.129 145.423  1.00 77.34           O
HETATM 4477  O   HOH B2139     133.146  79.695 106.627  1.00 66.12           O
HETATM 4478  O   HOH B2140     117.142  82.807  94.404  1.00 75.62           O
HETATM 4479  O   HOH B2141     129.368  67.358 117.685  1.00 63.56           O
HETATM 4480  O   HOH B2142     143.122  96.840 106.001  1.00 69.21           O
HETATM 4481  O   HOH B2143     126.489 108.056 101.581  1.00 60.62           O
HETATM 4482  O   HOH B2144     130.694  58.378 121.268  1.00 67.30           O
HETATM 4483  O   HOH B2145     124.172  59.127  98.056  1.00 75.38           O
HETATM 4484  O   HOH B2146      92.783  83.154 134.889  1.00 77.04           O
HETATM 4485  O   HOH B2147     113.453 100.506 115.709  1.00 66.61           O
HETATM 4486  O   HOH B2148     119.776  76.684 130.360  1.00 67.62           O
HETATM 4487  O   HOH B2149      89.281  80.995 134.862  1.00 76.55           O
HETATM 4488  O   HOH B2150     167.479  84.568  92.544  1.00 73.73           O
HETATM 4489  O   HOH B2151     106.169  47.633 119.093  1.00 73.81           O
HETATM 4490  O   HOH B2152     116.672  46.354 123.318  1.00 73.56           O
HETATM 4491  O   HOH B2153     104.487  84.543 125.522  1.00 67.20           O
HETATM 4492  O   HOH B2154     178.400 101.583 101.891  1.00 70.41           O
HETATM 4493  O   HOH B2155     178.099  76.829 119.547  1.00 71.76           O
HETATM 4494  O   HOH B2156     118.024  44.164 108.613  1.00 80.72           O
HETATM 4495  O   HOH B2157     115.025  97.455 144.169  1.00 76.63           O
HETATM 4496  O   HOH B2158     130.084  76.832 138.112  1.00 69.37           O
HETATM 4497  O   HOH B2159     131.619  68.167  98.892  1.00 73.01           O
HETATM 4498  O   HOH B2160     166.014  90.889 110.605  1.00 59.37           O
HETATM 4499  O   HOH B2161     182.101 108.073 111.060  1.00 72.65           O
HETATM 4500  O   HOH B2162     131.120  72.739 118.584  1.00 66.38           O
HETATM 4501  O   HOH B2163     177.740  92.255 108.445  1.00 66.37           O
HETATM 4502  O   HOH B2164     110.529  95.089 127.780  1.00 71.27           O
HETATM 4503  O   HOH B2165     100.137  95.089 132.997  1.00 78.94           O
HETATM 4504  O   HOH B2166     112.943  94.064 107.565  1.00 64.16           O
HETATM 4505  O   HOH B2167     145.152  89.085 105.232  1.00 72.50           O
HETATM 4506  O   HOH B2168     108.375  52.020 102.824  1.00 74.08           O
HETATM 4507  O   HOH B2169     145.436 103.401 147.586  1.00 73.06           O
HETATM 4508  O   HOH B2170     152.657 100.616  97.714  1.00 65.82           O
HETATM 4509  O   HOH B2171     169.283  95.731 106.288  1.00 61.17           O
HETATM 4510  O   HOH B2172     144.413  80.934 130.679  1.00 64.46           O
HETATM 4511  O   HOH B2173     114.732  70.198 127.238  1.00 69.32           O
HETATM 4512  O   HOH B2174     133.607  80.927 116.964  1.00 59.36           O
HETATM 4513  O   HOH B2175     149.622  77.198 101.874  1.00 79.01           O
HETATM 4514  O   HOH B2176     170.227  94.347  87.846  1.00 74.86           O
HETATM 4515  O   HOH B2177     161.257  84.170  90.541  1.00 73.37           O
HETATM 4516  O   HOH B2178     168.177 106.124 119.644  1.00 66.66           O
HETATM 4517  O   HOH B2179     152.103 102.127 101.632  1.00 65.88           O
HETATM 4518  O   HOH B2180     143.843  79.078  96.874  1.00 87.21           O
HETATM 4519  O   HOH B2181     147.646  94.415 140.471  1.00 71.82           O
HETATM 4520  O   HOH B2182     171.470  97.875 130.705  1.00 63.94           O
HETATM 4521  O   HOH B2183     152.873 116.702 131.619  1.00 81.08           O
HETATM 4522  O   HOH B2184     151.056  91.507 128.881  1.00 59.58           O
HETATM 4523  O   HOH B2185     142.819  92.766 100.169  1.00 70.19           O
HETATM 4524  O   HOH B2186     127.471  56.501  98.655  1.00 72.67           O
HETATM 4525  O   HOH B2187     129.974  79.507 138.402  1.00 68.44           O
HETATM 4526  O   HOH B2188     160.417  86.649 134.152  1.00 68.30           O
HETATM 4527  O   HOH B2189      98.262  76.392 125.254  1.00 74.19           O
HETATM 4528  O   HOH B2190     110.401  63.791 144.763  1.00 82.65           O
HETATM 4529  O   HOH B2191     162.781  82.700 122.185  1.00 66.14           O
HETATM 4530  O   HOH B2192     131.098  47.328 114.921  1.00 71.90           O
HETATM 4531  O   HOH B2193     126.844  50.776 129.843  1.00 75.99           O
HETATM 4532  O   HOH B2194     107.706  80.415 122.596  1.00 65.20           O
HETATM 4533  O   HOH B2195     107.224  60.952 121.966  1.00 63.89           O
HETATM 4534  O   HOH B2196     122.512  99.702 103.376  1.00 66.34           O
HETATM 4535  O   HOH B2197     138.871  92.186 140.881  1.00 68.51           O
HETATM 4536  O   HOH B2198     174.183 106.960 106.182  1.00 61.07           O
HETATM 4537  O   HOH B2199     115.125  68.917 131.659  1.00 72.94           O
HETATM 4538  O   HOH B2200     106.924  58.422 122.424  1.00 66.34           O
HETATM 4539  O   HOH B2201     129.139  90.667 105.128  1.00 64.69           O
HETATM 4540  O   HOH B2202     137.488  97.929 136.484  1.00 64.60           O
HETATM 4541  O   HOH B2203     152.359 101.258 122.499  1.00 57.40           O
HETATM 4542  O   HOH B2204     163.359 102.937  95.009  1.00 71.98           O
HETATM 4543  O   HOH B2205     143.426  77.033 100.736  1.00 83.62           O
HETATM 4544  O   HOH B2206     140.120  70.513 130.018  1.00 72.64           O
HETATM 4545  O   HOH B2207     168.613  89.825 132.391  1.00 66.59           O
HETATM 4546  O   HOH B2208     124.366  85.798 110.467  1.00 62.52           O
HETATM 4547  O   HOH B2209     135.252  92.960 120.261  1.00 47.41           O
HETATM 4548  O   HOH B2210     129.474  71.905 110.365  1.00 66.26           O
HETATM 4549  O   HOH B2211     118.668  89.455  99.110  1.00 61.99           O
HETATM 4550  O   HOH B2212     105.153  51.322 130.498  1.00 73.09           O
HETATM 4551  O   HOH B2213     127.832  70.964 135.500  1.00 72.47           O
HETATM 4552  O   HOH B2214     139.640 104.430 112.796  1.00 59.78           O
HETATM 4553  O   HOH B2215     171.088  87.413 129.188  1.00 70.01           O
HETATM 4554  O   HOH B2216     161.579  87.401 120.475  1.00 57.29           O
HETATM 4555  O   HOH B2217     145.345  71.291 120.573  1.00 66.51           O
HETATM 4556  O   HOH B2218     119.032 108.981 118.825  1.00 70.01           O
HETATM 4557  O   HOH B2219     141.395  87.402 144.803  1.00 71.63           O
HETATM 4558  O   HOH B2220     106.996  64.260 112.291  1.00 64.66           O
HETATM 4559  O   HOH B2221     130.223  88.316  94.474  1.00 80.03           O
HETATM 4560  O   HOH B2222     156.126 104.668 133.196  1.00 60.11           O
HETATM 4561  O   HOH B2223     107.131  50.777 117.993  1.00 69.96           O
HETATM 4562  O   HOH B2224     156.573  85.837 122.309  1.00 59.38           O
HETATM 4563  O   HOH B2225     144.454  87.198  97.773  1.00 78.55           O
HETATM 4564  O   HOH B2226     114.705 102.371 140.385  1.00 78.08           O
HETATM 4565  O   HOH B2227     131.361  77.138 106.463  1.00 64.67           O
HETATM 4566  O   HOH B2228     110.902 102.132 128.862  1.00 77.21           O
HETATM 4567  O   HOH B2229     126.040  73.086 137.178  1.00 70.87           O
HETATM 4568  O   HOH B2230     143.135  87.052 132.920  1.00 63.90           O
HETATM 4569  O   HOH B2231     175.709  77.523 121.066  1.00 71.61           O
HETATM 4570  O   HOH B2232     102.987  62.073 125.173  1.00 71.86           O
HETATM 4571  O   HOH B2233     120.741  69.964 129.940  1.00 71.65           O
HETATM 4572  O   HOH B2234     180.592  83.067 110.695  1.00 69.81           O
HETATM 4573  O   HOH B2235     113.775  66.701 144.159  1.00 79.65           O
HETATM 4574  O   HOH B2236     126.252  91.370 114.798  1.00 54.59           O
HETATM 4575  O   HOH B2237     115.063 100.242 138.496  1.00 71.35           O
HETATM 4576  O   HOH B2238     137.059  69.018 130.835  1.00 70.24           O
HETATM 4577  O   HOH B2239     150.111  89.901 106.300  1.00 66.51           O
HETATM 4578  O   HOH B2240     165.794 104.419 111.583  1.00 60.24           O
HETATM 4579  O   HOH B2241     153.432 101.472 114.887  1.00 63.68           O
HETATM 4580  O   HOH B2242     109.619  91.890 107.367  1.00 59.10           O
HETATM 4581  O   HOH B2243     108.210  74.372 149.873  1.00 78.76           O
HETATM 4582  O   HOH B2244     117.346  91.896 137.032  1.00 60.06           O
HETATM 4583  O   HOH B2245     151.394 100.684  99.907  1.00 67.88           O
HETATM 4584  O   HOH B2246     124.309  87.425 138.793  1.00 60.91           O
HETATM 4585  O   HOH B2247     180.419  85.833 105.345  1.00 78.28           O
HETATM 4586  O   HOH B2248     145.218  89.614 128.772  1.00 57.63           O
HETATM 4587  O   HOH B2249     147.195  69.505 106.886  1.00 76.01           O
HETATM 4588  O   HOH B2250     154.348  82.892  93.726  1.00 72.38           O
HETATM 4589  O   HOH B2251     141.696  58.965 108.427  1.00 75.14           O
HETATM 4590  O   HOH B2252      91.922  76.524 136.932  1.00 80.52           O
HETATM 4591  O   HOH B2253     155.601  80.535 108.156  1.00 63.21           O
HETATM 4592  O   HOH B2254     153.743  95.948  97.029  1.00 66.96           O
HETATM 4593  O   HOH B2255     139.105 110.840 128.815  1.00 66.72           O
HETATM 4594  O   HOH B2256     128.156  70.982 123.528  1.00 65.62           O
HETATM 4595  O   HOH B2257     131.186  58.809 103.954  1.00 72.72           O
HETATM 4596  O   HOH B2258     155.527  77.969 116.409  1.00 59.44           O
HETATM 4597  O   HOH B2259     120.833  47.461 109.330  1.00 73.93           O
HETATM 4598  O   HOH B2260     159.908 100.264  99.863  1.00 62.11           O
HETATM 4599  O   HOH B2261     156.816  65.522 118.918  1.00 81.20           O
HETATM 4600  O   HOH B2262     147.903  88.060 125.626  1.00 55.52           O
HETATM 4601  O   HOH B2263     138.256  92.151 105.176  1.00 65.83           O
HETATM 4602  O   HOH B2264     149.808  91.790  98.539  1.00 66.37           O
HETATM 4603  O   HOH B2265     110.426  69.830 119.039  1.00 65.99           O
HETATM 4604  O   HOH B2266     158.610 103.160 131.399  1.00 62.27           O
HETATM 4605  O   HOH B2267     132.451  78.449 112.135  1.00 67.42           O
HETATM 4606  O   HOH B2268     161.264 109.440 122.984  1.00 71.33           O
HETATM 4607  O   HOH B2269     150.110  94.813 121.586  1.00 54.52           O
HETATM 4608  O   HOH B2270     131.704 104.261 135.815  1.00 68.78           O
HETATM 4609  O   HOH B2271     125.988  54.045 132.463  1.00 75.00           O
HETATM 4610  O   HOH B2272      90.251  76.950 132.032  1.00 79.15           O
HETATM 4611  O   HOH B2273     139.444  79.017 116.167  1.00 63.42           O
HETATM 4612  O   HOH B2274     132.579  92.223 130.693  1.00 57.22           O
HETATM 4613  O   HOH B2275     121.736  43.231 131.023  1.00 78.04           O
HETATM 4614  O   HOH B2276     125.872  62.977  98.754  1.00 74.54           O
HETATM 4615  O   HOH B2277     105.606  57.213 133.573  1.00 74.81           O
HETATM 4616  O   HOH B2278     120.189 106.770 125.415  1.00 63.87           O
HETATM 4617  O   HOH B2279     140.206  62.186 122.955  1.00 75.85           O
HETATM 4618  O   HOH B2280     127.232  97.006 129.052  1.00 60.42           O
HETATM 4619  O   HOH B2281     136.747 103.150 143.525  1.00 74.52           O
HETATM 4620  O   HOH B2282     131.139  79.180 108.935  1.00 63.91           O
HETATM 4621  O   HOH B2283     139.897  65.848 129.982  1.00 72.34           O
HETATM 4622  O   HOH B2284     118.299  76.802 127.402  1.00 61.11           O
HETATM 4623  O   HOH B2285     103.753  61.147 118.347  1.00 65.44           O
HETATM 4624  O   HOH B2286     117.082  68.696 117.740  1.00 62.23           O
HETATM 4625  O   HOH B2287     130.707 101.379 126.604  1.00 61.22           O
HETATM 4626  O   HOH B2288     176.290  96.263 102.672  1.00 67.22           O
HETATM 4627  O   HOH B2289     109.789  69.212 116.063  1.00 67.62           O
HETATM 4628  O   HOH B2290     141.758 102.691 119.190  1.00 57.65           O
HETATM 4629  O   HOH B2291     119.783  52.096 136.471  1.00 73.77           O
HETATM 4630  O   HOH B2292     147.393  96.476 109.316  1.00 61.69           O
HETATM 4631  O   HOH B2293     119.911  65.092 115.943  1.00 61.00           O
HETATM 4632  O   HOH B2294     164.206 102.008 113.044  1.00 60.89           O
HETATM 4633  O   HOH B2295     116.779  73.741  96.368  1.00 67.15           O
HETATM 4634  O   HOH B2296     134.811  67.568 101.002  1.00 77.01           O
HETATM 4635  O   HOH B2297     155.287  77.171 108.700  1.00 64.42           O
HETATM 4636  O   HOH B2298     126.845  88.546 103.003  1.00 68.64           O
HETATM 4637  O   HOH B2299     121.108  77.616 100.807  1.00 66.00           O
HETATM 4638  O   HOH B2300     114.532  79.816 128.082  1.00 59.53           O
HETATM 4639  O   HOH B2301     143.605  95.819  99.760  1.00 69.98           O
HETATM 4640  O   HOH B2302     115.757  42.302 116.996  1.00 77.37           O
HETATM 4641  O   HOH B2303     152.364 110.222 145.094  1.00 75.04           O
HETATM 4642  O   HOH B2304     125.189  74.019  92.653  1.00 74.15           O
HETATM 4643  O   HOH B2305     107.811  63.821 130.814  1.00 69.65           O
HETATM 4644  O   HOH B2306     115.870 102.779 114.410  1.00 67.42           O
HETATM 4645  O   HOH B2307     143.941  94.393 146.014  1.00 71.99           O
HETATM 4646  O   HOH B2308     124.643  97.001 100.478  1.00 67.03           O
HETATM 4647  O   HOH B2309     141.956  97.625 110.680  1.00 61.15           O
HETATM 4648  O   HOH B2310     136.152  67.256 102.926  1.00 79.76           O
HETATM 4649  O   HOH B2311     147.906  94.618 102.189  1.00 66.12           O
HETATM 4650  O   HOH B2312     128.697  94.457 138.893  1.00 66.73           O
HETATM 4651  O   HOH B2313     167.942 101.482 115.125  1.00 63.09           O
HETATM 4652  O   HOH B2314     113.513  93.713 125.415  1.00 59.88           O
HETATM 4653  O   HOH B2315     126.321 104.325 120.317  1.00 62.96           O
HETATM 4654  O   HOH B2316      81.895  80.280 117.988  1.00 77.39           O
HETATM 4655  O   HOH B2317     115.032  95.130 108.449  1.00 63.65           O
HETATM 4656  O   HOH B2318     113.910  70.917  96.142  1.00 68.18           O
HETATM 4657  O   HOH B2319     144.074  61.833 118.958  1.00 75.00           O
HETATM 4658  O   HOH B2320     131.483  63.199 128.821  1.00 69.16           O
HETATM 4659  O   HOH B2321     145.952  85.209 117.677  1.00 61.48           O
HETATM 4660  O   HOH B2322     135.229  96.696 103.540  1.00 64.14           O
HETATM 4661  O   HOH B2323      96.168  86.860 136.107  1.00 74.79           O
HETATM 4662  O   HOH B2324     123.230  69.520 128.194  1.00 69.12           O
HETATM 4663  O   HOH B2325     158.790  98.204  97.173  1.00 64.93           O
HETATM 4664  O   HOH B2326     139.274  85.406 144.063  1.00 72.72           O
HETATM 4665  O   HOH B2327     137.809  92.528 110.048  1.00 58.94           O
HETATM 4666  O   HOH B2328     177.926  88.622  99.804  1.00 76.07           O
HETATM 4667  O   HOH B2329     177.444  84.832 121.137  1.00 69.52           O
HETATM 4668  O   HOH B2330     113.843  70.256 130.205  1.00 70.79           O
HETATM 4669  O   HOH B2331     113.625  90.711 130.727  1.00 63.79           O
HETATM 4670  O   HOH B2332     181.650  80.008 120.919  1.00 75.91           O
HETATM 4671  O   HOH B2333     125.942  67.002 110.119  1.00 64.77           O
HETATM 4672  O   HOH B2334     135.132  90.540 146.998  1.00 72.13           O
HETATM 4673  O   HOH B2335     157.817 103.027 105.586  1.00 61.17           O
HETATM 4674  O   HOH B2336     116.347  97.969 112.912  1.00 60.92           O
HETATM 4675  O   HOH B2337     112.426  93.038 127.828  1.00 63.90           O
HETATM 4676  O   HOH B2338     134.893 107.094 125.725  1.00 64.89           O
HETATM 4677  O   HOH B2339     117.028  68.976 109.491  1.00 64.13           O
HETATM 4678  O   HOH B2340     144.720  64.460 104.996  1.00 76.06           O
HETATM 4679  O   HOH B2341     159.953 107.868 100.757  1.00 66.75           O
HETATM 4680  O   HOH B2342     136.656  76.475 135.647  1.00 68.55           O
HETATM 4681  O   HOH B2343     169.733  86.894 106.257  1.00 65.77           O
HETATM 4682  O   HOH B2344     120.280  81.691 134.700  1.00 66.30           O
HETATM 4683  O   HOH B2345     127.857 103.433 124.377  1.00 61.59           O
HETATM 4684  O   HOH B2346     113.824  62.888  99.915  1.00 69.60           O
HETATM 4685  O   HOH B2347     111.386  68.078 144.342  1.00 76.86           O
HETATM 4686  O   HOH B2348     141.879 101.755 124.718  1.00 52.30           O
HETATM 4687  O   HOH B2349     127.768  69.415 106.462  1.00 67.82           O
HETATM 4688  O   HOH B2350     118.837  75.477 115.715  1.00 60.63           O
HETATM 4689  O   HOH B2351     149.828 100.525 126.238  1.00 52.15           O
HETATM 4690  O   HOH B2352     136.501  74.929 101.998  1.00 72.60           O
HETATM 4691  O   HOH B2353     121.405  90.205 105.742  1.00 60.45           O
HETATM 4692  O   HOH B2354     128.031  44.320 110.122  1.00 71.66           O
HETATM 4693  O   HOH B2355     100.579  66.692 144.367  1.00 78.26           O
HETATM 4694  O   HOH B2356     127.640  64.467 111.929  1.00 64.56           O
HETATM 4695  O   HOH B2357     163.265  88.991  88.898  1.00 75.54           O
HETATM 4696  O   HOH B2358     108.066  95.798 144.200  1.00 76.05           O
HETATM 4697  O   HOH B2359     162.334 105.679 105.256  1.00 62.73           O
HETATM 4698  O   HOH B2360     116.765  77.805  95.355  1.00 70.33           O
HETATM 4699  O   HOH B2361     119.332  66.451 119.659  1.00 63.47           O
HETATM 4700  O   HOH B2362      96.767  71.564 126.645  1.00 79.59           O
HETATM 4701  O   HOH B2363     128.254  87.214 138.996  1.00 64.96           O
HETATM 4702  O   HOH B2364     155.458  99.200 109.494  1.00 61.23           O
HETATM 4703  O   HOH B2365     138.039  71.592 102.481  1.00 76.36           O
HETATM 4704  O   HOH B2366     157.211  79.634 124.465  1.00 66.56           O
HETATM 4705  O   HOH B2367     114.539  72.501 126.706  1.00 68.83           O
HETATM 4706  O   HOH B2368     113.794  89.620 126.184  1.00 59.52           O
HETATM 4707  O   HOH B2369     111.928  71.071 104.800  1.00 64.07           O
HETATM 4708  O   HOH B2370     111.426  42.269 121.803  1.00 78.60           O
HETATM 4709  O   HOH B2371     109.561  60.868 140.406  1.00 76.08           O
HETATM 4710  O   HOH B2372     145.143  81.295 116.433  1.00 63.84           O
HETATM 4711  O   HOH B2373     138.580  52.885 119.045  1.00 74.01           O
HETATM 4712  O   HOH B2374     155.504  97.563  94.832  1.00 67.82           O
HETATM 4713  O   HOH B2375     104.880  86.747 128.977  1.00 72.23           O
HETATM 4714  O   HOH B2376     138.289  90.404 101.565  1.00 72.35           O
HETATM 4715  O   HOH B2377     109.145  92.008 149.927  1.00 79.43           O
HETATM 4716  O   HOH B2378     118.239  86.451 143.032  1.00 72.44           O
HETATM 4717  O   HOH B2379     138.390  98.297 131.604  1.00 53.70           O
HETATM 4718  O   HOH B2380     160.658 104.689 131.052  1.00 68.67           O
HETATM 4719  O   HOH B2381     132.681 107.059 122.462  1.00 64.81           O
HETATM 4720  O   HOH B2382     118.554  83.898 140.637  1.00 69.11           O
HETATM 4721  O   HOH B2383     116.493  86.470  97.600  1.00 66.77           O
HETATM 4722  O   HOH B2384     139.250 110.294 144.352  1.00 75.91           O
HETATM 4723  O   HOH B2385     148.558  85.641 110.746  1.00 64.96           O
HETATM 4724  O   HOH B2386     150.311  82.839 126.905  1.00 66.21           O
HETATM 4725  O   HOH B2387     108.938  74.408 116.889  1.00 63.93           O
HETATM 4726  O   HOH B2388     137.827 101.749  99.166  1.00 72.82           O
HETATM 4727  O   HOH B2389      87.341  80.650 125.779  1.00 75.66           O
HETATM 4728  O   HOH B2390     146.592  79.162 112.432  1.00 70.19           O
HETATM 4729  O   HOH B2391     172.759  85.749 109.110  1.00 66.61           O
HETATM 4730  O   HOH B2392     150.342  80.719 112.786  1.00 66.17           O
HETATM 4731  O   HOH B2393     100.073  89.747 141.479  1.00 78.59           O
HETATM 4732  O   HOH B2394      85.195  89.899 114.486  1.00 72.09           O
HETATM 4733  O   HOH B2395     134.793  92.850 131.677  1.00 56.25           O
HETATM 4734  O   HOH B2396     129.622  80.088 122.697  1.00 58.63           O
HETATM 4735  O   HOH B2397     160.333 103.343 121.848  1.00 63.67           O
HETATM 4736  O   HOH B2398     166.016  97.386  90.094  1.00 74.07           O
HETATM 4737  O   HOH B2399     126.291  94.177 100.811  1.00 65.89           O
HETATM 4738  O   HOH B2400     137.583  78.298 114.897  1.00 64.48           O
HETATM 4739  O   HOH B2401     122.408  96.673 135.448  1.00 58.63           O
HETATM 4740  O   HOH B2402     129.750  69.869 133.393  1.00 74.62           O
HETATM 4741  O   HOH B2403     114.752  81.046  94.154  1.00 71.45           O
HETATM 4742  O   HOH B2404     178.262  94.412 105.550  1.00 67.81           O
HETATM 4743  O   HOH B2405     102.415  59.783 128.488  1.00 71.65           O
HETATM 4744  O   HOH B2406     100.013  84.700 145.026  1.00 75.06           O
HETATM 4745  O   HOH B2407     148.934  63.243 110.802  1.00 75.27           O
HETATM 4746  O   HOH B2408     119.306  66.091 128.884  1.00 64.36           O
HETATM 4747  O   HOH B2409     149.777  70.673 122.107  1.00 67.59           O
HETATM 4748  O   HOH B2410     114.067  78.826  94.751  1.00 70.39           O
HETATM 4749  O   HOH B2411     134.397  87.025 144.718  1.00 72.55           O
HETATM 4750  O   HOH B2412     139.250  92.407  99.908  1.00 73.80           O
HETATM 4751  O   HOH B2413     166.394  88.401 102.918  1.00 65.05           O
HETATM 4752  O   HOH B2414     113.321  94.450 120.810  1.00 57.66           O
HETATM 4753  O   HOH B2415     113.757  94.599 144.076  1.00 71.39           O
HETATM 4754  O   HOH B2416      83.654  79.275 121.122  1.00 74.90           O
HETATM 4755  O   HOH B2417     125.862  46.018 128.925  1.00 74.85           O
HETATM 4756  O   HOH B2418     110.597  86.510 125.072  1.00 63.13           O
HETATM 4757  O   HOH B2419     109.945  87.466 151.685  1.00 78.21           O
HETATM 4758  O   HOH B2420     189.257  97.276  99.739  1.00 78.65           O
HETATM 4759  O   HOH B2421     143.326 115.535 141.506  1.00 82.48           O
HETATM 4760  O   HOH B2422     124.533  87.197 112.823  1.00 59.70           O
HETATM 4761  O   HOH B2423     132.380  47.929 112.062  1.00 66.20           O
HETATM 4762  O   HOH B2424     121.214  45.196 105.243  1.00 78.86           O
HETATM 4763  O   HOH B2425     134.432  63.273 123.092  1.00 68.47           O
HETATM 4764  O   HOH B2426     146.684  74.215 123.259  1.00 66.32           O
HETATM 4765  O   HOH B2427     130.257  98.514 114.577  1.00 51.90           O
HETATM 4766  O   HOH B2428     161.476 101.075 116.423  1.00 62.03           O
HETATM 4767  O   HOH B2429     103.372  89.913 118.247  1.00 66.28           O
HETATM 4768  O   HOH B2430     133.098  48.987 119.070  1.00 74.13           O
HETATM 4769  O   HOH B2431     129.249 103.459  96.199  1.00 66.66           O
HETATM 4770  O   HOH B2432     127.930 102.582 121.250  1.00 58.97           O
HETATM 4771  O   HOH B2433     133.832  95.368 133.281  1.00 62.95           O
HETATM 4772  O   HOH B2434     158.735  72.276 119.625  1.00 71.29           O
HETATM 4773  O   HOH B2435     115.523  76.242 135.500  1.00 76.82           O
HETATM 4774  O   HOH B2436     123.458  54.215 103.726  1.00 72.07           O
HETATM 4775  O   HOH B2437     167.630  96.012  88.313  1.00 73.31           O
HETATM 4776  O   HOH B2438     151.030  83.238 111.942  1.00 66.17           O
HETATM 4777  O   HOH B2439     145.426  87.102 103.821  1.00 70.73           O
HETATM 4778  O   HOH B2440     123.109 104.223 134.257  1.00 70.59           O
HETATM 4779  O   HOH B2441     123.101  47.821 126.883  1.00 71.03           O
HETATM 4780  O   HOH B2442     105.204  80.493 143.013  1.00 73.70           O
HETATM 4781  O   HOH B2443     129.557  96.099 129.421  1.00 59.35           O
HETATM 4782  O   HOH B2444     137.707 107.429 118.659  1.00 59.57           O
HETATM 4783  O   HOH B2445     118.705  73.698 137.400  1.00 78.36           O
HETATM 4784  O   HOH B2446     118.029 105.029 130.827  1.00 65.04           O
HETATM 4785  O   HOH B2447      96.970  83.550 128.445  1.00 75.43           O
HETATM 4786  O   HOH B2448     139.890 103.756 120.829  1.00 57.91           O
HETATM 4787  O   HOH B2449     175.296 103.438 105.460  1.00 61.09           O
HETATM 4788  O   HOH B2450     138.987  93.511 132.878  1.00 56.35           O
HETATM 4789  O   HOH B2451     141.590 104.293 122.894  1.00 61.80           O
HETATM 4790  O   HOH B2452     130.193  92.140 135.378  1.00 63.60           O
HETATM 4791  O   HOH B2453     178.709 103.641 111.567  1.00 65.67           O
HETATM 4792  O   HOH B2454     111.073 100.320 145.692  1.00 79.74           O
HETATM 4793  O   HOH B2455     132.571  63.862  97.623  1.00 75.69           O
HETATM 4794  O   HOH B2456     128.686  78.445 119.652  1.00 61.73           O
HETATM 4795  O   HOH B2457     160.438  84.860 114.662  1.00 61.21           O
HETATM 4796  O   HOH B2458      93.691  83.264 126.075  1.00 79.08           O
HETATM 4797  O   HOH B2459     113.566  58.150 141.414  1.00 81.98           O
HETATM 4798  O   HOH B2460     118.989 102.706 132.741  1.00 63.44           O
HETATM 4799  O   HOH B2461     131.709 111.329 137.615  1.00 71.29           O
HETATM 4800  O   HOH B2462     145.126 108.704 125.378  1.00 65.20           O
HETATM 4801  O   HOH B2463     155.598  89.421  92.709  1.00 70.92           O
HETATM 4802  O   HOH B2464     129.078  76.283 125.638  1.00 62.79           O
HETATM 4803  O   HOH B2465     172.883  90.263 130.115  1.00 66.10           O
HETATM 4804  O   HOH B2466     164.367  83.739 113.798  1.00 64.72           O
HETATM 4805  O   HOH B2467     148.965  90.631  93.205  1.00 76.32           O
HETATM 4806  O   HOH B2468     121.153 107.206 105.315  1.00 64.36           O
HETATM 4807  O   HOH B2469     163.010  84.502 106.136  1.00 66.50           O
HETATM 4808  O   HOH B2470     111.843  67.790 121.777  1.00 63.88           O
HETATM 4809  O   HOH B2471     179.026 102.326  99.770  1.00 70.70           O
HETATM 4810  O   HOH B2472     125.273  49.452 121.298  1.00 68.36           O
HETATM 4811  O   HOH B2473     109.812  64.468  97.644  1.00 65.62           O
HETATM 4812  O   HOH B2474     155.895  95.775 103.335  1.00 58.52           O
HETATM 4813  O   HOH B2475     138.944 107.161 123.420  1.00 64.71           O
HETATM 4814  O   HOH B2476     100.353  62.626 137.894  1.00 79.38           O
HETATM 4815  O   HOH B2477     139.678  73.855 100.260  1.00 80.70           O
HETATM 4816  O   HOH B2478     108.568  88.901 124.031  1.00 62.88           O
HETATM 4817  O   HOH B2479     131.009  87.075 103.958  1.00 71.51           O
HETATM 4818  O   HOH B2480     161.441  71.065 109.947  1.00 71.32           O
HETATM 4819  O   HOH B2481     114.790 105.114 137.885  1.00 77.84           O
HETATM 4820  O   HOH B2482     148.475  88.060 102.008  1.00 68.63           O
HETATM 4821  O   HOH B2483     142.367 105.949 126.415  1.00 61.44           O
HETATM 4822  O   HOH B2484     162.568  71.322 111.973  1.00 68.66           O
HETATM 4823  O   HOH B2485     122.249  97.466 140.301  1.00 64.91           O
HETATM 4824  O   HOH B2486     151.815  70.941 119.331  1.00 68.08           O
HETATM 4825  O   HOH B2487     121.060  67.420 111.876  1.00 62.95           O
HETATM 4826  O   HOH B2488     117.055  96.155 103.395  1.00 64.23           O
HETATM 4827  O   HOH B2489     106.782  74.757 102.442  1.00 62.47           O
HETATM 4828  O   HOH B2490     116.143  81.913 132.663  1.00 65.74           O
HETATM 4829  O   HOH B2491     142.231  76.312 102.747  1.00 78.07           O
HETATM 4830  O   HOH B2492     106.465  54.583 118.205  1.00 69.20           O
HETATM 4831  O   HOH B2493     169.627  88.418 102.407  1.00 68.95           O
HETATM 4832  O   HOH B2494     105.649  62.889 114.788  1.00 65.07           O
HETATM 4833  O   HOH B2495     186.054 102.585 104.876  1.00 72.67           O
HETATM 4834  O   HOH B2496     140.365 112.957 141.642  1.00 77.55           O
HETATM 4835  O   HOH B2497     105.182  69.174 128.505  1.00 71.87           O
HETATM 4836  O   HOH B2498     131.965  96.702 141.535  1.00 72.70           O
HETATM 4837  O   HOH B2499     184.509  81.877 112.203  1.00 71.21           O
HETATM 4838  O   HOH B2500     122.307  64.164 123.740  1.00 63.08           O
HETATM 4839  O   HOH B2501     158.686 102.640  96.899  1.00 66.33           O
HETATM 4840  O   HOH B2502     106.476  50.536 115.196  1.00 72.62           O
HETATM 4841  O   HOH B2503     141.102  72.983 127.092  1.00 68.52           O
HETATM 4842  O   HOH B2504     121.175  98.133 133.747  1.00 56.74           O
HETATM 4843  O   HOH B2505     135.192  69.352 127.833  1.00 72.52           O
HETATM 4844  O   HOH B2506     123.685  68.712  93.378  1.00 78.64           O
HETATM 4845  O   HOH B2507     144.412  94.622 109.236  1.00 63.43           O
HETATM 4846  O   HOH B2508     159.996  90.287 101.746  1.00 60.57           O
HETATM 4847  O   HOH B2509     148.766  74.976 124.090  1.00 68.06           O
HETATM 4848  O   HOH B2510     146.929  88.779  91.214  1.00 81.45           O
HETATM 4849  O   HOH B2511      87.650  76.537 141.841  1.00 85.70           O
HETATM 4850  O   HOH B2512     171.634 102.160  99.830  1.00 64.02           O
HETATM 4851  O   HOH B2513      90.562  76.862 125.067  1.00 73.94           O
HETATM 4852  O   HOH B2514     133.625  93.049 144.080  1.00 68.97           O
HETATM 4853  O   HOH B2515     120.859  81.036 107.899  1.00 60.42           O
HETATM 4854  O   HOH B2516     128.668  68.930 108.546  1.00 68.18           O
HETATM 4855  O   HOH B2517     172.126  75.208 114.372  1.00 68.64           O
HETATM 4856  O   HOH B2518     155.941  79.146 102.238  1.00 69.56           O
HETATM 4857  O   HOH B2519     139.901 104.045 101.527  1.00 70.10           O
HETATM 4858  O   HOH B2520     148.622  86.585 118.631  1.00 58.98           O
HETATM 4859  O   HOH B2521     120.919  61.878 138.065  1.00 70.60           O
HETATM 4860  O   HOH B2522     112.443  44.361 118.230  1.00 77.62           O
HETATM 4861  O   HOH B2523     118.435  80.035 143.186  1.00 74.48           O
HETATM 4862  O   HOH B2524     173.647  75.544 121.224  1.00 71.42           O
HETATM 4863  O   HOH B2525     102.363  70.654 148.564  1.00 77.90           O
HETATM 4864  O   HOH B2526     103.966  87.828 120.977  1.00 65.10           O
HETATM 4865  O   HOH B2527     174.421  92.681 128.295  1.00 66.20           O
HETATM 4866  O   HOH B2528     131.598  54.515 106.226  1.00 70.69           O
HETATM 4867  O   HOH B2529     108.929  78.609 125.287  1.00 68.83           O
HETATM 4868  O   HOH B2530     121.835  84.953  98.307  1.00 69.35           O
HETATM 4869  O   HOH B2531     169.015 104.147 122.034  1.00 64.76           O
HETATM 4870  O   HOH B2532     109.923  84.953 126.855  1.00 65.97           O
HETATM 4871  O   HOH B2533     131.349  94.689 136.120  1.00 67.67           O
HETATM 4872  O   HOH B2534     159.362 107.387 121.760  1.00 70.80           O
HETATM 4873  O   HOH B2535     141.844  88.030 137.828  1.00 66.10           O
HETATM 4874  O   HOH B2536     136.060  79.478 118.995  1.00 57.23           O
HETATM 4875  O   HOH B2537     156.856 114.085 124.731  1.00 72.78           O
HETATM 4876  O   HOH B2538     119.461  98.604 138.445  1.00 63.54           O
HETATM 4877  O   HOH B2539     106.229  53.443 103.230  1.00 67.63           O
HETATM 4878  O   HOH B2540     131.216 113.733 134.168  1.00 74.33           O
HETATM 4879  O   HOH B2541     181.692 103.643 117.283  1.00 72.59           O
HETATM 4880  O   HOH B2542     123.105  43.763 108.299  1.00 79.15           O
HETATM 4881  O   HOH B2543     155.279  78.726 105.887  1.00 68.08           O
HETATM 4882  O   HOH B2544     108.093  72.775 119.212  1.00 68.12           O
HETATM 4883  O   HOH B2545     115.484  70.691 110.936  1.00 64.53           O
HETATM 4884  O   HOH B2546     160.711 111.219 119.685  1.00 71.79           O
HETATM 4885  O   HOH B2547     119.583 106.229 111.901  1.00 62.92           O
HETATM 4886  O   HOH B2548     136.636  90.135 103.237  1.00 73.28           O
HETATM 4887  O   HOH B2549     154.978  65.664 120.406  1.00 83.22           O
HETATM 4888  O   HOH B2550     116.663  76.591 137.508  1.00 75.71           O
HETATM 4889  O   HOH B2551     121.181  39.997 113.648  1.00 73.14           O
HETATM 4890  O   HOH B2552     157.031  74.741 119.951  1.00 68.14           O
HETATM 4891  O   HOH B2553     139.954  85.043  98.911  1.00 77.59           O
HETATM 4892  O   HOH B2554     111.258  59.482 104.701  1.00 68.61           O
HETATM 4893  O   HOH B2555     106.263  73.123 148.280  1.00 78.67           O
HETATM 4894  O   HOH B2556     109.785  69.143 102.159  1.00 69.30           O
HETATM 4895  O   HOH B2557     169.831 102.859 126.777  1.00 65.13           O
HETATM 4896  O   HOH B2558     151.456  83.049 124.196  1.00 66.85           O
HETATM 4897  O   HOH B2559     152.093  86.437  92.744  1.00 80.06           O
HETATM 4898  O   HOH B2560     102.514  65.712 141.614  1.00 77.96           O
HETATM 4899  O   HOH B2561     107.078  69.225 125.589  1.00 66.97           O
HETATM 4900  O   HOH B2562     128.291  68.618 125.970  1.00 66.47           O
HETATM 4901  O   HOH B2563     167.726 106.010 123.680  1.00 63.75           O
HETATM 4902  O   HOH B2564     146.166  99.019 110.178  1.00 64.58           O
HETATM 4903  O   HOH B2565     113.835  59.439 101.830  1.00 69.92           O
HETATM 4904  O   HOH B2566     138.672 109.475 112.289  1.00 66.94           O
HETATM 4905  O   HOH B2567     162.925  96.125  86.749  1.00 75.95           O
HETATM 4906  O   HOH B2568     103.898  79.977 115.693  1.00 62.17           O
HETATM 4907  O   HOH B2569     141.496  64.842 120.529  1.00 71.96           O
HETATM 4908  O   HOH B2570     110.981  94.779 109.620  1.00 63.11           O
HETATM 4909  O   HOH B2571     139.719  81.321 133.469  1.00 62.72           O
HETATM 4910  O   HOH B2572      89.057  83.014 131.147  1.00 80.51           O
HETATM 4911  O   HOH B2573     156.539 101.432  95.312  1.00 70.26           O
HETATM 4912  O   HOH B2574     147.543  74.504 121.138  1.00 66.79           O
HETATM 4913  O   HOH B2575     140.057  97.864 108.664  1.00 61.11           O
HETATM 4914  O   HOH B2576     166.395  77.533 124.780  1.00 71.30           O
HETATM 4915  O   HOH B2577     143.664  89.803 132.078  1.00 57.08           O
HETATM 4916  O   HOH B2578     155.343  83.146 124.652  1.00 64.32           O
HETATM 4917  O   HOH B2579     160.950  82.383 116.535  1.00 64.09           O
HETATM 4918  O   HOH B2580     139.049  90.823 147.722  1.00 68.02           O
HETATM 4919  O   HOH B2581     113.221  72.267 124.174  1.00 66.30           O
HETATM 4920  O   HOH B2582     120.896  40.950 110.944  1.00 77.92           O
HETATM 4921  O   HOH B2583     109.638  98.069 128.341  1.00 70.95           O
HETATM 4922  O   HOH B2584     120.838  43.322 109.484  1.00 77.77           O
HETATM 4923  O   HOH B2585     145.696  75.667 119.940  1.00 64.66           O
HETATM 4924  O   HOH B2586     123.745  94.700 142.742  1.00 67.39           O
HETATM 4925  O   HOH B2587     126.020  72.206 113.585  1.00 64.23           O
HETATM 4926  O   HOH B2588     146.027  97.365 116.807  1.00 55.80           O
HETATM 4927  O   HOH B2589     119.495  78.177 137.033  1.00 72.75           O
HETATM 4928  O   HOH B2590     127.112 101.184 140.613  1.00 71.99           O
HETATM 4929  O   HOH B2591     121.737  88.970 141.418  1.00 63.27           O
HETATM 4930  O   HOH B2592     123.016  56.893 104.042  1.00 69.32           O
HETATM 4931  O   HOH B2593     130.429  64.829 111.035  1.00 68.45           O
HETATM 4932  O   HOH B2594     108.690  72.419 115.537  1.00 66.25           O
HETATM 4933  O   HOH B2595     130.345  68.397 113.957  1.00 64.85           O
HETATM 4934  O   HOH B2596     154.555  94.506  93.199  1.00 68.21           O
HETATM 4935  O   HOH B2597     140.496  99.981 106.571  1.00 65.04           O
HETATM 4936  O   HOH B2598     111.035  91.125 128.189  1.00 68.33           O
HETATM 4937  O   HOH B2599     113.631  77.183 133.102  1.00 72.87           O
HETATM 4938  O   HOH B2600     129.699  67.734  95.120  1.00 74.57           O
HETATM 4939  O   HOH B2601     186.418  83.699 102.137  1.00 82.60           O
HETATM 4940  O   HOH B2602     148.868 108.873 145.970  1.00 77.49           O
HETATM 4941  O   HOH B2603     147.698  90.459 104.556  1.00 69.92           O
HETATM 4942  O   HOH B2604     106.771  57.184 120.425  1.00 64.40           O
HETATM 4943  O   HOH B2605     109.914  53.117 100.497  1.00 72.75           O
HETATM 4944  O   HOH B2606     125.053  73.447  95.095  1.00 73.10           O
HETATM 4945  O   HOH B2607     164.863  84.858 115.989  1.00 63.01           O
HETATM 4946  O   HOH B2608     122.225  64.840 132.172  1.00 71.71           O
HETATM 4947  O   HOH B2609     105.241  90.746 113.228  1.00 60.05           O
HETATM 4948  O   HOH B2610     101.730  59.304 130.808  1.00 74.04           O
HETATM 4949  O   HOH B2611     114.359  95.372 116.697  1.00 63.70           O
HETATM 4950  O   HOH B2612     107.805  93.024 116.568  1.00 63.82           O
HETATM 4951  O   HOH B2613     137.497  85.745 142.157  1.00 69.68           O
HETATM 4952  O   HOH B2614     115.309  52.164 101.052  1.00 72.07           O
HETATM 4953  O   HOH B2615     124.630  49.507 129.375  1.00 71.49           O
HETATM 4954  O   HOH B2616     147.298 112.875 142.662  1.00 84.11           O
HETATM 4955  O   HOH B2617     161.991  89.944  90.630  1.00 71.89           O
HETATM 4956  O   HOH B2618     112.971 104.789 116.126  1.00 71.61           O
HETATM 4957  O   HOH B2619     149.518 102.921 126.146  1.00 56.55           O
HETATM 4958  O   HOH B2620     136.287  62.894 100.742  1.00 78.91           O
HETATM 4959  O   HOH B2621     116.414  99.924 125.986  1.00 60.24           O
HETATM 4960  O   HOH B2622     118.360 106.326 120.265  1.00 65.24           O
HETATM 4961  O   HOH B2623     103.974  79.961 127.646  1.00 72.39           O
HETATM 4962  O   HOH B2624     132.244 107.384 127.527  1.00 69.95           O
HETATM 4963  O   HOH B2625     132.852  48.828 116.706  1.00 72.07           O
HETATM 4964  O   HOH B2626     105.032  91.638 117.312  1.00 64.91           O
HETATM 4965  O   HOH B2627     144.663  71.384 102.762  1.00 78.20           O
HETATM 4966  O   HOH B2628     194.830 100.588 112.840  1.00 80.17           O
HETATM 4967  O   HOH B2629     167.126  85.213 100.220  1.00 70.66           O
HETATM 4968  O   HOH B2630     112.010 101.574 119.285  1.00 69.67           O
HETATM 4969  O   HOH B2631     153.340 103.211 124.982  1.00 63.35           O
HETATM 4970  O   HOH B2632     133.214  73.856  97.240  1.00 75.24           O
HETATM 4971  O   HOH B2633     136.874  77.831 112.633  1.00 65.52           O
HETATM 4972  O   HOH B2634     135.999  53.110 122.902  1.00 74.32           O
HETATM 4973  O   HOH B2635     116.015  48.839 122.772  1.00 67.57           O
HETATM 4974  O   HOH B2636     151.988  70.805 116.795  1.00 66.45           O
HETATM 4975  O   HOH B2637     160.638  92.197  91.647  1.00 69.78           O
HETATM 4976  O   HOH B2638     125.453  47.002 122.092  1.00 76.07           O
HETATM 4977  O   HOH B2639     129.743  61.384 131.341  1.00 68.97           O
HETATM 4978  O   HOH B2640     152.753 109.718 124.107  1.00 65.15           O
HETATM 4979  O   HOH B2641     109.042  45.911 124.648  1.00 74.26           O
HETATM 4980  O   HOH B2642     114.074  46.286 103.891  1.00 80.52           O
HETATM 4981  O   HOH B2643     130.165 106.177 119.838  1.00 59.45           O
HETATM 4982  O   HOH B2644     125.800  75.907 137.891  1.00 71.90           O
HETATM 4983  O   HOH B2645     160.787  84.545 118.398  1.00 61.18           O
HETATM 4984  O   HOH B2646     119.009  66.396 138.667  1.00 77.37           O
HETATM 4985  O   HOH B2647     134.274  64.176 127.946  1.00 72.25           O
HETATM 4986  O   HOH B2648      97.261  87.002 143.436  1.00 76.69           O
HETATM 4987  O   HOH B2649     135.807  88.408 101.853  1.00 75.43           O
HETATM 4988  O   HOH B2650     159.062  88.001 103.245  1.00 63.07           O
HETATM 4989  O   HOH B2651     115.850  58.440 100.035  1.00 71.06           O
HETATM 4990  O   HOH B2652     130.869  61.896  99.556  1.00 74.92           O
HETATM 4991  O   HOH B2653     143.620  81.457  93.108  1.00 85.92           O
HETATM 4992  O   HOH B2654     166.936  81.760 108.217  1.00 67.64           O
HETATM 4993  O   HOH B2655     146.980  80.540 105.902  1.00 73.57           O
HETATM 4994  O   HOH B2656     159.914  91.866 133.249  1.00 62.40           O
HETATM 4995  O   HOH B2657     153.581  91.817  92.767  1.00 73.19           O
HETATM 4996  O   HOH B2658      84.601  80.050 124.190  1.00 76.23           O
HETATM 4997  O   HOH B2659     159.764 109.506 118.452  1.00 71.30           O
HETATM 4998  O   HOH B2660     145.239  96.348 102.391  1.00 69.87           O
HETATM 4999  O   HOH B2661     110.060  73.941  95.294  1.00 68.10           O
HETATM 5000  O   HOH B2662     155.010  67.628 121.683  1.00 81.26           O
HETATM 5001  O   HOH B2663     128.547  98.646 126.411  1.00 57.79           O
HETATM 5002  O   HOH B2664     117.036  80.011 134.212  1.00 72.10           O
HETATM 5003  O   HOH B2665     150.507  76.836 123.857  1.00 65.98           O
HETATM 5004  O   HOH B2666     173.246 101.854 127.585  1.00 65.85           O
HETATM 5005  O   HOH B2667     164.232  79.908 128.527  1.00 68.57           O
HETATM 5006  O   HOH B2668     147.780 116.484 143.207  1.00 86.48           O
HETATM 5007  O   HOH B2669     142.183  93.588 112.730  1.00 59.98           O
HETATM 5008  O   HOH B2670     155.457 112.508 122.289  1.00 70.66           O
HETATM 5009  O   HOH B2671     136.300  95.358 133.523  1.00 63.17           O
HETATM 5010  O   HOH B2672     158.581  99.516 111.313  1.00 61.92           O
HETATM 5011  O   HOH B2673     147.401  91.961 138.066  1.00 68.73           O
HETATM 5012  O   HOH B2674     162.982 110.100 142.165  1.00 75.82           O
HETATM 5013  O   HOH B2675     156.949  70.141 108.152  1.00 69.77           O
HETATM 5014  O   HOH B2676     145.954 112.047 125.626  1.00 70.88           O
HETATM 5015  O   HOH B2677     152.092 112.891 125.373  1.00 68.19           O
HETATM 5016  O   HOH B2678     156.382 109.239 144.419  1.00 70.99           O
HETATM 5017  O   HOH B2679     154.353  87.295 124.016  1.00 59.27           O
HETATM 5018  O   HOH B2680     133.965  62.805 126.033  1.00 70.75           O
HETATM 5019  O   HOH B2681     104.248  75.825 147.853  1.00 76.40           O
HETATM 5020  O   HOH B2682     133.160  61.713 103.644  1.00 74.11           O
HETATM 5021  O   HOH B2683     123.453  41.447 119.561  1.00 76.80           O
HETATM 5022  O   HOH B2684     132.188  59.813 106.153  1.00 68.85           O
HETATM 5023  O   HOH B2685     181.469  79.602 116.530  1.00 72.33           O
HETATM 5024  O   HOH B2686     167.741  79.510 127.160  1.00 70.53           O
HETATM 5025  O   HOH B2687     181.418  85.519  98.009  1.00 82.04           O
HETATM 5026  O   HOH B2688     141.478  72.324 100.167  1.00 82.85           O
HETATM 5027  O   HOH B2689     136.202  60.265 108.176  1.00 73.38           O
HETATM 5028  O   HOH B2690     129.694  88.743 137.858  1.00 64.13           O
HETATM 5029  O   HOH B2691     146.951  93.114 131.705  1.00 58.48           O
HETATM 5030  O   HOH B2692     149.518  99.460 116.682  1.00 58.98           O
HETATM 5031  O   HOH B2693     104.593  67.694 123.132  1.00 67.06           O
HETATM 5032  O   HOH B2694     139.800  84.545 138.704  1.00 68.27           O
HETATM 5033  O   HOH B2695     150.097  92.269 121.219  1.00 58.21           O
HETATM 5034  O   HOH B2696     161.379  79.221 131.191  1.00 71.36           O
HETATM 5035  O   HOH B2697     168.869  77.402 109.685  1.00 69.05           O
HETATM 5036  O   HOH B2698     133.715  82.056 139.917  1.00 69.35           O
HETATM 5037  O   HOH B2699     138.070  57.476 108.748  1.00 73.35           O
HETATM 5038  O   HOH B2700     107.855  86.491 126.708  1.00 69.96           O
HETATM 5039  O   HOH B2701     156.224 104.067 103.777  1.00 63.49           O
HETATM 5040  O   HOH B2702     166.698  83.864 111.056  1.00 63.08           O
HETATM 5041  O   HOH B2703     181.000  95.245 119.403  1.00 71.24           O
HETATM 5042  O   HOH B2704     104.920  56.884 125.438  1.00 64.64           O
HETATM 5043  O   HOH B2705     122.634 107.651 107.653  1.00 63.46           O
HETATM 5044  O   HOH B2706     136.019  55.122 124.409  1.00 73.52           O
HETATM 5045  O   HOH B2707     132.076 110.069 119.845  1.00 62.53           O
HETATM 5046  O   HOH B2708     168.575  80.071 108.155  1.00 70.27           O
HETATM 5047  O   HOH B2709     113.500  96.938 118.712  1.00 63.41           O
HETATM 5048  O   HOH B2710     155.349 101.469 107.408  1.00 65.59           O
HETATM 5049  O   HOH B2711     164.454 105.852 107.106  1.00 59.07           O
HETATM 5050  O   HOH B2712      93.917  68.400 146.608  1.00 83.00           O
HETATM 5051  O   HOH B2713     154.870 112.063 118.350  1.00 70.51           O
HETATM 5052  O   HOH B2714     157.759  68.295 120.413  1.00 76.09           O
HETATM 5053  O   HOH B2715     105.316  64.094 143.695  1.00 80.16           O
HETATM 5054  O   HOH B2716     137.204 101.500 145.383  1.00 77.99           O
HETATM 5055  O   HOH B2717     184.924  79.462 120.558  1.00 77.80           O
HETATM 5056  O   HOH B2718     103.907  62.129 139.355  1.00 76.48           O
HETATM 5057  O   HOH B2719     183.175  89.389  96.038  1.00 82.12           O
HETATM 5058  O   HOH B2720     157.179  76.264 103.104  1.00 70.52           O
HETATM 5059  O   HOH B2721     161.117  67.349 112.907  1.00 68.95           O
HETATM 5060  O   HOH B2722     103.393  68.165 147.047  1.00 81.20           O
HETATM 5061  O   HOH B2723     135.557  64.680 103.100  1.00 77.06           O
HETATM 5062  O   HOH B2724     165.318  84.562 102.616  1.00 66.52           O
HETATM 5063  O   HOH B2725     159.172 101.473 135.547  1.00 69.86           O
HETATM 5064  O   HOH B2726     164.563  71.330 120.858  1.00 69.30           O
HETATM 5065  O   HOH B2727     186.135  85.511 107.080  1.00 73.19           O
HETATM 5066  O   HOH B2728     104.453  84.672 122.165  1.00 66.65           O
HETATM 5067  O   HOH B2729     125.477  64.125 135.228  1.00 78.26           O
HETATM 5068  O   HOH B2730     132.398  82.383 100.293  1.00 73.50           O
HETATM 5069  O   HOH B2731     145.118 101.030 103.507  1.00 71.48           O
HETATM 5070  O   HOH B2732     149.821 107.808 123.977  1.00 71.54           O
HETATM 5071  O   HOH B2733     137.527  62.948 104.383  1.00 78.41           O
HETATM 5072  O   HOH B2734     134.309 112.733 139.244  1.00 74.43           O
HETATM 5073  O   HOH B2735     117.492 100.775 107.091  1.00 65.09           O
HETATM 5074  O   HOH B2736     133.058  73.894 117.026  1.00 63.83           O
HETATM 5075  O   HOH B2737     160.398 101.656 112.340  1.00 61.98           O
HETATM 5076  O   HOH B2738     108.319  68.640 111.322  1.00 69.49           O
HETATM 5077  O   HOH B2739     108.220  47.302 126.450  1.00 72.58           O
HETATM 5078  O   HOH B2740     112.532  87.395 128.107  1.00 64.98           O
HETATM 5079  O   HOH B2741     131.120 110.324 127.891  1.00 74.03           O
HETATM 5080  O   HOH B2742     170.174  89.566 129.677  1.00 66.33           O
HETATM 5081  O   HOH B2743     147.949  78.886 117.259  1.00 63.95           O
HETATM 5082  O   HOH B2744     120.912  91.179 142.538  1.00 65.72           O
HETATM 5083  O   HOH B2745      95.200  85.395 131.278  1.00 77.17           O
HETATM 5084  O   HOH B2746     175.900  78.566 125.032  1.00 75.61           O
HETATM 5085  O   HOH B2747     120.229  47.786 135.084  1.00 76.77           O
HETATM 5086  O   HOH B2748     163.251  80.163 121.495  1.00 65.43           O
HETATM 5087  O   HOH B2749     135.268  48.330 126.602  1.00 76.09           O
HETATM 5088  O   HOH B2750     129.374  96.261  94.377  1.00 77.54           O
HETATM 5089  O   HOH B2751     140.597  92.773 148.613  1.00 71.34           O
HETATM 5090  O   HOH B2752     103.030  91.243 144.351  1.00 77.31           O
HETATM 5091  O   HOH B2753     167.617 103.892 113.744  1.00 62.17           O
HETATM 5092  O   HOH B2754      97.652  89.089 137.127  1.00 79.41           O
HETATM 5093  O   HOH B2755     150.439  60.736 114.903  1.00 81.26           O
HETATM 5094  O   HOH B2756      96.899  67.853 126.867  1.00 80.90           O
HETATM 5095  O   HOH B2757     142.865  69.413 100.842  1.00 78.78           O
HETATM 5096  O   HOH B2758     161.516  83.643  96.417  1.00 69.45           O
HETATM 5097  O   HOH B2759     152.984 115.237 127.474  1.00 77.14           O
HETATM 5098  O   HOH B2760     116.374 106.603 112.654  1.00 68.07           O
HETATM 5099  O   HOH B2761     135.262  72.027 116.693  1.00 66.90           O
HETATM 5100  O   HOH B2762     162.008  82.342 105.622  1.00 66.24           O
HETATM 5101  O   HOH B2763     149.520  74.008 105.976  1.00 73.27           O
HETATM 5102  O   HOH B2764     116.746  99.482 142.188  1.00 75.62           O
HETATM 5103  O   HOH B2765     142.756  59.342 111.993  1.00 72.86           O
HETATM 5104  O   HOH B2766     174.735 105.614 101.737  1.00 64.19           O
HETATM 5105  O   HOH B2767     150.026 107.080 146.851  1.00 78.20           O
HETATM 5106  O   HOH B2768     104.591  93.088 144.724  1.00 80.25           O
HETATM 5107  O   HOH B2769     145.497  89.932 139.992  1.00 68.70           O
HETATM 5108  O   HOH B2770     130.511  72.161  98.603  1.00 70.26           O
HETATM 5109  O   HOH B2771     143.999  98.311 108.951  1.00 65.06           O
HETATM 5110  O   HOH B2772     140.782 109.123 124.961  1.00 65.79           O
HETATM 5111  O   HOH B2773     105.588  99.491 133.961  1.00 76.19           O
HETATM 5112  O   HOH B2774     116.786  71.565 133.949  1.00 74.27           O
HETATM 5113  O   HOH B2775     134.319  95.998 136.785  1.00 68.92           O
HETATM 5114  O   HOH B2776     108.781  66.174 110.400  1.00 63.05           O
HETATM 5115  O   HOH B2777     116.448  69.592  97.332  1.00 71.03           O
HETATM 5116  O   HOH B2778     112.269  43.903 115.922  1.00 79.99           O
HETATM 5117  O   HOH B2779     114.572  87.225 131.958  1.00 62.41           O
HETATM 5118  O   HOH B2780     177.303  95.503 128.227  1.00 67.11           O
HETATM 5119  O   HOH B2781     105.214  73.033 124.949  1.00 73.73           O
HETATM 5120  O   HOH B2782     147.714  98.105  99.533  1.00 68.76           O
HETATM 5121  O   HOH B2783     165.208  81.957 133.832  1.00 76.77           O
HETATM 5122  O   HOH B2784     155.668  80.435 115.559  1.00 59.90           O
HETATM 5123  O   HOH B2785     140.922  94.079  99.752  1.00 71.21           O
HETATM 5124  O   HOH B2786     159.889  88.733  89.118  1.00 73.93           O
HETATM 5125  O   HOH B2787     113.209  66.058  98.522  1.00 71.09           O
HETATM 5126  O   HOH B2788     183.170 111.083 115.171  1.00 75.45           O
HETATM 5127  O   HOH B2789     114.387  72.802 121.809  1.00 66.02           O
HETATM 5128  O   HOH B2790     102.412  92.185 142.259  1.00 76.93           O
HETATM 5129  O   HOH B2791     136.198 116.021 137.505  1.00 78.35           O
HETATM 5130  O   HOH B2792     160.088 100.523  97.049  1.00 66.45           O
HETATM 5131  O   HOH B2793     151.642  57.144 121.529  1.00 92.22           O
HETATM 5132  O   HOH B2794     124.294  55.879 132.913  1.00 70.45           O
HETATM 5133  O   HOH B2795     111.353  95.989 114.225  1.00 61.22           O
HETATM 5134  O   HOH B2796     124.765  89.071 140.880  1.00 64.54           O
HETATM 5135  O   HOH B2797      90.445  75.601 134.534  1.00 80.01           O
HETATM 5136  O   HOH B2798     120.082  65.415 136.678  1.00 79.24           O
HETATM 5137  O   HOH B2799     111.429  90.373 106.244  1.00 60.04           O
HETATM 5138  O   HOH B2800     145.668  91.617 135.733  1.00 61.61           O
HETATM 5139  O   HOH B2801      88.241  78.618 139.317  1.00 83.10           O
HETATM 5140  O   HOH B2802     135.372  56.471 126.994  1.00 69.64           O
HETATM 5141  O   HOH B2803     153.451  84.254 123.718  1.00 65.55           O
HETATM 5142  O   HOH B2804     156.942  63.610 116.306  1.00 84.58           O
HETATM 5143  O   HOH B2805     164.975  99.800 135.194  1.00 70.92           O
HETATM 5144  O   HOH B2806     168.904 105.852 103.195  1.00 61.07           O
HETATM 5145  O   HOH B2807     146.631  60.083 118.195  1.00 76.80           O
HETATM 5146  O   HOH B2808     125.643  84.897 102.340  1.00 66.43           O
HETATM 5147  O   HOH B2809     146.387  60.382 110.372  1.00 76.71           O
HETATM 5148  O   HOH B2810      86.255  70.347 136.891  1.00 86.71           O
HETATM 5149  O   HOH B2811     115.341  73.894 135.252  1.00 73.17           O
HETATM 5150  O   HOH B2812     150.935  96.737  97.996  1.00 69.11           O
HETATM 5151  O   HOH B2813     131.851  61.587 101.661  1.00 76.25           O
HETATM 5152  O   HOH B2814     155.694  86.856 126.559  1.00 64.26           O
HETATM 5153  O   HOH B2815     103.070  80.205 122.625  1.00 73.41           O
HETATM 5154  O   HOH B2816     179.488  88.291  96.833  1.00 75.73           O
HETATM 5155  O   HOH B2817     125.648 103.154 139.790  1.00 71.68           O
HETATM 5156  O   HOH B2818     133.758  96.037 145.692  1.00 71.90           O
HETATM 5157  O   HOH B2819     168.992 104.643 101.156  1.00 63.02           O
HETATM 5158  O   HOH B2820     161.301 105.248 122.776  1.00 69.00           O
HETATM 5159  O   HOH B2821     144.058  86.768 130.590  1.00 63.48           O
HETATM 5160  O   HOH B2822     172.225 105.320 124.028  1.00 72.38           O
HETATM 5161  O   HOH B2823     101.018  75.892 146.950  1.00 75.84           O
HETATM 5162  O   HOH B2824     113.321  89.986  99.601  1.00 63.46           O
HETATM 5163  O   HOH B2825     190.350  98.643 101.720  1.00 74.84           O
HETATM 5164  O   HOH B2826     111.208  64.913  95.119  1.00 66.04           O
HETATM 5165  O   HOH B2827     174.028 108.514 116.459  1.00 68.89           O
HETATM 5166  O   HOH B2828     146.497  67.830 103.954  1.00 75.22           O
HETATM 5167  O   HOH B2829     134.139  95.590 140.060  1.00 72.66           O
HETATM 5168  O   HOH B2830     140.953 117.615 140.090  1.00 82.24           O
HETATM 5169  O   HOH B2831     132.004  93.236 138.906  1.00 68.32           O
HETATM 5170  O   HOH B2832     143.816  74.276 101.430  1.00 79.04           O
HETATM 5171  O   HOH B2833     112.584  69.837 123.747  1.00 65.83           O
HETATM 5172  O   HOH B2834     130.499  84.496 103.112  1.00 72.15           O
HETATM 5173  O   HOH B2835     133.591  64.051  99.792  1.00 74.57           O
HETATM 5174  O   HOH B2836     154.910  75.329 106.167  1.00 70.72           O
HETATM 5175  O   HOH B2837     168.139 110.994 124.832  1.00 77.66           O
HETATM 5176  O   HOH B2838     171.084  85.677 131.297  1.00 72.23           O
HETATM 5177  O   HOH B2839     167.253  69.912 118.598  1.00 71.36           O
HETATM 5178  O   HOH B2840     105.529  70.374 148.525  1.00 76.49           O
HETATM 5179  O   HOH B2841     116.752  92.612 100.933  1.00 64.25           O
HETATM 5180  O   HOH B2842     109.112  91.861 126.873  1.00 70.44           O
HETATM 5181  O   HOH B2843     120.114  71.509 140.007  1.00 82.09           O
HETATM 5182  O   HOH B2844     103.914  59.942 113.978  1.00 70.79           O
HETATM 5183  O   HOH B2845     145.071 103.245 120.612  1.00 61.56           O
HETATM 5184  O   HOH B2846     138.073  71.699 100.100  1.00 78.04           O
HETATM 5185  O   HOH B2847     114.530  87.649 129.352  1.00 63.91           O
HETATM 5186  O   HOH B2848      89.628  81.122 128.187  1.00 76.37           O
HETATM 5187  O   HOH B2849     129.927  91.082 137.709  1.00 65.13           O
HETATM 5188  O   HOH B2850     104.669  98.421 137.927  1.00 74.97           O
HETATM 5189  O   HOH B2851     152.327 116.747 129.329  1.00 79.90           O
HETATM 5190  O   HOH B2852     181.383  79.221 114.234  1.00 73.97           O
HETATM 5191  O   HOH B2853     104.585  67.293 114.587  1.00 70.75           O
HETATM 5192  O   HOH B2854     121.598  74.994 133.323  1.00 70.38           O
HETATM 5193  O   HOH B2855     148.262 110.701 143.885  1.00 77.92           O
HETATM 5194  O   HOH B2856     117.269  68.136 130.934  1.00 72.82           O
HETATM 5195  O   HOH B2857     162.154 106.533 124.489  1.00 67.06           O
HETATM 5196  O   HOH B2858     169.828 103.579 124.514  1.00 70.00           O
HETATM 5197  O   HOH B2859     177.522  85.128 104.020  1.00 72.83           O
HETATM 5198  O   HOH B2860     148.545  79.006 114.354  1.00 65.86           O
HETATM 5199  O   HOH B2861     121.871 102.947  98.841  1.00 62.36           O
HETATM 5200  O   HOH B2862     104.498  41.997 114.676  1.00 81.52           O
HETATM 5201  O   HOH B2863     111.562  95.971 123.562  1.00 66.69           O
HETATM 5202  O   HOH B2864     181.089  94.932  91.748  1.00 79.24           O
HETATM 5203  O   HOH B2865      99.709  82.155 146.277  1.00 80.84           O
HETATM 5204  O   HOH B2866     142.051  80.344 132.698  1.00 66.55           O
HETATM 5205  O   HOH B2867     137.194  84.246 140.066  1.00 68.72           O
HETATM 5206  O   HOH B2868     146.887  91.482 129.464  1.00 55.39           O
HETATM 5207  O   HOH B2869     172.991  79.197 108.825  1.00 68.63           O
HETATM 5208  O   HOH B2870     123.784 107.754 126.452  1.00 66.22           O
HETATM 5209  O   HOH B2871     157.866 103.981 142.254  1.00 71.12           O
HETATM 5210  O   HOH B2872     110.025  94.744 117.687  1.00 71.31           O
HETATM 5211  O   HOH B2873      92.752  72.743 125.975  1.00 78.00           O
HETATM 5212  O   HOH B2874     104.618  56.285 114.720  1.00 71.44           O
HETATM 5213  O   HOH B2875     134.265 104.952 144.742  1.00 74.29           O
HETATM 5214  O   HOH B2876     114.319  87.082  99.384  1.00 63.67           O
HETATM 5215  O   HOH B2877     136.838  93.875  95.990  1.00 75.69           O
HETATM 5216  O   HOH B2878     108.311  85.228 151.979  1.00 76.69           O
HETATM 5217  O   HOH B2879     124.911  91.386 140.454  1.00 63.50           O
HETATM 5218  O   HOH B2880     115.949  45.112 129.024  1.00 76.69           O
HETATM 5219  O   HOH B2881     146.627  99.761 114.632  1.00 61.52           O
HETATM 5220  O   HOH B2882     150.241  77.072 104.648  1.00 70.62           O
HETATM 5221  O   HOH B2883     116.960  68.894 106.849  1.00 64.94           O
HETATM 5222  O   HOH B2884     114.887  70.126 113.546  1.00 66.09           O
HETATM 5223  O   HOH B2885     155.646 116.739 127.633  1.00 76.07           O
HETATM 5224  O   HOH B2886     172.387 103.718 117.769  1.00 67.60           O
HETATM 5225  O   HOH B2887      87.112  67.941 140.220  1.00 88.51           O
HETATM 5226  O   HOH B2888     102.454  85.647 118.362  1.00 65.25           O
HETATM 5227  O   HOH B2889     146.801  87.738 128.093  1.00 59.18           O
HETATM 5228  O   HOH B2890     153.741 113.195 123.700  1.00 73.77           O
HETATM 5229  O   HOH B2891     121.520  43.579 126.689  1.00 76.05           O
HETATM 5230  O   HOH B2892     105.498  58.252 113.327  1.00 71.93           O
HETATM 5231  O   HOH B2893     117.914  70.122 138.607  1.00 81.92           O
HETATM 5232  O   HOH B2894     130.097 105.616 126.795  1.00 69.04           O
HETATM 5233  O   HOH B2895     113.496  79.056 131.659  1.00 71.10           O
HETATM 5234  O   HOH B2896     166.941 104.996 125.907  1.00 68.39           O
HETATM 5235  O   HOH B2897     170.595 104.902 116.678  1.00 68.46           O
HETATM 5236  O   HOH B2898      82.954  76.276 121.250  1.00 75.71           O
HETATM 5237  O   HOH B2899     119.422  80.108 140.998  1.00 73.78           O
HETATM 5238  O   HOH B2900     136.770 114.853 139.418  1.00 76.88           O
HETATM 5239  O   HOH B2901     144.411 105.681 123.315  1.00 66.00           O
HETATM 5240  O   HOH B2902     141.271  96.395 149.298  1.00 74.97           O
HETATM 5241  O   HOH B2903     132.342  56.386 120.958  1.00 70.25           O
HETATM 5242  O   HOH B2904     105.871  80.038 120.202  1.00 65.93           O
HETATM 5243  O   HOH B2905     117.857  61.698 140.355  1.00 77.03           O
HETATM 5244  O   HOH B2906     174.671 104.550 115.521  1.00 65.01           O
HETATM 5245  O   HOH B2907     142.456 105.346 113.903  1.00 63.66           O
HETATM 5246  O   HOH B2908     155.047  74.269 121.748  1.00 69.07           O
HETATM 5247  O   HOH B2909     192.833 105.808 105.497  1.00 79.38           O
HETATM 5248  O   HOH B2910     115.355  96.690 106.025  1.00 62.65           O
HETATM 5249  O   HOH B2911     145.884 100.080 101.483  1.00 70.66           O
HETATM 5250  O   HOH B2912     114.071  68.224  98.169  1.00 70.88           O
HETATM 5251  O   HOH B2913     145.541  71.860  99.225  1.00 86.55           O
HETATM 5252  O   HOH B2914     129.008  49.190 130.176  1.00 75.79           O
HETATM 5253  O   HOH B2915     128.527  63.843 132.426  1.00 70.57           O
HETATM 5254  O   HOH B2916     146.010  86.832 101.427  1.00 70.02           O
HETATM 5255  O   HOH B2917     155.330 115.736 125.498  1.00 73.48           O
HETATM 5256  O   HOH B2918     196.696 101.037 115.688  1.00 84.36           O
HETATM 5257  O   HOH B2919     136.380 109.445 126.062  1.00 72.15           O
HETATM 5258  O   HOH B2920     152.008 103.821 144.674  1.00 73.36           O
HETATM 5259  O   HOH B2921     115.526  80.076 131.099  1.00 67.27           O
HETATM 5260  O   HOH B2922     124.079  66.049 133.918  1.00 74.45           O
HETATM 5261  O   HOH B2923     112.750  76.927  94.463  1.00 68.75           O
HETATM 5262  O   HOH B2924     128.551  91.742 102.668  1.00 69.01           O
HETATM 5263  O   HOH B2925     119.453  75.355 132.312  1.00 71.79           O
HETATM 5264  O   HOH B2926     151.381  69.265 106.778  1.00 72.61           O
HETATM 5265  O   HOH B2927     114.840  97.309 110.942  1.00 61.01           O
HETATM 5266  O   HOH B2928     104.893  88.928 147.357  1.00 73.98           O
HETATM 5267  O   HOH B2929     154.922 100.235 132.481  1.00 64.38           O
HETATM 5268  O   HOH B2930     137.607  78.645 135.896  1.00 68.85           O
HETATM 5269  O   HOH B2931     157.254 106.485 121.184  1.00 68.99           O
HETATM 5270  O   HOH B2932     154.012  66.817 109.130  1.00 73.27           O
HETATM 5271  O   HOH B2933     153.621  70.810 120.872  1.00 70.93           O
HETATM 5272  O   HOH B2934     179.509  81.608 122.929  1.00 72.80           O
HETATM 5273  O   HOH B2935     135.992 109.139 120.115  1.00 65.17           O
HETATM 5274  O   HOH B2936     184.725  94.454  96.752  1.00 73.07           O
HETATM 5275  O   HOH B2937     157.229  81.939  92.308  1.00 71.98           O
HETATM 5276  O   HOH B2938     127.189 106.674 123.974  1.00 68.53           O
HETATM 5277  O   HOH B2939     137.548  70.999  97.567  1.00 76.42           O
HETATM 5278  O   HOH B2940     121.962  82.697 139.738  1.00 68.20           O
HETATM 5279  O   HOH B2941     147.779  95.057  99.711  1.00 72.09           O
HETATM 5280  O   HOH B2942     131.979  94.054 133.851  1.00 65.29           O
HETATM 5281  O   HOH B2943     108.495  93.567 123.719  1.00 65.45           O
HETATM 5282  O   HOH B2944     170.222 105.202 120.260  1.00 67.33           O
HETATM 5283  O   HOH B2945      99.135  65.303 138.818  1.00 77.59           O
HETATM 5284  O   HOH B2946     159.628 105.547 142.578  1.00 75.59           O
HETATM 5285  O   HOH B2947      93.165  82.328 142.317  1.00 77.25           O
HETATM 5286  O   HOH B2948     143.172 100.169 104.644  1.00 76.42           O
HETATM 5287  O   HOH B2949     181.053 109.681 113.928  1.00 72.71           O
HETATM 5288  O   HOH B2950     125.099  61.213  97.345  1.00 75.84           O
HETATM 5289  O   HOH B2951     115.443  45.051 125.872  1.00 71.29           O
HETATM 5290  O   HOH B2952     130.777  94.431 131.206  1.00 59.62           O
HETATM 5291  O   HOH B2953     166.098  82.453 105.982  1.00 70.16           O
HETATM 5292  O   HOH B2954     105.591  92.495 127.065  1.00 71.95           O
HETATM 5293  O   HOH B2955     136.782  54.431 109.338  1.00 70.31           O
HETATM 5294  O   HOH B2956     143.851 103.975 115.194  1.00 63.31           O
HETATM 5295  O   HOH B2957     168.551 105.729 117.398  1.00 68.60           O
HETATM 5296  O   HOH B2958     129.840 108.994 120.063  1.00 63.90           O
HETATM 5297  O   HOH B2959     102.406  82.339 123.658  1.00 78.15           O
HETATM 5298  O   HOH B2960     115.433  99.270 107.680  1.00 67.37           O
HETATM 5299  O   HOH B2961      79.729  76.913 116.449  1.00 73.28           O
HETATM 5300  O   HOH B2962     144.467 113.342 142.893  1.00 82.76           O
HETATM 5301  O   HOH B2963     132.917  56.686 105.661  1.00 74.08           O
HETATM 5302  O   HOH B2964      87.597  77.913 126.052  1.00 75.69           O
HETATM 5303  O   HOH B2965      91.393  70.694 145.262  1.00 83.77           O
HETATM 5304  O   HOH B2966     148.226 113.312 124.830  1.00 72.72           O
HETATM 5305  O   HOH B2967     128.539  40.308 124.683  1.00 82.59           O
HETATM 5306  O   HOH B2968     167.926  82.593 135.317  1.00 76.28           O
HETATM 5307  O   HOH B2969     139.577  98.490 148.820  1.00 80.11           O
HETATM 5308  O   HOH B2970     154.984  97.827 138.098  1.00 71.76           O
HETATM 5309  O   HOH B2971     153.912 100.550  94.787  1.00 72.70           O
HETATM 5310  O   HOH B2972     157.172 102.400 134.615  1.00 68.64           O
HETATM 5311  O   HOH B2973     157.290 100.541 115.418  1.00 65.15           O
HETATM 5312  O   HOH B2974     141.370  59.544 114.134  1.00 73.55           O
HETATM 5313  O   HOH B2975     128.467  97.593 140.785  1.00 71.38           O
HETATM 5314  O   HOH B2976     144.175  91.893  96.297  1.00 75.28           O
HETATM 5315  O   HOH B2977     159.463  80.431  94.416  1.00 68.77           O
HETATM 5316  O   HOH B2978     154.047  74.992 123.814  1.00 69.18           O
HETATM 5317  O   HOH B2979     134.798  56.490 107.735  1.00 73.89           O
HETATM 5318  O   HOH B2980     122.365  72.776 132.526  1.00 69.74           O
HETATM 5319  O   HOH B2981     126.631  48.167 104.497  1.00 72.43           O
HETATM 5320  O   HOH B2982     134.149 100.697  95.848  1.00 72.05           O
HETATM 5321  O   HOH B2983     117.570  48.199 105.814  1.00 75.55           O
HETATM 5322  O   HOH B2984     179.768 105.854 103.362  1.00 74.16           O
HETATM 5323  O   HOH B2985     155.265  88.271 128.384  1.00 60.42           O
HETATM 5324  O   HOH B2986     156.948 116.404 132.346  1.00 79.79           O
HETATM 5325  O   HOH B2987      99.777  95.134 135.321  1.00 79.84           O
HETATM 5326  O   HOH B2988     166.436 107.658 110.717  1.00 63.90           O
HETATM 5327  O   HOH B2989     134.418  85.491 101.945  1.00 76.82           O
HETATM 5328  O   HOH B2990     172.530 104.419 119.984  1.00 67.60           O
HETATM 5329  O   HOH B2991     122.055  98.389 137.688  1.00 63.44           O
HETATM 5330  O   HOH B2992     131.923  66.172  95.707  1.00 74.51           O
HETATM 5331  O   HOH B2993     128.728 110.048 126.833  1.00 79.09           O
HETATM 5332  O   HOH B2994     128.021  69.889 131.797  1.00 72.35           O
HETATM 5333  O   HOH B2995     176.633  86.445 100.476  1.00 72.13           O
HETATM 5334  O   HOH B2996     118.406  43.854 127.631  1.00 74.02           O
HETATM 5335  O   HOH B2997     179.739 106.333 116.037  1.00 72.41           O
HETATM 5336  O   HOH B2998     120.237  65.619 134.328  1.00 76.95           O
HETATM 5337  O   HOH B2999     135.608 108.434 122.324  1.00 65.68           O
HETATM 5338  O   HOH B3000     118.607  57.421 140.154  1.00 81.68           O
HETATM 5339  O   HOH B3001     123.684  38.499 121.174  1.00 77.54           O
HETATM 5340  O   HOH B3002     162.229  78.115 122.794  1.00 70.77           O
HETATM 5341  O   HOH B3003     140.559 108.365 110.968  1.00 68.98           O
HETATM 5342  O   HOH B3004     134.882  67.095  98.681  1.00 80.42           O
HETATM 5343  O   HOH B3005      95.438  79.741 145.771  1.00 72.99           O
HETATM 5344  O   HOH B3006     111.233  40.940 117.052  1.00 80.12           O
HETATM 5345  O   HOH B3007     131.322  91.610 141.827  1.00 70.95           O
HETATM 5346  O   HOH B3008     157.435 101.989 118.069  1.00 62.50           O
HETATM 5347  O   HOH B3009     160.354  76.823 123.452  1.00 67.94           O
HETATM 5348  O   HOH B3010     145.679  71.775 123.168  1.00 70.16           O
HETATM 5349  O   HOH B3011     152.479  83.841  91.831  1.00 79.74           O
HETATM 5350  O   HOH B3012     116.774 100.972 112.810  1.00 60.94           O
HETATM 5351  O   HOH B3013     114.849 104.684 112.914  1.00 69.97           O
HETATM 5352  O   HOH B3014     115.770  78.223 133.225  1.00 73.11           O
HETATM 5353  O   HOH B3015     137.579  75.906  99.664  1.00 79.09           O
HETATM 5354  O   HOH B3016     117.281 101.738 137.373  1.00 70.82           O
HETATM 5355  O   HOH B3017     105.506  86.457 126.520  1.00 73.95           O
HETATM 5356  O   HOH B3018     128.870  69.447 112.076  1.00 67.58           O
HETATM 5357  O   HOH B3019     149.239  74.010 101.952  1.00 82.41           O
HETATM 5358  O   HOH B3020     114.224  97.473 114.730  1.00 64.20           O
HETATM 5359  O   HOH B3021     142.482  88.468  97.377  1.00 79.79           O
HETATM 5360  O   HOH B3022     117.692  76.856 133.207  1.00 74.69           O
HETATM 5361  O   HOH B3023     142.872  70.890 127.944  1.00 76.97           O
HETATM 5362  O   HOH B3024     167.734  86.045 105.215  1.00 67.11           O
HETATM 5363  O   HOH B3025     133.400  86.256 104.278  1.00 73.49           O
HETATM 5364  O   HOH B3026      89.574  72.826 146.026  1.00 88.88           O
HETATM 5365  O   HOH B3027     152.769  65.745 111.877  1.00 68.33           O
HETATM 5366  O   HOH B3028     139.030 110.038 126.310  1.00 67.90           O
HETATM 5367  O   HOH B3029     121.241  75.344 136.202  1.00 75.90           O
HETATM 5368  O   HOH B3030     151.145 104.984 146.704  1.00 75.55           O
HETATM 5369  O   HOH B3031     153.937  96.612 134.247  1.00 70.47           O
HETATM 5370  O   HOH B3032     133.939  66.777 128.826  1.00 72.09           O
HETATM 5371  O   HOH B3033     135.251 116.388 134.907  1.00 74.44           O
HETATM 5372  O   HOH B3034     130.219 103.424 125.416  1.00 65.68           O
HETATM 5373  O   HOH B3035     131.524 104.995 122.796  1.00 62.71           O
HETATM 5374  O   HOH B3036     123.340  75.342 137.280  1.00 74.54           O
HETATM 5375  O   HOH B3037     164.273  78.551 124.387  1.00 68.94           O
HETATM 5376  O   HOH B3038     181.132  78.730 118.981  1.00 76.37           O
HETATM 5377  O   HOH B3039     125.407  51.791 133.662  1.00 74.19           O
HETATM 5378  O   HOH B3040     110.342  66.107 146.144  1.00 81.07           O
HETATM 5379  O   HOH B3041     155.398 117.294 130.716  1.00 80.19           O
HETATM 5380  O   HOH B3042     118.911  46.536 107.699  1.00 78.32           O
HETATM 5381  O   HOH B3043     104.417  65.954 145.339  1.00 78.58           O
HETATM 5382  O   HOH B3044     148.557 109.638 123.191  1.00 74.18           O
HETATM 5383  O   HOH B3045     143.456 104.681 118.321  1.00 63.54           O
HETATM 5384  O   HOH B3046     138.390  88.483  99.481  1.00 76.17           O
HETATM 5385  O   HOH B3047     128.041  59.434  97.614  1.00 74.02           O
HETATM 5386  O   HOH B3048     123.289  71.326  94.496  1.00 74.54           O
HETATM 5387  O   HOH B3049     140.338  78.224  99.777  1.00 79.92           O
HETATM 5388  O   HOH B3050     120.141  71.223  94.348  1.00 76.33           O
HETATM 5389  O   HOH B3051     136.214  84.235 100.135  1.00 77.69           O
HETATM 5390  O   HOH B3052     116.885  39.048 116.844  1.00 80.04           O
HETATM 5391  O   HOH B3053     104.494  61.384 121.811  1.00 68.55           O
HETATM 5392  O   HOH B3054     140.211  55.927 111.447  1.00 72.79           O
HETATM 5393  O   HOH B3055     177.039 104.616 102.770  1.00 71.77           O
HETATM 5394  O   HOH B3056     131.065  66.348 129.807  1.00 71.34           O
HETATM 5395  O   HOH B3057     136.931 108.043 124.214  1.00 68.56           O
HETATM 5396  O   HOH B3058      82.424  88.051 115.259  1.00 78.13           O
HETATM 5397  O   HOH B3059     155.202 112.199 143.471  1.00 77.36           O
HETATM 5398  O   HOH B3060     176.726 106.138  99.227  1.00 72.58           O
HETATM 5399  O   HOH B3061     126.098 106.517 121.173  1.00 67.09           O
HETATM 5400  O   HOH B3062     164.897 121.581 130.042  1.00 73.79           O
HETATM 5401  O   HOH B3063     156.184  67.119 107.861  1.00 73.86           O
HETATM 5402  O   HOH B3064     142.140 102.739 103.036  1.00 73.92           O
HETATM 5403  O   HOH B3065     107.712  90.928 124.997  1.00 72.49           O
HETATM 5404  O   HOH B3066     153.726 106.742 122.388  1.00 68.91           O
HETATM 5405  O   HOH B3067     127.391  92.203 140.352  1.00 67.98           O
HETATM 5406  O   HOH B3068     128.793  67.513 110.476  1.00 68.56           O
HETATM 5407  O   HOH B3069     107.038  63.731 145.354  1.00 83.04           O
HETATM 5408  O   HOH B3070     117.197  72.947 127.327  1.00 68.52           O
HETATM 5409  O   HOH B3071     150.214  61.587 112.583  1.00 80.05           O
HETATM 5410  O   HOH B3072     152.053  80.548 125.253  1.00 69.50           O
HETATM 5411  O   HOH B3073     119.055  68.688 132.387  1.00 74.74           O
HETATM 5412  O   HOH B3074     115.784  58.139 139.696  1.00 80.97           O
HETATM 5413  O   HOH B3075     157.393  91.006  91.023  1.00 69.94           O
HETATM 5414  O   HOH B3076     148.809  71.356 105.602  1.00 77.33           O
HETATM 5415  O   HOH B3077     124.124  64.768 137.420  1.00 79.37           O
HETATM 5416  O   HOH B3078     153.704  88.439  91.632  1.00 74.52           O
HETATM 5417  O   HOH B3079     149.997 102.305 117.038  1.00 64.27           O
HETATM 5418  O   HOH B3080     157.788 103.420 121.732  1.00 64.51           O
HETATM 5419  O   HOH B3081     153.844 102.989 121.055  1.00 67.70           O
HETATM 5420  O   HOH B3082     110.354  98.347 124.349  1.00 66.83           O
HETATM 5421  O   HOH B3083     142.833  81.009  95.486  1.00 89.78           O
HETATM 5422  O   HOH B3084     125.819  84.316 141.376  1.00 68.66           O
HETATM 5423  O   HOH B3085     137.679  61.182 106.574  1.00 78.89           O
HETATM 5424  O   HOH B3086     139.344 106.519 120.505  1.00 60.80           O
HETATM 5425  O   HOH B3087     151.233  99.172 131.712  1.00 56.01           O
HETATM 5426  O   HOH B3088     139.575  79.705 135.166  1.00 67.26           O
HETATM 5427  O   HOH B3089     139.673  90.225  97.712  1.00 79.40           O
HETATM 5428  O   HOH B3090     169.468 108.948 117.027  1.00 65.12           O
HETATM 5429  O   HOH B3091     136.512 108.295 145.970  1.00 78.22           O
HETATM 5430  O   HOH B3092     146.312 106.953 121.597  1.00 70.20           O
HETATM 5431  O   HOH B3093     160.387  76.776 102.366  1.00 72.91           O
HETATM 5432  O   HOH B3094     123.345  85.440 140.287  1.00 66.80           O
HETATM 5433  O   HOH B3095     128.528  84.605 140.541  1.00 68.70           O
HETATM 5434  O   HOH B3096     159.866 105.373 106.631  1.00 61.60           O
HETATM 5435  O   HOH B3097     149.196 111.895 123.196  1.00 78.39           O
HETATM 5436  O   HOH B3098     157.294  77.266 124.269  1.00 69.48           O
HETATM 5437  O   HOH B3099     132.923  52.688 104.391  1.00 78.35           O
HETATM 5438  O   HOH B3100     138.292  93.057  97.689  1.00 75.82           O
HETATM 5439  O   HOH B3101     121.448  69.509 139.244  1.00 80.03           O
HETATM 5440  O   HOH B3102     160.920  80.886  97.166  1.00 67.92           O
HETATM 5441  O   HOH B3103     126.895  75.393  89.817  1.00 77.85           O
HETATM 5442  O   HOH B3104      88.039  74.708 144.617  1.00 88.11           O
HETATM 5443  O   HOH B3105     157.031  75.332 122.721  1.00 69.88           O
HETATM 5444  O   HOH B3106     135.117  49.462 115.266  1.00 72.03           O
HETATM 5445  O   HOH B3107      84.859  76.962 124.566  1.00 74.23           O
HETATM 5446  O   HOH B3108     119.963 106.936 122.382  1.00 65.58           O
HETATM 5447  O   HOH B3109     140.723  82.340  96.022  1.00 84.80           O
HETATM 5448  O   HOH B3110     150.509 103.507 119.909  1.00 62.01           O
HETATM 5449  O   HOH B3111     162.538 106.279 109.691  1.00 65.07           O
HETATM 5450  O   HOH B3112     145.344  83.470 131.316  1.00 67.19           O
HETATM 5451  O   HOH B3113     161.925  79.593 100.501  1.00 74.97           O
HETATM 5452  O   HOH B3114     178.679 106.171 113.301  1.00 70.61           O
HETATM 5453  O   HOH B3115     155.497 101.737 111.612  1.00 65.73           O
HETATM 5454  O   HOH B3116     130.389  46.177 108.653  1.00 73.83           O
HETATM 5455  O   HOH B3117     144.818  70.254 126.244  1.00 74.54           O
HETATM 5456  O   HOH B3118     135.783  68.736  96.969  1.00 78.07           O
HETATM 5457  O   HOH B3119     144.322  98.550 147.252  1.00 77.00           O
HETATM 5458  O   HOH B3120     157.743 101.815 108.483  1.00 66.63           O
HETATM 5459  O   HOH B3121     121.822  71.582 146.918  1.00 77.55           O
HETATM 5460  O   HOH B3122     138.588  82.790  99.442  1.00 80.46           O
HETATM 5461  O   HOH B3123     156.834  90.654 132.660  1.00 69.06           O
HETATM 5462  O   HOH B3124     145.895 103.916 118.276  1.00 67.19           O
HETATM 5463  O   HOH B3125     100.257  64.527 140.700  1.00 75.03           O
HETATM 5464  O   HOH B3126     147.207  67.456 126.328  1.00 76.50           O
HETATM 5465  O   HOH B3127     129.819 107.894 123.777  1.00 67.30           O
HETATM 5466  O   HOH B3128     119.186  72.002 131.238  1.00 73.38           O
HETATM 5467  O   HOH B3129      87.700  71.118 144.464  1.00 85.42           O
HETATM 5468  O   HOH B3130     142.249 106.895 119.636  1.00 66.03           O
HETATM 5469  O   HOH B3131     125.369  97.544 142.247  1.00 66.30           O
HETATM 5470  O   HOH B3132     136.413  79.492 138.716  1.00 64.99           O
HETATM 5471  O   HOH B3133     149.179  92.385 133.896  1.00 70.00           O
HETATM 5472  O   HOH B3134     122.691 108.220 122.473  1.00 70.07           O
HETATM 5473  O   HOH B3135     147.054 102.768 116.434  1.00 67.73           O
HETATM 5474  O   HOH B3136     121.764  37.807 124.353  1.00 82.09           O
HETATM 5475  O   HOH B3137     155.463 103.937 122.428  1.00 68.06           O
HETATM 5476  O   HOH B3138     176.872 106.106 117.912  1.00 71.40           O
HETATM 5477  O   HOH B3139     124.063 106.140  95.771  1.00 69.50           O
HETATM 5478  O   HOH B3140     125.328 103.403  96.904  1.00 67.56           O
HETATM 5479  O   HOH B3141     139.046  80.286  98.837  1.00 81.90           O
HETATM 5480  O   HOH B3142     142.219  99.929 148.040  1.00 76.76           O
HETATM 5481  O   HOH B3143     120.153  70.699 135.947  1.00 81.46           O
HETATM 5482  O   HOH B3144     120.466  68.676 134.802  1.00 79.01           O
HETATM 5483  O   HOH B3145     158.519 103.648 109.732  1.00 70.70           O
HETATM 5484  O   HOH B3146     114.786  62.834  94.407  1.00 76.79           O
HETATM 5485  O   HOH B3147     138.712  91.347  94.850  1.00 82.73           O
HETATM 5486  O   HOH B3148     137.452  88.818  94.780  1.00 87.74           O
HETATM 5487  O   HOH C2101      78.363  97.630  81.491  1.00 61.29           O
HETATM 5488  O   HOH C2102      70.369  84.752 115.449  1.00 75.28           O
HETATM 5489  O   HOH C2103     113.467  74.377  89.534  1.00 72.38           O
HETATM 5490  O   HOH C2104      88.848  84.797 107.665  1.00 65.05           O
HETATM 5491  O   HOH C2105     100.003  71.955  99.677  1.00 63.28           O
HETATM 5492  O   HOH C2106      90.737  59.076  80.259  1.00 69.37           O
HETATM 5493  O   HOH C2107      85.101  50.161  82.403  1.00 80.16           O
HETATM 5494  O   HOH C2108      41.764  83.127  84.692  1.00 76.94           O
HETATM 5495  O   HOH C2109      57.790  80.581  87.347  1.00 69.05           O
HETATM 5496  O   HOH C2110      69.220  80.263 124.373  1.00 85.50           O
HETATM 5497  O   HOH C2111      71.791 103.932  88.669  1.00 59.38           O
HETATM 5498  O   HOH C2112      92.493  68.742  83.978  1.00 71.12           O
HETATM 5499  O   HOH C2113      75.980  59.098 100.124  1.00 73.14           O
HETATM 5500  O   HOH C2114      88.131  85.348 111.223  1.00 67.28           O
HETATM 5501  O   HOH C2115      74.919 104.956 105.265  1.00 68.56           O
HETATM 5502  O   HOH C2116     102.844  74.709  79.748  1.00 73.73           O
HETATM 5503  O   HOH C2117      46.750 107.976  84.333  1.00 80.05           O
HETATM 5504  O   HOH C2118     103.494  80.939 118.596  1.00 67.81           O
HETATM 5505  O   HOH C2119      85.731  99.215  86.124  1.00 63.27           O
HETATM 5506  O   HOH C2120      93.066  93.114 114.250  1.00 65.13           O
HETATM 5507  O   HOH C2121      79.222  52.188 102.081  1.00 70.82           O
HETATM 5508  O   HOH C2122     107.196 103.160  73.331  1.00 77.56           O
HETATM 5509  O   HOH C2123      76.553  51.939  98.652  1.00 74.85           O
HETATM 5510  O   HOH C2124      35.690 104.025  95.602  1.00 75.75           O
HETATM 5511  O   HOH C2125     101.612  55.898  77.272  1.00 80.83           O
HETATM 5512  O   HOH C2126     104.324  95.972  70.947  1.00 77.79           O
HETATM 5513  O   HOH C2127     121.378  67.443  78.364  1.00 84.77           O
HETATM 5514  O   HOH C2128      68.920  64.366  88.757  1.00 79.25           O
HETATM 5515  O   HOH C2129      79.854 109.750 104.757  1.00 63.82           O
HETATM 5516  O   HOH C2130      71.940  89.370  78.733  1.00 64.85           O
HETATM 5517  O   HOH C2131      63.620  86.232  90.032  1.00 61.34           O
HETATM 5518  O   HOH C2132      68.344 102.737  91.621  1.00 51.88           O
HETATM 5519  O   HOH C2133      33.043  95.941  92.934  1.00 77.66           O
HETATM 5520  O   HOH C2134      51.676 106.255  89.036  1.00 70.34           O
HETATM 5521  O   HOH C2135     100.526  43.189 100.765  1.00 75.98           O
HETATM 5522  O   HOH C2136      98.148  82.808 120.902  1.00 75.52           O
HETATM 5523  O   HOH C2137      99.245  83.130  69.884  1.00 77.24           O
HETATM 5524  O   HOH C2138      67.151  76.671 124.313  1.00 91.37           O
HETATM 5525  O   HOH C2139      82.142  79.700 108.680  1.00 66.03           O
HETATM 5526  O   HOH C2140      94.408  71.066  91.543  1.00 64.67           O
HETATM 5527  O   HOH C2141      85.919  67.361  97.622  1.00 63.12           O
HETATM 5528  O   HOH C2142      72.169  96.846 109.306  1.00 69.23           O
HETATM 5529  O   HOH C2143      88.804 108.060 113.726  1.00 60.67           O
HETATM 5530  O   HOH C2144      84.592  58.382  94.039  1.00 67.30           O
HETATM 5531  O   HOH C2145     122.507  83.152  80.417  1.00 76.59           O
HETATM 5532  O   HOH C2146      91.113  59.130 117.251  1.00 75.20           O
HETATM 5533  O   HOH C2147     101.838 100.508  99.597  1.00 66.49           O
HETATM 5534  O   HOH C2148      95.513  76.686  84.947  1.00 67.71           O
HETATM 5535  O   HOH C2149     126.007  80.993  80.444  1.00 76.92           O
HETATM 5536  O   HOH C2150     109.115  47.633  96.215  1.00 73.64           O
HETATM 5537  O   HOH C2151      47.810  84.577 122.763  1.00 73.89           O
HETATM 5538  O   HOH C2152     110.803  84.543  89.784  1.00 67.27           O
HETATM 5539  O   HOH C2153      98.612  46.356  91.989  1.00 73.19           O
HETATM 5540  O   HOH C2154      36.892 101.593 113.416  1.00 70.16           O
HETATM 5541  O   HOH C2155      37.190  76.839  95.760  1.00 71.84           O
HETATM 5542  O   HOH C2156      97.260  44.166 106.694  1.00 80.59           O
HETATM 5543  O   HOH C2157     100.266  97.456  71.137  1.00 76.67           O
HETATM 5544  O   HOH C2158      83.669  68.171 116.415  1.00 72.66           O
HETATM 5545  O   HOH C2159      85.205  76.835  77.195  1.00 69.20           O
HETATM 5546  O   HOH C2160      49.277  90.898 104.702  1.00 59.46           O
HETATM 5547  O   HOH C2161      33.192 108.083 104.247  1.00 72.84           O
HETATM 5548  O   HOH C2162      84.168  72.743  96.723  1.00 66.35           O
HETATM 5549  O   HOH C2163     104.763  95.090  87.526  1.00 71.14           O
HETATM 5550  O   HOH C2164      37.550  92.265 106.862  1.00 66.40           O
HETATM 5551  O   HOH C2165     102.346  94.066 107.741  1.00 64.15           O
HETATM 5552  O   HOH C2166     106.909  52.019 112.483  1.00 74.21           O
HETATM 5553  O   HOH C2167     115.155  95.089  82.309  1.00 79.13           O
HETATM 5554  O   HOH C2168      70.138  89.091 110.075  1.00 72.38           O
HETATM 5555  O   HOH C2169      69.856 103.406  67.721  1.00 73.22           O
HETATM 5556  O   HOH C2170      62.634 100.623 117.593  1.00 66.14           O
HETATM 5557  O   HOH C2171      46.008  95.741 109.019  1.00 61.09           O
HETATM 5558  O   HOH C2172      70.875  80.940  84.628  1.00 64.07           O
HETATM 5559  O   HOH C2173      81.682  80.931  98.343  1.00 59.37           O
HETATM 5560  O   HOH C2174     100.556  70.200  88.069  1.00 69.43           O
HETATM 5561  O   HOH C2175      65.666  77.205 113.433  1.00 79.04           O
HETATM 5562  O   HOH C2176      45.063  94.357 127.461  1.00 75.03           O
HETATM 5563  O   HOH C2177      54.032  84.178 124.766  1.00 73.49           O
HETATM 5564  O   HOH C2178      47.115 106.133  95.663  1.00 66.79           O
HETATM 5565  O   HOH C2179      63.189 102.134 113.675  1.00 66.12           O
HETATM 5566  O   HOH C2180      71.445  79.084 118.433  1.00 86.99           O
HETATM 5567  O   HOH C2181      67.645  94.421  74.836  1.00 71.28           O
HETATM 5568  O   HOH C2182      43.822  97.884  84.602  1.00 64.09           O
HETATM 5569  O   HOH C2183      62.421 116.708  83.688  1.00 80.85           O
HETATM 5570  O   HOH C2184      64.235  91.514  86.426  1.00 59.57           O
HETATM 5571  O   HOH C2185      72.471  92.772 115.138  1.00 70.18           O
HETATM 5572  O   HOH C2186      87.815  56.505 116.652  1.00 72.45           O
HETATM 5573  O   HOH C2187      85.314  79.510  76.905  1.00 68.40           O
HETATM 5574  O   HOH C2188      54.872  86.657  81.155  1.00 68.42           O
HETATM 5575  O   HOH C2189     117.027  76.391  90.052  1.00 74.33           O
HETATM 5576  O   HOH C2190     104.886  63.791  70.544  1.00 82.54           O
HETATM 5577  O   HOH C2191      88.441  50.780  85.464  1.00 75.66           O
HETATM 5578  O   HOH C2192     108.062  60.953  93.341  1.00 64.00           O
HETATM 5579  O   HOH C2193      52.509  82.708  93.122  1.00 66.22           O
HETATM 5580  O   HOH C2194     107.583  80.416  92.710  1.00 65.18           O
HETATM 5581  O   HOH C2195      84.186  47.332 100.386  1.00 72.04           O
HETATM 5582  O   HOH C2196      76.419  92.190  74.426  1.00 68.62           O
HETATM 5583  O   HOH C2197      92.779  99.704 111.931  1.00 66.18           O
HETATM 5584  O   HOH C2198      41.108 106.970 109.125  1.00 61.12           O
HETATM 5585  O   HOH C2199     100.163  68.918  83.648  1.00 72.94           O
HETATM 5586  O   HOH C2200     108.362  58.423  92.883  1.00 66.59           O
HETATM 5587  O   HOH C2201      86.151  90.670 110.179  1.00 64.58           O
HETATM 5588  O   HOH C2202      77.803  97.934  78.823  1.00 64.53           O
HETATM 5589  O   HOH C2203      62.933 101.264  92.808  1.00 57.58           O
HETATM 5590  O   HOH C2204      51.933 102.945 120.298  1.00 71.90           O
HETATM 5591  O   HOH C2205      71.862  77.039 114.571  1.00 83.40           O
HETATM 5592  O   HOH C2206      75.168  70.518  85.289  1.00 72.23           O
HETATM 5593  O   HOH C2207      46.678  89.834  82.916  1.00 66.54           O
HETATM 5594  O   HOH C2208      90.923  85.801 104.840  1.00 62.15           O
HETATM 5595  O   HOH C2209      80.039  92.964  95.046  1.00 47.66           O
HETATM 5596  O   HOH C2210      85.813  71.908 104.942  1.00 66.28           O
HETATM 5597  O   HOH C2211      96.622  89.457 116.197  1.00 62.18           O
HETATM 5598  O   HOH C2212      75.653 104.436 102.511  1.00 59.81           O
HETATM 5599  O   HOH C2213     110.132  51.322  84.810  1.00 72.91           O
HETATM 5600  O   HOH C2214      87.456  70.967  79.807  1.00 72.67           O
HETATM 5601  O   HOH C2215      44.201  87.422  86.119  1.00 69.99           O
HETATM 5602  O   HOH C2216      53.710  87.409  94.832  1.00 57.33           O
HETATM 5603  O   HOH C2217      69.943  71.297  94.734  1.00 66.43           O
HETATM 5604  O   HOH C2218      96.262 108.983  96.481  1.00 70.12           O
HETATM 5605  O   HOH C2219      73.894  87.407  70.504  1.00 71.91           O
HETATM 5606  O   HOH C2220     108.290  64.259 103.016  1.00 64.50           O
HETATM 5607  O   HOH C2221      85.068  88.320 120.833  1.00 79.86           O
HETATM 5608  O   HOH C2222      59.166 104.675  82.111  1.00 60.33           O
HETATM 5609  O   HOH C2223     108.154  50.778  97.314  1.00 69.63           O
HETATM 5610  O   HOH C2224      58.717  85.845  92.998  1.00 59.49           O
HETATM 5611  O   HOH C2225      83.927  77.142 108.844  1.00 64.41           O
HETATM 5612  O   HOH C2226      70.835  87.204 117.534  1.00 78.71           O
HETATM 5613  O   HOH C2227     100.588 102.372  74.921  1.00 78.32           O
HETATM 5614  O   HOH C2228     104.391 102.133  86.444  1.00 77.98           O
HETATM 5615  O   HOH C2229      89.248  73.089  78.129  1.00 71.12           O
HETATM 5616  O   HOH C2230      39.580  77.533  94.241  1.00 71.71           O
HETATM 5617  O   HOH C2231      72.154  87.057  82.387  1.00 63.67           O
HETATM 5618  O   HOH C2232     112.301  62.072  90.134  1.00 71.96           O
HETATM 5619  O   HOH C2233      94.547  69.967  85.367  1.00 71.60           O
HETATM 5620  O   HOH C2234      34.697  83.078 104.612  1.00 69.99           O
HETATM 5621  O   HOH C2235     101.512  66.703  71.148  1.00 79.37           O
HETATM 5622  O   HOH C2236      89.039  91.374 100.509  1.00 54.42           O
HETATM 5623  O   HOH C2237      65.179  89.908 109.007  1.00 66.64           O
HETATM 5624  O   HOH C2238      78.229  69.023  84.472  1.00 70.06           O
HETATM 5625  O   HOH C2239      49.499 104.428 103.724  1.00 60.55           O
HETATM 5626  O   HOH C2240     100.228 100.243  76.810  1.00 71.76           O
HETATM 5627  O   HOH C2241      61.861 101.479 100.420  1.00 63.70           O
HETATM 5628  O   HOH C2242     105.671  91.891 107.939  1.00 58.96           O
HETATM 5629  O   HOH C2243      97.944  91.898  78.275  1.00 59.97           O
HETATM 5630  O   HOH C2244     107.078  74.372  65.434  1.00 78.70           O
HETATM 5631  O   HOH C2245      63.896 100.691 115.400  1.00 68.23           O
HETATM 5632  O   HOH C2246      90.980  87.428  76.514  1.00 60.63           O
HETATM 5633  O   HOH C2247      34.870  85.844 109.962  1.00 77.71           O
HETATM 5634  O   HOH C2248      70.073  89.620  86.535  1.00 57.61           O
HETATM 5635  O   HOH C2249      68.093  69.511 108.421  1.00 75.63           O
HETATM 5636  O   HOH C2250      73.589  58.970 106.880  1.00 74.40           O
HETATM 5637  O   HOH C2251      60.941  82.899 121.581  1.00 72.82           O
HETATM 5638  O   HOH C2252     123.367  76.522  78.374  1.00 80.48           O
HETATM 5639  O   HOH C2253      61.548  95.955 118.278  1.00 67.15           O
HETATM 5640  O   HOH C2254      59.687  80.542 107.151  1.00 63.45           O
HETATM 5641  O   HOH C2255      94.450  47.464 105.977  1.00 73.71           O
HETATM 5642  O   HOH C2256      87.132  70.985  91.779  1.00 65.48           O
HETATM 5643  O   HOH C2257      76.188 110.845  86.492  1.00 66.88           O
HETATM 5644  O   HOH C2258      59.762  77.976  98.898  1.00 59.59           O
HETATM 5645  O   HOH C2259      84.099  58.813 111.353  1.00 72.63           O
HETATM 5646  O   HOH C2260      55.383 100.272 115.444  1.00 62.24           O
HETATM 5647  O   HOH C2261      67.388  88.066  89.681  1.00 55.50           O
HETATM 5648  O   HOH C2262      58.471  65.530  96.389  1.00 81.34           O
HETATM 5649  O   HOH C2263      65.482  91.797 116.768  1.00 66.69           O
HETATM 5650  O   HOH C2264      77.034  92.156 110.131  1.00 65.74           O
HETATM 5651  O   HOH C2265     104.862  69.831  96.268  1.00 65.83           O
HETATM 5652  O   HOH C2266      56.683 103.167  83.908  1.00 62.37           O
HETATM 5653  O   HOH C2267      82.838  78.453 103.172  1.00 67.51           O
HETATM 5654  O   HOH C2268      54.030 109.448  92.323  1.00 71.48           O
HETATM 5655  O   HOH C2269      65.182  94.820  93.721  1.00 54.43           O
HETATM 5656  O   HOH C2270      83.588 104.265  79.492  1.00 68.79           O
HETATM 5657  O   HOH C2271      89.297  54.048  82.844  1.00 74.63           O
HETATM 5658  O   HOH C2272      93.549  43.233  84.284  1.00 77.76           O
HETATM 5659  O   HOH C2273      75.845  79.023  99.140  1.00 63.33           O
HETATM 5660  O   HOH C2274      82.712  92.227  84.614  1.00 57.08           O
HETATM 5661  O   HOH C2275     125.038  76.948  83.274  1.00 79.09           O
HETATM 5662  O   HOH C2276      89.415  62.981 116.553  1.00 74.18           O
HETATM 5663  O   HOH C2277     109.680  57.213  81.734  1.00 75.12           O
HETATM 5664  O   HOH C2278      95.103 106.773  89.891  1.00 63.83           O
HETATM 5665  O   HOH C2279      75.082  62.191  92.352  1.00 75.67           O
HETATM 5666  O   HOH C2280      88.060  97.009  86.255  1.00 60.52           O
HETATM 5667  O   HOH C2281      78.546 103.154  71.782  1.00 74.51           O
HETATM 5668  O   HOH C2282      75.390  65.853  85.325  1.00 72.26           O
HETATM 5669  O   HOH C2283      84.149  79.184 106.372  1.00 63.77           O
HETATM 5670  O   HOH C2284     111.532  61.146  96.960  1.00 64.98           O
HETATM 5671  O   HOH C2285      96.990  76.804  87.905  1.00 61.09           O
HETATM 5672  O   HOH C2286      98.207  68.698  97.567  1.00 62.15           O
HETATM 5673  O   HOH C2287      84.586 101.383  88.703  1.00 60.86           O
HETATM 5674  O   HOH C2288      86.075 107.653 107.654  1.00 61.01           O
HETATM 5675  O   HOH C2289      39.001  96.274 112.635  1.00 67.33           O
HETATM 5676  O   HOH C2290     105.499  69.212  99.244  1.00 67.01           O
HETATM 5677  O   HOH C2291      73.535 102.696  96.117  1.00 57.91           O
HETATM 5678  O   HOH C2292      95.502  52.098  78.836  1.00 73.60           O
HETATM 5679  O   HOH C2293      67.898  96.482 105.991  1.00 61.86           O
HETATM 5680  O   HOH C2294      51.087 102.016 102.263  1.00 61.16           O
HETATM 5681  O   HOH C2295      95.376  65.095  99.364  1.00 60.84           O
HETATM 5682  O   HOH C2296      98.508  73.743 118.939  1.00 66.95           O
HETATM 5683  O   HOH C2297      60.001  77.178 106.607  1.00 64.51           O
HETATM 5684  O   HOH C2298      88.446  88.548 112.303  1.00 68.49           O
HETATM 5685  O   HOH C2299      80.475  67.572 114.305  1.00 76.99           O
HETATM 5686  O   HOH C2300      94.180  77.619 114.500  1.00 65.86           O
HETATM 5687  O   HOH C2301     100.757  79.818  87.225  1.00 59.49           O
HETATM 5688  O   HOH C2302      62.929 110.228  70.213  1.00 75.31           O
HETATM 5689  O   HOH C2303      71.686  95.825 115.547  1.00 69.94           O
HETATM 5690  O   HOH C2304      99.528  42.303  98.311  1.00 77.16           O
HETATM 5691  O   HOH C2305      90.098  74.022 122.654  1.00 73.91           O
HETATM 5692  O   HOH C2306     107.476  63.822  84.493  1.00 69.49           O
HETATM 5693  O   HOH C2307      99.423 102.780 100.896  1.00 67.72           O
HETATM 5694  O   HOH C2308      79.134  67.261 112.381  1.00 79.57           O
HETATM 5695  O   HOH C2309      71.350  94.398  69.293  1.00 71.99           O
HETATM 5696  O   HOH C2310      73.336  97.630 104.627  1.00 61.27           O
HETATM 5697  O   HOH C2311      90.648  97.004 114.829  1.00 66.90           O
HETATM 5698  O   HOH C2312      67.385  94.624 113.118  1.00 66.09           O
HETATM 5699  O   HOH C2313      86.594  94.460  76.414  1.00 66.84           O
HETATM 5700  O   HOH C2314      47.351 101.491 100.182  1.00 63.29           O
HETATM 5701  O   HOH C2315      88.972 104.329  94.990  1.00 63.00           O
HETATM 5702  O   HOH C2316     101.777  93.715  89.891  1.00 59.68           O
HETATM 5703  O   HOH C2317     133.394  80.277  97.318  1.00 77.73           O
HETATM 5704  O   HOH C2318     100.259  95.132 106.857  1.00 63.43           O
HETATM 5705  O   HOH C2319     101.377  70.919 119.165  1.00 68.47           O
HETATM 5706  O   HOH C2320      71.214  61.839  96.349  1.00 75.08           O
HETATM 5707  O   HOH C2321      83.804  63.203  86.486  1.00 68.78           O
HETATM 5708  O   HOH C2322      69.338  85.214  97.630  1.00 61.33           O
HETATM 5709  O   HOH C2323      92.058  69.522  87.113  1.00 69.13           O
HETATM 5710  O   HOH C2324      80.062  96.700 111.767  1.00 64.06           O
HETATM 5711  O   HOH C2325      76.015  85.410  71.244  1.00 73.18           O
HETATM 5712  O   HOH C2326     119.121  86.859  79.199  1.00 74.98           O
HETATM 5713  O   HOH C2327      77.482  92.533 105.259  1.00 59.04           O
HETATM 5714  O   HOH C2328      56.501  98.212 118.134  1.00 65.14           O
HETATM 5715  O   HOH C2329      37.364  88.632 115.503  1.00 75.88           O
HETATM 5716  O   HOH C2330     101.445  70.258  85.102  1.00 70.73           O
HETATM 5717  O   HOH C2331      37.846  84.842  94.170  1.00 69.33           O
HETATM 5718  O   HOH C2332     101.666  90.713  84.579  1.00 63.67           O
HETATM 5719  O   HOH C2333      33.639  80.019  94.388  1.00 75.89           O
HETATM 5720  O   HOH C2334      89.344  67.006 105.188  1.00 64.46           O
HETATM 5721  O   HOH C2335      80.159  90.544  68.309  1.00 71.86           O
HETATM 5722  O   HOH C2336      57.475 103.035 109.721  1.00 61.43           O
HETATM 5723  O   HOH C2337      98.945  97.971 102.394  1.00 60.71           O
HETATM 5724  O   HOH C2338     102.864  93.039  87.478  1.00 63.77           O
HETATM 5725  O   HOH C2339      80.399 107.098  89.582  1.00 64.96           O
HETATM 5726  O   HOH C2340      98.260  68.978 105.816  1.00 63.93           O
HETATM 5727  O   HOH C2341      55.339 107.876 114.550  1.00 67.43           O
HETATM 5728  O   HOH C2342      78.633  76.479  79.660  1.00 68.54           O
HETATM 5729  O   HOH C2343      70.566  64.466 110.311  1.00 76.51           O
HETATM 5730  O   HOH C2344      45.556  86.904 109.050  1.00 65.64           O
HETATM 5731  O   HOH C2345      95.010  81.694  80.607  1.00 66.33           O
HETATM 5732  O   HOH C2346      87.436 103.436  90.930  1.00 61.30           O
HETATM 5733  O   HOH C2347     101.463  62.890 115.392  1.00 69.64           O
HETATM 5734  O   HOH C2348     103.901  68.079  70.965  1.00 76.40           O
HETATM 5735  O   HOH C2349      73.414 101.760  90.589  1.00 52.38           O
HETATM 5736  O   HOH C2350      87.520  69.419 108.845  1.00 67.68           O
HETATM 5737  O   HOH C2351      96.452  75.479  99.592  1.00 60.77           O
HETATM 5738  O   HOH C2352      65.463 100.531  89.069  1.00 52.48           O
HETATM 5739  O   HOH C2353      78.788  74.934 113.309  1.00 72.70           O
HETATM 5740  O   HOH C2354      93.885  90.208 109.565  1.00 60.15           O
HETATM 5741  O   HOH C2355     114.708  66.692  70.939  1.00 78.14           O
HETATM 5742  O   HOH C2356      87.253  44.323 105.185  1.00 71.75           O
HETATM 5743  O   HOH C2357      52.026  89.000 126.409  1.00 75.86           O
HETATM 5744  O   HOH C2358      87.646  64.470 103.378  1.00 64.45           O
HETATM 5745  O   HOH C2359     107.226  95.799  71.106  1.00 76.17           O
HETATM 5746  O   HOH C2360      52.958 105.687 110.051  1.00 62.98           O
HETATM 5747  O   HOH C2361      98.523  77.807 119.952  1.00 70.43           O
HETATM 5748  O   HOH C2362      95.955  66.453  95.648  1.00 63.61           O
HETATM 5749  O   HOH C2363     118.521  71.562  88.661  1.00 79.47           O
HETATM 5750  O   HOH C2364      59.834  99.207 105.813  1.00 61.25           O
HETATM 5751  O   HOH C2365      87.035  87.217  76.311  1.00 64.68           O
HETATM 5752  O   HOH C2366      77.248  71.597 112.826  1.00 76.46           O
HETATM 5753  O   HOH C2367      58.078  79.642  90.842  1.00 66.45           O
HETATM 5754  O   HOH C2368     100.749  72.503  88.601  1.00 69.04           O
HETATM 5755  O   HOH C2369     101.497  89.622  89.123  1.00 59.32           O
HETATM 5756  O   HOH C2370     103.359  71.072 110.507  1.00 64.00           O
HETATM 5757  O   HOH C2371     103.859  42.270  93.505  1.00 78.37           O
HETATM 5758  O   HOH C2372     105.725  60.868  74.901  1.00 75.83           O
HETATM 5759  O   HOH C2373      70.146  81.301  98.874  1.00 63.77           O
HETATM 5760  O   HOH C2374      76.705  52.890  96.262  1.00 73.87           O
HETATM 5761  O   HOH C2375      59.787  97.570 120.475  1.00 68.00           O
HETATM 5762  O   HOH C2376     110.409  86.747  86.329  1.00 72.17           O
HETATM 5763  O   HOH C2377      77.001  90.409 113.742  1.00 72.29           O
HETATM 5764  O   HOH C2378     106.145  92.008  65.379  1.00 79.54           O
HETATM 5765  O   HOH C2379      97.050  86.453  72.275  1.00 72.35           O
HETATM 5766  O   HOH C2380      54.634 104.697  84.255  1.00 68.87           O
HETATM 5767  O   HOH C2381      76.901  98.302  83.703  1.00 53.71           O
HETATM 5768  O   HOH C2382      82.611 107.063  92.845  1.00 65.10           O
HETATM 5769  O   HOH C2383      96.736  83.900  74.670  1.00 69.11           O
HETATM 5770  O   HOH C2384      98.797  86.471 117.706  1.00 66.92           O
HETATM 5771  O   HOH C2385      76.043 110.298  70.955  1.00 75.67           O
HETATM 5772  O   HOH C2386      66.731  85.647 104.561  1.00 65.22           O
HETATM 5773  O   HOH C2387      64.979  82.846  88.402  1.00 66.12           O
HETATM 5774  O   HOH C2388     106.350  74.409  98.418  1.00 63.62           O
HETATM 5775  O   HOH C2389     127.947  80.648  89.527  1.00 76.06           O
HETATM 5776  O   HOH C2390      77.465 101.754 116.141  1.00 72.77           O
HETATM 5777  O   HOH C2391      42.530  85.759 106.197  1.00 66.36           O
HETATM 5778  O   HOH C2392      68.697  79.168 102.875  1.00 70.14           O
HETATM 5779  O   HOH C2393      64.947  80.726 102.521  1.00 66.29           O
HETATM 5780  O   HOH C2394     115.218  89.746  73.827  1.00 78.91           O
HETATM 5781  O   HOH C2395     130.095  89.895 100.821  1.00 72.55           O
HETATM 5782  O   HOH C2396      80.497  92.854  83.630  1.00 56.38           O
HETATM 5783  O   HOH C2397      85.667  80.091  92.610  1.00 58.59           O
HETATM 5784  O   HOH C2398      88.999  94.181 114.496  1.00 65.78           O
HETATM 5785  O   HOH C2399      54.960 103.351  93.459  1.00 63.57           O
HETATM 5786  O   HOH C2400      49.275  97.395 125.213  1.00 74.26           O
HETATM 5787  O   HOH C2401      77.706  78.303 100.410  1.00 64.54           O
HETATM 5788  O   HOH C2402      92.884  96.675  79.859  1.00 58.89           O
HETATM 5789  O   HOH C2403     100.536  81.048 121.153  1.00 71.62           O
HETATM 5790  O   HOH C2404      85.538  69.872  81.914  1.00 74.53           O
HETATM 5791  O   HOH C2405      37.027  94.422 109.757  1.00 67.72           O
HETATM 5792  O   HOH C2406     112.871  59.783  86.819  1.00 71.86           O
HETATM 5793  O   HOH C2407     115.277  84.699  70.280  1.00 74.85           O
HETATM 5794  O   HOH C2408      66.353  63.249 104.505  1.00 75.28           O
HETATM 5795  O   HOH C2409      95.981  66.093  86.423  1.00 64.25           O
HETATM 5796  O   HOH C2410      65.511  70.679  93.200  1.00 67.51           O
HETATM 5797  O   HOH C2411     101.222  78.826 120.555  1.00 70.38           O
HETATM 5798  O   HOH C2412      80.892  87.029  70.589  1.00 72.76           O
HETATM 5799  O   HOH C2413     101.970  94.452  94.496  1.00 57.68           O
HETATM 5800  O   HOH C2414      76.040  92.413 115.399  1.00 73.69           O
HETATM 5801  O   HOH C2415      48.896  88.410 112.389  1.00 65.21           O
HETATM 5802  O   HOH C2416     131.635  79.273  94.184  1.00 74.83           O
HETATM 5803  O   HOH C2417      89.422  46.021  86.382  1.00 74.61           O
HETATM 5804  O   HOH C2418     101.534  94.601  71.230  1.00 71.65           O
HETATM 5805  O   HOH C2419     104.693  86.511  90.234  1.00 63.12           O
HETATM 5806  O   HOH C2420     105.344  87.466  63.621  1.00 78.39           O
HETATM 5807  O   HOH C2421      71.969 115.540  73.801  1.00 82.39           O
HETATM 5808  O   HOH C2422      90.757  87.200 102.484  1.00 59.58           O
HETATM 5809  O   HOH C2423      26.034  97.288 115.568  1.00 78.51           O
HETATM 5810  O   HOH C2424      94.070  45.199 110.064  1.00 79.47           O
HETATM 5811  O   HOH C2425      80.855  63.277  92.215  1.00 67.97           O
HETATM 5812  O   HOH C2426      82.903  47.933 103.245  1.00 66.52           O
HETATM 5813  O   HOH C2427      68.604  74.221  92.048  1.00 66.12           O
HETATM 5814  O   HOH C2428      85.035  98.518 100.730  1.00 52.00           O
HETATM 5815  O   HOH C2429      53.815 101.083  98.884  1.00 61.89           O
HETATM 5816  O   HOH C2430      82.188  48.992  96.237  1.00 74.20           O
HETATM 5817  O   HOH C2431      86.043 103.463 119.108  1.00 66.36           O
HETATM 5818  O   HOH C2432     111.919  89.913  97.059  1.00 66.47           O
HETATM 5819  O   HOH C2433      87.363 102.585  94.057  1.00 58.88           O
HETATM 5820  O   HOH C2434      81.460  95.372  82.026  1.00 62.99           O
HETATM 5821  O   HOH C2435      91.826  54.218 111.581  1.00 72.16           O
HETATM 5822  O   HOH C2436      56.553  72.283  95.682  1.00 71.21           O
HETATM 5823  O   HOH C2437      99.766  76.243  79.807  1.00 76.59           O
HETATM 5824  O   HOH C2438      47.661  96.021 126.994  1.00 73.42           O
HETATM 5825  O   HOH C2439      64.260  83.245 103.365  1.00 66.33           O
HETATM 5826  O   HOH C2440      92.183 104.225  81.050  1.00 70.43           O
HETATM 5827  O   HOH C2441      92.183  47.823  88.424  1.00 70.98           O
HETATM 5828  O   HOH C2442      69.863  87.108 111.486  1.00 70.93           O
HETATM 5829  O   HOH C2443      85.735  96.102  85.886  1.00 59.54           O
HETATM 5830  O   HOH C2444     110.084  80.493  72.293  1.00 73.46           O
HETATM 5831  O   HOH C2445      77.585 107.434  96.648  1.00 59.49           O
HETATM 5832  O   HOH C2446      96.582  73.700  77.907  1.00 78.21           O
HETATM 5833  O   HOH C2447      97.263 105.031  84.479  1.00 64.88           O
HETATM 5834  O   HOH C2448     118.320  83.549  86.861  1.00 75.22           O
HETATM 5835  O   HOH C2449      75.403 103.761  94.478  1.00 57.87           O
HETATM 5836  O   HOH C2450      39.996 103.448 109.847  1.00 61.32           O
HETATM 5837  O   HOH C2451      73.703 104.298  92.413  1.00 61.89           O
HETATM 5838  O   HOH C2452      76.303  93.516  82.429  1.00 56.73           O
HETATM 5839  O   HOH C2453      85.097  92.143  79.929  1.00 63.53           O
HETATM 5840  O   HOH C2454      36.584 103.651 103.740  1.00 65.97           O
HETATM 5841  O   HOH C2455     104.218 100.321  69.614  1.00 79.73           O
HETATM 5842  O   HOH C2456      86.603  78.448  95.655  1.00 61.50           O
HETATM 5843  O   HOH C2457      82.716  63.867 117.684  1.00 75.71           O
HETATM 5844  O   HOH C2458      54.852  84.868 100.645  1.00 61.34           O
HETATM 5845  O   HOH C2459     121.599  83.263  89.231  1.00 79.09           O
HETATM 5846  O   HOH C2460     101.720  58.151  73.893  1.00 82.09           O
HETATM 5847  O   HOH C2461      83.584 111.333  77.692  1.00 71.35           O
HETATM 5848  O   HOH C2462      70.168 108.710  89.929  1.00 65.19           O
HETATM 5849  O   HOH C2463      59.692  89.429 122.598  1.00 71.01           O
HETATM 5850  O   HOH C2464      96.304 102.708  82.565  1.00 63.56           O
HETATM 5851  O   HOH C2465      86.211  76.286  89.669  1.00 62.80           O
HETATM 5852  O   HOH C2466      42.408  90.272  85.192  1.00 65.60           O
HETATM 5853  O   HOH C2467      50.923  83.747 101.509  1.00 64.79           O
HETATM 5854  O   HOH C2468      66.325  90.638 122.102  1.00 76.59           O
HETATM 5855  O   HOH C2469      36.266 102.337 115.537  1.00 70.24           O
HETATM 5856  O   HOH C2470      52.279  84.511 109.171  1.00 66.68           O
HETATM 5857  O   HOH C2471      94.138 107.209 109.991  1.00 64.68           O
HETATM 5858  O   HOH C2472     103.444  67.791  93.530  1.00 63.85           O
HETATM 5859  O   HOH C2473      90.013  49.455  94.009  1.00 68.04           O
HETATM 5860  O   HOH C2474      59.396  95.783 111.972  1.00 58.69           O
HETATM 5861  O   HOH C2475      76.348 107.166  91.887  1.00 64.96           O
HETATM 5862  O   HOH C2476     105.475  64.468 117.663  1.00 65.87           O
HETATM 5863  O   HOH C2477     114.934  62.626  77.413  1.00 79.17           O
HETATM 5864  O   HOH C2478      75.609  73.861 115.047  1.00 80.64           O
HETATM 5865  O   HOH C2479     106.723  88.902  91.275  1.00 62.69           O
HETATM 5866  O   HOH C2480      84.280  87.079 111.349  1.00 71.36           O
HETATM 5867  O   HOH C2481      53.846  71.073 105.360  1.00 71.09           O
HETATM 5868  O   HOH C2482      66.816  88.066 113.299  1.00 68.63           O
HETATM 5869  O   HOH C2483      72.925 105.954  88.892  1.00 61.47           O
HETATM 5870  O   HOH C2484      94.226  67.423 103.431  1.00 63.05           O
HETATM 5871  O   HOH C2485     100.502 105.115  77.421  1.00 78.33           O
HETATM 5872  O   HOH C2486      98.236  96.157 111.912  1.00 64.59           O
HETATM 5873  O   HOH C2487     108.507  74.758 112.865  1.00 62.50           O
HETATM 5874  O   HOH C2488      93.043  97.468  75.006  1.00 64.73           O
HETATM 5875  O   HOH C2489      63.473  70.947  95.976  1.00 67.70           O
HETATM 5876  O   HOH C2490      52.719  71.330 103.334  1.00 68.62           O
HETATM 5877  O   HOH C2491      99.147  81.914  82.644  1.00 65.71           O
HETATM 5878  O   HOH C2492      73.057  76.317 112.560  1.00 78.10           O
HETATM 5879  O   HOH C2493     108.821  54.584  97.102  1.00 69.30           O
HETATM 5880  O   HOH C2494      45.663  88.428 112.900  1.00 69.00           O
HETATM 5881  O   HOH C2495     109.639  62.889 100.519  1.00 64.82           O
HETATM 5882  O   HOH C2496      29.238 102.597 110.431  1.00 72.86           O
HETATM 5883  O   HOH C2497      74.928 112.962  73.665  1.00 77.49           O
HETATM 5884  O   HOH C2498     110.106  69.174  86.802  1.00 71.63           O
HETATM 5885  O   HOH C2499      83.327  96.706  73.772  1.00 72.52           O
HETATM 5886  O   HOH C2500      30.781  81.888 103.104  1.00 71.06           O
HETATM 5887  O   HOH C2501      92.980  64.166  91.567  1.00 62.98           O
HETATM 5888  O   HOH C2502     108.809  50.535 100.111  1.00 72.33           O
HETATM 5889  O   HOH C2503      56.606 102.648 118.408  1.00 66.64           O
HETATM 5890  O   HOH C2504      74.186  72.988  88.215  1.00 68.49           O
HETATM 5891  O   HOH C2505      80.096  69.356  87.474  1.00 72.03           O
HETATM 5892  O   HOH C2506      94.116  98.135  81.560  1.00 56.83           O
HETATM 5893  O   HOH C2507      70.879  94.628 106.071  1.00 63.46           O
HETATM 5894  O   HOH C2508      91.603  68.715 121.929  1.00 78.33           O
HETATM 5895  O   HOH C2509      55.294  90.295 113.561  1.00 60.73           O
HETATM 5896  O   HOH C2510      66.523  74.982  91.217  1.00 68.11           O
HETATM 5897  O   HOH C2511      81.665  93.052  71.227  1.00 69.01           O
HETATM 5898  O   HOH C2512     127.639  76.535  73.465  1.00 85.45           O
HETATM 5899  O   HOH C2513      68.362  88.785 124.093  1.00 81.84           O
HETATM 5900  O   HOH C2514      43.658 102.169 115.477  1.00 64.17           O
HETATM 5901  O   HOH C2515     124.727  76.859  90.240  1.00 73.97           O
HETATM 5902  O   HOH C2516      43.163  75.217 100.935  1.00 68.90           O
HETATM 5903  O   HOH C2517      86.620  68.933 106.761  1.00 67.99           O
HETATM 5904  O   HOH C2518      94.429  81.039 107.408  1.00 60.19           O
HETATM 5905  O   HOH C2519      59.347  79.154 113.069  1.00 69.62           O
HETATM 5906  O   HOH C2520      75.391 104.051 113.780  1.00 70.31           O
HETATM 5907  O   HOH C2521      66.668  86.591  96.676  1.00 58.96           O
HETATM 5908  O   HOH C2522      94.368  61.880  77.242  1.00 70.66           O
HETATM 5909  O   HOH C2523     102.842  44.362  97.077  1.00 77.33           O
HETATM 5910  O   HOH C2524      96.853  80.037  72.121  1.00 74.05           O
HETATM 5911  O   HOH C2525      41.642  75.554  94.083  1.00 71.48           O
HETATM 5912  O   HOH C2526      93.455  84.954 116.999  1.00 69.25           O
HETATM 5913  O   HOH C2527      40.869  92.691  87.012  1.00 66.12           O
HETATM 5914  O   HOH C2528     112.925  70.653  66.742  1.00 77.99           O
HETATM 5915  O   HOH C2529     106.360  78.609  90.020  1.00 68.61           O
HETATM 5916  O   HOH C2530     111.324  87.828  94.329  1.00 65.23           O
HETATM 5917  O   HOH C2531      46.278 104.156  93.273  1.00 64.65           O
HETATM 5918  O   HOH C2532      83.686  54.519 109.081  1.00 70.78           O
HETATM 5919  O   HOH C2533     105.367  84.953  88.451  1.00 65.90           O
HETATM 5920  O   HOH C2534      83.942  94.693  79.187  1.00 67.56           O
HETATM 5921  O   HOH C2535      58.436 114.092  90.576  1.00 72.64           O
HETATM 5922  O   HOH C2536      55.930 107.394  93.547  1.00 70.96           O
HETATM 5923  O   HOH C2537      73.446  88.035  77.479  1.00 65.96           O
HETATM 5924  O   HOH C2538      79.229  79.482  96.312  1.00 57.17           O
HETATM 5925  O   HOH C2539     109.055  53.444 112.077  1.00 67.71           O
HETATM 5926  O   HOH C2540      95.830  98.606  76.862  1.00 63.76           O
HETATM 5927  O   HOH C2541      84.077 113.737  81.139  1.00 74.04           O
HETATM 5928  O   HOH C2542      60.009  78.733 109.420  1.00 68.20           O
HETATM 5929  O   HOH C2543      33.601 103.654  98.024  1.00 72.31           O
HETATM 5930  O   HOH C2544      92.179  43.766 107.008  1.00 78.78           O
HETATM 5931  O   HOH C2545     107.195  72.776  96.095  1.00 67.93           O
HETATM 5932  O   HOH C2546      99.804  70.693 104.371  1.00 64.39           O
HETATM 5933  O   HOH C2547      54.581 111.227  95.622  1.00 71.69           O
HETATM 5934  O   HOH C2548      78.654  90.140 112.070  1.00 73.37           O
HETATM 5935  O   HOH C2549      95.709 106.232 103.405  1.00 63.06           O
HETATM 5936  O   HOH C2550      60.309  65.671  94.901  1.00 83.04           O
HETATM 5937  O   HOH C2551      98.626  76.592  77.799  1.00 75.57           O
HETATM 5938  O   HOH C2552      75.335  85.049 116.396  1.00 78.29           O
HETATM 5939  O   HOH C2553      58.259  74.749  95.356  1.00 68.32           O
HETATM 5940  O   HOH C2554     109.024  73.123  67.027  1.00 78.85           O
HETATM 5941  O   HOH C2555      94.101  40.000 101.659  1.00 72.85           O
HETATM 5942  O   HOH C2556     104.027  59.483 110.606  1.00 68.39           O
HETATM 5943  O   HOH C2557     105.503  69.144 113.148  1.00 69.24           O
HETATM 5944  O   HOH C2558      45.462 102.867  88.530  1.00 65.10           O
HETATM 5945  O   HOH C2559      63.834  83.056  91.111  1.00 66.79           O
HETATM 5946  O   HOH C2560      63.196  86.445 122.563  1.00 80.05           O
HETATM 5947  O   HOH C2561     112.773  65.711  73.693  1.00 78.01           O
HETATM 5948  O   HOH C2562     108.210  69.226  89.718  1.00 66.75           O
HETATM 5949  O   HOH C2563      86.997  68.621  89.337  1.00 66.29           O
HETATM 5950  O   HOH C2564     101.450  59.441 113.477  1.00 69.93           O
HETATM 5951  O   HOH C2565      47.566 106.019  91.627  1.00 63.84           O
HETATM 5952  O   HOH C2566      69.126  99.025 105.129  1.00 64.60           O
HETATM 5953  O   HOH C2567      52.366  96.133 128.558  1.00 76.34           O
HETATM 5954  O   HOH C2568      76.621 109.479 103.018  1.00 67.12           O
HETATM 5955  O   HOH C2569     111.391  79.977  99.613  1.00 62.22           O
HETATM 5956  O   HOH C2570      73.791  64.847  94.778  1.00 71.68           O
HETATM 5957  O   HOH C2571     104.310  94.780 105.686  1.00 63.11           O
HETATM 5958  O   HOH C2572      75.570  81.325  81.838  1.00 62.79           O
HETATM 5959  O   HOH C2573     126.233  83.012  84.159  1.00 80.77           O
HETATM 5960  O   HOH C2574      58.753 101.440 119.995  1.00 70.17           O
HETATM 5961  O   HOH C2575      67.746  74.510  94.169  1.00 66.59           O
HETATM 5962  O   HOH C2576      75.234  97.869 106.643  1.00 61.25           O
HETATM 5963  O   HOH C2577      48.894  77.542  90.527  1.00 71.12           O
HETATM 5964  O   HOH C2578      59.947  83.153  90.655  1.00 64.51           O
HETATM 5965  O   HOH C2579      71.627  89.809  83.229  1.00 57.17           O
HETATM 5966  O   HOH C2580      54.340  82.391  98.772  1.00 64.27           O
HETATM 5967  O   HOH C2581     102.067  72.269  91.133  1.00 66.24           O
HETATM 5968  O   HOH C2582      76.242  90.827  67.585  1.00 68.31           O
HETATM 5969  O   HOH C2583     105.654  98.069  86.965  1.00 71.33           O
HETATM 5970  O   HOH C2584      94.386  40.953 104.363  1.00 77.86           O
HETATM 5971  O   HOH C2585      69.593  75.672  95.367  1.00 64.89           O
HETATM 5972  O   HOH C2586      94.446  43.325 105.823  1.00 77.34           O
HETATM 5973  O   HOH C2587      91.546  94.702  72.565  1.00 67.61           O
HETATM 5974  O   HOH C2588      89.268  72.210 101.722  1.00 63.99           O
HETATM 5975  O   HOH C2589      69.265  97.371  98.500  1.00 55.85           O
HETATM 5976  O   HOH C2590      95.794  78.179  78.274  1.00 72.73           O
HETATM 5977  O   HOH C2591      93.554  88.972  73.889  1.00 63.09           O
HETATM 5978  O   HOH C2592      88.180 101.187  74.694  1.00 71.85           O
HETATM 5979  O   HOH C2593      92.270  56.896 111.265  1.00 69.52           O
HETATM 5980  O   HOH C2594      84.857  64.833 104.272  1.00 68.12           O
HETATM 5981  O   HOH C2595     106.598  72.420  99.770  1.00 65.78           O
HETATM 5982  O   HOH C2596      60.736  94.513 122.108  1.00 68.03           O
HETATM 5983  O   HOH C2597     104.256  91.126  87.117  1.00 68.27           O
HETATM 5984  O   HOH C2598      84.944  68.401 101.350  1.00 64.84           O
HETATM 5985  O   HOH C2599     101.658  77.185  82.205  1.00 73.00           O
HETATM 5986  O   HOH C2600      74.795  99.986 108.736  1.00 65.16           O
HETATM 5987  O   HOH C2601      85.587  67.738 120.187  1.00 74.15           O
HETATM 5988  O   HOH C2602      28.871  83.711 113.170  1.00 82.73           O
HETATM 5989  O   HOH C2603      66.426 108.879  69.337  1.00 77.32           O
HETATM 5990  O   HOH C2604     108.515  57.185  94.882  1.00 64.38           O
HETATM 5991  O   HOH C2605     105.371  53.117 114.810  1.00 72.54           O
HETATM 5992  O   HOH C2606      67.592  90.465 110.751  1.00 69.71           O
HETATM 5993  O   HOH C2607      50.427  84.866  99.318  1.00 63.11           O
HETATM 5994  O   HOH C2608      90.234  73.450 120.212  1.00 72.66           O
HETATM 5995  O   HOH C2609      93.062  64.842  83.135  1.00 71.62           O
HETATM 5996  O   HOH C2610     110.050  90.746 102.078  1.00 60.13           O
HETATM 5997  O   HOH C2611     113.556  59.304  84.499  1.00 73.88           O
HETATM 5998  O   HOH C2612     100.933  95.374  98.609  1.00 63.99           O
HETATM 5999  O   HOH C2613     107.486  93.025  98.738  1.00 63.92           O
HETATM 6000  O   HOH C2614      77.792  85.750  73.150  1.00 69.74           O
HETATM 6001  O   HOH C2615      90.656  49.510  85.932  1.00 71.31           O
HETATM 6002  O   HOH C2616      99.975  52.166 114.255  1.00 71.98           O
HETATM 6003  O   HOH C2617      67.995 112.881  72.645  1.00 83.79           O
HETATM 6004  O   HOH C2618      53.299  89.952 124.677  1.00 71.99           O
HETATM 6005  O   HOH C2619     102.322 104.791  99.180  1.00 71.58           O
HETATM 6006  O   HOH C2620      65.775 102.927  89.161  1.00 56.73           O
HETATM 6007  O   HOH C2621      79.000  62.899 114.565  1.00 78.68           O
HETATM 6008  O   HOH C2622      98.877  99.925  89.320  1.00 60.33           O
HETATM 6009  O   HOH C2623     111.315  79.961  87.660  1.00 72.34           O
HETATM 6010  O   HOH C2624      96.932 106.328  95.041  1.00 65.08           O
HETATM 6011  O   HOH C2625      83.048 107.388  87.780  1.00 70.40           O
HETATM 6012  O   HOH C2626      82.434  48.833  98.601  1.00 71.91           O
HETATM 6013  O   HOH C2627     110.259  91.638  97.994  1.00 64.95           O
HETATM 6014  O   HOH C2628      20.461 100.600 102.467  1.00 80.36           O
HETATM 6015  O   HOH C2629      70.624  71.390 112.545  1.00 78.15           O
HETATM 6016  O   HOH C2630      61.953 103.218  90.325  1.00 63.40           O
HETATM 6017  O   HOH C2631      48.163  85.222 115.087  1.00 70.75           O
HETATM 6018  O   HOH C2632      82.074  73.859 118.067  1.00 75.12           O
HETATM 6019  O   HOH C2633     103.283 101.575  96.021  1.00 69.71           O
HETATM 6020  O   HOH C2634      78.415  77.836 102.674  1.00 65.55           O
HETATM 6021  O   HOH C2635      99.271  48.840  92.535  1.00 67.35           O
HETATM 6022  O   HOH C2636      79.286  53.114  92.405  1.00 74.48           O
HETATM 6023  O   HOH C2637      63.300  70.811  98.512  1.00 66.14           O
HETATM 6024  O   HOH C2638      54.652  92.205 123.660  1.00 69.83           O
HETATM 6025  O   HOH C2639      89.831  47.005  93.215  1.00 75.98           O
HETATM 6026  O   HOH C2640      85.544  61.387  83.966  1.00 68.72           O
HETATM 6027  O   HOH C2641      62.541 109.724  91.200  1.00 65.09           O
HETATM 6028  O   HOH C2642     106.242  45.911  90.660  1.00 74.81           O
HETATM 6029  O   HOH C2643     101.209  46.288 111.416  1.00 80.28           O
HETATM 6030  O   HOH C2644      85.127 106.181  95.469  1.00 59.28           O
HETATM 6031  O   HOH C2645      54.503  84.553  96.909  1.00 61.09           O
HETATM 6032  O   HOH C2646      89.489  75.910  77.416  1.00 71.91           O
HETATM 6033  O   HOH C2647      96.278  66.398  76.640  1.00 77.51           O
HETATM 6034  O   HOH C2648      81.013  64.180  87.361  1.00 71.48           O
HETATM 6035  O   HOH C2649     118.028  87.000  71.870  1.00 76.14           O
HETATM 6036  O   HOH C2650      79.483  88.412 113.454  1.00 75.23           O
HETATM 6037  O   HOH C2651      56.229  88.009 112.062  1.00 63.39           O
HETATM 6038  O   HOH C2652      99.436  58.440 115.273  1.00 70.76           O
HETATM 6039  O   HOH C2653      84.418  61.900 115.751  1.00 74.78           O
HETATM 6040  O   HOH C2654      48.353  81.769 107.090  1.00 67.99           O
HETATM 6041  O   HOH C2655      71.670  81.463 122.199  1.00 85.61           O
HETATM 6042  O   HOH C2656      55.377  91.874  82.058  1.00 62.14           O
HETATM 6043  O   HOH C2657      68.308  80.546 109.405  1.00 73.50           O
HETATM 6044  O   HOH C2658      70.052  96.354 112.916  1.00 69.92           O
HETATM 6045  O   HOH C2659     130.688  80.047  91.116  1.00 76.30           O
HETATM 6046  O   HOH C2660      55.530 109.514  96.855  1.00 71.19           O
HETATM 6047  O   HOH C2661      61.709  91.824 122.540  1.00 73.33           O
HETATM 6048  O   HOH C2662     105.228  73.941 120.012  1.00 68.09           O
HETATM 6049  O   HOH C2663      60.277  67.635  93.624  1.00 81.06           O
HETATM 6050  O   HOH C2664      86.744  98.649  88.896  1.00 57.63           O
HETATM 6051  O   HOH C2665      98.252  80.012  81.095  1.00 72.11           O
HETATM 6052  O   HOH C2666      64.782  76.843  91.450  1.00 65.90           O
HETATM 6053  O   HOH C2667      73.107  93.593 102.577  1.00 59.91           O
HETATM 6054  O   HOH C2668      42.047 101.864  87.722  1.00 65.63           O
HETATM 6055  O   HOH C2669      67.514 116.490  72.100  1.00 86.39           O
HETATM 6056  O   HOH C2670      51.057  79.916  86.780  1.00 68.64           O
HETATM 6057  O   HOH C2671      59.836 112.515  93.018  1.00 70.24           O
HETATM 6058  O   HOH C2672      56.711  99.523 103.994  1.00 62.08           O
HETATM 6059  O   HOH C2673      78.992  95.362  81.784  1.00 63.16           O
HETATM 6060  O   HOH C2674      67.889  91.967  77.241  1.00 68.57           O
HETATM 6061  O   HOH C2675      58.338  70.149 107.155  1.00 69.97           O
HETATM 6062  O   HOH C2676      52.311 110.108  73.142  1.00 75.81           O
HETATM 6063  O   HOH C2677      69.339 112.052  89.681  1.00 70.95           O
HETATM 6064  O   HOH C2678      60.936  87.302  91.291  1.00 59.27           O
HETATM 6065  O   HOH C2679      58.912 109.246  70.888  1.00 71.01           O
HETATM 6066  O   HOH C2680      63.201 112.897  89.934  1.00 68.27           O
HETATM 6067  O   HOH C2681      81.322  62.809  89.274  1.00 70.46           O
HETATM 6068  O   HOH C2682     111.041  75.825  67.453  1.00 76.13           O
HETATM 6069  O   HOH C2683      82.127  61.718 111.663  1.00 74.06           O
HETATM 6070  O   HOH C2684      91.831  41.450  95.746  1.00 76.71           O
HETATM 6071  O   HOH C2685      83.097  59.817 109.154  1.00 68.87           O
HETATM 6072  O   HOH C2686      47.548  79.519  88.147  1.00 70.48           O
HETATM 6073  O   HOH C2687      33.820  79.613  98.777  1.00 72.22           O
HETATM 6074  O   HOH C2688      33.871  85.530 117.298  1.00 82.37           O
HETATM 6075  O   HOH C2689      73.809  72.329 115.140  1.00 82.85           O
HETATM 6076  O   HOH C2690      79.083  60.270 107.131  1.00 73.09           O
HETATM 6077  O   HOH C2691      85.597  88.746  77.449  1.00 64.04           O
HETATM 6078  O   HOH C2692      65.773  99.466  98.625  1.00 59.14           O
HETATM 6079  O   HOH C2693      68.339  93.120  83.602  1.00 58.77           O
HETATM 6080  O   HOH C2694     110.694  67.694  92.175  1.00 67.16           O
HETATM 6081  O   HOH C2695      75.490  84.549  76.603  1.00 68.33           O
HETATM 6082  O   HOH C2696      65.194  92.276  94.088  1.00 58.23           O
HETATM 6083  O   HOH C2697      53.910  79.229  84.116  1.00 71.43           O
HETATM 6084  O   HOH C2698      81.575  82.060  75.390  1.00 69.79           O
HETATM 6085  O   HOH C2699      46.419  77.411 105.622  1.00 69.02           O
HETATM 6086  O   HOH C2700      77.215  57.481 106.559  1.00 73.32           O
HETATM 6087  O   HOH C2701     107.434  86.492  88.598  1.00 69.49           O
HETATM 6088  O   HOH C2702      59.068 104.075 111.530  1.00 63.84           O
HETATM 6089  O   HOH C2703      48.592  83.873 104.251  1.00 63.11           O
HETATM 6090  O   HOH C2704      34.292  95.256  95.904  1.00 71.03           O
HETATM 6091  O   HOH C2705      92.657 107.654 107.653  1.00 63.67           O
HETATM 6092  O   HOH C2706     110.366  56.884  89.869  1.00 64.85           O
HETATM 6093  O   HOH C2707      79.268  55.126  90.898  1.00 73.24           O
HETATM 6094  O   HOH C2708      83.218 110.073  95.462  1.00 62.30           O
HETATM 6095  O   HOH C2709     101.792  96.940  96.594  1.00 63.52           O
HETATM 6096  O   HOH C2710      46.713  80.080 107.152  1.00 70.53           O
HETATM 6097  O   HOH C2711      50.838 105.860 108.201  1.00 59.06           O
HETATM 6098  O   HOH C2712     121.371  68.399  68.698  1.00 83.34           O
HETATM 6099  O   HOH C2713      59.943 101.476 107.899  1.00 65.60           O
HETATM 6100  O   HOH C2714      60.423 112.070  96.957  1.00 70.46           O
HETATM 6101  O   HOH C2715      57.530  68.302  94.894  1.00 75.87           O
HETATM 6102  O   HOH C2716      78.088 101.504  69.924  1.00 78.05           O
HETATM 6103  O   HOH C2717     109.971  64.094  71.612  1.00 79.96           O
HETATM 6104  O   HOH C2718      30.365  79.473  94.749  1.00 77.74           O
HETATM 6105  O   HOH C2719      32.115  89.400 119.269  1.00 82.59           O
HETATM 6106  O   HOH C2720     111.380  62.128  75.952  1.00 76.54           O
HETATM 6107  O   HOH C2721      58.109  76.272 112.203  1.00 71.18           O
HETATM 6108  O   HOH C2722      54.170  67.357 102.400  1.00 69.79           O
HETATM 6109  O   HOH C2723     111.894  68.164  68.260  1.00 81.26           O
HETATM 6110  O   HOH C2724      79.729  64.684 112.207  1.00 77.00           O
HETATM 6111  O   HOH C2725      49.971  84.570 112.691  1.00 66.58           O
HETATM 6112  O   HOH C2726      56.121 101.480  79.760  1.00 69.99           O
HETATM 6113  O   HOH C2727      50.725  71.338  94.449  1.00 68.90           O
HETATM 6114  O   HOH C2728      29.154  85.523 108.227  1.00 73.33           O
HETATM 6115  O   HOH C2729     110.837  84.672  93.141  1.00 66.65           O
HETATM 6116  O   HOH C2730      89.810  64.128  80.079  1.00 78.37           O
HETATM 6117  O   HOH C2731      82.891  82.388 115.014  1.00 73.48           O
HETATM 6118  O   HOH C2732      70.172 101.036 111.800  1.00 71.40           O
HETATM 6119  O   HOH C2733      65.472 107.814  91.330  1.00 71.72           O
HETATM 6120  O   HOH C2734      97.798 100.777 108.215  1.00 65.13           O
HETATM 6121  O   HOH C2735      77.760  62.953 110.924  1.00 78.62           O
HETATM 6122  O   HOH C2736      80.984 112.737  76.063  1.00 74.58           O
HETATM 6123  O   HOH C2737      82.230  73.899  98.281  1.00 63.62           O
HETATM 6124  O   HOH C2738      54.895 101.664 102.967  1.00 62.29           O
HETATM 6125  O   HOH C2739     107.064  47.303  88.858  1.00 72.72           O
HETATM 6126  O   HOH C2740     102.757  87.396  87.200  1.00 64.75           O
HETATM 6127  O   HOH C2741     106.969  68.639 103.985  1.00 69.33           O
HETATM 6128  O   HOH C2742      45.117  89.575  85.630  1.00 66.17           O
HETATM 6129  O   HOH C2743      84.174 110.328  87.416  1.00 74.22           O
HETATM 6130  O   HOH C2744      67.340  78.892  98.048  1.00 64.01           O
HETATM 6131  O   HOH C2745     120.090  85.394  84.028  1.00 77.33           O
HETATM 6132  O   HOH C2746      94.379  91.181  72.769  1.00 65.42           O
HETATM 6133  O   HOH C2747      39.389  78.575  90.275  1.00 75.26           O
HETATM 6134  O   HOH C2748      95.056  47.789  80.223  1.00 76.59           O
HETATM 6135  O   HOH C2749      52.038  80.172  93.812  1.00 65.46           O
HETATM 6136  O   HOH C2750      80.018  48.334  88.705  1.00 76.11           O
HETATM 6137  O   HOH C2751      85.917  96.265 120.930  1.00 77.40           O
HETATM 6138  O   HOH C2752      74.693  92.778  66.694  1.00 71.55           O
HETATM 6139  O   HOH C2753     112.260  91.242  70.955  1.00 77.48           O
HETATM 6140  O   HOH C2754      47.676 103.901 101.563  1.00 62.56           O
HETATM 6141  O   HOH C2755     117.639  89.088  78.179  1.00 79.32           O
HETATM 6142  O   HOH C2756      64.847  60.743 100.404  1.00 80.75           O
HETATM 6143  O   HOH C2757     118.389  67.852  88.439  1.00 80.53           O
HETATM 6144  O   HOH C2758      72.423  69.419 114.465  1.00 78.46           O
HETATM 6145  O   HOH C2759      53.773  83.651 118.890  1.00 69.54           O
HETATM 6146  O   HOH C2760      98.918 106.605 102.652  1.00 67.98           O
HETATM 6147  O   HOH C2761      62.310 115.243  87.833  1.00 77.01           O
HETATM 6148  O   HOH C2762      80.026  72.031  98.614  1.00 66.85           O
HETATM 6149  O   HOH C2763      53.281  82.350 109.685  1.00 66.40           O
HETATM 6150  O   HOH C2764      65.767  74.015 109.331  1.00 73.49           O
HETATM 6151  O   HOH C2765      98.545  99.483  73.118  1.00 75.52           O
HETATM 6152  O   HOH C2766      72.529  59.347 103.314  1.00 72.58           O
HETATM 6153  O   HOH C2767      40.557 105.624 113.570  1.00 64.35           O
HETATM 6154  O   HOH C2768      65.266 107.086  68.456  1.00 78.10           O
HETATM 6155  O   HOH C2769     110.699  93.088  70.582  1.00 80.31           O
HETATM 6156  O   HOH C2770      69.794  89.937  75.315  1.00 68.75           O
HETATM 6157  O   HOH C2771      84.777  72.163 116.704  1.00 69.92           O
HETATM 6158  O   HOH C2772      74.512 109.128  90.346  1.00 65.72           O
HETATM 6159  O   HOH C2773      71.292  98.317 106.356  1.00 65.20           O
HETATM 6160  O   HOH C2774     109.703  99.491  81.345  1.00 76.69           O
HETATM 6161  O   HOH C2775     106.505  66.175 104.907  1.00 63.01           O
HETATM 6162  O   HOH C2776      98.502  71.566  81.358  1.00 73.99           O
HETATM 6163  O   HOH C2777      80.973  96.002  78.522  1.00 68.84           O
HETATM 6164  O   HOH C2778      98.840  69.594 117.975  1.00 70.99           O
HETATM 6165  O   HOH C2779     103.016  43.904  99.386  1.00 80.03           O
HETATM 6166  O   HOH C2780     100.717  87.227  83.349  1.00 62.04           O
HETATM 6167  O   HOH C2781      37.989  95.513  87.080  1.00 67.10           O
HETATM 6168  O   HOH C2782      67.577  98.111 115.774  1.00 68.76           O
HETATM 6169  O   HOH C2783     110.074  73.033  90.358  1.00 73.88           O
HETATM 6170  O   HOH C2784      50.082  81.965  81.475  1.00 76.31           O
HETATM 6171  O   HOH C2785      59.621  80.442  99.748  1.00 59.70           O
HETATM 6172  O   HOH C2786      74.368  94.084 115.555  1.00 71.12           O
HETATM 6173  O   HOH C2787      55.402  88.741 126.189  1.00 73.97           O
HETATM 6174  O   HOH C2788      32.122 111.094 100.136  1.00 75.50           O
HETATM 6175  O   HOH C2789     102.077  66.060 116.785  1.00 70.90           O
HETATM 6176  O   HOH C2790     100.901  72.804  93.498  1.00 66.07           O
HETATM 6177  O   HOH C2791     112.878  92.184  73.047  1.00 77.30           O
HETATM 6178  O   HOH C2792      79.097 116.025  77.802  1.00 78.67           O
HETATM 6179  O   HOH C2793      55.203 100.531 118.258  1.00 66.72           O
HETATM 6180  O   HOH C2794      63.644  57.150  93.778  1.00 92.31           O
HETATM 6181  O   HOH C2795      90.992  55.882  82.394  1.00 70.23           O
HETATM 6182  O   HOH C2796     103.939  95.990 101.081  1.00 61.48           O
HETATM 6183  O   HOH C2797      90.526  89.074  74.427  1.00 64.07           O
HETATM 6184  O   HOH C2798     124.844  75.598  80.772  1.00 79.88           O
HETATM 6185  O   HOH C2799     103.861  90.374 109.062  1.00 60.06           O
HETATM 6186  O   HOH C2800      95.205  65.417  78.629  1.00 78.95           O
HETATM 6187  O   HOH C2801      69.623  91.622  79.574  1.00 61.78           O
HETATM 6188  O   HOH C2802     127.048  78.616  75.989  1.00 82.74           O
HETATM 6189  O   HOH C2803      79.914  56.475  88.313  1.00 69.43           O
HETATM 6190  O   HOH C2804      61.839  84.261  91.589  1.00 65.57           O
HETATM 6191  O   HOH C2805      58.345  63.618  99.001  1.00 84.56           O
HETATM 6192  O   HOH C2806      50.316  99.808  80.113  1.00 71.03           O
HETATM 6193  O   HOH C2807      46.388 105.861 112.112  1.00 60.93           O
HETATM 6194  O   HOH C2808      68.655  60.089  97.112  1.00 76.81           O
HETATM 6195  O   HOH C2809      89.646  84.901 112.967  1.00 66.05           O
HETATM 6196  O   HOH C2810      68.898  60.388 104.935  1.00 76.64           O
HETATM 6197  O   HOH C2811     129.033  70.344  78.416  1.00 86.51           O
HETATM 6198  O   HOH C2812      99.946  73.895  80.055  1.00 72.93           O
HETATM 6199  O   HOH C2813      64.356  96.744 117.311  1.00 68.89           O
HETATM 6200  O   HOH C2814      59.595  86.863  88.748  1.00 63.85           O
HETATM 6201  O   HOH C2815      35.803  88.302 118.474  1.00 75.72           O
HETATM 6202  O   HOH C2816     112.218  80.203  92.682  1.00 73.45           O
HETATM 6203  O   HOH C2817      89.645 103.157  75.517  1.00 71.46           O
HETATM 6204  O   HOH C2818      83.436  61.591 113.646  1.00 76.03           O
HETATM 6205  O   HOH C2819      43.067 105.329  91.279  1.00 72.34           O
HETATM 6206  O   HOH C2820      81.534  96.041  69.615  1.00 71.71           O
HETATM 6207  O   HOH C2821      71.231  86.774  84.717  1.00 63.17           O
HETATM 6208  O   HOH C2822      53.991 105.256  92.531  1.00 68.91           O
HETATM 6209  O   HOH C2823     101.969  89.988 115.705  1.00 63.28           O
HETATM 6210  O   HOH C2824     114.271  75.892  68.356  1.00 75.94           O
HETATM 6211  O   HOH C2825      46.300 104.652 114.151  1.00 62.87           O
HETATM 6212  O   HOH C2826      24.941  98.655 113.587  1.00 74.79           O
HETATM 6213  O   HOH C2827      41.265 108.523  98.848  1.00 68.78           O
HETATM 6214  O   HOH C2828     104.078  64.914 120.188  1.00 66.11           O
HETATM 6215  O   HOH C2829      81.153  95.594  75.247  1.00 72.45           O
HETATM 6216  O   HOH C2830      74.341 117.620  75.217  1.00 81.79           O
HETATM 6217  O   HOH C2831      68.789  67.836 111.353  1.00 74.75           O
HETATM 6218  O   HOH C2832      71.471  74.282 113.877  1.00 79.13           O
HETATM 6219  O   HOH C2833      83.286  93.240  76.401  1.00 67.91           O
HETATM 6220  O   HOH C2834     102.704  69.838  91.560  1.00 65.87           O
HETATM 6221  O   HOH C2835      84.790  84.500 112.195  1.00 71.97           O
HETATM 6222  O   HOH C2836      81.696  64.056 115.515  1.00 74.45           O
HETATM 6223  O   HOH C2837      60.379  75.336 109.140  1.00 70.58           O
HETATM 6224  O   HOH C2838      47.154 111.003  90.475  1.00 77.51           O
HETATM 6225  O   HOH C2839      44.206  85.686  84.010  1.00 72.04           O
HETATM 6226  O   HOH C2840      48.035  69.921  96.709  1.00 71.95           O
HETATM 6227  O   HOH C2841     109.759  70.374  66.782  1.00 76.26           O
HETATM 6228  O   HOH C2842      98.538  92.614 114.374  1.00 63.87           O
HETATM 6229  O   HOH C2843     106.179  91.861  88.433  1.00 70.20           O
HETATM 6230  O   HOH C2844      95.174  71.511  75.300  1.00 81.81           O
HETATM 6231  O   HOH C2845     111.371  59.941 101.329  1.00 70.71           O
HETATM 6232  O   HOH C2846      70.222 103.251  94.695  1.00 62.10           O
HETATM 6233  O   HOH C2847      77.214  71.704 115.207  1.00 78.09           O
HETATM 6234  O   HOH C2848     100.759  87.651  85.955  1.00 63.74           O
HETATM 6235  O   HOH C2849     125.661  81.120  87.119  1.00 76.39           O
HETATM 6236  O   HOH C2850      85.364  91.085  77.598  1.00 65.05           O
HETATM 6237  O   HOH C2851     110.622  98.421  77.379  1.00 75.21           O
HETATM 6238  O   HOH C2852      62.967 116.753  85.978  1.00 79.47           O
HETATM 6239  O   HOH C2853     110.701  67.292 100.720  1.00 70.31           O
HETATM 6240  O   HOH C2854      33.906  79.232 101.073  1.00 73.73           O
HETATM 6241  O   HOH C2855      93.691  74.996  81.984  1.00 70.25           O
HETATM 6242  O   HOH C2856      67.031 110.707  71.422  1.00 77.90           O
HETATM 6243  O   HOH C2857      98.018  68.138  84.373  1.00 72.75           O
HETATM 6244  O   HOH C2858      53.138 106.541  90.818  1.00 67.35           O
HETATM 6245  O   HOH C2859      45.465 103.587  90.793  1.00 69.78           O
HETATM 6246  O   HOH C2860      37.767  85.138 111.287  1.00 72.40           O
HETATM 6247  O   HOH C2861      66.744  79.012 100.953  1.00 65.47           O
HETATM 6248  O   HOH C2862      93.421 102.950 116.466  1.00 62.32           O
HETATM 6249  O   HOH C2863     110.786  41.997 100.632  1.00 81.34           O
HETATM 6250  O   HOH C2864     103.730  95.972  91.744  1.00 66.51           O
HETATM 6251  O   HOH C2865      34.203  94.943 123.559  1.00 79.33           O
HETATM 6252  O   HOH C2866      73.237  80.349  82.609  1.00 66.84           O
HETATM 6253  O   HOH C2867     115.581  82.154  69.029  1.00 80.58           O
HETATM 6254  O   HOH C2868      78.096  84.250  75.241  1.00 68.85           O
HETATM 6255  O   HOH C2869      68.404  91.488  85.843  1.00 55.44           O
HETATM 6256  O   HOH C2870      42.297  79.207 106.482  1.00 68.31           O
HETATM 6257  O   HOH C2871      91.509 107.757  88.855  1.00 65.88           O
HETATM 6258  O   HOH C2872      57.426 103.988  73.053  1.00 70.82           O
HETATM 6259  O   HOH C2873     105.267  94.745  97.619  1.00 71.05           O
HETATM 6260  O   HOH C2874     122.536  72.741  89.331  1.00 77.97           O
HETATM 6261  O   HOH C2875      81.027 104.956  70.565  1.00 74.40           O
HETATM 6262  O   HOH C2876     110.669  56.285 100.587  1.00 71.47           O
HETATM 6263  O   HOH C2877     100.971  87.082 115.922  1.00 63.45           O
HETATM 6264  O   HOH C2878      78.452  93.880 119.317  1.00 75.24           O
HETATM 6265  O   HOH C2879     106.978  85.228  63.327  1.00 76.83           O
HETATM 6266  O   HOH C2880      90.380  91.389  74.853  1.00 63.27           O
HETATM 6267  O   HOH C2881      68.664  99.767 100.675  1.00 61.41           O
HETATM 6268  O   HOH C2882      99.335  45.113  86.283  1.00 76.87           O
HETATM 6269  O   HOH C2883      65.047  77.079 110.659  1.00 70.48           O
HETATM 6270  O   HOH C2884      98.328  68.896 108.458  1.00 65.00           O
HETATM 6271  O   HOH C2885     100.400  70.127 101.761  1.00 66.06           O
HETATM 6272  O   HOH C2886      59.649 116.746  87.674  1.00 76.13           O
HETATM 6273  O   HOH C2887      42.906 103.727  97.538  1.00 67.36           O
HETATM 6274  O   HOH C2888     128.175  67.939  75.087  1.00 88.44           O
HETATM 6275  O   HOH C2889     112.836  85.647  96.944  1.00 65.31           O
HETATM 6276  O   HOH C2890      68.489  87.744  87.214  1.00 59.16           O
HETATM 6277  O   HOH C2891      61.552 113.202  91.607  1.00 73.54           O
HETATM 6278  O   HOH C2892      93.765  43.581  88.618  1.00 75.75           O
HETATM 6279  O   HOH C2893     109.787  58.251 101.980  1.00 72.04           O
HETATM 6280  O   HOH C2894      97.374  70.124  76.700  1.00 81.52           O
HETATM 6281  O   HOH C2895     101.793  79.058  83.648  1.00 71.31           O
HETATM 6282  O   HOH C2896      85.195 105.620  88.512  1.00 69.18           O
HETATM 6283  O   HOH C2897      48.351 105.005  89.400  1.00 68.57           O
HETATM 6284  O   HOH C2898      44.698 104.911  98.629  1.00 68.39           O
HETATM 6285  O   HOH C2899     132.335  76.271  94.057  1.00 75.70           O
HETATM 6286  O   HOH C2900      95.866  80.110  74.309  1.00 73.80           O
HETATM 6287  O   HOH C2901      70.881 105.687  91.992  1.00 65.94           O
HETATM 6288  O   HOH C2902      78.525 114.857  75.889  1.00 77.03           O
HETATM 6289  O   HOH C2903      74.021  96.400  66.009  1.00 74.96           O
HETATM 6290  O   HOH C2904     109.417  80.036  95.105  1.00 65.47           O
HETATM 6291  O   HOH C2905      82.945  56.390  94.349  1.00 70.51           O
HETATM 6292  O   HOH C2906      97.430  61.700  74.952  1.00 77.00           O
HETATM 6293  O   HOH C2907      40.622 104.560  99.786  1.00 65.32           O
HETATM 6294  O   HOH C2908      72.837 105.351 101.404  1.00 63.67           O
HETATM 6295  O   HOH C2909      60.241  74.276  93.559  1.00 69.29           O
HETATM 6296  O   HOH C2910      22.458 105.820 109.810  1.00 79.56           O
HETATM 6297  O   HOH C2911      99.936  96.692 109.281  1.00 62.23           O
HETATM 6298  O   HOH C2912      69.407 100.087 113.824  1.00 70.84           O
HETATM 6299  O   HOH C2913     101.217  68.226 117.138  1.00 70.81           O
HETATM 6300  O   HOH C2914      69.746  71.867 116.082  1.00 86.66           O
HETATM 6301  O   HOH C2915      86.278  49.193  85.131  1.00 75.60           O
HETATM 6302  O   HOH C2916      86.760  63.846  82.881  1.00 70.05           O
HETATM 6303  O   HOH C2917      69.279  86.839 113.880  1.00 69.95           O
HETATM 6304  O   HOH C2918      59.965 115.743  89.809  1.00 73.86           O
HETATM 6305  O   HOH C2919      78.914 109.449  89.245  1.00 72.45           O
HETATM 6306  O   HOH C2920      18.595 101.050  99.618  1.00 84.63           O
HETATM 6307  O   HOH C2921      99.762  80.077  84.208  1.00 67.13           O
HETATM 6308  O   HOH C2922      63.284 103.827  70.633  1.00 73.38           O
HETATM 6309  O   HOH C2923      91.208  66.052  81.389  1.00 74.33           O
HETATM 6310  O   HOH C2924     102.538  76.929 120.844  1.00 68.73           O
HETATM 6311  O   HOH C2925      86.739  91.745 112.639  1.00 68.85           O
HETATM 6312  O   HOH C2926      95.836  75.357  82.995  1.00 71.75           O
HETATM 6313  O   HOH C2927      63.907  69.272 108.529  1.00 72.66           O
HETATM 6314  O   HOH C2928     100.452  97.311 104.364  1.00 60.43           O
HETATM 6315  O   HOH C2929     110.398  88.928  67.949  1.00 73.86           O
HETATM 6316  O   HOH C2930      60.369 100.242  82.826  1.00 64.12           O
HETATM 6317  O   HOH C2931      77.682  78.650  79.411  1.00 68.53           O
HETATM 6318  O   HOH C2932      58.038 106.493  94.123  1.00 68.83           O
HETATM 6319  O   HOH C2933      61.274  66.824 106.177  1.00 73.62           O
HETATM 6320  O   HOH C2934      61.667  70.817  94.435  1.00 70.61           O
HETATM 6321  O   HOH C2935      35.781  81.619  92.378  1.00 72.82           O
HETATM 6322  O   HOH C2936      79.302 109.143  95.192  1.00 65.15           O
HETATM 6323  O   HOH C2937      30.566  94.465 118.555  1.00 73.59           O
HETATM 6324  O   HOH C2938      58.061  81.947 122.999  1.00 72.11           O
HETATM 6325  O   HOH C2939      88.103 106.677  91.333  1.00 68.46           O
HETATM 6326  O   HOH C2940      77.739  71.004 117.740  1.00 76.81           O
HETATM 6327  O   HOH C2941      93.328  82.699  75.569  1.00 68.39           O
HETATM 6328  O   HOH C2942      67.512  95.063 115.596  1.00 72.00           O
HETATM 6329  O   HOH C2943      83.311  94.058  81.456  1.00 65.36           O
HETATM 6330  O   HOH C2944     106.795  93.568  91.587  1.00 65.34           O
HETATM 6331  O   HOH C2945      45.070 105.211  95.047  1.00 66.93           O
HETATM 6332  O   HOH C2946     116.152  65.302  76.488  1.00 77.62           O
HETATM 6333  O   HOH C2947      55.664 105.554  72.729  1.00 75.61           O
HETATM 6334  O   HOH C2948     122.125  82.326  72.989  1.00 76.42           O
HETATM 6335  O   HOH C2949      34.240 109.691 101.379  1.00 72.99           O
HETATM 6336  O   HOH C2950      72.119 100.175 110.663  1.00 76.47           O
HETATM 6337  O   HOH C2951      90.186  61.216 117.962  1.00 75.21           O
HETATM 6338  O   HOH C2952      99.841  45.052  89.435  1.00 71.08           O
HETATM 6339  O   HOH C2953      84.514  94.435  84.101  1.00 59.75           O
HETATM 6340  O   HOH C2954      49.191  82.462 109.325  1.00 70.29           O
HETATM 6341  O   HOH C2955     109.700  92.495  88.241  1.00 72.29           O
HETATM 6342  O   HOH C2956      78.502  54.436 105.969  1.00 70.58           O
HETATM 6343  O   HOH C2957      71.442 103.981 100.113  1.00 63.58           O
HETATM 6344  O   HOH C2958      46.741 105.738  97.909  1.00 68.70           O
HETATM 6345  O   HOH C2959     112.884  82.339  91.648  1.00 78.02           O
HETATM 6346  O   HOH C2960      99.858  99.272 107.626  1.00 67.18           O
HETATM 6347  O   HOH C2961      85.454 108.997  95.244  1.00 63.49           O
HETATM 6348  O   HOH C2962     135.559  76.909  98.858  1.00 73.60           O
HETATM 6349  O   HOH C2963      70.826 113.348  72.414  1.00 82.24           O
HETATM 6350  O   HOH C2964      82.369  56.691 109.646  1.00 74.46           O
HETATM 6351  O   HOH C2965     123.895  70.692  70.044  1.00 83.92           O
HETATM 6352  O   HOH C2966     127.692  77.911  89.254  1.00 75.82           O
HETATM 6353  O   HOH C2967      67.067 113.318  90.477  1.00 72.78           O
HETATM 6354  O   HOH C2968      86.744  40.311  90.624  1.00 82.16           O
HETATM 6355  O   HOH C2969      47.364  82.602  79.990  1.00 76.39           O
HETATM 6356  O   HOH C2970      75.714  98.494  66.487  1.00 80.08           O
HETATM 6357  O   HOH C2971      60.307  97.834  77.209  1.00 72.40           O
HETATM 6358  O   HOH C2972      61.378 100.557 120.520  1.00 72.85           O
HETATM 6359  O   HOH C2973      58.001 100.549  99.889  1.00 65.13           O
HETATM 6360  O   HOH C2974      58.121 102.408  80.692  1.00 68.71           O
HETATM 6361  O   HOH C2975      73.916  59.549 101.173  1.00 73.44           O
HETATM 6362  O   HOH C2976      86.824  97.596  74.522  1.00 71.36           O
HETATM 6363  O   HOH C2977      71.115  91.899 119.010  1.00 75.03           O
HETATM 6364  O   HOH C2978      55.825  80.439 120.891  1.00 69.04           O
HETATM 6365  O   HOH C2979      61.242  74.999  91.493  1.00 69.42           O
HETATM 6366  O   HOH C2980      80.488  56.494 107.572  1.00 73.89           O
HETATM 6367  O   HOH C2981      92.923  72.778  82.781  1.00 69.75           O
HETATM 6368  O   HOH C2982      88.654  48.171 110.810  1.00 72.41           O
HETATM 6369  O   HOH C2983      81.142 100.702 119.459  1.00 72.02           O
HETATM 6370  O   HOH C2984      97.715  48.201 109.493  1.00 75.18           O
HETATM 6371  O   HOH C2985      35.524 105.865 111.945  1.00 73.91           O
HETATM 6372  O   HOH C2986     107.706  52.631 107.712  1.00 72.58           O
HETATM 6373  O   HOH C2987      60.026  88.278  86.923  1.00 60.12           O
HETATM 6374  O   HOH C2988      58.347 116.412  82.961  1.00 79.56           O
HETATM 6375  O   HOH C2989     115.515  95.133  79.985  1.00 79.94           O
HETATM 6376  O   HOH C2990      48.856 107.667 104.590  1.00 63.95           O
HETATM 6377  O   HOH C2991      80.871  85.495 113.362  1.00 76.81           O
HETATM 6378  O   HOH C2992      42.763 104.428  95.323  1.00 67.55           O
HETATM 6379  O   HOH C2993      93.236  98.391  77.619  1.00 63.49           O
HETATM 6380  O   HOH C2994      83.363  66.176 119.600  1.00 74.34           O
HETATM 6381  O   HOH C2995      86.566 110.051  88.474  1.00 78.59           O
HETATM 6382  O   HOH C2996      87.267  69.892  83.510  1.00 72.50           O
HETATM 6383  O   HOH C2997      96.878  43.856  87.676  1.00 73.95           O
HETATM 6384  O   HOH C2998      38.656  86.456 114.831  1.00 71.77           O
HETATM 6385  O   HOH C2999      35.553 106.344  99.270  1.00 72.83           O
HETATM 6386  O   HOH C3000      95.050  65.622  80.979  1.00 76.78           O
HETATM 6387  O   HOH C3001      79.686 108.438  92.983  1.00 65.98           O
HETATM 6388  O   HOH C3002      96.679  57.423  75.153  1.00 82.12           O
HETATM 6389  O   HOH C3003      91.599  38.502  94.133  1.00 77.42           O
HETATM 6390  O   HOH C3004      53.060  78.123  92.513  1.00 70.75           O
HETATM 6391  O   HOH C3005      74.734 108.370 104.339  1.00 69.05           O
HETATM 6392  O   HOH C3006     119.850  79.740  69.535  1.00 73.15           O
HETATM 6393  O   HOH C3007      80.404  67.099 116.626  1.00 80.55           O
HETATM 6394  O   HOH C3008     104.050  40.941  98.256  1.00 80.17           O
HETATM 6395  O   HOH C3009      83.968  91.614  73.480  1.00 70.85           O
HETATM 6396  O   HOH C3010      57.858 101.997  97.238  1.00 62.00           O
HETATM 6397  O   HOH C3011      54.935  76.831  91.855  1.00 68.11           O
HETATM 6398  O   HOH C3012      69.609  71.780  92.139  1.00 69.73           O
HETATM 6399  O   HOH C3013      62.810  83.849 123.476  1.00 79.70           O
HETATM 6400  O   HOH C3014      98.517 100.974 102.496  1.00 60.60           O
HETATM 6401  O   HOH C3015     100.444 104.686 102.392  1.00 70.53           O
HETATM 6402  O   HOH C3016      99.519  78.224  82.082  1.00 73.28           O
HETATM 6403  O   HOH C3017      77.710  75.911 115.643  1.00 79.19           O
HETATM 6404  O   HOH C3018      98.012 101.740  77.933  1.00 70.68           O
HETATM 6405  O   HOH C3019     109.784  86.457  88.786  1.00 73.80           O
HETATM 6406  O   HOH C3020      86.417  69.450 103.231  1.00 67.58           O
HETATM 6407  O   HOH C3021      66.048  74.017 113.355  1.00 82.04           O
HETATM 6408  O   HOH C3022      72.809  88.474 117.930  1.00 79.79           O
HETATM 6409  O   HOH C3023     101.068  97.475 100.576  1.00 64.18           O
HETATM 6410  O   HOH C3024      97.597  76.858  82.100  1.00 74.78           O
HETATM 6411  O   HOH C3025      72.416  70.895  87.363  1.00 76.43           O
HETATM 6412  O   HOH C3026      47.555  86.054 110.092  1.00 67.24           O
HETATM 6413  O   HOH C3027      81.889  86.261 111.029  1.00 73.51           O
HETATM 6414  O   HOH C3028     125.713  72.824  69.280  1.00 88.69           O
HETATM 6415  O   HOH C3029      62.517  65.752 103.430  1.00 67.73           O
HETATM 6416  O   HOH C3030      76.264 110.043  88.997  1.00 68.07           O
HETATM 6417  O   HOH C3031      94.048  75.346  79.105  1.00 75.55           O
HETATM 6418  O   HOH C3032      64.147 104.990  68.603  1.00 75.14           O
HETATM 6419  O   HOH C3033      61.355  96.619  81.060  1.00 70.15           O
HETATM 6420  O   HOH C3034      81.348  66.781  86.481  1.00 71.78           O
HETATM 6421  O   HOH C3035      80.043 116.392  80.400  1.00 74.36           O
HETATM 6422  O   HOH C3036      85.074 103.428  89.891  1.00 65.52           O
HETATM 6423  O   HOH C3037      83.769 104.999  92.511  1.00 62.63           O
HETATM 6424  O   HOH C3038      91.949  75.344  78.027  1.00 74.35           O
HETATM 6425  O   HOH C3039      51.016  78.559  90.920  1.00 68.91           O
HETATM 6426  O   HOH C3040      34.157  78.741  96.326  1.00 76.25           O
HETATM 6427  O   HOH C3041      89.878  51.794  81.645  1.00 73.94           O
HETATM 6428  O   HOH C3042     104.945  66.107  69.163  1.00 80.81           O
HETATM 6429  O   HOH C3043      59.896 117.301  84.591  1.00 79.75           O
HETATM 6430  O   HOH C3044      96.372  46.538 107.608  1.00 78.14           O
HETATM 6431  O   HOH C3045     110.870  65.954  69.968  1.00 78.66           O
HETATM 6432  O   HOH C3046      66.737 109.644  92.116  1.00 74.38           O
HETATM 6433  O   HOH C3047      71.837 104.687  96.986  1.00 63.66           O
HETATM 6434  O   HOH C3048      76.901  88.488 115.826  1.00 76.15           O
HETATM 6435  O   HOH C3049      87.244  59.438 117.693  1.00 73.69           O
HETATM 6436  O   HOH C3050      91.998  71.329 120.811  1.00 74.57           O
HETATM 6437  O   HOH C3051      74.950  78.229 115.530  1.00 79.96           O
HETATM 6438  O   HOH C3052      95.146  71.226 120.959  1.00 76.11           O
HETATM 6439  O   HOH C3053      79.075  84.240 115.172  1.00 78.24           O
HETATM 6440  O   HOH C3054      98.398  39.050  98.464  1.00 79.87           O
HETATM 6441  O   HOH C3055     110.793  61.384  93.496  1.00 68.59           O
HETATM 6442  O   HOH C3056      75.075  55.932 103.860  1.00 72.65           O
HETATM 6443  O   HOH C3057      38.253 104.626 112.537  1.00 71.97           O
HETATM 6444  O   HOH C3058      84.222  66.352  85.500  1.00 71.17           O
HETATM 6445  O   HOH C3059      78.363 108.048  91.093  1.00 68.62           O
HETATM 6446  O   HOH C3060     132.867  88.046 100.048  1.00 78.46           O
HETATM 6447  O   HOH C3061      60.091 112.206  71.836  1.00 77.26           O
HETATM 6448  O   HOH C3062      38.565 106.148 116.080  1.00 72.49           O
HETATM 6449  O   HOH C3063      89.194 106.520  94.134  1.00 66.97           O
HETATM 6450  O   HOH C3064      50.398 121.589  85.264  1.00 73.71           O
HETATM 6451  O   HOH C3065      59.102  67.127 107.446  1.00 73.98           O
HETATM 6452  O   HOH C3066      73.152 102.744 112.271  1.00 74.28           O
HETATM 6453  O   HOH C3067     107.579  90.929  90.309  1.00 72.31           O
HETATM 6454  O   HOH C3068      61.566 106.749  92.919  1.00 69.27           O
HETATM 6455  O   HOH C3069      87.899  92.206  74.955  1.00 68.18           O
HETATM 6456  O   HOH C3070      86.493  67.516 104.831  1.00 68.69           O
HETATM 6457  O   HOH C3071     108.249  63.731  69.953  1.00 82.57           O
HETATM 6458  O   HOH C3072      98.091  72.949  87.980  1.00 68.73           O
HETATM 6459  O   HOH C3073      65.073  61.594 102.724  1.00 80.34           O
HETATM 6460  O   HOH C3074      63.235  80.554  90.054  1.00 69.29           O
HETATM 6461  O   HOH C3075      96.233  68.690  82.920  1.00 74.44           O
HETATM 6462  O   HOH C3076      99.502  58.140  75.611  1.00 80.98           O
HETATM 6463  O   HOH C3077      57.897  91.014 124.284  1.00 69.70           O
HETATM 6464  O   HOH C3078      66.478  71.362 109.705  1.00 77.17           O
HETATM 6465  O   HOH C3079      91.163  64.771  77.887  1.00 78.37           O
HETATM 6466  O   HOH C3080      61.587  88.446 123.675  1.00 74.47           O
HETATM 6467  O   HOH C3081      65.296 102.312  98.269  1.00 64.19           O
HETATM 6468  O   HOH C3082      57.505 103.427  93.575  1.00 64.28           O
HETATM 6469  O   HOH C3083      61.449 102.996  94.252  1.00 67.91           O
HETATM 6470  O   HOH C3084     104.938  98.348  90.957  1.00 66.77           O
HETATM 6471  O   HOH C3085      72.455  81.015 119.821  1.00 90.10           O
HETATM 6472  O   HOH C3086      89.471  84.319  73.931  1.00 68.01           O
HETATM 6473  O   HOH C3087      77.606  61.187 108.733  1.00 78.58           O
HETATM 6474  O   HOH C3088      75.948 106.524  94.802  1.00 60.91           O
HETATM 6475  O   HOH C3089      64.058  99.178  83.595  1.00 56.26           O
HETATM 6476  O   HOH C3090      75.714  79.709  80.141  1.00 67.06           O
HETATM 6477  O   HOH C3091      75.617  90.231 117.595  1.00 79.08           O
HETATM 6478  O   HOH C3092      45.825 108.956  98.280  1.00 65.47           O
HETATM 6479  O   HOH C3093      78.782 108.299  69.337  1.00 77.83           O
HETATM 6480  O   HOH C3094      68.980 106.959  93.710  1.00 69.90           O
HETATM 6481  O   HOH C3095      54.901  76.784 112.941  1.00 72.84           O
HETATM 6482  O   HOH C3096      91.944  85.442  75.020  1.00 67.00           O
HETATM 6483  O   HOH C3097      86.762  84.608  74.766  1.00 68.91           O
HETATM 6484  O   HOH C3098      55.425 105.381 108.676  1.00 61.69           O
HETATM 6485  O   HOH C3099      66.097 111.901  92.111  1.00 78.54           O
HETATM 6486  O   HOH C3100      57.995  77.274  91.038  1.00 69.60           O
HETATM 6487  O   HOH C3101      82.361  52.693 110.916  1.00 78.83           O
HETATM 6488  O   HOH C3102      76.998  93.062 117.618  1.00 75.57           O
HETATM 6489  O   HOH C3103      93.840  69.511  76.063  1.00 79.80           O
HETATM 6490  O   HOH C3104      54.368  80.894 118.141  1.00 68.20           O
HETATM 6491  O   HOH C3105      88.394  75.395 125.489  1.00 78.01           O
HETATM 6492  O   HOH C3106     127.249  74.706  70.689  1.00 87.44           O
HETATM 6493  O   HOH C3107      58.258  75.340  92.586  1.00 69.66           O
HETATM 6494  O   HOH C3108      80.169  49.466 100.041  1.00 72.26           O
HETATM 6495  O   HOH C3109     130.430  76.958  90.741  1.00 74.52           O
HETATM 6496  O   HOH C3110      95.329 106.939  92.924  1.00 65.91           O
HETATM 6497  O   HOH C3111      74.567  82.345 119.285  1.00 85.53           O
HETATM 6498  O   HOH C3112      64.784 103.514  95.398  1.00 62.37           O
HETATM 6499  O   HOH C3113      52.754 106.287 105.616  1.00 65.04           O
HETATM 6500  O   HOH C3114      69.946  83.475  83.991  1.00 66.78           O
HETATM 6501  O   HOH C3115      53.363  79.601 114.806  1.00 75.57           O
HETATM 6502  O   HOH C3116      36.613 106.181 102.006  1.00 70.87           O
HETATM 6503  O   HOH C3117      59.796 101.744 103.695  1.00 65.94           O
HETATM 6504  O   HOH C3118      84.894  46.181 106.654  1.00 74.28           O
HETATM 6505  O   HOH C3119      70.470  70.260  89.063  1.00 74.58           O
HETATM 6506  O   HOH C3120      79.505  68.741 118.338  1.00 77.54           O
HETATM 6507  O   HOH C3121      70.969  98.556  68.055  1.00 76.93           O
HETATM 6508  O   HOH C3122      57.549 101.823 106.824  1.00 66.53           O
HETATM 6509  O   HOH C3123      93.466  71.584  68.389  1.00 76.59           O
HETATM 6510  O   HOH C3124      76.701  82.795 115.865  1.00 80.49           O
HETATM 6511  O   HOH C3125      58.457  90.661  82.647  1.00 69.02           O
HETATM 6512  O   HOH C3126      69.398 103.921  97.031  1.00 67.59           O
HETATM 6513  O   HOH C3127     115.030  64.526  74.606  1.00 74.95           O
HETATM 6514  O   HOH C3128      68.080  67.462  88.979  1.00 75.60           O
HETATM 6515  O   HOH C3129      85.474 107.897  91.530  1.00 67.32           O
HETATM 6516  O   HOH C3130      96.102  72.004  84.069  1.00 73.09           O
HETATM 6517  O   HOH C3131     127.588  71.116  70.843  1.00 84.57           O
HETATM 6518  O   HOH C3132      73.042 106.899  95.671  1.00 66.37           O
HETATM 6519  O   HOH C3133      89.922  97.547  73.060  1.00 66.09           O
HETATM 6520  O   HOH C3134      78.875  79.496  76.591  1.00 65.00           O
HETATM 6521  O   HOH C3135      66.111  92.391  81.411  1.00 70.16           O
HETATM 6522  O   HOH C3136      92.603 108.222  92.833  1.00 70.08           O
HETATM 6523  O   HOH C3137      68.239 102.774  98.873  1.00 68.06           O
HETATM 6524  O   HOH C3138      93.520  37.809  90.954  1.00 81.05           O
HETATM 6525  O   HOH C3139      38.420 106.116  97.395  1.00 71.63           O
HETATM 6526  O   HOH C3140      59.830 103.944  92.879  1.00 67.93           O
HETATM 6527  O   HOH C3141      91.228 106.142 119.536  1.00 69.42           O
HETATM 6528  O   HOH C3142      89.964 103.406 118.403  1.00 67.36           O
HETATM 6529  O   HOH C3143      76.242  80.292 116.470  1.00 82.38           O
HETATM 6530  O   HOH C3144      73.072  99.934  67.267  1.00 76.76           O
HETATM 6531  O   HOH C3145      95.135  70.702  79.360  1.00 81.23           O
HETATM 6532  O   HOH C3146      94.822  68.679  80.505  1.00 78.85           O
HETATM 6533  O   HOH C3147      56.774 103.655 105.575  1.00 70.97           O
HETATM 6534  O   HOH C3148     100.501  62.836 120.900  1.00 76.36           O
HETATM 6535  O   HOH C3149      76.578  91.353 120.457  1.00 82.00           O
HETATM 6536  O   HOH C3150      77.839  88.823 120.527  1.00 86.74           O
HETATM 6537  O   HOH D2101     136.930 117.676  81.491  1.00 61.29           O
HETATM 6538  O   HOH D2102     144.923 130.555 115.449  1.00 75.23           O
HETATM 6539  O   HOH D2103     101.824 140.929  89.534  1.00 72.37           O
HETATM 6540  O   HOH D2104     126.444 130.509 107.665  1.00 65.23           O
HETATM 6541  O   HOH D2105     115.289 143.351  99.676  1.00 63.53           O
HETATM 6542  O   HOH D2106     124.556 156.231  80.258  1.00 69.06           O
HETATM 6543  O   HOH D2107     130.191 165.145  82.402  1.00 80.32           O
HETATM 6544  O   HOH D2108     173.528 132.179  84.692  1.00 77.02           O
HETATM 6545  O   HOH D2109     157.502 134.725  87.347  1.00 69.14           O
HETATM 6546  O   HOH D2110     146.073 135.044 124.373  1.00 85.56           O
HETATM 6547  O   HOH D2111     143.502 111.375  88.669  1.00 59.28           O
HETATM 6548  O   HOH D2112     122.799 146.564  83.977  1.00 71.09           O
HETATM 6549  O   HOH D2113     139.312 156.208 100.123  1.00 73.20           O
HETATM 6550  O   HOH D2114     127.161 129.958 111.223  1.00 67.42           O
HETATM 6551  O   HOH D2115     140.374 110.349 105.265  1.00 68.72           O
HETATM 6552  O   HOH D2116     112.448 140.597  79.747  1.00 73.78           O
HETATM 6553  O   HOH D2117     168.542 107.330  84.333  1.00 79.87           O
HETATM 6554  O   HOH D2118     111.798 134.368 118.595  1.00 68.09           O
HETATM 6555  O   HOH D2119     122.227 122.191 114.250  1.00 65.53           O
HETATM 6556  O   HOH D2120     136.070 163.118 102.080  1.00 70.82           O
HETATM 6557  O   HOH D2121     129.561 116.091  86.124  1.00 63.12           O
HETATM 6558  O   HOH D2122     108.097 112.146  73.332  1.00 77.35           O
HETATM 6559  O   HOH D2123     138.739 163.368  98.651  1.00 74.87           O
HETATM 6560  O   HOH D2124     179.602 111.280  95.602  1.00 75.73           O
HETATM 6561  O   HOH D2125     113.680 159.408  77.271  1.00 81.01           O
HETATM 6562  O   HOH D2126     110.968 119.335  70.948  1.00 77.73           O
HETATM 6563  O   HOH D2127      93.914 147.863  78.363  1.00 85.14           O
HETATM 6564  O   HOH D2128     146.372 150.939  88.756  1.00 79.15           O
HETATM 6565  O   HOH D2129     143.352 125.936  78.733  1.00 64.96           O
HETATM 6566  O   HOH D2130     151.673 129.074  90.032  1.00 61.46           O
HETATM 6567  O   HOH D2131     135.438 105.555 104.757  1.00 63.75           O
HETATM 6568  O   HOH D2132     146.948 112.568  91.621  1.00 51.72           O
HETATM 6569  O   HOH D2133     182.249 119.364  92.934  1.00 77.44           O
HETATM 6570  O   HOH D2134     163.616 109.051  89.036  1.00 70.43           O
HETATM 6571  O   HOH D2135     133.151 135.606 108.680  1.00 66.01           O
HETATM 6572  O   HOH D2136     114.767 172.117 100.764  1.00 76.15           O
HETATM 6573  O   HOH D2137     129.374 147.945  97.621  1.00 63.41           O
HETATM 6574  O   HOH D2138     120.884 144.240  91.542  1.00 64.86           O
HETATM 6575  O   HOH D2139     148.142 138.635 124.313  1.00 91.18           O
HETATM 6576  O   HOH D2140     116.047 132.176  69.884  1.00 77.39           O
HETATM 6577  O   HOH D2141     117.145 132.498 120.902  1.00 75.13           O
HETATM 6578  O   HOH D2142     143.123 118.461 109.306  1.00 69.23           O
HETATM 6579  O   HOH D2143     126.488 107.246 113.726  1.00 60.63           O
HETATM 6580  O   HOH D2144     130.700 156.925  94.038  1.00 67.24           O
HETATM 6581  O   HOH D2145      92.785 132.154  80.416  1.00 76.56           O
HETATM 6582  O   HOH D2146     124.179 156.177 117.250  1.00 75.09           O
HETATM 6583  O   HOH D2147     113.454 114.798  99.598  1.00 66.50           O
HETATM 6584  O   HOH D2148     119.779 138.620  84.946  1.00 67.76           O
HETATM 6585  O   HOH D2149     106.178 167.673  96.214  1.00 73.71           O
HETATM 6586  O   HOH D2150      89.285 134.313  80.443  1.00 77.01           O
HETATM 6587  O   HOH D2151     167.482 130.729 122.763  1.00 73.82           O
HETATM 6588  O   HOH D2152     104.489 130.764  89.784  1.00 67.42           O
HETATM 6589  O   HOH D2153     116.680 168.951  91.988  1.00 73.42           O
HETATM 6590  O   HOH D2154     178.400 113.713 113.416  1.00 70.38           O
HETATM 6591  O   HOH D2155     178.102 138.467  95.760  1.00 71.57           O
HETATM 6592  O   HOH D2156     115.026 117.849  71.138  1.00 76.75           O
HETATM 6593  O   HOH D2157     118.033 171.141 106.693  1.00 80.54           O
HETATM 6594  O   HOH D2158     166.015 124.407 104.702  1.00 59.37           O
HETATM 6595  O   HOH D2159     131.624 147.136 116.414  1.00 72.73           O
HETATM 6596  O   HOH D2160     130.087 138.471  77.194  1.00 69.61           O
HETATM 6597  O   HOH D2161     182.100 107.222 104.247  1.00 72.84           O
HETATM 6598  O   HOH D2162     131.125 142.564  96.722  1.00 66.14           O
HETATM 6599  O   HOH D2163     110.529 120.217  87.527  1.00 71.19           O
HETATM 6600  O   HOH D2164     177.743 123.041 106.862  1.00 66.26           O
HETATM 6601  O   HOH D2165     112.946 121.240 107.742  1.00 64.45           O
HETATM 6602  O   HOH D2166     100.137 120.217  82.309  1.00 79.28           O
HETATM 6603  O   HOH D2167     145.154 126.216 110.075  1.00 72.35           O
HETATM 6604  O   HOH D2168     108.383 163.286 112.482  1.00 74.59           O
HETATM 6605  O   HOH D2169     145.436 111.899  67.721  1.00 73.23           O
HETATM 6606  O   HOH D2170     152.659 114.683 117.593  1.00 66.14           O
HETATM 6607  O   HOH D2171     169.284 119.566 109.019  1.00 61.21           O
HETATM 6608  O   HOH D2172     144.417 134.367  84.628  1.00 64.17           O
HETATM 6609  O   HOH D2173     133.611 134.374  98.343  1.00 59.35           O
HETATM 6610  O   HOH D2174     114.736 145.106  88.068  1.00 69.35           O
HETATM 6611  O   HOH D2175     149.626 138.102 113.433  1.00 79.35           O
HETATM 6612  O   HOH D2176     170.229 120.950 127.461  1.00 74.70           O
HETATM 6613  O   HOH D2177     161.260 131.128 124.766  1.00 73.58           O
HETATM 6614  O   HOH D2178     168.177 109.173  95.663  1.00 66.76           O
HETATM 6615  O   HOH D2179     152.103 113.173 113.675  1.00 65.88           O
HETATM 6616  O   HOH D2180     143.847 136.223 118.433  1.00 86.93           O
HETATM 6617  O   HOH D2181     147.648 120.885  74.836  1.00 71.62           O
HETATM 6618  O   HOH D2182     171.471 117.422  84.602  1.00 63.67           O
HETATM 6619  O   HOH D2183     152.871  98.597  83.688  1.00 80.96           O
HETATM 6620  O   HOH D2184     151.058 123.793  86.426  1.00 59.45           O
HETATM 6621  O   HOH D2185     142.822 122.535 115.138  1.00 70.13           O
HETATM 6622  O   HOH D2186     129.978 135.796  76.905  1.00 68.37           O
HETATM 6623  O   HOH D2187     127.478 158.801 116.651  1.00 72.65           O
HETATM 6624  O   HOH D2188     160.420 128.648  81.155  1.00 68.19           O
HETATM 6625  O   HOH D2189      98.265 138.916  90.052  1.00 74.39           O
HETATM 6626  O   HOH D2190     110.406 151.515  70.543  1.00 82.87           O
HETATM 6627  O   HOH D2191     107.231 154.353  93.340  1.00 63.77           O
HETATM 6628  O   HOH D2192     162.783 132.598  93.122  1.00 66.09           O
HETATM 6629  O   HOH D2193     107.710 134.890  92.710  1.00 65.27           O
HETATM 6630  O   HOH D2194     131.107 167.975 100.385  1.00 72.24           O
HETATM 6631  O   HOH D2195     126.851 164.526  85.463  1.00 75.68           O
HETATM 6632  O   HOH D2196     122.514 115.602 111.931  1.00 66.13           O
HETATM 6633  O   HOH D2197     138.873 123.115  74.426  1.00 68.54           O
HETATM 6634  O   HOH D2198     174.184 108.336 109.125  1.00 61.29           O
HETATM 6635  O   HOH D2199     115.129 146.387  83.647  1.00 73.21           O
HETATM 6636  O   HOH D2200     106.930 156.883  92.882  1.00 66.46           O
HETATM 6637  O   HOH D2201     129.141 124.636 110.179  1.00 64.85           O
HETATM 6638  O   HOH D2202     137.489 117.373  78.823  1.00 64.56           O
HETATM 6639  O   HOH D2203     152.359 114.041  92.808  1.00 57.55           O
HETATM 6640  O   HOH D2204     163.360 112.361 120.298  1.00 71.71           O
HETATM 6641  O   HOH D2205     143.430 138.268 114.571  1.00 83.54           O
HETATM 6642  O   HOH D2206     140.124 144.787  85.288  1.00 72.53           O
HETATM 6643  O   HOH D2207     168.614 125.472  82.916  1.00 66.42           O
HETATM 6644  O   HOH D2208     135.254 122.342  95.046  1.00 47.56           O
HETATM 6645  O   HOH D2209     124.370 129.506 104.840  1.00 62.54           O
HETATM 6646  O   HOH D2210     129.479 143.398 104.941  1.00 66.01           O
HETATM 6647  O   HOH D2211     118.670 125.850 116.197  1.00 62.26           O
HETATM 6648  O   HOH D2212     127.836 144.338  79.806  1.00 72.63           O
HETATM 6649  O   HOH D2213     139.639 110.870 102.511  1.00 59.71           O
HETATM 6650  O   HOH D2214     105.160 163.984  84.809  1.00 73.26           O
HETATM 6651  O   HOH D2215     171.091 127.884  86.119  1.00 70.14           O
HETATM 6652  O   HOH D2216     161.582 127.897  94.832  1.00 57.59           O
HETATM 6653  O   HOH D2217     145.349 144.009  94.733  1.00 66.36           O
HETATM 6654  O   HOH D2218     119.030 106.323  96.482  1.00 70.27           O
HETATM 6655  O   HOH D2219     141.398 127.899  70.504  1.00 71.96           O
HETATM 6656  O   HOH D2220     107.002 151.046 103.015  1.00 64.53           O
HETATM 6657  O   HOH D2221     130.225 126.987 120.833  1.00 79.80           O
HETATM 6658  O   HOH D2222     156.126 110.631  82.111  1.00 60.12           O
HETATM 6659  O   HOH D2223     107.138 164.528  97.313  1.00 70.04           O
HETATM 6660  O   HOH D2224     156.576 129.462  92.998  1.00 59.45           O
HETATM 6661  O   HOH D2225     131.365 138.165 108.843  1.00 64.67           O
HETATM 6662  O   HOH D2226     144.458 128.103 117.534  1.00 78.84           O
HETATM 6663  O   HOH D2227     114.704 112.933  74.922  1.00 77.97           O
HETATM 6664  O   HOH D2228     110.901 113.174  86.445  1.00 77.73           O
HETATM 6665  O   HOH D2229     126.045 142.217  78.128  1.00 70.88           O
HETATM 6666  O   HOH D2230     143.138 128.249  82.387  1.00 63.95           O
HETATM 6667  O   HOH D2231     175.712 137.773  94.241  1.00 71.88           O
HETATM 6668  O   HOH D2232     102.992 153.234  90.133  1.00 71.86           O
HETATM 6669  O   HOH D2233     120.745 145.339  85.366  1.00 71.75           O
HETATM 6670  O   HOH D2234     180.595 132.228 104.612  1.00 69.90           O
HETATM 6671  O   HOH D2235     113.781 148.603  71.147  1.00 79.38           O
HETATM 6672  O   HOH D2236     126.253 123.932 100.509  1.00 54.55           O
HETATM 6673  O   HOH D2237     150.113 125.399 109.007  1.00 66.57           O
HETATM 6674  O   HOH D2238     137.063 146.284  84.471  1.00 70.24           O
HETATM 6675  O   HOH D2239     115.064 115.062  76.811  1.00 71.56           O
HETATM 6676  O   HOH D2240     165.793 110.877 103.724  1.00 60.56           O
HETATM 6677  O   HOH D2241     153.431 113.826 100.420  1.00 63.45           O
HETATM 6678  O   HOH D2242     109.621 123.416 107.940  1.00 58.97           O
HETATM 6679  O   HOH D2243     117.348 123.409  78.275  1.00 59.94           O
HETATM 6680  O   HOH D2244     108.215 140.933  65.433  1.00 78.84           O
HETATM 6681  O   HOH D2245     151.396 114.616 115.400  1.00 67.98           O
HETATM 6682  O   HOH D2246     180.423 129.462 109.962  1.00 77.97           O
HETATM 6683  O   HOH D2247     124.312 127.879  76.514  1.00 60.67           O
HETATM 6684  O   HOH D2248     145.219 125.686  86.535  1.00 57.48           O
HETATM 6685  O   HOH D2249     147.200 145.794 108.420  1.00 76.22           O
HETATM 6686  O   HOH D2250     154.351 132.406 121.581  1.00 72.70           O
HETATM 6687  O   HOH D2251     141.703 156.336 106.879  1.00 74.42           O
HETATM 6688  O   HOH D2252      91.925 138.784  78.373  1.00 80.68           O
HETATM 6689  O   HOH D2253     153.744 119.350 118.278  1.00 66.89           O
HETATM 6690  O   HOH D2254     155.606 134.764 107.151  1.00 63.47           O
HETATM 6691  O   HOH D2255     139.104 104.461  86.492  1.00 66.79           O
HETATM 6692  O   HOH D2256     128.160 144.320  91.778  1.00 65.62           O
HETATM 6693  O   HOH D2257     120.843 167.842 105.976  1.00 73.79           O
HETATM 6694  O   HOH D2258     155.530 137.330  98.898  1.00 59.46           O
HETATM 6695  O   HOH D2259     131.193 156.494 111.352  1.00 72.80           O
HETATM 6696  O   HOH D2260     147.904 127.240  89.681  1.00 55.53           O
HETATM 6697  O   HOH D2261     156.821 149.777  96.388  1.00 81.59           O
HETATM 6698  O   HOH D2262     159.910 115.033 115.444  1.00 62.12           O
HETATM 6699  O   HOH D2263     138.258 123.151 110.131  1.00 65.54           O
HETATM 6700  O   HOH D2264     149.810 123.510 116.768  1.00 66.43           O
HETATM 6701  O   HOH D2265     110.430 145.476  96.267  1.00 65.92           O
HETATM 6702  O   HOH D2266     158.609 112.138  83.908  1.00 62.26           O
HETATM 6703  O   HOH D2267     132.454 136.853 103.171  1.00 67.46           O
HETATM 6704  O   HOH D2268     161.262 105.858  92.323  1.00 71.39           O
HETATM 6705  O   HOH D2269     150.110 120.487  93.721  1.00 54.33           O
HETATM 6706  O   HOH D2270     131.704 111.041  79.492  1.00 68.73           O
HETATM 6707  O   HOH D2271     125.996 161.258  82.843  1.00 74.84           O
HETATM 6708  O   HOH D2272     132.581 123.079  84.614  1.00 57.23           O
HETATM 6709  O   HOH D2273     139.448 136.283  99.140  1.00 63.39           O
HETATM 6710  O   HOH D2274     121.744 172.072  84.283  1.00 77.80           O
HETATM 6711  O   HOH D2275      90.254 138.359  83.273  1.00 78.92           O
HETATM 6712  O   HOH D2276     105.612 158.093  81.733  1.00 75.09           O
HETATM 6713  O   HOH D2277     125.878 152.326 116.552  1.00 74.37           O
HETATM 6714  O   HOH D2278     120.189 108.533  89.892  1.00 63.79           O
HETATM 6715  O   HOH D2279     140.211 153.114  92.351  1.00 75.58           O
HETATM 6716  O   HOH D2280     136.747 112.152  71.782  1.00 74.62           O
HETATM 6717  O   HOH D2281     131.143 136.123 106.372  1.00 63.80           O
HETATM 6718  O   HOH D2282     127.232 118.296  86.255  1.00 60.57           O
HETATM 6719  O   HOH D2283     139.903 149.452  85.324  1.00 72.46           O
HETATM 6720  O   HOH D2284     118.302 138.503  87.904  1.00 61.21           O
HETATM 6721  O   HOH D2285     103.759 154.160  96.959  1.00 65.07           O
HETATM 6722  O   HOH D2286     117.086 146.609  97.566  1.00 62.30           O
HETATM 6723  O   HOH D2287     130.706 113.924  88.703  1.00 61.07           O
HETATM 6724  O   HOH D2288     176.291 119.033 112.635  1.00 67.35           O
HETATM 6725  O   HOH D2289     109.793 146.094  99.243  1.00 67.17           O
HETATM 6726  O   HOH D2290     129.216 107.652 107.654  1.00 60.91           O
HETATM 6727  O   HOH D2291     141.757 112.610  96.117  1.00 57.82           O
HETATM 6728  O   HOH D2292     119.790 163.208  78.835  1.00 73.46           O
HETATM 6729  O   HOH D2293     147.394 118.823 105.991  1.00 61.74           O
HETATM 6730  O   HOH D2294     164.205 113.290 102.263  1.00 60.90           O
HETATM 6731  O   HOH D2295     119.916 150.211  99.363  1.00 60.81           O
HETATM 6732  O   HOH D2296     116.785 141.564 118.938  1.00 66.95           O
HETATM 6733  O   HOH D2297     155.291 138.128 106.607  1.00 64.46           O
HETATM 6734  O   HOH D2298     134.817 147.733 114.304  1.00 76.88           O
HETATM 6735  O   HOH D2299     126.847 126.757 112.303  1.00 68.55           O
HETATM 6736  O   HOH D2300     121.112 137.687 114.499  1.00 66.08           O
HETATM 6737  O   HOH D2301     114.536 135.488  87.224  1.00 59.44           O
HETATM 6738  O   HOH D2302     115.765 173.002  98.310  1.00 77.11           O
HETATM 6739  O   HOH D2303     152.363 105.077  70.213  1.00 75.34           O
HETATM 6740  O   HOH D2304     143.606 119.482 115.547  1.00 69.99           O
HETATM 6741  O   HOH D2305     125.195 141.285 122.653  1.00 73.77           O
HETATM 6742  O   HOH D2306     107.816 151.484  84.492  1.00 69.59           O
HETATM 6743  O   HOH D2307     115.869 112.525 100.897  1.00 67.74           O
HETATM 6744  O   HOH D2308     136.159 148.046 112.380  1.00 79.56           O
HETATM 6745  O   HOH D2309     143.943 120.908  69.293  1.00 71.61           O
HETATM 6746  O   HOH D2310     141.956 117.676 104.627  1.00 61.22           O
HETATM 6747  O   HOH D2311     124.644 118.303 114.829  1.00 67.13           O
HETATM 6748  O   HOH D2312     147.907 120.681 113.118  1.00 66.12           O
HETATM 6749  O   HOH D2313     128.698 120.846  76.414  1.00 66.76           O
HETATM 6750  O   HOH D2314     167.941 113.815 100.182  1.00 63.15           O
HETATM 6751  O   HOH D2315     113.515 121.591  89.892  1.00 59.92           O
HETATM 6752  O   HOH D2316     126.321 110.977  94.990  1.00 62.92           O
HETATM 6753  O   HOH D2317      81.899 135.029  97.317  1.00 77.82           O
HETATM 6754  O   HOH D2318     115.033 120.174 106.858  1.00 63.52           O
HETATM 6755  O   HOH D2319     113.915 144.387 119.164  1.00 68.30           O
HETATM 6756  O   HOH D2320     144.079 153.468  96.348  1.00 75.11           O
HETATM 6757  O   HOH D2321     131.488 152.104  86.485  1.00 68.67           O
HETATM 6758  O   HOH D2322     145.955 130.091  97.630  1.00 61.40           O
HETATM 6759  O   HOH D2323     123.234 145.784  87.112  1.00 68.97           O
HETATM 6760  O   HOH D2324     135.230 118.606 111.767  1.00 64.21           O
HETATM 6761  O   HOH D2325      96.171 128.447  79.198  1.00 74.91           O
HETATM 6762  O   HOH D2326     158.791 117.094 118.134  1.00 65.15           O
HETATM 6763  O   HOH D2327     139.277 129.895  71.244  1.00 72.92           O
HETATM 6764  O   HOH D2328     137.811 122.774 105.259  1.00 58.99           O
HETATM 6765  O   HOH D2329     177.928 126.674 115.503  1.00 75.89           O
HETATM 6766  O   HOH D2330     113.847 145.048  85.101  1.00 71.10           O
HETATM 6767  O   HOH D2331     177.446 130.464  94.170  1.00 69.33           O
HETATM 6768  O   HOH D2332     113.626 124.593  84.580  1.00 63.85           O
HETATM 6769  O   HOH D2333     181.654 135.287  94.388  1.00 75.81           O
HETATM 6770  O   HOH D2334     125.949 148.300 105.187  1.00 64.83           O
HETATM 6771  O   HOH D2335     135.134 124.762  68.309  1.00 72.02           O
HETATM 6772  O   HOH D2336     157.817 112.272 109.721  1.00 61.42           O
HETATM 6773  O   HOH D2337     116.347 117.336 102.395  1.00 60.96           O
HETATM 6774  O   HOH D2338     112.428 122.267  87.479  1.00 64.10           O
HETATM 6775  O   HOH D2339     117.033 146.329 105.815  1.00 64.21           O
HETATM 6776  O   HOH D2340     134.893 108.207  89.582  1.00 65.09           O
HETATM 6777  O   HOH D2341     136.659 138.827  79.659  1.00 68.81           O
HETATM 6778  O   HOH D2342     159.952 107.429 114.550  1.00 67.27           O
HETATM 6779  O   HOH D2343     169.737 128.403 109.050  1.00 65.67           O
HETATM 6780  O   HOH D2344     144.726 150.841 110.310  1.00 76.36           O
HETATM 6781  O   HOH D2345     120.282 133.612  80.606  1.00 66.49           O
HETATM 6782  O   HOH D2346     113.830 152.416 115.391  1.00 69.53           O
HETATM 6783  O   HOH D2347     127.856 111.869  90.930  1.00 61.46           O
HETATM 6784  O   HOH D2348     111.391 147.227  70.964  1.00 76.30           O
HETATM 6785  O   HOH D2349     141.878 113.546  90.589  1.00 52.38           O
HETATM 6786  O   HOH D2350     118.840 139.827  99.591  1.00 60.75           O
HETATM 6787  O   HOH D2351     149.829 114.775  89.069  1.00 52.45           O
HETATM 6788  O   HOH D2352     127.773 145.887 108.844  1.00 67.99           O
HETATM 6789  O   HOH D2353     136.505 140.373 113.308  1.00 72.80           O
HETATM 6790  O   HOH D2354     121.407 125.098 109.565  1.00 60.46           O
HETATM 6791  O   HOH D2355     100.585 148.614  70.939  1.00 78.12           O
HETATM 6792  O   HOH D2356     128.040 170.982 105.184  1.00 71.57           O
HETATM 6793  O   HOH D2357     163.267 126.307 126.409  1.00 75.68           O
HETATM 6794  O   HOH D2358     127.646 150.835 103.377  1.00 64.65           O
HETATM 6795  O   HOH D2359     108.066 119.507  71.107  1.00 76.31           O
HETATM 6796  O   HOH D2360     162.335 109.619 110.051  1.00 62.82           O
HETATM 6797  O   HOH D2361     116.769 137.500 119.951  1.00 70.35           O
HETATM 6798  O   HOH D2362     119.338 148.853  95.647  1.00 63.63           O
HETATM 6799  O   HOH D2363      96.771 143.744  88.661  1.00 79.33           O
HETATM 6800  O   HOH D2364     155.459 116.099 105.813  1.00 61.11           O
HETATM 6801  O   HOH D2365     128.257 128.088  76.311  1.00 64.80           O
HETATM 6802  O   HOH D2366     138.044 143.710 112.825  1.00 76.37           O
HETATM 6803  O   HOH D2367     114.544 142.803  88.600  1.00 68.76           O
HETATM 6804  O   HOH D2368     157.215 135.665  90.842  1.00 66.45           O
HETATM 6805  O   HOH D2369     113.795 125.684  89.123  1.00 59.39           O
HETATM 6806  O   HOH D2370     111.933 144.235 110.506  1.00 63.97           O
HETATM 6807  O   HOH D2371     111.434 173.037  93.504  1.00 78.94           O
HETATM 6808  O   HOH D2372     109.568 154.438  74.900  1.00 75.88           O
HETATM 6809  O   HOH D2373     145.146 134.006  98.874  1.00 63.80           O
HETATM 6810  O   HOH D2374     138.587 162.417  96.261  1.00 73.96           O
HETATM 6811  O   HOH D2375     155.505 117.736 120.475  1.00 67.83           O
HETATM 6812  O   HOH D2376     138.291 124.898 113.742  1.00 72.38           O
HETATM 6813  O   HOH D2377     104.883 128.560  86.330  1.00 72.31           O
HETATM 6814  O   HOH D2378     109.147 123.298  65.380  1.00 79.93           O
HETATM 6815  O   HOH D2379     118.242 128.853  72.275  1.00 72.43           O
HETATM 6816  O   HOH D2380     138.391 117.004  83.703  1.00 53.68           O
HETATM 6817  O   HOH D2381     160.658 110.609  84.255  1.00 69.06           O
HETATM 6818  O   HOH D2382     132.681 108.243  92.845  1.00 64.83           O
HETATM 6819  O   HOH D2383     118.556 131.406  74.670  1.00 69.28           O
HETATM 6820  O   HOH D2384     116.496 128.835 117.706  1.00 66.73           O
HETATM 6821  O   HOH D2385     148.562 129.659 104.561  1.00 64.99           O
HETATM 6822  O   HOH D2386     108.942 140.897  98.417  1.00 63.78           O
HETATM 6823  O   HOH D2387     139.249 105.007  70.955  1.00 75.11           O
HETATM 6824  O   HOH D2388     150.313 132.461  88.402  1.00 66.30           O
HETATM 6825  O   HOH D2389     137.827 113.553 116.141  1.00 72.78           O
HETATM 6826  O   HOH D2390      87.345 134.658  89.526  1.00 75.79           O
HETATM 6827  O   HOH D2391     146.596 136.137 102.875  1.00 70.09           O
HETATM 6828  O   HOH D2392     172.763 129.546 106.197  1.00 66.35           O
HETATM 6829  O   HOH D2393     150.346 134.581 102.521  1.00 66.11           O
HETATM 6830  O   HOH D2394     100.074 125.560  73.827  1.00 78.81           O
HETATM 6831  O   HOH D2395      85.197 125.411 100.820  1.00 72.48           O
HETATM 6832  O   HOH D2396     134.795 122.451  83.630  1.00 56.38           O
HETATM 6833  O   HOH D2397     129.626 135.215  92.610  1.00 58.56           O
HETATM 6834  O   HOH D2398     126.293 121.125 114.496  1.00 66.15           O
HETATM 6835  O   HOH D2399     166.017 117.911 125.213  1.00 74.10           O
HETATM 6836  O   HOH D2400     160.332 111.954  93.459  1.00 63.54           O
HETATM 6837  O   HOH D2401     137.586 137.004 100.410  1.00 64.58           O
HETATM 6838  O   HOH D2402     122.408 118.631  79.859  1.00 58.74           O
HETATM 6839  O   HOH D2403     114.756 134.258 121.152  1.00 71.61           O
HETATM 6840  O   HOH D2404     129.754 145.434  81.913  1.00 74.38           O
HETATM 6841  O   HOH D2405     178.264 120.884 109.757  1.00 67.76           O
HETATM 6842  O   HOH D2406     102.422 155.523  86.818  1.00 72.04           O
HETATM 6843  O   HOH D2407     100.016 130.607  70.280  1.00 74.86           O
HETATM 6844  O   HOH D2408     148.940 152.057 104.504  1.00 75.27           O
HETATM 6845  O   HOH D2409     119.312 149.213  86.422  1.00 64.25           O
HETATM 6846  O   HOH D2410     149.781 144.627  93.199  1.00 67.39           O
HETATM 6847  O   HOH D2411     114.071 136.479 120.554  1.00 70.64           O
HETATM 6848  O   HOH D2412     134.400 128.276  70.589  1.00 72.75           O
HETATM 6849  O   HOH D2413     139.252 122.894 115.399  1.00 73.74           O
HETATM 6850  O   HOH D2414     166.396 126.895 112.389  1.00 65.10           O
HETATM 6851  O   HOH D2415     113.322 120.854  94.497  1.00 57.69           O
HETATM 6852  O   HOH D2416     113.758 120.705  71.231  1.00 71.65           O
HETATM 6853  O   HOH D2417      83.658 136.034  94.183  1.00 74.94           O
HETATM 6854  O   HOH D2418     110.600 128.796  90.235  1.00 63.12           O
HETATM 6855  O   HOH D2419     125.870 169.285  86.381  1.00 74.74           O
HETATM 6856  O   HOH D2420     109.948 127.840  63.622  1.00 78.56           O
HETATM 6857  O   HOH D2421     143.323  99.766  73.801  1.00 82.40           O
HETATM 6858  O   HOH D2422     124.536 128.107 102.484  1.00 59.82           O
HETATM 6859  O   HOH D2423     189.258 118.018 115.568  1.00 78.74           O
HETATM 6860  O   HOH D2424     121.223 170.107 110.063  1.00 78.79           O
HETATM 6861  O   HOH D2425     132.389 167.373 103.244  1.00 66.63           O
HETATM 6862  O   HOH D2426     134.437 152.028  92.214  1.00 68.15           O
HETATM 6863  O   HOH D2427     146.689 141.084  92.047  1.00 66.13           O
HETATM 6864  O   HOH D2428     130.258 116.789 100.730  1.00 52.02           O
HETATM 6865  O   HOH D2429     161.476 114.223  98.884  1.00 62.00           O
HETATM 6866  O   HOH D2430     133.105 166.314  96.236  1.00 74.32           O
HETATM 6867  O   HOH D2431     103.373 125.394  97.060  1.00 66.87           O
HETATM 6868  O   HOH D2432     129.249 111.844 119.108  1.00 66.37           O
HETATM 6869  O   HOH D2433     127.929 112.720  94.057  1.00 58.91           O
HETATM 6870  O   HOH D2434     123.467 161.089 111.580  1.00 71.99           O
HETATM 6871  O   HOH D2435     158.740 143.022  95.681  1.00 71.39           O
HETATM 6872  O   HOH D2436     115.526 139.062  79.806  1.00 76.70           O
HETATM 6873  O   HOH D2437     133.832 119.933  82.026  1.00 62.68           O
HETATM 6874  O   HOH D2438     167.631 119.285 126.994  1.00 73.37           O
HETATM 6875  O   HOH D2439     151.032 132.062 103.365  1.00 66.29           O
HETATM 6876  O   HOH D2440     123.109 111.081  81.050  1.00 70.54           O
HETATM 6877  O   HOH D2441     123.109 167.483  88.423  1.00 70.95           O
HETATM 6878  O   HOH D2442     145.430 128.199 111.486  1.00 70.88           O
HETATM 6879  O   HOH D2443     105.208 134.813  72.293  1.00 73.60           O
HETATM 6880  O   HOH D2444     129.557 119.204  85.886  1.00 59.37           O
HETATM 6881  O   HOH D2445     137.707 107.873  96.648  1.00 59.68           O
HETATM 6882  O   HOH D2446     118.710 141.606  77.906  1.00 78.06           O
HETATM 6883  O   HOH D2447     118.029 110.276  84.480  1.00 64.67           O
HETATM 6884  O   HOH D2448      96.972 131.758  86.860  1.00 75.35           O
HETATM 6885  O   HOH D2449     175.296 111.858 109.847  1.00 61.55           O
HETATM 6886  O   HOH D2450     139.889 111.544  94.478  1.00 57.72           O
HETATM 6887  O   HOH D2451     138.989 121.790  82.429  1.00 56.54           O
HETATM 6888  O   HOH D2452     141.590 111.008  92.413  1.00 61.81           O
HETATM 6889  O   HOH D2453     130.195 123.163  79.929  1.00 63.59           O
HETATM 6890  O   HOH D2454     178.708 111.655 103.740  1.00 65.72           O
HETATM 6891  O   HOH D2455     111.074 114.986  69.615  1.00 80.11           O
HETATM 6892  O   HOH D2456     160.440 130.437 100.645  1.00 61.24           O
HETATM 6893  O   HOH D2457     132.577 151.440 117.683  1.00 76.00           O
HETATM 6894  O   HOH D2458     128.689 136.858  95.654  1.00 61.70           O
HETATM 6895  O   HOH D2459      93.693 132.043  89.230  1.00 79.04           O
HETATM 6896  O   HOH D2460     113.572 157.155  73.892  1.00 82.33           O
HETATM 6897  O   HOH D2461     118.988 112.598  82.566  1.00 63.69           O
HETATM 6898  O   HOH D2462     145.124 106.596  89.929  1.00 65.10           O
HETATM 6899  O   HOH D2463     155.600 125.878 122.598  1.00 71.09           O
HETATM 6900  O   HOH D2464     131.708 103.973  77.692  1.00 71.35           O
HETATM 6901  O   HOH D2465     129.081 139.020  89.668  1.00 62.91           O
HETATM 6902  O   HOH D2466     172.884 125.033  85.192  1.00 65.89           O
HETATM 6903  O   HOH D2467     164.369 131.559 101.509  1.00 64.38           O
HETATM 6904  O   HOH D2468     148.967 124.669 122.102  1.00 76.57           O
HETATM 6905  O   HOH D2469     121.154 108.097 109.992  1.00 64.55           O
HETATM 6906  O   HOH D2470     179.026 112.969 115.537  1.00 70.51           O
HETATM 6907  O   HOH D2471     163.013 130.796 109.171  1.00 66.65           O
HETATM 6908  O   HOH D2472     111.848 147.516  93.529  1.00 64.01           O
HETATM 6909  O   HOH D2473     155.896 119.524 111.972  1.00 58.74           O
HETATM 6910  O   HOH D2474     109.818 150.838 117.662  1.00 65.95           O
HETATM 6911  O   HOH D2475     138.944 108.140  91.887  1.00 65.15           O
HETATM 6912  O   HOH D2476     125.280 165.852  94.008  1.00 68.19           O
HETATM 6913  O   HOH D2477     100.358 152.680  77.412  1.00 79.38           O
HETATM 6914  O   HOH D2478     139.684 141.445 115.046  1.00 80.80           O
HETATM 6915  O   HOH D2479     108.569 126.404  91.276  1.00 62.92           O
HETATM 6916  O   HOH D2480     131.013 128.228 111.349  1.00 71.61           O
HETATM 6917  O   HOH D2481     121.067 147.883 103.430  1.00 62.87           O
HETATM 6918  O   HOH D2482     148.477 127.240 113.299  1.00 68.47           O
HETATM 6919  O   HOH D2483     114.790 110.190  77.422  1.00 78.45           O
HETATM 6920  O   HOH D2484     161.446 144.233 105.359  1.00 71.28           O
HETATM 6921  O   HOH D2485     142.367 109.352  88.892  1.00 61.60           O
HETATM 6922  O   HOH D2486     117.056 119.150 111.912  1.00 64.66           O
HETATM 6923  O   HOH D2487     162.573 143.976 103.333  1.00 68.46           O
HETATM 6924  O   HOH D2488     122.250 117.838  75.006  1.00 64.60           O
HETATM 6925  O   HOH D2489     106.786 140.548 112.864  1.00 62.42           O
HETATM 6926  O   HOH D2490     151.819 144.359  95.975  1.00 67.93           O
HETATM 6927  O   HOH D2491     116.145 133.392  82.643  1.00 65.83           O
HETATM 6928  O   HOH D2492     142.235 138.989 112.559  1.00 78.02           O
HETATM 6929  O   HOH D2493     106.472 160.722  97.101  1.00 69.29           O
HETATM 6930  O   HOH D2494     169.629 126.879 112.900  1.00 68.69           O
HETATM 6931  O   HOH D2495     105.654 152.417 100.518  1.00 64.89           O
HETATM 6932  O   HOH D2496     186.054 112.708 110.431  1.00 72.76           O
HETATM 6933  O   HOH D2497     140.364 102.343  73.665  1.00 77.18           O
HETATM 6934  O   HOH D2498     105.186 146.132  86.801  1.00 71.35           O
HETATM 6935  O   HOH D2499     131.965 118.600  73.772  1.00 72.39           O
HETATM 6936  O   HOH D2500     184.511 133.418 103.104  1.00 71.01           O
HETATM 6937  O   HOH D2501     122.312 151.140  91.566  1.00 63.14           O
HETATM 6938  O   HOH D2502     158.687 112.658 118.408  1.00 66.50           O
HETATM 6939  O   HOH D2503     106.483 164.770 100.110  1.00 72.60           O
HETATM 6940  O   HOH D2504     141.107 142.317  88.214  1.00 68.51           O
HETATM 6941  O   HOH D2505     135.196 145.950  87.473  1.00 72.17           O
HETATM 6942  O   HOH D2506     123.690 146.592 121.928  1.00 78.16           O
HETATM 6943  O   HOH D2507     121.176 117.170  81.560  1.00 56.56           O
HETATM 6944  O   HOH D2508     144.413 120.679 106.071  1.00 63.57           O
HETATM 6945  O   HOH D2509     159.998 125.010 113.561  1.00 60.53           O
HETATM 6946  O   HOH D2510     148.769 140.324  91.217  1.00 68.02           O
HETATM 6947  O   HOH D2511     146.931 126.520 124.093  1.00 81.61           O
HETATM 6948  O   HOH D2512      87.653 138.771  73.464  1.00 85.61           O
HETATM 6949  O   HOH D2513     171.634 113.137 115.477  1.00 64.16           O
HETATM 6950  O   HOH D2514      90.565 138.447  90.239  1.00 74.09           O
HETATM 6951  O   HOH D2515     133.627 122.253  71.227  1.00 69.22           O
HETATM 6952  O   HOH D2516     128.673 146.372 106.760  1.00 68.24           O
HETATM 6953  O   HOH D2517     172.129 140.088 100.935  1.00 68.55           O
HETATM 6954  O   HOH D2518     120.863 134.267 107.407  1.00 60.64           O
HETATM 6955  O   HOH D2519     155.945 136.153 113.069  1.00 69.59           O
HETATM 6956  O   HOH D2520     112.451 170.944  97.076  1.00 77.31           O
HETATM 6957  O   HOH D2521     139.901 111.255 113.780  1.00 70.11           O
HETATM 6958  O   HOH D2522     148.625 128.715  96.676  1.00 58.86           O
HETATM 6959  O   HOH D2523     120.924 153.425  77.241  1.00 70.77           O
HETATM 6960  O   HOH D2524     118.439 135.269  72.120  1.00 74.21           O
HETATM 6961  O   HOH D2525     102.367 144.652  66.742  1.00 78.05           O
HETATM 6962  O   HOH D2526     103.968 127.479  94.330  1.00 65.19           O
HETATM 6963  O   HOH D2527     173.650 139.752  94.083  1.00 71.26           O
HETATM 6964  O   HOH D2528     174.423 122.615  87.012  1.00 66.19           O
HETATM 6965  O   HOH D2529     121.838 130.351 116.999  1.00 69.31           O
HETATM 6966  O   HOH D2530     108.933 136.696  90.019  1.00 68.65           O
HETATM 6967  O   HOH D2531     131.606 160.788 109.080  1.00 70.81           O
HETATM 6968  O   HOH D2532     169.014 111.150  93.273  1.00 64.71           O
HETATM 6969  O   HOH D2533     109.926 130.353  88.452  1.00 65.85           O
HETATM 6970  O   HOH D2534     131.350 120.614  79.187  1.00 67.29           O
HETATM 6971  O   HOH D2535     159.362 107.911  93.547  1.00 70.75           O
HETATM 6972  O   HOH D2536     156.856 101.214  90.576  1.00 72.72           O
HETATM 6973  O   HOH D2537     136.064 135.824  96.312  1.00 57.19           O
HETATM 6974  O   HOH D2538     141.846 127.271  77.479  1.00 66.04           O
HETATM 6975  O   HOH D2539     119.462 116.700  76.862  1.00 63.64           O
HETATM 6976  O   HOH D2540     106.237 161.862 112.076  1.00 67.93           O
HETATM 6977  O   HOH D2541     131.215 101.570  81.139  1.00 74.27           O
HETATM 6978  O   HOH D2542     155.283 136.573 109.420  1.00 68.02           O
HETATM 6979  O   HOH D2543     181.691 111.652  98.024  1.00 72.42           O
HETATM 6980  O   HOH D2544     123.114 171.541 107.007  1.00 79.03           O
HETATM 6981  O   HOH D2545     108.098 142.530  96.094  1.00 68.10           O
HETATM 6982  O   HOH D2546     115.489 144.613 104.370  1.00 64.34           O
HETATM 6983  O   HOH D2547     136.638 125.167 112.070  1.00 73.30           O
HETATM 6984  O   HOH D2548     160.711 104.078  95.622  1.00 71.60           O
HETATM 6985  O   HOH D2549     119.583 109.074 103.406  1.00 63.04           O
HETATM 6986  O   HOH D2550     154.983 149.635  94.900  1.00 83.20           O
HETATM 6987  O   HOH D2551     116.666 138.714  77.798  1.00 75.49           O
HETATM 6988  O   HOH D2552     157.034 140.558  95.356  1.00 68.37           O
HETATM 6989  O   HOH D2553     139.957 130.257 116.396  1.00 77.79           O
HETATM 6990  O   HOH D2554     121.191 175.306 101.658  1.00 72.99           O
HETATM 6991  O   HOH D2555     106.268 142.183  67.026  1.00 78.58           O
HETATM 6992  O   HOH D2556     109.790 146.163 113.147  1.00 69.21           O
HETATM 6993  O   HOH D2557     111.265 155.824 110.605  1.00 68.37           O
HETATM 6994  O   HOH D2558     169.830 112.438  88.530  1.00 64.98           O
HETATM 6995  O   HOH D2559     151.458 132.251  91.111  1.00 67.18           O
HETATM 6996  O   HOH D2560     152.096 128.862 122.563  1.00 80.34           O
HETATM 6997  O   HOH D2561     102.520 149.594  73.692  1.00 77.95           O
HETATM 6998  O   HOH D2562     107.082 146.080  89.717  1.00 66.89           O
HETATM 6999  O   HOH D2563     128.295 146.684  89.336  1.00 66.48           O
HETATM 7000  O   HOH D2564     113.842 155.865 113.476  1.00 70.15           O
HETATM 7001  O   HOH D2565     146.167 116.280 105.129  1.00 64.52           O
HETATM 7002  O   HOH D2566     167.726 109.287  91.627  1.00 63.60           O
HETATM 7003  O   HOH D2567     162.927 119.173 128.558  1.00 76.05           O
HETATM 7004  O   HOH D2568     138.671 105.827 103.018  1.00 66.94           O
HETATM 7005  O   HOH D2569     103.902 135.330  99.613  1.00 62.44           O
HETATM 7006  O   HOH D2570     110.982 120.527 105.687  1.00 62.79           O
HETATM 7007  O   HOH D2571     141.501 150.459  94.777  1.00 71.40           O
HETATM 7008  O   HOH D2572     140.058 117.436 106.643  1.00 61.23           O
HETATM 7009  O   HOH D2573     139.722 133.980  81.838  1.00 62.57           O
HETATM 7010  O   HOH D2574      89.059 132.294  84.158  1.00 80.59           O
HETATM 7011  O   HOH D2575     156.539 113.867 119.995  1.00 70.21           O
HETATM 7012  O   HOH D2576     147.547 140.795  94.168  1.00 66.40           O
HETATM 7013  O   HOH D2577     166.398 137.763  90.527  1.00 70.93           O
HETATM 7014  O   HOH D2578     143.665 125.498  83.229  1.00 57.13           O
HETATM 7015  O   HOH D2579     155.345 132.153  90.655  1.00 64.52           O
HETATM 7016  O   HOH D2580     160.952 132.915  98.772  1.00 64.27           O
HETATM 7017  O   HOH D2581     139.051 124.478  67.585  1.00 68.35           O
HETATM 7018  O   HOH D2582     113.226 143.037  91.132  1.00 66.15           O
HETATM 7019  O   HOH D2583     120.907 174.353 104.362  1.00 77.85           O
HETATM 7020  O   HOH D2584     109.639 117.237  86.966  1.00 71.39           O
HETATM 7021  O   HOH D2585     126.024 143.096 101.721  1.00 64.01           O
HETATM 7022  O   HOH D2586     120.847 171.981 105.822  1.00 77.58           O
HETATM 7023  O   HOH D2587     145.699 139.633  95.367  1.00 64.72           O
HETATM 7024  O   HOH D2588     123.746 120.604  72.565  1.00 67.27           O
HETATM 7025  O   HOH D2589     146.027 117.934  98.500  1.00 55.69           O
HETATM 7026  O   HOH D2590     119.499 137.127  78.273  1.00 72.70           O
HETATM 7027  O   HOH D2591     127.112 114.118  74.694  1.00 71.96           O
HETATM 7028  O   HOH D2592     123.023 158.411 111.264  1.00 69.59           O
HETATM 7029  O   HOH D2593     121.738 126.333  73.889  1.00 63.23           O
HETATM 7030  O   HOH D2594     130.435 150.474 104.271  1.00 68.42           O
HETATM 7031  O   HOH D2595     108.694 142.886  99.769  1.00 66.14           O
HETATM 7032  O   HOH D2596     130.349 146.906 101.349  1.00 64.91           O
HETATM 7033  O   HOH D2597     154.556 120.793 122.108  1.00 68.09           O
HETATM 7034  O   HOH D2598     113.634 138.121  82.204  1.00 73.07           O
HETATM 7035  O   HOH D2599     111.037 124.181  87.118  1.00 68.35           O
HETATM 7036  O   HOH D2600     140.498 115.319 108.736  1.00 65.22           O
HETATM 7037  O   HOH D2601     129.705 147.569 120.186  1.00 74.38           O
HETATM 7038  O   HOH D2602     148.866 106.427  69.337  1.00 77.60           O
HETATM 7039  O   HOH D2603     186.421 131.595 113.170  1.00 82.72           O
HETATM 7040  O   HOH D2604     147.700 124.840 110.751  1.00 69.84           O
HETATM 7041  O   HOH D2605     106.777 158.121  94.881  1.00 64.25           O
HETATM 7042  O   HOH D2606     109.922 162.189 114.809  1.00 72.93           O
HETATM 7043  O   HOH D2607     164.865 130.440  99.318  1.00 62.93           O
HETATM 7044  O   HOH D2608     125.058 141.857 120.211  1.00 72.62           O
HETATM 7045  O   HOH D2609     122.230 150.464  83.134  1.00 71.51           O
HETATM 7046  O   HOH D2610     105.242 124.561 102.079  1.00 60.18           O
HETATM 7047  O   HOH D2611     101.737 156.002  84.498  1.00 74.23           O
HETATM 7048  O   HOH D2612     114.359 119.932  98.610  1.00 63.78           O
HETATM 7049  O   HOH D2613     107.807 122.281  98.739  1.00 64.07           O
HETATM 7050  O   HOH D2614     137.500 129.557  73.150  1.00 69.66           O
HETATM 7051  O   HOH D2615     115.317 163.140 114.254  1.00 72.06           O
HETATM 7052  O   HOH D2616     124.637 165.797  85.931  1.00 71.33           O
HETATM 7053  O   HOH D2617     147.297 102.424  72.645  1.00 83.98           O
HETATM 7054  O   HOH D2618     161.993 125.354 124.677  1.00 72.15           O
HETATM 7055  O   HOH D2619     112.971 110.515  99.181  1.00 71.49           O
HETATM 7056  O   HOH D2620     149.517 112.379  89.161  1.00 56.85           O
HETATM 7057  O   HOH D2621     136.293 152.408 114.564  1.00 78.84           O
HETATM 7058  O   HOH D2622     116.415 115.381  89.321  1.00 60.37           O
HETATM 7059  O   HOH D2623     118.360 108.979  95.042  1.00 65.07           O
HETATM 7060  O   HOH D2624     103.978 135.346  87.660  1.00 72.37           O
HETATM 7061  O   HOH D2625     132.244 107.918  87.780  1.00 70.48           O
HETATM 7062  O   HOH D2626     132.859 166.473  98.600  1.00 72.03           O
HETATM 7063  O   HOH D2627     105.034 123.669  97.995  1.00 64.80           O
HETATM 7064  O   HOH D2628     144.668 143.917 112.544  1.00 78.10           O
HETATM 7065  O   HOH D2629     194.831 114.705 102.467  1.00 80.28           O
HETATM 7066  O   HOH D2630     153.339 112.087  90.325  1.00 63.49           O
HETATM 7067  O   HOH D2631     133.219 141.446 118.065  1.00 75.00           O
HETATM 7068  O   HOH D2632     112.009 113.732  96.022  1.00 70.09           O
HETATM 7069  O   HOH D2633     136.877 137.471 102.674  1.00 65.62           O
HETATM 7070  O   HOH D2634     167.129 130.083 115.087  1.00 70.71           O
HETATM 7071  O   HOH D2635     116.022 166.466  92.534  1.00 67.49           O
HETATM 7072  O   HOH D2636     136.007 162.192  92.404  1.00 74.46           O
HETATM 7073  O   HOH D2637     151.992 144.495  98.511  1.00 66.28           O
HETATM 7074  O   HOH D2638     160.640 123.100 123.660  1.00 70.04           O
HETATM 7075  O   HOH D2639     125.462 168.301  93.214  1.00 76.02           O
HETATM 7076  O   HOH D2640     129.749 153.919  83.965  1.00 68.86           O
HETATM 7077  O   HOH D2641     152.751 105.581  91.200  1.00 65.33           O
HETATM 7078  O   HOH D2642     109.050 169.394  90.659  1.00 75.06           O
HETATM 7079  O   HOH D2643     114.083 169.018 111.415  1.00 80.20           O
HETATM 7080  O   HOH D2644     130.165 109.126  95.469  1.00 59.20           O
HETATM 7081  O   HOH D2645     160.789 130.753  96.909  1.00 61.08           O
HETATM 7082  O   HOH D2646     125.803 139.396  77.415  1.00 71.88           O
HETATM 7083  O   HOH D2647     134.279 151.125  87.360  1.00 71.64           O
HETATM 7084  O   HOH D2648      97.264 128.306  71.869  1.00 76.47           O
HETATM 7085  O   HOH D2649     119.015 148.908  76.639  1.00 77.52           O
HETATM 7086  O   HOH D2650     135.809 126.894 113.454  1.00 75.31           O
HETATM 7087  O   HOH D2651     115.857 156.865 115.271  1.00 70.82           O
HETATM 7088  O   HOH D2652     159.064 127.297 112.062  1.00 63.08           O
HETATM 7089  O   HOH D2653     130.875 153.407 115.750  1.00 74.87           O
HETATM 7090  O   HOH D2654     143.623 133.844 122.199  1.00 85.89           O
HETATM 7091  O   HOH D2655     166.939 133.536 107.090  1.00 67.91           O
HETATM 7092  O   HOH D2656     159.916 123.431  82.058  1.00 62.40           O
HETATM 7093  O   HOH D2657     146.985 134.759 109.405  1.00 73.57           O
HETATM 7094  O   HOH D2658     159.762 105.791  96.855  1.00 70.94           O
HETATM 7095  O   HOH D2659     153.583 123.481 122.540  1.00 73.27           O
HETATM 7096  O   HOH D2660     145.240 118.953 112.916  1.00 69.71           O
HETATM 7097  O   HOH D2661      84.605 135.260  91.115  1.00 76.50           O
HETATM 7098  O   HOH D2662     110.065 141.365 120.011  1.00 68.14           O
HETATM 7099  O   HOH D2663     155.016 147.671  93.623  1.00 81.24           O
HETATM 7100  O   HOH D2664     128.548 116.656  88.896  1.00 57.89           O
HETATM 7101  O   HOH D2665     117.040 135.294  81.094  1.00 72.06           O
HETATM 7102  O   HOH D2666     142.185 121.713 102.577  1.00 59.98           O
HETATM 7103  O   HOH D2667     150.510 138.464  91.450  1.00 66.06           O
HETATM 7104  O   HOH D2668     173.245 113.441  87.722  1.00 65.60           O
HETATM 7105  O   HOH D2669     147.778  98.816  72.100  1.00 86.57           O
HETATM 7106  O   HOH D2670     155.456 102.791  93.018  1.00 70.59           O
HETATM 7107  O   HOH D2671     164.236 135.390  86.780  1.00 68.50           O
HETATM 7108  O   HOH D2672     158.582 115.783 103.994  1.00 61.84           O
HETATM 7109  O   HOH D2673     136.300 119.944  81.784  1.00 63.00           O
HETATM 7110  O   HOH D2674     147.403 123.338  77.241  1.00 68.56           O
HETATM 7111  O   HOH D2675     156.954 145.158 107.154  1.00 69.96           O
HETATM 7112  O   HOH D2676     162.981 105.198  73.142  1.00 75.69           O
HETATM 7113  O   HOH D2677     145.953 103.253  89.681  1.00 70.69           O
HETATM 7114  O   HOH D2678     156.380 106.060  70.888  1.00 71.10           O
HETATM 7115  O   HOH D2679     152.091 102.408  89.934  1.00 68.29           O
HETATM 7116  O   HOH D2680     154.356 128.004  91.291  1.00 59.37           O
HETATM 7117  O   HOH D2681     133.970 152.496  89.273  1.00 70.51           O
HETATM 7118  O   HOH D2682     104.251 139.482  67.453  1.00 76.76           O
HETATM 7119  O   HOH D2683     133.166 153.588 111.662  1.00 74.21           O
HETATM 7120  O   HOH D2684     123.462 173.857  95.745  1.00 76.87           O
HETATM 7121  O   HOH D2685     132.195 155.490 109.153  1.00 68.96           O
HETATM 7122  O   HOH D2686     167.745 135.787  88.147  1.00 70.72           O
HETATM 7123  O   HOH D2687     181.421 129.776 117.298  1.00 82.78           O
HETATM 7124  O   HOH D2688     181.473 135.693  98.777  1.00 72.11           O
HETATM 7125  O   HOH D2689     141.483 142.976 115.139  1.00 82.81           O
HETATM 7126  O   HOH D2690     136.210 155.037 107.130  1.00 73.09           O
HETATM 7127  O   HOH D2691     129.695 126.560  77.449  1.00 64.21           O
HETATM 7128  O   HOH D2692     146.953 122.185  83.602  1.00 58.58           O
HETATM 7129  O   HOH D2693     104.599 147.613  92.174  1.00 67.23           O
HETATM 7130  O   HOH D2694     149.519 115.840  98.625  1.00 59.07           O
HETATM 7131  O   HOH D2695     139.803 130.756  76.603  1.00 68.31           O
HETATM 7132  O   HOH D2696     150.099 123.031  94.088  1.00 58.18           O
HETATM 7133  O   HOH D2697     161.383 136.077  84.116  1.00 71.66           O
HETATM 7134  O   HOH D2698     133.717 133.245  75.390  1.00 69.41           O
HETATM 7135  O   HOH D2699     168.873 137.895 105.622  1.00 69.17           O
HETATM 7136  O   HOH D2700     138.077 157.826 106.558  1.00 73.30           O
HETATM 7137  O   HOH D2701     107.858 128.814  88.599  1.00 69.23           O
HETATM 7138  O   HOH D2702     156.224 111.232 111.530  1.00 63.56           O
HETATM 7139  O   HOH D2703     166.700 131.432 104.251  1.00 63.27           O
HETATM 7140  O   HOH D2704     181.000 120.050  95.904  1.00 71.21           O
HETATM 7141  O   HOH D2705     104.926 158.423  89.868  1.00 65.04           O
HETATM 7142  O   HOH D2706     136.025 160.180  90.897  1.00 73.12           O
HETATM 7143  O   HOH D2707     132.074 105.233  95.462  1.00 62.45           O
HETATM 7144  O   HOH D2708     164.455 109.446 108.201  1.00 59.04           O
HETATM 7145  O   HOH D2709     168.580 135.226 107.152  1.00 70.73           O
HETATM 7146  O   HOH D2710      93.921 146.907  68.697  1.00 83.03           O
HETATM 7147  O   HOH D2711     155.349 113.830 107.899  1.00 65.54           O
HETATM 7148  O   HOH D2712     113.500 118.366  96.595  1.00 63.35           O
HETATM 7149  O   HOH D2713     154.869 103.236  96.957  1.00 70.53           O
HETATM 7150  O   HOH D2714     157.763 147.004  94.893  1.00 75.79           O
HETATM 7151  O   HOH D2715     137.204 113.802  69.924  1.00 78.07           O
HETATM 7152  O   HOH D2716     105.321 151.212  71.611  1.00 79.80           O
HETATM 7153  O   HOH D2717     184.928 135.833  94.749  1.00 77.81           O
HETATM 7154  O   HOH D2718     183.177 125.906 119.269  1.00 82.94           O
HETATM 7155  O   HOH D2719     103.912 153.178  75.951  1.00 76.34           O
HETATM 7156  O   HOH D2720     157.183 139.035 112.203  1.00 70.72           O
HETATM 7157  O   HOH D2721     161.123 147.949 102.399  1.00 69.81           O
HETATM 7158  O   HOH D2722     103.398 147.142  68.259  1.00 81.28           O
HETATM 7159  O   HOH D2723     135.563 150.622 112.206  1.00 77.10           O
HETATM 7160  O   HOH D2724     165.321 130.736 112.691  1.00 66.53           O
HETATM 7161  O   HOH D2725     159.171 113.825  79.760  1.00 69.81           O
HETATM 7162  O   HOH D2726     164.567 143.968  94.449  1.00 69.14           O
HETATM 7163  O   HOH D2727     186.138 129.782 108.227  1.00 73.49           O
HETATM 7164  O   HOH D2728     125.482 151.178  80.078  1.00 78.22           O
HETATM 7165  O   HOH D2729     104.455 130.635  93.141  1.00 66.81           O
HETATM 7166  O   HOH D2730     132.401 132.919 115.014  1.00 73.35           O
HETATM 7167  O   HOH D2731     145.119 114.271 111.800  1.00 71.68           O
HETATM 7168  O   HOH D2732     149.820 107.492  91.330  1.00 71.78           O
HETATM 7169  O   HOH D2733     117.494 114.530 108.216  1.00 65.25           O
HETATM 7170  O   HOH D2734     137.533 152.354 110.923  1.00 78.17           O
HETATM 7171  O   HOH D2735     134.308 102.568  76.063  1.00 74.69           O
HETATM 7172  O   HOH D2736     133.063 141.407  98.280  1.00 63.73           O
HETATM 7173  O   HOH D2737     112.535 127.910  87.200  1.00 65.03           O
HETATM 7174  O   HOH D2738     160.397 113.641 102.967  1.00 61.80           O
HETATM 7175  O   HOH D2739     108.229 168.003  88.857  1.00 73.09           O
HETATM 7176  O   HOH D2740     108.323 146.666 103.984  1.00 69.47           O
HETATM 7177  O   HOH D2741     170.175 125.731  85.630  1.00 66.32           O
HETATM 7178  O   HOH D2742     131.119 104.979  87.416  1.00 74.17           O
HETATM 7179  O   HOH D2743     120.914 124.124  72.769  1.00 65.63           O
HETATM 7180  O   HOH D2744      95.203 129.912  84.027  1.00 77.25           O
HETATM 7181  O   HOH D2745     147.953 136.414  98.048  1.00 63.84           O
HETATM 7182  O   HOH D2746     175.904 136.730  90.275  1.00 75.50           O
HETATM 7183  O   HOH D2747     120.238 167.517  80.222  1.00 76.95           O
HETATM 7184  O   HOH D2748     163.255 135.135  93.812  1.00 65.38           O
HETATM 7185  O   HOH D2749     135.275 166.972  88.704  1.00 76.21           O
HETATM 7186  O   HOH D2750     129.375 119.042 120.930  1.00 77.20           O
HETATM 7187  O   HOH D2751     140.599 122.527  66.694  1.00 71.51           O
HETATM 7188  O   HOH D2752     103.032 124.064  70.956  1.00 77.34           O
HETATM 7189  O   HOH D2753     167.616 111.405 101.563  1.00 62.52           O
HETATM 7190  O   HOH D2754      97.653 126.219  78.179  1.00 79.77           O
HETATM 7191  O   HOH D2755     150.446 154.564 100.403  1.00 80.90           O
HETATM 7192  O   HOH D2756      96.904 147.455  88.439  1.00 80.84           O
HETATM 7193  O   HOH D2757     142.870 145.888 114.464  1.00 78.46           O
HETATM 7194  O   HOH D2758     161.519 131.655 118.890  1.00 69.59           O
HETATM 7195  O   HOH D2759     116.374 108.702 102.653  1.00 68.02           O
HETATM 7196  O   HOH D2760     152.982 100.062  87.833  1.00 77.01           O
HETATM 7197  O   HOH D2761     135.266 143.275  98.613  1.00 66.62           O
HETATM 7198  O   HOH D2762     162.011 132.956 109.685  1.00 66.27           O
HETATM 7199  O   HOH D2763     149.526 141.292 109.330  1.00 73.61           O
HETATM 7200  O   HOH D2764     116.747 115.823  73.119  1.00 75.59           O
HETATM 7201  O   HOH D2765     142.763 155.959 103.313  1.00 72.83           O
HETATM 7202  O   HOH D2766     174.736 109.682 113.570  1.00 64.28           O
HETATM 7203  O   HOH D2767     150.026 108.220  68.456  1.00 78.01           O
HETATM 7204  O   HOH D2768     104.593 122.218  70.583  1.00 80.30           O
HETATM 7205  O   HOH D2769     145.498 125.368  75.315  1.00 68.70           O
HETATM 7206  O   HOH D2770     130.516 143.143 116.702  1.00 70.01           O
HETATM 7207  O   HOH D2771     140.780 106.177  90.346  1.00 65.99           O
HETATM 7208  O   HOH D2772     144.000 116.990 106.356  1.00 65.19           O
HETATM 7209  O   HOH D2773     105.589 115.815  81.346  1.00 76.23           O
HETATM 7210  O   HOH D2774     108.787 149.131 104.906  1.00 63.06           O
HETATM 7211  O   HOH D2775     134.319 119.303  78.522  1.00 68.85           O
HETATM 7212  O   HOH D2776     116.791 143.740  81.357  1.00 73.63           O
HETATM 7213  O   HOH D2777     116.453 145.713 117.974  1.00 70.89           O
HETATM 7214  O   HOH D2778     112.277 171.402  99.385  1.00 80.25           O
HETATM 7215  O   HOH D2779     114.575 128.079  83.349  1.00 62.25           O
HETATM 7216  O   HOH D2780     177.303 119.793  87.080  1.00 67.22           O
HETATM 7217  O   HOH D2781     165.210 133.340  81.475  1.00 76.29           O
HETATM 7218  O   HOH D2782     147.715 117.194 115.774  1.00 68.93           O
HETATM 7219  O   HOH D2783     105.219 142.273  90.357  1.00 73.53           O
HETATM 7220  O   HOH D2784     155.672 134.864  99.748  1.00 59.88           O
HETATM 7221  O   HOH D2785     140.925 121.221 115.555  1.00 71.45           O
HETATM 7222  O   HOH D2786     113.215 149.246 116.784  1.00 70.80           O
HETATM 7223  O   HOH D2787     183.170 104.212 100.136  1.00 75.90           O
HETATM 7224  O   HOH D2788     159.891 126.564 126.189  1.00 73.76           O
HETATM 7225  O   HOH D2789     114.392 142.502  93.497  1.00 66.32           O
HETATM 7226  O   HOH D2790     102.414 123.121  73.048  1.00 77.16           O
HETATM 7227  O   HOH D2791     136.195  99.281  77.802  1.00 78.26           O
HETATM 7228  O   HOH D2792     160.090 114.774 118.258  1.00 66.72           O
HETATM 7229  O   HOH D2793     124.300 159.425  82.393  1.00 70.38           O
HETATM 7230  O   HOH D2794     151.648 158.156  93.777  1.00 92.18           O
HETATM 7231  O   HOH D2795     111.353 119.317 101.082  1.00 61.48           O
HETATM 7232  O   HOH D2796     124.766 126.232  74.427  1.00 64.17           O
HETATM 7233  O   HOH D2797      90.448 139.708  80.771  1.00 79.92           O
HETATM 7234  O   HOH D2798     145.670 123.683  79.574  1.00 62.01           O
HETATM 7235  O   HOH D2799     120.088 149.889  78.628  1.00 79.10           O
HETATM 7236  O   HOH D2800     111.431 124.933 109.063  1.00 60.17           O
HETATM 7237  O   HOH D2801      88.245 136.690  75.988  1.00 82.62           O
HETATM 7238  O   HOH D2802     153.453 131.044  91.589  1.00 65.62           O
HETATM 7239  O   HOH D2803     135.378 158.831  88.312  1.00 69.54           O
HETATM 7240  O   HOH D2804     156.947 151.689  99.000  1.00 85.06           O
HETATM 7241  O   HOH D2805     164.976 115.497  80.113  1.00 71.03           O
HETATM 7242  O   HOH D2806     168.905 109.445 112.112  1.00 60.96           O
HETATM 7243  O   HOH D2807     146.638 155.216  97.111  1.00 77.07           O
HETATM 7244  O   HOH D2808     125.646 130.406 112.967  1.00 66.28           O
HETATM 7245  O   HOH D2809     146.395 154.917 104.934  1.00 76.91           O
HETATM 7246  O   HOH D2810      86.259 144.962  78.415  1.00 86.90           O
HETATM 7247  O   HOH D2811     115.346 141.410  80.054  1.00 73.22           O
HETATM 7248  O   HOH D2812     150.936 118.563 117.311  1.00 69.25           O
HETATM 7249  O   HOH D2813     179.490 127.003 118.474  1.00 75.63           O
HETATM 7250  O   HOH D2814     103.074 135.102  92.681  1.00 73.70           O
HETATM 7251  O   HOH D2815     155.697 128.443  88.748  1.00 64.09           O
HETATM 7252  O   HOH D2816     131.857 153.716 113.645  1.00 76.29           O
HETATM 7253  O   HOH D2817     125.647 112.149  75.517  1.00 71.26           O
HETATM 7254  O   HOH D2818     133.758 119.264  69.615  1.00 72.01           O
HETATM 7255  O   HOH D2819     172.225 109.976  91.279  1.00 72.72           O
HETATM 7256  O   HOH D2820     168.992 110.654 114.151  1.00 62.83           O
HETATM 7257  O   HOH D2821     161.301 110.050  92.531  1.00 68.54           O
HETATM 7258  O   HOH D2822     101.021 139.414  68.356  1.00 76.22           O
HETATM 7259  O   HOH D2823     144.061 128.533  84.717  1.00 63.44           O
HETATM 7260  O   HOH D2824     113.323 125.318 115.706  1.00 63.22           O
HETATM 7261  O   HOH D2825     190.351 116.651 113.587  1.00 74.70           O
HETATM 7262  O   HOH D2826     174.027 106.782  98.848  1.00 68.77           O
HETATM 7263  O   HOH D2827     111.214 150.393 120.187  1.00 66.20           O
HETATM 7264  O   HOH D2828     134.139 119.711  75.247  1.00 72.45           O
HETATM 7265  O   HOH D2829     140.951  97.685  75.217  1.00 82.25           O
HETATM 7266  O   HOH D2830     146.503 147.469 111.352  1.00 75.40           O
HETATM 7267  O   HOH D2831     132.006 122.066  76.401  1.00 68.10           O
HETATM 7268  O   HOH D2832     143.821 141.025 113.876  1.00 78.92           O
HETATM 7269  O   HOH D2833     112.588 145.468  91.559  1.00 66.12           O
HETATM 7270  O   HOH D2834     130.502 130.807 112.195  1.00 72.26           O
HETATM 7271  O   HOH D2835     133.597 151.250 115.514  1.00 74.70           O
HETATM 7272  O   HOH D2836     154.914 139.970 109.140  1.00 70.48           O
HETATM 7273  O   HOH D2837     168.138 104.303  90.475  1.00 77.79           O
HETATM 7274  O   HOH D2838     171.087 129.620  84.010  1.00 72.24           O
HETATM 7275  O   HOH D2839     167.257 145.385  96.708  1.00 71.36           O
HETATM 7276  O   HOH D2840     105.533 144.932  66.781  1.00 75.80           O
HETATM 7277  O   HOH D2841     116.755 122.693 114.374  1.00 63.81           O
HETATM 7278  O   HOH D2842     109.114 123.444  88.434  1.00 70.60           O
HETATM 7279  O   HOH D2843     120.119 143.795  75.299  1.00 82.00           O
HETATM 7280  O   HOH D2844     103.921 155.365 101.328  1.00 70.76           O
HETATM 7281  O   HOH D2845     145.070 112.056  94.695  1.00 61.52           O
HETATM 7282  O   HOH D2846     138.078 143.603 115.206  1.00 77.97           O
HETATM 7283  O   HOH D2847     114.533 127.655  85.955  1.00 63.96           O
HETATM 7284  O   HOH D2848      89.631 134.186  87.118  1.00 76.30           O
HETATM 7285  O   HOH D2849     129.929 124.221  77.598  1.00 65.15           O
HETATM 7286  O   HOH D2850     104.670 116.886  77.380  1.00 75.03           O
HETATM 7287  O   HOH D2851     152.325  98.552  85.978  1.00 79.33           O
HETATM 7288  O   HOH D2852     104.591 148.014 100.719  1.00 70.56           O
HETATM 7289  O   HOH D2853     181.387 136.074 101.073  1.00 73.78           O
HETATM 7290  O   HOH D2854     121.601 140.309  81.983  1.00 70.32           O
HETATM 7291  O   HOH D2855     148.261 104.599  71.422  1.00 78.15           O
HETATM 7292  O   HOH D2856     117.274 147.169  84.372  1.00 72.87           O
HETATM 7293  O   HOH D2857     162.154 108.765  90.818  1.00 67.13           O
HETATM 7294  O   HOH D2858     169.827 111.718  90.793  1.00 69.73           O
HETATM 7295  O   HOH D2859     177.525 130.168 111.287  1.00 72.39           O
HETATM 7296  O   HOH D2860     148.549 136.294 100.953  1.00 65.57           O
HETATM 7297  O   HOH D2861     121.871 112.356 116.466  1.00 62.33           O
HETATM 7298  O   HOH D2862     104.507 173.310 100.631  1.00 82.08           O
HETATM 7299  O   HOH D2863     111.562 119.335  91.745  1.00 66.37           O
HETATM 7300  O   HOH D2864     181.090 120.363 123.559  1.00 79.45           O
HETATM 7301  O   HOH D2865      99.711 133.152  69.029  1.00 80.66           O
HETATM 7302  O   HOH D2866     142.055 134.957  82.609  1.00 66.41           O
HETATM 7303  O   HOH D2867     137.197 131.056  75.241  1.00 68.70           O
HETATM 7304  O   HOH D2868     146.889 123.817  85.843  1.00 55.26           O
HETATM 7305  O   HOH D2869     172.995 136.098 106.482  1.00 68.48           O
HETATM 7306  O   HOH D2870     123.783 107.550  88.855  1.00 65.98           O
HETATM 7307  O   HOH D2871     157.866 111.317  73.053  1.00 71.18           O
HETATM 7308  O   HOH D2872     110.025 120.562  97.620  1.00 71.21           O
HETATM 7309  O   HOH D2873      92.757 142.565  89.330  1.00 78.05           O
HETATM 7310  O   HOH D2874     134.265 110.349  70.565  1.00 74.73           O
HETATM 7311  O   HOH D2875     104.624 159.022 100.586  1.00 71.28           O
HETATM 7312  O   HOH D2876     114.322 128.223 115.922  1.00 63.52           O
HETATM 7313  O   HOH D2877     108.314 130.077  63.328  1.00 76.09           O
HETATM 7314  O   HOH D2878     136.841 121.427 119.317  1.00 75.18           O
HETATM 7315  O   HOH D2879     124.913 123.917  74.853  1.00 63.40           O
HETATM 7316  O   HOH D2880     115.957 170.193  86.282  1.00 77.21           O
HETATM 7317  O   HOH D2881     146.628 115.538 100.675  1.00 61.21           O
HETATM 7318  O   HOH D2882     150.245 138.228 110.659  1.00 70.62           O
HETATM 7319  O   HOH D2883     116.965 146.411 108.457  1.00 64.92           O
HETATM 7320  O   HOH D2884     114.892 145.179 101.760  1.00 66.18           O
HETATM 7321  O   HOH D2885     155.644  98.560  87.674  1.00 76.08           O
HETATM 7322  O   HOH D2886     172.386 111.578  97.538  1.00 67.61           O
HETATM 7323  O   HOH D2887      87.117 147.367  75.086  1.00 88.72           O
HETATM 7324  O   HOH D2888     102.457 129.659  96.944  1.00 65.33           O
HETATM 7325  O   HOH D2889     146.803 127.561  87.214  1.00 59.26           O
HETATM 7326  O   HOH D2890     153.740 102.103  91.607  1.00 73.88           O
HETATM 7327  O   HOH D2891     121.528 171.724  88.617  1.00 75.82           O
HETATM 7328  O   HOH D2892     105.505 157.055 101.979  1.00 72.01           O
HETATM 7329  O   HOH D2893     117.918 145.183  76.699  1.00 81.70           O
HETATM 7330  O   HOH D2894     113.500 136.248  83.647  1.00 71.43           O
HETATM 7331  O   HOH D2895     130.097 109.687  88.512  1.00 69.08           O
HETATM 7332  O   HOH D2896     166.941 110.300  89.400  1.00 68.28           O
HETATM 7333  O   HOH D2897     170.595 110.395  98.629  1.00 68.43           O
HETATM 7334  O   HOH D2898      82.957 139.034  94.056  1.00 75.42           O
HETATM 7335  O   HOH D2899     119.426 135.196  74.308  1.00 73.68           O
HETATM 7336  O   HOH D2900     144.411 109.620  91.992  1.00 65.60           O
HETATM 7337  O   HOH D2901     136.767 100.449  75.889  1.00 76.29           O
HETATM 7338  O   HOH D2902     141.272 118.906  66.009  1.00 74.39           O
HETATM 7339  O   HOH D2903     105.875 135.269  95.104  1.00 65.62           O
HETATM 7340  O   HOH D2904     132.348 158.916  94.348  1.00 70.39           O
HETATM 7341  O   HOH D2905     117.862 153.607  74.951  1.00 77.04           O
HETATM 7342  O   HOH D2906     174.671 110.746  99.786  1.00 65.05           O
HETATM 7343  O   HOH D2907     142.456 109.955 101.404  1.00 63.63           O
HETATM 7344  O   HOH D2908     155.052 141.030  93.559  1.00 69.00           O
HETATM 7345  O   HOH D2909     192.835 109.485 109.809  1.00 79.51           O
HETATM 7346  O   HOH D2910     115.356 118.614 109.282  1.00 62.50           O
HETATM 7347  O   HOH D2911     145.886 115.220 113.824  1.00 70.70           O
HETATM 7348  O   HOH D2912     114.076 147.080 117.137  1.00 71.14           O
HETATM 7349  O   HOH D2913     145.546 143.440 116.081  1.00 86.42           O
HETATM 7350  O   HOH D2914     129.015 166.113  85.130  1.00 75.65           O
HETATM 7351  O   HOH D2915     128.532 151.460  82.880  1.00 70.53           O
HETATM 7352  O   HOH D2916     146.014 128.467 113.880  1.00 69.91           O
HETATM 7353  O   HOH D2917     155.327  99.563  89.809  1.00 73.99           O
HETATM 7354  O   HOH D2918     136.378 105.857  89.245  1.00 72.72           O
HETATM 7355  O   HOH D2919     196.696 114.256  99.618  1.00 84.05           O
HETATM 7356  O   HOH D2920     115.530 135.228  84.207  1.00 67.31           O
HETATM 7357  O   HOH D2921     124.085 149.255  81.388  1.00 74.45           O
HETATM 7358  O   HOH D2922     152.008 111.478  70.633  1.00 73.70           O
HETATM 7359  O   HOH D2923     112.754 138.378 120.843  1.00 68.98           O
HETATM 7360  O   HOH D2924     128.553 123.560 112.639  1.00 68.93           O
HETATM 7361  O   HOH D2925     119.456 139.949  82.994  1.00 71.63           O
HETATM 7362  O   HOH D2926     151.386 146.035 108.528  1.00 73.20           O
HETATM 7363  O   HOH D2927     114.840 117.995 104.365  1.00 60.76           O
HETATM 7364  O   HOH D2928     104.894 126.378  67.950  1.00 73.70           O
HETATM 7365  O   HOH D2929     154.923 115.064  82.826  1.00 64.35           O
HETATM 7366  O   HOH D2930     137.611 136.657  79.411  1.00 68.75           O
HETATM 7367  O   HOH D2931     157.254 108.814  94.123  1.00 68.84           O
HETATM 7368  O   HOH D2932     154.019 148.481 106.176  1.00 73.20           O
HETATM 7369  O   HOH D2933     153.625 144.488  94.434  1.00 70.56           O
HETATM 7370  O   HOH D2934     179.511 133.686  92.378  1.00 72.84           O
HETATM 7371  O   HOH D2935     135.990 106.163  95.192  1.00 65.21           O
HETATM 7372  O   HOH D2936     184.726 120.841 118.555  1.00 73.39           O
HETATM 7373  O   HOH D2937     157.232 133.360 122.999  1.00 71.83           O
HETATM 7374  O   HOH D2938     127.189 108.628  91.333  1.00 68.43           O
HETATM 7375  O   HOH D2939     137.553 144.303 117.739  1.00 76.32           O
HETATM 7376  O   HOH D2940     121.964 132.606  75.569  1.00 68.46           O
HETATM 7377  O   HOH D2941     147.780 120.242 115.596  1.00 72.20           O
HETATM 7378  O   HOH D2942     131.981 121.248  81.456  1.00 64.97           O
HETATM 7379  O   HOH D2943     108.497 121.738  91.588  1.00 65.37           O
HETATM 7380  O   HOH D2944     170.222 110.095  95.047  1.00 66.90           O
HETATM 7381  O   HOH D2945      99.141 150.004  76.488  1.00 77.60           O
HETATM 7382  O   HOH D2946      93.167 132.980  72.988  1.00 76.83           O
HETATM 7383  O   HOH D2947     159.628 109.751  72.729  1.00 75.85           O
HETATM 7384  O   HOH D2948     181.052 105.614 101.379  1.00 72.78           O
HETATM 7385  O   HOH D2949     143.174 115.132 110.663  1.00 76.67           O
HETATM 7386  O   HOH D2950     125.106 154.091 117.961  1.00 75.47           O
HETATM 7387  O   HOH D2951     115.451 170.253  89.434  1.00 71.54           O
HETATM 7388  O   HOH D2952     130.778 120.872  84.101  1.00 59.40           O
HETATM 7389  O   HOH D2953     166.101 132.843 109.325  1.00 70.51           O
HETATM 7390  O   HOH D2954     105.593 122.811  88.242  1.00 72.09           O
HETATM 7391  O   HOH D2955     136.790 160.871 105.968  1.00 70.54           O
HETATM 7392  O   HOH D2956     143.850 111.326 100.113  1.00 63.24           O
HETATM 7393  O   HOH D2957     168.551 109.568  97.909  1.00 68.64           O
HETATM 7394  O   HOH D2958     102.408 132.967  91.648  1.00 78.13           O
HETATM 7395  O   HOH D2959     115.435 116.034 107.627  1.00 67.33           O
HETATM 7396  O   HOH D2960     129.838 106.309  95.244  1.00 63.55           O
HETATM 7397  O   HOH D2961      79.733 138.396  98.857  1.00 73.73           O
HETATM 7398  O   HOH D2962     144.466 101.959  72.414  1.00 82.64           O
HETATM 7399  O   HOH D2963     132.924 158.615 109.645  1.00 74.66           O
HETATM 7400  O   HOH D2964      87.600 137.395  89.253  1.00 75.76           O
HETATM 7401  O   HOH D2965      91.397 144.614  70.043  1.00 84.00           O
HETATM 7402  O   HOH D2966     148.225 101.988  90.477  1.00 72.62           O
HETATM 7403  O   HOH D2967     128.549 174.994  90.623  1.00 82.85           O
HETATM 7404  O   HOH D2968     167.928 132.704  79.990  1.00 76.14           O
HETATM 7405  O   HOH D2969     139.578 116.811  66.487  1.00 79.73           O
HETATM 7406  O   HOH D2970     154.985 117.472  77.209  1.00 72.16           O
HETATM 7407  O   HOH D2971     153.915 114.748 120.520  1.00 72.94           O
HETATM 7408  O   HOH D2972     157.171 112.899  80.692  1.00 68.65           O
HETATM 7409  O   HOH D2973     157.291 114.758  99.889  1.00 65.03           O
HETATM 7410  O   HOH D2974     141.376 155.756 101.172  1.00 73.63           O
HETATM 7411  O   HOH D2975     128.468 117.710  74.522  1.00 71.15           O
HETATM 7412  O   HOH D2976     144.177 123.408 119.010  1.00 75.09           O
HETATM 7413  O   HOH D2977     159.468 134.866 120.891  1.00 69.54           O
HETATM 7414  O   HOH D2978     154.050 140.306  91.493  1.00 69.30           O
HETATM 7415  O   HOH D2979     134.805 158.811 107.571  1.00 74.13           O
HETATM 7416  O   HOH D2980     122.370 142.528  82.780  1.00 69.60           O
HETATM 7417  O   HOH D2981     126.639 167.135 110.809  1.00 72.38           O
HETATM 7418  O   HOH D2982     134.151 114.604 119.459  1.00 71.62           O
HETATM 7419  O   HOH D2983     107.586 162.674 107.711  1.00 72.77           O
HETATM 7420  O   HOH D2984     117.578 167.106 109.492  1.00 75.32           O
HETATM 7421  O   HOH D2985     155.266 127.028  86.923  1.00 60.22           O
HETATM 7422  O   HOH D2986     179.769 109.440 111.945  1.00 74.02           O
HETATM 7423  O   HOH D2987     156.945  98.895  82.961  1.00 79.45           O
HETATM 7424  O   HOH D2988      99.777 120.173  79.985  1.00 79.90           O
HETATM 7425  O   HOH D2989     166.435 107.638 104.590  1.00 63.81           O
HETATM 7426  O   HOH D2990     134.421 129.810 113.362  1.00 76.78           O
HETATM 7427  O   HOH D2991     172.530 110.877  95.323  1.00 67.68           O
HETATM 7428  O   HOH D2992     122.056 116.915  77.619  1.00 63.46           O
HETATM 7429  O   HOH D2993     131.929 149.131 119.599  1.00 74.68           O
HETATM 7430  O   HOH D2994     128.726 105.255  88.474  1.00 78.98           O
HETATM 7431  O   HOH D2995     128.025 145.413  83.509  1.00 72.59           O
HETATM 7432  O   HOH D2996     118.414 171.451  87.675  1.00 74.11           O
HETATM 7433  O   HOH D2997     176.637 128.851 114.831  1.00 72.08           O
HETATM 7434  O   HOH D2998     179.739 108.961  99.270  1.00 73.06           O
HETATM 7435  O   HOH D2999     120.243 149.684  80.978  1.00 77.00           O
HETATM 7436  O   HOH D3000     135.606 106.868  92.983  1.00 66.03           O
HETATM 7437  O   HOH D3001     118.613 157.883  75.152  1.00 82.47           O
HETATM 7438  O   HOH D3002     123.693 176.805  94.132  1.00 77.03           O
HETATM 7439  O   HOH D3003     162.232 137.183  92.513  1.00 70.65           O
HETATM 7440  O   HOH D3004     140.558 106.935 104.339  1.00 68.79           O
HETATM 7441  O   HOH D3005      95.442 135.566  69.534  1.00 73.06           O
HETATM 7442  O   HOH D3006     134.889 148.206 116.625  1.00 80.59           O
HETATM 7443  O   HOH D3007     111.243 174.366  98.255  1.00 80.10           O
HETATM 7444  O   HOH D3008     131.324 123.692  73.480  1.00 71.25           O
HETATM 7445  O   HOH D3009     157.434 113.310  97.238  1.00 62.14           O
HETATM 7446  O   HOH D3010     160.357 138.474  91.855  1.00 67.94           O
HETATM 7447  O   HOH D3011     145.683 143.525  92.138  1.00 69.65           O
HETATM 7448  O   HOH D3012     152.482 131.458 123.476  1.00 79.80           O
HETATM 7449  O   HOH D3013     116.774 114.333 102.497  1.00 61.01           O
HETATM 7450  O   HOH D3014     114.849 110.620 102.393  1.00 70.41           O
HETATM 7451  O   HOH D3015     137.583 139.396 115.642  1.00 79.30           O
HETATM 7452  O   HOH D3016     115.774 137.082  82.081  1.00 73.24           O
HETATM 7453  O   HOH D3017     117.280 113.567  77.934  1.00 70.12           O
HETATM 7454  O   HOH D3018     105.509 128.849  88.787  1.00 73.71           O
HETATM 7455  O   HOH D3019     128.875 145.856 103.230  1.00 67.51           O
HETATM 7456  O   HOH D3020     149.245 141.290 113.354  1.00 82.47           O
HETATM 7457  O   HOH D3021     142.484 126.833 117.930  1.00 80.06           O
HETATM 7458  O   HOH D3022     114.224 117.831 100.577  1.00 64.42           O
HETATM 7459  O   HOH D3023     117.695 138.449  82.099  1.00 74.99           O
HETATM 7460  O   HOH D3024     142.876 144.411  87.362  1.00 76.78           O
HETATM 7461  O   HOH D3025     133.404 129.045 111.029  1.00 73.45           O
HETATM 7462  O   HOH D3026     167.738 129.252 110.092  1.00 67.38           O
HETATM 7463  O   HOH D3027      89.579 142.482  69.279  1.00 89.15           O
HETATM 7464  O   HOH D3028     152.775 149.553 103.429  1.00 68.24           O
HETATM 7465  O   HOH D3029     139.028 105.263  88.997  1.00 68.18           O
HETATM 7466  O   HOH D3030     121.244 139.959  79.104  1.00 75.53           O
HETATM 7467  O   HOH D3031     151.145 110.315  68.603  1.00 75.24           O
HETATM 7468  O   HOH D3032     153.937 118.686  81.060  1.00 69.74           O
HETATM 7469  O   HOH D3033     135.249  98.914  80.400  1.00 74.62           O
HETATM 7470  O   HOH D3034     133.945 148.524  86.480  1.00 71.63           O
HETATM 7471  O   HOH D3035     130.218 111.879  89.891  1.00 65.71           O
HETATM 7472  O   HOH D3036     131.524 110.308  92.511  1.00 62.73           O
HETATM 7473  O   HOH D3037     123.343 139.962  78.026  1.00 74.43           O
HETATM 7474  O   HOH D3038     164.277 136.747  90.920  1.00 68.72           O
HETATM 7475  O   HOH D3039     181.136 136.565  96.326  1.00 76.21           O
HETATM 7476  O   HOH D3040     125.414 163.512  81.644  1.00 74.00           O
HETATM 7477  O   HOH D3041     110.348 149.199  69.162  1.00 80.73           O
HETATM 7478  O   HOH D3042     155.396  98.005  84.591  1.00 79.96           O
HETATM 7479  O   HOH D3043     118.920 168.769 107.607  1.00 78.19           O
HETATM 7480  O   HOH D3044     104.423 149.353  69.967  1.00 78.43           O
HETATM 7481  O   HOH D3045     148.555 105.662  92.116  1.00 74.65           O
HETATM 7482  O   HOH D3046     143.456 110.620  96.986  1.00 63.14           O
HETATM 7483  O   HOH D3047     138.392 126.819 115.826  1.00 76.21           O
HETATM 7484  O   HOH D3048     128.048 155.868 117.692  1.00 73.90           O
HETATM 7485  O   HOH D3049     123.294 143.978 120.810  1.00 74.28           O
HETATM 7486  O   HOH D3050     140.342 137.076 115.530  1.00 79.75           O
HETATM 7487  O   HOH D3051     120.146 144.080 120.958  1.00 76.36           O
HETATM 7488  O   HOH D3052     136.217 131.067 115.172  1.00 77.88           O
HETATM 7489  O   HOH D3053     116.894 176.257  98.463  1.00 79.47           O
HETATM 7490  O   HOH D3054     104.500 153.923  93.495  1.00 68.33           O
HETATM 7491  O   HOH D3055     140.218 159.373 103.859  1.00 72.68           O
HETATM 7492  O   HOH D3056     177.039 110.680 112.537  1.00 71.59           O
HETATM 7493  O   HOH D3057     131.071 148.955  85.499  1.00 71.22           O
HETATM 7494  O   HOH D3058     136.929 107.259  91.093  1.00 69.13           O
HETATM 7495  O   HOH D3059      82.425 127.259 100.047  1.00 77.79           O
HETATM 7496  O   HOH D3060     155.201 103.100  71.836  1.00 77.25           O
HETATM 7497  O   HOH D3061     176.728 109.158 116.080  1.00 72.72           O
HETATM 7498  O   HOH D3062     126.098 108.786  94.134  1.00 67.02           O
HETATM 7499  O   HOH D3063     164.894  93.716  85.265  1.00 73.80           O
HETATM 7500  O   HOH D3064     156.191 148.180 107.445  1.00 73.40           O
HETATM 7501  O   HOH D3065     142.140 112.562 112.271  1.00 73.96           O
HETATM 7502  O   HOH D3066     107.713 124.377  90.310  1.00 72.37           O
HETATM 7503  O   HOH D3067     153.726 108.556  92.919  1.00 69.34           O
HETATM 7504  O   HOH D3068     127.393 123.099  74.955  1.00 68.11           O
HETATM 7505  O   HOH D3069     128.800 147.790 104.830  1.00 68.39           O
HETATM 7506  O   HOH D3070     107.043 151.575  69.952  1.00 82.58           O
HETATM 7507  O   HOH D3071     117.202 142.358  87.979  1.00 68.30           O
HETATM 7508  O   HOH D3072     150.220 153.713 102.723  1.00 80.33           O
HETATM 7509  O   HOH D3073     152.057 134.751  90.054  1.00 69.22           O
HETATM 7510  O   HOH D3074     119.059 146.616  82.919  1.00 74.82           O
HETATM 7511  O   HOH D3075     115.790 157.166  75.610  1.00 81.07           O
HETATM 7512  O   HOH D3076     157.395 124.293 124.284  1.00 69.95           O
HETATM 7513  O   HOH D3077     148.814 143.944 109.704  1.00 77.30           O
HETATM 7514  O   HOH D3078     124.129 150.536  77.886  1.00 78.94           O
HETATM 7515  O   HOH D3079     153.706 126.859 123.675  1.00 74.46           O
HETATM 7516  O   HOH D3080     149.996 112.995  98.269  1.00 64.19           O
HETATM 7517  O   HOH D3081     157.787 111.879  93.575  1.00 64.12           O
HETATM 7518  O   HOH D3082     153.843 112.309  94.252  1.00 67.79           O
HETATM 7519  O   HOH D3083     110.355 116.959  90.958  1.00 66.83           O
HETATM 7520  O   HOH D3084     142.837 134.292 119.821  1.00 89.89           O
HETATM 7521  O   HOH D3085     125.822 130.987  73.931  1.00 68.38           O
HETATM 7522  O   HOH D3086     137.686 154.120 108.732  1.00 78.46           O
HETATM 7523  O   HOH D3087     151.234 116.128  83.595  1.00 56.17           O
HETATM 7524  O   HOH D3088     139.344 108.782  94.802  1.00 61.10           O
HETATM 7525  O   HOH D3089     139.579 135.596  80.141  1.00 67.57           O
HETATM 7526  O   HOH D3090     139.675 125.075 117.595  1.00 79.27           O
HETATM 7527  O   HOH D3091     169.467 106.349  98.280  1.00 65.35           O
HETATM 7528  O   HOH D3092     136.510 107.007  69.337  1.00 78.29           O
HETATM 7529  O   HOH D3093     146.312 108.346  93.710  1.00 70.13           O
HETATM 7530  O   HOH D3094     160.391 138.521 112.941  1.00 72.62           O
HETATM 7531  O   HOH D3095     123.348 129.864  75.020  1.00 66.92           O
HETATM 7532  O   HOH D3096     128.531 130.698  74.766  1.00 68.27           O
HETATM 7533  O   HOH D3097     159.868 109.924 108.676  1.00 62.08           O
HETATM 7534  O   HOH D3098     149.195 103.405  92.111  1.00 78.88           O
HETATM 7535  O   HOH D3099     157.297 138.033  91.038  1.00 69.38           O
HETATM 7536  O   HOH D3100     132.931 162.613 110.915  1.00 79.16           O
HETATM 7537  O   HOH D3101     138.295 122.245 117.618  1.00 75.39           O
HETATM 7538  O   HOH D3102     121.452 145.794  76.062  1.00 80.01           O
HETATM 7539  O   HOH D3103     160.924 134.412 118.141  1.00 68.37           O
HETATM 7540  O   HOH D3104     126.899 139.910 125.488  1.00 77.53           O
HETATM 7541  O   HOH D3105      88.043 140.600  70.688  1.00 87.75           O
HETATM 7542  O   HOH D3106     157.034 139.967  92.586  1.00 69.62           O
HETATM 7543  O   HOH D3107     135.124 165.840 100.040  1.00 72.37           O
HETATM 7544  O   HOH D3108      84.862 138.348  90.740  1.00 74.70           O
HETATM 7545  O   HOH D3109     119.963 108.367  92.925  1.00 65.84           O
HETATM 7546  O   HOH D3110     140.726 132.960 119.285  1.00 85.41           O
HETATM 7547  O   HOH D3111     150.508 111.793  95.398  1.00 62.27           O
HETATM 7548  O   HOH D3112     162.538 109.019 105.616  1.00 64.87           O
HETATM 7549  O   HOH D3113     145.346 131.830  83.991  1.00 67.38           O
HETATM 7550  O   HOH D3114     161.929 135.705 114.806  1.00 75.27           O
HETATM 7551  O   HOH D3115     178.679 109.125 102.006  1.00 70.53           O
HETATM 7552  O   HOH D3116     155.496 113.562 103.695  1.00 65.79           O
HETATM 7553  O   HOH D3117     130.398 169.126 106.653  1.00 73.82           O
HETATM 7554  O   HOH D3118     144.822 145.047  89.062  1.00 75.01           O
HETATM 7555  O   HOH D3119     135.788 146.566 118.337  1.00 77.86           O
HETATM 7556  O   HOH D3120     144.323 116.751  68.055  1.00 76.84           O
HETATM 7557  O   HOH D3121     157.743 113.484 106.824  1.00 66.59           O
HETATM 7558  O   HOH D3122     121.827 143.721  68.388  1.00 77.03           O
HETATM 7559  O   HOH D3123     138.591 132.512 115.865  1.00 80.89           O
HETATM 7560  O   HOH D3124     156.835 124.645  82.647  1.00 68.76           O
HETATM 7561  O   HOH D3125     145.894 111.384  97.031  1.00 67.20           O
HETATM 7562  O   HOH D3126     100.262 150.780  74.606  1.00 74.55           O
HETATM 7563  O   HOH D3127     147.213 147.843  88.978  1.00 76.27           O
HETATM 7564  O   HOH D3128     129.818 107.409  91.530  1.00 67.30           O
HETATM 7565  O   HOH D3129     119.191 143.302  84.068  1.00 73.26           O
HETATM 7566  O   HOH D3130      87.705 144.190  70.842  1.00 85.72           O
HETATM 7567  O   HOH D3131     142.250 108.406  95.671  1.00 66.25           O
HETATM 7568  O   HOH D3132     125.370 117.759  73.060  1.00 66.52           O
HETATM 7569  O   HOH D3133     136.417 135.810  76.591  1.00 64.67           O
HETATM 7570  O   HOH D3134     149.181 122.915  81.411  1.00 70.33           O
HETATM 7571  O   HOH D3135     122.689 107.084  92.834  1.00 69.63           O
HETATM 7572  O   HOH D3136     147.053 112.531  98.873  1.00 67.81           O
HETATM 7573  O   HOH D3137     121.773 177.496  90.953  1.00 81.23           O
HETATM 7574  O   HOH D3138     176.872 109.190  97.395  1.00 71.49           O
HETATM 7575  O   HOH D3139     155.462 111.362  92.879  1.00 68.04           O
HETATM 7576  O   HOH D3140     124.065 109.164 119.536  1.00 69.51           O
HETATM 7577  O   HOH D3141     125.328 111.901 118.403  1.00 67.21           O
HETATM 7578  O   HOH D3142     139.051 135.015 116.470  1.00 82.25           O
HETATM 7579  O   HOH D3143     142.220 115.372  67.267  1.00 76.66           O
HETATM 7580  O   HOH D3144     120.157 144.604  79.359  1.00 81.86           O
HETATM 7581  O   HOH D3145     120.470 146.627  80.504  1.00 78.94           O
HETATM 7582  O   HOH D3146     158.518 111.651 105.575  1.00 70.79           O
HETATM 7583  O   HOH D3147     114.792 152.470 120.899  1.00 76.74           O
HETATM 7584  O   HOH D3148     138.714 123.954 120.457  1.00 82.35           O
HETATM 7585  O   HOH D3149     137.454 126.484 120.527  1.00 86.99           O
"""
data_6cvm_frag_sym = """
ATOM      1  N   ILE A 351      85.984 118.452 121.905  1.00 48.51           N
ATOM      2  CA  ILE A 351      85.786 119.893 121.987  1.00 48.51           C
ATOM      3  C   ILE A 351      84.295 120.190 121.929  1.00 48.51           C
ATOM      4  O   ILE A 351      83.638 119.942 120.920  1.00 48.51           O
ATOM      5  CB  ILE A 351      86.539 120.620 120.871  1.00 48.51           C
ATOM      6  CG1 ILE A 351      88.039 120.403 121.018  1.00 48.51           C
ATOM      7  CG2 ILE A 351      86.195 122.081 120.857  1.00 48.51           C
ATOM      8  CD1 ILE A 351      88.595 120.916 122.294  1.00 48.51           C
ATOM      9  N   ARG A 352      83.760 120.702 123.026  1.00 47.54           N
ATOM     10  CA  ARG A 352      82.395 121.198 123.098  1.00 47.54           C
ATOM     11  C   ARG A 352      82.484 122.713 123.003  1.00 47.54           C
ATOM     12  O   ARG A 352      82.398 123.429 123.986  1.00 47.54           O
ATOM     13  CB  ARG A 352      81.759 120.747 124.394  1.00 47.54           C
ATOM     14  CG  ARG A 352      81.611 119.275 124.486  1.00 47.54           C
ATOM     15  CD  ARG A 352      81.308 118.858 125.867  1.00 47.54           C
ATOM     16  NE  ARG A 352      80.852 117.481 125.952  1.00 47.54           N
ATOM     17  CZ  ARG A 352      81.641 116.423 126.028  1.00 47.54           C
ATOM     18  NH1 ARG A 352      82.951 116.558 126.003  1.00 47.54           N
ATOM     19  NH2 ARG A 352      81.108 115.224 126.115  1.00 47.54           N
ATOM     20  N   GLY A 353      82.701 123.206 121.792  1.00 44.84           N
ATOM     21  CA  GLY A 353      83.123 124.569 121.596  1.00 44.84           C
ATOM     22  C   GLY A 353      82.049 125.482 121.041  1.00 44.84           C
ATOM     23  O   GLY A 353      81.036 125.056 120.504  1.00 44.84           O
ATOM     24  N   VAL A 354      82.313 126.773 121.171  1.00 46.30           N
ATOM     25  CA  VAL A 354      81.463 127.798 120.588  1.00 46.30           C
ATOM     26  C   VAL A 354      82.348 128.958 120.154  1.00 46.30           C
ATOM     27  O   VAL A 354      83.349 129.273 120.795  1.00 46.30           O
ATOM     28  CB  VAL A 354      80.343 128.216 121.570  1.00 46.30           C
ATOM     29  CG1 VAL A 354      80.884 128.866 122.814  1.00 46.30           C
ATOM     30  CG2 VAL A 354      79.324 129.098 120.896  1.00 46.30           C
ATOM     31  N   ASN A 355      82.019 129.534 119.012  1.00 51.63           N
ATOM     32  CA  ASN A 355      82.616 130.779 118.573  1.00 51.63           C
ATOM     33  C   ASN A 355      81.994 131.940 119.321  1.00 51.63           C
ATOM     34  O   ASN A 355      80.789 131.964 119.553  1.00 51.63           O
ATOM     35  CB  ASN A 355      82.384 130.951 117.087  1.00 51.63           C
ATOM     36  CG  ASN A 355      83.250 130.064 116.262  1.00 51.63           C
ATOM     37  OD1 ASN A 355      84.457 130.158 116.307  1.00 51.63           O
ATOM     38  ND2 ASN A 355      82.640 129.131 115.567  1.00 51.63           N
ATOM     39  N   ARG A 356      82.811 132.913 119.690  1.00 56.60           N
ATOM     40  CA  ARG A 356      82.323 134.057 120.443  1.00 56.60           C
ATOM     41  C   ARG A 356      82.961 135.330 119.922  1.00 56.60           C
ATOM     42  O   ARG A 356      84.179 135.485 119.988  1.00 56.60           O
ATOM     43  CB  ARG A 356      82.619 133.899 121.925  1.00 56.60           C
ATOM     44  CG  ARG A 356      82.184 135.071 122.741  1.00 56.60           C
ATOM     45  CD  ARG A 356      82.595 134.868 124.148  1.00 56.60           C
ATOM     46  NE  ARG A 356      82.247 135.977 125.010  1.00 56.60           N
ATOM     47  CZ  ARG A 356      83.054 136.996 125.251  1.00 56.60           C
ATOM     48  NH1 ARG A 356      84.248 137.045 124.690  1.00 56.60           N
ATOM     49  NH2 ARG A 356      82.667 137.957 126.058  1.00 56.60           N
ATOM     50  N   HIS A 357      82.138 136.235 119.415  1.00 61.60           N
ATOM     51  CA  HIS A 357      82.561 137.605 119.189  1.00 61.60           C
ATOM     52  C   HIS A 357      82.449 138.423 120.461  1.00 61.60           C
ATOM     53  O   HIS A 357      81.612 138.160 121.323  1.00 61.60           O
ATOM     54  CB  HIS A 357      81.722 138.271 118.106  1.00 61.60           C
ATOM     55  CG  HIS A 357      82.171 137.970 116.717  1.00 61.60           C
ATOM     56  ND1 HIS A 357      83.276 138.568 116.155  1.00 61.60           N
ATOM     57  CD2 HIS A 357      81.642 137.181 115.756  1.00 61.60           C
ATOM     58  CE1 HIS A 357      83.425 138.138 114.917  1.00 61.60           C
ATOM     59  NE2 HIS A 357      82.447 137.293 114.651  1.00 61.60           N
ATOM     60  N   GLU A 358      83.300 139.430 120.565  1.00 65.08           N
ATOM     61  CA  GLU A 358      83.164 140.447 121.599  1.00 65.08           C
ATOM     62  C   GLU A 358      82.086 141.425 121.170  1.00 65.08           C
ATOM     63  O   GLU A 358      82.308 142.272 120.309  1.00 65.08           O
ATOM     64  CB  GLU A 358      84.486 141.157 121.833  1.00 65.08           C
ATOM     65  CG  GLU A 358      85.464 140.356 122.628  1.00 65.08           C
ATOM     66  CD  GLU A 358      86.752 141.099 122.870  1.00 65.08           C
ATOM     67  OE1 GLU A 358      86.994 142.121 122.201  1.00 65.08           O
ATOM     68  OE2 GLU A 358      87.505 140.691 123.768  1.00 65.08           O
ATOM     69  N   HIS A 359      80.909 141.311 121.768  1.00 64.23           N
ATOM     70  CA  HIS A 359      79.791 142.144 121.368  1.00 64.23           C
ATOM     71  C   HIS A 359      78.944 142.481 122.577  1.00 64.23           C
ATOM     72  O   HIS A 359      78.643 141.608 123.390  1.00 64.23           O
ATOM     73  CB  HIS A 359      78.930 141.451 120.320  1.00 64.23           C
ATOM     74  CG  HIS A 359      77.752 142.257 119.890  1.00 64.23           C
ATOM     75  ND1 HIS A 359      77.846 143.285 118.981  1.00 64.23           N
ATOM     76  CD2 HIS A 359      76.459 142.217 120.280  1.00 64.23           C
ATOM     77  CE1 HIS A 359      76.655 143.823 118.807  1.00 64.23           C
ATOM     78  NE2 HIS A 359      75.797 143.197 119.588  1.00 64.23           N
ATOM     79  N   HIS A 360      78.565 143.744 122.684  1.00 67.87           N
ATOM     80  CA  HIS A 360      77.598 144.191 123.658  1.00 67.87           C
ATOM     81  C   HIS A 360      76.583 145.029 122.892  1.00 67.87           C
ATOM     82  O   HIS A 360      76.977 145.849 122.055  1.00 67.87           O
ATOM     83  CB  HIS A 360      78.260 145.006 124.764  1.00 67.87           C
ATOM     84  CG  HIS A 360      77.369 145.262 125.932  1.00 67.87           C
ATOM     85  ND1 HIS A 360      76.455 146.290 125.958  1.00 67.87           N
ATOM     86  CD2 HIS A 360      77.249 144.622 127.117  1.00 67.87           C
ATOM     87  CE1 HIS A 360      75.805 146.269 127.106  1.00 67.87           C
ATOM     88  NE2 HIS A 360      76.271 145.268 127.829  1.00 67.87           N
ATOM     89  N   PRO A 361      75.282 144.845 123.124  1.00 67.53           N
ATOM     90  CA  PRO A 361      74.286 145.540 122.296  1.00 67.53           C
ATOM     91  C   PRO A 361      74.216 147.033 122.536  1.00 67.53           C
ATOM     92  O   PRO A 361      73.778 147.762 121.643  1.00 67.53           O
ATOM     93  CB  PRO A 361      72.975 144.863 122.691  1.00 67.53           C
ATOM     94  CG  PRO A 361      73.214 144.391 124.058  1.00 67.53           C
ATOM     95  CD  PRO A 361      74.644 143.990 124.134  1.00 67.53           C
ATOM     96  N   LEU A 362      74.637 147.512 123.699  1.00 71.50           N
ATOM     97  CA  LEU A 362      74.648 148.935 123.994  1.00 71.50           C
ATOM     98  C   LEU A 362      75.990 149.586 123.729  1.00 71.50           C
ATOM     99  O   LEU A 362      76.036 150.721 123.254  1.00 71.50           O
ATOM    100  CB  LEU A 362      74.261 149.172 125.452  1.00 71.50           C
ATOM    101  CG  LEU A 362      72.815 148.830 125.777  1.00 71.50           C
ATOM    102  CD1 LEU A 362      72.573 148.925 127.266  1.00 71.50           C
ATOM    103  CD2 LEU A 362      71.899 149.765 125.024  1.00 71.50           C
ATOM    104  N   HIS A 363      77.084 148.892 124.015  1.00 70.40           N
ATOM    105  CA  HIS A 363      78.407 149.485 123.950  1.00 70.40           C
ATOM    106  C   HIS A 363      79.206 149.004 122.755  1.00 70.40           C
ATOM    107  O   HIS A 363      80.385 149.337 122.643  1.00 70.40           O
ATOM    108  CB  HIS A 363      79.164 149.196 125.238  1.00 70.40           C
ATOM    109  CG  HIS A 363      78.451 149.670 126.458  1.00 70.40           C
ATOM    110  ND1 HIS A 363      78.270 151.005 126.739  1.00 70.40           N
ATOM    111  CD2 HIS A 363      77.876 148.989 127.474  1.00 70.40           C
ATOM    112  CE1 HIS A 363      77.606 151.125 127.872  1.00 70.40           C
ATOM    113  NE2 HIS A 363      77.358 149.917 128.341  1.00 70.40           N
ATOM    114  N   GLY A 364      78.597 148.240 121.861  1.00 67.37           N
ATOM    115  CA  GLY A 364      79.293 147.763 120.689  1.00 67.37           C
ATOM    116  C   GLY A 364      80.331 146.716 121.011  1.00 67.37           C
ATOM    117  O   GLY A 364      80.013 145.658 121.550  1.00 67.37           O
ATOM    118  N   GLN A 365      81.588 147.014 120.710  1.00 65.98           N
ATOM    119  CA  GLN A 365      82.667 146.056 120.866  1.00 65.98           C
ATOM    120  C   GLN A 365      83.509 146.327 122.100  1.00 65.98           C
ATOM    121  O   GLN A 365      84.663 145.903 122.164  1.00 65.98           O
ATOM    122  CB  GLN A 365      83.508 146.047 119.597  1.00 65.98           C
ATOM    123  CG  GLN A 365      82.682 145.560 118.436  1.00 65.98           C
ATOM    124  CD  GLN A 365      83.372 145.664 117.115  1.00 65.98           C
ATOM    125  OE1 GLN A 365      84.470 146.197 117.015  1.00 65.98           O
ATOM    126  NE2 GLN A 365      82.728 145.154 116.080  1.00 65.98           N
ATOM    127  N   VAL A 366      82.942 146.997 123.091  1.00 66.98           N
ATOM    128  CA  VAL A 366      83.613 147.279 124.349  1.00 66.98           C
ATOM    129  C   VAL A 366      83.147 146.257 125.369  1.00 66.98           C
ATOM    130  O   VAL A 366      81.953 146.165 125.663  1.00 66.98           O
ATOM    131  CB  VAL A 366      83.320 148.705 124.825  1.00 66.98           C
ATOM    132  CG1 VAL A 366      83.933 148.947 126.175  1.00 66.98           C
ATOM    133  CG2 VAL A 366      83.851 149.668 123.827  1.00 66.98           C
ATOM    134  N   MET A 367      84.083 145.495 125.914  1.00 72.90           N
ATOM    135  CA  MET A 367      83.771 144.420 126.839  1.00 72.90           C
ATOM    136  C   MET A 367      84.249 144.762 128.236  1.00 72.90           C
ATOM    137  O   MET A 367      85.387 145.196 128.418  1.00 72.90           O
ATOM    138  CB  MET A 367      84.409 143.109 126.393  1.00 72.90           C
ATOM    139  CG  MET A 367      83.818 142.547 125.142  1.00 72.90           C
ATOM    140  SD  MET A 367      82.044 142.330 125.297  1.00 72.90           S
ATOM    141  CE  MET A 367      82.005 141.162 126.633  1.00 72.90           C
ATOM    142  N   ASP A 368      83.382 144.556 129.214  1.00 74.72           N
ATOM    143  CA  ASP A 368      83.738 144.657 130.616  1.00 74.72           C
ATOM    144  C   ASP A 368      83.749 143.273 131.247  1.00 74.72           C
ATOM    145  O   ASP A 368      83.377 142.282 130.622  1.00 74.72           O
ATOM    146  CB  ASP A 368      82.778 145.586 131.357  1.00 74.72           C
ATOM    147  CG  ASP A 368      81.333 145.202 131.172  1.00 74.72           C
ATOM    148  OD1 ASP A 368      81.034 144.342 130.324  1.00 74.72           O
ATOM    149  OD2 ASP A 368      80.484 145.754 131.896  1.00 74.72           O
ATOM    150  N   GLU A 369      84.174 143.224 132.510  1.00 72.94           N
ATOM    151  CA  GLU A 369      84.347 141.946 133.188  1.00 72.94           C
ATOM    152  C   GLU A 369      83.020 141.259 133.463  1.00 72.94           C
ATOM    153  O   GLU A 369      82.935 140.033 133.361  1.00 72.94           O
ATOM    154  CB  GLU A 369      85.117 142.144 134.488  1.00 72.94           C
ATOM    155  CG  GLU A 369      85.427 140.860 135.219  1.00 72.94           C
ATOM    156  CD  GLU A 369      86.363 141.058 136.381  1.00 72.94           C
ATOM    157  OE1 GLU A 369      86.786 142.208 136.612  1.00 72.94           O
ATOM    158  OE2 GLU A 369      86.683 140.061 137.061  1.00 72.94           O
ATOM    159  N   GLN A 370      81.976 142.026 133.766  1.00 73.01           N
ATOM    160  CA  GLN A 370      80.704 141.436 134.163  1.00 73.01           C
ATOM    161  C   GLN A 370      80.027 140.716 133.010  1.00 73.01           C
ATOM    162  O   GLN A 370      79.379 139.690 133.222  1.00 73.01           O
ATOM    163  CB  GLN A 370      79.772 142.506 134.724  1.00 73.01           C
ATOM    164  CG  GLN A 370      80.065 142.929 136.157  1.00 73.01           C
ATOM    165  CD  GLN A 370      81.349 143.723 136.301  1.00 73.01           C
ATOM    166  OE1 GLN A 370      82.243 143.347 137.058  1.00 73.01           O
ATOM    167  NE2 GLN A 370      81.460 144.810 135.545  1.00 73.01           N
ATOM    168  N   THR A 371      80.182 141.217 131.791  1.00 69.35           N
ATOM    169  CA  THR A 371      79.631 140.517 130.645  1.00 69.35           C
ATOM    170  C   THR A 371      80.462 139.287 130.303  1.00 69.35           C
ATOM    171  O   THR A 371      79.912 138.275 129.864  1.00 69.35           O
ATOM    172  CB  THR A 371      79.538 141.471 129.459  1.00 69.35           C
ATOM    173  OG1 THR A 371      78.859 142.657 129.874  1.00 69.35           O
ATOM    174  CG2 THR A 371      78.732 140.862 128.337  1.00 69.35           C
ATOM    175  N   MET A 372      81.777 139.346 130.526  1.00 66.00           N
ATOM    176  CA  MET A 372      82.624 138.182 130.291  1.00 66.00           C
ATOM    177  C   MET A 372      82.319 137.064 131.269  1.00 66.00           C
ATOM    178  O   MET A 372      82.292 135.894 130.882  1.00 66.00           O
ATOM    179  CB  MET A 372      84.092 138.546 130.410  1.00 66.00           C
ATOM    180  CG  MET A 372      84.606 139.464 129.378  1.00 66.00           C
ATOM    181  SD  MET A 372      86.337 139.738 129.710  1.00 66.00           S
ATOM    182  CE  MET A 372      86.609 141.084 128.607  1.00 66.00           C
ATOM    183  N   VAL A 373      82.124 137.401 132.542  1.00 63.75           N
ATOM    184  CA  VAL A 373      81.793 136.390 133.534  1.00 63.75           C
ATOM    185  C   VAL A 373      80.414 135.818 133.257  1.00 63.75           C
ATOM    186  O   VAL A 373      80.199 134.611 133.379  1.00 63.75           O
ATOM    187  CB  VAL A 373      81.910 136.980 134.950  1.00 63.75           C
ATOM    188  CG1 VAL A 373      81.433 136.006 135.995  1.00 63.75           C
ATOM    189  CG2 VAL A 373      83.336 137.338 135.232  1.00 63.75           C
ATOM    190  N   GLN A 374      79.487 136.661 132.802  1.00 64.23           N
ATOM    191  CA  GLN A 374      78.154 136.197 132.438  1.00 64.23           C
ATOM    192  C   GLN A 374      78.198 135.227 131.265  1.00 64.23           C
ATOM    193  O   GLN A 374      77.448 134.247 131.240  1.00 64.23           O
ATOM    194  CB  GLN A 374      77.268 137.390 132.098  1.00 64.23           C
ATOM    195  CG  GLN A 374      75.826 137.042 131.863  1.00 64.23           C
ATOM    196  CD  GLN A 374      74.996 138.237 131.473  1.00 64.23           C
ATOM    197  OE1 GLN A 374      75.518 139.324 131.253  1.00 64.23           O
ATOM    198  NE2 GLN A 374      73.691 138.046 131.401  1.00 64.23           N
ATOM    199  N   ASP A 375      79.086 135.467 130.300  1.00 60.83           N
ATOM    200  CA  ASP A 375      79.214 134.549 129.177  1.00 60.83           C
ATOM    201  C   ASP A 375      79.809 133.218 129.605  1.00 60.83           C
ATOM    202  O   ASP A 375      79.321 132.167 129.190  1.00 60.83           O
ATOM    203  CB  ASP A 375      80.058 135.159 128.064  1.00 60.83           C
ATOM    204  CG  ASP A 375      79.302 136.176 127.251  1.00 60.83           C
ATOM    205  OD1 ASP A 375      78.065 136.111 127.225  1.00 60.83           O
ATOM    206  OD2 ASP A 375      79.943 137.017 126.599  1.00 60.83           O
ATOM    207  N   ILE A 376      80.842 133.241 130.447  1.00 57.84           N
ATOM    208  CA  ILE A 376      81.538 132.016 130.825  1.00 57.84           C
ATOM    209  C   ILE A 376      80.658 131.129 131.687  1.00 57.84           C
ATOM    210  O   ILE A 376      80.664 129.904 131.532  1.00 57.84           O
ATOM    211  CB  ILE A 376      82.866 132.358 131.517  1.00 57.84           C
ATOM    212  CG1 ILE A 376      83.809 132.942 130.497  1.00 57.84           C
ATOM    213  CG2 ILE A 376      83.529 131.152 132.122  1.00 57.84           C
ATOM    214  CD1 ILE A 376      85.025 133.472 131.070  1.00 57.84           C
ATOM    215  N   LEU A 377      79.854 131.726 132.569  1.00 57.63           N
ATOM    216  CA  LEU A 377      78.948 130.917 133.371  1.00 57.63           C
ATOM    217  C   LEU A 377      77.881 130.269 132.505  1.00 57.63           C
ATOM    218  O   LEU A 377      77.628 129.077 132.643  1.00 57.63           O
ATOM    219  CB  LEU A 377      78.294 131.736 134.476  1.00 57.63           C
ATOM    220  CG  LEU A 377      79.179 132.424 135.509  1.00 57.63           C
ATOM    221  CD1 LEU A 377      78.356 132.988 136.648  1.00 57.63           C
ATOM    222  CD2 LEU A 377      80.309 131.583 135.985  1.00 57.63           C
ATOM    223  N   LEU A 378      77.299 131.018 131.568  1.00 56.00           N
ATOM    224  CA  LEU A 378      76.302 130.444 130.670  1.00 56.00           C
ATOM    225  C   LEU A 378      76.878 129.375 129.759  1.00 56.00           C
ATOM    226  O   LEU A 378      76.174 128.428 129.409  1.00 56.00           O
ATOM    227  CB  LEU A 378      75.663 131.528 129.819  1.00 56.00           C
ATOM    228  CG  LEU A 378      74.659 132.439 130.485  1.00 56.00           C
ATOM    229  CD1 LEU A 378      74.295 133.533 129.524  1.00 56.00           C
ATOM    230  CD2 LEU A 378      73.451 131.623 130.838  1.00 56.00           C
ATOM    231  N   MET A 379      78.141 129.507 129.364  1.00 54.55           N
ATOM    232  CA  MET A 379      78.772 128.482 128.546  1.00 54.55           C
ATOM    233  C   MET A 379      78.969 127.194 129.322  1.00 54.55           C
ATOM    234  O   MET A 379      78.656 126.111 128.825  1.00 54.55           O
ATOM    235  CB  MET A 379      80.101 128.984 128.014  1.00 54.55           C
ATOM    236  CG  MET A 379      79.952 129.968 126.917  1.00 54.55           C
ATOM    237  SD  MET A 379      81.508 130.714 126.503  1.00 54.55           S
ATOM    238  CE  MET A 379      80.953 131.823 125.249  1.00 54.55           C
ATOM    239  N   LYS A 380      79.483 127.288 130.542  1.00 54.17           N
ATOM    240  CA  LYS A 380      79.755 126.077 131.296  1.00 54.17           C
ATOM    241  C   LYS A 380      78.483 125.441 131.825  1.00 54.17           C
ATOM    242  O   LYS A 380      78.420 124.219 131.953  1.00 54.17           O
ATOM    243  CB  LYS A 380      80.728 126.370 132.425  1.00 54.17           C
ATOM    244  CG  LYS A 380      82.102 126.688 131.922  1.00 54.17           C
ATOM    245  CD  LYS A 380      83.064 126.853 133.046  1.00 54.17           C
ATOM    246  CE  LYS A 380      83.369 125.521 133.674  1.00 54.17           C
ATOM    247  NZ  LYS A 380      84.117 124.635 132.770  1.00 54.17           N
ATOM    248  N   GLN A 381      77.450 126.234 132.092  1.00 55.58           N
ATOM    249  CA  GLN A 381      76.163 125.679 132.484  1.00 55.58           C
ATOM    250  C   GLN A 381      75.442 125.000 131.335  1.00 55.58           C
ATOM    251  O   GLN A 381      74.471 124.287 131.573  1.00 55.58           O
ATOM    252  CB  GLN A 381      75.284 126.773 133.071  1.00 55.58           C
ATOM    253  CG  GLN A 381      75.752 127.247 134.418  1.00 55.58           C
ATOM    254  CD  GLN A 381      75.105 128.535 134.826  1.00 55.58           C
ATOM    255  OE1 GLN A 381      74.232 129.043 134.139  1.00 55.58           O
ATOM    256  NE2 GLN A 381      75.584 129.115 135.909  1.00 55.58           N
ATOM    257  N   ASN A 382      75.895 125.194 130.108  1.00 50.40           N
ATOM    258  CA  ASN A 382      75.321 124.560 128.937  1.00 50.40           C
ATOM    259  C   ASN A 382      76.302 123.600 128.288  1.00 50.40           C
ATOM    260  O   ASN A 382      76.234 123.356 127.087  1.00 50.40           O
ATOM    261  CB  ASN A 382      74.858 125.638 127.972  1.00 50.40           C
ATOM    262  CG  ASN A 382      73.650 126.346 128.480  1.00 50.40           C
ATOM    263  OD1 ASN A 382      72.630 125.732 128.725  1.00 50.40           O
ATOM    264  ND2 ASN A 382      73.794 127.617 128.772  1.00 50.40           N
ATOM    265  N   ASN A 383      77.239 123.095 129.091  1.00 48.74           N
ATOM    266  CA  ASN A 383      78.156 122.008 128.753  1.00 48.74           C
ATOM    267  C   ASN A 383      79.108 122.366 127.621  1.00 48.74           C
ATOM    268  O   ASN A 383      79.518 121.503 126.857  1.00 48.74           O
ATOM    269  CB  ASN A 383      77.403 120.716 128.429  1.00 48.74           C
ATOM    270  CG  ASN A 383      76.672 120.170 129.611  1.00 48.74           C
ATOM    271  OD1 ASN A 383      77.164 120.216 130.723  1.00 48.74           O
ATOM    272  ND2 ASN A 383      75.493 119.643 129.381  1.00 48.74           N
ATOM    273  N   PHE A 384      79.477 123.629 127.500  1.00 46.24           N
ATOM    274  CA  PHE A 384      80.572 124.014 126.627  1.00 46.24           C
ATOM    275  C   PHE A 384      81.874 123.974 127.411  1.00 46.24           C
ATOM    276  O   PHE A 384      81.912 124.350 128.578  1.00 46.24           O
ATOM    277  CB  PHE A 384      80.351 125.411 126.053  1.00 46.24           C
ATOM    278  CG  PHE A 384      79.267 125.486 125.030  1.00 46.24           C
ATOM    279  CD1 PHE A 384      79.528 125.198 123.709  1.00 46.24           C
ATOM    280  CD2 PHE A 384      77.989 125.841 125.387  1.00 46.24           C
ATOM    281  CE1 PHE A 384      78.536 125.268 122.772  1.00 46.24           C
ATOM    282  CE2 PHE A 384      76.996 125.908 124.450  1.00 46.24           C
ATOM    283  CZ  PHE A 384      77.272 125.622 123.144  1.00 46.24           C
ATOM    284  N   ASN A 385      82.938 123.500 126.776  1.00 47.51           N
ATOM    285  CA  ASN A 385      84.245 123.539 127.408  1.00 47.51           C
ATOM    286  C   ASN A 385      85.289 124.298 126.606  1.00 47.51           C
ATOM    287  O   ASN A 385      86.449 124.328 127.013  1.00 47.51           O
ATOM    288  CB  ASN A 385      84.750 122.121 127.735  1.00 47.51           C
ATOM    289  CG  ASN A 385      84.941 121.226 126.515  1.00 47.51           C
ATOM    290  OD1 ASN A 385      84.801 121.629 125.376  1.00 47.51           O
ATOM    291  ND2 ASN A 385      85.276 119.984 126.775  1.00 47.51           N
ATOM    292  N   ALA A 386      84.925 124.900 125.484  1.00 45.28           N
ATOM    293  CA  ALA A 386      85.917 125.535 124.640  1.00 45.28           C
ATOM    294  C   ALA A 386      85.319 126.750 123.959  1.00 45.28           C
ATOM    295  O   ALA A 386      84.123 126.802 123.694  1.00 45.28           O
ATOM    296  CB  ALA A 386      86.473 124.569 123.603  1.00 45.28           C
ATOM    297  N   VAL A 387      86.158 127.750 123.719  1.00 47.41           N
ATOM    298  CA  VAL A 387      85.757 128.990 123.068  1.00 47.41           C
ATOM    299  C   VAL A 387      86.781 129.299 121.992  1.00 47.41           C
ATOM    300  O   VAL A 387      87.984 129.216 122.239  1.00 47.41           O
ATOM    301  CB  VAL A 387      85.661 130.172 124.053  1.00 47.41           C
ATOM    302  CG1 VAL A 387      85.175 131.408 123.357  1.00 47.41           C
ATOM    303  CG2 VAL A 387      84.744 129.881 125.164  1.00 47.41           C
ATOM    304  N   ARG A 388      86.315 129.649 120.808  1.00 52.67           N
ATOM    305  CA  ARG A 388      87.184 130.147 119.759  1.00 52.67           C
ATOM    306  C   ARG A 388      87.037 131.656 119.673  1.00 52.67           C
ATOM    307  O   ARG A 388      85.924 132.173 119.572  1.00 52.67           O
ATOM    308  CB  ARG A 388      86.862 129.470 118.433  1.00 52.67           C
ATOM    309  CG  ARG A 388      87.695 129.914 117.274  1.00 52.67           C
ATOM    310  CD  ARG A 388      87.528 128.957 116.129  1.00 52.67           C
ATOM    311  NE  ARG A 388      88.202 129.417 114.929  1.00 52.67           N
ATOM    312  CZ  ARG A 388      87.592 130.038 113.930  1.00 52.67           C
ATOM    313  NH1 ARG A 388      86.289 130.240 113.977  1.00 52.67           N
ATOM    314  NH2 ARG A 388      88.276 130.430 112.870  1.00 52.67           N
ATOM    315  N   CYS A 389      88.159 132.357 119.754  1.00 59.66           N
ATOM    316  CA  CYS A 389      88.197 133.817 119.741  1.00 59.66           C
ATOM    317  C   CYS A 389      88.022 134.280 118.308  1.00 59.66           C
ATOM    318  O   CYS A 389      88.989 134.537 117.602  1.00 59.66           O
ATOM    319  CB  CYS A 389      89.516 134.322 120.304  1.00 59.66           C
ATOM    320  SG  CYS A 389      89.871 133.807 121.964  1.00 59.66           S
ATOM    321  N   SER A 390      86.782 134.406 117.871  1.00 58.60           N
ATOM    322  CA  SER A 390      86.486 134.655 116.469  1.00 58.60           C
ATOM    323  C   SER A 390      86.308 136.150 116.220  1.00 58.60           C
ATOM    324  O   SER A 390      85.467 136.781 116.862  1.00 58.60           O
ATOM    325  CB  SER A 390      85.229 133.896 116.068  1.00 58.60           C
ATOM    326  OG  SER A 390      84.103 134.402 116.745  1.00 58.60           O
ATOM    327  N   HIS A 391      87.112 136.729 115.321  1.00 59.22           N
ATOM    328  CA  HIS A 391      88.323 136.124 114.781  1.00 59.22           C
ATOM    329  C   HIS A 391      89.452 137.107 114.969  1.00 59.22           C
ATOM    330  O   HIS A 391      89.916 137.699 114.004  1.00 59.22           O
ATOM    331  CB  HIS A 391      88.179 135.837 113.293  1.00 59.22           C
ATOM    332  CG  HIS A 391      86.990 135.012 112.941  1.00 59.22           C
ATOM    333  ND1 HIS A 391      86.951 133.649 113.113  1.00 59.22           N
ATOM    334  CD2 HIS A 391      85.787 135.364 112.435  1.00 59.22           C
ATOM    335  CE1 HIS A 391      85.778 133.195 112.721  1.00 59.22           C
ATOM    336  NE2 HIS A 391      85.052 134.215 112.307  1.00 59.22           N
ATOM    337  N   TYR A 392      89.944 137.202 116.185  1.00 58.66           N
ATOM    338  CA  TYR A 392      90.877 138.223 116.640  1.00 58.66           C
ATOM    339  C   TYR A 392      91.251 137.927 118.082  1.00 58.66           C
ATOM    340  O   TYR A 392      90.505 137.219 118.760  1.00 58.66           O
ATOM    341  CB  TYR A 392      90.295 139.639 116.493  1.00 58.66           C
ATOM    342  CG  TYR A 392      88.875 139.835 116.944  1.00 58.66           C
ATOM    343  CD1 TYR A 392      88.547 139.922 118.282  1.00 58.66           C
ATOM    344  CD2 TYR A 392      87.856 139.917 116.015  1.00 58.66           C
ATOM    345  CE1 TYR A 392      87.251 140.084 118.678  1.00 58.66           C
ATOM    346  CE2 TYR A 392      86.564 140.089 116.400  1.00 58.66           C
ATOM    347  CZ  TYR A 392      86.264 140.170 117.729  1.00 58.66           C
ATOM    348  OH  TYR A 392      84.960 140.339 118.110  1.00 58.66           O
ATOM    349  N   PRO A 393      92.387 138.416 118.579  1.00 57.99           N
ATOM    350  CA  PRO A 393      92.693 138.235 119.998  1.00 57.99           C
ATOM    351  C   PRO A 393      91.726 139.015 120.862  1.00 57.99           C
ATOM    352  O   PRO A 393      91.353 140.141 120.539  1.00 57.99           O
ATOM    353  CB  PRO A 393      94.113 138.786 120.122  1.00 57.99           C
ATOM    354  CG  PRO A 393      94.652 138.725 118.777  1.00 57.99           C
ATOM    355  CD  PRO A 393      93.530 139.005 117.869  1.00 57.99           C
ATOM    356  N   ASN A 394      91.297 138.403 121.954  1.00 61.43           N
ATOM    357  CA  ASN A 394      90.343 139.095 122.792  1.00 61.43           C
ATOM    358  C   ASN A 394      91.027 140.058 123.745  1.00 61.43           C
ATOM    359  O   ASN A 394      92.245 140.235 123.748  1.00 61.43           O
ATOM    360  CB  ASN A 394      89.479 138.134 123.597  1.00 61.43           C
ATOM    361  CG  ASN A 394      88.440 137.462 122.766  1.00 61.43           C
ATOM    362  OD1 ASN A 394      88.185 136.287 122.915  1.00 61.43           O
ATOM    363  ND2 ASN A 394      87.889 138.189 121.819  1.00 61.43           N
ATOM    364  N   HIS A 395      90.183 140.712 124.520  1.00 65.16           N
ATOM    365  CA  HIS A 395      90.579 141.481 125.682  1.00 65.16           C
ATOM    366  C   HIS A 395      91.393 140.601 126.625  1.00 65.16           C
ATOM    367  O   HIS A 395      91.083 139.417 126.775  1.00 65.16           O
ATOM    368  CB  HIS A 395      89.307 141.979 126.364  1.00 65.16           C
ATOM    369  CG  HIS A 395      89.531 142.940 127.479  1.00 65.16           C
ATOM    370  ND1 HIS A 395      89.886 142.537 128.745  1.00 65.16           N
ATOM    371  CD2 HIS A 395      89.382 144.281 127.538  1.00 65.16           C
ATOM    372  CE1 HIS A 395      89.990 143.594 129.527  1.00 65.16           C
ATOM    373  NE2 HIS A 395      89.687 144.666 128.820  1.00 65.16           N
ATOM    374  N   PRO A 396      92.445 141.131 127.254  1.00 63.79           N
ATOM    375  CA  PRO A 396      93.357 140.271 128.025  1.00 63.79           C
ATOM    376  C   PRO A 396      92.740 139.636 129.250  1.00 63.79           C
ATOM    377  O   PRO A 396      93.232 138.596 129.693  1.00 63.79           O
ATOM    378  CB  PRO A 396      94.481 141.232 128.422  1.00 63.79           C
ATOM    379  CG  PRO A 396      94.418 142.303 127.435  1.00 63.79           C
ATOM    380  CD  PRO A 396      92.982 142.490 127.111  1.00 63.79           C
ATOM    381  N   LEU A 397      91.673 140.207 129.798  1.00 62.71           N
ATOM    382  CA  LEU A 397      91.013 139.617 130.951  1.00 62.71           C
ATOM    383  C   LEU A 397      90.268 138.340 130.597  1.00 62.71           C
ATOM    384  O   LEU A 397      90.049 137.502 131.475  1.00 62.71           O
ATOM    385  CB  LEU A 397      90.068 140.643 131.560  1.00 62.71           C
ATOM    386  CG  LEU A 397      89.336 140.323 132.850  1.00 62.71           C
ATOM    387  CD1 LEU A 397      90.334 140.035 133.936  1.00 62.71           C
ATOM    388  CD2 LEU A 397      88.494 141.497 133.207  1.00 62.71           C
ATOM    389  N   TRP A 398      89.903 138.169 129.327  1.00 57.16           N
ATOM    390  CA  TRP A 398      89.182 136.983 128.888  1.00 57.16           C
ATOM    391  C   TRP A 398      89.996 135.717 129.087  1.00 57.16           C
ATOM    392  O   TRP A 398      89.459 134.689 129.502  1.00 57.16           O
ATOM    393  CB  TRP A 398      88.797 137.139 127.427  1.00 57.16           C
ATOM    394  CG  TRP A 398      88.151 135.961 126.861  1.00 57.16           C
ATOM    395  CD1 TRP A 398      88.692 135.081 125.991  1.00 57.16           C
ATOM    396  CD2 TRP A 398      86.834 135.505 127.130  1.00 57.16           C
ATOM    397  NE1 TRP A 398      87.790 134.107 125.685  1.00 57.16           N
ATOM    398  CE2 TRP A 398      86.637 134.345 126.378  1.00 57.16           C
ATOM    399  CE3 TRP A 398      85.797 135.972 127.932  1.00 57.16           C
ATOM    400  CZ2 TRP A 398      85.450 133.642 126.403  1.00 57.16           C
ATOM    401  CZ3 TRP A 398      84.625 135.281 127.950  1.00 57.16           C
ATOM    402  CH2 TRP A 398      84.456 134.126 127.195  1.00 57.16           C
ATOM    403  N   TYR A 399      91.296 135.781 128.819  1.00 57.98           N
ATOM    404  CA  TYR A 399      92.142 134.609 128.967  1.00 57.98           C
ATOM    405  C   TYR A 399      92.357 134.268 130.426  1.00 57.98           C
ATOM    406  O   TYR A 399      92.461 133.093 130.770  1.00 57.98           O
ATOM    407  CB  TYR A 399      93.478 134.844 128.279  1.00 57.98           C
ATOM    408  CG  TYR A 399      93.317 135.179 126.835  1.00 57.98           C
ATOM    409  CD1 TYR A 399      93.084 134.195 125.901  1.00 57.98           C
ATOM    410  CD2 TYR A 399      93.371 136.491 126.406  1.00 57.98           C
ATOM    411  CE1 TYR A 399      92.921 134.504 124.582  1.00 57.98           C
ATOM    412  CE2 TYR A 399      93.206 136.806 125.094  1.00 57.98           C
ATOM    413  CZ  TYR A 399      92.985 135.812 124.186  1.00 57.98           C
ATOM    414  OH  TYR A 399      92.825 136.128 122.869  1.00 57.98           O
ATOM    415  N   THR A 400      92.412 135.283 131.286  1.00 60.01           N
ATOM    416  CA  THR A 400      92.531 135.063 132.720  1.00 60.01           C
ATOM    417  C   THR A 400      91.301 134.361 133.270  1.00 60.01           C
ATOM    418  O   THR A 400      91.412 133.430 134.070  1.00 60.01           O
ATOM    419  CB  THR A 400      92.743 136.401 133.420  1.00 60.01           C
ATOM    420  OG1 THR A 400      93.946 137.000 132.937  1.00 60.01           O
ATOM    421  CG2 THR A 400      92.844 136.227 134.909  1.00 60.01           C
ATOM    422  N   LEU A 401      90.122 134.774 132.825  1.00 58.69           N
ATOM    423  CA  LEU A 401      88.897 134.149 133.294  1.00 58.69           C
ATOM    424  C   LEU A 401      88.730 132.743 132.739  1.00 58.69           C
ATOM    425  O   LEU A 401      88.156 131.884 133.407  1.00 58.69           O
ATOM    426  CB  LEU A 401      87.710 135.015 132.919  1.00 58.69           C
ATOM    427  CG  LEU A 401      87.610 136.393 133.549  1.00 58.69           C
ATOM    428  CD1 LEU A 401      86.465 137.131 132.931  1.00 58.69           C
ATOM    429  CD2 LEU A 401      87.420 136.265 135.025  1.00 58.69           C
ATOM    430  N   CYS A 402      89.230 132.482 131.535  1.00 56.47           N
ATOM    431  CA  CYS A 402      89.190 131.123 131.016  1.00 56.47           C
ATOM    432  C   CYS A 402      90.208 130.227 131.706  1.00 56.47           C
ATOM    433  O   CYS A 402      89.992 129.019 131.792  1.00 56.47           O
ATOM    434  CB  CYS A 402      89.410 131.125 129.507  1.00 56.47           C
ATOM    435  SG  CYS A 402      88.082 131.868 128.550  1.00 56.47           S
ATOM    436  N   ASP A 403      91.320 130.792 132.187  1.00 58.77           N
ATOM    437  CA  ASP A 403      92.224 130.053 133.066  1.00 58.77           C
ATOM    438  C   ASP A 403      91.521 129.653 134.349  1.00 58.77           C
ATOM    439  O   ASP A 403      91.686 128.536 134.841  1.00 58.77           O
ATOM    440  CB  ASP A 403      93.443 130.897 133.438  1.00 58.77           C
ATOM    441  CG  ASP A 403      94.336 131.208 132.273  1.00 58.77           C
ATOM    442  OD1 ASP A 403      94.342 130.438 131.313  1.00 58.77           O
ATOM    443  OD2 ASP A 403      95.046 132.232 132.315  1.00 58.77           O
ATOM    444  N   ARG A 404      90.728 130.562 134.895  1.00 62.32           N
ATOM    445  CA  ARG A 404      90.194 130.434 136.238  1.00 62.32           C
ATOM    446  C   ARG A 404      89.003 129.491 136.283  1.00 62.32           C
ATOM    447  O   ARG A 404      88.933 128.614 137.143  1.00 62.32           O
ATOM    448  CB  ARG A 404      89.808 131.818 136.735  1.00 62.32           C
ATOM    449  CG  ARG A 404      89.342 131.913 138.145  1.00 62.32           C
ATOM    450  CD  ARG A 404      89.081 133.370 138.431  1.00 62.32           C
ATOM    451  NE  ARG A 404      90.314 134.139 138.312  1.00 62.32           N
ATOM    452  CZ  ARG A 404      90.364 135.462 138.221  1.00 62.32           C
ATOM    453  NH1 ARG A 404      89.246 136.169 138.222  1.00 62.32           N
ATOM    454  NH2 ARG A 404      91.533 136.074 138.120  1.00 62.32           N
ATOM    455  N   TYR A 405      88.057 129.660 135.371  1.00 60.24           N
ATOM    456  CA  TYR A 405      86.862 128.833 135.357  1.00 60.24           C
ATOM    457  C   TYR A 405      87.049 127.543 134.590  1.00 60.24           C
ATOM    458  O   TYR A 405      86.406 126.544 134.906  1.00 60.24           O
ATOM    459  CB  TYR A 405      85.698 129.609 134.756  1.00 60.24           C
ATOM    460  CG  TYR A 405      85.229 130.727 135.629  1.00 60.24           C
ATOM    461  CD1 TYR A 405      84.390 130.483 136.697  1.00 60.24           C
ATOM    462  CD2 TYR A 405      85.631 132.025 135.394  1.00 60.24           C
ATOM    463  CE1 TYR A 405      83.960 131.500 137.500  1.00 60.24           C
ATOM    464  CE2 TYR A 405      85.209 133.048 136.191  1.00 60.24           C
ATOM    465  CZ  TYR A 405      84.372 132.780 137.241  1.00 60.24           C
ATOM    466  OH  TYR A 405      83.946 133.804 138.042  1.00 60.24           O
ATOM    467  N   GLY A 406      87.899 127.553 133.584  1.00 55.48           N
ATOM    468  CA  GLY A 406      88.229 126.367 132.836  1.00 55.48           C
ATOM    469  C   GLY A 406      87.482 126.316 131.529  1.00 55.48           C
ATOM    470  O   GLY A 406      86.371 125.801 131.451  1.00 55.48           O
ATOM    471  N   LEU A 407      88.124 126.810 130.484  1.00 50.07           N
ATOM    472  CA  LEU A 407      87.642 126.712 129.122  1.00 50.07           C
ATOM    473  C   LEU A 407      88.867 126.645 128.242  1.00 50.07           C
ATOM    474  O   LEU A 407      89.832 127.365 128.477  1.00 50.07           O
ATOM    475  CB  LEU A 407      86.776 127.904 128.710  1.00 50.07           C
ATOM    476  CG  LEU A 407      85.382 128.091 129.286  1.00 50.07           C
ATOM    477  CD1 LEU A 407      84.814 129.402 128.844  1.00 50.07           C
ATOM    478  CD2 LEU A 407      84.488 126.976 128.843  1.00 50.07           C
ATOM    479  N   TYR A 408      88.840 125.778 127.250  1.00 49.12           N
ATOM    480  CA  TYR A 408      89.910 125.768 126.277  1.00 49.12           C
ATOM    481  C   TYR A 408      89.712 126.936 125.331  1.00 49.12           C
ATOM    482  O   TYR A 408      88.589 127.288 124.990  1.00 49.12           O
ATOM    483  CB  TYR A 408      89.931 124.461 125.509  1.00 49.12           C
ATOM    484  CG  TYR A 408      89.959 123.278 126.414  1.00 49.12           C
ATOM    485  CD1 TYR A 408      91.022 123.063 127.265  1.00 49.12           C
ATOM    486  CD2 TYR A 408      88.940 122.350 126.387  1.00 49.12           C
ATOM    487  CE1 TYR A 408      91.043 121.987 128.095  1.00 49.12           C
ATOM    488  CE2 TYR A 408      88.958 121.265 127.201  1.00 49.12           C
ATOM    489  CZ  TYR A 408      90.013 121.084 128.052  1.00 49.12           C
ATOM    490  OH  TYR A 408      90.021 119.995 128.871  1.00 49.12           O
ATOM    491  N   VAL A 409      90.800 127.572 124.941  1.00 48.32           N
ATOM    492  CA  VAL A 409      90.732 128.763 124.114  1.00 48.32           C
ATOM    493  C   VAL A 409      91.527 128.509 122.848  1.00 48.32           C
ATOM    494  O   VAL A 409      92.660 128.029 122.909  1.00 48.32           O
ATOM    495  CB  VAL A 409      91.248 129.999 124.869  1.00 48.32           C
ATOM    496  CG1 VAL A 409      91.335 131.177 123.967  1.00 48.32           C
ATOM    497  CG2 VAL A 409      90.334 130.324 126.002  1.00 48.32           C
ATOM    498  N   VAL A 410      90.917 128.784 121.707  1.00 50.57           N
ATOM    499  CA  VAL A 410      91.628 128.896 120.445  1.00 50.57           C
ATOM    500  C   VAL A 410      91.872 130.374 120.210  1.00 50.57           C
ATOM    501  O   VAL A 410      90.932 131.141 120.004  1.00 50.57           O
ATOM    502  CB  VAL A 410      90.845 128.268 119.292  1.00 50.57           C
ATOM    503  CG1 VAL A 410      91.556 128.514 117.989  1.00 50.57           C
ATOM    504  CG2 VAL A 410      90.692 126.809 119.529  1.00 50.57           C
ATOM    505  N   ASP A 411      93.128 130.781 120.255  1.00 55.37           N
ATOM    506  CA  ASP A 411      93.486 132.176 120.089  1.00 55.37           C
ATOM    507  C   ASP A 411      93.807 132.423 118.624  1.00 55.37           C
ATOM    508  O   ASP A 411      94.605 131.700 118.030  1.00 55.37           O
ATOM    509  CB  ASP A 411      94.677 132.520 120.971  1.00 55.37           C
ATOM    510  CG  ASP A 411      94.812 133.988 121.213  1.00 55.37           C
ATOM    511  OD1 ASP A 411      93.979 134.767 120.731  1.00 55.37           O
ATOM    512  OD2 ASP A 411      95.765 134.369 121.895  1.00 55.37           O
ATOM    513  N   GLU A 412      93.188 133.437 118.044  1.00 58.94           N
ATOM    514  CA  GLU A 412      93.156 133.589 116.600  1.00 58.94           C
ATOM    515  C   GLU A 412      93.722 134.937 116.199  1.00 58.94           C
ATOM    516  O   GLU A 412      93.377 135.952 116.794  1.00 58.94           O
ATOM    517  CB  GLU A 412      91.731 133.423 116.097  1.00 58.94           C
ATOM    518  CG  GLU A 412      91.581 133.451 114.613  1.00 58.94           C
ATOM    519  CD  GLU A 412      90.230 132.937 114.193  1.00 58.94           C
ATOM    520  OE1 GLU A 412      89.438 132.566 115.081  1.00 58.94           O
ATOM    521  OE2 GLU A 412      89.959 132.888 112.983  1.00 58.94           O
ATOM    522  N   ALA A 413      94.605 134.936 115.210  1.00 56.38           N
ATOM    523  CA  ALA A 413      95.209 136.170 114.741  1.00 56.38           C
ATOM    524  C   ALA A 413      94.191 137.020 113.996  1.00 56.38           C
ATOM    525  O   ALA A 413      93.251 136.514 113.386  1.00 56.38           O
ATOM    526  CB  ALA A 413      96.398 135.870 113.838  1.00 56.38           C
ATOM    527  N   ASN A 414      94.397 138.332 114.043  1.00 58.63           N
ATOM    528  CA  ASN A 414      93.475 139.305 113.462  1.00 58.63           C
ATOM    529  C   ASN A 414      93.752 139.453 111.965  1.00 58.63           C
ATOM    530  O   ASN A 414      94.186 140.493 111.476  1.00 58.63           O
ATOM    531  CB  ASN A 414      93.626 140.636 114.179  1.00 58.63           C
ATOM    532  CG  ASN A 414      92.537 141.616 113.839  1.00 58.63           C
ATOM    533  OD1 ASN A 414      91.541 141.267 113.226  1.00 58.63           O
ATOM    534  ND2 ASN A 414      92.764 142.870 114.168  1.00 58.63           N
ATOM    535  N   ILE A 415      93.512 138.377 111.225  1.00 56.49           N
ATOM    536  CA  ILE A 415      93.741 138.356 109.786  1.00 56.49           C
ATOM    537  C   ILE A 415      92.513 137.754 109.129  1.00 56.49           C
ATOM    538  O   ILE A 415      92.233 136.567 109.309  1.00 56.49           O
ATOM    539  CB  ILE A 415      94.990 137.560 109.390  1.00 56.49           C
ATOM    540  CG1 ILE A 415      96.253 138.136 110.012  1.00 56.49           C
ATOM    541  CG2 ILE A 415      95.142 137.572 107.896  1.00 56.49           C
ATOM    542  CD1 ILE A 415      97.428 137.244 109.889  1.00 56.49           C
ATOM    543  N   GLU A 416      91.786 138.558 108.367  1.00 62.75           N
ATOM    544  CA  GLU A 416      90.731 138.032 107.512  1.00 62.75           C
ATOM    545  C   GLU A 416      90.601 138.899 106.276  1.00 62.75           C
ATOM    546  O   GLU A 416      90.346 140.096 106.383  1.00 62.75           O
ATOM    547  CB  GLU A 416      89.398 137.933 108.240  1.00 62.75           C
ATOM    548  CG  GLU A 416      88.299 137.504 107.301  1.00 62.75           C
ATOM    549  CD  GLU A 416      87.066 137.007 107.994  1.00 62.75           C
ATOM    550  OE1 GLU A 416      87.081 136.842 109.223  1.00 62.75           O
ATOM    551  OE2 GLU A 416      86.059 136.808 107.305  1.00 62.75           O
ATOM    552  N   THR A 417      90.704 138.287 105.113  1.00 63.74           N
ATOM    553  CA  THR A 417      90.590 139.026 103.883  1.00 63.74           C
ATOM    554  C   THR A 417      89.587 138.301 103.033  1.00 63.74           C
ATOM    555  O   THR A 417      89.854 137.963 101.901  1.00 63.74           O
ATOM    556  CB  THR A 417      91.926 139.031 103.140  1.00 63.74           C
ATOM    557  OG1 THR A 417      92.192 137.721 102.647  1.00 63.74           O
ATOM    558  CG2 THR A 417      93.039 139.432 104.059  1.00 63.74           C
ATOM    559  N   HIS A 418      88.399 138.131 103.582  1.00 66.36           N
ATOM    560  CA  HIS A 418      87.317 137.419 102.933  1.00 66.36           C
ATOM    561  C   HIS A 418      86.856 138.073 101.646  1.00 66.36           C
ATOM    562  O   HIS A 418      86.546 137.401 100.680  1.00 66.36           O
ATOM    563  CB  HIS A 418      86.140 137.311 103.891  1.00 66.36           C
ATOM    564  CG  HIS A 418      85.203 136.196 103.571  1.00 66.36           C
ATOM    565  ND1 HIS A 418      84.419 135.590 104.524  1.00 66.36           N
ATOM    566  CD2 HIS A 418      84.932 135.568 102.406  1.00 66.36           C
ATOM    567  CE1 HIS A 418      83.697 134.643 103.958  1.00 66.36           C
ATOM    568  NE2 HIS A 418      83.992 134.607 102.674  1.00 66.36           N
ATOM    569  N   GLY A 419      86.817 139.392 101.645  1.00 67.96           N
ATOM    570  CA  GLY A 419      86.365 140.157 100.507  1.00 67.96           C
ATOM    571  C   GLY A 419      87.241 140.207  99.275  1.00 67.96           C
ATOM    572  O   GLY A 419      86.796 140.681  98.245  1.00 67.96           O
ATOM    573  N   MET A 420      88.484 139.761  99.374  1.00 69.11           N
ATOM    574  CA  MET A 420      89.399 139.850  98.253  1.00 69.11           C
ATOM    575  C   MET A 420      89.015 138.841  97.183  1.00 69.11           C
ATOM    576  O   MET A 420      88.459 137.783  97.473  1.00 69.11           O
ATOM    577  CB  MET A 420      90.832 139.595  98.711  1.00 69.11           C
ATOM    578  CG  MET A 420      91.343 140.579  99.729  1.00 69.11           C
ATOM    579  SD  MET A 420      91.274 142.278  99.157  1.00 69.11           S
ATOM    580  CE  MET A 420      92.477 142.219  97.858  1.00 69.11           C
ATOM    581  N   VAL A 421      89.299 139.183  95.933  1.00 69.64           N
ATOM    582  CA  VAL A 421      89.087 138.254  94.827  1.00 69.64           C
ATOM    583  C   VAL A 421      90.420 138.026  94.125  1.00 69.64           C
ATOM    584  O   VAL A 421      90.963 138.960  93.524  1.00 69.64           O
ATOM    585  CB  VAL A 421      88.025 138.758  93.844  1.00 69.64           C
ATOM    586  CG1 VAL A 421      87.913 137.798  92.691  1.00 69.64           C
ATOM    587  CG2 VAL A 421      86.693 138.894  94.534  1.00 69.64           C
ATOM    588  N   PRO A 422      91.015 136.829  94.206  1.00 69.53           N
ATOM    589  CA  PRO A 422      90.617 135.673  95.005  1.00 69.53           C
ATOM    590  C   PRO A 422      90.948 135.902  96.462  1.00 69.53           C
ATOM    591  O   PRO A 422      91.562 136.914  96.765  1.00 69.53           O
ATOM    592  CB  PRO A 422      91.456 134.547  94.425  1.00 69.53           C
ATOM    593  CG  PRO A 422      92.650 135.214  93.935  1.00 69.53           C
ATOM    594  CD  PRO A 422      92.224 136.540  93.423  1.00 69.53           C
ATOM    595  N   MET A 423      90.547 134.986  97.337  1.00 69.70           N
ATOM    596  CA  MET A 423      90.600 135.249  98.766  1.00 69.70           C
ATOM    597  C   MET A 423      92.031 135.350  99.282  1.00 69.70           C
ATOM    598  O   MET A 423      92.256 135.980 100.315  1.00 69.70           O
ATOM    599  CB  MET A 423      89.819 134.162  99.504  1.00 69.70           C
ATOM    600  CG  MET A 423      89.427 134.465 100.918  1.00 69.70           C
ATOM    601  SD  MET A 423      88.671 133.027 101.695  1.00 69.70           S
ATOM    602  CE  MET A 423      87.155 132.882 100.789  1.00 69.70           C
ATOM    603  N   ASN A 424      93.010 134.805  98.561  1.00 67.55           N
ATOM    604  CA  ASN A 424      94.401 134.885  98.979  1.00 67.55           C
ATOM    605  C   ASN A 424      95.199 135.938  98.220  1.00 67.55           C
ATOM    606  O   ASN A 424      96.411 135.780  98.079  1.00 67.55           O
ATOM    607  CB  ASN A 424      95.094 133.527  98.858  1.00 67.55           C
ATOM    608  CG  ASN A 424      95.180 133.008  97.430  1.00 67.55           C
ATOM    609  OD1 ASN A 424      94.655 133.589  96.491  1.00 67.55           O
ATOM    610  ND2 ASN A 424      95.906 131.920  97.265  1.00 67.55           N
ATOM    611  N   ARG A 425      94.550 136.984  97.706  1.00 67.75           N
ATOM    612  CA  ARG A 425      95.269 137.985  96.925  1.00 67.75           C
ATOM    613  C   ARG A 425      96.299 138.724  97.770  1.00 67.75           C
ATOM    614  O   ARG A 425      97.416 138.981  97.314  1.00 67.75           O
ATOM    615  CB  ARG A 425      94.293 138.968  96.288  1.00 67.75           C
ATOM    616  CG  ARG A 425      94.983 140.024  95.462  1.00 67.75           C
ATOM    617  CD  ARG A 425      94.032 140.920  94.732  1.00 67.75           C
ATOM    618  NE  ARG A 425      93.364 140.232  93.641  1.00 67.75           N
ATOM    619  CZ  ARG A 425      93.881 140.089  92.429  1.00 67.75           C
ATOM    620  NH1 ARG A 425      95.074 140.583  92.151  1.00 67.75           N
ATOM    621  NH2 ARG A 425      93.204 139.451  91.493  1.00 67.75           N
ATOM    622  N   LEU A 426      95.970 139.014  99.019  1.00 63.68           N
ATOM    623  CA  LEU A 426      96.938 139.646  99.897  1.00 63.68           C
ATOM    624  C   LEU A 426      97.829 138.640 100.597  1.00 63.68           C
ATOM    625  O   LEU A 426      99.006 138.921 100.821  1.00 63.68           O
ATOM    626  CB  LEU A 426      96.229 140.498 100.945  1.00 63.68           C
ATOM    627  CG  LEU A 426      95.343 141.598 100.382  1.00 63.68           C
ATOM    628  CD1 LEU A 426      94.709 142.367 101.503  1.00 63.68           C
ATOM    629  CD2 LEU A 426      96.106 142.506  99.458  1.00 63.68           C
ATOM    630  N   THR A 427      97.309 137.475 100.946  1.00 62.81           N
ATOM    631  CA  THR A 427      98.087 136.533 101.730  1.00 62.81           C
ATOM    632  C   THR A 427      99.023 135.684 100.891  1.00 62.81           C
ATOM    633  O   THR A 427      99.783 134.902 101.454  1.00 62.81           O
ATOM    634  CB  THR A 427      97.171 135.622 102.531  1.00 62.81           C
ATOM    635  OG1 THR A 427      96.407 134.810 101.640  1.00 62.81           O
ATOM    636  CG2 THR A 427      96.233 136.437 103.379  1.00 62.81           C
ATOM    637  N   ASP A 428      98.988 135.799  99.573  1.00 68.07           N
ATOM    638  CA  ASP A 428      99.994 135.167  98.741  1.00 68.07           C
ATOM    639  C   ASP A 428     100.975 136.196  98.198  1.00 68.07           C
ATOM    640  O   ASP A 428     101.824 135.865  97.372  1.00 68.07           O
ATOM    641  CB  ASP A 428      99.328 134.394  97.607  1.00 68.07           C
ATOM    642  CG  ASP A 428     100.165 133.238  97.119  1.00 68.07           C
ATOM    643  OD1 ASP A 428     101.246 132.995  97.692  1.00 68.07           O
ATOM    644  OD2 ASP A 428      99.742 132.562  96.162  1.00 68.07           O
ATOM    645  N   ASP A 429     100.870 137.438  98.655  1.00 66.53           N
ATOM    646  CA  ASP A 429     101.729 138.528  98.237  1.00 66.53           C
ATOM    647  C   ASP A 429     102.768 138.765  99.317  1.00 66.53           C
ATOM    648  O   ASP A 429     102.391 139.022 100.467  1.00 66.53           O
ATOM    649  CB  ASP A 429     100.886 139.779  98.021  1.00 66.53           C
ATOM    650  CG  ASP A 429     101.634 140.913  97.343  1.00 66.53           C
ATOM    651  OD1 ASP A 429     102.832 140.799  97.035  1.00 66.53           O
ATOM    652  OD2 ASP A 429     100.996 141.953  97.107  1.00 66.53           O
ATOM    653  N   PRO A 430     104.066 138.695  99.016  1.00 63.91           N
ATOM    654  CA  PRO A 430     105.067 138.926 100.065  1.00 63.91           C
ATOM    655  C   PRO A 430     105.195 140.369 100.493  1.00 63.91           C
ATOM    656  O   PRO A 430     105.827 140.628 101.517  1.00 63.91           O
ATOM    657  CB  PRO A 430     106.361 138.421  99.427  1.00 63.91           C
ATOM    658  CG  PRO A 430     106.131 138.539  98.015  1.00 63.91           C
ATOM    659  CD  PRO A 430     104.697 138.253  97.767  1.00 63.91           C
ATOM    660  N   ARG A 431     104.611 141.314  99.761  1.00 67.22           N
ATOM    661  CA  ARG A 431     104.558 142.690 100.227  1.00 67.22           C
ATOM    662  C   ARG A 431     103.639 142.857 101.427  1.00 67.22           C
ATOM    663  O   ARG A 431     103.757 143.847 102.149  1.00 67.22           O
ATOM    664  CB  ARG A 431     104.116 143.601  99.089  1.00 67.22           C
ATOM    665  CG  ARG A 431     105.154 143.718  97.990  1.00 67.22           C
ATOM    666  CD  ARG A 431     104.646 144.483  96.788  1.00 67.22           C
ATOM    667  NE  ARG A 431     104.335 145.877  97.085  1.00 67.22           N
ATOM    668  CZ  ARG A 431     105.219 146.867  97.051  1.00 67.22           C
ATOM    669  NH1 ARG A 431     106.484 146.626  96.745  1.00 67.22           N
ATOM    670  NH2 ARG A 431     104.838 148.101  97.333  1.00 67.22           N
ATOM    671  N   TRP A 432     102.737 141.914 101.659  1.00 61.70           N
ATOM    672  CA  TRP A 432     101.862 141.920 102.815  1.00 61.70           C
ATOM    673  C   TRP A 432     102.330 140.987 103.911  1.00 61.70           C
ATOM    674  O   TRP A 432     101.694 140.926 104.960  1.00 61.70           O
ATOM    675  CB  TRP A 432     100.451 141.551 102.384  1.00 61.70           C
ATOM    676  CG  TRP A 432      99.799 142.640 101.653  1.00 61.70           C
ATOM    677  CD1 TRP A 432      99.877 142.890 100.328  1.00 61.70           C
ATOM    678  CD2 TRP A 432      98.927 143.622 102.199  1.00 61.70           C
ATOM    679  NE1 TRP A 432      99.130 143.986 100.012  1.00 61.70           N
ATOM    680  CE2 TRP A 432      98.530 144.452 101.148  1.00 61.70           C
ATOM    681  CE3 TRP A 432      98.447 143.882 103.480  1.00 61.70           C
ATOM    682  CZ2 TRP A 432      97.671 145.520 101.333  1.00 61.70           C
ATOM    683  CZ3 TRP A 432      97.603 144.940 103.663  1.00 61.70           C
ATOM    684  CH2 TRP A 432      97.223 145.749 102.598  1.00 61.70           C
ATOM    685  N   LEU A 433     103.410 140.250 103.680  1.00 59.21           N
ATOM    686  CA  LEU A 433     103.984 139.418 104.732  1.00 59.21           C
ATOM    687  C   LEU A 433     104.461 140.186 105.967  1.00 59.21           C
ATOM    688  O   LEU A 433     104.265 139.658 107.072  1.00 59.21           O
ATOM    689  CB  LEU A 433     105.105 138.551 104.143  1.00 59.21           C
ATOM    690  CG  LEU A 433     105.850 137.602 105.078  1.00 59.21           C
ATOM    691  CD1 LEU A 433     104.904 136.617 105.706  1.00 59.21           C
ATOM    692  CD2 LEU A 433     106.930 136.879 104.322  1.00 59.21           C
ATOM    693  N   PRO A 434     105.068 141.387 105.887  1.00 60.38           N
ATOM    694  CA  PRO A 434     105.325 142.123 107.138  1.00 60.38           C
ATOM    695  C   PRO A 434     104.083 142.521 107.910  1.00 60.38           C
ATOM    696  O   PRO A 434     104.106 142.492 109.143  1.00 60.38           O
ATOM    697  CB  PRO A 434     106.094 143.353 106.657  1.00 60.38           C
ATOM    698  CG  PRO A 434     106.761 142.916 105.478  1.00 60.38           C
ATOM    699  CD  PRO A 434     105.835 142.006 104.787  1.00 60.38           C
ATOM    700  N   ALA A 435     103.002 142.894 107.230  1.00 60.35           N
ATOM    701  CA  ALA A 435     101.792 143.269 107.948  1.00 60.35           C
ATOM    702  C   ALA A 435     101.120 142.054 108.565  1.00 60.35           C
ATOM    703  O   ALA A 435     100.592 142.131 109.676  1.00 60.35           O
ATOM    704  CB  ALA A 435     100.830 143.996 107.017  1.00 60.35           C
ATOM    705  N   MET A 436     101.136 140.925 107.864  1.00 60.10           N
ATOM    706  CA  MET A 436     100.543 139.715 108.410  1.00 60.10           C
ATOM    707  C   MET A 436     101.367 139.145 109.546  1.00 60.10           C
ATOM    708  O   MET A 436     100.803 138.572 110.479  1.00 60.10           O
ATOM    709  CB  MET A 436     100.380 138.667 107.322  1.00 60.10           C
ATOM    710  CG  MET A 436      99.296 138.958 106.338  1.00 60.10           C
ATOM    711  SD  MET A 436      99.293 137.718 105.056  1.00 60.10           S
ATOM    712  CE  MET A 436      98.875 136.273 106.014  1.00 60.10           C
ATOM    713  N   SER A 437     102.690 139.287 109.490  1.00 59.53           N
ATOM    714  CA  SER A 437     103.524 138.686 110.518  1.00 59.53           C
ATOM    715  C   SER A 437     103.377 139.397 111.849  1.00 59.53           C
ATOM    716  O   SER A 437     103.372 138.741 112.887  1.00 59.53           O
ATOM    717  CB  SER A 437     104.986 138.664 110.089  1.00 59.53           C
ATOM    718  OG  SER A 437     105.518 139.964 110.011  1.00 59.53           O
ATOM    719  N   GLU A 438     103.193 140.703 111.811  1.00 63.70           N
ATOM    720  CA  GLU A 438     103.022 141.471 113.022  1.00 63.70           C
ATOM    721  C   GLU A 438     101.772 141.018 113.746  1.00 63.70           C
ATOM    722  O   GLU A 438     101.756 140.929 114.955  1.00 63.70           O
ATOM    723  CB  GLU A 438     102.901 142.948 112.689  1.00 63.70           C
ATOM    724  CG  GLU A 438     104.137 143.529 112.043  1.00 63.70           C
ATOM    725  CD  GLU A 438     105.108 144.089 113.056  1.00 63.70           C
ATOM    726  OE1 GLU A 438     104.644 144.621 114.085  1.00 63.70           O
ATOM    727  OE2 GLU A 438     106.334 144.002 112.826  1.00 63.70           O
ATOM    728  N   ARG A 439     100.721 140.735 112.996  1.00 59.20           N
ATOM    729  CA  ARG A 439      99.465 140.319 113.593  1.00 59.20           C
ATOM    730  C   ARG A 439      99.552 138.944 114.222  1.00 59.20           C
ATOM    731  O   ARG A 439      98.813 138.662 115.163  1.00 59.20           O
ATOM    732  CB  ARG A 439      98.368 140.359 112.542  1.00 59.20           C
ATOM    733  CG  ARG A 439      98.037 141.764 112.173  1.00 59.20           C
ATOM    734  CD  ARG A 439      97.164 141.842 110.985  1.00 59.20           C
ATOM    735  NE  ARG A 439      96.923 143.231 110.648  1.00 59.20           N
ATOM    736  CZ  ARG A 439      95.854 143.908 111.026  1.00 59.20           C
ATOM    737  NH1 ARG A 439      94.905 143.309 111.711  1.00 59.20           N
ATOM    738  NH2 ARG A 439      95.727 145.174 110.693  1.00 59.20           N
ATOM    739  N   VAL A 440     100.449 138.099 113.742  1.00 55.50           N
ATOM    740  CA  VAL A 440     100.631 136.776 114.310  1.00 55.50           C
ATOM    741  C   VAL A 440     101.645 136.793 115.440  1.00 55.50           C
ATOM    742  O   VAL A 440     101.383 136.264 116.520  1.00 55.50           O
ATOM    743  CB  VAL A 440     101.034 135.791 113.200  1.00 55.50           C
ATOM    744  CG1 VAL A 440     101.447 134.492 113.785  1.00 55.50           C
ATOM    745  CG2 VAL A 440      99.877 135.576 112.266  1.00 55.50           C
ATOM    746  N   THR A 441     102.805 137.413 115.217  1.00 57.15           N
ATOM    747  CA  THR A 441     103.886 137.350 116.194  1.00 57.15           C
ATOM    748  C   THR A 441     103.557 138.118 117.462  1.00 57.15           C
ATOM    749  O   THR A 441     103.959 137.703 118.548  1.00 57.15           O
ATOM    750  CB  THR A 441     105.192 137.870 115.596  1.00 57.15           C
ATOM    751  OG1 THR A 441     105.030 139.226 115.188  1.00 57.15           O
ATOM    752  CG2 THR A 441     105.622 137.036 114.415  1.00 57.15           C
ATOM    753  N   ARG A 442     102.807 139.205 117.360  1.00 59.65           N
ATOM    754  CA  ARG A 442     102.459 139.953 118.554  1.00 59.65           C
ATOM    755  C   ARG A 442     101.324 139.312 119.331  1.00 59.65           C
ATOM    756  O   ARG A 442     101.200 139.566 120.528  1.00 59.65           O
ATOM    757  CB  ARG A 442     102.115 141.389 118.187  1.00 59.65           C
ATOM    758  CG  ARG A 442     103.300 142.113 117.609  1.00 59.65           C
ATOM    759  CD  ARG A 442     102.972 143.494 117.129  1.00 59.65           C
ATOM    760  NE  ARG A 442     102.668 144.397 118.225  1.00 59.65           N
ATOM    761  CZ  ARG A 442     101.489 144.968 118.419  1.00 59.65           C
ATOM    762  NH1 ARG A 442     100.492 144.752 117.580  1.00 59.65           N
ATOM    763  NH2 ARG A 442     101.318 145.774 119.448  1.00 59.65           N
ATOM    764  N   MET A 443     100.502 138.490 118.684  1.00 57.54           N
ATOM    765  CA  MET A 443      99.524 137.696 119.414  1.00 57.54           C
ATOM    766  C   MET A 443     100.206 136.631 120.255  1.00 57.54           C
ATOM    767  O   MET A 443      99.875 136.451 121.430  1.00 57.54           O
ATOM    768  CB  MET A 443      98.547 137.039 118.451  1.00 57.54           C
ATOM    769  CG  MET A 443      97.621 136.074 119.143  1.00 57.54           C
ATOM    770  SD  MET A 443      96.583 135.142 118.038  1.00 57.54           S
ATOM    771  CE  MET A 443      97.777 134.093 117.236  1.00 57.54           C
ATOM    772  N   VAL A 444     101.153 135.910 119.658  1.00 55.44           N
ATOM    773  CA  VAL A 444     101.851 134.839 120.356  1.00 55.44           C
ATOM    774  C   VAL A 444     102.682 135.399 121.498  1.00 55.44           C
ATOM    775  O   VAL A 444     102.694 134.846 122.595  1.00 55.44           O
ATOM    776  CB  VAL A 444     102.698 134.033 119.358  1.00 55.44           C
ATOM    777  CG1 VAL A 444     103.553 133.022 120.064  1.00 55.44           C
ATOM    778  CG2 VAL A 444     101.802 133.334 118.379  1.00 55.44           C
ATOM    779  N   GLN A 445     103.323 136.542 121.285  1.00 60.13           N
ATOM    780  CA  GLN A 445     104.104 137.155 122.349  1.00 60.13           C
ATOM    781  C   GLN A 445     103.240 137.676 123.485  1.00 60.13           C
ATOM    782  O   GLN A 445     103.694 137.710 124.628  1.00 60.13           O
ATOM    783  CB  GLN A 445     104.964 138.266 121.778  1.00 60.13           C
ATOM    784  CG  GLN A 445     106.200 137.742 121.139  1.00 60.13           C
ATOM    785  CD  GLN A 445     107.039 138.817 120.528  1.00 60.13           C
ATOM    786  OE1 GLN A 445     106.556 139.894 120.209  1.00 60.13           O
ATOM    787  NE2 GLN A 445     108.330 138.575 120.473  1.00 60.13           N
ATOM    788  N   ARG A 446     101.998 138.050 123.212  1.00 58.60           N
ATOM    789  CA  ARG A 446     101.146 138.509 124.295  1.00 58.60           C
ATOM    790  C   ARG A 446     100.581 137.346 125.100  1.00 58.60           C
ATOM    791  O   ARG A 446     100.500 137.424 126.326  1.00 58.60           O
ATOM    792  CB  ARG A 446     100.002 139.361 123.757  1.00 58.60           C
ATOM    793  CG  ARG A 446      99.252 140.057 124.859  1.00 58.60           C
ATOM    794  CD  ARG A 446      97.981 140.719 124.423  1.00 58.60           C
ATOM    795  NE  ARG A 446      96.970 139.738 124.075  1.00 58.60           N
ATOM    796  CZ  ARG A 446      95.734 140.034 123.707  1.00 58.60           C
ATOM    797  NH1 ARG A 446      95.329 141.288 123.677  1.00 58.60           N
ATOM    798  NH2 ARG A 446      94.891 139.067 123.406  1.00 58.60           N
ATOM    799  N   ASP A 447     100.204 136.254 124.440  1.00 58.33           N
ATOM    800  CA  ASP A 447      99.292 135.288 125.033  1.00 58.33           C
ATOM    801  C   ASP A 447      99.883 133.904 125.252  1.00 58.33           C
ATOM    802  O   ASP A 447      99.141 132.988 125.599  1.00 58.33           O
ATOM    803  CB  ASP A 447      98.043 135.172 124.163  1.00 58.33           C
ATOM    804  CG  ASP A 447      97.219 136.427 124.181  1.00 58.33           C
ATOM    805  OD1 ASP A 447      97.217 137.116 125.213  1.00 58.33           O
ATOM    806  OD2 ASP A 447      96.590 136.751 123.166  1.00 58.33           O
ATOM    807  N   ARG A 448     101.189 133.724 125.088  1.00 59.42           N
ATOM    808  CA  ARG A 448     101.758 132.384 125.151  1.00 59.42           C
ATOM    809  C   ARG A 448     101.826 131.804 126.555  1.00 59.42           C
ATOM    810  O   ARG A 448     102.063 130.605 126.684  1.00 59.42           O
ATOM    811  CB  ARG A 448     103.154 132.373 124.554  1.00 59.42           C
ATOM    812  CG  ARG A 448     104.130 133.241 125.288  1.00 59.42           C
ATOM    813  CD  ARG A 448     105.441 133.254 124.574  1.00 59.42           C
ATOM    814  NE  ARG A 448     106.004 131.919 124.523  1.00 59.42           N
ATOM    815  CZ  ARG A 448     106.997 131.562 123.725  1.00 59.42           C
ATOM    816  NH1 ARG A 448     107.546 132.451 122.918  1.00 59.42           N
ATOM    817  NH2 ARG A 448     107.440 130.318 123.740  1.00 59.42           N
ATOM    818  N   ASN A 449     101.632 132.595 127.599  1.00 61.44           N
ATOM    819  CA  ASN A 449     101.723 132.048 128.942  1.00 61.44           C
ATOM    820  C   ASN A 449     100.389 131.582 129.499  1.00 61.44           C
ATOM    821  O   ASN A 449     100.370 130.996 130.581  1.00 61.44           O
ATOM    822  CB  ASN A 449     102.330 133.065 129.903  1.00 61.44           C
ATOM    823  CG  ASN A 449     103.786 133.314 129.634  1.00 61.44           C
ATOM    824  OD1 ASN A 449     104.515 132.416 129.242  1.00 61.44           O
ATOM    825  ND2 ASN A 449     104.227 134.528 129.878  1.00 61.44           N
TER
HETATM  826  C1  PTQ A2001      80.063 133.001 106.500  1.00 70.60           C
HETATM  827  C10 PTQ A2001      76.157 134.644 104.014  1.00 70.60           C
HETATM  828  C11 PTQ A2001      75.585 135.861 103.962  1.00 70.60           C
HETATM  829  C12 PTQ A2001      76.145 136.936 103.063  1.00 70.60           C
HETATM  830  C13 PTQ A2001      77.232 136.664 102.307  1.00 70.60           C
HETATM  831  C14 PTQ A2001      77.874 135.294 102.371  1.00 70.60           C
HETATM  832  C2  PTQ A2001      78.762 132.957 107.279  1.00 70.60           C
HETATM  833  C3  PTQ A2001      78.941 133.684 108.590  1.00 70.60           C
HETATM  834  C4  PTQ A2001      80.122 133.156 109.385  1.00 70.60           C
HETATM  835  C5  PTQ A2001      81.306 133.332 108.481  1.00 70.60           C
HETATM  836  C6  PTQ A2001      82.604 133.052 109.180  1.00 70.60           C
HETATM  837  C7  PTQ A2001      79.460 133.109 103.637  1.00 70.60           C
HETATM  838  C8  PTQ A2001      77.999 132.969 103.262  1.00 70.60           C
HETATM  839  C9  PTQ A2001      77.368 134.341 103.175  1.00 70.60           C
HETATM  840  O1  PTQ A2001      81.095 132.522 107.343  1.00 70.60           O
HETATM  841  O2  PTQ A2001      77.739 133.572 106.547  1.00 70.60           O
HETATM  842  O3  PTQ A2001      77.728 133.628 109.300  1.00 70.60           O
HETATM  843  O4  PTQ A2001      80.020 131.774 109.598  1.00 70.60           O
HETATM  844  O5  PTQ A2001      82.706 133.940 110.264  1.00 70.60           O
HETATM  845  S1  PTQ A2001      79.873 132.061 105.009  1.00 70.60           S
HETATM  846  O   HOH A2101      78.364 117.680 133.816  1.00 61.38           O
HETATM  847  O   HOH A2102      70.372 130.560  99.857  1.00 75.31           O
HETATM  848  O   HOH A2103     113.472 140.928 125.771  1.00 72.52           O
HETATM  849  O   HOH A2104      88.851 130.512 107.641  1.00 65.31           O
HETATM  850  O   HOH A2105     100.008 143.352 115.629  1.00 63.37           O
HETATM  851  O   HOH A2106      85.109 165.148 132.903  1.00 80.04           O
HETATM  852  O   HOH A2107      90.744 156.233 135.047  1.00 68.90           O
HETATM  853  O   HOH A2108      41.767 132.188 130.614  1.00 77.21           O
HETATM  854  O   HOH A2109      57.795 134.732 127.959  1.00 69.05           O
HETATM  855  O   HOH A2110      69.224 135.049  90.933  1.00 85.72           O
HETATM  856  O   HOH A2111      71.791 111.380 126.638  1.00 59.48           O
HETATM  857  O   HOH A2112      92.498 146.566 131.328  1.00 70.90           O
HETATM  858  O   HOH A2113      75.987 156.213 115.182  1.00 73.37           O
HETATM  859  O   HOH A2114      88.134 129.961 104.083  1.00 67.35           O
HETATM  860  O   HOH A2115      74.919 110.354 110.042  1.00 68.49           O
HETATM  861  O   HOH A2116     102.848 140.598 135.558  1.00 73.74           O
HETATM  862  O   HOH A2117      46.749 107.339 130.974  1.00 79.77           O
HETATM  863  O   HOH A2118     103.498 134.368  96.710  1.00 67.81           O
HETATM  864  O   HOH A2119      79.230 163.122 113.225  1.00 70.83           O
HETATM  865  O   HOH A2120      93.068 122.193 101.057  1.00 65.27           O
HETATM  866  O   HOH A2121      85.733 116.094 129.183  1.00 63.08           O
HETATM  867  O   HOH A2122     107.196 112.146 141.975  1.00 77.32           O
HETATM  868  O   HOH A2123      76.561 163.372 116.654  1.00 75.45           O
HETATM  869  O   HOH A2124      35.690 111.291 119.705  1.00 75.55           O
HETATM  870  O   HOH A2125     101.619 159.409 138.034  1.00 80.90           O
HETATM  871  O   HOH A2126     104.325 119.335 144.359  1.00 77.59           O
HETATM  872  O   HOH A2127     121.384 147.861 136.941  1.00 85.08           O
HETATM  873  O   HOH A2128      68.926 150.945 126.549  1.00 79.46           O
HETATM  874  O   HOH A2129      63.623 129.080 125.274  1.00 61.38           O
HETATM  875  O   HOH A2130      79.854 105.559 110.550  1.00 63.82           O
HETATM  876  O   HOH A2131      71.942 125.941 136.573  1.00 65.03           O
HETATM  877  O   HOH A2132      68.344 112.574 123.686  1.00 51.91           O
HETATM  878  O   HOH A2133      33.044 119.375 122.372  1.00 77.41           O
HETATM  879  O   HOH A2134      51.677 109.059 126.271  1.00 70.47           O
HETATM  880  O   HOH A2135     100.534 172.118 114.541  1.00 76.22           O
HETATM  881  O   HOH A2136      82.146 135.610 106.626  1.00 66.13           O
HETATM  882  O   HOH A2137      94.413 144.242 123.763  1.00 64.80           O
HETATM  883  O   HOH A2138      99.248 132.177 145.422  1.00 76.98           O
HETATM  884  O   HOH A2139      67.154 138.640  90.993  1.00 91.87           O
HETATM  885  O   HOH A2140      85.925 147.948 117.684  1.00 63.57           O
HETATM  886  O   HOH A2141      98.150 132.500  94.403  1.00 75.61           O
HETATM  887  O   HOH A2142      72.170 118.466 106.001  1.00 69.17           O
HETATM  888  O   HOH A2143      88.803 107.249 101.581  1.00 60.71           O
HETATM  889  O   HOH A2144      84.599 156.928 121.267  1.00 67.35           O
HETATM  890  O   HOH A2145     122.510 132.152 134.889  1.00 76.84           O
HETATM  891  O   HOH A2146      91.120 156.179  98.055  1.00 75.60           O
HETATM  892  O   HOH A2147     101.840 114.799 115.709  1.00 66.42           O
HETATM  893  O   HOH A2148      95.517 138.622 130.359  1.00 67.59           O
HETATM  894  O   HOH A2149     109.123 167.673 119.091  1.00 73.85           O
HETATM  895  O   HOH A2150     126.011 134.311 134.862  1.00 76.71           O
HETATM  896  O   HOH A2151      47.813 130.737  92.543  1.00 74.04           O
HETATM  897  O   HOH A2152     110.806 130.763 125.522  1.00 67.22           O
HETATM  898  O   HOH A2153      98.621 168.952 123.317  1.00 73.53           O
HETATM  899  O   HOH A2154      36.892 113.723 101.890  1.00 70.15           O
HETATM  900  O   HOH A2155      37.194 138.477 119.546  1.00 71.99           O
HETATM  901  O   HOH A2156      97.268 171.142 108.612  1.00 80.96           O
HETATM  902  O   HOH A2157     100.268 117.851 144.169  1.00 76.57           O
HETATM  903  O   HOH A2158      85.209 138.474 138.111  1.00 69.37           O
HETATM  904  O   HOH A2159      49.279 124.416 110.604  1.00 59.32           O
HETATM  905  O   HOH A2160      83.673 147.139  98.891  1.00 72.86           O
HETATM  906  O   HOH A2161      33.191 107.233 111.060  1.00 72.29           O
HETATM  907  O   HOH A2162      84.173 142.567 118.583  1.00 66.48           O
HETATM  908  O   HOH A2163      37.552 123.051 108.444  1.00 66.38           O
HETATM  909  O   HOH A2164     104.764 120.217 127.780  1.00 71.07           O
HETATM  910  O   HOH A2165     102.349 121.241 107.565  1.00 64.71           O
HETATM  911  O   HOH A2166     115.156 120.216 132.997  1.00 78.70           O
HETATM  912  O   HOH A2167      70.140 126.221 105.231  1.00 72.45           O
HETATM  913  O   HOH A2168     106.917 163.286 102.823  1.00 74.44           O
HETATM  914  O   HOH A2169      69.857 111.905 147.586  1.00 73.56           O
HETATM  915  O   HOH A2170      62.635 114.689  97.714  1.00 65.91           O
HETATM  916  O   HOH A2171      46.009 119.574 106.287  1.00 61.16           O
HETATM  917  O   HOH A2172      70.879 134.372 130.678  1.00 64.19           O
HETATM  918  O   HOH A2173      81.685 134.378 116.963  1.00 59.54           O
HETATM  919  O   HOH A2174     100.561 145.107 127.237  1.00 69.49           O
HETATM  920  O   HOH A2175      65.670 138.108 101.873  1.00 79.10           O
HETATM  921  O   HOH A2176      45.064 120.959  87.845  1.00 74.52           O
HETATM  922  O   HOH A2177      54.035 131.135  90.540  1.00 73.53           O
HETATM  923  O   HOH A2178      47.116 109.181 119.644  1.00 66.54           O
HETATM  924  O   HOH A2179      63.189 113.179 101.632  1.00 65.96           O
HETATM  925  O   HOH A2180      71.449 136.228  96.873  1.00 87.23           O
HETATM  926  O   HOH A2181      67.646 120.890 140.470  1.00 71.90           O
HETATM  927  O   HOH A2182      43.823 117.431 130.704  1.00 63.59           O
HETATM  928  O   HOH A2183      62.420  98.604 131.619  1.00 81.11           O
HETATM  929  O   HOH A2184      64.237 123.799 128.880  1.00 59.51           O
HETATM  930  O   HOH A2185      72.473 122.539 100.168  1.00 70.18           O
HETATM  931  O   HOH A2186      87.821 158.804  98.654  1.00 72.78           O
HETATM  932  O   HOH A2187      85.319 135.799 138.401  1.00 68.41           O
HETATM  933  O   HOH A2188      54.876 128.656 134.151  1.00 68.33           O
HETATM  934  O   HOH A2189     117.031 138.914 125.253  1.00 74.25           O
HETATM  935  O   HOH A2190     104.892 151.515 144.762  1.00 82.71           O
HETATM  936  O   HOH A2191      52.512 132.606 122.184  1.00 66.14           O
HETATM  937  O   HOH A2192      84.195 167.978 114.920  1.00 72.25           O
HETATM  938  O   HOH A2193     108.068 154.353 121.965  1.00 64.14           O
HETATM  939  O   HOH A2194      88.449 164.529 129.842  1.00 75.81           O
HETATM  940  O   HOH A2195     107.587 134.890 122.595  1.00 65.30           O
HETATM  941  O   HOH A2196      76.422 123.120 140.880  1.00 68.52           O
HETATM  942  O   HOH A2197      92.780 115.603 103.376  1.00 66.56           O
HETATM  943  O   HOH A2198      41.109 108.345 106.182  1.00 61.21           O
HETATM  944  O   HOH A2199     100.168 146.388 131.658  1.00 72.95           O
HETATM  945  O   HOH A2200     108.369 156.883 122.423  1.00 66.73           O
HETATM  946  O   HOH A2201      86.153 124.638 105.128  1.00 64.68           O
HETATM  947  O   HOH A2202      77.805 117.377 136.484  1.00 64.44           O
HETATM  948  O   HOH A2203      62.933 114.048 122.499  1.00 57.70           O
HETATM  949  O   HOH A2204      51.933 112.370  95.009  1.00 71.76           O
HETATM  950  O   HOH A2205      71.866 138.273 100.735  1.00 83.63           O
HETATM  951  O   HOH A2206      75.173 144.792 130.017  1.00 72.77           O
HETATM  952  O   HOH A2207      46.680 125.481 132.390  1.00 66.69           O
HETATM  953  O   HOH A2208      90.926 129.508 110.466  1.00 62.46           O
HETATM  954  O   HOH A2209      80.041 122.345 120.261  1.00 47.66           O
HETATM  955  O   HOH A2210      85.818 143.401 110.364  1.00 66.19           O
HETATM  956  O   HOH A2211      96.624 125.851  99.110  1.00 62.21           O
HETATM  957  O   HOH A2212      87.461 144.341 135.499  1.00 72.76           O
HETATM  958  O   HOH A2213     110.140 163.984 130.496  1.00 73.13           O
HETATM  959  O   HOH A2214      75.653 110.875 112.796  1.00 59.83           O
HETATM  960  O   HOH A2215      44.204 127.893 129.187  1.00 70.15           O
HETATM  961  O   HOH A2216      53.713 127.904 120.474  1.00 57.35           O
HETATM  962  O   HOH A2217      69.948 144.015 120.572  1.00 66.44           O
HETATM  963  O   HOH A2218      96.261 106.325 118.825  1.00 70.14           O
HETATM  964  O   HOH A2219      73.897 127.903 144.802  1.00 71.81           O
HETATM  965  O   HOH A2220     108.296 151.046 112.290  1.00 64.67           O
HETATM  966  O   HOH A2221      59.167 110.638 133.196  1.00 60.28           O
HETATM  967  O   HOH A2222      85.069 126.990  94.473  1.00 80.03           O
HETATM  968  O   HOH A2223      58.720 129.469 122.308  1.00 59.49           O
HETATM  969  O   HOH A2224     108.162 164.528 117.992  1.00 69.88           O
HETATM  970  O   HOH A2225      70.838 128.108  97.772  1.00 78.56           O
HETATM  971  O   HOH A2226      83.931 138.168 106.462  1.00 64.59           O
HETATM  972  O   HOH A2227     100.588 112.934 140.385  1.00 78.14           O
HETATM  973  O   HOH A2228     104.391 113.174 128.862  1.00 77.15           O
HETATM  974  O   HOH A2229      89.253 142.220 137.177  1.00 71.02           O
HETATM  975  O   HOH A2230      72.158 128.254 132.919  1.00 64.13           O
HETATM  976  O   HOH A2231      39.584 137.783 121.065  1.00 71.85           O
HETATM  977  O   HOH A2232     112.306 153.233 125.172  1.00 72.15           O
HETATM  978  O   HOH A2233      94.552 145.341 129.939  1.00 71.71           O
HETATM  979  O   HOH A2234      34.700 132.238 110.694  1.00 69.84           O
HETATM  980  O   HOH A2235     101.518 148.604 144.158  1.00 79.49           O
HETATM  981  O   HOH A2236      89.041 123.935 114.798  1.00 54.45           O
HETATM  982  O   HOH A2237     100.230 115.063 138.496  1.00 71.29           O
HETATM  983  O   HOH A2238      65.181 125.405 106.299  1.00 66.68           O
HETATM  984  O   HOH A2239      78.234 146.288 130.834  1.00 70.07           O
HETATM  985  O   HOH A2240      49.499 110.886 111.583  1.00 60.44           O
HETATM  986  O   HOH A2241      61.861 113.833 114.887  1.00 63.65           O
HETATM  987  O   HOH A2242     105.673 123.416 107.367  1.00 59.06           O
HETATM  988  O   HOH A2243     107.082 140.934 149.872  1.00 78.71           O
HETATM  989  O   HOH A2244      97.947 123.410 137.032  1.00 59.88           O
HETATM  990  O   HOH A2245      63.898 114.622  99.907  1.00 68.11           O
HETATM  991  O   HOH A2246      90.983 127.881 138.792  1.00 60.89           O
HETATM  992  O   HOH A2247      34.873 129.472 105.344  1.00 77.96           O
HETATM  993  O   HOH A2248      70.075 125.692 128.771  1.00 57.64           O
HETATM  994  O   HOH A2249      68.097 145.800 106.885  1.00 76.14           O
HETATM  995  O   HOH A2250      60.944 132.413  93.725  1.00 72.73           O
HETATM  996  O   HOH A2251      73.596 156.340 108.426  1.00 74.66           O
HETATM  997  O   HOH A2252     123.371 138.782 136.931  1.00 80.50           O
HETATM  998  O   HOH A2253      59.691 134.770 108.155  1.00 63.42           O
HETATM  999  O   HOH A2254      61.549 119.357  97.028  1.00 67.08           O
HETATM 1000  O   HOH A2255      76.188 104.466 128.815  1.00 66.70           O
HETATM 1001  O   HOH A2256      87.137 144.323 123.527  1.00 65.68           O
HETATM 1002  O   HOH A2257      84.106 156.497 103.953  1.00 72.66           O
HETATM 1003  O   HOH A2258      59.766 137.336 116.408  1.00 59.62           O
HETATM 1004  O   HOH A2259      94.459 167.844 109.329  1.00 74.12           O
HETATM 1005  O   HOH A2260      58.477 149.784 118.917  1.00 81.02           O
HETATM 1006  O   HOH A2261      55.384 115.041  99.863  1.00 62.00           O
HETATM 1007  O   HOH A2262      67.390 127.245 125.625  1.00 55.55           O
HETATM 1008  O   HOH A2263      65.484 123.516  98.538  1.00 66.36           O
HETATM 1009  O   HOH A2264     104.867 145.476 119.038  1.00 65.83           O
HETATM 1010  O   HOH A2265      56.683 112.146 131.399  1.00 62.21           O
HETATM 1011  O   HOH A2266      77.036 123.155 105.175  1.00 65.63           O
HETATM 1012  O   HOH A2267      82.842 136.857 112.134  1.00 67.37           O
HETATM 1013  O   HOH A2268      54.029 105.865 122.984  1.00 71.51           O
HETATM 1014  O   HOH A2269      65.183 120.493 121.585  1.00 54.49           O
HETATM 1015  O   HOH A2270      83.589 111.045 135.815  1.00 68.71           O
HETATM 1016  O   HOH A2271      89.305 161.261 132.462  1.00 74.90           O
HETATM 1017  O   HOH A2272     125.042 138.356 132.031  1.00 79.26           O
HETATM 1018  O   HOH A2273      75.849 136.288 116.166  1.00 63.33           O
HETATM 1019  O   HOH A2274      93.557 172.074 131.022  1.00 77.81           O
HETATM 1020  O   HOH A2275      82.714 123.083 130.693  1.00 57.47           O
HETATM 1021  O   HOH A2276      89.420 152.328  98.753  1.00 74.50           O
HETATM 1022  O   HOH A2277     109.687 158.093 133.572  1.00 75.07           O
HETATM 1023  O   HOH A2278      95.104 108.535 125.415  1.00 64.15           O
HETATM 1024  O   HOH A2279      75.087 153.119 122.954  1.00 75.59           O
HETATM 1025  O   HOH A2280      78.546 112.156 143.525  1.00 74.81           O
HETATM 1026  O   HOH A2281      75.396 149.457 129.981  1.00 72.69           O
HETATM 1027  O   HOH A2282      88.061 118.299 129.052  1.00 60.35           O
HETATM 1028  O   HOH A2283      84.153 136.126 108.934  1.00 63.93           O
HETATM 1029  O   HOH A2284     111.539 154.160 118.346  1.00 65.06           O
HETATM 1030  O   HOH A2285      96.994 138.504 127.401  1.00 61.32           O
HETATM 1031  O   HOH A2286      98.211 146.610 117.739  1.00 62.23           O
HETATM 1032  O   HOH A2287      84.586 113.927 126.604  1.00 61.16           O
HETATM 1033  O   HOH A2288      39.002 119.043 102.671  1.00 67.27           O
HETATM 1034  O   HOH A2289     105.504 146.095 116.062  1.00 67.45           O
HETATM 1035  O   HOH A2290      73.535 112.614 119.190  1.00 57.95           O
HETATM 1036  O   HOH A2291      95.510 163.210 136.470  1.00 73.33           O
HETATM 1037  O   HOH A2292      67.899 118.829 109.316  1.00 61.72           O
HETATM 1038  O   HOH A2293      95.382 150.213 115.942  1.00 60.93           O
HETATM 1039  O   HOH A2294      51.087 113.298 113.044  1.00 61.04           O
HETATM 1040  O   HOH A2295      98.513 141.565  96.367  1.00 67.28           O
HETATM 1041  O   HOH A2296      80.481 147.737 101.001  1.00 77.10           O
HETATM 1042  O   HOH A2297      60.005 138.134 108.699  1.00 64.46           O
HETATM 1043  O   HOH A2298      94.184 137.689 100.806  1.00 65.92           O
HETATM 1044  O   HOH A2299      88.447 126.760 103.002  1.00 68.77           O
HETATM 1045  O   HOH A2300     100.761 135.489 128.081  1.00 59.32           O
HETATM 1046  O   HOH A2301      99.536 173.003 116.995  1.00 77.42           O
HETATM 1047  O   HOH A2302      62.929 105.084 145.094  1.00 75.30           O
HETATM 1048  O   HOH A2303      71.687 119.487  99.760  1.00 69.83           O
HETATM 1049  O   HOH A2304      90.103 141.287  92.652  1.00 73.97           O
HETATM 1050  O   HOH A2305     107.482 151.484 130.813  1.00 69.76           O
HETATM 1051  O   HOH A2306      99.423 112.526 114.410  1.00 67.68           O
HETATM 1052  O   HOH A2307      71.351 120.913 146.014  1.00 71.70           O
HETATM 1053  O   HOH A2308      79.140 148.049 102.925  1.00 79.69           O
HETATM 1054  O   HOH A2309      73.337 117.680 110.680  1.00 61.19           O
HETATM 1055  O   HOH A2310      90.649 118.305 100.478  1.00 66.96           O
HETATM 1056  O   HOH A2311      67.386 120.687 102.189  1.00 66.24           O
HETATM 1057  O   HOH A2312      86.595 120.849 138.893  1.00 66.79           O
HETATM 1058  O   HOH A2313      47.351 113.823 115.125  1.00 62.85           O
HETATM 1059  O   HOH A2314     101.780 121.592 125.415  1.00 59.85           O
HETATM 1060  O   HOH A2315      88.972 110.980 120.317  1.00 63.15           O
HETATM 1061  O   HOH A2316     100.260 120.175 108.449  1.00 63.72           O
HETATM 1062  O   HOH A2317     133.398 135.025 117.988  1.00 77.75           O
HETATM 1063  O   HOH A2318     101.382 144.388  96.141  1.00 68.35           O
HETATM 1064  O   HOH A2319      71.219 153.473 118.957  1.00 74.77           O
HETATM 1065  O   HOH A2320      83.810 152.107 128.820  1.00 68.97           O
HETATM 1066  O   HOH A2321      69.341 130.097 117.676  1.00 61.40           O
HETATM 1067  O   HOH A2322      80.063 118.609 103.540  1.00 64.17           O
HETATM 1068  O   HOH A2323      92.063 145.786 128.193  1.00 69.06           O
HETATM 1069  O   HOH A2324     119.125 128.446 136.107  1.00 74.69           O
HETATM 1070  O   HOH A2325      76.019 129.900 144.062  1.00 72.89           O
HETATM 1071  O   HOH A2326      77.484 122.778 110.048  1.00 58.72           O
HETATM 1072  O   HOH A2327      56.502 117.101  97.173  1.00 64.93           O
HETATM 1073  O   HOH A2328      37.366 126.684  99.803  1.00 75.83           O
HETATM 1074  O   HOH A2329     101.450 145.049 130.204  1.00 70.92           O
HETATM 1075  O   HOH A2330      37.849 130.474 121.136  1.00 69.55           O
HETATM 1076  O   HOH A2331     101.668 124.594 130.727  1.00 63.91           O
HETATM 1077  O   HOH A2332      33.643 135.297 120.918  1.00 75.98           O
HETATM 1078  O   HOH A2333      89.350 148.303 110.118  1.00 64.95           O
HETATM 1079  O   HOH A2334      80.161 124.766 146.997  1.00 71.56           O
HETATM 1080  O   HOH A2335      57.475 112.279 105.586  1.00 61.34           O
HETATM 1081  O   HOH A2336      98.946 117.337 112.912  1.00 60.87           O
HETATM 1082  O   HOH A2337     102.867 122.268 127.828  1.00 63.88           O
HETATM 1083  O   HOH A2338      80.400 108.211 125.725  1.00 65.02           O
HETATM 1084  O   HOH A2339      98.264 146.330 109.490  1.00 64.04           O
HETATM 1085  O   HOH A2340      55.339 107.437 100.757  1.00 67.16           O
HETATM 1086  O   HOH A2341      78.637 138.831 135.646  1.00 68.30           O
HETATM 1087  O   HOH A2342      45.559 128.412 106.256  1.00 65.82           O
HETATM 1088  O   HOH A2343      70.572 150.846 104.995  1.00 76.41           O
HETATM 1089  O   HOH A2344      95.013 133.614 134.699  1.00 66.36           O
HETATM 1090  O   HOH A2345     101.468 152.417  99.914  1.00 69.32           O
HETATM 1091  O   HOH A2346      87.436 111.872 124.377  1.00 61.55           O
HETATM 1092  O   HOH A2347     103.906 147.228 144.341  1.00 76.57           O
HETATM 1093  O   HOH A2348      73.414 113.550 124.718  1.00 52.57           O
HETATM 1094  O   HOH A2349      96.456 139.829 115.714  1.00 60.44           O
HETATM 1095  O   HOH A2350      78.791 140.377 101.997  1.00 72.57           O
HETATM 1096  O   HOH A2351      65.465 114.781 126.238  1.00 52.47           O
HETATM 1097  O   HOH A2352      87.524 145.890 106.461  1.00 68.00           O
HETATM 1098  O   HOH A2353      93.887 125.100 105.742  1.00 60.56           O
HETATM 1099  O   HOH A2354     114.714 148.613 144.366  1.00 77.87           O
HETATM 1100  O   HOH A2355      87.261 170.985 110.121  1.00 71.64           O
HETATM 1101  O   HOH A2356      52.027 126.314  88.897  1.00 76.06           O
HETATM 1102  O   HOH A2357      87.652 150.838 111.928  1.00 64.72           O
HETATM 1103  O   HOH A2358     107.227 119.507 144.200  1.00 76.05           O
HETATM 1104  O   HOH A2359      52.958 109.626 105.256  1.00 62.76           O
HETATM 1105  O   HOH A2360      98.527 137.501  95.354  1.00 70.55           O
HETATM 1106  O   HOH A2361     118.526 143.742 126.644  1.00 79.65           O
HETATM 1107  O   HOH A2362      95.961 148.855 119.658  1.00 63.57           O
HETATM 1108  O   HOH A2363      87.039 128.091 138.995  1.00 64.77           O
HETATM 1109  O   HOH A2364      77.253 143.714 102.480  1.00 76.38           O
HETATM 1110  O   HOH A2365      59.835 116.105 109.494  1.00 61.10           O
HETATM 1111  O   HOH A2366     100.754 142.804 126.705  1.00 68.75           O
HETATM 1112  O   HOH A2367      58.082 135.672 124.464  1.00 66.53           O
HETATM 1113  O   HOH A2368     101.499 125.685 126.184  1.00 59.70           O
HETATM 1114  O   HOH A2369     103.364 144.235 104.799  1.00 63.99           O
HETATM 1115  O   HOH A2370     103.867 173.037 121.801  1.00 78.85           O
HETATM 1116  O   HOH A2371     105.731 154.438 140.405  1.00 75.92           O
HETATM 1117  O   HOH A2372      70.149 134.011 116.432  1.00 63.82           O
HETATM 1118  O   HOH A2373      76.713 162.421 119.044  1.00 73.99           O
HETATM 1119  O   HOH A2374      59.788 117.742  94.832  1.00 68.08           O
HETATM 1120  O   HOH A2375      77.003 124.902 101.564  1.00 72.38           O
HETATM 1121  O   HOH A2376     110.413 128.559 128.977  1.00 72.24           O
HETATM 1122  O   HOH A2377     106.148 123.298 149.927  1.00 79.66           O
HETATM 1123  O   HOH A2378      97.054 128.855 143.031  1.00 72.57           O
HETATM 1124  O   HOH A2379      76.903 117.009 131.604  1.00 53.74           O
HETATM 1125  O   HOH A2380      54.635 110.616 131.052  1.00 68.97           O
HETATM 1126  O   HOH A2381      82.612 108.247 122.462  1.00 65.19           O
HETATM 1127  O   HOH A2382      96.739 131.408 140.636  1.00 69.16           O
HETATM 1128  O   HOH A2383      98.800 128.837  97.599  1.00 66.75           O
HETATM 1129  O   HOH A2384      66.734 129.664 110.745  1.00 65.13           O
HETATM 1130  O   HOH A2385     106.354 140.897 116.888  1.00 63.66           O
HETATM 1131  O   HOH A2386      76.043 105.012 144.352  1.00 75.39           O
HETATM 1132  O   HOH A2387      64.982 132.467 126.904  1.00 66.38           O
HETATM 1133  O   HOH A2388     127.952 134.655 125.779  1.00 75.83           O
HETATM 1134  O   HOH A2389      77.465 113.557  99.166  1.00 72.69           O
HETATM 1135  O   HOH A2390      42.533 129.556 109.109  1.00 66.50           O
HETATM 1136  O   HOH A2391      68.701 136.143 112.431  1.00 70.09           O
HETATM 1137  O   HOH A2392      64.951 134.587 112.785  1.00 66.07           O
HETATM 1138  O   HOH A2393     115.220 125.559 141.479  1.00 78.54           O
HETATM 1139  O   HOH A2394     130.097 125.408 114.486  1.00 72.41           O
HETATM 1140  O   HOH A2395      85.671 135.218 122.696  1.00 58.60           O
HETATM 1141  O   HOH A2396      80.500 122.455 131.677  1.00 56.30           O
HETATM 1142  O   HOH A2397      54.960 111.962 121.848  1.00 63.72           O
HETATM 1143  O   HOH A2398      89.001 121.128 100.811  1.00 66.12           O
HETATM 1144  O   HOH A2399      49.276 117.919  90.093  1.00 73.92           O
HETATM 1145  O   HOH A2400      77.710 137.008 114.896  1.00 64.60           O
HETATM 1146  O   HOH A2401      92.885 118.633 135.448  1.00 58.97           O
HETATM 1147  O   HOH A2402      85.543 145.437 133.392  1.00 74.53           O
HETATM 1148  O   HOH A2403     100.539 134.259  94.153  1.00 71.32           O
HETATM 1149  O   HOH A2404      37.029 120.894 105.549  1.00 67.96           O
HETATM 1150  O   HOH A2405     112.878 155.523 128.487  1.00 71.84           O
HETATM 1151  O   HOH A2406     115.280 130.606 145.026  1.00 74.85           O
HETATM 1152  O   HOH A2407      66.358 152.062 110.801  1.00 75.18           O
HETATM 1153  O   HOH A2408      95.987 149.215 128.883  1.00 64.22           O
HETATM 1154  O   HOH A2409      65.516 144.633 122.106  1.00 67.45           O
HETATM 1155  O   HOH A2410     101.226 136.480  94.751  1.00 70.33           O
HETATM 1156  O   HOH A2411      80.896 128.280 144.717  1.00 72.65           O
HETATM 1157  O   HOH A2412     101.971 120.855 120.810  1.00 57.93           O
HETATM 1158  O   HOH A2413      48.898 126.904 102.917  1.00 65.03           O
HETATM 1159  O   HOH A2414      76.042 122.898  99.907  1.00 73.78           O
HETATM 1160  O   HOH A2415     101.535 120.706 144.076  1.00 71.50           O
HETATM 1161  O   HOH A2416     131.639 136.031 121.122  1.00 74.90           O
HETATM 1162  O   HOH A2417      89.431 169.288 128.924  1.00 74.83           O
HETATM 1163  O   HOH A2418     104.696 128.796 125.072  1.00 63.31           O
HETATM 1164  O   HOH A2419     105.347 127.840 151.685  1.00 78.40           O
HETATM 1165  O   HOH A2420      71.967  99.771 141.506  1.00 82.89           O
HETATM 1166  O   HOH A2421      90.760 128.109 112.822  1.00 59.82           O
HETATM 1167  O   HOH A2422      26.035 118.029  99.738  1.00 78.91           O
HETATM 1168  O   HOH A2423      94.078 170.109 105.242  1.00 79.49           O
HETATM 1169  O   HOH A2424      80.861 152.032 123.091  1.00 68.34           O
HETATM 1170  O   HOH A2425      82.911 167.377 112.061  1.00 66.71           O
HETATM 1171  O   HOH A2426      68.608 141.090 123.258  1.00 66.00           O
HETATM 1172  O   HOH A2427      85.036 116.792 114.577  1.00 52.02           O
HETATM 1173  O   HOH A2428      53.816 114.230 116.423  1.00 61.91           O
HETATM 1174  O   HOH A2429      82.195 166.318 119.069  1.00 74.33           O
HETATM 1175  O   HOH A2430     111.921 125.393 118.247  1.00 66.88           O
HETATM 1176  O   HOH A2431      86.043 111.846  96.199  1.00 66.25           O
HETATM 1177  O   HOH A2432      87.363 112.723 121.250  1.00 59.12           O
HETATM 1178  O   HOH A2433      81.461 119.937 133.281  1.00 62.63           O
HETATM 1179  O   HOH A2434      91.834 161.091 103.725  1.00 72.26           O
HETATM 1180  O   HOH A2435      56.558 143.030 119.624  1.00 71.20           O
HETATM 1181  O   HOH A2436      99.770 139.064 135.499  1.00 76.64           O
HETATM 1182  O   HOH A2437      47.662 119.293  88.312  1.00 73.07           O
HETATM 1183  O   HOH A2438      64.263 132.068 111.941  1.00 66.19           O
HETATM 1184  O   HOH A2439      69.866 128.204 103.820  1.00 70.85           O
HETATM 1185  O   HOH A2440      92.184 111.083 134.257  1.00 70.29           O
HETATM 1186  O   HOH A2441      92.191 167.485 126.882  1.00 71.24           O
HETATM 1187  O   HOH A2442      85.736 119.207 129.421  1.00 59.51           O
HETATM 1188  O   HOH A2443     110.089 134.813 143.012  1.00 73.69           O
HETATM 1189  O   HOH A2444      77.585 107.877 118.659  1.00 59.60           O
HETATM 1190  O   HOH A2445      96.588 141.608 137.399  1.00 78.53           O
HETATM 1191  O   HOH A2446      97.264 110.277 130.827  1.00 64.65           O
HETATM 1192  O   HOH A2447     118.323 131.756 128.445  1.00 74.95           O
HETATM 1193  O   HOH A2448      39.996 111.867 105.460  1.00 61.18           O
HETATM 1194  O   HOH A2449      75.403 111.549 120.829  1.00 58.01           O
HETATM 1195  O   HOH A2450      76.306 121.795 132.878  1.00 56.49           O
HETATM 1196  O   HOH A2451      73.703 111.012 122.894  1.00 61.66           O
HETATM 1197  O   HOH A2452      85.100 123.166 135.378  1.00 63.60           O
HETATM 1198  O   HOH A2453      36.584 111.665 111.567  1.00 65.48           O
HETATM 1199  O   HOH A2454     104.220 114.986 145.692  1.00 79.63           O
HETATM 1200  O   HOH A2455      86.607 136.860 119.651  1.00 61.71           O
HETATM 1201  O   HOH A2456      82.721 151.443  97.622  1.00 75.53           O
HETATM 1202  O   HOH A2457      54.855 130.445 114.661  1.00 61.39           O
HETATM 1203  O   HOH A2458     101.727 157.156 141.413  1.00 82.59           O
HETATM 1204  O   HOH A2459     121.602 132.041 126.075  1.00 79.06           O
HETATM 1205  O   HOH A2460      96.304 112.600 132.741  1.00 63.50           O
HETATM 1206  O   HOH A2461      83.584 103.977 137.615  1.00 71.20           O
HETATM 1207  O   HOH A2462      70.167 106.602 125.378  1.00 65.20           O
HETATM 1208  O   HOH A2463      59.694 125.884  92.708  1.00 71.03           O
HETATM 1209  O   HOH A2464      86.215 139.023 125.637  1.00 62.85           O
HETATM 1210  O   HOH A2465      42.410 125.043 130.114  1.00 65.83           O
HETATM 1211  O   HOH A2466      50.926 131.567 113.797  1.00 64.61           O
HETATM 1212  O   HOH A2467      66.327 124.674  93.204  1.00 76.36           O
HETATM 1213  O   HOH A2468      94.139 108.099 105.315  1.00 64.65           O
HETATM 1214  O   HOH A2469      52.282 130.804 106.135  1.00 66.71           O
HETATM 1215  O   HOH A2470     103.449 147.516 121.776  1.00 63.72           O
HETATM 1216  O   HOH A2471      36.266 112.979  99.770  1.00 70.32           O
HETATM 1217  O   HOH A2472      90.020 165.854 121.297  1.00 68.28           O
HETATM 1218  O   HOH A2473     105.480 150.838  97.643  1.00 65.94           O
HETATM 1219  O   HOH A2474      59.397 119.530 103.334  1.00 58.70           O
HETATM 1220  O   HOH A2475      76.349 108.145 123.420  1.00 65.06           O
HETATM 1221  O   HOH A2476     114.940 152.679 137.893  1.00 79.45           O
HETATM 1222  O   HOH A2477      75.614 141.450 100.259  1.00 80.79           O
HETATM 1223  O   HOH A2478     106.725 126.404 124.031  1.00 62.99           O
HETATM 1224  O   HOH A2479      84.283 128.231 103.957  1.00 71.39           O
HETATM 1225  O   HOH A2480      53.851 144.240 109.946  1.00 71.53           O
HETATM 1226  O   HOH A2481     100.503 110.191 137.885  1.00 78.13           O
HETATM 1227  O   HOH A2482      66.817 127.245 102.007  1.00 68.57           O
HETATM 1228  O   HOH A2483      72.926 109.357 126.415  1.00 61.54           O
HETATM 1229  O   HOH A2484      93.044 117.840 140.301  1.00 64.87           O
HETATM 1230  O   HOH A2485      98.237 119.151 103.395  1.00 64.62           O
HETATM 1231  O   HOH A2486      52.724 143.984 111.972  1.00 68.32           O
HETATM 1232  O   HOH A2487     108.510 140.548 102.441  1.00 62.53           O
HETATM 1233  O   HOH A2488      94.232 147.885 111.875  1.00 62.99           O
HETATM 1234  O   HOH A2489      63.478 144.365 119.330  1.00 67.82           O
HETATM 1235  O   HOH A2490      99.150 133.393 132.662  1.00 65.76           O
HETATM 1236  O   HOH A2491     108.827 160.722 118.204  1.00 69.27           O
HETATM 1237  O   HOH A2492      73.061 138.993 102.746  1.00 78.10           O
HETATM 1238  O   HOH A2493      45.665 126.888 102.406  1.00 68.85           O
HETATM 1239  O   HOH A2494     109.644 152.417 114.787  1.00 65.10           O
HETATM 1240  O   HOH A2495      29.238 112.720 104.875  1.00 72.76           O
HETATM 1241  O   HOH A2496      74.928 102.348 141.642  1.00 77.72           O
HETATM 1242  O   HOH A2497     110.111 146.132 128.504  1.00 71.90           O
HETATM 1243  O   HOH A2498      83.328 118.604 141.535  1.00 72.41           O
HETATM 1244  O   HOH A2499      30.784 133.429 112.202  1.00 71.17           O
HETATM 1245  O   HOH A2500      56.606 112.665  96.899  1.00 66.44           O
HETATM 1246  O   HOH A2501      92.986 151.142 123.739  1.00 63.11           O
HETATM 1247  O   HOH A2502     108.817 164.770 115.195  1.00 72.84           O
HETATM 1248  O   HOH A2503      91.607 146.594  93.377  1.00 78.17           O
HETATM 1249  O   HOH A2504      74.191 142.322 127.091  1.00 68.74           O
HETATM 1250  O   HOH A2505      94.118 117.172 133.747  1.00 56.75           O
HETATM 1251  O   HOH A2506      80.101 145.953 127.832  1.00 72.31           O
HETATM 1252  O   HOH A2507      70.880 120.684 109.236  1.00 63.31           O
HETATM 1253  O   HOH A2508      55.296 125.018 101.745  1.00 60.77           O
HETATM 1254  O   HOH A2509      66.527 140.329 124.089  1.00 68.08           O
HETATM 1255  O   HOH A2510     127.643 138.768 141.840  1.00 85.22           O
HETATM 1256  O   HOH A2511      68.363 126.526  91.213  1.00 81.61           O
HETATM 1257  O   HOH A2512      43.658 113.146  99.830  1.00 63.90           O
HETATM 1258  O   HOH A2513     124.731 138.445 125.066  1.00 74.05           O
HETATM 1259  O   HOH A2514      81.668 122.257 144.080  1.00 69.03           O
HETATM 1260  O   HOH A2515      86.624 146.375 108.545  1.00 68.25           O
HETATM 1261  O   HOH A2516      43.167 140.098 114.371  1.00 68.72           O
HETATM 1262  O   HOH A2517      94.432 134.269 107.898  1.00 60.47           O
HETATM 1263  O   HOH A2518      59.351 136.159 102.237  1.00 69.76           O
HETATM 1264  O   HOH A2519      75.391 111.260 101.527  1.00 70.16           O
HETATM 1265  O   HOH A2520      66.671 128.720 118.630  1.00 59.05           O
HETATM 1266  O   HOH A2521      94.374 153.427 138.064  1.00 70.70           O
HETATM 1267  O   HOH A2522     102.850 170.945 118.229  1.00 77.72           O
HETATM 1268  O   HOH A2523      96.858 135.271 143.185  1.00 74.11           O
HETATM 1269  O   HOH A2524      41.646 139.761 121.223  1.00 71.54           O
HETATM 1270  O   HOH A2525     112.930 144.652 148.563  1.00 77.89           O
HETATM 1271  O   HOH A2526     111.326 127.478 120.977  1.00 65.22           O
HETATM 1272  O   HOH A2527      40.872 122.624 128.294  1.00 66.17           O
HETATM 1273  O   HOH A2528     106.364 136.697 125.286  1.00 68.63           O
HETATM 1274  O   HOH A2529      46.278 111.159 122.034  1.00 64.69           O
HETATM 1275  O   HOH A2530      93.457 130.353  98.306  1.00 69.51           O
HETATM 1276  O   HOH A2531      83.693 160.791 106.225  1.00 70.69           O
HETATM 1277  O   HOH A2532     105.370 130.353 126.854  1.00 66.12           O
HETATM 1278  O   HOH A2533      83.943 120.617 136.120  1.00 67.59           O
HETATM 1279  O   HOH A2534      55.930 107.919 121.760  1.00 70.94           O
HETATM 1280  O   HOH A2535      58.436 101.222 124.731  1.00 72.62           O
HETATM 1281  O   HOH A2536      79.233 135.828 118.994  1.00 57.07           O
HETATM 1282  O   HOH A2537      73.448 127.276 137.827  1.00 66.25           O
HETATM 1283  O   HOH A2538      95.832 116.702 138.445  1.00 63.81           O
HETATM 1284  O   HOH A2539     109.063 161.862 103.229  1.00 67.70           O
HETATM 1285  O   HOH A2540      84.077 101.573 134.168  1.00 74.39           O
HETATM 1286  O   HOH A2541      92.187 171.543 108.298  1.00 79.34           O
HETATM 1287  O   HOH A2542      60.013 136.579 105.886  1.00 68.05           O
HETATM 1288  O   HOH A2543      33.601 111.662 117.283  1.00 72.11           O
HETATM 1289  O   HOH A2544     107.200 142.530 119.211  1.00 68.20           O
HETATM 1290  O   HOH A2545      99.808 144.614 110.935  1.00 64.34           O
HETATM 1291  O   HOH A2546      54.581 104.086 119.685  1.00 71.66           O
HETATM 1292  O   HOH A2547      78.656 125.171 103.236  1.00 73.39           O
HETATM 1293  O   HOH A2548      95.710 109.076 111.901  1.00 63.06           O
HETATM 1294  O   HOH A2549      60.315 149.641 120.405  1.00 82.91           O
HETATM 1295  O   HOH A2550      98.630 138.715 137.507  1.00 75.63           O
HETATM 1296  O   HOH A2551      75.338 130.262  98.910  1.00 77.66           O
HETATM 1297  O   HOH A2552      58.262 140.565 119.950  1.00 68.14           O
HETATM 1298  O   HOH A2553      94.111 175.308 113.647  1.00 73.13           O
HETATM 1299  O   HOH A2554     104.034 155.824 104.700  1.00 68.47           O
HETATM 1300  O   HOH A2555     105.507 146.163 102.158  1.00 69.55           O
HETATM 1301  O   HOH A2556     109.030 142.183 148.279  1.00 78.78           O
HETATM 1302  O   HOH A2557      45.462 112.447 126.777  1.00 65.19           O
HETATM 1303  O   HOH A2558      63.837 132.257 124.195  1.00 66.82           O
HETATM 1304  O   HOH A2559      63.199 128.868  92.743  1.00 80.12           O
HETATM 1305  O   HOH A2560     112.779 149.594 141.613  1.00 77.81           O
HETATM 1306  O   HOH A2561     108.215 146.080 125.588  1.00 67.25           O
HETATM 1307  O   HOH A2562      87.002 146.687 125.969  1.00 66.57           O
HETATM 1308  O   HOH A2563     101.457 155.866 101.829  1.00 69.98           O
HETATM 1309  O   HOH A2564      47.567 109.295 123.680  1.00 63.88           O
HETATM 1310  O   HOH A2565      69.127 116.286 110.178  1.00 64.39           O
HETATM 1311  O   HOH A2566      76.621 105.832 112.289  1.00 67.16           O
HETATM 1312  O   HOH A2567      52.367 119.181  86.748  1.00 76.17           O
HETATM 1313  O   HOH A2568     111.395 135.329 115.692  1.00 62.42           O
HETATM 1314  O   HOH A2569      73.797 150.463 120.528  1.00 71.71           O
HETATM 1315  O   HOH A2570     104.311 120.527 109.620  1.00 63.21           O
HETATM 1316  O   HOH A2571      58.753 113.874  95.312  1.00 70.15           O
HETATM 1317  O   HOH A2572      75.573 133.985 133.468  1.00 62.63           O
HETATM 1318  O   HOH A2573     126.236 132.292 131.147  1.00 80.66           O
HETATM 1319  O   HOH A2574      67.749 140.801 121.137  1.00 66.57           O
HETATM 1320  O   HOH A2575      75.235 117.441 108.664  1.00 61.14           O
HETATM 1321  O   HOH A2576      48.898 137.772 124.779  1.00 71.59           O
HETATM 1322  O   HOH A2577      71.629 125.503 132.077  1.00 57.27           O
HETATM 1323  O   HOH A2578      59.950 132.159 124.651  1.00 64.49           O
HETATM 1324  O   HOH A2579      54.343 132.922 116.534  1.00 64.13           O
HETATM 1325  O   HOH A2580     102.072 143.038 124.173  1.00 66.22           O
HETATM 1326  O   HOH A2581      76.244 124.483 147.721  1.00 68.05           O
HETATM 1327  O   HOH A2582      94.395 174.355 110.943  1.00 78.35           O
HETATM 1328  O   HOH A2583     105.655 117.237 128.341  1.00 70.68           O
HETATM 1329  O   HOH A2584      94.454 171.983 109.483  1.00 77.74           O
HETATM 1330  O   HOH A2585      69.597 139.639 119.939  1.00 64.67           O
HETATM 1331  O   HOH A2586      89.273 143.099 113.584  1.00 64.02           O
HETATM 1332  O   HOH A2587      91.547 120.606 142.742  1.00 67.44           O
HETATM 1333  O   HOH A2588      69.266 117.940 116.807  1.00 55.86           O
HETATM 1334  O   HOH A2589      95.798 137.129 137.032  1.00 72.65           O
HETATM 1335  O   HOH A2590      88.180 114.121 140.613  1.00 71.92           O
HETATM 1336  O   HOH A2591      92.276 158.413 104.041  1.00 69.58           O
HETATM 1337  O   HOH A2592      93.556 126.336 141.418  1.00 63.30           O
HETATM 1338  O   HOH A2593      84.863 150.477 111.034  1.00 68.40           O
HETATM 1339  O   HOH A2594     106.603 142.886 115.536  1.00 65.97           O
HETATM 1340  O   HOH A2595      84.948 146.909 113.956  1.00 64.81           O
HETATM 1341  O   HOH A2596      74.796 115.324 106.571  1.00 65.07           O
HETATM 1342  O   HOH A2597      60.737 120.799  93.198  1.00 68.30           O
HETATM 1343  O   HOH A2598     104.258 124.181 128.189  1.00 68.20           O
HETATM 1344  O   HOH A2599     101.662 138.122 133.101  1.00 72.91           O
HETATM 1345  O   HOH A2600      85.592 147.571  95.119  1.00 74.63           O
HETATM 1346  O   HOH A2601      28.874 131.606 102.136  1.00 82.45           O
HETATM 1347  O   HOH A2602      66.425 106.433 145.970  1.00 77.65           O
HETATM 1348  O   HOH A2603      67.594 124.846 104.555  1.00 69.80           O
HETATM 1349  O   HOH A2604     108.522 158.121 120.424  1.00 64.66           O
HETATM 1350  O   HOH A2605     105.378 162.190 100.496  1.00 73.07           O
HETATM 1351  O   HOH A2606      50.430 130.448 115.988  1.00 63.09           O
HETATM 1352  O   HOH A2607      90.239 141.859  95.094  1.00 73.04           O
HETATM 1353  O   HOH A2608      93.068 150.466 132.171  1.00 71.64           O
HETATM 1354  O   HOH A2609     110.052 124.560 113.228  1.00 59.99           O
HETATM 1355  O   HOH A2610     113.563 156.001 130.807  1.00 74.17           O
HETATM 1356  O   HOH A2611     107.488 122.281 116.568  1.00 63.99           O
HETATM 1357  O   HOH A2612     100.934 119.933 116.697  1.00 63.94           O
HETATM 1358  O   HOH A2613      77.796 129.561 142.156  1.00 69.56           O
HETATM 1359  O   HOH A2614      99.983 163.141 101.051  1.00 72.22           O
HETATM 1360  O   HOH A2615      90.663 165.799 129.374  1.00 71.42           O
HETATM 1361  O   HOH A2616      67.995 102.430 142.662  1.00 84.18           O
HETATM 1362  O   HOH A2617      53.301 125.361  90.629  1.00 72.24           O
HETATM 1363  O   HOH A2618     102.322 110.516 116.126  1.00 71.65           O
HETATM 1364  O   HOH A2619      65.775 112.385 126.146  1.00 56.77           O
HETATM 1365  O   HOH A2620      79.005 152.411 100.741  1.00 78.85           O
HETATM 1366  O   HOH A2621      98.879 115.382 125.986  1.00 60.29           O
HETATM 1367  O   HOH A2622      96.933 108.980 120.265  1.00 65.14           O
HETATM 1368  O   HOH A2623     111.319 135.345 127.645  1.00 72.51           O
HETATM 1369  O   HOH A2624      83.048 107.922 127.527  1.00 70.48           O
HETATM 1370  O   HOH A2625      82.441 166.477 116.705  1.00 72.35           O
HETATM 1371  O   HOH A2626     110.261 123.668 117.312  1.00 64.88           O
HETATM 1372  O   HOH A2627      70.629 143.922 102.761  1.00 78.31           O
HETATM 1373  O   HOH A2628      20.463 114.717 112.839  1.00 79.75           O
HETATM 1374  O   HOH A2629      61.953 112.094 124.982  1.00 63.21           O
HETATM 1375  O   HOH A2630     103.283 113.732 119.285  1.00 69.95           O
HETATM 1376  O   HOH A2631      48.166 130.092 100.219  1.00 70.95           O
HETATM 1377  O   HOH A2632      82.079 141.450  97.239  1.00 75.27           O
HETATM 1378  O   HOH A2633      78.419 137.475 112.632  1.00 65.69           O
HETATM 1379  O   HOH A2634      79.294 162.196 122.901  1.00 74.40           O
HETATM 1380  O   HOH A2635      99.278 166.467 122.771  1.00 67.51           O
HETATM 1381  O   HOH A2636      63.305 144.501 116.794  1.00 66.23           O
HETATM 1382  O   HOH A2637      54.654 123.108  91.646  1.00 69.79           O
HETATM 1383  O   HOH A2638      89.840 168.304 122.091  1.00 76.14           O
HETATM 1384  O   HOH A2639      85.549 153.922 131.340  1.00 68.93           O
HETATM 1385  O   HOH A2640      62.540 105.588 124.107  1.00 65.25           O
HETATM 1386  O   HOH A2641     106.251 169.395 124.646  1.00 75.14           O
HETATM 1387  O   HOH A2642     101.218 169.019 103.890  1.00 79.99           O
HETATM 1388  O   HOH A2643      85.128 109.129 119.838  1.00 59.42           O
HETATM 1389  O   HOH A2644      54.506 130.760 118.397  1.00 61.35           O
HETATM 1390  O   HOH A2645      89.493 139.399 137.890  1.00 71.80           O
HETATM 1391  O   HOH A2646      96.284 148.910 138.666  1.00 77.37           O
HETATM 1392  O   HOH A2647      81.019 151.129 127.945  1.00 72.04           O
HETATM 1393  O   HOH A2648     118.032 128.304 143.436  1.00 76.53           O
HETATM 1394  O   HOH A2649      79.485 126.897 101.852  1.00 75.50           O
HETATM 1395  O   HOH A2650      99.442 156.866 100.034  1.00 70.89           O
HETATM 1396  O   HOH A2651      56.230 127.304 103.244  1.00 63.19           O
HETATM 1397  O   HOH A2652      71.672 133.849  93.107  1.00 85.83           O
HETATM 1398  O   HOH A2653      84.423 153.410  99.555  1.00 74.94           O
HETATM 1399  O   HOH A2654      68.312 134.765 105.901  1.00 73.62           O
HETATM 1400  O   HOH A2655      55.379 123.439 133.248  1.00 62.29           O
HETATM 1401  O   HOH A2656      48.356 133.545 108.216  1.00 68.16           O
HETATM 1402  O   HOH A2657     130.692 135.256 124.190  1.00 75.87           O
HETATM 1403  O   HOH A2658      55.529 105.799 118.452  1.00 70.93           O
HETATM 1404  O   HOH A2659      70.053 118.958 102.391  1.00 69.83           O
HETATM 1405  O   HOH A2660      61.711 123.488  92.766  1.00 73.46           O
HETATM 1406  O   HOH A2661     105.233 141.366  95.294  1.00 68.27           O
HETATM 1407  O   HOH A2662      86.746 116.659 126.411  1.00 57.80           O
HETATM 1408  O   HOH A2663      60.282 147.677 121.682  1.00 81.03           O
HETATM 1409  O   HOH A2664      98.257 135.295 134.211  1.00 71.98           O
HETATM 1410  O   HOH A2665      64.786 138.470 123.856  1.00 65.88           O
HETATM 1411  O   HOH A2666      42.047 113.451 127.585  1.00 65.98           O
HETATM 1412  O   HOH A2667      51.061 135.398 128.526  1.00 68.72           O
HETATM 1413  O   HOH A2668      73.110 121.717 112.730  1.00 59.90           O
HETATM 1414  O   HOH A2669      67.513  98.821 143.207  1.00 86.44           O
HETATM 1415  O   HOH A2670      59.836 102.797 122.289  1.00 70.57           O
HETATM 1416  O   HOH A2671      56.712 115.790 111.313  1.00 61.63           O
HETATM 1417  O   HOH A2672      78.993 119.948 133.523  1.00 63.25           O
HETATM 1418  O   HOH A2673      67.892 123.344 138.065  1.00 68.54           O
HETATM 1419  O   HOH A2674      52.311 105.206 142.165  1.00 76.57           O
HETATM 1420  O   HOH A2675      58.343 145.165 108.151  1.00 69.91           O
HETATM 1421  O   HOH A2676      69.339 103.259 125.626  1.00 70.82           O
HETATM 1422  O   HOH A2677      58.911 106.067 144.419  1.00 71.31           O
HETATM 1423  O   HOH A2678      63.201 102.415 125.373  1.00 68.27           O
HETATM 1424  O   HOH A2679      60.940 128.010 124.015  1.00 59.33           O
HETATM 1425  O   HOH A2680      81.328 152.500 126.032  1.00 70.36           O
HETATM 1426  O   HOH A2681     111.045 139.481 147.852  1.00 76.24           O
HETATM 1427  O   HOH A2682      82.132 153.592 103.643  1.00 74.13           O
HETATM 1428  O   HOH A2683      91.839 173.859 119.560  1.00 76.70           O
HETATM 1429  O   HOH A2684      83.104 155.493 106.152  1.00 68.85           O
HETATM 1430  O   HOH A2685      47.552 135.795 127.159  1.00 70.20           O
HETATM 1431  O   HOH A2686      33.824 135.703 116.529  1.00 71.96           O
HETATM 1432  O   HOH A2687      33.874 129.786  98.008  1.00 82.23           O
HETATM 1433  O   HOH A2688      73.814 142.981 100.166  1.00 82.88           O
HETATM 1434  O   HOH A2689      79.090 155.041 108.175  1.00 73.36           O
HETATM 1435  O   HOH A2690      85.599 126.563 137.857  1.00 64.47           O
HETATM 1436  O   HOH A2691      68.342 122.191 131.704  1.00 58.36           O
HETATM 1437  O   HOH A2692      65.775 115.846 116.682  1.00 59.26           O
HETATM 1438  O   HOH A2693     110.699 147.612 123.131  1.00 67.09           O
HETATM 1439  O   HOH A2694      75.493 130.761 138.703  1.00 68.18           O
HETATM 1440  O   HOH A2695      65.196 123.037 121.218  1.00 58.15           O
HETATM 1441  O   HOH A2696      53.914 136.084 131.190  1.00 71.05           O
HETATM 1442  O   HOH A2697      81.578 133.249 139.916  1.00 69.89           O
HETATM 1443  O   HOH A2698      46.423 137.903 109.684  1.00 69.10           O
HETATM 1444  O   HOH A2699      77.222 157.830 108.747  1.00 73.21           O
HETATM 1445  O   HOH A2700     107.438 128.814 126.708  1.00 69.37           O
HETATM 1446  O   HOH A2701      59.068 111.239 103.777  1.00 63.80           O
HETATM 1447  O   HOH A2702      48.595 131.441 111.055  1.00 63.18           O
HETATM 1448  O   HOH A2703      34.293 120.060 119.402  1.00 71.11           O
HETATM 1449  O   HOH A2704     110.373 158.422 125.437  1.00 64.90           O
HETATM 1450  O   HOH A2705      83.217 105.237 119.845  1.00 62.72           O
HETATM 1451  O   HOH A2706      79.274 160.184 124.408  1.00 73.40           O
HETATM 1452  O   HOH A2707     101.793 118.367 118.712  1.00 63.68           O
HETATM 1453  O   HOH A2708      46.717 135.234 108.154  1.00 70.39           O
HETATM 1454  O   HOH A2709      50.838 109.454 107.106  1.00 59.03           O
HETATM 1455  O   HOH A2710      59.943 113.836 107.408  1.00 65.27           O
HETATM 1456  O   HOH A2711     121.376 146.905 146.607  1.00 83.14           O
HETATM 1457  O   HOH A2712      60.423 103.242 118.350  1.00 70.51           O
HETATM 1458  O   HOH A2713      57.534 147.011 120.412  1.00 75.77           O
HETATM 1459  O   HOH A2714     109.977 151.212 143.694  1.00 80.30           O
HETATM 1460  O   HOH A2715      78.088 113.806 145.383  1.00 78.17           O
HETATM 1461  O   HOH A2716      30.369 135.844 120.557  1.00 77.83           O
HETATM 1462  O   HOH A2717      32.117 125.917  96.037  1.00 82.92           O
HETATM 1463  O   HOH A2718     111.386 153.177 139.354  1.00 76.41           O
HETATM 1464  O   HOH A2719      58.113 139.042 103.103  1.00 71.12           O
HETATM 1465  O   HOH A2720      54.176 147.956 112.906  1.00 68.96           O
HETATM 1466  O   HOH A2721     111.899 147.141 147.046  1.00 81.25           O
HETATM 1467  O   HOH A2722      79.735 150.625 103.099  1.00 77.39           O
HETATM 1468  O   HOH A2723      49.974 130.744 102.615  1.00 66.53           O
HETATM 1469  O   HOH A2724      56.121 113.833 135.547  1.00 69.69           O
HETATM 1470  O   HOH A2725      50.730 143.976 120.857  1.00 69.39           O
HETATM 1471  O   HOH A2726      29.157 129.794 107.079  1.00 73.11           O
HETATM 1472  O   HOH A2727     110.840 130.634 122.165  1.00 66.72           O
HETATM 1473  O   HOH A2728      89.816 151.181 135.227  1.00 78.17           O
HETATM 1474  O   HOH A2729      70.173 114.276 103.507  1.00 71.58           O
HETATM 1475  O   HOH A2730      82.894 132.922 100.292  1.00 73.35           O
HETATM 1476  O   HOH A2731      65.471 107.498 123.977  1.00 71.63           O
HETATM 1477  O   HOH A2732      97.800 114.531 107.091  1.00 65.20           O
HETATM 1478  O   HOH A2733      77.765 152.358 104.382  1.00 78.53           O
HETATM 1479  O   HOH A2734      80.984 102.572 139.244  1.00 74.72           O
HETATM 1480  O   HOH A2735      82.235 141.411 117.025  1.00 63.87           O
HETATM 1481  O   HOH A2736      54.895 113.649 112.340  1.00 62.00           O
HETATM 1482  O   HOH A2737     107.073 168.003 126.448  1.00 73.13           O
HETATM 1483  O   HOH A2738     102.760 127.911 128.107  1.00 64.77           O
HETATM 1484  O   HOH A2739     106.974 146.666 111.321  1.00 69.69           O
HETATM 1485  O   HOH A2740      84.173 104.982 127.891  1.00 73.94           O
HETATM 1486  O   HOH A2741      45.119 125.740 129.676  1.00 66.30           O
HETATM 1487  O   HOH A2742      67.344 136.419 117.258  1.00 63.79           O
HETATM 1488  O   HOH A2743      94.381 124.126 142.538  1.00 65.52           O
HETATM 1489  O   HOH A2744     120.093 129.910 131.278  1.00 76.86           O
HETATM 1490  O   HOH A2745      39.393 136.740 125.031  1.00 75.63           O
HETATM 1491  O   HOH A2746      95.063 167.519 135.083  1.00 76.73           O
HETATM 1492  O   HOH A2747      52.042 135.143 121.494  1.00 65.68           O
HETATM 1493  O   HOH A2748      80.025 166.975 126.601  1.00 75.79           O
HETATM 1494  O   HOH A2749      85.918 119.044  94.377  1.00 77.41           O
HETATM 1495  O   HOH A2750      74.696 122.532 148.613  1.00 71.47           O
HETATM 1496  O   HOH A2751     112.263 124.063 144.351  1.00 77.28           O
HETATM 1497  O   HOH A2752      47.676 111.413 113.744  1.00 62.51           O
HETATM 1498  O   HOH A2753     117.641 126.217 137.127  1.00 79.39           O
HETATM 1499  O   HOH A2754      64.854 154.570 114.902  1.00 81.14           O
HETATM 1500  O   HOH A2755     118.393 147.453 126.866  1.00 80.74           O
HETATM 1501  O   HOH A2756      72.427 145.892 100.841  1.00 78.54           O
HETATM 1502  O   HOH A2757      53.776 131.662  96.416  1.00 69.77           O
HETATM 1503  O   HOH A2758      62.309 100.069 127.474  1.00 77.05           O
HETATM 1504  O   HOH A2759      98.919 108.703 112.654  1.00 68.04           O
HETATM 1505  O   HOH A2760      80.031 143.278 116.692  1.00 66.75           O
HETATM 1506  O   HOH A2761      53.284 132.963 105.621  1.00 66.27           O
HETATM 1507  O   HOH A2762      65.772 141.298 105.975  1.00 73.74           O
HETATM 1508  O   HOH A2763      98.547 115.824 142.188  1.00 75.77           O
HETATM 1509  O   HOH A2764      72.536 155.964 111.992  1.00 72.63           O
HETATM 1510  O   HOH A2765      40.557 109.691 101.737  1.00 63.97           O
HETATM 1511  O   HOH A2766      65.267 108.226 146.851  1.00 78.42           O
HETATM 1512  O   HOH A2767     110.702 122.218 144.724  1.00 79.95           O
HETATM 1513  O   HOH A2768      69.796 125.374 139.991  1.00 68.80           O
HETATM 1514  O   HOH A2769      84.781 143.147  98.602  1.00 70.10           O
HETATM 1515  O   HOH A2770      71.293 116.995 108.951  1.00 65.24           O
HETATM 1516  O   HOH A2771      74.511 106.182 124.961  1.00 65.72           O
HETATM 1517  O   HOH A2772     109.705 115.815 133.961  1.00 75.99           O
HETATM 1518  O   HOH A2773     106.511 149.131 110.399  1.00 63.05           O
HETATM 1519  O   HOH A2774      98.507 143.741 133.948  1.00 73.76           O
HETATM 1520  O   HOH A2775      80.974 119.307 136.785  1.00 68.90           O
HETATM 1521  O   HOH A2776      98.844 145.713  97.331  1.00 70.82           O
HETATM 1522  O   HOH A2777     103.024 171.403 115.920  1.00 80.07           O
HETATM 1523  O   HOH A2778     100.721 128.080 131.958  1.00 62.39           O
HETATM 1524  O   HOH A2779      37.990 119.803 128.226  1.00 67.24           O
HETATM 1525  O   HOH A2780      67.578 117.200  99.533  1.00 68.47           O
HETATM 1526  O   HOH A2781     110.079 142.273 124.948  1.00 73.74           O
HETATM 1527  O   HOH A2782      50.085 133.349 133.831  1.00 76.58           O
HETATM 1528  O   HOH A2783      59.625 134.870 115.558  1.00 59.90           O
HETATM 1529  O   HOH A2784      74.370 121.226  99.752  1.00 71.18           O
HETATM 1530  O   HOH A2785      55.403 126.572  89.117  1.00 73.62           O
HETATM 1531  O   HOH A2786      32.122 104.223 115.171  1.00 75.50           O
HETATM 1532  O   HOH A2787     102.083 149.247  98.521  1.00 71.08           O
HETATM 1533  O   HOH A2788     100.906 142.503 121.808  1.00 66.24           O
HETATM 1534  O   HOH A2789     112.881 123.121 142.259  1.00 76.74           O
HETATM 1535  O   HOH A2790      79.095  99.285 137.505  1.00 78.33           O
HETATM 1536  O   HOH A2791      55.204 114.782  97.049  1.00 66.78           O
HETATM 1537  O   HOH A2792      63.651 158.162 121.528  1.00 92.15           O
HETATM 1538  O   HOH A2793      90.999 159.427 132.912  1.00 70.49           O
HETATM 1539  O   HOH A2794     103.940 119.317 114.225  1.00 61.10           O
HETATM 1540  O   HOH A2795      90.528 126.235 140.880  1.00 64.52           O
HETATM 1541  O   HOH A2796     124.848 139.705 134.533  1.00 79.92           O
HETATM 1542  O   HOH A2797      95.211 149.891 136.677  1.00 79.06           O
HETATM 1543  O   HOH A2798     103.863 124.933 106.244  1.00 60.13           O
HETATM 1544  O   HOH A2799      69.625 123.689 135.732  1.00 61.56           O
HETATM 1545  O   HOH A2800      79.921 158.834 126.993  1.00 69.49           O
HETATM 1546  O   HOH A2801      61.842 131.051 123.717  1.00 65.46           O
HETATM 1547  O   HOH A2802     127.052 136.687 139.316  1.00 83.07           O
HETATM 1548  O   HOH A2803      58.351 151.696 116.305  1.00 84.62           O
HETATM 1549  O   HOH A2804      50.318 115.506 135.194  1.00 70.90           O
HETATM 1550  O   HOH A2805      46.388 109.453 103.195  1.00 60.93           O
HETATM 1551  O   HOH A2806      68.662 155.222 118.194  1.00 76.92           O
HETATM 1552  O   HOH A2807      89.649 130.408 102.339  1.00 66.41           O
HETATM 1553  O   HOH A2808      68.905 154.923 110.371  1.00 76.85           O
HETATM 1554  O   HOH A2809     129.038 144.959 136.889  1.00 86.74           O
HETATM 1555  O   HOH A2810      99.952 141.412 135.251  1.00 73.00           O
HETATM 1556  O   HOH A2811      64.357 118.569  97.996  1.00 69.14           O
HETATM 1557  O   HOH A2812     112.223 135.102 122.624  1.00 73.58           O
HETATM 1558  O   HOH A2813      35.804 127.014  96.832  1.00 75.63           O
HETATM 1559  O   HOH A2814      59.599 128.450 126.558  1.00 64.08           O
HETATM 1560  O   HOH A2815      83.441 153.719 101.660  1.00 76.11           O
HETATM 1561  O   HOH A2816      89.645 112.152 139.790  1.00 71.36           O
HETATM 1562  O   HOH A2817      81.535 119.268 145.692  1.00 71.52           O
HETATM 1563  O   HOH A2818      43.068 109.986 124.028  1.00 72.30           O
HETATM 1564  O   HOH A2819      71.235 128.538 130.589  1.00 63.35           O
HETATM 1565  O   HOH A2820      53.992 110.057 122.776  1.00 68.77           O
HETATM 1566  O   HOH A2821      46.300 110.662 101.156  1.00 62.93           O
HETATM 1567  O   HOH A2822     101.971 125.319  99.601  1.00 63.52           O
HETATM 1568  O   HOH A2823     114.275 139.413 146.949  1.00 76.20           O
HETATM 1569  O   HOH A2824      24.942 116.663 101.719  1.00 74.71           O
HETATM 1570  O   HOH A2825     104.084 150.393  95.118  1.00 66.14           O
HETATM 1571  O   HOH A2826      41.265 106.792 116.459  1.00 68.28           O
HETATM 1572  O   HOH A2827      81.154 119.715 140.060  1.00 72.49           O
HETATM 1573  O   HOH A2828      74.340  97.690 140.090  1.00 82.26           O
HETATM 1574  O   HOH A2829      68.794 147.475 103.953  1.00 75.01           O
HETATM 1575  O   HOH A2830      71.475 141.030 101.429  1.00 79.19           O
HETATM 1576  O   HOH A2831      83.289 122.070 138.906  1.00 68.57           O
HETATM 1577  O   HOH A2832     102.709 145.469 123.746  1.00 65.87           O
HETATM 1578  O   HOH A2833      84.793 130.810 103.111  1.00 72.23           O
HETATM 1579  O   HOH A2834      81.701 151.254  99.791  1.00 74.53           O
HETATM 1580  O   HOH A2835      60.382 139.976 106.166  1.00 70.81           O
HETATM 1581  O   HOH A2836      47.154 104.311 124.832  1.00 77.78           O
HETATM 1582  O   HOH A2837      44.209 129.629 131.296  1.00 72.22           O
HETATM 1583  O   HOH A2838      48.040 145.393 118.597  1.00 71.91           O
HETATM 1584  O   HOH A2839     109.764 144.932 148.524  1.00 76.17           O
HETATM 1585  O   HOH A2840      98.540 122.694 100.933  1.00 64.19           O
HETATM 1586  O   HOH A2841     106.181 123.445 126.873  1.00 70.33           O
HETATM 1587  O   HOH A2842      95.179 143.797 140.006  1.00 82.17           O
HETATM 1588  O   HOH A2843     111.378 155.365 113.977  1.00 70.63           O
HETATM 1589  O   HOH A2844      70.222 112.061 120.612  1.00 62.00           O
HETATM 1590  O   HOH A2845      77.219 143.607 100.099  1.00 77.96           O
HETATM 1591  O   HOH A2846     100.762 127.656 129.352  1.00 64.09           O
HETATM 1592  O   HOH A2847     125.664 134.184 128.187  1.00 76.41           O
HETATM 1593  O   HOH A2848      85.366 124.224 137.709  1.00 65.23           O
HETATM 1594  O   HOH A2849     110.624 116.885 137.927  1.00 74.96           O
HETATM 1595  O   HOH A2850      62.966  98.559 129.329  1.00 79.81           O
HETATM 1596  O   HOH A2851      33.910 136.084 114.233  1.00 73.85           O
HETATM 1597  O   HOH A2852     110.708 148.014 114.586  1.00 70.37           O
HETATM 1598  O   HOH A2853      93.695 140.311 133.322  1.00 70.38           O
HETATM 1599  O   HOH A2854      67.031 104.605 143.885  1.00 78.06           O
HETATM 1600  O   HOH A2855      98.023 147.170 130.933  1.00 72.53           O
HETATM 1601  O   HOH A2856      53.139 108.773 124.489  1.00 67.13           O
HETATM 1602  O   HOH A2857      45.465 111.727 124.514  1.00 69.63           O
HETATM 1603  O   HOH A2858      37.770 130.178 104.019  1.00 72.76           O
HETATM 1604  O   HOH A2859      66.748 136.299 114.353  1.00 65.84           O
HETATM 1605  O   HOH A2860      93.421 112.358  98.841  1.00 62.31           O
HETATM 1606  O   HOH A2861     110.794 173.309 114.674  1.00 81.61           O
HETATM 1607  O   HOH A2862     103.731 119.335 123.562  1.00 66.35           O
HETATM 1608  O   HOH A2863      34.203 120.373  91.747  1.00 79.31           O
HETATM 1609  O   HOH A2864      73.242 134.962 132.697  1.00 66.82           O
HETATM 1610  O   HOH A2865     115.584 133.151 146.276  1.00 80.32           O
HETATM 1611  O   HOH A2866      78.099 131.060 140.065  1.00 68.76           O
HETATM 1612  O   HOH A2867      68.406 123.823 129.463  1.00 55.57           O
HETATM 1613  O   HOH A2868      42.301 136.108 108.824  1.00 68.26           O
HETATM 1614  O   HOH A2869      91.508 107.552 126.452  1.00 66.16           O
HETATM 1615  O   HOH A2870      57.427 111.325 142.254  1.00 70.91           O
HETATM 1616  O   HOH A2871     105.268 120.562 117.687  1.00 71.46           O
HETATM 1617  O   HOH A2872     122.541 142.563 125.974  1.00 78.19           O
HETATM 1618  O   HOH A2873     110.675 159.021 114.719  1.00 71.46           O
HETATM 1619  O   HOH A2874     100.974 128.224  99.385  1.00 63.63           O
HETATM 1620  O   HOH A2875      81.028 110.353 144.742  1.00 74.76           O
HETATM 1621  O   HOH A2876      78.454 121.431  95.990  1.00 75.38           O
HETATM 1622  O   HOH A2877     106.982 130.078 151.979  1.00 76.58           O
HETATM 1623  O   HOH A2878      90.382 123.920 140.454  1.00 63.56           O
HETATM 1624  O   HOH A2879      99.344 170.194 129.023  1.00 77.25           O
HETATM 1625  O   HOH A2880      68.666 115.544 114.632  1.00 61.18           O
HETATM 1626  O   HOH A2881      65.051 138.234 104.647  1.00 70.72           O
HETATM 1627  O   HOH A2882      98.332 146.412 106.848  1.00 64.86           O
HETATM 1628  O   HOH A2883     100.405 145.179 113.545  1.00 66.09           O
HETATM 1629  O   HOH A2884      59.647  98.567 127.633  1.00 75.83           O
HETATM 1630  O   HOH A2885     128.180 147.364 140.218  1.00 88.18           O
HETATM 1631  O   HOH A2886      42.906 111.588 117.769  1.00 67.14           O
HETATM 1632  O   HOH A2887     112.839 129.658 118.362  1.00 65.71           O
HETATM 1633  O   HOH A2888      68.491 127.567 128.092  1.00 59.15           O
HETATM 1634  O   HOH A2889      61.552 102.110 123.700  1.00 73.61           O
HETATM 1635  O   HOH A2890      93.773 171.726 126.688  1.00 75.97           O
HETATM 1636  O   HOH A2891     109.794 157.055 113.326  1.00 72.01           O
HETATM 1637  O   HOH A2892      97.379 145.184 138.606  1.00 81.91           O
HETATM 1638  O   HOH A2893     101.797 136.249 131.658  1.00 71.10           O
HETATM 1639  O   HOH A2894      85.196 109.690 126.795  1.00 68.97           O
HETATM 1640  O   HOH A2895      48.352 110.309 125.907  1.00 68.49           O
HETATM 1641  O   HOH A2896      44.698 110.404 116.678  1.00 68.23           O
HETATM 1642  O   HOH A2897     132.339 139.031 121.249  1.00 75.85           O
HETATM 1643  O   HOH A2898      95.871 135.198 140.997  1.00 73.56           O
HETATM 1644  O   HOH A2899      70.882 109.625 123.315  1.00 65.93           O
HETATM 1645  O   HOH A2900      78.523 100.453 139.418  1.00 76.87           O
HETATM 1646  O   HOH A2901      74.022 118.910 149.298  1.00 74.63           O
HETATM 1647  O   HOH A2902     109.422 135.269 120.201  1.00 65.88           O
HETATM 1648  O   HOH A2903      82.951 158.920 120.957  1.00 70.28           O
HETATM 1649  O   HOH A2904      97.436 153.608 140.354  1.00 76.80           O
HETATM 1650  O   HOH A2905      40.622 110.755 115.521  1.00 65.00           O
HETATM 1651  O   HOH A2906      72.837 109.959 113.903  1.00 63.93           O
HETATM 1652  O   HOH A2907      60.245 141.036 121.747  1.00 69.00           O
HETATM 1653  O   HOH A2908      22.459 109.498 105.497  1.00 79.45           O
HETATM 1654  O   HOH A2909      99.937 118.615 106.025  1.00 62.47           O
HETATM 1655  O   HOH A2910      69.408 115.225 101.483  1.00 70.45           O
HETATM 1656  O   HOH A2911     101.221 147.081  98.168  1.00 71.28           O
HETATM 1657  O   HOH A2912      69.751 143.445  99.224  1.00 86.30           O
HETATM 1658  O   HOH A2913      86.285 166.116 130.175  1.00 75.85           O
HETATM 1659  O   HOH A2914      86.766 151.462 132.425  1.00 70.34           O
HETATM 1660  O   HOH A2915      69.282 128.473 101.426  1.00 70.02           O
HETATM 1661  O   HOH A2916      59.963  99.569 125.498  1.00 73.64           O
HETATM 1662  O   HOH A2917      78.913 105.861 126.062  1.00 72.72           O
HETATM 1663  O   HOH A2918      18.596 114.269 115.688  1.00 84.13           O
HETATM 1664  O   HOH A2919      63.285 111.485 144.674  1.00 73.88           O
HETATM 1665  O   HOH A2920      99.767 135.230 131.098  1.00 67.09           O
HETATM 1666  O   HOH A2921      91.214 149.257 133.917  1.00 74.37           O
HETATM 1667  O   HOH A2922     102.542 138.378  94.462  1.00 68.85           O
HETATM 1668  O   HOH A2923      86.741 123.563 102.668  1.00 68.92           O
HETATM 1669  O   HOH A2924      95.840 139.951 132.311  1.00 71.81           O
HETATM 1670  O   HOH A2925      63.911 146.041 106.777  1.00 72.98           O
HETATM 1671  O   HOH A2926     100.453 117.996 110.942  1.00 60.60           O
HETATM 1672  O   HOH A2927     110.400 126.378 147.357  1.00 73.84           O
HETATM 1673  O   HOH A2928      60.371 115.070 132.481  1.00 64.20           O
HETATM 1674  O   HOH A2929      77.686 136.661 135.895  1.00 68.48           O
HETATM 1675  O   HOH A2930      58.039 108.821 121.184  1.00 69.44           O
HETATM 1676  O   HOH A2931      61.280 148.488 109.129  1.00 73.57           O
HETATM 1677  O   HOH A2932      61.672 144.495 120.871  1.00 70.62           O
HETATM 1678  O   HOH A2933      35.784 133.697 122.928  1.00 72.68           O
HETATM 1679  O   HOH A2934      79.301 106.167 120.115  1.00 65.48           O
HETATM 1680  O   HOH A2935      30.567 120.852  96.751  1.00 73.31           O
HETATM 1681  O   HOH A2936      58.063 133.367  92.307  1.00 71.99           O
HETATM 1682  O   HOH A2937      88.104 108.631 123.974  1.00 68.74           O
HETATM 1683  O   HOH A2938      77.744 144.307  97.566  1.00 75.97           O
HETATM 1684  O   HOH A2939      93.331 132.609 139.737  1.00 68.53           O
HETATM 1685  O   HOH A2940      67.513 120.248  99.711  1.00 71.83           O
HETATM 1686  O   HOH A2941      83.313 121.252 133.851  1.00 65.26           O
HETATM 1687  O   HOH A2942      45.071 110.104 120.260  1.00 66.92           O
HETATM 1688  O   HOH A2943     106.798 121.738 123.719  1.00 65.15           O
HETATM 1689  O   HOH A2944     116.158 150.003 138.817  1.00 77.53           O
HETATM 1690  O   HOH A2945      55.665 109.759 142.578  1.00 75.59           O
HETATM 1691  O   HOH A2946     122.128 132.978 142.317  1.00 76.92           O
HETATM 1692  O   HOH A2947      72.120 115.137 104.644  1.00 76.45           O
HETATM 1693  O   HOH A2948      34.240 105.625 113.928  1.00 72.79           O
HETATM 1694  O   HOH A2949      99.850 170.254 125.871  1.00 71.38           O
HETATM 1695  O   HOH A2950      90.192 154.093  97.344  1.00 75.62           O
HETATM 1696  O   HOH A2951      84.515 120.875 131.206  1.00 59.58           O
HETATM 1697  O   HOH A2952     109.702 122.811 127.065  1.00 71.64           O
HETATM 1698  O   HOH A2953      49.194 132.852 105.981  1.00 70.66           O
HETATM 1699  O   HOH A2954      78.509 160.875 109.337  1.00 70.96           O
HETATM 1700  O   HOH A2955      71.442 111.331 115.194  1.00 63.38           O
HETATM 1701  O   HOH A2956      46.742 109.576 117.398  1.00 68.61           O
HETATM 1702  O   HOH A2957      85.453 106.312 120.063  1.00 63.57           O
HETATM 1703  O   HOH A2958     112.887 132.967 123.657  1.00 77.83           O
HETATM 1704  O   HOH A2959      99.859 116.035 107.680  1.00 67.40           O
HETATM 1705  O   HOH A2960     135.563 138.393 116.448  1.00 73.39           O
HETATM 1706  O   HOH A2961      70.826 101.964 142.893  1.00 82.89           O
HETATM 1707  O   HOH A2962     127.696 137.392 126.051  1.00 75.45           O
HETATM 1708  O   HOH A2963      82.375 158.619 105.660  1.00 74.29           O
HETATM 1709  O   HOH A2964     123.900 144.612 145.261  1.00 83.74           O
HETATM 1710  O   HOH A2965      67.067 101.993 124.830  1.00 72.89           O
HETATM 1711  O   HOH A2966      86.754 174.997 124.682  1.00 82.94           O
HETATM 1712  O   HOH A2967      47.367 132.712 135.316  1.00 76.43           O
HETATM 1713  O   HOH A2968      75.716 116.816 148.820  1.00 80.18           O
HETATM 1714  O   HOH A2969      60.309 117.479 138.098  1.00 72.37           O
HETATM 1715  O   HOH A2970      61.380 114.755  94.787  1.00 72.55           O
HETATM 1716  O   HOH A2971      58.121 112.906 134.615  1.00 68.94           O
HETATM 1717  O   HOH A2972      58.003 114.765 115.418  1.00 65.31           O
HETATM 1718  O   HOH A2973      73.923 155.761 114.133  1.00 73.53           O
HETATM 1719  O   HOH A2974      86.826 117.713 140.785  1.00 71.36           O
HETATM 1720  O   HOH A2975      71.117 123.413  96.296  1.00 75.49           O
HETATM 1721  O   HOH A2976      55.829 134.874  94.415  1.00 69.21           O
HETATM 1722  O   HOH A2977      61.246 140.313 123.813  1.00 68.95           O
HETATM 1723  O   HOH A2978      80.494 158.815 107.734  1.00 73.86           O
HETATM 1724  O   HOH A2979      92.928 142.530 132.525  1.00 69.75           O
HETATM 1725  O   HOH A2980      88.661 167.138 104.496  1.00 72.76           O
HETATM 1726  O   HOH A2981      81.143 114.608  95.848  1.00 71.88           O
HETATM 1727  O   HOH A2982      97.722 167.107 105.813  1.00 75.68           O
HETATM 1728  O   HOH A2983      35.524 109.451 103.362  1.00 74.12           O
HETATM 1729  O   HOH A2984      60.028 127.034 128.383  1.00 60.17           O
HETATM 1730  O   HOH A2985      58.345  98.902 132.346  1.00 79.43           O
HETATM 1731  O   HOH A2986     115.516 120.172 135.321  1.00 79.40           O
HETATM 1732  O   HOH A2987      48.856 107.647 110.717  1.00 63.99           O
HETATM 1733  O   HOH A2988      80.874 129.814 101.944  1.00 76.94           O
HETATM 1734  O   HOH A2989      42.763 110.887 119.984  1.00 67.29           O
HETATM 1735  O   HOH A2990      93.238 116.917 137.688  1.00 63.71           O
HETATM 1736  O   HOH A2991      83.369 149.134  95.706  1.00 74.65           O
HETATM 1737  O   HOH A2992      86.565 105.257 126.833  1.00 79.27           O
HETATM 1738  O   HOH A2993      87.272 145.416 131.796  1.00 72.37           O
HETATM 1739  O   HOH A2994      96.887 171.452 127.630  1.00 74.67           O
HETATM 1740  O   HOH A2995      38.659 128.861 100.475  1.00 72.09           O
HETATM 1741  O   HOH A2996      35.554 108.972 116.037  1.00 72.67           O
HETATM 1742  O   HOH A2997      95.056 149.686 134.327  1.00 76.76           O
HETATM 1743  O   HOH A2998      79.685 106.872 122.324  1.00 65.96           O
HETATM 1744  O   HOH A2999      96.686 157.885 140.153  1.00 82.06           O
HETATM 1745  O   HOH A3000      53.064 137.191 122.793  1.00 70.63           O
HETATM 1746  O   HOH A3001      91.609 176.807 121.173  1.00 77.02           O
HETATM 1747  O   HOH A3002      74.733 106.940 110.968  1.00 68.89           O
HETATM 1748  O   HOH A3003      80.410 148.210  98.680  1.00 80.61           O
HETATM 1749  O   HOH A3004     119.855 135.565 145.770  1.00 72.73           O
HETATM 1750  O   HOH A3005     104.059 174.366 117.050  1.00 80.39           O
HETATM 1751  O   HOH A3006      57.858 113.317 118.069  1.00 62.20           O
HETATM 1752  O   HOH A3007      83.971 123.696 141.827  1.00 70.86           O
HETATM 1753  O   HOH A3008      54.939 138.482 123.451  1.00 68.29           O
HETATM 1754  O   HOH A3009      69.614 143.531 123.167  1.00 69.79           O
HETATM 1755  O   HOH A3010      62.813 131.464  91.830  1.00 79.53           O
HETATM 1756  O   HOH A3011      98.518 114.334 112.810  1.00 60.77           O
HETATM 1757  O   HOH A3012     100.444 110.621 112.914  1.00 70.51           O
HETATM 1758  O   HOH A3013      99.523 137.083 133.224  1.00 73.22           O
HETATM 1759  O   HOH A3014      77.713 139.400  99.663  1.00 79.29           O
HETATM 1760  O   HOH A3015      98.012 113.568 137.373  1.00 70.48           O
HETATM 1761  O   HOH A3016     109.787 128.849 126.520  1.00 73.61           O
HETATM 1762  O   HOH A3017      86.422 145.858 112.075  1.00 67.59           O
HETATM 1763  O   HOH A3018      66.053 141.295 101.951  1.00 82.58           O
HETATM 1764  O   HOH A3019     101.069 117.832 114.730  1.00 63.86           O
HETATM 1765  O   HOH A3020      72.810 126.837  97.376  1.00 80.01           O
HETATM 1766  O   HOH A3021      97.601 138.450 133.206  1.00 74.88           O
HETATM 1767  O   HOH A3022      72.421 144.416 127.943  1.00 76.63           O
HETATM 1768  O   HOH A3023      81.892 129.049 104.277  1.00 73.60           O
HETATM 1769  O   HOH A3024      47.558 129.260 105.214  1.00 66.75           O
HETATM 1770  O   HOH A3025     125.719 142.480 146.025  1.00 88.66           O
HETATM 1771  O   HOH A3026      62.523 149.560 111.876  1.00 68.21           O
HETATM 1772  O   HOH A3027      76.263 105.268 126.310  1.00 68.00           O
HETATM 1773  O   HOH A3028      94.052 139.961 136.201  1.00 75.85           O
HETATM 1774  O   HOH A3029      64.148 110.322 146.704  1.00 75.41           O
HETATM 1775  O   HOH A3030      61.356 118.693 134.247  1.00 70.28           O
HETATM 1776  O   HOH A3031      81.354 148.528 128.825  1.00 71.94           O
HETATM 1777  O   HOH A3032      80.042  98.918 134.907  1.00 74.61           O
HETATM 1778  O   HOH A3033      85.074 111.882 125.416  1.00 65.62           O
HETATM 1779  O   HOH A3034      83.769 110.311 122.796  1.00 62.68           O
HETATM 1780  O   HOH A3035      91.953 139.964 137.279  1.00 74.72           O
HETATM 1781  O   HOH A3036      51.020 136.755 124.386  1.00 69.02           O
HETATM 1782  O   HOH A3037      34.161 136.575 118.980  1.00 76.21           O
HETATM 1783  O   HOH A3038      89.886 163.515 133.661  1.00 74.67           O
HETATM 1784  O   HOH A3039     104.951 149.199 146.143  1.00 80.86           O
HETATM 1785  O   HOH A3040      59.895  98.012 130.716  1.00 79.94           O
HETATM 1786  O   HOH A3041      96.381 168.770 107.698  1.00 78.31           O
HETATM 1787  O   HOH A3042     110.876 149.352 145.338  1.00 78.63           O
HETATM 1788  O   HOH A3043      66.736 105.667 123.191  1.00 74.76           O
HETATM 1789  O   HOH A3044      71.837 110.625 118.321  1.00 63.64           O
HETATM 1790  O   HOH A3045      76.902 126.823  99.480  1.00 75.88           O
HETATM 1791  O   HOH A3046      87.251 155.871  97.613  1.00 73.86           O
HETATM 1792  O   HOH A3047      92.003 143.980  94.495  1.00 74.46           O
HETATM 1793  O   HOH A3048      74.954 137.081  99.776  1.00 80.05           O
HETATM 1794  O   HOH A3049      95.151 144.082  94.347  1.00 76.47           O
HETATM 1795  O   HOH A3050      79.078 131.070 100.134  1.00 77.83           O
HETATM 1796  O   HOH A3051      98.408 176.258 116.842  1.00 79.68           O
HETATM 1797  O   HOH A3052     110.798 153.922 121.810  1.00 68.34           O
HETATM 1798  O   HOH A3053      75.081 159.378 111.446  1.00 72.71           O
HETATM 1799  O   HOH A3054      38.253 110.690 102.770  1.00 71.99           O
HETATM 1800  O   HOH A3055      84.228 148.958 129.806  1.00 71.23           O
HETATM 1801  O   HOH A3056      78.362 107.263 124.214  1.00 68.92           O
HETATM 1802  O   HOH A3057     132.869 127.255 115.259  1.00 77.91           O
HETATM 1803  O   HOH A3058      60.091 103.107 143.471  1.00 77.15           O
HETATM 1804  O   HOH A3059      38.566 109.168  99.227  1.00 72.70           O
HETATM 1805  O   HOH A3060      89.195 108.789 121.173  1.00 66.97           O
HETATM 1806  O   HOH A3061      50.396  93.726 130.042  1.00 74.33           O
HETATM 1807  O   HOH A3062      59.108 148.187 107.860  1.00 73.72           O
HETATM 1808  O   HOH A3063      73.152 112.566 103.036  1.00 73.99           O
HETATM 1809  O   HOH A3064     107.581 124.377 124.997  1.00 72.52           O
HETATM 1810  O   HOH A3065      61.567 108.563 122.388  1.00 69.03           O
HETATM 1811  O   HOH A3066      87.902 123.102 140.352  1.00 68.40           O
HETATM 1812  O   HOH A3067      86.499 147.792 110.475  1.00 68.63           O
HETATM 1813  O   HOH A3068     108.255 151.575 145.353  1.00 83.22           O
HETATM 1814  O   HOH A3069      98.096 142.359 127.326  1.00 68.62           O
HETATM 1815  O   HOH A3070      65.078 153.719 112.582  1.00 80.00           O
HETATM 1816  O   HOH A3071      63.240 134.758 125.252  1.00 69.10           O
HETATM 1817  O   HOH A3072      96.238 146.618 132.386  1.00 74.82           O
HETATM 1818  O   HOH A3073      99.509 157.167 139.695  1.00 81.11           O
HETATM 1819  O   HOH A3074      57.899 124.300  91.022  1.00 70.04           O
HETATM 1820  O   HOH A3075      66.483 143.949 105.601  1.00 77.50           O
HETATM 1821  O   HOH A3076      91.169 150.538 137.419  1.00 78.96           O
HETATM 1822  O   HOH A3077      61.588 126.866  91.631  1.00 74.16           O
HETATM 1823  O   HOH A3078      65.296 113.001 117.038  1.00 64.17           O
HETATM 1824  O   HOH A3079      57.505 111.886 121.732  1.00 64.48           O
HETATM 1825  O   HOH A3080      61.449 112.316 121.055  1.00 67.94           O
HETATM 1826  O   HOH A3081     104.939 116.959 124.349  1.00 67.13           O
HETATM 1827  O   HOH A3082      72.458 134.296  95.485  1.00 90.00           O
HETATM 1828  O   HOH A3083      89.474 130.990 141.375  1.00 68.70           O
HETATM 1829  O   HOH A3084      77.612 154.124 106.573  1.00 78.87           O
HETATM 1830  O   HOH A3085      75.949 108.787 120.505  1.00 61.36           O
HETATM 1831  O   HOH A3086      64.060 116.134 131.712  1.00 55.98           O
HETATM 1832  O   HOH A3087      75.718 135.601 135.165  1.00 66.91           O
HETATM 1833  O   HOH A3088      75.619 125.080  97.711  1.00 79.35           O
HETATM 1834  O   HOH A3089      45.825 106.359 117.027  1.00 64.91           O
HETATM 1835  O   HOH A3090      78.781 107.011 145.970  1.00 78.63           O
HETATM 1836  O   HOH A3091      68.981 108.352 121.597  1.00 70.87           O
HETATM 1837  O   HOH A3092      54.905 138.529 102.365  1.00 73.29           O
HETATM 1838  O   HOH A3093      91.948 129.866 140.286  1.00 66.78           O
HETATM 1839  O   HOH A3094      86.765 130.701 140.540  1.00 68.66           O
HETATM 1840  O   HOH A3095      55.426 109.932 106.631  1.00 61.82           O
HETATM 1841  O   HOH A3096      66.097 103.411 123.196  1.00 78.89           O
HETATM 1842  O   HOH A3097      57.999 138.040 124.268  1.00 69.56           O
HETATM 1843  O   HOH A3098      82.369 162.617 104.390  1.00 78.37           O
HETATM 1844  O   HOH A3099      77.000 122.249  97.689  1.00 75.67           O
HETATM 1845  O   HOH A3100      93.845 145.796 139.243  1.00 79.71           O
HETATM 1846  O   HOH A3101      54.372 134.419  97.165  1.00 68.23           O
HETATM 1847  O   HOH A3102      88.397 139.913  89.816  1.00 77.91           O
HETATM 1848  O   HOH A3103     127.253 140.597 144.616  1.00 87.94           O
HETATM 1849  O   HOH A3104      58.262 139.974 122.720  1.00 69.76           O
HETATM 1850  O   HOH A3105      80.176 165.843 115.265  1.00 72.15           O
HETATM 1851  O   HOH A3106     130.434 138.345 124.565  1.00 74.48           O
HETATM 1852  O   HOH A3107      95.330 108.369 122.382  1.00 66.03           O
HETATM 1853  O   HOH A3108      74.569 132.965  96.021  1.00 85.24           O
HETATM 1854  O   HOH A3109      64.784 111.799 119.909  1.00 62.07           O
HETATM 1855  O   HOH A3110      52.755 109.026 109.691  1.00 64.90           O
HETATM 1856  O   HOH A3111      69.949 131.836 131.315  1.00 67.06           O
HETATM 1857  O   HOH A3112      53.367 135.712 100.500  1.00 75.71           O
HETATM 1858  O   HOH A3113      36.614 109.135 113.301  1.00 70.64           O
HETATM 1859  O   HOH A3114      59.796 113.568 111.612  1.00 65.56           O
HETATM 1860  O   HOH A3115      84.903 169.129 108.652  1.00 73.71           O
HETATM 1861  O   HOH A3116      70.475 145.052 126.243  1.00 74.91           O
HETATM 1862  O   HOH A3117      79.509 146.569  96.968  1.00 77.82           O
HETATM 1863  O   HOH A3118      70.971 116.756 147.252  1.00 76.41           O
HETATM 1864  O   HOH A3119      57.549 113.491 108.483  1.00 65.97           O
HETATM 1865  O   HOH A3120      93.471 143.724 146.917  1.00 77.50           O
HETATM 1866  O   HOH A3121      76.704 132.516  99.441  1.00 80.42           O
HETATM 1867  O   HOH A3122      58.459 124.652 132.659  1.00 69.00           O
HETATM 1868  O   HOH A3123      69.398 111.390 118.276  1.00 67.62           O
HETATM 1869  O   HOH A3124     115.036 150.779 140.699  1.00 74.89           O
HETATM 1870  O   HOH A3125      68.085 147.849 126.327  1.00 76.67           O
HETATM 1871  O   HOH A3126      85.473 107.412 123.777  1.00 67.16           O
HETATM 1872  O   HOH A3127      96.107 143.304 131.237  1.00 73.09           O
HETATM 1873  O   HOH A3128     127.593 144.187 144.462  1.00 85.03           O
HETATM 1874  O   HOH A3129      73.043 108.411 119.636  1.00 66.75           O
HETATM 1875  O   HOH A3130      89.924 117.762 142.247  1.00 66.44           O
HETATM 1876  O   HOH A3131      78.880 135.814 138.715  1.00 64.93           O
HETATM 1877  O   HOH A3132      66.114 122.921 133.895  1.00 70.03           O
HETATM 1878  O   HOH A3133      92.602 107.086 122.473  1.00 69.49           O
HETATM 1879  O   HOH A3134      68.239 112.537 116.434  1.00 67.88           O
HETATM 1880  O   HOH A3135      93.529 177.498 124.352  1.00 81.49           O
HETATM 1881  O   HOH A3136      38.421 109.200 117.912  1.00 71.15           O
HETATM 1882  O   HOH A3137      59.830 111.368 122.428  1.00 68.32           O
HETATM 1883  O   HOH A3138      91.229 109.167  95.771  1.00 69.28           O
HETATM 1884  O   HOH A3139      89.964 111.903  96.904  1.00 67.35           O
HETATM 1885  O   HOH A3140      76.246 135.019  98.836  1.00 81.84           O
HETATM 1886  O   HOH A3141      73.074 115.377 148.040  1.00 77.01           O
HETATM 1887  O   HOH A3142      95.140 144.606 135.946  1.00 81.68           O
HETATM 1888  O   HOH A3143      94.827 146.629 134.801  1.00 78.99           O
HETATM 1889  O   HOH A3144      56.774 111.658 109.732  1.00 70.29           O
HETATM 1890  O   HOH A3145     100.506 152.471  94.406  1.00 75.78           O
HETATM 1891  O   HOH A3146      76.580 123.958  94.849  1.00 82.45           O
HETATM 1892  O   HOH A3147      77.840 126.488  94.779  1.00 87.82           O
HETATM 1893 MG   MG  A3148      84.145 136.144 106.826  1.00 67.14          Mg
HETATM 1894 MG   MG  A3149     100.413 151.214 107.183  1.00 68.34          Mg
HETATM 1895 NA   NA  A3150      77.416 136.239 110.703  1.00 67.59          Na
HETATM 1896 NA   NA  A3151      85.643 111.620 118.947  1.00 61.13          Na
HETATM 1897  O   HOH A3152      92.659 107.654 107.654  1.00 63.46           O
HETATM 1898  O   HOH A3153      86.075 107.656 107.652  1.00 61.01           O
HETATM 1899  O   HOH A3154     107.714 162.675 107.594  1.00 72.58           O
ATOM   1900  N   ILE B 351     129.309  96.854 121.906  1.00 48.51           N
ATOM   1901  CA  ILE B 351     129.507  95.413 121.988  1.00 48.51           C
ATOM   1902  C   ILE B 351     130.998  95.116 121.930  1.00 48.51           C
ATOM   1903  O   ILE B 351     131.655  95.364 120.921  1.00 48.51           O
ATOM   1904  CB  ILE B 351     128.754  94.686 120.872  1.00 48.51           C
ATOM   1905  CG1 ILE B 351     127.254  94.903 121.019  1.00 48.51           C
ATOM   1906  CG2 ILE B 351     129.098  93.225 120.858  1.00 48.51           C
ATOM   1907  CD1 ILE B 351     126.698  94.390 122.295  1.00 48.51           C
ATOM   1908  N   ARG B 352     131.533  94.604 123.027  1.00 47.54           N
ATOM   1909  CA  ARG B 352     132.898  94.108 123.099  1.00 47.54           C
ATOM   1910  C   ARG B 352     132.809  92.593 123.004  1.00 47.54           C
ATOM   1911  O   ARG B 352     132.895  91.877 123.987  1.00 47.54           O
ATOM   1912  CB  ARG B 352     133.534  94.559 124.395  1.00 47.54           C
ATOM   1913  CG  ARG B 352     133.682  96.031 124.487  1.00 47.54           C
ATOM   1914  CD  ARG B 352     133.985  96.448 125.868  1.00 47.54           C
ATOM   1915  NE  ARG B 352     134.441  97.825 125.953  1.00 47.54           N
ATOM   1916  CZ  ARG B 352     133.652  98.883 126.029  1.00 47.54           C
ATOM   1917  NH1 ARG B 352     132.342  98.748 126.004  1.00 47.54           N
ATOM   1918  NH2 ARG B 352     134.185 100.082 126.116  1.00 47.54           N
ATOM   1919  N   GLY B 353     132.592  92.100 121.793  1.00 44.84           N
ATOM   1920  CA  GLY B 353     132.170  90.737 121.597  1.00 44.84           C
ATOM   1921  C   GLY B 353     133.244  89.824 121.042  1.00 44.84           C
ATOM   1922  O   GLY B 353     134.257  90.250 120.505  1.00 44.84           O
ATOM   1923  N   VAL B 354     132.980  88.533 121.172  1.00 46.30           N
ATOM   1924  CA  VAL B 354     133.830  87.508 120.589  1.00 46.30           C
ATOM   1925  C   VAL B 354     132.945  86.348 120.155  1.00 46.30           C
ATOM   1926  O   VAL B 354     131.944  86.033 120.796  1.00 46.30           O
ATOM   1927  CB  VAL B 354     134.950  87.090 121.571  1.00 46.30           C
ATOM   1928  CG1 VAL B 354     134.409  86.440 122.815  1.00 46.30           C
ATOM   1929  CG2 VAL B 354     135.969  86.208 120.897  1.00 46.30           C
ATOM   1930  N   ASN B 355     133.274  85.772 119.013  1.00 51.63           N
ATOM   1931  CA  ASN B 355     132.677  84.527 118.574  1.00 51.63           C
ATOM   1932  C   ASN B 355     133.299  83.366 119.322  1.00 51.63           C
ATOM   1933  O   ASN B 355     134.504  83.342 119.554  1.00 51.63           O
ATOM   1934  CB  ASN B 355     132.909  84.354 117.088  1.00 51.63           C
ATOM   1935  CG  ASN B 355     132.043  85.241 116.263  1.00 51.63           C
ATOM   1936  OD1 ASN B 355     130.836  85.147 116.308  1.00 51.63           O
ATOM   1937  ND2 ASN B 355     132.653  86.174 115.568  1.00 51.63           N
ATOM   1938  N   ARG B 356     132.482  82.393 119.691  1.00 56.60           N
ATOM   1939  CA  ARG B 356     132.970  81.249 120.444  1.00 56.60           C
ATOM   1940  C   ARG B 356     132.332  79.976 119.923  1.00 56.60           C
ATOM   1941  O   ARG B 356     131.114  79.821 119.989  1.00 56.60           O
ATOM   1942  CB  ARG B 356     132.674  81.407 121.926  1.00 56.60           C
ATOM   1943  CG  ARG B 356     133.109  80.235 122.742  1.00 56.60           C
ATOM   1944  CD  ARG B 356     132.698  80.438 124.149  1.00 56.60           C
ATOM   1945  NE  ARG B 356     133.046  79.329 125.011  1.00 56.60           N
ATOM   1946  CZ  ARG B 356     132.239  78.310 125.252  1.00 56.60           C
ATOM   1947  NH1 ARG B 356     131.045  78.261 124.691  1.00 56.60           N
ATOM   1948  NH2 ARG B 356     132.626  77.349 126.059  1.00 56.60           N
ATOM   1949  N   HIS B 357     133.155  79.071 119.416  1.00 61.60           N
ATOM   1950  CA  HIS B 357     132.732  77.701 119.190  1.00 61.60           C
ATOM   1951  C   HIS B 357     132.844  76.883 120.462  1.00 61.60           C
ATOM   1952  O   HIS B 357     133.681  77.146 121.324  1.00 61.60           O
ATOM   1953  CB  HIS B 357     133.571  77.035 118.107  1.00 61.60           C
ATOM   1954  CG  HIS B 357     133.122  77.335 116.718  1.00 61.60           C
ATOM   1955  ND1 HIS B 357     132.017  76.737 116.156  1.00 61.60           N
ATOM   1956  CD2 HIS B 357     133.651  78.124 115.757  1.00 61.60           C
ATOM   1957  CE1 HIS B 357     131.868  77.167 114.918  1.00 61.60           C
ATOM   1958  NE2 HIS B 357     132.846  78.012 114.652  1.00 61.60           N
ATOM   1959  N   GLU B 358     131.993  75.876 120.566  1.00 65.08           N
ATOM   1960  CA  GLU B 358     132.129  74.859 121.600  1.00 65.08           C
ATOM   1961  C   GLU B 358     133.207  73.881 121.171  1.00 65.08           C
ATOM   1962  O   GLU B 358     132.985  73.034 120.310  1.00 65.08           O
ATOM   1963  CB  GLU B 358     130.807  74.149 121.834  1.00 65.08           C
ATOM   1964  CG  GLU B 358     129.829  74.950 122.629  1.00 65.08           C
ATOM   1965  CD  GLU B 358     128.541  74.207 122.871  1.00 65.08           C
ATOM   1966  OE1 GLU B 358     128.299  73.185 122.202  1.00 65.08           O
ATOM   1967  OE2 GLU B 358     127.788  74.615 123.769  1.00 65.08           O
ATOM   1968  N   HIS B 359     134.384  73.995 121.769  1.00 64.23           N
ATOM   1969  CA  HIS B 359     135.502  73.162 121.369  1.00 64.23           C
ATOM   1970  C   HIS B 359     136.349  72.825 122.578  1.00 64.23           C
ATOM   1971  O   HIS B 359     136.650  73.698 123.391  1.00 64.23           O
ATOM   1972  CB  HIS B 359     136.363  73.855 120.321  1.00 64.23           C
ATOM   1973  CG  HIS B 359     137.541  73.049 119.891  1.00 64.23           C
ATOM   1974  ND1 HIS B 359     137.447  72.021 118.982  1.00 64.23           N
ATOM   1975  CD2 HIS B 359     138.834  73.089 120.281  1.00 64.23           C
ATOM   1976  CE1 HIS B 359     138.638  71.483 118.808  1.00 64.23           C
ATOM   1977  NE2 HIS B 359     139.496  72.109 119.589  1.00 64.23           N
ATOM   1978  N   HIS B 360     136.728  71.562 122.685  1.00 67.87           N
ATOM   1979  CA  HIS B 360     137.695  71.115 123.659  1.00 67.87           C
ATOM   1980  C   HIS B 360     138.710  70.277 122.893  1.00 67.87           C
ATOM   1981  O   HIS B 360     138.316  69.457 122.056  1.00 67.87           O
ATOM   1982  CB  HIS B 360     137.033  70.300 124.765  1.00 67.87           C
ATOM   1983  CG  HIS B 360     137.924  70.044 125.933  1.00 67.87           C
ATOM   1984  ND1 HIS B 360     138.838  69.016 125.959  1.00 67.87           N
ATOM   1985  CD2 HIS B 360     138.044  70.684 127.118  1.00 67.87           C
ATOM   1986  CE1 HIS B 360     139.488  69.037 127.107  1.00 67.87           C
ATOM   1987  NE2 HIS B 360     139.022  70.038 127.830  1.00 67.87           N
ATOM   1988  N   PRO B 361     140.011  70.461 123.125  1.00 67.53           N
ATOM   1989  CA  PRO B 361     141.007  69.766 122.297  1.00 67.53           C
ATOM   1990  C   PRO B 361     141.077  68.273 122.537  1.00 67.53           C
ATOM   1991  O   PRO B 361     141.515  67.544 121.644  1.00 67.53           O
ATOM   1992  CB  PRO B 361     142.318  70.443 122.692  1.00 67.53           C
ATOM   1993  CG  PRO B 361     142.079  70.915 124.059  1.00 67.53           C
ATOM   1994  CD  PRO B 361     140.649  71.316 124.135  1.00 67.53           C
ATOM   1995  N   LEU B 362     140.656  67.794 123.700  1.00 71.50           N
ATOM   1996  CA  LEU B 362     140.645  66.371 123.995  1.00 71.50           C
ATOM   1997  C   LEU B 362     139.303  65.720 123.730  1.00 71.50           C
ATOM   1998  O   LEU B 362     139.257  64.585 123.255  1.00 71.50           O
ATOM   1999  CB  LEU B 362     141.032  66.134 125.453  1.00 71.50           C
ATOM   2000  CG  LEU B 362     142.478  66.476 125.778  1.00 71.50           C
ATOM   2001  CD1 LEU B 362     142.720  66.381 127.267  1.00 71.50           C
ATOM   2002  CD2 LEU B 362     143.394  65.541 125.025  1.00 71.50           C
ATOM   2003  N   HIS B 363     138.209  66.414 124.016  1.00 70.40           N
ATOM   2004  CA  HIS B 363     136.886  65.821 123.951  1.00 70.40           C
ATOM   2005  C   HIS B 363     136.087  66.302 122.756  1.00 70.40           C
ATOM   2006  O   HIS B 363     134.908  65.969 122.644  1.00 70.40           O
ATOM   2007  CB  HIS B 363     136.129  66.110 125.239  1.00 70.40           C
ATOM   2008  CG  HIS B 363     136.842  65.636 126.459  1.00 70.40           C
ATOM   2009  ND1 HIS B 363     137.023  64.301 126.740  1.00 70.40           N
ATOM   2010  CD2 HIS B 363     137.417  66.317 127.475  1.00 70.40           C
ATOM   2011  CE1 HIS B 363     137.687  64.181 127.873  1.00 70.40           C
ATOM   2012  NE2 HIS B 363     137.935  65.389 128.342  1.00 70.40           N
ATOM   2013  N   GLY B 364     136.696  67.066 121.862  1.00 67.37           N
ATOM   2014  CA  GLY B 364     136.000  67.543 120.690  1.00 67.37           C
ATOM   2015  C   GLY B 364     134.962  68.590 121.012  1.00 67.37           C
ATOM   2016  O   GLY B 364     135.280  69.648 121.551  1.00 67.37           O
ATOM   2017  N   GLN B 365     133.705  68.292 120.711  1.00 65.98           N
ATOM   2018  CA  GLN B 365     132.626  69.250 120.867  1.00 65.98           C
ATOM   2019  C   GLN B 365     131.784  68.979 122.101  1.00 65.98           C
ATOM   2020  O   GLN B 365     130.630  69.403 122.165  1.00 65.98           O
ATOM   2021  CB  GLN B 365     131.785  69.259 119.598  1.00 65.98           C
ATOM   2022  CG  GLN B 365     132.611  69.746 118.437  1.00 65.98           C
ATOM   2023  CD  GLN B 365     131.921  69.641 117.116  1.00 65.98           C
ATOM   2024  OE1 GLN B 365     130.823  69.108 117.016  1.00 65.98           O
ATOM   2025  NE2 GLN B 365     132.565  70.151 116.081  1.00 65.98           N
ATOM   2026  N   VAL B 366     132.351  68.309 123.092  1.00 66.98           N
ATOM   2027  CA  VAL B 366     131.680  68.027 124.350  1.00 66.98           C
ATOM   2028  C   VAL B 366     132.146  69.049 125.370  1.00 66.98           C
ATOM   2029  O   VAL B 366     133.340  69.141 125.664  1.00 66.98           O
ATOM   2030  CB  VAL B 366     131.973  66.601 124.826  1.00 66.98           C
ATOM   2031  CG1 VAL B 366     131.360  66.359 126.176  1.00 66.98           C
ATOM   2032  CG2 VAL B 366     131.442  65.638 123.828  1.00 66.98           C
ATOM   2033  N   MET B 367     131.210  69.811 125.915  1.00 72.90           N
ATOM   2034  CA  MET B 367     131.522  70.886 126.840  1.00 72.90           C
ATOM   2035  C   MET B 367     131.044  70.544 128.237  1.00 72.90           C
ATOM   2036  O   MET B 367     129.906  70.110 128.419  1.00 72.90           O
ATOM   2037  CB  MET B 367     130.884  72.197 126.394  1.00 72.90           C
ATOM   2038  CG  MET B 367     131.475  72.759 125.143  1.00 72.90           C
ATOM   2039  SD  MET B 367     133.249  72.976 125.298  1.00 72.90           S
ATOM   2040  CE  MET B 367     133.288  74.144 126.634  1.00 72.90           C
ATOM   2041  N   ASP B 368     131.911  70.750 129.215  1.00 74.72           N
ATOM   2042  CA  ASP B 368     131.555  70.649 130.617  1.00 74.72           C
ATOM   2043  C   ASP B 368     131.544  72.033 131.248  1.00 74.72           C
ATOM   2044  O   ASP B 368     131.916  73.024 130.623  1.00 74.72           O
ATOM   2045  CB  ASP B 368     132.515  69.720 131.358  1.00 74.72           C
ATOM   2046  CG  ASP B 368     133.960  70.104 131.173  1.00 74.72           C
ATOM   2047  OD1 ASP B 368     134.259  70.964 130.325  1.00 74.72           O
ATOM   2048  OD2 ASP B 368     134.809  69.552 131.897  1.00 74.72           O
ATOM   2049  N   GLU B 369     131.119  72.082 132.511  1.00 72.94           N
ATOM   2050  CA  GLU B 369     130.946  73.360 133.189  1.00 72.94           C
ATOM   2051  C   GLU B 369     132.273  74.047 133.464  1.00 72.94           C
ATOM   2052  O   GLU B 369     132.358  75.273 133.362  1.00 72.94           O
ATOM   2053  CB  GLU B 369     130.176  73.162 134.489  1.00 72.94           C
ATOM   2054  CG  GLU B 369     129.866  74.446 135.220  1.00 72.94           C
ATOM   2055  CD  GLU B 369     128.930  74.248 136.382  1.00 72.94           C
ATOM   2056  OE1 GLU B 369     128.507  73.098 136.613  1.00 72.94           O
ATOM   2057  OE2 GLU B 369     128.610  75.245 137.062  1.00 72.94           O
ATOM   2058  N   GLN B 370     133.317  73.280 133.767  1.00 73.01           N
ATOM   2059  CA  GLN B 370     134.589  73.870 134.164  1.00 73.01           C
ATOM   2060  C   GLN B 370     135.266  74.590 133.011  1.00 73.01           C
ATOM   2061  O   GLN B 370     135.914  75.616 133.223  1.00 73.01           O
ATOM   2062  CB  GLN B 370     135.521  72.800 134.725  1.00 73.01           C
ATOM   2063  CG  GLN B 370     135.228  72.377 136.158  1.00 73.01           C
ATOM   2064  CD  GLN B 370     133.944  71.583 136.302  1.00 73.01           C
ATOM   2065  OE1 GLN B 370     133.050  71.959 137.059  1.00 73.01           O
ATOM   2066  NE2 GLN B 370     133.833  70.496 135.546  1.00 73.01           N
ATOM   2067  N   THR B 371     135.111  74.089 131.792  1.00 69.35           N
ATOM   2068  CA  THR B 371     135.662  74.789 130.646  1.00 69.35           C
ATOM   2069  C   THR B 371     134.831  76.019 130.304  1.00 69.35           C
ATOM   2070  O   THR B 371     135.381  77.031 129.865  1.00 69.35           O
ATOM   2071  CB  THR B 371     135.755  73.835 129.460  1.00 69.35           C
ATOM   2072  OG1 THR B 371     136.434  72.649 129.875  1.00 69.35           O
ATOM   2073  CG2 THR B 371     136.561  74.444 128.338  1.00 69.35           C
ATOM   2074  N   MET B 372     133.516  75.960 130.527  1.00 66.00           N
ATOM   2075  CA  MET B 372     132.669  77.124 130.292  1.00 66.00           C
ATOM   2076  C   MET B 372     132.974  78.242 131.270  1.00 66.00           C
ATOM   2077  O   MET B 372     133.001  79.412 130.883  1.00 66.00           O
ATOM   2078  CB  MET B 372     131.201  76.760 130.411  1.00 66.00           C
ATOM   2079  CG  MET B 372     130.687  75.842 129.379  1.00 66.00           C
ATOM   2080  SD  MET B 372     128.956  75.568 129.711  1.00 66.00           S
ATOM   2081  CE  MET B 372     128.684  74.222 128.608  1.00 66.00           C
ATOM   2082  N   VAL B 373     133.169  77.905 132.543  1.00 63.75           N
ATOM   2083  CA  VAL B 373     133.500  78.916 133.535  1.00 63.75           C
ATOM   2084  C   VAL B 373     134.879  79.488 133.258  1.00 63.75           C
ATOM   2085  O   VAL B 373     135.094  80.695 133.380  1.00 63.75           O
ATOM   2086  CB  VAL B 373     133.383  78.326 134.951  1.00 63.75           C
ATOM   2087  CG1 VAL B 373     133.860  79.300 135.996  1.00 63.75           C
ATOM   2088  CG2 VAL B 373     131.957  77.968 135.233  1.00 63.75           C
ATOM   2089  N   GLN B 374     135.806  78.645 132.803  1.00 64.23           N
ATOM   2090  CA  GLN B 374     137.139  79.109 132.439  1.00 64.23           C
ATOM   2091  C   GLN B 374     137.095  80.079 131.266  1.00 64.23           C
ATOM   2092  O   GLN B 374     137.845  81.059 131.241  1.00 64.23           O
ATOM   2093  CB  GLN B 374     138.025  77.916 132.099  1.00 64.23           C
ATOM   2094  CG  GLN B 374     139.467  78.264 131.864  1.00 64.23           C
ATOM   2095  CD  GLN B 374     140.297  77.069 131.474  1.00 64.23           C
ATOM   2096  OE1 GLN B 374     139.775  75.982 131.254  1.00 64.23           O
ATOM   2097  NE2 GLN B 374     141.602  77.260 131.402  1.00 64.23           N
ATOM   2098  N   ASP B 375     136.207  79.839 130.301  1.00 60.83           N
ATOM   2099  CA  ASP B 375     136.079  80.757 129.178  1.00 60.83           C
ATOM   2100  C   ASP B 375     135.484  82.088 129.606  1.00 60.83           C
ATOM   2101  O   ASP B 375     135.972  83.139 129.191  1.00 60.83           O
ATOM   2102  CB  ASP B 375     135.235  80.147 128.065  1.00 60.83           C
ATOM   2103  CG  ASP B 375     135.991  79.130 127.252  1.00 60.83           C
ATOM   2104  OD1 ASP B 375     137.228  79.195 127.226  1.00 60.83           O
ATOM   2105  OD2 ASP B 375     135.350  78.289 126.600  1.00 60.83           O
ATOM   2106  N   ILE B 376     134.451  82.065 130.448  1.00 57.84           N
ATOM   2107  CA  ILE B 376     133.755  83.290 130.826  1.00 57.84           C
ATOM   2108  C   ILE B 376     134.635  84.177 131.688  1.00 57.84           C
ATOM   2109  O   ILE B 376     134.629  85.402 131.533  1.00 57.84           O
ATOM   2110  CB  ILE B 376     132.427  82.948 131.518  1.00 57.84           C
ATOM   2111  CG1 ILE B 376     131.484  82.364 130.498  1.00 57.84           C
ATOM   2112  CG2 ILE B 376     131.764  84.154 132.123  1.00 57.84           C
ATOM   2113  CD1 ILE B 376     130.268  81.834 131.071  1.00 57.84           C
ATOM   2114  N   LEU B 377     135.439  83.580 132.570  1.00 57.63           N
ATOM   2115  CA  LEU B 377     136.345  84.389 133.372  1.00 57.63           C
ATOM   2116  C   LEU B 377     137.412  85.037 132.506  1.00 57.63           C
ATOM   2117  O   LEU B 377     137.665  86.229 132.644  1.00 57.63           O
ATOM   2118  CB  LEU B 377     136.999  83.570 134.477  1.00 57.63           C
ATOM   2119  CG  LEU B 377     136.114  82.882 135.510  1.00 57.63           C
ATOM   2120  CD1 LEU B 377     136.937  82.318 136.649  1.00 57.63           C
ATOM   2121  CD2 LEU B 377     134.984  83.723 135.986  1.00 57.63           C
ATOM   2122  N   LEU B 378     137.994  84.288 131.569  1.00 56.00           N
ATOM   2123  CA  LEU B 378     138.991  84.862 130.671  1.00 56.00           C
ATOM   2124  C   LEU B 378     138.415  85.931 129.760  1.00 56.00           C
ATOM   2125  O   LEU B 378     139.119  86.878 129.410  1.00 56.00           O
ATOM   2126  CB  LEU B 378     139.630  83.778 129.820  1.00 56.00           C
ATOM   2127  CG  LEU B 378     140.634  82.867 130.486  1.00 56.00           C
ATOM   2128  CD1 LEU B 378     140.998  81.773 129.525  1.00 56.00           C
ATOM   2129  CD2 LEU B 378     141.842  83.683 130.839  1.00 56.00           C
ATOM   2130  N   MET B 379     137.152  85.799 129.365  1.00 54.55           N
ATOM   2131  CA  MET B 379     136.521  86.824 128.547  1.00 54.55           C
ATOM   2132  C   MET B 379     136.324  88.112 129.323  1.00 54.55           C
ATOM   2133  O   MET B 379     136.637  89.195 128.826  1.00 54.55           O
ATOM   2134  CB  MET B 379     135.192  86.322 128.015  1.00 54.55           C
ATOM   2135  CG  MET B 379     135.341  85.338 126.918  1.00 54.55           C
ATOM   2136  SD  MET B 379     133.785  84.592 126.504  1.00 54.55           S
ATOM   2137  CE  MET B 379     134.340  83.483 125.250  1.00 54.55           C
ATOM   2138  N   LYS B 380     135.810  88.018 130.543  1.00 54.17           N
ATOM   2139  CA  LYS B 380     135.538  89.229 131.297  1.00 54.17           C
ATOM   2140  C   LYS B 380     136.810  89.865 131.826  1.00 54.17           C
ATOM   2141  O   LYS B 380     136.873  91.087 131.954  1.00 54.17           O
ATOM   2142  CB  LYS B 380     134.565  88.936 132.426  1.00 54.17           C
ATOM   2143  CG  LYS B 380     133.191  88.618 131.923  1.00 54.17           C
ATOM   2144  CD  LYS B 380     132.229  88.453 133.047  1.00 54.17           C
ATOM   2145  CE  LYS B 380     131.924  89.785 133.675  1.00 54.17           C
ATOM   2146  NZ  LYS B 380     131.176  90.671 132.771  1.00 54.17           N
ATOM   2147  N   GLN B 381     137.843  89.072 132.093  1.00 55.58           N
ATOM   2148  CA  GLN B 381     139.130  89.627 132.485  1.00 55.58           C
ATOM   2149  C   GLN B 381     139.851  90.306 131.336  1.00 55.58           C
ATOM   2150  O   GLN B 381     140.822  91.019 131.574  1.00 55.58           O
ATOM   2151  CB  GLN B 381     140.009  88.533 133.072  1.00 55.58           C
ATOM   2152  CG  GLN B 381     139.541  88.059 134.419  1.00 55.58           C
ATOM   2153  CD  GLN B 381     140.188  86.771 134.827  1.00 55.58           C
ATOM   2154  OE1 GLN B 381     141.061  86.263 134.140  1.00 55.58           O
ATOM   2155  NE2 GLN B 381     139.709  86.191 135.910  1.00 55.58           N
ATOM   2156  N   ASN B 382     139.398  90.112 130.109  1.00 50.40           N
ATOM   2157  CA  ASN B 382     139.972  90.746 128.938  1.00 50.40           C
ATOM   2158  C   ASN B 382     138.991  91.706 128.289  1.00 50.40           C
ATOM   2159  O   ASN B 382     139.059  91.950 127.088  1.00 50.40           O
ATOM   2160  CB  ASN B 382     140.435  89.668 127.973  1.00 50.40           C
ATOM   2161  CG  ASN B 382     141.643  88.960 128.481  1.00 50.40           C
ATOM   2162  OD1 ASN B 382     142.663  89.574 128.726  1.00 50.40           O
ATOM   2163  ND2 ASN B 382     141.499  87.689 128.773  1.00 50.40           N
ATOM   2164  N   ASN B 383     138.054  92.211 129.092  1.00 48.74           N
ATOM   2165  CA  ASN B 383     137.137  93.298 128.754  1.00 48.74           C
ATOM   2166  C   ASN B 383     136.185  92.940 127.622  1.00 48.74           C
ATOM   2167  O   ASN B 383     135.775  93.803 126.858  1.00 48.74           O
ATOM   2168  CB  ASN B 383     137.890  94.590 128.430  1.00 48.74           C
ATOM   2169  CG  ASN B 383     138.621  95.136 129.612  1.00 48.74           C
ATOM   2170  OD1 ASN B 383     138.129  95.090 130.724  1.00 48.74           O
ATOM   2171  ND2 ASN B 383     139.800  95.663 129.382  1.00 48.74           N
ATOM   2172  N   PHE B 384     135.816  91.677 127.501  1.00 46.24           N
ATOM   2173  CA  PHE B 384     134.721  91.292 126.628  1.00 46.24           C
ATOM   2174  C   PHE B 384     133.419  91.332 127.412  1.00 46.24           C
ATOM   2175  O   PHE B 384     133.381  90.956 128.579  1.00 46.24           O
ATOM   2176  CB  PHE B 384     134.942  89.895 126.054  1.00 46.24           C
ATOM   2177  CG  PHE B 384     136.026  89.820 125.031  1.00 46.24           C
ATOM   2178  CD1 PHE B 384     135.765  90.108 123.710  1.00 46.24           C
ATOM   2179  CD2 PHE B 384     137.304  89.465 125.388  1.00 46.24           C
ATOM   2180  CE1 PHE B 384     136.757  90.038 122.773  1.00 46.24           C
ATOM   2181  CE2 PHE B 384     138.297  89.398 124.451  1.00 46.24           C
ATOM   2182  CZ  PHE B 384     138.021  89.684 123.145  1.00 46.24           C
ATOM   2183  N   ASN B 385     132.355  91.806 126.777  1.00 47.51           N
ATOM   2184  CA  ASN B 385     131.048  91.767 127.409  1.00 47.51           C
ATOM   2185  C   ASN B 385     130.004  91.008 126.607  1.00 47.51           C
ATOM   2186  O   ASN B 385     128.844  90.978 127.014  1.00 47.51           O
ATOM   2187  CB  ASN B 385     130.543  93.185 127.736  1.00 47.51           C
ATOM   2188  CG  ASN B 385     130.352  94.080 126.516  1.00 47.51           C
ATOM   2189  OD1 ASN B 385     130.492  93.677 125.377  1.00 47.51           O
ATOM   2190  ND2 ASN B 385     130.017  95.322 126.776  1.00 47.51           N
ATOM   2191  N   ALA B 386     130.368  90.406 125.485  1.00 45.28           N
ATOM   2192  CA  ALA B 386     129.376  89.771 124.641  1.00 45.28           C
ATOM   2193  C   ALA B 386     129.974  88.556 123.960  1.00 45.28           C
ATOM   2194  O   ALA B 386     131.170  88.504 123.695  1.00 45.28           O
ATOM   2195  CB  ALA B 386     128.820  90.737 123.604  1.00 45.28           C
ATOM   2196  N   VAL B 387     129.135  87.556 123.720  1.00 47.41           N
ATOM   2197  CA  VAL B 387     129.536  86.316 123.069  1.00 47.41           C
ATOM   2198  C   VAL B 387     128.512  86.007 121.993  1.00 47.41           C
ATOM   2199  O   VAL B 387     127.309  86.090 122.240  1.00 47.41           O
ATOM   2200  CB  VAL B 387     129.632  85.134 124.054  1.00 47.41           C
ATOM   2201  CG1 VAL B 387     130.118  83.898 123.358  1.00 47.41           C
ATOM   2202  CG2 VAL B 387     130.549  85.425 125.165  1.00 47.41           C
ATOM   2203  N   ARG B 388     128.978  85.657 120.809  1.00 52.67           N
ATOM   2204  CA  ARG B 388     128.109  85.159 119.760  1.00 52.67           C
ATOM   2205  C   ARG B 388     128.256  83.650 119.674  1.00 52.67           C
ATOM   2206  O   ARG B 388     129.369  83.133 119.573  1.00 52.67           O
ATOM   2207  CB  ARG B 388     128.431  85.836 118.434  1.00 52.67           C
ATOM   2208  CG  ARG B 388     127.598  85.391 117.275  1.00 52.67           C
ATOM   2209  CD  ARG B 388     127.765  86.348 116.130  1.00 52.67           C
ATOM   2210  NE  ARG B 388     127.091  85.888 114.930  1.00 52.67           N
ATOM   2211  CZ  ARG B 388     127.701  85.267 113.931  1.00 52.67           C
ATOM   2212  NH1 ARG B 388     129.004  85.065 113.978  1.00 52.67           N
ATOM   2213  NH2 ARG B 388     127.017  84.875 112.871  1.00 52.67           N
ATOM   2214  N   CYS B 389     127.134  82.949 119.755  1.00 59.66           N
ATOM   2215  CA  CYS B 389     127.096  81.489 119.742  1.00 59.66           C
ATOM   2216  C   CYS B 389     127.271  81.026 118.309  1.00 59.66           C
ATOM   2217  O   CYS B 389     126.304  80.768 117.603  1.00 59.66           O
ATOM   2218  CB  CYS B 389     125.777  80.984 120.305  1.00 59.66           C
ATOM   2219  SG  CYS B 389     125.422  81.499 121.965  1.00 59.66           S
ATOM   2220  N   SER B 390     128.511  80.900 117.872  1.00 58.60           N
ATOM   2221  CA  SER B 390     128.807  80.650 116.470  1.00 58.60           C
ATOM   2222  C   SER B 390     128.985  79.155 116.221  1.00 58.60           C
ATOM   2223  O   SER B 390     129.826  78.524 116.863  1.00 58.60           O
ATOM   2224  CB  SER B 390     130.064  81.409 116.069  1.00 58.60           C
ATOM   2225  OG  SER B 390     131.190  80.903 116.746  1.00 58.60           O
ATOM   2226  N   HIS B 391     128.181  78.576 115.322  1.00 59.22           N
ATOM   2227  CA  HIS B 391     126.970  79.181 114.782  1.00 59.22           C
ATOM   2228  C   HIS B 391     125.841  78.198 114.970  1.00 59.22           C
ATOM   2229  O   HIS B 391     125.377  77.606 114.005  1.00 59.22           O
ATOM   2230  CB  HIS B 391     127.114  79.468 113.294  1.00 59.22           C
ATOM   2231  CG  HIS B 391     128.303  80.293 112.942  1.00 59.22           C
ATOM   2232  ND1 HIS B 391     128.342  81.656 113.114  1.00 59.22           N
ATOM   2233  CD2 HIS B 391     129.506  79.941 112.436  1.00 59.22           C
ATOM   2234  CE1 HIS B 391     129.515  82.110 112.722  1.00 59.22           C
ATOM   2235  NE2 HIS B 391     130.241  81.090 112.308  1.00 59.22           N
ATOM   2236  N   TYR B 392     125.349  78.103 116.186  1.00 58.66           N
ATOM   2237  CA  TYR B 392     124.416  77.082 116.641  1.00 58.66           C
ATOM   2238  C   TYR B 392     124.042  77.379 118.083  1.00 58.66           C
ATOM   2239  O   TYR B 392     124.788  78.087 118.761  1.00 58.66           O
ATOM   2240  CB  TYR B 392     124.998  75.666 116.494  1.00 58.66           C
ATOM   2241  CG  TYR B 392     126.418  75.470 116.945  1.00 58.66           C
ATOM   2242  CD1 TYR B 392     126.746  75.384 118.283  1.00 58.66           C
ATOM   2243  CD2 TYR B 392     127.437  75.388 116.016  1.00 58.66           C
ATOM   2244  CE1 TYR B 392     128.042  75.222 118.679  1.00 58.66           C
ATOM   2245  CE2 TYR B 392     128.729  75.216 116.401  1.00 58.66           C
ATOM   2246  CZ  TYR B 392     129.029  75.135 117.730  1.00 58.66           C
ATOM   2247  OH  TYR B 392     130.333  74.967 118.111  1.00 58.66           O
ATOM   2248  N   PRO B 393     122.906  76.890 118.580  1.00 57.99           N
ATOM   2249  CA  PRO B 393     122.600  77.071 119.999  1.00 57.99           C
ATOM   2250  C   PRO B 393     123.567  76.291 120.863  1.00 57.99           C
ATOM   2251  O   PRO B 393     123.940  75.165 120.540  1.00 57.99           O
ATOM   2252  CB  PRO B 393     121.180  76.520 120.123  1.00 57.99           C
ATOM   2253  CG  PRO B 393     120.641  76.581 118.778  1.00 57.99           C
ATOM   2254  CD  PRO B 393     121.763  76.300 117.870  1.00 57.99           C
ATOM   2255  N   ASN B 394     123.996  76.903 121.955  1.00 61.43           N
ATOM   2256  CA  ASN B 394     124.950  76.211 122.793  1.00 61.43           C
ATOM   2257  C   ASN B 394     124.266  75.248 123.746  1.00 61.43           C
ATOM   2258  O   ASN B 394     123.048  75.071 123.749  1.00 61.43           O
ATOM   2259  CB  ASN B 394     125.814  77.172 123.598  1.00 61.43           C
ATOM   2260  CG  ASN B 394     126.853  77.844 122.767  1.00 61.43           C
ATOM   2261  OD1 ASN B 394     127.108  79.019 122.916  1.00 61.43           O
ATOM   2262  ND2 ASN B 394     127.404  77.117 121.820  1.00 61.43           N
ATOM   2263  N   HIS B 395     125.110  74.594 124.521  1.00 65.16           N
ATOM   2264  CA  HIS B 395     124.714  73.825 125.683  1.00 65.16           C
ATOM   2265  C   HIS B 395     123.900  74.705 126.626  1.00 65.16           C
ATOM   2266  O   HIS B 395     124.210  75.889 126.776  1.00 65.16           O
ATOM   2267  CB  HIS B 395     125.986  73.327 126.365  1.00 65.16           C
ATOM   2268  CG  HIS B 395     125.762  72.366 127.480  1.00 65.16           C
ATOM   2269  ND1 HIS B 395     125.407  72.769 128.746  1.00 65.16           N
ATOM   2270  CD2 HIS B 395     125.911  71.025 127.539  1.00 65.16           C
ATOM   2271  CE1 HIS B 395     125.303  71.712 129.528  1.00 65.16           C
ATOM   2272  NE2 HIS B 395     125.606  70.640 128.821  1.00 65.16           N
ATOM   2273  N   PRO B 396     122.848  74.175 127.255  1.00 63.79           N
ATOM   2274  CA  PRO B 396     121.936  75.035 128.026  1.00 63.79           C
ATOM   2275  C   PRO B 396     122.553  75.670 129.251  1.00 63.79           C
ATOM   2276  O   PRO B 396     122.061  76.710 129.694  1.00 63.79           O
ATOM   2277  CB  PRO B 396     120.812  74.074 128.423  1.00 63.79           C
ATOM   2278  CG  PRO B 396     120.875  73.003 127.436  1.00 63.79           C
ATOM   2279  CD  PRO B 396     122.311  72.816 127.112  1.00 63.79           C
ATOM   2280  N   LEU B 397     123.620  75.099 129.799  1.00 62.71           N
ATOM   2281  CA  LEU B 397     124.280  75.689 130.952  1.00 62.71           C
ATOM   2282  C   LEU B 397     125.025  76.966 130.598  1.00 62.71           C
ATOM   2283  O   LEU B 397     125.244  77.804 131.476  1.00 62.71           O
ATOM   2284  CB  LEU B 397     125.225  74.663 131.561  1.00 62.71           C
ATOM   2285  CG  LEU B 397     125.957  74.983 132.851  1.00 62.71           C
ATOM   2286  CD1 LEU B 397     124.959  75.271 133.937  1.00 62.71           C
ATOM   2287  CD2 LEU B 397     126.799  73.809 133.208  1.00 62.71           C
ATOM   2288  N   TRP B 398     125.390  77.137 129.328  1.00 57.16           N
ATOM   2289  CA  TRP B 398     126.111  78.323 128.889  1.00 57.16           C
ATOM   2290  C   TRP B 398     125.297  79.589 129.088  1.00 57.16           C
ATOM   2291  O   TRP B 398     125.834  80.617 129.503  1.00 57.16           O
ATOM   2292  CB  TRP B 398     126.496  78.167 127.428  1.00 57.16           C
ATOM   2293  CG  TRP B 398     127.142  79.345 126.862  1.00 57.16           C
ATOM   2294  CD1 TRP B 398     126.601  80.225 125.992  1.00 57.16           C
ATOM   2295  CD2 TRP B 398     128.459  79.801 127.131  1.00 57.16           C
ATOM   2296  NE1 TRP B 398     127.503  81.199 125.686  1.00 57.16           N
ATOM   2297  CE2 TRP B 398     128.656  80.961 126.379  1.00 57.16           C
ATOM   2298  CE3 TRP B 398     129.496  79.334 127.933  1.00 57.16           C
ATOM   2299  CZ2 TRP B 398     129.843  81.664 126.404  1.00 57.16           C
ATOM   2300  CZ3 TRP B 398     130.668  80.025 127.951  1.00 57.16           C
ATOM   2301  CH2 TRP B 398     130.837  81.180 127.196  1.00 57.16           C
ATOM   2302  N   TYR B 399     123.997  79.525 128.820  1.00 57.98           N
ATOM   2303  CA  TYR B 399     123.151  80.697 128.968  1.00 57.98           C
ATOM   2304  C   TYR B 399     122.936  81.038 130.427  1.00 57.98           C
ATOM   2305  O   TYR B 399     122.832  82.213 130.771  1.00 57.98           O
ATOM   2306  CB  TYR B 399     121.815  80.462 128.280  1.00 57.98           C
ATOM   2307  CG  TYR B 399     121.976  80.127 126.836  1.00 57.98           C
ATOM   2308  CD1 TYR B 399     122.209  81.111 125.902  1.00 57.98           C
ATOM   2309  CD2 TYR B 399     121.922  78.815 126.407  1.00 57.98           C
ATOM   2310  CE1 TYR B 399     122.372  80.802 124.583  1.00 57.98           C
ATOM   2311  CE2 TYR B 399     122.087  78.500 125.095  1.00 57.98           C
ATOM   2312  CZ  TYR B 399     122.308  79.494 124.187  1.00 57.98           C
ATOM   2313  OH  TYR B 399     122.468  79.178 122.870  1.00 57.98           O
ATOM   2314  N   THR B 400     122.881  80.023 131.287  1.00 60.01           N
ATOM   2315  CA  THR B 400     122.762  80.243 132.721  1.00 60.01           C
ATOM   2316  C   THR B 400     123.992  80.945 133.271  1.00 60.01           C
ATOM   2317  O   THR B 400     123.881  81.876 134.071  1.00 60.01           O
ATOM   2318  CB  THR B 400     122.550  78.905 133.421  1.00 60.01           C
ATOM   2319  OG1 THR B 400     121.347  78.306 132.938  1.00 60.01           O
ATOM   2320  CG2 THR B 400     122.449  79.079 134.910  1.00 60.01           C
ATOM   2321  N   LEU B 401     125.171  80.532 132.826  1.00 58.69           N
ATOM   2322  CA  LEU B 401     126.396  81.157 133.295  1.00 58.69           C
ATOM   2323  C   LEU B 401     126.563  82.563 132.740  1.00 58.69           C
ATOM   2324  O   LEU B 401     127.137  83.422 133.408  1.00 58.69           O
ATOM   2325  CB  LEU B 401     127.583  80.291 132.920  1.00 58.69           C
ATOM   2326  CG  LEU B 401     127.683  78.913 133.550  1.00 58.69           C
ATOM   2327  CD1 LEU B 401     128.828  78.175 132.932  1.00 58.69           C
ATOM   2328  CD2 LEU B 401     127.873  79.041 135.026  1.00 58.69           C
ATOM   2329  N   CYS B 402     126.063  82.824 131.536  1.00 56.47           N
ATOM   2330  CA  CYS B 402     126.103  84.183 131.017  1.00 56.47           C
ATOM   2331  C   CYS B 402     125.085  85.079 131.707  1.00 56.47           C
ATOM   2332  O   CYS B 402     125.301  86.287 131.793  1.00 56.47           O
ATOM   2333  CB  CYS B 402     125.883  84.181 129.508  1.00 56.47           C
ATOM   2334  SG  CYS B 402     127.211  83.438 128.551  1.00 56.47           S
ATOM   2335  N   ASP B 403     123.973  84.514 132.188  1.00 58.77           N
ATOM   2336  CA  ASP B 403     123.069  85.253 133.067  1.00 58.77           C
ATOM   2337  C   ASP B 403     123.772  85.653 134.350  1.00 58.77           C
ATOM   2338  O   ASP B 403     123.607  86.770 134.842  1.00 58.77           O
ATOM   2339  CB  ASP B 403     121.850  84.409 133.439  1.00 58.77           C
ATOM   2340  CG  ASP B 403     120.957  84.098 132.274  1.00 58.77           C
ATOM   2341  OD1 ASP B 403     120.951  84.868 131.314  1.00 58.77           O
ATOM   2342  OD2 ASP B 403     120.247  83.074 132.316  1.00 58.77           O
ATOM   2343  N   ARG B 404     124.565  84.744 134.896  1.00 62.32           N
ATOM   2344  CA  ARG B 404     125.099  84.872 136.239  1.00 62.32           C
ATOM   2345  C   ARG B 404     126.290  85.815 136.284  1.00 62.32           C
ATOM   2346  O   ARG B 404     126.360  86.692 137.144  1.00 62.32           O
ATOM   2347  CB  ARG B 404     125.485  83.488 136.736  1.00 62.32           C
ATOM   2348  CG  ARG B 404     125.951  83.393 138.146  1.00 62.32           C
ATOM   2349  CD  ARG B 404     126.212  81.936 138.432  1.00 62.32           C
ATOM   2350  NE  ARG B 404     124.979  81.167 138.313  1.00 62.32           N
ATOM   2351  CZ  ARG B 404     124.929  79.844 138.222  1.00 62.32           C
ATOM   2352  NH1 ARG B 404     126.047  79.137 138.223  1.00 62.32           N
ATOM   2353  NH2 ARG B 404     123.760  79.232 138.121  1.00 62.32           N
ATOM   2354  N   TYR B 405     127.236  85.646 135.372  1.00 60.24           N
ATOM   2355  CA  TYR B 405     128.431  86.473 135.358  1.00 60.24           C
ATOM   2356  C   TYR B 405     128.244  87.763 134.591  1.00 60.24           C
ATOM   2357  O   TYR B 405     128.887  88.762 134.907  1.00 60.24           O
ATOM   2358  CB  TYR B 405     129.595  85.697 134.757  1.00 60.24           C
ATOM   2359  CG  TYR B 405     130.064  84.579 135.630  1.00 60.24           C
ATOM   2360  CD1 TYR B 405     130.903  84.823 136.698  1.00 60.24           C
ATOM   2361  CD2 TYR B 405     129.662  83.281 135.395  1.00 60.24           C
ATOM   2362  CE1 TYR B 405     131.333  83.806 137.501  1.00 60.24           C
ATOM   2363  CE2 TYR B 405     130.084  82.258 136.192  1.00 60.24           C
ATOM   2364  CZ  TYR B 405     130.921  82.526 137.242  1.00 60.24           C
ATOM   2365  OH  TYR B 405     131.347  81.502 138.043  1.00 60.24           O
ATOM   2366  N   GLY B 406     127.394  87.753 133.585  1.00 55.48           N
ATOM   2367  CA  GLY B 406     127.064  88.939 132.837  1.00 55.48           C
ATOM   2368  C   GLY B 406     127.811  88.990 131.530  1.00 55.48           C
ATOM   2369  O   GLY B 406     128.922  89.505 131.452  1.00 55.48           O
ATOM   2370  N   LEU B 407     127.169  88.496 130.485  1.00 50.07           N
ATOM   2371  CA  LEU B 407     127.651  88.594 129.123  1.00 50.07           C
ATOM   2372  C   LEU B 407     126.426  88.661 128.243  1.00 50.07           C
ATOM   2373  O   LEU B 407     125.461  87.941 128.478  1.00 50.07           O
ATOM   2374  CB  LEU B 407     128.517  87.402 128.711  1.00 50.07           C
ATOM   2375  CG  LEU B 407     129.911  87.215 129.287  1.00 50.07           C
ATOM   2376  CD1 LEU B 407     130.479  85.904 128.845  1.00 50.07           C
ATOM   2377  CD2 LEU B 407     130.805  88.330 128.844  1.00 50.07           C
ATOM   2378  N   TYR B 408     126.453  89.528 127.251  1.00 49.12           N
ATOM   2379  CA  TYR B 408     125.383  89.538 126.278  1.00 49.12           C
ATOM   2380  C   TYR B 408     125.581  88.370 125.332  1.00 49.12           C
ATOM   2381  O   TYR B 408     126.704  88.018 124.991  1.00 49.12           O
ATOM   2382  CB  TYR B 408     125.362  90.845 125.510  1.00 49.12           C
ATOM   2383  CG  TYR B 408     125.334  92.028 126.415  1.00 49.12           C
ATOM   2384  CD1 TYR B 408     124.271  92.243 127.266  1.00 49.12           C
ATOM   2385  CD2 TYR B 408     126.353  92.956 126.388  1.00 49.12           C
ATOM   2386  CE1 TYR B 408     124.250  93.319 128.096  1.00 49.12           C
ATOM   2387  CE2 TYR B 408     126.335  94.041 127.202  1.00 49.12           C
ATOM   2388  CZ  TYR B 408     125.280  94.222 128.053  1.00 49.12           C
ATOM   2389  OH  TYR B 408     125.272  95.311 128.872  1.00 49.12           O
ATOM   2390  N   VAL B 409     124.493  87.734 124.942  1.00 48.32           N
ATOM   2391  CA  VAL B 409     124.561  86.543 124.115  1.00 48.32           C
ATOM   2392  C   VAL B 409     123.766  86.797 122.849  1.00 48.32           C
ATOM   2393  O   VAL B 409     122.633  87.277 122.910  1.00 48.32           O
ATOM   2394  CB  VAL B 409     124.045  85.307 124.870  1.00 48.32           C
ATOM   2395  CG1 VAL B 409     123.958  84.129 123.968  1.00 48.32           C
ATOM   2396  CG2 VAL B 409     124.959  84.982 126.003  1.00 48.32           C
ATOM   2397  N   VAL B 410     124.376  86.522 121.708  1.00 50.57           N
ATOM   2398  CA  VAL B 410     123.665  86.410 120.446  1.00 50.57           C
ATOM   2399  C   VAL B 410     123.421  84.932 120.211  1.00 50.57           C
ATOM   2400  O   VAL B 410     124.361  84.165 120.005  1.00 50.57           O
ATOM   2401  CB  VAL B 410     124.448  87.038 119.293  1.00 50.57           C
ATOM   2402  CG1 VAL B 410     123.737  86.792 117.990  1.00 50.57           C
ATOM   2403  CG2 VAL B 410     124.601  88.497 119.530  1.00 50.57           C
ATOM   2404  N   ASP B 411     122.165  84.525 120.256  1.00 55.37           N
ATOM   2405  CA  ASP B 411     121.807  83.130 120.090  1.00 55.37           C
ATOM   2406  C   ASP B 411     121.486  82.883 118.625  1.00 55.37           C
ATOM   2407  O   ASP B 411     120.688  83.605 118.031  1.00 55.37           O
ATOM   2408  CB  ASP B 411     120.616  82.786 120.972  1.00 55.37           C
ATOM   2409  CG  ASP B 411     120.481  81.318 121.214  1.00 55.37           C
ATOM   2410  OD1 ASP B 411     121.314  80.539 120.732  1.00 55.37           O
ATOM   2411  OD2 ASP B 411     119.528  80.937 121.896  1.00 55.37           O
ATOM   2412  N   GLU B 412     122.105  81.869 118.045  1.00 58.94           N
ATOM   2413  CA  GLU B 412     122.137  81.716 116.601  1.00 58.94           C
ATOM   2414  C   GLU B 412     121.571  80.368 116.200  1.00 58.94           C
ATOM   2415  O   GLU B 412     121.916  79.353 116.795  1.00 58.94           O
ATOM   2416  CB  GLU B 412     123.562  81.882 116.098  1.00 58.94           C
ATOM   2417  CG  GLU B 412     123.712  81.854 114.614  1.00 58.94           C
ATOM   2418  CD  GLU B 412     125.063  82.368 114.194  1.00 58.94           C
ATOM   2419  OE1 GLU B 412     125.855  82.739 115.082  1.00 58.94           O
ATOM   2420  OE2 GLU B 412     125.334  82.417 112.984  1.00 58.94           O
ATOM   2421  N   ALA B 413     120.688  80.369 115.211  1.00 56.38           N
ATOM   2422  CA  ALA B 413     120.084  79.135 114.742  1.00 56.38           C
ATOM   2423  C   ALA B 413     121.102  78.285 113.997  1.00 56.38           C
ATOM   2424  O   ALA B 413     122.042  78.791 113.387  1.00 56.38           O
ATOM   2425  CB  ALA B 413     118.895  79.435 113.839  1.00 56.38           C
ATOM   2426  N   ASN B 414     120.896  76.973 114.044  1.00 58.63           N
ATOM   2427  CA  ASN B 414     121.818  76.000 113.463  1.00 58.63           C
ATOM   2428  C   ASN B 414     121.541  75.852 111.966  1.00 58.63           C
ATOM   2429  O   ASN B 414     121.107  74.812 111.477  1.00 58.63           O
ATOM   2430  CB  ASN B 414     121.667  74.669 114.180  1.00 58.63           C
ATOM   2431  CG  ASN B 414     122.756  73.689 113.840  1.00 58.63           C
ATOM   2432  OD1 ASN B 414     123.752  74.038 113.227  1.00 58.63           O
ATOM   2433  ND2 ASN B 414     122.529  72.435 114.169  1.00 58.63           N
ATOM   2434  N   ILE B 415     121.781  76.928 111.226  1.00 56.49           N
ATOM   2435  CA  ILE B 415     121.552  76.949 109.787  1.00 56.49           C
ATOM   2436  C   ILE B 415     122.780  77.551 109.130  1.00 56.49           C
ATOM   2437  O   ILE B 415     123.060  78.738 109.310  1.00 56.49           O
ATOM   2438  CB  ILE B 415     120.303  77.745 109.391  1.00 56.49           C
ATOM   2439  CG1 ILE B 415     119.040  77.169 110.013  1.00 56.49           C
ATOM   2440  CG2 ILE B 415     120.151  77.733 107.897  1.00 56.49           C
ATOM   2441  CD1 ILE B 415     117.865  78.061 109.890  1.00 56.49           C
ATOM   2442  N   GLU B 416     123.507  76.747 108.368  1.00 62.75           N
ATOM   2443  CA  GLU B 416     124.562  77.273 107.513  1.00 62.75           C
ATOM   2444  C   GLU B 416     124.692  76.406 106.277  1.00 62.75           C
ATOM   2445  O   GLU B 416     124.947  75.209 106.384  1.00 62.75           O
ATOM   2446  CB  GLU B 416     125.895  77.372 108.241  1.00 62.75           C
ATOM   2447  CG  GLU B 416     126.994  77.801 107.302  1.00 62.75           C
ATOM   2448  CD  GLU B 416     128.227  78.298 107.995  1.00 62.75           C
ATOM   2449  OE1 GLU B 416     128.212  78.463 109.224  1.00 62.75           O
ATOM   2450  OE2 GLU B 416     129.234  78.497 107.306  1.00 62.75           O
ATOM   2451  N   THR B 417     124.589  77.018 105.114  1.00 63.74           N
ATOM   2452  CA  THR B 417     124.703  76.279 103.884  1.00 63.74           C
ATOM   2453  C   THR B 417     125.706  77.004 103.034  1.00 63.74           C
ATOM   2454  O   THR B 417     125.439  77.342 101.902  1.00 63.74           O
ATOM   2455  CB  THR B 417     123.367  76.274 103.141  1.00 63.74           C
ATOM   2456  OG1 THR B 417     123.101  77.584 102.648  1.00 63.74           O
ATOM   2457  CG2 THR B 417     122.254  75.873 104.060  1.00 63.74           C
ATOM   2458  N   HIS B 418     126.894  77.174 103.583  1.00 66.36           N
ATOM   2459  CA  HIS B 418     127.976  77.886 102.934  1.00 66.36           C
ATOM   2460  C   HIS B 418     128.437  77.232 101.647  1.00 66.36           C
ATOM   2461  O   HIS B 418     128.747  77.904 100.681  1.00 66.36           O
ATOM   2462  CB  HIS B 418     129.153  77.994 103.892  1.00 66.36           C
ATOM   2463  CG  HIS B 418     130.090  79.109 103.572  1.00 66.36           C
ATOM   2464  ND1 HIS B 418     130.874  79.715 104.525  1.00 66.36           N
ATOM   2465  CD2 HIS B 418     130.361  79.737 102.407  1.00 66.36           C
ATOM   2466  CE1 HIS B 418     131.596  80.662 103.959  1.00 66.36           C
ATOM   2467  NE2 HIS B 418     131.301  80.698 102.675  1.00 66.36           N
ATOM   2468  N   GLY B 419     128.476  75.913 101.646  1.00 67.96           N
ATOM   2469  CA  GLY B 419     128.928  75.148 100.508  1.00 67.96           C
ATOM   2470  C   GLY B 419     128.052  75.098  99.276  1.00 67.96           C
ATOM   2471  O   GLY B 419     128.497  74.624  98.246  1.00 67.96           O
ATOM   2472  N   MET B 420     126.809  75.544  99.375  1.00 69.11           N
ATOM   2473  CA  MET B 420     125.894  75.455  98.254  1.00 69.11           C
ATOM   2474  C   MET B 420     126.278  76.464  97.184  1.00 69.11           C
ATOM   2475  O   MET B 420     126.834  77.522  97.474  1.00 69.11           O
ATOM   2476  CB  MET B 420     124.461  75.710  98.712  1.00 69.11           C
ATOM   2477  CG  MET B 420     123.950  74.726  99.730  1.00 69.11           C
ATOM   2478  SD  MET B 420     124.019  73.027  99.158  1.00 69.11           S
ATOM   2479  CE  MET B 420     122.816  73.086  97.859  1.00 69.11           C
ATOM   2480  N   VAL B 421     125.994  76.122  95.934  1.00 69.64           N
ATOM   2481  CA  VAL B 421     126.206  77.051  94.828  1.00 69.64           C
ATOM   2482  C   VAL B 421     124.873  77.279  94.126  1.00 69.64           C
ATOM   2483  O   VAL B 421     124.330  76.345  93.525  1.00 69.64           O
ATOM   2484  CB  VAL B 421     127.268  76.547  93.845  1.00 69.64           C
ATOM   2485  CG1 VAL B 421     127.380  77.507  92.692  1.00 69.64           C
ATOM   2486  CG2 VAL B 421     128.600  76.411  94.535  1.00 69.64           C
ATOM   2487  N   PRO B 422     124.278  78.476  94.207  1.00 69.53           N
ATOM   2488  CA  PRO B 422     124.676  79.632  95.006  1.00 69.53           C
ATOM   2489  C   PRO B 422     124.345  79.403  96.463  1.00 69.53           C
ATOM   2490  O   PRO B 422     123.731  78.391  96.766  1.00 69.53           O
ATOM   2491  CB  PRO B 422     123.837  80.758  94.426  1.00 69.53           C
ATOM   2492  CG  PRO B 422     122.643  80.091  93.936  1.00 69.53           C
ATOM   2493  CD  PRO B 422     123.069  78.765  93.424  1.00 69.53           C
ATOM   2494  N   MET B 423     124.746  80.319  97.338  1.00 69.70           N
ATOM   2495  CA  MET B 423     124.693  80.056  98.767  1.00 69.70           C
ATOM   2496  C   MET B 423     123.262  79.955  99.283  1.00 69.70           C
ATOM   2497  O   MET B 423     123.037  79.325 100.316  1.00 69.70           O
ATOM   2498  CB  MET B 423     125.474  81.143  99.505  1.00 69.70           C
ATOM   2499  CG  MET B 423     125.866  80.840 100.919  1.00 69.70           C
ATOM   2500  SD  MET B 423     126.622  82.278 101.696  1.00 69.70           S
ATOM   2501  CE  MET B 423     128.138  82.423 100.790  1.00 69.70           C
ATOM   2502  N   ASN B 424     122.283  80.500  98.562  1.00 67.55           N
ATOM   2503  CA  ASN B 424     120.892  80.420  98.980  1.00 67.55           C
ATOM   2504  C   ASN B 424     120.094  79.367  98.221  1.00 67.55           C
ATOM   2505  O   ASN B 424     118.882  79.525  98.080  1.00 67.55           O
ATOM   2506  CB  ASN B 424     120.199  81.778  98.859  1.00 67.55           C
ATOM   2507  CG  ASN B 424     120.113  82.297  97.431  1.00 67.55           C
ATOM   2508  OD1 ASN B 424     120.638  81.716  96.492  1.00 67.55           O
ATOM   2509  ND2 ASN B 424     119.387  83.385  97.266  1.00 67.55           N
ATOM   2510  N   ARG B 425     120.743  78.321  97.707  1.00 67.75           N
ATOM   2511  CA  ARG B 425     120.024  77.320  96.926  1.00 67.75           C
ATOM   2512  C   ARG B 425     118.994  76.581  97.771  1.00 67.75           C
ATOM   2513  O   ARG B 425     117.877  76.324  97.315  1.00 67.75           O
ATOM   2514  CB  ARG B 425     121.000  76.337  96.289  1.00 67.75           C
ATOM   2515  CG  ARG B 425     120.310  75.281  95.463  1.00 67.75           C
ATOM   2516  CD  ARG B 425     121.261  74.385  94.733  1.00 67.75           C
ATOM   2517  NE  ARG B 425     121.929  75.073  93.642  1.00 67.75           N
ATOM   2518  CZ  ARG B 425     121.412  75.216  92.430  1.00 67.75           C
ATOM   2519  NH1 ARG B 425     120.219  74.722  92.152  1.00 67.75           N
ATOM   2520  NH2 ARG B 425     122.089  75.854  91.494  1.00 67.75           N
ATOM   2521  N   LEU B 426     119.323  76.291  99.020  1.00 63.68           N
ATOM   2522  CA  LEU B 426     118.355  75.659  99.898  1.00 63.68           C
ATOM   2523  C   LEU B 426     117.464  76.665 100.598  1.00 63.68           C
ATOM   2524  O   LEU B 426     116.287  76.384 100.822  1.00 63.68           O
ATOM   2525  CB  LEU B 426     119.064  74.807 100.946  1.00 63.68           C
ATOM   2526  CG  LEU B 426     119.950  73.707 100.383  1.00 63.68           C
ATOM   2527  CD1 LEU B 426     120.584  72.938 101.504  1.00 63.68           C
ATOM   2528  CD2 LEU B 426     119.187  72.799  99.459  1.00 63.68           C
ATOM   2529  N   THR B 427     117.984  77.830 100.947  1.00 62.81           N
ATOM   2530  CA  THR B 427     117.206  78.772 101.731  1.00 62.81           C
ATOM   2531  C   THR B 427     116.270  79.621 100.892  1.00 62.81           C
ATOM   2532  O   THR B 427     115.510  80.403 101.455  1.00 62.81           O
ATOM   2533  CB  THR B 427     118.122  79.683 102.532  1.00 62.81           C
ATOM   2534  OG1 THR B 427     118.886  80.495 101.641  1.00 62.81           O
ATOM   2535  CG2 THR B 427     119.060  78.868 103.380  1.00 62.81           C
ATOM   2536  N   ASP B 428     116.305  79.506  99.574  1.00 68.07           N
ATOM   2537  CA  ASP B 428     115.299  80.138  98.742  1.00 68.07           C
ATOM   2538  C   ASP B 428     114.318  79.109  98.199  1.00 68.07           C
ATOM   2539  O   ASP B 428     113.469  79.440  97.373  1.00 68.07           O
ATOM   2540  CB  ASP B 428     115.965  80.911  97.608  1.00 68.07           C
ATOM   2541  CG  ASP B 428     115.128  82.067  97.120  1.00 68.07           C
ATOM   2542  OD1 ASP B 428     114.047  82.310  97.693  1.00 68.07           O
ATOM   2543  OD2 ASP B 428     115.551  82.743  96.163  1.00 68.07           O
ATOM   2544  N   ASP B 429     114.423  77.867  98.656  1.00 66.53           N
ATOM   2545  CA  ASP B 429     113.564  76.777  98.238  1.00 66.53           C
ATOM   2546  C   ASP B 429     112.525  76.540  99.318  1.00 66.53           C
ATOM   2547  O   ASP B 429     112.902  76.283 100.468  1.00 66.53           O
ATOM   2548  CB  ASP B 429     114.407  75.526  98.022  1.00 66.53           C
ATOM   2549  CG  ASP B 429     113.659  74.392  97.344  1.00 66.53           C
ATOM   2550  OD1 ASP B 429     112.461  74.506  97.036  1.00 66.53           O
ATOM   2551  OD2 ASP B 429     114.297  73.352  97.108  1.00 66.53           O
ATOM   2552  N   PRO B 430     111.227  76.610  99.017  1.00 63.91           N
ATOM   2553  CA  PRO B 430     110.226  76.379 100.066  1.00 63.91           C
ATOM   2554  C   PRO B 430     110.098  74.936 100.494  1.00 63.91           C
ATOM   2555  O   PRO B 430     109.466  74.677 101.518  1.00 63.91           O
ATOM   2556  CB  PRO B 430     108.932  76.884  99.428  1.00 63.91           C
ATOM   2557  CG  PRO B 430     109.162  76.766  98.016  1.00 63.91           C
ATOM   2558  CD  PRO B 430     110.596  77.052  97.768  1.00 63.91           C
ATOM   2559  N   ARG B 431     110.682  73.991  99.762  1.00 67.22           N
ATOM   2560  CA  ARG B 431     110.735  72.615 100.228  1.00 67.22           C
ATOM   2561  C   ARG B 431     111.654  72.448 101.428  1.00 67.22           C
ATOM   2562  O   ARG B 431     111.536  71.458 102.150  1.00 67.22           O
ATOM   2563  CB  ARG B 431     111.177  71.704  99.090  1.00 67.22           C
ATOM   2564  CG  ARG B 431     110.139  71.587  97.991  1.00 67.22           C
ATOM   2565  CD  ARG B 431     110.647  70.822  96.789  1.00 67.22           C
ATOM   2566  NE  ARG B 431     110.958  69.428  97.086  1.00 67.22           N
ATOM   2567  CZ  ARG B 431     110.074  68.438  97.052  1.00 67.22           C
ATOM   2568  NH1 ARG B 431     108.809  68.679  96.746  1.00 67.22           N
ATOM   2569  NH2 ARG B 431     110.455  67.204  97.334  1.00 67.22           N
ATOM   2570  N   TRP B 432     112.556  73.391 101.660  1.00 61.70           N
ATOM   2571  CA  TRP B 432     113.431  73.385 102.816  1.00 61.70           C
ATOM   2572  C   TRP B 432     112.963  74.318 103.912  1.00 61.70           C
ATOM   2573  O   TRP B 432     113.599  74.379 104.961  1.00 61.70           O
ATOM   2574  CB  TRP B 432     114.842  73.754 102.385  1.00 61.70           C
ATOM   2575  CG  TRP B 432     115.494  72.665 101.654  1.00 61.70           C
ATOM   2576  CD1 TRP B 432     115.416  72.415 100.329  1.00 61.70           C
ATOM   2577  CD2 TRP B 432     116.366  71.683 102.200  1.00 61.70           C
ATOM   2578  NE1 TRP B 432     116.163  71.319 100.013  1.00 61.70           N
ATOM   2579  CE2 TRP B 432     116.763  70.853 101.149  1.00 61.70           C
ATOM   2580  CE3 TRP B 432     116.846  71.423 103.481  1.00 61.70           C
ATOM   2581  CZ2 TRP B 432     117.622  69.785 101.334  1.00 61.70           C
ATOM   2582  CZ3 TRP B 432     117.690  70.365 103.664  1.00 61.70           C
ATOM   2583  CH2 TRP B 432     118.070  69.556 102.599  1.00 61.70           C
ATOM   2584  N   LEU B 433     111.883  75.055 103.681  1.00 59.21           N
ATOM   2585  CA  LEU B 433     111.309  75.887 104.733  1.00 59.21           C
ATOM   2586  C   LEU B 433     110.832  75.119 105.968  1.00 59.21           C
ATOM   2587  O   LEU B 433     111.028  75.647 107.073  1.00 59.21           O
ATOM   2588  CB  LEU B 433     110.188  76.754 104.144  1.00 59.21           C
ATOM   2589  CG  LEU B 433     109.443  77.703 105.079  1.00 59.21           C
ATOM   2590  CD1 LEU B 433     110.389  78.688 105.707  1.00 59.21           C
ATOM   2591  CD2 LEU B 433     108.363  78.426 104.323  1.00 59.21           C
ATOM   2592  N   PRO B 434     110.225  73.918 105.888  1.00 60.38           N
ATOM   2593  CA  PRO B 434     109.968  73.182 107.139  1.00 60.38           C
ATOM   2594  C   PRO B 434     111.210  72.784 107.911  1.00 60.38           C
ATOM   2595  O   PRO B 434     111.187  72.813 109.144  1.00 60.38           O
ATOM   2596  CB  PRO B 434     109.199  71.952 106.658  1.00 60.38           C
ATOM   2597  CG  PRO B 434     108.532  72.389 105.479  1.00 60.38           C
ATOM   2598  CD  PRO B 434     109.458  73.299 104.788  1.00 60.38           C
ATOM   2599  N   ALA B 435     112.291  72.411 107.231  1.00 60.35           N
ATOM   2600  CA  ALA B 435     113.501  72.036 107.949  1.00 60.35           C
ATOM   2601  C   ALA B 435     114.173  73.251 108.566  1.00 60.35           C
ATOM   2602  O   ALA B 435     114.701  73.174 109.677  1.00 60.35           O
ATOM   2603  CB  ALA B 435     114.463  71.309 107.018  1.00 60.35           C
ATOM   2604  N   MET B 436     114.157  74.380 107.865  1.00 60.10           N
ATOM   2605  CA  MET B 436     114.750  75.590 108.411  1.00 60.10           C
ATOM   2606  C   MET B 436     113.926  76.160 109.547  1.00 60.10           C
ATOM   2607  O   MET B 436     114.490  76.733 110.480  1.00 60.10           O
ATOM   2608  CB  MET B 436     114.913  76.638 107.323  1.00 60.10           C
ATOM   2609  CG  MET B 436     115.997  76.347 106.339  1.00 60.10           C
ATOM   2610  SD  MET B 436     116.000  77.587 105.057  1.00 60.10           S
ATOM   2611  CE  MET B 436     116.418  79.032 106.015  1.00 60.10           C
ATOM   2612  N   SER B 437     112.603  76.018 109.491  1.00 59.53           N
ATOM   2613  CA  SER B 437     111.769  76.619 110.519  1.00 59.53           C
ATOM   2614  C   SER B 437     111.916  75.908 111.850  1.00 59.53           C
ATOM   2615  O   SER B 437     111.921  76.564 112.888  1.00 59.53           O
ATOM   2616  CB  SER B 437     110.307  76.641 110.090  1.00 59.53           C
ATOM   2617  OG  SER B 437     109.775  75.341 110.012  1.00 59.53           O
ATOM   2618  N   GLU B 438     112.100  74.602 111.812  1.00 63.70           N
ATOM   2619  CA  GLU B 438     112.271  73.834 113.023  1.00 63.70           C
ATOM   2620  C   GLU B 438     113.521  74.287 113.747  1.00 63.70           C
ATOM   2621  O   GLU B 438     113.537  74.376 114.956  1.00 63.70           O
ATOM   2622  CB  GLU B 438     112.392  72.357 112.690  1.00 63.70           C
ATOM   2623  CG  GLU B 438     111.156  71.776 112.044  1.00 63.70           C
ATOM   2624  CD  GLU B 438     110.185  71.216 113.057  1.00 63.70           C
ATOM   2625  OE1 GLU B 438     110.649  70.684 114.086  1.00 63.70           O
ATOM   2626  OE2 GLU B 438     108.959  71.303 112.827  1.00 63.70           O
ATOM   2627  N   ARG B 439     114.572  74.570 112.997  1.00 59.20           N
ATOM   2628  CA  ARG B 439     115.828  74.986 113.594  1.00 59.20           C
ATOM   2629  C   ARG B 439     115.741  76.361 114.223  1.00 59.20           C
ATOM   2630  O   ARG B 439     116.480  76.643 115.164  1.00 59.20           O
ATOM   2631  CB  ARG B 439     116.925  74.946 112.543  1.00 59.20           C
ATOM   2632  CG  ARG B 439     117.256  73.541 112.174  1.00 59.20           C
ATOM   2633  CD  ARG B 439     118.129  73.463 110.986  1.00 59.20           C
ATOM   2634  NE  ARG B 439     118.370  72.074 110.649  1.00 59.20           N
ATOM   2635  CZ  ARG B 439     119.439  71.397 111.027  1.00 59.20           C
ATOM   2636  NH1 ARG B 439     120.388  71.996 111.712  1.00 59.20           N
ATOM   2637  NH2 ARG B 439     119.566  70.131 110.694  1.00 59.20           N
ATOM   2638  N   VAL B 440     114.844  77.206 113.743  1.00 55.50           N
ATOM   2639  CA  VAL B 440     114.662  78.529 114.311  1.00 55.50           C
ATOM   2640  C   VAL B 440     113.648  78.512 115.441  1.00 55.50           C
ATOM   2641  O   VAL B 440     113.910  79.041 116.521  1.00 55.50           O
ATOM   2642  CB  VAL B 440     114.259  79.514 113.201  1.00 55.50           C
ATOM   2643  CG1 VAL B 440     113.846  80.813 113.786  1.00 55.50           C
ATOM   2644  CG2 VAL B 440     115.416  79.729 112.267  1.00 55.50           C
ATOM   2645  N   THR B 441     112.488  77.892 115.218  1.00 57.15           N
ATOM   2646  CA  THR B 441     111.407  77.955 116.195  1.00 57.15           C
ATOM   2647  C   THR B 441     111.736  77.187 117.463  1.00 57.15           C
ATOM   2648  O   THR B 441     111.334  77.603 118.549  1.00 57.15           O
ATOM   2649  CB  THR B 441     110.101  77.435 115.597  1.00 57.15           C
ATOM   2650  OG1 THR B 441     110.263  76.079 115.189  1.00 57.15           O
ATOM   2651  CG2 THR B 441     109.671  78.269 114.416  1.00 57.15           C
ATOM   2652  N   ARG B 442     112.486  76.100 117.361  1.00 59.65           N
ATOM   2653  CA  ARG B 442     112.834  75.353 118.555  1.00 59.65           C
ATOM   2654  C   ARG B 442     113.969  75.994 119.332  1.00 59.65           C
ATOM   2655  O   ARG B 442     114.093  75.740 120.529  1.00 59.65           O
ATOM   2656  CB  ARG B 442     113.178  73.916 118.188  1.00 59.65           C
ATOM   2657  CG  ARG B 442     111.993  73.192 117.610  1.00 59.65           C
ATOM   2658  CD  ARG B 442     112.321  71.811 117.130  1.00 59.65           C
ATOM   2659  NE  ARG B 442     112.625  70.909 118.226  1.00 59.65           N
ATOM   2660  CZ  ARG B 442     113.804  70.338 118.420  1.00 59.65           C
ATOM   2661  NH1 ARG B 442     114.801  70.553 117.581  1.00 59.65           N
ATOM   2662  NH2 ARG B 442     113.975  69.532 119.449  1.00 59.65           N
ATOM   2663  N   MET B 443     114.791  76.816 118.685  1.00 57.54           N
ATOM   2664  CA  MET B 443     115.769  77.610 119.415  1.00 57.54           C
ATOM   2665  C   MET B 443     115.087  78.675 120.256  1.00 57.54           C
ATOM   2666  O   MET B 443     115.418  78.855 121.431  1.00 57.54           O
ATOM   2667  CB  MET B 443     116.746  78.267 118.452  1.00 57.54           C
ATOM   2668  CG  MET B 443     117.672  79.232 119.144  1.00 57.54           C
ATOM   2669  SD  MET B 443     118.710  80.163 118.039  1.00 57.54           S
ATOM   2670  CE  MET B 443     117.516  81.212 117.237  1.00 57.54           C
ATOM   2671  N   VAL B 444     114.140  79.396 119.659  1.00 55.44           N
ATOM   2672  CA  VAL B 444     113.442  80.467 120.357  1.00 55.44           C
ATOM   2673  C   VAL B 444     112.611  79.907 121.499  1.00 55.44           C
ATOM   2674  O   VAL B 444     112.599  80.460 122.596  1.00 55.44           O
ATOM   2675  CB  VAL B 444     112.595  81.273 119.359  1.00 55.44           C
ATOM   2676  CG1 VAL B 444     111.740  82.284 120.065  1.00 55.44           C
ATOM   2677  CG2 VAL B 444     113.491  81.972 118.380  1.00 55.44           C
ATOM   2678  N   GLN B 445     111.970  78.764 121.286  1.00 60.13           N
ATOM   2679  CA  GLN B 445     111.189  78.151 122.350  1.00 60.13           C
ATOM   2680  C   GLN B 445     112.053  77.630 123.486  1.00 60.13           C
ATOM   2681  O   GLN B 445     111.599  77.596 124.629  1.00 60.13           O
ATOM   2682  CB  GLN B 445     110.329  77.040 121.779  1.00 60.13           C
ATOM   2683  CG  GLN B 445     109.093  77.564 121.140  1.00 60.13           C
ATOM   2684  CD  GLN B 445     108.254  76.489 120.529  1.00 60.13           C
ATOM   2685  OE1 GLN B 445     108.737  75.412 120.210  1.00 60.13           O
ATOM   2686  NE2 GLN B 445     106.963  76.731 120.474  1.00 60.13           N
ATOM   2687  N   ARG B 446     113.295  77.256 123.213  1.00 58.60           N
ATOM   2688  CA  ARG B 446     114.147  76.797 124.296  1.00 58.60           C
ATOM   2689  C   ARG B 446     114.712  77.960 125.101  1.00 58.60           C
ATOM   2690  O   ARG B 446     114.793  77.882 126.327  1.00 58.60           O
ATOM   2691  CB  ARG B 446     115.291  75.945 123.758  1.00 58.60           C
ATOM   2692  CG  ARG B 446     116.041  75.249 124.860  1.00 58.60           C
ATOM   2693  CD  ARG B 446     117.312  74.587 124.424  1.00 58.60           C
ATOM   2694  NE  ARG B 446     118.323  75.568 124.076  1.00 58.60           N
ATOM   2695  CZ  ARG B 446     119.559  75.272 123.708  1.00 58.60           C
ATOM   2696  NH1 ARG B 446     119.964  74.018 123.678  1.00 58.60           N
ATOM   2697  NH2 ARG B 446     120.402  76.239 123.407  1.00 58.60           N
ATOM   2698  N   ASP B 447     115.089  79.052 124.441  1.00 58.33           N
ATOM   2699  CA  ASP B 447     116.001  80.018 125.034  1.00 58.33           C
ATOM   2700  C   ASP B 447     115.410  81.402 125.253  1.00 58.33           C
ATOM   2701  O   ASP B 447     116.152  82.318 125.600  1.00 58.33           O
ATOM   2702  CB  ASP B 447     117.250  80.134 124.164  1.00 58.33           C
ATOM   2703  CG  ASP B 447     118.074  78.879 124.182  1.00 58.33           C
ATOM   2704  OD1 ASP B 447     118.076  78.190 125.214  1.00 58.33           O
ATOM   2705  OD2 ASP B 447     118.703  78.555 123.167  1.00 58.33           O
ATOM   2706  N   ARG B 448     114.104  81.582 125.089  1.00 59.42           N
ATOM   2707  CA  ARG B 448     113.535  82.922 125.152  1.00 59.42           C
ATOM   2708  C   ARG B 448     113.467  83.502 126.556  1.00 59.42           C
ATOM   2709  O   ARG B 448     113.230  84.701 126.685  1.00 59.42           O
ATOM   2710  CB  ARG B 448     112.139  82.933 124.555  1.00 59.42           C
ATOM   2711  CG  ARG B 448     111.163  82.065 125.289  1.00 59.42           C
ATOM   2712  CD  ARG B 448     109.852  82.052 124.575  1.00 59.42           C
ATOM   2713  NE  ARG B 448     109.289  83.387 124.524  1.00 59.42           N
ATOM   2714  CZ  ARG B 448     108.296  83.744 123.726  1.00 59.42           C
ATOM   2715  NH1 ARG B 448     107.747  82.855 122.919  1.00 59.42           N
ATOM   2716  NH2 ARG B 448     107.853  84.988 123.741  1.00 59.42           N
ATOM   2717  N   ASN B 449     113.661  82.711 127.600  1.00 61.44           N
ATOM   2718  CA  ASN B 449     113.570  83.258 128.943  1.00 61.44           C
ATOM   2719  C   ASN B 449     114.904  83.724 129.500  1.00 61.44           C
ATOM   2720  O   ASN B 449     114.923  84.310 130.582  1.00 61.44           O
ATOM   2721  CB  ASN B 449     112.963  82.241 129.904  1.00 61.44           C
ATOM   2722  CG  ASN B 449     111.507  81.992 129.635  1.00 61.44           C
ATOM   2723  OD1 ASN B 449     110.778  82.890 129.243  1.00 61.44           O
ATOM   2724  ND2 ASN B 449     111.066  80.778 129.879  1.00 61.44           N
TER
HETATM 2725  C1  PTQ B2001     135.230  82.304 106.501  1.00 70.60           C
HETATM 2726  C10 PTQ B2001     139.136  80.661 104.015  1.00 70.60           C
HETATM 2727  C11 PTQ B2001     139.708  79.444 103.963  1.00 70.60           C
HETATM 2728  C12 PTQ B2001     139.148  78.369 103.064  1.00 70.60           C
HETATM 2729  C13 PTQ B2001     138.061  78.641 102.308  1.00 70.60           C
HETATM 2730  C14 PTQ B2001     137.419  80.011 102.372  1.00 70.60           C
HETATM 2731  C2  PTQ B2001     136.531  82.348 107.280  1.00 70.60           C
HETATM 2732  C3  PTQ B2001     136.352  81.621 108.591  1.00 70.60           C
HETATM 2733  C4  PTQ B2001     135.171  82.149 109.386  1.00 70.60           C
HETATM 2734  C5  PTQ B2001     133.987  81.973 108.482  1.00 70.60           C
HETATM 2735  C6  PTQ B2001     132.689  82.253 109.181  1.00 70.60           C
HETATM 2736  C7  PTQ B2001     135.833  82.196 103.638  1.00 70.60           C
HETATM 2737  C8  PTQ B2001     137.294  82.336 103.263  1.00 70.60           C
HETATM 2738  C9  PTQ B2001     137.925  80.964 103.176  1.00 70.60           C
HETATM 2739  O1  PTQ B2001     134.198  82.783 107.344  1.00 70.60           O
HETATM 2740  O2  PTQ B2001     137.554  81.733 106.548  1.00 70.60           O
HETATM 2741  O3  PTQ B2001     137.565  81.677 109.301  1.00 70.60           O
HETATM 2742  O4  PTQ B2001     135.273  83.531 109.599  1.00 70.60           O
HETATM 2743  O5  PTQ B2001     132.587  81.365 110.265  1.00 70.60           O
HETATM 2744  S1  PTQ B2001     135.420  83.244 105.010  1.00 70.60           S
HETATM 2745  O   HOH B2101     136.929  97.626 133.817  1.00 61.38           O
HETATM 2746  O   HOH B2102     144.921  84.745  99.858  1.00 75.31           O
HETATM 2747  O   HOH B2103     101.821  74.378 125.772  1.00 72.52           O
HETATM 2748  O   HOH B2104     126.442  84.793 107.642  1.00 65.31           O
HETATM 2749  O   HOH B2105     115.285  71.953 115.630  1.00 63.37           O
HETATM 2750  O   HOH B2106     130.184  50.158 132.904  1.00 80.04           O
HETATM 2751  O   HOH B2107     124.549  59.073 135.048  1.00 68.90           O
HETATM 2752  O   HOH B2108     173.526  83.118 130.615  1.00 77.21           O
HETATM 2753  O   HOH B2109     157.498  80.574 127.960  1.00 69.05           O
HETATM 2754  O   HOH B2110     146.069  80.256  90.934  1.00 85.72           O
HETATM 2755  O   HOH B2111     143.502 103.926 126.639  1.00 59.48           O
HETATM 2756  O   HOH B2112     122.795  68.740 131.329  1.00 70.90           O
HETATM 2757  O   HOH B2113     139.306  59.092 115.183  1.00 73.37           O
HETATM 2758  O   HOH B2114     127.159  85.344 104.084  1.00 67.35           O
HETATM 2759  O   HOH B2115     140.374 104.951 110.043  1.00 68.49           O
HETATM 2760  O   HOH B2116     112.445  74.708 135.559  1.00 73.74           O
HETATM 2761  O   HOH B2117     168.544 107.967 130.975  1.00 79.77           O
HETATM 2762  O   HOH B2118     111.795  80.937  96.711  1.00 67.81           O
HETATM 2763  O   HOH B2119     136.063  52.183 113.226  1.00 70.83           O
HETATM 2764  O   HOH B2120     122.225  93.112 101.058  1.00 65.27           O
HETATM 2765  O   HOH B2121     129.560  99.212 129.184  1.00 63.08           O
HETATM 2766  O   HOH B2122     108.097 103.160 141.976  1.00 77.32           O
HETATM 2767  O   HOH B2123     138.732  51.933 116.655  1.00 75.45           O
HETATM 2768  O   HOH B2124     179.603 104.015 119.706  1.00 75.55           O
HETATM 2769  O   HOH B2125     113.674  55.897 138.035  1.00 80.90           O
HETATM 2770  O   HOH B2126     110.968  95.971 144.360  1.00 77.59           O
HETATM 2771  O   HOH B2127      93.909  67.445 136.942  1.00 85.08           O
HETATM 2772  O   HOH B2128     146.367  64.361 126.550  1.00 79.46           O
HETATM 2773  O   HOH B2129     151.670  86.226 125.275  1.00 61.38           O
HETATM 2774  O   HOH B2130     135.439 109.746 110.551  1.00 63.82           O
HETATM 2775  O   HOH B2131     143.351  89.365 136.574  1.00 65.03           O
HETATM 2776  O   HOH B2132     146.949 102.732 123.687  1.00 51.91           O
HETATM 2777  O   HOH B2133     182.249  95.931 122.373  1.00 77.41           O
HETATM 2778  O   HOH B2134     163.616 106.247 126.272  1.00 70.47           O
HETATM 2779  O   HOH B2135     114.759  43.187 114.542  1.00 76.22           O
HETATM 2780  O   HOH B2136     133.147  79.695 106.627  1.00 66.13           O
HETATM 2781  O   HOH B2137     120.880  71.064 123.764  1.00 64.80           O
HETATM 2782  O   HOH B2138     116.045  83.129 145.423  1.00 76.98           O
HETATM 2783  O   HOH B2139     148.139  76.665  90.994  1.00 91.87           O
HETATM 2784  O   HOH B2140     129.368  67.357 117.685  1.00 63.57           O
HETATM 2785  O   HOH B2141     117.143  82.805  94.404  1.00 75.61           O
HETATM 2786  O   HOH B2142     143.123  96.839 106.002  1.00 69.17           O
HETATM 2787  O   HOH B2143     126.490 108.056 101.582  1.00 60.71           O
HETATM 2788  O   HOH B2144     130.694  58.378 121.268  1.00 67.35           O
HETATM 2789  O   HOH B2145      92.783  83.154 134.890  1.00 76.84           O
HETATM 2790  O   HOH B2146     124.173  59.126  98.056  1.00 75.60           O
HETATM 2791  O   HOH B2147     113.453 100.506 115.710  1.00 66.42           O
HETATM 2792  O   HOH B2148     119.776  76.684 130.360  1.00 67.59           O
HETATM 2793  O   HOH B2149     106.170  47.633 119.092  1.00 73.85           O
HETATM 2794  O   HOH B2150      89.282  80.995 134.863  1.00 76.71           O
HETATM 2795  O   HOH B2151     167.480  84.568  92.544  1.00 74.04           O
HETATM 2796  O   HOH B2152     104.487  84.543 125.523  1.00 67.22           O
HETATM 2797  O   HOH B2153     116.672  46.354 123.318  1.00 73.53           O
HETATM 2798  O   HOH B2154     178.401 101.582 101.891  1.00 70.15           O
HETATM 2799  O   HOH B2155     178.099  76.829 119.547  1.00 71.99           O
HETATM 2800  O   HOH B2156     118.025  44.163 108.613  1.00 80.96           O
HETATM 2801  O   HOH B2157     115.025  97.455 144.170  1.00 76.57           O
HETATM 2802  O   HOH B2158     130.084  76.832 138.112  1.00 69.37           O
HETATM 2803  O   HOH B2159     166.014  90.889 110.605  1.00 59.32           O
HETATM 2804  O   HOH B2160     131.620  68.166  98.892  1.00 72.86           O
HETATM 2805  O   HOH B2161     182.102 108.072 111.061  1.00 72.29           O
HETATM 2806  O   HOH B2162     131.120  72.739 118.584  1.00 66.48           O
HETATM 2807  O   HOH B2163     177.741  92.254 108.445  1.00 66.38           O
HETATM 2808  O   HOH B2164     110.529  95.089 127.781  1.00 71.07           O
HETATM 2809  O   HOH B2165     112.944  94.064 107.566  1.00 64.71           O
HETATM 2810  O   HOH B2166     100.137  95.090 132.998  1.00 78.70           O
HETATM 2811  O   HOH B2167     145.153  89.084 105.232  1.00 72.45           O
HETATM 2812  O   HOH B2168     108.376  52.019 102.824  1.00 74.44           O
HETATM 2813  O   HOH B2169     145.436 103.401 147.587  1.00 73.56           O
HETATM 2814  O   HOH B2170     152.658 100.616  97.715  1.00 65.91           O
HETATM 2815  O   HOH B2171     169.284  95.731 106.288  1.00 61.16           O
HETATM 2816  O   HOH B2172     144.414  80.934 130.679  1.00 64.19           O
HETATM 2817  O   HOH B2173     133.608  80.927 116.964  1.00 59.54           O
HETATM 2818  O   HOH B2174     114.732  70.199 127.238  1.00 69.49           O
HETATM 2819  O   HOH B2175     149.623  77.197 101.874  1.00 79.10           O
HETATM 2820  O   HOH B2176     170.229  94.346  87.846  1.00 74.52           O
HETATM 2821  O   HOH B2177     161.258  84.170  90.541  1.00 73.53           O
HETATM 2822  O   HOH B2178     168.177 106.125 119.645  1.00 66.54           O
HETATM 2823  O   HOH B2179     152.104 102.126 101.633  1.00 65.96           O
HETATM 2824  O   HOH B2180     143.844  79.077  96.874  1.00 87.23           O
HETATM 2825  O   HOH B2181     147.647  94.416 140.471  1.00 71.90           O
HETATM 2826  O   HOH B2182     171.470  97.875 130.705  1.00 63.59           O
HETATM 2827  O   HOH B2183     152.873 116.702 131.619  1.00 81.11           O
HETATM 2828  O   HOH B2184     151.056  91.507 128.881  1.00 59.51           O
HETATM 2829  O   HOH B2185     142.820  92.766 100.169  1.00 70.18           O
HETATM 2830  O   HOH B2186     127.472  56.501  98.655  1.00 72.78           O
HETATM 2831  O   HOH B2187     129.974  79.507 138.402  1.00 68.41           O
HETATM 2832  O   HOH B2188     160.417  86.650 134.152  1.00 68.33           O
HETATM 2833  O   HOH B2189      98.262  76.392 125.254  1.00 74.25           O
HETATM 2834  O   HOH B2190     110.401  63.791 144.763  1.00 82.71           O
HETATM 2835  O   HOH B2191     162.781  82.700 122.185  1.00 66.14           O
HETATM 2836  O   HOH B2192     131.098  47.327 114.921  1.00 72.25           O
HETATM 2837  O   HOH B2193     107.225  60.953 121.966  1.00 64.14           O
HETATM 2838  O   HOH B2194     126.844  50.777 129.843  1.00 75.81           O
HETATM 2839  O   HOH B2195     107.706  80.416 122.596  1.00 65.30           O
HETATM 2840  O   HOH B2196     138.871  92.186 140.881  1.00 68.52           O
HETATM 2841  O   HOH B2197     122.513  99.702 103.377  1.00 66.56           O
HETATM 2842  O   HOH B2198     174.184 106.960 106.183  1.00 61.21           O
HETATM 2843  O   HOH B2199     115.125  68.918 131.659  1.00 72.95           O
HETATM 2844  O   HOH B2200     106.924  58.423 122.424  1.00 66.73           O
HETATM 2845  O   HOH B2201     129.140  90.667 105.129  1.00 64.68           O
HETATM 2846  O   HOH B2202     137.488  97.929 136.485  1.00 64.44           O
HETATM 2847  O   HOH B2203     152.360 101.258 122.500  1.00 57.70           O
HETATM 2848  O   HOH B2204     163.360 102.935  95.010  1.00 71.76           O
HETATM 2849  O   HOH B2205     143.427  77.032 100.736  1.00 83.63           O
HETATM 2850  O   HOH B2206     140.120  70.514 130.018  1.00 72.77           O
HETATM 2851  O   HOH B2207     168.613  89.825 132.391  1.00 66.69           O
HETATM 2852  O   HOH B2208     124.367  85.797 110.467  1.00 62.46           O
HETATM 2853  O   HOH B2209     135.252  92.961 120.262  1.00 47.66           O
HETATM 2854  O   HOH B2210     129.475  71.904 110.365  1.00 66.19           O
HETATM 2855  O   HOH B2211     118.669  89.454  99.111  1.00 62.21           O
HETATM 2856  O   HOH B2212     127.832  70.965 135.500  1.00 72.76           O
HETATM 2857  O   HOH B2213     105.153  51.322 130.497  1.00 73.13           O
HETATM 2858  O   HOH B2214     139.640 104.430 112.797  1.00 59.83           O
HETATM 2859  O   HOH B2215     171.089  87.413 129.188  1.00 70.15           O
HETATM 2860  O   HOH B2216     161.580  87.402 120.475  1.00 57.35           O
HETATM 2861  O   HOH B2217     145.345  71.291 120.573  1.00 66.44           O
HETATM 2862  O   HOH B2218     119.032 108.981 118.826  1.00 70.14           O
HETATM 2863  O   HOH B2219     141.396  87.403 144.803  1.00 71.81           O
HETATM 2864  O   HOH B2220     106.997  64.259 112.291  1.00 64.67           O
HETATM 2865  O   HOH B2221     156.126 104.668 133.197  1.00 60.28           O
HETATM 2866  O   HOH B2222     130.224  88.315  94.474  1.00 80.03           O
HETATM 2867  O   HOH B2223     156.573  85.837 122.309  1.00 59.49           O
HETATM 2868  O   HOH B2224     107.131  50.777 117.993  1.00 69.88           O
HETATM 2869  O   HOH B2225     144.455  87.197  97.773  1.00 78.56           O
HETATM 2870  O   HOH B2226     131.362  77.137 106.463  1.00 64.59           O
HETATM 2871  O   HOH B2227     114.705 102.372 140.386  1.00 78.14           O
HETATM 2872  O   HOH B2228     110.902 102.132 128.863  1.00 77.15           O
HETATM 2873  O   HOH B2229     126.040  73.086 137.178  1.00 71.02           O
HETATM 2874  O   HOH B2230     143.135  87.052 132.920  1.00 64.13           O
HETATM 2875  O   HOH B2231     175.709  77.523 121.066  1.00 71.85           O
HETATM 2876  O   HOH B2232     102.987  62.073 125.173  1.00 72.15           O
HETATM 2877  O   HOH B2233     120.741  69.965 129.940  1.00 71.71           O
HETATM 2878  O   HOH B2234     180.593  83.067 110.695  1.00 69.84           O
HETATM 2879  O   HOH B2235     113.775  66.702 144.159  1.00 79.49           O
HETATM 2880  O   HOH B2236     126.252  91.370 114.799  1.00 54.45           O
HETATM 2881  O   HOH B2237     115.063 100.243 138.497  1.00 71.29           O
HETATM 2882  O   HOH B2238     150.112  89.900 106.300  1.00 66.68           O
HETATM 2883  O   HOH B2239     137.059  69.018 130.835  1.00 70.07           O
HETATM 2884  O   HOH B2240     165.794 104.419 111.584  1.00 60.44           O
HETATM 2885  O   HOH B2241     153.432 101.472 114.888  1.00 63.65           O
HETATM 2886  O   HOH B2242     109.620  91.889 107.368  1.00 59.06           O
HETATM 2887  O   HOH B2243     108.211  74.372 149.873  1.00 78.71           O
HETATM 2888  O   HOH B2244     117.346  91.896 137.033  1.00 59.88           O
HETATM 2889  O   HOH B2245     151.395 100.683  99.908  1.00 68.11           O
HETATM 2890  O   HOH B2246     124.310  87.425 138.793  1.00 60.89           O
HETATM 2891  O   HOH B2247     180.420  85.833 105.345  1.00 77.96           O
HETATM 2892  O   HOH B2248     145.218  89.614 128.772  1.00 57.64           O
HETATM 2893  O   HOH B2249     147.196  69.505 106.886  1.00 76.14           O
HETATM 2894  O   HOH B2250     154.349  82.892  93.726  1.00 72.73           O
HETATM 2895  O   HOH B2251     141.697  58.965 108.427  1.00 74.66           O
HETATM 2896  O   HOH B2252      91.922  76.524 136.932  1.00 80.50           O
HETATM 2897  O   HOH B2253     155.602  80.535 108.156  1.00 63.42           O
HETATM 2898  O   HOH B2254     153.744  95.948  97.029  1.00 67.08           O
HETATM 2899  O   HOH B2255     139.105 110.840 128.816  1.00 66.70           O
HETATM 2900  O   HOH B2256     128.156  70.983 123.528  1.00 65.68           O
HETATM 2901  O   HOH B2257     131.187  58.808 103.954  1.00 72.66           O
HETATM 2902  O   HOH B2258     155.527  77.969 116.409  1.00 59.62           O
HETATM 2903  O   HOH B2259     120.834  47.461 109.330  1.00 74.12           O
HETATM 2904  O   HOH B2260     156.816  65.522 118.918  1.00 81.02           O
HETATM 2905  O   HOH B2261     159.909 100.264  99.864  1.00 62.00           O
HETATM 2906  O   HOH B2262     147.903  88.061 125.626  1.00 55.55           O
HETATM 2907  O   HOH B2263     149.809  91.789  98.539  1.00 66.36           O
HETATM 2908  O   HOH B2264     110.426  69.830 119.039  1.00 65.83           O
HETATM 2909  O   HOH B2265     158.610 103.160 131.400  1.00 62.21           O
HETATM 2910  O   HOH B2266     138.257  92.150 105.176  1.00 65.63           O
HETATM 2911  O   HOH B2267     132.451  78.448 112.135  1.00 67.37           O
HETATM 2912  O   HOH B2268     161.264 109.441 122.985  1.00 71.51           O
HETATM 2913  O   HOH B2269     150.110  94.813 121.586  1.00 54.49           O
HETATM 2914  O   HOH B2270     131.704 104.261 135.816  1.00 68.71           O
HETATM 2915  O   HOH B2271     125.988  54.045 132.463  1.00 74.90           O
HETATM 2916  O   HOH B2272      90.251  76.950 132.032  1.00 79.26           O
HETATM 2917  O   HOH B2273     139.444  79.017 116.167  1.00 63.33           O
HETATM 2918  O   HOH B2274     121.736  43.232 131.023  1.00 77.81           O
HETATM 2919  O   HOH B2275     132.579  92.223 130.694  1.00 57.47           O
HETATM 2920  O   HOH B2276     125.873  62.977  98.754  1.00 74.50           O
HETATM 2921  O   HOH B2277     105.606  57.213 133.573  1.00 75.07           O
HETATM 2922  O   HOH B2278     120.189 106.771 125.416  1.00 64.15           O
HETATM 2923  O   HOH B2279     140.206  62.187 122.955  1.00 75.59           O
HETATM 2924  O   HOH B2280     136.747 103.150 143.526  1.00 74.81           O
HETATM 2925  O   HOH B2281     139.897  65.849 129.982  1.00 72.69           O
HETATM 2926  O   HOH B2282     127.232  97.007 129.053  1.00 60.35           O
HETATM 2927  O   HOH B2283     131.140  79.179 108.935  1.00 63.93           O
HETATM 2928  O   HOH B2284     103.754  61.145 118.347  1.00 65.06           O
HETATM 2929  O   HOH B2285     118.299  76.802 127.402  1.00 61.32           O
HETATM 2930  O   HOH B2286     117.082  68.695 117.740  1.00 62.23           O
HETATM 2931  O   HOH B2287     130.707 101.379 126.605  1.00 61.16           O
HETATM 2932  O   HOH B2288     176.291  96.262 102.672  1.00 67.27           O
HETATM 2933  O   HOH B2289     109.789  69.210 116.063  1.00 67.45           O
HETATM 2934  O   HOH B2290     141.758 102.692 119.191  1.00 57.95           O
HETATM 2935  O   HOH B2291     119.783  52.096 136.471  1.00 73.33           O
HETATM 2936  O   HOH B2292     147.394  96.476 109.317  1.00 61.72           O
HETATM 2937  O   HOH B2293     119.911  65.092 115.943  1.00 60.93           O
HETATM 2938  O   HOH B2294     164.206 102.007 113.045  1.00 61.04           O
HETATM 2939  O   HOH B2295     116.780  73.740  96.368  1.00 67.28           O
HETATM 2940  O   HOH B2296     134.812  67.568 101.002  1.00 77.10           O
HETATM 2941  O   HOH B2297     155.288  77.171 108.700  1.00 64.46           O
HETATM 2942  O   HOH B2298     121.109  77.616 100.807  1.00 65.92           O
HETATM 2943  O   HOH B2299     126.846  88.545 103.003  1.00 68.77           O
HETATM 2944  O   HOH B2300     114.532  79.817 128.082  1.00 59.32           O
HETATM 2945  O   HOH B2301     115.757  42.302 116.996  1.00 77.42           O
HETATM 2946  O   HOH B2302     152.364 110.222 145.095  1.00 75.30           O
HETATM 2947  O   HOH B2303     143.606  95.818  99.761  1.00 69.83           O
HETATM 2948  O   HOH B2304     125.190  74.018  92.653  1.00 73.97           O
HETATM 2949  O   HOH B2305     107.811  63.822 130.814  1.00 69.76           O
HETATM 2950  O   HOH B2306     115.870 102.779 114.411  1.00 67.68           O
HETATM 2951  O   HOH B2307     143.942  94.393 146.015  1.00 71.70           O
HETATM 2952  O   HOH B2308     136.153  67.256 102.926  1.00 79.69           O
HETATM 2953  O   HOH B2309     141.956  97.625 110.681  1.00 61.19           O
HETATM 2954  O   HOH B2310     124.644  97.000 100.479  1.00 66.96           O
HETATM 2955  O   HOH B2311     147.907  94.618 102.190  1.00 66.24           O
HETATM 2956  O   HOH B2312     128.698  94.457 138.894  1.00 66.79           O
HETATM 2957  O   HOH B2313     167.942 101.482 115.126  1.00 62.85           O
HETATM 2958  O   HOH B2314     113.513  93.714 125.416  1.00 59.85           O
HETATM 2959  O   HOH B2315     126.321 104.326 120.318  1.00 63.15           O
HETATM 2960  O   HOH B2316     115.033  95.130 108.450  1.00 63.72           O
HETATM 2961  O   HOH B2317      81.895  80.280 117.989  1.00 77.75           O
HETATM 2962  O   HOH B2318     113.911  70.917  96.142  1.00 68.35           O
HETATM 2963  O   HOH B2319     144.074  61.833 118.958  1.00 74.77           O
HETATM 2964  O   HOH B2320     131.483  63.199 128.821  1.00 68.97           O
HETATM 2965  O   HOH B2321     145.952  85.209 117.677  1.00 61.40           O
HETATM 2966  O   HOH B2322     135.230  96.696 103.541  1.00 64.17           O
HETATM 2967  O   HOH B2323     123.230  69.520 128.194  1.00 69.06           O
HETATM 2968  O   HOH B2324      96.168  86.860 136.108  1.00 74.69           O
HETATM 2969  O   HOH B2325     139.274  85.406 144.063  1.00 72.89           O
HETATM 2970  O   HOH B2326     137.809  92.527 110.049  1.00 58.72           O
HETATM 2971  O   HOH B2327     158.791  98.204  97.174  1.00 64.93           O
HETATM 2972  O   HOH B2328     177.927  88.621  99.804  1.00 75.83           O
HETATM 2973  O   HOH B2329     113.843  70.257 130.205  1.00 70.92           O
HETATM 2974  O   HOH B2330     177.444  84.832 121.137  1.00 69.55           O
HETATM 2975  O   HOH B2331     113.625  90.712 130.728  1.00 63.91           O
HETATM 2976  O   HOH B2332     181.650  80.009 120.919  1.00 75.98           O
HETATM 2977  O   HOH B2333     125.943  67.002 110.119  1.00 64.95           O
HETATM 2978  O   HOH B2334     135.132  90.540 146.998  1.00 71.56           O
HETATM 2979  O   HOH B2335     157.818 103.026 105.587  1.00 61.34           O
HETATM 2980  O   HOH B2336     116.347  97.968 112.913  1.00 60.87           O
HETATM 2981  O   HOH B2337     112.426  93.038 127.829  1.00 63.88           O
HETATM 2982  O   HOH B2338     134.893 107.095 125.726  1.00 65.02           O
HETATM 2983  O   HOH B2339     117.029  68.975 109.491  1.00 64.04           O
HETATM 2984  O   HOH B2340     159.954 107.868 100.758  1.00 67.16           O
HETATM 2985  O   HOH B2341     136.656  76.475 135.647  1.00 68.30           O
HETATM 2986  O   HOH B2342     169.734  86.893 106.257  1.00 65.82           O
HETATM 2987  O   HOH B2343     144.721  64.459 104.996  1.00 76.41           O
HETATM 2988  O   HOH B2344     120.280  81.692 134.700  1.00 66.36           O
HETATM 2989  O   HOH B2345     113.825  62.888  99.915  1.00 69.32           O
HETATM 2990  O   HOH B2346     127.857 103.434 124.378  1.00 61.55           O
HETATM 2991  O   HOH B2347     111.387  68.078 144.342  1.00 76.57           O
HETATM 2992  O   HOH B2348     141.879 101.756 124.719  1.00 52.57           O
HETATM 2993  O   HOH B2349     118.837  75.476 115.715  1.00 60.44           O
HETATM 2994  O   HOH B2350     136.502  74.928 101.998  1.00 72.57           O
HETATM 2995  O   HOH B2351     149.828 100.525 126.239  1.00 52.47           O
HETATM 2996  O   HOH B2352     127.769  69.415 106.462  1.00 68.00           O
HETATM 2997  O   HOH B2353     121.406  90.205 105.743  1.00 60.56           O
HETATM 2998  O   HOH B2354     100.579  66.693 144.367  1.00 77.87           O
HETATM 2999  O   HOH B2355     128.032  44.320 110.122  1.00 71.64           O
HETATM 3000  O   HOH B2356     163.266  88.991  88.898  1.00 76.06           O
HETATM 3001  O   HOH B2357     127.641  64.467 111.929  1.00 64.72           O
HETATM 3002  O   HOH B2358     108.066  95.799 144.201  1.00 76.05           O
HETATM 3003  O   HOH B2359     162.335 105.679 105.257  1.00 62.76           O
HETATM 3004  O   HOH B2360     116.766  77.804  95.355  1.00 70.55           O
HETATM 3005  O   HOH B2361      96.767  71.564 126.645  1.00 79.65           O
HETATM 3006  O   HOH B2362     119.332  66.451 119.659  1.00 63.57           O
HETATM 3007  O   HOH B2363     128.254  87.215 138.996  1.00 64.77           O
HETATM 3008  O   HOH B2364     138.040  71.591 102.481  1.00 76.38           O
HETATM 3009  O   HOH B2365     155.458  99.200 109.495  1.00 61.10           O
HETATM 3010  O   HOH B2366     114.539  72.502 126.706  1.00 68.75           O
HETATM 3011  O   HOH B2367     157.211  79.634 124.465  1.00 66.53           O
HETATM 3012  O   HOH B2368     113.794  89.621 126.185  1.00 59.70           O
HETATM 3013  O   HOH B2369     111.929  71.070 104.800  1.00 63.99           O
HETATM 3014  O   HOH B2370     111.426  42.269 121.802  1.00 78.85           O
HETATM 3015  O   HOH B2371     109.562  60.868 140.406  1.00 75.92           O
HETATM 3016  O   HOH B2372     145.144  81.294 116.433  1.00 63.82           O
HETATM 3017  O   HOH B2373     138.580  52.885 119.045  1.00 73.99           O
HETATM 3018  O   HOH B2374     155.505  97.563  94.833  1.00 68.08           O
HETATM 3019  O   HOH B2375     138.290  90.403 101.565  1.00 72.38           O
HETATM 3020  O   HOH B2376     104.880  86.747 128.978  1.00 72.24           O
HETATM 3021  O   HOH B2377     109.145  92.008 149.928  1.00 79.66           O
HETATM 3022  O   HOH B2378     118.239  86.451 143.032  1.00 72.57           O
HETATM 3023  O   HOH B2379     138.390  98.297 131.605  1.00 53.74           O
HETATM 3024  O   HOH B2380     160.658 104.690 131.053  1.00 68.97           O
HETATM 3025  O   HOH B2381     132.681 107.059 122.463  1.00 65.19           O
HETATM 3026  O   HOH B2382     118.554  83.898 140.637  1.00 69.16           O
HETATM 3027  O   HOH B2383     116.493  86.468  97.600  1.00 66.75           O
HETATM 3028  O   HOH B2384     148.559  85.641 110.746  1.00 65.13           O
HETATM 3029  O   HOH B2385     108.939  74.408 116.889  1.00 63.66           O
HETATM 3030  O   HOH B2386     139.250 110.294 144.353  1.00 75.39           O
HETATM 3031  O   HOH B2387     150.311  82.839 126.905  1.00 66.38           O
HETATM 3032  O   HOH B2388      87.341  80.651 125.780  1.00 75.83           O
HETATM 3033  O   HOH B2389     137.828 101.748  99.167  1.00 72.69           O
HETATM 3034  O   HOH B2390     172.760  85.749 109.110  1.00 66.50           O
HETATM 3035  O   HOH B2391     146.592  79.162 112.432  1.00 70.09           O
HETATM 3036  O   HOH B2392     150.342  80.718 112.786  1.00 66.07           O
HETATM 3037  O   HOH B2393     100.073  89.747 141.480  1.00 78.54           O
HETATM 3038  O   HOH B2394      85.196  89.897 114.487  1.00 72.41           O
HETATM 3039  O   HOH B2395     129.622  80.088 122.697  1.00 58.60           O
HETATM 3040  O   HOH B2396     134.793  92.851 131.678  1.00 56.30           O
HETATM 3041  O   HOH B2397     160.333 103.344 121.849  1.00 63.72           O
HETATM 3042  O   HOH B2398     126.292  94.177 100.812  1.00 66.12           O
HETATM 3043  O   HOH B2399     166.017  97.386  90.094  1.00 73.92           O
HETATM 3044  O   HOH B2400     137.583  78.297 114.897  1.00 64.60           O
HETATM 3045  O   HOH B2401     122.408  96.673 135.449  1.00 58.97           O
HETATM 3046  O   HOH B2402     129.750  69.869 133.393  1.00 74.53           O
HETATM 3047  O   HOH B2403     114.754  81.046  94.154  1.00 71.32           O
HETATM 3048  O   HOH B2404     178.264  94.411 105.550  1.00 67.96           O
HETATM 3049  O   HOH B2405     102.415  59.783 128.488  1.00 71.84           O
HETATM 3050  O   HOH B2406     100.013  84.700 145.027  1.00 74.85           O
HETATM 3051  O   HOH B2407     148.935  63.243 110.802  1.00 75.18           O
HETATM 3052  O   HOH B2408     119.306  66.091 128.884  1.00 64.22           O
HETATM 3053  O   HOH B2409     149.777  70.673 122.107  1.00 67.45           O
HETATM 3054  O   HOH B2410     114.067  78.825  94.752  1.00 70.33           O
HETATM 3055  O   HOH B2411     134.397  87.026 144.718  1.00 72.65           O
HETATM 3056  O   HOH B2412     113.322  94.451 120.811  1.00 57.93           O
HETATM 3057  O   HOH B2413     166.395  88.401 102.918  1.00 65.03           O
HETATM 3058  O   HOH B2414     139.251  92.407  99.908  1.00 73.78           O
HETATM 3059  O   HOH B2415     113.758  94.600 144.077  1.00 71.50           O
HETATM 3060  O   HOH B2416      83.654  79.275 121.123  1.00 74.90           O
HETATM 3061  O   HOH B2417     125.862  46.018 128.925  1.00 74.83           O
HETATM 3062  O   HOH B2418     110.597  86.510 125.073  1.00 63.31           O
HETATM 3063  O   HOH B2419     109.946  87.466 151.686  1.00 78.40           O
HETATM 3064  O   HOH B2420     143.326 115.535 141.506  1.00 82.89           O
HETATM 3065  O   HOH B2421     124.533  87.196 112.823  1.00 59.82           O
HETATM 3066  O   HOH B2422     189.258  97.276  99.739  1.00 78.91           O
HETATM 3067  O   HOH B2423     121.215  45.196 105.243  1.00 79.49           O
HETATM 3068  O   HOH B2424     134.432  63.274 123.092  1.00 68.34           O
HETATM 3069  O   HOH B2425     132.382  47.928 112.062  1.00 66.71           O
HETATM 3070  O   HOH B2426     146.685  74.216 123.259  1.00 66.00           O
HETATM 3071  O   HOH B2427     130.257  98.513 114.578  1.00 52.02           O
HETATM 3072  O   HOH B2428     161.477 101.075 116.424  1.00 61.91           O
HETATM 3073  O   HOH B2429     133.098  48.988 119.070  1.00 74.33           O
HETATM 3074  O   HOH B2430     103.372  89.912 118.248  1.00 66.88           O
HETATM 3075  O   HOH B2431     129.250 103.459  96.200  1.00 66.25           O
HETATM 3076  O   HOH B2432     127.930 102.583 121.251  1.00 59.12           O
HETATM 3077  O   HOH B2433     133.832  95.369 133.282  1.00 62.63           O
HETATM 3078  O   HOH B2434     123.459  54.214 103.726  1.00 72.26           O
HETATM 3079  O   HOH B2435     158.735  72.276 119.625  1.00 71.20           O
HETATM 3080  O   HOH B2436     115.523  76.242 135.500  1.00 76.64           O
HETATM 3081  O   HOH B2437     167.631  96.012  88.313  1.00 73.07           O
HETATM 3082  O   HOH B2438     151.030  83.237 111.942  1.00 66.19           O
HETATM 3083  O   HOH B2439     145.427  87.101 103.821  1.00 70.85           O
HETATM 3084  O   HOH B2440     123.109 104.223 134.258  1.00 70.29           O
HETATM 3085  O   HOH B2441     123.102  47.821 126.883  1.00 71.24           O
HETATM 3086  O   HOH B2442     129.557  96.099 129.422  1.00 59.51           O
HETATM 3087  O   HOH B2443     105.204  80.493 143.013  1.00 73.69           O
HETATM 3088  O   HOH B2444     137.708 107.429 118.660  1.00 59.60           O
HETATM 3089  O   HOH B2445     118.705  73.698 137.400  1.00 78.53           O
HETATM 3090  O   HOH B2446     118.029 105.029 130.828  1.00 64.65           O
HETATM 3091  O   HOH B2447      96.970  83.550 128.446  1.00 74.95           O
HETATM 3092  O   HOH B2448     175.297 103.438 105.461  1.00 61.18           O
HETATM 3093  O   HOH B2449     139.890 103.757 120.830  1.00 58.01           O
HETATM 3094  O   HOH B2450     138.987  93.511 132.879  1.00 56.49           O
HETATM 3095  O   HOH B2451     141.590 104.294 122.895  1.00 61.66           O
HETATM 3096  O   HOH B2452     130.193  92.140 135.379  1.00 63.60           O
HETATM 3097  O   HOH B2453     178.709 103.640 111.568  1.00 65.48           O
HETATM 3098  O   HOH B2454     111.073 100.320 145.693  1.00 79.63           O
HETATM 3099  O   HOH B2455     128.686  78.446 119.652  1.00 61.71           O
HETATM 3100  O   HOH B2456     132.572  63.862  97.623  1.00 75.53           O
HETATM 3101  O   HOH B2457     160.438  84.860 114.662  1.00 61.39           O
HETATM 3102  O   HOH B2458     113.566  58.150 141.414  1.00 82.59           O
HETATM 3103  O   HOH B2459      93.691  83.265 126.076  1.00 79.06           O
HETATM 3104  O   HOH B2460     118.989 102.706 132.742  1.00 63.50           O
HETATM 3105  O   HOH B2461     131.709 111.329 137.616  1.00 71.20           O
HETATM 3106  O   HOH B2462     145.126 108.704 125.379  1.00 65.20           O
HETATM 3107  O   HOH B2463     155.599  89.421  92.709  1.00 71.03           O
HETATM 3108  O   HOH B2464     129.078  76.283 125.638  1.00 62.85           O
HETATM 3109  O   HOH B2465     172.883  90.263 130.115  1.00 65.83           O
HETATM 3110  O   HOH B2466     164.367  83.738 113.798  1.00 64.61           O
HETATM 3111  O   HOH B2467     148.966  90.631  93.205  1.00 76.36           O
HETATM 3112  O   HOH B2468     121.154 107.206 105.316  1.00 64.65           O
HETATM 3113  O   HOH B2469     163.011  84.501 106.136  1.00 66.71           O
HETATM 3114  O   HOH B2470     111.844  67.790 121.777  1.00 63.72           O
HETATM 3115  O   HOH B2471     179.027 102.326  99.771  1.00 70.32           O
HETATM 3116  O   HOH B2472     125.273  49.452 121.298  1.00 68.28           O
HETATM 3117  O   HOH B2473     109.813  64.467  97.644  1.00 65.94           O
HETATM 3118  O   HOH B2474     155.896  95.775 103.335  1.00 58.70           O
HETATM 3119  O   HOH B2475     138.944 107.161 123.421  1.00 65.06           O
HETATM 3120  O   HOH B2476     100.353  62.627 137.894  1.00 79.45           O
HETATM 3121  O   HOH B2477     139.679  73.855 100.260  1.00 80.79           O
HETATM 3122  O   HOH B2478     108.568  88.902 124.032  1.00 62.99           O
HETATM 3123  O   HOH B2479     131.010  87.074 103.958  1.00 71.39           O
HETATM 3124  O   HOH B2480     161.442  71.065 109.947  1.00 71.53           O
HETATM 3125  O   HOH B2481     114.790 105.115 137.886  1.00 78.13           O
HETATM 3126  O   HOH B2482     148.476  88.060 102.008  1.00 68.57           O
HETATM 3127  O   HOH B2483     142.367 105.949 126.416  1.00 61.54           O
HETATM 3128  O   HOH B2484     122.249  97.466 140.302  1.00 64.87           O
HETATM 3129  O   HOH B2485     117.056  96.154 103.396  1.00 64.62           O
HETATM 3130  O   HOH B2486     162.569  71.321 111.973  1.00 68.32           O
HETATM 3131  O   HOH B2487     106.783  74.757 102.442  1.00 62.53           O
HETATM 3132  O   HOH B2488     121.061  67.420 111.876  1.00 62.99           O
HETATM 3133  O   HOH B2489     151.815  70.941 119.331  1.00 67.82           O
HETATM 3134  O   HOH B2490     116.143  81.913 132.663  1.00 65.76           O
HETATM 3135  O   HOH B2491     106.466  54.583 118.205  1.00 69.27           O
HETATM 3136  O   HOH B2492     142.232  76.312 102.747  1.00 78.10           O
HETATM 3137  O   HOH B2493     169.628  88.417 102.407  1.00 68.85           O
HETATM 3138  O   HOH B2494     105.649  62.888 114.788  1.00 65.10           O
HETATM 3139  O   HOH B2495     186.055 102.585 104.876  1.00 72.76           O
HETATM 3140  O   HOH B2496     140.365 112.958 141.643  1.00 77.72           O
HETATM 3141  O   HOH B2497     105.182  69.174 128.505  1.00 71.90           O
HETATM 3142  O   HOH B2498     131.965  96.702 141.536  1.00 72.41           O
HETATM 3143  O   HOH B2499     184.509  81.876 112.203  1.00 71.17           O
HETATM 3144  O   HOH B2500     158.687 102.640  96.900  1.00 66.44           O
HETATM 3145  O   HOH B2501     122.307  64.164 123.740  1.00 63.11           O
HETATM 3146  O   HOH B2502     106.476  50.535 115.196  1.00 72.84           O
HETATM 3147  O   HOH B2503     123.686  68.711  93.378  1.00 78.17           O
HETATM 3148  O   HOH B2504     141.102  72.984 127.092  1.00 68.74           O
HETATM 3149  O   HOH B2505     121.175  98.134 133.748  1.00 56.75           O
HETATM 3150  O   HOH B2506     135.192  69.353 127.833  1.00 72.31           O
HETATM 3151  O   HOH B2507     144.413  94.621 109.237  1.00 63.31           O
HETATM 3152  O   HOH B2508     159.997  90.287 101.746  1.00 60.77           O
HETATM 3153  O   HOH B2509     148.766  74.977 124.090  1.00 68.08           O
HETATM 3154  O   HOH B2510      87.650  76.538 141.841  1.00 85.22           O
HETATM 3155  O   HOH B2511     146.930  88.779  91.214  1.00 81.61           O
HETATM 3156  O   HOH B2512     171.635 102.159  99.831  1.00 63.90           O
HETATM 3157  O   HOH B2513      90.562  76.861 125.067  1.00 74.05           O
HETATM 3158  O   HOH B2514     133.625  93.049 144.081  1.00 69.03           O
HETATM 3159  O   HOH B2515     128.669  68.930 108.546  1.00 68.25           O
HETATM 3160  O   HOH B2516     172.126  75.207 114.372  1.00 68.72           O
HETATM 3161  O   HOH B2517     120.861  81.036 107.899  1.00 60.47           O
HETATM 3162  O   HOH B2518     155.942  79.146 102.238  1.00 69.76           O
HETATM 3163  O   HOH B2519     139.902 104.045 101.528  1.00 70.16           O
HETATM 3164  O   HOH B2520     148.622  86.586 118.631  1.00 59.05           O
HETATM 3165  O   HOH B2521     120.919  61.879 138.065  1.00 70.70           O
HETATM 3166  O   HOH B2522     112.443  44.361 118.230  1.00 77.72           O
HETATM 3167  O   HOH B2523     118.435  80.035 143.186  1.00 74.11           O
HETATM 3168  O   HOH B2524     173.647  75.545 121.224  1.00 71.54           O
HETATM 3169  O   HOH B2525     102.363  70.654 148.564  1.00 77.89           O
HETATM 3170  O   HOH B2526     103.967  87.828 120.978  1.00 65.22           O
HETATM 3171  O   HOH B2527     174.421  92.682 128.295  1.00 66.17           O
HETATM 3172  O   HOH B2528     108.929  78.609 125.287  1.00 68.63           O
HETATM 3173  O   HOH B2529     169.015 104.147 122.035  1.00 64.69           O
HETATM 3174  O   HOH B2530     121.836  84.952  98.307  1.00 69.51           O
HETATM 3175  O   HOH B2531     131.600  54.514 106.226  1.00 70.69           O
HETATM 3176  O   HOH B2532     109.923  84.953 126.855  1.00 66.12           O
HETATM 3177  O   HOH B2533     131.350  94.689 136.121  1.00 67.59           O
HETATM 3178  O   HOH B2534     159.363 107.387 121.761  1.00 70.94           O
HETATM 3179  O   HOH B2535     156.857 114.084 124.732  1.00 72.62           O
HETATM 3180  O   HOH B2536     136.060  79.478 118.995  1.00 57.07           O
HETATM 3181  O   HOH B2537     141.845  88.030 137.828  1.00 66.25           O
HETATM 3182  O   HOH B2538     119.461  98.604 138.446  1.00 63.81           O
HETATM 3183  O   HOH B2539     106.230  53.443 103.230  1.00 67.70           O
HETATM 3184  O   HOH B2540     131.216 113.733 134.168  1.00 74.39           O
HETATM 3185  O   HOH B2541     123.106  43.762 108.299  1.00 79.34           O
HETATM 3186  O   HOH B2542     155.280  78.726 105.887  1.00 68.05           O
HETATM 3187  O   HOH B2543     181.692 103.644 117.284  1.00 72.11           O
HETATM 3188  O   HOH B2544     108.093  72.776 119.212  1.00 68.20           O
HETATM 3189  O   HOH B2545     115.485  70.691 110.936  1.00 64.34           O
HETATM 3190  O   HOH B2546     160.712 111.220 119.686  1.00 71.66           O
HETATM 3191  O   HOH B2547     136.637  90.134 103.237  1.00 73.39           O
HETATM 3192  O   HOH B2548     119.583 106.229 111.902  1.00 63.06           O
HETATM 3193  O   HOH B2549     154.978  65.665 120.406  1.00 82.91           O
HETATM 3194  O   HOH B2550     116.663  76.591 137.508  1.00 75.63           O
HETATM 3195  O   HOH B2551     139.955  85.043  98.911  1.00 77.66           O
HETATM 3196  O   HOH B2552     157.031  74.741 119.951  1.00 68.14           O
HETATM 3197  O   HOH B2553     121.182  39.997 113.648  1.00 73.13           O
HETATM 3198  O   HOH B2554     111.259  59.481 104.701  1.00 68.47           O
HETATM 3199  O   HOH B2555     109.786  69.142 102.159  1.00 69.55           O
HETATM 3200  O   HOH B2556     106.263  73.123 148.280  1.00 78.78           O
HETATM 3201  O   HOH B2557     169.831 102.859 126.778  1.00 65.19           O
HETATM 3202  O   HOH B2558     151.456  83.049 124.196  1.00 66.82           O
HETATM 3203  O   HOH B2559     152.094  86.437  92.744  1.00 80.12           O
HETATM 3204  O   HOH B2560     102.514  65.712 141.614  1.00 77.81           O
HETATM 3205  O   HOH B2561     107.078  69.226 125.589  1.00 67.25           O
HETATM 3206  O   HOH B2562     128.291  68.619 125.970  1.00 66.57           O
HETATM 3207  O   HOH B2563     113.836  59.439 101.830  1.00 69.98           O
HETATM 3208  O   HOH B2564     167.726 106.011 123.681  1.00 63.88           O
HETATM 3209  O   HOH B2565     146.166  99.019 110.179  1.00 64.39           O
HETATM 3210  O   HOH B2566     138.672 109.473 112.290  1.00 67.16           O
HETATM 3211  O   HOH B2567     162.926  96.124  86.749  1.00 76.17           O
HETATM 3212  O   HOH B2568     103.898  79.976 115.693  1.00 62.42           O
HETATM 3213  O   HOH B2569     141.496  64.843 120.529  1.00 71.71           O
HETATM 3214  O   HOH B2570     110.982  94.778 109.621  1.00 63.21           O
HETATM 3215  O   HOH B2571     156.540 101.431  95.313  1.00 70.15           O
HETATM 3216  O   HOH B2572     139.720  81.321 133.469  1.00 62.63           O
HETATM 3217  O   HOH B2573      89.057  83.014 131.148  1.00 80.66           O
HETATM 3218  O   HOH B2574     147.544  74.505 121.138  1.00 66.57           O
HETATM 3219  O   HOH B2575     140.058  97.864 108.665  1.00 61.14           O
HETATM 3220  O   HOH B2576     166.395  77.534 124.780  1.00 71.59           O
HETATM 3221  O   HOH B2577     143.664  89.803 132.078  1.00 57.27           O
HETATM 3222  O   HOH B2578     155.343  83.147 124.652  1.00 64.49           O
HETATM 3223  O   HOH B2579     160.950  82.383 116.535  1.00 64.13           O
HETATM 3224  O   HOH B2580     113.221  72.268 124.174  1.00 66.22           O
HETATM 3225  O   HOH B2581     139.049  90.823 147.722  1.00 68.05           O
HETATM 3226  O   HOH B2582     120.898  40.950 110.944  1.00 78.35           O
HETATM 3227  O   HOH B2583     109.638  98.069 128.342  1.00 70.68           O
HETATM 3228  O   HOH B2584     120.839  43.322 109.484  1.00 77.74           O
HETATM 3229  O   HOH B2585     145.696  75.667 119.940  1.00 64.67           O
HETATM 3230  O   HOH B2586     126.020  72.206 113.585  1.00 64.02           O
HETATM 3231  O   HOH B2587     123.746  94.700 142.743  1.00 67.44           O
HETATM 3232  O   HOH B2588     146.027  97.365 116.808  1.00 55.86           O
HETATM 3233  O   HOH B2589     119.495  78.177 137.033  1.00 72.65           O
HETATM 3234  O   HOH B2590     127.113 101.185 140.614  1.00 71.92           O
HETATM 3235  O   HOH B2591     123.017  56.892 104.042  1.00 69.58           O
HETATM 3236  O   HOH B2592     121.737  88.970 141.419  1.00 63.30           O
HETATM 3237  O   HOH B2593     130.430  64.828 111.035  1.00 68.40           O
HETATM 3238  O   HOH B2594     108.690  72.419 115.537  1.00 65.97           O
HETATM 3239  O   HOH B2595     130.345  68.396 113.957  1.00 64.81           O
HETATM 3240  O   HOH B2596     140.497  99.981 106.572  1.00 65.07           O
HETATM 3241  O   HOH B2597     154.556  94.506  93.199  1.00 68.30           O
HETATM 3242  O   HOH B2598     111.035  91.125 128.190  1.00 68.20           O
HETATM 3243  O   HOH B2599     113.631  77.184 133.102  1.00 72.91           O
HETATM 3244  O   HOH B2600     129.701  67.734  95.120  1.00 74.63           O
HETATM 3245  O   HOH B2601     186.419  83.699 102.137  1.00 82.45           O
HETATM 3246  O   HOH B2602     148.868 108.873 145.971  1.00 77.65           O
HETATM 3247  O   HOH B2603     147.699  90.459 104.556  1.00 69.80           O
HETATM 3248  O   HOH B2604     106.771  57.185 120.425  1.00 64.66           O
HETATM 3249  O   HOH B2605     109.915  53.115 100.497  1.00 73.07           O
HETATM 3250  O   HOH B2606     164.863  84.857 115.989  1.00 63.09           O
HETATM 3251  O   HOH B2607     125.054  73.446  95.095  1.00 73.04           O
HETATM 3252  O   HOH B2608     122.225  64.840 132.172  1.00 71.64           O
HETATM 3253  O   HOH B2609     105.241  90.745 113.229  1.00 59.99           O
HETATM 3254  O   HOH B2610     101.730  59.305 130.808  1.00 74.17           O
HETATM 3255  O   HOH B2611     107.805  93.024 116.569  1.00 63.99           O
HETATM 3256  O   HOH B2612     114.359  95.372 116.698  1.00 63.94           O
HETATM 3257  O   HOH B2613     137.497  85.745 142.157  1.00 69.56           O
HETATM 3258  O   HOH B2614     115.310  52.164 101.052  1.00 72.22           O
HETATM 3259  O   HOH B2615     124.630  49.507 129.375  1.00 71.42           O
HETATM 3260  O   HOH B2616     147.298 112.876 142.663  1.00 84.18           O
HETATM 3261  O   HOH B2617     161.992  89.944  90.630  1.00 72.24           O
HETATM 3262  O   HOH B2618     112.971 104.789 116.127  1.00 71.65           O
HETATM 3263  O   HOH B2619     149.518 102.921 126.147  1.00 56.77           O
HETATM 3264  O   HOH B2620     136.288  62.894 100.742  1.00 78.85           O
HETATM 3265  O   HOH B2621     116.414  99.924 125.987  1.00 60.29           O
HETATM 3266  O   HOH B2622     118.360 106.326 120.266  1.00 65.14           O
HETATM 3267  O   HOH B2623     103.974  79.961 127.646  1.00 72.51           O
HETATM 3268  O   HOH B2624     132.245 107.384 127.528  1.00 70.48           O
HETATM 3269  O   HOH B2625     132.852  48.828 116.706  1.00 72.35           O
HETATM 3270  O   HOH B2626     105.032  91.637 117.313  1.00 64.88           O
HETATM 3271  O   HOH B2627     144.664  71.383 102.762  1.00 78.31           O
HETATM 3272  O   HOH B2628     194.830 100.588 112.840  1.00 79.75           O
HETATM 3273  O   HOH B2629     153.340 103.212 124.983  1.00 63.21           O
HETATM 3274  O   HOH B2630     112.010 101.574 119.286  1.00 69.95           O
HETATM 3275  O   HOH B2631     167.127  85.213 100.220  1.00 70.95           O
HETATM 3276  O   HOH B2632     133.214  73.855  97.240  1.00 75.27           O
HETATM 3277  O   HOH B2633     136.874  77.830 112.633  1.00 65.69           O
HETATM 3278  O   HOH B2634     135.999  53.110 122.902  1.00 74.40           O
HETATM 3279  O   HOH B2635     116.015  48.839 122.772  1.00 67.51           O
HETATM 3280  O   HOH B2636     151.988  70.804 116.795  1.00 66.23           O
HETATM 3281  O   HOH B2637     160.639  92.197  91.647  1.00 69.79           O
HETATM 3282  O   HOH B2638     125.453  47.002 122.092  1.00 76.14           O
HETATM 3283  O   HOH B2639     129.744  61.384 131.341  1.00 68.93           O
HETATM 3284  O   HOH B2640     152.753 109.718 124.108  1.00 65.25           O
HETATM 3285  O   HOH B2641     109.042  45.911 124.647  1.00 75.14           O
HETATM 3286  O   HOH B2642     114.075  46.286 103.891  1.00 79.99           O
HETATM 3287  O   HOH B2643     130.165 106.177 119.839  1.00 59.42           O
HETATM 3288  O   HOH B2644     160.787  84.546 118.398  1.00 61.35           O
HETATM 3289  O   HOH B2645     125.800  75.907 137.891  1.00 71.80           O
HETATM 3290  O   HOH B2646     119.009  66.396 138.667  1.00 77.37           O
HETATM 3291  O   HOH B2647     134.274  64.177 127.946  1.00 72.04           O
HETATM 3292  O   HOH B2648      97.261  87.002 143.437  1.00 76.53           O
HETATM 3293  O   HOH B2649     135.808  88.408 101.853  1.00 75.50           O
HETATM 3294  O   HOH B2650     115.851  58.439 100.035  1.00 70.89           O
HETATM 3295  O   HOH B2651     159.063  88.001 103.245  1.00 63.19           O
HETATM 3296  O   HOH B2652     143.621  81.456  93.108  1.00 85.83           O
HETATM 3297  O   HOH B2653     130.870  61.895  99.556  1.00 74.94           O
HETATM 3298  O   HOH B2654     146.981  80.540 105.902  1.00 73.62           O
HETATM 3299  O   HOH B2655     159.914  91.867 133.249  1.00 62.29           O
HETATM 3300  O   HOH B2656     166.937  81.760 108.217  1.00 68.16           O
HETATM 3301  O   HOH B2657      84.601  80.050 124.191  1.00 75.87           O
HETATM 3302  O   HOH B2658     159.764 109.507 118.453  1.00 70.93           O
HETATM 3303  O   HOH B2659     145.240  96.347 102.392  1.00 69.83           O
HETATM 3304  O   HOH B2660     153.582  91.817  92.767  1.00 73.46           O
HETATM 3305  O   HOH B2661     110.060  73.939  95.295  1.00 68.27           O
HETATM 3306  O   HOH B2662     128.547  98.647 126.412  1.00 57.80           O
HETATM 3307  O   HOH B2663     155.011  67.629 121.683  1.00 81.03           O
HETATM 3308  O   HOH B2664     117.036  80.011 134.212  1.00 71.98           O
HETATM 3309  O   HOH B2665     150.507  76.836 123.857  1.00 65.88           O
HETATM 3310  O   HOH B2666     173.246 101.855 127.586  1.00 65.98           O
HETATM 3311  O   HOH B2667     164.232  79.908 128.527  1.00 68.72           O
HETATM 3312  O   HOH B2668     142.183  93.588 112.731  1.00 59.90           O
HETATM 3313  O   HOH B2669     147.780 116.485 143.207  1.00 86.44           O
HETATM 3314  O   HOH B2670     155.457 112.509 122.290  1.00 70.57           O
HETATM 3315  O   HOH B2671     158.581  99.515 111.314  1.00 61.63           O
HETATM 3316  O   HOH B2672     136.300  95.358 133.524  1.00 63.25           O
HETATM 3317  O   HOH B2673     147.401  91.962 138.066  1.00 68.54           O
HETATM 3318  O   HOH B2674     162.982 110.100 142.166  1.00 76.57           O
HETATM 3319  O   HOH B2675     156.950  70.140 108.152  1.00 69.91           O
HETATM 3320  O   HOH B2676     145.954 112.047 125.627  1.00 70.82           O
HETATM 3321  O   HOH B2677     156.382 109.239 144.420  1.00 71.31           O
HETATM 3322  O   HOH B2678     152.092 112.891 125.374  1.00 68.27           O
HETATM 3323  O   HOH B2679     154.353  87.296 124.016  1.00 59.33           O
HETATM 3324  O   HOH B2680     133.965  62.806 126.033  1.00 70.36           O
HETATM 3325  O   HOH B2681     104.248  75.825 147.853  1.00 76.24           O
HETATM 3326  O   HOH B2682     133.161  61.713 103.644  1.00 74.13           O
HETATM 3327  O   HOH B2683     123.454  41.447 119.561  1.00 76.70           O
HETATM 3328  O   HOH B2684     132.189  59.812 106.153  1.00 68.85           O
HETATM 3329  O   HOH B2685     167.741  79.511 127.160  1.00 70.20           O
HETATM 3330  O   HOH B2686     181.469  79.602 116.530  1.00 71.96           O
HETATM 3331  O   HOH B2687     181.419  85.519  98.009  1.00 82.23           O
HETATM 3332  O   HOH B2688     141.479  72.324 100.167  1.00 82.88           O
HETATM 3333  O   HOH B2689     136.203  60.264 108.176  1.00 73.36           O
HETATM 3334  O   HOH B2690     129.694  88.743 137.858  1.00 64.47           O
HETATM 3335  O   HOH B2691     146.951  93.115 131.705  1.00 58.36           O
HETATM 3336  O   HOH B2692     149.518  99.459 116.683  1.00 59.26           O
HETATM 3337  O   HOH B2693     104.594  67.694 123.132  1.00 67.09           O
HETATM 3338  O   HOH B2694     139.800  84.545 138.704  1.00 68.18           O
HETATM 3339  O   HOH B2695     150.097  92.269 121.219  1.00 58.15           O
HETATM 3340  O   HOH B2696     161.379  79.222 131.191  1.00 71.05           O
HETATM 3341  O   HOH B2697     133.715  82.057 139.917  1.00 69.89           O
HETATM 3342  O   HOH B2698     168.870  77.402 109.685  1.00 69.10           O
HETATM 3343  O   HOH B2699     138.071  57.475 108.748  1.00 73.21           O
HETATM 3344  O   HOH B2700     107.855  86.492 126.709  1.00 69.37           O
HETATM 3345  O   HOH B2701     156.225 104.066 103.778  1.00 63.80           O
HETATM 3346  O   HOH B2702     166.698  83.864 111.056  1.00 63.18           O
HETATM 3347  O   HOH B2703     181.000  95.246 119.403  1.00 71.11           O
HETATM 3348  O   HOH B2704     104.920  56.884 125.438  1.00 64.90           O
HETATM 3349  O   HOH B2705     132.076 110.069 119.846  1.00 62.72           O
HETATM 3350  O   HOH B2706     136.019  55.122 124.409  1.00 73.40           O
HETATM 3351  O   HOH B2707     113.500  96.939 118.713  1.00 63.68           O
HETATM 3352  O   HOH B2708     168.576  80.071 108.155  1.00 70.39           O
HETATM 3353  O   HOH B2709     164.455 105.851 107.107  1.00 59.03           O
HETATM 3354  O   HOH B2710     155.350 101.469 107.409  1.00 65.27           O
HETATM 3355  O   HOH B2711      93.917  68.401 146.608  1.00 83.14           O
HETATM 3356  O   HOH B2712     154.870 112.064 118.351  1.00 70.51           O
HETATM 3357  O   HOH B2713     157.759  68.295 120.413  1.00 75.77           O
HETATM 3358  O   HOH B2714     105.316  64.094 143.695  1.00 80.30           O
HETATM 3359  O   HOH B2715     137.205 101.500 145.384  1.00 78.17           O
HETATM 3360  O   HOH B2716     184.924  79.462 120.558  1.00 77.83           O
HETATM 3361  O   HOH B2717     183.176  89.388  96.038  1.00 82.92           O
HETATM 3362  O   HOH B2718     103.907  62.129 139.355  1.00 76.41           O
HETATM 3363  O   HOH B2719     157.180  76.263 103.104  1.00 71.12           O
HETATM 3364  O   HOH B2720     161.117  67.349 112.907  1.00 68.96           O
HETATM 3365  O   HOH B2721     103.394  68.165 147.047  1.00 81.25           O
HETATM 3366  O   HOH B2722     135.558  64.680 103.100  1.00 77.39           O
HETATM 3367  O   HOH B2723     165.319  84.561 102.616  1.00 66.53           O
HETATM 3368  O   HOH B2724     159.172 101.473 135.548  1.00 69.69           O
HETATM 3369  O   HOH B2725     164.563  71.330 120.858  1.00 69.39           O
HETATM 3370  O   HOH B2726     186.136  85.511 107.080  1.00 73.11           O
HETATM 3371  O   HOH B2727     104.453  84.672 122.166  1.00 66.72           O
HETATM 3372  O   HOH B2728     125.477  64.125 135.228  1.00 78.17           O
HETATM 3373  O   HOH B2729     145.120 101.029 103.508  1.00 71.58           O
HETATM 3374  O   HOH B2730     132.399  82.383 100.293  1.00 73.35           O
HETATM 3375  O   HOH B2731     149.822 107.808 123.978  1.00 71.63           O
HETATM 3376  O   HOH B2732     117.493 100.774 107.092  1.00 65.20           O
HETATM 3377  O   HOH B2733     137.528  62.947 104.383  1.00 78.53           O
HETATM 3378  O   HOH B2734     134.309 112.734 139.245  1.00 74.72           O
HETATM 3379  O   HOH B2735     133.058  73.894 117.026  1.00 63.87           O
HETATM 3380  O   HOH B2736     160.398 101.656 112.341  1.00 62.00           O
HETATM 3381  O   HOH B2737     108.220  47.303 126.449  1.00 73.13           O
HETATM 3382  O   HOH B2738     112.533  87.395 128.108  1.00 64.77           O
HETATM 3383  O   HOH B2739     108.319  68.639 111.322  1.00 69.69           O
HETATM 3384  O   HOH B2740     131.120 110.324 127.892  1.00 73.94           O
HETATM 3385  O   HOH B2741     170.174  89.566 129.677  1.00 66.30           O
HETATM 3386  O   HOH B2742     147.949  78.886 117.259  1.00 63.79           O
HETATM 3387  O   HOH B2743     120.912  91.180 142.539  1.00 65.52           O
HETATM 3388  O   HOH B2744      95.200  85.396 131.279  1.00 76.86           O
HETATM 3389  O   HOH B2745     175.900  78.566 125.032  1.00 75.63           O
HETATM 3390  O   HOH B2746     120.230  47.787 135.084  1.00 76.73           O
HETATM 3391  O   HOH B2747     163.251  80.163 121.495  1.00 65.68           O
HETATM 3392  O   HOH B2748     135.268  48.331 126.602  1.00 75.79           O
HETATM 3393  O   HOH B2749     129.375  96.261  94.378  1.00 77.41           O
HETATM 3394  O   HOH B2750     140.597  92.774 148.614  1.00 71.47           O
HETATM 3395  O   HOH B2751     103.030  91.243 144.352  1.00 77.28           O
HETATM 3396  O   HOH B2752     167.617 103.892 113.745  1.00 62.51           O
HETATM 3397  O   HOH B2753      97.652  89.089 137.128  1.00 79.39           O
HETATM 3398  O   HOH B2754     150.439  60.735 114.903  1.00 81.14           O
HETATM 3399  O   HOH B2755      96.900  67.853 126.867  1.00 80.74           O
HETATM 3400  O   HOH B2756     142.866  69.413 100.842  1.00 78.54           O
HETATM 3401  O   HOH B2757     161.517  83.643  96.417  1.00 69.77           O
HETATM 3402  O   HOH B2758     152.984 115.237 127.474  1.00 77.05           O
HETATM 3403  O   HOH B2759     116.374 106.602 112.655  1.00 68.04           O
HETATM 3404  O   HOH B2760     135.262  72.027 116.693  1.00 66.75           O
HETATM 3405  O   HOH B2761     162.009  82.342 105.622  1.00 66.27           O
HETATM 3406  O   HOH B2762     149.521  74.007 105.976  1.00 73.74           O
HETATM 3407  O   HOH B2763     116.746  99.482 142.189  1.00 75.77           O
HETATM 3408  O   HOH B2764     142.757  59.341 111.993  1.00 72.63           O
HETATM 3409  O   HOH B2765     174.736 105.614 101.738  1.00 63.97           O
HETATM 3410  O   HOH B2766     150.026 107.080 146.852  1.00 78.42           O
HETATM 3411  O   HOH B2767     104.591  93.088 144.725  1.00 79.95           O
HETATM 3412  O   HOH B2768     145.497  89.932 139.992  1.00 68.80           O
HETATM 3413  O   HOH B2769     130.512  72.158  98.603  1.00 70.10           O
HETATM 3414  O   HOH B2770     144.000  98.310 108.952  1.00 65.24           O
HETATM 3415  O   HOH B2771     140.782 109.124 124.962  1.00 65.72           O
HETATM 3416  O   HOH B2772     105.588  99.491 133.962  1.00 75.99           O
HETATM 3417  O   HOH B2773     108.782  66.174 110.400  1.00 63.05           O
HETATM 3418  O   HOH B2774     116.786  71.565 133.949  1.00 73.76           O
HETATM 3419  O   HOH B2775     134.319  95.999 136.786  1.00 68.90           O
HETATM 3420  O   HOH B2776     116.449  69.592  97.332  1.00 70.82           O
HETATM 3421  O   HOH B2777     112.269  43.902 115.921  1.00 80.07           O
HETATM 3422  O   HOH B2778     114.572  87.226 131.959  1.00 62.39           O
HETATM 3423  O   HOH B2779     177.303  95.503 128.227  1.00 67.24           O
HETATM 3424  O   HOH B2780     147.715  98.105  99.534  1.00 68.47           O
HETATM 3425  O   HOH B2781     105.214  73.033 124.949  1.00 73.74           O
HETATM 3426  O   HOH B2782     165.208  81.957 133.832  1.00 76.58           O
HETATM 3427  O   HOH B2783     155.668  80.435 115.559  1.00 59.90           O
HETATM 3428  O   HOH B2784     140.923  94.079  99.753  1.00 71.18           O
HETATM 3429  O   HOH B2785     159.890  88.733  89.118  1.00 73.62           O
HETATM 3430  O   HOH B2786     183.171 111.082 115.172  1.00 75.50           O
HETATM 3431  O   HOH B2787     113.210  66.058  98.