*
* $Id: studis.F,v 1.1.1.1 1996/04/01 15:02:42 mclareni Exp $
*
* $Log: studis.F,v $
* Revision 1.1.1.1  1996/04/01 15:02:42  mclareni
* Mathlib gen
*
*
#include "gen/pilot.h"
      FUNCTION STUDIS(T,N)
C    THIS ROUTINE COMPUTES THE DISTRIBUTION FUNCTION OF THE
C    STUDENT DISTRIBUTION WITH N DEGREES OF FREEDOM.
C    T=VALUE OF THE INDEPENDENT VARIABLE,
C    N=INTEGER GREATER THAN ZERO.
C    THE ROUTINE WAS WRITTEN  BY B.E. COOPER,APPLIED STATISTICS,
C     17(1968)189-190
C    ALGORITHM AS3. THE METHOD WHICH IS THEORETICALLY EXACT WAS GIVEN BY
C    D.B. OWEN,BIOMETRIKA,52(1965),437-446.
C    AT LEAST 9 DECIMAL PLACES ARE CORRECT.
      DATA G1/0.31830988618379/
      IF(N-1) 1,2,3
    2 STUDIS=0.5+G1*ATAN(T)
      RETURN
    3 FN=N
      A=T/SQRT(FN)
      B=FN/(FN+T*T)
      S=1.
      N2=N-2
      N3=MOD(N,2)
      IF(N2 .LT. 2) GO TO 4
      C=1.
      K=2+N3
      FK=K
      DO 5 I=K,N2,2
           C=C*B*(FK-1.)/FK
           S=S+C
    5      FK=FK+2.
    4 IF(N3 .NE. 0) GO TO 6
      STUDIS=0.5+0.5*A*SQRT(B)*S
      RETURN
    6 STUDIS=0.5+(A*B*S+ATAN(A))*G1
      RETURN
    1 WRITE(6,7) N
      STOP
    7 FORMAT(/10X,'DEGREE OF FREEDOM N=',I5,' IN STUDIS ILLEGAL'/)
      END
