   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*             CLIPS Version 6.30  08/16/14            */
   /*                                                     */
   /*              FACT FUNCTIONS HEADER FILE             */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*      6.23: Correction for FalseSymbol/TrueSymbol. DR0859  */
/*                                                           */
/*            Corrected compilation errors for files         */
/*            generated by constructs-to-c. DR0861           */
/*                                                           */
/*      6.24: Added ppfact function.                         */
/*                                                           */
/*      6.30: Support for long long integers.                */
/*                                                           */
/*            Removed conditional code for unsupported       */
/*            compilers/operating systems (IBM_MCW,          */
/*            MAC_MCW, and IBM_TBC).                         */
/*                                                           */
/*            Added const qualifiers to remove C++           */
/*            deprecation warnings.                          */
/*                                                           */
/*            Converted API macros to function calls.        */
/*                                                           */
/*************************************************************/

#ifndef _H_factfun
#define _H_factfun

#ifndef _H_factmngr
#include "factmngr.h"
#endif

#ifdef LOCALE
#undef LOCALE
#endif

#ifdef _FACTFUN_SOURCE_
#define LOCALE
#else
#define LOCALE extern
#endif

   LOCALE void                           FactFunctionDefinitions(void *);
   LOCALE void                          *FactRelationFunction(void *);
   LOCALE void                          *FactRelation(void *);
   LOCALE void                          *EnvFactDeftemplate(void *,void *);
   LOCALE int                            FactExistpFunction(void *);
   LOCALE int                            EnvFactExistp(void *,void *);
   LOCALE void                           FactSlotValueFunction(void *,DATA_OBJECT *);
   LOCALE void                           FactSlotValue(void *,void *,const char *,DATA_OBJECT *);
   LOCALE void                           FactSlotNamesFunction(void *,DATA_OBJECT *);
   LOCALE void                           EnvFactSlotNames(void *,void *,DATA_OBJECT *);
   LOCALE void                           GetFactListFunction(void *,DATA_OBJECT *);
   LOCALE void                           EnvGetFactList(void *,DATA_OBJECT *,void *);
   LOCALE void                           PPFactFunction(void *);
   LOCALE void                           EnvPPFact(void *,void *,const char *,int);
   LOCALE struct fact                   *GetFactAddressOrIndexArgument(void *,const char *,int,int);

#if ALLOW_ENVIRONMENT_GLOBALS

   LOCALE void                          *FactDeftemplate(void *);
   LOCALE int                            FactExistp(void *);
   LOCALE void                           FactSlotNames(void *,DATA_OBJECT *);
   LOCALE void                           GetFactList(DATA_OBJECT_PTR,void *);
   LOCALE void                           PPFact(void *,const char *,int);

#endif /* ALLOW_ENVIRONMENT_GLOBALS */

#endif /* _H_factfun */

