/****************************************************************************
 *    lib/b/ExecutableRule.cpp - This file is part of coala					*
 *																			*
 *    Copyright (C) 2009-2010  Torsten Grote								*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "ExecutableRule.h"

using namespace B;

ExecutableRule::ExecutableRule(int line, Formula* A, Formula* F, Types* types) : C::Statement(line, types) {
	A_ = A;
	F_ = F;
}

ExecutableRule::~ExecutableRule ( ) { }

void ExecutableRule::print(Printer* p) {
	set<Variable*>* vars = new set<Variable*>();
	string T;

	// print the static rule twice: for T=0 and T>0
	for(int i = 1; i <= 2; ++i) {
		if(i == 1) {
			p->setSection('b');
			T = "0";
		}
		else {
			p->setSection('c');
			T = p->T;
		}

		FluentAction* a;
		FluentAction* f;
		string neg_a;
		string neg_f;

		// possible(a, T) :- holds(f, T).
		for(vector<Formula*>::iterator action_a = A_->begin(); action_a != A_->end(); ++action_a) {
			if(!(*action_a)->isFalse()) {
				// check for negation
				if((*action_a)->getType() == 'n') {
					a = (FluentAction*) (*action_a)->getFirstFormula();
					neg_a = p->neg;
				}
				else {
					a = (FluentAction*) *action_a;
					neg_a = "";
				}

				vars = a->getVariables();

				p->add("possible(" + neg_a + a->print(p) + ", " + T + ")");
			}

			// print F part
			if(F_ && !F_->isTrue()) {
				p->add(" :- ");

				for(vector<Formula*>::iterator fluent_f = F_->begin(); fluent_f != F_->end(); ++fluent_f) {
					// check for negation
					if((*fluent_f)->getType() == 'n') {
						f = (FluentAction*) (*fluent_f)->getFirstFormula();
						neg_f = p->neg;
					}
					else {
						f = (FluentAction*) *fluent_f;
						neg_f = "";
					}

					p->add("holds(" + neg_f + f->print(p) + ", " + T + ")");
					if(fluent_f != F_->end()-1) p->add(", ");

					// get the vars
					set<Variable*>* tmp_vars = f->getVariables();
					if(!tmp_vars->empty()) vars->insert(tmp_vars->begin(), tmp_vars->end());
					delete tmp_vars;
				}

			}

			if(!vars->empty()) {
				if(F_ && !F_->isTrue()) p->add(", ");
				else  p->add(" :- ");
				types_.print(p, vars, line_);
			}
			p->add(".\n");

		}
	} // end main for

	delete vars;

}
