#
# Copyright (C) 2005  Robert Collins  <robertc@squid-cache.org>
# 
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


from copy import deepcopy

import tests

import config_manager.implementations as implementations


class ImplementationTestAdapter(object):
    """An adapter factory for implementationtests."""

    def adapt(self, test):
        """Return a suite of implementation tests for test."""
        result = tests.TestSuite()
        for implementation in implementations.all_implementations:
            adapted = deepcopy(test)
            adapted.implementation_class = implementation.__class__
            def make_new_test_id():
                new_id = "%s(%s)" % (adapted.id(),
                                     implementation.__class__.__name__)
                return lambda: new_id
            adapted.id = make_new_test_id()
            result.addTest(adapted)
        return result


def test_suite():
    import test_vcs_implementations
    import test_vcs_implementation
    import test_fake_vcs_implementation
    import test_arch_vcs_implementation
    result = tests.TestSuite()
    result.addTest(test_vcs_implementations.test_suite())
    result.addTest(test_vcs_implementation.test_suite())
    result.addTest(test_fake_vcs_implementation.test_suite())
    result.addTest(test_arch_vcs_implementation.test_suite())
    return result

