/* mailbox.h
 *
 * Here are a couple of shapes for displaying a mailbox
 *
 * flag has two polygons, and z-rotates about (35, 85, 225).
 * cube2 has sides of length 60, with front-bottom-left corner at (30,30,230).
 */

#include "render1.h"

/* stem part */
real_point_t flag_1[] = {
                            { 30.0,  85.0, 220.0},
                            { 70.0,  85.0, 220.0},
                            { 70.0,  75.0, 220.0},
                            { 30.0,  75.0, 220.0}
                         };

/* wide part */
real_point_t flag_2[] = {
                            { 70.0,  85.0, 220.0},
                            { 90.0,  85.0, 220.0},
                            { 90.0,  60.0, 220.0},
                            { 70.0,  60.0, 220.0}
                         };

real_point_t envelope[] = {
                             {40.0, 30.0, 280.0},
                             {40.0, 70.0, 230.0},
                             {90.0, 70.0, 230.0},
                             {90.0, 30.0, 280.0}
                          }; /* Average z = 230 */






/* Front face */
real_point_t mailbox_front[] = {
                            {20.0, 30.0, 230.0},
                            {20.0, 90.0, 230.0},
                            {100.0, 90.0, 230.0},
                            {100.0, 30.0, 230.0}
                         }; /* Average z = 230 */
/* Back face */
real_point_t mailbox_back[] = {
                            {20.0, 30.0, 290.0},
                            {20.0, 90.0, 290.0},
                            {100.0, 90.0, 290.0},
                            {100.0, 30.0, 290.0}
                         }; /* Average z = 290 */


/* Top face */
real_point_t mailbox_top[] = {
                            {20.0, 90.0, 230.0},
                            {20.0, 90.0, 290.0},
                            {100.0, 90.0, 290.0},
                            {100.0, 90.0, 230.0}
                         };

/* Bottom face */
real_point_t mailbox_bottom[] = {
                            {20.0, 30.0, 230.0},
                            {20.0, 30.0, 290.0},
                            {100.0, 30.0, 290.0},
                            {100.0, 30.0, 230.0}
                         };

/* Left face */
real_point_t mailbox_left[] = {
                            {20.0, 30.0, 230.0},
                            {20.0, 30.0, 290.0},
                            {20.0, 90.0, 290.0},
                            {20.0, 90.0, 230.0}
                         };

real_point_t post_top[] = {
                            {50.0, 29.9, 250.0},
                            {50.0, 29.9, 270.0},
                            {70.0, 29.9, 270.0},
                            {70.0, 29.9, 250.0}
                         };

real_point_t post_bottom[] = {
                            {50.0, -30.0, 250.0},
                            {50.0, -30.0, 270.0},
                            {70.0, -30.0, 270.0},
                            {70.0, -30.0, 250.0}
                         };
  
real_point_t post_front[] = {
                            {50.0, 29.9, 250.0},
                            {70.0, 29.9, 250.0},
                            {70.0, -30.0, 250.0},
                            {50.0, -30.0, 250.0}
                         };
  
real_point_t post_back[] = {
                            {50.0, 29.9, 270.0},
                            {70.0, 29.9, 270.0},
                            {70.0, -30.0, 270.0},
                            {50.0, -30.0, 270.0}
                         };

real_point_t post_right[] = {
                            {70.0, 29.9, 250.0},
                            {70.0, 29.9, 270.0},
                            {70.0, -30.0, 270.0},
                            {70.0, -29.9, 250.0}
                         };

real_point_t post_left[] = {
                            {50.0, 29.9, 250.0},
                            {50.0, 29.9, 270.0},
                            {50.0, -30.0, 270.0},
                            {50.0, -30.0, 250.0}
                         };

real_point_t ground_plane[] = {
                            {-50.0, -30.0, 150.0},
                            {-50.0, -30.0, 500.0},
                            {150.0, -30.0, 500.0},
                            {150.0, -30.0, 150.0}
                         };
  






