/*
 * MoleculesToTriangles/CXXClasses/oglPolyhedron.cpp
 *
 * Copyright 2009 by Martin Noble, University of Oxford
 * Author: Martin Noble
 *
 * This file is part of Coot
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA
 */

#include "oglPolyhedron.h"
#include "CXXMatrix.h"

#include "Renderer.h"

std::map<Polyhedron::PolyhedronType, oglPolyhedron *> oglPolyhedron::globalPolyhedra;

oglPolyhedron::oglPolyhedron() : VertexColorNormalPrimitive (){
    drawModeGL=DrawAsTriangles;
    enableColorGL = true;
}

void oglPolyhedron::renderWithRenderer(std::shared_ptr<Renderer> renderer)
{
    if (vertexNormalArray == 0){
        generateArrays();
    }
    renderer->renderPolyhedron(this);
}

void oglPolyhedron::generateArrays()
{	
	vertexNormalArray = new VertexNormal[vertices.size()];
	for (int i=0; i<vertices.size(); i++){
		for (int j=0; j<3; j++){
            vertexNormalArray[i].vertex[j] = vertices[i][j];
            vertexNormalArray[i].normal[j] = vertices[i][j];
		}
	}
    _nVertices = vertices.size();
	int nIndices = 0;
	_nTriangles = 0;
	for (int i=0; i<faces.size(); i++){
		nIndices += face(i).nIndices();
		_nTriangles++;
	}
	indexArray = new GLIndexType[nIndices];	
	nIndices = 0;
	for (int i=0; i<faces.size(); i++){
		for (int j=0; j<face(i).nIndices(); j++){
			indexArray[nIndices++] = face(i)[j];
		}
	}
	return;
}

oglPolyhedron *oglPolyhedron::octaHedron (){
	oglPolyhedron *result = globalPolyhedra[Octahedron];
	if (result != 0){
		return result;
	}
	else {
		oglPolyhedron *newPolyhedron = new oglPolyhedron();
		static float coordArray[6][4] = {
			{  1,  0,  0, 0 },
			{ -1,  0,  0, 0 },
			{  0,  1,  0, 0 },
			{  0, -1,  0, 0 },
			{  0,  0,  1, 0 },
			{  0,  0, -1, 0 }
		};
		for (int i=0; i<6;i++){
			newPolyhedron->getVertices().push_back(FCXXCoord (coordArray[i][0], coordArray[i][1], coordArray[i][2], coordArray[i][3]));
		}
		static int indexesArray[8][4] = {
			{3,	0, 4, 2},
			{3,	0, 2, 5},
			{3,	0, 5, 3},
			{3,	0, 3, 4},
			{3,	1, 2, 4},
			{3,	1, 5, 2},
			{3,	1, 3, 5},
			{3,	1, 4, 3}
		};
		for (int i=0; i<8; i++){
			newPolyhedron->getFaces().push_back(PolyhedronFace(indexesArray[i][0], &(indexesArray[i][1])));
		}
		globalPolyhedra[Octahedron] = newPolyhedron;
		return globalPolyhedra[Octahedron];
	}
}		

oglPolyhedron *oglPolyhedron::dodecaHedron (){
	oglPolyhedron *result = globalPolyhedra[Dodecahedron];
	if (result != 0){
		return result;
	}
	else {
		oglPolyhedron *newPolyhedron = new oglPolyhedron();
		static float coordArray[12][4] = {
			{ 0.00000000,  0.00000000, -0.95105650, 0.},
			{ 0.00000000,  0.85065080, -0.42532537, 0.},
			{ 0.80901698,  0.26286556, -0.42532537, 0.},
			{ 0.50000000, -0.68819095, -0.42532537, 0.},
			{-0.50000000, -0.68819095, -0.42532537, 0.},
			{-0.80901698,  0.26286556, -0.42532537, 0.},
			{ 0.50000000,  0.68819095,  0.42532537, 0.},
			{ 0.80901698, -0.26286556,  0.42532537, 0.},
			{ 0.00000000, -0.85065080,  0.42532537, 0.},
			{-0.80901698, -0.26286556,  0.42532537, 0.},
			{-0.50000000,  0.68819095,  0.42532537, 0.},
			{ 0.00000000,  0.00000000,  0.95105650, 0.}
		};
		for (int i=0; i<12;i++){
			newPolyhedron->getVertices().push_back(FCXXCoord (coordArray[i][0], coordArray[i][1], coordArray[i][2], coordArray[i][3]));
            std::cout << "i" << i << std::endl;
		}
		static int indexesArray[20][4] = {
			{3,	0,  2,  1},
			{3,	0,  3,  2},
			{3,	0,  4,  3},
			{3,	0,  5,  4},
			{3,	0,  1,  5},
			{3,	1,  6, 10},
			{3,	1,  2,  6},
			{3,	2,  7,  6},
			{3,	2,  3,  7},
			{3,	3,  8,  7},
			{3,	3,  4,  8},
			{3,	4,  9,  8},
			{3,	4,  5,  9},
			{3,	5, 10,  9},
			{3,	5,  1, 10},
			{3,	10,  6, 11}, 
			{3,	6,  7, 11},
			{3,	7,  8, 11},
			{3,	8,  9, 11},
			{3,	9, 10, 11}
		};
		for (int i=0; i<20; i++){
			newPolyhedron->getFaces().push_back(PolyhedronFace(indexesArray[i][0], &(indexesArray[i][1])));
		}
		globalPolyhedra[Dodecahedron] = newPolyhedron;
		return globalPolyhedra[Dodecahedron];
	}
}		

oglPolyhedron *oglPolyhedron::dodecaHedron4 (){
	oglPolyhedron *result = globalPolyhedra[Dodecahedron4];
	if (result != 0){
		return result;
	}
	else {
		oglPolyhedron *newPolyhedron = new oglPolyhedron();
		static float coordArray[42][4] = {
			{ 0.00000000, 0.00000000,-1.00000000, 0.},
			{ 0.50000000, 0.16245987,-0.85065079, 0.},
			{ 0.00000000, 0.52573109,-0.85065079, 0.},
			{ 0.50000000, 0.68819100,-0.52573109, 0.},
			{ 0.85065079, 0.27639320,-0.44721356, 0.},
			{ 0.00000000, 0.89442718,-0.44721356, 0.},
			{ 0.30901700,-0.42532539,-0.85065079, 0.},
			{ 0.80901700,-0.26286554,-0.52573109, 0.},
			{ 0.52573115,-0.72360682,-0.44721356, 0.},
			{-0.30901700,-0.42532539,-0.85065079, 0.},
			{ 0.00000000,-0.85065085,-0.52573109, 0.},
			{-0.52573115,-0.72360682,-0.44721356, 0.},
			{-0.50000000, 0.16245987,-0.85065079, 0.},
			{-0.80901700,-0.26286554,-0.52573109, 0.},
			{-0.85065079, 0.27639320,-0.44721356, 0.},
			{-0.50000000, 0.68819100,-0.52573109, 0.},
			{ 0.30901700, 0.95105648, 0.00000000, 0.},
			{-0.30901700, 0.95105648, 0.00000000, 0.},
			{ 0.00000000, 0.85065085, 0.52573109, 0.},
			{ 0.52573115, 0.72360682, 0.44721356, 0.},
			{-0.52573115, 0.72360682, 0.44721356, 0.},
			{ 0.80901700, 0.58778524, 0.00000000, 0.},
			{ 1.00000000, 0.00000000, 0.00000000, 0.},
			{ 0.80901700, 0.26286554, 0.52573109, 0.},
			{ 0.85065079,-0.27639320, 0.44721356, 0.},
			{ 0.80901700,-0.58778524, 0.00000000, 0.},
			{ 0.30901700,-0.95105648, 0.00000000, 0.},
			{ 0.50000000,-0.68819100, 0.52573109, 0.},
			{ 0.00000000,-0.89442718, 0.44721356, 0.},
			{-0.30901700,-0.95105648, 0.00000000, 0.},
			{-0.80901700,-0.58778524, 0.00000000, 0.},
			{-0.50000000,-0.68819100, 0.52573109, 0.},
			{-0.85065079,-0.27639320, 0.44721356, 0.},
			{-1.00000000, 0.00000000, 0.00000000, 0.},
			{-0.80901700, 0.58778524, 0.00000000, 0.},
			{-0.80901700, 0.26286554, 0.52573109, 0.},
			{-0.30901700, 0.42532539, 0.85065079, 0.},
			{ 0.30901700, 0.42532539, 0.85065079, 0.},
			{ 0.00000000, 0.00000000, 1.00000000, 0.},
			{ 0.50000000,-0.16245987, 0.85065079, 0.},
			{ 0.00000000,-0.52573109, 0.85065079, 0.},
			{-0.50000000,-0.16245987, 0.85065079, 0.}
		};
		for (int i=0; i<42;i++){
			newPolyhedron->getVertices().push_back(FCXXCoord (coordArray[i][0], coordArray[i][1], coordArray[i][2], coordArray[i][3]));
		}
		static int indexesArray[80][4] = {
			3,        0,   1,   2,
			3,        1,   3,   2,
			3,        3,   1,   4,
			3,        2,   3,   5,
			3,        0,   6,   1,
			3,        6,   7,   1,
			3,        7,   6,   8,
			3,        1,   7,   4,
			3,        0,   9,   6,
			3,        9,  10,   6,
			3,       10,   9,  11,
			3,        6,  10,   8,
			3,        0,  12,   9,
			3,       12,  13,   9,
			3,       13,  12,  14,
			3,        9,  13,  11,
			3,        0,   2,  12,
			3,        2,  15,  12,
			3,       15,   2,   5,
			3,       12,  15,  14,
			3,        5,  16,  17,
			3,       16,  18,  17,
			3,       18,  16,  19,
			3,       17,  18,  20,
			3,        5,   3,  16,
			3,        3,  21,  16,
			3,       21,   3,   4,
			3,       16,  21,  19,
			3,        4,  22,  21,
			3,       22,  23,  21,
			3,       23,  22,  24,
			3,       21,  23,  19,
			3,        4,   7,  22,
			3,        7,  25,  22,
			3,       25,   7,   8,
			3,       22,  25,  24,
			3,        8,  26,  25,
			3,       26,  27,  25,
			3,       27,  26,  28,
			3,       25,  27,  24,
			3,        8,  10,  26,
			3,       10,  29,  26,
			3,       29,  10,  11,
			3,       26,  29,  28,
			3,       11,  30,  29,
			3,       30,  31,  29,
			3,       31,  30,  32,
			3,       29,  31,  28,
			3,       11,  13,  30,
			3,       13,  33,  30,
			3,       33,  13,  14,
			3,       30,  33,  32,
			3,       14,  34,  33,
			3,       34,  35,  33,
			3,       35,  34,  20,
			3,       33,  35,  32,
			3,       14,  15,  34,
			3,       15,  17,  34,
			3,       17,  15,   5,
			3,       34,  17,  20,
			3,       20,  18,  36,
			3,       18,  37,  36,
			3,       37,  18,  19,
			3,       36,  37,  38,
			3,       19,  23,  37,
			3,       23,  39,  37,
			3,       39,  23,  24,
			3,       37,  39,  38,
			3,       24,  27,  39,
			3,       27,  40,  39,
			3,       40,  27,  28,
			3,       39,  40,  38,
			3,       28,  31,  40,
			3,       31,  41,  40,
			3,       41,  31,  32,
			3,       40,  41,  38,
			3,       32,  35,  41,
			3,       35,  36,  41,
			3,       36,  35,  20,
		    3,       41,  36,  38
		};
		for (int i=0; i<80; i++){
			newPolyhedron->getFaces().push_back(PolyhedronFace(indexesArray[i][0], &(indexesArray[i][1])));
		}
		globalPolyhedra[Dodecahedron4] = newPolyhedron;
		return globalPolyhedra[Dodecahedron4];
	}
}		

oglPolyhedron *oglPolyhedron::dodecaHedron16 (){
	oglPolyhedron *result = globalPolyhedra[Dodecahedron16];
	if (result != 0){
		return result;
	}
	else {
		oglPolyhedron *newPolyhedron = new oglPolyhedron();
		static float coordArray[162][4] = {
			{ 0.00000000, 0.00000000,-1.00000000, 0.},
			{ 0.25989193, 0.08444401,-0.96193832, 0.},
			{ 0.00000000, 0.27326652,-0.96193838, 0.},
			{ 0.26286557, 0.36180338,-0.89442718, 0.},
			{ 0.50000000, 0.16245987,-0.85065079, 0.},
			{ 0.00000000, 0.52573109,-0.85065079, 0.},
			{ 0.52573109, 0.44721362,-0.72360677, 0.},
			{ 0.26286557, 0.63819659,-0.72360682, 0.},
			{ 0.50000000, 0.68819100,-0.52573109, 0.},
			{ 0.70204645, 0.50137532,-0.50572091, 0.},
			{ 0.70204645, 0.22810875,-0.67460889, 0.},
			{ 0.85065079, 0.27639320,-0.44721356, 0.},
			{ 0.00000000, 0.73817533,-0.67460889, 0.},
			{ 0.25989193, 0.82261938,-0.50572085, 0.},
			{ 0.00000000, 0.89442724,-0.44721359, 0.},
			{ 0.16062205,-0.22107726,-0.96193832, 0.},
			{ 0.42532542,-0.13819660,-0.89442718, 0.},
			{ 0.30901700,-0.42532539,-0.85065079, 0.},
			{ 0.58778530,-0.36180338,-0.72360677, 0.},
			{ 0.68819094,-0.05278639,-0.72360677, 0.},
			{ 0.80901700,-0.26286554,-0.52573109, 0.},
			{ 0.69378048,-0.51275235,-0.50572085, 0.},
			{ 0.43388858,-0.59719640,-0.67460889, 0.},
			{ 0.52573115,-0.72360682,-0.44721356, 0.},
			{ 0.86266845, 0.00703146,-0.50572091, 0.},
			{-0.16062205,-0.22107726,-0.96193832, 0.},
			{ 0.00000000,-0.44721359,-0.89442718, 0.},
			{-0.30901700,-0.42532539,-0.85065079, 0.},
			{-0.16245987,-0.67082042,-0.72360682, 0.},
			{ 0.16245987,-0.67082042,-0.72360682, 0.},
			{ 0.00000000,-0.85065085,-0.52573109, 0.},
			{-0.27326655,-0.81827366,-0.50572091, 0.},
			{-0.43388858,-0.59719640,-0.67460889, 0.},
			{-0.52573115,-0.72360682,-0.44721356, 0.},
			{ 0.27326655,-0.81827366,-0.50572091, 0.},
			{-0.25989193, 0.08444401,-0.96193832, 0.},
			{-0.42532542,-0.13819660,-0.89442718, 0.},
			{-0.50000000, 0.16245987,-0.85065079, 0.},
			{-0.68819094,-0.05278639,-0.72360677, 0.},
			{-0.58778530,-0.36180338,-0.72360677, 0.},
			{-0.80901700,-0.26286554,-0.52573109, 0.},
			{-0.86266845, 0.00703146,-0.50572091, 0.},
			{-0.70204645, 0.22810875,-0.67460889, 0.},
			{-0.85065079, 0.27639320,-0.44721356, 0.},
			{-0.69378048,-0.51275235,-0.50572085, 0.},
			{-0.26286557, 0.36180338,-0.89442718, 0.},
			{-0.26286557, 0.63819659,-0.72360682, 0.},
			{-0.52573109, 0.44721362,-0.72360677, 0.},
			{-0.50000000, 0.68819100,-0.52573109, 0.},
			{-0.25989193, 0.82261938,-0.50572085, 0.},
			{-0.70204645, 0.50137532,-0.50572091, 0.},
			{ 0.16062205, 0.95925260,-0.23245439, 0.},
			{-0.16062205, 0.95925260,-0.23245439, 0.},
			{ 0.00000000, 1.00000000, 0.00000000, 0.},
			{ 0.30901700, 0.95105654, 0.00000000, 0.},
			{-0.30901700, 0.95105654, 0.00000000, 0.},
			{ 0.16245987, 0.94721359, 0.27639320, 0.},
			{-0.16245987, 0.94721359, 0.27639320, 0.},
			{ 0.00000000, 0.85065085, 0.52573109, 0.},
			{ 0.27326655, 0.81827366, 0.50572091, 0.},
			{ 0.43388858, 0.87046289, 0.23245437, 0.},
			{ 0.52573115, 0.72360682, 0.44721356, 0.},
			{-0.43388858, 0.87046289, 0.23245437, 0.},
			{-0.27326655, 0.81827366, 0.50572091, 0.},
			{-0.52573115, 0.72360682, 0.44721356, 0.},
			{ 0.42532542, 0.86180341,-0.27639320, 0.},
			{ 0.68819094, 0.67082042,-0.27639320, 0.},
			{ 0.58778524, 0.80901700, 0.00000000, 0.},
			{ 0.80901700, 0.58778524, 0.00000000, 0.},
			{ 0.86266845, 0.44918597,-0.23245439, 0.},
			{ 0.69378048, 0.68164039, 0.23245437, 0.},
			{ 0.96193838, 0.14366472,-0.23245437, 0.},
			{ 0.95105654, 0.30901700, 0.00000000, 0.},
			{ 1.00000000, 0.00000000, 0.00000000, 0.},
			{ 0.95105654, 0.13819660, 0.27639320, 0.},
			{ 0.85065079, 0.44721359, 0.27639318, 0.},
			{ 0.80901700, 0.26286554, 0.52573109, 0.},
			{ 0.86266845,-0.00703146, 0.50572091, 0.},
			{ 0.96193838,-0.14366472, 0.23245437, 0.},
			{ 0.85065079,-0.27639320, 0.44721356, 0.},
			{ 0.69378048, 0.51275235, 0.50572085, 0.},
			{ 0.95105654,-0.13819660,-0.27639320, 0.},
			{ 0.85065079,-0.44721359,-0.27639318, 0.},
			{ 0.95105654,-0.30901700, 0.00000000, 0.},
			{ 0.80901700,-0.58778524, 0.00000000, 0.},
			{ 0.69378048,-0.68164039,-0.23245437, 0.},
			{ 0.86266845,-0.44918597, 0.23245439, 0.},
			{ 0.43388858,-0.87046289,-0.23245437, 0.},
			{ 0.58778524,-0.80901700, 0.00000000, 0.},
			{ 0.30901700,-0.95105654, 0.00000000, 0.},
			{ 0.42532542,-0.86180341, 0.27639320, 0.},
			{ 0.68819094,-0.67082042, 0.27639320, 0.},
			{ 0.50000000,-0.68819100, 0.52573109, 0.},
			{ 0.25989193,-0.82261938, 0.50572085, 0.},
			{ 0.16062205,-0.95925260, 0.23245439, 0.},
			{ 0.00000000,-0.89442724, 0.44721359, 0.},
			{ 0.70204645,-0.50137532, 0.50572091, 0.},
			{ 0.16245987,-0.94721359,-0.27639320, 0.},
			{-0.16245987,-0.94721359,-0.27639320, 0.},
			{ 0.00000000,-1.00000000, 0.00000000, 0.},
			{-0.30901700,-0.95105654, 0.00000000, 0.},
			{-0.43388858,-0.87046289,-0.23245437, 0.},
			{-0.16062205,-0.95925260, 0.23245439, 0.},
			{-0.69378048,-0.68164039,-0.23245437, 0.},
			{-0.58778524,-0.80901700, 0.00000000, 0.},
			{-0.80901700,-0.58778524, 0.00000000, 0.},
			{-0.68819094,-0.67082042, 0.27639320, 0.},
			{-0.42532542,-0.86180341, 0.27639320, 0.},
			{-0.50000000,-0.68819100, 0.52573109, 0.},
			{-0.70204645,-0.50137532, 0.50572091, 0.},
			{-0.86266845,-0.44918597, 0.23245439, 0.},
			{-0.85065079,-0.27639320, 0.44721356, 0.},
			{-0.25989193,-0.82261938, 0.50572085, 0.},
			{-0.85065079,-0.44721359,-0.27639318, 0.},
			{-0.95105654,-0.13819660,-0.27639320, 0.},
			{-0.95105654,-0.30901700, 0.00000000, 0.},
			{-1.00000000, 0.00000000, 0.00000000, 0.},
			{-0.96193838, 0.14366472,-0.23245437, 0.},
			{-0.96193838,-0.14366472, 0.23245437, 0.},
			{-0.86266845, 0.44918597,-0.23245439, 0.},
			{-0.95105654, 0.30901700, 0.00000000, 0.},
			{-0.80901700, 0.58778524, 0.00000000, 0.},
			{-0.85065079, 0.44721359, 0.27639318, 0.},
			{-0.95105654, 0.13819660, 0.27639320, 0.},
			{-0.80901700, 0.26286554, 0.52573109, 0.},
			{-0.69378048, 0.51275235, 0.50572085, 0.},
			{-0.69378048, 0.68164039, 0.23245437, 0.},
			{-0.86266845,-0.00703146, 0.50572091, 0.},
			{-0.68819094, 0.67082042,-0.27639320, 0.},
			{-0.42532542, 0.86180341,-0.27639320, 0.},
			{-0.58778524, 0.80901700, 0.00000000, 0.},
			{-0.43388858, 0.59719640, 0.67460889, 0.},
			{-0.16245987, 0.67082042, 0.72360682, 0.},
			{-0.30901700, 0.42532539, 0.85065079, 0.},
			{ 0.16245987, 0.67082042, 0.72360682, 0.},
			{ 0.00000000, 0.44721359, 0.89442718, 0.},
			{ 0.30901700, 0.42532539, 0.85065079, 0.},
			{ 0.43388858, 0.59719640, 0.67460889, 0.},
			{-0.16062205, 0.22107726, 0.96193832, 0.},
			{ 0.16062205, 0.22107726, 0.96193832, 0.},
			{ 0.00000000, 0.00000000, 1.00000000, 0.},
			{ 0.58778530, 0.36180338, 0.72360677, 0.},
			{ 0.68819094, 0.05278639, 0.72360677, 0.},
			{ 0.42532542, 0.13819660, 0.89442718, 0.},
			{ 0.50000000,-0.16245987, 0.85065079, 0.},
			{ 0.70204645,-0.22810875, 0.67460889, 0.},
			{ 0.25989193,-0.08444401, 0.96193832, 0.},
			{ 0.52573109,-0.44721362, 0.72360677, 0.},
			{ 0.26286557,-0.63819659, 0.72360682, 0.},
			{ 0.26286557,-0.36180338, 0.89442718, 0.},
			{ 0.00000000,-0.52573109, 0.85065079, 0.},
			{ 0.00000000,-0.73817533, 0.67460889, 0.},
			{ 0.00000000,-0.27326652, 0.96193838, 0.},
			{-0.26286557,-0.63819659, 0.72360682, 0.},
			{-0.52573109,-0.44721362, 0.72360677, 0.},
			{-0.26286557,-0.36180338, 0.89442718, 0.},
			{-0.50000000,-0.16245987, 0.85065079, 0.},
			{-0.70204645,-0.22810875, 0.67460889, 0.},
			{-0.25989193,-0.08444401, 0.96193832, 0.},
			{-0.68819094, 0.05278639, 0.72360677, 0.},
			{-0.58778530, 0.36180338, 0.72360677, 0.},
			{-0.42532542, 0.13819660, 0.89442718, 0.}
		};
		for (int i=0; i<162;i++){
			newPolyhedron->getVertices().push_back(FCXXCoord (coordArray[i][0], coordArray[i][1], coordArray[i][2], coordArray[i][3]));
		}
		static int indexesArray[320][4] = {
			3,        0,   1,   2,
			3,        1,   3,   2,
			3,        3,   1,   4,
			3,        2,   3,   5,
			3,        4,   6,   3,
			3,        6,   7,   3,
			3,        7,   6,   8,
			3,        3,   7,   5,
			3,        8,   6,   9,
			3,        6,  10,   9,
			3,       10,   6,   4,
			3,        9,  10,  11,
			3,        5,   7,  12,
			3,        7,  13,  12,
			3,       13,   7,   8,
			3,       12,  13,  14,
			3,        0,  15,   1,
			3,       15,  16,   1,
			3,       16,  15,  17,
			3,        1,  16,   4,
			3,       17,  18,  16,
			3,       18,  19,  16,
			3,       19,  18,  20,
			3,       16,  19,   4,
			3,       20,  18,  21,
			3,       18,  22,  21,
			3,       22,  18,  17,
			3,       21,  22,  23,
			3,        4,  19,  10,
			3,       19,  24,  10,
			3,       24,  19,  20,
			3,       10,  24,  11,
			3,        0,  25,  15,
			3,       25,  26,  15,
			3,       26,  25,  27,
			3,       15,  26,  17,
			3,       27,  28,  26,
			3,       28,  29,  26,
			3,       29,  28,  30,
			3,       26,  29,  17,
			3,       30,  28,  31,
			3,       28,  32,  31,
			3,       32,  28,  27,
			3,       31,  32,  33,
			3,       17,  29,  22,
			3,       29,  34,  22,
			3,       34,  29,  30,
			3,       22,  34,  23,
			3,        0,  35,  25,
			3,       35,  36,  25,
			3,       36,  35,  37,
			3,       25,  36,  27,
			3,       37,  38,  36,
			3,       38,  39,  36,
			3,       39,  38,  40,
			3,       36,  39,  27,
			3,       40,  38,  41,
			3,       38,  42,  41,
			3,       42,  38,  37,
			3,       41,  42,  43,
			3,       27,  39,  32,
			3,       39,  44,  32,
			3,       44,  39,  40,
			3,       32,  44,  33,
			3,        0,   2,  35,
			3,        2,  45,  35,
			3,       45,   2,   5,
			3,       35,  45,  37,
			3,        5,  46,  45,
			3,       46,  47,  45,
			3,       47,  46,  48,
			3,       45,  47,  37,
			3,       48,  46,  49,
			3,       46,  12,  49,
			3,       12,  46,   5,
			3,       49,  12,  14,
			3,       37,  47,  42,
			3,       47,  50,  42,
			3,       50,  47,  48,
			3,       42,  50,  43,
			3,       14,  51,  52,
			3,       51,  53,  52,
			3,       53,  51,  54,
			3,       52,  53,  55,
			3,       54,  56,  53,
			3,       56,  57,  53,
			3,       57,  56,  58,
			3,       53,  57,  55,
			3,       58,  56,  59,
			3,       56,  60,  59,
			3,       60,  56,  54,
			3,       59,  60,  61,
			3,       55,  57,  62,
			3,       57,  63,  62,
			3,       63,  57,  58,
			3,       62,  63,  64,
			3,       14,  13,  51,
			3,       13,  65,  51,
			3,       65,  13,   8,
			3,       51,  65,  54,
			3,        8,  66,  65,
			3,       66,  67,  65,
			3,       67,  66,  68,
			3,       65,  67,  54,
			3,       68,  66,  69,
			3,       66,   9,  69,
			3,        9,  66,   8,
			3,       69,   9,  11,
			3,       54,  67,  60,
			3,       67,  70,  60,
			3,       70,  67,  68,
			3,       60,  70,  61,
			3,       11,  71,  69,
			3,       71,  72,  69,
			3,       72,  71,  73,
			3,       69,  72,  68,
			3,       73,  74,  72,
			3,       74,  75,  72,
			3,       75,  74,  76,
			3,       72,  75,  68,
			3,       76,  74,  77,
			3,       74,  78,  77,
			3,       78,  74,  73,
			3,       77,  78,  79,
			3,       68,  75,  70,
			3,       75,  80,  70,
			3,       80,  75,  76,
			3,       70,  80,  61,
			3,       11,  24,  71,
			3,       24,  81,  71,
			3,       81,  24,  20,
			3,       71,  81,  73,
			3,       20,  82,  81,
			3,       82,  83,  81,
			3,       83,  82,  84,
			3,       81,  83,  73,
			3,       84,  82,  85,
			3,       82,  21,  85,
			3,       21,  82,  20,
			3,       85,  21,  23,
			3,       73,  83,  78,
			3,       83,  86,  78,
			3,       86,  83,  84,
			3,       78,  86,  79,
			3,       23,  87,  85,
			3,       87,  88,  85,
			3,       88,  87,  89,
			3,       85,  88,  84,
			3,       89,  90,  88,
			3,       90,  91,  88,
			3,       91,  90,  92,
			3,       88,  91,  84,
			3,       92,  90,  93,
			3,       90,  94,  93,
			3,       94,  90,  89,
			3,       93,  94,  95,
			3,       84,  91,  86,
			3,       91,  96,  86,
			3,       96,  91,  92,
			3,       86,  96,  79,
			3,       23,  34,  87,
			3,       34,  97,  87,
			3,       97,  34,  30,
			3,       87,  97,  89,
			3,       30,  98,  97,
			3,       98,  99,  97,
			3,       99,  98, 100,
			3,       97,  99,  89,
			3,      100,  98, 101,
			3,       98,  31, 101,
			3,       31,  98,  30,
			3,      101,  31,  33,
			3,       89,  99,  94,
			3,       99, 102,  94,
			3,      102,  99, 100,
			3,       94, 102,  95,
			3,       33, 103, 101,
			3,      103, 104, 101,
			3,      104, 103, 105,
			3,      101, 104, 100,
			3,      105, 106, 104,
			3,      106, 107, 104,
			3,      107, 106, 108,
			3,      104, 107, 100,
			3,      108, 106, 109,
			3,      106, 110, 109,
			3,      110, 106, 105,
			3,      109, 110, 111,
			3,      100, 107, 102,
			3,      107, 112, 102,
			3,      112, 107, 108,
			3,      102, 112,  95,
			3,       33,  44, 103,
			3,       44, 113, 103,
			3,      113,  44,  40,
			3,      103, 113, 105,
			3,       40, 114, 113,
			3,      114, 115, 113,
			3,      115, 114, 116,
			3,      113, 115, 105,
			3,      116, 114, 117,
			3,      114,  41, 117,
			3,       41, 114,  40,
			3,      117,  41,  43,
			3,      105, 115, 110,
			3,      115, 118, 110,
			3,      118, 115, 116,
			3,      110, 118, 111,
			3,       43, 119, 117,
			3,      119, 120, 117,
			3,      120, 119, 121,
			3,      117, 120, 116,
			3,      121, 122, 120,
			3,      122, 123, 120,
			3,      123, 122, 124,
			3,      120, 123, 116,
			3,      124, 122, 125,
			3,      122, 126, 125,
			3,      126, 122, 121,
			3,      125, 126,  64,
			3,      116, 123, 118,
			3,      123, 127, 118,
			3,      127, 123, 124,
			3,      118, 127, 111,
			3,       43,  50, 119,
			3,       50, 128, 119,
			3,      128,  50,  48,
			3,      119, 128, 121,
			3,       48, 129, 128,
			3,      129, 130, 128,
			3,      130, 129,  55,
			3,      128, 130, 121,
			3,       55, 129,  52,
			3,      129,  49,  52,
			3,       49, 129,  48,
			3,       52,  49,  14,
			3,      121, 130, 126,
			3,      130,  62, 126,
			3,       62, 130,  55,
			3,      126,  62,  64,
			3,       64,  63, 131,
			3,       63, 132, 131,
			3,      132,  63,  58,
			3,      131, 132, 133,
			3,       58, 134, 132,
			3,      134, 135, 132,
			3,      135, 134, 136,
			3,      132, 135, 133,
			3,      136, 134, 137,
			3,      134,  59, 137,
			3,       59, 134,  58,
			3,      137,  59,  61,
			3,      133, 135, 138,
			3,      135, 139, 138,
			3,      139, 135, 136,
			3,      138, 139, 140,
			3,       61,  80, 137,
			3,       80, 141, 137,
			3,      141,  80,  76,
			3,      137, 141, 136,
			3,       76, 142, 141,
			3,      142, 143, 141,
			3,      143, 142, 144,
			3,      141, 143, 136,
			3,      144, 142, 145,
			3,      142,  77, 145,
			3,       77, 142,  76,
			3,      145,  77,  79,
			3,      136, 143, 139,
			3,      143, 146, 139,
			3,      146, 143, 144,
			3,      139, 146, 140,
			3,       79,  96, 145,
			3,       96, 147, 145,
			3,      147,  96,  92,
			3,      145, 147, 144,
			3,       92, 148, 147,
			3,      148, 149, 147,
			3,      149, 148, 150,
			3,      147, 149, 144,
			3,      150, 148, 151,
			3,      148,  93, 151,
			3,       93, 148,  92,
			3,      151,  93,  95,
			3,      144, 149, 146,
			3,      149, 152, 146,
			3,      152, 149, 150,
			3,      146, 152, 140,
			3,       95, 112, 151,
			3,      112, 153, 151,
			3,      153, 112, 108,
			3,      151, 153, 150,
			3,      108, 154, 153,
			3,      154, 155, 153,
			3,      155, 154, 156,
			3,      153, 155, 150,
			3,      156, 154, 157,
			3,      154, 109, 157,
			3,      109, 154, 108,
			3,      157, 109, 111,
			3,      150, 155, 152,
			3,      155, 158, 152,
			3,      158, 155, 156,
			3,      152, 158, 140,
			3,      111, 127, 157,
			3,      127, 159, 157,
			3,      159, 127, 124,
			3,      157, 159, 156,
			3,      124, 160, 159,
			3,      160, 161, 159,
			3,      161, 160, 133,
			3,      159, 161, 156,
			3,      133, 160, 131,
			3,      160, 125, 131,
			3,      125, 160, 124,
			3,      131, 125,  64,
			3,      156, 161, 158,
			3,      161, 138, 158,
			3,      138, 161, 133,
			3,      158, 138, 140
				};
		for (int i=0; i<320; i++){
			newPolyhedron->getFaces().push_back(PolyhedronFace(indexesArray[i][0], &(indexesArray[i][1])));
		}
		globalPolyhedra[Dodecahedron16] = newPolyhedron;
		return globalPolyhedra[Dodecahedron16];
	}
}	
