//
// C++ Interface: log
//
// Description: 
//
//
// Author: Rikard Björklind <olof@linux.nu>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef LOG_H__
#define LOG_H__

#include <QString>
#include <QColor>

//! Logging interface
class Log
{
    public:
        virtual void info(const char* format, ...) = 0;
        virtual void info(const QString&) = 0;
        virtual void error(const char* format, ...) = 0;
        virtual void error(const QString&) = 0;
        virtual void warn(const char* format, ...) = 0;
        virtual void warn(const QString&) = 0;
        virtual void debug(const char* format, ...) = 0;
        virtual void debug(const QString&) = 0;
		virtual void msg(const QString&,const QColor& color) = 0;
        virtual ~Log() {}
};

extern Log* logger;


#endif
