//
// C++ Implementation: settingsdialog
//
// Description: 
//
//
// Author: Rikard Bjorklind <olof@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "settingsdialog.h"
#include "shareitemmodel.h"

#include "log.h"
#include <QtGui>

SettingsDialog::SettingsDialog(boost::shared_ptr<BackendConnection> aBackendConnection,QWidget *parent)
 : QDialog(parent),backendConnection(aBackendConnection)
{
	ui.setupUi(this);
	// Create the shareitem model for the shared dir treeview.
	shareItemModel = new ShareItemModel;
	ui.sharedView->setModel(shareItemModel);
	ui.sharedView->setContextMenuPolicy(Qt::CustomContextMenu);
	connect(ui.sharedView,SIGNAL(customContextMenuRequested ( const QPoint&)),SLOT(onContextMenu(const QPoint&)));
	connect(shareItemModel,SIGNAL(dirDropped( const QString& )),SLOT(onDirDropped( const QString&)));
	
	// Init local settings
	QSettings settings("dc-qt.sf.net","dcqt");
	BackendConnectionType backendConnectionType = (BackendConnectionType)settings.value("bctype",(int)USE_LOCAL_BACKEND).toInt();
	QString backendConnectionURL = settings.value("bcurl","localhost").toString();
	int localPort = settings.value("bclocalport",6161).toInt();
	int remotePort = settings.value("bcremoteport",6161).toInt();
	srand(time(NULL));
	QString defaultPassword = QString::number(rand() % 100000 + 100000);
	QString password = settings.value("bcpassword",defaultPassword).toString();
	
	// Set the loaded settings in the gui
	ui.localBackendPort->setValue(localPort);
	ui.remoteBackendPort->setValue(remotePort);
	ui.remoteBackendURL->setText(backendConnectionURL);
	ui.passwordEdit->setText(password);
	// Preselect the radio button
	if(backendConnectionType==USE_LOCAL_BACKEND) ui.localBackendRadio->setChecked(true);
	else ui.remoteBackendRadio->setChecked(true);
	
	connect(ui.sharedView,SIGNAL(leftMousePressed()),SLOT(onLeftMouse()));
	
	contextMenu = new QMenu(this);
	/*QAction* removeAction = */contextMenu->addAction( tr("Remove") );
}


SettingsDialog::~SettingsDialog()
{
}

QList< QString > SettingsDialog::getRequiredSettings( )
{
 	QList<QString> settings;
    settings += "NICK";
    settings += "DESCRIPTION";
    settings += "EMAIL";
    settings += "CONNECTION_TYPE";
    settings += "SERVER";
    settings += "IN_PORT";
    settings += "UDP_PORT";
    settings += "DOWNLOAD_DIRECTORY";
    settings += "TEMP_DOWNLOAD_DIRECTORY";
	return settings;
}

void SettingsDialog::settingsInfo(const QList<QString>& keys,const QList<QVariant>& values)
{
	QListIterator<QString> ki(keys);
	QListIterator<QVariant> vi(values);
	
	while(ki.hasNext())
	{
		const QString key = ki.next();
		const QVariant value = vi.next();
		if(key=="NICK") ui.nickEdit->setText( value.toString() );
		else if(key=="DESCRIPTION") ui.descriptionEdit->setText( value.toString() );
		else if(key=="EMAIL") ui.emailEdit->setText( value.toString() );
		else if(key=="CONNECTION_TYPE") ui.activeCheck->setChecked( value.toInt()==0 );
		else if(key=="SERVER") ui.ipEdit->setText(value.toString());
		else if(key=="IN_PORT") ui.tcpEdit->setText(QString::number(value.toInt()));
		else if(key=="UDP_PORT") ui.udpEdit->setText(QString::number(value.toInt()));
		else if(key=="DOWNLOAD_DIRECTORY") ui.finisheddirEdit->setText(value.toString());
		else if(key=="TEMP_DOWNLOAD_DIRECTORY") ui.dldirEdit->setText(value.toString());
	}
}

void SettingsDialog::showEvent(QShowEvent*)
{
	backendConnection->getSettings(getRequiredSettings());
	backendConnection->getSharedDirs();
}

void SettingsDialog::on_okButton_pressed()
{
	bool ok1,ok2;
	int tcpport = ui.tcpEdit->text().toInt(&ok1);
	int udpport = ui.udpEdit->text().toInt(&ok2);
	
	if(!ok1) {
		QMessageBox::critical(this,tr("Settings Error"),tr("TCP port must be a number"));
		return;
	}
	if(!ok2) {
		QMessageBox::critical(this,tr("Settings Error"),tr("UDP port must be a number"));
		return;
	}

	QList<QPair<QString,QVariant> > settings;
	settings += QPair<QString,QVariant>("NICK",ui.nickEdit->text());
	settings += QPair<QString,QVariant>("DESCRIPTION",ui.descriptionEdit->text());
	settings += QPair<QString,QVariant>("EMAIL",ui.emailEdit->text());
	settings += QPair<QString,QVariant>("CONNECTION_TYPE",ui.activeCheck->isChecked()?0:1);
	settings += QPair<QString,QVariant>("SERVER",ui.ipEdit->text());
	settings += QPair<QString,QVariant>("IN_PORT",tcpport);
	settings += QPair<QString,QVariant>("UDP_PORT",udpport);
	settings += QPair<QString,QVariant>("DOWNLOAD_DIRECTORY",ui.finisheddirEdit->text());
	settings += QPair<QString,QVariant>("TEMP_DOWNLOAD_DIRECTORY",ui.dldirEdit->text());

	backendConnection->setSettings(settings);
	
	// Save local settings
	QSettings ls("dc-qt.sf.net","dcqt");
	ls.setValue("bctype", ui.localBackendRadio->isChecked() ? USE_LOCAL_BACKEND : USE_REMOTE_BACKEND);
	ls.setValue("bcurl", ui.remoteBackendURL->text());
	ls.setValue("bclocalport", ui.localBackendPort->value());
	ls.setValue("bcremoteport", ui.remoteBackendPort->value());
	ls.setValue("bcpassword", ui.passwordEdit->text());
	
	accept();
}

void SettingsDialog::on_dldirButton_pressed()
{
	// TODO
//if( BackendConnection::instance()->isConnectionLocal())
 //   {
        QString dir = QFileDialog::getExistingDirectory(this,tr("Choose incomplete directory"),
		QDir::homePath());
        if(dir!=QString::null && !dir.isEmpty())
            ui.dldirEdit->setText(dir);
   // }
   // else
    //    QMessageBox::information(this,tr("Problematic request"),tr("You cannot browse when connected to a remote backend."),tr("Ok"));
}

void SettingsDialog::on_finisheddirButton_pressed()
{
	// TODO
  //if( BackendConnection::instance()->isConnectionLocal())
  //  {
//		logger->info(findirEdit->text());
        QString dir = QFileDialog::getExistingDirectory(this,tr("Choose finished directory"),
			QDir::homePath());
        if(dir!=QString::null && !dir.isEmpty())
            ui.finisheddirEdit->setText(dir);
   // }
   // else
   //     QMessageBox::information(this,tr("Problematic request"),tr("You cannot browse when connected to a remote backend."),tr("Ok"));

}

void SettingsDialog::sharedDirs( const QList<ShareItem> dirs)
{
	shareItemModel->clear();
	for(int i=0;i<dirs.size();i++)
		shareItemModel->add( dirs[i] );
}
/*
void SettingsDialog::on_removeShareButton_pressed( )
{
	QModelIndex current = ui.sharedView->currentIndex();
	QString name = shareItemModel->getDir(current.row());   
	backendConnection->delShare(name);
	shareItemModel->remove(current.row());      
}
*/
void SettingsDialog::onDirDropped( const QString &dir )
{
	QString name = QInputDialog::getText(0,tr("Enter name for share"), "Enter a name for the share " + dir);
	if(!name.isEmpty() && !name.isNull()) {
		backendConnection->addShare(name,dir);
		shareItemModel->add(name,dir);   
	}
}

void SettingsDialog::onLeftMouse( )
{
	QString vName = QInputDialog::getText(this,tr("Enter name"),tr("Enter a name for this share"));
	if(!vName.isEmpty()) {
		QString dir = QFileDialog::getExistingDirectory(this,tr("Choose a directory"));
		if(!dir.isEmpty()) {
			backendConnection->addShare(vName,dir);
			shareItemModel->add(vName,dir);   
		}
	}
}

void SettingsDialog::onContextMenu( const QPoint & )
{
	QAction* a = contextMenu->exec(QCursor::pos());
	if(a) {
		QModelIndex current = ui.sharedView->currentIndex();
		QString name = shareItemModel->getDir(current.row());   
		backendConnection->delShare(name);
		shareItemModel->remove(current.row());      
	}
}
