#include "searchmanager.h"
#include "../backend/CommonTypes.h"

#include <QtGui>

SearchManager::SearchManager(boost::shared_ptr<BackendConnection> aConnection,QObject *parent)
	: QObject(parent),backendConnection(aConnection), dockWidgetAdded(false)
{
	QMainWindow *mw = static_cast<QMainWindow*>(parent);
	displayMode = SHOW_AS_DOCKWINDOW;
	searchTabs = new QTabWidget(0);
	setupUi(mw);
	
	QPushButton* b = new QPushButton(searchTabs);
	QIcon i(":/images/remove.png");
	b->setIcon(i);
	b->setFlat(true);
	b->setToolTip(tr("Close search"));
	searchTabs->setCornerWidget(b);
	connect(b,SIGNAL(pressed()),SLOT(onCloseCurrentSearch())); 
	
	// create an initial search widget
	//activeSearch = new SearchWidget(0);
	//searchTabs->addTab(activeSearch,tr("Search"));
	//connect(activeSearch,SIGNAL(search( int , qint64 , int , int , const QString& )),
	//		this,SLOT(search( int , qint64 , int , int , const QString & )));
	//connect(activeSearch,SIGNAL(downloadFile(const SearchEntry&)),backendConnection.get(),SLOT(downloadFile(const SearchEntry&)));
	//connect(activeSearch,SIGNAL(downloadFile( int, const QString& , int64 , const QString& )),backendConnection.get(),SLOT(downloadFile( int, const QString& , int64 , const QString& )));
	//connect(activeSearch,SIGNAL(downloadFileTo(const SearchEntry&, const QString&)),backendConnection.get(),SLOT(downloadFileTo(const SearchEntry&,const QString&)));
	//connect(activeSearch, 
	////		SIGNAL(downloadFileTo( int, const QString&, int64, const QString&, const QString& )),
		//	 backendConnection.get(), 
	//		 SLOT(downloadFileTo( int, const QString&, int64, const QString&, const QString& )) );
	//connect(activeSearch,SIGNAL(getUserFileList(int)),backendConnection.get(),SLOT(getUserFileList(int)));
	activeSearch = newSearchWidget( tr("Search") );
}


SearchManager::~SearchManager()
{
}

void SearchManager::setupUi( QMainWindow* mw)
{
	searchTabs->hide();
	searchTabs->setParent(0);
	if(dialog) delete dialog;
	if(dock) delete dock;
	
	if(displayMode==SHOW_AS_DIALOG) {
		dialog = new QDialog;
		QVBoxLayout *layout = new QVBoxLayout(dialog);
		layout->addWidget(searchTabs);
		searchTabs->setParent(dialog);
	}
	else {
		dock = new QDockWidget(tr("Searches"),mw);
		searchTabs->setParent(dock);
		dock->setWidget(searchTabs);
		dock->setFeatures(QDockWidget::DockWidgetClosable|QDockWidget::DockWidgetMovable);
	}
	searchTabs->show();
}

void SearchManager::show(QMainWindow* mw )
{
	if(displayMode==SHOW_AS_DIALOG) dialog->show();
	else {
		if(dock->isVisible()) {
			newSearchWidget( tr("Search") );
		}
		if(!dockWidgetAdded) {
			mw->addDockWidget(Qt::RightDockWidgetArea,dock);
			dockWidgetAdded = true;
		} 
		else 
			dock->show();
	}
}

void SearchManager::search( int session, qint64 size, int sizeMode, int typeMode, const QString & search, SearchWidget* destination )
{
	if( NULL == destination ) {
		activeSearch = newSearchWidget(search);
	}
	else {
		activeSearch = destination;
	}
	activeSearchType = typeMode;
	activeSearchString = search;
	searchTokens = activeSearchString.split(" ");
	backendConnection->sendSearch( session, size, sizeMode, typeMode, search );	
}

void SearchManager::searchResults( int session, QList<SearchEntry> &results)
{
	// Filter
	QList< SearchEntry >::iterator it = results.begin();
	while( it!=results.end() ) {
		if( (activeSearchType==backend::TYPE_TTH && activeSearchString!=it->getTTH()) ||
			(activeSearchType!=backend::TYPE_TTH && !isSearchForActiveWidget(QString::fromStdString(it->getFile()))) ) {
				logger->debug("Erasing search because of filter");
			it = results.erase(it);
		}
		else it++;
	}
	
	// Put them in the widget
	activeSearch->searchResults( session, results );	
}

SearchWidget * SearchManager::newSearchWidget(const QString& name)
{
	SearchWidget *sw = new SearchWidget(0);
	searchTabs->addTab(sw,name);
	connect(sw,SIGNAL(search( int , qint64 , int , int , const QString&,SearchWidget* )),
			this,SLOT(search( int , qint64 , int , int , const QString &,SearchWidget* )));
	connect(sw,SIGNAL(downloadFile(const SearchEntry&)),backendConnection.get(),SLOT(downloadFile(const SearchEntry&)));
	connect(sw,SIGNAL(downloadFile( int, const QString& , int64 , const QString& )),backendConnection.get(),SLOT(downloadFile( int, const QString& , int64 , const QString& )));
	connect(sw,SIGNAL(downloadFileTo(const SearchEntry&, const QString&)),backendConnection.get(),SLOT(downloadFileTo(const SearchEntry&,const QString&)));
	connect(sw, SIGNAL(downloadFileTo( int, const QString&, int64, const QString&, const QString& )),
			backendConnection.get(), SLOT(downloadFileTo( int, const QString&, int64, const QString&, const QString& )) );
	connect(sw,SIGNAL(getUserFileList(int)),backendConnection.get(),SLOT(getUserFileList(int)));
	return sw;
}

void SearchManager::onCloseCurrentSearch( )
{
	if(searchTabs->count() <= 1) return;
	SearchWidget* curr = qobject_cast<SearchWidget*>( searchTabs->currentWidget() );
	int curri = searchTabs->currentIndex();
	searchTabs->removeTab(curri);
	if( curr == activeSearch ) activeSearch = 0;
	delete curr;
}

bool SearchManager::isSearchForActiveWidget( const QString& searchStr ) const
{
	QStringList::const_iterator it = searchTokens.begin();
	while( it != searchTokens.end() && searchStr.contains( *it, Qt::CaseInsensitive ) ) { ++it; }
	
	return it == searchTokens.end();
}
