//
// C++ Interface: sessionmanager
//
// Description:
//
//
// Author: Rikard Bjorklind <olof@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SESSIONMANAGER_H
#define SESSIONMANAGER_H

#include <QObject>
#include <QMap>
#include "backendconnection.h"

class QTabWidget;
class Session;
class User;

/**
	Manages the mapping between integers and sessions, creates session widgets.
	@author Rikard Bjorklind <olof@users.sourceforge.net>
*/
class SessionManager : public QObject
{
    Q_OBJECT
public:
    SessionManager(QTabWidget *aSessionTabs,
                   boost::shared_ptr< BackendConnection > aConnection,
                   QObject *parent = 0);

    ~SessionManager();

public slots:
    void createSession(int id);
	void closeCurrentSession();
	void hubUpdated(int id,const QString& hubName);
    void connectionFailed(int id, const QString& reason);
    void privateChat(int,const QString&,const QString&);
    void usersUpdated(int, QList<User*>);
	void userRemoved(int,int);
    void chatMessage(int,const QString&);
	void sessionInfo(int,const QString&,const QString&,const QList<User*>);
	
signals:
	void currentHubTotalShare(qint64);
	
private slots:
	void sendChat(int,const QString&);
    void getUserFileList(int);
	void onHubStats(int,qint64);
	void onActiveSessionChanged(int);
	
private:
    boost::shared_ptr< BackendConnection > backendConnection;
    QTabWidget* sessionTabs;
    QMap<int,Session*> sessionMap;



};

#endif
