"""
This module contains compiletime information about the dolfin python
library, which can be utelized at runtime.

The file is automatically generated by the generateswigcode.py script
in the dolfin/swig directory."""

try:
    from collections import OrderedDict
except ImportError:
    from dolfin_utils.ordereddict import OrderedDict

# A list of shared_ptr declared classes in dolfin
shared_ptr_classes = ['AdaptiveLinearVariationalSolver', 'AdaptiveNonlinearVariationalSolver', 'ErrorControl', 'Hierarchical<dolfin::ErrorControl>', 'GenericAdaptiveVariationalSolver', 'GoalFunctional', 'SpecialFacetFunction', 'TimeSeries', 'TimeSeriesHDF5', 'MeshDisplacement', 'Variable', 'Hierarchical<dolfin::Form>', 'GenericDofMap', 'DofMap', 'CCFEMDofMap', 'Form', 'FiniteElement', 'BasisFunction', 'MultiStageScheme', 'Hierarchical<dolfin::LinearVariationalProblem>', 'Hierarchical<dolfin::NonlinearVariationalProblem>', 'LinearVariationalProblem', 'NonlinearVariationalProblem', 'LinearVariationalSolver', 'NonlinearVariationalSolver', 'VariationalProblem', 'PointIntegralSolver', 'Hierarchical<dolfin::DirichletBC>', 'DirichletBC', 'Hierarchical<dolfin::FunctionSpace>', 'FunctionSpace', 'SubSpace', 'GenericFunction', 'Hierarchical<dolfin::Function>', 'Function', 'Expression', 'FacetArea', 'Constant', 'MeshCoordinates', 'BoundingBoxTree', 'Hierarchical<dolfin::Mesh>', 'BoundaryMesh', 'CircleMesh', 'EllipseMesh', 'EllipsoidMesh', 'Mesh', 'Restriction', 'SphereMesh', 'SubMesh', 'UnitTetrahedronMesh', 'UnitTetrahedron', 'UnitCubeMesh', 'UnitCube', 'UnitIntervalMesh', 'UnitInterval', 'IntervalMesh', 'Interval', 'UnitTriangleMesh', 'UnitTriangle', 'UnitSquareMesh', 'UnitSquare', 'UnitCircleMesh', 'UnitCircle', 'BoxMesh', 'Box', 'RectangleMesh', 'Rectangle', 'CSGGeometry', 'CSGOperator', 'CSGUnion', 'CSGDifference', 'CSGIntersection', 'CSGPrimitive', 'CSGPrimitive2D', 'CSGPrimitive3D', 'Circle', 'Ellipse', 'Polygon', 'Sphere', 'Cone', 'Cylinder', 'Tetrahedron', 'Surface3D', 'CSGCGALMeshGenerator2D', 'CSGCGALMeshGenerator3D', 'SubDomain', 'DomainBoundary', 'LocalMeshData', 'MeshData', 'Hierarchical<dolfin::MeshFunction<std::size_t> >', 'MeshFunction<std::size_t>', 'CellFunction<std::size_t>', 'EdgeFunction<std::size_t>', 'FaceFunction<std::size_t>', 'FacetFunction<std::size_t>', 'VertexFunction<std::size_t>', 'Parameters', 'GlobalParameters', 'GenericLinearOperator', 'GenericMatrix', 'GenericPreconditioner', 'GenericTensor', 'GenericVector', 'LinearAlgebraObject', 'Scalar', 'Matrix', 'Vector', 'LinearOperator', 'STLMatrix', 'uBLASMatrix<boost::numeric::ublas::matrix<double> >', 'uBLASVector', 'PETScBaseMatrix', 'PETScLinearOperator', 'PETScKrylovSolver', 'PETScLUSolver', 'PETScMatrix', 'PETScObject', 'PETScPreconditioner', 'PETScVector', 'PETScUserPreconditioner', 'SLEPcEigenSolver', 'EpetraKrylovSolver', 'EpetraLUSolver', 'EpetraMatrix', 'EpetraSparsityPattern', 'EpetraVector', 'TrilinosPreconditioner', 'PaStiXLUSolver', 'UmfpackLUSolver', 'CholmodCholeskySolver', 'uBLASKrylovSolver', 'uBLASLinearOperator', 'LinearSolver', 'GenericLinearSolver', 'GenericLUSolver', 'KrylovSolver', 'LUSolver', 'GenericSparsityPattern', 'SparsityPattern', 'Table', 'GenericFile', 'File', 'XDMFFile', 'HDF5File', 'Lagrange', 'NewtonSolver', 'PETScSNESSolver', 'TAOLinearBoundSolver', 'VTKPlotter', 'GenericVTKPlottable', 'VTKPlottableMesh', 'VTKPlottableGenericFunction', 'VTKPlottableMeshFunction', 'ExpressionWrapper', 'Quadrature', 'LobattoQuadrature', 'RadauQuadrature', 'GaussQuadrature', 'GaussianQuadrature', 'MeshPointIntersection']

# An OrderedDict of all dolfin declared and its meta info
dolfin_type_def = OrderedDict([\
('ufc::function', {'header': 'ufc.h', 'submodule': '', 'derived': ['Function', 'MeshDisplacement', 'BasisFunction', 'GenericFunction', 'SpecialFacetFunction', 'MeshCoordinates', 'Constant', 'Expression', 'FacetArea'], 'bases': [], 'module': ''}),
('la_index', {'header': 'dolfin/common/types.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('Array', {'header': 'dolfin/common/Array.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('IndexSet', {'header': 'dolfin/common/IndexSet.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('Set', {'header': 'dolfin/common/Set.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('Timer', {'header': 'dolfin/common/Timer.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('Variable', {'header': 'dolfin/common/Variable.h', 'submodule': 'common', 'derived': ['GenericDofMap', 'CircleMesh', 'PETScVector', 'PETScLUSolver', 'CSGDifference', 'UnitCircleMesh', 'EpetraVector', 'Matrix', 'VTKPlotter', 'uBLASVector', 'UnitIntervalMesh', 'uBLASMatrix', 'GenericLinearOperator', 'UnitCube', 'MeshCoordinates', 'CSGCGALMeshGenerator3D', 'CSGPrimitive3D', 'FacetFunction', 'GenericTensor', 'FaceFunction', 'AdaptiveNonlinearVariationalSolver', 'EllipsoidMesh', 'UnitSquareMesh', 'CSGPrimitive', 'UmfpackLUSolver', 'TrilinosPreconditioner', 'CSGPrimitive2D', 'XDMFFile', 'Scalar', 'SparsityPattern', 'EpetraKrylovSolver', 'CSGCGALMeshGenerator2D', 'LinearVariationalSolver', 'LinearAlgebraObject', 'UnitInterval', 'GenericSparsityPattern', 'UnitCircle', 'BoundaryMesh', 'SphereMesh', 'AdaptiveLinearVariationalSolver', 'Circle', 'CSGIntersection', 'CSGOperator', 'CSGGeometry', 'CholmodCholeskySolver', 'CellFunction', 'LUSolver', 'MultiStageScheme', 'BoxMesh', 'MeshDisplacement', 'SubMesh', 'LinearOperator', 'Box', 'LinearSolver', 'PETScLinearOperator', 'UnitTetrahedronMesh', 'Lagrange', 'Vector', 'MeshValueCollection', 'KrylovSolver', 'GenericLUSolver', 'Cylinder', 'PETScPreconditioner', 'Cone', 'UnitSquare', 'GenericVector', 'VertexFunction', 'TimeSeriesHDF5', 'Rectangle', 'LocalMeshData', 'GenericMatrix', 'Mesh', 'IntervalMesh', 'MUMPSLUSolver', 'Tetrahedron', 'EpetraLUSolver', 'SpecialFacetFunction', 'Constant', 'Expression', 'CSGUnion', 'RectangleMesh', 'PETScMatrix', 'DofMap', 'GenericLinearSolver', 'SLEPcEigenSolver', 'Surface3D', 'uBLASKrylovSolver', 'Polygon', 'UnitCubeMesh', 'SubSpace', 'PointIntegralSolver', 'GenericAdaptiveVariationalSolver', 'ErrorControl', 'EpetraMatrix', 'EdgeFunction', 'Function', 'DirichletBC', 'UnitTriangleMesh', 'CCFEMDofMap', 'STLMatrix', 'PETScBaseMatrix', 'MeshFunction', 'TAOLinearBoundSolver', 'PETScKrylovSolver', 'HDF5File', 'TimeSeries', 'PaStiXLUSolver', 'FacetArea', 'GenericFunction', 'EllipseMesh', 'uBLASLinearOperator', 'NewtonSolver', 'NonlinearVariationalSolver', 'Sphere', 'FunctionSpace', 'Table', 'Ellipse', 'MeshData'], 'bases': [], 'module': 'common'}),
('Hierarchical', {'header': 'dolfin/common/Hierarchical.h', 'submodule': 'common', 'derived': ['UnitInterval', 'UnitCubeMesh', 'UnitCircle', 'CircleMesh', 'SubSpace', 'SphereMesh', 'LinearVariationalProblem', 'GoalFunctional', 'ErrorControl', 'VertexFunction', 'UnitCircleMesh', 'DirichletBC', 'UnitSquare', 'Function', 'Form', 'BoundaryMesh', 'UnitIntervalMesh', 'UnitTriangleMesh', 'CellFunction', 'UnitCube', 'Mesh', 'BoxMesh', 'EdgeFunction', 'IntervalMesh', 'SubMesh', 'MeshFunction', 'FacetFunction', 'UnitTetrahedronMesh', 'FaceFunction', 'EllipsoidMesh', 'UnitSquareMesh', 'NonlinearVariationalProblem', 'EllipseMesh', 'RectangleMesh', 'FunctionSpace'], 'bases': [], 'module': 'common'}),
('map_iterator', {'header': 'dolfin/common/MPI.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('map_const_iterator', {'header': 'dolfin/common/MPI.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('MPI', {'header': 'dolfin/common/MPI.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('MPINonblocking', {'header': 'dolfin/common/MPI.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('MPICommunicator', {'header': 'dolfin/common/MPI.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('MPIInfo', {'header': 'dolfin/common/MPI.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('SubSystemsManager', {'header': 'dolfin/common/SubSystemsManager.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('IntParameter', {'header': 'dolfin/parameter/Parameter.h', 'submodule': 'parameter', 'derived': [], 'bases': ['Parameter'], 'module': 'common'}),
('BoolParameter', {'header': 'dolfin/parameter/Parameter.h', 'submodule': 'parameter', 'derived': [], 'bases': ['Parameter'], 'module': 'common'}),
('StringParameter', {'header': 'dolfin/parameter/Parameter.h', 'submodule': 'parameter', 'derived': [], 'bases': ['Parameter'], 'module': 'common'}),
('Parameter', {'header': 'dolfin/parameter/Parameter.h', 'submodule': 'parameter', 'derived': ['IntParameter', 'BoolParameter', 'StringParameter', 'DoubleParameter'], 'bases': [], 'module': 'common'}),
('DoubleParameter', {'header': 'dolfin/parameter/Parameter.h', 'submodule': 'parameter', 'derived': [], 'bases': ['Parameter'], 'module': 'common'}),
('Parameters', {'header': 'dolfin/parameter/Parameters.h', 'submodule': 'parameter', 'derived': ['GlobalParameters'], 'bases': [], 'module': 'common'}),
('GlobalParameters', {'header': 'dolfin/parameter/GlobalParameters.h', 'submodule': 'parameter', 'derived': [], 'bases': ['Parameters'], 'module': 'common'}),
('Event', {'header': 'dolfin/log/Event.h', 'submodule': 'log', 'derived': [], 'bases': [], 'module': 'common'}),
('Progress', {'header': 'dolfin/log/Progress.h', 'submodule': 'log', 'derived': [], 'bases': [], 'module': 'common'}),
('Table', {'header': 'dolfin/log/Table.h', 'submodule': 'log', 'derived': [], 'bases': ['Variable'], 'module': 'common'}),
('TableEntry', {'header': 'dolfin/log/Table.h', 'submodule': 'log', 'derived': [], 'bases': [], 'module': 'common'}),
('ublas_sparse_matrix_cmajor', {'header': 'dolfin/la/ublas.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('ublas_vector_range', {'header': 'dolfin/la/ublas.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('ublas_assembly_matrix', {'header': 'dolfin/la/ublas.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('ublas_dense_matrix', {'header': 'dolfin/la/ublas.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('ublas_sparse_matrix', {'header': 'dolfin/la/ublas.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('ublas_matrix_cmajor_tri', {'header': 'dolfin/la/ublas.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('ublas_matrix_range', {'header': 'dolfin/la/ublas.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('ublas_matrix_cmajor_tri_column', {'header': 'dolfin/la/ublas.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('ublas_vector', {'header': 'dolfin/la/ublas.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('ublas_matrix_cmajor', {'header': 'dolfin/la/ublas.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('ublas_assembly_matrix_cmajor', {'header': 'dolfin/la/ublas.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('ublas_matrix_cmajor_tri_range', {'header': 'dolfin/la/ublas.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('ublas_matrix_cmajor_range', {'header': 'dolfin/la/ublas.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('E', {'header': 'dolfin/la/LinearAlgebraObject.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('LinearAlgebraObject', {'header': 'dolfin/la/LinearAlgebraObject.h', 'submodule': 'la', 'derived': ['GenericVector', 'Matrix', 'GenericMatrix', 'GenericTensor', 'uBLASMatrix', 'PETScMatrix', 'PETScVector', 'STLMatrix', 'Scalar', 'Vector', 'LinearOperator', 'uBLASVector', 'uBLASLinearOperator', 'EpetraMatrix', 'GenericLinearOperator', 'EpetraVector', 'PETScLinearOperator'], 'bases': ['Variable'], 'module': 'la'}),
('GenericLinearOperator', {'header': 'dolfin/la/GenericLinearOperator.h', 'submodule': 'la', 'derived': ['Matrix', 'STLMatrix', 'uBLASMatrix', 'PETScMatrix', 'uBLASLinearOperator', 'GenericMatrix', 'LinearOperator', 'EpetraMatrix', 'PETScLinearOperator'], 'bases': ['Variable', 'LinearAlgebraObject'], 'module': 'la'}),
('GenericTensor', {'header': 'dolfin/la/GenericTensor.h', 'submodule': 'la', 'derived': ['GenericVector', 'Matrix', 'STLMatrix', 'uBLASVector', 'uBLASMatrix', 'PETScMatrix', 'PETScVector', 'GenericMatrix', 'Scalar', 'Vector', 'EpetraMatrix', 'EpetraVector'], 'bases': ['Variable', 'LinearAlgebraObject'], 'module': 'la'}),
('GenericMatrix', {'header': 'dolfin/la/GenericMatrix.h', 'submodule': 'la', 'derived': ['STLMatrix', 'uBLASMatrix', 'EpetraMatrix', 'PETScMatrix', 'Matrix'], 'bases': ['Variable', 'GenericTensor', 'LinearAlgebraObject', 'GenericLinearOperator'], 'module': 'la'}),
('GenericSparsityPattern', {'header': 'dolfin/la/GenericSparsityPattern.h', 'submodule': 'la', 'derived': ['SparsityPattern'], 'bases': ['Variable'], 'module': 'la'}),
('GenericVector', {'header': 'dolfin/la/GenericVector.h', 'submodule': 'la', 'derived': ['uBLASVector', 'Vector', 'EpetraVector', 'PETScVector'], 'bases': ['Variable', 'GenericTensor', 'LinearAlgebraObject'], 'module': 'la'}),
('VectorSpaceBasis', {'header': 'dolfin/la/VectorSpaceBasis.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('GenericLinearSolver', {'header': 'dolfin/la/GenericLinearSolver.h', 'submodule': 'la', 'derived': ['GenericLUSolver', 'LinearSolver', 'UmfpackLUSolver', 'CholmodCholeskySolver', 'EpetraLUSolver', 'PETScKrylovSolver', 'PETScLUSolver', 'LUSolver', 'EpetraKrylovSolver', 'uBLASKrylovSolver', 'KrylovSolver'], 'bases': ['Variable'], 'module': 'la'}),
('GenericLUSolver', {'header': 'dolfin/la/GenericLUSolver.h', 'submodule': 'la', 'derived': ['PETScLUSolver', 'UmfpackLUSolver', 'LUSolver', 'EpetraLUSolver'], 'bases': ['Variable', 'GenericLinearSolver'], 'module': 'la'}),
('GenericPreconditioner', {'header': 'dolfin/la/GenericPreconditioner.h', 'submodule': 'la', 'derived': ['PETScPreconditioner', 'TrilinosPreconditioner'], 'bases': [], 'module': 'la'}),
('PETScOptions', {'header': 'dolfin/la/PETScOptions.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('PETScObject', {'header': 'dolfin/la/PETScObject.h', 'submodule': 'la', 'derived': ['PETScUserPreconditioner', 'PETScLinearOperator', 'PETScPreconditioner', 'PETScMatrix', 'PETScKrylovSolver', 'PETScVector', 'PETScLUSolver', 'PETScSNESSolver', 'TAOLinearBoundSolver', 'PETScBaseMatrix', 'SLEPcEigenSolver'], 'bases': [], 'module': 'la'}),
('PETScBaseMatrix', {'header': 'dolfin/la/PETScBaseMatrix.h', 'submodule': 'la', 'derived': ['PETScMatrix', 'PETScLinearOperator'], 'bases': ['Variable', 'PETScObject'], 'module': 'la'}),
('PETScMatrixDeleter', {'header': 'dolfin/la/PETScBaseMatrix.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('uBLASFactory', {'header': 'dolfin/la/uBLASFactory.h', 'submodule': 'la', 'derived': [], 'bases': ['GenericLinearAlgebraFactory'], 'module': 'la'}),
('tuple', {'header': 'dolfin/la/uBLASMatrix.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('uBLASMatrix', {'header': 'dolfin/la/uBLASMatrix.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericMatrix', 'LinearAlgebraObject', 'GenericLinearOperator', 'GenericTensor'], 'module': 'la'}),
('uBLASLinearOperator', {'header': 'dolfin/la/uBLASLinearOperator.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'LinearAlgebraObject', 'GenericLinearOperator'], 'module': 'la'}),
('PETScMatrix', {'header': 'dolfin/la/PETScMatrix.h', 'submodule': 'la', 'derived': [], 'bases': ['LinearAlgebraObject', 'GenericTensor', 'GenericLinearOperator', 'PETScObject', 'GenericMatrix', 'Variable', 'PETScBaseMatrix'], 'module': 'la'}),
('PETScLinearOperator', {'header': 'dolfin/la/PETScLinearOperator.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'PETScBaseMatrix', 'LinearAlgebraObject', 'GenericLinearOperator', 'PETScObject'], 'module': 'la'}),
('PETScPreconditioner', {'header': 'dolfin/la/PETScPreconditioner.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericPreconditioner', 'PETScObject'], 'module': 'la'}),
('EpetraLUSolver', {'header': 'dolfin/la/EpetraLUSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['GenericLUSolver', 'Variable', 'GenericLinearSolver'], 'module': 'la'}),
('EpetraKrylovSolver', {'header': 'dolfin/la/EpetraKrylovSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericLinearSolver'], 'module': 'la'}),
('EpetraMatrix', {'header': 'dolfin/la/EpetraMatrix.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericMatrix', 'LinearAlgebraObject', 'GenericLinearOperator', 'GenericTensor'], 'module': 'la'}),
('EpetraVector', {'header': 'dolfin/la/EpetraVector.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericTensor', 'GenericVector', 'LinearAlgebraObject'], 'module': 'la'}),
('PETScKrylovSolver', {'header': 'dolfin/la/PETScKrylovSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericLinearSolver', 'PETScObject'], 'module': 'la'}),
('PETScLUSolver', {'header': 'dolfin/la/PETScLUSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['GenericLUSolver', 'Variable', 'GenericLinearSolver', 'PETScObject'], 'module': 'la'}),
('CholmodCholeskySolver', {'header': 'dolfin/la/CholmodCholeskySolver.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericLinearSolver'], 'module': 'la'}),
('UmfpackLUSolver', {'header': 'dolfin/la/UmfpackLUSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['GenericLUSolver', 'Variable', 'GenericLinearSolver'], 'module': 'la'}),
('MUMPSLUSolver', {'header': 'dolfin/la/MUMPSLUSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable'], 'module': 'la'}),
('PaStiXLUSolver', {'header': 'dolfin/la/PaStiXLUSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable'], 'module': 'la'}),
('STLMatrix', {'header': 'dolfin/la/STLMatrix.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericMatrix', 'LinearAlgebraObject', 'GenericLinearOperator', 'GenericTensor'], 'module': 'la'}),
('CoordinateMatrix', {'header': 'dolfin/la/CoordinateMatrix.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('uBLASVector', {'header': 'dolfin/la/uBLASVector.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericTensor', 'GenericVector', 'LinearAlgebraObject'], 'module': 'la'}),
('PETScVector', {'header': 'dolfin/la/PETScVector.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericTensor', 'GenericVector', 'LinearAlgebraObject', 'PETScObject'], 'module': 'la'}),
('PETScVectorDeleter', {'header': 'dolfin/la/PETScVector.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('SparsityPattern', {'header': 'dolfin/la/SparsityPattern.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericSparsityPattern'], 'module': 'la'}),
('GenericLinearAlgebraFactory', {'header': 'dolfin/la/GenericLinearAlgebraFactory.h', 'submodule': 'la', 'derived': ['DefaultFactory', 'EpetraFactory', 'PETScFactory', 'uBLASFactory', 'STLFactory', 'PETScCuspFactory'], 'bases': [], 'module': 'la'}),
('DefaultFactory', {'header': 'dolfin/la/DefaultFactory.h', 'submodule': 'la', 'derived': [], 'bases': ['GenericLinearAlgebraFactory'], 'module': 'la'}),
('PETScUserPreconditioner', {'header': 'dolfin/la/PETScUserPreconditioner.h', 'submodule': 'la', 'derived': [], 'bases': ['PETScObject'], 'module': 'la'}),
('PETScFactory', {'header': 'dolfin/la/PETScFactory.h', 'submodule': 'la', 'derived': [], 'bases': ['GenericLinearAlgebraFactory'], 'module': 'la'}),
('PETScCuspFactory', {'header': 'dolfin/la/PETScCuspFactory.h', 'submodule': 'la', 'derived': [], 'bases': ['GenericLinearAlgebraFactory'], 'module': 'la'}),
('EpetraFactory', {'header': 'dolfin/la/EpetraFactory.h', 'submodule': 'la', 'derived': [], 'bases': ['GenericLinearAlgebraFactory'], 'module': 'la'}),
('STLFactory', {'header': 'dolfin/la/STLFactory.h', 'submodule': 'la', 'derived': [], 'bases': ['GenericLinearAlgebraFactory'], 'module': 'la'}),
('SLEPcEigenSolver', {'header': 'dolfin/la/SLEPcEigenSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'PETScObject'], 'module': 'la'}),
('TrilinosPreconditioner', {'header': 'dolfin/la/TrilinosPreconditioner.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericPreconditioner'], 'module': 'la'}),
('uBLASSparseMatrix', {'header': 'dolfin/la/uBLASSparseMatrix.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('uBLASDenseMatrix', {'header': 'dolfin/la/uBLASDenseMatrix.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('uBLASPreconditioner', {'header': 'dolfin/la/uBLASPreconditioner.h', 'submodule': 'la', 'derived': ['uBLASILUPreconditioner'], 'bases': [], 'module': 'la'}),
('uBLASKrylovSolver', {'header': 'dolfin/la/uBLASKrylovSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericLinearSolver'], 'module': 'la'}),
('uBLASILUPreconditioner', {'header': 'dolfin/la/uBLASILUPreconditioner.h', 'submodule': 'la', 'derived': [], 'bases': ['uBLASPreconditioner'], 'module': 'la'}),
('Vector', {'header': 'dolfin/la/Vector.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericTensor', 'GenericVector', 'LinearAlgebraObject'], 'module': 'la'}),
('Matrix', {'header': 'dolfin/la/Matrix.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericMatrix', 'LinearAlgebraObject', 'GenericLinearOperator', 'GenericTensor'], 'module': 'la'}),
('Scalar', {'header': 'dolfin/la/Scalar.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericTensor', 'LinearAlgebraObject'], 'module': 'la'}),
('LinearSolver', {'header': 'dolfin/la/LinearSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericLinearSolver'], 'module': 'la'}),
('KrylovSolver', {'header': 'dolfin/la/KrylovSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericLinearSolver'], 'module': 'la'}),
('LUSolver', {'header': 'dolfin/la/LUSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['GenericLUSolver', 'Variable', 'GenericLinearSolver'], 'module': 'la'}),
('BlockVector', {'header': 'dolfin/la/BlockVector.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('BlockMatrix', {'header': 'dolfin/la/BlockMatrix.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('TensorProductVector', {'header': 'dolfin/la/TensorProductVector.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('TensorProductMatrix', {'header': 'dolfin/la/TensorProductMatrix.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('LinearOperator', {'header': 'dolfin/la/LinearOperator.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'LinearAlgebraObject', 'GenericLinearOperator'], 'module': 'la'}),
('NonlinearProblem', {'header': 'dolfin/nls/NonlinearProblem.h', 'submodule': 'nls', 'derived': [], 'bases': [], 'module': 'la'}),
('NewtonSolver', {'header': 'dolfin/nls/NewtonSolver.h', 'submodule': 'nls', 'derived': [], 'bases': ['Variable'], 'module': 'la'}),
('PETScSNESSolver', {'header': 'dolfin/nls/PETScSNESSolver.h', 'submodule': 'nls', 'derived': [], 'bases': ['PETScObject'], 'module': 'la'}),
('TAOLinearBoundSolver', {'header': 'dolfin/nls/TAOLinearBoundSolver.h', 'submodule': 'nls', 'derived': [], 'bases': ['Variable', 'PETScObject'], 'module': 'la'}),
('CellType', {'header': 'dolfin/mesh/CellType.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshTopology', {'header': 'dolfin/mesh/MeshTopology.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshGeometry', {'header': 'dolfin/mesh/MeshGeometry.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshDomains', {'header': 'dolfin/mesh/MeshDomains.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshData', {'header': 'dolfin/mesh/MeshData.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable'], 'module': 'mesh'}),
('Mesh', {'header': 'dolfin/mesh/Mesh.h', 'submodule': 'mesh', 'derived': ['RectangleMesh', 'UnitCubeMesh', 'EllipseMesh', 'UnitCube', 'UnitCircle', 'CircleMesh', 'UnitTetrahedronMesh', 'BoxMesh', 'UnitTriangleMesh', 'SphereMesh', 'EllipsoidMesh', 'UnitSquareMesh', 'UnitSquare', 'BoundaryMesh', 'UnitCircleMesh', 'IntervalMesh', 'UnitIntervalMesh', 'SubMesh', 'UnitInterval'], 'bases': ['Variable', 'Hierarchical'], 'module': 'mesh'}),
('MeshEntity', {'header': 'dolfin/mesh/MeshEntity.h', 'submodule': 'mesh', 'derived': ['Cell', 'Vertex', 'Face', 'Facet', 'Edge', 'FacetCell'], 'bases': [], 'module': 'mesh'}),
('MeshEntityIterator', {'header': 'dolfin/mesh/MeshEntityIterator.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshEntityIteratorBase', {'header': 'dolfin/mesh/MeshEntityIteratorBase.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('SubsetIterator', {'header': 'dolfin/mesh/SubsetIterator.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('VertexIterator', {'header': 'dolfin/mesh/Vertex.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('VertexFunction', {'header': 'dolfin/mesh/Vertex.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable', 'Hierarchical', 'MeshFunction'], 'module': 'mesh'}),
('Vertex', {'header': 'dolfin/mesh/Vertex.h', 'submodule': 'mesh', 'derived': [], 'bases': ['MeshEntity'], 'module': 'mesh'}),
('EdgeIterator', {'header': 'dolfin/mesh/Edge.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('Edge', {'header': 'dolfin/mesh/Edge.h', 'submodule': 'mesh', 'derived': [], 'bases': ['MeshEntity'], 'module': 'mesh'}),
('EdgeFunction', {'header': 'dolfin/mesh/Edge.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable', 'Hierarchical', 'MeshFunction'], 'module': 'mesh'}),
('FaceIterator', {'header': 'dolfin/mesh/Face.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('FaceFunction', {'header': 'dolfin/mesh/Face.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable', 'Hierarchical', 'MeshFunction'], 'module': 'mesh'}),
('Face', {'header': 'dolfin/mesh/Face.h', 'submodule': 'mesh', 'derived': [], 'bases': ['MeshEntity'], 'module': 'mesh'}),
('FacetIterator', {'header': 'dolfin/mesh/Facet.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('Facet', {'header': 'dolfin/mesh/Facet.h', 'submodule': 'mesh', 'derived': [], 'bases': ['MeshEntity'], 'module': 'mesh'}),
('FacetFunction', {'header': 'dolfin/mesh/Facet.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable', 'Hierarchical', 'MeshFunction'], 'module': 'mesh'}),
('CellIterator', {'header': 'dolfin/mesh/Cell.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('Cell', {'header': 'dolfin/mesh/Cell.h', 'submodule': 'mesh', 'derived': ['FacetCell'], 'bases': ['MeshEntity'], 'module': 'mesh'}),
('CellFunction', {'header': 'dolfin/mesh/Cell.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable', 'Hierarchical', 'MeshFunction'], 'module': 'mesh'}),
('FacetCell', {'header': 'dolfin/mesh/FacetCell.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Cell', 'MeshEntity'], 'module': 'mesh'}),
('MeshConnectivity', {'header': 'dolfin/mesh/MeshConnectivity.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshEditor', {'header': 'dolfin/mesh/MeshEditor.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('DynamicMeshEditor', {'header': 'dolfin/mesh/DynamicMeshEditor.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('LocalMeshValueCollection', {'header': 'dolfin/mesh/LocalMeshValueCollection.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshFunction', {'header': 'dolfin/mesh/MeshFunction.h', 'submodule': 'mesh', 'derived': ['VertexFunction', 'FacetFunction', 'FaceFunction', 'CellFunction', 'EdgeFunction'], 'bases': ['Variable', 'Hierarchical'], 'module': 'mesh'}),
('MeshPartitioning', {'header': 'dolfin/mesh/MeshPartitioning.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshValueCollection', {'header': 'dolfin/mesh/MeshValueCollection.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable'], 'module': 'mesh'}),
('MeshColoring', {'header': 'dolfin/mesh/MeshColoring.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshRenumbering', {'header': 'dolfin/mesh/MeshRenumbering.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshTransformation', {'header': 'dolfin/mesh/MeshTransformation.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('LocalMeshData', {'header': 'dolfin/mesh/LocalMeshData.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable'], 'module': 'mesh'}),
('SubDomain', {'header': 'dolfin/mesh/SubDomain.h', 'submodule': 'mesh', 'derived': ['DomainBoundary'], 'bases': [], 'module': 'mesh'}),
('SubMesh', {'header': 'dolfin/mesh/SubMesh.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('Restriction', {'header': 'dolfin/mesh/Restriction.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('DomainBoundary', {'header': 'dolfin/mesh/DomainBoundary.h', 'submodule': 'mesh', 'derived': [], 'bases': ['SubDomain'], 'module': 'mesh'}),
('BoundaryMesh', {'header': 'dolfin/mesh/BoundaryMesh.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('PeriodicBoundaryComputation', {'header': 'dolfin/mesh/PeriodicBoundaryComputation.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshQuality', {'header': 'dolfin/mesh/MeshQuality.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('ImplicitDomainMeshGenerator', {'header': 'dolfin/generation/ImplicitDomainMeshGenerator.h', 'submodule': 'generation', 'derived': [], 'bases': [], 'module': 'mesh'}),
('PolygonalMeshGenerator', {'header': 'dolfin/generation/PolygonalMeshGenerator.h', 'submodule': 'generation', 'derived': [], 'bases': [], 'module': 'mesh'}),
('PolyhedralMeshGenerator', {'header': 'dolfin/generation/PolyhedralMeshGenerator.h', 'submodule': 'generation', 'derived': [], 'bases': [], 'module': 'mesh'}),
('Triangulate', {'header': 'dolfin/generation/Triangulate.h', 'submodule': 'generation', 'derived': [], 'bases': [], 'module': 'mesh'}),
('BoxMesh', {'header': 'dolfin/generation/BoxMesh.h', 'submodule': 'generation', 'derived': ['UnitCube', 'UnitCubeMesh'], 'bases': ['Variable', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('CircleMesh', {'header': 'dolfin/generation/EllipseMesh.h', 'submodule': 'generation', 'derived': ['UnitCircle', 'UnitCircleMesh'], 'bases': ['Variable', 'Mesh', 'Hierarchical', 'EllipseMesh'], 'module': 'mesh'}),
('EllipseMesh', {'header': 'dolfin/generation/EllipseMesh.h', 'submodule': 'generation', 'derived': ['UnitCircle', 'CircleMesh', 'UnitCircleMesh'], 'bases': ['Variable', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('EllipsoidMesh', {'header': 'dolfin/generation/EllipsoidMesh.h', 'submodule': 'generation', 'derived': ['SphereMesh'], 'bases': ['Variable', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('SphereMesh', {'header': 'dolfin/generation/EllipsoidMesh.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'EllipsoidMesh', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('IntervalMesh', {'header': 'dolfin/generation/IntervalMesh.h', 'submodule': 'generation', 'derived': ['UnitIntervalMesh', 'UnitInterval'], 'bases': ['Variable', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('RectangleMesh', {'header': 'dolfin/generation/RectangleMesh.h', 'submodule': 'generation', 'derived': ['UnitSquareMesh', 'UnitSquare'], 'bases': ['Variable', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('UnitTetrahedronMesh', {'header': 'dolfin/generation/UnitTetrahedronMesh.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('UnitCubeMesh', {'header': 'dolfin/generation/UnitCubeMesh.h', 'submodule': 'generation', 'derived': ['UnitCube'], 'bases': ['Variable', 'Mesh', 'Hierarchical', 'BoxMesh'], 'module': 'mesh'}),
('UnitCube', {'header': 'dolfin/generation/UnitCube.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'Mesh', 'Hierarchical', 'UnitCubeMesh', 'BoxMesh'], 'module': 'mesh'}),
('UnitIntervalMesh', {'header': 'dolfin/generation/UnitIntervalMesh.h', 'submodule': 'generation', 'derived': ['UnitInterval'], 'bases': ['Variable', 'Mesh', 'IntervalMesh', 'Hierarchical'], 'module': 'mesh'}),
('UnitInterval', {'header': 'dolfin/generation/UnitInterval.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'UnitIntervalMesh', 'Mesh', 'IntervalMesh', 'Hierarchical'], 'module': 'mesh'}),
('UnitTriangleMesh', {'header': 'dolfin/generation/UnitTriangleMesh.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('UnitSquareMesh', {'header': 'dolfin/generation/UnitSquareMesh.h', 'submodule': 'generation', 'derived': ['UnitSquare'], 'bases': ['Variable', 'RectangleMesh', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('UnitSquare', {'header': 'dolfin/generation/UnitSquare.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'RectangleMesh', 'UnitSquareMesh', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('UnitCircleMesh', {'header': 'dolfin/generation/UnitCircleMesh.h', 'submodule': 'generation', 'derived': ['UnitCircle'], 'bases': ['Variable', 'CircleMesh', 'Mesh', 'Hierarchical', 'EllipseMesh'], 'module': 'mesh'}),
('UnitCircle', {'header': 'dolfin/generation/UnitCircle.h', 'submodule': 'generation', 'derived': [], 'bases': ['EllipseMesh', 'CircleMesh', 'Hierarchical', 'Variable', 'Mesh', 'UnitCircleMesh'], 'module': 'mesh'}),
('CSGGeometry', {'header': 'dolfin/generation/CSGGeometry.h', 'submodule': 'generation', 'derived': ['Box', 'CSGOperator', 'CSGPrimitive2D', 'Polygon', 'CSGUnion', 'Sphere', 'Tetrahedron', 'Cylinder', 'Ellipse', 'CSGDifference', 'CSGPrimitive', 'Surface3D', 'Circle', 'CSGPrimitive3D', 'CSGIntersection', 'Rectangle', 'Cone'], 'bases': ['Variable'], 'module': 'mesh'}),
('CSGMeshGenerator', {'header': 'dolfin/generation/CSGMeshGenerator.h', 'submodule': 'generation', 'derived': [], 'bases': [], 'module': 'mesh'}),
('CSGCGALMeshGenerator2D', {'header': 'dolfin/generation/CSGCGALMeshGenerator2D.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable'], 'module': 'mesh'}),
('CSGCGALMeshGenerator3D', {'header': 'dolfin/generation/CSGCGALMeshGenerator3D.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable'], 'module': 'mesh'}),
('CSGDifference', {'header': 'dolfin/generation/CSGOperators.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'CSGOperator', 'CSGGeometry'], 'module': 'mesh'}),
('CSGOperator', {'header': 'dolfin/generation/CSGOperators.h', 'submodule': 'generation', 'derived': ['CSGDifference', 'CSGIntersection', 'CSGUnion'], 'bases': ['Variable', 'CSGGeometry'], 'module': 'mesh'}),
('CSGIntersection', {'header': 'dolfin/generation/CSGOperators.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'CSGOperator', 'CSGGeometry'], 'module': 'mesh'}),
('CSGUnion', {'header': 'dolfin/generation/CSGOperators.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'CSGOperator', 'CSGGeometry'], 'module': 'mesh'}),
('CSGPrimitive', {'header': 'dolfin/generation/CSGPrimitive.h', 'submodule': 'generation', 'derived': ['Box', 'Cylinder', 'CSGPrimitive2D', 'Polygon', 'Tetrahedron', 'Sphere', 'Surface3D', 'Circle', 'CSGPrimitive3D', 'Ellipse', 'Rectangle', 'Cone'], 'bases': ['Variable', 'CSGGeometry'], 'module': 'mesh'}),
('Circle', {'header': 'dolfin/generation/CSGPrimitives2D.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'CSGPrimitive', 'CSGGeometry', 'CSGPrimitive2D'], 'module': 'mesh'}),
('CSGPrimitive2D', {'header': 'dolfin/generation/CSGPrimitives2D.h', 'submodule': 'generation', 'derived': ['Circle', 'Ellipse', 'Rectangle', 'Polygon'], 'bases': ['Variable', 'CSGGeometry', 'CSGPrimitive'], 'module': 'mesh'}),
('Ellipse', {'header': 'dolfin/generation/CSGPrimitives2D.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'CSGPrimitive', 'CSGGeometry', 'CSGPrimitive2D'], 'module': 'mesh'}),
('Rectangle', {'header': 'dolfin/generation/CSGPrimitives2D.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'CSGPrimitive', 'CSGGeometry', 'CSGPrimitive2D'], 'module': 'mesh'}),
('Polygon', {'header': 'dolfin/generation/CSGPrimitives2D.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'CSGPrimitive', 'CSGGeometry', 'CSGPrimitive2D'], 'module': 'mesh'}),
('Box', {'header': 'dolfin/generation/CSGPrimitives3D.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'CSGGeometry', 'CSGPrimitive3D', 'CSGPrimitive'], 'module': 'mesh'}),
('Cylinder', {'header': 'dolfin/generation/CSGPrimitives3D.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'CSGGeometry', 'CSGPrimitive3D', 'CSGPrimitive', 'Cone'], 'module': 'mesh'}),
('Tetrahedron', {'header': 'dolfin/generation/CSGPrimitives3D.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'CSGGeometry', 'CSGPrimitive3D', 'CSGPrimitive'], 'module': 'mesh'}),
('Sphere', {'header': 'dolfin/generation/CSGPrimitives3D.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'CSGGeometry', 'CSGPrimitive3D', 'CSGPrimitive'], 'module': 'mesh'}),
('Cone', {'header': 'dolfin/generation/CSGPrimitives3D.h', 'submodule': 'generation', 'derived': ['Cylinder'], 'bases': ['Variable', 'CSGGeometry', 'CSGPrimitive3D', 'CSGPrimitive'], 'module': 'mesh'}),
('CSGPrimitive3D', {'header': 'dolfin/generation/CSGPrimitives3D.h', 'submodule': 'generation', 'derived': ['Box', 'Cylinder', 'Tetrahedron', 'Sphere', 'Surface3D', 'Cone'], 'bases': ['Variable', 'CSGGeometry', 'CSGPrimitive'], 'module': 'mesh'}),
('Surface3D', {'header': 'dolfin/generation/CSGPrimitives3D.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'CSGGeometry', 'CSGPrimitive3D', 'CSGPrimitive'], 'module': 'mesh'}),
('CSGGeometries', {'header': 'dolfin/generation/CSGGeometries3D.h', 'submodule': 'generation', 'derived': [], 'bases': [], 'module': 'mesh'}),
('ImplicitSurface', {'header': 'dolfin/geometry/ImplicitSurface.h', 'submodule': 'geometry', 'derived': [], 'bases': [], 'module': 'mesh'}),
('Point', {'header': 'dolfin/geometry/Point.h', 'submodule': 'geometry', 'derived': [], 'bases': [], 'module': 'mesh'}),
('BoundingBoxTree', {'header': 'dolfin/geometry/BoundingBoxTree.h', 'submodule': 'geometry', 'derived': [], 'bases': [], 'module': 'mesh'}),
('GenericBoundingBoxTree', {'header': 'dolfin/geometry/GenericBoundingBoxTree.h', 'submodule': 'geometry', 'derived': ['BoundingBoxTree3D'], 'bases': [], 'module': 'mesh'}),
('BoundingBoxTree3D', {'header': 'dolfin/geometry/BoundingBoxTree3D.h', 'submodule': 'geometry', 'derived': [], 'bases': ['GenericBoundingBoxTree'], 'module': 'mesh'}),
('MeshPointIntersection', {'header': 'dolfin/geometry/MeshPointIntersection.h', 'submodule': 'geometry', 'derived': [], 'bases': [], 'module': 'mesh'}),
('graph_set_type', {'header': 'dolfin/graph/Graph.h', 'submodule': 'graph', 'derived': [], 'bases': [], 'module': 'mesh'}),
('Graph', {'header': 'dolfin/graph/Graph.h', 'submodule': 'graph', 'derived': [], 'bases': [], 'module': 'mesh'}),
('GraphBuilder', {'header': 'dolfin/graph/GraphBuilder.h', 'submodule': 'graph', 'derived': [], 'bases': [], 'module': 'mesh'}),
('BoostGraphOrdering', {'header': 'dolfin/graph/BoostGraphOrdering.h', 'submodule': 'graph', 'derived': [], 'bases': [], 'module': 'mesh'}),
('SCOTCH', {'header': 'dolfin/graph/SCOTCH.h', 'submodule': 'graph', 'derived': [], 'bases': [], 'module': 'mesh'}),
('ALE', {'header': 'dolfin/ale/ALE.h', 'submodule': 'ale', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshDisplacement', {'header': 'dolfin/ale/MeshDisplacement.h', 'submodule': 'ale', 'derived': [], 'bases': ['Variable', 'GenericFunction', 'Expression', 'ufc::function'], 'module': 'mesh'}),
('GenericFunction', {'header': 'dolfin/function/GenericFunction.h', 'submodule': 'function', 'derived': ['Function', 'MeshDisplacement', 'Constant', 'SpecialFacetFunction', 'MeshCoordinates', 'Expression', 'FacetArea'], 'bases': ['Variable', 'ufc::function'], 'module': 'function'}),
('Expression', {'header': 'dolfin/function/Expression.h', 'submodule': 'function', 'derived': ['MeshDisplacement', 'FacetArea', 'Constant', 'SpecialFacetFunction', 'MeshCoordinates'], 'bases': ['Variable', 'ufc::function', 'GenericFunction'], 'module': 'function'}),
('FunctionAXPY', {'header': 'dolfin/function/FunctionAXPY.h', 'submodule': 'function', 'derived': [], 'bases': [], 'module': 'function'}),
('Function', {'header': 'dolfin/function/Function.h', 'submodule': 'function', 'derived': [], 'bases': ['Variable', 'ufc::function', 'Hierarchical', 'GenericFunction'], 'module': 'function'}),
('FunctionSpace', {'header': 'dolfin/function/FunctionSpace.h', 'submodule': 'function', 'derived': ['SubSpace'], 'bases': ['Variable', 'Hierarchical'], 'module': 'function'}),
('SubSpace', {'header': 'dolfin/function/SubSpace.h', 'submodule': 'function', 'derived': [], 'bases': ['Variable', 'Hierarchical', 'FunctionSpace'], 'module': 'function'}),
('Constant', {'header': 'dolfin/function/Constant.h', 'submodule': 'function', 'derived': [], 'bases': ['Variable', 'ufc::function', 'Expression', 'GenericFunction'], 'module': 'function'}),
('FacetArea', {'header': 'dolfin/function/SpecialFunctions.h', 'submodule': 'function', 'derived': [], 'bases': ['Variable', 'ufc::function', 'Expression', 'GenericFunction'], 'module': 'function'}),
('MeshCoordinates', {'header': 'dolfin/function/SpecialFunctions.h', 'submodule': 'function', 'derived': [], 'bases': ['Variable', 'ufc::function', 'Expression', 'GenericFunction'], 'module': 'function'}),
('SpecialFacetFunction', {'header': 'dolfin/function/SpecialFacetFunction.h', 'submodule': 'function', 'derived': [], 'bases': ['Variable', 'ufc::function', 'Expression', 'GenericFunction'], 'module': 'function'}),
('CCFEMFunctionSpace', {'header': 'dolfin/function/CCFEMFunctionSpace.h', 'submodule': 'function', 'derived': [], 'bases': [], 'module': 'function'}),
('FunctionAssigner', {'header': 'dolfin/function/FunctionAssigner.h', 'submodule': 'function', 'derived': [], 'bases': [], 'module': 'function'}),
('CCFEMFunction', {'header': 'dolfin/function/CCFEMFunction.h', 'submodule': 'function', 'derived': [], 'bases': [], 'module': 'function'}),
('Lagrange', {'header': 'dolfin/math/Lagrange.h', 'submodule': 'math', 'derived': [], 'bases': ['Variable'], 'module': 'function'}),
('Legendre', {'header': 'dolfin/math/Legendre.h', 'submodule': 'math', 'derived': [], 'bases': [], 'module': 'function'}),
('GenericDofMap', {'header': 'dolfin/fem/GenericDofMap.h', 'submodule': 'fem', 'derived': ['DofMap', 'CCFEMDofMap'], 'bases': ['Variable'], 'module': 'fem'}),
('DofMap', {'header': 'dolfin/fem/DofMap.h', 'submodule': 'fem', 'derived': [], 'bases': ['Variable', 'GenericDofMap'], 'module': 'fem'}),
('Equation', {'header': 'dolfin/fem/Equation.h', 'submodule': 'fem', 'derived': [], 'bases': [], 'module': 'fem'}),
('FiniteElement', {'header': 'dolfin/fem/FiniteElement.h', 'submodule': 'fem', 'derived': [], 'bases': [], 'module': 'fem'}),
('BasisFunction', {'header': 'dolfin/fem/BasisFunction.h', 'submodule': 'fem', 'derived': [], 'bases': ['ufc::function'], 'module': 'fem'}),
('DirichletBC', {'header': 'dolfin/fem/DirichletBC.h', 'submodule': 'fem', 'derived': [], 'bases': ['Variable', 'Hierarchical'], 'module': 'fem'}),
('PointSource', {'header': 'dolfin/fem/PointSource.h', 'submodule': 'fem', 'derived': [], 'bases': [], 'module': 'fem'}),
('LocalSolver', {'header': 'dolfin/fem/LocalSolver.h', 'submodule': 'fem', 'derived': [], 'bases': [], 'module': 'fem'}),
('Form', {'header': 'dolfin/fem/Form.h', 'submodule': 'fem', 'derived': ['GoalFunctional'], 'bases': ['Hierarchical'], 'module': 'fem'}),
('AssemblerBase', {'header': 'dolfin/fem/AssemblerBase.h', 'submodule': 'fem', 'derived': ['SystemAssembler', 'Assembler', 'OpenMpAssembler'], 'bases': [], 'module': 'fem'}),
('Assembler', {'header': 'dolfin/fem/Assembler.h', 'submodule': 'fem', 'derived': [], 'bases': ['AssemblerBase'], 'module': 'fem'}),
('SparsityPatternBuilder', {'header': 'dolfin/fem/SparsityPatternBuilder.h', 'submodule': 'fem', 'derived': [], 'bases': [], 'module': 'fem'}),
('SystemAssembler', {'header': 'dolfin/fem/SystemAssembler.h', 'submodule': 'fem', 'derived': [], 'bases': ['AssemblerBase'], 'module': 'fem'}),
('LinearVariationalProblem', {'header': 'dolfin/fem/LinearVariationalProblem.h', 'submodule': 'fem', 'derived': [], 'bases': ['Hierarchical'], 'module': 'fem'}),
('LinearVariationalSolver', {'header': 'dolfin/fem/LinearVariationalSolver.h', 'submodule': 'fem', 'derived': [], 'bases': ['Variable'], 'module': 'fem'}),
('NonlinearVariationalProblem', {'header': 'dolfin/fem/NonlinearVariationalProblem.h', 'submodule': 'fem', 'derived': [], 'bases': ['Hierarchical'], 'module': 'fem'}),
('NonlinearVariationalSolver', {'header': 'dolfin/fem/NonlinearVariationalSolver.h', 'submodule': 'fem', 'derived': [], 'bases': ['Variable'], 'module': 'fem'}),
('CCFEMForm', {'header': 'dolfin/fem/CCFEMForm.h', 'submodule': 'fem', 'derived': [], 'bases': [], 'module': 'fem'}),
('CCFEMDofMap', {'header': 'dolfin/fem/CCFEMDofMap.h', 'submodule': 'fem', 'derived': [], 'bases': ['Variable', 'GenericDofMap'], 'module': 'fem'}),
('CCFEMAssembler', {'header': 'dolfin/fem/CCFEMAssembler.h', 'submodule': 'fem', 'derived': [], 'bases': [], 'module': 'fem'}),
('OpenMpAssembler', {'header': 'dolfin/fem/OpenMpAssembler.h', 'submodule': 'fem', 'derived': [], 'bases': ['AssemblerBase'], 'module': 'fem'}),
('VariationalProblem', {'header': 'dolfin/fem/VariationalProblem.h', 'submodule': 'fem', 'derived': [], 'bases': [], 'module': 'fem'}),
('MultiStageScheme', {'header': 'dolfin/multistage/MultiStageScheme.h', 'submodule': 'multistage', 'derived': [], 'bases': ['Variable'], 'module': 'fem'}),
('RKSolver', {'header': 'dolfin/multistage/RKSolver.h', 'submodule': 'multistage', 'derived': [], 'bases': [], 'module': 'fem'}),
('PointIntegralSolver', {'header': 'dolfin/multistage/PointIntegralSolver.h', 'submodule': 'multistage', 'derived': [], 'bases': ['Variable'], 'module': 'fem'}),
('GenericAdaptiveVariationalSolver', {'header': 'dolfin/adaptivity/GenericAdaptiveVariationalSolver.h', 'submodule': 'adaptivity', 'derived': ['AdaptiveLinearVariationalSolver', 'AdaptiveNonlinearVariationalSolver'], 'bases': ['Variable'], 'module': 'fem'}),
('AdaptiveLinearVariationalSolver', {'header': 'dolfin/adaptivity/AdaptiveLinearVariationalSolver.h', 'submodule': 'adaptivity', 'derived': [], 'bases': ['Variable', 'GenericAdaptiveVariationalSolver'], 'module': 'fem'}),
('AdaptiveNonlinearVariationalSolver', {'header': 'dolfin/adaptivity/AdaptiveNonlinearVariationalSolver.h', 'submodule': 'adaptivity', 'derived': [], 'bases': ['Variable', 'GenericAdaptiveVariationalSolver'], 'module': 'fem'}),
('GoalFunctional', {'header': 'dolfin/adaptivity/GoalFunctional.h', 'submodule': 'adaptivity', 'derived': [], 'bases': ['Hierarchical', 'Form'], 'module': 'fem'}),
('ErrorControl', {'header': 'dolfin/adaptivity/ErrorControl.h', 'submodule': 'adaptivity', 'derived': [], 'bases': ['Variable', 'Hierarchical'], 'module': 'fem'}),
('Extrapolation', {'header': 'dolfin/adaptivity/Extrapolation.h', 'submodule': 'adaptivity', 'derived': [], 'bases': [], 'module': 'fem'}),
('LocalAssembler', {'header': 'dolfin/adaptivity/LocalAssembler.h', 'submodule': 'adaptivity', 'derived': [], 'bases': [], 'module': 'fem'}),
('TimeSeries', {'header': 'dolfin/adaptivity/TimeSeries.h', 'submodule': 'adaptivity', 'derived': [], 'bases': ['Variable'], 'module': 'fem'}),
('TimeSeriesHDF5', {'header': 'dolfin/adaptivity/TimeSeriesHDF5.h', 'submodule': 'adaptivity', 'derived': [], 'bases': ['Variable'], 'module': 'fem'}),
('VTKPlotter', {'header': 'dolfin/plot/VTKPlotter.h', 'submodule': 'plot', 'derived': [], 'bases': ['Variable'], 'module': 'io'}),
('GenericFile', {'header': 'dolfin/io/GenericFile.h', 'submodule': 'io', 'derived': ['XDMFFile'], 'bases': [], 'module': 'io'}),
('File', {'header': 'dolfin/io/File.h', 'submodule': 'io', 'derived': [], 'bases': [], 'module': 'io'}),
('XDMFFile', {'header': 'dolfin/io/XDMFFile.h', 'submodule': 'io', 'derived': [], 'bases': ['Variable', 'GenericFile'], 'module': 'io'}),
('HDF5File', {'header': 'dolfin/io/HDF5File.h', 'submodule': 'io', 'derived': [], 'bases': ['Variable'], 'module': 'io'}),
('HDF5Attribute', {'header': 'dolfin/io/HDF5Attribute.h', 'submodule': 'io', 'derived': [], 'bases': [], 'module': 'io'}),])

# A map between modules and its submodules
module_to_submodules = OrderedDict([\
('common', ['common', 'parameter', 'log']),
('la', ['la', 'nls']),
('mesh', ['mesh', 'generation', 'geometry', 'refinement', 'graph', 'ale']),
('function', ['function', 'math']),
('fem', ['fem', 'multistage', 'adaptivity']),
('io', ['plot', 'io']),])

# A reverse map between submodules and modules
submodule_info = OrderedDict([\
('common', {'headers': ['dolfin/common/init.h', 'dolfin/common/defines.h', 'dolfin/common/types.h', 'dolfin/common/constants.h', 'dolfin/common/timing.h', 'dolfin/common/Array.h', 'dolfin/common/IndexSet.h', 'dolfin/common/Set.h', 'dolfin/common/Timer.h', 'dolfin/common/Variable.h', 'dolfin/common/Hierarchical.h', 'dolfin/common/MPI.h', 'dolfin/common/SubSystemsManager.h'], 'has_post': True, 'module': 'common', 'has_pre': True}),
('parameter', {'headers': ['dolfin/parameter/Parameter.h', 'dolfin/parameter/Parameters.h', 'dolfin/parameter/GlobalParameters.h'], 'has_post': True, 'module': 'common', 'has_pre': True}),
('log', {'headers': ['dolfin/log/log.h', 'dolfin/log/Event.h', 'dolfin/log/Progress.h', 'dolfin/log/Table.h', 'dolfin/log/LogLevel.h'], 'has_post': True, 'module': 'common', 'has_pre': True}),
('la', {'headers': ['dolfin/la/ublas.h', 'dolfin/la/LinearAlgebraObject.h', 'dolfin/la/GenericLinearOperator.h', 'dolfin/la/GenericTensor.h', 'dolfin/la/GenericMatrix.h', 'dolfin/la/GenericSparsityPattern.h', 'dolfin/la/GenericVector.h', 'dolfin/la/VectorSpaceBasis.h', 'dolfin/la/GenericLinearSolver.h', 'dolfin/la/GenericLUSolver.h', 'dolfin/la/GenericPreconditioner.h', 'dolfin/la/PETScOptions.h', 'dolfin/la/PETScObject.h', 'dolfin/la/PETScBaseMatrix.h', 'dolfin/la/uBLASFactory.h', 'dolfin/la/uBLASMatrix.h', 'dolfin/la/uBLASLinearOperator.h', 'dolfin/la/PETScMatrix.h', 'dolfin/la/PETScLinearOperator.h', 'dolfin/la/PETScPreconditioner.h', 'dolfin/la/EpetraLUSolver.h', 'dolfin/la/EpetraKrylovSolver.h', 'dolfin/la/EpetraMatrix.h', 'dolfin/la/EpetraVector.h', 'dolfin/la/PETScKrylovSolver.h', 'dolfin/la/PETScLUSolver.h', 'dolfin/la/CholmodCholeskySolver.h', 'dolfin/la/UmfpackLUSolver.h', 'dolfin/la/MUMPSLUSolver.h', 'dolfin/la/PaStiXLUSolver.h', 'dolfin/la/STLMatrix.h', 'dolfin/la/CoordinateMatrix.h', 'dolfin/la/uBLASVector.h', 'dolfin/la/PETScVector.h', 'dolfin/la/SparsityPattern.h', 'dolfin/la/GenericLinearAlgebraFactory.h', 'dolfin/la/DefaultFactory.h', 'dolfin/la/PETScUserPreconditioner.h', 'dolfin/la/PETScFactory.h', 'dolfin/la/PETScCuspFactory.h', 'dolfin/la/EpetraFactory.h', 'dolfin/la/STLFactory.h', 'dolfin/la/SLEPcEigenSolver.h', 'dolfin/la/TrilinosPreconditioner.h', 'dolfin/la/uBLASSparseMatrix.h', 'dolfin/la/uBLASDenseMatrix.h', 'dolfin/la/uBLASPreconditioner.h', 'dolfin/la/uBLASKrylovSolver.h', 'dolfin/la/uBLASILUPreconditioner.h', 'dolfin/la/Vector.h', 'dolfin/la/Matrix.h', 'dolfin/la/Scalar.h', 'dolfin/la/LinearSolver.h', 'dolfin/la/KrylovSolver.h', 'dolfin/la/LUSolver.h', 'dolfin/la/solve.h', 'dolfin/la/BlockVector.h', 'dolfin/la/BlockMatrix.h', 'dolfin/la/TensorProductVector.h', 'dolfin/la/TensorProductMatrix.h', 'dolfin/la/LinearOperator.h'], 'has_post': True, 'module': 'la', 'has_pre': True}),
('nls', {'headers': ['dolfin/nls/NonlinearProblem.h', 'dolfin/nls/NewtonSolver.h', 'dolfin/nls/PETScSNESSolver.h', 'dolfin/nls/TAOLinearBoundSolver.h'], 'has_post': False, 'module': 'la', 'has_pre': True}),
('mesh', {'headers': ['dolfin/mesh/CellType.h', 'dolfin/mesh/MeshTopology.h', 'dolfin/mesh/MeshGeometry.h', 'dolfin/mesh/MeshDomains.h', 'dolfin/mesh/MeshData.h', 'dolfin/mesh/Mesh.h', 'dolfin/mesh/MeshEntity.h', 'dolfin/mesh/MeshEntityIterator.h', 'dolfin/mesh/MeshEntityIteratorBase.h', 'dolfin/mesh/SubsetIterator.h', 'dolfin/mesh/Vertex.h', 'dolfin/mesh/Edge.h', 'dolfin/mesh/Face.h', 'dolfin/mesh/Facet.h', 'dolfin/mesh/Cell.h', 'dolfin/mesh/FacetCell.h', 'dolfin/mesh/MeshConnectivity.h', 'dolfin/mesh/MeshEditor.h', 'dolfin/mesh/DynamicMeshEditor.h', 'dolfin/mesh/LocalMeshValueCollection.h', 'dolfin/mesh/MeshFunction.h', 'dolfin/mesh/MeshPartitioning.h', 'dolfin/mesh/MeshValueCollection.h', 'dolfin/mesh/MeshColoring.h', 'dolfin/mesh/MeshRenumbering.h', 'dolfin/mesh/MeshTransformation.h', 'dolfin/mesh/LocalMeshData.h', 'dolfin/mesh/SubDomain.h', 'dolfin/mesh/SubMesh.h', 'dolfin/mesh/Restriction.h', 'dolfin/mesh/DomainBoundary.h', 'dolfin/mesh/BoundaryMesh.h', 'dolfin/mesh/PeriodicBoundaryComputation.h', 'dolfin/mesh/MeshQuality.h'], 'has_post': True, 'module': 'mesh', 'has_pre': True}),
('generation', {'headers': ['dolfin/generation/ImplicitDomainMeshGenerator.h', 'dolfin/generation/PolygonalMeshGenerator.h', 'dolfin/generation/PolyhedralMeshGenerator.h', 'dolfin/generation/Triangulate.h', 'dolfin/generation/BoxMesh.h', 'dolfin/generation/EllipseMesh.h', 'dolfin/generation/EllipsoidMesh.h', 'dolfin/generation/IntervalMesh.h', 'dolfin/generation/Interval.h', 'dolfin/generation/RectangleMesh.h', 'dolfin/generation/UnitTetrahedronMesh.h', 'dolfin/generation/UnitCubeMesh.h', 'dolfin/generation/UnitCube.h', 'dolfin/generation/UnitIntervalMesh.h', 'dolfin/generation/UnitInterval.h', 'dolfin/generation/UnitTriangleMesh.h', 'dolfin/generation/UnitSquareMesh.h', 'dolfin/generation/UnitSquare.h', 'dolfin/generation/UnitCircleMesh.h', 'dolfin/generation/UnitCircle.h', 'dolfin/generation/CSGGeometry.h', 'dolfin/generation/CSGMeshGenerator.h', 'dolfin/generation/CSGCGALMeshGenerator2D.h', 'dolfin/generation/CSGCGALMeshGenerator3D.h', 'dolfin/generation/CSGOperators.h', 'dolfin/generation/CSGPrimitive.h', 'dolfin/generation/CSGPrimitives2D.h', 'dolfin/generation/CSGPrimitives3D.h', 'dolfin/generation/CSGGeometries3D.h'], 'has_post': True, 'module': 'mesh', 'has_pre': False}),
('geometry', {'headers': ['dolfin/geometry/ImplicitSurface.h', 'dolfin/geometry/Point.h', 'dolfin/geometry/BoundingBoxTree.h', 'dolfin/geometry/GenericBoundingBoxTree.h', 'dolfin/geometry/BoundingBoxTree3D.h', 'dolfin/geometry/MeshPointIntersection.h', 'dolfin/geometry/intersect.h'], 'has_post': True, 'module': 'mesh', 'has_pre': True}),
('refinement', {'headers': ['dolfin/refinement/refine.h'], 'has_post': False, 'module': 'mesh', 'has_pre': False}),
('function', {'headers': ['dolfin/function/GenericFunction.h', 'dolfin/function/Expression.h', 'dolfin/function/FunctionAXPY.h', 'dolfin/function/Function.h', 'dolfin/function/FunctionSpace.h', 'dolfin/function/SubSpace.h', 'dolfin/function/Constant.h', 'dolfin/function/SpecialFunctions.h', 'dolfin/function/SpecialFacetFunction.h', 'dolfin/function/CCFEMFunctionSpace.h', 'dolfin/function/FunctionAssigner.h', 'dolfin/function/assign.h', 'dolfin/function/CCFEMFunction.h'], 'has_post': True, 'module': 'function', 'has_pre': True}),
('graph', {'headers': ['dolfin/graph/Graph.h', 'dolfin/graph/GraphBuilder.h', 'dolfin/graph/BoostGraphOrdering.h', 'dolfin/graph/SCOTCH.h'], 'has_post': True, 'module': 'mesh', 'has_pre': False}),
('plot', {'headers': ['dolfin/plot/plot.h', 'dolfin/plot/VTKPlotter.h'], 'has_post': False, 'module': 'io', 'has_pre': False}),
('math', {'headers': ['dolfin/math/basic.h', 'dolfin/math/Lagrange.h', 'dolfin/math/Legendre.h'], 'has_post': False, 'module': 'function', 'has_pre': False}),
('ale', {'headers': ['dolfin/ale/ALE.h', 'dolfin/ale/MeshDisplacement.h'], 'has_post': False, 'module': 'mesh', 'has_pre': True}),
('fem', {'headers': ['dolfin/fem/GenericDofMap.h', 'dolfin/fem/DofMap.h', 'dolfin/fem/fem_utils.h', 'dolfin/fem/Equation.h', 'dolfin/fem/FiniteElement.h', 'dolfin/fem/BasisFunction.h', 'dolfin/fem/DirichletBC.h', 'dolfin/fem/PointSource.h', 'dolfin/fem/assemble.h', 'dolfin/fem/LocalSolver.h', 'dolfin/fem/solve.h', 'dolfin/fem/Form.h', 'dolfin/fem/AssemblerBase.h', 'dolfin/fem/Assembler.h', 'dolfin/fem/SparsityPatternBuilder.h', 'dolfin/fem/SystemAssembler.h', 'dolfin/fem/LinearVariationalProblem.h', 'dolfin/fem/LinearVariationalSolver.h', 'dolfin/fem/NonlinearVariationalProblem.h', 'dolfin/fem/NonlinearVariationalSolver.h', 'dolfin/fem/CCFEMForm.h', 'dolfin/fem/CCFEMDofMap.h', 'dolfin/fem/CCFEMAssembler.h', 'dolfin/fem/OpenMpAssembler.h', 'dolfin/fem/VariationalProblem.h'], 'has_post': True, 'module': 'fem', 'has_pre': True}),
('multistage', {'headers': ['dolfin/multistage/MultiStageScheme.h', 'dolfin/multistage/RKSolver.h', 'dolfin/multistage/PointIntegralSolver.h'], 'has_post': False, 'module': 'fem', 'has_pre': True}),
('adaptivity', {'headers': ['dolfin/adaptivity/GenericAdaptiveVariationalSolver.h', 'dolfin/adaptivity/AdaptiveLinearVariationalSolver.h', 'dolfin/adaptivity/AdaptiveNonlinearVariationalSolver.h', 'dolfin/adaptivity/GoalFunctional.h', 'dolfin/adaptivity/ErrorControl.h', 'dolfin/adaptivity/Extrapolation.h', 'dolfin/adaptivity/LocalAssembler.h', 'dolfin/adaptivity/TimeSeries.h', 'dolfin/adaptivity/TimeSeriesHDF5.h', 'dolfin/adaptivity/adapt.h', 'dolfin/adaptivity/marking.h', 'dolfin/adaptivity/adaptivesolve.h'], 'has_post': True, 'module': 'fem', 'has_pre': True}),
('io', {'headers': ['dolfin/io/GenericFile.h', 'dolfin/io/File.h', 'dolfin/io/XDMFFile.h', 'dolfin/io/HDF5File.h', 'dolfin/io/HDF5Attribute.h'], 'has_post': True, 'module': 'io', 'has_pre': True}),])
