.\" This file was generated by efeudoc
.\" document input: ./dvipost.doc:1
.TH dvipost 1
.SH NAME
dvipost, pptex, pplatex - post processing of dvi files

.SH SYNOPSIS
\fBdvipost\fR [\fB-debug\fR] [\fB-version\fR] [\fB-help\fR] \fIin\fR \fIout\fR

\fBpplatex\fR [\fB-debug\fR] [\fB-version\fR] [\fB-help\fR] [LaTeX-Arguments]

\fBpptex\fR [\fB-debug\fR] [\fB-version\fR] [\fB-help\fR] [TeX-Arguments]

.SH DESCRIPTION
The command \fBdvipost\fR is a post procesor for dvi files, created by
\fBlatex\fR or \fBtex\fR. It is used for special modes, which normally needs
the support of dvi drivers (such as \fBdvips\fR). With \fBdvipost\fR, this
features could be implemented independent of the prefered driver.
Currently, the post processor supports layout raster, change bars and
overstrike mode.

This version of \fBdvipost\fR does not seek the dvi file, so it could be
used as a filter. If \fB-\fR is given as file name, the command uses
standard input or standard output respective. The command does not
substitute a missing \fB.dvi\fR extension to the filename.

Because the command works with a temporary file and
creates the ouput file only after successfull processing the input file,
it is possible to use the same name for input and output.

If the command is renamed or linked to \fBpplatex\fR/\fBpptex\fR, it
runs \fBlatex\fR/\fBtex\fR and post processes the createt output.
If the name of the dvi file could not be determined by the arguments
to \fBlatex\fR/\fBtex\fR (e.g. on an interactive run),
the command processes all dvi files in the current directory with
a modification time later than the run of \fBlatex\fR/\fBtex\fR.

.SS Basics
If the filter is used in context of LaTeX, the style file
\fBdvipost.sty\fR should be included in the LaTeX source.

The filter interpretes dvi extensions in the form of
.RS
\fBdvipost:\fR \fIname\fR [\fIarg\fR]
.RE
where \fIarg\fR depends on the command \fIname\fR and may be separated from
\fIname\fR by \fB=\fR  or space.
All other extensions are not interpreted by \fBdvipost\fR and
remain in the dvi file.

Such a dvipost command could be placed with the TeX primitive
.RS
\fB\\special{dvipost:\fR \fIcmd\fR\fB}\fR
.RE
or the LaTeX macro (provided by \fBdvipost.sty\fR)
.RS
\fB\\dvipost{\fR\fIcmd\fR\fB}\fR
.RE
in the dvi file.

Depending on the type of \fBdvipost\fR commands,
the following kinds of arguments may be used:
.PD 0
.TP
\fIlength\fR
is a floating point number followed by a
unit specification.
The following units are supportet by \fBdivipost\fR:
\fBpt\fR, \fBin\fR, \fBcm\fR and \fBmm\fR.
If no argument is given or the unit specification is missing,
the corresponding \fIlength\fR is set to 0.
.TP
\fIstring\fR
is an arbitrary string argument.
.TP
\fIflag\fR
is an integer argument, where a value
different from 0 (usually 1) means true and a missing value or 0
means false.
.TP
\fIdepth\fR
is an integer argument, where a value
different from 0 (usually 1) increments a depth counter
and a missing value or 0 decrements it.
.PD
.PP
.SS Change bars
All text printed with change mode level higher than 0 is
marked with a change bar.

The following LaTeX macros modifies the change mode level:

.PD 0
.TP
\fB\\changestart\fR
increments the change mode level.
.TP
\fB\\changeend\fR
decrements the change mode level.
.TP
\fB\\textchanged{\fItext\fB}\fR
increments the change mode level for \fItext\fR only.
.PD
.PP
The following \fBdvipost\fR commands are used in context of change bars:
.PD 0
.TP
\fBcbmode \fIdepth\fB\fR
increments/decrements the change mode level.
This command is used by the LaTeX macros.
.TP
\fBcbrule \fIlength\fB\fR
determines the thickness of the change bar. The default value
is 2pt.
.TP
\fBcbsep \fIlength\fB\fR
sets the distance beetween page margin and change bar.
The default value is 2pt.
.TP
\fBcbexp \fIlength\fB\fR
sets the additional height and depth of a character in
calculating the change bar positions.
The default value is 6pt.
.TP
\fBcbstart \fIstring\fB\fR
places the dvi extension \fIstring\fR before printing
characters in change mode.
.TP
\fBcbend \fIstring\fB\fR
places the dvi extension \fIstring\fR after printing
characters in change mode.
.PD
.PP
The use of \fBcbstart\fR and \fBcbend\fR allows to set additional attributes
to the marked text, depending on the dvi driver.

If \fBdvips\fR is used as dvi driver and the preamble of the LaTeX
source contains
.RS
\fB\\usepackage{dvipost}\fR
.br
\fB\\dvipost{cbstart color push Blue}\fR
.br
\fB\\dvipost{cbend color pop}\fR
.RE
the marked text is colored blue.

.SS Overstrike mode
All text printed with overstrike level higher than 0 is
overstriked with a horizontal line.

The overstrike line is positioned at the mean height
of every block of text not broken by vertical movements and font
changes.

The following LaTeX macros modifies the overstrike level:

.PD 0
.TP
\fB\\overstrikeon\fR
increments the overstrike level.
.TP
\fB\\overstrikeoff\fR
decrements the overstrike level.
.TP
\fB\\overstrike{\fItext\fB}\fR
increments the overstrike level for \fItext\fR only.
.PD
.PP
The following \fBdvipost\fR commands are used in context of overstrike mode:
.PD 0
.TP
\fBosmode \fIdepth\fB\fR
increments/decrements the overstrike level.
This command is used by the LaTeX macros.
.TP
\fBosrule \fIlength\fB\fR
sets the thickness of the overstrike line to \fIlength\fR.
The default value is \fB\\fboxrule\fR.
.TP
\fBosstart \fIstring\fB\fR
places the dvi extension \fIstring\fR before change
of overstrike mode.
.TP
\fBosend \fIstring\fB\fR
places the dvi extension \fIstring\fR after change
of overstrike mode.
.PD
.PP
The use of \fBosstart\fR and \fBosend\fR is similar to \fBcbstart\fR and \fBcbend\fR.

.SS Layout parameters
Layout parameters are transfered to the dvi file on loading the
style file. If any changes are made to layout parameters, like
\fB\\evensidemargin\fR, the macro \fB\\dvipostlayout\fR must be called
to get the correct placement of change bars. Additional calls
to \fB\\dvipostlayout\fR are harmeless.

The following layout parameters are transfered to the dvi file:
\fB\\hoffset\fR,
\fB\\voffset\fR,
\fB\\textwidth\fR,
\fB\\textheight\fR,
\fB\\oddsidemargin\fR,
\fB\\evensidemargin\fR,
\fB\\topmargin\fR,
\fB\\headheight\fR,
\fB\\headsep\fR,
\fB\\footskip\fR,
\fB\\marginparsep\fR and
\fB\\marginparwidth\fR.
Additional the flag \fBtwoside\fR is set to 0 or 1, depending on
the document style option \fBtwoside\fR.

Instead of calling \fB\\dvipostlayout\fR, partciucular values could be set.
The command
.RS
\fB\\dvipost{evensidemargin=\\the\\evensidemargin}\fR
.RE
transfers the actual setting of \fB\\evensidemargin\fR to the
dvi file.

The \fBdvipost\fR command allows the printing of the layout raster
by setting \fBlayout\fR to a length different to 0. The value of
\fBlayout\fR is used as the thickness of the raster lines.

For example: The command
.RS
\fB\\dvipost{layout=\\the\\fboxrule}\fR
.RE
activates the layout raster and uses the same line thicknes as frame boxes.

.SH NOTES
The filter is primarly written for LaTeX.
It could be used for plain TeX, but currently there is no
assistance style file included in the distribution.
Maybe somone would write one, I am not a plain TeX user.

The current state of change bar mode and overstrike mode
must be committed do environments, which are placed on different
locations than the current text. This is done in \fBdvipost.sty\fR
by redefining \fB\\color@begingroup\fR and \fB\\color@endgroup\fR.
This may conflict with other packages.

If the macro \fB\\footnoterule\fR is redefined, it should start with
the command \fB\\dvipost{footnote}\fR for a correct handling of
overstrike mode and change bars.

.SH COPYRIGHT
Copyright (C) 2002 Erich Fruehstueck
