// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file typesTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "typesTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "types.hpp"


using namespace eprosima::fastdds::dds::xtypes;

namespace eprosima {
namespace fastdds {
namespace statistics {
namespace detail {
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_EntityId_s_type_identifier(
        TypeIdentifierPair& type_ids_EntityId_s)
{

    ReturnCode_t return_code_EntityId_s {eprosima::fastdds::dds::RETCODE_OK};
    return_code_EntityId_s =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::detail::EntityId_s", type_ids_EntityId_s);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_EntityId_s)
    {
        StructTypeFlag struct_flags_EntityId_s = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_EntityId_s = "eprosima::fastdds::statistics::detail::EntityId_s";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_EntityId_s;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_EntityId_s;
        CompleteTypeDetail detail_EntityId_s = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_EntityId_s, ann_custom_EntityId_s, type_name_EntityId_s.to_string());
        CompleteStructHeader header_EntityId_s;
        header_EntityId_s = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_EntityId_s);
        CompleteStructMemberSeq member_seq_EntityId_s;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint8_t_4", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint8_t_4_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint8_t_4 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, element_identifier_anonymous_array_uint8_t_4_ec))};
                if (!element_identifier_anonymous_array_uint8_t_4_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint8_t_4 = EK_COMPLETE;
                if (TK_NONE == type_ids_value.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint8_t_4 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint8_t_4 = 0;
                PlainCollectionHeader header_anonymous_array_uint8_t_4 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint8_t_4, element_flags_anonymous_array_uint8_t_4);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(4));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint8_t_4, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint8_t_4));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint8_t_4", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint8_t_4 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_EntityId_s.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_EntityId_s);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_EntityId_s, member_value);
        }
        CompleteStructType struct_type_EntityId_s = TypeObjectUtils::build_complete_struct_type(struct_flags_EntityId_s, header_EntityId_s, member_seq_EntityId_s);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_EntityId_s, type_name_EntityId_s.to_string(), type_ids_EntityId_s))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::detail::EntityId_s already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_GuidPrefix_s_type_identifier(
        TypeIdentifierPair& type_ids_GuidPrefix_s)
{

    ReturnCode_t return_code_GuidPrefix_s {eprosima::fastdds::dds::RETCODE_OK};
    return_code_GuidPrefix_s =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::detail::GuidPrefix_s", type_ids_GuidPrefix_s);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_GuidPrefix_s)
    {
        StructTypeFlag struct_flags_GuidPrefix_s = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_GuidPrefix_s = "eprosima::fastdds::statistics::detail::GuidPrefix_s";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_GuidPrefix_s;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_GuidPrefix_s;
        CompleteTypeDetail detail_GuidPrefix_s = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_GuidPrefix_s, ann_custom_GuidPrefix_s, type_name_GuidPrefix_s.to_string());
        CompleteStructHeader header_GuidPrefix_s;
        header_GuidPrefix_s = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_GuidPrefix_s);
        CompleteStructMemberSeq member_seq_GuidPrefix_s;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint8_t_12", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                return_code_value =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_value);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint8_t_12_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint8_t_12 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, element_identifier_anonymous_array_uint8_t_12_ec))};
                if (!element_identifier_anonymous_array_uint8_t_12_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint8_t_12 = EK_COMPLETE;
                if (TK_NONE == type_ids_value.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint8_t_12 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint8_t_12 = 0;
                PlainCollectionHeader header_anonymous_array_uint8_t_12 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint8_t_12, element_flags_anonymous_array_uint8_t_12);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(12));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint8_t_12, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint8_t_12));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint8_t_12", type_ids_value))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint8_t_12 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_GuidPrefix_s.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_GuidPrefix_s);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_GuidPrefix_s, member_value);
        }
        CompleteStructType struct_type_GuidPrefix_s = TypeObjectUtils::build_complete_struct_type(struct_flags_GuidPrefix_s, header_GuidPrefix_s, member_seq_GuidPrefix_s);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_GuidPrefix_s, type_name_GuidPrefix_s.to_string(), type_ids_GuidPrefix_s))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::detail::GuidPrefix_s already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_GUID_s_type_identifier(
        TypeIdentifierPair& type_ids_GUID_s)
{

    ReturnCode_t return_code_GUID_s {eprosima::fastdds::dds::RETCODE_OK};
    return_code_GUID_s =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::detail::GUID_s", type_ids_GUID_s);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_GUID_s)
    {
        StructTypeFlag struct_flags_GUID_s = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_GUID_s = "eprosima::fastdds::statistics::detail::GUID_s";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_GUID_s;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_GUID_s;
        CompleteTypeDetail detail_GUID_s = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_GUID_s, ann_custom_GUID_s, type_name_GUID_s.to_string());
        CompleteStructHeader header_GUID_s;
        header_GUID_s = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_GUID_s);
        CompleteStructMemberSeq member_seq_GUID_s;
        {
            TypeIdentifierPair type_ids_guidPrefix;
            ReturnCode_t return_code_guidPrefix {eprosima::fastdds::dds::RETCODE_OK};
            return_code_guidPrefix =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::detail::GuidPrefix_s", type_ids_guidPrefix);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_guidPrefix)
            {
                eprosima::fastdds::statistics::detail::register_GuidPrefix_s_type_identifier(type_ids_guidPrefix);
            }
            StructMemberFlag member_flags_guidPrefix = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_guidPrefix = 0x00000000;
            bool common_guidPrefix_ec {false};
            CommonStructMember common_guidPrefix {TypeObjectUtils::build_common_struct_member(member_id_guidPrefix, member_flags_guidPrefix, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_guidPrefix, common_guidPrefix_ec))};
            if (!common_guidPrefix_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure guidPrefix member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_guidPrefix = "guidPrefix";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_guidPrefix;
            ann_custom_GUID_s.reset();
            CompleteMemberDetail detail_guidPrefix = TypeObjectUtils::build_complete_member_detail(name_guidPrefix, member_ann_builtin_guidPrefix, ann_custom_GUID_s);
            CompleteStructMember member_guidPrefix = TypeObjectUtils::build_complete_struct_member(common_guidPrefix, detail_guidPrefix);
            TypeObjectUtils::add_complete_struct_member(member_seq_GUID_s, member_guidPrefix);
        }
        {
            TypeIdentifierPair type_ids_entityId;
            ReturnCode_t return_code_entityId {eprosima::fastdds::dds::RETCODE_OK};
            return_code_entityId =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::detail::EntityId_s", type_ids_entityId);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_entityId)
            {
                eprosima::fastdds::statistics::detail::register_EntityId_s_type_identifier(type_ids_entityId);
            }
            StructMemberFlag member_flags_entityId = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_entityId = 0x00000001;
            bool common_entityId_ec {false};
            CommonStructMember common_entityId {TypeObjectUtils::build_common_struct_member(member_id_entityId, member_flags_entityId, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_entityId, common_entityId_ec))};
            if (!common_entityId_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure entityId member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_entityId = "entityId";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_entityId;
            ann_custom_GUID_s.reset();
            CompleteMemberDetail detail_entityId = TypeObjectUtils::build_complete_member_detail(name_entityId, member_ann_builtin_entityId, ann_custom_GUID_s);
            CompleteStructMember member_entityId = TypeObjectUtils::build_complete_struct_member(common_entityId, detail_entityId);
            TypeObjectUtils::add_complete_struct_member(member_seq_GUID_s, member_entityId);
        }
        CompleteStructType struct_type_GUID_s = TypeObjectUtils::build_complete_struct_type(struct_flags_GUID_s, header_GUID_s, member_seq_GUID_s);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_GUID_s, type_name_GUID_s.to_string(), type_ids_GUID_s))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::detail::GUID_s already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceNumber_s_type_identifier(
        TypeIdentifierPair& type_ids_SequenceNumber_s)
{

    ReturnCode_t return_code_SequenceNumber_s {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceNumber_s =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::detail::SequenceNumber_s", type_ids_SequenceNumber_s);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceNumber_s)
    {
        StructTypeFlag struct_flags_SequenceNumber_s = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceNumber_s = "eprosima::fastdds::statistics::detail::SequenceNumber_s";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceNumber_s;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceNumber_s;
        CompleteTypeDetail detail_SequenceNumber_s = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceNumber_s, ann_custom_SequenceNumber_s, type_name_SequenceNumber_s.to_string());
        CompleteStructHeader header_SequenceNumber_s;
        header_SequenceNumber_s = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceNumber_s);
        CompleteStructMemberSeq member_seq_SequenceNumber_s;
        {
            TypeIdentifierPair type_ids_high;
            ReturnCode_t return_code_high {eprosima::fastdds::dds::RETCODE_OK};
            return_code_high =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_high);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_high)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "high Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_high = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_high = 0x00000000;
            bool common_high_ec {false};
            CommonStructMember common_high {TypeObjectUtils::build_common_struct_member(member_id_high, member_flags_high, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_high, common_high_ec))};
            if (!common_high_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure high member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_high = "high";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_high;
            ann_custom_SequenceNumber_s.reset();
            CompleteMemberDetail detail_high = TypeObjectUtils::build_complete_member_detail(name_high, member_ann_builtin_high, ann_custom_SequenceNumber_s);
            CompleteStructMember member_high = TypeObjectUtils::build_complete_struct_member(common_high, detail_high);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceNumber_s, member_high);
        }
        {
            TypeIdentifierPair type_ids_low;
            ReturnCode_t return_code_low {eprosima::fastdds::dds::RETCODE_OK};
            return_code_low =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_low);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_low)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "low Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_low = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_low = 0x00000001;
            bool common_low_ec {false};
            CommonStructMember common_low {TypeObjectUtils::build_common_struct_member(member_id_low, member_flags_low, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_low, common_low_ec))};
            if (!common_low_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure low member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_low = "low";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_low;
            ann_custom_SequenceNumber_s.reset();
            CompleteMemberDetail detail_low = TypeObjectUtils::build_complete_member_detail(name_low, member_ann_builtin_low, ann_custom_SequenceNumber_s);
            CompleteStructMember member_low = TypeObjectUtils::build_complete_struct_member(common_low, detail_low);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceNumber_s, member_low);
        }
        CompleteStructType struct_type_SequenceNumber_s = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceNumber_s, header_SequenceNumber_s, member_seq_SequenceNumber_s);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceNumber_s, type_name_SequenceNumber_s.to_string(), type_ids_SequenceNumber_s))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::detail::SequenceNumber_s already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SampleIdentity_s_type_identifier(
        TypeIdentifierPair& type_ids_SampleIdentity_s)
{

    ReturnCode_t return_code_SampleIdentity_s {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SampleIdentity_s =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::detail::SampleIdentity_s", type_ids_SampleIdentity_s);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SampleIdentity_s)
    {
        StructTypeFlag struct_flags_SampleIdentity_s = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SampleIdentity_s = "eprosima::fastdds::statistics::detail::SampleIdentity_s";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SampleIdentity_s;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SampleIdentity_s;
        CompleteTypeDetail detail_SampleIdentity_s = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SampleIdentity_s, ann_custom_SampleIdentity_s, type_name_SampleIdentity_s.to_string());
        CompleteStructHeader header_SampleIdentity_s;
        header_SampleIdentity_s = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SampleIdentity_s);
        CompleteStructMemberSeq member_seq_SampleIdentity_s;
        {
            TypeIdentifierPair type_ids_writer_guid;
            ReturnCode_t return_code_writer_guid {eprosima::fastdds::dds::RETCODE_OK};
            return_code_writer_guid =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::detail::GUID_s", type_ids_writer_guid);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_writer_guid)
            {
                eprosima::fastdds::statistics::detail::register_GUID_s_type_identifier(type_ids_writer_guid);
            }
            StructMemberFlag member_flags_writer_guid = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_writer_guid = 0x00000000;
            bool common_writer_guid_ec {false};
            CommonStructMember common_writer_guid {TypeObjectUtils::build_common_struct_member(member_id_writer_guid, member_flags_writer_guid, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_writer_guid, common_writer_guid_ec))};
            if (!common_writer_guid_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure writer_guid member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_writer_guid = "writer_guid";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_writer_guid;
            ann_custom_SampleIdentity_s.reset();
            CompleteMemberDetail detail_writer_guid = TypeObjectUtils::build_complete_member_detail(name_writer_guid, member_ann_builtin_writer_guid, ann_custom_SampleIdentity_s);
            CompleteStructMember member_writer_guid = TypeObjectUtils::build_complete_struct_member(common_writer_guid, detail_writer_guid);
            TypeObjectUtils::add_complete_struct_member(member_seq_SampleIdentity_s, member_writer_guid);
        }
        {
            TypeIdentifierPair type_ids_sequence_number;
            ReturnCode_t return_code_sequence_number {eprosima::fastdds::dds::RETCODE_OK};
            return_code_sequence_number =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::detail::SequenceNumber_s", type_ids_sequence_number);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_sequence_number)
            {
                eprosima::fastdds::statistics::detail::register_SequenceNumber_s_type_identifier(type_ids_sequence_number);
            }
            StructMemberFlag member_flags_sequence_number = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_sequence_number = 0x00000001;
            bool common_sequence_number_ec {false};
            CommonStructMember common_sequence_number {TypeObjectUtils::build_common_struct_member(member_id_sequence_number, member_flags_sequence_number, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_sequence_number, common_sequence_number_ec))};
            if (!common_sequence_number_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure sequence_number member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_sequence_number = "sequence_number";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_sequence_number;
            ann_custom_SampleIdentity_s.reset();
            CompleteMemberDetail detail_sequence_number = TypeObjectUtils::build_complete_member_detail(name_sequence_number, member_ann_builtin_sequence_number, ann_custom_SampleIdentity_s);
            CompleteStructMember member_sequence_number = TypeObjectUtils::build_complete_struct_member(common_sequence_number, detail_sequence_number);
            TypeObjectUtils::add_complete_struct_member(member_seq_SampleIdentity_s, member_sequence_number);
        }
        CompleteStructType struct_type_SampleIdentity_s = TypeObjectUtils::build_complete_struct_type(struct_flags_SampleIdentity_s, header_SampleIdentity_s, member_seq_SampleIdentity_s);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SampleIdentity_s, type_name_SampleIdentity_s.to_string(), type_ids_SampleIdentity_s))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::detail::SampleIdentity_s already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Locator_s_type_identifier(
        TypeIdentifierPair& type_ids_Locator_s)
{

    ReturnCode_t return_code_Locator_s {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Locator_s =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::detail::Locator_s", type_ids_Locator_s);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Locator_s)
    {
        StructTypeFlag struct_flags_Locator_s = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Locator_s = "eprosima::fastdds::statistics::detail::Locator_s";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Locator_s;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Locator_s;
        CompleteTypeDetail detail_Locator_s = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Locator_s, ann_custom_Locator_s, type_name_Locator_s.to_string());
        CompleteStructHeader header_Locator_s;
        header_Locator_s = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Locator_s);
        CompleteStructMemberSeq member_seq_Locator_s;
        {
            TypeIdentifierPair type_ids_kind;
            ReturnCode_t return_code_kind {eprosima::fastdds::dds::RETCODE_OK};
            return_code_kind =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_kind);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_kind)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "kind Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_kind = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_kind = 0x00000000;
            bool common_kind_ec {false};
            CommonStructMember common_kind {TypeObjectUtils::build_common_struct_member(member_id_kind, member_flags_kind, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_kind, common_kind_ec))};
            if (!common_kind_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure kind member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_kind = "kind";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_kind;
            ann_custom_Locator_s.reset();
            CompleteMemberDetail detail_kind = TypeObjectUtils::build_complete_member_detail(name_kind, member_ann_builtin_kind, ann_custom_Locator_s);
            CompleteStructMember member_kind = TypeObjectUtils::build_complete_struct_member(common_kind, detail_kind);
            TypeObjectUtils::add_complete_struct_member(member_seq_Locator_s, member_kind);
        }
        {
            TypeIdentifierPair type_ids_port;
            ReturnCode_t return_code_port {eprosima::fastdds::dds::RETCODE_OK};
            return_code_port =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_port);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_port)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "port Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_port = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_port = 0x00000001;
            bool common_port_ec {false};
            CommonStructMember common_port {TypeObjectUtils::build_common_struct_member(member_id_port, member_flags_port, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_port, common_port_ec))};
            if (!common_port_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure port member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_port = "port";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_port;
            ann_custom_Locator_s.reset();
            CompleteMemberDetail detail_port = TypeObjectUtils::build_complete_member_detail(name_port, member_ann_builtin_port, ann_custom_Locator_s);
            CompleteStructMember member_port = TypeObjectUtils::build_complete_struct_member(common_port, detail_port);
            TypeObjectUtils::add_complete_struct_member(member_seq_Locator_s, member_port);
        }
        {
            TypeIdentifierPair type_ids_address;
            ReturnCode_t return_code_address {eprosima::fastdds::dds::RETCODE_OK};
            return_code_address =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint8_t_16", type_ids_address);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_address)
            {
                return_code_address =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_address);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_address)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint8_t_16_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint8_t_16 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_address, element_identifier_anonymous_array_uint8_t_16_ec))};
                if (!element_identifier_anonymous_array_uint8_t_16_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint8_t_16 = EK_COMPLETE;
                if (TK_NONE == type_ids_address.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint8_t_16 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint8_t_16 = 0;
                PlainCollectionHeader header_anonymous_array_uint8_t_16 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint8_t_16, element_flags_anonymous_array_uint8_t_16);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(16));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint8_t_16, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint8_t_16));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint8_t_16", type_ids_address))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint8_t_16 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_address = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_address = 0x00000002;
            bool common_address_ec {false};
            CommonStructMember common_address {TypeObjectUtils::build_common_struct_member(member_id_address, member_flags_address, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_address, common_address_ec))};
            if (!common_address_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure address member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_address = "address";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_address;
            ann_custom_Locator_s.reset();
            CompleteMemberDetail detail_address = TypeObjectUtils::build_complete_member_detail(name_address, member_ann_builtin_address, ann_custom_Locator_s);
            CompleteStructMember member_address = TypeObjectUtils::build_complete_struct_member(common_address, detail_address);
            TypeObjectUtils::add_complete_struct_member(member_seq_Locator_s, member_address);
        }
        CompleteStructType struct_type_Locator_s = TypeObjectUtils::build_complete_struct_type(struct_flags_Locator_s, header_Locator_s, member_seq_Locator_s);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Locator_s, type_name_Locator_s.to_string(), type_ids_Locator_s))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::detail::Locator_s already registered in TypeObjectRegistry for a different type.");
        }
    }
}

} // namespace detail
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_DiscoveryTime_type_identifier(
        TypeIdentifierPair& type_ids_DiscoveryTime)
{

    ReturnCode_t return_code_DiscoveryTime {eprosima::fastdds::dds::RETCODE_OK};
    return_code_DiscoveryTime =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::DiscoveryTime", type_ids_DiscoveryTime);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_DiscoveryTime)
    {
        StructTypeFlag struct_flags_DiscoveryTime = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_DiscoveryTime = "eprosima::fastdds::statistics::DiscoveryTime";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_DiscoveryTime;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_DiscoveryTime;
        CompleteTypeDetail detail_DiscoveryTime = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_DiscoveryTime, ann_custom_DiscoveryTime, type_name_DiscoveryTime.to_string());
        CompleteStructHeader header_DiscoveryTime;
        header_DiscoveryTime = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_DiscoveryTime);
        CompleteStructMemberSeq member_seq_DiscoveryTime;
        {
            TypeIdentifierPair type_ids_local_participant_guid;
            ReturnCode_t return_code_local_participant_guid {eprosima::fastdds::dds::RETCODE_OK};
            return_code_local_participant_guid =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::detail::GUID_s", type_ids_local_participant_guid);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_local_participant_guid)
            {
                eprosima::fastdds::statistics::detail::register_GUID_s_type_identifier(type_ids_local_participant_guid);
            }
            StructMemberFlag member_flags_local_participant_guid = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_local_participant_guid = 0x00000000;
            bool common_local_participant_guid_ec {false};
            CommonStructMember common_local_participant_guid {TypeObjectUtils::build_common_struct_member(member_id_local_participant_guid, member_flags_local_participant_guid, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_local_participant_guid, common_local_participant_guid_ec))};
            if (!common_local_participant_guid_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure local_participant_guid member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_local_participant_guid = "local_participant_guid";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_local_participant_guid;
            ann_custom_DiscoveryTime.reset();
            AppliedAnnotationSeq tmp_ann_custom_local_participant_guid;
            eprosima::fastcdr::optional<std::string> unit_local_participant_guid;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_local_participant_guid;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_local_participant_guid;
            eprosima::fastcdr::optional<std::string> hash_id_local_participant_guid;
            if (unit_local_participant_guid.has_value() || min_local_participant_guid.has_value() || max_local_participant_guid.has_value() || hash_id_local_participant_guid.has_value())
            {
                member_ann_builtin_local_participant_guid = TypeObjectUtils::build_applied_builtin_member_annotations(unit_local_participant_guid, min_local_participant_guid, max_local_participant_guid, hash_id_local_participant_guid);
            }
            if (!tmp_ann_custom_local_participant_guid.empty())
            {
                ann_custom_DiscoveryTime = tmp_ann_custom_local_participant_guid;
            }
            CompleteMemberDetail detail_local_participant_guid = TypeObjectUtils::build_complete_member_detail(name_local_participant_guid, member_ann_builtin_local_participant_guid, ann_custom_DiscoveryTime);
            CompleteStructMember member_local_participant_guid = TypeObjectUtils::build_complete_struct_member(common_local_participant_guid, detail_local_participant_guid);
            TypeObjectUtils::add_complete_struct_member(member_seq_DiscoveryTime, member_local_participant_guid);
        }
        {
            TypeIdentifierPair type_ids_remote_entity_guid;
            ReturnCode_t return_code_remote_entity_guid {eprosima::fastdds::dds::RETCODE_OK};
            return_code_remote_entity_guid =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::detail::GUID_s", type_ids_remote_entity_guid);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_remote_entity_guid)
            {
                eprosima::fastdds::statistics::detail::register_GUID_s_type_identifier(type_ids_remote_entity_guid);
            }
            StructMemberFlag member_flags_remote_entity_guid = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_remote_entity_guid = 0x00000001;
            bool common_remote_entity_guid_ec {false};
            CommonStructMember common_remote_entity_guid {TypeObjectUtils::build_common_struct_member(member_id_remote_entity_guid, member_flags_remote_entity_guid, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_remote_entity_guid, common_remote_entity_guid_ec))};
            if (!common_remote_entity_guid_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure remote_entity_guid member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_remote_entity_guid = "remote_entity_guid";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_remote_entity_guid;
            ann_custom_DiscoveryTime.reset();
            AppliedAnnotationSeq tmp_ann_custom_remote_entity_guid;
            eprosima::fastcdr::optional<std::string> unit_remote_entity_guid;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_remote_entity_guid;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_remote_entity_guid;
            eprosima::fastcdr::optional<std::string> hash_id_remote_entity_guid;
            if (unit_remote_entity_guid.has_value() || min_remote_entity_guid.has_value() || max_remote_entity_guid.has_value() || hash_id_remote_entity_guid.has_value())
            {
                member_ann_builtin_remote_entity_guid = TypeObjectUtils::build_applied_builtin_member_annotations(unit_remote_entity_guid, min_remote_entity_guid, max_remote_entity_guid, hash_id_remote_entity_guid);
            }
            if (!tmp_ann_custom_remote_entity_guid.empty())
            {
                ann_custom_DiscoveryTime = tmp_ann_custom_remote_entity_guid;
            }
            CompleteMemberDetail detail_remote_entity_guid = TypeObjectUtils::build_complete_member_detail(name_remote_entity_guid, member_ann_builtin_remote_entity_guid, ann_custom_DiscoveryTime);
            CompleteStructMember member_remote_entity_guid = TypeObjectUtils::build_complete_struct_member(common_remote_entity_guid, detail_remote_entity_guid);
            TypeObjectUtils::add_complete_struct_member(member_seq_DiscoveryTime, member_remote_entity_guid);
        }
        {
            TypeIdentifierPair type_ids_time;
            ReturnCode_t return_code_time {eprosima::fastdds::dds::RETCODE_OK};
            return_code_time =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_time);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_time)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "time Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_time = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_time = 0x00000002;
            bool common_time_ec {false};
            CommonStructMember common_time {TypeObjectUtils::build_common_struct_member(member_id_time, member_flags_time, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_time, common_time_ec))};
            if (!common_time_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure time member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_time = "time";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_time;
            ann_custom_DiscoveryTime.reset();
            CompleteMemberDetail detail_time = TypeObjectUtils::build_complete_member_detail(name_time, member_ann_builtin_time, ann_custom_DiscoveryTime);
            CompleteStructMember member_time = TypeObjectUtils::build_complete_struct_member(common_time, detail_time);
            TypeObjectUtils::add_complete_struct_member(member_seq_DiscoveryTime, member_time);
        }
        {
            TypeIdentifierPair type_ids_host;
            ReturnCode_t return_code_host {eprosima::fastdds::dds::RETCODE_OK};
            return_code_host =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_host);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_host)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_host))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_host = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_host = 0x00000003;
            bool common_host_ec {false};
            CommonStructMember common_host {TypeObjectUtils::build_common_struct_member(member_id_host, member_flags_host, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_host, common_host_ec))};
            if (!common_host_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure host member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_host = "host";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_host;
            ann_custom_DiscoveryTime.reset();
            CompleteMemberDetail detail_host = TypeObjectUtils::build_complete_member_detail(name_host, member_ann_builtin_host, ann_custom_DiscoveryTime);
            CompleteStructMember member_host = TypeObjectUtils::build_complete_struct_member(common_host, detail_host);
            TypeObjectUtils::add_complete_struct_member(member_seq_DiscoveryTime, member_host);
        }
        {
            TypeIdentifierPair type_ids_user;
            ReturnCode_t return_code_user {eprosima::fastdds::dds::RETCODE_OK};
            return_code_user =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_user);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_user)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_user))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_user = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_user = 0x00000004;
            bool common_user_ec {false};
            CommonStructMember common_user {TypeObjectUtils::build_common_struct_member(member_id_user, member_flags_user, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_user, common_user_ec))};
            if (!common_user_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure user member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_user = "user";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_user;
            ann_custom_DiscoveryTime.reset();
            CompleteMemberDetail detail_user = TypeObjectUtils::build_complete_member_detail(name_user, member_ann_builtin_user, ann_custom_DiscoveryTime);
            CompleteStructMember member_user = TypeObjectUtils::build_complete_struct_member(common_user, detail_user);
            TypeObjectUtils::add_complete_struct_member(member_seq_DiscoveryTime, member_user);
        }
        {
            TypeIdentifierPair type_ids_process;
            ReturnCode_t return_code_process {eprosima::fastdds::dds::RETCODE_OK};
            return_code_process =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_process);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_process)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_process))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_process = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_process = 0x00000005;
            bool common_process_ec {false};
            CommonStructMember common_process {TypeObjectUtils::build_common_struct_member(member_id_process, member_flags_process, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_process, common_process_ec))};
            if (!common_process_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure process member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_process = "process";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_process;
            ann_custom_DiscoveryTime.reset();
            CompleteMemberDetail detail_process = TypeObjectUtils::build_complete_member_detail(name_process, member_ann_builtin_process, ann_custom_DiscoveryTime);
            CompleteStructMember member_process = TypeObjectUtils::build_complete_struct_member(common_process, detail_process);
            TypeObjectUtils::add_complete_struct_member(member_seq_DiscoveryTime, member_process);
        }
        CompleteStructType struct_type_DiscoveryTime = TypeObjectUtils::build_complete_struct_type(struct_flags_DiscoveryTime, header_DiscoveryTime, member_seq_DiscoveryTime);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_DiscoveryTime, type_name_DiscoveryTime.to_string(), type_ids_DiscoveryTime))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::DiscoveryTime already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_EntityCount_type_identifier(
        TypeIdentifierPair& type_ids_EntityCount)
{

    ReturnCode_t return_code_EntityCount {eprosima::fastdds::dds::RETCODE_OK};
    return_code_EntityCount =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::EntityCount", type_ids_EntityCount);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_EntityCount)
    {
        StructTypeFlag struct_flags_EntityCount = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_EntityCount = "eprosima::fastdds::statistics::EntityCount";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_EntityCount;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_EntityCount;
        CompleteTypeDetail detail_EntityCount = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_EntityCount, ann_custom_EntityCount, type_name_EntityCount.to_string());
        CompleteStructHeader header_EntityCount;
        header_EntityCount = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_EntityCount);
        CompleteStructMemberSeq member_seq_EntityCount;
        {
            TypeIdentifierPair type_ids_guid;
            ReturnCode_t return_code_guid {eprosima::fastdds::dds::RETCODE_OK};
            return_code_guid =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::detail::GUID_s", type_ids_guid);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_guid)
            {
                eprosima::fastdds::statistics::detail::register_GUID_s_type_identifier(type_ids_guid);
            }
            StructMemberFlag member_flags_guid = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_guid = 0x00000000;
            bool common_guid_ec {false};
            CommonStructMember common_guid {TypeObjectUtils::build_common_struct_member(member_id_guid, member_flags_guid, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_guid, common_guid_ec))};
            if (!common_guid_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure guid member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_guid = "guid";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_guid;
            ann_custom_EntityCount.reset();
            AppliedAnnotationSeq tmp_ann_custom_guid;
            eprosima::fastcdr::optional<std::string> unit_guid;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_guid;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_guid;
            eprosima::fastcdr::optional<std::string> hash_id_guid;
            if (unit_guid.has_value() || min_guid.has_value() || max_guid.has_value() || hash_id_guid.has_value())
            {
                member_ann_builtin_guid = TypeObjectUtils::build_applied_builtin_member_annotations(unit_guid, min_guid, max_guid, hash_id_guid);
            }
            if (!tmp_ann_custom_guid.empty())
            {
                ann_custom_EntityCount = tmp_ann_custom_guid;
            }
            CompleteMemberDetail detail_guid = TypeObjectUtils::build_complete_member_detail(name_guid, member_ann_builtin_guid, ann_custom_EntityCount);
            CompleteStructMember member_guid = TypeObjectUtils::build_complete_struct_member(common_guid, detail_guid);
            TypeObjectUtils::add_complete_struct_member(member_seq_EntityCount, member_guid);
        }
        {
            TypeIdentifierPair type_ids_count;
            ReturnCode_t return_code_count {eprosima::fastdds::dds::RETCODE_OK};
            return_code_count =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_count);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_count)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "count Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_count = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_count = 0x00000001;
            bool common_count_ec {false};
            CommonStructMember common_count {TypeObjectUtils::build_common_struct_member(member_id_count, member_flags_count, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_count, common_count_ec))};
            if (!common_count_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure count member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_count = "count";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_count;
            ann_custom_EntityCount.reset();
            CompleteMemberDetail detail_count = TypeObjectUtils::build_complete_member_detail(name_count, member_ann_builtin_count, ann_custom_EntityCount);
            CompleteStructMember member_count = TypeObjectUtils::build_complete_struct_member(common_count, detail_count);
            TypeObjectUtils::add_complete_struct_member(member_seq_EntityCount, member_count);
        }
        CompleteStructType struct_type_EntityCount = TypeObjectUtils::build_complete_struct_type(struct_flags_EntityCount, header_EntityCount, member_seq_EntityCount);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_EntityCount, type_name_EntityCount.to_string(), type_ids_EntityCount))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::EntityCount already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SampleIdentityCount_type_identifier(
        TypeIdentifierPair& type_ids_SampleIdentityCount)
{

    ReturnCode_t return_code_SampleIdentityCount {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SampleIdentityCount =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::SampleIdentityCount", type_ids_SampleIdentityCount);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SampleIdentityCount)
    {
        StructTypeFlag struct_flags_SampleIdentityCount = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SampleIdentityCount = "eprosima::fastdds::statistics::SampleIdentityCount";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SampleIdentityCount;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SampleIdentityCount;
        CompleteTypeDetail detail_SampleIdentityCount = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SampleIdentityCount, ann_custom_SampleIdentityCount, type_name_SampleIdentityCount.to_string());
        CompleteStructHeader header_SampleIdentityCount;
        header_SampleIdentityCount = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SampleIdentityCount);
        CompleteStructMemberSeq member_seq_SampleIdentityCount;
        {
            TypeIdentifierPair type_ids_sample_id;
            ReturnCode_t return_code_sample_id {eprosima::fastdds::dds::RETCODE_OK};
            return_code_sample_id =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::detail::SampleIdentity_s", type_ids_sample_id);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_sample_id)
            {
                eprosima::fastdds::statistics::detail::register_SampleIdentity_s_type_identifier(type_ids_sample_id);
            }
            StructMemberFlag member_flags_sample_id = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_sample_id = 0x00000000;
            bool common_sample_id_ec {false};
            CommonStructMember common_sample_id {TypeObjectUtils::build_common_struct_member(member_id_sample_id, member_flags_sample_id, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_sample_id, common_sample_id_ec))};
            if (!common_sample_id_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure sample_id member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_sample_id = "sample_id";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_sample_id;
            ann_custom_SampleIdentityCount.reset();
            AppliedAnnotationSeq tmp_ann_custom_sample_id;
            eprosima::fastcdr::optional<std::string> unit_sample_id;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_sample_id;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_sample_id;
            eprosima::fastcdr::optional<std::string> hash_id_sample_id;
            if (unit_sample_id.has_value() || min_sample_id.has_value() || max_sample_id.has_value() || hash_id_sample_id.has_value())
            {
                member_ann_builtin_sample_id = TypeObjectUtils::build_applied_builtin_member_annotations(unit_sample_id, min_sample_id, max_sample_id, hash_id_sample_id);
            }
            if (!tmp_ann_custom_sample_id.empty())
            {
                ann_custom_SampleIdentityCount = tmp_ann_custom_sample_id;
            }
            CompleteMemberDetail detail_sample_id = TypeObjectUtils::build_complete_member_detail(name_sample_id, member_ann_builtin_sample_id, ann_custom_SampleIdentityCount);
            CompleteStructMember member_sample_id = TypeObjectUtils::build_complete_struct_member(common_sample_id, detail_sample_id);
            TypeObjectUtils::add_complete_struct_member(member_seq_SampleIdentityCount, member_sample_id);
        }
        {
            TypeIdentifierPair type_ids_count;
            ReturnCode_t return_code_count {eprosima::fastdds::dds::RETCODE_OK};
            return_code_count =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_count);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_count)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "count Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_count = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_count = 0x00000001;
            bool common_count_ec {false};
            CommonStructMember common_count {TypeObjectUtils::build_common_struct_member(member_id_count, member_flags_count, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_count, common_count_ec))};
            if (!common_count_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure count member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_count = "count";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_count;
            ann_custom_SampleIdentityCount.reset();
            CompleteMemberDetail detail_count = TypeObjectUtils::build_complete_member_detail(name_count, member_ann_builtin_count, ann_custom_SampleIdentityCount);
            CompleteStructMember member_count = TypeObjectUtils::build_complete_struct_member(common_count, detail_count);
            TypeObjectUtils::add_complete_struct_member(member_seq_SampleIdentityCount, member_count);
        }
        CompleteStructType struct_type_SampleIdentityCount = TypeObjectUtils::build_complete_struct_type(struct_flags_SampleIdentityCount, header_SampleIdentityCount, member_seq_SampleIdentityCount);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SampleIdentityCount, type_name_SampleIdentityCount.to_string(), type_ids_SampleIdentityCount))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::SampleIdentityCount already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Entity2LocatorTraffic_type_identifier(
        TypeIdentifierPair& type_ids_Entity2LocatorTraffic)
{

    ReturnCode_t return_code_Entity2LocatorTraffic {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Entity2LocatorTraffic =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::Entity2LocatorTraffic", type_ids_Entity2LocatorTraffic);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Entity2LocatorTraffic)
    {
        StructTypeFlag struct_flags_Entity2LocatorTraffic = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Entity2LocatorTraffic = "eprosima::fastdds::statistics::Entity2LocatorTraffic";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Entity2LocatorTraffic;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Entity2LocatorTraffic;
        CompleteTypeDetail detail_Entity2LocatorTraffic = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Entity2LocatorTraffic, ann_custom_Entity2LocatorTraffic, type_name_Entity2LocatorTraffic.to_string());
        CompleteStructHeader header_Entity2LocatorTraffic;
        header_Entity2LocatorTraffic = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Entity2LocatorTraffic);
        CompleteStructMemberSeq member_seq_Entity2LocatorTraffic;
        {
            TypeIdentifierPair type_ids_src_guid;
            ReturnCode_t return_code_src_guid {eprosima::fastdds::dds::RETCODE_OK};
            return_code_src_guid =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::detail::GUID_s", type_ids_src_guid);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_src_guid)
            {
                eprosima::fastdds::statistics::detail::register_GUID_s_type_identifier(type_ids_src_guid);
            }
            StructMemberFlag member_flags_src_guid = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_src_guid = 0x00000000;
            bool common_src_guid_ec {false};
            CommonStructMember common_src_guid {TypeObjectUtils::build_common_struct_member(member_id_src_guid, member_flags_src_guid, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_src_guid, common_src_guid_ec))};
            if (!common_src_guid_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure src_guid member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_src_guid = "src_guid";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_src_guid;
            ann_custom_Entity2LocatorTraffic.reset();
            AppliedAnnotationSeq tmp_ann_custom_src_guid;
            eprosima::fastcdr::optional<std::string> unit_src_guid;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_src_guid;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_src_guid;
            eprosima::fastcdr::optional<std::string> hash_id_src_guid;
            if (unit_src_guid.has_value() || min_src_guid.has_value() || max_src_guid.has_value() || hash_id_src_guid.has_value())
            {
                member_ann_builtin_src_guid = TypeObjectUtils::build_applied_builtin_member_annotations(unit_src_guid, min_src_guid, max_src_guid, hash_id_src_guid);
            }
            if (!tmp_ann_custom_src_guid.empty())
            {
                ann_custom_Entity2LocatorTraffic = tmp_ann_custom_src_guid;
            }
            CompleteMemberDetail detail_src_guid = TypeObjectUtils::build_complete_member_detail(name_src_guid, member_ann_builtin_src_guid, ann_custom_Entity2LocatorTraffic);
            CompleteStructMember member_src_guid = TypeObjectUtils::build_complete_struct_member(common_src_guid, detail_src_guid);
            TypeObjectUtils::add_complete_struct_member(member_seq_Entity2LocatorTraffic, member_src_guid);
        }
        {
            TypeIdentifierPair type_ids_dst_locator;
            ReturnCode_t return_code_dst_locator {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dst_locator =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::detail::Locator_s", type_ids_dst_locator);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dst_locator)
            {
                eprosima::fastdds::statistics::detail::register_Locator_s_type_identifier(type_ids_dst_locator);
            }
            StructMemberFlag member_flags_dst_locator = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_dst_locator = 0x00000001;
            bool common_dst_locator_ec {false};
            CommonStructMember common_dst_locator {TypeObjectUtils::build_common_struct_member(member_id_dst_locator, member_flags_dst_locator, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dst_locator, common_dst_locator_ec))};
            if (!common_dst_locator_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dst_locator member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dst_locator = "dst_locator";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dst_locator;
            ann_custom_Entity2LocatorTraffic.reset();
            AppliedAnnotationSeq tmp_ann_custom_dst_locator;
            eprosima::fastcdr::optional<std::string> unit_dst_locator;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_dst_locator;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_dst_locator;
            eprosima::fastcdr::optional<std::string> hash_id_dst_locator;
            if (unit_dst_locator.has_value() || min_dst_locator.has_value() || max_dst_locator.has_value() || hash_id_dst_locator.has_value())
            {
                member_ann_builtin_dst_locator = TypeObjectUtils::build_applied_builtin_member_annotations(unit_dst_locator, min_dst_locator, max_dst_locator, hash_id_dst_locator);
            }
            if (!tmp_ann_custom_dst_locator.empty())
            {
                ann_custom_Entity2LocatorTraffic = tmp_ann_custom_dst_locator;
            }
            CompleteMemberDetail detail_dst_locator = TypeObjectUtils::build_complete_member_detail(name_dst_locator, member_ann_builtin_dst_locator, ann_custom_Entity2LocatorTraffic);
            CompleteStructMember member_dst_locator = TypeObjectUtils::build_complete_struct_member(common_dst_locator, detail_dst_locator);
            TypeObjectUtils::add_complete_struct_member(member_seq_Entity2LocatorTraffic, member_dst_locator);
        }
        {
            TypeIdentifierPair type_ids_packet_count;
            ReturnCode_t return_code_packet_count {eprosima::fastdds::dds::RETCODE_OK};
            return_code_packet_count =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_packet_count);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_packet_count)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "packet_count Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_packet_count = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_packet_count = 0x00000002;
            bool common_packet_count_ec {false};
            CommonStructMember common_packet_count {TypeObjectUtils::build_common_struct_member(member_id_packet_count, member_flags_packet_count, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_packet_count, common_packet_count_ec))};
            if (!common_packet_count_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure packet_count member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_packet_count = "packet_count";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_packet_count;
            ann_custom_Entity2LocatorTraffic.reset();
            CompleteMemberDetail detail_packet_count = TypeObjectUtils::build_complete_member_detail(name_packet_count, member_ann_builtin_packet_count, ann_custom_Entity2LocatorTraffic);
            CompleteStructMember member_packet_count = TypeObjectUtils::build_complete_struct_member(common_packet_count, detail_packet_count);
            TypeObjectUtils::add_complete_struct_member(member_seq_Entity2LocatorTraffic, member_packet_count);
        }
        {
            TypeIdentifierPair type_ids_byte_count;
            ReturnCode_t return_code_byte_count {eprosima::fastdds::dds::RETCODE_OK};
            return_code_byte_count =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_byte_count);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_byte_count)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "byte_count Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_byte_count = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_byte_count = 0x00000003;
            bool common_byte_count_ec {false};
            CommonStructMember common_byte_count {TypeObjectUtils::build_common_struct_member(member_id_byte_count, member_flags_byte_count, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_byte_count, common_byte_count_ec))};
            if (!common_byte_count_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure byte_count member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_byte_count = "byte_count";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_byte_count;
            ann_custom_Entity2LocatorTraffic.reset();
            CompleteMemberDetail detail_byte_count = TypeObjectUtils::build_complete_member_detail(name_byte_count, member_ann_builtin_byte_count, ann_custom_Entity2LocatorTraffic);
            CompleteStructMember member_byte_count = TypeObjectUtils::build_complete_struct_member(common_byte_count, detail_byte_count);
            TypeObjectUtils::add_complete_struct_member(member_seq_Entity2LocatorTraffic, member_byte_count);
        }
        {
            TypeIdentifierPair type_ids_byte_magnitude_order;
            ReturnCode_t return_code_byte_magnitude_order {eprosima::fastdds::dds::RETCODE_OK};
            return_code_byte_magnitude_order =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_byte_magnitude_order);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_byte_magnitude_order)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "byte_magnitude_order Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_byte_magnitude_order = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_byte_magnitude_order = 0x00000004;
            bool common_byte_magnitude_order_ec {false};
            CommonStructMember common_byte_magnitude_order {TypeObjectUtils::build_common_struct_member(member_id_byte_magnitude_order, member_flags_byte_magnitude_order, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_byte_magnitude_order, common_byte_magnitude_order_ec))};
            if (!common_byte_magnitude_order_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure byte_magnitude_order member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_byte_magnitude_order = "byte_magnitude_order";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_byte_magnitude_order;
            ann_custom_Entity2LocatorTraffic.reset();
            CompleteMemberDetail detail_byte_magnitude_order = TypeObjectUtils::build_complete_member_detail(name_byte_magnitude_order, member_ann_builtin_byte_magnitude_order, ann_custom_Entity2LocatorTraffic);
            CompleteStructMember member_byte_magnitude_order = TypeObjectUtils::build_complete_struct_member(common_byte_magnitude_order, detail_byte_magnitude_order);
            TypeObjectUtils::add_complete_struct_member(member_seq_Entity2LocatorTraffic, member_byte_magnitude_order);
        }
        CompleteStructType struct_type_Entity2LocatorTraffic = TypeObjectUtils::build_complete_struct_type(struct_flags_Entity2LocatorTraffic, header_Entity2LocatorTraffic, member_seq_Entity2LocatorTraffic);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Entity2LocatorTraffic, type_name_Entity2LocatorTraffic.to_string(), type_ids_Entity2LocatorTraffic))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::Entity2LocatorTraffic already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_WriterReaderData_type_identifier(
        TypeIdentifierPair& type_ids_WriterReaderData)
{

    ReturnCode_t return_code_WriterReaderData {eprosima::fastdds::dds::RETCODE_OK};
    return_code_WriterReaderData =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::WriterReaderData", type_ids_WriterReaderData);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_WriterReaderData)
    {
        StructTypeFlag struct_flags_WriterReaderData = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_WriterReaderData = "eprosima::fastdds::statistics::WriterReaderData";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_WriterReaderData;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_WriterReaderData;
        CompleteTypeDetail detail_WriterReaderData = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_WriterReaderData, ann_custom_WriterReaderData, type_name_WriterReaderData.to_string());
        CompleteStructHeader header_WriterReaderData;
        header_WriterReaderData = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_WriterReaderData);
        CompleteStructMemberSeq member_seq_WriterReaderData;
        {
            TypeIdentifierPair type_ids_writer_guid;
            ReturnCode_t return_code_writer_guid {eprosima::fastdds::dds::RETCODE_OK};
            return_code_writer_guid =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::detail::GUID_s", type_ids_writer_guid);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_writer_guid)
            {
                eprosima::fastdds::statistics::detail::register_GUID_s_type_identifier(type_ids_writer_guid);
            }
            StructMemberFlag member_flags_writer_guid = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_writer_guid = 0x00000000;
            bool common_writer_guid_ec {false};
            CommonStructMember common_writer_guid {TypeObjectUtils::build_common_struct_member(member_id_writer_guid, member_flags_writer_guid, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_writer_guid, common_writer_guid_ec))};
            if (!common_writer_guid_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure writer_guid member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_writer_guid = "writer_guid";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_writer_guid;
            ann_custom_WriterReaderData.reset();
            AppliedAnnotationSeq tmp_ann_custom_writer_guid;
            eprosima::fastcdr::optional<std::string> unit_writer_guid;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_writer_guid;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_writer_guid;
            eprosima::fastcdr::optional<std::string> hash_id_writer_guid;
            if (unit_writer_guid.has_value() || min_writer_guid.has_value() || max_writer_guid.has_value() || hash_id_writer_guid.has_value())
            {
                member_ann_builtin_writer_guid = TypeObjectUtils::build_applied_builtin_member_annotations(unit_writer_guid, min_writer_guid, max_writer_guid, hash_id_writer_guid);
            }
            if (!tmp_ann_custom_writer_guid.empty())
            {
                ann_custom_WriterReaderData = tmp_ann_custom_writer_guid;
            }
            CompleteMemberDetail detail_writer_guid = TypeObjectUtils::build_complete_member_detail(name_writer_guid, member_ann_builtin_writer_guid, ann_custom_WriterReaderData);
            CompleteStructMember member_writer_guid = TypeObjectUtils::build_complete_struct_member(common_writer_guid, detail_writer_guid);
            TypeObjectUtils::add_complete_struct_member(member_seq_WriterReaderData, member_writer_guid);
        }
        {
            TypeIdentifierPair type_ids_reader_guid;
            ReturnCode_t return_code_reader_guid {eprosima::fastdds::dds::RETCODE_OK};
            return_code_reader_guid =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::detail::GUID_s", type_ids_reader_guid);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_reader_guid)
            {
                eprosima::fastdds::statistics::detail::register_GUID_s_type_identifier(type_ids_reader_guid);
            }
            StructMemberFlag member_flags_reader_guid = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_reader_guid = 0x00000001;
            bool common_reader_guid_ec {false};
            CommonStructMember common_reader_guid {TypeObjectUtils::build_common_struct_member(member_id_reader_guid, member_flags_reader_guid, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_reader_guid, common_reader_guid_ec))};
            if (!common_reader_guid_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure reader_guid member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_reader_guid = "reader_guid";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_reader_guid;
            ann_custom_WriterReaderData.reset();
            AppliedAnnotationSeq tmp_ann_custom_reader_guid;
            eprosima::fastcdr::optional<std::string> unit_reader_guid;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_reader_guid;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_reader_guid;
            eprosima::fastcdr::optional<std::string> hash_id_reader_guid;
            if (unit_reader_guid.has_value() || min_reader_guid.has_value() || max_reader_guid.has_value() || hash_id_reader_guid.has_value())
            {
                member_ann_builtin_reader_guid = TypeObjectUtils::build_applied_builtin_member_annotations(unit_reader_guid, min_reader_guid, max_reader_guid, hash_id_reader_guid);
            }
            if (!tmp_ann_custom_reader_guid.empty())
            {
                ann_custom_WriterReaderData = tmp_ann_custom_reader_guid;
            }
            CompleteMemberDetail detail_reader_guid = TypeObjectUtils::build_complete_member_detail(name_reader_guid, member_ann_builtin_reader_guid, ann_custom_WriterReaderData);
            CompleteStructMember member_reader_guid = TypeObjectUtils::build_complete_struct_member(common_reader_guid, detail_reader_guid);
            TypeObjectUtils::add_complete_struct_member(member_seq_WriterReaderData, member_reader_guid);
        }
        {
            TypeIdentifierPair type_ids_data;
            ReturnCode_t return_code_data {eprosima::fastdds::dds::RETCODE_OK};
            return_code_data =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_data);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_data)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "data Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_data = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_data = 0x00000002;
            bool common_data_ec {false};
            CommonStructMember common_data {TypeObjectUtils::build_common_struct_member(member_id_data, member_flags_data, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_data, common_data_ec))};
            if (!common_data_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure data member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_data = "data";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_data;
            ann_custom_WriterReaderData.reset();
            CompleteMemberDetail detail_data = TypeObjectUtils::build_complete_member_detail(name_data, member_ann_builtin_data, ann_custom_WriterReaderData);
            CompleteStructMember member_data = TypeObjectUtils::build_complete_struct_member(common_data, detail_data);
            TypeObjectUtils::add_complete_struct_member(member_seq_WriterReaderData, member_data);
        }
        CompleteStructType struct_type_WriterReaderData = TypeObjectUtils::build_complete_struct_type(struct_flags_WriterReaderData, header_WriterReaderData, member_seq_WriterReaderData);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_WriterReaderData, type_name_WriterReaderData.to_string(), type_ids_WriterReaderData))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::WriterReaderData already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Locator2LocatorData_type_identifier(
        TypeIdentifierPair& type_ids_Locator2LocatorData)
{

    ReturnCode_t return_code_Locator2LocatorData {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Locator2LocatorData =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::Locator2LocatorData", type_ids_Locator2LocatorData);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Locator2LocatorData)
    {
        StructTypeFlag struct_flags_Locator2LocatorData = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Locator2LocatorData = "eprosima::fastdds::statistics::Locator2LocatorData";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Locator2LocatorData;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Locator2LocatorData;
        CompleteTypeDetail detail_Locator2LocatorData = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Locator2LocatorData, ann_custom_Locator2LocatorData, type_name_Locator2LocatorData.to_string());
        CompleteStructHeader header_Locator2LocatorData;
        header_Locator2LocatorData = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Locator2LocatorData);
        CompleteStructMemberSeq member_seq_Locator2LocatorData;
        {
            TypeIdentifierPair type_ids_src_locator;
            ReturnCode_t return_code_src_locator {eprosima::fastdds::dds::RETCODE_OK};
            return_code_src_locator =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::detail::Locator_s", type_ids_src_locator);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_src_locator)
            {
                eprosima::fastdds::statistics::detail::register_Locator_s_type_identifier(type_ids_src_locator);
            }
            StructMemberFlag member_flags_src_locator = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_src_locator = 0x00000000;
            bool common_src_locator_ec {false};
            CommonStructMember common_src_locator {TypeObjectUtils::build_common_struct_member(member_id_src_locator, member_flags_src_locator, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_src_locator, common_src_locator_ec))};
            if (!common_src_locator_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure src_locator member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_src_locator = "src_locator";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_src_locator;
            ann_custom_Locator2LocatorData.reset();
            AppliedAnnotationSeq tmp_ann_custom_src_locator;
            eprosima::fastcdr::optional<std::string> unit_src_locator;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_src_locator;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_src_locator;
            eprosima::fastcdr::optional<std::string> hash_id_src_locator;
            if (unit_src_locator.has_value() || min_src_locator.has_value() || max_src_locator.has_value() || hash_id_src_locator.has_value())
            {
                member_ann_builtin_src_locator = TypeObjectUtils::build_applied_builtin_member_annotations(unit_src_locator, min_src_locator, max_src_locator, hash_id_src_locator);
            }
            if (!tmp_ann_custom_src_locator.empty())
            {
                ann_custom_Locator2LocatorData = tmp_ann_custom_src_locator;
            }
            CompleteMemberDetail detail_src_locator = TypeObjectUtils::build_complete_member_detail(name_src_locator, member_ann_builtin_src_locator, ann_custom_Locator2LocatorData);
            CompleteStructMember member_src_locator = TypeObjectUtils::build_complete_struct_member(common_src_locator, detail_src_locator);
            TypeObjectUtils::add_complete_struct_member(member_seq_Locator2LocatorData, member_src_locator);
        }
        {
            TypeIdentifierPair type_ids_dst_locator;
            ReturnCode_t return_code_dst_locator {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dst_locator =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::detail::Locator_s", type_ids_dst_locator);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dst_locator)
            {
                eprosima::fastdds::statistics::detail::register_Locator_s_type_identifier(type_ids_dst_locator);
            }
            StructMemberFlag member_flags_dst_locator = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_dst_locator = 0x00000001;
            bool common_dst_locator_ec {false};
            CommonStructMember common_dst_locator {TypeObjectUtils::build_common_struct_member(member_id_dst_locator, member_flags_dst_locator, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dst_locator, common_dst_locator_ec))};
            if (!common_dst_locator_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dst_locator member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dst_locator = "dst_locator";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dst_locator;
            ann_custom_Locator2LocatorData.reset();
            AppliedAnnotationSeq tmp_ann_custom_dst_locator;
            eprosima::fastcdr::optional<std::string> unit_dst_locator;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_dst_locator;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_dst_locator;
            eprosima::fastcdr::optional<std::string> hash_id_dst_locator;
            if (unit_dst_locator.has_value() || min_dst_locator.has_value() || max_dst_locator.has_value() || hash_id_dst_locator.has_value())
            {
                member_ann_builtin_dst_locator = TypeObjectUtils::build_applied_builtin_member_annotations(unit_dst_locator, min_dst_locator, max_dst_locator, hash_id_dst_locator);
            }
            if (!tmp_ann_custom_dst_locator.empty())
            {
                ann_custom_Locator2LocatorData = tmp_ann_custom_dst_locator;
            }
            CompleteMemberDetail detail_dst_locator = TypeObjectUtils::build_complete_member_detail(name_dst_locator, member_ann_builtin_dst_locator, ann_custom_Locator2LocatorData);
            CompleteStructMember member_dst_locator = TypeObjectUtils::build_complete_struct_member(common_dst_locator, detail_dst_locator);
            TypeObjectUtils::add_complete_struct_member(member_seq_Locator2LocatorData, member_dst_locator);
        }
        {
            TypeIdentifierPair type_ids_data;
            ReturnCode_t return_code_data {eprosima::fastdds::dds::RETCODE_OK};
            return_code_data =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_data);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_data)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "data Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_data = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_data = 0x00000002;
            bool common_data_ec {false};
            CommonStructMember common_data {TypeObjectUtils::build_common_struct_member(member_id_data, member_flags_data, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_data, common_data_ec))};
            if (!common_data_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure data member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_data = "data";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_data;
            ann_custom_Locator2LocatorData.reset();
            CompleteMemberDetail detail_data = TypeObjectUtils::build_complete_member_detail(name_data, member_ann_builtin_data, ann_custom_Locator2LocatorData);
            CompleteStructMember member_data = TypeObjectUtils::build_complete_struct_member(common_data, detail_data);
            TypeObjectUtils::add_complete_struct_member(member_seq_Locator2LocatorData, member_data);
        }
        CompleteStructType struct_type_Locator2LocatorData = TypeObjectUtils::build_complete_struct_type(struct_flags_Locator2LocatorData, header_Locator2LocatorData, member_seq_Locator2LocatorData);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Locator2LocatorData, type_name_Locator2LocatorData.to_string(), type_ids_Locator2LocatorData))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::Locator2LocatorData already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_EntityData_type_identifier(
        TypeIdentifierPair& type_ids_EntityData)
{

    ReturnCode_t return_code_EntityData {eprosima::fastdds::dds::RETCODE_OK};
    return_code_EntityData =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::EntityData", type_ids_EntityData);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_EntityData)
    {
        StructTypeFlag struct_flags_EntityData = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_EntityData = "eprosima::fastdds::statistics::EntityData";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_EntityData;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_EntityData;
        CompleteTypeDetail detail_EntityData = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_EntityData, ann_custom_EntityData, type_name_EntityData.to_string());
        CompleteStructHeader header_EntityData;
        header_EntityData = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_EntityData);
        CompleteStructMemberSeq member_seq_EntityData;
        {
            TypeIdentifierPair type_ids_guid;
            ReturnCode_t return_code_guid {eprosima::fastdds::dds::RETCODE_OK};
            return_code_guid =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::detail::GUID_s", type_ids_guid);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_guid)
            {
                eprosima::fastdds::statistics::detail::register_GUID_s_type_identifier(type_ids_guid);
            }
            StructMemberFlag member_flags_guid = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_guid = 0x00000000;
            bool common_guid_ec {false};
            CommonStructMember common_guid {TypeObjectUtils::build_common_struct_member(member_id_guid, member_flags_guid, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_guid, common_guid_ec))};
            if (!common_guid_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure guid member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_guid = "guid";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_guid;
            ann_custom_EntityData.reset();
            AppliedAnnotationSeq tmp_ann_custom_guid;
            eprosima::fastcdr::optional<std::string> unit_guid;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_guid;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_guid;
            eprosima::fastcdr::optional<std::string> hash_id_guid;
            if (unit_guid.has_value() || min_guid.has_value() || max_guid.has_value() || hash_id_guid.has_value())
            {
                member_ann_builtin_guid = TypeObjectUtils::build_applied_builtin_member_annotations(unit_guid, min_guid, max_guid, hash_id_guid);
            }
            if (!tmp_ann_custom_guid.empty())
            {
                ann_custom_EntityData = tmp_ann_custom_guid;
            }
            CompleteMemberDetail detail_guid = TypeObjectUtils::build_complete_member_detail(name_guid, member_ann_builtin_guid, ann_custom_EntityData);
            CompleteStructMember member_guid = TypeObjectUtils::build_complete_struct_member(common_guid, detail_guid);
            TypeObjectUtils::add_complete_struct_member(member_seq_EntityData, member_guid);
        }
        {
            TypeIdentifierPair type_ids_data;
            ReturnCode_t return_code_data {eprosima::fastdds::dds::RETCODE_OK};
            return_code_data =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_data);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_data)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "data Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_data = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_data = 0x00000001;
            bool common_data_ec {false};
            CommonStructMember common_data {TypeObjectUtils::build_common_struct_member(member_id_data, member_flags_data, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_data, common_data_ec))};
            if (!common_data_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure data member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_data = "data";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_data;
            ann_custom_EntityData.reset();
            CompleteMemberDetail detail_data = TypeObjectUtils::build_complete_member_detail(name_data, member_ann_builtin_data, ann_custom_EntityData);
            CompleteStructMember member_data = TypeObjectUtils::build_complete_struct_member(common_data, detail_data);
            TypeObjectUtils::add_complete_struct_member(member_seq_EntityData, member_data);
        }
        CompleteStructType struct_type_EntityData = TypeObjectUtils::build_complete_struct_type(struct_flags_EntityData, header_EntityData, member_seq_EntityData);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_EntityData, type_name_EntityData.to_string(), type_ids_EntityData))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::EntityData already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_PhysicalData_type_identifier(
        TypeIdentifierPair& type_ids_PhysicalData)
{

    ReturnCode_t return_code_PhysicalData {eprosima::fastdds::dds::RETCODE_OK};
    return_code_PhysicalData =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::PhysicalData", type_ids_PhysicalData);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_PhysicalData)
    {
        StructTypeFlag struct_flags_PhysicalData = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_PhysicalData = "eprosima::fastdds::statistics::PhysicalData";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_PhysicalData;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_PhysicalData;
        CompleteTypeDetail detail_PhysicalData = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_PhysicalData, ann_custom_PhysicalData, type_name_PhysicalData.to_string());
        CompleteStructHeader header_PhysicalData;
        header_PhysicalData = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_PhysicalData);
        CompleteStructMemberSeq member_seq_PhysicalData;
        {
            TypeIdentifierPair type_ids_participant_guid;
            ReturnCode_t return_code_participant_guid {eprosima::fastdds::dds::RETCODE_OK};
            return_code_participant_guid =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::detail::GUID_s", type_ids_participant_guid);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_participant_guid)
            {
                eprosima::fastdds::statistics::detail::register_GUID_s_type_identifier(type_ids_participant_guid);
            }
            StructMemberFlag member_flags_participant_guid = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_participant_guid = 0x00000000;
            bool common_participant_guid_ec {false};
            CommonStructMember common_participant_guid {TypeObjectUtils::build_common_struct_member(member_id_participant_guid, member_flags_participant_guid, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_participant_guid, common_participant_guid_ec))};
            if (!common_participant_guid_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure participant_guid member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_participant_guid = "participant_guid";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_participant_guid;
            ann_custom_PhysicalData.reset();
            AppliedAnnotationSeq tmp_ann_custom_participant_guid;
            eprosima::fastcdr::optional<std::string> unit_participant_guid;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_participant_guid;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_participant_guid;
            eprosima::fastcdr::optional<std::string> hash_id_participant_guid;
            if (unit_participant_guid.has_value() || min_participant_guid.has_value() || max_participant_guid.has_value() || hash_id_participant_guid.has_value())
            {
                member_ann_builtin_participant_guid = TypeObjectUtils::build_applied_builtin_member_annotations(unit_participant_guid, min_participant_guid, max_participant_guid, hash_id_participant_guid);
            }
            if (!tmp_ann_custom_participant_guid.empty())
            {
                ann_custom_PhysicalData = tmp_ann_custom_participant_guid;
            }
            CompleteMemberDetail detail_participant_guid = TypeObjectUtils::build_complete_member_detail(name_participant_guid, member_ann_builtin_participant_guid, ann_custom_PhysicalData);
            CompleteStructMember member_participant_guid = TypeObjectUtils::build_complete_struct_member(common_participant_guid, detail_participant_guid);
            TypeObjectUtils::add_complete_struct_member(member_seq_PhysicalData, member_participant_guid);
        }
        {
            TypeIdentifierPair type_ids_host;
            ReturnCode_t return_code_host {eprosima::fastdds::dds::RETCODE_OK};
            return_code_host =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_host);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_host)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_host))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_host = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_host = 0x00000001;
            bool common_host_ec {false};
            CommonStructMember common_host {TypeObjectUtils::build_common_struct_member(member_id_host, member_flags_host, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_host, common_host_ec))};
            if (!common_host_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure host member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_host = "host";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_host;
            ann_custom_PhysicalData.reset();
            CompleteMemberDetail detail_host = TypeObjectUtils::build_complete_member_detail(name_host, member_ann_builtin_host, ann_custom_PhysicalData);
            CompleteStructMember member_host = TypeObjectUtils::build_complete_struct_member(common_host, detail_host);
            TypeObjectUtils::add_complete_struct_member(member_seq_PhysicalData, member_host);
        }
        {
            TypeIdentifierPair type_ids_user;
            ReturnCode_t return_code_user {eprosima::fastdds::dds::RETCODE_OK};
            return_code_user =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_user);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_user)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_user))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_user = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_user = 0x00000002;
            bool common_user_ec {false};
            CommonStructMember common_user {TypeObjectUtils::build_common_struct_member(member_id_user, member_flags_user, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_user, common_user_ec))};
            if (!common_user_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure user member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_user = "user";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_user;
            ann_custom_PhysicalData.reset();
            CompleteMemberDetail detail_user = TypeObjectUtils::build_complete_member_detail(name_user, member_ann_builtin_user, ann_custom_PhysicalData);
            CompleteStructMember member_user = TypeObjectUtils::build_complete_struct_member(common_user, detail_user);
            TypeObjectUtils::add_complete_struct_member(member_seq_PhysicalData, member_user);
        }
        {
            TypeIdentifierPair type_ids_process;
            ReturnCode_t return_code_process {eprosima::fastdds::dds::RETCODE_OK};
            return_code_process =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_process);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_process)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_process))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_process = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_process = 0x00000003;
            bool common_process_ec {false};
            CommonStructMember common_process {TypeObjectUtils::build_common_struct_member(member_id_process, member_flags_process, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_process, common_process_ec))};
            if (!common_process_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure process member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_process = "process";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_process;
            ann_custom_PhysicalData.reset();
            CompleteMemberDetail detail_process = TypeObjectUtils::build_complete_member_detail(name_process, member_ann_builtin_process, ann_custom_PhysicalData);
            CompleteStructMember member_process = TypeObjectUtils::build_complete_struct_member(common_process, detail_process);
            TypeObjectUtils::add_complete_struct_member(member_seq_PhysicalData, member_process);
        }
        CompleteStructType struct_type_PhysicalData = TypeObjectUtils::build_complete_struct_type(struct_flags_PhysicalData, header_PhysicalData, member_seq_PhysicalData);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_PhysicalData, type_name_PhysicalData.to_string(), type_ids_PhysicalData))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::PhysicalData already registered in TypeObjectRegistry for a different type.");
        }
    }
}
namespace EventKind {
} // namespace EventKind
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Data_type_identifier(
        TypeIdentifierPair& type_ids_Data)
{
    ReturnCode_t return_code_Data {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Data =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::Data", type_ids_Data);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Data)
    {
        UnionTypeFlag union_flags_Data = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Data = "eprosima::fastdds::statistics::Data";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Data;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Data;
        CompleteTypeDetail detail_Data = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Data, ann_custom_Data, type_name_Data.to_string());
        CompleteUnionHeader header_Data = TypeObjectUtils::build_complete_union_header(detail_Data);
        UnionDiscriminatorFlag member_flags_Data = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_Data =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_uint32_t", type_ids_Data);

        if (return_code_Data != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_Data;
        if (EK_COMPLETE == type_ids_Data.type_identifier1()._d() || TK_NONE == type_ids_Data.type_identifier2()._d())
        {
            common_Data = TypeObjectUtils::build_common_discriminator_member(member_flags_Data, type_ids_Data.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_Data.type_identifier2()._d())
        {
            common_Data = TypeObjectUtils::build_common_discriminator_member(member_flags_Data, type_ids_Data.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::Data discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_Data.reset();
        ann_custom_Data.reset();
        CompleteDiscriminatorMember discriminator_Data = TypeObjectUtils::build_complete_discriminator_member(common_Data,
                type_ann_builtin_Data, ann_custom_Data);
        CompleteUnionMemberSeq member_seq_Data;
        {
            return_code_Data =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::WriterReaderData", type_ids_Data);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Data)
            {
                eprosima::fastdds::statistics::register_WriterReaderData_type_identifier(type_ids_Data);
            }
            UnionMemberFlag member_flags_writer_reader_data = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_writer_reader_data;
            TypeObjectUtils::add_union_case_label(label_seq_writer_reader_data, static_cast<int32_t>(EventKind::HISTORY2HISTORY_LATENCY));
            MemberId member_id_writer_reader_data = 0x00000001;
            bool common_writer_reader_data_ec {false};
            CommonUnionMember common_writer_reader_data {TypeObjectUtils::build_common_union_member(member_id_writer_reader_data,
                    member_flags_writer_reader_data, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Data,
                        common_writer_reader_data_ec), label_seq_writer_reader_data)};
            if (!common_writer_reader_data_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union writer_reader_data member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_writer_reader_data = "writer_reader_data";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_writer_reader_data;
            ann_custom_Data.reset();
            CompleteMemberDetail detail_writer_reader_data = TypeObjectUtils::build_complete_member_detail(name_writer_reader_data, member_ann_builtin_writer_reader_data, ann_custom_Data);
            CompleteUnionMember member_writer_reader_data = TypeObjectUtils::build_complete_union_member(common_writer_reader_data, detail_writer_reader_data);
            TypeObjectUtils::add_complete_union_member(member_seq_Data, member_writer_reader_data);
        }
        {
            return_code_Data =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::Locator2LocatorData", type_ids_Data);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Data)
            {
                eprosima::fastdds::statistics::register_Locator2LocatorData_type_identifier(type_ids_Data);
            }
            UnionMemberFlag member_flags_locator2locator_data = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_locator2locator_data;
            TypeObjectUtils::add_union_case_label(label_seq_locator2locator_data, static_cast<int32_t>(EventKind::NETWORK_LATENCY));
            MemberId member_id_locator2locator_data = 0x00000002;
            bool common_locator2locator_data_ec {false};
            CommonUnionMember common_locator2locator_data {TypeObjectUtils::build_common_union_member(member_id_locator2locator_data,
                    member_flags_locator2locator_data, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Data,
                        common_locator2locator_data_ec), label_seq_locator2locator_data)};
            if (!common_locator2locator_data_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union locator2locator_data member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_locator2locator_data = "locator2locator_data";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_locator2locator_data;
            ann_custom_Data.reset();
            CompleteMemberDetail detail_locator2locator_data = TypeObjectUtils::build_complete_member_detail(name_locator2locator_data, member_ann_builtin_locator2locator_data, ann_custom_Data);
            CompleteUnionMember member_locator2locator_data = TypeObjectUtils::build_complete_union_member(common_locator2locator_data, detail_locator2locator_data);
            TypeObjectUtils::add_complete_union_member(member_seq_Data, member_locator2locator_data);
        }
        {
            return_code_Data =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::EntityData", type_ids_Data);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Data)
            {
                eprosima::fastdds::statistics::register_EntityData_type_identifier(type_ids_Data);
            }
            UnionMemberFlag member_flags_entity_data = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_entity_data;
            TypeObjectUtils::add_union_case_label(label_seq_entity_data, static_cast<int32_t>(EventKind::PUBLICATION_THROUGHPUT));
            TypeObjectUtils::add_union_case_label(label_seq_entity_data, static_cast<int32_t>(EventKind::SUBSCRIPTION_THROUGHPUT));
            MemberId member_id_entity_data = 0x00000003;
            bool common_entity_data_ec {false};
            CommonUnionMember common_entity_data {TypeObjectUtils::build_common_union_member(member_id_entity_data,
                    member_flags_entity_data, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Data,
                        common_entity_data_ec), label_seq_entity_data)};
            if (!common_entity_data_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union entity_data member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_entity_data = "entity_data";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_entity_data;
            ann_custom_Data.reset();
            CompleteMemberDetail detail_entity_data = TypeObjectUtils::build_complete_member_detail(name_entity_data, member_ann_builtin_entity_data, ann_custom_Data);
            CompleteUnionMember member_entity_data = TypeObjectUtils::build_complete_union_member(common_entity_data, detail_entity_data);
            TypeObjectUtils::add_complete_union_member(member_seq_Data, member_entity_data);
        }
        {
            return_code_Data =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::Entity2LocatorTraffic", type_ids_Data);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Data)
            {
                eprosima::fastdds::statistics::register_Entity2LocatorTraffic_type_identifier(type_ids_Data);
            }
            UnionMemberFlag member_flags_entity2locator_traffic = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_entity2locator_traffic;
            TypeObjectUtils::add_union_case_label(label_seq_entity2locator_traffic, static_cast<int32_t>(EventKind::RTPS_SENT));
            TypeObjectUtils::add_union_case_label(label_seq_entity2locator_traffic, static_cast<int32_t>(EventKind::RTPS_LOST));
            MemberId member_id_entity2locator_traffic = 0x00000004;
            bool common_entity2locator_traffic_ec {false};
            CommonUnionMember common_entity2locator_traffic {TypeObjectUtils::build_common_union_member(member_id_entity2locator_traffic,
                    member_flags_entity2locator_traffic, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Data,
                        common_entity2locator_traffic_ec), label_seq_entity2locator_traffic)};
            if (!common_entity2locator_traffic_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union entity2locator_traffic member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_entity2locator_traffic = "entity2locator_traffic";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_entity2locator_traffic;
            ann_custom_Data.reset();
            CompleteMemberDetail detail_entity2locator_traffic = TypeObjectUtils::build_complete_member_detail(name_entity2locator_traffic, member_ann_builtin_entity2locator_traffic, ann_custom_Data);
            CompleteUnionMember member_entity2locator_traffic = TypeObjectUtils::build_complete_union_member(common_entity2locator_traffic, detail_entity2locator_traffic);
            TypeObjectUtils::add_complete_union_member(member_seq_Data, member_entity2locator_traffic);
        }
        {
            return_code_Data =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::EntityCount", type_ids_Data);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Data)
            {
                eprosima::fastdds::statistics::register_EntityCount_type_identifier(type_ids_Data);
            }
            UnionMemberFlag member_flags_entity_count = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_entity_count;
            TypeObjectUtils::add_union_case_label(label_seq_entity_count, static_cast<int32_t>(EventKind::RESENT_DATAS));
            TypeObjectUtils::add_union_case_label(label_seq_entity_count, static_cast<int32_t>(EventKind::HEARTBEAT_COUNT));
            TypeObjectUtils::add_union_case_label(label_seq_entity_count, static_cast<int32_t>(EventKind::ACKNACK_COUNT));
            TypeObjectUtils::add_union_case_label(label_seq_entity_count, static_cast<int32_t>(EventKind::NACKFRAG_COUNT));
            TypeObjectUtils::add_union_case_label(label_seq_entity_count, static_cast<int32_t>(EventKind::GAP_COUNT));
            TypeObjectUtils::add_union_case_label(label_seq_entity_count, static_cast<int32_t>(EventKind::DATA_COUNT));
            TypeObjectUtils::add_union_case_label(label_seq_entity_count, static_cast<int32_t>(EventKind::PDP_PACKETS));
            TypeObjectUtils::add_union_case_label(label_seq_entity_count, static_cast<int32_t>(EventKind::EDP_PACKETS));
            MemberId member_id_entity_count = 0x00000005;
            bool common_entity_count_ec {false};
            CommonUnionMember common_entity_count {TypeObjectUtils::build_common_union_member(member_id_entity_count,
                    member_flags_entity_count, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Data,
                        common_entity_count_ec), label_seq_entity_count)};
            if (!common_entity_count_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union entity_count member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_entity_count = "entity_count";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_entity_count;
            ann_custom_Data.reset();
            CompleteMemberDetail detail_entity_count = TypeObjectUtils::build_complete_member_detail(name_entity_count, member_ann_builtin_entity_count, ann_custom_Data);
            CompleteUnionMember member_entity_count = TypeObjectUtils::build_complete_union_member(common_entity_count, detail_entity_count);
            TypeObjectUtils::add_complete_union_member(member_seq_Data, member_entity_count);
        }
        {
            return_code_Data =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::DiscoveryTime", type_ids_Data);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Data)
            {
                eprosima::fastdds::statistics::register_DiscoveryTime_type_identifier(type_ids_Data);
            }
            UnionMemberFlag member_flags_discovery_time = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_discovery_time;
            TypeObjectUtils::add_union_case_label(label_seq_discovery_time, static_cast<int32_t>(EventKind::DISCOVERED_ENTITY));
            MemberId member_id_discovery_time = 0x00000006;
            bool common_discovery_time_ec {false};
            CommonUnionMember common_discovery_time {TypeObjectUtils::build_common_union_member(member_id_discovery_time,
                    member_flags_discovery_time, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Data,
                        common_discovery_time_ec), label_seq_discovery_time)};
            if (!common_discovery_time_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union discovery_time member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_discovery_time = "discovery_time";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_discovery_time;
            ann_custom_Data.reset();
            CompleteMemberDetail detail_discovery_time = TypeObjectUtils::build_complete_member_detail(name_discovery_time, member_ann_builtin_discovery_time, ann_custom_Data);
            CompleteUnionMember member_discovery_time = TypeObjectUtils::build_complete_union_member(common_discovery_time, detail_discovery_time);
            TypeObjectUtils::add_complete_union_member(member_seq_Data, member_discovery_time);
        }
        {
            return_code_Data =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::SampleIdentityCount", type_ids_Data);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Data)
            {
                eprosima::fastdds::statistics::register_SampleIdentityCount_type_identifier(type_ids_Data);
            }
            UnionMemberFlag member_flags_sample_identity_count = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_sample_identity_count;
            TypeObjectUtils::add_union_case_label(label_seq_sample_identity_count, static_cast<int32_t>(EventKind::SAMPLE_DATAS));
            MemberId member_id_sample_identity_count = 0x00000007;
            bool common_sample_identity_count_ec {false};
            CommonUnionMember common_sample_identity_count {TypeObjectUtils::build_common_union_member(member_id_sample_identity_count,
                    member_flags_sample_identity_count, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Data,
                        common_sample_identity_count_ec), label_seq_sample_identity_count)};
            if (!common_sample_identity_count_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union sample_identity_count member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_sample_identity_count = "sample_identity_count";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_sample_identity_count;
            ann_custom_Data.reset();
            CompleteMemberDetail detail_sample_identity_count = TypeObjectUtils::build_complete_member_detail(name_sample_identity_count, member_ann_builtin_sample_identity_count, ann_custom_Data);
            CompleteUnionMember member_sample_identity_count = TypeObjectUtils::build_complete_union_member(common_sample_identity_count, detail_sample_identity_count);
            TypeObjectUtils::add_complete_union_member(member_seq_Data, member_sample_identity_count);
        }
        {
            return_code_Data =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::PhysicalData", type_ids_Data);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Data)
            {
                eprosima::fastdds::statistics::register_PhysicalData_type_identifier(type_ids_Data);
            }
            UnionMemberFlag member_flags_physical_data = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_physical_data;
            TypeObjectUtils::add_union_case_label(label_seq_physical_data, static_cast<int32_t>(EventKind::PHYSICAL_DATA));
            MemberId member_id_physical_data = 0x00000008;
            bool common_physical_data_ec {false};
            CommonUnionMember common_physical_data {TypeObjectUtils::build_common_union_member(member_id_physical_data,
                    member_flags_physical_data, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Data,
                        common_physical_data_ec), label_seq_physical_data)};
            if (!common_physical_data_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union physical_data member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_physical_data = "physical_data";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_physical_data;
            ann_custom_Data.reset();
            CompleteMemberDetail detail_physical_data = TypeObjectUtils::build_complete_member_detail(name_physical_data, member_ann_builtin_physical_data, ann_custom_Data);
            CompleteUnionMember member_physical_data = TypeObjectUtils::build_complete_union_member(common_physical_data, detail_physical_data);
            TypeObjectUtils::add_complete_union_member(member_seq_Data, member_physical_data);
        }
        CompleteUnionType union_type_Data = TypeObjectUtils::build_complete_union_type(union_flags_Data, header_Data, discriminator_Data,
                member_seq_Data);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_Data, type_name_Data.to_string(), type_ids_Data))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::Data already registered in TypeObjectRegistry for a different type.");
        }
    }
}

} // namespace statistics

} // namespace fastdds

} // namespace eprosima

