// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file ComprehensiveType.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__COMPREHENSIVETYPE_HPP
#define FAST_DDS_GENERATED__COMPREHENSIVETYPE_HPP

#include <array>
#include <cstdint>
#include <functional>
#include <map>
#include <string>
#include <utility>
#include <vector>

#include <fastcdr/cdr/fixed_size_string.hpp>
#include <fastcdr/exceptions/BadParamException.h>


#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(COMPREHENSIVETYPE_SOURCE)
#define COMPREHENSIVETYPE_DllAPI __declspec( dllexport )
#else
#define COMPREHENSIVETYPE_DllAPI __declspec( dllimport )
#endif // COMPREHENSIVETYPE_SOURCE
#else
#define COMPREHENSIVETYPE_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define COMPREHENSIVETYPE_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure PrimitivesStruct defined by the user in the IDL file.
 * @ingroup ComprehensiveType
 */
class PrimitivesStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport PrimitivesStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~PrimitivesStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object PrimitivesStruct that will be copied.
     */
    eProsima_user_DllExport PrimitivesStruct(
            const PrimitivesStruct& x)
    {
                    m_my_bool = x.m_my_bool;

                    m_my_octet = x.m_my_octet;

                    m_my_char = x.m_my_char;

                    m_my_wchar = x.m_my_wchar;

                    m_my_long = x.m_my_long;

                    m_my_ulong = x.m_my_ulong;

                    m_my_int8 = x.m_my_int8;

                    m_my_uint8 = x.m_my_uint8;

                    m_my_short = x.m_my_short;

                    m_my_ushort = x.m_my_ushort;

                    m_my_longlong = x.m_my_longlong;

                    m_my_ulonglong = x.m_my_ulonglong;

                    m_my_float = x.m_my_float;

                    m_my_double = x.m_my_double;

                    m_my_longdouble = x.m_my_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object PrimitivesStruct that will be copied.
     */
    eProsima_user_DllExport PrimitivesStruct(
            PrimitivesStruct&& x) noexcept
    {
        m_my_bool = x.m_my_bool;
        m_my_octet = x.m_my_octet;
        m_my_char = x.m_my_char;
        m_my_wchar = x.m_my_wchar;
        m_my_long = x.m_my_long;
        m_my_ulong = x.m_my_ulong;
        m_my_int8 = x.m_my_int8;
        m_my_uint8 = x.m_my_uint8;
        m_my_short = x.m_my_short;
        m_my_ushort = x.m_my_ushort;
        m_my_longlong = x.m_my_longlong;
        m_my_ulonglong = x.m_my_ulonglong;
        m_my_float = x.m_my_float;
        m_my_double = x.m_my_double;
        m_my_longdouble = x.m_my_longdouble;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object PrimitivesStruct that will be copied.
     */
    eProsima_user_DllExport PrimitivesStruct& operator =(
            const PrimitivesStruct& x)
    {

                    m_my_bool = x.m_my_bool;

                    m_my_octet = x.m_my_octet;

                    m_my_char = x.m_my_char;

                    m_my_wchar = x.m_my_wchar;

                    m_my_long = x.m_my_long;

                    m_my_ulong = x.m_my_ulong;

                    m_my_int8 = x.m_my_int8;

                    m_my_uint8 = x.m_my_uint8;

                    m_my_short = x.m_my_short;

                    m_my_ushort = x.m_my_ushort;

                    m_my_longlong = x.m_my_longlong;

                    m_my_ulonglong = x.m_my_ulonglong;

                    m_my_float = x.m_my_float;

                    m_my_double = x.m_my_double;

                    m_my_longdouble = x.m_my_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object PrimitivesStruct that will be copied.
     */
    eProsima_user_DllExport PrimitivesStruct& operator =(
            PrimitivesStruct&& x) noexcept
    {

        m_my_bool = x.m_my_bool;
        m_my_octet = x.m_my_octet;
        m_my_char = x.m_my_char;
        m_my_wchar = x.m_my_wchar;
        m_my_long = x.m_my_long;
        m_my_ulong = x.m_my_ulong;
        m_my_int8 = x.m_my_int8;
        m_my_uint8 = x.m_my_uint8;
        m_my_short = x.m_my_short;
        m_my_ushort = x.m_my_ushort;
        m_my_longlong = x.m_my_longlong;
        m_my_ulonglong = x.m_my_ulonglong;
        m_my_float = x.m_my_float;
        m_my_double = x.m_my_double;
        m_my_longdouble = x.m_my_longdouble;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x PrimitivesStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const PrimitivesStruct& x) const
    {
        return (m_my_bool == x.m_my_bool &&
           m_my_octet == x.m_my_octet &&
           m_my_char == x.m_my_char &&
           m_my_wchar == x.m_my_wchar &&
           m_my_long == x.m_my_long &&
           m_my_ulong == x.m_my_ulong &&
           m_my_int8 == x.m_my_int8 &&
           m_my_uint8 == x.m_my_uint8 &&
           m_my_short == x.m_my_short &&
           m_my_ushort == x.m_my_ushort &&
           m_my_longlong == x.m_my_longlong &&
           m_my_ulonglong == x.m_my_ulonglong &&
           m_my_float == x.m_my_float &&
           m_my_double == x.m_my_double &&
           m_my_longdouble == x.m_my_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x PrimitivesStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const PrimitivesStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member my_bool
     * @param _my_bool New value for member my_bool
     */
    eProsima_user_DllExport void my_bool(
            bool _my_bool)
    {
        m_my_bool = _my_bool;
    }

    /*!
     * @brief This function returns the value of member my_bool
     * @return Value of member my_bool
     */
    eProsima_user_DllExport bool my_bool() const
    {
        return m_my_bool;
    }

    /*!
     * @brief This function returns a reference to member my_bool
     * @return Reference to member my_bool
     */
    eProsima_user_DllExport bool& my_bool()
    {
        return m_my_bool;
    }


    /*!
     * @brief This function sets a value in member my_octet
     * @param _my_octet New value for member my_octet
     */
    eProsima_user_DllExport void my_octet(
            uint8_t _my_octet)
    {
        m_my_octet = _my_octet;
    }

    /*!
     * @brief This function returns the value of member my_octet
     * @return Value of member my_octet
     */
    eProsima_user_DllExport uint8_t my_octet() const
    {
        return m_my_octet;
    }

    /*!
     * @brief This function returns a reference to member my_octet
     * @return Reference to member my_octet
     */
    eProsima_user_DllExport uint8_t& my_octet()
    {
        return m_my_octet;
    }


    /*!
     * @brief This function sets a value in member my_char
     * @param _my_char New value for member my_char
     */
    eProsima_user_DllExport void my_char(
            char _my_char)
    {
        m_my_char = _my_char;
    }

    /*!
     * @brief This function returns the value of member my_char
     * @return Value of member my_char
     */
    eProsima_user_DllExport char my_char() const
    {
        return m_my_char;
    }

    /*!
     * @brief This function returns a reference to member my_char
     * @return Reference to member my_char
     */
    eProsima_user_DllExport char& my_char()
    {
        return m_my_char;
    }


    /*!
     * @brief This function sets a value in member my_wchar
     * @param _my_wchar New value for member my_wchar
     */
    eProsima_user_DllExport void my_wchar(
            wchar_t _my_wchar)
    {
        m_my_wchar = _my_wchar;
    }

    /*!
     * @brief This function returns the value of member my_wchar
     * @return Value of member my_wchar
     */
    eProsima_user_DllExport wchar_t my_wchar() const
    {
        return m_my_wchar;
    }

    /*!
     * @brief This function returns a reference to member my_wchar
     * @return Reference to member my_wchar
     */
    eProsima_user_DllExport wchar_t& my_wchar()
    {
        return m_my_wchar;
    }


    /*!
     * @brief This function sets a value in member my_long
     * @param _my_long New value for member my_long
     */
    eProsima_user_DllExport void my_long(
            int32_t _my_long)
    {
        m_my_long = _my_long;
    }

    /*!
     * @brief This function returns the value of member my_long
     * @return Value of member my_long
     */
    eProsima_user_DllExport int32_t my_long() const
    {
        return m_my_long;
    }

    /*!
     * @brief This function returns a reference to member my_long
     * @return Reference to member my_long
     */
    eProsima_user_DllExport int32_t& my_long()
    {
        return m_my_long;
    }


    /*!
     * @brief This function sets a value in member my_ulong
     * @param _my_ulong New value for member my_ulong
     */
    eProsima_user_DllExport void my_ulong(
            uint32_t _my_ulong)
    {
        m_my_ulong = _my_ulong;
    }

    /*!
     * @brief This function returns the value of member my_ulong
     * @return Value of member my_ulong
     */
    eProsima_user_DllExport uint32_t my_ulong() const
    {
        return m_my_ulong;
    }

    /*!
     * @brief This function returns a reference to member my_ulong
     * @return Reference to member my_ulong
     */
    eProsima_user_DllExport uint32_t& my_ulong()
    {
        return m_my_ulong;
    }


    /*!
     * @brief This function sets a value in member my_int8
     * @param _my_int8 New value for member my_int8
     */
    eProsima_user_DllExport void my_int8(
            int8_t _my_int8)
    {
        m_my_int8 = _my_int8;
    }

    /*!
     * @brief This function returns the value of member my_int8
     * @return Value of member my_int8
     */
    eProsima_user_DllExport int8_t my_int8() const
    {
        return m_my_int8;
    }

    /*!
     * @brief This function returns a reference to member my_int8
     * @return Reference to member my_int8
     */
    eProsima_user_DllExport int8_t& my_int8()
    {
        return m_my_int8;
    }


    /*!
     * @brief This function sets a value in member my_uint8
     * @param _my_uint8 New value for member my_uint8
     */
    eProsima_user_DllExport void my_uint8(
            uint8_t _my_uint8)
    {
        m_my_uint8 = _my_uint8;
    }

    /*!
     * @brief This function returns the value of member my_uint8
     * @return Value of member my_uint8
     */
    eProsima_user_DllExport uint8_t my_uint8() const
    {
        return m_my_uint8;
    }

    /*!
     * @brief This function returns a reference to member my_uint8
     * @return Reference to member my_uint8
     */
    eProsima_user_DllExport uint8_t& my_uint8()
    {
        return m_my_uint8;
    }


    /*!
     * @brief This function sets a value in member my_short
     * @param _my_short New value for member my_short
     */
    eProsima_user_DllExport void my_short(
            int16_t _my_short)
    {
        m_my_short = _my_short;
    }

    /*!
     * @brief This function returns the value of member my_short
     * @return Value of member my_short
     */
    eProsima_user_DllExport int16_t my_short() const
    {
        return m_my_short;
    }

    /*!
     * @brief This function returns a reference to member my_short
     * @return Reference to member my_short
     */
    eProsima_user_DllExport int16_t& my_short()
    {
        return m_my_short;
    }


    /*!
     * @brief This function sets a value in member my_ushort
     * @param _my_ushort New value for member my_ushort
     */
    eProsima_user_DllExport void my_ushort(
            uint16_t _my_ushort)
    {
        m_my_ushort = _my_ushort;
    }

    /*!
     * @brief This function returns the value of member my_ushort
     * @return Value of member my_ushort
     */
    eProsima_user_DllExport uint16_t my_ushort() const
    {
        return m_my_ushort;
    }

    /*!
     * @brief This function returns a reference to member my_ushort
     * @return Reference to member my_ushort
     */
    eProsima_user_DllExport uint16_t& my_ushort()
    {
        return m_my_ushort;
    }


    /*!
     * @brief This function sets a value in member my_longlong
     * @param _my_longlong New value for member my_longlong
     */
    eProsima_user_DllExport void my_longlong(
            int64_t _my_longlong)
    {
        m_my_longlong = _my_longlong;
    }

    /*!
     * @brief This function returns the value of member my_longlong
     * @return Value of member my_longlong
     */
    eProsima_user_DllExport int64_t my_longlong() const
    {
        return m_my_longlong;
    }

    /*!
     * @brief This function returns a reference to member my_longlong
     * @return Reference to member my_longlong
     */
    eProsima_user_DllExport int64_t& my_longlong()
    {
        return m_my_longlong;
    }


    /*!
     * @brief This function sets a value in member my_ulonglong
     * @param _my_ulonglong New value for member my_ulonglong
     */
    eProsima_user_DllExport void my_ulonglong(
            uint64_t _my_ulonglong)
    {
        m_my_ulonglong = _my_ulonglong;
    }

    /*!
     * @brief This function returns the value of member my_ulonglong
     * @return Value of member my_ulonglong
     */
    eProsima_user_DllExport uint64_t my_ulonglong() const
    {
        return m_my_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member my_ulonglong
     * @return Reference to member my_ulonglong
     */
    eProsima_user_DllExport uint64_t& my_ulonglong()
    {
        return m_my_ulonglong;
    }


    /*!
     * @brief This function sets a value in member my_float
     * @param _my_float New value for member my_float
     */
    eProsima_user_DllExport void my_float(
            float _my_float)
    {
        m_my_float = _my_float;
    }

    /*!
     * @brief This function returns the value of member my_float
     * @return Value of member my_float
     */
    eProsima_user_DllExport float my_float() const
    {
        return m_my_float;
    }

    /*!
     * @brief This function returns a reference to member my_float
     * @return Reference to member my_float
     */
    eProsima_user_DllExport float& my_float()
    {
        return m_my_float;
    }


    /*!
     * @brief This function sets a value in member my_double
     * @param _my_double New value for member my_double
     */
    eProsima_user_DllExport void my_double(
            double _my_double)
    {
        m_my_double = _my_double;
    }

    /*!
     * @brief This function returns the value of member my_double
     * @return Value of member my_double
     */
    eProsima_user_DllExport double my_double() const
    {
        return m_my_double;
    }

    /*!
     * @brief This function returns a reference to member my_double
     * @return Reference to member my_double
     */
    eProsima_user_DllExport double& my_double()
    {
        return m_my_double;
    }


    /*!
     * @brief This function sets a value in member my_longdouble
     * @param _my_longdouble New value for member my_longdouble
     */
    eProsima_user_DllExport void my_longdouble(
            long double _my_longdouble)
    {
        m_my_longdouble = _my_longdouble;
    }

    /*!
     * @brief This function returns the value of member my_longdouble
     * @return Value of member my_longdouble
     */
    eProsima_user_DllExport long double my_longdouble() const
    {
        return m_my_longdouble;
    }

    /*!
     * @brief This function returns a reference to member my_longdouble
     * @return Reference to member my_longdouble
     */
    eProsima_user_DllExport long double& my_longdouble()
    {
        return m_my_longdouble;
    }



private:

    bool m_my_bool{false};
    uint8_t m_my_octet{0};
    char m_my_char{0};
    wchar_t m_my_wchar{0};
    int32_t m_my_long{0};
    uint32_t m_my_ulong{0};
    int8_t m_my_int8{0};
    uint8_t m_my_uint8{0};
    int16_t m_my_short{0};
    uint16_t m_my_ushort{0};
    int64_t m_my_longlong{0};
    uint64_t m_my_ulonglong{0};
    float m_my_float{0.0};
    double m_my_double{0.0};
    long double m_my_longdouble{0.0};

};
/*!
 * @brief This class represents the enumeration MyEnum defined by the user in the IDL file.
 * @ingroup ComprehensiveType
 */
enum class MyEnum : int32_t
{
    A,
    B,
    C
};
/*!
 * @brief This enumeration represents the MyBitMask bitflags defined by the user in the IDL file.
 * @ingroup ComprehensiveType
 */
enum MyBitMaskBits : uint32_t
{
    flag0 = 0x01ull << 0,
    flag1 = 0x01ull << 1,
    flag2 = 0x01ull << 2,
    flag26 = 0x01ull << 26
};
typedef uint32_t MyBitMask;
typedef PrimitivesStruct MyAliasedStruct;

typedef MyEnum MyAliasedEnum;

typedef eprosima::fastcdr::fixed_string<100> MyAliasedBoundedString;

typedef MyAliasedEnum MyRecursiveAlias;

/*!
 * @brief This class represents the union InnerUnion defined by the user in the IDL file.
 * @ingroup ComprehensiveType
 */
class InnerUnion
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport InnerUnion()
    {
        second_();
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~InnerUnion()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object InnerUnion that will be copied.
     */
    eProsima_user_DllExport InnerUnion(
            const InnerUnion& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000010:
                            first_() = x.m_first;
                            break;

                        case 0x00000011:
                            second_() = x.m_second;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object InnerUnion that will be copied.
     */
    eProsima_user_DllExport InnerUnion(
            InnerUnion&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000010:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000011:
                            second_() = std::move(x.m_second);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object InnerUnion that will be copied.
     */
    eProsima_user_DllExport InnerUnion& operator =(
            const InnerUnion& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000010:
                            first_() = x.m_first;
                            break;

                        case 0x00000011:
                            second_() = x.m_second;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object InnerUnion that will be copied.
     */
    eProsima_user_DllExport InnerUnion& operator =(
            InnerUnion&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000010:
                            first_() = std::move(x.m_first);
                            break;

                        case 0x00000011:
                            second_() = std::move(x.m_second);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x InnerUnion object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const InnerUnion& x) const
    {
        bool ret_value {false};

        if (m__d == x.m__d &&
                selected_member_ == x.selected_member_)
        {
            switch (selected_member_)
            {
                                case 0x00000010:
                                    ret_value = (m_first == x.m_first);
                                    break;

                                case 0x00000011:
                                    ret_value = (m_second == x.m_second);
                                    break;

            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x InnerUnion object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const InnerUnion& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int16_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 0:
                            if (0x00000010 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 1:
                        default:
                            if (0x00000011 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int16_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member first
     * @param _first New value to be copied in member first
     */
    eProsima_user_DllExport void first(
            const PrimitivesStruct& _first)
    {
        first_() = _first;
        m__d = 0;
    }

    /*!
     * @brief This function moves the value in member first
     * @param _first New value to be moved in member first
     */
    eProsima_user_DllExport void first(
            PrimitivesStruct&& _first)
    {
        first_() = _first;
        m__d = 0;
    }

    /*!
     * @brief This function returns a constant reference to member first
     * @return Constant reference to member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const PrimitivesStruct& first() const
    {
        if (0x00000010 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }

    /*!
     * @brief This function returns a reference to member first
     * @return Reference to member first
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport PrimitivesStruct& first()
    {
        if (0x00000010 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_first;
    }


    /*!
     * @brief This function sets a value in member second
     * @param _second New value for member second
     */
    eProsima_user_DllExport void second(
            int64_t _second)
    {
        second_() = _second;
        m__d = 32767;
    }

    /*!
     * @brief This function returns the value of member second
     * @return Value of member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t second() const
    {
        if (0x00000011 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }

    /*!
     * @brief This function returns a reference to member second
     * @return Reference to member second
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t& second()
    {
        if (0x00000011 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_second;
    }



private:

            PrimitivesStruct& first_()
            {
                if (0x00000010 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000010;
                    member_destructor_ = [&]() {m_first.~PrimitivesStruct();};
                    new(&m_first) PrimitivesStruct();
    ;
                }

                return m_first;
            }

            int64_t& second_()
            {
                if (0x00000011 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000011;
                    member_destructor_ = nullptr;
                    m_second = {0};
    ;
                }

                return m_second;
            }


    int16_t m__d {32767};

    union
    {
        PrimitivesStruct m_first;
        int64_t m_second;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union ComplexUnion defined by the user in the IDL file.
 * @ingroup ComprehensiveType
 */
class ComplexUnion
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ComplexUnion()
    {
        fourth_();
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ComplexUnion()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ComplexUnion that will be copied.
     */
    eProsima_user_DllExport ComplexUnion(
            const ComplexUnion& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            third_() = x.m_third;
                            break;

                        case 0x00000002:
                            fourth_() = x.m_fourth;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ComplexUnion that will be copied.
     */
    eProsima_user_DllExport ComplexUnion(
            ComplexUnion&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            third_() = std::move(x.m_third);
                            break;

                        case 0x00000002:
                            fourth_() = std::move(x.m_fourth);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ComplexUnion that will be copied.
     */
    eProsima_user_DllExport ComplexUnion& operator =(
            const ComplexUnion& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            third_() = x.m_third;
                            break;

                        case 0x00000002:
                            fourth_() = x.m_fourth;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ComplexUnion that will be copied.
     */
    eProsima_user_DllExport ComplexUnion& operator =(
            ComplexUnion&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            third_() = std::move(x.m_third);
                            break;

                        case 0x00000002:
                            fourth_() = std::move(x.m_fourth);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ComplexUnion object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ComplexUnion& x) const
    {
        bool ret_value {false};

        if (m__d == x.m__d &&
                selected_member_ == x.selected_member_)
        {
            switch (selected_member_)
            {
                                case 0x00000001:
                                    ret_value = (m_third == x.m_third);
                                    break;

                                case 0x00000002:
                                    ret_value = (m_fourth == x.m_fourth);
                                    break;

            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x ComplexUnion object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ComplexUnion& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            int16_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 0:
                        case 1:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        default:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport int16_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member third
     * @param _third New value for member third
     */
    eProsima_user_DllExport void third(
            int32_t _third)
    {
        third_() = _third;
        m__d = 0;
    }

    /*!
     * @brief This function returns the value of member third
     * @return Value of member third
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t third() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_third;
    }

    /*!
     * @brief This function returns a reference to member third
     * @return Reference to member third
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& third()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_third;
    }


    /*!
     * @brief This function copies the value in member fourth
     * @param _fourth New value to be copied in member fourth
     */
    eProsima_user_DllExport void fourth(
            const InnerUnion& _fourth)
    {
        fourth_() = _fourth;
        m__d = 32767;
    }

    /*!
     * @brief This function moves the value in member fourth
     * @param _fourth New value to be moved in member fourth
     */
    eProsima_user_DllExport void fourth(
            InnerUnion&& _fourth)
    {
        fourth_() = _fourth;
        m__d = 32767;
    }

    /*!
     * @brief This function returns a constant reference to member fourth
     * @return Constant reference to member fourth
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const InnerUnion& fourth() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_fourth;
    }

    /*!
     * @brief This function returns a reference to member fourth
     * @return Reference to member fourth
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport InnerUnion& fourth()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_fourth;
    }



private:

            int32_t& third_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_third = {0};
    ;
                }

                return m_third;
            }

            InnerUnion& fourth_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = [&]() {m_fourth.~InnerUnion();};
                    new(&m_fourth) InnerUnion();
    ;
                }

                return m_fourth;
            }


    int16_t m__d {32767};

    union
    {
        int32_t m_third;
        InnerUnion m_fourth;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This structure represents the bitset MyBitSet defined by the user in the IDL file.
 * @ingroup ComprehensiveType
 */
struct MyBitSet
{
        uint8_t a : 3;

        bool b : 1;

        uint8_t  : 4;

        uint16_t c : 10;

        int16_t d : 12;


    /*!
     * @brief Comparison operator.
     * @param x MyBitSet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MyBitSet& x) const
    {
        return (a == x.a &&
           b == x.b &&
           c == x.c &&
           d == x.d);
    }

    /*!
     * @brief Comparison operator.
     * @param x MyBitSet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MyBitSet& x) const
    {
        return !(*this == x);
    }
};
/*!
 * @brief This class represents the structure AllStruct defined by the user in the IDL file.
 * @ingroup ComprehensiveType
 */
class AllStruct : public PrimitivesStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AllStruct()
        : PrimitivesStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AllStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AllStruct that will be copied.
     */
    eProsima_user_DllExport AllStruct(
            const AllStruct& x)
        : PrimitivesStruct(x)
    {
                    m_my_string = x.m_my_string;

                    m_my_wstring = x.m_my_wstring;

                    m_my_bounded_string = x.m_my_bounded_string;

                    m_my_bounded_wstring = x.m_my_bounded_wstring;

                    m_my_enum = x.m_my_enum;

                    m_my_bitmask = x.m_my_bitmask;

                    m_my_aliased_struct = x.m_my_aliased_struct;

                    m_my_aliased_enum = x.m_my_aliased_enum;

                    m_my_aliased_bounded_string = x.m_my_aliased_bounded_string;

                    m_my_recursive_alias = x.m_my_recursive_alias;

                    m_bitmask_sequence = x.m_bitmask_sequence;

                    m_enum_sequence = x.m_enum_sequence;

                    m_short_sequence = x.m_short_sequence;

                    m_long_array = x.m_long_array;

                    m_string_unbounded_map = x.m_string_unbounded_map;

                    m_string_alias_unbounded_map = x.m_string_alias_unbounded_map;

                    m_short_long_map = x.m_short_long_map;

                    m_inner_union = x.m_inner_union;

                    m_complex_union = x.m_complex_union;

                    m_my_bitset = x.m_my_bitset;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AllStruct that will be copied.
     */
    eProsima_user_DllExport AllStruct(
            AllStruct&& x) noexcept
        : PrimitivesStruct(std::move(x))

    {
        m_my_string = std::move(x.m_my_string);
        m_my_wstring = std::move(x.m_my_wstring);
        m_my_bounded_string = std::move(x.m_my_bounded_string);
        m_my_bounded_wstring = std::move(x.m_my_bounded_wstring);
        m_my_enum = x.m_my_enum;
        m_my_bitmask = std::move(x.m_my_bitmask);
        m_my_aliased_struct = std::move(x.m_my_aliased_struct);
        m_my_aliased_enum = x.m_my_aliased_enum;
        m_my_aliased_bounded_string = std::move(x.m_my_aliased_bounded_string);
        m_my_recursive_alias = x.m_my_recursive_alias;
        m_bitmask_sequence = std::move(x.m_bitmask_sequence);
        m_enum_sequence = std::move(x.m_enum_sequence);
        m_short_sequence = std::move(x.m_short_sequence);
        m_long_array = std::move(x.m_long_array);
        m_string_unbounded_map = std::move(x.m_string_unbounded_map);
        m_string_alias_unbounded_map = std::move(x.m_string_alias_unbounded_map);
        m_short_long_map = std::move(x.m_short_long_map);
        m_inner_union = std::move(x.m_inner_union);
        m_complex_union = std::move(x.m_complex_union);
        m_my_bitset = std::move(x.m_my_bitset);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AllStruct that will be copied.
     */
    eProsima_user_DllExport AllStruct& operator =(
            const AllStruct& x)
    {
        PrimitivesStruct::operator =(x);

                    m_my_string = x.m_my_string;

                    m_my_wstring = x.m_my_wstring;

                    m_my_bounded_string = x.m_my_bounded_string;

                    m_my_bounded_wstring = x.m_my_bounded_wstring;

                    m_my_enum = x.m_my_enum;

                    m_my_bitmask = x.m_my_bitmask;

                    m_my_aliased_struct = x.m_my_aliased_struct;

                    m_my_aliased_enum = x.m_my_aliased_enum;

                    m_my_aliased_bounded_string = x.m_my_aliased_bounded_string;

                    m_my_recursive_alias = x.m_my_recursive_alias;

                    m_bitmask_sequence = x.m_bitmask_sequence;

                    m_enum_sequence = x.m_enum_sequence;

                    m_short_sequence = x.m_short_sequence;

                    m_long_array = x.m_long_array;

                    m_string_unbounded_map = x.m_string_unbounded_map;

                    m_string_alias_unbounded_map = x.m_string_alias_unbounded_map;

                    m_short_long_map = x.m_short_long_map;

                    m_inner_union = x.m_inner_union;

                    m_complex_union = x.m_complex_union;

                    m_my_bitset = x.m_my_bitset;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AllStruct that will be copied.
     */
    eProsima_user_DllExport AllStruct& operator =(
            AllStruct&& x) noexcept
    {
        PrimitivesStruct::operator =(std::move(x));

        m_my_string = std::move(x.m_my_string);
        m_my_wstring = std::move(x.m_my_wstring);
        m_my_bounded_string = std::move(x.m_my_bounded_string);
        m_my_bounded_wstring = std::move(x.m_my_bounded_wstring);
        m_my_enum = x.m_my_enum;
        m_my_bitmask = std::move(x.m_my_bitmask);
        m_my_aliased_struct = std::move(x.m_my_aliased_struct);
        m_my_aliased_enum = x.m_my_aliased_enum;
        m_my_aliased_bounded_string = std::move(x.m_my_aliased_bounded_string);
        m_my_recursive_alias = x.m_my_recursive_alias;
        m_bitmask_sequence = std::move(x.m_bitmask_sequence);
        m_enum_sequence = std::move(x.m_enum_sequence);
        m_short_sequence = std::move(x.m_short_sequence);
        m_long_array = std::move(x.m_long_array);
        m_string_unbounded_map = std::move(x.m_string_unbounded_map);
        m_string_alias_unbounded_map = std::move(x.m_string_alias_unbounded_map);
        m_short_long_map = std::move(x.m_short_long_map);
        m_inner_union = std::move(x.m_inner_union);
        m_complex_union = std::move(x.m_complex_union);
        m_my_bitset = std::move(x.m_my_bitset);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AllStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AllStruct& x) const
    {
        if (PrimitivesStruct::operator !=(x))
                {
                    return false;
                }
        return (m_my_string == x.m_my_string &&
           m_my_wstring == x.m_my_wstring &&
           m_my_bounded_string == x.m_my_bounded_string &&
           m_my_bounded_wstring == x.m_my_bounded_wstring &&
           m_my_enum == x.m_my_enum &&
           m_my_bitmask == x.m_my_bitmask &&
           m_my_aliased_struct == x.m_my_aliased_struct &&
           m_my_aliased_enum == x.m_my_aliased_enum &&
           m_my_aliased_bounded_string == x.m_my_aliased_bounded_string &&
           m_my_recursive_alias == x.m_my_recursive_alias &&
           m_bitmask_sequence == x.m_bitmask_sequence &&
           m_enum_sequence == x.m_enum_sequence &&
           m_short_sequence == x.m_short_sequence &&
           m_long_array == x.m_long_array &&
           m_string_unbounded_map == x.m_string_unbounded_map &&
           m_string_alias_unbounded_map == x.m_string_alias_unbounded_map &&
           m_short_long_map == x.m_short_long_map &&
           m_inner_union == x.m_inner_union &&
           m_complex_union == x.m_complex_union &&
           m_my_bitset == x.m_my_bitset);
    }

    /*!
     * @brief Comparison operator.
     * @param x AllStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AllStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member my_string
     * @param _my_string New value to be copied in member my_string
     */
    eProsima_user_DllExport void my_string(
            const std::string& _my_string)
    {
        m_my_string = _my_string;
    }

    /*!
     * @brief This function moves the value in member my_string
     * @param _my_string New value to be moved in member my_string
     */
    eProsima_user_DllExport void my_string(
            std::string&& _my_string)
    {
        m_my_string = std::move(_my_string);
    }

    /*!
     * @brief This function returns a constant reference to member my_string
     * @return Constant reference to member my_string
     */
    eProsima_user_DllExport const std::string& my_string() const
    {
        return m_my_string;
    }

    /*!
     * @brief This function returns a reference to member my_string
     * @return Reference to member my_string
     */
    eProsima_user_DllExport std::string& my_string()
    {
        return m_my_string;
    }


    /*!
     * @brief This function copies the value in member my_wstring
     * @param _my_wstring New value to be copied in member my_wstring
     */
    eProsima_user_DllExport void my_wstring(
            const std::wstring& _my_wstring)
    {
        m_my_wstring = _my_wstring;
    }

    /*!
     * @brief This function moves the value in member my_wstring
     * @param _my_wstring New value to be moved in member my_wstring
     */
    eProsima_user_DllExport void my_wstring(
            std::wstring&& _my_wstring)
    {
        m_my_wstring = std::move(_my_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member my_wstring
     * @return Constant reference to member my_wstring
     */
    eProsima_user_DllExport const std::wstring& my_wstring() const
    {
        return m_my_wstring;
    }

    /*!
     * @brief This function returns a reference to member my_wstring
     * @return Reference to member my_wstring
     */
    eProsima_user_DllExport std::wstring& my_wstring()
    {
        return m_my_wstring;
    }


    /*!
     * @brief This function copies the value in member my_bounded_string
     * @param _my_bounded_string New value to be copied in member my_bounded_string
     */
    eProsima_user_DllExport void my_bounded_string(
            const eprosima::fastcdr::fixed_string<41925>& _my_bounded_string)
    {
        m_my_bounded_string = _my_bounded_string;
    }

    /*!
     * @brief This function moves the value in member my_bounded_string
     * @param _my_bounded_string New value to be moved in member my_bounded_string
     */
    eProsima_user_DllExport void my_bounded_string(
            eprosima::fastcdr::fixed_string<41925>&& _my_bounded_string)
    {
        m_my_bounded_string = std::move(_my_bounded_string);
    }

    /*!
     * @brief This function returns a constant reference to member my_bounded_string
     * @return Constant reference to member my_bounded_string
     */
    eProsima_user_DllExport const eprosima::fastcdr::fixed_string<41925>& my_bounded_string() const
    {
        return m_my_bounded_string;
    }

    /*!
     * @brief This function returns a reference to member my_bounded_string
     * @return Reference to member my_bounded_string
     */
    eProsima_user_DllExport eprosima::fastcdr::fixed_string<41925>& my_bounded_string()
    {
        return m_my_bounded_string;
    }


    /*!
     * @brief This function copies the value in member my_bounded_wstring
     * @param _my_bounded_wstring New value to be copied in member my_bounded_wstring
     */
    eProsima_user_DllExport void my_bounded_wstring(
            const std::wstring& _my_bounded_wstring)
    {
        m_my_bounded_wstring = _my_bounded_wstring;
    }

    /*!
     * @brief This function moves the value in member my_bounded_wstring
     * @param _my_bounded_wstring New value to be moved in member my_bounded_wstring
     */
    eProsima_user_DllExport void my_bounded_wstring(
            std::wstring&& _my_bounded_wstring)
    {
        m_my_bounded_wstring = std::move(_my_bounded_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member my_bounded_wstring
     * @return Constant reference to member my_bounded_wstring
     */
    eProsima_user_DllExport const std::wstring& my_bounded_wstring() const
    {
        return m_my_bounded_wstring;
    }

    /*!
     * @brief This function returns a reference to member my_bounded_wstring
     * @return Reference to member my_bounded_wstring
     */
    eProsima_user_DllExport std::wstring& my_bounded_wstring()
    {
        return m_my_bounded_wstring;
    }


    /*!
     * @brief This function sets a value in member my_enum
     * @param _my_enum New value for member my_enum
     */
    eProsima_user_DllExport void my_enum(
            MyEnum _my_enum)
    {
        m_my_enum = _my_enum;
    }

    /*!
     * @brief This function returns the value of member my_enum
     * @return Value of member my_enum
     */
    eProsima_user_DllExport MyEnum my_enum() const
    {
        return m_my_enum;
    }

    /*!
     * @brief This function returns a reference to member my_enum
     * @return Reference to member my_enum
     */
    eProsima_user_DllExport MyEnum& my_enum()
    {
        return m_my_enum;
    }


    /*!
     * @brief This function copies the value in member my_bitmask
     * @param _my_bitmask New value to be copied in member my_bitmask
     */
    eProsima_user_DllExport void my_bitmask(
            const MyBitMask& _my_bitmask)
    {
        m_my_bitmask = _my_bitmask;
    }

    /*!
     * @brief This function moves the value in member my_bitmask
     * @param _my_bitmask New value to be moved in member my_bitmask
     */
    eProsima_user_DllExport void my_bitmask(
            MyBitMask&& _my_bitmask)
    {
        m_my_bitmask = std::move(_my_bitmask);
    }

    /*!
     * @brief This function returns a constant reference to member my_bitmask
     * @return Constant reference to member my_bitmask
     */
    eProsima_user_DllExport const MyBitMask& my_bitmask() const
    {
        return m_my_bitmask;
    }

    /*!
     * @brief This function returns a reference to member my_bitmask
     * @return Reference to member my_bitmask
     */
    eProsima_user_DllExport MyBitMask& my_bitmask()
    {
        return m_my_bitmask;
    }


    /*!
     * @brief This function copies the value in member my_aliased_struct
     * @param _my_aliased_struct New value to be copied in member my_aliased_struct
     */
    eProsima_user_DllExport void my_aliased_struct(
            const MyAliasedStruct& _my_aliased_struct)
    {
        m_my_aliased_struct = _my_aliased_struct;
    }

    /*!
     * @brief This function moves the value in member my_aliased_struct
     * @param _my_aliased_struct New value to be moved in member my_aliased_struct
     */
    eProsima_user_DllExport void my_aliased_struct(
            MyAliasedStruct&& _my_aliased_struct)
    {
        m_my_aliased_struct = std::move(_my_aliased_struct);
    }

    /*!
     * @brief This function returns a constant reference to member my_aliased_struct
     * @return Constant reference to member my_aliased_struct
     */
    eProsima_user_DllExport const MyAliasedStruct& my_aliased_struct() const
    {
        return m_my_aliased_struct;
    }

    /*!
     * @brief This function returns a reference to member my_aliased_struct
     * @return Reference to member my_aliased_struct
     */
    eProsima_user_DllExport MyAliasedStruct& my_aliased_struct()
    {
        return m_my_aliased_struct;
    }


    /*!
     * @brief This function sets a value in member my_aliased_enum
     * @param _my_aliased_enum New value for member my_aliased_enum
     */
    eProsima_user_DllExport void my_aliased_enum(
            MyAliasedEnum _my_aliased_enum)
    {
        m_my_aliased_enum = _my_aliased_enum;
    }

    /*!
     * @brief This function returns the value of member my_aliased_enum
     * @return Value of member my_aliased_enum
     */
    eProsima_user_DllExport MyAliasedEnum my_aliased_enum() const
    {
        return m_my_aliased_enum;
    }

    /*!
     * @brief This function returns a reference to member my_aliased_enum
     * @return Reference to member my_aliased_enum
     */
    eProsima_user_DllExport MyAliasedEnum& my_aliased_enum()
    {
        return m_my_aliased_enum;
    }


    /*!
     * @brief This function copies the value in member my_aliased_bounded_string
     * @param _my_aliased_bounded_string New value to be copied in member my_aliased_bounded_string
     */
    eProsima_user_DllExport void my_aliased_bounded_string(
            const MyAliasedBoundedString& _my_aliased_bounded_string)
    {
        m_my_aliased_bounded_string = _my_aliased_bounded_string;
    }

    /*!
     * @brief This function moves the value in member my_aliased_bounded_string
     * @param _my_aliased_bounded_string New value to be moved in member my_aliased_bounded_string
     */
    eProsima_user_DllExport void my_aliased_bounded_string(
            MyAliasedBoundedString&& _my_aliased_bounded_string)
    {
        m_my_aliased_bounded_string = std::move(_my_aliased_bounded_string);
    }

    /*!
     * @brief This function returns a constant reference to member my_aliased_bounded_string
     * @return Constant reference to member my_aliased_bounded_string
     */
    eProsima_user_DllExport const MyAliasedBoundedString& my_aliased_bounded_string() const
    {
        return m_my_aliased_bounded_string;
    }

    /*!
     * @brief This function returns a reference to member my_aliased_bounded_string
     * @return Reference to member my_aliased_bounded_string
     */
    eProsima_user_DllExport MyAliasedBoundedString& my_aliased_bounded_string()
    {
        return m_my_aliased_bounded_string;
    }


    /*!
     * @brief This function sets a value in member my_recursive_alias
     * @param _my_recursive_alias New value for member my_recursive_alias
     */
    eProsima_user_DllExport void my_recursive_alias(
            MyRecursiveAlias _my_recursive_alias)
    {
        m_my_recursive_alias = _my_recursive_alias;
    }

    /*!
     * @brief This function returns the value of member my_recursive_alias
     * @return Value of member my_recursive_alias
     */
    eProsima_user_DllExport MyRecursiveAlias my_recursive_alias() const
    {
        return m_my_recursive_alias;
    }

    /*!
     * @brief This function returns a reference to member my_recursive_alias
     * @return Reference to member my_recursive_alias
     */
    eProsima_user_DllExport MyRecursiveAlias& my_recursive_alias()
    {
        return m_my_recursive_alias;
    }


    /*!
     * @brief This function copies the value in member bitmask_sequence
     * @param _bitmask_sequence New value to be copied in member bitmask_sequence
     */
    eProsima_user_DllExport void bitmask_sequence(
            const std::vector<MyBitMask>& _bitmask_sequence)
    {
        m_bitmask_sequence = _bitmask_sequence;
    }

    /*!
     * @brief This function moves the value in member bitmask_sequence
     * @param _bitmask_sequence New value to be moved in member bitmask_sequence
     */
    eProsima_user_DllExport void bitmask_sequence(
            std::vector<MyBitMask>&& _bitmask_sequence)
    {
        m_bitmask_sequence = std::move(_bitmask_sequence);
    }

    /*!
     * @brief This function returns a constant reference to member bitmask_sequence
     * @return Constant reference to member bitmask_sequence
     */
    eProsima_user_DllExport const std::vector<MyBitMask>& bitmask_sequence() const
    {
        return m_bitmask_sequence;
    }

    /*!
     * @brief This function returns a reference to member bitmask_sequence
     * @return Reference to member bitmask_sequence
     */
    eProsima_user_DllExport std::vector<MyBitMask>& bitmask_sequence()
    {
        return m_bitmask_sequence;
    }


    /*!
     * @brief This function copies the value in member enum_sequence
     * @param _enum_sequence New value to be copied in member enum_sequence
     */
    eProsima_user_DllExport void enum_sequence(
            const std::vector<MyEnum>& _enum_sequence)
    {
        m_enum_sequence = _enum_sequence;
    }

    /*!
     * @brief This function moves the value in member enum_sequence
     * @param _enum_sequence New value to be moved in member enum_sequence
     */
    eProsima_user_DllExport void enum_sequence(
            std::vector<MyEnum>&& _enum_sequence)
    {
        m_enum_sequence = std::move(_enum_sequence);
    }

    /*!
     * @brief This function returns a constant reference to member enum_sequence
     * @return Constant reference to member enum_sequence
     */
    eProsima_user_DllExport const std::vector<MyEnum>& enum_sequence() const
    {
        return m_enum_sequence;
    }

    /*!
     * @brief This function returns a reference to member enum_sequence
     * @return Reference to member enum_sequence
     */
    eProsima_user_DllExport std::vector<MyEnum>& enum_sequence()
    {
        return m_enum_sequence;
    }


    /*!
     * @brief This function copies the value in member short_sequence
     * @param _short_sequence New value to be copied in member short_sequence
     */
    eProsima_user_DllExport void short_sequence(
            const std::vector<int16_t>& _short_sequence)
    {
        m_short_sequence = _short_sequence;
    }

    /*!
     * @brief This function moves the value in member short_sequence
     * @param _short_sequence New value to be moved in member short_sequence
     */
    eProsima_user_DllExport void short_sequence(
            std::vector<int16_t>&& _short_sequence)
    {
        m_short_sequence = std::move(_short_sequence);
    }

    /*!
     * @brief This function returns a constant reference to member short_sequence
     * @return Constant reference to member short_sequence
     */
    eProsima_user_DllExport const std::vector<int16_t>& short_sequence() const
    {
        return m_short_sequence;
    }

    /*!
     * @brief This function returns a reference to member short_sequence
     * @return Reference to member short_sequence
     */
    eProsima_user_DllExport std::vector<int16_t>& short_sequence()
    {
        return m_short_sequence;
    }


    /*!
     * @brief This function copies the value in member long_array
     * @param _long_array New value to be copied in member long_array
     */
    eProsima_user_DllExport void long_array(
            const std::array<std::array<std::array<int32_t, 4>, 3>, 2>& _long_array)
    {
        m_long_array = _long_array;
    }

    /*!
     * @brief This function moves the value in member long_array
     * @param _long_array New value to be moved in member long_array
     */
    eProsima_user_DllExport void long_array(
            std::array<std::array<std::array<int32_t, 4>, 3>, 2>&& _long_array)
    {
        m_long_array = std::move(_long_array);
    }

    /*!
     * @brief This function returns a constant reference to member long_array
     * @return Constant reference to member long_array
     */
    eProsima_user_DllExport const std::array<std::array<std::array<int32_t, 4>, 3>, 2>& long_array() const
    {
        return m_long_array;
    }

    /*!
     * @brief This function returns a reference to member long_array
     * @return Reference to member long_array
     */
    eProsima_user_DllExport std::array<std::array<std::array<int32_t, 4>, 3>, 2>& long_array()
    {
        return m_long_array;
    }


    /*!
     * @brief This function copies the value in member string_unbounded_map
     * @param _string_unbounded_map New value to be copied in member string_unbounded_map
     */
    eProsima_user_DllExport void string_unbounded_map(
            const std::map<std::string, std::string>& _string_unbounded_map)
    {
        m_string_unbounded_map = _string_unbounded_map;
    }

    /*!
     * @brief This function moves the value in member string_unbounded_map
     * @param _string_unbounded_map New value to be moved in member string_unbounded_map
     */
    eProsima_user_DllExport void string_unbounded_map(
            std::map<std::string, std::string>&& _string_unbounded_map)
    {
        m_string_unbounded_map = std::move(_string_unbounded_map);
    }

    /*!
     * @brief This function returns a constant reference to member string_unbounded_map
     * @return Constant reference to member string_unbounded_map
     */
    eProsima_user_DllExport const std::map<std::string, std::string>& string_unbounded_map() const
    {
        return m_string_unbounded_map;
    }

    /*!
     * @brief This function returns a reference to member string_unbounded_map
     * @return Reference to member string_unbounded_map
     */
    eProsima_user_DllExport std::map<std::string, std::string>& string_unbounded_map()
    {
        return m_string_unbounded_map;
    }


    /*!
     * @brief This function copies the value in member string_alias_unbounded_map
     * @param _string_alias_unbounded_map New value to be copied in member string_alias_unbounded_map
     */
    eProsima_user_DllExport void string_alias_unbounded_map(
            const std::map<std::string, MyAliasedBoundedString>& _string_alias_unbounded_map)
    {
        m_string_alias_unbounded_map = _string_alias_unbounded_map;
    }

    /*!
     * @brief This function moves the value in member string_alias_unbounded_map
     * @param _string_alias_unbounded_map New value to be moved in member string_alias_unbounded_map
     */
    eProsima_user_DllExport void string_alias_unbounded_map(
            std::map<std::string, MyAliasedBoundedString>&& _string_alias_unbounded_map)
    {
        m_string_alias_unbounded_map = std::move(_string_alias_unbounded_map);
    }

    /*!
     * @brief This function returns a constant reference to member string_alias_unbounded_map
     * @return Constant reference to member string_alias_unbounded_map
     */
    eProsima_user_DllExport const std::map<std::string, MyAliasedBoundedString>& string_alias_unbounded_map() const
    {
        return m_string_alias_unbounded_map;
    }

    /*!
     * @brief This function returns a reference to member string_alias_unbounded_map
     * @return Reference to member string_alias_unbounded_map
     */
    eProsima_user_DllExport std::map<std::string, MyAliasedBoundedString>& string_alias_unbounded_map()
    {
        return m_string_alias_unbounded_map;
    }


    /*!
     * @brief This function copies the value in member short_long_map
     * @param _short_long_map New value to be copied in member short_long_map
     */
    eProsima_user_DllExport void short_long_map(
            const std::map<int16_t, int32_t>& _short_long_map)
    {
        m_short_long_map = _short_long_map;
    }

    /*!
     * @brief This function moves the value in member short_long_map
     * @param _short_long_map New value to be moved in member short_long_map
     */
    eProsima_user_DllExport void short_long_map(
            std::map<int16_t, int32_t>&& _short_long_map)
    {
        m_short_long_map = std::move(_short_long_map);
    }

    /*!
     * @brief This function returns a constant reference to member short_long_map
     * @return Constant reference to member short_long_map
     */
    eProsima_user_DllExport const std::map<int16_t, int32_t>& short_long_map() const
    {
        return m_short_long_map;
    }

    /*!
     * @brief This function returns a reference to member short_long_map
     * @return Reference to member short_long_map
     */
    eProsima_user_DllExport std::map<int16_t, int32_t>& short_long_map()
    {
        return m_short_long_map;
    }


    /*!
     * @brief This function copies the value in member inner_union
     * @param _inner_union New value to be copied in member inner_union
     */
    eProsima_user_DllExport void inner_union(
            const InnerUnion& _inner_union)
    {
        m_inner_union = _inner_union;
    }

    /*!
     * @brief This function moves the value in member inner_union
     * @param _inner_union New value to be moved in member inner_union
     */
    eProsima_user_DllExport void inner_union(
            InnerUnion&& _inner_union)
    {
        m_inner_union = std::move(_inner_union);
    }

    /*!
     * @brief This function returns a constant reference to member inner_union
     * @return Constant reference to member inner_union
     */
    eProsima_user_DllExport const InnerUnion& inner_union() const
    {
        return m_inner_union;
    }

    /*!
     * @brief This function returns a reference to member inner_union
     * @return Reference to member inner_union
     */
    eProsima_user_DllExport InnerUnion& inner_union()
    {
        return m_inner_union;
    }


    /*!
     * @brief This function copies the value in member complex_union
     * @param _complex_union New value to be copied in member complex_union
     */
    eProsima_user_DllExport void complex_union(
            const ComplexUnion& _complex_union)
    {
        m_complex_union = _complex_union;
    }

    /*!
     * @brief This function moves the value in member complex_union
     * @param _complex_union New value to be moved in member complex_union
     */
    eProsima_user_DllExport void complex_union(
            ComplexUnion&& _complex_union)
    {
        m_complex_union = std::move(_complex_union);
    }

    /*!
     * @brief This function returns a constant reference to member complex_union
     * @return Constant reference to member complex_union
     */
    eProsima_user_DllExport const ComplexUnion& complex_union() const
    {
        return m_complex_union;
    }

    /*!
     * @brief This function returns a reference to member complex_union
     * @return Reference to member complex_union
     */
    eProsima_user_DllExport ComplexUnion& complex_union()
    {
        return m_complex_union;
    }


    /*!
     * @brief This function copies the value in member my_bitset
     * @param _my_bitset New value to be copied in member my_bitset
     */
    eProsima_user_DllExport void my_bitset(
            const MyBitSet& _my_bitset)
    {
        m_my_bitset = _my_bitset;
    }

    /*!
     * @brief This function moves the value in member my_bitset
     * @param _my_bitset New value to be moved in member my_bitset
     */
    eProsima_user_DllExport void my_bitset(
            MyBitSet&& _my_bitset)
    {
        m_my_bitset = std::move(_my_bitset);
    }

    /*!
     * @brief This function returns a constant reference to member my_bitset
     * @return Constant reference to member my_bitset
     */
    eProsima_user_DllExport const MyBitSet& my_bitset() const
    {
        return m_my_bitset;
    }

    /*!
     * @brief This function returns a reference to member my_bitset
     * @return Reference to member my_bitset
     */
    eProsima_user_DllExport MyBitSet& my_bitset()
    {
        return m_my_bitset;
    }



private:

    std::string m_my_string;
    std::wstring m_my_wstring;
    eprosima::fastcdr::fixed_string<41925> m_my_bounded_string;
    std::wstring m_my_bounded_wstring;
    MyEnum m_my_enum{MyEnum::A};
    MyBitMask m_my_bitmask{0};
    MyAliasedStruct m_my_aliased_struct;
    MyAliasedEnum m_my_aliased_enum{MyEnum::A};
    MyAliasedBoundedString m_my_aliased_bounded_string;
    MyRecursiveAlias m_my_recursive_alias{MyEnum::A};
    std::vector<MyBitMask> m_bitmask_sequence;
    std::vector<MyEnum> m_enum_sequence;
    std::vector<int16_t> m_short_sequence;
    std::array<std::array<std::array<int32_t, 4>, 3>, 2> m_long_array{ {{ {{0}} }} };
    std::map<std::string, std::string> m_string_unbounded_map;
    std::map<std::string, MyAliasedBoundedString> m_string_alias_unbounded_map;
    std::map<int16_t, int32_t> m_short_long_map;
    InnerUnion m_inner_union;
    ComplexUnion m_complex_union;
    MyBitSet m_my_bitset{};

};
/*!
 * @brief This class represents the structure ComprehensiveType defined by the user in the IDL file.
 * @ingroup ComprehensiveType
 */
class ComprehensiveType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ComprehensiveType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ComprehensiveType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ComprehensiveType that will be copied.
     */
    eProsima_user_DllExport ComprehensiveType(
            const ComprehensiveType& x)
    {
                    m_index = x.m_index;

                    m_inner_struct = x.m_inner_struct;

                    m_complex_sequence = x.m_complex_sequence;

                    m_complex_array = x.m_complex_array;

                    m_complex_map = x.m_complex_map;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ComprehensiveType that will be copied.
     */
    eProsima_user_DllExport ComprehensiveType(
            ComprehensiveType&& x) noexcept
    {
        m_index = x.m_index;
        m_inner_struct = std::move(x.m_inner_struct);
        m_complex_sequence = std::move(x.m_complex_sequence);
        m_complex_array = std::move(x.m_complex_array);
        m_complex_map = std::move(x.m_complex_map);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ComprehensiveType that will be copied.
     */
    eProsima_user_DllExport ComprehensiveType& operator =(
            const ComprehensiveType& x)
    {

                    m_index = x.m_index;

                    m_inner_struct = x.m_inner_struct;

                    m_complex_sequence = x.m_complex_sequence;

                    m_complex_array = x.m_complex_array;

                    m_complex_map = x.m_complex_map;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ComprehensiveType that will be copied.
     */
    eProsima_user_DllExport ComprehensiveType& operator =(
            ComprehensiveType&& x) noexcept
    {

        m_index = x.m_index;
        m_inner_struct = std::move(x.m_inner_struct);
        m_complex_sequence = std::move(x.m_complex_sequence);
        m_complex_array = std::move(x.m_complex_array);
        m_complex_map = std::move(x.m_complex_map);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ComprehensiveType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ComprehensiveType& x) const
    {
        return (m_index == x.m_index &&
           m_inner_struct == x.m_inner_struct &&
           m_complex_sequence == x.m_complex_sequence &&
           m_complex_array == x.m_complex_array &&
           m_complex_map == x.m_complex_map);
    }

    /*!
     * @brief Comparison operator.
     * @param x ComprehensiveType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ComprehensiveType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member index
     * @param _index New value for member index
     */
    eProsima_user_DllExport void index(
            uint32_t _index)
    {
        m_index = _index;
    }

    /*!
     * @brief This function returns the value of member index
     * @return Value of member index
     */
    eProsima_user_DllExport uint32_t index() const
    {
        return m_index;
    }

    /*!
     * @brief This function returns a reference to member index
     * @return Reference to member index
     */
    eProsima_user_DllExport uint32_t& index()
    {
        return m_index;
    }


    /*!
     * @brief This function copies the value in member inner_struct
     * @param _inner_struct New value to be copied in member inner_struct
     */
    eProsima_user_DllExport void inner_struct(
            const AllStruct& _inner_struct)
    {
        m_inner_struct = _inner_struct;
    }

    /*!
     * @brief This function moves the value in member inner_struct
     * @param _inner_struct New value to be moved in member inner_struct
     */
    eProsima_user_DllExport void inner_struct(
            AllStruct&& _inner_struct)
    {
        m_inner_struct = std::move(_inner_struct);
    }

    /*!
     * @brief This function returns a constant reference to member inner_struct
     * @return Constant reference to member inner_struct
     */
    eProsima_user_DllExport const AllStruct& inner_struct() const
    {
        return m_inner_struct;
    }

    /*!
     * @brief This function returns a reference to member inner_struct
     * @return Reference to member inner_struct
     */
    eProsima_user_DllExport AllStruct& inner_struct()
    {
        return m_inner_struct;
    }


    /*!
     * @brief This function copies the value in member complex_sequence
     * @param _complex_sequence New value to be copied in member complex_sequence
     */
    eProsima_user_DllExport void complex_sequence(
            const std::vector<AllStruct>& _complex_sequence)
    {
        m_complex_sequence = _complex_sequence;
    }

    /*!
     * @brief This function moves the value in member complex_sequence
     * @param _complex_sequence New value to be moved in member complex_sequence
     */
    eProsima_user_DllExport void complex_sequence(
            std::vector<AllStruct>&& _complex_sequence)
    {
        m_complex_sequence = std::move(_complex_sequence);
    }

    /*!
     * @brief This function returns a constant reference to member complex_sequence
     * @return Constant reference to member complex_sequence
     */
    eProsima_user_DllExport const std::vector<AllStruct>& complex_sequence() const
    {
        return m_complex_sequence;
    }

    /*!
     * @brief This function returns a reference to member complex_sequence
     * @return Reference to member complex_sequence
     */
    eProsima_user_DllExport std::vector<AllStruct>& complex_sequence()
    {
        return m_complex_sequence;
    }


    /*!
     * @brief This function copies the value in member complex_array
     * @param _complex_array New value to be copied in member complex_array
     */
    eProsima_user_DllExport void complex_array(
            const std::array<AllStruct, 2>& _complex_array)
    {
        m_complex_array = _complex_array;
    }

    /*!
     * @brief This function moves the value in member complex_array
     * @param _complex_array New value to be moved in member complex_array
     */
    eProsima_user_DllExport void complex_array(
            std::array<AllStruct, 2>&& _complex_array)
    {
        m_complex_array = std::move(_complex_array);
    }

    /*!
     * @brief This function returns a constant reference to member complex_array
     * @return Constant reference to member complex_array
     */
    eProsima_user_DllExport const std::array<AllStruct, 2>& complex_array() const
    {
        return m_complex_array;
    }

    /*!
     * @brief This function returns a reference to member complex_array
     * @return Reference to member complex_array
     */
    eProsima_user_DllExport std::array<AllStruct, 2>& complex_array()
    {
        return m_complex_array;
    }


    /*!
     * @brief This function copies the value in member complex_map
     * @param _complex_map New value to be copied in member complex_map
     */
    eProsima_user_DllExport void complex_map(
            const std::map<int16_t, AllStruct>& _complex_map)
    {
        m_complex_map = _complex_map;
    }

    /*!
     * @brief This function moves the value in member complex_map
     * @param _complex_map New value to be moved in member complex_map
     */
    eProsima_user_DllExport void complex_map(
            std::map<int16_t, AllStruct>&& _complex_map)
    {
        m_complex_map = std::move(_complex_map);
    }

    /*!
     * @brief This function returns a constant reference to member complex_map
     * @return Constant reference to member complex_map
     */
    eProsima_user_DllExport const std::map<int16_t, AllStruct>& complex_map() const
    {
        return m_complex_map;
    }

    /*!
     * @brief This function returns a reference to member complex_map
     * @return Reference to member complex_map
     */
    eProsima_user_DllExport std::map<int16_t, AllStruct>& complex_map()
    {
        return m_complex_map;
    }



private:

    uint32_t m_index{0};
    AllStruct m_inner_struct;
    std::vector<AllStruct> m_complex_sequence;
    std::array<AllStruct, 2> m_complex_array;
    std::map<int16_t, AllStruct> m_complex_map;

};

#endif // _FAST_DDS_GENERATED_COMPREHENSIVETYPE_HPP_


