/* $Id: SignalDeclaration.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIGNAL_DECLARATION_HPP_INCLUDED
#define __SIGNAL_DECLARATION_HPP_INCLUDED

#include "frontend/ast/ValDeclaration.hpp"
#include "frontend/ast/Expression.hpp"

namespace ast {

//! Represents one Signal declaration.
/** This class represents one VHDL signal declaration. */
class SignalDeclaration : public ValDeclaration {

public:
	//! c'tor
	/** construct a Signal object.
	 *  @param declName name of the declared Signal.
	 *  @param pMode mode of the Signal (in, out, inout).
	 *  @param isBus declared with bus keyword (guarded signal)?
	 *  @param varInit initializer Expression for the constant.
	 *  @param subtype subtype indication
	 *  @param loc location of the SignalDeclaration. */
	SignalDeclaration(
		std::string *declName, 
		enum ValDeclaration::Mode pMode, 
		bool isBus,
		Expression *varInit,
		SubtypeIndication *subtype,
		Location loc
		) : 	ValDeclaration(pMode, declName, varInit, 
					subtype, 
					ValDeclaration::OBJ_CLASS_SIGNAL, 
					loc),
			isGuarded(isBus) {}
	
	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor &visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		assert(this->name);
		stream << "SIGNAL " << *this->name << " : " 
			<< this->subtypeIndic;
		if (this->init) {
			stream << " := " << this->init;
		}
		stream << ';';
	}


	/** Is it a guarded signal?
	 *  currently this gets utterly ignored.
	 */
	bool isGuarded;
};
}; /* namespace ast */

#endif /* __SIGNAL_DECLARATION_HPP_INCLUDED */
