-- $Id: arrays.vhdl 4329 2009-01-27 14:48:04Z potyra $ 

-- test for some different arrays

-- Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


library std;
use std.standard.all;
package types is
	type word is array(0 to 31) of bit;
	type bitarray is array(INTEGER range <>) of bit;
	type memory is array(INTEGER range <>, INTEGER range <>) of bit;
	subtype small is integer range 0 to 127;
	--type memory3 is array(small, 0 to 31) of bit;
	type memory2 is array(small, 0 to 31) of bit;
	type memory3 is array(0 to 127, 0 to 31) of bit;
end package types;

use types.all;
entity nullentity is
end entity nullentity;

architecture implementation of nullentity is
begin	
	x : process 
		constant memsize : integer := 127;
		variable foo : word; -- no index constrained allowed here!
		variable bar : memory(0 to memsize);
		variable tofu : memory(small);
		variable test : memory( 16 to 4, 5 to 8 );
		variable bla : integer range 1 to 112;
		constant foobar -- comment in identifier list
			        : bitarray := "11110000"; -- (0 to 7)
	begin
		bar(4, 5) := '1';
		bar(0) := "0";
		tofu(0, 0) := '1';
		tofu(0, 1) := '0';
	end process;
end implementation;
