/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;

public class AspectJWeaverMessageHandler
implements IMessageHandler {
    private static final String AJ_ID = "[AspectJ] ";
    private static final Log LOGGER = LogFactory.getLog("AspectJ Weaver");

    public boolean handleMessage(IMessage message) throws AbortException {
        IMessage.Kind messageKind = message.getKind();
        if ((LOGGER.isDebugEnabled() || LOGGER.isTraceEnabled()) && messageKind == IMessage.DEBUG) {
            LOGGER.debug(this.makeMessageFor(message));
            return true;
        }
        if (LOGGER.isInfoEnabled() && (messageKind == IMessage.INFO || messageKind == IMessage.WEAVEINFO)) {
            LOGGER.info(this.makeMessageFor(message));
            return true;
        }
        if (LOGGER.isWarnEnabled() && messageKind == IMessage.WARNING) {
            LOGGER.warn(this.makeMessageFor(message));
            return true;
        }
        if (LOGGER.isErrorEnabled() && messageKind == IMessage.ERROR) {
            LOGGER.error(this.makeMessageFor(message));
            return true;
        }
        if (LOGGER.isFatalEnabled() && messageKind == IMessage.ABORT) {
            LOGGER.fatal(this.makeMessageFor(message));
            return true;
        }
        return false;
    }

    private String makeMessageFor(IMessage aMessage) {
        return AJ_ID + aMessage.getMessage();
    }

    public boolean isIgnoring(IMessage.Kind messageKind) {
        return false;
    }

    public void dontIgnore(IMessage.Kind messageKind) {
    }

    public void ignore(IMessage.Kind kind) {
    }
}

