/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedSectionSpec {
    public Variable v;
    public Section section;
    public ParsedSectionSpec child;
    private static boolean debugSelector = false;

    private ParsedSectionSpec(Variable v, Section section) {
        this.v = v;
        this.section = section;
        this.child = null;
    }

    public static ParsedSectionSpec parseVariableSection(NetcdfFile ncfile, String variableSection) throws InvalidRangeException {
        ParsedSectionSpec outerV;
        StringTokenizer stoke = new StringTokenizer(variableSection, ".");
        String selector = stoke.nextToken();
        if (selector == null) {
            throw new IllegalArgumentException("empty sectionSpec = " + variableSection);
        }
        ParsedSectionSpec current = outerV = ParsedSectionSpec.parseVariableSelector(ncfile, selector);
        while (stoke.hasMoreTokens()) {
            selector = stoke.nextToken();
            current = current.child = ParsedSectionSpec.parseVariableSelector(current.v, selector);
        }
        return outerV;
    }

    private static ParsedSectionSpec parseVariableSelector(Object parent, String selector) throws InvalidRangeException {
        Section section;
        String varName;
        String indexSelect = null;
        int pos1 = selector.indexOf(40);
        if (pos1 < 0) {
            varName = selector;
        } else {
            varName = selector.substring(0, pos1);
            int pos2 = selector.indexOf(41);
            indexSelect = selector.substring(pos1, pos2);
        }
        if (debugSelector) {
            System.out.println(" parseVariableSection <" + selector + "> = <" + varName + ">, <" + indexSelect + ">");
        }
        Variable v = null;
        if (parent instanceof NetcdfFile) {
            NetcdfFile ncfile = (NetcdfFile)parent;
            v = ncfile.findVariable(varName);
        } else if (parent instanceof Structure) {
            Structure s = (Structure)parent;
            v = s.findVariable(varName);
        }
        if (v == null) {
            throw new IllegalArgumentException(" cant find variable: " + varName + " in selector=" + selector);
        }
        if (indexSelect != null) {
            section = new Section(indexSelect);
            section.setDefaults(v.getShape());
        } else {
            section = new Section(v.getShape());
        }
        return new ParsedSectionSpec(v, section);
    }

    public static String makeSectionSpecString(Variable v, List<Range> ranges) throws InvalidRangeException {
        StringBuilder sb = new StringBuilder();
        ParsedSectionSpec.makeSpec(sb, v, ranges);
        return sb.toString();
    }

    private static List<Range> makeSpec(StringBuilder sb, Variable v, List<Range> orgRanges) throws InvalidRangeException {
        if (v.isMemberOfStructure()) {
            orgRanges = ParsedSectionSpec.makeSpec(sb, v.getParentStructure(), orgRanges);
            sb.append('.');
        }
        List<Range> ranges = orgRanges == null ? v.getRanges() : orgRanges;
        sb.append(v.isMemberOfStructure() ? v.getShortName() : v.getNameEscaped());
        if (!v.isVariableLength() && !v.isScalar()) {
            sb.append('(');
            for (int count = 0; count < v.getRank(); ++count) {
                Range r = ranges.get(count);
                if (r == null) {
                    r = new Range(0, v.getDimension(count).getLength());
                }
                if (count > 0) {
                    sb.append(", ");
                }
                sb.append(r.first());
                sb.append(':');
                sb.append(r.last());
                sb.append(':');
                sb.append(r.stride());
            }
            sb.append(')');
        }
        return orgRanges == null ? null : ranges.subList(v.getRank(), ranges.size());
    }
}

