/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryObject;

public class BinaryIntegerMatrix
implements BinaryObject {
    private static final boolean fasterButUglier = true;

    static final int computeBytes(int[][] matrix) {
        if (matrix == null) {
            return 4;
        }
        int len = 4;
        for (int i = 0; i < matrix.length; ++i) {
            len += 4 + matrix[i].length * 4;
        }
        return len;
    }

    static final int[][] read(DataInput file) throws IOException {
        int len = file.readInt();
        if (len < 0) {
            return null;
        }
        int[][] matrix = new int[len][];
        for (int i = 0; i < len; ++i) {
            int len2 = file.readInt();
            matrix[i] = new int[len2];
            for (int j = 0; j < len2; ++j) {
                matrix[i][j] = file.readInt();
            }
        }
        return matrix;
    }

    static final void write(DataOutput file, int[][] matrix) throws IOException {
        if (matrix == null) {
            file.writeInt(-1);
        } else {
            byte[] buf = new byte[4 + matrix.length * (4 + 4 * matrix[0].length)];
            int bufIdx = 0;
            int l = matrix.length;
            for (int b = 3; b >= 0; --b) {
                buf[bufIdx + b] = (byte)(l & 0xFF);
                l >>= 8;
            }
            bufIdx += 4;
            for (int i = 0; i < matrix.length; ++i) {
                int len = matrix[i].length;
                int l2 = len;
                for (int b = 3; b >= 0; --b) {
                    buf[bufIdx + b] = (byte)(l2 & 0xFF);
                    l2 >>= 8;
                }
                bufIdx += 4;
                for (int j = 0; j < len; ++j) {
                    int x = matrix[i][j];
                    for (int b = 3; b >= 0; --b) {
                        buf[bufIdx + b] = (byte)(x & 0xFF);
                        x >>= 8;
                    }
                    bufIdx += 4;
                }
            }
            file.write(buf);
        }
    }

    public static final void write(BinaryWriter writer, int[][] matrix, Object token) throws IOException {
        DataOutput file = writer.getOutput();
        BinaryIntegerMatrix.write(file, matrix);
    }
}

