;;; Czech lexicon

;; Copyright (C) 2003, 2004, 2005, 2006, 2007 Brailcom, o.p.s.

;; Author: Milan Zamazal <pdm@brailcom.org>

;; COPYRIGHT NOTICE

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.


;;; Alphabet

("a"  sym (((a:) 0)))
("a"  nil (((a) 0)))
(""  sym (((d l o u h e: ) 0) ((a:) 0)))
(""  int (((a:) 0)))
(""  nil (((p r~ e h l a s o v a n e:) 0) ((a:) 0)))
("b"  nil (((b e:) 0)))
("c"  nil (((c e:) 0)))
(""  nil (((c~ e:) 0)))
("d"  nil (((d e:) 0)))
(""  nil (((d~ e:) 0)))
("e"  nil (((e:) 0)))
(""  nil (((d l o u h e: ) 0) ((e:) 0)))
(""  nil (((i j e) 0)))
("f"  nil (((e f) 0)))
("g"  nil (((g e:) 0)))
("h"  nil (((h a:) 0)))
("ch" nil (((ch a:) 0)))
(""  nil (((d l o u h e: ) 0) ((i:) 0)))
("j"  nil (((j e:) 0)))
("k"  sym (((k a:) 0)))
("k"  nil (((k) 0)))
("l"  nil (((e l) 0)))
("m"  nil (((e m) 0)))
("n"  nil (((e n) 0)))
(""  nil (((e n~) 0)))
("o"  sym (((o:) 0)))
("o"  nil (((o) 0)))
(""  sym (((d l o u h e: ) 0) ((o:) 0)))
(""  int (((o:) 0)))
(""  nil (((p r~ e h l a s o v a n e:) 0) ((o:) 0)))
("p"  nil (((p e:) 0)))
("q"  nil (((k v e:) 0)))
("r"  nil (((e r) 0)))
(""  nil (((e r~) 0)))
("s"  sym (((e s) 0)))
("s"  nil (((s) 0)))
(""  nil (((e s~) 0)))
(""  nil (((o s t r e:) 0) ((e s) 0)))
("t"  nil (((t e:) 0)))
(""  nil (((t~ e:) 0)))
("u"  sym (((u:) 0)))
("u"  nil (((u) 0)))
(""  nil (((d l o u h e: ) 0) ((u:) 0)))
(""  nil (((u:) 0) ((s k r o u s~ k e m) 0)))
(""  nil (((p r~ e h l a s o v a n e:) 0) ((u:) 0)))
("v"  sym (((v e:) 0)))
("v"  nil (((v) 0)))
("w"  nil (((d v o j i t e:) 0) ((v e:) 0)))
("x"  nil (((i k s) 0)))
("y"  nil (((i p s i l o n) 0)))
(""  nil (((d l o u h e:) 0) ((i p s i l o n) 0)))
("z"  sym (((z e t) 0)))
("z"  nil (((z) 0)))
(""  nil (((z~ e t) 0)))

;;; Punctuation characters

("+"  num (((p l u s) 0)))
("-"  num (((m i n u s) 0)))
("."  num (((t e c~ k a) 0)))
(","  num (((c e l i: ch) 0)))

("-"  range (((a z~) 0)))

("."  punc ())
(":"  punc ())
(";"  punc ())
(","  punc ())
("-"  punc ())
("?"  punc ())
("!"  punc ())
("`"  punc ())
("'"  punc ())
("\"" punc ())
("("  punc ())
(")"  punc ())
;; These are multiword entries, but there's not another easy way to handle the
;; punctuation
("["  punc (((l e v a:) 0) ((h r a n a t a:) 0)))
("]"  punc (((p r a v a:) 0) ((h r a n a t a:) 0)))
("{"  punc (((l e v a:) 0) ((s l o z~ e n a:) 0)))
("}"  punc (((p r a v a:) 0) ((s l o z~ e n a:) 0)))
("<"  punc (((m e n s~ i:) 0) ((n e z~) 0)))
(">"  punc (((v j e t s~ i:) 0) ((n e z~) 0)))

("."  nil (((t e c~ k a) 0)))
(":"  nil (((d v o j t e c~ k a) 0)))
(";"  nil (((s t r~ e d n~ i: k) 0)))
(","  nil (((c~ a: r k a) 0)))
("-"  nil (((p o m l c~ k a) 0)))
("?"  nil (((o t a z n~ i: k) 0)))
("!"  nil (((v i k r~ i c~ n~ i: k) 0)))
("'"  nil (((a p o s t r o f) 0)))
("\"" nil (((u v o z o v k i) 0)))
(" "  nil (((m e z e r a) 0)))

;;; Other non-alphanumeric characters

("*"  nil (((h v j e z d~ i c~ k a) 0)))
("%"  nil (((p r o c e n t) 0)))
("&"  nil (((a m p r s a n d) 0)))
("$"  nil (((d o l a r) 0)))
("#"  nil (((m r~ i: z~ k a) 0)))
("@"  nil (((z a v i n a: c~) 0)))
("+"  nil (((p l u s) 0)))
("="  nil (((r o v n a:) 0) ((s e) 0)))
("^"  nil (((s t r~ i: s~ k a) 0)))
("~"  nil (((v l n k a) 0)))
("/"  nil (((l o m e n o) 0)))
("_"  nil (((p o d t r z~ i: t k o) 0)))
("|"  nil (((s v i s l i: t k o) 0)))
("\t" nil (((t a b u l a: t o r) 0)))

;;; Words

("Chocomyl" nil (((ch o c o m i s~ l) 0)))
("Chocomyle" nil (((ch o c o m i s~ l e) 0)))
("Chocomylemi" nil (((ch o c o m i s~ l e m i) 0)))
("Chocomyli" nil (((ch o c o m i s~ l i) 0)))
("Chocomyl" nil (((ch o c o m i s~ l i:) 0)))
("Chocomylch" nil (((ch o c o m i s~ l i: ch) 0)))
("Chocomylm" nil (((ch o c o m i s~ l i: m) 0)))
("Emacs" nil (((i: m e k s) 0)))
("Emacsech" nil (((i: m e k s e ch) 0)))
("Emacsem" nil (((i: m e k s e m) 0)))
("Emacsu" nil (((i: m e k s u) 0)))
("Emacsy" nil (((i: m e k s i) 0)))
("Emacs" nil (((i: m e k s u:) 0)))
("Emacsm" nil (((i: m e k s u: m) 0)))
("GNU" nil (((g n u:) 0)))
("K"  nil (((k o r u n) 0)))
("cca" nil (((c i r k a) 0)))
("chocomylskou" nil (((ch o c o m i s~ l s k o u) 0)))
("chocomylsky" nil (((ch o c o m i s~ l s k i) 0)))
("chocomylsk" nil (((ch o c o m i s~ l s k a:) 0)))
("chocomylsk" nil (((ch o c o m i s~ l s k e:) 0)))
("chocomylskho" nil (((ch o c o m i s~ l s k e: h o) 0)))
("chocomylskm" nil (((ch o c o m i s~ l s k e: m) 0)))
("chocomylskmu" nil (((ch o c o m i s~ l s k e: m u) 0)))
("chocomylsk" nil (((ch o c o m i s~ l s k i:) 0)))
("chocomylskch" nil (((ch o c o m i s~ l s k i: ch) 0)))
("chocomylskm" nil (((ch o c o m i s~ l s k i: m) 0)))
("chocomylskma" nil (((ch o c o m i s~ l s k i: m a) 0)))
("chocomylskmi" nil (((ch o c o m i s~ l s k i: m i) 0)))
("chocomylt" nil (((ch o c o m i s~ l s~ t~ i:) 0)))
("control" nil (((k o n t r o l) 0)))
("copyright" nil (((k o p i r a j t) 0)))
("copyrightech" nil (((k o p i r a j t e ch) 0)))
("copyrightem" nil (((k o p i r a j t e m) 0)))
("copyrightu" nil (((k o p i r a j t u) 0)))
("copyrighty" nil (((k o p i r a j t i) 0)))
("copyright" nil (((k o p i r a j t u:) 0)))
("copyrightm" nil (((k o p i r a j t u: m) 0)))
("czech" nil (((c~ e k) 0)))
("emacsovou" nil (((i: m e k s o v o u) 0)))
("emacsov" nil (((i: m e k s o v a:) 0)))
("emacsov" nil (((i: m e k s o v e:) 0)))
("emacsovho" nil (((i: m e k s o v e: h o) 0)))
("emacsovm" nil (((i: m e k s o v e: m) 0)))
("emacsovmu" nil (((i: m e k s o v e: m u) 0)))
("emacsov" nil (((i: m e k s o v j e) 0)))
("emacsov" nil (((i: m e k s o v i:) 0)))
("emacsov" nil (((i: m e k s o v i:) 0)))
("emacsovch" nil (((i: m e k s o v i: ch) 0)))
("emacsovm" nil (((i: m e k s o v i: m) 0)))
("emacsovma" nil (((i: m e k s o v i: m a) 0)))
("emacsovmi" nil (((i: m e k s o v i: m i) 0)))
("escape" nil (((i s k e j p) 0)))
("foundation" nil (((f a u n d e j s~ n) 0)))
("freeware" nil (((f r i: v e: r) 0)))
("freewarech" nil (((f r i: v e: r e ch) 0)))
("freewarem" nil (((f r i: v e: r e m) 0)))
("freewarovou" nil (((f r i: v e: r o v o u) 0)))
("freewarov" nil (((f r i: v e: r o v a:) 0)))
("freewarov" nil (((f r i: v e: r o v e:) 0)))
("freewarovho" nil (((f r i: v e: r o v e: h o) 0)))
("freewarovm" nil (((f r i: v e: r o v e: m) 0)))
("freewarovmu" nil (((f r i: v e: r o v e: m u) 0)))
("freewarov" nil (((f r i: v e: r o v j e) 0)))
("freewarov" nil (((f r i: v e: r o v i:) 0)))
("freewarov" nil (((f r i: v e: r o v i:) 0)))
("freewarovch" nil (((f r i: v e: r o v i: ch) 0)))
("freewarovm" nil (((f r i: v e: r o v i: m) 0)))
("freewarovma" nil (((f r i: v e: r o v i: m a) 0)))
("freewarovmi" nil (((f r i: v e: r o v i: m i) 0)))
("freewaru" nil (((f r i: v e: r u) 0)))
("freewary" nil (((f r i: v e: r i) 0)))
("freewar" nil (((f r i: v e: r u:) 0)))
("freewarm" nil (((f r i: v e: r u: m) 0)))
("hardware" nil (((h a r d v e: r) 0)))
("hardwarech" nil (((h a r d v e: r e ch) 0)))
("hardwarem" nil (((h a r d v e: r e m) 0)))
("hardwarovou" nil (((h a r d v e: r o v o u) 0)))
("hardwarov" nil (((h a r d v e: r o v a:) 0)))
("hardwarov" nil (((h a r d v e: r o v e:) 0)))
("hardwarovho" nil (((h a r d v e: r o v e: h o) 0)))
("hardwarovm" nil (((h a r d v e: r o v e: m) 0)))
("hardwarovmu" nil (((h a r d v e: r o v e: m u) 0)))
("hardwarov" nil (((h a r d v e: r o v j e) 0)))
("hardwarov" nil (((h a r d v e: r o v i:) 0)))
("hardwarov" nil (((h a r d v e: r o v i:) 0)))
("hardwarovch" nil (((h a r d v e: r o v i: ch) 0)))
("hardwarovm" nil (((h a r d v e: r o v i: m) 0)))
("hardwarovma" nil (((h a r d v e: r o v i: m a) 0)))
("hardwarovmi" nil (((h a r d v e: r o v i: m i) 0)))
("hardwaru" nil (((h a r d v e: r u) 0)))
("hardwary" nil (((h a r d v e: r i) 0)))
("hardwar" nil (((h a r d v e: r u:) 0)))
("hardwarm" nil (((h a r d v e: r u: m) 0)))
("pst" nil (((p s t) 0)))
("shareware" nil (((s~ e: r v e: r) 0)))
("sharewarech" nil (((s~ e: r v e: r e ch) 0)))
("sharewarem" nil (((s~ e: r v e: r e m) 0)))
("sharewarovou" nil (((s~ e: r v e: r o v o u) 0)))
("sharewarov" nil (((s~ e: r v e: r o v a:) 0)))
("sharewarov" nil (((s~ e: r v e: r o v e:) 0)))
("sharewarovho" nil (((s~ e: r v e: r o v e: h o) 0)))
("sharewarovm" nil (((s~ e: r v e: r o v e: m) 0)))
("sharewarovmu" nil (((s~ e: r v e: r o v e: m u) 0)))
("sharewarov" nil (((s~ e: r v e: r o v j e) 0)))
("sharewarov" nil (((s~ e: r v e: r o v i:) 0)))
("sharewarov" nil (((s~ e: r v e: r o v i:) 0)))
("sharewarovch" nil (((s~ e: r v e: r o v i: ch) 0)))
("sharewarovm" nil (((s~ e: r v e: r o v i: m) 0)))
("sharewarovma" nil (((s~ e: r v e: r o v i: m a) 0)))
("sharewarovmi" nil (((s~ e: r v e: r o v i: m i) 0)))
("sharewaru" nil (((s~ e: r v e: r u) 0)))
("sharewary" nil (((s~ e: r v e: r i) 0)))
("sharewar" nil (((s~ e: r v e: r u:) 0)))
("sharewarm" nil (((s~ e: r v e: r u: m) 0)))
("shift" nil (((s~ i f t) 0)))
("shluk" nil (((z h l u k) 0)))
("shora" nil (((z h o r a) 0)))
("shry" nil (((z h u: r i) 0)))
("software" nil (((s o f t v e: r) 0)))
("softwarech" nil (((s o f t v e: r e ch) 0)))
("softwarem" nil (((s o f t v e: r e m) 0)))
("softwarovou" nil (((s o f t v e: r o v o u) 0)))
("softwarov" nil (((s o f t v e: r o v a:) 0)))
("softwarov" nil (((s o f t v e: r o v e:) 0)))
("softwarovho" nil (((s o f t v e: r o v e: h o) 0)))
("softwarovm" nil (((s o f t v e: r o v e: m) 0)))
("softwarovmu" nil (((s o f t v e: r o v e: m u) 0)))
("softwarov" nil (((s o f t v e: r o v j e) 0)))
("softwarov" nil (((s o f t v e: r o v i:) 0)))
("softwarov" nil (((s o f t v e: r o v i:) 0)))
("softwarovch" nil (((s o f t v e: r o v i: ch) 0)))
("softwarovm" nil (((s o f t v e: r o v i: m) 0)))
("softwarovma" nil (((s o f t v e: r o v i: m a) 0)))
("softwarovmi" nil (((s o f t v e: r o v i: m i) 0)))
("softwaru" nil (((s o f t v e: r u) 0)))
("softwary" nil (((s o f t v e: r i) 0)))
("softwar" nil (((s o f t v e: r u:) 0)))
("softwarm" nil (((s o f t v e: r u: m) 0)))
("syntetizr" nil (((s i n t e t i z e: r) 0)))
("syntetizrm" nil (((s i n t e t i z e: r u: m) 0)))
