# FIAIF is an Intelligent firewall
#
# description: Automates a packet filtering firewall with iptables.
#
# Script Author: Anders Fugmann <afu at fugmann dot net>
# 
# FIAIF is an Intelligent firewall
# Copyright (C) 2002-2011 Anders Peter Fugmann
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

###############################################################################
# Constants 
###############################################################################
declare -r CONF_FILE=${FIAIF_CONF:-/etc/fiaif/fiaif.conf}
declare -r FIAIF_STATE_FILE=/var/lib/fiaif/fiaif
declare -r NETFILTER_STATE_FILE=/var/lib/fiaif/iptables
declare -r PROC_STATE_FILE=/var/lib/fiaif/sysctl
declare -r SUBSYS_FILE=/var/lock/subsys/fiaif
declare -r FIAIF_SHARED=/usr/share/fiaif/
declare -r VERSION_FILE=${FIAIF_SHARED}/VERSION

declare -r BUILT_IN_CHAINS_nat="PREROUTING OUTPUT POSTROUTING"
declare -r BUILT_IN_CHAINS_mangle="PREROUTING INPUT FORWARD OUTPUT POSTROUTING"
declare -r BUILT_IN_CHAINS_filter="INPUT FORWARD OUTPUT"

declare -r LOG_ACCEPT_TARGETS="ACCEPT LIMIT_ACCEPT"
declare -r LOG_DROP_TARGETS="MARTIAN DROP INVALID MISS ZONE_MISS \
                             LIMIT_DROP SYN SCAN GLOBAL_MISS"
declare -r LOG_REJECT_TARGETS="REJECT LIMIT_REJECT"
declare -r LOG_TARGETS="WATCH TEST LOG"

declare -r STANDARD_TARGETS="ACCEPT REJECT DROP"

declare -r -i MAX_MULTI_PORTS=15

if [ -f /proc/net/ip_tables_names ]; then
    declare -r TABLES=$(cat /proc/net/ip_tables_names)
else
    declare -r TABLES="filter nat mangle"
fi

if [ ! -d /var/lock/subsys ]; then
    mkdir -p /var/lock/subsys
fi


###############################################################################
# Global Variables 
###############################################################################
LINUX_VERSION=$(uname -a | cut -d" " -f 3)
declare -ri MAJOR=$(echo ${LINUX_VERSION} | cut -d"." -f 1)
declare -ri MINOR=$(echo ${LINUX_VERSION} | cut -d"." -f 2)
declare -ri RELEASE=$(echo ${LINUX_VERSION} | cut -d"." -f 3 | sed "s/\([[:digit:]]*\).*/\1/")
#if [ ${MAJOR} -gt 2 -o ${MINOR} -gt 4 -o ${RELEASE} -ge 18 ]; then
iptables -t mangle -L POSTROUTING > /dev/null 2>&1
if (( $? == 0 )); then
    declare -ri EXTENDED_MANGLE=1
else
    declare -ri EXTENDED_MANGLE=0
fi

###############################################################################
# Proc check constants 
###############################################################################
declare -ri TCP_FIN_TIMEOUT=60

###############################################################################
# Function check
###############################################################################

#Test how to resolve ip's
type dnsname &> /dev/null
if (( $? == 0 )); then
    DNS_RESOLVE="dnsname"
else
    DNS_RESOLVE="dig +short +tries=1 +noauthority -x"
fi
declare -r DNS_RESOLVE

