  std::cout << "#!/bin/sh" << std::endl;
  std::cout << "# - makefdeps -" << std::endl;
  std::cout << "# Creates make-dependencies for fortran sources, based on" << std::endl;
  std::cout << "# analysis by findent of (sub)modules that are needed or created and" << std::endl;
  std::cout << "# include files. Include files are not further analyzed." << std::endl;
  std::cout << "# Dependencies will be like:" << std::endl;
  std::cout << "# prog.o: sub1.o sub2.o" << std::endl;
  std::cout << "# prog.o: file1.inc file2.inc" << std::endl;
  std::cout << "# Example:" << std::endl;
  std::cout << "# makefdeps *.f90 > deps" << std::endl;
  std::cout << "usage()" << std::endl;
  std::cout << "{" << std::endl;
  std::cout << "   echo \"usage:\"" << std::endl;
  std::cout << "   echo \"$0 [-s objectsuffix] fortansources ...\"" << std::endl;
  std::cout << "   echo \"objectsuffix: default '.o'\"" << std::endl;
  std::cout << "   echo \"depending on your make system, '.lo' can be the correct one\"" << std::endl;
  std::cout << "   exit 1" << std::endl;
  std::cout << "}" << std::endl;
  std::cout << "FINDENTPROG=${FINDENT:-findent}" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "O='.o'" << std::endl;
  std::cout << "if [ \"$1\" = \"-s\" ] ; then" << std::endl;
  std::cout << "   O=\"$2\"" << std::endl;
  std::cout << "   shift; shift" << std::endl;
  std::cout << "fi" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "while [ \"$1\" ] ; do" << std::endl;
  std::cout << "   j=${1%.*}$O" << std::endl;
  std::cout << "   $FINDENTPROG --deps < $1 | awk -v name=\"$j\" '{ print $0, name}' " << std::endl;
  std::cout << "   shift" << std::endl;
  std::cout << "done | " << std::endl;
  std::cout << "awk '/^use /{use[$3] = use[$3] \" \" $2}" << std::endl;
  std::cout << "     /^mod |^sub /{ if (NF == 3) {module[$2] = $3}} " << std::endl;
  std::cout << "     /^inc |^cpp |^coc |^std / {include[$3] = include[$3] \" \" $2}" << std::endl;
  std::cout << "END { " << std::endl;
  std::cout << "      for (k in use) " << std::endl;
  std::cout << "      {" << std::endl;
  std::cout << "	  m = \"\"" << std::endl;
  std::cout << "	  split(use[k],u)" << std::endl;
  std::cout << "	  for (l in u) { " << std::endl;
  std::cout << "	     m=m \" \" module[u[l]]" << std::endl;
  std::cout << "	     }" << std::endl;
  std::cout << "	  mm = m; gsub(\" \",\"\",mm)" << std::endl;
  std::cout << "	  if (length(mm) != 0) { " << std::endl;
  std::cout << "	     while (gsub(\"  \",\" \",m)){}" << std::endl;
  std::cout << "	     sub(\"^ \",\"\",m)" << std::endl;
  std::cout << "	     print k \": \" m " << std::endl;
  std::cout << "	  }" << std::endl;
  std::cout << "      }" << std::endl;
  std::cout << "      for (k in include) { " << std::endl;
  std::cout << "         while(sub(\"^ \",\"\",include[k])){}" << std::endl;
  std::cout << "         print k \": \" include[k] " << std::endl;
  std::cout << "      }" << std::endl;
  std::cout << "    }'" << std::endl;
