$!#################################################################
$!#                                                               #
$!#       Copyright 2010, 2012 Fidelity Information Services, Inc #
$!#                                                               #
$!#       This source code contains the intellectual property     #
$!#       of its copyright holder(s), and is made available       #
$!#       under a license.  If you do not know the terms of       #
$!#       the license, please stop and do not read further.       #
$!#                                                               #
$!#################################################################
$!
$ set noon
$ savedir = f$environment("DEFAULT")
$!
$! Generate gtm_threadgbl_deftypes.h from gtm_threadgbl_deftypes.c. The result is a list of
$! #defines for the (real) types of the neutral-typed vars in the gtm_threadgbl structure. The
$! vars are neutral so not all types have to be defined in all modules. This mechanism allows
$! us to type only the vars used in the module.
$!
$! First setup the compile options and commands we need
$!
$ common_options := /standard=vaxc/share/assume=nowrit/float=g_float/inc=(here:,gtm$src:)/warn=disable=(signedknown,signedmember,questcompare,questcompare1)
$ ccdbg :== cc'common_options'/define=(debug,nolicense)/debug/nooptimize
$ ccpro :== cc'common_options'
$!
$! We need to build this table twice - once for pro and once for dbg because the elements in the
$! table could be different sizes. So setup the necessary #ifdefs so the proper set is selected
$! when the module is built. One complication is that gtm_malloc_src.h gets built both as PRO and
$! DBG in the same module for a pro build. The DEBUG flag is overridden and the PRO build is
$! selected is PRO_BUILD is defined (set by gtm_malloc_dbg.c).
$!
$ set def gtm$obj
$ if $severity .ne. 1
$ then
$   write sys$output "gen_gtm_threadgbl_deftypes.com-E-: Unable to switch to gtm$obj - ERROR"
$   set def 'savedir'
$   exit 2
$ endif
$ if f$search("gtm_threadgbl_deftypes.h") .nes. "" then delete/nolog gtm_threadgbl_deftypes.h.*
$ if f$search("gtm_threadgbl_deftypes.h") .nes. ""
$ then
$   write sys$output "gen_gtm_threadgbl_deftypes.com-E-: Unable to delete old gtm$obj:gtm_threadgbl_deftypes.h - ERROR"
$   set def 'savedir'
$   exit 2
$ endif
$!
$! Create gtm_threadgbl_deftypes.h file - create in gtm$obj first so we don't replace the gtm$src version
$! until/unless we know it is replaceable.
$!
$ year = f$extract(7, 4, f$time())
$ open/share/write ofile gtm_threadgbl_deftypes.h
$ write ofile "/******************************************************************"
$ write ofile " *								  *"
$ write ofile " *	Copyright 2010, ''year' Fidelity Information Services, Inc	  *"
$ write ofile " *								  *"
$ write ofile " *	This source code contains the intellectual property	  *"
$ write ofile " *	of its copyright holder(s), and is made available	  *"
$ write ofile " *	under a license.  If you do not know the terms of	  *"
$ write ofile " *	the license, please stop and do not read further.	  *"
$ write ofile " *								  *"
$ write ofile " ******************************************************************/"
$ write ofile " "
$ write ofile "#ifndef GTM_THREADGBL_DEFTYPES_INCLUDED"
$ write ofile "#define GTM_THREADGBL_DEFTYPES_INCLUDED"
$ gtmvrt = f$trnlmn("gtm$vrt")
$ gtmtools = f$extract(0,f$length(gtmvrt)-1,gtmvrt)
$ write ofile "/* Generated by ''gtmtools'TOOLS]gen_gtm_threadgbl_deftypes.com */"
$!
$! Output selection criteria for PRO build
$!
$ write ofile " "
$ write ofile "#if !defined(DEBUG) || defined(PRO_BUILD)"
$!
$! Now do pro build/run
$!
$ ccpro gtm$src:gtm_threadgbl_deftypes.c
$ if 1 .ne. $severity
$ then
$   write sys$output "gen_gtm_threadgbl_deftypes.com-E-: pro build of gtm$obj:gtm_threadgbl_deftypes failed - ERROR"
$   set def 'savedir'
$   exit 2
$ endif
$ link/map=gtm_threadgbl_deftypes.map/full/exe=gtm_threadgbl_deftypes gtm_threadgbl_deftypes.obj
$ if 1 .ne. $severity
$ then
$   write sys$output "gen_gtm_threadgbl_deftypes.com-E-: pro build link of gtm$obj/gtm_threadgbl_deftypes failed. See gtm$obj:gtm_threadgbl_deftypes.map - ERROR"
$   set def 'savedir'
$   exit 2
$ endif
$ define/user/nolog sys$output ofile
$ run gtm_threadgbl_deftypes
$ if 1 .ne. $severity
$ then
$   write sys$output "gen_gtm_threadgbl_deftypes.com-E-: generating pro output failed - ERROR"
$   set def 'savedir'
$   exit 2
$ endif
$ write ofile "#else"
$!
$! Do debug build
$!
$ ccdbg gtm$src:gtm_threadgbl_deftypes.c
$ if 1 .ne. $severity
$ then
$   write sys$output "gen_gtm_threadgbl_deftypes.com-E-: dbg build of gtm$obj:gtm_threadgbl_deftypes failed - ERROR"
$   set def 'savedir'
$   exit 2
$ endif
$ link/map=gtm_threadgbl_deftypes.map/full/exe=gtm_threadgbl_deftypes gtm_threadgbl_deftypes.obj
$ if 1 .ne. $severity
$ then
$   write "gen_gtm_threadgbl_deftypes.com-E-: dbg build link of gtm$obj/gtm_threadgbl_deftypes failed. See gtm$obj:gtm_threadgbl_deftypes.map - ERROR"
$   set def 'savedir'
$   exit 2
$ endif
$ define/user/nolog sys$output ofile
$ run gtm_threadgbl_deftypes
$ if 1 .ne. $severity
$ then
$   write sys$output "gen_gtm_threadgbl_deftypes.com-E-: generating dbg output failed - ERROR"
$   set def 'savedir'
$   exit 2
$ endif
$ write ofile "#endif"
$ write ofile "#endif"
$ close ofile
$!
$! Make sure it is there
$!
$ if f$search("gtm_threadgbl_deftypes.h") .eqs. ""
$ then
$   write sys$output "gen_gtm_threadgbl_deftypes.com-E-: Unable to generate new gtm$obj:gtm_threadgbl_deftypes.h - ERROR"
$   set def 'savedir'
$   exit 2
$ endif
$!
$! See if it is different from the one in gtm$src (or if the gtm$src one is not there). Only move it there if
$! needed to prevent unneeded re-compiles of the world.
$!
$ keepold = 0
$ if f$search("gtm$src:gtm_threadgbl_deftypes.h") .nes. ""
$ then
$   diff/output=gtm_threadgbl_deftypes.diff gtm$src:gtm_threadgbl_deftypes.h gtm$obj:gtm_threadgbl_deftypes.h
$   if $severity .eq. 1 then keepold = 1
$ endif
$ if keepold .eq. 0 then copy /nolog gtm_threadgbl_deftypes.h gtm$src:
$ if 1 .ne. $severity
$ then
$   write sys$output "gen_gtm_threadgbl_deftypes.com-E-: Unable to copy/replace gtm$src:gtm_threadgbl_deftypes.h - ERROR"
$   set def 'savedir'
$   exit 2
$ endif
$!
$ if f$search("gtm_threadgbl_deftypes.exe") .nes. "" then delete/nolog gtm_threadgbl_deftypes.exe.*
$ if f$search("gtm_threadgbl_deftypes.obj") .nes. "" then delete/nolog gtm_threadgbl_deftypes.obj.*
$ if f$search("gtm_threadgbl_deftypes.map") .nes. "" then delete/nolog gtm_threadgbl_deftypes.map.*
$ if f$search("gtm_threadgbl_deftypes.diff") .nes. "" then delete/nolog gtm_threadgbl_deftypes.diff.*
$ set def 'savedir'
$ exit 1
