/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.sunsecure;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.ast.ASTBlockStatement;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTEqualityExpression;
import net.sourceforge.pmd.ast.ASTExpression;
import net.sourceforge.pmd.ast.ASTFormalParameter;
import net.sourceforge.pmd.ast.ASTFormalParameters;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.ASTStatementExpression;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.rules.sunsecure.AbstractSunSecureRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIsStoredDirectly
extends AbstractSunSecureRule {
    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        ASTFormalParameter[] arrs = this.getArrays(node.getParameters());
        if (arrs != null) {
            List<ASTBlockStatement> bs = node.findChildrenOfType(ASTBlockStatement.class);
            this.checkAll(data, arrs, bs);
        }
        return data;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        ASTFormalParameters params = node.getFirstChildOfType(ASTFormalParameters.class);
        ASTFormalParameter[] arrs = this.getArrays(params);
        if (arrs != null) {
            this.checkAll(data, arrs, node.findChildrenOfType(ASTBlockStatement.class));
        }
        return data;
    }

    private void checkAll(Object context, ASTFormalParameter[] arrs, List<ASTBlockStatement> bs) {
        for (int i = 0; i < arrs.length; ++i) {
            this.checkForDirectAssignment(context, arrs[i], bs);
        }
    }

    private boolean checkForDirectAssignment(Object ctx, ASTFormalParameter parameter, List<ASTBlockStatement> bs) {
        ASTVariableDeclaratorId vid = parameter.getFirstChildOfType(ASTVariableDeclaratorId.class);
        String varName = vid.getImage();
        for (ASTBlockStatement b : bs) {
            ASTPrimarySuffix foo;
            ASTExpression e;
            SimpleNode n;
            ASTStatementExpression se;
            if (!b.containsChildOfType(ASTAssignmentOperator.class) || (se = b.getFirstChildOfType(ASTStatementExpression.class)) == null || !(se.jjtGetChild(0) instanceof ASTPrimaryExpression)) continue;
            ASTPrimaryExpression pe = (ASTPrimaryExpression)se.jjtGetChild(0);
            String assignedVar = this.getFirstNameImage(pe);
            if (assignedVar == null) {
                ASTPrimarySuffix suffix = se.getFirstChildOfType(ASTPrimarySuffix.class);
                if (suffix == null) continue;
                assignedVar = suffix.getImage();
            }
            if ((n = (SimpleNode)pe.getFirstParentOfType(ASTMethodDeclaration.class)) == null && (n = (SimpleNode)pe.getFirstParentOfType(ASTConstructorDeclaration.class)) == null || this.isLocalVariable(assignedVar, n) || se.jjtGetNumChildren() < 3 || (e = (ASTExpression)se.jjtGetChild(2)).findChildrenOfType(ASTEqualityExpression.class).size() > 0) continue;
            String val = this.getFirstNameImage(e);
            if (val == null) {
                foo = se.getFirstChildOfType(ASTPrimarySuffix.class);
                if (foo == null) continue;
                val = foo.getImage();
            }
            if (val == null || (foo = se.getFirstChildOfType(ASTPrimarySuffix.class)) != null && foo.isArrayDereference() || !val.equals(varName)) continue;
            SimpleNode md = parameter.getFirstParentOfType(ASTMethodDeclaration.class);
            if (md == null) {
                md = pe.getFirstParentOfType(ASTConstructorDeclaration.class);
            }
            if (this.isLocalVariable(varName, md)) continue;
            this.addViolation(ctx, parameter, varName);
        }
        return false;
    }

    private final ASTFormalParameter[] getArrays(ASTFormalParameters params) {
        List<ASTFormalParameter> l = params.findChildrenOfType(ASTFormalParameter.class);
        if (l != null && !l.isEmpty()) {
            ArrayList<ASTFormalParameter> l2 = new ArrayList<ASTFormalParameter>();
            for (ASTFormalParameter fp : l) {
                if (!fp.isArray()) continue;
                l2.add(fp);
            }
            return l2.toArray(new ASTFormalParameter[l2.size()]);
        }
        return null;
    }
}

