#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "FXHash.h"
#include "FXStream.h"
#include "FXTextCodec.h"
#include "FXCP856Codec.h"

namespace FX {

FXIMPLEMENT(FXCP856Codec,FXTextCodec,NULL,0)


//// Created by codec tool on 03/25/2005 from: CP856.TXT ////
static const unsigned short forward_data[256]={
   0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,   13,   14,   15,
   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,   100,  101,  102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
   112,  113,  114,  115,  116,  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,
   1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499, 1500, 1501, 1502, 1503,
   1504, 1505, 1506, 1507, 1508, 1509, 1510, 1511, 1512, 1513, 1514, 65533, 163,  65533, 215,  65533,
   65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 174,  172,  189,  188,  65533, 171,  187,
   9617, 9618, 9619, 9474, 9508, 65533, 65533, 65533, 169,  9571, 9553, 9559, 9565, 162,  165,  9488,
   9492, 9524, 9516, 9500, 9472, 9532, 65533, 65533, 9562, 9556, 9577, 9574, 9568, 9552, 9580, 164,
   65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 65533, 9496, 9484, 9608, 9604, 166,  65533, 9600,
   65533, 65533, 65533, 65533, 65533, 65533, 181,  65533, 65533, 65533, 65533, 65533, 65533, 65533, 175,  180,
   173,  177,  8215, 190,  182,  167,  247,  184,  176,  168,  183,  185,  179,  178,  9632, 160,
  };


static const unsigned char reverse_plane[17]={
  0, 10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
  };

static const unsigned char reverse_pages[74]={
  0,  35, 66, 66, 66, 66, 66, 66, 129,177,66, 66, 66, 66, 66, 66,
  66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66,
  66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66,
  66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66,
  66, 66, 66, 66, 66, 66, 66, 66, 66, 66,
  };

static const unsigned short reverse_block[241]={
  0,   16,  32,  48,  64,  80,  96,  112, 128, 128, 144, 160, 128, 175, 128, 184,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  200, 216, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 227, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 243, 259, 272, 285, 128, 301, 317, 128, 333, 348, 364, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128,
  };

static const unsigned char reverse_data[380]={
   0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,   13,   14,   15,
   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,   100,  101,  102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
   112,  113,  114,  115,  116,  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,
   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
   255,  26,   189,  156,  207,  190,  221,  245,  249,  184,  26,   174,  170,  240,  169,  238,
   248,  241,  253,  252,  239,  230,  244,  250,  247,  251,  26,   175,  172,  171,  243,  26,
   26,   26,   26,   26,   26,   26,   158,  26,   26,   26,   26,   26,   26,   26,   26,   246,
   26,   26,   26,   26,   26,   26,   26,   26,   128,  129,  130,  131,  132,  133,  134,  135,
   136,  137,  138,  139,  140,  141,  142,  143,  144,  145,  146,  147,  148,  149,  150,  151,
   152,  153,  154,  26,   26,   26,   26,   26,   26,   26,   242,  26,   26,   26,   26,   26,
   26,   26,   26,   196,  26,   179,  26,   26,   26,   26,   26,   26,   26,   26,   26,   218,
   26,   26,   26,   191,  26,   26,   26,   192,  26,   26,   26,   217,  26,   26,   26,   195,
   26,   26,   26,   26,   180,  26,   26,   26,   26,   26,   26,   26,   194,  26,   26,   26,
   26,   193,  26,   26,   26,   26,   26,   26,   26,   197,  26,   26,   26,   205,  186,  26,
   26,   201,  26,   26,   187,  26,   26,   200,  26,   26,   188,  26,   26,   204,  26,   26,
   185,  26,   26,   203,  26,   26,   202,  26,   26,   206,  26,   26,   26,   223,  26,   26,
   26,   220,  26,   26,   26,   219,  26,   26,   26,   26,   26,   26,   26,   176,  177,  178,
   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   254,  26,   26,   26,
   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
  };


FXint FXCP856Codec::mb2wc(FXwchar& wc,const FXchar* src,FXint nsrc) const {
  if(nsrc<1) return -1;
  wc=forward_data[(FXuchar)src[0]];
  return 1;
  }


FXint FXCP856Codec::wc2mb(FXchar* dst,FXint ndst,FXwchar wc) const {
  if(ndst<1) return -1;
  dst[0]=reverse_data[reverse_block[reverse_pages[reverse_plane[wc>>16]+((wc>>10)&63)]+((wc>>4)&63)]+(wc&15)];
  return 1;
  }

FXint FXCP856Codec::mibEnum() const {
  return 5;
  }


const FXchar* FXCP856Codec::name() const {
  return "IBM856";
  }


const FXchar* FXCP856Codec::mimeName() const {
  return "IBM856";
  }


const FXchar* const* FXCP856Codec::aliases() const {
  static const FXchar *const list[]={"microsoft-cp856","IBM856","cp856","856","csIBM856","microsoft-cp856",NULL};
  return list;
  }

}

