#!/usr/bin/python
import os
import sys

def writeloader(dirname,gfuncs,classdefs,loadername,outdir):
    g = open(os.path.join(outdir,'Loader.cpp'),'w')
    g.write("// WARNING - This file is automatically generated by\n");
    g.write("// the siggen.py script in tools.  Do not\n");
    g.write("// edit it by hand, or changes will be lost!  If you\n");
    g.write("// need to add a built in function to FreeMat, add a\n");
    g.write("// signature block to its documentation and rerun siggen.\n");
    g.write("\n\n// First each function gets prototyped.\n");
    g.write('#include "Array.hpp"\n');
    g.write('#include "Context.hpp"\n');
    g.write('#include "Class.hpp"\n');
    g.write("\n\n");
    for fnc in gfuncs:
        if (fnc["type"] == "function"):
            g.write('ArrayVector %s(int, const ArrayVector&);\n'%fnc["internal_name"])
        elif (fnc["type"] == "sfunction"):
            g.write('ArrayVector %s(int, const ArrayVector&, Interpreter*);\n'%fnc["internal_name"])
        elif (fnc["type"] == "gfunction"):
            g.write('ArrayVector %s(int, const ArrayVector&);\n'%fnc["internal_name"])
        elif (fnc["type"] == "sgfunction"):
            g.write('ArrayVector %s(int, const ArrayVector&, Interpreter*);\n'%fnc["internal_name"])
    funcmapping = {"function":"Function","sfunction":"SpecialFunction","gfunction":"GfxFunction","sgfunction":"GfxSpecialFunction"};
    g.write('\n\nvoid LoadBuiltinFunctions%s(Context *context, bool guiflag) {\n'%(loadername));
    for fnc in gfuncs:
        if (fnc["type"] == "gfunction" or fnc["type"] == "sgfunction"):
            g.write('  if (guiflag)')
        g.write('  context->add%s("%s",%s,%d,'%(funcmapping[fnc["type"]],fnc["name"],fnc["internal_name"],fnc["jitsafe"]))
        if fnc["inputs"][0]=='none':
            input_count = 0
        elif fnc["inputs"][len(fnc["inputs"])-1]=='varargin':
            input_count = -1
        else:
            input_count = len(fnc["inputs"])
        if fnc["outputs"][0]=='none':
            output_count = 0
        elif fnc["outputs"][len(fnc["outputs"])-1]=='varargout':
            output_count = -1
        else:
            output_count = len(fnc["outputs"])
        g.write('%d,%d,'%(input_count,output_count))
        if (input_count > 0):
            for p in fnc["inputs"]:
                g.write('"%s",'%(p))
        g.write('NULL);\n');
    g.write('\n\n// Writing hierarchy definitions for classes\n');
    for cls in classdefs:
        targetclass = cls[0]
        parentclasses = cls[1:]
        g.write('  defineHierarchyForClass("%s",StringVector() '%(targetclass))
        for p in parentclasses:
          g.write('<< "%s" '%(p));
        g.write(');\n');
    g.write('}\n\n');


dirname = sys.argv[1]
names = os.listdir(dirname)
gfuncs = [];
classdefs = [];
for name in names:
    (root, ext) = os.path.splitext(name)
    if ext == '.cpp':
        fullpath = os.path.join(dirname,name)
        f = open(fullpath,'r')
        line = ' '
        while line != '':
            line = f.readline()
            if (line.startswith("//@@Signature")):
                fline = f.readline().rstrip()
                iline = f.readline()
                oline = f.readline()
                fsplit = fline.split()
                jitsafe = 0;
                if ((len(fsplit) > 3) and (fsplit[3] == 'jitsafe')):
                    jitsafe = 1
                function_type = fsplit[0][2:]
                function_name = fsplit[1]
                function_internal_name = fsplit[2];
                if (function_name == '') or (function_internal_name == ''):
                    print 'MISSING Function Name: <%s> <%s> <%s>'%(fline,function_name,function_internal_name)
                inputs = iline.split()
                inputs = inputs[1:]
                outputs = oline.split()
                outputs = outputs[1:]
                data = {"type": function_type,
                        "name": function_name,
                        "internal_name": function_internal_name,
                        "inputs": inputs,
                        "outputs": outputs,
                        "jitsafe": jitsafe}
                gfuncs.append(data);
            if (line.startswith("//@@Parents")):
                classes = line.split()
                classes = classes[1:]
                classdefs.append(classes)
        f.close()
if (len(gfuncs) > 0):
    writeloader(sys.argv[1],gfuncs,classdefs,sys.argv[2],sys.argv[3])
