// 2007-02-04  Edward Smith-Rowland <3dw4rd@verizon.net>
//
// Copyright (C) 2007-2016 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

//  expint


//  Compare against values generated by the GNU Scientific Library.
//  The GSL can be found on the web: http://www.gnu.org/software/gsl/

#include <tr1/cmath>
#if defined(__TEST_DEBUG)
#include <iostream>
#define VERIFY(A) \
if (!(A)) \
  { \
    std::cout << "line " << __LINE__ \
      << "  max_abs_frac = " << max_abs_frac \
      << std::endl; \
  }
#else
#include <testsuite_hooks.h>
#endif
#include "../testcase.h"


// Test data.
testcase_expint<double> data001[] = {
  { -3.7832640295504591e-24, -50.000000000000000 },
  { -1.0489811642368024e-23, -49.000000000000000 },
  { -2.9096641904058423e-23, -48.000000000000000 },
  { -8.0741978427258127e-23, -47.000000000000000 },
  { -2.2415317597442998e-22, -46.000000000000000 },
  { -6.2256908094623838e-22, -45.000000000000000 },
  { -1.7299598742816476e-21, -44.000000000000000 },
  { -4.8094965569500181e-21, -43.000000000000000 },
  { -1.3377908810011775e-20, -42.000000000000000 },
  { -3.7231667764599780e-20, -41.000000000000000 },
  { -1.0367732614516570e-19, -40.000000000000000 },
  { -2.8887793015227007e-19, -39.000000000000000 },
  { -8.0541069142907499e-19, -38.000000000000000 },
  { -2.2470206975885714e-18, -37.000000000000000 },
  { -6.2733390097622421e-18, -36.000000000000000 },
  { -1.7527059389947371e-17, -35.000000000000000 },
  { -4.9006761183927874e-17, -34.000000000000000 },
  { -1.3713843484487468e-16, -33.000000000000000 },
  { -3.8409618012250666e-16, -32.000000000000000 },
  { -1.0767670386162383e-15, -31.000000000000000 },
  { -3.0215520106888128e-15, -30.000000000000000 },
  { -8.4877597783535618e-15, -29.000000000000000 },
  { -2.3869415119337330e-14, -28.000000000000000 },
  { -6.7206374352620390e-14, -27.000000000000000 },
  { -1.8946858856749785e-13, -26.000000000000000 },
  { -5.3488997553402167e-13, -25.000000000000000 },
  { -1.5123058939997059e-12, -24.000000000000000 },
  { -4.2826847956656722e-12, -23.000000000000000 },
  { -1.2149378956204371e-11, -22.000000000000000 },
  { -3.4532012671467559e-11, -21.000000000000000 },
  { -9.8355252906498815e-11, -20.000000000000000 },
  { -2.8078290970607954e-10, -19.000000000000000 },
  { -8.0360903448286769e-10, -18.000000000000000 },
  { -2.3064319898216547e-09, -17.000000000000000 },
  { -6.6404872494410427e-09, -16.000000000000000 },
  { -1.9186278921478670e-08, -15.000000000000000 },
  { -5.5656311111451816e-08, -14.000000000000000 },
  { -1.6218662188014328e-07, -13.000000000000000 },
  { -4.7510818246724931e-07, -12.000000000000000 },
  { -1.4003003042474418e-06, -11.000000000000000 },
  { -4.1569689296853246e-06, -10.000000000000000 },
  { -1.2447354178006272e-05, -9.0000000000000000 },
  { -3.7665622843924906e-05, -8.0000000000000000 },
  { -0.00011548173161033820, -7.0000000000000000 },
  { -0.00036008245216265867, -6.0000000000000000 },
  { -0.0011482955912753257, -5.0000000000000000 },
  { -0.0037793524098489058, -4.0000000000000000 },
  { -0.013048381094197037, -3.0000000000000000 },
  { -0.048900510708061125, -2.0000000000000000 },
  { -0.21938393439552029, -1.0000000000000000 },
};

// Test function.
template <typename Tp>
void test001()
{
  const Tp eps = std::numeric_limits<Tp>::epsilon();
  Tp max_abs_diff = -Tp(1);
  Tp max_abs_frac = -Tp(1);
  unsigned int num_datum = sizeof(data001)
                         / sizeof(testcase_expint<double>);
  for (unsigned int i = 0; i < num_datum; ++i)
    {
      const Tp f = std::tr1::expint(Tp(data001[i].x));
      const Tp f0 = data001[i].f0;
      const Tp diff = f - f0;
      if (std::abs(diff) > max_abs_diff)
        max_abs_diff = std::abs(diff);
      if (std::abs(f0) > Tp(10) * eps
       && std::abs(f) > Tp(10) * eps)
        {
          const Tp frac = diff / f0;
          if (std::abs(frac) > max_abs_frac)
            max_abs_frac = std::abs(frac);
        }
    }
  VERIFY(max_abs_frac < Tp(2.5000000000000020e-13));
}

int main(int, char**)
{
  test001<double>();
  return 0;
}
