/*
 * Copyright 2025 Nico Sonack <nsonack@herrhotzenplotz.de>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following
 * disclaimer in the documentation and/or other materials provided
 * with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <gcli/gcli.h>
#include <gcli/path.h>
#include <gcli/port/string.h>
#include <gcli/waitproc.h>

#include <stdlib.h>
#include <unistd.h>

int
github_pull_checkout(struct gcli_ctx *ctx, char const *const remote,
                     struct gcli_path const *const path)
{
	/* FIXME: this is more than not ideal! */
	char *remote_ref, *local_ref, *refspec;
	int rc;
	pid_t pid;
	gcli_id pr_id;

	if (path->kind != GCLI_PATH_DEFAULT)
		return gcli_error(ctx, "unsupported path kind for checkout");

	pr_id = path->as_default.id;

	remote_ref = gcli_asprintf("refs/pull/%"PRIid"/head", pr_id);
	local_ref = gcli_asprintf("github/pr/%"PRIid, pr_id);
	refspec = gcli_asprintf("%s:%s", remote_ref, local_ref);

	pid = fork();
	if (pid < 0)
		return gcli_error(ctx, "could not fork");

	if (pid == 0) {
		rc = execlp("git", "git", "fetch", remote, refspec, NULL);
		if (rc < 0)
			exit(EXIT_FAILURE);

		/* NOTREACHED */
	}

	rc = gcli_wait_proc_ok(ctx, pid);
	if (rc < 0)
		return rc;

	gcli_clear_ptr(&remote_ref);
	gcli_clear_ptr(&refspec);

	pid = fork();
	if (pid < 0)
		return gcli_error(ctx, "could not fork");

	if (pid == 0) {
		rc = execlp("git", "git", "checkout", "--track", local_ref, NULL);
		if (rc < 0)
			exit(EXIT_FAILURE);

		/* NOTREACHED */
	}

	rc = gcli_wait_proc_ok(ctx, pid);

	gcli_clear_ptr(&local_ref);

	return rc;
}
