/*

	Byte-order invariant definitions

*/

/*  The following macros allow packing fields of various types
    into a byte-oriented packet with a running pointer named
    pktP.  The reason we store then memcpy rather than storing
    through a cast of pktP to the desired type is that the
    latter approach can result in alignment faults when run
    on RISC machines which typically require values to be
    aligned at an even multiple of their length.  */

#define packShort(x) { \
			short s = htons((short) (x)); \
			memcpy(pktP, &s, sizeof(short)); \
			pktP += sizeof(short); \
		     }

#define packLong(x) { \
			long l = htonl((long) (x)); \
			memcpy(pktP, &l, sizeof(long)); \
			pktP += sizeof(long); \
		    }

#define packByte(x) { \
			char c = (x); \
			memcpy(pktP, &c, sizeof(char)); \
			pktP += sizeof(char); \
		    }

#define packBytes(x, n) { \
			    memcpy(pktP, x, n); \
			    pktP += n; \
			}

/*  These macros unpack fields of various lengths from a
    byte-packet packet in network byte order pointed to by
    pktP.  Note that the argument of these macros must be
    an lvalue.	*/

#define unpackShort(x) { \
			    short s; \
			    memcpy(&s, pktP, sizeof(short)); \
			    pktP += sizeof(short); \
			    x = ntohs(s); \
		       }

#define unpackLong(x) { \
			   long l; \
			   memcpy(&l, pktP, sizeof(long)); \
			   pktP += sizeof(long); \
			   x = ntohl(l); \
		      }

#define unpackByte(x) { \
			*((char *) &x) = (char) *pktP++; \
		      }

#define unpackBytes(x, n) { \
			    memcpy(x, pktP, n); \
			    pktP += n; \
			  }
