/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.gui;

import geotrans3.exception.CoordinateConversionException;
import geotrans3.gui.MasterPanel;
import geotrans3.gui.ProgressDlg;
import geotrans3.gui.StartBrowser;
import geotrans3.jni.JNICoordinateConversionService;
import geotrans3.jni.JNIFiomeths;
import geotrans3.misc.FormatOptions;
import geotrans3.misc.StringHandler;
import geotrans3.utility.DATFileFilter;
import geotrans3.utility.Directory;
import geotrans3.utility.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FileDlg
extends JDialog {
    private Directory currentDir;
    private MasterPanel lowerFilePanel;
    private StringHandler stringHandler;
    private JNIFiomeths jniFiomeths;
    private JFrame parentFrame;
    private FormatOptions options;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JButton helpButton;
    private JPanel inputFilePanel;
    private JLabel inputLabel;
    private JButton okButton;
    private JPanel outputFilePanel;
    private JLabel outputLabel;

    public FileDlg(JNICoordinateConversionService jNICoordinateConversionService, JFrame jFrame, boolean bl, Directory directory, FormatOptions formatOptions, JNIFiomeths jNIFiomeths, StringHandler stringHandler) throws CoordinateConversionException {
        super((Frame)jFrame, bl);
        this.parentFrame = jFrame;
        this.currentDir = directory;
        this.jniFiomeths = jNIFiomeths;
        this.options = formatOptions;
        this.stringHandler = stringHandler;
        this.initComponents();
        MasterPanel masterPanel = new MasterPanel(jNICoordinateConversionService, jNIFiomeths.getDatumCode(), jNIFiomeths.getCoordinateSystemParameters(), 0, 0, formatOptions, stringHandler);
        this.lowerFilePanel = new MasterPanel(jNICoordinateConversionService, 1, formatOptions, stringHandler, masterPanel.getProjectionType());
        this.inputFilePanel.add((Component)masterPanel, "Center");
        this.outputFilePanel.add((Component)this.lowerFilePanel, "Center");
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        Utility.center(jFrame, this);
    }

    private void initComponents() {
        this.inputFilePanel = new JPanel();
        this.inputLabel = new JLabel();
        this.outputFilePanel = new JPanel();
        this.outputLabel = new JLabel();
        this.buttonsPanel = new JPanel();
        this.okButton = new JButton();
        this.helpButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("File Processing");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FileDlg.this.closeDialog(windowEvent);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.inputFilePanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.inputFilePanel.setMinimumSize(new Dimension(467, 197));
        this.inputFilePanel.setPreferredSize(new Dimension(467, 197));
        this.inputFilePanel.setLayout(new BorderLayout(1, 1));
        this.inputLabel.setText("INPUT");
        this.inputFilePanel.add((Component)this.inputLabel, "North");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.inputFilePanel, gridBagConstraints);
        this.outputFilePanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.outputFilePanel.setAlignmentY(1.5f);
        this.outputFilePanel.setMinimumSize(new Dimension(467, 197));
        this.outputFilePanel.setPreferredSize(new Dimension(467, 197));
        this.outputFilePanel.setLayout(new BorderLayout(1, 1));
        this.outputLabel.setText("OUTPUT");
        this.outputFilePanel.add((Component)this.outputLabel, "North");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 8;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(3, 2, 2, 2);
        this.getContentPane().add((Component)this.outputFilePanel, gridBagConstraints);
        this.buttonsPanel.setMinimumSize(new Dimension(330, 50));
        this.buttonsPanel.setPreferredSize(new Dimension(330, 50));
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.okButton.setMnemonic(79);
        this.okButton.setText("OK");
        this.okButton.setBorder(BorderFactory.createBevelBorder(0));
        this.okButton.setMaximumSize(new Dimension(80, 21));
        this.okButton.setMinimumSize(new Dimension(80, 21));
        this.okButton.setPreferredSize(new Dimension(80, 21));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileDlg.this.okActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 45);
        this.buttonsPanel.add((Component)this.okButton, gridBagConstraints);
        this.helpButton.setMnemonic(72);
        this.helpButton.setText("Help");
        this.helpButton.setBorder(BorderFactory.createBevelBorder(0));
        this.helpButton.setMaximumSize(new Dimension(80, 21));
        this.helpButton.setMinimumSize(new Dimension(80, 21));
        this.helpButton.setPreferredSize(new Dimension(80, 21));
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileDlg.this.helpActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 45);
        this.buttonsPanel.add((Component)this.helpButton, gridBagConstraints);
        this.cancelButton.setMnemonic(67);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setBorder(BorderFactory.createBevelBorder(0));
        this.cancelButton.setMaximumSize(new Dimension(80, 21));
        this.cancelButton.setMinimumSize(new Dimension(80, 21));
        this.cancelButton.setPreferredSize(new Dimension(80, 21));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileDlg.this.cancelActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.buttonsPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.getContentPane().add((Component)this.buttonsPanel, gridBagConstraints);
    }

    private void cancelActionPerformed(ActionEvent actionEvent) {
        try {
            this.jniFiomeths.closeInputFile();
        }
        catch (Exception exception) {
            this.stringHandler.displayErrorMsg(this, exception.getMessage());
        }
        finally {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void helpActionPerformed(ActionEvent actionEvent) {
        File file = new File("..");
        try {
            if (StartBrowser.isWindowsPlatform()) {
                StartBrowser.displayURL(this, "file:" + file.getCanonicalPath() + "\\help\\fileproc.htm");
            } else {
                StartBrowser.displayURL(this, "file:" + file.getCanonicalPath() + "/help/fileproc.htm");
            }
        }
        catch (Exception exception) {
            this.stringHandler.displayErrorMsg(this, "Could not invoke browser");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void okActionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.lowerFilePanel.getError()) {
                this.setVisible(false);
                JFileChooser jFileChooser = new JFileChooser(this.currentDir.getDirectory());
                jFileChooser.setDialogTitle("Save As");
                jFileChooser.addChoosableFileFilter(new DATFileFilter());
                jFileChooser.setSelectedFile(new File("*.dat"));
                int n = jFileChooser.showSaveDialog(this.parentFrame);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    this.currentDir.setDirectory(file.getAbsolutePath());
                    if (file != null) {
                        this.jniFiomeths.setUseNSEW(this.options.getUseNSEW());
                        this.jniFiomeths.setUseMinutes(this.options.getUseMinutes());
                        this.jniFiomeths.setUseSeconds(this.options.getUseSeconds());
                        this.jniFiomeths.setLatLongPrecision(this.options.getPrecision());
                        this.jniFiomeths.setLeadingZeros(this.options.getLeadingZeros());
                        this.jniFiomeths.setSeparator(this.options.getSeparator());
                        this.jniFiomeths.setLonRange(this.options.getRange());
                        if (this.lowerFilePanel.getProjectionType() == 10) {
                            this.jniFiomeths.setGeodeticCoordinateOrder(this.lowerFilePanel.getCoordinateOrder());
                        }
                        this.jniFiomeths.setOutputFilename(file.getPath(), this.lowerFilePanel.getDatumCode(), this.lowerFilePanel.getParameters());
                        ProgressDlg progressDlg = new ProgressDlg(this, true, this.jniFiomeths);
                        progressDlg.show();
                    }
                }
            } else {
                this.lowerFilePanel.showErrors(this);
                this.dispose();
            }
        }
        catch (Exception exception) {
            this.stringHandler.displayErrorMsg(this, exception.getMessage());
        }
        finally {
            try {
                this.jniFiomeths.closeInputFile();
            }
            catch (Exception exception) {
                this.stringHandler.displayErrorMsg(this, exception.getMessage());
            }
            this.dispose();
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
        try {
            this.jniFiomeths.closeInputFile();
        }
        catch (Exception exception) {
            this.stringHandler.displayErrorMsg(this, exception.getMessage());
        }
    }
}

