
module Main (main) where

import Data.Bits

{-
Do some bitwise operations on some large numbers.
These number are designed so that they are likely to exercise all the
interesting split-up cases for implementations that implement Integer
as some sort of sequence of roughly word-sized values. They are
essentially random apart from that.
-}

px, py, nx, ny :: Integer
px =  0x03A4B5C281F6E9D7029C3FE81D6A4B75
nx = -0x03A4B5C281F6E9D7029C3FE81D6A4B75
py =  0x069AF53C4D1BE728
ny = -0x069AF53C4D1BE728
    --  \.. 64  bits ../\.. 64  bits ../

{-
px        = 0 0000001110100100101101011100001010000001111101101110100111010111 0000001010011100001111111110100000011101011010100100101101110101
py        = 0 0000000000000000000000000000000000000000000000000000000000000000 0000011010011010111101010011110001001101000110111110011100101000
px and py = 0 0000000000000000000000000000000000000000000000000000000000000000 0000001010011000001101010010100000001101000010100100001100100000

px        = 0 0000001110100100101101011100001010000001111101101110100111010111 0000001010011100001111111110100000011101011010100100101101110101
ny        = 1 1111111111111111111111111111111111111111111111111111111111111111 1111100101100101000010101100001110110010111001000001100011011000
px and ny = 0 0000001110100100101101011100001010000001111101101110100111010111 0000000000000100000010101100000000010000011000000000100001010000

nx        = 1 1111110001011011010010100011110101111110000010010001011000101000 1111110101100011110000000001011111100010100101011011010010001011
py        = 0 0000000000000000000000000000000000000000000000000000000000000000 0000011010011010111101010011110001001101000110111110011100101000
nx and py = 0 0000000000000000000000000000000000000000000000000000000000000000 0000010000000010110000000001010001000000000100011010010000001000

nx        = 1 1111110001011011010010100011110101111110000010010001011000101000 1111110101100011110000000001011111100010100101011011010010001011
ny        = 1 1111111111111111111111111111111111111111111111111111111111111111 1111100101100101000010101100001110110010111001000001100011011000
nx and ny = 1 1111110001011011010010100011110101111110000010010001011000101000 1111100101100001000000000000001110100010100001000001000010001000
      = neg 0 0000001110100100101101011100001010000001111101101110100111010111 0000011010011110111111111111110001011101011110111110111101111000

px        = 0 0000001110100100101101011100001010000001111101101110100111010111 0000001010011100001111111110100000011101011010100100101101110101
py        = 0 0000000000000000000000000000000000000000000000000000000000000000 0000011010011010111101010011110001001101000110111110011100101000
px or  py = 0 0000001110100100101101011100001010000001111101101110100111010111 0000011010011110111111111111110001011101011110111110111101111101

px        = 0 0000001110100100101101011100001010000001111101101110100111010111 0000001010011100001111111110100000011101011010100100101101110101
ny        = 1 1111111111111111111111111111111111111111111111111111111111111111 1111100101100101000010101100001110110010111001000001100011011000
px or  ny = 1 1111111111111111111111111111111111111111111111111111111111111111 1111101111111101001111111110101110111111111011100101101111111101
      = neg 0 0000000000000000000000000000000000000000000000000000000000000000 0000010000000010110000000001010001000000000100011010010000000011

nx        = 1 1111110001011011010010100011110101111110000010010001011000101000 1111110101100011110000000001011111100010100101011011010010001011
py        = 0 0000000000000000000000000000000000000000000000000000000000000000 0000011010011010111101010011110001001101000110111110011100101000
nx or  py = 1 1111110001011011010010100011110101111110000010010001011000101000 1111111111111011111101010011111111101111100111111111011110101011
      = neg 0 0000001110100100101101011100001010000001111101101110100111010111 0000000000000100000010101100000000010000011000000000100001010101

nx        = 1 1111110001011011010010100011110101111110000010010001011000101000 1111110101100011110000000001011111100010100101011011010010001011
ny        = 1 1111111111111111111111111111111111111111111111111111111111111111 1111100101100101000010101100001110110010111001000001100011011000
nx or  ny = 1 1111111111111111111111111111111111111111111111111111111111111111 1111110101100111110010101101011111110010111101011011110011011011
      = neg 0 0000000000000000000000000000000000000000000000000000000000000000 0000001010011000001101010010100000001101000010100100001100100101

px        = 0 0000001110100100101101011100001010000001111101101110100111010111 0000001010011100001111111110100000011101011010100100101101110101
py        = 0 0000000000000000000000000000000000000000000000000000000000000000 0000011010011010111101010011110001001101000110111110011100101000
px xor py = 0 0000001110100100101101011100001010000001111101101110100111010111 0000010000000110110010101101010001010000011100011010110001011101

px        = 0 0000001110100100101101011100001010000001111101101110100111010111 0000001010011100001111111110100000011101011010100100101101110101
ny        = 1 1111111111111111111111111111111111111111111111111111111111111111 1111100101100101000010101100001110110010111001000001100011011000
px xor ny = 1 1111110001011011010010100011110101111110000010010001011000101000 1111101111111001001101010010101110101111100011100101001110101101
      = neg 0 0000001110100100101101011100001010000001111101101110100111010111 0000010000000110110010101101010001010000011100011010110001010011

nx        = 1 1111110001011011010010100011110101111110000010010001011000101000 1111110101100011110000000001011111100010100101011011010010001011
py        = 0 0000000000000000000000000000000000000000000000000000000000000000 0000011010011010111101010011110001001101000110111110011100101000
nx xor py = 1 1111110001011011010010100011110101111110000010010001011000101000 1111101111111001001101010010101110101111100011100101001110100011
      = neg 0 0000001110100100101101011100001010000001111101101110100111010111 0000010000000110110010101101010001010000011100011010110001011101

nx        = 1 1111110001011011010010100011110101111110000010010001011000101000 1111110101100011110000000001011111100010100101011011010010001011
ny        = 1 1111111111111111111111111111111111111111111111111111111111111111 1111100101100101000010101100001110110010111001000001100011011000
nx xor ny = 0 0000001110100100101101011100001010000001111101101110100111010111 0000010000000110110010101101010001010000011100011010110001010011

-}

px_and_py :: Integer
px_and_py = 0x29835280D0A4320

px_and_ny :: Integer
px_and_ny = 0x3A4B5C281F6E9D700040AC010600850

nx_and_py :: Integer
nx_and_py = 0x402C0144011A408

nx_and_ny :: Integer
nx_and_ny = -0x3A4B5C281F6E9D7069EFFFC5D7BEF78

px_or_py :: Integer
px_or_py = 0x3A4B5C281F6E9D7069EFFFC5D7BEF7D

px_or_ny :: Integer
px_or_ny = -0x402C0144011A403

nx_or_py :: Integer
nx_or_py = -0x3A4B5C281F6E9D700040AC010600855

nx_or_ny :: Integer
nx_or_ny = -0x29835280D0A4325

px_xor_py :: Integer
px_xor_py = 0x3A4B5C281F6E9D70406CAD45071AC5D

px_xor_ny :: Integer
px_xor_ny = -0x3A4B5C281F6E9D70406CAD45071AC53

nx_xor_py :: Integer
nx_xor_py = -0x3A4B5C281F6E9D70406CAD45071AC5D

nx_xor_ny :: Integer
nx_xor_ny = 0x3A4B5C281F6E9D70406CAD45071AC53

main :: IO ()
main = do putStrLn "Start"
          test "px and py" px_and_py (px .&. py)
          test "px and ny" px_and_ny (px .&. ny)
          test "nx and py" nx_and_py (nx .&. py)
          test "nx and ny" nx_and_ny (nx .&. ny)
          test "px or py" px_or_py (px .|. py)
          test "px or ny" px_or_ny (px .|. ny)
          test "nx or py" nx_or_py (nx .|. py)
          test "nx or ny" nx_or_ny (nx .|. ny)
          test "px xor py" px_xor_py (px `xor` py)
          test "px xor ny" px_xor_ny (px `xor` ny)
          test "nx xor py" nx_xor_py (nx `xor` py)
          test "nx xor ny" nx_xor_ny (nx `xor` ny)
          putStrLn "End"

test :: String -> Integer -> Integer -> IO ()
test what want got
 | want == got = return ()
 | otherwise   = print (what, want, got)

