
"Color."

import OpenGL.GL as gl

import glitch

class Color(glitch.Node):
    "Change the OpenGL color."

    def __init__(self, r=0, g=0, b=0, a=1, **kwargs):
        glitch.Node.__init__(self, **kwargs)
        self.r = r
        self.g = g
        self.b = b
        self.a = a

    def render(self, ctx):
        gl.glPushAttrib(gl.GL_CURRENT_BIT)
        glitch.Node.render(self, ctx)
        gl.glPopAttrib()

    def draw(self, ctx):
        if ctx.get('debug'):
            gl.glColor(0, 1, 0, 1)
        else:
            gl.glColor(self.r, self.g, self.b, self.a)
