drop database if exists lrctest;
create database lrctest;

use lrctest;

create table t_lfn (
  id int not null auto_increment,
  name varchar(250) not null,
  ref int not null default 0,

  primary key (id),
  unique(name)
) type = innodb;
create index t_lfn_name on t_lfn(name);

create table t_pfn (
  id int not null auto_increment,
  name varchar(250) not null,
  ref int not null default 0,

  primary key (id),
  unique(name)
) type = innodb;
create index t_pfn_name on t_pfn(name);

create table t_map (
  lfn_id int not null references t_lfn(id),
  pfn_id int not null references t_pfn(id),

  primary key(lfn_id, pfn_id)
) type = innodb;
create index t_map_pfn_id on t_map(pfn_id);

create table t_rli (
  id int not null auto_increment,
  flags int not null default 0,
  name varchar(250) not null,

  primary key(id),
  unique(name)
) type = innodb;
create index t_rli_name on t_rli(name);

create table t_rlipartition (
  rli_id int not null references t_rli(id),
  pattern varchar(250) not null,

  primary key(rli_id, pattern)
) type = innodb;
create index t_rlipartition_pattern on t_rlipartition(pattern);

create table t_attribute (
  id int not null auto_increment,
  name varchar(250) not null,
  objtype int not null,
  type int not null,

  primary key(id),
  unique(name, objtype)
) type = innodb;
create index t_attribute_name_objtype on t_attribute(name, objtype);

create table t_date_attr (
  obj_id int not null,
  attr_id int not null references t_attribute(id),
  value timestamp not null,

  unique(obj_id, attr_id)
) type = innodb;
create index t_date_attr_attr_id on t_date_attr(attr_id);
create index t_date_attr_value on t_date_attr(value);
create index t_date_obj_id_attr_id on t_date_attr(obj_id, attr_id);

create table t_flt_attr (
  obj_id int not null,
  attr_id int not null references t_attribute(id),
  value float not null,

  unique(obj_id, attr_id)
) type = innodb;
create index t_flt_attr_attr_id on t_flt_attr(attr_id);
create index t_flt_attr_value on t_flt_attr(value);
create index t_flt_obj_id_attr_id on t_flt_attr(obj_id, attr_id);

create table t_int_attr (
  obj_id int not null,
  attr_id int not null references t_attribute(id),
  value int not null,

  unique(obj_id, attr_id)
) type = innodb;
create index t_int_attr_attr_id on t_int_attr(attr_id);
create index t_int_attr_value on t_int_attr(value);
create index t_int_obj_id_attr_id on t_int_attr(obj_id, attr_id);

create table t_str_attr (
  obj_id int not null,
  attr_id int not null references t_attribute(id),
  value varchar(250) not null,

  unique(obj_id, attr_id)
) type = innodb;
create index t_str_attr_attr_id on t_str_attr(attr_id);
create index t_str_attr_value on t_str_attr(value);
create index t_str_obj_id_attr_id on t_str_attr(obj_id, attr_id);

drop database if exists rlitest;

create database rlitest;

use rlitest;

create table t_lfn (
  id int not null auto_increment,
  name varchar(250) not null,
  ref int not null default 0,

  primary key (id),
  unique(name)
) type = innodb;
create index t_lfn_name on t_lfn(name);

create table t_lrc (
  id int not null auto_increment,
  name varchar(250) not null,
  ref int not null default 0,

  primary key (id),
  unique(name)
) type = innodb;
create index t_lrc_name on t_lrc(name);

create table t_sender (
  id int not null auto_increment,
  name varchar(250) not null,
  ref int not null default 0,

  primary key (id),
  unique(name)
) type = innodb;
create index t_sender_name on t_sender(name);

create table t_map (
  lfn_id int not null references t_lfn(id),
  lrc_id int not null references t_lrc(id),
  sender_id int not null references t_sender(id),
  updatetime timestamp,

  primary key(lfn_id, lrc_id, sender_id)
) type = innodb;
create index t_map_lrc_id on t_map(lrc_id);
create index t_map_sender_id on t_map(sender_id);
create index t_map_updatetime on t_map(updatetime);

create table t_rli (
  id int not null auto_increment,
  flags int not null default 0,
  name varchar(250) not null,

  primary key(id),
  unique(name)
) type = innodb;
create index t_rli_name on t_rli(name);

create table t_rlipartition (
  rli_id int not null references t_rli(id),
  pattern varchar(250) not null,

  primary key(rli_id, pattern)
) type = innodb;
create index t_rlipartition_pattern on t_rlipartition(pattern);
