-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/dbi/adbc/gnu-db-adbc-sql_helper.ads,v $
--  Description     : ADBC SQL Helper package                                --
--  Author          : <a>Michael Erdmann</a>                                 --
--  Created         : 18.1.2002                                              --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: <d>$Date: 2002/03/22 20:57:28 $
--  Version         : $Revision: 1.3 $
--  Status          : $State: Exp $</d>
--                                                                           --
--  Copyright (C) 2001 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  This software is implemented to work with GNAT, the GNU Ada compiler.    --
--  <p>                                                                      --
--  Functional Description                                                   --
--  ======================                                                   --
--  This apckage contains a set of helper funtions which are translating     --
--  procedure calls, functions etc into the SQL 92 representation which      --
--  can be processed by the ADBC API.                                        --
--  </p>                                                                     --
--                                                                           --
--                                                                           --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  Only Linux                                                               --
--                                                                           --
--  Contact                                                                  --
--  =======                                                                  --
--  Error reports shall be handled via http://gnade.sourceforge.net          --
--  Features and ideas via: gnade-develop@lists.sourceforge.net              --
--                                                                           --
--  Author contact:                                                          --
--               purl:/net/michael.erdmann                                   --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Strings.Unbounded;                   use Ada.Strings.Unbounded;
with GNU.DB.Support.List;                     use GNU.DB.Support.List;
use  GNU.DB.Support;

package GNU.DB.ADBC.SQL_Helper is

   subtype Table_Name  is List_Element_Access;
   subtype Domain_Name is List_Element_Access;

   function SQL_Select(
      Table     : in List_Element_Access;
      Fields    : in String := "*";
      Condition : in String := "" ) return String;

   function To_Table_Name(
      Name  : in String ) return List_Element_Access;

   function To_Domain_Name(
      Name  : in String ) return List_Element_Access;

end GNU.DB.ADBC.SQL_Helper;

