------------------------------------------------------------------------------
--                                  G P S                                   --
--                                                                          --
--                     Copyright (C) 2007-2016, AdaCore                     --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General  Public  License  distributed  with  this  software;   see  file --
-- COPYING3.  If not, go to http://www.gnu.org/licenses for a complete copy --
-- of the license.                                                          --
------------------------------------------------------------------------------

--  This package implements a simple reStructured text backend of Docgen.
--  For details on the reStructured Text Markup language read:
--    http://docutils.sourceforge.net/docs/user/rst/quickref.html
--    http://docutils.sourceforge.net/docs/ref/rst/restructuredtext.html
--  For details on sphynx read:
--    http://sphinx-doc.org

with GNATdoc.Atree; use GNATdoc.Atree;
with GNATdoc.Backend.Base;

private package GNATdoc.Backend.Simple is

   type Simple_Backend is new GNATdoc.Backend.Base.Base_Backend with private;

   overriding procedure Initialize
     (Backend : in out Simple_Backend;
      Context : access constant Docgen_Context);
   --  Initialize the backend and create the destination directory with support
   --  files. Returns the backend structure used to collect information of all
   --  the processed files (used to generate the global indexes).

   overriding procedure Generate_Lang_Documentation
     (Backend     : in out Simple_Backend;
      Tree        : access Tree_Type;
      Entity      : Entity_Id;
      Entities    : Base.Collected_Entities;
      Scope_Level : Natural);
   --  Generate the documentation of a single <lang> file

   overriding procedure Finalize
     (Backend : in out Simple_Backend;
      Update_Global_Index : Boolean);
   --  If Update_Global_Index is true then update the global indexes.

private

   type Simple_Backend is new GNATdoc.Backend.Base.Base_Backend with record
      Extra_Files : Files_List.Vector;
      --  Additional files generated by the backend for nested packages
   end record;

   overriding function Name (Self : Simple_Backend) return String;
   --  Returns name of backend.

end GNATdoc.Backend.Simple;
