#! /bin/sh
# Primitive program to diff PRs.
# Copyright (C) 200 Free Software Foundation, Inc.
# Contributed by Bob Manson (manson@juniper.net).
#
# This file is part of GNU GNATS.
#
# GNU GNATS is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# GNU GNATS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU GNATS; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

# Diff the PRs in files $1 and $2, returning a list of the changed
# fields.  No output is produced if the PRs are identical.

xAWKx '
BEGIN {
  state = 0;
}

(state == 0) {
  fn = FILENAME;
}

((state == 0 || state == 2) && /^>.*:/) {
  state++;
}


(fn != FILENAME) {
  fn = FILENAME;
  state++;
  arrayindex="";
}

((state == 1 || state == 3) && /^>.*:/) {
  line=$0;
  fieldname=$1;
  sub("^>", "", fieldname);
  sub(":.*$", "", fieldname);
  sub("^[^:]*:[ \t]*", "", line);
  arrayindex=state">"fieldname;
  array[arrayindex] = line;
  fields[fieldname]++;
  next;
}

((state == 1 || state == 3) && arrayindex != "") {
  array[arrayindex] = array[arrayindex] "" $0;
  next;
}

END {
  for (x in fields) {
    if (array["1>"x] != array["3>"x]) {
      print x;
    }
  }
}
' $1 $2
